#include "telegram_api.h"

#include "td/tl/tl_object_parse.h"
#include "td/tl/tl_object_store.h"

#include "td/utils/common.h"
#include "td/utils/format.h"
#include "td/utils/logging.h"
#include "td/utils/SliceBuilder.h"
#include "td/utils/tl_parsers.h"
#include "td/utils/tl_storers.h"
#include "td/utils/TlStorerToString.h"

namespace td {
namespace telegram_api {

std::string to_string(const BaseObject &value) {
  TlStorerToString storer;
  value.store(storer, "");
  return storer.move_as_string();
}

object_ptr<Object> Object::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case accessPointRule::ID:
      return accessPointRule::fetch(p);
    case accountDaysTTL::ID:
      return accountDaysTTL::fetch(p);
    case attachMenuBot::ID:
      return attachMenuBot::fetch(p);
    case attachMenuBotIcon::ID:
      return attachMenuBotIcon::fetch(p);
    case attachMenuBotIconColor::ID:
      return attachMenuBotIconColor::fetch(p);
    case attachMenuBotsNotModified::ID:
      return attachMenuBotsNotModified::fetch(p);
    case attachMenuBots::ID:
      return attachMenuBots::fetch(p);
    case attachMenuBotsBot::ID:
      return attachMenuBotsBot::fetch(p);
    case attachMenuPeerTypeSameBotPM::ID:
      return attachMenuPeerTypeSameBotPM::fetch(p);
    case attachMenuPeerTypeBotPM::ID:
      return attachMenuPeerTypeBotPM::fetch(p);
    case attachMenuPeerTypePM::ID:
      return attachMenuPeerTypePM::fetch(p);
    case attachMenuPeerTypeChat::ID:
      return attachMenuPeerTypeChat::fetch(p);
    case attachMenuPeerTypeBroadcast::ID:
      return attachMenuPeerTypeBroadcast::fetch(p);
    case authorization::ID:
      return authorization::fetch(p);
    case autoDownloadSettings::ID:
      return autoDownloadSettings::fetch(p);
    case autoSaveException::ID:
      return autoSaveException::fetch(p);
    case autoSaveSettings::ID:
      return autoSaveSettings::fetch(p);
    case availableEffect::ID:
      return availableEffect::fetch(p);
    case availableReaction::ID:
      return availableReaction::fetch(p);
    case bankCardOpenUrl::ID:
      return bankCardOpenUrl::fetch(p);
    case baseThemeClassic::ID:
      return baseThemeClassic::fetch(p);
    case baseThemeDay::ID:
      return baseThemeDay::fetch(p);
    case baseThemeNight::ID:
      return baseThemeNight::fetch(p);
    case baseThemeTinted::ID:
      return baseThemeTinted::fetch(p);
    case baseThemeArctic::ID:
      return baseThemeArctic::fetch(p);
    case birthday::ID:
      return birthday::fetch(p);
    case boost::ID:
      return boost::fetch(p);
    case botAppNotModified::ID:
      return botAppNotModified::fetch(p);
    case botApp::ID:
      return botApp::fetch(p);
    case botAppSettings::ID:
      return botAppSettings::fetch(p);
    case botBusinessConnection::ID:
      return botBusinessConnection::fetch(p);
    case botCommand::ID:
      return botCommand::fetch(p);
    case botInfo::ID:
      return botInfo::fetch(p);
    case botInlineMessageMediaAuto::ID:
      return botInlineMessageMediaAuto::fetch(p);
    case botInlineMessageText::ID:
      return botInlineMessageText::fetch(p);
    case botInlineMessageMediaGeo::ID:
      return botInlineMessageMediaGeo::fetch(p);
    case botInlineMessageMediaVenue::ID:
      return botInlineMessageMediaVenue::fetch(p);
    case botInlineMessageMediaContact::ID:
      return botInlineMessageMediaContact::fetch(p);
    case botInlineMessageMediaInvoice::ID:
      return botInlineMessageMediaInvoice::fetch(p);
    case botInlineMessageMediaWebPage::ID:
      return botInlineMessageMediaWebPage::fetch(p);
    case botInlineResult::ID:
      return botInlineResult::fetch(p);
    case botInlineMediaResult::ID:
      return botInlineMediaResult::fetch(p);
    case botMenuButtonDefault::ID:
      return botMenuButtonDefault::fetch(p);
    case botMenuButtonCommands::ID:
      return botMenuButtonCommands::fetch(p);
    case botMenuButton::ID:
      return botMenuButton::fetch(p);
    case botPreviewMedia::ID:
      return botPreviewMedia::fetch(p);
    case botVerification::ID:
      return botVerification::fetch(p);
    case botVerifierSettings::ID:
      return botVerifierSettings::fetch(p);
    case businessAwayMessage::ID:
      return businessAwayMessage::fetch(p);
    case businessAwayMessageScheduleAlways::ID:
      return businessAwayMessageScheduleAlways::fetch(p);
    case businessAwayMessageScheduleOutsideWorkHours::ID:
      return businessAwayMessageScheduleOutsideWorkHours::fetch(p);
    case businessAwayMessageScheduleCustom::ID:
      return businessAwayMessageScheduleCustom::fetch(p);
    case businessBotRecipients::ID:
      return businessBotRecipients::fetch(p);
    case businessBotRights::ID:
      return businessBotRights::fetch(p);
    case businessChatLink::ID:
      return businessChatLink::fetch(p);
    case businessGreetingMessage::ID:
      return businessGreetingMessage::fetch(p);
    case businessIntro::ID:
      return businessIntro::fetch(p);
    case businessLocation::ID:
      return businessLocation::fetch(p);
    case businessRecipients::ID:
      return businessRecipients::fetch(p);
    case businessWeeklyOpen::ID:
      return businessWeeklyOpen::fetch(p);
    case businessWorkHours::ID:
      return businessWorkHours::fetch(p);
    case cdnConfig::ID:
      return cdnConfig::fetch(p);
    case cdnPublicKey::ID:
      return cdnPublicKey::fetch(p);
    case channelAdminLogEvent::ID:
      return channelAdminLogEvent::fetch(p);
    case channelAdminLogEventActionChangeTitle::ID:
      return channelAdminLogEventActionChangeTitle::fetch(p);
    case channelAdminLogEventActionChangeAbout::ID:
      return channelAdminLogEventActionChangeAbout::fetch(p);
    case channelAdminLogEventActionChangeUsername::ID:
      return channelAdminLogEventActionChangeUsername::fetch(p);
    case channelAdminLogEventActionChangePhoto::ID:
      return channelAdminLogEventActionChangePhoto::fetch(p);
    case channelAdminLogEventActionToggleInvites::ID:
      return channelAdminLogEventActionToggleInvites::fetch(p);
    case channelAdminLogEventActionToggleSignatures::ID:
      return channelAdminLogEventActionToggleSignatures::fetch(p);
    case channelAdminLogEventActionUpdatePinned::ID:
      return channelAdminLogEventActionUpdatePinned::fetch(p);
    case channelAdminLogEventActionEditMessage::ID:
      return channelAdminLogEventActionEditMessage::fetch(p);
    case channelAdminLogEventActionDeleteMessage::ID:
      return channelAdminLogEventActionDeleteMessage::fetch(p);
    case channelAdminLogEventActionParticipantJoin::ID:
      return channelAdminLogEventActionParticipantJoin::fetch(p);
    case channelAdminLogEventActionParticipantLeave::ID:
      return channelAdminLogEventActionParticipantLeave::fetch(p);
    case channelAdminLogEventActionParticipantInvite::ID:
      return channelAdminLogEventActionParticipantInvite::fetch(p);
    case channelAdminLogEventActionParticipantToggleBan::ID:
      return channelAdminLogEventActionParticipantToggleBan::fetch(p);
    case channelAdminLogEventActionParticipantToggleAdmin::ID:
      return channelAdminLogEventActionParticipantToggleAdmin::fetch(p);
    case channelAdminLogEventActionChangeStickerSet::ID:
      return channelAdminLogEventActionChangeStickerSet::fetch(p);
    case channelAdminLogEventActionTogglePreHistoryHidden::ID:
      return channelAdminLogEventActionTogglePreHistoryHidden::fetch(p);
    case channelAdminLogEventActionDefaultBannedRights::ID:
      return channelAdminLogEventActionDefaultBannedRights::fetch(p);
    case channelAdminLogEventActionStopPoll::ID:
      return channelAdminLogEventActionStopPoll::fetch(p);
    case channelAdminLogEventActionChangeLinkedChat::ID:
      return channelAdminLogEventActionChangeLinkedChat::fetch(p);
    case channelAdminLogEventActionChangeLocation::ID:
      return channelAdminLogEventActionChangeLocation::fetch(p);
    case channelAdminLogEventActionToggleSlowMode::ID:
      return channelAdminLogEventActionToggleSlowMode::fetch(p);
    case channelAdminLogEventActionStartGroupCall::ID:
      return channelAdminLogEventActionStartGroupCall::fetch(p);
    case channelAdminLogEventActionDiscardGroupCall::ID:
      return channelAdminLogEventActionDiscardGroupCall::fetch(p);
    case channelAdminLogEventActionParticipantMute::ID:
      return channelAdminLogEventActionParticipantMute::fetch(p);
    case channelAdminLogEventActionParticipantUnmute::ID:
      return channelAdminLogEventActionParticipantUnmute::fetch(p);
    case channelAdminLogEventActionToggleGroupCallSetting::ID:
      return channelAdminLogEventActionToggleGroupCallSetting::fetch(p);
    case channelAdminLogEventActionParticipantJoinByInvite::ID:
      return channelAdminLogEventActionParticipantJoinByInvite::fetch(p);
    case channelAdminLogEventActionExportedInviteDelete::ID:
      return channelAdminLogEventActionExportedInviteDelete::fetch(p);
    case channelAdminLogEventActionExportedInviteRevoke::ID:
      return channelAdminLogEventActionExportedInviteRevoke::fetch(p);
    case channelAdminLogEventActionExportedInviteEdit::ID:
      return channelAdminLogEventActionExportedInviteEdit::fetch(p);
    case channelAdminLogEventActionParticipantVolume::ID:
      return channelAdminLogEventActionParticipantVolume::fetch(p);
    case channelAdminLogEventActionChangeHistoryTTL::ID:
      return channelAdminLogEventActionChangeHistoryTTL::fetch(p);
    case channelAdminLogEventActionParticipantJoinByRequest::ID:
      return channelAdminLogEventActionParticipantJoinByRequest::fetch(p);
    case channelAdminLogEventActionToggleNoForwards::ID:
      return channelAdminLogEventActionToggleNoForwards::fetch(p);
    case channelAdminLogEventActionSendMessage::ID:
      return channelAdminLogEventActionSendMessage::fetch(p);
    case channelAdminLogEventActionChangeAvailableReactions::ID:
      return channelAdminLogEventActionChangeAvailableReactions::fetch(p);
    case channelAdminLogEventActionChangeUsernames::ID:
      return channelAdminLogEventActionChangeUsernames::fetch(p);
    case channelAdminLogEventActionToggleForum::ID:
      return channelAdminLogEventActionToggleForum::fetch(p);
    case channelAdminLogEventActionCreateTopic::ID:
      return channelAdminLogEventActionCreateTopic::fetch(p);
    case channelAdminLogEventActionEditTopic::ID:
      return channelAdminLogEventActionEditTopic::fetch(p);
    case channelAdminLogEventActionDeleteTopic::ID:
      return channelAdminLogEventActionDeleteTopic::fetch(p);
    case channelAdminLogEventActionPinTopic::ID:
      return channelAdminLogEventActionPinTopic::fetch(p);
    case channelAdminLogEventActionToggleAntiSpam::ID:
      return channelAdminLogEventActionToggleAntiSpam::fetch(p);
    case channelAdminLogEventActionChangePeerColor::ID:
      return channelAdminLogEventActionChangePeerColor::fetch(p);
    case channelAdminLogEventActionChangeProfilePeerColor::ID:
      return channelAdminLogEventActionChangeProfilePeerColor::fetch(p);
    case channelAdminLogEventActionChangeWallpaper::ID:
      return channelAdminLogEventActionChangeWallpaper::fetch(p);
    case channelAdminLogEventActionChangeEmojiStatus::ID:
      return channelAdminLogEventActionChangeEmojiStatus::fetch(p);
    case channelAdminLogEventActionChangeEmojiStickerSet::ID:
      return channelAdminLogEventActionChangeEmojiStickerSet::fetch(p);
    case channelAdminLogEventActionToggleSignatureProfiles::ID:
      return channelAdminLogEventActionToggleSignatureProfiles::fetch(p);
    case channelAdminLogEventActionParticipantSubExtend::ID:
      return channelAdminLogEventActionParticipantSubExtend::fetch(p);
    case channelAdminLogEventActionToggleAutotranslation::ID:
      return channelAdminLogEventActionToggleAutotranslation::fetch(p);
    case channelLocationEmpty::ID:
      return channelLocationEmpty::fetch(p);
    case channelLocation::ID:
      return channelLocation::fetch(p);
    case channelParticipant::ID:
      return channelParticipant::fetch(p);
    case channelParticipantSelf::ID:
      return channelParticipantSelf::fetch(p);
    case channelParticipantCreator::ID:
      return channelParticipantCreator::fetch(p);
    case channelParticipantAdmin::ID:
      return channelParticipantAdmin::fetch(p);
    case channelParticipantBanned::ID:
      return channelParticipantBanned::fetch(p);
    case channelParticipantLeft::ID:
      return channelParticipantLeft::fetch(p);
    case chatEmpty::ID:
      return chatEmpty::fetch(p);
    case chat::ID:
      return chat::fetch(p);
    case chatForbidden::ID:
      return chatForbidden::fetch(p);
    case channel::ID:
      return channel::fetch(p);
    case channelForbidden::ID:
      return channelForbidden::fetch(p);
    case chatAdminRights::ID:
      return chatAdminRights::fetch(p);
    case chatAdminWithInvites::ID:
      return chatAdminWithInvites::fetch(p);
    case chatBannedRights::ID:
      return chatBannedRights::fetch(p);
    case chatFull::ID:
      return chatFull::fetch(p);
    case channelFull::ID:
      return channelFull::fetch(p);
    case chatInviteAlready::ID:
      return chatInviteAlready::fetch(p);
    case chatInvite::ID:
      return chatInvite::fetch(p);
    case chatInvitePeek::ID:
      return chatInvitePeek::fetch(p);
    case chatInviteImporter::ID:
      return chatInviteImporter::fetch(p);
    case chatOnlines::ID:
      return chatOnlines::fetch(p);
    case chatParticipant::ID:
      return chatParticipant::fetch(p);
    case chatParticipantCreator::ID:
      return chatParticipantCreator::fetch(p);
    case chatParticipantAdmin::ID:
      return chatParticipantAdmin::fetch(p);
    case chatParticipantsForbidden::ID:
      return chatParticipantsForbidden::fetch(p);
    case chatParticipants::ID:
      return chatParticipants::fetch(p);
    case chatPhotoEmpty::ID:
      return chatPhotoEmpty::fetch(p);
    case chatPhoto::ID:
      return chatPhoto::fetch(p);
    case chatReactionsNone::ID:
      return chatReactionsNone::fetch(p);
    case chatReactionsAll::ID:
      return chatReactionsAll::fetch(p);
    case chatReactionsSome::ID:
      return chatReactionsSome::fetch(p);
    case config::ID:
      return config::fetch(p);
    case connectedBot::ID:
      return connectedBot::fetch(p);
    case connectedBotStarRef::ID:
      return connectedBotStarRef::fetch(p);
    case contact::ID:
      return contact::fetch(p);
    case contactBirthday::ID:
      return contactBirthday::fetch(p);
    case contactStatus::ID:
      return contactStatus::fetch(p);
    case dataJSON::ID:
      return dataJSON::fetch(p);
    case dcOption::ID:
      return dcOption::fetch(p);
    case defaultHistoryTTL::ID:
      return defaultHistoryTTL::fetch(p);
    case dialog::ID:
      return dialog::fetch(p);
    case dialogFolder::ID:
      return dialogFolder::fetch(p);
    case dialogFilter::ID:
      return dialogFilter::fetch(p);
    case dialogFilterDefault::ID:
      return dialogFilterDefault::fetch(p);
    case dialogFilterChatlist::ID:
      return dialogFilterChatlist::fetch(p);
    case dialogFilterSuggested::ID:
      return dialogFilterSuggested::fetch(p);
    case dialogPeer::ID:
      return dialogPeer::fetch(p);
    case dialogPeerFolder::ID:
      return dialogPeerFolder::fetch(p);
    case disallowedGiftsSettings::ID:
      return disallowedGiftsSettings::fetch(p);
    case documentEmpty::ID:
      return documentEmpty::fetch(p);
    case document::ID:
      return document::fetch(p);
    case documentAttributeImageSize::ID:
      return documentAttributeImageSize::fetch(p);
    case documentAttributeAnimated::ID:
      return documentAttributeAnimated::fetch(p);
    case documentAttributeSticker::ID:
      return documentAttributeSticker::fetch(p);
    case documentAttributeVideo::ID:
      return documentAttributeVideo::fetch(p);
    case documentAttributeAudio::ID:
      return documentAttributeAudio::fetch(p);
    case documentAttributeFilename::ID:
      return documentAttributeFilename::fetch(p);
    case documentAttributeHasStickers::ID:
      return documentAttributeHasStickers::fetch(p);
    case documentAttributeCustomEmoji::ID:
      return documentAttributeCustomEmoji::fetch(p);
    case draftMessageEmpty::ID:
      return draftMessageEmpty::fetch(p);
    case draftMessage::ID:
      return draftMessage::fetch(p);
    case emojiGroup::ID:
      return emojiGroup::fetch(p);
    case emojiGroupGreeting::ID:
      return emojiGroupGreeting::fetch(p);
    case emojiGroupPremium::ID:
      return emojiGroupPremium::fetch(p);
    case emojiKeyword::ID:
      return emojiKeyword::fetch(p);
    case emojiKeywordDeleted::ID:
      return emojiKeywordDeleted::fetch(p);
    case emojiKeywordsDifference::ID:
      return emojiKeywordsDifference::fetch(p);
    case emojiLanguage::ID:
      return emojiLanguage::fetch(p);
    case emojiListNotModified::ID:
      return emojiListNotModified::fetch(p);
    case emojiList::ID:
      return emojiList::fetch(p);
    case emojiStatusEmpty::ID:
      return emojiStatusEmpty::fetch(p);
    case emojiStatus::ID:
      return emojiStatus::fetch(p);
    case emojiStatusCollectible::ID:
      return emojiStatusCollectible::fetch(p);
    case inputEmojiStatusCollectible::ID:
      return inputEmojiStatusCollectible::fetch(p);
    case emojiURL::ID:
      return emojiURL::fetch(p);
    case encryptedChatEmpty::ID:
      return encryptedChatEmpty::fetch(p);
    case encryptedChatWaiting::ID:
      return encryptedChatWaiting::fetch(p);
    case encryptedChatRequested::ID:
      return encryptedChatRequested::fetch(p);
    case encryptedChat::ID:
      return encryptedChat::fetch(p);
    case encryptedChatDiscarded::ID:
      return encryptedChatDiscarded::fetch(p);
    case encryptedFileEmpty::ID:
      return encryptedFileEmpty::fetch(p);
    case encryptedFile::ID:
      return encryptedFile::fetch(p);
    case encryptedMessage::ID:
      return encryptedMessage::fetch(p);
    case encryptedMessageService::ID:
      return encryptedMessageService::fetch(p);
    case error::ID:
      return error::fetch(p);
    case chatInviteExported::ID:
      return chatInviteExported::fetch(p);
    case chatInvitePublicJoinRequests::ID:
      return chatInvitePublicJoinRequests::fetch(p);
    case exportedChatlistInvite::ID:
      return exportedChatlistInvite::fetch(p);
    case exportedContactToken::ID:
      return exportedContactToken::fetch(p);
    case exportedMessageLink::ID:
      return exportedMessageLink::fetch(p);
    case exportedStoryLink::ID:
      return exportedStoryLink::fetch(p);
    case factCheck::ID:
      return factCheck::fetch(p);
    case fileHash::ID:
      return fileHash::fetch(p);
    case folder::ID:
      return folder::fetch(p);
    case folderPeer::ID:
      return folderPeer::fetch(p);
    case forumTopicDeleted::ID:
      return forumTopicDeleted::fetch(p);
    case forumTopic::ID:
      return forumTopic::fetch(p);
    case foundStory::ID:
      return foundStory::fetch(p);
    case game::ID:
      return game::fetch(p);
    case geoPointEmpty::ID:
      return geoPointEmpty::fetch(p);
    case geoPoint::ID:
      return geoPoint::fetch(p);
    case geoPointAddress::ID:
      return geoPointAddress::fetch(p);
    case globalPrivacySettings::ID:
      return globalPrivacySettings::fetch(p);
    case groupCallDiscarded::ID:
      return groupCallDiscarded::fetch(p);
    case groupCall::ID:
      return groupCall::fetch(p);
    case groupCallParticipant::ID:
      return groupCallParticipant::fetch(p);
    case groupCallParticipantVideo::ID:
      return groupCallParticipantVideo::fetch(p);
    case groupCallParticipantVideoSourceGroup::ID:
      return groupCallParticipantVideoSourceGroup::fetch(p);
    case groupCallStreamChannel::ID:
      return groupCallStreamChannel::fetch(p);
    case highScore::ID:
      return highScore::fetch(p);
    case importedContact::ID:
      return importedContact::fetch(p);
    case inlineBotSwitchPM::ID:
      return inlineBotSwitchPM::fetch(p);
    case inlineBotWebView::ID:
      return inlineBotWebView::fetch(p);
    case inlineQueryPeerTypeSameBotPM::ID:
      return inlineQueryPeerTypeSameBotPM::fetch(p);
    case inlineQueryPeerTypePM::ID:
      return inlineQueryPeerTypePM::fetch(p);
    case inlineQueryPeerTypeChat::ID:
      return inlineQueryPeerTypeChat::fetch(p);
    case inlineQueryPeerTypeMegagroup::ID:
      return inlineQueryPeerTypeMegagroup::fetch(p);
    case inlineQueryPeerTypeBroadcast::ID:
      return inlineQueryPeerTypeBroadcast::fetch(p);
    case inlineQueryPeerTypeBotPM::ID:
      return inlineQueryPeerTypeBotPM::fetch(p);
    case inputAppEvent::ID:
      return inputAppEvent::fetch(p);
    case inputBotInlineMessageID::ID:
      return inputBotInlineMessageID::fetch(p);
    case inputBotInlineMessageID64::ID:
      return inputBotInlineMessageID64::fetch(p);
    case inputChannelEmpty::ID:
      return inputChannelEmpty::fetch(p);
    case inputChannel::ID:
      return inputChannel::fetch(p);
    case inputChannelFromMessage::ID:
      return inputChannelFromMessage::fetch(p);
    case inputDocumentEmpty::ID:
      return inputDocumentEmpty::fetch(p);
    case inputDocument::ID:
      return inputDocument::fetch(p);
    case inputFile::ID:
      return inputFile::fetch(p);
    case inputFileBig::ID:
      return inputFileBig::fetch(p);
    case inputFileStoryDocument::ID:
      return inputFileStoryDocument::fetch(p);
    case inputGameID::ID:
      return inputGameID::fetch(p);
    case inputGameShortName::ID:
      return inputGameShortName::fetch(p);
    case inputGeoPointEmpty::ID:
      return inputGeoPointEmpty::fetch(p);
    case inputGeoPoint::ID:
      return inputGeoPoint::fetch(p);
    case inputGroupCall::ID:
      return inputGroupCall::fetch(p);
    case inputGroupCallSlug::ID:
      return inputGroupCallSlug::fetch(p);
    case inputGroupCallInviteMessage::ID:
      return inputGroupCallInviteMessage::fetch(p);
    case inputMediaEmpty::ID:
      return inputMediaEmpty::fetch(p);
    case inputMediaUploadedPhoto::ID:
      return inputMediaUploadedPhoto::fetch(p);
    case inputMediaPhoto::ID:
      return inputMediaPhoto::fetch(p);
    case inputMediaGeoPoint::ID:
      return inputMediaGeoPoint::fetch(p);
    case inputMediaContact::ID:
      return inputMediaContact::fetch(p);
    case inputMediaUploadedDocument::ID:
      return inputMediaUploadedDocument::fetch(p);
    case inputMediaDocument::ID:
      return inputMediaDocument::fetch(p);
    case inputMediaVenue::ID:
      return inputMediaVenue::fetch(p);
    case inputMediaPhotoExternal::ID:
      return inputMediaPhotoExternal::fetch(p);
    case inputMediaDocumentExternal::ID:
      return inputMediaDocumentExternal::fetch(p);
    case inputMediaGame::ID:
      return inputMediaGame::fetch(p);
    case inputMediaInvoice::ID:
      return inputMediaInvoice::fetch(p);
    case inputMediaGeoLive::ID:
      return inputMediaGeoLive::fetch(p);
    case inputMediaPoll::ID:
      return inputMediaPoll::fetch(p);
    case inputMediaDice::ID:
      return inputMediaDice::fetch(p);
    case inputMediaStory::ID:
      return inputMediaStory::fetch(p);
    case inputMediaWebPage::ID:
      return inputMediaWebPage::fetch(p);
    case inputMediaPaidMedia::ID:
      return inputMediaPaidMedia::fetch(p);
    case inputMediaTodo::ID:
      return inputMediaTodo::fetch(p);
    case inputPeerEmpty::ID:
      return inputPeerEmpty::fetch(p);
    case inputPeerSelf::ID:
      return inputPeerSelf::fetch(p);
    case inputPeerChat::ID:
      return inputPeerChat::fetch(p);
    case inputPeerUser::ID:
      return inputPeerUser::fetch(p);
    case inputPeerChannel::ID:
      return inputPeerChannel::fetch(p);
    case inputPeerUserFromMessage::ID:
      return inputPeerUserFromMessage::fetch(p);
    case inputPeerChannelFromMessage::ID:
      return inputPeerChannelFromMessage::fetch(p);
    case inputPhotoEmpty::ID:
      return inputPhotoEmpty::fetch(p);
    case inputPhoto::ID:
      return inputPhoto::fetch(p);
    case inputReplyToMessage::ID:
      return inputReplyToMessage::fetch(p);
    case inputReplyToStory::ID:
      return inputReplyToStory::fetch(p);
    case inputReplyToMonoForum::ID:
      return inputReplyToMonoForum::fetch(p);
    case inputStickerSetEmpty::ID:
      return inputStickerSetEmpty::fetch(p);
    case inputStickerSetID::ID:
      return inputStickerSetID::fetch(p);
    case inputStickerSetShortName::ID:
      return inputStickerSetShortName::fetch(p);
    case inputStickerSetAnimatedEmoji::ID:
      return inputStickerSetAnimatedEmoji::fetch(p);
    case inputStickerSetDice::ID:
      return inputStickerSetDice::fetch(p);
    case inputStickerSetAnimatedEmojiAnimations::ID:
      return inputStickerSetAnimatedEmojiAnimations::fetch(p);
    case inputStickerSetPremiumGifts::ID:
      return inputStickerSetPremiumGifts::fetch(p);
    case inputStickerSetEmojiGenericAnimations::ID:
      return inputStickerSetEmojiGenericAnimations::fetch(p);
    case inputStickerSetEmojiDefaultStatuses::ID:
      return inputStickerSetEmojiDefaultStatuses::fetch(p);
    case inputStickerSetEmojiDefaultTopicIcons::ID:
      return inputStickerSetEmojiDefaultTopicIcons::fetch(p);
    case inputStickerSetEmojiChannelDefaultStatuses::ID:
      return inputStickerSetEmojiChannelDefaultStatuses::fetch(p);
    case inputStickerSetTonGifts::ID:
      return inputStickerSetTonGifts::fetch(p);
    case inputUserEmpty::ID:
      return inputUserEmpty::fetch(p);
    case inputUserSelf::ID:
      return inputUserSelf::fetch(p);
    case inputUser::ID:
      return inputUser::fetch(p);
    case inputUserFromMessage::ID:
      return inputUserFromMessage::fetch(p);
    case inputWebDocument::ID:
      return inputWebDocument::fetch(p);
    case invoice::ID:
      return invoice::fetch(p);
    case ipPort::ID:
      return ipPort::fetch(p);
    case ipPortSecret::ID:
      return ipPortSecret::fetch(p);
    case jsonObjectValue::ID:
      return jsonObjectValue::fetch(p);
    case jsonNull::ID:
      return jsonNull::fetch(p);
    case jsonBool::ID:
      return jsonBool::fetch(p);
    case jsonNumber::ID:
      return jsonNumber::fetch(p);
    case jsonString::ID:
      return jsonString::fetch(p);
    case jsonArray::ID:
      return jsonArray::fetch(p);
    case jsonObject::ID:
      return jsonObject::fetch(p);
    case keyboardButton::ID:
      return keyboardButton::fetch(p);
    case keyboardButtonUrl::ID:
      return keyboardButtonUrl::fetch(p);
    case keyboardButtonCallback::ID:
      return keyboardButtonCallback::fetch(p);
    case keyboardButtonRequestPhone::ID:
      return keyboardButtonRequestPhone::fetch(p);
    case keyboardButtonRequestGeoLocation::ID:
      return keyboardButtonRequestGeoLocation::fetch(p);
    case keyboardButtonSwitchInline::ID:
      return keyboardButtonSwitchInline::fetch(p);
    case keyboardButtonGame::ID:
      return keyboardButtonGame::fetch(p);
    case keyboardButtonBuy::ID:
      return keyboardButtonBuy::fetch(p);
    case keyboardButtonUrlAuth::ID:
      return keyboardButtonUrlAuth::fetch(p);
    case inputKeyboardButtonUrlAuth::ID:
      return inputKeyboardButtonUrlAuth::fetch(p);
    case keyboardButtonRequestPoll::ID:
      return keyboardButtonRequestPoll::fetch(p);
    case inputKeyboardButtonUserProfile::ID:
      return inputKeyboardButtonUserProfile::fetch(p);
    case keyboardButtonUserProfile::ID:
      return keyboardButtonUserProfile::fetch(p);
    case keyboardButtonWebView::ID:
      return keyboardButtonWebView::fetch(p);
    case keyboardButtonSimpleWebView::ID:
      return keyboardButtonSimpleWebView::fetch(p);
    case keyboardButtonRequestPeer::ID:
      return keyboardButtonRequestPeer::fetch(p);
    case inputKeyboardButtonRequestPeer::ID:
      return inputKeyboardButtonRequestPeer::fetch(p);
    case keyboardButtonCopy::ID:
      return keyboardButtonCopy::fetch(p);
    case keyboardButtonRow::ID:
      return keyboardButtonRow::fetch(p);
    case labeledPrice::ID:
      return labeledPrice::fetch(p);
    case langPackDifference::ID:
      return langPackDifference::fetch(p);
    case langPackLanguage::ID:
      return langPackLanguage::fetch(p);
    case langPackString::ID:
      return langPackString::fetch(p);
    case langPackStringPluralized::ID:
      return langPackStringPluralized::fetch(p);
    case langPackStringDeleted::ID:
      return langPackStringDeleted::fetch(p);
    case maskCoords::ID:
      return maskCoords::fetch(p);
    case mediaAreaVenue::ID:
      return mediaAreaVenue::fetch(p);
    case inputMediaAreaVenue::ID:
      return inputMediaAreaVenue::fetch(p);
    case mediaAreaGeoPoint::ID:
      return mediaAreaGeoPoint::fetch(p);
    case mediaAreaSuggestedReaction::ID:
      return mediaAreaSuggestedReaction::fetch(p);
    case mediaAreaChannelPost::ID:
      return mediaAreaChannelPost::fetch(p);
    case inputMediaAreaChannelPost::ID:
      return inputMediaAreaChannelPost::fetch(p);
    case mediaAreaUrl::ID:
      return mediaAreaUrl::fetch(p);
    case mediaAreaWeather::ID:
      return mediaAreaWeather::fetch(p);
    case mediaAreaStarGift::ID:
      return mediaAreaStarGift::fetch(p);
    case mediaAreaCoordinates::ID:
      return mediaAreaCoordinates::fetch(p);
    case messageEmpty::ID:
      return messageEmpty::fetch(p);
    case message::ID:
      return message::fetch(p);
    case messageService::ID:
      return messageService::fetch(p);
    case messageActionEmpty::ID:
      return messageActionEmpty::fetch(p);
    case messageActionChatCreate::ID:
      return messageActionChatCreate::fetch(p);
    case messageActionChatEditTitle::ID:
      return messageActionChatEditTitle::fetch(p);
    case messageActionChatEditPhoto::ID:
      return messageActionChatEditPhoto::fetch(p);
    case messageActionChatDeletePhoto::ID:
      return messageActionChatDeletePhoto::fetch(p);
    case messageActionChatAddUser::ID:
      return messageActionChatAddUser::fetch(p);
    case messageActionChatDeleteUser::ID:
      return messageActionChatDeleteUser::fetch(p);
    case messageActionChatJoinedByLink::ID:
      return messageActionChatJoinedByLink::fetch(p);
    case messageActionChannelCreate::ID:
      return messageActionChannelCreate::fetch(p);
    case messageActionChatMigrateTo::ID:
      return messageActionChatMigrateTo::fetch(p);
    case messageActionChannelMigrateFrom::ID:
      return messageActionChannelMigrateFrom::fetch(p);
    case messageActionPinMessage::ID:
      return messageActionPinMessage::fetch(p);
    case messageActionHistoryClear::ID:
      return messageActionHistoryClear::fetch(p);
    case messageActionGameScore::ID:
      return messageActionGameScore::fetch(p);
    case messageActionPaymentSentMe::ID:
      return messageActionPaymentSentMe::fetch(p);
    case messageActionPaymentSent::ID:
      return messageActionPaymentSent::fetch(p);
    case messageActionPhoneCall::ID:
      return messageActionPhoneCall::fetch(p);
    case messageActionScreenshotTaken::ID:
      return messageActionScreenshotTaken::fetch(p);
    case messageActionCustomAction::ID:
      return messageActionCustomAction::fetch(p);
    case messageActionBotAllowed::ID:
      return messageActionBotAllowed::fetch(p);
    case messageActionSecureValuesSentMe::ID:
      return messageActionSecureValuesSentMe::fetch(p);
    case messageActionSecureValuesSent::ID:
      return messageActionSecureValuesSent::fetch(p);
    case messageActionContactSignUp::ID:
      return messageActionContactSignUp::fetch(p);
    case messageActionGeoProximityReached::ID:
      return messageActionGeoProximityReached::fetch(p);
    case messageActionGroupCall::ID:
      return messageActionGroupCall::fetch(p);
    case messageActionInviteToGroupCall::ID:
      return messageActionInviteToGroupCall::fetch(p);
    case messageActionSetMessagesTTL::ID:
      return messageActionSetMessagesTTL::fetch(p);
    case messageActionGroupCallScheduled::ID:
      return messageActionGroupCallScheduled::fetch(p);
    case messageActionSetChatTheme::ID:
      return messageActionSetChatTheme::fetch(p);
    case messageActionChatJoinedByRequest::ID:
      return messageActionChatJoinedByRequest::fetch(p);
    case messageActionWebViewDataSentMe::ID:
      return messageActionWebViewDataSentMe::fetch(p);
    case messageActionWebViewDataSent::ID:
      return messageActionWebViewDataSent::fetch(p);
    case messageActionGiftPremium::ID:
      return messageActionGiftPremium::fetch(p);
    case messageActionTopicCreate::ID:
      return messageActionTopicCreate::fetch(p);
    case messageActionTopicEdit::ID:
      return messageActionTopicEdit::fetch(p);
    case messageActionSuggestProfilePhoto::ID:
      return messageActionSuggestProfilePhoto::fetch(p);
    case messageActionRequestedPeer::ID:
      return messageActionRequestedPeer::fetch(p);
    case messageActionSetChatWallPaper::ID:
      return messageActionSetChatWallPaper::fetch(p);
    case messageActionGiftCode::ID:
      return messageActionGiftCode::fetch(p);
    case messageActionGiveawayLaunch::ID:
      return messageActionGiveawayLaunch::fetch(p);
    case messageActionGiveawayResults::ID:
      return messageActionGiveawayResults::fetch(p);
    case messageActionBoostApply::ID:
      return messageActionBoostApply::fetch(p);
    case messageActionRequestedPeerSentMe::ID:
      return messageActionRequestedPeerSentMe::fetch(p);
    case messageActionPaymentRefunded::ID:
      return messageActionPaymentRefunded::fetch(p);
    case messageActionGiftStars::ID:
      return messageActionGiftStars::fetch(p);
    case messageActionPrizeStars::ID:
      return messageActionPrizeStars::fetch(p);
    case messageActionStarGift::ID:
      return messageActionStarGift::fetch(p);
    case messageActionStarGiftUnique::ID:
      return messageActionStarGiftUnique::fetch(p);
    case messageActionPaidMessagesRefunded::ID:
      return messageActionPaidMessagesRefunded::fetch(p);
    case messageActionPaidMessagesPrice::ID:
      return messageActionPaidMessagesPrice::fetch(p);
    case messageActionConferenceCall::ID:
      return messageActionConferenceCall::fetch(p);
    case messageActionTodoCompletions::ID:
      return messageActionTodoCompletions::fetch(p);
    case messageActionTodoAppendTasks::ID:
      return messageActionTodoAppendTasks::fetch(p);
    case messageActionSuggestedPostApproval::ID:
      return messageActionSuggestedPostApproval::fetch(p);
    case messageActionSuggestedPostSuccess::ID:
      return messageActionSuggestedPostSuccess::fetch(p);
    case messageActionSuggestedPostRefund::ID:
      return messageActionSuggestedPostRefund::fetch(p);
    case messageActionGiftTon::ID:
      return messageActionGiftTon::fetch(p);
    case messageEntityUnknown::ID:
      return messageEntityUnknown::fetch(p);
    case messageEntityMention::ID:
      return messageEntityMention::fetch(p);
    case messageEntityHashtag::ID:
      return messageEntityHashtag::fetch(p);
    case messageEntityBotCommand::ID:
      return messageEntityBotCommand::fetch(p);
    case messageEntityUrl::ID:
      return messageEntityUrl::fetch(p);
    case messageEntityEmail::ID:
      return messageEntityEmail::fetch(p);
    case messageEntityBold::ID:
      return messageEntityBold::fetch(p);
    case messageEntityItalic::ID:
      return messageEntityItalic::fetch(p);
    case messageEntityCode::ID:
      return messageEntityCode::fetch(p);
    case messageEntityPre::ID:
      return messageEntityPre::fetch(p);
    case messageEntityTextUrl::ID:
      return messageEntityTextUrl::fetch(p);
    case messageEntityMentionName::ID:
      return messageEntityMentionName::fetch(p);
    case inputMessageEntityMentionName::ID:
      return inputMessageEntityMentionName::fetch(p);
    case messageEntityPhone::ID:
      return messageEntityPhone::fetch(p);
    case messageEntityCashtag::ID:
      return messageEntityCashtag::fetch(p);
    case messageEntityUnderline::ID:
      return messageEntityUnderline::fetch(p);
    case messageEntityStrike::ID:
      return messageEntityStrike::fetch(p);
    case messageEntityBankCard::ID:
      return messageEntityBankCard::fetch(p);
    case messageEntitySpoiler::ID:
      return messageEntitySpoiler::fetch(p);
    case messageEntityCustomEmoji::ID:
      return messageEntityCustomEmoji::fetch(p);
    case messageEntityBlockquote::ID:
      return messageEntityBlockquote::fetch(p);
    case messageExtendedMediaPreview::ID:
      return messageExtendedMediaPreview::fetch(p);
    case messageExtendedMedia::ID:
      return messageExtendedMedia::fetch(p);
    case messageFwdHeader::ID:
      return messageFwdHeader::fetch(p);
    case messageMediaEmpty::ID:
      return messageMediaEmpty::fetch(p);
    case messageMediaPhoto::ID:
      return messageMediaPhoto::fetch(p);
    case messageMediaGeo::ID:
      return messageMediaGeo::fetch(p);
    case messageMediaContact::ID:
      return messageMediaContact::fetch(p);
    case messageMediaUnsupported::ID:
      return messageMediaUnsupported::fetch(p);
    case messageMediaDocument::ID:
      return messageMediaDocument::fetch(p);
    case messageMediaWebPage::ID:
      return messageMediaWebPage::fetch(p);
    case messageMediaVenue::ID:
      return messageMediaVenue::fetch(p);
    case messageMediaGame::ID:
      return messageMediaGame::fetch(p);
    case messageMediaInvoice::ID:
      return messageMediaInvoice::fetch(p);
    case messageMediaGeoLive::ID:
      return messageMediaGeoLive::fetch(p);
    case messageMediaPoll::ID:
      return messageMediaPoll::fetch(p);
    case messageMediaDice::ID:
      return messageMediaDice::fetch(p);
    case messageMediaStory::ID:
      return messageMediaStory::fetch(p);
    case messageMediaGiveaway::ID:
      return messageMediaGiveaway::fetch(p);
    case messageMediaGiveawayResults::ID:
      return messageMediaGiveawayResults::fetch(p);
    case messageMediaPaidMedia::ID:
      return messageMediaPaidMedia::fetch(p);
    case messageMediaToDo::ID:
      return messageMediaToDo::fetch(p);
    case messagePeerReaction::ID:
      return messagePeerReaction::fetch(p);
    case messagePeerVote::ID:
      return messagePeerVote::fetch(p);
    case messagePeerVoteInputOption::ID:
      return messagePeerVoteInputOption::fetch(p);
    case messagePeerVoteMultiple::ID:
      return messagePeerVoteMultiple::fetch(p);
    case messageRange::ID:
      return messageRange::fetch(p);
    case messageReactions::ID:
      return messageReactions::fetch(p);
    case messageReactor::ID:
      return messageReactor::fetch(p);
    case messageReplies::ID:
      return messageReplies::fetch(p);
    case messageReplyHeader::ID:
      return messageReplyHeader::fetch(p);
    case messageReplyStoryHeader::ID:
      return messageReplyStoryHeader::fetch(p);
    case messageReportOption::ID:
      return messageReportOption::fetch(p);
    case messageViews::ID:
      return messageViews::fetch(p);
    case inputMessagesFilterEmpty::ID:
      return inputMessagesFilterEmpty::fetch(p);
    case inputMessagesFilterPhotos::ID:
      return inputMessagesFilterPhotos::fetch(p);
    case inputMessagesFilterVideo::ID:
      return inputMessagesFilterVideo::fetch(p);
    case inputMessagesFilterPhotoVideo::ID:
      return inputMessagesFilterPhotoVideo::fetch(p);
    case inputMessagesFilterDocument::ID:
      return inputMessagesFilterDocument::fetch(p);
    case inputMessagesFilterUrl::ID:
      return inputMessagesFilterUrl::fetch(p);
    case inputMessagesFilterGif::ID:
      return inputMessagesFilterGif::fetch(p);
    case inputMessagesFilterVoice::ID:
      return inputMessagesFilterVoice::fetch(p);
    case inputMessagesFilterMusic::ID:
      return inputMessagesFilterMusic::fetch(p);
    case inputMessagesFilterChatPhotos::ID:
      return inputMessagesFilterChatPhotos::fetch(p);
    case inputMessagesFilterPhoneCalls::ID:
      return inputMessagesFilterPhoneCalls::fetch(p);
    case inputMessagesFilterRoundVoice::ID:
      return inputMessagesFilterRoundVoice::fetch(p);
    case inputMessagesFilterRoundVideo::ID:
      return inputMessagesFilterRoundVideo::fetch(p);
    case inputMessagesFilterMyMentions::ID:
      return inputMessagesFilterMyMentions::fetch(p);
    case inputMessagesFilterGeo::ID:
      return inputMessagesFilterGeo::fetch(p);
    case inputMessagesFilterContacts::ID:
      return inputMessagesFilterContacts::fetch(p);
    case inputMessagesFilterPinned::ID:
      return inputMessagesFilterPinned::fetch(p);
    case missingInvitee::ID:
      return missingInvitee::fetch(p);
    case myBoost::ID:
      return myBoost::fetch(p);
    case nearestDc::ID:
      return nearestDc::fetch(p);
    case notificationSoundDefault::ID:
      return notificationSoundDefault::fetch(p);
    case notificationSoundNone::ID:
      return notificationSoundNone::fetch(p);
    case notificationSoundLocal::ID:
      return notificationSoundLocal::fetch(p);
    case notificationSoundRingtone::ID:
      return notificationSoundRingtone::fetch(p);
    case notifyPeer::ID:
      return notifyPeer::fetch(p);
    case notifyUsers::ID:
      return notifyUsers::fetch(p);
    case notifyChats::ID:
      return notifyChats::fetch(p);
    case notifyBroadcasts::ID:
      return notifyBroadcasts::fetch(p);
    case notifyForumTopic::ID:
      return notifyForumTopic::fetch(p);
    case outboxReadDate::ID:
      return outboxReadDate::fetch(p);
    case page::ID:
      return page::fetch(p);
    case pageBlockUnsupported::ID:
      return pageBlockUnsupported::fetch(p);
    case pageBlockTitle::ID:
      return pageBlockTitle::fetch(p);
    case pageBlockSubtitle::ID:
      return pageBlockSubtitle::fetch(p);
    case pageBlockAuthorDate::ID:
      return pageBlockAuthorDate::fetch(p);
    case pageBlockHeader::ID:
      return pageBlockHeader::fetch(p);
    case pageBlockSubheader::ID:
      return pageBlockSubheader::fetch(p);
    case pageBlockParagraph::ID:
      return pageBlockParagraph::fetch(p);
    case pageBlockPreformatted::ID:
      return pageBlockPreformatted::fetch(p);
    case pageBlockFooter::ID:
      return pageBlockFooter::fetch(p);
    case pageBlockDivider::ID:
      return pageBlockDivider::fetch(p);
    case pageBlockAnchor::ID:
      return pageBlockAnchor::fetch(p);
    case pageBlockList::ID:
      return pageBlockList::fetch(p);
    case pageBlockBlockquote::ID:
      return pageBlockBlockquote::fetch(p);
    case pageBlockPullquote::ID:
      return pageBlockPullquote::fetch(p);
    case pageBlockPhoto::ID:
      return pageBlockPhoto::fetch(p);
    case pageBlockVideo::ID:
      return pageBlockVideo::fetch(p);
    case pageBlockCover::ID:
      return pageBlockCover::fetch(p);
    case pageBlockEmbed::ID:
      return pageBlockEmbed::fetch(p);
    case pageBlockEmbedPost::ID:
      return pageBlockEmbedPost::fetch(p);
    case pageBlockCollage::ID:
      return pageBlockCollage::fetch(p);
    case pageBlockSlideshow::ID:
      return pageBlockSlideshow::fetch(p);
    case pageBlockChannel::ID:
      return pageBlockChannel::fetch(p);
    case pageBlockAudio::ID:
      return pageBlockAudio::fetch(p);
    case pageBlockKicker::ID:
      return pageBlockKicker::fetch(p);
    case pageBlockTable::ID:
      return pageBlockTable::fetch(p);
    case pageBlockOrderedList::ID:
      return pageBlockOrderedList::fetch(p);
    case pageBlockDetails::ID:
      return pageBlockDetails::fetch(p);
    case pageBlockRelatedArticles::ID:
      return pageBlockRelatedArticles::fetch(p);
    case pageBlockMap::ID:
      return pageBlockMap::fetch(p);
    case pageCaption::ID:
      return pageCaption::fetch(p);
    case pageListItemText::ID:
      return pageListItemText::fetch(p);
    case pageListItemBlocks::ID:
      return pageListItemBlocks::fetch(p);
    case pageListOrderedItemText::ID:
      return pageListOrderedItemText::fetch(p);
    case pageListOrderedItemBlocks::ID:
      return pageListOrderedItemBlocks::fetch(p);
    case pageRelatedArticle::ID:
      return pageRelatedArticle::fetch(p);
    case pageTableCell::ID:
      return pageTableCell::fetch(p);
    case pageTableRow::ID:
      return pageTableRow::fetch(p);
    case paidReactionPrivacyDefault::ID:
      return paidReactionPrivacyDefault::fetch(p);
    case paidReactionPrivacyAnonymous::ID:
      return paidReactionPrivacyAnonymous::fetch(p);
    case paidReactionPrivacyPeer::ID:
      return paidReactionPrivacyPeer::fetch(p);
    case passwordKdfAlgoUnknown::ID:
      return passwordKdfAlgoUnknown::fetch(p);
    case passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::ID:
      return passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::fetch(p);
    case paymentCharge::ID:
      return paymentCharge::fetch(p);
    case paymentFormMethod::ID:
      return paymentFormMethod::fetch(p);
    case paymentRequestedInfo::ID:
      return paymentRequestedInfo::fetch(p);
    case paymentSavedCredentialsCard::ID:
      return paymentSavedCredentialsCard::fetch(p);
    case peerUser::ID:
      return peerUser::fetch(p);
    case peerChat::ID:
      return peerChat::fetch(p);
    case peerChannel::ID:
      return peerChannel::fetch(p);
    case peerBlocked::ID:
      return peerBlocked::fetch(p);
    case peerColor::ID:
      return peerColor::fetch(p);
    case peerLocated::ID:
      return peerLocated::fetch(p);
    case peerSelfLocated::ID:
      return peerSelfLocated::fetch(p);
    case peerNotifySettings::ID:
      return peerNotifySettings::fetch(p);
    case peerSettings::ID:
      return peerSettings::fetch(p);
    case peerStories::ID:
      return peerStories::fetch(p);
    case pendingSuggestion::ID:
      return pendingSuggestion::fetch(p);
    case phoneCallEmpty::ID:
      return phoneCallEmpty::fetch(p);
    case phoneCallWaiting::ID:
      return phoneCallWaiting::fetch(p);
    case phoneCallRequested::ID:
      return phoneCallRequested::fetch(p);
    case phoneCallAccepted::ID:
      return phoneCallAccepted::fetch(p);
    case phoneCall::ID:
      return phoneCall::fetch(p);
    case phoneCallDiscarded::ID:
      return phoneCallDiscarded::fetch(p);
    case phoneCallDiscardReasonMissed::ID:
      return phoneCallDiscardReasonMissed::fetch(p);
    case phoneCallDiscardReasonDisconnect::ID:
      return phoneCallDiscardReasonDisconnect::fetch(p);
    case phoneCallDiscardReasonHangup::ID:
      return phoneCallDiscardReasonHangup::fetch(p);
    case phoneCallDiscardReasonBusy::ID:
      return phoneCallDiscardReasonBusy::fetch(p);
    case phoneCallDiscardReasonMigrateConferenceCall::ID:
      return phoneCallDiscardReasonMigrateConferenceCall::fetch(p);
    case phoneCallProtocol::ID:
      return phoneCallProtocol::fetch(p);
    case phoneConnection::ID:
      return phoneConnection::fetch(p);
    case phoneConnectionWebrtc::ID:
      return phoneConnectionWebrtc::fetch(p);
    case photoEmpty::ID:
      return photoEmpty::fetch(p);
    case photo::ID:
      return photo::fetch(p);
    case photoSizeEmpty::ID:
      return photoSizeEmpty::fetch(p);
    case photoSize::ID:
      return photoSize::fetch(p);
    case photoCachedSize::ID:
      return photoCachedSize::fetch(p);
    case photoStrippedSize::ID:
      return photoStrippedSize::fetch(p);
    case photoSizeProgressive::ID:
      return photoSizeProgressive::fetch(p);
    case photoPathSize::ID:
      return photoPathSize::fetch(p);
    case poll::ID:
      return poll::fetch(p);
    case pollAnswer::ID:
      return pollAnswer::fetch(p);
    case pollAnswerVoters::ID:
      return pollAnswerVoters::fetch(p);
    case pollResults::ID:
      return pollResults::fetch(p);
    case popularContact::ID:
      return popularContact::fetch(p);
    case postAddress::ID:
      return postAddress::fetch(p);
    case postInteractionCountersMessage::ID:
      return postInteractionCountersMessage::fetch(p);
    case postInteractionCountersStory::ID:
      return postInteractionCountersStory::fetch(p);
    case premiumGiftCodeOption::ID:
      return premiumGiftCodeOption::fetch(p);
    case premiumSubscriptionOption::ID:
      return premiumSubscriptionOption::fetch(p);
    case prepaidGiveaway::ID:
      return prepaidGiveaway::fetch(p);
    case prepaidStarsGiveaway::ID:
      return prepaidStarsGiveaway::fetch(p);
    case privacyKeyStatusTimestamp::ID:
      return privacyKeyStatusTimestamp::fetch(p);
    case privacyKeyChatInvite::ID:
      return privacyKeyChatInvite::fetch(p);
    case privacyKeyPhoneCall::ID:
      return privacyKeyPhoneCall::fetch(p);
    case privacyKeyPhoneP2P::ID:
      return privacyKeyPhoneP2P::fetch(p);
    case privacyKeyForwards::ID:
      return privacyKeyForwards::fetch(p);
    case privacyKeyProfilePhoto::ID:
      return privacyKeyProfilePhoto::fetch(p);
    case privacyKeyPhoneNumber::ID:
      return privacyKeyPhoneNumber::fetch(p);
    case privacyKeyAddedByPhone::ID:
      return privacyKeyAddedByPhone::fetch(p);
    case privacyKeyVoiceMessages::ID:
      return privacyKeyVoiceMessages::fetch(p);
    case privacyKeyAbout::ID:
      return privacyKeyAbout::fetch(p);
    case privacyKeyBirthday::ID:
      return privacyKeyBirthday::fetch(p);
    case privacyKeyStarGiftsAutoSave::ID:
      return privacyKeyStarGiftsAutoSave::fetch(p);
    case privacyKeyNoPaidMessages::ID:
      return privacyKeyNoPaidMessages::fetch(p);
    case privacyValueAllowContacts::ID:
      return privacyValueAllowContacts::fetch(p);
    case privacyValueAllowAll::ID:
      return privacyValueAllowAll::fetch(p);
    case privacyValueAllowUsers::ID:
      return privacyValueAllowUsers::fetch(p);
    case privacyValueDisallowContacts::ID:
      return privacyValueDisallowContacts::fetch(p);
    case privacyValueDisallowAll::ID:
      return privacyValueDisallowAll::fetch(p);
    case privacyValueDisallowUsers::ID:
      return privacyValueDisallowUsers::fetch(p);
    case privacyValueAllowChatParticipants::ID:
      return privacyValueAllowChatParticipants::fetch(p);
    case privacyValueDisallowChatParticipants::ID:
      return privacyValueDisallowChatParticipants::fetch(p);
    case privacyValueAllowCloseFriends::ID:
      return privacyValueAllowCloseFriends::fetch(p);
    case privacyValueAllowPremium::ID:
      return privacyValueAllowPremium::fetch(p);
    case privacyValueAllowBots::ID:
      return privacyValueAllowBots::fetch(p);
    case privacyValueDisallowBots::ID:
      return privacyValueDisallowBots::fetch(p);
    case publicForwardMessage::ID:
      return publicForwardMessage::fetch(p);
    case publicForwardStory::ID:
      return publicForwardStory::fetch(p);
    case quickReply::ID:
      return quickReply::fetch(p);
    case reactionEmpty::ID:
      return reactionEmpty::fetch(p);
    case reactionEmoji::ID:
      return reactionEmoji::fetch(p);
    case reactionCustomEmoji::ID:
      return reactionCustomEmoji::fetch(p);
    case reactionPaid::ID:
      return reactionPaid::fetch(p);
    case reactionCount::ID:
      return reactionCount::fetch(p);
    case reactionNotificationsFromContacts::ID:
      return reactionNotificationsFromContacts::fetch(p);
    case reactionNotificationsFromAll::ID:
      return reactionNotificationsFromAll::fetch(p);
    case reactionsNotifySettings::ID:
      return reactionsNotifySettings::fetch(p);
    case readParticipantDate::ID:
      return readParticipantDate::fetch(p);
    case receivedNotifyMessage::ID:
      return receivedNotifyMessage::fetch(p);
    case recentMeUrlUnknown::ID:
      return recentMeUrlUnknown::fetch(p);
    case recentMeUrlUser::ID:
      return recentMeUrlUser::fetch(p);
    case recentMeUrlChat::ID:
      return recentMeUrlChat::fetch(p);
    case recentMeUrlChatInvite::ID:
      return recentMeUrlChatInvite::fetch(p);
    case recentMeUrlStickerSet::ID:
      return recentMeUrlStickerSet::fetch(p);
    case replyKeyboardHide::ID:
      return replyKeyboardHide::fetch(p);
    case replyKeyboardForceReply::ID:
      return replyKeyboardForceReply::fetch(p);
    case replyKeyboardMarkup::ID:
      return replyKeyboardMarkup::fetch(p);
    case replyInlineMarkup::ID:
      return replyInlineMarkup::fetch(p);
    case reportResultChooseOption::ID:
      return reportResultChooseOption::fetch(p);
    case reportResultAddComment::ID:
      return reportResultAddComment::fetch(p);
    case reportResultReported::ID:
      return reportResultReported::fetch(p);
    case requestPeerTypeUser::ID:
      return requestPeerTypeUser::fetch(p);
    case requestPeerTypeChat::ID:
      return requestPeerTypeChat::fetch(p);
    case requestPeerTypeBroadcast::ID:
      return requestPeerTypeBroadcast::fetch(p);
    case requestedPeerUser::ID:
      return requestedPeerUser::fetch(p);
    case requestedPeerChat::ID:
      return requestedPeerChat::fetch(p);
    case requestedPeerChannel::ID:
      return requestedPeerChannel::fetch(p);
    case requirementToContactEmpty::ID:
      return requirementToContactEmpty::fetch(p);
    case requirementToContactPremium::ID:
      return requirementToContactPremium::fetch(p);
    case requirementToContactPaidMessages::ID:
      return requirementToContactPaidMessages::fetch(p);
    case restrictionReason::ID:
      return restrictionReason::fetch(p);
    case textEmpty::ID:
      return textEmpty::fetch(p);
    case textPlain::ID:
      return textPlain::fetch(p);
    case textBold::ID:
      return textBold::fetch(p);
    case textItalic::ID:
      return textItalic::fetch(p);
    case textUnderline::ID:
      return textUnderline::fetch(p);
    case textStrike::ID:
      return textStrike::fetch(p);
    case textFixed::ID:
      return textFixed::fetch(p);
    case textUrl::ID:
      return textUrl::fetch(p);
    case textEmail::ID:
      return textEmail::fetch(p);
    case textConcat::ID:
      return textConcat::fetch(p);
    case textSubscript::ID:
      return textSubscript::fetch(p);
    case textSuperscript::ID:
      return textSuperscript::fetch(p);
    case textMarked::ID:
      return textMarked::fetch(p);
    case textPhone::ID:
      return textPhone::fetch(p);
    case textImage::ID:
      return textImage::fetch(p);
    case textAnchor::ID:
      return textAnchor::fetch(p);
    case savedPhoneContact::ID:
      return savedPhoneContact::fetch(p);
    case savedDialog::ID:
      return savedDialog::fetch(p);
    case monoForumDialog::ID:
      return monoForumDialog::fetch(p);
    case savedReactionTag::ID:
      return savedReactionTag::fetch(p);
    case savedStarGift::ID:
      return savedStarGift::fetch(p);
    case searchResultsCalendarPeriod::ID:
      return searchResultsCalendarPeriod::fetch(p);
    case searchResultPosition::ID:
      return searchResultPosition::fetch(p);
    case secureCredentialsEncrypted::ID:
      return secureCredentialsEncrypted::fetch(p);
    case secureData::ID:
      return secureData::fetch(p);
    case secureFileEmpty::ID:
      return secureFileEmpty::fetch(p);
    case secureFile::ID:
      return secureFile::fetch(p);
    case securePasswordKdfAlgoUnknown::ID:
      return securePasswordKdfAlgoUnknown::fetch(p);
    case securePasswordKdfAlgoPBKDF2HMACSHA512iter100000::ID:
      return securePasswordKdfAlgoPBKDF2HMACSHA512iter100000::fetch(p);
    case securePasswordKdfAlgoSHA512::ID:
      return securePasswordKdfAlgoSHA512::fetch(p);
    case securePlainPhone::ID:
      return securePlainPhone::fetch(p);
    case securePlainEmail::ID:
      return securePlainEmail::fetch(p);
    case secureRequiredType::ID:
      return secureRequiredType::fetch(p);
    case secureRequiredTypeOneOf::ID:
      return secureRequiredTypeOneOf::fetch(p);
    case secureSecretSettings::ID:
      return secureSecretSettings::fetch(p);
    case secureValue::ID:
      return secureValue::fetch(p);
    case secureValueErrorData::ID:
      return secureValueErrorData::fetch(p);
    case secureValueErrorFrontSide::ID:
      return secureValueErrorFrontSide::fetch(p);
    case secureValueErrorReverseSide::ID:
      return secureValueErrorReverseSide::fetch(p);
    case secureValueErrorSelfie::ID:
      return secureValueErrorSelfie::fetch(p);
    case secureValueErrorFile::ID:
      return secureValueErrorFile::fetch(p);
    case secureValueErrorFiles::ID:
      return secureValueErrorFiles::fetch(p);
    case secureValueError::ID:
      return secureValueError::fetch(p);
    case secureValueErrorTranslationFile::ID:
      return secureValueErrorTranslationFile::fetch(p);
    case secureValueErrorTranslationFiles::ID:
      return secureValueErrorTranslationFiles::fetch(p);
    case secureValueTypePersonalDetails::ID:
      return secureValueTypePersonalDetails::fetch(p);
    case secureValueTypePassport::ID:
      return secureValueTypePassport::fetch(p);
    case secureValueTypeDriverLicense::ID:
      return secureValueTypeDriverLicense::fetch(p);
    case secureValueTypeIdentityCard::ID:
      return secureValueTypeIdentityCard::fetch(p);
    case secureValueTypeInternalPassport::ID:
      return secureValueTypeInternalPassport::fetch(p);
    case secureValueTypeAddress::ID:
      return secureValueTypeAddress::fetch(p);
    case secureValueTypeUtilityBill::ID:
      return secureValueTypeUtilityBill::fetch(p);
    case secureValueTypeBankStatement::ID:
      return secureValueTypeBankStatement::fetch(p);
    case secureValueTypeRentalAgreement::ID:
      return secureValueTypeRentalAgreement::fetch(p);
    case secureValueTypePassportRegistration::ID:
      return secureValueTypePassportRegistration::fetch(p);
    case secureValueTypeTemporaryRegistration::ID:
      return secureValueTypeTemporaryRegistration::fetch(p);
    case secureValueTypePhone::ID:
      return secureValueTypePhone::fetch(p);
    case secureValueTypeEmail::ID:
      return secureValueTypeEmail::fetch(p);
    case sendAsPeer::ID:
      return sendAsPeer::fetch(p);
    case sendMessageTypingAction::ID:
      return sendMessageTypingAction::fetch(p);
    case sendMessageCancelAction::ID:
      return sendMessageCancelAction::fetch(p);
    case sendMessageRecordVideoAction::ID:
      return sendMessageRecordVideoAction::fetch(p);
    case sendMessageUploadVideoAction::ID:
      return sendMessageUploadVideoAction::fetch(p);
    case sendMessageRecordAudioAction::ID:
      return sendMessageRecordAudioAction::fetch(p);
    case sendMessageUploadAudioAction::ID:
      return sendMessageUploadAudioAction::fetch(p);
    case sendMessageUploadPhotoAction::ID:
      return sendMessageUploadPhotoAction::fetch(p);
    case sendMessageUploadDocumentAction::ID:
      return sendMessageUploadDocumentAction::fetch(p);
    case sendMessageGeoLocationAction::ID:
      return sendMessageGeoLocationAction::fetch(p);
    case sendMessageChooseContactAction::ID:
      return sendMessageChooseContactAction::fetch(p);
    case sendMessageGamePlayAction::ID:
      return sendMessageGamePlayAction::fetch(p);
    case sendMessageRecordRoundAction::ID:
      return sendMessageRecordRoundAction::fetch(p);
    case sendMessageUploadRoundAction::ID:
      return sendMessageUploadRoundAction::fetch(p);
    case speakingInGroupCallAction::ID:
      return speakingInGroupCallAction::fetch(p);
    case sendMessageHistoryImportAction::ID:
      return sendMessageHistoryImportAction::fetch(p);
    case sendMessageChooseStickerAction::ID:
      return sendMessageChooseStickerAction::fetch(p);
    case sendMessageEmojiInteraction::ID:
      return sendMessageEmojiInteraction::fetch(p);
    case sendMessageEmojiInteractionSeen::ID:
      return sendMessageEmojiInteractionSeen::fetch(p);
    case shippingOption::ID:
      return shippingOption::fetch(p);
    case smsJob::ID:
      return smsJob::fetch(p);
    case sponsoredMessage::ID:
      return sponsoredMessage::fetch(p);
    case sponsoredMessageReportOption::ID:
      return sponsoredMessageReportOption::fetch(p);
    case sponsoredPeer::ID:
      return sponsoredPeer::fetch(p);
    case starGift::ID:
      return starGift::fetch(p);
    case starGiftUnique::ID:
      return starGiftUnique::fetch(p);
    case starGiftAttributeModel::ID:
      return starGiftAttributeModel::fetch(p);
    case starGiftAttributePattern::ID:
      return starGiftAttributePattern::fetch(p);
    case starGiftAttributeBackdrop::ID:
      return starGiftAttributeBackdrop::fetch(p);
    case starGiftAttributeOriginalDetails::ID:
      return starGiftAttributeOriginalDetails::fetch(p);
    case starGiftAttributeCounter::ID:
      return starGiftAttributeCounter::fetch(p);
    case starGiftAttributeIdModel::ID:
      return starGiftAttributeIdModel::fetch(p);
    case starGiftAttributeIdPattern::ID:
      return starGiftAttributeIdPattern::fetch(p);
    case starGiftAttributeIdBackdrop::ID:
      return starGiftAttributeIdBackdrop::fetch(p);
    case starRefProgram::ID:
      return starRefProgram::fetch(p);
    case starsAmount::ID:
      return starsAmount::fetch(p);
    case starsTonAmount::ID:
      return starsTonAmount::fetch(p);
    case starsGiftOption::ID:
      return starsGiftOption::fetch(p);
    case starsGiveawayOption::ID:
      return starsGiveawayOption::fetch(p);
    case starsGiveawayWinnersOption::ID:
      return starsGiveawayWinnersOption::fetch(p);
    case starsRevenueStatus::ID:
      return starsRevenueStatus::fetch(p);
    case starsSubscription::ID:
      return starsSubscription::fetch(p);
    case starsSubscriptionPricing::ID:
      return starsSubscriptionPricing::fetch(p);
    case starsTopupOption::ID:
      return starsTopupOption::fetch(p);
    case starsTransaction::ID:
      return starsTransaction::fetch(p);
    case starsTransactionPeerUnsupported::ID:
      return starsTransactionPeerUnsupported::fetch(p);
    case starsTransactionPeerAppStore::ID:
      return starsTransactionPeerAppStore::fetch(p);
    case starsTransactionPeerPlayMarket::ID:
      return starsTransactionPeerPlayMarket::fetch(p);
    case starsTransactionPeerPremiumBot::ID:
      return starsTransactionPeerPremiumBot::fetch(p);
    case starsTransactionPeerFragment::ID:
      return starsTransactionPeerFragment::fetch(p);
    case starsTransactionPeer::ID:
      return starsTransactionPeer::fetch(p);
    case starsTransactionPeerAds::ID:
      return starsTransactionPeerAds::fetch(p);
    case starsTransactionPeerAPI::ID:
      return starsTransactionPeerAPI::fetch(p);
    case statsAbsValueAndPrev::ID:
      return statsAbsValueAndPrev::fetch(p);
    case statsDateRangeDays::ID:
      return statsDateRangeDays::fetch(p);
    case statsGraphAsync::ID:
      return statsGraphAsync::fetch(p);
    case statsGraphError::ID:
      return statsGraphError::fetch(p);
    case statsGraph::ID:
      return statsGraph::fetch(p);
    case statsGroupTopAdmin::ID:
      return statsGroupTopAdmin::fetch(p);
    case statsGroupTopInviter::ID:
      return statsGroupTopInviter::fetch(p);
    case statsGroupTopPoster::ID:
      return statsGroupTopPoster::fetch(p);
    case statsPercentValue::ID:
      return statsPercentValue::fetch(p);
    case stickerKeyword::ID:
      return stickerKeyword::fetch(p);
    case stickerPack::ID:
      return stickerPack::fetch(p);
    case stickerSet::ID:
      return stickerSet::fetch(p);
    case stickerSetCovered::ID:
      return stickerSetCovered::fetch(p);
    case stickerSetMultiCovered::ID:
      return stickerSetMultiCovered::fetch(p);
    case stickerSetFullCovered::ID:
      return stickerSetFullCovered::fetch(p);
    case stickerSetNoCovered::ID:
      return stickerSetNoCovered::fetch(p);
    case storiesStealthMode::ID:
      return storiesStealthMode::fetch(p);
    case storyFwdHeader::ID:
      return storyFwdHeader::fetch(p);
    case storyItemDeleted::ID:
      return storyItemDeleted::fetch(p);
    case storyItemSkipped::ID:
      return storyItemSkipped::fetch(p);
    case storyItem::ID:
      return storyItem::fetch(p);
    case storyReaction::ID:
      return storyReaction::fetch(p);
    case storyReactionPublicForward::ID:
      return storyReactionPublicForward::fetch(p);
    case storyReactionPublicRepost::ID:
      return storyReactionPublicRepost::fetch(p);
    case storyView::ID:
      return storyView::fetch(p);
    case storyViewPublicForward::ID:
      return storyViewPublicForward::fetch(p);
    case storyViewPublicRepost::ID:
      return storyViewPublicRepost::fetch(p);
    case storyViews::ID:
      return storyViews::fetch(p);
    case suggestedPost::ID:
      return suggestedPost::fetch(p);
    case textWithEntities::ID:
      return textWithEntities::fetch(p);
    case theme::ID:
      return theme::fetch(p);
    case themeSettings::ID:
      return themeSettings::fetch(p);
    case timezone::ID:
      return timezone::fetch(p);
    case todoCompletion::ID:
      return todoCompletion::fetch(p);
    case todoItem::ID:
      return todoItem::fetch(p);
    case todoList::ID:
      return todoList::fetch(p);
    case topPeer::ID:
      return topPeer::fetch(p);
    case topPeerCategoryBotsPM::ID:
      return topPeerCategoryBotsPM::fetch(p);
    case topPeerCategoryBotsInline::ID:
      return topPeerCategoryBotsInline::fetch(p);
    case topPeerCategoryCorrespondents::ID:
      return topPeerCategoryCorrespondents::fetch(p);
    case topPeerCategoryGroups::ID:
      return topPeerCategoryGroups::fetch(p);
    case topPeerCategoryChannels::ID:
      return topPeerCategoryChannels::fetch(p);
    case topPeerCategoryPhoneCalls::ID:
      return topPeerCategoryPhoneCalls::fetch(p);
    case topPeerCategoryForwardUsers::ID:
      return topPeerCategoryForwardUsers::fetch(p);
    case topPeerCategoryForwardChats::ID:
      return topPeerCategoryForwardChats::fetch(p);
    case topPeerCategoryBotsApp::ID:
      return topPeerCategoryBotsApp::fetch(p);
    case topPeerCategoryPeers::ID:
      return topPeerCategoryPeers::fetch(p);
    case updateNewMessage::ID:
      return updateNewMessage::fetch(p);
    case updateMessageID::ID:
      return updateMessageID::fetch(p);
    case updateDeleteMessages::ID:
      return updateDeleteMessages::fetch(p);
    case updateUserTyping::ID:
      return updateUserTyping::fetch(p);
    case updateChatUserTyping::ID:
      return updateChatUserTyping::fetch(p);
    case updateChatParticipants::ID:
      return updateChatParticipants::fetch(p);
    case updateUserStatus::ID:
      return updateUserStatus::fetch(p);
    case updateUserName::ID:
      return updateUserName::fetch(p);
    case updateNewAuthorization::ID:
      return updateNewAuthorization::fetch(p);
    case updateNewEncryptedMessage::ID:
      return updateNewEncryptedMessage::fetch(p);
    case updateEncryptedChatTyping::ID:
      return updateEncryptedChatTyping::fetch(p);
    case updateEncryption::ID:
      return updateEncryption::fetch(p);
    case updateEncryptedMessagesRead::ID:
      return updateEncryptedMessagesRead::fetch(p);
    case updateChatParticipantAdd::ID:
      return updateChatParticipantAdd::fetch(p);
    case updateChatParticipantDelete::ID:
      return updateChatParticipantDelete::fetch(p);
    case updateDcOptions::ID:
      return updateDcOptions::fetch(p);
    case updateNotifySettings::ID:
      return updateNotifySettings::fetch(p);
    case updateServiceNotification::ID:
      return updateServiceNotification::fetch(p);
    case updatePrivacy::ID:
      return updatePrivacy::fetch(p);
    case updateUserPhone::ID:
      return updateUserPhone::fetch(p);
    case updateReadHistoryInbox::ID:
      return updateReadHistoryInbox::fetch(p);
    case updateReadHistoryOutbox::ID:
      return updateReadHistoryOutbox::fetch(p);
    case updateWebPage::ID:
      return updateWebPage::fetch(p);
    case updateReadMessagesContents::ID:
      return updateReadMessagesContents::fetch(p);
    case updateChannelTooLong::ID:
      return updateChannelTooLong::fetch(p);
    case updateChannel::ID:
      return updateChannel::fetch(p);
    case updateNewChannelMessage::ID:
      return updateNewChannelMessage::fetch(p);
    case updateReadChannelInbox::ID:
      return updateReadChannelInbox::fetch(p);
    case updateDeleteChannelMessages::ID:
      return updateDeleteChannelMessages::fetch(p);
    case updateChannelMessageViews::ID:
      return updateChannelMessageViews::fetch(p);
    case updateChatParticipantAdmin::ID:
      return updateChatParticipantAdmin::fetch(p);
    case updateNewStickerSet::ID:
      return updateNewStickerSet::fetch(p);
    case updateStickerSetsOrder::ID:
      return updateStickerSetsOrder::fetch(p);
    case updateStickerSets::ID:
      return updateStickerSets::fetch(p);
    case updateSavedGifs::ID:
      return updateSavedGifs::fetch(p);
    case updateBotInlineQuery::ID:
      return updateBotInlineQuery::fetch(p);
    case updateBotInlineSend::ID:
      return updateBotInlineSend::fetch(p);
    case updateEditChannelMessage::ID:
      return updateEditChannelMessage::fetch(p);
    case updateBotCallbackQuery::ID:
      return updateBotCallbackQuery::fetch(p);
    case updateEditMessage::ID:
      return updateEditMessage::fetch(p);
    case updateInlineBotCallbackQuery::ID:
      return updateInlineBotCallbackQuery::fetch(p);
    case updateReadChannelOutbox::ID:
      return updateReadChannelOutbox::fetch(p);
    case updateDraftMessage::ID:
      return updateDraftMessage::fetch(p);
    case updateReadFeaturedStickers::ID:
      return updateReadFeaturedStickers::fetch(p);
    case updateRecentStickers::ID:
      return updateRecentStickers::fetch(p);
    case updateConfig::ID:
      return updateConfig::fetch(p);
    case updatePtsChanged::ID:
      return updatePtsChanged::fetch(p);
    case updateChannelWebPage::ID:
      return updateChannelWebPage::fetch(p);
    case updateDialogPinned::ID:
      return updateDialogPinned::fetch(p);
    case updatePinnedDialogs::ID:
      return updatePinnedDialogs::fetch(p);
    case updateBotWebhookJSON::ID:
      return updateBotWebhookJSON::fetch(p);
    case updateBotWebhookJSONQuery::ID:
      return updateBotWebhookJSONQuery::fetch(p);
    case updateBotShippingQuery::ID:
      return updateBotShippingQuery::fetch(p);
    case updateBotPrecheckoutQuery::ID:
      return updateBotPrecheckoutQuery::fetch(p);
    case updatePhoneCall::ID:
      return updatePhoneCall::fetch(p);
    case updateLangPackTooLong::ID:
      return updateLangPackTooLong::fetch(p);
    case updateLangPack::ID:
      return updateLangPack::fetch(p);
    case updateFavedStickers::ID:
      return updateFavedStickers::fetch(p);
    case updateChannelReadMessagesContents::ID:
      return updateChannelReadMessagesContents::fetch(p);
    case updateContactsReset::ID:
      return updateContactsReset::fetch(p);
    case updateChannelAvailableMessages::ID:
      return updateChannelAvailableMessages::fetch(p);
    case updateDialogUnreadMark::ID:
      return updateDialogUnreadMark::fetch(p);
    case updateMessagePoll::ID:
      return updateMessagePoll::fetch(p);
    case updateChatDefaultBannedRights::ID:
      return updateChatDefaultBannedRights::fetch(p);
    case updateFolderPeers::ID:
      return updateFolderPeers::fetch(p);
    case updatePeerSettings::ID:
      return updatePeerSettings::fetch(p);
    case updatePeerLocated::ID:
      return updatePeerLocated::fetch(p);
    case updateNewScheduledMessage::ID:
      return updateNewScheduledMessage::fetch(p);
    case updateDeleteScheduledMessages::ID:
      return updateDeleteScheduledMessages::fetch(p);
    case updateTheme::ID:
      return updateTheme::fetch(p);
    case updateGeoLiveViewed::ID:
      return updateGeoLiveViewed::fetch(p);
    case updateLoginToken::ID:
      return updateLoginToken::fetch(p);
    case updateMessagePollVote::ID:
      return updateMessagePollVote::fetch(p);
    case updateDialogFilter::ID:
      return updateDialogFilter::fetch(p);
    case updateDialogFilterOrder::ID:
      return updateDialogFilterOrder::fetch(p);
    case updateDialogFilters::ID:
      return updateDialogFilters::fetch(p);
    case updatePhoneCallSignalingData::ID:
      return updatePhoneCallSignalingData::fetch(p);
    case updateChannelMessageForwards::ID:
      return updateChannelMessageForwards::fetch(p);
    case updateReadChannelDiscussionInbox::ID:
      return updateReadChannelDiscussionInbox::fetch(p);
    case updateReadChannelDiscussionOutbox::ID:
      return updateReadChannelDiscussionOutbox::fetch(p);
    case updatePeerBlocked::ID:
      return updatePeerBlocked::fetch(p);
    case updateChannelUserTyping::ID:
      return updateChannelUserTyping::fetch(p);
    case updatePinnedMessages::ID:
      return updatePinnedMessages::fetch(p);
    case updatePinnedChannelMessages::ID:
      return updatePinnedChannelMessages::fetch(p);
    case updateChat::ID:
      return updateChat::fetch(p);
    case updateGroupCallParticipants::ID:
      return updateGroupCallParticipants::fetch(p);
    case updateGroupCall::ID:
      return updateGroupCall::fetch(p);
    case updatePeerHistoryTTL::ID:
      return updatePeerHistoryTTL::fetch(p);
    case updateChatParticipant::ID:
      return updateChatParticipant::fetch(p);
    case updateChannelParticipant::ID:
      return updateChannelParticipant::fetch(p);
    case updateBotStopped::ID:
      return updateBotStopped::fetch(p);
    case updateGroupCallConnection::ID:
      return updateGroupCallConnection::fetch(p);
    case updateBotCommands::ID:
      return updateBotCommands::fetch(p);
    case updatePendingJoinRequests::ID:
      return updatePendingJoinRequests::fetch(p);
    case updateBotChatInviteRequester::ID:
      return updateBotChatInviteRequester::fetch(p);
    case updateMessageReactions::ID:
      return updateMessageReactions::fetch(p);
    case updateAttachMenuBots::ID:
      return updateAttachMenuBots::fetch(p);
    case updateWebViewResultSent::ID:
      return updateWebViewResultSent::fetch(p);
    case updateBotMenuButton::ID:
      return updateBotMenuButton::fetch(p);
    case updateSavedRingtones::ID:
      return updateSavedRingtones::fetch(p);
    case updateTranscribedAudio::ID:
      return updateTranscribedAudio::fetch(p);
    case updateReadFeaturedEmojiStickers::ID:
      return updateReadFeaturedEmojiStickers::fetch(p);
    case updateUserEmojiStatus::ID:
      return updateUserEmojiStatus::fetch(p);
    case updateRecentEmojiStatuses::ID:
      return updateRecentEmojiStatuses::fetch(p);
    case updateRecentReactions::ID:
      return updateRecentReactions::fetch(p);
    case updateMoveStickerSetToTop::ID:
      return updateMoveStickerSetToTop::fetch(p);
    case updateMessageExtendedMedia::ID:
      return updateMessageExtendedMedia::fetch(p);
    case updateChannelPinnedTopic::ID:
      return updateChannelPinnedTopic::fetch(p);
    case updateChannelPinnedTopics::ID:
      return updateChannelPinnedTopics::fetch(p);
    case updateUser::ID:
      return updateUser::fetch(p);
    case updateAutoSaveSettings::ID:
      return updateAutoSaveSettings::fetch(p);
    case updateStory::ID:
      return updateStory::fetch(p);
    case updateReadStories::ID:
      return updateReadStories::fetch(p);
    case updateStoryID::ID:
      return updateStoryID::fetch(p);
    case updateStoriesStealthMode::ID:
      return updateStoriesStealthMode::fetch(p);
    case updateSentStoryReaction::ID:
      return updateSentStoryReaction::fetch(p);
    case updateBotChatBoost::ID:
      return updateBotChatBoost::fetch(p);
    case updateChannelViewForumAsMessages::ID:
      return updateChannelViewForumAsMessages::fetch(p);
    case updatePeerWallpaper::ID:
      return updatePeerWallpaper::fetch(p);
    case updateBotMessageReaction::ID:
      return updateBotMessageReaction::fetch(p);
    case updateBotMessageReactions::ID:
      return updateBotMessageReactions::fetch(p);
    case updateSavedDialogPinned::ID:
      return updateSavedDialogPinned::fetch(p);
    case updatePinnedSavedDialogs::ID:
      return updatePinnedSavedDialogs::fetch(p);
    case updateSavedReactionTags::ID:
      return updateSavedReactionTags::fetch(p);
    case updateSmsJob::ID:
      return updateSmsJob::fetch(p);
    case updateQuickReplies::ID:
      return updateQuickReplies::fetch(p);
    case updateNewQuickReply::ID:
      return updateNewQuickReply::fetch(p);
    case updateDeleteQuickReply::ID:
      return updateDeleteQuickReply::fetch(p);
    case updateQuickReplyMessage::ID:
      return updateQuickReplyMessage::fetch(p);
    case updateDeleteQuickReplyMessages::ID:
      return updateDeleteQuickReplyMessages::fetch(p);
    case updateBotBusinessConnect::ID:
      return updateBotBusinessConnect::fetch(p);
    case updateBotNewBusinessMessage::ID:
      return updateBotNewBusinessMessage::fetch(p);
    case updateBotEditBusinessMessage::ID:
      return updateBotEditBusinessMessage::fetch(p);
    case updateBotDeleteBusinessMessage::ID:
      return updateBotDeleteBusinessMessage::fetch(p);
    case updateNewStoryReaction::ID:
      return updateNewStoryReaction::fetch(p);
    case updateStarsBalance::ID:
      return updateStarsBalance::fetch(p);
    case updateBusinessBotCallbackQuery::ID:
      return updateBusinessBotCallbackQuery::fetch(p);
    case updateStarsRevenueStatus::ID:
      return updateStarsRevenueStatus::fetch(p);
    case updateBotPurchasedPaidMedia::ID:
      return updateBotPurchasedPaidMedia::fetch(p);
    case updatePaidReactionPrivacy::ID:
      return updatePaidReactionPrivacy::fetch(p);
    case updateSentPhoneCode::ID:
      return updateSentPhoneCode::fetch(p);
    case updateGroupCallChainBlocks::ID:
      return updateGroupCallChainBlocks::fetch(p);
    case updateReadMonoForumInbox::ID:
      return updateReadMonoForumInbox::fetch(p);
    case updateReadMonoForumOutbox::ID:
      return updateReadMonoForumOutbox::fetch(p);
    case updateMonoForumNoPaidException::ID:
      return updateMonoForumNoPaidException::fetch(p);
    case updatesTooLong::ID:
      return updatesTooLong::fetch(p);
    case updateShortMessage::ID:
      return updateShortMessage::fetch(p);
    case updateShortChatMessage::ID:
      return updateShortChatMessage::fetch(p);
    case updateShort::ID:
      return updateShort::fetch(p);
    case updatesCombined::ID:
      return updatesCombined::fetch(p);
    case updates::ID:
      return updates::fetch(p);
    case updateShortSentMessage::ID:
      return updateShortSentMessage::fetch(p);
    case urlAuthResultRequest::ID:
      return urlAuthResultRequest::fetch(p);
    case urlAuthResultAccepted::ID:
      return urlAuthResultAccepted::fetch(p);
    case urlAuthResultDefault::ID:
      return urlAuthResultDefault::fetch(p);
    case userEmpty::ID:
      return userEmpty::fetch(p);
    case user::ID:
      return user::fetch(p);
    case userFull::ID:
      return userFull::fetch(p);
    case userProfilePhotoEmpty::ID:
      return userProfilePhotoEmpty::fetch(p);
    case userProfilePhoto::ID:
      return userProfilePhoto::fetch(p);
    case userStatusEmpty::ID:
      return userStatusEmpty::fetch(p);
    case userStatusOnline::ID:
      return userStatusOnline::fetch(p);
    case userStatusOffline::ID:
      return userStatusOffline::fetch(p);
    case userStatusRecently::ID:
      return userStatusRecently::fetch(p);
    case userStatusLastWeek::ID:
      return userStatusLastWeek::fetch(p);
    case userStatusLastMonth::ID:
      return userStatusLastMonth::fetch(p);
    case username::ID:
      return username::fetch(p);
    case videoSize::ID:
      return videoSize::fetch(p);
    case videoSizeEmojiMarkup::ID:
      return videoSizeEmojiMarkup::fetch(p);
    case videoSizeStickerMarkup::ID:
      return videoSizeStickerMarkup::fetch(p);
    case wallPaper::ID:
      return wallPaper::fetch(p);
    case wallPaperNoFile::ID:
      return wallPaperNoFile::fetch(p);
    case wallPaperSettings::ID:
      return wallPaperSettings::fetch(p);
    case webAuthorization::ID:
      return webAuthorization::fetch(p);
    case webDocument::ID:
      return webDocument::fetch(p);
    case webDocumentNoProxy::ID:
      return webDocumentNoProxy::fetch(p);
    case webPageEmpty::ID:
      return webPageEmpty::fetch(p);
    case webPagePending::ID:
      return webPagePending::fetch(p);
    case webPage::ID:
      return webPage::fetch(p);
    case webPageNotModified::ID:
      return webPageNotModified::fetch(p);
    case webPageAttributeTheme::ID:
      return webPageAttributeTheme::fetch(p);
    case webPageAttributeStory::ID:
      return webPageAttributeStory::fetch(p);
    case webPageAttributeStickerSet::ID:
      return webPageAttributeStickerSet::fetch(p);
    case webPageAttributeUniqueStarGift::ID:
      return webPageAttributeUniqueStarGift::fetch(p);
    case webViewMessageSent::ID:
      return webViewMessageSent::fetch(p);
    case webViewResultUrl::ID:
      return webViewResultUrl::fetch(p);
    case account_authorizationForm::ID:
      return account_authorizationForm::fetch(p);
    case account_authorizations::ID:
      return account_authorizations::fetch(p);
    case account_autoDownloadSettings::ID:
      return account_autoDownloadSettings::fetch(p);
    case account_autoSaveSettings::ID:
      return account_autoSaveSettings::fetch(p);
    case account_businessChatLinks::ID:
      return account_businessChatLinks::fetch(p);
    case account_connectedBots::ID:
      return account_connectedBots::fetch(p);
    case account_contentSettings::ID:
      return account_contentSettings::fetch(p);
    case account_emailVerified::ID:
      return account_emailVerified::fetch(p);
    case account_emailVerifiedLogin::ID:
      return account_emailVerifiedLogin::fetch(p);
    case account_emojiStatusesNotModified::ID:
      return account_emojiStatusesNotModified::fetch(p);
    case account_emojiStatuses::ID:
      return account_emojiStatuses::fetch(p);
    case account_paidMessagesRevenue::ID:
      return account_paidMessagesRevenue::fetch(p);
    case account_password::ID:
      return account_password::fetch(p);
    case account_passwordSettings::ID:
      return account_passwordSettings::fetch(p);
    case account_privacyRules::ID:
      return account_privacyRules::fetch(p);
    case account_resetPasswordFailedWait::ID:
      return account_resetPasswordFailedWait::fetch(p);
    case account_resetPasswordRequestedWait::ID:
      return account_resetPasswordRequestedWait::fetch(p);
    case account_resetPasswordOk::ID:
      return account_resetPasswordOk::fetch(p);
    case account_resolvedBusinessChatLinks::ID:
      return account_resolvedBusinessChatLinks::fetch(p);
    case account_savedRingtone::ID:
      return account_savedRingtone::fetch(p);
    case account_savedRingtoneConverted::ID:
      return account_savedRingtoneConverted::fetch(p);
    case account_savedRingtonesNotModified::ID:
      return account_savedRingtonesNotModified::fetch(p);
    case account_savedRingtones::ID:
      return account_savedRingtones::fetch(p);
    case account_sentEmailCode::ID:
      return account_sentEmailCode::fetch(p);
    case account_takeout::ID:
      return account_takeout::fetch(p);
    case account_themesNotModified::ID:
      return account_themesNotModified::fetch(p);
    case account_themes::ID:
      return account_themes::fetch(p);
    case account_tmpPassword::ID:
      return account_tmpPassword::fetch(p);
    case account_wallPapersNotModified::ID:
      return account_wallPapersNotModified::fetch(p);
    case account_wallPapers::ID:
      return account_wallPapers::fetch(p);
    case account_webAuthorizations::ID:
      return account_webAuthorizations::fetch(p);
    case auth_authorization::ID:
      return auth_authorization::fetch(p);
    case auth_authorizationSignUpRequired::ID:
      return auth_authorizationSignUpRequired::fetch(p);
    case auth_codeTypeSms::ID:
      return auth_codeTypeSms::fetch(p);
    case auth_codeTypeCall::ID:
      return auth_codeTypeCall::fetch(p);
    case auth_codeTypeFlashCall::ID:
      return auth_codeTypeFlashCall::fetch(p);
    case auth_codeTypeMissedCall::ID:
      return auth_codeTypeMissedCall::fetch(p);
    case auth_codeTypeFragmentSms::ID:
      return auth_codeTypeFragmentSms::fetch(p);
    case auth_exportedAuthorization::ID:
      return auth_exportedAuthorization::fetch(p);
    case auth_loggedOut::ID:
      return auth_loggedOut::fetch(p);
    case auth_loginToken::ID:
      return auth_loginToken::fetch(p);
    case auth_loginTokenMigrateTo::ID:
      return auth_loginTokenMigrateTo::fetch(p);
    case auth_loginTokenSuccess::ID:
      return auth_loginTokenSuccess::fetch(p);
    case auth_passwordRecovery::ID:
      return auth_passwordRecovery::fetch(p);
    case auth_sentCode::ID:
      return auth_sentCode::fetch(p);
    case auth_sentCodeSuccess::ID:
      return auth_sentCodeSuccess::fetch(p);
    case auth_sentCodePaymentRequired::ID:
      return auth_sentCodePaymentRequired::fetch(p);
    case auth_sentCodeTypeApp::ID:
      return auth_sentCodeTypeApp::fetch(p);
    case auth_sentCodeTypeSms::ID:
      return auth_sentCodeTypeSms::fetch(p);
    case auth_sentCodeTypeCall::ID:
      return auth_sentCodeTypeCall::fetch(p);
    case auth_sentCodeTypeFlashCall::ID:
      return auth_sentCodeTypeFlashCall::fetch(p);
    case auth_sentCodeTypeMissedCall::ID:
      return auth_sentCodeTypeMissedCall::fetch(p);
    case auth_sentCodeTypeEmailCode::ID:
      return auth_sentCodeTypeEmailCode::fetch(p);
    case auth_sentCodeTypeSetUpEmailRequired::ID:
      return auth_sentCodeTypeSetUpEmailRequired::fetch(p);
    case auth_sentCodeTypeFragmentSms::ID:
      return auth_sentCodeTypeFragmentSms::fetch(p);
    case auth_sentCodeTypeFirebaseSms::ID:
      return auth_sentCodeTypeFirebaseSms::fetch(p);
    case auth_sentCodeTypeSmsWord::ID:
      return auth_sentCodeTypeSmsWord::fetch(p);
    case auth_sentCodeTypeSmsPhrase::ID:
      return auth_sentCodeTypeSmsPhrase::fetch(p);
    case bots_botInfo::ID:
      return bots_botInfo::fetch(p);
    case bots_popularAppBots::ID:
      return bots_popularAppBots::fetch(p);
    case bots_previewInfo::ID:
      return bots_previewInfo::fetch(p);
    case channels_adminLogResults::ID:
      return channels_adminLogResults::fetch(p);
    case channels_channelParticipant::ID:
      return channels_channelParticipant::fetch(p);
    case channels_channelParticipants::ID:
      return channels_channelParticipants::fetch(p);
    case channels_channelParticipantsNotModified::ID:
      return channels_channelParticipantsNotModified::fetch(p);
    case channels_sendAsPeers::ID:
      return channels_sendAsPeers::fetch(p);
    case channels_sponsoredMessageReportResultChooseOption::ID:
      return channels_sponsoredMessageReportResultChooseOption::fetch(p);
    case channels_sponsoredMessageReportResultAdsHidden::ID:
      return channels_sponsoredMessageReportResultAdsHidden::fetch(p);
    case channels_sponsoredMessageReportResultReported::ID:
      return channels_sponsoredMessageReportResultReported::fetch(p);
    case chatlists_chatlistInviteAlready::ID:
      return chatlists_chatlistInviteAlready::fetch(p);
    case chatlists_chatlistInvite::ID:
      return chatlists_chatlistInvite::fetch(p);
    case chatlists_chatlistUpdates::ID:
      return chatlists_chatlistUpdates::fetch(p);
    case chatlists_exportedChatlistInvite::ID:
      return chatlists_exportedChatlistInvite::fetch(p);
    case chatlists_exportedInvites::ID:
      return chatlists_exportedInvites::fetch(p);
    case contacts_blocked::ID:
      return contacts_blocked::fetch(p);
    case contacts_blockedSlice::ID:
      return contacts_blockedSlice::fetch(p);
    case contacts_contactBirthdays::ID:
      return contacts_contactBirthdays::fetch(p);
    case contacts_contactsNotModified::ID:
      return contacts_contactsNotModified::fetch(p);
    case contacts_contacts::ID:
      return contacts_contacts::fetch(p);
    case contacts_found::ID:
      return contacts_found::fetch(p);
    case contacts_importedContacts::ID:
      return contacts_importedContacts::fetch(p);
    case contacts_resolvedPeer::ID:
      return contacts_resolvedPeer::fetch(p);
    case contacts_sponsoredPeersEmpty::ID:
      return contacts_sponsoredPeersEmpty::fetch(p);
    case contacts_sponsoredPeers::ID:
      return contacts_sponsoredPeers::fetch(p);
    case contacts_topPeersNotModified::ID:
      return contacts_topPeersNotModified::fetch(p);
    case contacts_topPeers::ID:
      return contacts_topPeers::fetch(p);
    case contacts_topPeersDisabled::ID:
      return contacts_topPeersDisabled::fetch(p);
    case fragment_collectibleInfo::ID:
      return fragment_collectibleInfo::fetch(p);
    case help_appConfigNotModified::ID:
      return help_appConfigNotModified::fetch(p);
    case help_appConfig::ID:
      return help_appConfig::fetch(p);
    case help_appUpdate::ID:
      return help_appUpdate::fetch(p);
    case help_noAppUpdate::ID:
      return help_noAppUpdate::fetch(p);
    case help_configSimple::ID:
      return help_configSimple::fetch(p);
    case help_countriesListNotModified::ID:
      return help_countriesListNotModified::fetch(p);
    case help_countriesList::ID:
      return help_countriesList::fetch(p);
    case help_country::ID:
      return help_country::fetch(p);
    case help_countryCode::ID:
      return help_countryCode::fetch(p);
    case help_deepLinkInfoEmpty::ID:
      return help_deepLinkInfoEmpty::fetch(p);
    case help_deepLinkInfo::ID:
      return help_deepLinkInfo::fetch(p);
    case help_inviteText::ID:
      return help_inviteText::fetch(p);
    case help_passportConfigNotModified::ID:
      return help_passportConfigNotModified::fetch(p);
    case help_passportConfig::ID:
      return help_passportConfig::fetch(p);
    case help_peerColorOption::ID:
      return help_peerColorOption::fetch(p);
    case help_peerColorSet::ID:
      return help_peerColorSet::fetch(p);
    case help_peerColorProfileSet::ID:
      return help_peerColorProfileSet::fetch(p);
    case help_peerColorsNotModified::ID:
      return help_peerColorsNotModified::fetch(p);
    case help_peerColors::ID:
      return help_peerColors::fetch(p);
    case help_premiumPromo::ID:
      return help_premiumPromo::fetch(p);
    case help_promoDataEmpty::ID:
      return help_promoDataEmpty::fetch(p);
    case help_promoData::ID:
      return help_promoData::fetch(p);
    case help_recentMeUrls::ID:
      return help_recentMeUrls::fetch(p);
    case help_support::ID:
      return help_support::fetch(p);
    case help_supportName::ID:
      return help_supportName::fetch(p);
    case help_termsOfService::ID:
      return help_termsOfService::fetch(p);
    case help_termsOfServiceUpdateEmpty::ID:
      return help_termsOfServiceUpdateEmpty::fetch(p);
    case help_termsOfServiceUpdate::ID:
      return help_termsOfServiceUpdate::fetch(p);
    case help_timezonesListNotModified::ID:
      return help_timezonesListNotModified::fetch(p);
    case help_timezonesList::ID:
      return help_timezonesList::fetch(p);
    case help_userInfoEmpty::ID:
      return help_userInfoEmpty::fetch(p);
    case help_userInfo::ID:
      return help_userInfo::fetch(p);
    case messages_affectedFoundMessages::ID:
      return messages_affectedFoundMessages::fetch(p);
    case messages_affectedHistory::ID:
      return messages_affectedHistory::fetch(p);
    case messages_affectedMessages::ID:
      return messages_affectedMessages::fetch(p);
    case messages_allStickersNotModified::ID:
      return messages_allStickersNotModified::fetch(p);
    case messages_allStickers::ID:
      return messages_allStickers::fetch(p);
    case messages_archivedStickers::ID:
      return messages_archivedStickers::fetch(p);
    case messages_availableEffectsNotModified::ID:
      return messages_availableEffectsNotModified::fetch(p);
    case messages_availableEffects::ID:
      return messages_availableEffects::fetch(p);
    case messages_availableReactionsNotModified::ID:
      return messages_availableReactionsNotModified::fetch(p);
    case messages_availableReactions::ID:
      return messages_availableReactions::fetch(p);
    case messages_botApp::ID:
      return messages_botApp::fetch(p);
    case messages_botCallbackAnswer::ID:
      return messages_botCallbackAnswer::fetch(p);
    case messages_botPreparedInlineMessage::ID:
      return messages_botPreparedInlineMessage::fetch(p);
    case messages_botResults::ID:
      return messages_botResults::fetch(p);
    case messages_chatAdminsWithInvites::ID:
      return messages_chatAdminsWithInvites::fetch(p);
    case messages_chatFull::ID:
      return messages_chatFull::fetch(p);
    case messages_chatInviteImporters::ID:
      return messages_chatInviteImporters::fetch(p);
    case messages_chats::ID:
      return messages_chats::fetch(p);
    case messages_chatsSlice::ID:
      return messages_chatsSlice::fetch(p);
    case messages_checkedHistoryImportPeer::ID:
      return messages_checkedHistoryImportPeer::fetch(p);
    case messages_dhConfigNotModified::ID:
      return messages_dhConfigNotModified::fetch(p);
    case messages_dhConfig::ID:
      return messages_dhConfig::fetch(p);
    case messages_dialogFilters::ID:
      return messages_dialogFilters::fetch(p);
    case messages_dialogs::ID:
      return messages_dialogs::fetch(p);
    case messages_dialogsSlice::ID:
      return messages_dialogsSlice::fetch(p);
    case messages_dialogsNotModified::ID:
      return messages_dialogsNotModified::fetch(p);
    case messages_discussionMessage::ID:
      return messages_discussionMessage::fetch(p);
    case messages_emojiGroupsNotModified::ID:
      return messages_emojiGroupsNotModified::fetch(p);
    case messages_emojiGroups::ID:
      return messages_emojiGroups::fetch(p);
    case messages_exportedChatInvite::ID:
      return messages_exportedChatInvite::fetch(p);
    case messages_exportedChatInviteReplaced::ID:
      return messages_exportedChatInviteReplaced::fetch(p);
    case messages_exportedChatInvites::ID:
      return messages_exportedChatInvites::fetch(p);
    case messages_favedStickersNotModified::ID:
      return messages_favedStickersNotModified::fetch(p);
    case messages_favedStickers::ID:
      return messages_favedStickers::fetch(p);
    case messages_featuredStickersNotModified::ID:
      return messages_featuredStickersNotModified::fetch(p);
    case messages_featuredStickers::ID:
      return messages_featuredStickers::fetch(p);
    case messages_forumTopics::ID:
      return messages_forumTopics::fetch(p);
    case messages_foundStickerSetsNotModified::ID:
      return messages_foundStickerSetsNotModified::fetch(p);
    case messages_foundStickerSets::ID:
      return messages_foundStickerSets::fetch(p);
    case messages_foundStickersNotModified::ID:
      return messages_foundStickersNotModified::fetch(p);
    case messages_foundStickers::ID:
      return messages_foundStickers::fetch(p);
    case messages_highScores::ID:
      return messages_highScores::fetch(p);
    case messages_historyImport::ID:
      return messages_historyImport::fetch(p);
    case messages_historyImportParsed::ID:
      return messages_historyImportParsed::fetch(p);
    case messages_inactiveChats::ID:
      return messages_inactiveChats::fetch(p);
    case messages_invitedUsers::ID:
      return messages_invitedUsers::fetch(p);
    case messages_messageEditData::ID:
      return messages_messageEditData::fetch(p);
    case messages_messageReactionsList::ID:
      return messages_messageReactionsList::fetch(p);
    case messages_messageViews::ID:
      return messages_messageViews::fetch(p);
    case messages_messages::ID:
      return messages_messages::fetch(p);
    case messages_messagesSlice::ID:
      return messages_messagesSlice::fetch(p);
    case messages_channelMessages::ID:
      return messages_channelMessages::fetch(p);
    case messages_messagesNotModified::ID:
      return messages_messagesNotModified::fetch(p);
    case messages_myStickers::ID:
      return messages_myStickers::fetch(p);
    case messages_peerDialogs::ID:
      return messages_peerDialogs::fetch(p);
    case messages_peerSettings::ID:
      return messages_peerSettings::fetch(p);
    case messages_preparedInlineMessage::ID:
      return messages_preparedInlineMessage::fetch(p);
    case messages_quickReplies::ID:
      return messages_quickReplies::fetch(p);
    case messages_quickRepliesNotModified::ID:
      return messages_quickRepliesNotModified::fetch(p);
    case messages_reactionsNotModified::ID:
      return messages_reactionsNotModified::fetch(p);
    case messages_reactions::ID:
      return messages_reactions::fetch(p);
    case messages_recentStickersNotModified::ID:
      return messages_recentStickersNotModified::fetch(p);
    case messages_recentStickers::ID:
      return messages_recentStickers::fetch(p);
    case messages_savedDialogs::ID:
      return messages_savedDialogs::fetch(p);
    case messages_savedDialogsSlice::ID:
      return messages_savedDialogsSlice::fetch(p);
    case messages_savedDialogsNotModified::ID:
      return messages_savedDialogsNotModified::fetch(p);
    case messages_savedGifsNotModified::ID:
      return messages_savedGifsNotModified::fetch(p);
    case messages_savedGifs::ID:
      return messages_savedGifs::fetch(p);
    case messages_savedReactionTagsNotModified::ID:
      return messages_savedReactionTagsNotModified::fetch(p);
    case messages_savedReactionTags::ID:
      return messages_savedReactionTags::fetch(p);
    case messages_searchCounter::ID:
      return messages_searchCounter::fetch(p);
    case messages_searchResultsCalendar::ID:
      return messages_searchResultsCalendar::fetch(p);
    case messages_searchResultsPositions::ID:
      return messages_searchResultsPositions::fetch(p);
    case messages_sentEncryptedMessage::ID:
      return messages_sentEncryptedMessage::fetch(p);
    case messages_sentEncryptedFile::ID:
      return messages_sentEncryptedFile::fetch(p);
    case messages_sponsoredMessages::ID:
      return messages_sponsoredMessages::fetch(p);
    case messages_sponsoredMessagesEmpty::ID:
      return messages_sponsoredMessagesEmpty::fetch(p);
    case messages_stickerSet::ID:
      return messages_stickerSet::fetch(p);
    case messages_stickerSetNotModified::ID:
      return messages_stickerSetNotModified::fetch(p);
    case messages_stickerSetInstallResultSuccess::ID:
      return messages_stickerSetInstallResultSuccess::fetch(p);
    case messages_stickerSetInstallResultArchive::ID:
      return messages_stickerSetInstallResultArchive::fetch(p);
    case messages_stickersNotModified::ID:
      return messages_stickersNotModified::fetch(p);
    case messages_stickers::ID:
      return messages_stickers::fetch(p);
    case messages_transcribedAudio::ID:
      return messages_transcribedAudio::fetch(p);
    case messages_translateResult::ID:
      return messages_translateResult::fetch(p);
    case messages_votesList::ID:
      return messages_votesList::fetch(p);
    case messages_webPage::ID:
      return messages_webPage::fetch(p);
    case messages_webPagePreview::ID:
      return messages_webPagePreview::fetch(p);
    case payments_bankCardData::ID:
      return payments_bankCardData::fetch(p);
    case payments_checkedGiftCode::ID:
      return payments_checkedGiftCode::fetch(p);
    case payments_connectedStarRefBots::ID:
      return payments_connectedStarRefBots::fetch(p);
    case payments_exportedInvoice::ID:
      return payments_exportedInvoice::fetch(p);
    case payments_giveawayInfo::ID:
      return payments_giveawayInfo::fetch(p);
    case payments_giveawayInfoResults::ID:
      return payments_giveawayInfoResults::fetch(p);
    case payments_paymentForm::ID:
      return payments_paymentForm::fetch(p);
    case payments_paymentFormStars::ID:
      return payments_paymentFormStars::fetch(p);
    case payments_paymentFormStarGift::ID:
      return payments_paymentFormStarGift::fetch(p);
    case payments_paymentReceipt::ID:
      return payments_paymentReceipt::fetch(p);
    case payments_paymentReceiptStars::ID:
      return payments_paymentReceiptStars::fetch(p);
    case payments_paymentResult::ID:
      return payments_paymentResult::fetch(p);
    case payments_paymentVerificationNeeded::ID:
      return payments_paymentVerificationNeeded::fetch(p);
    case payments_resaleStarGifts::ID:
      return payments_resaleStarGifts::fetch(p);
    case payments_savedInfo::ID:
      return payments_savedInfo::fetch(p);
    case payments_savedStarGifts::ID:
      return payments_savedStarGifts::fetch(p);
    case payments_starGiftUpgradePreview::ID:
      return payments_starGiftUpgradePreview::fetch(p);
    case payments_starGiftWithdrawalUrl::ID:
      return payments_starGiftWithdrawalUrl::fetch(p);
    case payments_starGiftsNotModified::ID:
      return payments_starGiftsNotModified::fetch(p);
    case payments_starGifts::ID:
      return payments_starGifts::fetch(p);
    case payments_starsRevenueAdsAccountUrl::ID:
      return payments_starsRevenueAdsAccountUrl::fetch(p);
    case payments_starsRevenueStats::ID:
      return payments_starsRevenueStats::fetch(p);
    case payments_starsRevenueWithdrawalUrl::ID:
      return payments_starsRevenueWithdrawalUrl::fetch(p);
    case payments_starsStatus::ID:
      return payments_starsStatus::fetch(p);
    case payments_suggestedStarRefBots::ID:
      return payments_suggestedStarRefBots::fetch(p);
    case payments_uniqueStarGift::ID:
      return payments_uniqueStarGift::fetch(p);
    case payments_validatedRequestedInfo::ID:
      return payments_validatedRequestedInfo::fetch(p);
    case phone_exportedGroupCallInvite::ID:
      return phone_exportedGroupCallInvite::fetch(p);
    case phone_groupCall::ID:
      return phone_groupCall::fetch(p);
    case phone_groupCallStreamChannels::ID:
      return phone_groupCallStreamChannels::fetch(p);
    case phone_groupCallStreamRtmpUrl::ID:
      return phone_groupCallStreamRtmpUrl::fetch(p);
    case phone_groupParticipants::ID:
      return phone_groupParticipants::fetch(p);
    case phone_joinAsPeers::ID:
      return phone_joinAsPeers::fetch(p);
    case phone_phoneCall::ID:
      return phone_phoneCall::fetch(p);
    case photos_photo::ID:
      return photos_photo::fetch(p);
    case photos_photos::ID:
      return photos_photos::fetch(p);
    case photos_photosSlice::ID:
      return photos_photosSlice::fetch(p);
    case premium_boostsList::ID:
      return premium_boostsList::fetch(p);
    case premium_boostsStatus::ID:
      return premium_boostsStatus::fetch(p);
    case premium_myBoosts::ID:
      return premium_myBoosts::fetch(p);
    case smsjobs_eligibleToJoin::ID:
      return smsjobs_eligibleToJoin::fetch(p);
    case smsjobs_status::ID:
      return smsjobs_status::fetch(p);
    case stats_broadcastStats::ID:
      return stats_broadcastStats::fetch(p);
    case stats_megagroupStats::ID:
      return stats_megagroupStats::fetch(p);
    case stats_messageStats::ID:
      return stats_messageStats::fetch(p);
    case stats_publicForwards::ID:
      return stats_publicForwards::fetch(p);
    case stats_storyStats::ID:
      return stats_storyStats::fetch(p);
    case stickers_suggestedShortName::ID:
      return stickers_suggestedShortName::fetch(p);
    case storage_fileUnknown::ID:
      return storage_fileUnknown::fetch(p);
    case storage_filePartial::ID:
      return storage_filePartial::fetch(p);
    case storage_fileJpeg::ID:
      return storage_fileJpeg::fetch(p);
    case storage_fileGif::ID:
      return storage_fileGif::fetch(p);
    case storage_filePng::ID:
      return storage_filePng::fetch(p);
    case storage_filePdf::ID:
      return storage_filePdf::fetch(p);
    case storage_fileMp3::ID:
      return storage_fileMp3::fetch(p);
    case storage_fileMov::ID:
      return storage_fileMov::fetch(p);
    case storage_fileMp4::ID:
      return storage_fileMp4::fetch(p);
    case storage_fileWebp::ID:
      return storage_fileWebp::fetch(p);
    case stories_allStoriesNotModified::ID:
      return stories_allStoriesNotModified::fetch(p);
    case stories_allStories::ID:
      return stories_allStories::fetch(p);
    case stories_canSendStoryCount::ID:
      return stories_canSendStoryCount::fetch(p);
    case stories_foundStories::ID:
      return stories_foundStories::fetch(p);
    case stories_peerStories::ID:
      return stories_peerStories::fetch(p);
    case stories_stories::ID:
      return stories_stories::fetch(p);
    case stories_storyReactionsList::ID:
      return stories_storyReactionsList::fetch(p);
    case stories_storyViews::ID:
      return stories_storyViews::fetch(p);
    case stories_storyViewsList::ID:
      return stories_storyViewsList::fetch(p);
    case updates_channelDifferenceEmpty::ID:
      return updates_channelDifferenceEmpty::fetch(p);
    case updates_channelDifferenceTooLong::ID:
      return updates_channelDifferenceTooLong::fetch(p);
    case updates_channelDifference::ID:
      return updates_channelDifference::fetch(p);
    case updates_differenceEmpty::ID:
      return updates_differenceEmpty::fetch(p);
    case updates_difference::ID:
      return updates_difference::fetch(p);
    case updates_differenceSlice::ID:
      return updates_differenceSlice::fetch(p);
    case updates_differenceTooLong::ID:
      return updates_differenceTooLong::fetch(p);
    case updates_state::ID:
      return updates_state::fetch(p);
    case upload_cdnFileReuploadNeeded::ID:
      return upload_cdnFileReuploadNeeded::fetch(p);
    case upload_cdnFile::ID:
      return upload_cdnFile::fetch(p);
    case upload_file::ID:
      return upload_file::fetch(p);
    case upload_fileCdnRedirect::ID:
      return upload_fileCdnRedirect::fetch(p);
    case upload_webFile::ID:
      return upload_webFile::fetch(p);
    case users_userFull::ID:
      return users_userFull::fetch(p);
    case users_users::ID:
      return users_users::fetch(p);
    case users_usersSlice::ID:
      return users_usersSlice::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t accessPointRule::ID;

object_ptr<accessPointRule> accessPointRule::fetch(TlBufferParser &p) {
  return make_tl_object<accessPointRule>(p);
}

accessPointRule::accessPointRule(TlBufferParser &p)
  : phone_prefix_rules_(TlFetchString<string>::parse(p))
  , dc_id_(TlFetchInt::parse(p))
  , ips_(TlFetchVector<TlFetchObject<IpPort>>::parse(p))
{}

void accessPointRule::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "accessPointRule");
    s.store_field("phone_prefix_rules", phone_prefix_rules_);
    s.store_field("dc_id", dc_id_);
    { s.store_vector_begin("ips", ips_.size()); for (const auto &_value : ips_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

accountDaysTTL::accountDaysTTL(int32 days_)
  : days_(days_)
{}

const std::int32_t accountDaysTTL::ID;

object_ptr<accountDaysTTL> accountDaysTTL::fetch(TlBufferParser &p) {
  return make_tl_object<accountDaysTTL>(p);
}

accountDaysTTL::accountDaysTTL(TlBufferParser &p)
  : days_(TlFetchInt::parse(p))
{}

void accountDaysTTL::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(days_, s);
}

void accountDaysTTL::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(days_, s);
}

void accountDaysTTL::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "accountDaysTTL");
    s.store_field("days", days_);
    s.store_class_end();
  }
}

attachMenuBot::attachMenuBot()
  : flags_()
  , inactive_()
  , has_settings_()
  , request_write_access_()
  , show_in_attach_menu_()
  , show_in_side_menu_()
  , side_menu_disclaimer_needed_()
  , bot_id_()
  , short_name_()
  , peer_types_()
  , icons_()
{}

const std::int32_t attachMenuBot::ID;

object_ptr<attachMenuBot> attachMenuBot::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<attachMenuBot> res = make_tl_object<attachMenuBot>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->inactive_ = (var0 & 1) != 0;
  res->has_settings_ = (var0 & 2) != 0;
  res->request_write_access_ = (var0 & 4) != 0;
  res->show_in_attach_menu_ = (var0 & 8) != 0;
  res->show_in_side_menu_ = (var0 & 16) != 0;
  res->side_menu_disclaimer_needed_ = (var0 & 32) != 0;
  res->bot_id_ = TlFetchLong::parse(p);
  res->short_name_ = TlFetchString<string>::parse(p);
  if (var0 & 8) { res->peer_types_ = TlFetchBoxed<TlFetchVector<TlFetchObject<AttachMenuPeerType>>, 481674261>::parse(p); }
  res->icons_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<attachMenuBotIcon>, -1297663893>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void attachMenuBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBot");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (inactive_ << 0) | (has_settings_ << 1) | (request_write_access_ << 2) | (show_in_attach_menu_ << 3) | (show_in_side_menu_ << 4) | (side_menu_disclaimer_needed_ << 5)));
    if (var0 & 1) { s.store_field("inactive", true); }
    if (var0 & 2) { s.store_field("has_settings", true); }
    if (var0 & 4) { s.store_field("request_write_access", true); }
    if (var0 & 8) { s.store_field("show_in_attach_menu", true); }
    if (var0 & 16) { s.store_field("show_in_side_menu", true); }
    if (var0 & 32) { s.store_field("side_menu_disclaimer_needed", true); }
    s.store_field("bot_id", bot_id_);
    s.store_field("short_name", short_name_);
    if (var0 & 8) { { s.store_vector_begin("peer_types", peer_types_.size()); for (const auto &_value : peer_types_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    { s.store_vector_begin("icons", icons_.size()); for (const auto &_value : icons_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

attachMenuBotIcon::attachMenuBotIcon()
  : flags_()
  , name_()
  , icon_()
  , colors_()
{}

const std::int32_t attachMenuBotIcon::ID;

object_ptr<attachMenuBotIcon> attachMenuBotIcon::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<attachMenuBotIcon> res = make_tl_object<attachMenuBotIcon>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->name_ = TlFetchString<string>::parse(p);
  res->icon_ = TlFetchObject<Document>::parse(p);
  if (var0 & 1) { res->colors_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<attachMenuBotIconColor>, 1165423600>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void attachMenuBotIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBotIcon");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("name", name_);
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    if (var0 & 1) { { s.store_vector_begin("colors", colors_.size()); for (const auto &_value : colors_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

const std::int32_t attachMenuBotIconColor::ID;

object_ptr<attachMenuBotIconColor> attachMenuBotIconColor::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuBotIconColor>(p);
}

attachMenuBotIconColor::attachMenuBotIconColor(TlBufferParser &p)
  : name_(TlFetchString<string>::parse(p))
  , color_(TlFetchInt::parse(p))
{}

void attachMenuBotIconColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBotIconColor");
    s.store_field("name", name_);
    s.store_field("color", color_);
    s.store_class_end();
  }
}

object_ptr<AttachMenuBots> AttachMenuBots::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case attachMenuBotsNotModified::ID:
      return attachMenuBotsNotModified::fetch(p);
    case attachMenuBots::ID:
      return attachMenuBots::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t attachMenuBotsNotModified::ID;

object_ptr<AttachMenuBots> attachMenuBotsNotModified::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuBotsNotModified>();
}

void attachMenuBotsNotModified::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBotsNotModified");
    s.store_class_end();
  }
}

const std::int32_t attachMenuBots::ID;

object_ptr<AttachMenuBots> attachMenuBots::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuBots>(p);
}

attachMenuBots::attachMenuBots(TlBufferParser &p)
  : hash_(TlFetchLong::parse(p))
  , bots_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<attachMenuBot>, -653423106>>, 481674261>::parse(p))
  , users_(TlFetchBoxed<TlFetchVector<TlFetchObject<User>>, 481674261>::parse(p))
{}

void attachMenuBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBots");
    s.store_field("hash", hash_);
    { s.store_vector_begin("bots", bots_.size()); for (const auto &_value : bots_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t attachMenuBotsBot::ID;

object_ptr<attachMenuBotsBot> attachMenuBotsBot::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuBotsBot>(p);
}

attachMenuBotsBot::attachMenuBotsBot(TlBufferParser &p)
  : bot_(TlFetchBoxed<TlFetchObject<attachMenuBot>, -653423106>::parse(p))
  , users_(TlFetchBoxed<TlFetchVector<TlFetchObject<User>>, 481674261>::parse(p))
{}

void attachMenuBotsBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuBotsBot");
    s.store_object_field("bot", static_cast<const BaseObject *>(bot_.get()));
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<AttachMenuPeerType> AttachMenuPeerType::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case attachMenuPeerTypeSameBotPM::ID:
      return attachMenuPeerTypeSameBotPM::fetch(p);
    case attachMenuPeerTypeBotPM::ID:
      return attachMenuPeerTypeBotPM::fetch(p);
    case attachMenuPeerTypePM::ID:
      return attachMenuPeerTypePM::fetch(p);
    case attachMenuPeerTypeChat::ID:
      return attachMenuPeerTypeChat::fetch(p);
    case attachMenuPeerTypeBroadcast::ID:
      return attachMenuPeerTypeBroadcast::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t attachMenuPeerTypeSameBotPM::ID;

object_ptr<AttachMenuPeerType> attachMenuPeerTypeSameBotPM::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuPeerTypeSameBotPM>();
}

void attachMenuPeerTypeSameBotPM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuPeerTypeSameBotPM");
    s.store_class_end();
  }
}

const std::int32_t attachMenuPeerTypeBotPM::ID;

object_ptr<AttachMenuPeerType> attachMenuPeerTypeBotPM::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuPeerTypeBotPM>();
}

void attachMenuPeerTypeBotPM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuPeerTypeBotPM");
    s.store_class_end();
  }
}

const std::int32_t attachMenuPeerTypePM::ID;

object_ptr<AttachMenuPeerType> attachMenuPeerTypePM::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuPeerTypePM>();
}

void attachMenuPeerTypePM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuPeerTypePM");
    s.store_class_end();
  }
}

const std::int32_t attachMenuPeerTypeChat::ID;

object_ptr<AttachMenuPeerType> attachMenuPeerTypeChat::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuPeerTypeChat>();
}

void attachMenuPeerTypeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuPeerTypeChat");
    s.store_class_end();
  }
}

const std::int32_t attachMenuPeerTypeBroadcast::ID;

object_ptr<AttachMenuPeerType> attachMenuPeerTypeBroadcast::fetch(TlBufferParser &p) {
  return make_tl_object<attachMenuPeerTypeBroadcast>();
}

void attachMenuPeerTypeBroadcast::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachMenuPeerTypeBroadcast");
    s.store_class_end();
  }
}

authorization::authorization()
  : flags_()
  , current_()
  , official_app_()
  , password_pending_()
  , encrypted_requests_disabled_()
  , call_requests_disabled_()
  , unconfirmed_()
  , hash_()
  , device_model_()
  , platform_()
  , system_version_()
  , api_id_()
  , app_name_()
  , app_version_()
  , date_created_()
  , date_active_()
  , ip_()
  , country_()
  , region_()
{}

const std::int32_t authorization::ID;

object_ptr<authorization> authorization::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<authorization> res = make_tl_object<authorization>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->current_ = (var0 & 1) != 0;
  res->official_app_ = (var0 & 2) != 0;
  res->password_pending_ = (var0 & 4) != 0;
  res->encrypted_requests_disabled_ = (var0 & 8) != 0;
  res->call_requests_disabled_ = (var0 & 16) != 0;
  res->unconfirmed_ = (var0 & 32) != 0;
  res->hash_ = TlFetchLong::parse(p);
  res->device_model_ = TlFetchString<string>::parse(p);
  res->platform_ = TlFetchString<string>::parse(p);
  res->system_version_ = TlFetchString<string>::parse(p);
  res->api_id_ = TlFetchInt::parse(p);
  res->app_name_ = TlFetchString<string>::parse(p);
  res->app_version_ = TlFetchString<string>::parse(p);
  res->date_created_ = TlFetchInt::parse(p);
  res->date_active_ = TlFetchInt::parse(p);
  res->ip_ = TlFetchString<string>::parse(p);
  res->country_ = TlFetchString<string>::parse(p);
  res->region_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void authorization::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorization");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (current_ << 0) | (official_app_ << 1) | (password_pending_ << 2) | (encrypted_requests_disabled_ << 3) | (call_requests_disabled_ << 4) | (unconfirmed_ << 5)));
    if (var0 & 1) { s.store_field("current", true); }
    if (var0 & 2) { s.store_field("official_app", true); }
    if (var0 & 4) { s.store_field("password_pending", true); }
    if (var0 & 8) { s.store_field("encrypted_requests_disabled", true); }
    if (var0 & 16) { s.store_field("call_requests_disabled", true); }
    if (var0 & 32) { s.store_field("unconfirmed", true); }
    s.store_field("hash", hash_);
    s.store_field("device_model", device_model_);
    s.store_field("platform", platform_);
    s.store_field("system_version", system_version_);
    s.store_field("api_id", api_id_);
    s.store_field("app_name", app_name_);
    s.store_field("app_version", app_version_);
    s.store_field("date_created", date_created_);
    s.store_field("date_active", date_active_);
    s.store_field("ip", ip_);
    s.store_field("country", country_);
    s.store_field("region", region_);
    s.store_class_end();
  }
}

autoDownloadSettings::autoDownloadSettings()
  : flags_()
  , disabled_()
  , video_preload_large_()
  , audio_preload_next_()
  , phonecalls_less_data_()
  , stories_preload_()
  , photo_size_max_()
  , video_size_max_()
  , file_size_max_()
  , video_upload_maxbitrate_()
  , small_queue_active_operations_max_()
  , large_queue_active_operations_max_()
{}

autoDownloadSettings::autoDownloadSettings(int32 flags_, bool disabled_, bool video_preload_large_, bool audio_preload_next_, bool phonecalls_less_data_, bool stories_preload_, int32 photo_size_max_, int64 video_size_max_, int64 file_size_max_, int32 video_upload_maxbitrate_, int32 small_queue_active_operations_max_, int32 large_queue_active_operations_max_)
  : flags_(flags_)
  , disabled_(disabled_)
  , video_preload_large_(video_preload_large_)
  , audio_preload_next_(audio_preload_next_)
  , phonecalls_less_data_(phonecalls_less_data_)
  , stories_preload_(stories_preload_)
  , photo_size_max_(photo_size_max_)
  , video_size_max_(video_size_max_)
  , file_size_max_(file_size_max_)
  , video_upload_maxbitrate_(video_upload_maxbitrate_)
  , small_queue_active_operations_max_(small_queue_active_operations_max_)
  , large_queue_active_operations_max_(large_queue_active_operations_max_)
{}

const std::int32_t autoDownloadSettings::ID;

object_ptr<autoDownloadSettings> autoDownloadSettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<autoDownloadSettings> res = make_tl_object<autoDownloadSettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->disabled_ = (var0 & 1) != 0;
  res->video_preload_large_ = (var0 & 2) != 0;
  res->audio_preload_next_ = (var0 & 4) != 0;
  res->phonecalls_less_data_ = (var0 & 8) != 0;
  res->stories_preload_ = (var0 & 16) != 0;
  res->photo_size_max_ = TlFetchInt::parse(p);
  res->video_size_max_ = TlFetchLong::parse(p);
  res->file_size_max_ = TlFetchLong::parse(p);
  res->video_upload_maxbitrate_ = TlFetchInt::parse(p);
  res->small_queue_active_operations_max_ = TlFetchInt::parse(p);
  res->large_queue_active_operations_max_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void autoDownloadSettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (disabled_ << 0) | (video_preload_large_ << 1) | (audio_preload_next_ << 2) | (phonecalls_less_data_ << 3) | (stories_preload_ << 4)), s);
  TlStoreBinary::store(photo_size_max_, s);
  TlStoreBinary::store(video_size_max_, s);
  TlStoreBinary::store(file_size_max_, s);
  TlStoreBinary::store(video_upload_maxbitrate_, s);
  TlStoreBinary::store(small_queue_active_operations_max_, s);
  TlStoreBinary::store(large_queue_active_operations_max_, s);
}

void autoDownloadSettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (disabled_ << 0) | (video_preload_large_ << 1) | (audio_preload_next_ << 2) | (phonecalls_less_data_ << 3) | (stories_preload_ << 4)), s);
  TlStoreBinary::store(photo_size_max_, s);
  TlStoreBinary::store(video_size_max_, s);
  TlStoreBinary::store(file_size_max_, s);
  TlStoreBinary::store(video_upload_maxbitrate_, s);
  TlStoreBinary::store(small_queue_active_operations_max_, s);
  TlStoreBinary::store(large_queue_active_operations_max_, s);
}

void autoDownloadSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autoDownloadSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (disabled_ << 0) | (video_preload_large_ << 1) | (audio_preload_next_ << 2) | (phonecalls_less_data_ << 3) | (stories_preload_ << 4)));
    if (var0 & 1) { s.store_field("disabled", true); }
    if (var0 & 2) { s.store_field("video_preload_large", true); }
    if (var0 & 4) { s.store_field("audio_preload_next", true); }
    if (var0 & 8) { s.store_field("phonecalls_less_data", true); }
    if (var0 & 16) { s.store_field("stories_preload", true); }
    s.store_field("photo_size_max", photo_size_max_);
    s.store_field("video_size_max", video_size_max_);
    s.store_field("file_size_max", file_size_max_);
    s.store_field("video_upload_maxbitrate", video_upload_maxbitrate_);
    s.store_field("small_queue_active_operations_max", small_queue_active_operations_max_);
    s.store_field("large_queue_active_operations_max", large_queue_active_operations_max_);
    s.store_class_end();
  }
}

const std::int32_t autoSaveException::ID;

object_ptr<autoSaveException> autoSaveException::fetch(TlBufferParser &p) {
  return make_tl_object<autoSaveException>(p);
}

autoSaveException::autoSaveException(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , settings_(TlFetchBoxed<TlFetchObject<autoSaveSettings>, -934791986>::parse(p))
{}

void autoSaveException::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autoSaveException");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_object_field("settings", static_cast<const BaseObject *>(settings_.get()));
    s.store_class_end();
  }
}

autoSaveSettings::autoSaveSettings()
  : flags_()
  , photos_()
  , videos_()
  , video_max_size_()
{}

autoSaveSettings::autoSaveSettings(int32 flags_, bool photos_, bool videos_, int64 video_max_size_)
  : flags_(flags_)
  , photos_(photos_)
  , videos_(videos_)
  , video_max_size_(video_max_size_)
{}

const std::int32_t autoSaveSettings::ID;

object_ptr<autoSaveSettings> autoSaveSettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<autoSaveSettings> res = make_tl_object<autoSaveSettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->photos_ = (var0 & 1) != 0;
  res->videos_ = (var0 & 2) != 0;
  if (var0 & 4) { res->video_max_size_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void autoSaveSettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (photos_ << 0) | (videos_ << 1)), s);
  if (var0 & 4) { TlStoreBinary::store(video_max_size_, s); }
}

void autoSaveSettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (photos_ << 0) | (videos_ << 1)), s);
  if (var0 & 4) { TlStoreBinary::store(video_max_size_, s); }
}

void autoSaveSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autoSaveSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (photos_ << 0) | (videos_ << 1)));
    if (var0 & 1) { s.store_field("photos", true); }
    if (var0 & 2) { s.store_field("videos", true); }
    if (var0 & 4) { s.store_field("video_max_size", video_max_size_); }
    s.store_class_end();
  }
}

availableEffect::availableEffect()
  : flags_()
  , premium_required_()
  , id_()
  , emoticon_()
  , static_icon_id_()
  , effect_sticker_id_()
  , effect_animation_id_()
{}

const std::int32_t availableEffect::ID;

object_ptr<availableEffect> availableEffect::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<availableEffect> res = make_tl_object<availableEffect>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->premium_required_ = (var0 & 4) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->emoticon_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->static_icon_id_ = TlFetchLong::parse(p); }
  res->effect_sticker_id_ = TlFetchLong::parse(p);
  if (var0 & 2) { res->effect_animation_id_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void availableEffect::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "availableEffect");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (premium_required_ << 2)));
    if (var0 & 4) { s.store_field("premium_required", true); }
    s.store_field("id", id_);
    s.store_field("emoticon", emoticon_);
    if (var0 & 1) { s.store_field("static_icon_id", static_icon_id_); }
    s.store_field("effect_sticker_id", effect_sticker_id_);
    if (var0 & 2) { s.store_field("effect_animation_id", effect_animation_id_); }
    s.store_class_end();
  }
}

availableReaction::availableReaction()
  : flags_()
  , inactive_()
  , premium_()
  , reaction_()
  , title_()
  , static_icon_()
  , appear_animation_()
  , select_animation_()
  , activate_animation_()
  , effect_animation_()
  , around_animation_()
  , center_icon_()
{}

const std::int32_t availableReaction::ID;

object_ptr<availableReaction> availableReaction::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<availableReaction> res = make_tl_object<availableReaction>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->inactive_ = (var0 & 1) != 0;
  res->premium_ = (var0 & 4) != 0;
  res->reaction_ = TlFetchString<string>::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->static_icon_ = TlFetchObject<Document>::parse(p);
  res->appear_animation_ = TlFetchObject<Document>::parse(p);
  res->select_animation_ = TlFetchObject<Document>::parse(p);
  res->activate_animation_ = TlFetchObject<Document>::parse(p);
  res->effect_animation_ = TlFetchObject<Document>::parse(p);
  if (var0 & 2) { res->around_animation_ = TlFetchObject<Document>::parse(p); }
  if (var0 & 2) { res->center_icon_ = TlFetchObject<Document>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void availableReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "availableReaction");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (inactive_ << 0) | (premium_ << 2)));
    if (var0 & 1) { s.store_field("inactive", true); }
    if (var0 & 4) { s.store_field("premium", true); }
    s.store_field("reaction", reaction_);
    s.store_field("title", title_);
    s.store_object_field("static_icon", static_cast<const BaseObject *>(static_icon_.get()));
    s.store_object_field("appear_animation", static_cast<const BaseObject *>(appear_animation_.get()));
    s.store_object_field("select_animation", static_cast<const BaseObject *>(select_animation_.get()));
    s.store_object_field("activate_animation", static_cast<const BaseObject *>(activate_animation_.get()));
    s.store_object_field("effect_animation", static_cast<const BaseObject *>(effect_animation_.get()));
    if (var0 & 2) { s.store_object_field("around_animation", static_cast<const BaseObject *>(around_animation_.get())); }
    if (var0 & 2) { s.store_object_field("center_icon", static_cast<const BaseObject *>(center_icon_.get())); }
    s.store_class_end();
  }
}

const std::int32_t bankCardOpenUrl::ID;

object_ptr<bankCardOpenUrl> bankCardOpenUrl::fetch(TlBufferParser &p) {
  return make_tl_object<bankCardOpenUrl>(p);
}

bankCardOpenUrl::bankCardOpenUrl(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
  , name_(TlFetchString<string>::parse(p))
{}

void bankCardOpenUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "bankCardOpenUrl");
    s.store_field("url", url_);
    s.store_field("name", name_);
    s.store_class_end();
  }
}

object_ptr<BaseTheme> BaseTheme::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case baseThemeClassic::ID:
      return baseThemeClassic::fetch(p);
    case baseThemeDay::ID:
      return baseThemeDay::fetch(p);
    case baseThemeNight::ID:
      return baseThemeNight::fetch(p);
    case baseThemeTinted::ID:
      return baseThemeTinted::fetch(p);
    case baseThemeArctic::ID:
      return baseThemeArctic::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t baseThemeClassic::ID;

object_ptr<BaseTheme> baseThemeClassic::fetch(TlBufferParser &p) {
  return make_tl_object<baseThemeClassic>();
}

void baseThemeClassic::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void baseThemeClassic::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void baseThemeClassic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "baseThemeClassic");
    s.store_class_end();
  }
}

const std::int32_t baseThemeDay::ID;

object_ptr<BaseTheme> baseThemeDay::fetch(TlBufferParser &p) {
  return make_tl_object<baseThemeDay>();
}

void baseThemeDay::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void baseThemeDay::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void baseThemeDay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "baseThemeDay");
    s.store_class_end();
  }
}

const std::int32_t baseThemeNight::ID;

object_ptr<BaseTheme> baseThemeNight::fetch(TlBufferParser &p) {
  return make_tl_object<baseThemeNight>();
}

void baseThemeNight::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void baseThemeNight::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void baseThemeNight::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "baseThemeNight");
    s.store_class_end();
  }
}

const std::int32_t baseThemeTinted::ID;

object_ptr<BaseTheme> baseThemeTinted::fetch(TlBufferParser &p) {
  return make_tl_object<baseThemeTinted>();
}

void baseThemeTinted::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void baseThemeTinted::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void baseThemeTinted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "baseThemeTinted");
    s.store_class_end();
  }
}

const std::int32_t baseThemeArctic::ID;

object_ptr<BaseTheme> baseThemeArctic::fetch(TlBufferParser &p) {
  return make_tl_object<baseThemeArctic>();
}

void baseThemeArctic::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void baseThemeArctic::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void baseThemeArctic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "baseThemeArctic");
    s.store_class_end();
  }
}

birthday::birthday()
  : flags_()
  , day_()
  , month_()
  , year_()
{}

birthday::birthday(int32 flags_, int32 day_, int32 month_, int32 year_)
  : flags_(flags_)
  , day_(day_)
  , month_(month_)
  , year_(year_)
{}

const std::int32_t birthday::ID;

object_ptr<birthday> birthday::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<birthday> res = make_tl_object<birthday>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->day_ = TlFetchInt::parse(p);
  res->month_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->year_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void birthday::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(day_, s);
  TlStoreBinary::store(month_, s);
  if (var0 & 1) { TlStoreBinary::store(year_, s); }
}

void birthday::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(day_, s);
  TlStoreBinary::store(month_, s);
  if (var0 & 1) { TlStoreBinary::store(year_, s); }
}

void birthday::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "birthday");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("day", day_);
    s.store_field("month", month_);
    if (var0 & 1) { s.store_field("year", year_); }
    s.store_class_end();
  }
}

boost::boost()
  : flags_()
  , gift_()
  , giveaway_()
  , unclaimed_()
  , id_()
  , user_id_()
  , giveaway_msg_id_()
  , date_()
  , expires_()
  , used_gift_slug_()
  , multiplier_()
  , stars_()
{}

const std::int32_t boost::ID;

object_ptr<boost> boost::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<boost> res = make_tl_object<boost>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->gift_ = (var0 & 2) != 0;
  res->giveaway_ = (var0 & 4) != 0;
  res->unclaimed_ = (var0 & 8) != 0;
  res->id_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->user_id_ = TlFetchLong::parse(p); }
  if (var0 & 4) { res->giveaway_msg_id_ = TlFetchInt::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  res->expires_ = TlFetchInt::parse(p);
  if (var0 & 16) { res->used_gift_slug_ = TlFetchString<string>::parse(p); }
  if (var0 & 32) { res->multiplier_ = TlFetchInt::parse(p); }
  if (var0 & 64) { res->stars_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void boost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "boost");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (gift_ << 1) | (giveaway_ << 2) | (unclaimed_ << 3)));
    if (var0 & 2) { s.store_field("gift", true); }
    if (var0 & 4) { s.store_field("giveaway", true); }
    if (var0 & 8) { s.store_field("unclaimed", true); }
    s.store_field("id", id_);
    if (var0 & 1) { s.store_field("user_id", user_id_); }
    if (var0 & 4) { s.store_field("giveaway_msg_id", giveaway_msg_id_); }
    s.store_field("date", date_);
    s.store_field("expires", expires_);
    if (var0 & 16) { s.store_field("used_gift_slug", used_gift_slug_); }
    if (var0 & 32) { s.store_field("multiplier", multiplier_); }
    if (var0 & 64) { s.store_field("stars", stars_); }
    s.store_class_end();
  }
}

object_ptr<BotApp> BotApp::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case botAppNotModified::ID:
      return botAppNotModified::fetch(p);
    case botApp::ID:
      return botApp::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t botAppNotModified::ID;

object_ptr<BotApp> botAppNotModified::fetch(TlBufferParser &p) {
  return make_tl_object<botAppNotModified>();
}

void botAppNotModified::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botAppNotModified");
    s.store_class_end();
  }
}

botApp::botApp()
  : flags_()
  , id_()
  , access_hash_()
  , short_name_()
  , title_()
  , description_()
  , photo_()
  , document_()
  , hash_()
{}

const std::int32_t botApp::ID;

object_ptr<BotApp> botApp::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botApp> res = make_tl_object<botApp>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchLong::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->short_name_ = TlFetchString<string>::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  res->photo_ = TlFetchObject<Photo>::parse(p);
  if (var0 & 1) { res->document_ = TlFetchObject<Document>::parse(p); }
  res->hash_ = TlFetchLong::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botApp");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("short_name", short_name_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    if (var0 & 1) { s.store_object_field("document", static_cast<const BaseObject *>(document_.get())); }
    s.store_field("hash", hash_);
    s.store_class_end();
  }
}

botAppSettings::botAppSettings()
  : flags_()
  , placeholder_path_()
  , background_color_()
  , background_dark_color_()
  , header_color_()
  , header_dark_color_()
{}

const std::int32_t botAppSettings::ID;

object_ptr<botAppSettings> botAppSettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botAppSettings> res = make_tl_object<botAppSettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->placeholder_path_ = TlFetchBytes<bytes>::parse(p); }
  if (var0 & 2) { res->background_color_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->background_dark_color_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->header_color_ = TlFetchInt::parse(p); }
  if (var0 & 16) { res->header_dark_color_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void botAppSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botAppSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_bytes_field("placeholder_path", placeholder_path_); }
    if (var0 & 2) { s.store_field("background_color", background_color_); }
    if (var0 & 4) { s.store_field("background_dark_color", background_dark_color_); }
    if (var0 & 8) { s.store_field("header_color", header_color_); }
    if (var0 & 16) { s.store_field("header_dark_color", header_dark_color_); }
    s.store_class_end();
  }
}

botBusinessConnection::botBusinessConnection()
  : flags_()
  , disabled_()
  , connection_id_()
  , user_id_()
  , dc_id_()
  , date_()
  , rights_()
{}

const std::int32_t botBusinessConnection::ID;

object_ptr<botBusinessConnection> botBusinessConnection::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botBusinessConnection> res = make_tl_object<botBusinessConnection>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->disabled_ = (var0 & 2) != 0;
  res->connection_id_ = TlFetchString<string>::parse(p);
  res->user_id_ = TlFetchLong::parse(p);
  res->dc_id_ = TlFetchInt::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 4) { res->rights_ = TlFetchBoxed<TlFetchObject<businessBotRights>, -1604170505>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void botBusinessConnection::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botBusinessConnection");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (disabled_ << 1)));
    if (var0 & 2) { s.store_field("disabled", true); }
    s.store_field("connection_id", connection_id_);
    s.store_field("user_id", user_id_);
    s.store_field("dc_id", dc_id_);
    s.store_field("date", date_);
    if (var0 & 4) { s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get())); }
    s.store_class_end();
  }
}

botCommand::botCommand(string const &command_, string const &description_)
  : command_(command_)
  , description_(description_)
{}

const std::int32_t botCommand::ID;

object_ptr<botCommand> botCommand::fetch(TlBufferParser &p) {
  return make_tl_object<botCommand>(p);
}

botCommand::botCommand(TlBufferParser &p)
  : command_(TlFetchString<string>::parse(p))
  , description_(TlFetchString<string>::parse(p))
{}

void botCommand::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(command_, s);
  TlStoreString::store(description_, s);
}

void botCommand::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(command_, s);
  TlStoreString::store(description_, s);
}

void botCommand::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommand");
    s.store_field("command", command_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

const std::int32_t botCommandScopeDefault::ID;

void botCommandScopeDefault::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botCommandScopeDefault::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botCommandScopeDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeDefault");
    s.store_class_end();
  }
}

const std::int32_t botCommandScopeUsers::ID;

void botCommandScopeUsers::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botCommandScopeUsers::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botCommandScopeUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeUsers");
    s.store_class_end();
  }
}

const std::int32_t botCommandScopeChats::ID;

void botCommandScopeChats::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botCommandScopeChats::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botCommandScopeChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeChats");
    s.store_class_end();
  }
}

const std::int32_t botCommandScopeChatAdmins::ID;

void botCommandScopeChatAdmins::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botCommandScopeChatAdmins::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botCommandScopeChatAdmins::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeChatAdmins");
    s.store_class_end();
  }
}

botCommandScopePeer::botCommandScopePeer(object_ptr<InputPeer> &&peer_)
  : peer_(std::move(peer_))
{}

const std::int32_t botCommandScopePeer::ID;

void botCommandScopePeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void botCommandScopePeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void botCommandScopePeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopePeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

botCommandScopePeerAdmins::botCommandScopePeerAdmins(object_ptr<InputPeer> &&peer_)
  : peer_(std::move(peer_))
{}

const std::int32_t botCommandScopePeerAdmins::ID;

void botCommandScopePeerAdmins::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void botCommandScopePeerAdmins::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void botCommandScopePeerAdmins::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopePeerAdmins");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

botCommandScopePeerUser::botCommandScopePeerUser(object_ptr<InputPeer> &&peer_, object_ptr<InputUser> &&user_id_)
  : peer_(std::move(peer_))
  , user_id_(std::move(user_id_))
{}

const std::int32_t botCommandScopePeerUser::ID;

void botCommandScopePeerUser::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void botCommandScopePeerUser::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void botCommandScopePeerUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopePeerUser");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_class_end();
  }
}

botInfo::botInfo()
  : flags_()
  , has_preview_medias_()
  , user_id_()
  , description_()
  , description_photo_()
  , description_document_()
  , commands_()
  , menu_button_()
  , privacy_policy_url_()
  , app_settings_()
  , verifier_settings_()
{}

const std::int32_t botInfo::ID;

object_ptr<botInfo> botInfo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInfo> res = make_tl_object<botInfo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->has_preview_medias_ = (var0 & 64) != 0;
  if (var0 & 1) { res->user_id_ = TlFetchLong::parse(p); }
  if (var0 & 2) { res->description_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->description_photo_ = TlFetchObject<Photo>::parse(p); }
  if (var0 & 32) { res->description_document_ = TlFetchObject<Document>::parse(p); }
  if (var0 & 4) { res->commands_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<botCommand>, -1032140601>>, 481674261>::parse(p); }
  if (var0 & 8) { res->menu_button_ = TlFetchObject<BotMenuButton>::parse(p); }
  if (var0 & 128) { res->privacy_policy_url_ = TlFetchString<string>::parse(p); }
  if (var0 & 256) { res->app_settings_ = TlFetchBoxed<TlFetchObject<botAppSettings>, -912582320>::parse(p); }
  if (var0 & 512) { res->verifier_settings_ = TlFetchBoxed<TlFetchObject<botVerifierSettings>, -1328716265>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void botInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInfo");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (has_preview_medias_ << 6)));
    if (var0 & 64) { s.store_field("has_preview_medias", true); }
    if (var0 & 1) { s.store_field("user_id", user_id_); }
    if (var0 & 2) { s.store_field("description", description_); }
    if (var0 & 16) { s.store_object_field("description_photo", static_cast<const BaseObject *>(description_photo_.get())); }
    if (var0 & 32) { s.store_object_field("description_document", static_cast<const BaseObject *>(description_document_.get())); }
    if (var0 & 4) { { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 8) { s.store_object_field("menu_button", static_cast<const BaseObject *>(menu_button_.get())); }
    if (var0 & 128) { s.store_field("privacy_policy_url", privacy_policy_url_); }
    if (var0 & 256) { s.store_object_field("app_settings", static_cast<const BaseObject *>(app_settings_.get())); }
    if (var0 & 512) { s.store_object_field("verifier_settings", static_cast<const BaseObject *>(verifier_settings_.get())); }
    s.store_class_end();
  }
}

object_ptr<BotInlineMessage> BotInlineMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case botInlineMessageMediaAuto::ID:
      return botInlineMessageMediaAuto::fetch(p);
    case botInlineMessageText::ID:
      return botInlineMessageText::fetch(p);
    case botInlineMessageMediaGeo::ID:
      return botInlineMessageMediaGeo::fetch(p);
    case botInlineMessageMediaVenue::ID:
      return botInlineMessageMediaVenue::fetch(p);
    case botInlineMessageMediaContact::ID:
      return botInlineMessageMediaContact::fetch(p);
    case botInlineMessageMediaInvoice::ID:
      return botInlineMessageMediaInvoice::fetch(p);
    case botInlineMessageMediaWebPage::ID:
      return botInlineMessageMediaWebPage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

botInlineMessageMediaAuto::botInlineMessageMediaAuto()
  : flags_()
  , invert_media_()
  , message_()
  , entities_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaAuto::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaAuto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaAuto> res = make_tl_object<botInlineMessageMediaAuto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->invert_media_ = (var0 & 8) != 0;
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaAuto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaAuto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (invert_media_ << 3)));
    if (var0 & 8) { s.store_field("invert_media", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageText::botInlineMessageText()
  : flags_()
  , no_webpage_()
  , invert_media_()
  , message_()
  , entities_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageText::ID;

object_ptr<BotInlineMessage> botInlineMessageText::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageText> res = make_tl_object<botInlineMessageText>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->no_webpage_ = (var0 & 1) != 0;
  res->invert_media_ = (var0 & 8) != 0;
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageText");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (no_webpage_ << 0) | (invert_media_ << 3)));
    if (var0 & 1) { s.store_field("no_webpage", true); }
    if (var0 & 8) { s.store_field("invert_media", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageMediaGeo::botInlineMessageMediaGeo()
  : flags_()
  , geo_()
  , heading_()
  , period_()
  , proximity_notification_radius_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaGeo::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaGeo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaGeo> res = make_tl_object<botInlineMessageMediaGeo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->geo_ = TlFetchObject<GeoPoint>::parse(p);
  if (var0 & 1) { res->heading_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->period_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->proximity_notification_radius_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaGeo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaGeo");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    if (var0 & 1) { s.store_field("heading", heading_); }
    if (var0 & 2) { s.store_field("period", period_); }
    if (var0 & 8) { s.store_field("proximity_notification_radius", proximity_notification_radius_); }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageMediaVenue::botInlineMessageMediaVenue()
  : flags_()
  , geo_()
  , title_()
  , address_()
  , provider_()
  , venue_id_()
  , venue_type_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaVenue::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaVenue::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaVenue> res = make_tl_object<botInlineMessageMediaVenue>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->geo_ = TlFetchObject<GeoPoint>::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->address_ = TlFetchString<string>::parse(p);
  res->provider_ = TlFetchString<string>::parse(p);
  res->venue_id_ = TlFetchString<string>::parse(p);
  res->venue_type_ = TlFetchString<string>::parse(p);
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaVenue");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    s.store_field("title", title_);
    s.store_field("address", address_);
    s.store_field("provider", provider_);
    s.store_field("venue_id", venue_id_);
    s.store_field("venue_type", venue_type_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageMediaContact::botInlineMessageMediaContact()
  : flags_()
  , phone_number_()
  , first_name_()
  , last_name_()
  , vcard_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaContact::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaContact::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaContact> res = make_tl_object<botInlineMessageMediaContact>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->phone_number_ = TlFetchString<string>::parse(p);
  res->first_name_ = TlFetchString<string>::parse(p);
  res->last_name_ = TlFetchString<string>::parse(p);
  res->vcard_ = TlFetchString<string>::parse(p);
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaContact");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("phone_number", phone_number_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("vcard", vcard_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageMediaInvoice::botInlineMessageMediaInvoice()
  : flags_()
  , shipping_address_requested_()
  , test_()
  , title_()
  , description_()
  , photo_()
  , currency_()
  , total_amount_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaInvoice::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaInvoice::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaInvoice> res = make_tl_object<botInlineMessageMediaInvoice>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->shipping_address_requested_ = (var0 & 2) != 0;
  res->test_ = (var0 & 8) != 0;
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->photo_ = TlFetchObject<WebDocument>::parse(p); }
  res->currency_ = TlFetchString<string>::parse(p);
  res->total_amount_ = TlFetchLong::parse(p);
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaInvoice");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (shipping_address_requested_ << 1) | (test_ << 3)));
    if (var0 & 2) { s.store_field("shipping_address_requested", true); }
    if (var0 & 8) { s.store_field("test", true); }
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

botInlineMessageMediaWebPage::botInlineMessageMediaWebPage()
  : flags_()
  , invert_media_()
  , force_large_media_()
  , force_small_media_()
  , manual_()
  , safe_()
  , message_()
  , entities_()
  , url_()
  , reply_markup_()
{}

const std::int32_t botInlineMessageMediaWebPage::ID;

object_ptr<BotInlineMessage> botInlineMessageMediaWebPage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMessageMediaWebPage> res = make_tl_object<botInlineMessageMediaWebPage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->invert_media_ = (var0 & 8) != 0;
  res->force_large_media_ = (var0 & 16) != 0;
  res->force_small_media_ = (var0 & 32) != 0;
  res->manual_ = (var0 & 128) != 0;
  res->safe_ = (var0 & 256) != 0;
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  res->url_ = TlFetchString<string>::parse(p);
  if (var0 & 4) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMessageMediaWebPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMessageMediaWebPage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (invert_media_ << 3) | (force_large_media_ << 4) | (force_small_media_ << 5) | (manual_ << 7) | (safe_ << 8)));
    if (var0 & 8) { s.store_field("invert_media", true); }
    if (var0 & 16) { s.store_field("force_large_media", true); }
    if (var0 & 32) { s.store_field("force_small_media", true); }
    if (var0 & 128) { s.store_field("manual", true); }
    if (var0 & 256) { s.store_field("safe", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_field("url", url_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

object_ptr<BotInlineResult> BotInlineResult::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case botInlineResult::ID:
      return botInlineResult::fetch(p);
    case botInlineMediaResult::ID:
      return botInlineMediaResult::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

botInlineResult::botInlineResult()
  : flags_()
  , id_()
  , type_()
  , title_()
  , description_()
  , url_()
  , thumb_()
  , content_()
  , send_message_()
{}

const std::int32_t botInlineResult::ID;

object_ptr<BotInlineResult> botInlineResult::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineResult> res = make_tl_object<botInlineResult>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchString<string>::parse(p);
  res->type_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->description_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->url_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->thumb_ = TlFetchObject<WebDocument>::parse(p); }
  if (var0 & 32) { res->content_ = TlFetchObject<WebDocument>::parse(p); }
  res->send_message_ = TlFetchObject<BotInlineMessage>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineResult::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineResult");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("type", type_);
    if (var0 & 2) { s.store_field("title", title_); }
    if (var0 & 4) { s.store_field("description", description_); }
    if (var0 & 8) { s.store_field("url", url_); }
    if (var0 & 16) { s.store_object_field("thumb", static_cast<const BaseObject *>(thumb_.get())); }
    if (var0 & 32) { s.store_object_field("content", static_cast<const BaseObject *>(content_.get())); }
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

botInlineMediaResult::botInlineMediaResult()
  : flags_()
  , id_()
  , type_()
  , photo_()
  , document_()
  , title_()
  , description_()
  , send_message_()
{}

const std::int32_t botInlineMediaResult::ID;

object_ptr<BotInlineResult> botInlineMediaResult::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botInlineMediaResult> res = make_tl_object<botInlineMediaResult>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchString<string>::parse(p);
  res->type_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->photo_ = TlFetchObject<Photo>::parse(p); }
  if (var0 & 2) { res->document_ = TlFetchObject<Document>::parse(p); }
  if (var0 & 4) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->description_ = TlFetchString<string>::parse(p); }
  res->send_message_ = TlFetchObject<BotInlineMessage>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void botInlineMediaResult::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInlineMediaResult");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("type", type_);
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    if (var0 & 2) { s.store_object_field("document", static_cast<const BaseObject *>(document_.get())); }
    if (var0 & 4) { s.store_field("title", title_); }
    if (var0 & 8) { s.store_field("description", description_); }
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

object_ptr<BotMenuButton> BotMenuButton::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case botMenuButtonDefault::ID:
      return botMenuButtonDefault::fetch(p);
    case botMenuButtonCommands::ID:
      return botMenuButtonCommands::fetch(p);
    case botMenuButton::ID:
      return botMenuButton::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t botMenuButtonDefault::ID;

object_ptr<BotMenuButton> botMenuButtonDefault::fetch(TlBufferParser &p) {
  return make_tl_object<botMenuButtonDefault>();
}

void botMenuButtonDefault::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botMenuButtonDefault::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botMenuButtonDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMenuButtonDefault");
    s.store_class_end();
  }
}

const std::int32_t botMenuButtonCommands::ID;

object_ptr<BotMenuButton> botMenuButtonCommands::fetch(TlBufferParser &p) {
  return make_tl_object<botMenuButtonCommands>();
}

void botMenuButtonCommands::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void botMenuButtonCommands::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void botMenuButtonCommands::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMenuButtonCommands");
    s.store_class_end();
  }
}

botMenuButton::botMenuButton(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t botMenuButton::ID;

object_ptr<BotMenuButton> botMenuButton::fetch(TlBufferParser &p) {
  return make_tl_object<botMenuButton>(p);
}

botMenuButton::botMenuButton(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void botMenuButton::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void botMenuButton::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void botMenuButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMenuButton");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

const std::int32_t botPreviewMedia::ID;

object_ptr<botPreviewMedia> botPreviewMedia::fetch(TlBufferParser &p) {
  return make_tl_object<botPreviewMedia>(p);
}

botPreviewMedia::botPreviewMedia(TlBufferParser &p)
  : date_(TlFetchInt::parse(p))
  , media_(TlFetchObject<MessageMedia>::parse(p))
{}

void botPreviewMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botPreviewMedia");
    s.store_field("date", date_);
    s.store_object_field("media", static_cast<const BaseObject *>(media_.get()));
    s.store_class_end();
  }
}

const std::int32_t botVerification::ID;

object_ptr<botVerification> botVerification::fetch(TlBufferParser &p) {
  return make_tl_object<botVerification>(p);
}

botVerification::botVerification(TlBufferParser &p)
  : bot_id_(TlFetchLong::parse(p))
  , icon_(TlFetchLong::parse(p))
  , description_(TlFetchString<string>::parse(p))
{}

void botVerification::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botVerification");
    s.store_field("bot_id", bot_id_);
    s.store_field("icon", icon_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

botVerifierSettings::botVerifierSettings()
  : flags_()
  , can_modify_custom_description_()
  , icon_()
  , company_()
  , custom_description_()
{}

const std::int32_t botVerifierSettings::ID;

object_ptr<botVerifierSettings> botVerifierSettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<botVerifierSettings> res = make_tl_object<botVerifierSettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->can_modify_custom_description_ = (var0 & 2) != 0;
  res->icon_ = TlFetchLong::parse(p);
  res->company_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->custom_description_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void botVerifierSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botVerifierSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (can_modify_custom_description_ << 1)));
    if (var0 & 2) { s.store_field("can_modify_custom_description", true); }
    s.store_field("icon", icon_);
    s.store_field("company", company_);
    if (var0 & 1) { s.store_field("custom_description", custom_description_); }
    s.store_class_end();
  }
}

businessAwayMessage::businessAwayMessage()
  : flags_()
  , offline_only_()
  , shortcut_id_()
  , schedule_()
  , recipients_()
{}

const std::int32_t businessAwayMessage::ID;

object_ptr<businessAwayMessage> businessAwayMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessAwayMessage> res = make_tl_object<businessAwayMessage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->offline_only_ = (var0 & 1) != 0;
  res->shortcut_id_ = TlFetchInt::parse(p);
  res->schedule_ = TlFetchObject<BusinessAwayMessageSchedule>::parse(p);
  res->recipients_ = TlFetchBoxed<TlFetchObject<businessRecipients>, 554733559>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessAwayMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (offline_only_ << 0)));
    if (var0 & 1) { s.store_field("offline_only", true); }
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("schedule", static_cast<const BaseObject *>(schedule_.get()));
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_class_end();
  }
}

object_ptr<BusinessAwayMessageSchedule> BusinessAwayMessageSchedule::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case businessAwayMessageScheduleAlways::ID:
      return businessAwayMessageScheduleAlways::fetch(p);
    case businessAwayMessageScheduleOutsideWorkHours::ID:
      return businessAwayMessageScheduleOutsideWorkHours::fetch(p);
    case businessAwayMessageScheduleCustom::ID:
      return businessAwayMessageScheduleCustom::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t businessAwayMessageScheduleAlways::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleAlways::fetch(TlBufferParser &p) {
  return make_tl_object<businessAwayMessageScheduleAlways>();
}

void businessAwayMessageScheduleAlways::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void businessAwayMessageScheduleAlways::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void businessAwayMessageScheduleAlways::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleAlways");
    s.store_class_end();
  }
}

const std::int32_t businessAwayMessageScheduleOutsideWorkHours::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleOutsideWorkHours::fetch(TlBufferParser &p) {
  return make_tl_object<businessAwayMessageScheduleOutsideWorkHours>();
}

void businessAwayMessageScheduleOutsideWorkHours::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void businessAwayMessageScheduleOutsideWorkHours::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void businessAwayMessageScheduleOutsideWorkHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleOutsideWorkHours");
    s.store_class_end();
  }
}

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom(int32 start_date_, int32 end_date_)
  : start_date_(start_date_)
  , end_date_(end_date_)
{}

const std::int32_t businessAwayMessageScheduleCustom::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleCustom::fetch(TlBufferParser &p) {
  return make_tl_object<businessAwayMessageScheduleCustom>(p);
}

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom(TlBufferParser &p)
  : start_date_(TlFetchInt::parse(p))
  , end_date_(TlFetchInt::parse(p))
{}

void businessAwayMessageScheduleCustom::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(start_date_, s);
  TlStoreBinary::store(end_date_, s);
}

void businessAwayMessageScheduleCustom::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(start_date_, s);
  TlStoreBinary::store(end_date_, s);
}

void businessAwayMessageScheduleCustom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleCustom");
    s.store_field("start_date", start_date_);
    s.store_field("end_date", end_date_);
    s.store_class_end();
  }
}

businessBotRecipients::businessBotRecipients()
  : flags_()
  , existing_chats_()
  , new_chats_()
  , contacts_()
  , non_contacts_()
  , exclude_selected_()
  , users_()
  , exclude_users_()
{}

const std::int32_t businessBotRecipients::ID;

object_ptr<businessBotRecipients> businessBotRecipients::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessBotRecipients> res = make_tl_object<businessBotRecipients>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->existing_chats_ = (var0 & 1) != 0;
  res->new_chats_ = (var0 & 2) != 0;
  res->contacts_ = (var0 & 4) != 0;
  res->non_contacts_ = (var0 & 8) != 0;
  res->exclude_selected_ = (var0 & 32) != 0;
  if (var0 & 16) { res->users_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (var0 & 64) { res->exclude_users_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessBotRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessBotRecipients");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)));
    if (var0 & 1) { s.store_field("existing_chats", true); }
    if (var0 & 2) { s.store_field("new_chats", true); }
    if (var0 & 4) { s.store_field("contacts", true); }
    if (var0 & 8) { s.store_field("non_contacts", true); }
    if (var0 & 32) { s.store_field("exclude_selected", true); }
    if (var0 & 16) { { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 64) { { s.store_vector_begin("exclude_users", exclude_users_.size()); for (const auto &_value : exclude_users_) { s.store_field("", _value); } s.store_class_end(); } }
    s.store_class_end();
  }
}

businessBotRights::businessBotRights()
  : flags_()
  , reply_()
  , read_messages_()
  , delete_sent_messages_()
  , delete_received_messages_()
  , edit_name_()
  , edit_bio_()
  , edit_profile_photo_()
  , edit_username_()
  , view_gifts_()
  , sell_gifts_()
  , change_gift_settings_()
  , transfer_and_upgrade_gifts_()
  , transfer_stars_()
  , manage_stories_()
{}

businessBotRights::businessBotRights(int32 flags_, bool reply_, bool read_messages_, bool delete_sent_messages_, bool delete_received_messages_, bool edit_name_, bool edit_bio_, bool edit_profile_photo_, bool edit_username_, bool view_gifts_, bool sell_gifts_, bool change_gift_settings_, bool transfer_and_upgrade_gifts_, bool transfer_stars_, bool manage_stories_)
  : flags_(flags_)
  , reply_(reply_)
  , read_messages_(read_messages_)
  , delete_sent_messages_(delete_sent_messages_)
  , delete_received_messages_(delete_received_messages_)
  , edit_name_(edit_name_)
  , edit_bio_(edit_bio_)
  , edit_profile_photo_(edit_profile_photo_)
  , edit_username_(edit_username_)
  , view_gifts_(view_gifts_)
  , sell_gifts_(sell_gifts_)
  , change_gift_settings_(change_gift_settings_)
  , transfer_and_upgrade_gifts_(transfer_and_upgrade_gifts_)
  , transfer_stars_(transfer_stars_)
  , manage_stories_(manage_stories_)
{}

const std::int32_t businessBotRights::ID;

object_ptr<businessBotRights> businessBotRights::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessBotRights> res = make_tl_object<businessBotRights>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->reply_ = (var0 & 1) != 0;
  res->read_messages_ = (var0 & 2) != 0;
  res->delete_sent_messages_ = (var0 & 4) != 0;
  res->delete_received_messages_ = (var0 & 8) != 0;
  res->edit_name_ = (var0 & 16) != 0;
  res->edit_bio_ = (var0 & 32) != 0;
  res->edit_profile_photo_ = (var0 & 64) != 0;
  res->edit_username_ = (var0 & 128) != 0;
  res->view_gifts_ = (var0 & 256) != 0;
  res->sell_gifts_ = (var0 & 512) != 0;
  res->change_gift_settings_ = (var0 & 1024) != 0;
  res->transfer_and_upgrade_gifts_ = (var0 & 2048) != 0;
  res->transfer_stars_ = (var0 & 4096) != 0;
  res->manage_stories_ = (var0 & 8192) != 0;
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessBotRights::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (reply_ << 0) | (read_messages_ << 1) | (delete_sent_messages_ << 2) | (delete_received_messages_ << 3) | (edit_name_ << 4) | (edit_bio_ << 5) | (edit_profile_photo_ << 6) | (edit_username_ << 7) | (view_gifts_ << 8) | (sell_gifts_ << 9) | (change_gift_settings_ << 10) | (transfer_and_upgrade_gifts_ << 11) | (transfer_stars_ << 12) | (manage_stories_ << 13)), s);
}

void businessBotRights::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (reply_ << 0) | (read_messages_ << 1) | (delete_sent_messages_ << 2) | (delete_received_messages_ << 3) | (edit_name_ << 4) | (edit_bio_ << 5) | (edit_profile_photo_ << 6) | (edit_username_ << 7) | (view_gifts_ << 8) | (sell_gifts_ << 9) | (change_gift_settings_ << 10) | (transfer_and_upgrade_gifts_ << 11) | (transfer_stars_ << 12) | (manage_stories_ << 13)), s);
}

void businessBotRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessBotRights");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (reply_ << 0) | (read_messages_ << 1) | (delete_sent_messages_ << 2) | (delete_received_messages_ << 3) | (edit_name_ << 4) | (edit_bio_ << 5) | (edit_profile_photo_ << 6) | (edit_username_ << 7) | (view_gifts_ << 8) | (sell_gifts_ << 9) | (change_gift_settings_ << 10) | (transfer_and_upgrade_gifts_ << 11) | (transfer_stars_ << 12) | (manage_stories_ << 13)));
    if (var0 & 1) { s.store_field("reply", true); }
    if (var0 & 2) { s.store_field("read_messages", true); }
    if (var0 & 4) { s.store_field("delete_sent_messages", true); }
    if (var0 & 8) { s.store_field("delete_received_messages", true); }
    if (var0 & 16) { s.store_field("edit_name", true); }
    if (var0 & 32) { s.store_field("edit_bio", true); }
    if (var0 & 64) { s.store_field("edit_profile_photo", true); }
    if (var0 & 128) { s.store_field("edit_username", true); }
    if (var0 & 256) { s.store_field("view_gifts", true); }
    if (var0 & 512) { s.store_field("sell_gifts", true); }
    if (var0 & 1024) { s.store_field("change_gift_settings", true); }
    if (var0 & 2048) { s.store_field("transfer_and_upgrade_gifts", true); }
    if (var0 & 4096) { s.store_field("transfer_stars", true); }
    if (var0 & 8192) { s.store_field("manage_stories", true); }
    s.store_class_end();
  }
}

businessChatLink::businessChatLink()
  : flags_()
  , link_()
  , message_()
  , entities_()
  , title_()
  , views_()
{}

const std::int32_t businessChatLink::ID;

object_ptr<businessChatLink> businessChatLink::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessChatLink> res = make_tl_object<businessChatLink>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->link_ = TlFetchString<string>::parse(p);
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 2) { res->title_ = TlFetchString<string>::parse(p); }
  res->views_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessChatLink");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("link", link_);
    s.store_field("message", message_);
    if (var0 & 1) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 2) { s.store_field("title", title_); }
    s.store_field("views", views_);
    s.store_class_end();
  }
}

const std::int32_t businessGreetingMessage::ID;

object_ptr<businessGreetingMessage> businessGreetingMessage::fetch(TlBufferParser &p) {
  return make_tl_object<businessGreetingMessage>(p);
}

businessGreetingMessage::businessGreetingMessage(TlBufferParser &p)
  : shortcut_id_(TlFetchInt::parse(p))
  , recipients_(TlFetchBoxed<TlFetchObject<businessRecipients>, 554733559>::parse(p))
  , no_activity_days_(TlFetchInt::parse(p))
{}

void businessGreetingMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessGreetingMessage");
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_field("no_activity_days", no_activity_days_);
    s.store_class_end();
  }
}

businessIntro::businessIntro()
  : flags_()
  , title_()
  , description_()
  , sticker_()
{}

const std::int32_t businessIntro::ID;

object_ptr<businessIntro> businessIntro::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessIntro> res = make_tl_object<businessIntro>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->sticker_ = TlFetchObject<Document>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessIntro::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessIntro");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get())); }
    s.store_class_end();
  }
}

businessLocation::businessLocation()
  : flags_()
  , geo_point_()
  , address_()
{}

const std::int32_t businessLocation::ID;

object_ptr<businessLocation> businessLocation::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessLocation> res = make_tl_object<businessLocation>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->geo_point_ = TlFetchObject<GeoPoint>::parse(p); }
  res->address_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessLocation");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get())); }
    s.store_field("address", address_);
    s.store_class_end();
  }
}

businessRecipients::businessRecipients()
  : flags_()
  , existing_chats_()
  , new_chats_()
  , contacts_()
  , non_contacts_()
  , exclude_selected_()
  , users_()
{}

const std::int32_t businessRecipients::ID;

object_ptr<businessRecipients> businessRecipients::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessRecipients> res = make_tl_object<businessRecipients>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->existing_chats_ = (var0 & 1) != 0;
  res->new_chats_ = (var0 & 2) != 0;
  res->contacts_ = (var0 & 4) != 0;
  res->non_contacts_ = (var0 & 8) != 0;
  res->exclude_selected_ = (var0 & 32) != 0;
  if (var0 & 16) { res->users_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessRecipients");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)));
    if (var0 & 1) { s.store_field("existing_chats", true); }
    if (var0 & 2) { s.store_field("new_chats", true); }
    if (var0 & 4) { s.store_field("contacts", true); }
    if (var0 & 8) { s.store_field("non_contacts", true); }
    if (var0 & 32) { s.store_field("exclude_selected", true); }
    if (var0 & 16) { { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_field("", _value); } s.store_class_end(); } }
    s.store_class_end();
  }
}

businessWeeklyOpen::businessWeeklyOpen(int32 start_minute_, int32 end_minute_)
  : start_minute_(start_minute_)
  , end_minute_(end_minute_)
{}

const std::int32_t businessWeeklyOpen::ID;

object_ptr<businessWeeklyOpen> businessWeeklyOpen::fetch(TlBufferParser &p) {
  return make_tl_object<businessWeeklyOpen>(p);
}

businessWeeklyOpen::businessWeeklyOpen(TlBufferParser &p)
  : start_minute_(TlFetchInt::parse(p))
  , end_minute_(TlFetchInt::parse(p))
{}

void businessWeeklyOpen::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(start_minute_, s);
  TlStoreBinary::store(end_minute_, s);
}

void businessWeeklyOpen::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(start_minute_, s);
  TlStoreBinary::store(end_minute_, s);
}

void businessWeeklyOpen::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessWeeklyOpen");
    s.store_field("start_minute", start_minute_);
    s.store_field("end_minute", end_minute_);
    s.store_class_end();
  }
}

businessWorkHours::businessWorkHours()
  : flags_()
  , open_now_()
  , timezone_id_()
  , weekly_open_()
{}

businessWorkHours::businessWorkHours(int32 flags_, bool open_now_, string const &timezone_id_, array<object_ptr<businessWeeklyOpen>> &&weekly_open_)
  : flags_(flags_)
  , open_now_(open_now_)
  , timezone_id_(timezone_id_)
  , weekly_open_(std::move(weekly_open_))
{}

const std::int32_t businessWorkHours::ID;

object_ptr<businessWorkHours> businessWorkHours::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<businessWorkHours> res = make_tl_object<businessWorkHours>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->open_now_ = (var0 & 1) != 0;
  res->timezone_id_ = TlFetchString<string>::parse(p);
  res->weekly_open_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<businessWeeklyOpen>, 302717625>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void businessWorkHours::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (open_now_ << 0)), s);
  TlStoreString::store(timezone_id_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, 302717625>>, 481674261>::store(weekly_open_, s);
}

void businessWorkHours::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (open_now_ << 0)), s);
  TlStoreString::store(timezone_id_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, 302717625>>, 481674261>::store(weekly_open_, s);
}

void businessWorkHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessWorkHours");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (open_now_ << 0)));
    if (var0 & 1) { s.store_field("open_now", true); }
    s.store_field("timezone_id", timezone_id_);
    { s.store_vector_begin("weekly_open", weekly_open_.size()); for (const auto &_value : weekly_open_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t cdnConfig::ID;

object_ptr<cdnConfig> cdnConfig::fetch(TlBufferParser &p) {
  return make_tl_object<cdnConfig>(p);
}

cdnConfig::cdnConfig(TlBufferParser &p)
  : public_keys_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<cdnPublicKey>, -914167110>>, 481674261>::parse(p))
{}

void cdnConfig::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "cdnConfig");
    { s.store_vector_begin("public_keys", public_keys_.size()); for (const auto &_value : public_keys_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t cdnPublicKey::ID;

object_ptr<cdnPublicKey> cdnPublicKey::fetch(TlBufferParser &p) {
  return make_tl_object<cdnPublicKey>(p);
}

cdnPublicKey::cdnPublicKey(TlBufferParser &p)
  : dc_id_(TlFetchInt::parse(p))
  , public_key_(TlFetchString<string>::parse(p))
{}

void cdnPublicKey::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "cdnPublicKey");
    s.store_field("dc_id", dc_id_);
    s.store_field("public_key", public_key_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEvent::ID;

object_ptr<channelAdminLogEvent> channelAdminLogEvent::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEvent>(p);
}

channelAdminLogEvent::channelAdminLogEvent(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , date_(TlFetchInt::parse(p))
  , user_id_(TlFetchLong::parse(p))
  , action_(TlFetchObject<ChannelAdminLogEventAction>::parse(p))
{}

void channelAdminLogEvent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEvent");
    s.store_field("id", id_);
    s.store_field("date", date_);
    s.store_field("user_id", user_id_);
    s.store_object_field("action", static_cast<const BaseObject *>(action_.get()));
    s.store_class_end();
  }
}

object_ptr<ChannelAdminLogEventAction> ChannelAdminLogEventAction::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case channelAdminLogEventActionChangeTitle::ID:
      return channelAdminLogEventActionChangeTitle::fetch(p);
    case channelAdminLogEventActionChangeAbout::ID:
      return channelAdminLogEventActionChangeAbout::fetch(p);
    case channelAdminLogEventActionChangeUsername::ID:
      return channelAdminLogEventActionChangeUsername::fetch(p);
    case channelAdminLogEventActionChangePhoto::ID:
      return channelAdminLogEventActionChangePhoto::fetch(p);
    case channelAdminLogEventActionToggleInvites::ID:
      return channelAdminLogEventActionToggleInvites::fetch(p);
    case channelAdminLogEventActionToggleSignatures::ID:
      return channelAdminLogEventActionToggleSignatures::fetch(p);
    case channelAdminLogEventActionUpdatePinned::ID:
      return channelAdminLogEventActionUpdatePinned::fetch(p);
    case channelAdminLogEventActionEditMessage::ID:
      return channelAdminLogEventActionEditMessage::fetch(p);
    case channelAdminLogEventActionDeleteMessage::ID:
      return channelAdminLogEventActionDeleteMessage::fetch(p);
    case channelAdminLogEventActionParticipantJoin::ID:
      return channelAdminLogEventActionParticipantJoin::fetch(p);
    case channelAdminLogEventActionParticipantLeave::ID:
      return channelAdminLogEventActionParticipantLeave::fetch(p);
    case channelAdminLogEventActionParticipantInvite::ID:
      return channelAdminLogEventActionParticipantInvite::fetch(p);
    case channelAdminLogEventActionParticipantToggleBan::ID:
      return channelAdminLogEventActionParticipantToggleBan::fetch(p);
    case channelAdminLogEventActionParticipantToggleAdmin::ID:
      return channelAdminLogEventActionParticipantToggleAdmin::fetch(p);
    case channelAdminLogEventActionChangeStickerSet::ID:
      return channelAdminLogEventActionChangeStickerSet::fetch(p);
    case channelAdminLogEventActionTogglePreHistoryHidden::ID:
      return channelAdminLogEventActionTogglePreHistoryHidden::fetch(p);
    case channelAdminLogEventActionDefaultBannedRights::ID:
      return channelAdminLogEventActionDefaultBannedRights::fetch(p);
    case channelAdminLogEventActionStopPoll::ID:
      return channelAdminLogEventActionStopPoll::fetch(p);
    case channelAdminLogEventActionChangeLinkedChat::ID:
      return channelAdminLogEventActionChangeLinkedChat::fetch(p);
    case channelAdminLogEventActionChangeLocation::ID:
      return channelAdminLogEventActionChangeLocation::fetch(p);
    case channelAdminLogEventActionToggleSlowMode::ID:
      return channelAdminLogEventActionToggleSlowMode::fetch(p);
    case channelAdminLogEventActionStartGroupCall::ID:
      return channelAdminLogEventActionStartGroupCall::fetch(p);
    case channelAdminLogEventActionDiscardGroupCall::ID:
      return channelAdminLogEventActionDiscardGroupCall::fetch(p);
    case channelAdminLogEventActionParticipantMute::ID:
      return channelAdminLogEventActionParticipantMute::fetch(p);
    case channelAdminLogEventActionParticipantUnmute::ID:
      return channelAdminLogEventActionParticipantUnmute::fetch(p);
    case channelAdminLogEventActionToggleGroupCallSetting::ID:
      return channelAdminLogEventActionToggleGroupCallSetting::fetch(p);
    case channelAdminLogEventActionParticipantJoinByInvite::ID:
      return channelAdminLogEventActionParticipantJoinByInvite::fetch(p);
    case channelAdminLogEventActionExportedInviteDelete::ID:
      return channelAdminLogEventActionExportedInviteDelete::fetch(p);
    case channelAdminLogEventActionExportedInviteRevoke::ID:
      return channelAdminLogEventActionExportedInviteRevoke::fetch(p);
    case channelAdminLogEventActionExportedInviteEdit::ID:
      return channelAdminLogEventActionExportedInviteEdit::fetch(p);
    case channelAdminLogEventActionParticipantVolume::ID:
      return channelAdminLogEventActionParticipantVolume::fetch(p);
    case channelAdminLogEventActionChangeHistoryTTL::ID:
      return channelAdminLogEventActionChangeHistoryTTL::fetch(p);
    case channelAdminLogEventActionParticipantJoinByRequest::ID:
      return channelAdminLogEventActionParticipantJoinByRequest::fetch(p);
    case channelAdminLogEventActionToggleNoForwards::ID:
      return channelAdminLogEventActionToggleNoForwards::fetch(p);
    case channelAdminLogEventActionSendMessage::ID:
      return channelAdminLogEventActionSendMessage::fetch(p);
    case channelAdminLogEventActionChangeAvailableReactions::ID:
      return channelAdminLogEventActionChangeAvailableReactions::fetch(p);
    case channelAdminLogEventActionChangeUsernames::ID:
      return channelAdminLogEventActionChangeUsernames::fetch(p);
    case channelAdminLogEventActionToggleForum::ID:
      return channelAdminLogEventActionToggleForum::fetch(p);
    case channelAdminLogEventActionCreateTopic::ID:
      return channelAdminLogEventActionCreateTopic::fetch(p);
    case channelAdminLogEventActionEditTopic::ID:
      return channelAdminLogEventActionEditTopic::fetch(p);
    case channelAdminLogEventActionDeleteTopic::ID:
      return channelAdminLogEventActionDeleteTopic::fetch(p);
    case channelAdminLogEventActionPinTopic::ID:
      return channelAdminLogEventActionPinTopic::fetch(p);
    case channelAdminLogEventActionToggleAntiSpam::ID:
      return channelAdminLogEventActionToggleAntiSpam::fetch(p);
    case channelAdminLogEventActionChangePeerColor::ID:
      return channelAdminLogEventActionChangePeerColor::fetch(p);
    case channelAdminLogEventActionChangeProfilePeerColor::ID:
      return channelAdminLogEventActionChangeProfilePeerColor::fetch(p);
    case channelAdminLogEventActionChangeWallpaper::ID:
      return channelAdminLogEventActionChangeWallpaper::fetch(p);
    case channelAdminLogEventActionChangeEmojiStatus::ID:
      return channelAdminLogEventActionChangeEmojiStatus::fetch(p);
    case channelAdminLogEventActionChangeEmojiStickerSet::ID:
      return channelAdminLogEventActionChangeEmojiStickerSet::fetch(p);
    case channelAdminLogEventActionToggleSignatureProfiles::ID:
      return channelAdminLogEventActionToggleSignatureProfiles::fetch(p);
    case channelAdminLogEventActionParticipantSubExtend::ID:
      return channelAdminLogEventActionParticipantSubExtend::fetch(p);
    case channelAdminLogEventActionToggleAutotranslation::ID:
      return channelAdminLogEventActionToggleAutotranslation::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t channelAdminLogEventActionChangeTitle::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeTitle::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeTitle>(p);
}

channelAdminLogEventActionChangeTitle::channelAdminLogEventActionChangeTitle(TlBufferParser &p)
  : prev_value_(TlFetchString<string>::parse(p))
  , new_value_(TlFetchString<string>::parse(p))
{}

void channelAdminLogEventActionChangeTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeTitle");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeAbout::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeAbout::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeAbout>(p);
}

channelAdminLogEventActionChangeAbout::channelAdminLogEventActionChangeAbout(TlBufferParser &p)
  : prev_value_(TlFetchString<string>::parse(p))
  , new_value_(TlFetchString<string>::parse(p))
{}

void channelAdminLogEventActionChangeAbout::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeAbout");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeUsername::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeUsername::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeUsername>(p);
}

channelAdminLogEventActionChangeUsername::channelAdminLogEventActionChangeUsername(TlBufferParser &p)
  : prev_value_(TlFetchString<string>::parse(p))
  , new_value_(TlFetchString<string>::parse(p))
{}

void channelAdminLogEventActionChangeUsername::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeUsername");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangePhoto::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangePhoto::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangePhoto>(p);
}

channelAdminLogEventActionChangePhoto::channelAdminLogEventActionChangePhoto(TlBufferParser &p)
  : prev_photo_(TlFetchObject<Photo>::parse(p))
  , new_photo_(TlFetchObject<Photo>::parse(p))
{}

void channelAdminLogEventActionChangePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangePhoto");
    s.store_object_field("prev_photo", static_cast<const BaseObject *>(prev_photo_.get()));
    s.store_object_field("new_photo", static_cast<const BaseObject *>(new_photo_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleInvites::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleInvites::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleInvites>(p);
}

channelAdminLogEventActionToggleInvites::channelAdminLogEventActionToggleInvites(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleInvites::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleInvites");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleSignatures::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleSignatures::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleSignatures>(p);
}

channelAdminLogEventActionToggleSignatures::channelAdminLogEventActionToggleSignatures(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleSignatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleSignatures");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionUpdatePinned::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionUpdatePinned::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionUpdatePinned>(p);
}

channelAdminLogEventActionUpdatePinned::channelAdminLogEventActionUpdatePinned(TlBufferParser &p)
  : message_(TlFetchObject<Message>::parse(p))
{}

void channelAdminLogEventActionUpdatePinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionUpdatePinned");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionEditMessage::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionEditMessage::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionEditMessage>(p);
}

channelAdminLogEventActionEditMessage::channelAdminLogEventActionEditMessage(TlBufferParser &p)
  : prev_message_(TlFetchObject<Message>::parse(p))
  , new_message_(TlFetchObject<Message>::parse(p))
{}

void channelAdminLogEventActionEditMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionEditMessage");
    s.store_object_field("prev_message", static_cast<const BaseObject *>(prev_message_.get()));
    s.store_object_field("new_message", static_cast<const BaseObject *>(new_message_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionDeleteMessage::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionDeleteMessage::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionDeleteMessage>(p);
}

channelAdminLogEventActionDeleteMessage::channelAdminLogEventActionDeleteMessage(TlBufferParser &p)
  : message_(TlFetchObject<Message>::parse(p))
{}

void channelAdminLogEventActionDeleteMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionDeleteMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantJoin::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantJoin::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantJoin>();
}

void channelAdminLogEventActionParticipantJoin::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantJoin");
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantLeave::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantLeave::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantLeave>();
}

void channelAdminLogEventActionParticipantLeave::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantLeave");
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantInvite::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantInvite::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantInvite>(p);
}

channelAdminLogEventActionParticipantInvite::channelAdminLogEventActionParticipantInvite(TlBufferParser &p)
  : participant_(TlFetchObject<ChannelParticipant>::parse(p))
{}

void channelAdminLogEventActionParticipantInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantInvite");
    s.store_object_field("participant", static_cast<const BaseObject *>(participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantToggleBan::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantToggleBan::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantToggleBan>(p);
}

channelAdminLogEventActionParticipantToggleBan::channelAdminLogEventActionParticipantToggleBan(TlBufferParser &p)
  : prev_participant_(TlFetchObject<ChannelParticipant>::parse(p))
  , new_participant_(TlFetchObject<ChannelParticipant>::parse(p))
{}

void channelAdminLogEventActionParticipantToggleBan::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantToggleBan");
    s.store_object_field("prev_participant", static_cast<const BaseObject *>(prev_participant_.get()));
    s.store_object_field("new_participant", static_cast<const BaseObject *>(new_participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantToggleAdmin::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantToggleAdmin::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantToggleAdmin>(p);
}

channelAdminLogEventActionParticipantToggleAdmin::channelAdminLogEventActionParticipantToggleAdmin(TlBufferParser &p)
  : prev_participant_(TlFetchObject<ChannelParticipant>::parse(p))
  , new_participant_(TlFetchObject<ChannelParticipant>::parse(p))
{}

void channelAdminLogEventActionParticipantToggleAdmin::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantToggleAdmin");
    s.store_object_field("prev_participant", static_cast<const BaseObject *>(prev_participant_.get()));
    s.store_object_field("new_participant", static_cast<const BaseObject *>(new_participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeStickerSet::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeStickerSet::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeStickerSet>(p);
}

channelAdminLogEventActionChangeStickerSet::channelAdminLogEventActionChangeStickerSet(TlBufferParser &p)
  : prev_stickerset_(TlFetchObject<InputStickerSet>::parse(p))
  , new_stickerset_(TlFetchObject<InputStickerSet>::parse(p))
{}

void channelAdminLogEventActionChangeStickerSet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeStickerSet");
    s.store_object_field("prev_stickerset", static_cast<const BaseObject *>(prev_stickerset_.get()));
    s.store_object_field("new_stickerset", static_cast<const BaseObject *>(new_stickerset_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionTogglePreHistoryHidden::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionTogglePreHistoryHidden::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionTogglePreHistoryHidden>(p);
}

channelAdminLogEventActionTogglePreHistoryHidden::channelAdminLogEventActionTogglePreHistoryHidden(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionTogglePreHistoryHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionTogglePreHistoryHidden");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionDefaultBannedRights::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionDefaultBannedRights::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionDefaultBannedRights>(p);
}

channelAdminLogEventActionDefaultBannedRights::channelAdminLogEventActionDefaultBannedRights(TlBufferParser &p)
  : prev_banned_rights_(TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p))
  , new_banned_rights_(TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p))
{}

void channelAdminLogEventActionDefaultBannedRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionDefaultBannedRights");
    s.store_object_field("prev_banned_rights", static_cast<const BaseObject *>(prev_banned_rights_.get()));
    s.store_object_field("new_banned_rights", static_cast<const BaseObject *>(new_banned_rights_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionStopPoll::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionStopPoll::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionStopPoll>(p);
}

channelAdminLogEventActionStopPoll::channelAdminLogEventActionStopPoll(TlBufferParser &p)
  : message_(TlFetchObject<Message>::parse(p))
{}

void channelAdminLogEventActionStopPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionStopPoll");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeLinkedChat::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeLinkedChat::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeLinkedChat>(p);
}

channelAdminLogEventActionChangeLinkedChat::channelAdminLogEventActionChangeLinkedChat(TlBufferParser &p)
  : prev_value_(TlFetchLong::parse(p))
  , new_value_(TlFetchLong::parse(p))
{}

void channelAdminLogEventActionChangeLinkedChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeLinkedChat");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeLocation::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeLocation::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeLocation>(p);
}

channelAdminLogEventActionChangeLocation::channelAdminLogEventActionChangeLocation(TlBufferParser &p)
  : prev_value_(TlFetchObject<ChannelLocation>::parse(p))
  , new_value_(TlFetchObject<ChannelLocation>::parse(p))
{}

void channelAdminLogEventActionChangeLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeLocation");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleSlowMode::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleSlowMode::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleSlowMode>(p);
}

channelAdminLogEventActionToggleSlowMode::channelAdminLogEventActionToggleSlowMode(TlBufferParser &p)
  : prev_value_(TlFetchInt::parse(p))
  , new_value_(TlFetchInt::parse(p))
{}

void channelAdminLogEventActionToggleSlowMode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleSlowMode");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionStartGroupCall::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionStartGroupCall::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionStartGroupCall>(p);
}

channelAdminLogEventActionStartGroupCall::channelAdminLogEventActionStartGroupCall(TlBufferParser &p)
  : call_(TlFetchObject<InputGroupCall>::parse(p))
{}

void channelAdminLogEventActionStartGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionStartGroupCall");
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionDiscardGroupCall::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionDiscardGroupCall::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionDiscardGroupCall>(p);
}

channelAdminLogEventActionDiscardGroupCall::channelAdminLogEventActionDiscardGroupCall(TlBufferParser &p)
  : call_(TlFetchObject<InputGroupCall>::parse(p))
{}

void channelAdminLogEventActionDiscardGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionDiscardGroupCall");
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantMute::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantMute::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantMute>(p);
}

channelAdminLogEventActionParticipantMute::channelAdminLogEventActionParticipantMute(TlBufferParser &p)
  : participant_(TlFetchBoxed<TlFetchObject<groupCallParticipant>, -341428482>::parse(p))
{}

void channelAdminLogEventActionParticipantMute::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantMute");
    s.store_object_field("participant", static_cast<const BaseObject *>(participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantUnmute::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantUnmute::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantUnmute>(p);
}

channelAdminLogEventActionParticipantUnmute::channelAdminLogEventActionParticipantUnmute(TlBufferParser &p)
  : participant_(TlFetchBoxed<TlFetchObject<groupCallParticipant>, -341428482>::parse(p))
{}

void channelAdminLogEventActionParticipantUnmute::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantUnmute");
    s.store_object_field("participant", static_cast<const BaseObject *>(participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleGroupCallSetting::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleGroupCallSetting::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleGroupCallSetting>(p);
}

channelAdminLogEventActionToggleGroupCallSetting::channelAdminLogEventActionToggleGroupCallSetting(TlBufferParser &p)
  : join_muted_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleGroupCallSetting::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleGroupCallSetting");
    s.store_field("join_muted", join_muted_);
    s.store_class_end();
  }
}

channelAdminLogEventActionParticipantJoinByInvite::channelAdminLogEventActionParticipantJoinByInvite()
  : flags_()
  , via_chatlist_()
  , invite_()
{}

const std::int32_t channelAdminLogEventActionParticipantJoinByInvite::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantJoinByInvite::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelAdminLogEventActionParticipantJoinByInvite> res = make_tl_object<channelAdminLogEventActionParticipantJoinByInvite>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->via_chatlist_ = (var0 & 1) != 0;
  res->invite_ = TlFetchObject<ExportedChatInvite>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelAdminLogEventActionParticipantJoinByInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantJoinByInvite");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (via_chatlist_ << 0)));
    if (var0 & 1) { s.store_field("via_chatlist", true); }
    s.store_object_field("invite", static_cast<const BaseObject *>(invite_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionExportedInviteDelete::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionExportedInviteDelete::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionExportedInviteDelete>(p);
}

channelAdminLogEventActionExportedInviteDelete::channelAdminLogEventActionExportedInviteDelete(TlBufferParser &p)
  : invite_(TlFetchObject<ExportedChatInvite>::parse(p))
{}

void channelAdminLogEventActionExportedInviteDelete::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionExportedInviteDelete");
    s.store_object_field("invite", static_cast<const BaseObject *>(invite_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionExportedInviteRevoke::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionExportedInviteRevoke::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionExportedInviteRevoke>(p);
}

channelAdminLogEventActionExportedInviteRevoke::channelAdminLogEventActionExportedInviteRevoke(TlBufferParser &p)
  : invite_(TlFetchObject<ExportedChatInvite>::parse(p))
{}

void channelAdminLogEventActionExportedInviteRevoke::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionExportedInviteRevoke");
    s.store_object_field("invite", static_cast<const BaseObject *>(invite_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionExportedInviteEdit::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionExportedInviteEdit::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionExportedInviteEdit>(p);
}

channelAdminLogEventActionExportedInviteEdit::channelAdminLogEventActionExportedInviteEdit(TlBufferParser &p)
  : prev_invite_(TlFetchObject<ExportedChatInvite>::parse(p))
  , new_invite_(TlFetchObject<ExportedChatInvite>::parse(p))
{}

void channelAdminLogEventActionExportedInviteEdit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionExportedInviteEdit");
    s.store_object_field("prev_invite", static_cast<const BaseObject *>(prev_invite_.get()));
    s.store_object_field("new_invite", static_cast<const BaseObject *>(new_invite_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantVolume::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantVolume::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantVolume>(p);
}

channelAdminLogEventActionParticipantVolume::channelAdminLogEventActionParticipantVolume(TlBufferParser &p)
  : participant_(TlFetchBoxed<TlFetchObject<groupCallParticipant>, -341428482>::parse(p))
{}

void channelAdminLogEventActionParticipantVolume::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantVolume");
    s.store_object_field("participant", static_cast<const BaseObject *>(participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeHistoryTTL::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeHistoryTTL::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeHistoryTTL>(p);
}

channelAdminLogEventActionChangeHistoryTTL::channelAdminLogEventActionChangeHistoryTTL(TlBufferParser &p)
  : prev_value_(TlFetchInt::parse(p))
  , new_value_(TlFetchInt::parse(p))
{}

void channelAdminLogEventActionChangeHistoryTTL::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeHistoryTTL");
    s.store_field("prev_value", prev_value_);
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantJoinByRequest::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantJoinByRequest::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantJoinByRequest>(p);
}

channelAdminLogEventActionParticipantJoinByRequest::channelAdminLogEventActionParticipantJoinByRequest(TlBufferParser &p)
  : invite_(TlFetchObject<ExportedChatInvite>::parse(p))
  , approved_by_(TlFetchLong::parse(p))
{}

void channelAdminLogEventActionParticipantJoinByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantJoinByRequest");
    s.store_object_field("invite", static_cast<const BaseObject *>(invite_.get()));
    s.store_field("approved_by", approved_by_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleNoForwards::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleNoForwards::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleNoForwards>(p);
}

channelAdminLogEventActionToggleNoForwards::channelAdminLogEventActionToggleNoForwards(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleNoForwards::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleNoForwards");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionSendMessage::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionSendMessage::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionSendMessage>(p);
}

channelAdminLogEventActionSendMessage::channelAdminLogEventActionSendMessage(TlBufferParser &p)
  : message_(TlFetchObject<Message>::parse(p))
{}

void channelAdminLogEventActionSendMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionSendMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeAvailableReactions::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeAvailableReactions::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeAvailableReactions>(p);
}

channelAdminLogEventActionChangeAvailableReactions::channelAdminLogEventActionChangeAvailableReactions(TlBufferParser &p)
  : prev_value_(TlFetchObject<ChatReactions>::parse(p))
  , new_value_(TlFetchObject<ChatReactions>::parse(p))
{}

void channelAdminLogEventActionChangeAvailableReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeAvailableReactions");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeUsernames::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeUsernames::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeUsernames>(p);
}

channelAdminLogEventActionChangeUsernames::channelAdminLogEventActionChangeUsernames(TlBufferParser &p)
  : prev_value_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
  , new_value_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
{}

void channelAdminLogEventActionChangeUsernames::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeUsernames");
    { s.store_vector_begin("prev_value", prev_value_.size()); for (const auto &_value : prev_value_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("new_value", new_value_.size()); for (const auto &_value : new_value_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleForum::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleForum::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleForum>(p);
}

channelAdminLogEventActionToggleForum::channelAdminLogEventActionToggleForum(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleForum::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleForum");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionCreateTopic::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionCreateTopic::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionCreateTopic>(p);
}

channelAdminLogEventActionCreateTopic::channelAdminLogEventActionCreateTopic(TlBufferParser &p)
  : topic_(TlFetchObject<ForumTopic>::parse(p))
{}

void channelAdminLogEventActionCreateTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionCreateTopic");
    s.store_object_field("topic", static_cast<const BaseObject *>(topic_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionEditTopic::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionEditTopic::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionEditTopic>(p);
}

channelAdminLogEventActionEditTopic::channelAdminLogEventActionEditTopic(TlBufferParser &p)
  : prev_topic_(TlFetchObject<ForumTopic>::parse(p))
  , new_topic_(TlFetchObject<ForumTopic>::parse(p))
{}

void channelAdminLogEventActionEditTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionEditTopic");
    s.store_object_field("prev_topic", static_cast<const BaseObject *>(prev_topic_.get()));
    s.store_object_field("new_topic", static_cast<const BaseObject *>(new_topic_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionDeleteTopic::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionDeleteTopic::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionDeleteTopic>(p);
}

channelAdminLogEventActionDeleteTopic::channelAdminLogEventActionDeleteTopic(TlBufferParser &p)
  : topic_(TlFetchObject<ForumTopic>::parse(p))
{}

void channelAdminLogEventActionDeleteTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionDeleteTopic");
    s.store_object_field("topic", static_cast<const BaseObject *>(topic_.get()));
    s.store_class_end();
  }
}

channelAdminLogEventActionPinTopic::channelAdminLogEventActionPinTopic()
  : flags_()
  , prev_topic_()
  , new_topic_()
{}

const std::int32_t channelAdminLogEventActionPinTopic::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionPinTopic::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelAdminLogEventActionPinTopic> res = make_tl_object<channelAdminLogEventActionPinTopic>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->prev_topic_ = TlFetchObject<ForumTopic>::parse(p); }
  if (var0 & 2) { res->new_topic_ = TlFetchObject<ForumTopic>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelAdminLogEventActionPinTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionPinTopic");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_object_field("prev_topic", static_cast<const BaseObject *>(prev_topic_.get())); }
    if (var0 & 2) { s.store_object_field("new_topic", static_cast<const BaseObject *>(new_topic_.get())); }
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleAntiSpam::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleAntiSpam::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleAntiSpam>(p);
}

channelAdminLogEventActionToggleAntiSpam::channelAdminLogEventActionToggleAntiSpam(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleAntiSpam::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleAntiSpam");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangePeerColor::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangePeerColor::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangePeerColor>(p);
}

channelAdminLogEventActionChangePeerColor::channelAdminLogEventActionChangePeerColor(TlBufferParser &p)
  : prev_value_(TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p))
  , new_value_(TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p))
{}

void channelAdminLogEventActionChangePeerColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangePeerColor");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeProfilePeerColor::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeProfilePeerColor::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeProfilePeerColor>(p);
}

channelAdminLogEventActionChangeProfilePeerColor::channelAdminLogEventActionChangeProfilePeerColor(TlBufferParser &p)
  : prev_value_(TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p))
  , new_value_(TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p))
{}

void channelAdminLogEventActionChangeProfilePeerColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeProfilePeerColor");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeWallpaper::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeWallpaper::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeWallpaper>(p);
}

channelAdminLogEventActionChangeWallpaper::channelAdminLogEventActionChangeWallpaper(TlBufferParser &p)
  : prev_value_(TlFetchObject<WallPaper>::parse(p))
  , new_value_(TlFetchObject<WallPaper>::parse(p))
{}

void channelAdminLogEventActionChangeWallpaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeWallpaper");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeEmojiStatus::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeEmojiStatus::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeEmojiStatus>(p);
}

channelAdminLogEventActionChangeEmojiStatus::channelAdminLogEventActionChangeEmojiStatus(TlBufferParser &p)
  : prev_value_(TlFetchObject<EmojiStatus>::parse(p))
  , new_value_(TlFetchObject<EmojiStatus>::parse(p))
{}

void channelAdminLogEventActionChangeEmojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeEmojiStatus");
    s.store_object_field("prev_value", static_cast<const BaseObject *>(prev_value_.get()));
    s.store_object_field("new_value", static_cast<const BaseObject *>(new_value_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionChangeEmojiStickerSet::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionChangeEmojiStickerSet::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionChangeEmojiStickerSet>(p);
}

channelAdminLogEventActionChangeEmojiStickerSet::channelAdminLogEventActionChangeEmojiStickerSet(TlBufferParser &p)
  : prev_stickerset_(TlFetchObject<InputStickerSet>::parse(p))
  , new_stickerset_(TlFetchObject<InputStickerSet>::parse(p))
{}

void channelAdminLogEventActionChangeEmojiStickerSet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionChangeEmojiStickerSet");
    s.store_object_field("prev_stickerset", static_cast<const BaseObject *>(prev_stickerset_.get()));
    s.store_object_field("new_stickerset", static_cast<const BaseObject *>(new_stickerset_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleSignatureProfiles::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleSignatureProfiles::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleSignatureProfiles>(p);
}

channelAdminLogEventActionToggleSignatureProfiles::channelAdminLogEventActionToggleSignatureProfiles(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleSignatureProfiles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleSignatureProfiles");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionParticipantSubExtend::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionParticipantSubExtend::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionParticipantSubExtend>(p);
}

channelAdminLogEventActionParticipantSubExtend::channelAdminLogEventActionParticipantSubExtend(TlBufferParser &p)
  : prev_participant_(TlFetchObject<ChannelParticipant>::parse(p))
  , new_participant_(TlFetchObject<ChannelParticipant>::parse(p))
{}

void channelAdminLogEventActionParticipantSubExtend::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionParticipantSubExtend");
    s.store_object_field("prev_participant", static_cast<const BaseObject *>(prev_participant_.get()));
    s.store_object_field("new_participant", static_cast<const BaseObject *>(new_participant_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelAdminLogEventActionToggleAutotranslation::ID;

object_ptr<ChannelAdminLogEventAction> channelAdminLogEventActionToggleAutotranslation::fetch(TlBufferParser &p) {
  return make_tl_object<channelAdminLogEventActionToggleAutotranslation>(p);
}

channelAdminLogEventActionToggleAutotranslation::channelAdminLogEventActionToggleAutotranslation(TlBufferParser &p)
  : new_value_(TlFetchBool::parse(p))
{}

void channelAdminLogEventActionToggleAutotranslation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventActionToggleAutotranslation");
    s.store_field("new_value", new_value_);
    s.store_class_end();
  }
}

channelAdminLogEventsFilter::channelAdminLogEventsFilter(int32 flags_, bool join_, bool leave_, bool invite_, bool ban_, bool unban_, bool kick_, bool unkick_, bool promote_, bool demote_, bool info_, bool settings_, bool pinned_, bool edit_, bool delete_, bool group_call_, bool invites_, bool send_, bool forums_, bool sub_extend_)
  : flags_(flags_)
  , join_(join_)
  , leave_(leave_)
  , invite_(invite_)
  , ban_(ban_)
  , unban_(unban_)
  , kick_(kick_)
  , unkick_(unkick_)
  , promote_(promote_)
  , demote_(demote_)
  , info_(info_)
  , settings_(settings_)
  , pinned_(pinned_)
  , edit_(edit_)
  , delete_(delete_)
  , group_call_(group_call_)
  , invites_(invites_)
  , send_(send_)
  , forums_(forums_)
  , sub_extend_(sub_extend_)
{}

const std::int32_t channelAdminLogEventsFilter::ID;

void channelAdminLogEventsFilter::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (join_ << 0) | (leave_ << 1) | (invite_ << 2) | (ban_ << 3) | (unban_ << 4) | (kick_ << 5) | (unkick_ << 6) | (promote_ << 7) | (demote_ << 8) | (info_ << 9) | (settings_ << 10) | (pinned_ << 11) | (edit_ << 12) | (delete_ << 13) | (group_call_ << 14) | (invites_ << 15) | (send_ << 16) | (forums_ << 17) | (sub_extend_ << 18)), s);
}

void channelAdminLogEventsFilter::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (join_ << 0) | (leave_ << 1) | (invite_ << 2) | (ban_ << 3) | (unban_ << 4) | (kick_ << 5) | (unkick_ << 6) | (promote_ << 7) | (demote_ << 8) | (info_ << 9) | (settings_ << 10) | (pinned_ << 11) | (edit_ << 12) | (delete_ << 13) | (group_call_ << 14) | (invites_ << 15) | (send_ << 16) | (forums_ << 17) | (sub_extend_ << 18)), s);
}

void channelAdminLogEventsFilter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelAdminLogEventsFilter");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (join_ << 0) | (leave_ << 1) | (invite_ << 2) | (ban_ << 3) | (unban_ << 4) | (kick_ << 5) | (unkick_ << 6) | (promote_ << 7) | (demote_ << 8) | (info_ << 9) | (settings_ << 10) | (pinned_ << 11) | (edit_ << 12) | (delete_ << 13) | (group_call_ << 14) | (invites_ << 15) | (send_ << 16) | (forums_ << 17) | (sub_extend_ << 18)));
    if (var0 & 1) { s.store_field("join", true); }
    if (var0 & 2) { s.store_field("leave", true); }
    if (var0 & 4) { s.store_field("invite", true); }
    if (var0 & 8) { s.store_field("ban", true); }
    if (var0 & 16) { s.store_field("unban", true); }
    if (var0 & 32) { s.store_field("kick", true); }
    if (var0 & 64) { s.store_field("unkick", true); }
    if (var0 & 128) { s.store_field("promote", true); }
    if (var0 & 256) { s.store_field("demote", true); }
    if (var0 & 512) { s.store_field("info", true); }
    if (var0 & 1024) { s.store_field("settings", true); }
    if (var0 & 2048) { s.store_field("pinned", true); }
    if (var0 & 4096) { s.store_field("edit", true); }
    if (var0 & 8192) { s.store_field("delete", true); }
    if (var0 & 16384) { s.store_field("group_call", true); }
    if (var0 & 32768) { s.store_field("invites", true); }
    if (var0 & 65536) { s.store_field("send", true); }
    if (var0 & 131072) { s.store_field("forums", true); }
    if (var0 & 262144) { s.store_field("sub_extend", true); }
    s.store_class_end();
  }
}

object_ptr<ChannelLocation> ChannelLocation::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case channelLocationEmpty::ID:
      return channelLocationEmpty::fetch(p);
    case channelLocation::ID:
      return channelLocation::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t channelLocationEmpty::ID;

object_ptr<ChannelLocation> channelLocationEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<channelLocationEmpty>();
}

void channelLocationEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelLocationEmpty");
    s.store_class_end();
  }
}

const std::int32_t channelLocation::ID;

object_ptr<ChannelLocation> channelLocation::fetch(TlBufferParser &p) {
  return make_tl_object<channelLocation>(p);
}

channelLocation::channelLocation(TlBufferParser &p)
  : geo_point_(TlFetchObject<GeoPoint>::parse(p))
  , address_(TlFetchString<string>::parse(p))
{}

void channelLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelLocation");
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    s.store_field("address", address_);
    s.store_class_end();
  }
}

const std::int32_t channelMessagesFilterEmpty::ID;

void channelMessagesFilterEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void channelMessagesFilterEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void channelMessagesFilterEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelMessagesFilterEmpty");
    s.store_class_end();
  }
}

channelMessagesFilter::channelMessagesFilter(int32 flags_, bool exclude_new_messages_, array<object_ptr<messageRange>> &&ranges_)
  : flags_(flags_)
  , exclude_new_messages_(exclude_new_messages_)
  , ranges_(std::move(ranges_))
{}

const std::int32_t channelMessagesFilter::ID;

void channelMessagesFilter::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (exclude_new_messages_ << 1)), s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, 182649427>>, 481674261>::store(ranges_, s);
}

void channelMessagesFilter::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (exclude_new_messages_ << 1)), s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, 182649427>>, 481674261>::store(ranges_, s);
}

void channelMessagesFilter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelMessagesFilter");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (exclude_new_messages_ << 1)));
    if (var0 & 2) { s.store_field("exclude_new_messages", true); }
    { s.store_vector_begin("ranges", ranges_.size()); for (const auto &_value : ranges_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<ChannelParticipant> ChannelParticipant::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case channelParticipant::ID:
      return channelParticipant::fetch(p);
    case channelParticipantSelf::ID:
      return channelParticipantSelf::fetch(p);
    case channelParticipantCreator::ID:
      return channelParticipantCreator::fetch(p);
    case channelParticipantAdmin::ID:
      return channelParticipantAdmin::fetch(p);
    case channelParticipantBanned::ID:
      return channelParticipantBanned::fetch(p);
    case channelParticipantLeft::ID:
      return channelParticipantLeft::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

channelParticipant::channelParticipant()
  : flags_()
  , user_id_()
  , date_()
  , subscription_until_date_()
{}

const std::int32_t channelParticipant::ID;

object_ptr<ChannelParticipant> channelParticipant::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelParticipant> res = make_tl_object<channelParticipant>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->user_id_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->subscription_until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelParticipant::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipant");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("user_id", user_id_);
    s.store_field("date", date_);
    if (var0 & 1) { s.store_field("subscription_until_date", subscription_until_date_); }
    s.store_class_end();
  }
}

channelParticipantSelf::channelParticipantSelf()
  : flags_()
  , via_request_()
  , user_id_()
  , inviter_id_()
  , date_()
  , subscription_until_date_()
{}

const std::int32_t channelParticipantSelf::ID;

object_ptr<ChannelParticipant> channelParticipantSelf::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelParticipantSelf> res = make_tl_object<channelParticipantSelf>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->via_request_ = (var0 & 1) != 0;
  res->user_id_ = TlFetchLong::parse(p);
  res->inviter_id_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 2) { res->subscription_until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelParticipantSelf::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantSelf");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (via_request_ << 0)));
    if (var0 & 1) { s.store_field("via_request", true); }
    s.store_field("user_id", user_id_);
    s.store_field("inviter_id", inviter_id_);
    s.store_field("date", date_);
    if (var0 & 2) { s.store_field("subscription_until_date", subscription_until_date_); }
    s.store_class_end();
  }
}

channelParticipantCreator::channelParticipantCreator()
  : flags_()
  , user_id_()
  , admin_rights_()
  , rank_()
{}

const std::int32_t channelParticipantCreator::ID;

object_ptr<ChannelParticipant> channelParticipantCreator::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelParticipantCreator> res = make_tl_object<channelParticipantCreator>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->user_id_ = TlFetchLong::parse(p);
  res->admin_rights_ = TlFetchBoxed<TlFetchObject<chatAdminRights>, 1605510357>::parse(p);
  if (var0 & 1) { res->rank_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelParticipantCreator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantCreator");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("user_id", user_id_);
    s.store_object_field("admin_rights", static_cast<const BaseObject *>(admin_rights_.get()));
    if (var0 & 1) { s.store_field("rank", rank_); }
    s.store_class_end();
  }
}

channelParticipantAdmin::channelParticipantAdmin()
  : flags_()
  , can_edit_()
  , self_()
  , user_id_()
  , inviter_id_()
  , promoted_by_()
  , date_()
  , admin_rights_()
  , rank_()
{}

const std::int32_t channelParticipantAdmin::ID;

object_ptr<ChannelParticipant> channelParticipantAdmin::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelParticipantAdmin> res = make_tl_object<channelParticipantAdmin>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->can_edit_ = (var0 & 1) != 0;
  res->self_ = (var0 & 2) != 0;
  res->user_id_ = TlFetchLong::parse(p);
  if (var0 & 2) { res->inviter_id_ = TlFetchLong::parse(p); }
  res->promoted_by_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->admin_rights_ = TlFetchBoxed<TlFetchObject<chatAdminRights>, 1605510357>::parse(p);
  if (var0 & 4) { res->rank_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelParticipantAdmin::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantAdmin");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (can_edit_ << 0) | (self_ << 1)));
    if (var0 & 1) { s.store_field("can_edit", true); }
    if (var0 & 2) { s.store_field("self", true); }
    s.store_field("user_id", user_id_);
    if (var0 & 2) { s.store_field("inviter_id", inviter_id_); }
    s.store_field("promoted_by", promoted_by_);
    s.store_field("date", date_);
    s.store_object_field("admin_rights", static_cast<const BaseObject *>(admin_rights_.get()));
    if (var0 & 4) { s.store_field("rank", rank_); }
    s.store_class_end();
  }
}

channelParticipantBanned::channelParticipantBanned()
  : flags_()
  , left_()
  , peer_()
  , kicked_by_()
  , date_()
  , banned_rights_()
{}

const std::int32_t channelParticipantBanned::ID;

object_ptr<ChannelParticipant> channelParticipantBanned::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelParticipantBanned> res = make_tl_object<channelParticipantBanned>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->left_ = (var0 & 1) != 0;
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->kicked_by_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->banned_rights_ = TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelParticipantBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantBanned");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (left_ << 0)));
    if (var0 & 1) { s.store_field("left", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("kicked_by", kicked_by_);
    s.store_field("date", date_);
    s.store_object_field("banned_rights", static_cast<const BaseObject *>(banned_rights_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelParticipantLeft::ID;

object_ptr<ChannelParticipant> channelParticipantLeft::fetch(TlBufferParser &p) {
  return make_tl_object<channelParticipantLeft>(p);
}

channelParticipantLeft::channelParticipantLeft(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
{}

void channelParticipantLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantLeft");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

const std::int32_t channelParticipantsRecent::ID;

void channelParticipantsRecent::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void channelParticipantsRecent::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void channelParticipantsRecent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsRecent");
    s.store_class_end();
  }
}

const std::int32_t channelParticipantsAdmins::ID;

void channelParticipantsAdmins::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void channelParticipantsAdmins::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void channelParticipantsAdmins::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsAdmins");
    s.store_class_end();
  }
}

channelParticipantsKicked::channelParticipantsKicked(string const &q_)
  : q_(q_)
{}

const std::int32_t channelParticipantsKicked::ID;

void channelParticipantsKicked::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsKicked::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsKicked::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsKicked");
    s.store_field("q", q_);
    s.store_class_end();
  }
}

const std::int32_t channelParticipantsBots::ID;

void channelParticipantsBots::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void channelParticipantsBots::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void channelParticipantsBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsBots");
    s.store_class_end();
  }
}

channelParticipantsBanned::channelParticipantsBanned(string const &q_)
  : q_(q_)
{}

const std::int32_t channelParticipantsBanned::ID;

void channelParticipantsBanned::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsBanned::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsBanned");
    s.store_field("q", q_);
    s.store_class_end();
  }
}

channelParticipantsSearch::channelParticipantsSearch(string const &q_)
  : q_(q_)
{}

const std::int32_t channelParticipantsSearch::ID;

void channelParticipantsSearch::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsSearch::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsSearch::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsSearch");
    s.store_field("q", q_);
    s.store_class_end();
  }
}

channelParticipantsContacts::channelParticipantsContacts(string const &q_)
  : q_(q_)
{}

const std::int32_t channelParticipantsContacts::ID;

void channelParticipantsContacts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsContacts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(q_, s);
}

void channelParticipantsContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsContacts");
    s.store_field("q", q_);
    s.store_class_end();
  }
}

channelParticipantsMentions::channelParticipantsMentions(int32 flags_, string const &q_, int32 top_msg_id_)
  : flags_(flags_)
  , q_(q_)
  , top_msg_id_(top_msg_id_)
{}

const std::int32_t channelParticipantsMentions::ID;

void channelParticipantsMentions::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreString::store(q_, s); }
  if (var0 & 2) { TlStoreBinary::store(top_msg_id_, s); }
}

void channelParticipantsMentions::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreString::store(q_, s); }
  if (var0 & 2) { TlStoreBinary::store(top_msg_id_, s); }
}

void channelParticipantsMentions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelParticipantsMentions");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("q", q_); }
    if (var0 & 2) { s.store_field("top_msg_id", top_msg_id_); }
    s.store_class_end();
  }
}

object_ptr<Chat> Chat::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatEmpty::ID:
      return chatEmpty::fetch(p);
    case chat::ID:
      return chat::fetch(p);
    case chatForbidden::ID:
      return chatForbidden::fetch(p);
    case channel::ID:
      return channel::fetch(p);
    case channelForbidden::ID:
      return channelForbidden::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t chatEmpty::ID;

object_ptr<Chat> chatEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<chatEmpty>(p);
}

chatEmpty::chatEmpty(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
{}

void chatEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEmpty");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

chat::chat()
  : flags_()
  , creator_()
  , left_()
  , deactivated_()
  , call_active_()
  , call_not_empty_()
  , noforwards_()
  , id_()
  , title_()
  , photo_()
  , participants_count_()
  , date_()
  , version_()
  , migrated_to_()
  , admin_rights_()
  , default_banned_rights_()
{}

const std::int32_t chat::ID;

object_ptr<Chat> chat::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chat> res = make_tl_object<chat>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->creator_ = (var0 & 1) != 0;
  res->left_ = (var0 & 4) != 0;
  res->deactivated_ = (var0 & 32) != 0;
  res->call_active_ = (var0 & 8388608) != 0;
  res->call_not_empty_ = (var0 & 16777216) != 0;
  res->noforwards_ = (var0 & 33554432) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->photo_ = TlFetchObject<ChatPhoto>::parse(p);
  res->participants_count_ = TlFetchInt::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->version_ = TlFetchInt::parse(p);
  if (var0 & 64) { res->migrated_to_ = TlFetchObject<InputChannel>::parse(p); }
  if (var0 & 16384) { res->admin_rights_ = TlFetchBoxed<TlFetchObject<chatAdminRights>, 1605510357>::parse(p); }
  if (var0 & 262144) { res->default_banned_rights_ = TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chat");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (creator_ << 0) | (left_ << 2) | (deactivated_ << 5) | (call_active_ << 23) | (call_not_empty_ << 24) | (noforwards_ << 25)));
    if (var0 & 1) { s.store_field("creator", true); }
    if (var0 & 4) { s.store_field("left", true); }
    if (var0 & 32) { s.store_field("deactivated", true); }
    if (var0 & 8388608) { s.store_field("call_active", true); }
    if (var0 & 16777216) { s.store_field("call_not_empty", true); }
    if (var0 & 33554432) { s.store_field("noforwards", true); }
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("participants_count", participants_count_);
    s.store_field("date", date_);
    s.store_field("version", version_);
    if (var0 & 64) { s.store_object_field("migrated_to", static_cast<const BaseObject *>(migrated_to_.get())); }
    if (var0 & 16384) { s.store_object_field("admin_rights", static_cast<const BaseObject *>(admin_rights_.get())); }
    if (var0 & 262144) { s.store_object_field("default_banned_rights", static_cast<const BaseObject *>(default_banned_rights_.get())); }
    s.store_class_end();
  }
}

const std::int32_t chatForbidden::ID;

object_ptr<Chat> chatForbidden::fetch(TlBufferParser &p) {
  return make_tl_object<chatForbidden>(p);
}

chatForbidden::chatForbidden(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , title_(TlFetchString<string>::parse(p))
{}

void chatForbidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatForbidden");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_class_end();
  }
}

channel::channel()
  : flags_()
  , creator_()
  , left_()
  , broadcast_()
  , verified_()
  , megagroup_()
  , restricted_()
  , signatures_()
  , min_()
  , scam_()
  , has_link_()
  , has_geo_()
  , slowmode_enabled_()
  , call_active_()
  , call_not_empty_()
  , fake_()
  , gigagroup_()
  , noforwards_()
  , join_to_send_()
  , join_request_()
  , forum_()
  , flags2_()
  , stories_hidden_()
  , stories_hidden_min_()
  , stories_unavailable_()
  , signature_profiles_()
  , autotranslation_()
  , broadcast_messages_allowed_()
  , monoforum_()
  , forum_tabs_()
  , id_()
  , access_hash_()
  , title_()
  , username_()
  , photo_()
  , date_()
  , restriction_reason_()
  , admin_rights_()
  , banned_rights_()
  , default_banned_rights_()
  , participants_count_()
  , usernames_()
  , stories_max_id_()
  , color_()
  , profile_color_()
  , emoji_status_()
  , level_()
  , subscription_until_date_()
  , bot_verification_icon_()
  , send_paid_messages_stars_()
  , linked_monoforum_id_()
{}

const std::int32_t channel::ID;

object_ptr<Chat> channel::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channel> res = make_tl_object<channel>();
  int32 var0;
  int32 var1;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->creator_ = (var0 & 1) != 0;
  res->left_ = (var0 & 4) != 0;
  res->broadcast_ = (var0 & 32) != 0;
  res->verified_ = (var0 & 128) != 0;
  res->megagroup_ = (var0 & 256) != 0;
  res->restricted_ = (var0 & 512) != 0;
  res->signatures_ = (var0 & 2048) != 0;
  res->min_ = (var0 & 4096) != 0;
  res->scam_ = (var0 & 524288) != 0;
  res->has_link_ = (var0 & 1048576) != 0;
  res->has_geo_ = (var0 & 2097152) != 0;
  res->slowmode_enabled_ = (var0 & 4194304) != 0;
  res->call_active_ = (var0 & 8388608) != 0;
  res->call_not_empty_ = (var0 & 16777216) != 0;
  res->fake_ = (var0 & 33554432) != 0;
  res->gigagroup_ = (var0 & 67108864) != 0;
  res->noforwards_ = (var0 & 134217728) != 0;
  res->join_to_send_ = (var0 & 268435456) != 0;
  res->join_request_ = (var0 & 536870912) != 0;
  res->forum_ = (var0 & 1073741824) != 0;
  if ((var1 = res->flags2_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->stories_hidden_ = (var1 & 2) != 0;
  res->stories_hidden_min_ = (var1 & 4) != 0;
  res->stories_unavailable_ = (var1 & 8) != 0;
  res->signature_profiles_ = (var1 & 4096) != 0;
  res->autotranslation_ = (var1 & 32768) != 0;
  res->broadcast_messages_allowed_ = (var1 & 65536) != 0;
  res->monoforum_ = (var1 & 131072) != 0;
  res->forum_tabs_ = (var1 & 524288) != 0;
  res->id_ = TlFetchLong::parse(p);
  if (var0 & 8192) { res->access_hash_ = TlFetchLong::parse(p); }
  res->title_ = TlFetchString<string>::parse(p);
  if (var0 & 64) { res->username_ = TlFetchString<string>::parse(p); }
  res->photo_ = TlFetchObject<ChatPhoto>::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 512) { res->restriction_reason_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<restrictionReason>, -797791052>>, 481674261>::parse(p); }
  if (var0 & 16384) { res->admin_rights_ = TlFetchBoxed<TlFetchObject<chatAdminRights>, 1605510357>::parse(p); }
  if (var0 & 32768) { res->banned_rights_ = TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p); }
  if (var0 & 262144) { res->default_banned_rights_ = TlFetchBoxed<TlFetchObject<chatBannedRights>, -1626209256>::parse(p); }
  if (var0 & 131072) { res->participants_count_ = TlFetchInt::parse(p); }
  if (var1 & 1) { res->usernames_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<username>, -1274595769>>, 481674261>::parse(p); }
  if (var1 & 16) { res->stories_max_id_ = TlFetchInt::parse(p); }
  if (var1 & 128) { res->color_ = TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p); }
  if (var1 & 256) { res->profile_color_ = TlFetchBoxed<TlFetchObject<peerColor>, -1253352753>::parse(p); }
  if (var1 & 512) { res->emoji_status_ = TlFetchObject<EmojiStatus>::parse(p); }
  if (var1 & 1024) { res->level_ = TlFetchInt::parse(p); }
  if (var1 & 2048) { res->subscription_until_date_ = TlFetchInt::parse(p); }
  if (var1 & 8192) { res->bot_verification_icon_ = TlFetchLong::parse(p); }
  if (var1 & 16384) { res->send_paid_messages_stars_ = TlFetchLong::parse(p); }
  if (var1 & 262144) { res->linked_monoforum_id_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channel");
  int32 var0;
  int32 var1;
    s.store_field("flags", (var0 = flags_ | (creator_ << 0) | (left_ << 2) | (broadcast_ << 5) | (verified_ << 7) | (megagroup_ << 8) | (restricted_ << 9) | (signatures_ << 11) | (min_ << 12) | (scam_ << 19) | (has_link_ << 20) | (has_geo_ << 21) | (slowmode_enabled_ << 22) | (call_active_ << 23) | (call_not_empty_ << 24) | (fake_ << 25) | (gigagroup_ << 26) | (noforwards_ << 27) | (join_to_send_ << 28) | (join_request_ << 29) | (forum_ << 30)));
    if (var0 & 1) { s.store_field("creator", true); }
    if (var0 & 4) { s.store_field("left", true); }
    if (var0 & 32) { s.store_field("broadcast", true); }
    if (var0 & 128) { s.store_field("verified", true); }
    if (var0 & 256) { s.store_field("megagroup", true); }
    if (var0 & 512) { s.store_field("restricted", true); }
    if (var0 & 2048) { s.store_field("signatures", true); }
    if (var0 & 4096) { s.store_field("min", true); }
    if (var0 & 524288) { s.store_field("scam", true); }
    if (var0 & 1048576) { s.store_field("has_link", true); }
    if (var0 & 2097152) { s.store_field("has_geo", true); }
    if (var0 & 4194304) { s.store_field("slowmode_enabled", true); }
    if (var0 & 8388608) { s.store_field("call_active", true); }
    if (var0 & 16777216) { s.store_field("call_not_empty", true); }
    if (var0 & 33554432) { s.store_field("fake", true); }
    if (var0 & 67108864) { s.store_field("gigagroup", true); }
    if (var0 & 134217728) { s.store_field("noforwards", true); }
    if (var0 & 268435456) { s.store_field("join_to_send", true); }
    if (var0 & 536870912) { s.store_field("join_request", true); }
    if (var0 & 1073741824) { s.store_field("forum", true); }
    s.store_field("flags2", (var1 = flags2_ | (stories_hidden_ << 1) | (stories_hidden_min_ << 2) | (stories_unavailable_ << 3) | (signature_profiles_ << 12) | (autotranslation_ << 15) | (broadcast_messages_allowed_ << 16) | (monoforum_ << 17) | (forum_tabs_ << 19)));
    if (var1 & 2) { s.store_field("stories_hidden", true); }
    if (var1 & 4) { s.store_field("stories_hidden_min", true); }
    if (var1 & 8) { s.store_field("stories_unavailable", true); }
    if (var1 & 4096) { s.store_field("signature_profiles", true); }
    if (var1 & 32768) { s.store_field("autotranslation", true); }
    if (var1 & 65536) { s.store_field("broadcast_messages_allowed", true); }
    if (var1 & 131072) { s.store_field("monoforum", true); }
    if (var1 & 524288) { s.store_field("forum_tabs", true); }
    s.store_field("id", id_);
    if (var0 & 8192) { s.store_field("access_hash", access_hash_); }
    s.store_field("title", title_);
    if (var0 & 64) { s.store_field("username", username_); }
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("date", date_);
    if (var0 & 512) { { s.store_vector_begin("restriction_reason", restriction_reason_.size()); for (const auto &_value : restriction_reason_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 16384) { s.store_object_field("admin_rights", static_cast<const BaseObject *>(admin_rights_.get())); }
    if (var0 & 32768) { s.store_object_field("banned_rights", static_cast<const BaseObject *>(banned_rights_.get())); }
    if (var0 & 262144) { s.store_object_field("default_banned_rights", static_cast<const BaseObject *>(default_banned_rights_.get())); }
    if (var0 & 131072) { s.store_field("participants_count", participants_count_); }
    if (var1 & 1) { { s.store_vector_begin("usernames", usernames_.size()); for (const auto &_value : usernames_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var1 & 16) { s.store_field("stories_max_id", stories_max_id_); }
    if (var1 & 128) { s.store_object_field("color", static_cast<const BaseObject *>(color_.get())); }
    if (var1 & 256) { s.store_object_field("profile_color", static_cast<const BaseObject *>(profile_color_.get())); }
    if (var1 & 512) { s.store_object_field("emoji_status", static_cast<const BaseObject *>(emoji_status_.get())); }
    if (var1 & 1024) { s.store_field("level", level_); }
    if (var1 & 2048) { s.store_field("subscription_until_date", subscription_until_date_); }
    if (var1 & 8192) { s.store_field("bot_verification_icon", bot_verification_icon_); }
    if (var1 & 16384) { s.store_field("send_paid_messages_stars", send_paid_messages_stars_); }
    if (var1 & 262144) { s.store_field("linked_monoforum_id", linked_monoforum_id_); }
    s.store_class_end();
  }
}

channelForbidden::channelForbidden()
  : flags_()
  , broadcast_()
  , megagroup_()
  , id_()
  , access_hash_()
  , title_()
  , until_date_()
{}

channelForbidden::channelForbidden(int32 flags_, bool broadcast_, bool megagroup_, int64 id_, int64 access_hash_, string const &title_, int32 until_date_)
  : flags_(flags_)
  , broadcast_(broadcast_)
  , megagroup_(megagroup_)
  , id_(id_)
  , access_hash_(access_hash_)
  , title_(title_)
  , until_date_(until_date_)
{}

const std::int32_t channelForbidden::ID;

object_ptr<Chat> channelForbidden::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelForbidden> res = make_tl_object<channelForbidden>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->broadcast_ = (var0 & 32) != 0;
  res->megagroup_ = (var0 & 256) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  if (var0 & 65536) { res->until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelForbidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelForbidden");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (broadcast_ << 5) | (megagroup_ << 8)));
    if (var0 & 32) { s.store_field("broadcast", true); }
    if (var0 & 256) { s.store_field("megagroup", true); }
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("title", title_);
    if (var0 & 65536) { s.store_field("until_date", until_date_); }
    s.store_class_end();
  }
}

chatAdminRights::chatAdminRights()
  : flags_()
  , change_info_()
  , post_messages_()
  , edit_messages_()
  , delete_messages_()
  , ban_users_()
  , invite_users_()
  , pin_messages_()
  , add_admins_()
  , anonymous_()
  , manage_call_()
  , other_()
  , manage_topics_()
  , post_stories_()
  , edit_stories_()
  , delete_stories_()
  , manage_direct_messages_()
{}

chatAdminRights::chatAdminRights(int32 flags_, bool change_info_, bool post_messages_, bool edit_messages_, bool delete_messages_, bool ban_users_, bool invite_users_, bool pin_messages_, bool add_admins_, bool anonymous_, bool manage_call_, bool other_, bool manage_topics_, bool post_stories_, bool edit_stories_, bool delete_stories_, bool manage_direct_messages_)
  : flags_(flags_)
  , change_info_(change_info_)
  , post_messages_(post_messages_)
  , edit_messages_(edit_messages_)
  , delete_messages_(delete_messages_)
  , ban_users_(ban_users_)
  , invite_users_(invite_users_)
  , pin_messages_(pin_messages_)
  , add_admins_(add_admins_)
  , anonymous_(anonymous_)
  , manage_call_(manage_call_)
  , other_(other_)
  , manage_topics_(manage_topics_)
  , post_stories_(post_stories_)
  , edit_stories_(edit_stories_)
  , delete_stories_(delete_stories_)
  , manage_direct_messages_(manage_direct_messages_)
{}

const std::int32_t chatAdminRights::ID;

object_ptr<chatAdminRights> chatAdminRights::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatAdminRights> res = make_tl_object<chatAdminRights>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->change_info_ = (var0 & 1) != 0;
  res->post_messages_ = (var0 & 2) != 0;
  res->edit_messages_ = (var0 & 4) != 0;
  res->delete_messages_ = (var0 & 8) != 0;
  res->ban_users_ = (var0 & 16) != 0;
  res->invite_users_ = (var0 & 32) != 0;
  res->pin_messages_ = (var0 & 128) != 0;
  res->add_admins_ = (var0 & 512) != 0;
  res->anonymous_ = (var0 & 1024) != 0;
  res->manage_call_ = (var0 & 2048) != 0;
  res->other_ = (var0 & 4096) != 0;
  res->manage_topics_ = (var0 & 8192) != 0;
  res->post_stories_ = (var0 & 16384) != 0;
  res->edit_stories_ = (var0 & 32768) != 0;
  res->delete_stories_ = (var0 & 65536) != 0;
  res->manage_direct_messages_ = (var0 & 131072) != 0;
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void chatAdminRights::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (change_info_ << 0) | (post_messages_ << 1) | (edit_messages_ << 2) | (delete_messages_ << 3) | (ban_users_ << 4) | (invite_users_ << 5) | (pin_messages_ << 7) | (add_admins_ << 9) | (anonymous_ << 10) | (manage_call_ << 11) | (other_ << 12) | (manage_topics_ << 13) | (post_stories_ << 14) | (edit_stories_ << 15) | (delete_stories_ << 16) | (manage_direct_messages_ << 17)), s);
}

void chatAdminRights::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (change_info_ << 0) | (post_messages_ << 1) | (edit_messages_ << 2) | (delete_messages_ << 3) | (ban_users_ << 4) | (invite_users_ << 5) | (pin_messages_ << 7) | (add_admins_ << 9) | (anonymous_ << 10) | (manage_call_ << 11) | (other_ << 12) | (manage_topics_ << 13) | (post_stories_ << 14) | (edit_stories_ << 15) | (delete_stories_ << 16) | (manage_direct_messages_ << 17)), s);
}

void chatAdminRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAdminRights");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (change_info_ << 0) | (post_messages_ << 1) | (edit_messages_ << 2) | (delete_messages_ << 3) | (ban_users_ << 4) | (invite_users_ << 5) | (pin_messages_ << 7) | (add_admins_ << 9) | (anonymous_ << 10) | (manage_call_ << 11) | (other_ << 12) | (manage_topics_ << 13) | (post_stories_ << 14) | (edit_stories_ << 15) | (delete_stories_ << 16) | (manage_direct_messages_ << 17)));
    if (var0 & 1) { s.store_field("change_info", true); }
    if (var0 & 2) { s.store_field("post_messages", true); }
    if (var0 & 4) { s.store_field("edit_messages", true); }
    if (var0 & 8) { s.store_field("delete_messages", true); }
    if (var0 & 16) { s.store_field("ban_users", true); }
    if (var0 & 32) { s.store_field("invite_users", true); }
    if (var0 & 128) { s.store_field("pin_messages", true); }
    if (var0 & 512) { s.store_field("add_admins", true); }
    if (var0 & 1024) { s.store_field("anonymous", true); }
    if (var0 & 2048) { s.store_field("manage_call", true); }
    if (var0 & 4096) { s.store_field("other", true); }
    if (var0 & 8192) { s.store_field("manage_topics", true); }
    if (var0 & 16384) { s.store_field("post_stories", true); }
    if (var0 & 32768) { s.store_field("edit_stories", true); }
    if (var0 & 65536) { s.store_field("delete_stories", true); }
    if (var0 & 131072) { s.store_field("manage_direct_messages", true); }
    s.store_class_end();
  }
}

const std::int32_t chatAdminWithInvites::ID;

object_ptr<chatAdminWithInvites> chatAdminWithInvites::fetch(TlBufferParser &p) {
  return make_tl_object<chatAdminWithInvites>(p);
}

chatAdminWithInvites::chatAdminWithInvites(TlBufferParser &p)
  : admin_id_(TlFetchLong::parse(p))
  , invites_count_(TlFetchInt::parse(p))
  , revoked_invites_count_(TlFetchInt::parse(p))
{}

void chatAdminWithInvites::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAdminWithInvites");
    s.store_field("admin_id", admin_id_);
    s.store_field("invites_count", invites_count_);
    s.store_field("revoked_invites_count", revoked_invites_count_);
    s.store_class_end();
  }
}

chatBannedRights::chatBannedRights()
  : flags_()
  , view_messages_()
  , send_messages_()
  , send_media_()
  , send_stickers_()
  , send_gifs_()
  , send_games_()
  , send_inline_()
  , embed_links_()
  , send_polls_()
  , change_info_()
  , invite_users_()
  , pin_messages_()
  , manage_topics_()
  , send_photos_()
  , send_videos_()
  , send_roundvideos_()
  , send_audios_()
  , send_voices_()
  , send_docs_()
  , send_plain_()
  , until_date_()
{}

chatBannedRights::chatBannedRights(int32 flags_, bool view_messages_, bool send_messages_, bool send_media_, bool send_stickers_, bool send_gifs_, bool send_games_, bool send_inline_, bool embed_links_, bool send_polls_, bool change_info_, bool invite_users_, bool pin_messages_, bool manage_topics_, bool send_photos_, bool send_videos_, bool send_roundvideos_, bool send_audios_, bool send_voices_, bool send_docs_, bool send_plain_, int32 until_date_)
  : flags_(flags_)
  , view_messages_(view_messages_)
  , send_messages_(send_messages_)
  , send_media_(send_media_)
  , send_stickers_(send_stickers_)
  , send_gifs_(send_gifs_)
  , send_games_(send_games_)
  , send_inline_(send_inline_)
  , embed_links_(embed_links_)
  , send_polls_(send_polls_)
  , change_info_(change_info_)
  , invite_users_(invite_users_)
  , pin_messages_(pin_messages_)
  , manage_topics_(manage_topics_)
  , send_photos_(send_photos_)
  , send_videos_(send_videos_)
  , send_roundvideos_(send_roundvideos_)
  , send_audios_(send_audios_)
  , send_voices_(send_voices_)
  , send_docs_(send_docs_)
  , send_plain_(send_plain_)
  , until_date_(until_date_)
{}

const std::int32_t chatBannedRights::ID;

object_ptr<chatBannedRights> chatBannedRights::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatBannedRights> res = make_tl_object<chatBannedRights>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->view_messages_ = (var0 & 1) != 0;
  res->send_messages_ = (var0 & 2) != 0;
  res->send_media_ = (var0 & 4) != 0;
  res->send_stickers_ = (var0 & 8) != 0;
  res->send_gifs_ = (var0 & 16) != 0;
  res->send_games_ = (var0 & 32) != 0;
  res->send_inline_ = (var0 & 64) != 0;
  res->embed_links_ = (var0 & 128) != 0;
  res->send_polls_ = (var0 & 256) != 0;
  res->change_info_ = (var0 & 1024) != 0;
  res->invite_users_ = (var0 & 32768) != 0;
  res->pin_messages_ = (var0 & 131072) != 0;
  res->manage_topics_ = (var0 & 262144) != 0;
  res->send_photos_ = (var0 & 524288) != 0;
  res->send_videos_ = (var0 & 1048576) != 0;
  res->send_roundvideos_ = (var0 & 2097152) != 0;
  res->send_audios_ = (var0 & 4194304) != 0;
  res->send_voices_ = (var0 & 8388608) != 0;
  res->send_docs_ = (var0 & 16777216) != 0;
  res->send_plain_ = (var0 & 33554432) != 0;
  res->until_date_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void chatBannedRights::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (view_messages_ << 0) | (send_messages_ << 1) | (send_media_ << 2) | (send_stickers_ << 3) | (send_gifs_ << 4) | (send_games_ << 5) | (send_inline_ << 6) | (embed_links_ << 7) | (send_polls_ << 8) | (change_info_ << 10) | (invite_users_ << 15) | (pin_messages_ << 17) | (manage_topics_ << 18) | (send_photos_ << 19) | (send_videos_ << 20) | (send_roundvideos_ << 21) | (send_audios_ << 22) | (send_voices_ << 23) | (send_docs_ << 24) | (send_plain_ << 25)), s);
  TlStoreBinary::store(until_date_, s);
}

void chatBannedRights::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (view_messages_ << 0) | (send_messages_ << 1) | (send_media_ << 2) | (send_stickers_ << 3) | (send_gifs_ << 4) | (send_games_ << 5) | (send_inline_ << 6) | (embed_links_ << 7) | (send_polls_ << 8) | (change_info_ << 10) | (invite_users_ << 15) | (pin_messages_ << 17) | (manage_topics_ << 18) | (send_photos_ << 19) | (send_videos_ << 20) | (send_roundvideos_ << 21) | (send_audios_ << 22) | (send_voices_ << 23) | (send_docs_ << 24) | (send_plain_ << 25)), s);
  TlStoreBinary::store(until_date_, s);
}

void chatBannedRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBannedRights");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (view_messages_ << 0) | (send_messages_ << 1) | (send_media_ << 2) | (send_stickers_ << 3) | (send_gifs_ << 4) | (send_games_ << 5) | (send_inline_ << 6) | (embed_links_ << 7) | (send_polls_ << 8) | (change_info_ << 10) | (invite_users_ << 15) | (pin_messages_ << 17) | (manage_topics_ << 18) | (send_photos_ << 19) | (send_videos_ << 20) | (send_roundvideos_ << 21) | (send_audios_ << 22) | (send_voices_ << 23) | (send_docs_ << 24) | (send_plain_ << 25)));
    if (var0 & 1) { s.store_field("view_messages", true); }
    if (var0 & 2) { s.store_field("send_messages", true); }
    if (var0 & 4) { s.store_field("send_media", true); }
    if (var0 & 8) { s.store_field("send_stickers", true); }
    if (var0 & 16) { s.store_field("send_gifs", true); }
    if (var0 & 32) { s.store_field("send_games", true); }
    if (var0 & 64) { s.store_field("send_inline", true); }
    if (var0 & 128) { s.store_field("embed_links", true); }
    if (var0 & 256) { s.store_field("send_polls", true); }
    if (var0 & 1024) { s.store_field("change_info", true); }
    if (var0 & 32768) { s.store_field("invite_users", true); }
    if (var0 & 131072) { s.store_field("pin_messages", true); }
    if (var0 & 262144) { s.store_field("manage_topics", true); }
    if (var0 & 524288) { s.store_field("send_photos", true); }
    if (var0 & 1048576) { s.store_field("send_videos", true); }
    if (var0 & 2097152) { s.store_field("send_roundvideos", true); }
    if (var0 & 4194304) { s.store_field("send_audios", true); }
    if (var0 & 8388608) { s.store_field("send_voices", true); }
    if (var0 & 16777216) { s.store_field("send_docs", true); }
    if (var0 & 33554432) { s.store_field("send_plain", true); }
    s.store_field("until_date", until_date_);
    s.store_class_end();
  }
}

object_ptr<ChatFull> ChatFull::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatFull::ID:
      return chatFull::fetch(p);
    case channelFull::ID:
      return channelFull::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

chatFull::chatFull()
  : flags_()
  , can_set_username_()
  , has_scheduled_()
  , translations_disabled_()
  , id_()
  , about_()
  , participants_()
  , chat_photo_()
  , notify_settings_()
  , exported_invite_()
  , bot_info_()
  , pinned_msg_id_()
  , folder_id_()
  , call_()
  , ttl_period_()
  , groupcall_default_join_as_()
  , theme_emoticon_()
  , requests_pending_()
  , recent_requesters_()
  , available_reactions_()
  , reactions_limit_()
{}

const std::int32_t chatFull::ID;

object_ptr<ChatFull> chatFull::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatFull> res = make_tl_object<chatFull>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->can_set_username_ = (var0 & 128) != 0;
  res->has_scheduled_ = (var0 & 256) != 0;
  res->translations_disabled_ = (var0 & 524288) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->about_ = TlFetchString<string>::parse(p);
  res->participants_ = TlFetchObject<ChatParticipants>::parse(p);
  if (var0 & 4) { res->chat_photo_ = TlFetchObject<Photo>::parse(p); }
  res->notify_settings_ = TlFetchBoxed<TlFetchObject<peerNotifySettings>, -1721619444>::parse(p);
  if (var0 & 8192) { res->exported_invite_ = TlFetchObject<ExportedChatInvite>::parse(p); }
  if (var0 & 8) { res->bot_info_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<botInfo>, 1300890265>>, 481674261>::parse(p); }
  if (var0 & 64) { res->pinned_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 2048) { res->folder_id_ = TlFetchInt::parse(p); }
  if (var0 & 4096) { res->call_ = TlFetchObject<InputGroupCall>::parse(p); }
  if (var0 & 16384) { res->ttl_period_ = TlFetchInt::parse(p); }
  if (var0 & 32768) { res->groupcall_default_join_as_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 65536) { res->theme_emoticon_ = TlFetchString<string>::parse(p); }
  if (var0 & 131072) { res->requests_pending_ = TlFetchInt::parse(p); }
  if (var0 & 131072) { res->recent_requesters_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (var0 & 262144) { res->available_reactions_ = TlFetchObject<ChatReactions>::parse(p); }
  if (var0 & 1048576) { res->reactions_limit_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatFull::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFull");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (can_set_username_ << 7) | (has_scheduled_ << 8) | (translations_disabled_ << 19)));
    if (var0 & 128) { s.store_field("can_set_username", true); }
    if (var0 & 256) { s.store_field("has_scheduled", true); }
    if (var0 & 524288) { s.store_field("translations_disabled", true); }
    s.store_field("id", id_);
    s.store_field("about", about_);
    s.store_object_field("participants", static_cast<const BaseObject *>(participants_.get()));
    if (var0 & 4) { s.store_object_field("chat_photo", static_cast<const BaseObject *>(chat_photo_.get())); }
    s.store_object_field("notify_settings", static_cast<const BaseObject *>(notify_settings_.get()));
    if (var0 & 8192) { s.store_object_field("exported_invite", static_cast<const BaseObject *>(exported_invite_.get())); }
    if (var0 & 8) { { s.store_vector_begin("bot_info", bot_info_.size()); for (const auto &_value : bot_info_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 64) { s.store_field("pinned_msg_id", pinned_msg_id_); }
    if (var0 & 2048) { s.store_field("folder_id", folder_id_); }
    if (var0 & 4096) { s.store_object_field("call", static_cast<const BaseObject *>(call_.get())); }
    if (var0 & 16384) { s.store_field("ttl_period", ttl_period_); }
    if (var0 & 32768) { s.store_object_field("groupcall_default_join_as", static_cast<const BaseObject *>(groupcall_default_join_as_.get())); }
    if (var0 & 65536) { s.store_field("theme_emoticon", theme_emoticon_); }
    if (var0 & 131072) { s.store_field("requests_pending", requests_pending_); }
    if (var0 & 131072) { { s.store_vector_begin("recent_requesters", recent_requesters_.size()); for (const auto &_value : recent_requesters_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 262144) { s.store_object_field("available_reactions", static_cast<const BaseObject *>(available_reactions_.get())); }
    if (var0 & 1048576) { s.store_field("reactions_limit", reactions_limit_); }
    s.store_class_end();
  }
}

channelFull::channelFull()
  : flags_()
  , can_view_participants_()
  , can_set_username_()
  , can_set_stickers_()
  , hidden_prehistory_()
  , can_set_location_()
  , has_scheduled_()
  , can_view_stats_()
  , blocked_()
  , flags2_()
  , can_delete_channel_()
  , antispam_()
  , participants_hidden_()
  , translations_disabled_()
  , stories_pinned_available_()
  , view_forum_as_messages_()
  , restricted_sponsored_()
  , can_view_revenue_()
  , paid_media_allowed_()
  , can_view_stars_revenue_()
  , paid_reactions_available_()
  , stargifts_available_()
  , paid_messages_available_()
  , id_()
  , about_()
  , participants_count_()
  , admins_count_()
  , kicked_count_()
  , banned_count_()
  , online_count_()
  , read_inbox_max_id_()
  , read_outbox_max_id_()
  , unread_count_()
  , chat_photo_()
  , notify_settings_()
  , exported_invite_()
  , bot_info_()
  , migrated_from_chat_id_()
  , migrated_from_max_id_()
  , pinned_msg_id_()
  , stickerset_()
  , available_min_id_()
  , folder_id_()
  , linked_chat_id_()
  , location_()
  , slowmode_seconds_()
  , slowmode_next_send_date_()
  , stats_dc_()
  , pts_()
  , call_()
  , ttl_period_()
  , pending_suggestions_()
  , groupcall_default_join_as_()
  , theme_emoticon_()
  , requests_pending_()
  , recent_requesters_()
  , default_send_as_()
  , available_reactions_()
  , reactions_limit_()
  , stories_()
  , wallpaper_()
  , boosts_applied_()
  , boosts_unrestrict_()
  , emojiset_()
  , bot_verification_()
  , stargifts_count_()
  , send_paid_messages_stars_()
{}

const std::int32_t channelFull::ID;

object_ptr<ChatFull> channelFull::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<channelFull> res = make_tl_object<channelFull>();
  int32 var0;
  int32 var1;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->can_view_participants_ = (var0 & 8) != 0;
  res->can_set_username_ = (var0 & 64) != 0;
  res->can_set_stickers_ = (var0 & 128) != 0;
  res->hidden_prehistory_ = (var0 & 1024) != 0;
  res->can_set_location_ = (var0 & 65536) != 0;
  res->has_scheduled_ = (var0 & 524288) != 0;
  res->can_view_stats_ = (var0 & 1048576) != 0;
  res->blocked_ = (var0 & 4194304) != 0;
  if ((var1 = res->flags2_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->can_delete_channel_ = (var1 & 1) != 0;
  res->antispam_ = (var1 & 2) != 0;
  res->participants_hidden_ = (var1 & 4) != 0;
  res->translations_disabled_ = (var1 & 8) != 0;
  res->stories_pinned_available_ = (var1 & 32) != 0;
  res->view_forum_as_messages_ = (var1 & 64) != 0;
  res->restricted_sponsored_ = (var1 & 2048) != 0;
  res->can_view_revenue_ = (var1 & 4096) != 0;
  res->paid_media_allowed_ = (var1 & 16384) != 0;
  res->can_view_stars_revenue_ = (var1 & 32768) != 0;
  res->paid_reactions_available_ = (var1 & 65536) != 0;
  res->stargifts_available_ = (var1 & 524288) != 0;
  res->paid_messages_available_ = (var1 & 1048576) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->about_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->participants_count_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->admins_count_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->kicked_count_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->banned_count_ = TlFetchInt::parse(p); }
  if (var0 & 8192) { res->online_count_ = TlFetchInt::parse(p); }
  res->read_inbox_max_id_ = TlFetchInt::parse(p);
  res->read_outbox_max_id_ = TlFetchInt::parse(p);
  res->unread_count_ = TlFetchInt::parse(p);
  res->chat_photo_ = TlFetchObject<Photo>::parse(p);
  res->notify_settings_ = TlFetchBoxed<TlFetchObject<peerNotifySettings>, -1721619444>::parse(p);
  if (var0 & 8388608) { res->exported_invite_ = TlFetchObject<ExportedChatInvite>::parse(p); }
  res->bot_info_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<botInfo>, 1300890265>>, 481674261>::parse(p);
  if (var0 & 16) { res->migrated_from_chat_id_ = TlFetchLong::parse(p); }
  if (var0 & 16) { res->migrated_from_max_id_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->pinned_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 256) { res->stickerset_ = TlFetchBoxed<TlFetchObject<stickerSet>, 768691932>::parse(p); }
  if (var0 & 512) { res->available_min_id_ = TlFetchInt::parse(p); }
  if (var0 & 2048) { res->folder_id_ = TlFetchInt::parse(p); }
  if (var0 & 16384) { res->linked_chat_id_ = TlFetchLong::parse(p); }
  if (var0 & 32768) { res->location_ = TlFetchObject<ChannelLocation>::parse(p); }
  if (var0 & 131072) { res->slowmode_seconds_ = TlFetchInt::parse(p); }
  if (var0 & 262144) { res->slowmode_next_send_date_ = TlFetchInt::parse(p); }
  if (var0 & 4096) { res->stats_dc_ = TlFetchInt::parse(p); }
  res->pts_ = TlFetchInt::parse(p);
  if (var0 & 2097152) { res->call_ = TlFetchObject<InputGroupCall>::parse(p); }
  if (var0 & 16777216) { res->ttl_period_ = TlFetchInt::parse(p); }
  if (var0 & 33554432) { res->pending_suggestions_ = TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p); }
  if (var0 & 67108864) { res->groupcall_default_join_as_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 134217728) { res->theme_emoticon_ = TlFetchString<string>::parse(p); }
  if (var0 & 268435456) { res->requests_pending_ = TlFetchInt::parse(p); }
  if (var0 & 268435456) { res->recent_requesters_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (var0 & 536870912) { res->default_send_as_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 1073741824) { res->available_reactions_ = TlFetchObject<ChatReactions>::parse(p); }
  if (var1 & 8192) { res->reactions_limit_ = TlFetchInt::parse(p); }
  if (var1 & 16) { res->stories_ = TlFetchBoxed<TlFetchObject<peerStories>, -1707742823>::parse(p); }
  if (var1 & 128) { res->wallpaper_ = TlFetchObject<WallPaper>::parse(p); }
  if (var1 & 256) { res->boosts_applied_ = TlFetchInt::parse(p); }
  if (var1 & 512) { res->boosts_unrestrict_ = TlFetchInt::parse(p); }
  if (var1 & 1024) { res->emojiset_ = TlFetchBoxed<TlFetchObject<stickerSet>, 768691932>::parse(p); }
  if (var1 & 131072) { res->bot_verification_ = TlFetchBoxed<TlFetchObject<botVerification>, -113453988>::parse(p); }
  if (var1 & 262144) { res->stargifts_count_ = TlFetchInt::parse(p); }
  if (var1 & 2097152) { res->send_paid_messages_stars_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void channelFull::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "channelFull");
  int32 var0;
  int32 var1;
    s.store_field("flags", (var0 = flags_ | (can_view_participants_ << 3) | (can_set_username_ << 6) | (can_set_stickers_ << 7) | (hidden_prehistory_ << 10) | (can_set_location_ << 16) | (has_scheduled_ << 19) | (can_view_stats_ << 20) | (blocked_ << 22)));
    if (var0 & 8) { s.store_field("can_view_participants", true); }
    if (var0 & 64) { s.store_field("can_set_username", true); }
    if (var0 & 128) { s.store_field("can_set_stickers", true); }
    if (var0 & 1024) { s.store_field("hidden_prehistory", true); }
    if (var0 & 65536) { s.store_field("can_set_location", true); }
    if (var0 & 524288) { s.store_field("has_scheduled", true); }
    if (var0 & 1048576) { s.store_field("can_view_stats", true); }
    if (var0 & 4194304) { s.store_field("blocked", true); }
    s.store_field("flags2", (var1 = flags2_ | (can_delete_channel_ << 0) | (antispam_ << 1) | (participants_hidden_ << 2) | (translations_disabled_ << 3) | (stories_pinned_available_ << 5) | (view_forum_as_messages_ << 6) | (restricted_sponsored_ << 11) | (can_view_revenue_ << 12) | (paid_media_allowed_ << 14) | (can_view_stars_revenue_ << 15) | (paid_reactions_available_ << 16) | (stargifts_available_ << 19) | (paid_messages_available_ << 20)));
    if (var1 & 1) { s.store_field("can_delete_channel", true); }
    if (var1 & 2) { s.store_field("antispam", true); }
    if (var1 & 4) { s.store_field("participants_hidden", true); }
    if (var1 & 8) { s.store_field("translations_disabled", true); }
    if (var1 & 32) { s.store_field("stories_pinned_available", true); }
    if (var1 & 64) { s.store_field("view_forum_as_messages", true); }
    if (var1 & 2048) { s.store_field("restricted_sponsored", true); }
    if (var1 & 4096) { s.store_field("can_view_revenue", true); }
    if (var1 & 16384) { s.store_field("paid_media_allowed", true); }
    if (var1 & 32768) { s.store_field("can_view_stars_revenue", true); }
    if (var1 & 65536) { s.store_field("paid_reactions_available", true); }
    if (var1 & 524288) { s.store_field("stargifts_available", true); }
    if (var1 & 1048576) { s.store_field("paid_messages_available", true); }
    s.store_field("id", id_);
    s.store_field("about", about_);
    if (var0 & 1) { s.store_field("participants_count", participants_count_); }
    if (var0 & 2) { s.store_field("admins_count", admins_count_); }
    if (var0 & 4) { s.store_field("kicked_count", kicked_count_); }
    if (var0 & 4) { s.store_field("banned_count", banned_count_); }
    if (var0 & 8192) { s.store_field("online_count", online_count_); }
    s.store_field("read_inbox_max_id", read_inbox_max_id_);
    s.store_field("read_outbox_max_id", read_outbox_max_id_);
    s.store_field("unread_count", unread_count_);
    s.store_object_field("chat_photo", static_cast<const BaseObject *>(chat_photo_.get()));
    s.store_object_field("notify_settings", static_cast<const BaseObject *>(notify_settings_.get()));
    if (var0 & 8388608) { s.store_object_field("exported_invite", static_cast<const BaseObject *>(exported_invite_.get())); }
    { s.store_vector_begin("bot_info", bot_info_.size()); for (const auto &_value : bot_info_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 16) { s.store_field("migrated_from_chat_id", migrated_from_chat_id_); }
    if (var0 & 16) { s.store_field("migrated_from_max_id", migrated_from_max_id_); }
    if (var0 & 32) { s.store_field("pinned_msg_id", pinned_msg_id_); }
    if (var0 & 256) { s.store_object_field("stickerset", static_cast<const BaseObject *>(stickerset_.get())); }
    if (var0 & 512) { s.store_field("available_min_id", available_min_id_); }
    if (var0 & 2048) { s.store_field("folder_id", folder_id_); }
    if (var0 & 16384) { s.store_field("linked_chat_id", linked_chat_id_); }
    if (var0 & 32768) { s.store_object_field("location", static_cast<const BaseObject *>(location_.get())); }
    if (var0 & 131072) { s.store_field("slowmode_seconds", slowmode_seconds_); }
    if (var0 & 262144) { s.store_field("slowmode_next_send_date", slowmode_next_send_date_); }
    if (var0 & 4096) { s.store_field("stats_dc", stats_dc_); }
    s.store_field("pts", pts_);
    if (var0 & 2097152) { s.store_object_field("call", static_cast<const BaseObject *>(call_.get())); }
    if (var0 & 16777216) { s.store_field("ttl_period", ttl_period_); }
    if (var0 & 33554432) { { s.store_vector_begin("pending_suggestions", pending_suggestions_.size()); for (const auto &_value : pending_suggestions_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 67108864) { s.store_object_field("groupcall_default_join_as", static_cast<const BaseObject *>(groupcall_default_join_as_.get())); }
    if (var0 & 134217728) { s.store_field("theme_emoticon", theme_emoticon_); }
    if (var0 & 268435456) { s.store_field("requests_pending", requests_pending_); }
    if (var0 & 268435456) { { s.store_vector_begin("recent_requesters", recent_requesters_.size()); for (const auto &_value : recent_requesters_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 536870912) { s.store_object_field("default_send_as", static_cast<const BaseObject *>(default_send_as_.get())); }
    if (var0 & 1073741824) { s.store_object_field("available_reactions", static_cast<const BaseObject *>(available_reactions_.get())); }
    if (var1 & 8192) { s.store_field("reactions_limit", reactions_limit_); }
    if (var1 & 16) { s.store_object_field("stories", static_cast<const BaseObject *>(stories_.get())); }
    if (var1 & 128) { s.store_object_field("wallpaper", static_cast<const BaseObject *>(wallpaper_.get())); }
    if (var1 & 256) { s.store_field("boosts_applied", boosts_applied_); }
    if (var1 & 512) { s.store_field("boosts_unrestrict", boosts_unrestrict_); }
    if (var1 & 1024) { s.store_object_field("emojiset", static_cast<const BaseObject *>(emojiset_.get())); }
    if (var1 & 131072) { s.store_object_field("bot_verification", static_cast<const BaseObject *>(bot_verification_.get())); }
    if (var1 & 262144) { s.store_field("stargifts_count", stargifts_count_); }
    if (var1 & 2097152) { s.store_field("send_paid_messages_stars", send_paid_messages_stars_); }
    s.store_class_end();
  }
}

object_ptr<ChatInvite> ChatInvite::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatInviteAlready::ID:
      return chatInviteAlready::fetch(p);
    case chatInvite::ID:
      return chatInvite::fetch(p);
    case chatInvitePeek::ID:
      return chatInvitePeek::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t chatInviteAlready::ID;

object_ptr<ChatInvite> chatInviteAlready::fetch(TlBufferParser &p) {
  return make_tl_object<chatInviteAlready>(p);
}

chatInviteAlready::chatInviteAlready(TlBufferParser &p)
  : chat_(TlFetchObject<Chat>::parse(p))
{}

void chatInviteAlready::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteAlready");
    s.store_object_field("chat", static_cast<const BaseObject *>(chat_.get()));
    s.store_class_end();
  }
}

chatInvite::chatInvite()
  : flags_()
  , channel_()
  , broadcast_()
  , public_()
  , megagroup_()
  , request_needed_()
  , verified_()
  , scam_()
  , fake_()
  , can_refulfill_subscription_()
  , title_()
  , about_()
  , photo_()
  , participants_count_()
  , participants_()
  , color_()
  , subscription_pricing_()
  , subscription_form_id_()
  , bot_verification_()
{}

const std::int32_t chatInvite::ID;

object_ptr<ChatInvite> chatInvite::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatInvite> res = make_tl_object<chatInvite>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->channel_ = (var0 & 1) != 0;
  res->broadcast_ = (var0 & 2) != 0;
  res->public_ = (var0 & 4) != 0;
  res->megagroup_ = (var0 & 8) != 0;
  res->request_needed_ = (var0 & 64) != 0;
  res->verified_ = (var0 & 128) != 0;
  res->scam_ = (var0 & 256) != 0;
  res->fake_ = (var0 & 512) != 0;
  res->can_refulfill_subscription_ = (var0 & 2048) != 0;
  res->title_ = TlFetchString<string>::parse(p);
  if (var0 & 32) { res->about_ = TlFetchString<string>::parse(p); }
  res->photo_ = TlFetchObject<Photo>::parse(p);
  res->participants_count_ = TlFetchInt::parse(p);
  if (var0 & 16) { res->participants_ = TlFetchBoxed<TlFetchVector<TlFetchObject<User>>, 481674261>::parse(p); }
  res->color_ = TlFetchInt::parse(p);
  if (var0 & 1024) { res->subscription_pricing_ = TlFetchBoxed<TlFetchObject<starsSubscriptionPricing>, 88173912>::parse(p); }
  if (var0 & 4096) { res->subscription_form_id_ = TlFetchLong::parse(p); }
  if (var0 & 8192) { res->bot_verification_ = TlFetchBoxed<TlFetchObject<botVerification>, -113453988>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInvite");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (channel_ << 0) | (broadcast_ << 1) | (public_ << 2) | (megagroup_ << 3) | (request_needed_ << 6) | (verified_ << 7) | (scam_ << 8) | (fake_ << 9) | (can_refulfill_subscription_ << 11)));
    if (var0 & 1) { s.store_field("channel", true); }
    if (var0 & 2) { s.store_field("broadcast", true); }
    if (var0 & 4) { s.store_field("public", true); }
    if (var0 & 8) { s.store_field("megagroup", true); }
    if (var0 & 64) { s.store_field("request_needed", true); }
    if (var0 & 128) { s.store_field("verified", true); }
    if (var0 & 256) { s.store_field("scam", true); }
    if (var0 & 512) { s.store_field("fake", true); }
    if (var0 & 2048) { s.store_field("can_refulfill_subscription", true); }
    s.store_field("title", title_);
    if (var0 & 32) { s.store_field("about", about_); }
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("participants_count", participants_count_);
    if (var0 & 16) { { s.store_vector_begin("participants", participants_.size()); for (const auto &_value : participants_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_field("color", color_);
    if (var0 & 1024) { s.store_object_field("subscription_pricing", static_cast<const BaseObject *>(subscription_pricing_.get())); }
    if (var0 & 4096) { s.store_field("subscription_form_id", subscription_form_id_); }
    if (var0 & 8192) { s.store_object_field("bot_verification", static_cast<const BaseObject *>(bot_verification_.get())); }
    s.store_class_end();
  }
}

const std::int32_t chatInvitePeek::ID;

object_ptr<ChatInvite> chatInvitePeek::fetch(TlBufferParser &p) {
  return make_tl_object<chatInvitePeek>(p);
}

chatInvitePeek::chatInvitePeek(TlBufferParser &p)
  : chat_(TlFetchObject<Chat>::parse(p))
  , expires_(TlFetchInt::parse(p))
{}

void chatInvitePeek::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInvitePeek");
    s.store_object_field("chat", static_cast<const BaseObject *>(chat_.get()));
    s.store_field("expires", expires_);
    s.store_class_end();
  }
}

chatInviteImporter::chatInviteImporter()
  : flags_()
  , requested_()
  , via_chatlist_()
  , user_id_()
  , date_()
  , about_()
  , approved_by_()
{}

const std::int32_t chatInviteImporter::ID;

object_ptr<chatInviteImporter> chatInviteImporter::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatInviteImporter> res = make_tl_object<chatInviteImporter>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->requested_ = (var0 & 1) != 0;
  res->via_chatlist_ = (var0 & 8) != 0;
  res->user_id_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 4) { res->about_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->approved_by_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void chatInviteImporter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteImporter");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (requested_ << 0) | (via_chatlist_ << 3)));
    if (var0 & 1) { s.store_field("requested", true); }
    if (var0 & 8) { s.store_field("via_chatlist", true); }
    s.store_field("user_id", user_id_);
    s.store_field("date", date_);
    if (var0 & 4) { s.store_field("about", about_); }
    if (var0 & 2) { s.store_field("approved_by", approved_by_); }
    s.store_class_end();
  }
}

const std::int32_t chatOnlines::ID;

object_ptr<chatOnlines> chatOnlines::fetch(TlBufferParser &p) {
  return make_tl_object<chatOnlines>(p);
}

chatOnlines::chatOnlines(TlBufferParser &p)
  : onlines_(TlFetchInt::parse(p))
{}

void chatOnlines::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatOnlines");
    s.store_field("onlines", onlines_);
    s.store_class_end();
  }
}

object_ptr<ChatParticipant> ChatParticipant::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatParticipant::ID:
      return chatParticipant::fetch(p);
    case chatParticipantCreator::ID:
      return chatParticipantCreator::fetch(p);
    case chatParticipantAdmin::ID:
      return chatParticipantAdmin::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t chatParticipant::ID;

object_ptr<ChatParticipant> chatParticipant::fetch(TlBufferParser &p) {
  return make_tl_object<chatParticipant>(p);
}

chatParticipant::chatParticipant(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , inviter_id_(TlFetchLong::parse(p))
  , date_(TlFetchInt::parse(p))
{}

void chatParticipant::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatParticipant");
    s.store_field("user_id", user_id_);
    s.store_field("inviter_id", inviter_id_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

const std::int32_t chatParticipantCreator::ID;

object_ptr<ChatParticipant> chatParticipantCreator::fetch(TlBufferParser &p) {
  return make_tl_object<chatParticipantCreator>(p);
}

chatParticipantCreator::chatParticipantCreator(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
{}

void chatParticipantCreator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatParticipantCreator");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

const std::int32_t chatParticipantAdmin::ID;

object_ptr<ChatParticipant> chatParticipantAdmin::fetch(TlBufferParser &p) {
  return make_tl_object<chatParticipantAdmin>(p);
}

chatParticipantAdmin::chatParticipantAdmin(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , inviter_id_(TlFetchLong::parse(p))
  , date_(TlFetchInt::parse(p))
{}

void chatParticipantAdmin::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatParticipantAdmin");
    s.store_field("user_id", user_id_);
    s.store_field("inviter_id", inviter_id_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

object_ptr<ChatParticipants> ChatParticipants::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatParticipantsForbidden::ID:
      return chatParticipantsForbidden::fetch(p);
    case chatParticipants::ID:
      return chatParticipants::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

chatParticipantsForbidden::chatParticipantsForbidden()
  : flags_()
  , chat_id_()
  , self_participant_()
{}

const std::int32_t chatParticipantsForbidden::ID;

object_ptr<ChatParticipants> chatParticipantsForbidden::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatParticipantsForbidden> res = make_tl_object<chatParticipantsForbidden>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->chat_id_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->self_participant_ = TlFetchObject<ChatParticipant>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatParticipantsForbidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatParticipantsForbidden");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("chat_id", chat_id_);
    if (var0 & 1) { s.store_object_field("self_participant", static_cast<const BaseObject *>(self_participant_.get())); }
    s.store_class_end();
  }
}

const std::int32_t chatParticipants::ID;

object_ptr<ChatParticipants> chatParticipants::fetch(TlBufferParser &p) {
  return make_tl_object<chatParticipants>(p);
}

chatParticipants::chatParticipants(TlBufferParser &p)
  : chat_id_(TlFetchLong::parse(p))
  , participants_(TlFetchBoxed<TlFetchVector<TlFetchObject<ChatParticipant>>, 481674261>::parse(p))
  , version_(TlFetchInt::parse(p))
{}

void chatParticipants::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatParticipants");
    s.store_field("chat_id", chat_id_);
    { s.store_vector_begin("participants", participants_.size()); for (const auto &_value : participants_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("version", version_);
    s.store_class_end();
  }
}

object_ptr<ChatPhoto> ChatPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatPhotoEmpty::ID:
      return chatPhotoEmpty::fetch(p);
    case chatPhoto::ID:
      return chatPhoto::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t chatPhotoEmpty::ID;

object_ptr<ChatPhoto> chatPhotoEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<chatPhotoEmpty>();
}

void chatPhotoEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotoEmpty");
    s.store_class_end();
  }
}

chatPhoto::chatPhoto()
  : flags_()
  , has_video_()
  , photo_id_()
  , stripped_thumb_()
  , dc_id_()
{}

const std::int32_t chatPhoto::ID;

object_ptr<ChatPhoto> chatPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatPhoto> res = make_tl_object<chatPhoto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->has_video_ = (var0 & 1) != 0;
  res->photo_id_ = TlFetchLong::parse(p);
  if (var0 & 2) { res->stripped_thumb_ = TlFetchBytes<bytes>::parse(p); }
  res->dc_id_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (has_video_ << 0)));
    if (var0 & 1) { s.store_field("has_video", true); }
    s.store_field("photo_id", photo_id_);
    if (var0 & 2) { s.store_bytes_field("stripped_thumb", stripped_thumb_); }
    s.store_field("dc_id", dc_id_);
    s.store_class_end();
  }
}

object_ptr<ChatReactions> ChatReactions::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatReactionsNone::ID:
      return chatReactionsNone::fetch(p);
    case chatReactionsAll::ID:
      return chatReactionsAll::fetch(p);
    case chatReactionsSome::ID:
      return chatReactionsSome::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t chatReactionsNone::ID;

object_ptr<ChatReactions> chatReactionsNone::fetch(TlBufferParser &p) {
  return make_tl_object<chatReactionsNone>();
}

void chatReactionsNone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void chatReactionsNone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void chatReactionsNone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatReactionsNone");
    s.store_class_end();
  }
}

chatReactionsAll::chatReactionsAll()
  : flags_()
  , allow_custom_()
{}

chatReactionsAll::chatReactionsAll(int32 flags_, bool allow_custom_)
  : flags_(flags_)
  , allow_custom_(allow_custom_)
{}

const std::int32_t chatReactionsAll::ID;

object_ptr<ChatReactions> chatReactionsAll::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatReactionsAll> res = make_tl_object<chatReactionsAll>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->allow_custom_ = (var0 & 1) != 0;
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatReactionsAll::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (allow_custom_ << 0)), s);
}

void chatReactionsAll::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (allow_custom_ << 0)), s);
}

void chatReactionsAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatReactionsAll");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (allow_custom_ << 0)));
    if (var0 & 1) { s.store_field("allow_custom", true); }
    s.store_class_end();
  }
}

chatReactionsSome::chatReactionsSome(array<object_ptr<Reaction>> &&reactions_)
  : reactions_(std::move(reactions_))
{}

const std::int32_t chatReactionsSome::ID;

object_ptr<ChatReactions> chatReactionsSome::fetch(TlBufferParser &p) {
  return make_tl_object<chatReactionsSome>(p);
}

chatReactionsSome::chatReactionsSome(TlBufferParser &p)
  : reactions_(TlFetchBoxed<TlFetchVector<TlFetchObject<Reaction>>, 481674261>::parse(p))
{}

void chatReactionsSome::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(reactions_, s);
}

void chatReactionsSome::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(reactions_, s);
}

void chatReactionsSome::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatReactionsSome");
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

codeSettings::codeSettings(int32 flags_, bool allow_flashcall_, bool current_number_, bool allow_app_hash_, bool allow_missed_call_, bool allow_firebase_, bool unknown_number_, array<bytes> &&logout_tokens_, string const &token_, bool app_sandbox_)
  : flags_(flags_)
  , allow_flashcall_(allow_flashcall_)
  , current_number_(current_number_)
  , allow_app_hash_(allow_app_hash_)
  , allow_missed_call_(allow_missed_call_)
  , allow_firebase_(allow_firebase_)
  , unknown_number_(unknown_number_)
  , logout_tokens_(std::move(logout_tokens_))
  , token_(token_)
  , app_sandbox_(app_sandbox_)
{}

const std::int32_t codeSettings::ID;

void codeSettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (allow_flashcall_ << 0) | (current_number_ << 1) | (allow_app_hash_ << 4) | (allow_missed_call_ << 5) | (allow_firebase_ << 7) | (unknown_number_ << 9)), s);
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(logout_tokens_, s); }
  if (var0 & 256) { TlStoreString::store(token_, s); }
  if (var0 & 256) { TlStoreBool::store(app_sandbox_, s); }
}

void codeSettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (allow_flashcall_ << 0) | (current_number_ << 1) | (allow_app_hash_ << 4) | (allow_missed_call_ << 5) | (allow_firebase_ << 7) | (unknown_number_ << 9)), s);
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(logout_tokens_, s); }
  if (var0 & 256) { TlStoreString::store(token_, s); }
  if (var0 & 256) { TlStoreBool::store(app_sandbox_, s); }
}

void codeSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "codeSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (allow_flashcall_ << 0) | (current_number_ << 1) | (allow_app_hash_ << 4) | (allow_missed_call_ << 5) | (allow_firebase_ << 7) | (unknown_number_ << 9)));
    if (var0 & 1) { s.store_field("allow_flashcall", true); }
    if (var0 & 2) { s.store_field("current_number", true); }
    if (var0 & 16) { s.store_field("allow_app_hash", true); }
    if (var0 & 32) { s.store_field("allow_missed_call", true); }
    if (var0 & 128) { s.store_field("allow_firebase", true); }
    if (var0 & 512) { s.store_field("unknown_number", true); }
    if (var0 & 64) { { s.store_vector_begin("logout_tokens", logout_tokens_.size()); for (const auto &_value : logout_tokens_) { s.store_bytes_field("", _value); } s.store_class_end(); } }
    if (var0 & 256) { s.store_field("token", token_); }
    if (var0 & 256) { s.store_field("app_sandbox", app_sandbox_); }
    s.store_class_end();
  }
}

config::config()
  : flags_()
  , default_p2p_contacts_()
  , preload_featured_stickers_()
  , revoke_pm_inbox_()
  , blocked_mode_()
  , force_try_ipv6_()
  , date_()
  , expires_()
  , test_mode_()
  , this_dc_()
  , dc_options_()
  , dc_txt_domain_name_()
  , chat_size_max_()
  , megagroup_size_max_()
  , forwarded_count_max_()
  , online_update_period_ms_()
  , offline_blur_timeout_ms_()
  , offline_idle_timeout_ms_()
  , online_cloud_timeout_ms_()
  , notify_cloud_delay_ms_()
  , notify_default_delay_ms_()
  , push_chat_period_ms_()
  , push_chat_limit_()
  , edit_time_limit_()
  , revoke_time_limit_()
  , revoke_pm_time_limit_()
  , rating_e_decay_()
  , stickers_recent_limit_()
  , channels_read_media_period_()
  , tmp_sessions_()
  , call_receive_timeout_ms_()
  , call_ring_timeout_ms_()
  , call_connect_timeout_ms_()
  , call_packet_timeout_ms_()
  , me_url_prefix_()
  , autoupdate_url_prefix_()
  , gif_search_username_()
  , venue_search_username_()
  , img_search_username_()
  , static_maps_provider_()
  , caption_length_max_()
  , message_length_max_()
  , webfile_dc_id_()
  , suggested_lang_code_()
  , lang_pack_version_()
  , base_lang_pack_version_()
  , reactions_default_()
  , autologin_token_()
{}

const std::int32_t config::ID;

object_ptr<config> config::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<config> res = make_tl_object<config>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->default_p2p_contacts_ = (var0 & 8) != 0;
  res->preload_featured_stickers_ = (var0 & 16) != 0;
  res->revoke_pm_inbox_ = (var0 & 64) != 0;
  res->blocked_mode_ = (var0 & 256) != 0;
  res->force_try_ipv6_ = (var0 & 16384) != 0;
  res->date_ = TlFetchInt::parse(p);
  res->expires_ = TlFetchInt::parse(p);
  res->test_mode_ = TlFetchBool::parse(p);
  res->this_dc_ = TlFetchInt::parse(p);
  res->dc_options_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<dcOption>, 414687501>>, 481674261>::parse(p);
  res->dc_txt_domain_name_ = TlFetchString<string>::parse(p);
  res->chat_size_max_ = TlFetchInt::parse(p);
  res->megagroup_size_max_ = TlFetchInt::parse(p);
  res->forwarded_count_max_ = TlFetchInt::parse(p);
  res->online_update_period_ms_ = TlFetchInt::parse(p);
  res->offline_blur_timeout_ms_ = TlFetchInt::parse(p);
  res->offline_idle_timeout_ms_ = TlFetchInt::parse(p);
  res->online_cloud_timeout_ms_ = TlFetchInt::parse(p);
  res->notify_cloud_delay_ms_ = TlFetchInt::parse(p);
  res->notify_default_delay_ms_ = TlFetchInt::parse(p);
  res->push_chat_period_ms_ = TlFetchInt::parse(p);
  res->push_chat_limit_ = TlFetchInt::parse(p);
  res->edit_time_limit_ = TlFetchInt::parse(p);
  res->revoke_time_limit_ = TlFetchInt::parse(p);
  res->revoke_pm_time_limit_ = TlFetchInt::parse(p);
  res->rating_e_decay_ = TlFetchInt::parse(p);
  res->stickers_recent_limit_ = TlFetchInt::parse(p);
  res->channels_read_media_period_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->tmp_sessions_ = TlFetchInt::parse(p); }
  res->call_receive_timeout_ms_ = TlFetchInt::parse(p);
  res->call_ring_timeout_ms_ = TlFetchInt::parse(p);
  res->call_connect_timeout_ms_ = TlFetchInt::parse(p);
  res->call_packet_timeout_ms_ = TlFetchInt::parse(p);
  res->me_url_prefix_ = TlFetchString<string>::parse(p);
  if (var0 & 128) { res->autoupdate_url_prefix_ = TlFetchString<string>::parse(p); }
  if (var0 & 512) { res->gif_search_username_ = TlFetchString<string>::parse(p); }
  if (var0 & 1024) { res->venue_search_username_ = TlFetchString<string>::parse(p); }
  if (var0 & 2048) { res->img_search_username_ = TlFetchString<string>::parse(p); }
  if (var0 & 4096) { res->static_maps_provider_ = TlFetchString<string>::parse(p); }
  res->caption_length_max_ = TlFetchInt::parse(p);
  res->message_length_max_ = TlFetchInt::parse(p);
  res->webfile_dc_id_ = TlFetchInt::parse(p);
  if (var0 & 4) { res->suggested_lang_code_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->lang_pack_version_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->base_lang_pack_version_ = TlFetchInt::parse(p); }
  if (var0 & 32768) { res->reactions_default_ = TlFetchObject<Reaction>::parse(p); }
  if (var0 & 65536) { res->autologin_token_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void config::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "config");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (default_p2p_contacts_ << 3) | (preload_featured_stickers_ << 4) | (revoke_pm_inbox_ << 6) | (blocked_mode_ << 8) | (force_try_ipv6_ << 14)));
    if (var0 & 8) { s.store_field("default_p2p_contacts", true); }
    if (var0 & 16) { s.store_field("preload_featured_stickers", true); }
    if (var0 & 64) { s.store_field("revoke_pm_inbox", true); }
    if (var0 & 256) { s.store_field("blocked_mode", true); }
    if (var0 & 16384) { s.store_field("force_try_ipv6", true); }
    s.store_field("date", date_);
    s.store_field("expires", expires_);
    s.store_field("test_mode", test_mode_);
    s.store_field("this_dc", this_dc_);
    { s.store_vector_begin("dc_options", dc_options_.size()); for (const auto &_value : dc_options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("dc_txt_domain_name", dc_txt_domain_name_);
    s.store_field("chat_size_max", chat_size_max_);
    s.store_field("megagroup_size_max", megagroup_size_max_);
    s.store_field("forwarded_count_max", forwarded_count_max_);
    s.store_field("online_update_period_ms", online_update_period_ms_);
    s.store_field("offline_blur_timeout_ms", offline_blur_timeout_ms_);
    s.store_field("offline_idle_timeout_ms", offline_idle_timeout_ms_);
    s.store_field("online_cloud_timeout_ms", online_cloud_timeout_ms_);
    s.store_field("notify_cloud_delay_ms", notify_cloud_delay_ms_);
    s.store_field("notify_default_delay_ms", notify_default_delay_ms_);
    s.store_field("push_chat_period_ms", push_chat_period_ms_);
    s.store_field("push_chat_limit", push_chat_limit_);
    s.store_field("edit_time_limit", edit_time_limit_);
    s.store_field("revoke_time_limit", revoke_time_limit_);
    s.store_field("revoke_pm_time_limit", revoke_pm_time_limit_);
    s.store_field("rating_e_decay", rating_e_decay_);
    s.store_field("stickers_recent_limit", stickers_recent_limit_);
    s.store_field("channels_read_media_period", channels_read_media_period_);
    if (var0 & 1) { s.store_field("tmp_sessions", tmp_sessions_); }
    s.store_field("call_receive_timeout_ms", call_receive_timeout_ms_);
    s.store_field("call_ring_timeout_ms", call_ring_timeout_ms_);
    s.store_field("call_connect_timeout_ms", call_connect_timeout_ms_);
    s.store_field("call_packet_timeout_ms", call_packet_timeout_ms_);
    s.store_field("me_url_prefix", me_url_prefix_);
    if (var0 & 128) { s.store_field("autoupdate_url_prefix", autoupdate_url_prefix_); }
    if (var0 & 512) { s.store_field("gif_search_username", gif_search_username_); }
    if (var0 & 1024) { s.store_field("venue_search_username", venue_search_username_); }
    if (var0 & 2048) { s.store_field("img_search_username", img_search_username_); }
    if (var0 & 4096) { s.store_field("static_maps_provider", static_maps_provider_); }
    s.store_field("caption_length_max", caption_length_max_);
    s.store_field("message_length_max", message_length_max_);
    s.store_field("webfile_dc_id", webfile_dc_id_);
    if (var0 & 4) { s.store_field("suggested_lang_code", suggested_lang_code_); }
    if (var0 & 4) { s.store_field("lang_pack_version", lang_pack_version_); }
    if (var0 & 4) { s.store_field("base_lang_pack_version", base_lang_pack_version_); }
    if (var0 & 32768) { s.store_object_field("reactions_default", static_cast<const BaseObject *>(reactions_default_.get())); }
    if (var0 & 65536) { s.store_field("autologin_token", autologin_token_); }
    s.store_class_end();
  }
}

connectedBot::connectedBot()
  : flags_()
  , bot_id_()
  , recipients_()
  , rights_()
{}

const std::int32_t connectedBot::ID;

object_ptr<connectedBot> connectedBot::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<connectedBot> res = make_tl_object<connectedBot>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->bot_id_ = TlFetchLong::parse(p);
  res->recipients_ = TlFetchBoxed<TlFetchObject<businessBotRecipients>, -1198722189>::parse(p);
  res->rights_ = TlFetchBoxed<TlFetchObject<businessBotRights>, -1604170505>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void connectedBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedBot");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("bot_id", bot_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get()));
    s.store_class_end();
  }
}

connectedBotStarRef::connectedBotStarRef()
  : flags_()
  , revoked_()
  , url_()
  , date_()
  , bot_id_()
  , commission_permille_()
  , duration_months_()
  , participants_()
  , revenue_()
{}

const std::int32_t connectedBotStarRef::ID;

object_ptr<connectedBotStarRef> connectedBotStarRef::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<connectedBotStarRef> res = make_tl_object<connectedBotStarRef>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->revoked_ = (var0 & 2) != 0;
  res->url_ = TlFetchString<string>::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->bot_id_ = TlFetchLong::parse(p);
  res->commission_permille_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->duration_months_ = TlFetchInt::parse(p); }
  res->participants_ = TlFetchLong::parse(p);
  res->revenue_ = TlFetchLong::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void connectedBotStarRef::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedBotStarRef");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (revoked_ << 1)));
    if (var0 & 2) { s.store_field("revoked", true); }
    s.store_field("url", url_);
    s.store_field("date", date_);
    s.store_field("bot_id", bot_id_);
    s.store_field("commission_permille", commission_permille_);
    if (var0 & 1) { s.store_field("duration_months", duration_months_); }
    s.store_field("participants", participants_);
    s.store_field("revenue", revenue_);
    s.store_class_end();
  }
}

const std::int32_t contact::ID;

object_ptr<contact> contact::fetch(TlBufferParser &p) {
  return make_tl_object<contact>(p);
}

contact::contact(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , mutual_(TlFetchBool::parse(p))
{}

void contact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "contact");
    s.store_field("user_id", user_id_);
    s.store_field("mutual", mutual_);
    s.store_class_end();
  }
}

const std::int32_t contactBirthday::ID;

object_ptr<contactBirthday> contactBirthday::fetch(TlBufferParser &p) {
  return make_tl_object<contactBirthday>(p);
}

contactBirthday::contactBirthday(TlBufferParser &p)
  : contact_id_(TlFetchLong::parse(p))
  , birthday_(TlFetchBoxed<TlFetchObject<birthday>, 1821253126>::parse(p))
{}

void contactBirthday::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "contactBirthday");
    s.store_field("contact_id", contact_id_);
    s.store_object_field("birthday", static_cast<const BaseObject *>(birthday_.get()));
    s.store_class_end();
  }
}

const std::int32_t contactStatus::ID;

object_ptr<contactStatus> contactStatus::fetch(TlBufferParser &p) {
  return make_tl_object<contactStatus>(p);
}

contactStatus::contactStatus(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , status_(TlFetchObject<UserStatus>::parse(p))
{}

void contactStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "contactStatus");
    s.store_field("user_id", user_id_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_class_end();
  }
}

dataJSON::dataJSON(string const &data_)
  : data_(data_)
{}

const std::int32_t dataJSON::ID;

object_ptr<dataJSON> dataJSON::fetch(TlBufferParser &p) {
  return make_tl_object<dataJSON>(p);
}

dataJSON::dataJSON(TlBufferParser &p)
  : data_(TlFetchString<string>::parse(p))
{}

void dataJSON::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(data_, s);
}

void dataJSON::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(data_, s);
}

void dataJSON::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dataJSON");
    s.store_field("data", data_);
    s.store_class_end();
  }
}

dcOption::dcOption()
  : flags_()
  , ipv6_()
  , media_only_()
  , tcpo_only_()
  , cdn_()
  , static_()
  , this_port_only_()
  , id_()
  , ip_address_()
  , port_()
  , secret_()
{}

const std::int32_t dcOption::ID;

object_ptr<dcOption> dcOption::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<dcOption> res = make_tl_object<dcOption>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->ipv6_ = (var0 & 1) != 0;
  res->media_only_ = (var0 & 2) != 0;
  res->tcpo_only_ = (var0 & 4) != 0;
  res->cdn_ = (var0 & 8) != 0;
  res->static_ = (var0 & 16) != 0;
  res->this_port_only_ = (var0 & 32) != 0;
  res->id_ = TlFetchInt::parse(p);
  res->ip_address_ = TlFetchString<string>::parse(p);
  res->port_ = TlFetchInt::parse(p);
  if (var0 & 1024) { res->secret_ = TlFetchBytes<bytes>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void dcOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dcOption");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (ipv6_ << 0) | (media_only_ << 1) | (tcpo_only_ << 2) | (cdn_ << 3) | (static_ << 4) | (this_port_only_ << 5)));
    if (var0 & 1) { s.store_field("ipv6", true); }
    if (var0 & 2) { s.store_field("media_only", true); }
    if (var0 & 4) { s.store_field("tcpo_only", true); }
    if (var0 & 8) { s.store_field("cdn", true); }
    if (var0 & 16) { s.store_field("static", true); }
    if (var0 & 32) { s.store_field("this_port_only", true); }
    s.store_field("id", id_);
    s.store_field("ip_address", ip_address_);
    s.store_field("port", port_);
    if (var0 & 1024) { s.store_bytes_field("secret", secret_); }
    s.store_class_end();
  }
}

const std::int32_t defaultHistoryTTL::ID;

object_ptr<defaultHistoryTTL> defaultHistoryTTL::fetch(TlBufferParser &p) {
  return make_tl_object<defaultHistoryTTL>(p);
}

defaultHistoryTTL::defaultHistoryTTL(TlBufferParser &p)
  : period_(TlFetchInt::parse(p))
{}

void defaultHistoryTTL::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "defaultHistoryTTL");
    s.store_field("period", period_);
    s.store_class_end();
  }
}

object_ptr<Dialog> Dialog::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case dialog::ID:
      return dialog::fetch(p);
    case dialogFolder::ID:
      return dialogFolder::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

dialog::dialog()
  : flags_()
  , pinned_()
  , unread_mark_()
  , view_forum_as_messages_()
  , peer_()
  , top_message_()
  , read_inbox_max_id_()
  , read_outbox_max_id_()
  , unread_count_()
  , unread_mentions_count_()
  , unread_reactions_count_()
  , notify_settings_()
  , pts_()
  , draft_()
  , folder_id_()
  , ttl_period_()
{}

const std::int32_t dialog::ID;

object_ptr<Dialog> dialog::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<dialog> res = make_tl_object<dialog>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->pinned_ = (var0 & 4) != 0;
  res->unread_mark_ = (var0 & 8) != 0;
  res->view_forum_as_messages_ = (var0 & 64) != 0;
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->top_message_ = TlFetchInt::parse(p);
  res->read_inbox_max_id_ = TlFetchInt::parse(p);
  res->read_outbox_max_id_ = TlFetchInt::parse(p);
  res->unread_count_ = TlFetchInt::parse(p);
  res->unread_mentions_count_ = TlFetchInt::parse(p);
  res->unread_reactions_count_ = TlFetchInt::parse(p);
  res->notify_settings_ = TlFetchBoxed<TlFetchObject<peerNotifySettings>, -1721619444>::parse(p);
  if (var0 & 1) { res->pts_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->draft_ = TlFetchObject<DraftMessage>::parse(p); }
  if (var0 & 16) { res->folder_id_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->ttl_period_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void dialog::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialog");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (pinned_ << 2) | (unread_mark_ << 3) | (view_forum_as_messages_ << 6)));
    if (var0 & 4) { s.store_field("pinned", true); }
    if (var0 & 8) { s.store_field("unread_mark", true); }
    if (var0 & 64) { s.store_field("view_forum_as_messages", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("top_message", top_message_);
    s.store_field("read_inbox_max_id", read_inbox_max_id_);
    s.store_field("read_outbox_max_id", read_outbox_max_id_);
    s.store_field("unread_count", unread_count_);
    s.store_field("unread_mentions_count", unread_mentions_count_);
    s.store_field("unread_reactions_count", unread_reactions_count_);
    s.store_object_field("notify_settings", static_cast<const BaseObject *>(notify_settings_.get()));
    if (var0 & 1) { s.store_field("pts", pts_); }
    if (var0 & 2) { s.store_object_field("draft", static_cast<const BaseObject *>(draft_.get())); }
    if (var0 & 16) { s.store_field("folder_id", folder_id_); }
    if (var0 & 32) { s.store_field("ttl_period", ttl_period_); }
    s.store_class_end();
  }
}

dialogFolder::dialogFolder()
  : flags_()
  , pinned_()
  , folder_()
  , peer_()
  , top_message_()
  , unread_muted_peers_count_()
  , unread_unmuted_peers_count_()
  , unread_muted_messages_count_()
  , unread_unmuted_messages_count_()
{}

const std::int32_t dialogFolder::ID;

object_ptr<Dialog> dialogFolder::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<dialogFolder> res = make_tl_object<dialogFolder>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->pinned_ = (var0 & 4) != 0;
  res->folder_ = TlFetchBoxed<TlFetchObject<folder>, -11252123>::parse(p);
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->top_message_ = TlFetchInt::parse(p);
  res->unread_muted_peers_count_ = TlFetchInt::parse(p);
  res->unread_unmuted_peers_count_ = TlFetchInt::parse(p);
  res->unread_muted_messages_count_ = TlFetchInt::parse(p);
  res->unread_unmuted_messages_count_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void dialogFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogFolder");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (pinned_ << 2)));
    if (var0 & 4) { s.store_field("pinned", true); }
    s.store_object_field("folder", static_cast<const BaseObject *>(folder_.get()));
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("top_message", top_message_);
    s.store_field("unread_muted_peers_count", unread_muted_peers_count_);
    s.store_field("unread_unmuted_peers_count", unread_unmuted_peers_count_);
    s.store_field("unread_muted_messages_count", unread_muted_messages_count_);
    s.store_field("unread_unmuted_messages_count", unread_unmuted_messages_count_);
    s.store_class_end();
  }
}

object_ptr<DialogFilter> DialogFilter::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case dialogFilter::ID:
      return dialogFilter::fetch(p);
    case dialogFilterDefault::ID:
      return dialogFilterDefault::fetch(p);
    case dialogFilterChatlist::ID:
      return dialogFilterChatlist::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

dialogFilter::dialogFilter()
  : flags_()
  , contacts_()
  , non_contacts_()
  , groups_()
  , broadcasts_()
  , bots_()
  , exclude_muted_()
  , exclude_read_()
  , exclude_archived_()
  , title_noanimate_()
  , id_()
  , title_()
  , emoticon_()
  , color_()
  , pinned_peers_()
  , include_peers_()
  , exclude_peers_()
{}

dialogFilter::dialogFilter(int32 flags_, bool contacts_, bool non_contacts_, bool groups_, bool broadcasts_, bool bots_, bool exclude_muted_, bool exclude_read_, bool exclude_archived_, bool title_noanimate_, int32 id_, object_ptr<textWithEntities> &&title_, string const &emoticon_, int32 color_, array<object_ptr<InputPeer>> &&pinned_peers_, array<object_ptr<InputPeer>> &&include_peers_, array<object_ptr<InputPeer>> &&exclude_peers_)
  : flags_(flags_)
  , contacts_(contacts_)
  , non_contacts_(non_contacts_)
  , groups_(groups_)
  , broadcasts_(broadcasts_)
  , bots_(bots_)
  , exclude_muted_(exclude_muted_)
  , exclude_read_(exclude_read_)
  , exclude_archived_(exclude_archived_)
  , title_noanimate_(title_noanimate_)
  , id_(id_)
  , title_(std::move(title_))
  , emoticon_(emoticon_)
  , color_(color_)
  , pinned_peers_(std::move(pinned_peers_))
  , include_peers_(std::move(include_peers_))
  , exclude_peers_(std::move(exclude_peers_))
{}

const std::int32_t dialogFilter::ID;

object_ptr<DialogFilter> dialogFilter::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<dialogFilter> res = make_tl_object<dialogFilter>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->contacts_ = (var0 & 1) != 0;
  res->non_contacts_ = (var0 & 2) != 0;
  res->groups_ = (var0 & 4) != 0;
  res->broadcasts_ = (var0 & 8) != 0;
  res->bots_ = (var0 & 16) != 0;
  res->exclude_muted_ = (var0 & 2048) != 0;
  res->exclude_read_ = (var0 & 4096) != 0;
  res->exclude_archived_ = (var0 & 8192) != 0;
  res->title_noanimate_ = (var0 & 268435456) != 0;
  res->id_ = TlFetchInt::parse(p);
  res->title_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p);
  if (var0 & 33554432) { res->emoticon_ = TlFetchString<string>::parse(p); }
  if (var0 & 134217728) { res->color_ = TlFetchInt::parse(p); }
  res->pinned_peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputPeer>>, 481674261>::parse(p);
  res->include_peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputPeer>>, 481674261>::parse(p);
  res->exclude_peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputPeer>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void dialogFilter::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (contacts_ << 0) | (non_contacts_ << 1) | (groups_ << 2) | (broadcasts_ << 3) | (bots_ << 4) | (exclude_muted_ << 11) | (exclude_read_ << 12) | (exclude_archived_ << 13) | (title_noanimate_ << 28)), s);
  TlStoreBinary::store(id_, s);
  TlStoreBoxed<TlStoreObject, 1964978502>::store(title_, s);
  if (var0 & 33554432) { TlStoreString::store(emoticon_, s); }
  if (var0 & 134217728) { TlStoreBinary::store(color_, s); }
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(pinned_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(include_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(exclude_peers_, s);
}

void dialogFilter::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (contacts_ << 0) | (non_contacts_ << 1) | (groups_ << 2) | (broadcasts_ << 3) | (bots_ << 4) | (exclude_muted_ << 11) | (exclude_read_ << 12) | (exclude_archived_ << 13) | (title_noanimate_ << 28)), s);
  TlStoreBinary::store(id_, s);
  TlStoreBoxed<TlStoreObject, 1964978502>::store(title_, s);
  if (var0 & 33554432) { TlStoreString::store(emoticon_, s); }
  if (var0 & 134217728) { TlStoreBinary::store(color_, s); }
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(pinned_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(include_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(exclude_peers_, s);
}

void dialogFilter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogFilter");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (contacts_ << 0) | (non_contacts_ << 1) | (groups_ << 2) | (broadcasts_ << 3) | (bots_ << 4) | (exclude_muted_ << 11) | (exclude_read_ << 12) | (exclude_archived_ << 13) | (title_noanimate_ << 28)));
    if (var0 & 1) { s.store_field("contacts", true); }
    if (var0 & 2) { s.store_field("non_contacts", true); }
    if (var0 & 4) { s.store_field("groups", true); }
    if (var0 & 8) { s.store_field("broadcasts", true); }
    if (var0 & 16) { s.store_field("bots", true); }
    if (var0 & 2048) { s.store_field("exclude_muted", true); }
    if (var0 & 4096) { s.store_field("exclude_read", true); }
    if (var0 & 8192) { s.store_field("exclude_archived", true); }
    if (var0 & 268435456) { s.store_field("title_noanimate", true); }
    s.store_field("id", id_);
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    if (var0 & 33554432) { s.store_field("emoticon", emoticon_); }
    if (var0 & 134217728) { s.store_field("color", color_); }
    { s.store_vector_begin("pinned_peers", pinned_peers_.size()); for (const auto &_value : pinned_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("include_peers", include_peers_.size()); for (const auto &_value : include_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("exclude_peers", exclude_peers_.size()); for (const auto &_value : exclude_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t dialogFilterDefault::ID;

object_ptr<DialogFilter> dialogFilterDefault::fetch(TlBufferParser &p) {
  return make_tl_object<dialogFilterDefault>();
}

void dialogFilterDefault::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void dialogFilterDefault::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void dialogFilterDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogFilterDefault");
    s.store_class_end();
  }
}

dialogFilterChatlist::dialogFilterChatlist()
  : flags_()
  , has_my_invites_()
  , title_noanimate_()
  , id_()
  , title_()
  , emoticon_()
  , color_()
  , pinned_peers_()
  , include_peers_()
{}

dialogFilterChatlist::dialogFilterChatlist(int32 flags_, bool has_my_invites_, bool title_noanimate_, int32 id_, object_ptr<textWithEntities> &&title_, string const &emoticon_, int32 color_, array<object_ptr<InputPeer>> &&pinned_peers_, array<object_ptr<InputPeer>> &&include_peers_)
  : flags_(flags_)
  , has_my_invites_(has_my_invites_)
  , title_noanimate_(title_noanimate_)
  , id_(id_)
  , title_(std::move(title_))
  , emoticon_(emoticon_)
  , color_(color_)
  , pinned_peers_(std::move(pinned_peers_))
  , include_peers_(std::move(include_peers_))
{}

const std::int32_t dialogFilterChatlist::ID;

object_ptr<DialogFilter> dialogFilterChatlist::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<dialogFilterChatlist> res = make_tl_object<dialogFilterChatlist>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->has_my_invites_ = (var0 & 67108864) != 0;
  res->title_noanimate_ = (var0 & 268435456) != 0;
  res->id_ = TlFetchInt::parse(p);
  res->title_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p);
  if (var0 & 33554432) { res->emoticon_ = TlFetchString<string>::parse(p); }
  if (var0 & 134217728) { res->color_ = TlFetchInt::parse(p); }
  res->pinned_peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputPeer>>, 481674261>::parse(p);
  res->include_peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputPeer>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void dialogFilterChatlist::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (has_my_invites_ << 26) | (title_noanimate_ << 28)), s);
  TlStoreBinary::store(id_, s);
  TlStoreBoxed<TlStoreObject, 1964978502>::store(title_, s);
  if (var0 & 33554432) { TlStoreString::store(emoticon_, s); }
  if (var0 & 134217728) { TlStoreBinary::store(color_, s); }
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(pinned_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(include_peers_, s);
}

void dialogFilterChatlist::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (has_my_invites_ << 26) | (title_noanimate_ << 28)), s);
  TlStoreBinary::store(id_, s);
  TlStoreBoxed<TlStoreObject, 1964978502>::store(title_, s);
  if (var0 & 33554432) { TlStoreString::store(emoticon_, s); }
  if (var0 & 134217728) { TlStoreBinary::store(color_, s); }
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(pinned_peers_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(include_peers_, s);
}

void dialogFilterChatlist::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogFilterChatlist");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (has_my_invites_ << 26) | (title_noanimate_ << 28)));
    if (var0 & 67108864) { s.store_field("has_my_invites", true); }
    if (var0 & 268435456) { s.store_field("title_noanimate", true); }
    s.store_field("id", id_);
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    if (var0 & 33554432) { s.store_field("emoticon", emoticon_); }
    if (var0 & 134217728) { s.store_field("color", color_); }
    { s.store_vector_begin("pinned_peers", pinned_peers_.size()); for (const auto &_value : pinned_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("include_peers", include_peers_.size()); for (const auto &_value : include_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t dialogFilterSuggested::ID;

object_ptr<dialogFilterSuggested> dialogFilterSuggested::fetch(TlBufferParser &p) {
  return make_tl_object<dialogFilterSuggested>(p);
}

dialogFilterSuggested::dialogFilterSuggested(TlBufferParser &p)
  : filter_(TlFetchObject<DialogFilter>::parse(p))
  , description_(TlFetchString<string>::parse(p))
{}

void dialogFilterSuggested::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogFilterSuggested");
    s.store_object_field("filter", static_cast<const BaseObject *>(filter_.get()));
    s.store_field("description", description_);
    s.store_class_end();
  }
}

object_ptr<DialogPeer> DialogPeer::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case dialogPeer::ID:
      return dialogPeer::fetch(p);
    case dialogPeerFolder::ID:
      return dialogPeerFolder::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t dialogPeer::ID;

object_ptr<DialogPeer> dialogPeer::fetch(TlBufferParser &p) {
  return make_tl_object<dialogPeer>(p);
}

dialogPeer::dialogPeer(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
{}

void dialogPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

const std::int32_t dialogPeerFolder::ID;

object_ptr<DialogPeer> dialogPeerFolder::fetch(TlBufferParser &p) {
  return make_tl_object<dialogPeerFolder>(p);
}

dialogPeerFolder::dialogPeerFolder(TlBufferParser &p)
  : folder_id_(TlFetchInt::parse(p))
{}

void dialogPeerFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dialogPeerFolder");
    s.store_field("folder_id", folder_id_);
    s.store_class_end();
  }
}

disallowedGiftsSettings::disallowedGiftsSettings()
  : flags_()
  , disallow_unlimited_stargifts_()
  , disallow_limited_stargifts_()
  , disallow_unique_stargifts_()
  , disallow_premium_gifts_()
{}

disallowedGiftsSettings::disallowedGiftsSettings(int32 flags_, bool disallow_unlimited_stargifts_, bool disallow_limited_stargifts_, bool disallow_unique_stargifts_, bool disallow_premium_gifts_)
  : flags_(flags_)
  , disallow_unlimited_stargifts_(disallow_unlimited_stargifts_)
  , disallow_limited_stargifts_(disallow_limited_stargifts_)
  , disallow_unique_stargifts_(disallow_unique_stargifts_)
  , disallow_premium_gifts_(disallow_premium_gifts_)
{}

const std::int32_t disallowedGiftsSettings::ID;

object_ptr<disallowedGiftsSettings> disallowedGiftsSettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<disallowedGiftsSettings> res = make_tl_object<disallowedGiftsSettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->disallow_unlimited_stargifts_ = (var0 & 1) != 0;
  res->disallow_limited_stargifts_ = (var0 & 2) != 0;
  res->disallow_unique_stargifts_ = (var0 & 4) != 0;
  res->disallow_premium_gifts_ = (var0 & 8) != 0;
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void disallowedGiftsSettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (disallow_unlimited_stargifts_ << 0) | (disallow_limited_stargifts_ << 1) | (disallow_unique_stargifts_ << 2) | (disallow_premium_gifts_ << 3)), s);
}

void disallowedGiftsSettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (disallow_unlimited_stargifts_ << 0) | (disallow_limited_stargifts_ << 1) | (disallow_unique_stargifts_ << 2) | (disallow_premium_gifts_ << 3)), s);
}

void disallowedGiftsSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "disallowedGiftsSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (disallow_unlimited_stargifts_ << 0) | (disallow_limited_stargifts_ << 1) | (disallow_unique_stargifts_ << 2) | (disallow_premium_gifts_ << 3)));
    if (var0 & 1) { s.store_field("disallow_unlimited_stargifts", true); }
    if (var0 & 2) { s.store_field("disallow_limited_stargifts", true); }
    if (var0 & 4) { s.store_field("disallow_unique_stargifts", true); }
    if (var0 & 8) { s.store_field("disallow_premium_gifts", true); }
    s.store_class_end();
  }
}

object_ptr<Document> Document::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case documentEmpty::ID:
      return documentEmpty::fetch(p);
    case document::ID:
      return document::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t documentEmpty::ID;

object_ptr<Document> documentEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<documentEmpty>(p);
}

documentEmpty::documentEmpty(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
{}

void documentEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentEmpty");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

document::document()
  : flags_()
  , id_()
  , access_hash_()
  , file_reference_()
  , date_()
  , mime_type_()
  , size_()
  , thumbs_()
  , video_thumbs_()
  , dc_id_()
  , attributes_()
{}

document::document(int32 flags_, int64 id_, int64 access_hash_, bytes &&file_reference_, int32 date_, string const &mime_type_, int64 size_, array<object_ptr<PhotoSize>> &&thumbs_, array<object_ptr<VideoSize>> &&video_thumbs_, int32 dc_id_, array<object_ptr<DocumentAttribute>> &&attributes_)
  : flags_(flags_)
  , id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
  , date_(date_)
  , mime_type_(mime_type_)
  , size_(size_)
  , thumbs_(std::move(thumbs_))
  , video_thumbs_(std::move(video_thumbs_))
  , dc_id_(dc_id_)
  , attributes_(std::move(attributes_))
{}

const std::int32_t document::ID;

object_ptr<Document> document::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<document> res = make_tl_object<document>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchLong::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->file_reference_ = TlFetchBytes<bytes>::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->mime_type_ = TlFetchString<string>::parse(p);
  res->size_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->thumbs_ = TlFetchBoxed<TlFetchVector<TlFetchObject<PhotoSize>>, 481674261>::parse(p); }
  if (var0 & 2) { res->video_thumbs_ = TlFetchBoxed<TlFetchVector<TlFetchObject<VideoSize>>, 481674261>::parse(p); }
  res->dc_id_ = TlFetchInt::parse(p);
  res->attributes_ = TlFetchBoxed<TlFetchVector<TlFetchObject<DocumentAttribute>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void document::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "document");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_field("date", date_);
    s.store_field("mime_type", mime_type_);
    s.store_field("size", size_);
    if (var0 & 1) { { s.store_vector_begin("thumbs", thumbs_.size()); for (const auto &_value : thumbs_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 2) { { s.store_vector_begin("video_thumbs", video_thumbs_.size()); for (const auto &_value : video_thumbs_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_field("dc_id", dc_id_);
    { s.store_vector_begin("attributes", attributes_.size()); for (const auto &_value : attributes_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<DocumentAttribute> DocumentAttribute::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case documentAttributeImageSize::ID:
      return documentAttributeImageSize::fetch(p);
    case documentAttributeAnimated::ID:
      return documentAttributeAnimated::fetch(p);
    case documentAttributeSticker::ID:
      return documentAttributeSticker::fetch(p);
    case documentAttributeVideo::ID:
      return documentAttributeVideo::fetch(p);
    case documentAttributeAudio::ID:
      return documentAttributeAudio::fetch(p);
    case documentAttributeFilename::ID:
      return documentAttributeFilename::fetch(p);
    case documentAttributeHasStickers::ID:
      return documentAttributeHasStickers::fetch(p);
    case documentAttributeCustomEmoji::ID:
      return documentAttributeCustomEmoji::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

documentAttributeImageSize::documentAttributeImageSize(int32 w_, int32 h_)
  : w_(w_)
  , h_(h_)
{}

const std::int32_t documentAttributeImageSize::ID;

object_ptr<DocumentAttribute> documentAttributeImageSize::fetch(TlBufferParser &p) {
  return make_tl_object<documentAttributeImageSize>(p);
}

documentAttributeImageSize::documentAttributeImageSize(TlBufferParser &p)
  : w_(TlFetchInt::parse(p))
  , h_(TlFetchInt::parse(p))
{}

void documentAttributeImageSize::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
}

void documentAttributeImageSize::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
}

void documentAttributeImageSize::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeImageSize");
    s.store_field("w", w_);
    s.store_field("h", h_);
    s.store_class_end();
  }
}

const std::int32_t documentAttributeAnimated::ID;

object_ptr<DocumentAttribute> documentAttributeAnimated::fetch(TlBufferParser &p) {
  return make_tl_object<documentAttributeAnimated>();
}

void documentAttributeAnimated::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void documentAttributeAnimated::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void documentAttributeAnimated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeAnimated");
    s.store_class_end();
  }
}

documentAttributeSticker::documentAttributeSticker()
  : flags_()
  , mask_()
  , alt_()
  , stickerset_()
  , mask_coords_()
{}

documentAttributeSticker::documentAttributeSticker(int32 flags_, bool mask_, string const &alt_, object_ptr<InputStickerSet> &&stickerset_, object_ptr<maskCoords> &&mask_coords_)
  : flags_(flags_)
  , mask_(mask_)
  , alt_(alt_)
  , stickerset_(std::move(stickerset_))
  , mask_coords_(std::move(mask_coords_))
{}

const std::int32_t documentAttributeSticker::ID;

object_ptr<DocumentAttribute> documentAttributeSticker::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<documentAttributeSticker> res = make_tl_object<documentAttributeSticker>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->mask_ = (var0 & 2) != 0;
  res->alt_ = TlFetchString<string>::parse(p);
  res->stickerset_ = TlFetchObject<InputStickerSet>::parse(p);
  if (var0 & 1) { res->mask_coords_ = TlFetchBoxed<TlFetchObject<maskCoords>, -1361650766>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void documentAttributeSticker::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (mask_ << 1)), s);
  TlStoreString::store(alt_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1361650766>::store(mask_coords_, s); }
}

void documentAttributeSticker::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (mask_ << 1)), s);
  TlStoreString::store(alt_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1361650766>::store(mask_coords_, s); }
}

void documentAttributeSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeSticker");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (mask_ << 1)));
    if (var0 & 2) { s.store_field("mask", true); }
    s.store_field("alt", alt_);
    s.store_object_field("stickerset", static_cast<const BaseObject *>(stickerset_.get()));
    if (var0 & 1) { s.store_object_field("mask_coords", static_cast<const BaseObject *>(mask_coords_.get())); }
    s.store_class_end();
  }
}

documentAttributeVideo::documentAttributeVideo()
  : flags_()
  , round_message_()
  , supports_streaming_()
  , nosound_()
  , duration_()
  , w_()
  , h_()
  , preload_prefix_size_()
  , video_start_ts_()
  , video_codec_()
{}

documentAttributeVideo::documentAttributeVideo(int32 flags_, bool round_message_, bool supports_streaming_, bool nosound_, double duration_, int32 w_, int32 h_, int32 preload_prefix_size_, double video_start_ts_, string const &video_codec_)
  : flags_(flags_)
  , round_message_(round_message_)
  , supports_streaming_(supports_streaming_)
  , nosound_(nosound_)
  , duration_(duration_)
  , w_(w_)
  , h_(h_)
  , preload_prefix_size_(preload_prefix_size_)
  , video_start_ts_(video_start_ts_)
  , video_codec_(video_codec_)
{}

const std::int32_t documentAttributeVideo::ID;

object_ptr<DocumentAttribute> documentAttributeVideo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<documentAttributeVideo> res = make_tl_object<documentAttributeVideo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->round_message_ = (var0 & 1) != 0;
  res->supports_streaming_ = (var0 & 2) != 0;
  res->nosound_ = (var0 & 8) != 0;
  res->duration_ = TlFetchDouble::parse(p);
  res->w_ = TlFetchInt::parse(p);
  res->h_ = TlFetchInt::parse(p);
  if (var0 & 4) { res->preload_prefix_size_ = TlFetchInt::parse(p); }
  if (var0 & 16) { res->video_start_ts_ = TlFetchDouble::parse(p); }
  if (var0 & 32) { res->video_codec_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void documentAttributeVideo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (round_message_ << 0) | (supports_streaming_ << 1) | (nosound_ << 3)), s);
  TlStoreBinary::store(duration_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  if (var0 & 4) { TlStoreBinary::store(preload_prefix_size_, s); }
  if (var0 & 16) { TlStoreBinary::store(video_start_ts_, s); }
  if (var0 & 32) { TlStoreString::store(video_codec_, s); }
}

void documentAttributeVideo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (round_message_ << 0) | (supports_streaming_ << 1) | (nosound_ << 3)), s);
  TlStoreBinary::store(duration_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  if (var0 & 4) { TlStoreBinary::store(preload_prefix_size_, s); }
  if (var0 & 16) { TlStoreBinary::store(video_start_ts_, s); }
  if (var0 & 32) { TlStoreString::store(video_codec_, s); }
}

void documentAttributeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeVideo");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (round_message_ << 0) | (supports_streaming_ << 1) | (nosound_ << 3)));
    if (var0 & 1) { s.store_field("round_message", true); }
    if (var0 & 2) { s.store_field("supports_streaming", true); }
    if (var0 & 8) { s.store_field("nosound", true); }
    s.store_field("duration", duration_);
    s.store_field("w", w_);
    s.store_field("h", h_);
    if (var0 & 4) { s.store_field("preload_prefix_size", preload_prefix_size_); }
    if (var0 & 16) { s.store_field("video_start_ts", video_start_ts_); }
    if (var0 & 32) { s.store_field("video_codec", video_codec_); }
    s.store_class_end();
  }
}

documentAttributeAudio::documentAttributeAudio()
  : flags_()
  , voice_()
  , duration_()
  , title_()
  , performer_()
  , waveform_()
{}

documentAttributeAudio::documentAttributeAudio(int32 flags_, bool voice_, int32 duration_, string const &title_, string const &performer_, bytes &&waveform_)
  : flags_(flags_)
  , voice_(voice_)
  , duration_(duration_)
  , title_(title_)
  , performer_(performer_)
  , waveform_(std::move(waveform_))
{}

const std::int32_t documentAttributeAudio::ID;

object_ptr<DocumentAttribute> documentAttributeAudio::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<documentAttributeAudio> res = make_tl_object<documentAttributeAudio>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->voice_ = (var0 & 1024) != 0;
  res->duration_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->performer_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->waveform_ = TlFetchBytes<bytes>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void documentAttributeAudio::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (voice_ << 10)), s);
  TlStoreBinary::store(duration_, s);
  if (var0 & 1) { TlStoreString::store(title_, s); }
  if (var0 & 2) { TlStoreString::store(performer_, s); }
  if (var0 & 4) { TlStoreString::store(waveform_, s); }
}

void documentAttributeAudio::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (voice_ << 10)), s);
  TlStoreBinary::store(duration_, s);
  if (var0 & 1) { TlStoreString::store(title_, s); }
  if (var0 & 2) { TlStoreString::store(performer_, s); }
  if (var0 & 4) { TlStoreString::store(waveform_, s); }
}

void documentAttributeAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeAudio");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (voice_ << 10)));
    if (var0 & 1024) { s.store_field("voice", true); }
    s.store_field("duration", duration_);
    if (var0 & 1) { s.store_field("title", title_); }
    if (var0 & 2) { s.store_field("performer", performer_); }
    if (var0 & 4) { s.store_bytes_field("waveform", waveform_); }
    s.store_class_end();
  }
}

documentAttributeFilename::documentAttributeFilename(string const &file_name_)
  : file_name_(file_name_)
{}

const std::int32_t documentAttributeFilename::ID;

object_ptr<DocumentAttribute> documentAttributeFilename::fetch(TlBufferParser &p) {
  return make_tl_object<documentAttributeFilename>(p);
}

documentAttributeFilename::documentAttributeFilename(TlBufferParser &p)
  : file_name_(TlFetchString<string>::parse(p))
{}

void documentAttributeFilename::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(file_name_, s);
}

void documentAttributeFilename::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(file_name_, s);
}

void documentAttributeFilename::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeFilename");
    s.store_field("file_name", file_name_);
    s.store_class_end();
  }
}

const std::int32_t documentAttributeHasStickers::ID;

object_ptr<DocumentAttribute> documentAttributeHasStickers::fetch(TlBufferParser &p) {
  return make_tl_object<documentAttributeHasStickers>();
}

void documentAttributeHasStickers::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void documentAttributeHasStickers::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void documentAttributeHasStickers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeHasStickers");
    s.store_class_end();
  }
}

documentAttributeCustomEmoji::documentAttributeCustomEmoji()
  : flags_()
  , free_()
  , text_color_()
  , alt_()
  , stickerset_()
{}

documentAttributeCustomEmoji::documentAttributeCustomEmoji(int32 flags_, bool free_, bool text_color_, string const &alt_, object_ptr<InputStickerSet> &&stickerset_)
  : flags_(flags_)
  , free_(free_)
  , text_color_(text_color_)
  , alt_(alt_)
  , stickerset_(std::move(stickerset_))
{}

const std::int32_t documentAttributeCustomEmoji::ID;

object_ptr<DocumentAttribute> documentAttributeCustomEmoji::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<documentAttributeCustomEmoji> res = make_tl_object<documentAttributeCustomEmoji>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->free_ = (var0 & 1) != 0;
  res->text_color_ = (var0 & 2) != 0;
  res->alt_ = TlFetchString<string>::parse(p);
  res->stickerset_ = TlFetchObject<InputStickerSet>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void documentAttributeCustomEmoji::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (free_ << 0) | (text_color_ << 1)), s);
  TlStoreString::store(alt_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
}

void documentAttributeCustomEmoji::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (free_ << 0) | (text_color_ << 1)), s);
  TlStoreString::store(alt_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
}

void documentAttributeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "documentAttributeCustomEmoji");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (free_ << 0) | (text_color_ << 1)));
    if (var0 & 1) { s.store_field("free", true); }
    if (var0 & 2) { s.store_field("text_color", true); }
    s.store_field("alt", alt_);
    s.store_object_field("stickerset", static_cast<const BaseObject *>(stickerset_.get()));
    s.store_class_end();
  }
}

object_ptr<DraftMessage> DraftMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case draftMessageEmpty::ID:
      return draftMessageEmpty::fetch(p);
    case draftMessage::ID:
      return draftMessage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

draftMessageEmpty::draftMessageEmpty()
  : flags_()
  , date_()
{}

const std::int32_t draftMessageEmpty::ID;

object_ptr<DraftMessage> draftMessageEmpty::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<draftMessageEmpty> res = make_tl_object<draftMessageEmpty>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void draftMessageEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "draftMessageEmpty");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("date", date_); }
    s.store_class_end();
  }
}

draftMessage::draftMessage()
  : flags_()
  , no_webpage_()
  , invert_media_()
  , reply_to_()
  , message_()
  , entities_()
  , media_()
  , date_()
  , effect_()
  , suggested_post_()
{}

const std::int32_t draftMessage::ID;

object_ptr<DraftMessage> draftMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<draftMessage> res = make_tl_object<draftMessage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->no_webpage_ = (var0 & 2) != 0;
  res->invert_media_ = (var0 & 64) != 0;
  if (var0 & 16) { res->reply_to_ = TlFetchObject<InputReplyTo>::parse(p); }
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 8) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 32) { res->media_ = TlFetchObject<InputMedia>::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 128) { res->effect_ = TlFetchLong::parse(p); }
  if (var0 & 256) { res->suggested_post_ = TlFetchBoxed<TlFetchObject<suggestedPost>, 244201445>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void draftMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "draftMessage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (no_webpage_ << 1) | (invert_media_ << 6)));
    if (var0 & 2) { s.store_field("no_webpage", true); }
    if (var0 & 64) { s.store_field("invert_media", true); }
    if (var0 & 16) { s.store_object_field("reply_to", static_cast<const BaseObject *>(reply_to_.get())); }
    s.store_field("message", message_);
    if (var0 & 8) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 32) { s.store_object_field("media", static_cast<const BaseObject *>(media_.get())); }
    s.store_field("date", date_);
    if (var0 & 128) { s.store_field("effect", effect_); }
    if (var0 & 256) { s.store_object_field("suggested_post", static_cast<const BaseObject *>(suggested_post_.get())); }
    s.store_class_end();
  }
}

emailVerificationCode::emailVerificationCode(string const &code_)
  : code_(code_)
{}

const std::int32_t emailVerificationCode::ID;

void emailVerificationCode::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(code_, s);
}

void emailVerificationCode::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(code_, s);
}

void emailVerificationCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerificationCode");
    s.store_field("code", code_);
    s.store_class_end();
  }
}

emailVerificationGoogle::emailVerificationGoogle(string const &token_)
  : token_(token_)
{}

const std::int32_t emailVerificationGoogle::ID;

void emailVerificationGoogle::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(token_, s);
}

void emailVerificationGoogle::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(token_, s);
}

void emailVerificationGoogle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerificationGoogle");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

emailVerificationApple::emailVerificationApple(string const &token_)
  : token_(token_)
{}

const std::int32_t emailVerificationApple::ID;

void emailVerificationApple::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(token_, s);
}

void emailVerificationApple::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(token_, s);
}

void emailVerificationApple::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerificationApple");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

emailVerifyPurposeLoginSetup::emailVerifyPurposeLoginSetup(string const &phone_number_, string const &phone_code_hash_)
  : phone_number_(phone_number_)
  , phone_code_hash_(phone_code_hash_)
{}

const std::int32_t emailVerifyPurposeLoginSetup::ID;

void emailVerifyPurposeLoginSetup::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(phone_code_hash_, s);
}

void emailVerifyPurposeLoginSetup::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(phone_code_hash_, s);
}

void emailVerifyPurposeLoginSetup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerifyPurposeLoginSetup");
    s.store_field("phone_number", phone_number_);
    s.store_field("phone_code_hash", phone_code_hash_);
    s.store_class_end();
  }
}

const std::int32_t emailVerifyPurposeLoginChange::ID;

void emailVerifyPurposeLoginChange::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void emailVerifyPurposeLoginChange::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void emailVerifyPurposeLoginChange::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerifyPurposeLoginChange");
    s.store_class_end();
  }
}

const std::int32_t emailVerifyPurposePassport::ID;

void emailVerifyPurposePassport::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void emailVerifyPurposePassport::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void emailVerifyPurposePassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailVerifyPurposePassport");
    s.store_class_end();
  }
}

object_ptr<EmojiGroup> EmojiGroup::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case emojiGroup::ID:
      return emojiGroup::fetch(p);
    case emojiGroupGreeting::ID:
      return emojiGroupGreeting::fetch(p);
    case emojiGroupPremium::ID:
      return emojiGroupPremium::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t emojiGroup::ID;

object_ptr<EmojiGroup> emojiGroup::fetch(TlBufferParser &p) {
  return make_tl_object<emojiGroup>(p);
}

emojiGroup::emojiGroup(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , icon_emoji_id_(TlFetchLong::parse(p))
  , emoticons_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
{}

void emojiGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiGroup");
    s.store_field("title", title_);
    s.store_field("icon_emoji_id", icon_emoji_id_);
    { s.store_vector_begin("emoticons", emoticons_.size()); for (const auto &_value : emoticons_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t emojiGroupGreeting::ID;

object_ptr<EmojiGroup> emojiGroupGreeting::fetch(TlBufferParser &p) {
  return make_tl_object<emojiGroupGreeting>(p);
}

emojiGroupGreeting::emojiGroupGreeting(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , icon_emoji_id_(TlFetchLong::parse(p))
  , emoticons_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
{}

void emojiGroupGreeting::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiGroupGreeting");
    s.store_field("title", title_);
    s.store_field("icon_emoji_id", icon_emoji_id_);
    { s.store_vector_begin("emoticons", emoticons_.size()); for (const auto &_value : emoticons_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t emojiGroupPremium::ID;

object_ptr<EmojiGroup> emojiGroupPremium::fetch(TlBufferParser &p) {
  return make_tl_object<emojiGroupPremium>(p);
}

emojiGroupPremium::emojiGroupPremium(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , icon_emoji_id_(TlFetchLong::parse(p))
{}

void emojiGroupPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiGroupPremium");
    s.store_field("title", title_);
    s.store_field("icon_emoji_id", icon_emoji_id_);
    s.store_class_end();
  }
}

object_ptr<EmojiKeyword> EmojiKeyword::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case emojiKeyword::ID:
      return emojiKeyword::fetch(p);
    case emojiKeywordDeleted::ID:
      return emojiKeywordDeleted::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t emojiKeyword::ID;

object_ptr<EmojiKeyword> emojiKeyword::fetch(TlBufferParser &p) {
  return make_tl_object<emojiKeyword>(p);
}

emojiKeyword::emojiKeyword(TlBufferParser &p)
  : keyword_(TlFetchString<string>::parse(p))
  , emoticons_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
{}

void emojiKeyword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiKeyword");
    s.store_field("keyword", keyword_);
    { s.store_vector_begin("emoticons", emoticons_.size()); for (const auto &_value : emoticons_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t emojiKeywordDeleted::ID;

object_ptr<EmojiKeyword> emojiKeywordDeleted::fetch(TlBufferParser &p) {
  return make_tl_object<emojiKeywordDeleted>(p);
}

emojiKeywordDeleted::emojiKeywordDeleted(TlBufferParser &p)
  : keyword_(TlFetchString<string>::parse(p))
  , emoticons_(TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p))
{}

void emojiKeywordDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiKeywordDeleted");
    s.store_field("keyword", keyword_);
    { s.store_vector_begin("emoticons", emoticons_.size()); for (const auto &_value : emoticons_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t emojiKeywordsDifference::ID;

object_ptr<emojiKeywordsDifference> emojiKeywordsDifference::fetch(TlBufferParser &p) {
  return make_tl_object<emojiKeywordsDifference>(p);
}

emojiKeywordsDifference::emojiKeywordsDifference(TlBufferParser &p)
  : lang_code_(TlFetchString<string>::parse(p))
  , from_version_(TlFetchInt::parse(p))
  , version_(TlFetchInt::parse(p))
  , keywords_(TlFetchBoxed<TlFetchVector<TlFetchObject<EmojiKeyword>>, 481674261>::parse(p))
{}

void emojiKeywordsDifference::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiKeywordsDifference");
    s.store_field("lang_code", lang_code_);
    s.store_field("from_version", from_version_);
    s.store_field("version", version_);
    { s.store_vector_begin("keywords", keywords_.size()); for (const auto &_value : keywords_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t emojiLanguage::ID;

object_ptr<emojiLanguage> emojiLanguage::fetch(TlBufferParser &p) {
  return make_tl_object<emojiLanguage>(p);
}

emojiLanguage::emojiLanguage(TlBufferParser &p)
  : lang_code_(TlFetchString<string>::parse(p))
{}

void emojiLanguage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiLanguage");
    s.store_field("lang_code", lang_code_);
    s.store_class_end();
  }
}

object_ptr<EmojiList> EmojiList::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case emojiListNotModified::ID:
      return emojiListNotModified::fetch(p);
    case emojiList::ID:
      return emojiList::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t emojiListNotModified::ID;

object_ptr<EmojiList> emojiListNotModified::fetch(TlBufferParser &p) {
  return make_tl_object<emojiListNotModified>();
}

void emojiListNotModified::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiListNotModified");
    s.store_class_end();
  }
}

const std::int32_t emojiList::ID;

object_ptr<EmojiList> emojiList::fetch(TlBufferParser &p) {
  return make_tl_object<emojiList>(p);
}

emojiList::emojiList(TlBufferParser &p)
  : hash_(TlFetchLong::parse(p))
  , document_id_(TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p))
{}

void emojiList::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiList");
    s.store_field("hash", hash_);
    { s.store_vector_begin("document_id", document_id_.size()); for (const auto &_value : document_id_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<EmojiStatus> EmojiStatus::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case emojiStatusEmpty::ID:
      return emojiStatusEmpty::fetch(p);
    case emojiStatus::ID:
      return emojiStatus::fetch(p);
    case emojiStatusCollectible::ID:
      return emojiStatusCollectible::fetch(p);
    case inputEmojiStatusCollectible::ID:
      return inputEmojiStatusCollectible::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t emojiStatusEmpty::ID;

object_ptr<EmojiStatus> emojiStatusEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<emojiStatusEmpty>();
}

void emojiStatusEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void emojiStatusEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void emojiStatusEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatusEmpty");
    s.store_class_end();
  }
}

emojiStatus::emojiStatus()
  : flags_()
  , document_id_()
  , until_()
{}

emojiStatus::emojiStatus(int32 flags_, int64 document_id_, int32 until_)
  : flags_(flags_)
  , document_id_(document_id_)
  , until_(until_)
{}

const std::int32_t emojiStatus::ID;

object_ptr<EmojiStatus> emojiStatus::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<emojiStatus> res = make_tl_object<emojiStatus>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->document_id_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->until_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void emojiStatus::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(document_id_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void emojiStatus::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(document_id_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void emojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatus");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("document_id", document_id_);
    if (var0 & 1) { s.store_field("until", until_); }
    s.store_class_end();
  }
}

emojiStatusCollectible::emojiStatusCollectible()
  : flags_()
  , collectible_id_()
  , document_id_()
  , title_()
  , slug_()
  , pattern_document_id_()
  , center_color_()
  , edge_color_()
  , pattern_color_()
  , text_color_()
  , until_()
{}

emojiStatusCollectible::emojiStatusCollectible(int32 flags_, int64 collectible_id_, int64 document_id_, string const &title_, string const &slug_, int64 pattern_document_id_, int32 center_color_, int32 edge_color_, int32 pattern_color_, int32 text_color_, int32 until_)
  : flags_(flags_)
  , collectible_id_(collectible_id_)
  , document_id_(document_id_)
  , title_(title_)
  , slug_(slug_)
  , pattern_document_id_(pattern_document_id_)
  , center_color_(center_color_)
  , edge_color_(edge_color_)
  , pattern_color_(pattern_color_)
  , text_color_(text_color_)
  , until_(until_)
{}

const std::int32_t emojiStatusCollectible::ID;

object_ptr<EmojiStatus> emojiStatusCollectible::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<emojiStatusCollectible> res = make_tl_object<emojiStatusCollectible>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->collectible_id_ = TlFetchLong::parse(p);
  res->document_id_ = TlFetchLong::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->slug_ = TlFetchString<string>::parse(p);
  res->pattern_document_id_ = TlFetchLong::parse(p);
  res->center_color_ = TlFetchInt::parse(p);
  res->edge_color_ = TlFetchInt::parse(p);
  res->pattern_color_ = TlFetchInt::parse(p);
  res->text_color_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->until_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void emojiStatusCollectible::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(collectible_id_, s);
  TlStoreBinary::store(document_id_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(slug_, s);
  TlStoreBinary::store(pattern_document_id_, s);
  TlStoreBinary::store(center_color_, s);
  TlStoreBinary::store(edge_color_, s);
  TlStoreBinary::store(pattern_color_, s);
  TlStoreBinary::store(text_color_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void emojiStatusCollectible::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(collectible_id_, s);
  TlStoreBinary::store(document_id_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(slug_, s);
  TlStoreBinary::store(pattern_document_id_, s);
  TlStoreBinary::store(center_color_, s);
  TlStoreBinary::store(edge_color_, s);
  TlStoreBinary::store(pattern_color_, s);
  TlStoreBinary::store(text_color_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void emojiStatusCollectible::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatusCollectible");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("collectible_id", collectible_id_);
    s.store_field("document_id", document_id_);
    s.store_field("title", title_);
    s.store_field("slug", slug_);
    s.store_field("pattern_document_id", pattern_document_id_);
    s.store_field("center_color", center_color_);
    s.store_field("edge_color", edge_color_);
    s.store_field("pattern_color", pattern_color_);
    s.store_field("text_color", text_color_);
    if (var0 & 1) { s.store_field("until", until_); }
    s.store_class_end();
  }
}

inputEmojiStatusCollectible::inputEmojiStatusCollectible()
  : flags_()
  , collectible_id_()
  , until_()
{}

inputEmojiStatusCollectible::inputEmojiStatusCollectible(int32 flags_, int64 collectible_id_, int32 until_)
  : flags_(flags_)
  , collectible_id_(collectible_id_)
  , until_(until_)
{}

const std::int32_t inputEmojiStatusCollectible::ID;

object_ptr<EmojiStatus> inputEmojiStatusCollectible::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputEmojiStatusCollectible> res = make_tl_object<inputEmojiStatusCollectible>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->collectible_id_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->until_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputEmojiStatusCollectible::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(collectible_id_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void inputEmojiStatusCollectible::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(collectible_id_, s);
  if (var0 & 1) { TlStoreBinary::store(until_, s); }
}

void inputEmojiStatusCollectible::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEmojiStatusCollectible");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("collectible_id", collectible_id_);
    if (var0 & 1) { s.store_field("until", until_); }
    s.store_class_end();
  }
}

const std::int32_t emojiURL::ID;

object_ptr<emojiURL> emojiURL::fetch(TlBufferParser &p) {
  return make_tl_object<emojiURL>(p);
}

emojiURL::emojiURL(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
{}

void emojiURL::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiURL");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

object_ptr<EncryptedChat> EncryptedChat::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case encryptedChatEmpty::ID:
      return encryptedChatEmpty::fetch(p);
    case encryptedChatWaiting::ID:
      return encryptedChatWaiting::fetch(p);
    case encryptedChatRequested::ID:
      return encryptedChatRequested::fetch(p);
    case encryptedChat::ID:
      return encryptedChat::fetch(p);
    case encryptedChatDiscarded::ID:
      return encryptedChatDiscarded::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t encryptedChatEmpty::ID;

object_ptr<EncryptedChat> encryptedChatEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedChatEmpty>(p);
}

encryptedChatEmpty::encryptedChatEmpty(TlBufferParser &p)
  : id_(TlFetchInt::parse(p))
{}

void encryptedChatEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedChatEmpty");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

encryptedChatWaiting::encryptedChatWaiting(int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_)
  : id_(id_)
  , access_hash_(access_hash_)
  , date_(date_)
  , admin_id_(admin_id_)
  , participant_id_(participant_id_)
{}

const std::int32_t encryptedChatWaiting::ID;

object_ptr<EncryptedChat> encryptedChatWaiting::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedChatWaiting>(p);
}

encryptedChatWaiting::encryptedChatWaiting(TlBufferParser &p)
  : id_(TlFetchInt::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , date_(TlFetchInt::parse(p))
  , admin_id_(TlFetchLong::parse(p))
  , participant_id_(TlFetchLong::parse(p))
{}

void encryptedChatWaiting::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedChatWaiting");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("date", date_);
    s.store_field("admin_id", admin_id_);
    s.store_field("participant_id", participant_id_);
    s.store_class_end();
  }
}

encryptedChatRequested::encryptedChatRequested()
  : flags_()
  , folder_id_()
  , id_()
  , access_hash_()
  , date_()
  , admin_id_()
  , participant_id_()
  , g_a_()
{}

encryptedChatRequested::encryptedChatRequested(int32 flags_, int32 folder_id_, int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_, bytes &&g_a_)
  : flags_(flags_)
  , folder_id_(folder_id_)
  , id_(id_)
  , access_hash_(access_hash_)
  , date_(date_)
  , admin_id_(admin_id_)
  , participant_id_(participant_id_)
  , g_a_(std::move(g_a_))
{}

const std::int32_t encryptedChatRequested::ID;

object_ptr<EncryptedChat> encryptedChatRequested::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<encryptedChatRequested> res = make_tl_object<encryptedChatRequested>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->folder_id_ = TlFetchInt::parse(p); }
  res->id_ = TlFetchInt::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->admin_id_ = TlFetchLong::parse(p);
  res->participant_id_ = TlFetchLong::parse(p);
  res->g_a_ = TlFetchBytes<bytes>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void encryptedChatRequested::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedChatRequested");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("folder_id", folder_id_); }
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("date", date_);
    s.store_field("admin_id", admin_id_);
    s.store_field("participant_id", participant_id_);
    s.store_bytes_field("g_a", g_a_);
    s.store_class_end();
  }
}

encryptedChat::encryptedChat(int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_, bytes &&g_a_or_b_, int64 key_fingerprint_)
  : id_(id_)
  , access_hash_(access_hash_)
  , date_(date_)
  , admin_id_(admin_id_)
  , participant_id_(participant_id_)
  , g_a_or_b_(std::move(g_a_or_b_))
  , key_fingerprint_(key_fingerprint_)
{}

const std::int32_t encryptedChat::ID;

object_ptr<EncryptedChat> encryptedChat::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedChat>(p);
}

encryptedChat::encryptedChat(TlBufferParser &p)
  : id_(TlFetchInt::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , date_(TlFetchInt::parse(p))
  , admin_id_(TlFetchLong::parse(p))
  , participant_id_(TlFetchLong::parse(p))
  , g_a_or_b_(TlFetchBytes<bytes>::parse(p))
  , key_fingerprint_(TlFetchLong::parse(p))
{}

void encryptedChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedChat");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("date", date_);
    s.store_field("admin_id", admin_id_);
    s.store_field("participant_id", participant_id_);
    s.store_bytes_field("g_a_or_b", g_a_or_b_);
    s.store_field("key_fingerprint", key_fingerprint_);
    s.store_class_end();
  }
}

encryptedChatDiscarded::encryptedChatDiscarded()
  : flags_()
  , history_deleted_()
  , id_()
{}

const std::int32_t encryptedChatDiscarded::ID;

object_ptr<EncryptedChat> encryptedChatDiscarded::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<encryptedChatDiscarded> res = make_tl_object<encryptedChatDiscarded>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->history_deleted_ = (var0 & 1) != 0;
  res->id_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void encryptedChatDiscarded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedChatDiscarded");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (history_deleted_ << 0)));
    if (var0 & 1) { s.store_field("history_deleted", true); }
    s.store_field("id", id_);
    s.store_class_end();
  }
}

object_ptr<EncryptedFile> EncryptedFile::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case encryptedFileEmpty::ID:
      return encryptedFileEmpty::fetch(p);
    case encryptedFile::ID:
      return encryptedFile::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t encryptedFileEmpty::ID;

object_ptr<EncryptedFile> encryptedFileEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedFileEmpty>();
}

void encryptedFileEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedFileEmpty");
    s.store_class_end();
  }
}

const std::int32_t encryptedFile::ID;

object_ptr<EncryptedFile> encryptedFile::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedFile>(p);
}

encryptedFile::encryptedFile(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , size_(TlFetchLong::parse(p))
  , dc_id_(TlFetchInt::parse(p))
  , key_fingerprint_(TlFetchInt::parse(p))
{}

void encryptedFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedFile");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("size", size_);
    s.store_field("dc_id", dc_id_);
    s.store_field("key_fingerprint", key_fingerprint_);
    s.store_class_end();
  }
}

object_ptr<EncryptedMessage> EncryptedMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case encryptedMessage::ID:
      return encryptedMessage::fetch(p);
    case encryptedMessageService::ID:
      return encryptedMessageService::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t encryptedMessage::ID;

object_ptr<EncryptedMessage> encryptedMessage::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedMessage>(p);
}

encryptedMessage::encryptedMessage(TlBufferParser &p)
  : random_id_(TlFetchLong::parse(p))
  , chat_id_(TlFetchInt::parse(p))
  , date_(TlFetchInt::parse(p))
  , bytes_(TlFetchBytes<bytes>::parse(p))
  , file_(TlFetchObject<EncryptedFile>::parse(p))
{}

void encryptedMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedMessage");
    s.store_field("random_id", random_id_);
    s.store_field("chat_id", chat_id_);
    s.store_field("date", date_);
    s.store_bytes_field("bytes", bytes_);
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    s.store_class_end();
  }
}

const std::int32_t encryptedMessageService::ID;

object_ptr<EncryptedMessage> encryptedMessageService::fetch(TlBufferParser &p) {
  return make_tl_object<encryptedMessageService>(p);
}

encryptedMessageService::encryptedMessageService(TlBufferParser &p)
  : random_id_(TlFetchLong::parse(p))
  , chat_id_(TlFetchInt::parse(p))
  , date_(TlFetchInt::parse(p))
  , bytes_(TlFetchBytes<bytes>::parse(p))
{}

void encryptedMessageService::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedMessageService");
    s.store_field("random_id", random_id_);
    s.store_field("chat_id", chat_id_);
    s.store_field("date", date_);
    s.store_bytes_field("bytes", bytes_);
    s.store_class_end();
  }
}

const std::int32_t error::ID;

object_ptr<error> error::fetch(TlBufferParser &p) {
  return make_tl_object<error>(p);
}

error::error(TlBufferParser &p)
  : code_(TlFetchInt::parse(p))
  , text_(TlFetchString<string>::parse(p))
{}

void error::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "error");
    s.store_field("code", code_);
    s.store_field("text", text_);
    s.store_class_end();
  }
}

object_ptr<ExportedChatInvite> ExportedChatInvite::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case chatInviteExported::ID:
      return chatInviteExported::fetch(p);
    case chatInvitePublicJoinRequests::ID:
      return chatInvitePublicJoinRequests::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

chatInviteExported::chatInviteExported()
  : flags_()
  , revoked_()
  , permanent_()
  , request_needed_()
  , link_()
  , admin_id_()
  , date_()
  , start_date_()
  , expire_date_()
  , usage_limit_()
  , usage_()
  , requested_()
  , subscription_expired_()
  , title_()
  , subscription_pricing_()
{}

const std::int32_t chatInviteExported::ID;

object_ptr<ExportedChatInvite> chatInviteExported::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<chatInviteExported> res = make_tl_object<chatInviteExported>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->revoked_ = (var0 & 1) != 0;
  res->permanent_ = (var0 & 32) != 0;
  res->request_needed_ = (var0 & 64) != 0;
  res->link_ = TlFetchString<string>::parse(p);
  res->admin_id_ = TlFetchLong::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 16) { res->start_date_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->expire_date_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->usage_limit_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->usage_ = TlFetchInt::parse(p); }
  if (var0 & 128) { res->requested_ = TlFetchInt::parse(p); }
  if (var0 & 1024) { res->subscription_expired_ = TlFetchInt::parse(p); }
  if (var0 & 256) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 512) { res->subscription_pricing_ = TlFetchBoxed<TlFetchObject<starsSubscriptionPricing>, 88173912>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void chatInviteExported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteExported");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (revoked_ << 0) | (permanent_ << 5) | (request_needed_ << 6)));
    if (var0 & 1) { s.store_field("revoked", true); }
    if (var0 & 32) { s.store_field("permanent", true); }
    if (var0 & 64) { s.store_field("request_needed", true); }
    s.store_field("link", link_);
    s.store_field("admin_id", admin_id_);
    s.store_field("date", date_);
    if (var0 & 16) { s.store_field("start_date", start_date_); }
    if (var0 & 2) { s.store_field("expire_date", expire_date_); }
    if (var0 & 4) { s.store_field("usage_limit", usage_limit_); }
    if (var0 & 8) { s.store_field("usage", usage_); }
    if (var0 & 128) { s.store_field("requested", requested_); }
    if (var0 & 1024) { s.store_field("subscription_expired", subscription_expired_); }
    if (var0 & 256) { s.store_field("title", title_); }
    if (var0 & 512) { s.store_object_field("subscription_pricing", static_cast<const BaseObject *>(subscription_pricing_.get())); }
    s.store_class_end();
  }
}

const std::int32_t chatInvitePublicJoinRequests::ID;

object_ptr<ExportedChatInvite> chatInvitePublicJoinRequests::fetch(TlBufferParser &p) {
  return make_tl_object<chatInvitePublicJoinRequests>();
}

void chatInvitePublicJoinRequests::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInvitePublicJoinRequests");
    s.store_class_end();
  }
}

exportedChatlistInvite::exportedChatlistInvite()
  : flags_()
  , title_()
  , url_()
  , peers_()
{}

const std::int32_t exportedChatlistInvite::ID;

object_ptr<exportedChatlistInvite> exportedChatlistInvite::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<exportedChatlistInvite> res = make_tl_object<exportedChatlistInvite>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->title_ = TlFetchString<string>::parse(p);
  res->url_ = TlFetchString<string>::parse(p);
  res->peers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Peer>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void exportedChatlistInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "exportedChatlistInvite");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("url", url_);
    { s.store_vector_begin("peers", peers_.size()); for (const auto &_value : peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t exportedContactToken::ID;

object_ptr<exportedContactToken> exportedContactToken::fetch(TlBufferParser &p) {
  return make_tl_object<exportedContactToken>(p);
}

exportedContactToken::exportedContactToken(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
  , expires_(TlFetchInt::parse(p))
{}

void exportedContactToken::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "exportedContactToken");
    s.store_field("url", url_);
    s.store_field("expires", expires_);
    s.store_class_end();
  }
}

const std::int32_t exportedMessageLink::ID;

object_ptr<exportedMessageLink> exportedMessageLink::fetch(TlBufferParser &p) {
  return make_tl_object<exportedMessageLink>(p);
}

exportedMessageLink::exportedMessageLink(TlBufferParser &p)
  : link_(TlFetchString<string>::parse(p))
  , html_(TlFetchString<string>::parse(p))
{}

void exportedMessageLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "exportedMessageLink");
    s.store_field("link", link_);
    s.store_field("html", html_);
    s.store_class_end();
  }
}

const std::int32_t exportedStoryLink::ID;

object_ptr<exportedStoryLink> exportedStoryLink::fetch(TlBufferParser &p) {
  return make_tl_object<exportedStoryLink>(p);
}

exportedStoryLink::exportedStoryLink(TlBufferParser &p)
  : link_(TlFetchString<string>::parse(p))
{}

void exportedStoryLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "exportedStoryLink");
    s.store_field("link", link_);
    s.store_class_end();
  }
}

factCheck::factCheck()
  : flags_()
  , need_check_()
  , country_()
  , text_()
  , hash_()
{}

const std::int32_t factCheck::ID;

object_ptr<factCheck> factCheck::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<factCheck> res = make_tl_object<factCheck>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->need_check_ = (var0 & 1) != 0;
  if (var0 & 2) { res->country_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->text_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p); }
  res->hash_ = TlFetchLong::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void factCheck::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "factCheck");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (need_check_ << 0)));
    if (var0 & 1) { s.store_field("need_check", true); }
    if (var0 & 2) { s.store_field("country", country_); }
    if (var0 & 2) { s.store_object_field("text", static_cast<const BaseObject *>(text_.get())); }
    s.store_field("hash", hash_);
    s.store_class_end();
  }
}

const std::int32_t fileHash::ID;

object_ptr<fileHash> fileHash::fetch(TlBufferParser &p) {
  return make_tl_object<fileHash>(p);
}

fileHash::fileHash(TlBufferParser &p)
  : offset_(TlFetchLong::parse(p))
  , limit_(TlFetchInt::parse(p))
  , hash_(TlFetchBytes<bytes>::parse(p))
{}

void fileHash::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileHash");
    s.store_field("offset", offset_);
    s.store_field("limit", limit_);
    s.store_bytes_field("hash", hash_);
    s.store_class_end();
  }
}

folder::folder()
  : flags_()
  , autofill_new_broadcasts_()
  , autofill_public_groups_()
  , autofill_new_correspondents_()
  , id_()
  , title_()
  , photo_()
{}

const std::int32_t folder::ID;

object_ptr<folder> folder::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<folder> res = make_tl_object<folder>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->autofill_new_broadcasts_ = (var0 & 1) != 0;
  res->autofill_public_groups_ = (var0 & 2) != 0;
  res->autofill_new_correspondents_ = (var0 & 4) != 0;
  res->id_ = TlFetchInt::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  if (var0 & 8) { res->photo_ = TlFetchObject<ChatPhoto>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void folder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "folder");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (autofill_new_broadcasts_ << 0) | (autofill_public_groups_ << 1) | (autofill_new_correspondents_ << 2)));
    if (var0 & 1) { s.store_field("autofill_new_broadcasts", true); }
    if (var0 & 2) { s.store_field("autofill_public_groups", true); }
    if (var0 & 4) { s.store_field("autofill_new_correspondents", true); }
    s.store_field("id", id_);
    s.store_field("title", title_);
    if (var0 & 8) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    s.store_class_end();
  }
}

const std::int32_t folderPeer::ID;

object_ptr<folderPeer> folderPeer::fetch(TlBufferParser &p) {
  return make_tl_object<folderPeer>(p);
}

folderPeer::folderPeer(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , folder_id_(TlFetchInt::parse(p))
{}

void folderPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "folderPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("folder_id", folder_id_);
    s.store_class_end();
  }
}

object_ptr<ForumTopic> ForumTopic::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case forumTopicDeleted::ID:
      return forumTopicDeleted::fetch(p);
    case forumTopic::ID:
      return forumTopic::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t forumTopicDeleted::ID;

object_ptr<ForumTopic> forumTopicDeleted::fetch(TlBufferParser &p) {
  return make_tl_object<forumTopicDeleted>(p);
}

forumTopicDeleted::forumTopicDeleted(TlBufferParser &p)
  : id_(TlFetchInt::parse(p))
{}

void forumTopicDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopicDeleted");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

forumTopic::forumTopic()
  : flags_()
  , my_()
  , closed_()
  , pinned_()
  , short_()
  , hidden_()
  , id_()
  , date_()
  , title_()
  , icon_color_()
  , icon_emoji_id_()
  , top_message_()
  , read_inbox_max_id_()
  , read_outbox_max_id_()
  , unread_count_()
  , unread_mentions_count_()
  , unread_reactions_count_()
  , from_id_()
  , notify_settings_()
  , draft_()
{}

const std::int32_t forumTopic::ID;

object_ptr<ForumTopic> forumTopic::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<forumTopic> res = make_tl_object<forumTopic>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->my_ = (var0 & 2) != 0;
  res->closed_ = (var0 & 4) != 0;
  res->pinned_ = (var0 & 8) != 0;
  res->short_ = (var0 & 32) != 0;
  res->hidden_ = (var0 & 64) != 0;
  res->id_ = TlFetchInt::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->icon_color_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->icon_emoji_id_ = TlFetchLong::parse(p); }
  res->top_message_ = TlFetchInt::parse(p);
  res->read_inbox_max_id_ = TlFetchInt::parse(p);
  res->read_outbox_max_id_ = TlFetchInt::parse(p);
  res->unread_count_ = TlFetchInt::parse(p);
  res->unread_mentions_count_ = TlFetchInt::parse(p);
  res->unread_reactions_count_ = TlFetchInt::parse(p);
  res->from_id_ = TlFetchObject<Peer>::parse(p);
  res->notify_settings_ = TlFetchBoxed<TlFetchObject<peerNotifySettings>, -1721619444>::parse(p);
  if (var0 & 16) { res->draft_ = TlFetchObject<DraftMessage>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void forumTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopic");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (my_ << 1) | (closed_ << 2) | (pinned_ << 3) | (short_ << 5) | (hidden_ << 6)));
    if (var0 & 2) { s.store_field("my", true); }
    if (var0 & 4) { s.store_field("closed", true); }
    if (var0 & 8) { s.store_field("pinned", true); }
    if (var0 & 32) { s.store_field("short", true); }
    if (var0 & 64) { s.store_field("hidden", true); }
    s.store_field("id", id_);
    s.store_field("date", date_);
    s.store_field("title", title_);
    s.store_field("icon_color", icon_color_);
    if (var0 & 1) { s.store_field("icon_emoji_id", icon_emoji_id_); }
    s.store_field("top_message", top_message_);
    s.store_field("read_inbox_max_id", read_inbox_max_id_);
    s.store_field("read_outbox_max_id", read_outbox_max_id_);
    s.store_field("unread_count", unread_count_);
    s.store_field("unread_mentions_count", unread_mentions_count_);
    s.store_field("unread_reactions_count", unread_reactions_count_);
    s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get()));
    s.store_object_field("notify_settings", static_cast<const BaseObject *>(notify_settings_.get()));
    if (var0 & 16) { s.store_object_field("draft", static_cast<const BaseObject *>(draft_.get())); }
    s.store_class_end();
  }
}

const std::int32_t foundStory::ID;

object_ptr<foundStory> foundStory::fetch(TlBufferParser &p) {
  return make_tl_object<foundStory>(p);
}

foundStory::foundStory(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , story_(TlFetchObject<StoryItem>::parse(p))
{}

void foundStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundStory");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_object_field("story", static_cast<const BaseObject *>(story_.get()));
    s.store_class_end();
  }
}

game::game()
  : flags_()
  , id_()
  , access_hash_()
  , short_name_()
  , title_()
  , description_()
  , photo_()
  , document_()
{}

const std::int32_t game::ID;

object_ptr<game> game::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<game> res = make_tl_object<game>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchLong::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->short_name_ = TlFetchString<string>::parse(p);
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  res->photo_ = TlFetchObject<Photo>::parse(p);
  if (var0 & 1) { res->document_ = TlFetchObject<Document>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void game::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "game");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("short_name", short_name_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    if (var0 & 1) { s.store_object_field("document", static_cast<const BaseObject *>(document_.get())); }
    s.store_class_end();
  }
}

object_ptr<GeoPoint> GeoPoint::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case geoPointEmpty::ID:
      return geoPointEmpty::fetch(p);
    case geoPoint::ID:
      return geoPoint::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t geoPointEmpty::ID;

object_ptr<GeoPoint> geoPointEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<geoPointEmpty>();
}

void geoPointEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void geoPointEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void geoPointEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "geoPointEmpty");
    s.store_class_end();
  }
}

geoPoint::geoPoint()
  : flags_()
  , long_()
  , lat_()
  , access_hash_()
  , accuracy_radius_()
{}

geoPoint::geoPoint(int32 flags_, double long_, double lat_, int64 access_hash_, int32 accuracy_radius_)
  : flags_(flags_)
  , long_(long_)
  , lat_(lat_)
  , access_hash_(access_hash_)
  , accuracy_radius_(accuracy_radius_)
{}

const std::int32_t geoPoint::ID;

object_ptr<GeoPoint> geoPoint::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<geoPoint> res = make_tl_object<geoPoint>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->long_ = TlFetchDouble::parse(p);
  res->lat_ = TlFetchDouble::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->accuracy_radius_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void geoPoint::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(long_, s);
  TlStoreBinary::store(lat_, s);
  TlStoreBinary::store(access_hash_, s);
  if (var0 & 1) { TlStoreBinary::store(accuracy_radius_, s); }
}

void geoPoint::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(long_, s);
  TlStoreBinary::store(lat_, s);
  TlStoreBinary::store(access_hash_, s);
  if (var0 & 1) { TlStoreBinary::store(accuracy_radius_, s); }
}

void geoPoint::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "geoPoint");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("long", long_);
    s.store_field("lat", lat_);
    s.store_field("access_hash", access_hash_);
    if (var0 & 1) { s.store_field("accuracy_radius", accuracy_radius_); }
    s.store_class_end();
  }
}

geoPointAddress::geoPointAddress()
  : flags_()
  , country_iso2_()
  , state_()
  , city_()
  , street_()
{}

geoPointAddress::geoPointAddress(int32 flags_, string const &country_iso2_, string const &state_, string const &city_, string const &street_)
  : flags_(flags_)
  , country_iso2_(country_iso2_)
  , state_(state_)
  , city_(city_)
  , street_(street_)
{}

const std::int32_t geoPointAddress::ID;

object_ptr<geoPointAddress> geoPointAddress::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<geoPointAddress> res = make_tl_object<geoPointAddress>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->country_iso2_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->state_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->city_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->street_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void geoPointAddress::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(country_iso2_, s);
  if (var0 & 1) { TlStoreString::store(state_, s); }
  if (var0 & 2) { TlStoreString::store(city_, s); }
  if (var0 & 4) { TlStoreString::store(street_, s); }
}

void geoPointAddress::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(country_iso2_, s);
  if (var0 & 1) { TlStoreString::store(state_, s); }
  if (var0 & 2) { TlStoreString::store(city_, s); }
  if (var0 & 4) { TlStoreString::store(street_, s); }
}

void geoPointAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "geoPointAddress");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("country_iso2", country_iso2_);
    if (var0 & 1) { s.store_field("state", state_); }
    if (var0 & 2) { s.store_field("city", city_); }
    if (var0 & 4) { s.store_field("street", street_); }
    s.store_class_end();
  }
}

globalPrivacySettings::globalPrivacySettings()
  : flags_()
  , archive_and_mute_new_noncontact_peers_()
  , keep_archived_unmuted_()
  , keep_archived_folders_()
  , hide_read_marks_()
  , new_noncontact_peers_require_premium_()
  , display_gifts_button_()
  , noncontact_peers_paid_stars_()
  , disallowed_gifts_()
{}

globalPrivacySettings::globalPrivacySettings(int32 flags_, bool archive_and_mute_new_noncontact_peers_, bool keep_archived_unmuted_, bool keep_archived_folders_, bool hide_read_marks_, bool new_noncontact_peers_require_premium_, bool display_gifts_button_, int64 noncontact_peers_paid_stars_, object_ptr<disallowedGiftsSettings> &&disallowed_gifts_)
  : flags_(flags_)
  , archive_and_mute_new_noncontact_peers_(archive_and_mute_new_noncontact_peers_)
  , keep_archived_unmuted_(keep_archived_unmuted_)
  , keep_archived_folders_(keep_archived_folders_)
  , hide_read_marks_(hide_read_marks_)
  , new_noncontact_peers_require_premium_(new_noncontact_peers_require_premium_)
  , display_gifts_button_(display_gifts_button_)
  , noncontact_peers_paid_stars_(noncontact_peers_paid_stars_)
  , disallowed_gifts_(std::move(disallowed_gifts_))
{}

const std::int32_t globalPrivacySettings::ID;

object_ptr<globalPrivacySettings> globalPrivacySettings::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<globalPrivacySettings> res = make_tl_object<globalPrivacySettings>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->archive_and_mute_new_noncontact_peers_ = (var0 & 1) != 0;
  res->keep_archived_unmuted_ = (var0 & 2) != 0;
  res->keep_archived_folders_ = (var0 & 4) != 0;
  res->hide_read_marks_ = (var0 & 8) != 0;
  res->new_noncontact_peers_require_premium_ = (var0 & 16) != 0;
  res->display_gifts_button_ = (var0 & 128) != 0;
  if (var0 & 32) { res->noncontact_peers_paid_stars_ = TlFetchLong::parse(p); }
  if (var0 & 64) { res->disallowed_gifts_ = TlFetchBoxed<TlFetchObject<disallowedGiftsSettings>, 1911715524>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void globalPrivacySettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (archive_and_mute_new_noncontact_peers_ << 0) | (keep_archived_unmuted_ << 1) | (keep_archived_folders_ << 2) | (hide_read_marks_ << 3) | (new_noncontact_peers_require_premium_ << 4) | (display_gifts_button_ << 7)), s);
  if (var0 & 32) { TlStoreBinary::store(noncontact_peers_paid_stars_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreObject, 1911715524>::store(disallowed_gifts_, s); }
}

void globalPrivacySettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (archive_and_mute_new_noncontact_peers_ << 0) | (keep_archived_unmuted_ << 1) | (keep_archived_folders_ << 2) | (hide_read_marks_ << 3) | (new_noncontact_peers_require_premium_ << 4) | (display_gifts_button_ << 7)), s);
  if (var0 & 32) { TlStoreBinary::store(noncontact_peers_paid_stars_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreObject, 1911715524>::store(disallowed_gifts_, s); }
}

void globalPrivacySettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "globalPrivacySettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (archive_and_mute_new_noncontact_peers_ << 0) | (keep_archived_unmuted_ << 1) | (keep_archived_folders_ << 2) | (hide_read_marks_ << 3) | (new_noncontact_peers_require_premium_ << 4) | (display_gifts_button_ << 7)));
    if (var0 & 1) { s.store_field("archive_and_mute_new_noncontact_peers", true); }
    if (var0 & 2) { s.store_field("keep_archived_unmuted", true); }
    if (var0 & 4) { s.store_field("keep_archived_folders", true); }
    if (var0 & 8) { s.store_field("hide_read_marks", true); }
    if (var0 & 16) { s.store_field("new_noncontact_peers_require_premium", true); }
    if (var0 & 128) { s.store_field("display_gifts_button", true); }
    if (var0 & 32) { s.store_field("noncontact_peers_paid_stars", noncontact_peers_paid_stars_); }
    if (var0 & 64) { s.store_object_field("disallowed_gifts", static_cast<const BaseObject *>(disallowed_gifts_.get())); }
    s.store_class_end();
  }
}

object_ptr<GroupCall> GroupCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case groupCallDiscarded::ID:
      return groupCallDiscarded::fetch(p);
    case groupCall::ID:
      return groupCall::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t groupCallDiscarded::ID;

object_ptr<GroupCall> groupCallDiscarded::fetch(TlBufferParser &p) {
  return make_tl_object<groupCallDiscarded>(p);
}

groupCallDiscarded::groupCallDiscarded(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , duration_(TlFetchInt::parse(p))
{}

void groupCallDiscarded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallDiscarded");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

groupCall::groupCall()
  : flags_()
  , join_muted_()
  , can_change_join_muted_()
  , join_date_asc_()
  , schedule_start_subscribed_()
  , can_start_video_()
  , record_video_active_()
  , rtmp_stream_()
  , listeners_hidden_()
  , conference_()
  , creator_()
  , id_()
  , access_hash_()
  , participants_count_()
  , title_()
  , stream_dc_id_()
  , record_start_date_()
  , schedule_date_()
  , unmuted_video_count_()
  , unmuted_video_limit_()
  , version_()
  , invite_link_()
{}

const std::int32_t groupCall::ID;

object_ptr<GroupCall> groupCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<groupCall> res = make_tl_object<groupCall>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->join_muted_ = (var0 & 2) != 0;
  res->can_change_join_muted_ = (var0 & 4) != 0;
  res->join_date_asc_ = (var0 & 64) != 0;
  res->schedule_start_subscribed_ = (var0 & 256) != 0;
  res->can_start_video_ = (var0 & 512) != 0;
  res->record_video_active_ = (var0 & 2048) != 0;
  res->rtmp_stream_ = (var0 & 4096) != 0;
  res->listeners_hidden_ = (var0 & 8192) != 0;
  res->conference_ = (var0 & 16384) != 0;
  res->creator_ = (var0 & 32768) != 0;
  res->id_ = TlFetchLong::parse(p);
  res->access_hash_ = TlFetchLong::parse(p);
  res->participants_count_ = TlFetchInt::parse(p);
  if (var0 & 8) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->stream_dc_id_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->record_start_date_ = TlFetchInt::parse(p); }
  if (var0 & 128) { res->schedule_date_ = TlFetchInt::parse(p); }
  if (var0 & 1024) { res->unmuted_video_count_ = TlFetchInt::parse(p); }
  res->unmuted_video_limit_ = TlFetchInt::parse(p);
  res->version_ = TlFetchInt::parse(p);
  if (var0 & 65536) { res->invite_link_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void groupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCall");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (join_muted_ << 1) | (can_change_join_muted_ << 2) | (join_date_asc_ << 6) | (schedule_start_subscribed_ << 8) | (can_start_video_ << 9) | (record_video_active_ << 11) | (rtmp_stream_ << 12) | (listeners_hidden_ << 13) | (conference_ << 14) | (creator_ << 15)));
    if (var0 & 2) { s.store_field("join_muted", true); }
    if (var0 & 4) { s.store_field("can_change_join_muted", true); }
    if (var0 & 64) { s.store_field("join_date_asc", true); }
    if (var0 & 256) { s.store_field("schedule_start_subscribed", true); }
    if (var0 & 512) { s.store_field("can_start_video", true); }
    if (var0 & 2048) { s.store_field("record_video_active", true); }
    if (var0 & 4096) { s.store_field("rtmp_stream", true); }
    if (var0 & 8192) { s.store_field("listeners_hidden", true); }
    if (var0 & 16384) { s.store_field("conference", true); }
    if (var0 & 32768) { s.store_field("creator", true); }
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_field("participants_count", participants_count_);
    if (var0 & 8) { s.store_field("title", title_); }
    if (var0 & 16) { s.store_field("stream_dc_id", stream_dc_id_); }
    if (var0 & 32) { s.store_field("record_start_date", record_start_date_); }
    if (var0 & 128) { s.store_field("schedule_date", schedule_date_); }
    if (var0 & 1024) { s.store_field("unmuted_video_count", unmuted_video_count_); }
    s.store_field("unmuted_video_limit", unmuted_video_limit_);
    s.store_field("version", version_);
    if (var0 & 65536) { s.store_field("invite_link", invite_link_); }
    s.store_class_end();
  }
}

groupCallParticipant::groupCallParticipant()
  : flags_()
  , muted_()
  , left_()
  , can_self_unmute_()
  , just_joined_()
  , versioned_()
  , min_()
  , muted_by_you_()
  , volume_by_admin_()
  , self_()
  , video_joined_()
  , peer_()
  , date_()
  , active_date_()
  , source_()
  , volume_()
  , about_()
  , raise_hand_rating_()
  , video_()
  , presentation_()
{}

const std::int32_t groupCallParticipant::ID;

object_ptr<groupCallParticipant> groupCallParticipant::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<groupCallParticipant> res = make_tl_object<groupCallParticipant>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->muted_ = (var0 & 1) != 0;
  res->left_ = (var0 & 2) != 0;
  res->can_self_unmute_ = (var0 & 4) != 0;
  res->just_joined_ = (var0 & 16) != 0;
  res->versioned_ = (var0 & 32) != 0;
  res->min_ = (var0 & 256) != 0;
  res->muted_by_you_ = (var0 & 512) != 0;
  res->volume_by_admin_ = (var0 & 1024) != 0;
  res->self_ = (var0 & 4096) != 0;
  res->video_joined_ = (var0 & 32768) != 0;
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 8) { res->active_date_ = TlFetchInt::parse(p); }
  res->source_ = TlFetchInt::parse(p);
  if (var0 & 128) { res->volume_ = TlFetchInt::parse(p); }
  if (var0 & 2048) { res->about_ = TlFetchString<string>::parse(p); }
  if (var0 & 8192) { res->raise_hand_rating_ = TlFetchLong::parse(p); }
  if (var0 & 64) { res->video_ = TlFetchBoxed<TlFetchObject<groupCallParticipantVideo>, 1735736008>::parse(p); }
  if (var0 & 16384) { res->presentation_ = TlFetchBoxed<TlFetchObject<groupCallParticipantVideo>, 1735736008>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void groupCallParticipant::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallParticipant");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (muted_ << 0) | (left_ << 1) | (can_self_unmute_ << 2) | (just_joined_ << 4) | (versioned_ << 5) | (min_ << 8) | (muted_by_you_ << 9) | (volume_by_admin_ << 10) | (self_ << 12) | (video_joined_ << 15)));
    if (var0 & 1) { s.store_field("muted", true); }
    if (var0 & 2) { s.store_field("left", true); }
    if (var0 & 4) { s.store_field("can_self_unmute", true); }
    if (var0 & 16) { s.store_field("just_joined", true); }
    if (var0 & 32) { s.store_field("versioned", true); }
    if (var0 & 256) { s.store_field("min", true); }
    if (var0 & 512) { s.store_field("muted_by_you", true); }
    if (var0 & 1024) { s.store_field("volume_by_admin", true); }
    if (var0 & 4096) { s.store_field("self", true); }
    if (var0 & 32768) { s.store_field("video_joined", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("date", date_);
    if (var0 & 8) { s.store_field("active_date", active_date_); }
    s.store_field("source", source_);
    if (var0 & 128) { s.store_field("volume", volume_); }
    if (var0 & 2048) { s.store_field("about", about_); }
    if (var0 & 8192) { s.store_field("raise_hand_rating", raise_hand_rating_); }
    if (var0 & 64) { s.store_object_field("video", static_cast<const BaseObject *>(video_.get())); }
    if (var0 & 16384) { s.store_object_field("presentation", static_cast<const BaseObject *>(presentation_.get())); }
    s.store_class_end();
  }
}

groupCallParticipantVideo::groupCallParticipantVideo()
  : flags_()
  , paused_()
  , endpoint_()
  , source_groups_()
  , audio_source_()
{}

const std::int32_t groupCallParticipantVideo::ID;

object_ptr<groupCallParticipantVideo> groupCallParticipantVideo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<groupCallParticipantVideo> res = make_tl_object<groupCallParticipantVideo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->paused_ = (var0 & 1) != 0;
  res->endpoint_ = TlFetchString<string>::parse(p);
  res->source_groups_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<groupCallParticipantVideoSourceGroup>, -592373577>>, 481674261>::parse(p);
  if (var0 & 2) { res->audio_source_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void groupCallParticipantVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallParticipantVideo");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (paused_ << 0)));
    if (var0 & 1) { s.store_field("paused", true); }
    s.store_field("endpoint", endpoint_);
    { s.store_vector_begin("source_groups", source_groups_.size()); for (const auto &_value : source_groups_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 2) { s.store_field("audio_source", audio_source_); }
    s.store_class_end();
  }
}

const std::int32_t groupCallParticipantVideoSourceGroup::ID;

object_ptr<groupCallParticipantVideoSourceGroup> groupCallParticipantVideoSourceGroup::fetch(TlBufferParser &p) {
  return make_tl_object<groupCallParticipantVideoSourceGroup>(p);
}

groupCallParticipantVideoSourceGroup::groupCallParticipantVideoSourceGroup(TlBufferParser &p)
  : semantics_(TlFetchString<string>::parse(p))
  , sources_(TlFetchBoxed<TlFetchVector<TlFetchInt>, 481674261>::parse(p))
{}

void groupCallParticipantVideoSourceGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallParticipantVideoSourceGroup");
    s.store_field("semantics", semantics_);
    { s.store_vector_begin("sources", sources_.size()); for (const auto &_value : sources_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t groupCallStreamChannel::ID;

object_ptr<groupCallStreamChannel> groupCallStreamChannel::fetch(TlBufferParser &p) {
  return make_tl_object<groupCallStreamChannel>(p);
}

groupCallStreamChannel::groupCallStreamChannel(TlBufferParser &p)
  : channel_(TlFetchInt::parse(p))
  , scale_(TlFetchInt::parse(p))
  , last_timestamp_ms_(TlFetchLong::parse(p))
{}

void groupCallStreamChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallStreamChannel");
    s.store_field("channel", channel_);
    s.store_field("scale", scale_);
    s.store_field("last_timestamp_ms", last_timestamp_ms_);
    s.store_class_end();
  }
}

const std::int32_t highScore::ID;

object_ptr<highScore> highScore::fetch(TlBufferParser &p) {
  return make_tl_object<highScore>(p);
}

highScore::highScore(TlBufferParser &p)
  : pos_(TlFetchInt::parse(p))
  , user_id_(TlFetchLong::parse(p))
  , score_(TlFetchInt::parse(p))
{}

void highScore::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "highScore");
    s.store_field("pos", pos_);
    s.store_field("user_id", user_id_);
    s.store_field("score", score_);
    s.store_class_end();
  }
}

const std::int32_t importedContact::ID;

object_ptr<importedContact> importedContact::fetch(TlBufferParser &p) {
  return make_tl_object<importedContact>(p);
}

importedContact::importedContact(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , client_id_(TlFetchLong::parse(p))
{}

void importedContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "importedContact");
    s.store_field("user_id", user_id_);
    s.store_field("client_id", client_id_);
    s.store_class_end();
  }
}

inlineBotSwitchPM::inlineBotSwitchPM(string const &text_, string const &start_param_)
  : text_(text_)
  , start_param_(start_param_)
{}

const std::int32_t inlineBotSwitchPM::ID;

object_ptr<inlineBotSwitchPM> inlineBotSwitchPM::fetch(TlBufferParser &p) {
  return make_tl_object<inlineBotSwitchPM>(p);
}

inlineBotSwitchPM::inlineBotSwitchPM(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , start_param_(TlFetchString<string>::parse(p))
{}

void inlineBotSwitchPM::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(start_param_, s);
}

void inlineBotSwitchPM::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(start_param_, s);
}

void inlineBotSwitchPM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineBotSwitchPM");
    s.store_field("text", text_);
    s.store_field("start_param", start_param_);
    s.store_class_end();
  }
}

inlineBotWebView::inlineBotWebView(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t inlineBotWebView::ID;

object_ptr<inlineBotWebView> inlineBotWebView::fetch(TlBufferParser &p) {
  return make_tl_object<inlineBotWebView>(p);
}

inlineBotWebView::inlineBotWebView(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void inlineBotWebView::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void inlineBotWebView::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void inlineBotWebView::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineBotWebView");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

object_ptr<InlineQueryPeerType> InlineQueryPeerType::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inlineQueryPeerTypeSameBotPM::ID:
      return inlineQueryPeerTypeSameBotPM::fetch(p);
    case inlineQueryPeerTypePM::ID:
      return inlineQueryPeerTypePM::fetch(p);
    case inlineQueryPeerTypeChat::ID:
      return inlineQueryPeerTypeChat::fetch(p);
    case inlineQueryPeerTypeMegagroup::ID:
      return inlineQueryPeerTypeMegagroup::fetch(p);
    case inlineQueryPeerTypeBroadcast::ID:
      return inlineQueryPeerTypeBroadcast::fetch(p);
    case inlineQueryPeerTypeBotPM::ID:
      return inlineQueryPeerTypeBotPM::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inlineQueryPeerTypeSameBotPM::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypeSameBotPM::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypeSameBotPM>();
}

void inlineQueryPeerTypeSameBotPM::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeSameBotPM::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeSameBotPM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypeSameBotPM");
    s.store_class_end();
  }
}

const std::int32_t inlineQueryPeerTypePM::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypePM::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypePM>();
}

void inlineQueryPeerTypePM::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypePM::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypePM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypePM");
    s.store_class_end();
  }
}

const std::int32_t inlineQueryPeerTypeChat::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypeChat::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypeChat>();
}

void inlineQueryPeerTypeChat::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeChat::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypeChat");
    s.store_class_end();
  }
}

const std::int32_t inlineQueryPeerTypeMegagroup::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypeMegagroup::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypeMegagroup>();
}

void inlineQueryPeerTypeMegagroup::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeMegagroup::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeMegagroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypeMegagroup");
    s.store_class_end();
  }
}

const std::int32_t inlineQueryPeerTypeBroadcast::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypeBroadcast::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypeBroadcast>();
}

void inlineQueryPeerTypeBroadcast::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeBroadcast::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeBroadcast::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypeBroadcast");
    s.store_class_end();
  }
}

const std::int32_t inlineQueryPeerTypeBotPM::ID;

object_ptr<InlineQueryPeerType> inlineQueryPeerTypeBotPM::fetch(TlBufferParser &p) {
  return make_tl_object<inlineQueryPeerTypeBotPM>();
}

void inlineQueryPeerTypeBotPM::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeBotPM::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inlineQueryPeerTypeBotPM::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryPeerTypeBotPM");
    s.store_class_end();
  }
}

inputAppEvent::inputAppEvent(double time_, string const &type_, int64 peer_, object_ptr<JSONValue> &&data_)
  : time_(time_)
  , type_(type_)
  , peer_(peer_)
  , data_(std::move(data_))
{}

const std::int32_t inputAppEvent::ID;

object_ptr<inputAppEvent> inputAppEvent::fetch(TlBufferParser &p) {
  return make_tl_object<inputAppEvent>(p);
}

inputAppEvent::inputAppEvent(TlBufferParser &p)
  : time_(TlFetchDouble::parse(p))
  , type_(TlFetchString<string>::parse(p))
  , peer_(TlFetchLong::parse(p))
  , data_(TlFetchObject<JSONValue>::parse(p))
{}

void inputAppEvent::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(time_, s);
  TlStoreString::store(type_, s);
  TlStoreBinary::store(peer_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(data_, s);
}

void inputAppEvent::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(time_, s);
  TlStoreString::store(type_, s);
  TlStoreBinary::store(peer_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(data_, s);
}

void inputAppEvent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputAppEvent");
    s.store_field("time", time_);
    s.store_field("type", type_);
    s.store_field("peer", peer_);
    s.store_object_field("data", static_cast<const BaseObject *>(data_.get()));
    s.store_class_end();
  }
}

inputBotAppID::inputBotAppID(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputBotAppID::ID;

void inputBotAppID::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotAppID::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotAppID::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotAppID");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputBotAppShortName::inputBotAppShortName(object_ptr<InputUser> &&bot_id_, string const &short_name_)
  : bot_id_(std::move(bot_id_))
  , short_name_(short_name_)
{}

const std::int32_t inputBotAppShortName::ID;

void inputBotAppShortName::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_id_, s);
  TlStoreString::store(short_name_, s);
}

void inputBotAppShortName::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_id_, s);
  TlStoreString::store(short_name_, s);
}

void inputBotAppShortName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotAppShortName");
    s.store_object_field("bot_id", static_cast<const BaseObject *>(bot_id_.get()));
    s.store_field("short_name", short_name_);
    s.store_class_end();
  }
}

inputBotInlineMessageMediaAuto::inputBotInlineMessageMediaAuto(int32 flags_, bool invert_media_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , invert_media_(invert_media_)
  , message_(message_)
  , entities_(std::move(entities_))
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaAuto::ID;

void inputBotInlineMessageMediaAuto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (invert_media_ << 3)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaAuto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (invert_media_ << 3)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaAuto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaAuto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (invert_media_ << 3)));
    if (var0 & 8) { s.store_field("invert_media", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageText::inputBotInlineMessageText(int32 flags_, bool no_webpage_, bool invert_media_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , no_webpage_(no_webpage_)
  , invert_media_(invert_media_)
  , message_(message_)
  , entities_(std::move(entities_))
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageText::ID;

void inputBotInlineMessageText::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (no_webpage_ << 0) | (invert_media_ << 3)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageText::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (no_webpage_ << 0) | (invert_media_ << 3)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageText");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (no_webpage_ << 0) | (invert_media_ << 3)));
    if (var0 & 1) { s.store_field("no_webpage", true); }
    if (var0 & 8) { s.store_field("invert_media", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageMediaGeo::inputBotInlineMessageMediaGeo(int32 flags_, object_ptr<InputGeoPoint> &&geo_point_, int32 heading_, int32 period_, int32 proximity_notification_radius_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , geo_point_(std::move(geo_point_))
  , heading_(heading_)
  , period_(period_)
  , proximity_notification_radius_(proximity_notification_radius_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaGeo::ID;

void inputBotInlineMessageMediaGeo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  if (var0 & 1) { TlStoreBinary::store(heading_, s); }
  if (var0 & 2) { TlStoreBinary::store(period_, s); }
  if (var0 & 8) { TlStoreBinary::store(proximity_notification_radius_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaGeo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  if (var0 & 1) { TlStoreBinary::store(heading_, s); }
  if (var0 & 2) { TlStoreBinary::store(period_, s); }
  if (var0 & 8) { TlStoreBinary::store(proximity_notification_radius_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaGeo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaGeo");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    if (var0 & 1) { s.store_field("heading", heading_); }
    if (var0 & 2) { s.store_field("period", period_); }
    if (var0 & 8) { s.store_field("proximity_notification_radius", proximity_notification_radius_); }
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageMediaVenue::inputBotInlineMessageMediaVenue(int32 flags_, object_ptr<InputGeoPoint> &&geo_point_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , geo_point_(std::move(geo_point_))
  , title_(title_)
  , address_(address_)
  , provider_(provider_)
  , venue_id_(venue_id_)
  , venue_type_(venue_type_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaVenue::ID;

void inputBotInlineMessageMediaVenue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaVenue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaVenue");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    s.store_field("title", title_);
    s.store_field("address", address_);
    s.store_field("provider", provider_);
    s.store_field("venue_id", venue_id_);
    s.store_field("venue_type", venue_type_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageMediaContact::inputBotInlineMessageMediaContact(int32 flags_, string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , phone_number_(phone_number_)
  , first_name_(first_name_)
  , last_name_(last_name_)
  , vcard_(vcard_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaContact::ID;

void inputBotInlineMessageMediaContact::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
  TlStoreString::store(vcard_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaContact::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
  TlStoreString::store(vcard_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaContact");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("phone_number", phone_number_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("vcard", vcard_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageGame::inputBotInlineMessageGame(int32 flags_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageGame::ID;

void inputBotInlineMessageGame::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageGame::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageGame");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageMediaInvoice::inputBotInlineMessageMediaInvoice(int32 flags_, string const &title_, string const &description_, object_ptr<inputWebDocument> &&photo_, object_ptr<invoice> &&invoice_, bytes &&payload_, string const &provider_, object_ptr<dataJSON> &&provider_data_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , title_(title_)
  , description_(description_)
  , photo_(std::move(photo_))
  , invoice_(std::move(invoice_))
  , payload_(std::move(payload_))
  , provider_(provider_)
  , provider_data_(std::move(provider_data_))
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaInvoice::ID;

void inputBotInlineMessageMediaInvoice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1678949555>::store(photo_, s); }
  TlStoreBoxed<TlStoreObject, 77522308>::store(invoice_, s);
  TlStoreString::store(payload_, s);
  TlStoreString::store(provider_, s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(provider_data_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaInvoice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1678949555>::store(photo_, s); }
  TlStoreBoxed<TlStoreObject, 77522308>::store(invoice_, s);
  TlStoreString::store(payload_, s);
  TlStoreString::store(provider_, s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(provider_data_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaInvoice");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    s.store_object_field("invoice", static_cast<const BaseObject *>(invoice_.get()));
    s.store_bytes_field("payload", payload_);
    s.store_field("provider", provider_);
    s.store_object_field("provider_data", static_cast<const BaseObject *>(provider_data_.get()));
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

inputBotInlineMessageMediaWebPage::inputBotInlineMessageMediaWebPage(int32 flags_, bool invert_media_, bool force_large_media_, bool force_small_media_, bool optional_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, string const &url_, object_ptr<ReplyMarkup> &&reply_markup_)
  : flags_(flags_)
  , invert_media_(invert_media_)
  , force_large_media_(force_large_media_)
  , force_small_media_(force_small_media_)
  , optional_(optional_)
  , message_(message_)
  , entities_(std::move(entities_))
  , url_(url_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputBotInlineMessageMediaWebPage::ID;

void inputBotInlineMessageMediaWebPage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (invert_media_ << 3) | (force_large_media_ << 4) | (force_small_media_ << 5) | (optional_ << 6)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  TlStoreString::store(url_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaWebPage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (invert_media_ << 3) | (force_large_media_ << 4) | (force_small_media_ << 5) | (optional_ << 6)), s);
  TlStoreString::store(message_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  TlStoreString::store(url_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_markup_, s); }
}

void inputBotInlineMessageMediaWebPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageMediaWebPage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (invert_media_ << 3) | (force_large_media_ << 4) | (force_small_media_ << 5) | (optional_ << 6)));
    if (var0 & 8) { s.store_field("invert_media", true); }
    if (var0 & 16) { s.store_field("force_large_media", true); }
    if (var0 & 32) { s.store_field("force_small_media", true); }
    if (var0 & 64) { s.store_field("optional", true); }
    s.store_field("message", message_);
    if (var0 & 2) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_field("url", url_);
    if (var0 & 4) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    s.store_class_end();
  }
}

object_ptr<InputBotInlineMessageID> InputBotInlineMessageID::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputBotInlineMessageID::ID:
      return inputBotInlineMessageID::fetch(p);
    case inputBotInlineMessageID64::ID:
      return inputBotInlineMessageID64::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

inputBotInlineMessageID::inputBotInlineMessageID(int32 dc_id_, int64 id_, int64 access_hash_)
  : dc_id_(dc_id_)
  , id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputBotInlineMessageID::ID;

object_ptr<InputBotInlineMessageID> inputBotInlineMessageID::fetch(TlBufferParser &p) {
  return make_tl_object<inputBotInlineMessageID>(p);
}

inputBotInlineMessageID::inputBotInlineMessageID(TlBufferParser &p)
  : dc_id_(TlFetchInt::parse(p))
  , id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputBotInlineMessageID::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(dc_id_, s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotInlineMessageID::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(dc_id_, s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotInlineMessageID::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageID");
    s.store_field("dc_id", dc_id_);
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputBotInlineMessageID64::inputBotInlineMessageID64(int32 dc_id_, int64 owner_id_, int32 id_, int64 access_hash_)
  : dc_id_(dc_id_)
  , owner_id_(owner_id_)
  , id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputBotInlineMessageID64::ID;

object_ptr<InputBotInlineMessageID> inputBotInlineMessageID64::fetch(TlBufferParser &p) {
  return make_tl_object<inputBotInlineMessageID64>(p);
}

inputBotInlineMessageID64::inputBotInlineMessageID64(TlBufferParser &p)
  : dc_id_(TlFetchInt::parse(p))
  , owner_id_(TlFetchLong::parse(p))
  , id_(TlFetchInt::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputBotInlineMessageID64::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(dc_id_, s);
  TlStoreBinary::store(owner_id_, s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotInlineMessageID64::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(dc_id_, s);
  TlStoreBinary::store(owner_id_, s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputBotInlineMessageID64::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineMessageID64");
    s.store_field("dc_id", dc_id_);
    s.store_field("owner_id", owner_id_);
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputBotInlineResult::inputBotInlineResult(int32 flags_, string const &id_, string const &type_, string const &title_, string const &description_, string const &url_, object_ptr<inputWebDocument> &&thumb_, object_ptr<inputWebDocument> &&content_, object_ptr<InputBotInlineMessage> &&send_message_)
  : flags_(flags_)
  , id_(id_)
  , type_(type_)
  , title_(title_)
  , description_(description_)
  , url_(url_)
  , thumb_(std::move(thumb_))
  , content_(std::move(content_))
  , send_message_(std::move(send_message_))
{}

const std::int32_t inputBotInlineResult::ID;

void inputBotInlineResult::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 4) { TlStoreString::store(description_, s); }
  if (var0 & 8) { TlStoreString::store(url_, s); }
  if (var0 & 16) { TlStoreBoxed<TlStoreObject, -1678949555>::store(thumb_, s); }
  if (var0 & 32) { TlStoreBoxed<TlStoreObject, -1678949555>::store(content_, s); }
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResult::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 4) { TlStoreString::store(description_, s); }
  if (var0 & 8) { TlStoreString::store(url_, s); }
  if (var0 & 16) { TlStoreBoxed<TlStoreObject, -1678949555>::store(thumb_, s); }
  if (var0 & 32) { TlStoreBoxed<TlStoreObject, -1678949555>::store(content_, s); }
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResult::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineResult");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("type", type_);
    if (var0 & 2) { s.store_field("title", title_); }
    if (var0 & 4) { s.store_field("description", description_); }
    if (var0 & 8) { s.store_field("url", url_); }
    if (var0 & 16) { s.store_object_field("thumb", static_cast<const BaseObject *>(thumb_.get())); }
    if (var0 & 32) { s.store_object_field("content", static_cast<const BaseObject *>(content_.get())); }
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

inputBotInlineResultPhoto::inputBotInlineResultPhoto(string const &id_, string const &type_, object_ptr<InputPhoto> &&photo_, object_ptr<InputBotInlineMessage> &&send_message_)
  : id_(id_)
  , type_(type_)
  , photo_(std::move(photo_))
  , send_message_(std::move(send_message_))
{}

const std::int32_t inputBotInlineResultPhoto::ID;

void inputBotInlineResultPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(photo_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(photo_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineResultPhoto");
    s.store_field("id", id_);
    s.store_field("type", type_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

inputBotInlineResultDocument::inputBotInlineResultDocument(int32 flags_, string const &id_, string const &type_, string const &title_, string const &description_, object_ptr<InputDocument> &&document_, object_ptr<InputBotInlineMessage> &&send_message_)
  : flags_(flags_)
  , id_(id_)
  , type_(type_)
  , title_(title_)
  , description_(description_)
  , document_(std::move(document_))
  , send_message_(std::move(send_message_))
{}

const std::int32_t inputBotInlineResultDocument::ID;

void inputBotInlineResultDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 4) { TlStoreString::store(description_, s); }
  TlStoreBoxedUnknown<TlStoreObject>::store(document_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(id_, s);
  TlStoreString::store(type_, s);
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 4) { TlStoreString::store(description_, s); }
  TlStoreBoxedUnknown<TlStoreObject>::store(document_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineResultDocument");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    s.store_field("type", type_);
    if (var0 & 2) { s.store_field("title", title_); }
    if (var0 & 4) { s.store_field("description", description_); }
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

inputBotInlineResultGame::inputBotInlineResultGame(string const &id_, string const &short_name_, object_ptr<InputBotInlineMessage> &&send_message_)
  : id_(id_)
  , short_name_(short_name_)
  , send_message_(std::move(send_message_))
{}

const std::int32_t inputBotInlineResultGame::ID;

void inputBotInlineResultGame::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(short_name_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultGame::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(short_name_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(send_message_, s);
}

void inputBotInlineResultGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBotInlineResultGame");
    s.store_field("id", id_);
    s.store_field("short_name", short_name_);
    s.store_object_field("send_message", static_cast<const BaseObject *>(send_message_.get()));
    s.store_class_end();
  }
}

inputBusinessAwayMessage::inputBusinessAwayMessage(int32 flags_, bool offline_only_, int32 shortcut_id_, object_ptr<BusinessAwayMessageSchedule> &&schedule_, object_ptr<inputBusinessRecipients> &&recipients_)
  : flags_(flags_)
  , offline_only_(offline_only_)
  , shortcut_id_(shortcut_id_)
  , schedule_(std::move(schedule_))
  , recipients_(std::move(recipients_))
{}

const std::int32_t inputBusinessAwayMessage::ID;

void inputBusinessAwayMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (offline_only_ << 0)), s);
  TlStoreBinary::store(shortcut_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(schedule_, s);
  TlStoreBoxed<TlStoreObject, 1871393450>::store(recipients_, s);
}

void inputBusinessAwayMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (offline_only_ << 0)), s);
  TlStoreBinary::store(shortcut_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(schedule_, s);
  TlStoreBoxed<TlStoreObject, 1871393450>::store(recipients_, s);
}

void inputBusinessAwayMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessAwayMessage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (offline_only_ << 0)));
    if (var0 & 1) { s.store_field("offline_only", true); }
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("schedule", static_cast<const BaseObject *>(schedule_.get()));
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_class_end();
  }
}

inputBusinessBotRecipients::inputBusinessBotRecipients(int32 flags_, bool existing_chats_, bool new_chats_, bool contacts_, bool non_contacts_, bool exclude_selected_, array<object_ptr<InputUser>> &&users_, array<object_ptr<InputUser>> &&exclude_users_)
  : flags_(flags_)
  , existing_chats_(existing_chats_)
  , new_chats_(new_chats_)
  , contacts_(contacts_)
  , non_contacts_(non_contacts_)
  , exclude_selected_(exclude_selected_)
  , users_(std::move(users_))
  , exclude_users_(std::move(exclude_users_))
{}

const std::int32_t inputBusinessBotRecipients::ID;

void inputBusinessBotRecipients::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)), s);
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(exclude_users_, s); }
}

void inputBusinessBotRecipients::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)), s);
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(exclude_users_, s); }
}

void inputBusinessBotRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessBotRecipients");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)));
    if (var0 & 1) { s.store_field("existing_chats", true); }
    if (var0 & 2) { s.store_field("new_chats", true); }
    if (var0 & 4) { s.store_field("contacts", true); }
    if (var0 & 8) { s.store_field("non_contacts", true); }
    if (var0 & 32) { s.store_field("exclude_selected", true); }
    if (var0 & 16) { { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 64) { { s.store_vector_begin("exclude_users", exclude_users_.size()); for (const auto &_value : exclude_users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

inputBusinessChatLink::inputBusinessChatLink(int32 flags_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, string const &title_)
  : flags_(flags_)
  , message_(message_)
  , entities_(std::move(entities_))
  , title_(title_)
{}

const std::int32_t inputBusinessChatLink::ID;

void inputBusinessChatLink::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(message_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 2) { TlStoreString::store(title_, s); }
}

void inputBusinessChatLink::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(message_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
  if (var0 & 2) { TlStoreString::store(title_, s); }
}

void inputBusinessChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessChatLink");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("message", message_);
    if (var0 & 1) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 2) { s.store_field("title", title_); }
    s.store_class_end();
  }
}

inputBusinessGreetingMessage::inputBusinessGreetingMessage(int32 shortcut_id_, object_ptr<inputBusinessRecipients> &&recipients_, int32 no_activity_days_)
  : shortcut_id_(shortcut_id_)
  , recipients_(std::move(recipients_))
  , no_activity_days_(no_activity_days_)
{}

const std::int32_t inputBusinessGreetingMessage::ID;

void inputBusinessGreetingMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(shortcut_id_, s);
  TlStoreBoxed<TlStoreObject, 1871393450>::store(recipients_, s);
  TlStoreBinary::store(no_activity_days_, s);
}

void inputBusinessGreetingMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(shortcut_id_, s);
  TlStoreBoxed<TlStoreObject, 1871393450>::store(recipients_, s);
  TlStoreBinary::store(no_activity_days_, s);
}

void inputBusinessGreetingMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessGreetingMessage");
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_field("no_activity_days", no_activity_days_);
    s.store_class_end();
  }
}

inputBusinessIntro::inputBusinessIntro(int32 flags_, string const &title_, string const &description_, object_ptr<InputDocument> &&sticker_)
  : flags_(flags_)
  , title_(title_)
  , description_(description_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t inputBusinessIntro::ID;

void inputBusinessIntro::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(sticker_, s); }
}

void inputBusinessIntro::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(sticker_, s); }
}

void inputBusinessIntro::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessIntro");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get())); }
    s.store_class_end();
  }
}

inputBusinessRecipients::inputBusinessRecipients(int32 flags_, bool existing_chats_, bool new_chats_, bool contacts_, bool non_contacts_, bool exclude_selected_, array<object_ptr<InputUser>> &&users_)
  : flags_(flags_)
  , existing_chats_(existing_chats_)
  , new_chats_(new_chats_)
  , contacts_(contacts_)
  , non_contacts_(non_contacts_)
  , exclude_selected_(exclude_selected_)
  , users_(std::move(users_))
{}

const std::int32_t inputBusinessRecipients::ID;

void inputBusinessRecipients::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)), s);
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s); }
}

void inputBusinessRecipients::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)), s);
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s); }
}

void inputBusinessRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessRecipients");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (existing_chats_ << 0) | (new_chats_ << 1) | (contacts_ << 2) | (non_contacts_ << 3) | (exclude_selected_ << 5)));
    if (var0 & 1) { s.store_field("existing_chats", true); }
    if (var0 & 2) { s.store_field("new_chats", true); }
    if (var0 & 4) { s.store_field("contacts", true); }
    if (var0 & 8) { s.store_field("non_contacts", true); }
    if (var0 & 32) { s.store_field("exclude_selected", true); }
    if (var0 & 16) { { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

object_ptr<InputChannel> InputChannel::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputChannelEmpty::ID:
      return inputChannelEmpty::fetch(p);
    case inputChannel::ID:
      return inputChannel::fetch(p);
    case inputChannelFromMessage::ID:
      return inputChannelFromMessage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputChannelEmpty::ID;

object_ptr<InputChannel> inputChannelEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputChannelEmpty>();
}

void inputChannelEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputChannelEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputChannelEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChannelEmpty");
    s.store_class_end();
  }
}

inputChannel::inputChannel(int64 channel_id_, int64 access_hash_)
  : channel_id_(channel_id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputChannel::ID;

object_ptr<InputChannel> inputChannel::fetch(TlBufferParser &p) {
  return make_tl_object<inputChannel>(p);
}

inputChannel::inputChannel(TlBufferParser &p)
  : channel_id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputChannel::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputChannel::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChannel");
    s.store_field("channel_id", channel_id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputChannelFromMessage::inputChannelFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 channel_id_)
  : peer_(std::move(peer_))
  , msg_id_(msg_id_)
  , channel_id_(channel_id_)
{}

const std::int32_t inputChannelFromMessage::ID;

object_ptr<InputChannel> inputChannelFromMessage::fetch(TlBufferParser &p) {
  return make_tl_object<inputChannelFromMessage>(p);
}

inputChannelFromMessage::inputChannelFromMessage(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , msg_id_(TlFetchInt::parse(p))
  , channel_id_(TlFetchLong::parse(p))
{}

void inputChannelFromMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(channel_id_, s);
}

void inputChannelFromMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(channel_id_, s);
}

void inputChannelFromMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChannelFromMessage");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_field("channel_id", channel_id_);
    s.store_class_end();
  }
}

const std::int32_t inputChatPhotoEmpty::ID;

void inputChatPhotoEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputChatPhotoEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputChatPhotoEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhotoEmpty");
    s.store_class_end();
  }
}

inputChatUploadedPhoto::inputChatUploadedPhoto(int32 flags_, object_ptr<InputFile> &&file_, object_ptr<InputFile> &&video_, double video_start_ts_, object_ptr<VideoSize> &&video_emoji_markup_)
  : flags_(flags_)
  , file_(std::move(file_))
  , video_(std::move(video_))
  , video_start_ts_(video_start_ts_)
  , video_emoji_markup_(std::move(video_emoji_markup_))
{}

const std::int32_t inputChatUploadedPhoto::ID;

void inputChatUploadedPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(file_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(video_, s); }
  if (var0 & 4) { TlStoreBinary::store(video_start_ts_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(video_emoji_markup_, s); }
}

void inputChatUploadedPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(file_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(video_, s); }
  if (var0 & 4) { TlStoreBinary::store(video_start_ts_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(video_emoji_markup_, s); }
}

void inputChatUploadedPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatUploadedPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_object_field("file", static_cast<const BaseObject *>(file_.get())); }
    if (var0 & 2) { s.store_object_field("video", static_cast<const BaseObject *>(video_.get())); }
    if (var0 & 4) { s.store_field("video_start_ts", video_start_ts_); }
    if (var0 & 8) { s.store_object_field("video_emoji_markup", static_cast<const BaseObject *>(video_emoji_markup_.get())); }
    s.store_class_end();
  }
}

inputChatPhoto::inputChatPhoto(object_ptr<InputPhoto> &&id_)
  : id_(std::move(id_))
{}

const std::int32_t inputChatPhoto::ID;

void inputChatPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputChatPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputChatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhoto");
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    s.store_class_end();
  }
}

inputChatlistDialogFilter::inputChatlistDialogFilter(int32 filter_id_)
  : filter_id_(filter_id_)
{}

const std::int32_t inputChatlistDialogFilter::ID;

void inputChatlistDialogFilter::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(filter_id_, s);
}

void inputChatlistDialogFilter::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(filter_id_, s);
}

void inputChatlistDialogFilter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatlistDialogFilter");
    s.store_field("filter_id", filter_id_);
    s.store_class_end();
  }
}

const std::int32_t inputCheckPasswordEmpty::ID;

void inputCheckPasswordEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputCheckPasswordEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputCheckPasswordEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCheckPasswordEmpty");
    s.store_class_end();
  }
}

inputCheckPasswordSRP::inputCheckPasswordSRP(int64 srp_id_, bytes &&A_, bytes &&M1_)
  : srp_id_(srp_id_)
  , A_(std::move(A_))
  , M1_(std::move(M1_))
{}

const std::int32_t inputCheckPasswordSRP::ID;

void inputCheckPasswordSRP::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(srp_id_, s);
  TlStoreString::store(A_, s);
  TlStoreString::store(M1_, s);
}

void inputCheckPasswordSRP::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(srp_id_, s);
  TlStoreString::store(A_, s);
  TlStoreString::store(M1_, s);
}

void inputCheckPasswordSRP::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCheckPasswordSRP");
    s.store_field("srp_id", srp_id_);
    s.store_bytes_field("A", A_);
    s.store_bytes_field("M1", M1_);
    s.store_class_end();
  }
}

const std::int32_t inputClientProxy::ID;

void inputClientProxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputClientProxy");
    s.store_field("address", address_);
    s.store_field("port", port_);
    s.store_class_end();
  }
}

inputCollectibleUsername::inputCollectibleUsername(string const &username_)
  : username_(username_)
{}

const std::int32_t inputCollectibleUsername::ID;

void inputCollectibleUsername::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(username_, s);
}

void inputCollectibleUsername::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(username_, s);
}

void inputCollectibleUsername::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCollectibleUsername");
    s.store_field("username", username_);
    s.store_class_end();
  }
}

inputCollectiblePhone::inputCollectiblePhone(string const &phone_)
  : phone_(phone_)
{}

const std::int32_t inputCollectiblePhone::ID;

void inputCollectiblePhone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_, s);
}

void inputCollectiblePhone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_, s);
}

void inputCollectiblePhone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCollectiblePhone");
    s.store_field("phone", phone_);
    s.store_class_end();
  }
}

inputPhoneContact::inputPhoneContact(int64 client_id_, string const &phone_, string const &first_name_, string const &last_name_)
  : client_id_(client_id_)
  , phone_(phone_)
  , first_name_(first_name_)
  , last_name_(last_name_)
{}

const std::int32_t inputPhoneContact::ID;

void inputPhoneContact::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(client_id_, s);
  TlStoreString::store(phone_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
}

void inputPhoneContact::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(client_id_, s);
  TlStoreString::store(phone_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
}

void inputPhoneContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhoneContact");
    s.store_field("client_id", client_id_);
    s.store_field("phone", phone_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_class_end();
  }
}

inputDialogPeer::inputDialogPeer(object_ptr<InputPeer> &&peer_)
  : peer_(std::move(peer_))
{}

const std::int32_t inputDialogPeer::ID;

void inputDialogPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void inputDialogPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void inputDialogPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputDialogPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

inputDialogPeerFolder::inputDialogPeerFolder(int32 folder_id_)
  : folder_id_(folder_id_)
{}

const std::int32_t inputDialogPeerFolder::ID;

void inputDialogPeerFolder::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(folder_id_, s);
}

void inputDialogPeerFolder::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(folder_id_, s);
}

void inputDialogPeerFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputDialogPeerFolder");
    s.store_field("folder_id", folder_id_);
    s.store_class_end();
  }
}

object_ptr<InputDocument> InputDocument::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputDocumentEmpty::ID:
      return inputDocumentEmpty::fetch(p);
    case inputDocument::ID:
      return inputDocument::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputDocumentEmpty::ID;

object_ptr<InputDocument> inputDocumentEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputDocumentEmpty>();
}

void inputDocumentEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputDocumentEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputDocumentEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputDocumentEmpty");
    s.store_class_end();
  }
}

inputDocument::inputDocument(int64 id_, int64 access_hash_, bytes &&file_reference_)
  : id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
{}

const std::int32_t inputDocument::ID;

object_ptr<InputDocument> inputDocument::fetch(TlBufferParser &p) {
  return make_tl_object<inputDocument>(p);
}

inputDocument::inputDocument(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , file_reference_(TlFetchBytes<bytes>::parse(p))
{}

void inputDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
}

void inputDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
}

void inputDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputDocument");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_class_end();
  }
}

inputEncryptedChat::inputEncryptedChat(int32 chat_id_, int64 access_hash_)
  : chat_id_(chat_id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputEncryptedChat::ID;

void inputEncryptedChat::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(chat_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedChat::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(chat_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedChat");
    s.store_field("chat_id", chat_id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

const std::int32_t inputEncryptedFileEmpty::ID;

void inputEncryptedFileEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputEncryptedFileEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputEncryptedFileEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedFileEmpty");
    s.store_class_end();
  }
}

inputEncryptedFileUploaded::inputEncryptedFileUploaded(int64 id_, int32 parts_, string const &md5_checksum_, int32 key_fingerprint_)
  : id_(id_)
  , parts_(parts_)
  , md5_checksum_(md5_checksum_)
  , key_fingerprint_(key_fingerprint_)
{}

const std::int32_t inputEncryptedFileUploaded::ID;

void inputEncryptedFileUploaded::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(md5_checksum_, s);
  TlStoreBinary::store(key_fingerprint_, s);
}

void inputEncryptedFileUploaded::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(md5_checksum_, s);
  TlStoreBinary::store(key_fingerprint_, s);
}

void inputEncryptedFileUploaded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedFileUploaded");
    s.store_field("id", id_);
    s.store_field("parts", parts_);
    s.store_field("md5_checksum", md5_checksum_);
    s.store_field("key_fingerprint", key_fingerprint_);
    s.store_class_end();
  }
}

inputEncryptedFile::inputEncryptedFile(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputEncryptedFile::ID;

void inputEncryptedFile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedFile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedFile");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputEncryptedFileBigUploaded::inputEncryptedFileBigUploaded(int64 id_, int32 parts_, int32 key_fingerprint_)
  : id_(id_)
  , parts_(parts_)
  , key_fingerprint_(key_fingerprint_)
{}

const std::int32_t inputEncryptedFileBigUploaded::ID;

void inputEncryptedFileBigUploaded::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreBinary::store(key_fingerprint_, s);
}

void inputEncryptedFileBigUploaded::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreBinary::store(key_fingerprint_, s);
}

void inputEncryptedFileBigUploaded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedFileBigUploaded");
    s.store_field("id", id_);
    s.store_field("parts", parts_);
    s.store_field("key_fingerprint", key_fingerprint_);
    s.store_class_end();
  }
}

object_ptr<InputFile> InputFile::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputFile::ID:
      return inputFile::fetch(p);
    case inputFileBig::ID:
      return inputFileBig::fetch(p);
    case inputFileStoryDocument::ID:
      return inputFileStoryDocument::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

inputFile::inputFile(int64 id_, int32 parts_, string const &name_, string const &md5_checksum_)
  : id_(id_)
  , parts_(parts_)
  , name_(name_)
  , md5_checksum_(md5_checksum_)
{}

const std::int32_t inputFile::ID;

object_ptr<InputFile> inputFile::fetch(TlBufferParser &p) {
  return make_tl_object<inputFile>(p);
}

inputFile::inputFile(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , parts_(TlFetchInt::parse(p))
  , name_(TlFetchString<string>::parse(p))
  , md5_checksum_(TlFetchString<string>::parse(p))
{}

void inputFile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(name_, s);
  TlStoreString::store(md5_checksum_, s);
}

void inputFile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(name_, s);
  TlStoreString::store(md5_checksum_, s);
}

void inputFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFile");
    s.store_field("id", id_);
    s.store_field("parts", parts_);
    s.store_field("name", name_);
    s.store_field("md5_checksum", md5_checksum_);
    s.store_class_end();
  }
}

inputFileBig::inputFileBig(int64 id_, int32 parts_, string const &name_)
  : id_(id_)
  , parts_(parts_)
  , name_(name_)
{}

const std::int32_t inputFileBig::ID;

object_ptr<InputFile> inputFileBig::fetch(TlBufferParser &p) {
  return make_tl_object<inputFileBig>(p);
}

inputFileBig::inputFileBig(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , parts_(TlFetchInt::parse(p))
  , name_(TlFetchString<string>::parse(p))
{}

void inputFileBig::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(name_, s);
}

void inputFileBig::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(name_, s);
}

void inputFileBig::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileBig");
    s.store_field("id", id_);
    s.store_field("parts", parts_);
    s.store_field("name", name_);
    s.store_class_end();
  }
}

inputFileStoryDocument::inputFileStoryDocument(object_ptr<InputDocument> &&id_)
  : id_(std::move(id_))
{}

const std::int32_t inputFileStoryDocument::ID;

object_ptr<InputFile> inputFileStoryDocument::fetch(TlBufferParser &p) {
  return make_tl_object<inputFileStoryDocument>(p);
}

inputFileStoryDocument::inputFileStoryDocument(TlBufferParser &p)
  : id_(TlFetchObject<InputDocument>::parse(p))
{}

void inputFileStoryDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputFileStoryDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputFileStoryDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileStoryDocument");
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    s.store_class_end();
  }
}

inputPeerPhotoFileLocationLegacy::inputPeerPhotoFileLocationLegacy(int32 flags_, bool big_, object_ptr<InputPeer> &&peer_, int64 volume_id_, int32 local_id_)
  : flags_(flags_)
  , big_(big_)
  , peer_(std::move(peer_))
  , volume_id_(volume_id_)
  , local_id_(local_id_)
{}

const std::int32_t inputPeerPhotoFileLocationLegacy::ID;

void inputPeerPhotoFileLocationLegacy::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (big_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
}

void inputPeerPhotoFileLocationLegacy::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (big_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
}

void inputPeerPhotoFileLocationLegacy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerPhotoFileLocationLegacy");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (big_ << 0)));
    if (var0 & 1) { s.store_field("big", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("volume_id", volume_id_);
    s.store_field("local_id", local_id_);
    s.store_class_end();
  }
}

inputStickerSetThumbLegacy::inputStickerSetThumbLegacy(object_ptr<InputStickerSet> &&stickerset_, int64 volume_id_, int32 local_id_)
  : stickerset_(std::move(stickerset_))
  , volume_id_(volume_id_)
  , local_id_(local_id_)
{}

const std::int32_t inputStickerSetThumbLegacy::ID;

void inputStickerSetThumbLegacy::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
}

void inputStickerSetThumbLegacy::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
}

void inputStickerSetThumbLegacy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetThumbLegacy");
    s.store_object_field("stickerset", static_cast<const BaseObject *>(stickerset_.get()));
    s.store_field("volume_id", volume_id_);
    s.store_field("local_id", local_id_);
    s.store_class_end();
  }
}

inputFileLocation::inputFileLocation(int64 volume_id_, int32 local_id_, int64 secret_, bytes &&file_reference_)
  : volume_id_(volume_id_)
  , local_id_(local_id_)
  , secret_(secret_)
  , file_reference_(std::move(file_reference_))
{}

const std::int32_t inputFileLocation::ID;

void inputFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
  TlStoreBinary::store(secret_, s);
  TlStoreString::store(file_reference_, s);
}

void inputFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
  TlStoreBinary::store(secret_, s);
  TlStoreString::store(file_reference_, s);
}

void inputFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileLocation");
    s.store_field("volume_id", volume_id_);
    s.store_field("local_id", local_id_);
    s.store_field("secret", secret_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_class_end();
  }
}

inputEncryptedFileLocation::inputEncryptedFileLocation(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputEncryptedFileLocation::ID;

void inputEncryptedFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputEncryptedFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputEncryptedFileLocation");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputDocumentFileLocation::inputDocumentFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, string const &thumb_size_)
  : id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
  , thumb_size_(thumb_size_)
{}

const std::int32_t inputDocumentFileLocation::ID;

void inputDocumentFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreString::store(thumb_size_, s);
}

void inputDocumentFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreString::store(thumb_size_, s);
}

void inputDocumentFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputDocumentFileLocation");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_field("thumb_size", thumb_size_);
    s.store_class_end();
  }
}

inputSecureFileLocation::inputSecureFileLocation(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputSecureFileLocation::ID;

void inputSecureFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputSecureFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputSecureFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSecureFileLocation");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

const std::int32_t inputTakeoutFileLocation::ID;

void inputTakeoutFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputTakeoutFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputTakeoutFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputTakeoutFileLocation");
    s.store_class_end();
  }
}

inputPhotoFileLocation::inputPhotoFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, string const &thumb_size_)
  : id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
  , thumb_size_(thumb_size_)
{}

const std::int32_t inputPhotoFileLocation::ID;

void inputPhotoFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreString::store(thumb_size_, s);
}

void inputPhotoFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreString::store(thumb_size_, s);
}

void inputPhotoFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhotoFileLocation");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_field("thumb_size", thumb_size_);
    s.store_class_end();
  }
}

inputPhotoLegacyFileLocation::inputPhotoLegacyFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, int64 volume_id_, int32 local_id_, int64 secret_)
  : id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
  , volume_id_(volume_id_)
  , local_id_(local_id_)
  , secret_(secret_)
{}

const std::int32_t inputPhotoLegacyFileLocation::ID;

void inputPhotoLegacyFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
  TlStoreBinary::store(secret_, s);
}

void inputPhotoLegacyFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
  TlStoreBinary::store(volume_id_, s);
  TlStoreBinary::store(local_id_, s);
  TlStoreBinary::store(secret_, s);
}

void inputPhotoLegacyFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhotoLegacyFileLocation");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_field("volume_id", volume_id_);
    s.store_field("local_id", local_id_);
    s.store_field("secret", secret_);
    s.store_class_end();
  }
}

inputPeerPhotoFileLocation::inputPeerPhotoFileLocation(int32 flags_, bool big_, object_ptr<InputPeer> &&peer_, int64 photo_id_)
  : flags_(flags_)
  , big_(big_)
  , peer_(std::move(peer_))
  , photo_id_(photo_id_)
{}

const std::int32_t inputPeerPhotoFileLocation::ID;

void inputPeerPhotoFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (big_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(photo_id_, s);
}

void inputPeerPhotoFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (big_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(photo_id_, s);
}

void inputPeerPhotoFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerPhotoFileLocation");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (big_ << 0)));
    if (var0 & 1) { s.store_field("big", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("photo_id", photo_id_);
    s.store_class_end();
  }
}

inputStickerSetThumb::inputStickerSetThumb(object_ptr<InputStickerSet> &&stickerset_, int32 thumb_version_)
  : stickerset_(std::move(stickerset_))
  , thumb_version_(thumb_version_)
{}

const std::int32_t inputStickerSetThumb::ID;

void inputStickerSetThumb::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  TlStoreBinary::store(thumb_version_, s);
}

void inputStickerSetThumb::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stickerset_, s);
  TlStoreBinary::store(thumb_version_, s);
}

void inputStickerSetThumb::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetThumb");
    s.store_object_field("stickerset", static_cast<const BaseObject *>(stickerset_.get()));
    s.store_field("thumb_version", thumb_version_);
    s.store_class_end();
  }
}

inputGroupCallStream::inputGroupCallStream(int32 flags_, object_ptr<InputGroupCall> &&call_, int64 time_ms_, int32 scale_, int32 video_channel_, int32 video_quality_)
  : flags_(flags_)
  , call_(std::move(call_))
  , time_ms_(time_ms_)
  , scale_(scale_)
  , video_channel_(video_channel_)
  , video_quality_(video_quality_)
{}

const std::int32_t inputGroupCallStream::ID;

void inputGroupCallStream::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(call_, s);
  TlStoreBinary::store(time_ms_, s);
  TlStoreBinary::store(scale_, s);
  if (var0 & 1) { TlStoreBinary::store(video_channel_, s); }
  if (var0 & 1) { TlStoreBinary::store(video_quality_, s); }
}

void inputGroupCallStream::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(call_, s);
  TlStoreBinary::store(time_ms_, s);
  TlStoreBinary::store(scale_, s);
  if (var0 & 1) { TlStoreBinary::store(video_channel_, s); }
  if (var0 & 1) { TlStoreBinary::store(video_quality_, s); }
}

void inputGroupCallStream::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGroupCallStream");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    s.store_field("time_ms", time_ms_);
    s.store_field("scale", scale_);
    if (var0 & 1) { s.store_field("video_channel", video_channel_); }
    if (var0 & 1) { s.store_field("video_quality", video_quality_); }
    s.store_class_end();
  }
}

inputFolderPeer::inputFolderPeer(object_ptr<InputPeer> &&peer_, int32 folder_id_)
  : peer_(std::move(peer_))
  , folder_id_(folder_id_)
{}

const std::int32_t inputFolderPeer::ID;

void inputFolderPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(folder_id_, s);
}

void inputFolderPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(folder_id_, s);
}

void inputFolderPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFolderPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("folder_id", folder_id_);
    s.store_class_end();
  }
}

object_ptr<InputGame> InputGame::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputGameID::ID:
      return inputGameID::fetch(p);
    case inputGameShortName::ID:
      return inputGameShortName::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

inputGameID::inputGameID(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputGameID::ID;

object_ptr<InputGame> inputGameID::fetch(TlBufferParser &p) {
  return make_tl_object<inputGameID>(p);
}

inputGameID::inputGameID(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputGameID::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputGameID::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputGameID::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGameID");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputGameShortName::inputGameShortName(object_ptr<InputUser> &&bot_id_, string const &short_name_)
  : bot_id_(std::move(bot_id_))
  , short_name_(short_name_)
{}

const std::int32_t inputGameShortName::ID;

object_ptr<InputGame> inputGameShortName::fetch(TlBufferParser &p) {
  return make_tl_object<inputGameShortName>(p);
}

inputGameShortName::inputGameShortName(TlBufferParser &p)
  : bot_id_(TlFetchObject<InputUser>::parse(p))
  , short_name_(TlFetchString<string>::parse(p))
{}

void inputGameShortName::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_id_, s);
  TlStoreString::store(short_name_, s);
}

void inputGameShortName::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_id_, s);
  TlStoreString::store(short_name_, s);
}

void inputGameShortName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGameShortName");
    s.store_object_field("bot_id", static_cast<const BaseObject *>(bot_id_.get()));
    s.store_field("short_name", short_name_);
    s.store_class_end();
  }
}

object_ptr<InputGeoPoint> InputGeoPoint::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputGeoPointEmpty::ID:
      return inputGeoPointEmpty::fetch(p);
    case inputGeoPoint::ID:
      return inputGeoPoint::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputGeoPointEmpty::ID;

object_ptr<InputGeoPoint> inputGeoPointEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputGeoPointEmpty>();
}

void inputGeoPointEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputGeoPointEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputGeoPointEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGeoPointEmpty");
    s.store_class_end();
  }
}

inputGeoPoint::inputGeoPoint()
  : flags_()
  , lat_()
  , long_()
  , accuracy_radius_()
{}

inputGeoPoint::inputGeoPoint(int32 flags_, double lat_, double long_, int32 accuracy_radius_)
  : flags_(flags_)
  , lat_(lat_)
  , long_(long_)
  , accuracy_radius_(accuracy_radius_)
{}

const std::int32_t inputGeoPoint::ID;

object_ptr<InputGeoPoint> inputGeoPoint::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputGeoPoint> res = make_tl_object<inputGeoPoint>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->lat_ = TlFetchDouble::parse(p);
  res->long_ = TlFetchDouble::parse(p);
  if (var0 & 1) { res->accuracy_radius_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputGeoPoint::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(lat_, s);
  TlStoreBinary::store(long_, s);
  if (var0 & 1) { TlStoreBinary::store(accuracy_radius_, s); }
}

void inputGeoPoint::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(lat_, s);
  TlStoreBinary::store(long_, s);
  if (var0 & 1) { TlStoreBinary::store(accuracy_radius_, s); }
}

void inputGeoPoint::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGeoPoint");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("lat", lat_);
    s.store_field("long", long_);
    if (var0 & 1) { s.store_field("accuracy_radius", accuracy_radius_); }
    s.store_class_end();
  }
}

object_ptr<InputGroupCall> InputGroupCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputGroupCall::ID:
      return inputGroupCall::fetch(p);
    case inputGroupCallSlug::ID:
      return inputGroupCallSlug::fetch(p);
    case inputGroupCallInviteMessage::ID:
      return inputGroupCallInviteMessage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

inputGroupCall::inputGroupCall(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputGroupCall::ID;

object_ptr<InputGroupCall> inputGroupCall::fetch(TlBufferParser &p) {
  return make_tl_object<inputGroupCall>(p);
}

inputGroupCall::inputGroupCall(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputGroupCall::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputGroupCall::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGroupCall");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputGroupCallSlug::inputGroupCallSlug(string const &slug_)
  : slug_(slug_)
{}

const std::int32_t inputGroupCallSlug::ID;

object_ptr<InputGroupCall> inputGroupCallSlug::fetch(TlBufferParser &p) {
  return make_tl_object<inputGroupCallSlug>(p);
}

inputGroupCallSlug::inputGroupCallSlug(TlBufferParser &p)
  : slug_(TlFetchString<string>::parse(p))
{}

void inputGroupCallSlug::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputGroupCallSlug::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputGroupCallSlug::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGroupCallSlug");
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

inputGroupCallInviteMessage::inputGroupCallInviteMessage(int32 msg_id_)
  : msg_id_(msg_id_)
{}

const std::int32_t inputGroupCallInviteMessage::ID;

object_ptr<InputGroupCall> inputGroupCallInviteMessage::fetch(TlBufferParser &p) {
  return make_tl_object<inputGroupCallInviteMessage>(p);
}

inputGroupCallInviteMessage::inputGroupCallInviteMessage(TlBufferParser &p)
  : msg_id_(TlFetchInt::parse(p))
{}

void inputGroupCallInviteMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(msg_id_, s);
}

void inputGroupCallInviteMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(msg_id_, s);
}

void inputGroupCallInviteMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputGroupCallInviteMessage");
    s.store_field("msg_id", msg_id_);
    s.store_class_end();
  }
}

inputInvoiceMessage::inputInvoiceMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_)
  : peer_(std::move(peer_))
  , msg_id_(msg_id_)
{}

const std::int32_t inputInvoiceMessage::ID;

void inputInvoiceMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
}

void inputInvoiceMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
}

void inputInvoiceMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceMessage");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_class_end();
  }
}

inputInvoiceSlug::inputInvoiceSlug(string const &slug_)
  : slug_(slug_)
{}

const std::int32_t inputInvoiceSlug::ID;

void inputInvoiceSlug::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputInvoiceSlug::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputInvoiceSlug::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceSlug");
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

inputInvoicePremiumGiftCode::inputInvoicePremiumGiftCode(object_ptr<InputStorePaymentPurpose> &&purpose_, object_ptr<premiumGiftCodeOption> &&option_)
  : purpose_(std::move(purpose_))
  , option_(std::move(option_))
{}

const std::int32_t inputInvoicePremiumGiftCode::ID;

void inputInvoicePremiumGiftCode::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(purpose_, s);
  TlStoreBoxed<TlStoreObject, 629052971>::store(option_, s);
}

void inputInvoicePremiumGiftCode::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(purpose_, s);
  TlStoreBoxed<TlStoreObject, 629052971>::store(option_, s);
}

void inputInvoicePremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoicePremiumGiftCode");
    s.store_object_field("purpose", static_cast<const BaseObject *>(purpose_.get()));
    s.store_object_field("option", static_cast<const BaseObject *>(option_.get()));
    s.store_class_end();
  }
}

inputInvoiceStars::inputInvoiceStars(object_ptr<InputStorePaymentPurpose> &&purpose_)
  : purpose_(std::move(purpose_))
{}

const std::int32_t inputInvoiceStars::ID;

void inputInvoiceStars::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(purpose_, s);
}

void inputInvoiceStars::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(purpose_, s);
}

void inputInvoiceStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceStars");
    s.store_object_field("purpose", static_cast<const BaseObject *>(purpose_.get()));
    s.store_class_end();
  }
}

inputInvoiceChatInviteSubscription::inputInvoiceChatInviteSubscription(string const &hash_)
  : hash_(hash_)
{}

const std::int32_t inputInvoiceChatInviteSubscription::ID;

void inputInvoiceChatInviteSubscription::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(hash_, s);
}

void inputInvoiceChatInviteSubscription::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(hash_, s);
}

void inputInvoiceChatInviteSubscription::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceChatInviteSubscription");
    s.store_field("hash", hash_);
    s.store_class_end();
  }
}

inputInvoiceStarGift::inputInvoiceStarGift(int32 flags_, bool hide_name_, bool include_upgrade_, object_ptr<InputPeer> &&peer_, int64 gift_id_, object_ptr<textWithEntities> &&message_)
  : flags_(flags_)
  , hide_name_(hide_name_)
  , include_upgrade_(include_upgrade_)
  , peer_(std::move(peer_))
  , gift_id_(gift_id_)
  , message_(std::move(message_))
{}

const std::int32_t inputInvoiceStarGift::ID;

void inputInvoiceStarGift::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (hide_name_ << 0) | (include_upgrade_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(gift_id_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputInvoiceStarGift::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (hide_name_ << 0) | (include_upgrade_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(gift_id_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputInvoiceStarGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceStarGift");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (hide_name_ << 0) | (include_upgrade_ << 2)));
    if (var0 & 1) { s.store_field("hide_name", true); }
    if (var0 & 4) { s.store_field("include_upgrade", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("gift_id", gift_id_);
    if (var0 & 2) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    s.store_class_end();
  }
}

inputInvoiceStarGiftUpgrade::inputInvoiceStarGiftUpgrade(int32 flags_, bool keep_original_details_, object_ptr<InputSavedStarGift> &&stargift_)
  : flags_(flags_)
  , keep_original_details_(keep_original_details_)
  , stargift_(std::move(stargift_))
{}

const std::int32_t inputInvoiceStarGiftUpgrade::ID;

void inputInvoiceStarGiftUpgrade::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (keep_original_details_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stargift_, s);
}

void inputInvoiceStarGiftUpgrade::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (keep_original_details_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stargift_, s);
}

void inputInvoiceStarGiftUpgrade::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceStarGiftUpgrade");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (keep_original_details_ << 0)));
    if (var0 & 1) { s.store_field("keep_original_details", true); }
    s.store_object_field("stargift", static_cast<const BaseObject *>(stargift_.get()));
    s.store_class_end();
  }
}

inputInvoiceStarGiftTransfer::inputInvoiceStarGiftTransfer(object_ptr<InputSavedStarGift> &&stargift_, object_ptr<InputPeer> &&to_id_)
  : stargift_(std::move(stargift_))
  , to_id_(std::move(to_id_))
{}

const std::int32_t inputInvoiceStarGiftTransfer::ID;

void inputInvoiceStarGiftTransfer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stargift_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(to_id_, s);
}

void inputInvoiceStarGiftTransfer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(stargift_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(to_id_, s);
}

void inputInvoiceStarGiftTransfer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceStarGiftTransfer");
    s.store_object_field("stargift", static_cast<const BaseObject *>(stargift_.get()));
    s.store_object_field("to_id", static_cast<const BaseObject *>(to_id_.get()));
    s.store_class_end();
  }
}

inputInvoicePremiumGiftStars::inputInvoicePremiumGiftStars(int32 flags_, object_ptr<InputUser> &&user_id_, int32 months_, object_ptr<textWithEntities> &&message_)
  : flags_(flags_)
  , user_id_(std::move(user_id_))
  , months_(months_)
  , message_(std::move(message_))
{}

const std::int32_t inputInvoicePremiumGiftStars::ID;

void inputInvoicePremiumGiftStars::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreBinary::store(months_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputInvoicePremiumGiftStars::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreBinary::store(months_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputInvoicePremiumGiftStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoicePremiumGiftStars");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_field("months", months_);
    if (var0 & 1) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    s.store_class_end();
  }
}

inputInvoiceBusinessBotTransferStars::inputInvoiceBusinessBotTransferStars(object_ptr<InputUser> &&bot_, int64 stars_)
  : bot_(std::move(bot_))
  , stars_(stars_)
{}

const std::int32_t inputInvoiceBusinessBotTransferStars::ID;

void inputInvoiceBusinessBotTransferStars::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_, s);
  TlStoreBinary::store(stars_, s);
}

void inputInvoiceBusinessBotTransferStars::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_, s);
  TlStoreBinary::store(stars_, s);
}

void inputInvoiceBusinessBotTransferStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceBusinessBotTransferStars");
    s.store_object_field("bot", static_cast<const BaseObject *>(bot_.get()));
    s.store_field("stars", stars_);
    s.store_class_end();
  }
}

inputInvoiceStarGiftResale::inputInvoiceStarGiftResale(string const &slug_, object_ptr<InputPeer> &&to_id_)
  : slug_(slug_)
  , to_id_(std::move(to_id_))
{}

const std::int32_t inputInvoiceStarGiftResale::ID;

void inputInvoiceStarGiftResale::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(to_id_, s);
}

void inputInvoiceStarGiftResale::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(to_id_, s);
}

void inputInvoiceStarGiftResale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceStarGiftResale");
    s.store_field("slug", slug_);
    s.store_object_field("to_id", static_cast<const BaseObject *>(to_id_.get()));
    s.store_class_end();
  }
}

object_ptr<InputMedia> InputMedia::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputMediaEmpty::ID:
      return inputMediaEmpty::fetch(p);
    case inputMediaUploadedPhoto::ID:
      return inputMediaUploadedPhoto::fetch(p);
    case inputMediaPhoto::ID:
      return inputMediaPhoto::fetch(p);
    case inputMediaGeoPoint::ID:
      return inputMediaGeoPoint::fetch(p);
    case inputMediaContact::ID:
      return inputMediaContact::fetch(p);
    case inputMediaUploadedDocument::ID:
      return inputMediaUploadedDocument::fetch(p);
    case inputMediaDocument::ID:
      return inputMediaDocument::fetch(p);
    case inputMediaVenue::ID:
      return inputMediaVenue::fetch(p);
    case inputMediaPhotoExternal::ID:
      return inputMediaPhotoExternal::fetch(p);
    case inputMediaDocumentExternal::ID:
      return inputMediaDocumentExternal::fetch(p);
    case inputMediaGame::ID:
      return inputMediaGame::fetch(p);
    case inputMediaInvoice::ID:
      return inputMediaInvoice::fetch(p);
    case inputMediaGeoLive::ID:
      return inputMediaGeoLive::fetch(p);
    case inputMediaPoll::ID:
      return inputMediaPoll::fetch(p);
    case inputMediaDice::ID:
      return inputMediaDice::fetch(p);
    case inputMediaStory::ID:
      return inputMediaStory::fetch(p);
    case inputMediaWebPage::ID:
      return inputMediaWebPage::fetch(p);
    case inputMediaPaidMedia::ID:
      return inputMediaPaidMedia::fetch(p);
    case inputMediaTodo::ID:
      return inputMediaTodo::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputMediaEmpty::ID;

object_ptr<InputMedia> inputMediaEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaEmpty>();
}

void inputMediaEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMediaEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMediaEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaEmpty");
    s.store_class_end();
  }
}

inputMediaUploadedPhoto::inputMediaUploadedPhoto()
  : flags_()
  , spoiler_()
  , file_()
  , stickers_()
  , ttl_seconds_()
{}

inputMediaUploadedPhoto::inputMediaUploadedPhoto(int32 flags_, bool spoiler_, object_ptr<InputFile> &&file_, array<object_ptr<InputDocument>> &&stickers_, int32 ttl_seconds_)
  : flags_(flags_)
  , spoiler_(spoiler_)
  , file_(std::move(file_))
  , stickers_(std::move(stickers_))
  , ttl_seconds_(ttl_seconds_)
{}

const std::int32_t inputMediaUploadedPhoto::ID;

object_ptr<InputMedia> inputMediaUploadedPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaUploadedPhoto> res = make_tl_object<inputMediaUploadedPhoto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 4) != 0;
  res->file_ = TlFetchObject<InputFile>::parse(p);
  if (var0 & 1) { res->stickers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputDocument>>, 481674261>::parse(p); }
  if (var0 & 2) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaUploadedPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(file_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(stickers_, s); }
  if (var0 & 2) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaUploadedPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(file_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(stickers_, s); }
  if (var0 & 2) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaUploadedPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaUploadedPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 2)));
    if (var0 & 4) { s.store_field("spoiler", true); }
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    if (var0 & 1) { { s.store_vector_begin("stickers", stickers_.size()); for (const auto &_value : stickers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 2) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

inputMediaPhoto::inputMediaPhoto()
  : flags_()
  , spoiler_()
  , id_()
  , ttl_seconds_()
{}

inputMediaPhoto::inputMediaPhoto(int32 flags_, bool spoiler_, object_ptr<InputPhoto> &&id_, int32 ttl_seconds_)
  : flags_(flags_)
  , spoiler_(spoiler_)
  , id_(std::move(id_))
  , ttl_seconds_(ttl_seconds_)
{}

const std::int32_t inputMediaPhoto::ID;

object_ptr<InputMedia> inputMediaPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaPhoto> res = make_tl_object<inputMediaPhoto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 2) != 0;
  res->id_ = TlFetchObject<InputPhoto>::parse(p);
  if (var0 & 1) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 1)));
    if (var0 & 2) { s.store_field("spoiler", true); }
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    if (var0 & 1) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

inputMediaGeoPoint::inputMediaGeoPoint(object_ptr<InputGeoPoint> &&geo_point_)
  : geo_point_(std::move(geo_point_))
{}

const std::int32_t inputMediaGeoPoint::ID;

object_ptr<InputMedia> inputMediaGeoPoint::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaGeoPoint>(p);
}

inputMediaGeoPoint::inputMediaGeoPoint(TlBufferParser &p)
  : geo_point_(TlFetchObject<InputGeoPoint>::parse(p))
{}

void inputMediaGeoPoint::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
}

void inputMediaGeoPoint::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
}

void inputMediaGeoPoint::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaGeoPoint");
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    s.store_class_end();
  }
}

inputMediaContact::inputMediaContact(string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_)
  : phone_number_(phone_number_)
  , first_name_(first_name_)
  , last_name_(last_name_)
  , vcard_(vcard_)
{}

const std::int32_t inputMediaContact::ID;

object_ptr<InputMedia> inputMediaContact::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaContact>(p);
}

inputMediaContact::inputMediaContact(TlBufferParser &p)
  : phone_number_(TlFetchString<string>::parse(p))
  , first_name_(TlFetchString<string>::parse(p))
  , last_name_(TlFetchString<string>::parse(p))
  , vcard_(TlFetchString<string>::parse(p))
{}

void inputMediaContact::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
  TlStoreString::store(vcard_, s);
}

void inputMediaContact::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(first_name_, s);
  TlStoreString::store(last_name_, s);
  TlStoreString::store(vcard_, s);
}

void inputMediaContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaContact");
    s.store_field("phone_number", phone_number_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("vcard", vcard_);
    s.store_class_end();
  }
}

inputMediaUploadedDocument::inputMediaUploadedDocument()
  : flags_()
  , nosound_video_()
  , force_file_()
  , spoiler_()
  , file_()
  , thumb_()
  , mime_type_()
  , attributes_()
  , stickers_()
  , video_cover_()
  , video_timestamp_()
  , ttl_seconds_()
{}

inputMediaUploadedDocument::inputMediaUploadedDocument(int32 flags_, bool nosound_video_, bool force_file_, bool spoiler_, object_ptr<InputFile> &&file_, object_ptr<InputFile> &&thumb_, string const &mime_type_, array<object_ptr<DocumentAttribute>> &&attributes_, array<object_ptr<InputDocument>> &&stickers_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_, int32 ttl_seconds_)
  : flags_(flags_)
  , nosound_video_(nosound_video_)
  , force_file_(force_file_)
  , spoiler_(spoiler_)
  , file_(std::move(file_))
  , thumb_(std::move(thumb_))
  , mime_type_(mime_type_)
  , attributes_(std::move(attributes_))
  , stickers_(std::move(stickers_))
  , video_cover_(std::move(video_cover_))
  , video_timestamp_(video_timestamp_)
  , ttl_seconds_(ttl_seconds_)
{}

const std::int32_t inputMediaUploadedDocument::ID;

object_ptr<InputMedia> inputMediaUploadedDocument::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaUploadedDocument> res = make_tl_object<inputMediaUploadedDocument>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->nosound_video_ = (var0 & 8) != 0;
  res->force_file_ = (var0 & 16) != 0;
  res->spoiler_ = (var0 & 32) != 0;
  res->file_ = TlFetchObject<InputFile>::parse(p);
  if (var0 & 4) { res->thumb_ = TlFetchObject<InputFile>::parse(p); }
  res->mime_type_ = TlFetchString<string>::parse(p);
  res->attributes_ = TlFetchBoxed<TlFetchVector<TlFetchObject<DocumentAttribute>>, 481674261>::parse(p);
  if (var0 & 1) { res->stickers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputDocument>>, 481674261>::parse(p); }
  if (var0 & 64) { res->video_cover_ = TlFetchObject<InputPhoto>::parse(p); }
  if (var0 & 128) { res->video_timestamp_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaUploadedDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (nosound_video_ << 3) | (force_file_ << 4) | (spoiler_ << 5)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(file_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(thumb_, s); }
  TlStoreString::store(mime_type_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(attributes_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(stickers_, s); }
  if (var0 & 64) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 128) { TlStoreBinary::store(video_timestamp_, s); }
  if (var0 & 2) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaUploadedDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (nosound_video_ << 3) | (force_file_ << 4) | (spoiler_ << 5)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(file_, s);
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(thumb_, s); }
  TlStoreString::store(mime_type_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(attributes_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(stickers_, s); }
  if (var0 & 64) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 128) { TlStoreBinary::store(video_timestamp_, s); }
  if (var0 & 2) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaUploadedDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaUploadedDocument");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (nosound_video_ << 3) | (force_file_ << 4) | (spoiler_ << 5)));
    if (var0 & 8) { s.store_field("nosound_video", true); }
    if (var0 & 16) { s.store_field("force_file", true); }
    if (var0 & 32) { s.store_field("spoiler", true); }
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    if (var0 & 4) { s.store_object_field("thumb", static_cast<const BaseObject *>(thumb_.get())); }
    s.store_field("mime_type", mime_type_);
    { s.store_vector_begin("attributes", attributes_.size()); for (const auto &_value : attributes_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 1) { { s.store_vector_begin("stickers", stickers_.size()); for (const auto &_value : stickers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 64) { s.store_object_field("video_cover", static_cast<const BaseObject *>(video_cover_.get())); }
    if (var0 & 128) { s.store_field("video_timestamp", video_timestamp_); }
    if (var0 & 2) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

inputMediaDocument::inputMediaDocument()
  : flags_()
  , spoiler_()
  , id_()
  , video_cover_()
  , video_timestamp_()
  , ttl_seconds_()
  , query_()
{}

inputMediaDocument::inputMediaDocument(int32 flags_, bool spoiler_, object_ptr<InputDocument> &&id_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_, int32 ttl_seconds_, string const &query_)
  : flags_(flags_)
  , spoiler_(spoiler_)
  , id_(std::move(id_))
  , video_cover_(std::move(video_cover_))
  , video_timestamp_(video_timestamp_)
  , ttl_seconds_(ttl_seconds_)
  , query_(query_)
{}

const std::int32_t inputMediaDocument::ID;

object_ptr<InputMedia> inputMediaDocument::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaDocument> res = make_tl_object<inputMediaDocument>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 4) != 0;
  res->id_ = TlFetchObject<InputDocument>::parse(p);
  if (var0 & 8) { res->video_cover_ = TlFetchObject<InputPhoto>::parse(p); }
  if (var0 & 16) { res->video_timestamp_ = TlFetchInt::parse(p); }
  if (var0 & 1) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->query_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 16) { TlStoreBinary::store(video_timestamp_, s); }
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
  if (var0 & 2) { TlStoreString::store(query_, s); }
}

void inputMediaDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 16) { TlStoreBinary::store(video_timestamp_, s); }
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
  if (var0 & 2) { TlStoreString::store(query_, s); }
}

void inputMediaDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaDocument");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 2)));
    if (var0 & 4) { s.store_field("spoiler", true); }
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    if (var0 & 8) { s.store_object_field("video_cover", static_cast<const BaseObject *>(video_cover_.get())); }
    if (var0 & 16) { s.store_field("video_timestamp", video_timestamp_); }
    if (var0 & 1) { s.store_field("ttl_seconds", ttl_seconds_); }
    if (var0 & 2) { s.store_field("query", query_); }
    s.store_class_end();
  }
}

inputMediaVenue::inputMediaVenue(object_ptr<InputGeoPoint> &&geo_point_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_)
  : geo_point_(std::move(geo_point_))
  , title_(title_)
  , address_(address_)
  , provider_(provider_)
  , venue_id_(venue_id_)
  , venue_type_(venue_type_)
{}

const std::int32_t inputMediaVenue::ID;

object_ptr<InputMedia> inputMediaVenue::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaVenue>(p);
}

inputMediaVenue::inputMediaVenue(TlBufferParser &p)
  : geo_point_(TlFetchObject<InputGeoPoint>::parse(p))
  , title_(TlFetchString<string>::parse(p))
  , address_(TlFetchString<string>::parse(p))
  , provider_(TlFetchString<string>::parse(p))
  , venue_id_(TlFetchString<string>::parse(p))
  , venue_type_(TlFetchString<string>::parse(p))
{}

void inputMediaVenue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
}

void inputMediaVenue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
}

void inputMediaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaVenue");
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    s.store_field("title", title_);
    s.store_field("address", address_);
    s.store_field("provider", provider_);
    s.store_field("venue_id", venue_id_);
    s.store_field("venue_type", venue_type_);
    s.store_class_end();
  }
}

inputMediaPhotoExternal::inputMediaPhotoExternal()
  : flags_()
  , spoiler_()
  , url_()
  , ttl_seconds_()
{}

inputMediaPhotoExternal::inputMediaPhotoExternal(int32 flags_, bool spoiler_, string const &url_, int32 ttl_seconds_)
  : flags_(flags_)
  , spoiler_(spoiler_)
  , url_(url_)
  , ttl_seconds_(ttl_seconds_)
{}

const std::int32_t inputMediaPhotoExternal::ID;

object_ptr<InputMedia> inputMediaPhotoExternal::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaPhotoExternal> res = make_tl_object<inputMediaPhotoExternal>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 2) != 0;
  res->url_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaPhotoExternal::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreString::store(url_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaPhotoExternal::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreString::store(url_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
}

void inputMediaPhotoExternal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaPhotoExternal");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 1)));
    if (var0 & 2) { s.store_field("spoiler", true); }
    s.store_field("url", url_);
    if (var0 & 1) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

inputMediaDocumentExternal::inputMediaDocumentExternal()
  : flags_()
  , spoiler_()
  , url_()
  , ttl_seconds_()
  , video_cover_()
  , video_timestamp_()
{}

inputMediaDocumentExternal::inputMediaDocumentExternal(int32 flags_, bool spoiler_, string const &url_, int32 ttl_seconds_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_)
  : flags_(flags_)
  , spoiler_(spoiler_)
  , url_(url_)
  , ttl_seconds_(ttl_seconds_)
  , video_cover_(std::move(video_cover_))
  , video_timestamp_(video_timestamp_)
{}

const std::int32_t inputMediaDocumentExternal::ID;

object_ptr<InputMedia> inputMediaDocumentExternal::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaDocumentExternal> res = make_tl_object<inputMediaDocumentExternal>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 2) != 0;
  res->url_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->video_cover_ = TlFetchObject<InputPhoto>::parse(p); }
  if (var0 & 8) { res->video_timestamp_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaDocumentExternal::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreString::store(url_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 8) { TlStoreBinary::store(video_timestamp_, s); }
}

void inputMediaDocumentExternal::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (spoiler_ << 1)), s);
  TlStoreString::store(url_, s);
  if (var0 & 1) { TlStoreBinary::store(ttl_seconds_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(video_cover_, s); }
  if (var0 & 8) { TlStoreBinary::store(video_timestamp_, s); }
}

void inputMediaDocumentExternal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaDocumentExternal");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 1)));
    if (var0 & 2) { s.store_field("spoiler", true); }
    s.store_field("url", url_);
    if (var0 & 1) { s.store_field("ttl_seconds", ttl_seconds_); }
    if (var0 & 4) { s.store_object_field("video_cover", static_cast<const BaseObject *>(video_cover_.get())); }
    if (var0 & 8) { s.store_field("video_timestamp", video_timestamp_); }
    s.store_class_end();
  }
}

inputMediaGame::inputMediaGame(object_ptr<InputGame> &&id_)
  : id_(std::move(id_))
{}

const std::int32_t inputMediaGame::ID;

object_ptr<InputMedia> inputMediaGame::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaGame>(p);
}

inputMediaGame::inputMediaGame(TlBufferParser &p)
  : id_(TlFetchObject<InputGame>::parse(p))
{}

void inputMediaGame::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputMediaGame::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputMediaGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaGame");
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    s.store_class_end();
  }
}

inputMediaInvoice::inputMediaInvoice()
  : flags_()
  , title_()
  , description_()
  , photo_()
  , invoice_()
  , payload_()
  , provider_()
  , provider_data_()
  , start_param_()
  , extended_media_()
{}

inputMediaInvoice::inputMediaInvoice(int32 flags_, string const &title_, string const &description_, object_ptr<inputWebDocument> &&photo_, object_ptr<invoice> &&invoice_, bytes &&payload_, string const &provider_, object_ptr<dataJSON> &&provider_data_, string const &start_param_, object_ptr<InputMedia> &&extended_media_)
  : flags_(flags_)
  , title_(title_)
  , description_(description_)
  , photo_(std::move(photo_))
  , invoice_(std::move(invoice_))
  , payload_(std::move(payload_))
  , provider_(provider_)
  , provider_data_(std::move(provider_data_))
  , start_param_(start_param_)
  , extended_media_(std::move(extended_media_))
{}

const std::int32_t inputMediaInvoice::ID;

object_ptr<InputMedia> inputMediaInvoice::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaInvoice> res = make_tl_object<inputMediaInvoice>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->photo_ = TlFetchBoxed<TlFetchObject<inputWebDocument>, -1678949555>::parse(p); }
  res->invoice_ = TlFetchBoxed<TlFetchObject<invoice>, 77522308>::parse(p);
  res->payload_ = TlFetchBytes<bytes>::parse(p);
  if (var0 & 8) { res->provider_ = TlFetchString<string>::parse(p); }
  res->provider_data_ = TlFetchBoxed<TlFetchObject<dataJSON>, 2104790276>::parse(p);
  if (var0 & 2) { res->start_param_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->extended_media_ = TlFetchObject<InputMedia>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaInvoice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1678949555>::store(photo_, s); }
  TlStoreBoxed<TlStoreObject, 77522308>::store(invoice_, s);
  TlStoreString::store(payload_, s);
  if (var0 & 8) { TlStoreString::store(provider_, s); }
  TlStoreBoxed<TlStoreObject, 2104790276>::store(provider_data_, s);
  if (var0 & 2) { TlStoreString::store(start_param_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(extended_media_, s); }
}

void inputMediaInvoice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(title_, s);
  TlStoreString::store(description_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1678949555>::store(photo_, s); }
  TlStoreBoxed<TlStoreObject, 77522308>::store(invoice_, s);
  TlStoreString::store(payload_, s);
  if (var0 & 8) { TlStoreString::store(provider_, s); }
  TlStoreBoxed<TlStoreObject, 2104790276>::store(provider_data_, s);
  if (var0 & 2) { TlStoreString::store(start_param_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(extended_media_, s); }
}

void inputMediaInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaInvoice");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    s.store_object_field("invoice", static_cast<const BaseObject *>(invoice_.get()));
    s.store_bytes_field("payload", payload_);
    if (var0 & 8) { s.store_field("provider", provider_); }
    s.store_object_field("provider_data", static_cast<const BaseObject *>(provider_data_.get()));
    if (var0 & 2) { s.store_field("start_param", start_param_); }
    if (var0 & 4) { s.store_object_field("extended_media", static_cast<const BaseObject *>(extended_media_.get())); }
    s.store_class_end();
  }
}

inputMediaGeoLive::inputMediaGeoLive()
  : flags_()
  , stopped_()
  , geo_point_()
  , heading_()
  , period_()
  , proximity_notification_radius_()
{}

inputMediaGeoLive::inputMediaGeoLive(int32 flags_, bool stopped_, object_ptr<InputGeoPoint> &&geo_point_, int32 heading_, int32 period_, int32 proximity_notification_radius_)
  : flags_(flags_)
  , stopped_(stopped_)
  , geo_point_(std::move(geo_point_))
  , heading_(heading_)
  , period_(period_)
  , proximity_notification_radius_(proximity_notification_radius_)
{}

const std::int32_t inputMediaGeoLive::ID;

object_ptr<InputMedia> inputMediaGeoLive::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaGeoLive> res = make_tl_object<inputMediaGeoLive>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->stopped_ = (var0 & 1) != 0;
  res->geo_point_ = TlFetchObject<InputGeoPoint>::parse(p);
  if (var0 & 4) { res->heading_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->period_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->proximity_notification_radius_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaGeoLive::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (stopped_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  if (var0 & 4) { TlStoreBinary::store(heading_, s); }
  if (var0 & 2) { TlStoreBinary::store(period_, s); }
  if (var0 & 8) { TlStoreBinary::store(proximity_notification_radius_, s); }
}

void inputMediaGeoLive::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (stopped_ << 0)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  if (var0 & 4) { TlStoreBinary::store(heading_, s); }
  if (var0 & 2) { TlStoreBinary::store(period_, s); }
  if (var0 & 8) { TlStoreBinary::store(proximity_notification_radius_, s); }
}

void inputMediaGeoLive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaGeoLive");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (stopped_ << 0)));
    if (var0 & 1) { s.store_field("stopped", true); }
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    if (var0 & 4) { s.store_field("heading", heading_); }
    if (var0 & 2) { s.store_field("period", period_); }
    if (var0 & 8) { s.store_field("proximity_notification_radius", proximity_notification_radius_); }
    s.store_class_end();
  }
}

inputMediaPoll::inputMediaPoll()
  : flags_()
  , poll_()
  , correct_answers_()
  , solution_()
  , solution_entities_()
{}

inputMediaPoll::inputMediaPoll(int32 flags_, object_ptr<poll> &&poll_, array<bytes> &&correct_answers_, string const &solution_, array<object_ptr<MessageEntity>> &&solution_entities_)
  : flags_(flags_)
  , poll_(std::move(poll_))
  , correct_answers_(std::move(correct_answers_))
  , solution_(solution_)
  , solution_entities_(std::move(solution_entities_))
{}

const std::int32_t inputMediaPoll::ID;

object_ptr<InputMedia> inputMediaPoll::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaPoll> res = make_tl_object<inputMediaPoll>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->poll_ = TlFetchBoxed<TlFetchObject<poll>, 1484026161>::parse(p);
  if (var0 & 1) { res->correct_answers_ = TlFetchBoxed<TlFetchVector<TlFetchBytes<bytes>>, 481674261>::parse(p); }
  if (var0 & 2) { res->solution_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->solution_entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaPoll::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreObject, 1484026161>::store(poll_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(correct_answers_, s); }
  if (var0 & 2) { TlStoreString::store(solution_, s); }
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(solution_entities_, s); }
}

void inputMediaPoll::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreObject, 1484026161>::store(poll_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(correct_answers_, s); }
  if (var0 & 2) { TlStoreString::store(solution_, s); }
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(solution_entities_, s); }
}

void inputMediaPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaPoll");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("poll", static_cast<const BaseObject *>(poll_.get()));
    if (var0 & 1) { { s.store_vector_begin("correct_answers", correct_answers_.size()); for (const auto &_value : correct_answers_) { s.store_bytes_field("", _value); } s.store_class_end(); } }
    if (var0 & 2) { s.store_field("solution", solution_); }
    if (var0 & 2) { { s.store_vector_begin("solution_entities", solution_entities_.size()); for (const auto &_value : solution_entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

inputMediaDice::inputMediaDice(string const &emoticon_)
  : emoticon_(emoticon_)
{}

const std::int32_t inputMediaDice::ID;

object_ptr<InputMedia> inputMediaDice::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaDice>(p);
}

inputMediaDice::inputMediaDice(TlBufferParser &p)
  : emoticon_(TlFetchString<string>::parse(p))
{}

void inputMediaDice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(emoticon_, s);
}

void inputMediaDice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(emoticon_, s);
}

void inputMediaDice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaDice");
    s.store_field("emoticon", emoticon_);
    s.store_class_end();
  }
}

inputMediaStory::inputMediaStory(object_ptr<InputPeer> &&peer_, int32 id_)
  : peer_(std::move(peer_))
  , id_(id_)
{}

const std::int32_t inputMediaStory::ID;

object_ptr<InputMedia> inputMediaStory::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaStory>(p);
}

inputMediaStory::inputMediaStory(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , id_(TlFetchInt::parse(p))
{}

void inputMediaStory::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(id_, s);
}

void inputMediaStory::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(id_, s);
}

void inputMediaStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaStory");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("id", id_);
    s.store_class_end();
  }
}

inputMediaWebPage::inputMediaWebPage()
  : flags_()
  , force_large_media_()
  , force_small_media_()
  , optional_()
  , url_()
{}

inputMediaWebPage::inputMediaWebPage(int32 flags_, bool force_large_media_, bool force_small_media_, bool optional_, string const &url_)
  : flags_(flags_)
  , force_large_media_(force_large_media_)
  , force_small_media_(force_small_media_)
  , optional_(optional_)
  , url_(url_)
{}

const std::int32_t inputMediaWebPage::ID;

object_ptr<InputMedia> inputMediaWebPage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaWebPage> res = make_tl_object<inputMediaWebPage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->force_large_media_ = (var0 & 1) != 0;
  res->force_small_media_ = (var0 & 2) != 0;
  res->optional_ = (var0 & 4) != 0;
  res->url_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaWebPage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (force_large_media_ << 0) | (force_small_media_ << 1) | (optional_ << 2)), s);
  TlStoreString::store(url_, s);
}

void inputMediaWebPage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (force_large_media_ << 0) | (force_small_media_ << 1) | (optional_ << 2)), s);
  TlStoreString::store(url_, s);
}

void inputMediaWebPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaWebPage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (force_large_media_ << 0) | (force_small_media_ << 1) | (optional_ << 2)));
    if (var0 & 1) { s.store_field("force_large_media", true); }
    if (var0 & 2) { s.store_field("force_small_media", true); }
    if (var0 & 4) { s.store_field("optional", true); }
    s.store_field("url", url_);
    s.store_class_end();
  }
}

inputMediaPaidMedia::inputMediaPaidMedia()
  : flags_()
  , stars_amount_()
  , extended_media_()
  , payload_()
{}

inputMediaPaidMedia::inputMediaPaidMedia(int32 flags_, int64 stars_amount_, array<object_ptr<InputMedia>> &&extended_media_, string const &payload_)
  : flags_(flags_)
  , stars_amount_(stars_amount_)
  , extended_media_(std::move(extended_media_))
  , payload_(payload_)
{}

const std::int32_t inputMediaPaidMedia::ID;

object_ptr<InputMedia> inputMediaPaidMedia::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMediaPaidMedia> res = make_tl_object<inputMediaPaidMedia>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->stars_amount_ = TlFetchLong::parse(p);
  res->extended_media_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InputMedia>>, 481674261>::parse(p);
  if (var0 & 1) { res->payload_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMediaPaidMedia::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(stars_amount_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(extended_media_, s);
  if (var0 & 1) { TlStoreString::store(payload_, s); }
}

void inputMediaPaidMedia::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(stars_amount_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(extended_media_, s);
  if (var0 & 1) { TlStoreString::store(payload_, s); }
}

void inputMediaPaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaPaidMedia");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("stars_amount", stars_amount_);
    { s.store_vector_begin("extended_media", extended_media_.size()); for (const auto &_value : extended_media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 1) { s.store_field("payload", payload_); }
    s.store_class_end();
  }
}

inputMediaTodo::inputMediaTodo(object_ptr<todoList> &&todo_)
  : todo_(std::move(todo_))
{}

const std::int32_t inputMediaTodo::ID;

object_ptr<InputMedia> inputMediaTodo::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaTodo>(p);
}

inputMediaTodo::inputMediaTodo(TlBufferParser &p)
  : todo_(TlFetchBoxed<TlFetchObject<todoList>, 1236871718>::parse(p))
{}

void inputMediaTodo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 1236871718>::store(todo_, s);
}

void inputMediaTodo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 1236871718>::store(todo_, s);
}

void inputMediaTodo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaTodo");
    s.store_object_field("todo", static_cast<const BaseObject *>(todo_.get()));
    s.store_class_end();
  }
}

inputMessageID::inputMessageID(int32 id_)
  : id_(id_)
{}

const std::int32_t inputMessageID::ID;

void inputMessageID::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputMessageID::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputMessageID::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageID");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

inputMessageReplyTo::inputMessageReplyTo(int32 id_)
  : id_(id_)
{}

const std::int32_t inputMessageReplyTo::ID;

void inputMessageReplyTo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputMessageReplyTo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputMessageReplyTo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageReplyTo");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

const std::int32_t inputMessagePinned::ID;

void inputMessagePinned::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagePinned::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagePinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagePinned");
    s.store_class_end();
  }
}

inputMessageCallbackQuery::inputMessageCallbackQuery(int32 id_, int64 query_id_)
  : id_(id_)
  , query_id_(query_id_)
{}

const std::int32_t inputMessageCallbackQuery::ID;

void inputMessageCallbackQuery::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(query_id_, s);
}

void inputMessageCallbackQuery::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(query_id_, s);
}

void inputMessageCallbackQuery::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageCallbackQuery");
    s.store_field("id", id_);
    s.store_field("query_id", query_id_);
    s.store_class_end();
  }
}

inputNotifyPeer::inputNotifyPeer(object_ptr<InputPeer> &&peer_)
  : peer_(std::move(peer_))
{}

const std::int32_t inputNotifyPeer::ID;

void inputNotifyPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void inputNotifyPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void inputNotifyPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputNotifyPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

const std::int32_t inputNotifyUsers::ID;

void inputNotifyUsers::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputNotifyUsers::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputNotifyUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputNotifyUsers");
    s.store_class_end();
  }
}

const std::int32_t inputNotifyChats::ID;

void inputNotifyChats::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputNotifyChats::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputNotifyChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputNotifyChats");
    s.store_class_end();
  }
}

const std::int32_t inputNotifyBroadcasts::ID;

void inputNotifyBroadcasts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputNotifyBroadcasts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputNotifyBroadcasts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputNotifyBroadcasts");
    s.store_class_end();
  }
}

inputNotifyForumTopic::inputNotifyForumTopic(object_ptr<InputPeer> &&peer_, int32 top_msg_id_)
  : peer_(std::move(peer_))
  , top_msg_id_(top_msg_id_)
{}

const std::int32_t inputNotifyForumTopic::ID;

void inputNotifyForumTopic::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(top_msg_id_, s);
}

void inputNotifyForumTopic::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(top_msg_id_, s);
}

void inputNotifyForumTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputNotifyForumTopic");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("top_msg_id", top_msg_id_);
    s.store_class_end();
  }
}

inputPaymentCredentialsSaved::inputPaymentCredentialsSaved(string const &id_, bytes &&tmp_password_)
  : id_(id_)
  , tmp_password_(std::move(tmp_password_))
{}

const std::int32_t inputPaymentCredentialsSaved::ID;

void inputPaymentCredentialsSaved::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(tmp_password_, s);
}

void inputPaymentCredentialsSaved::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(id_, s);
  TlStoreString::store(tmp_password_, s);
}

void inputPaymentCredentialsSaved::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaymentCredentialsSaved");
    s.store_field("id", id_);
    s.store_bytes_field("tmp_password", tmp_password_);
    s.store_class_end();
  }
}

inputPaymentCredentials::inputPaymentCredentials(int32 flags_, bool save_, object_ptr<dataJSON> &&data_)
  : flags_(flags_)
  , save_(save_)
  , data_(std::move(data_))
{}

const std::int32_t inputPaymentCredentials::ID;

void inputPaymentCredentials::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (save_ << 0)), s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(data_, s);
}

void inputPaymentCredentials::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (save_ << 0)), s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(data_, s);
}

void inputPaymentCredentials::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaymentCredentials");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (save_ << 0)));
    if (var0 & 1) { s.store_field("save", true); }
    s.store_object_field("data", static_cast<const BaseObject *>(data_.get()));
    s.store_class_end();
  }
}

inputPaymentCredentialsApplePay::inputPaymentCredentialsApplePay(object_ptr<dataJSON> &&payment_data_)
  : payment_data_(std::move(payment_data_))
{}

const std::int32_t inputPaymentCredentialsApplePay::ID;

void inputPaymentCredentialsApplePay::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(payment_data_, s);
}

void inputPaymentCredentialsApplePay::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(payment_data_, s);
}

void inputPaymentCredentialsApplePay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaymentCredentialsApplePay");
    s.store_object_field("payment_data", static_cast<const BaseObject *>(payment_data_.get()));
    s.store_class_end();
  }
}

inputPaymentCredentialsGooglePay::inputPaymentCredentialsGooglePay(object_ptr<dataJSON> &&payment_token_)
  : payment_token_(std::move(payment_token_))
{}

const std::int32_t inputPaymentCredentialsGooglePay::ID;

void inputPaymentCredentialsGooglePay::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(payment_token_, s);
}

void inputPaymentCredentialsGooglePay::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, 2104790276>::store(payment_token_, s);
}

void inputPaymentCredentialsGooglePay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaymentCredentialsGooglePay");
    s.store_object_field("payment_token", static_cast<const BaseObject *>(payment_token_.get()));
    s.store_class_end();
  }
}

object_ptr<InputPeer> InputPeer::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputPeerEmpty::ID:
      return inputPeerEmpty::fetch(p);
    case inputPeerSelf::ID:
      return inputPeerSelf::fetch(p);
    case inputPeerChat::ID:
      return inputPeerChat::fetch(p);
    case inputPeerUser::ID:
      return inputPeerUser::fetch(p);
    case inputPeerChannel::ID:
      return inputPeerChannel::fetch(p);
    case inputPeerUserFromMessage::ID:
      return inputPeerUserFromMessage::fetch(p);
    case inputPeerChannelFromMessage::ID:
      return inputPeerChannelFromMessage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputPeerEmpty::ID;

object_ptr<InputPeer> inputPeerEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerEmpty>();
}

void inputPeerEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPeerEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPeerEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerEmpty");
    s.store_class_end();
  }
}

const std::int32_t inputPeerSelf::ID;

object_ptr<InputPeer> inputPeerSelf::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerSelf>();
}

void inputPeerSelf::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPeerSelf::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPeerSelf::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerSelf");
    s.store_class_end();
  }
}

inputPeerChat::inputPeerChat(int64 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t inputPeerChat::ID;

object_ptr<InputPeer> inputPeerChat::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerChat>(p);
}

inputPeerChat::inputPeerChat(TlBufferParser &p)
  : chat_id_(TlFetchLong::parse(p))
{}

void inputPeerChat::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(chat_id_, s);
}

void inputPeerChat::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(chat_id_, s);
}

void inputPeerChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

inputPeerUser::inputPeerUser(int64 user_id_, int64 access_hash_)
  : user_id_(user_id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputPeerUser::ID;

object_ptr<InputPeer> inputPeerUser::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerUser>(p);
}

inputPeerUser::inputPeerUser(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputPeerUser::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(user_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPeerUser::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(user_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPeerUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerUser");
    s.store_field("user_id", user_id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputPeerChannel::inputPeerChannel(int64 channel_id_, int64 access_hash_)
  : channel_id_(channel_id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputPeerChannel::ID;

object_ptr<InputPeer> inputPeerChannel::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerChannel>(p);
}

inputPeerChannel::inputPeerChannel(TlBufferParser &p)
  : channel_id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputPeerChannel::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPeerChannel::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPeerChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerChannel");
    s.store_field("channel_id", channel_id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputPeerUserFromMessage::inputPeerUserFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 user_id_)
  : peer_(std::move(peer_))
  , msg_id_(msg_id_)
  , user_id_(user_id_)
{}

const std::int32_t inputPeerUserFromMessage::ID;

object_ptr<InputPeer> inputPeerUserFromMessage::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerUserFromMessage>(p);
}

inputPeerUserFromMessage::inputPeerUserFromMessage(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , msg_id_(TlFetchInt::parse(p))
  , user_id_(TlFetchLong::parse(p))
{}

void inputPeerUserFromMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(user_id_, s);
}

void inputPeerUserFromMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(user_id_, s);
}

void inputPeerUserFromMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerUserFromMessage");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

inputPeerChannelFromMessage::inputPeerChannelFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 channel_id_)
  : peer_(std::move(peer_))
  , msg_id_(msg_id_)
  , channel_id_(channel_id_)
{}

const std::int32_t inputPeerChannelFromMessage::ID;

object_ptr<InputPeer> inputPeerChannelFromMessage::fetch(TlBufferParser &p) {
  return make_tl_object<inputPeerChannelFromMessage>(p);
}

inputPeerChannelFromMessage::inputPeerChannelFromMessage(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , msg_id_(TlFetchInt::parse(p))
  , channel_id_(TlFetchLong::parse(p))
{}

void inputPeerChannelFromMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(channel_id_, s);
}

void inputPeerChannelFromMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(channel_id_, s);
}

void inputPeerChannelFromMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerChannelFromMessage");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_field("channel_id", channel_id_);
    s.store_class_end();
  }
}

inputPeerNotifySettings::inputPeerNotifySettings(int32 flags_, bool show_previews_, bool silent_, int32 mute_until_, object_ptr<NotificationSound> &&sound_, bool stories_muted_, bool stories_hide_sender_, object_ptr<NotificationSound> &&stories_sound_)
  : flags_(flags_)
  , show_previews_(show_previews_)
  , silent_(silent_)
  , mute_until_(mute_until_)
  , sound_(std::move(sound_))
  , stories_muted_(stories_muted_)
  , stories_hide_sender_(stories_hide_sender_)
  , stories_sound_(std::move(stories_sound_))
{}

const std::int32_t inputPeerNotifySettings::ID;

void inputPeerNotifySettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBool::store(show_previews_, s); }
  if (var0 & 2) { TlStoreBool::store(silent_, s); }
  if (var0 & 4) { TlStoreBinary::store(mute_until_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(sound_, s); }
  if (var0 & 64) { TlStoreBool::store(stories_muted_, s); }
  if (var0 & 128) { TlStoreBool::store(stories_hide_sender_, s); }
  if (var0 & 256) { TlStoreBoxedUnknown<TlStoreObject>::store(stories_sound_, s); }
}

void inputPeerNotifySettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBool::store(show_previews_, s); }
  if (var0 & 2) { TlStoreBool::store(silent_, s); }
  if (var0 & 4) { TlStoreBinary::store(mute_until_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(sound_, s); }
  if (var0 & 64) { TlStoreBool::store(stories_muted_, s); }
  if (var0 & 128) { TlStoreBool::store(stories_hide_sender_, s); }
  if (var0 & 256) { TlStoreBoxedUnknown<TlStoreObject>::store(stories_sound_, s); }
}

void inputPeerNotifySettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPeerNotifySettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("show_previews", show_previews_); }
    if (var0 & 2) { s.store_field("silent", silent_); }
    if (var0 & 4) { s.store_field("mute_until", mute_until_); }
    if (var0 & 8) { s.store_object_field("sound", static_cast<const BaseObject *>(sound_.get())); }
    if (var0 & 64) { s.store_field("stories_muted", stories_muted_); }
    if (var0 & 128) { s.store_field("stories_hide_sender", stories_hide_sender_); }
    if (var0 & 256) { s.store_object_field("stories_sound", static_cast<const BaseObject *>(stories_sound_.get())); }
    s.store_class_end();
  }
}

inputPhoneCall::inputPhoneCall(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputPhoneCall::ID;

void inputPhoneCall::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPhoneCall::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputPhoneCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhoneCall");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

object_ptr<InputPhoto> InputPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputPhotoEmpty::ID:
      return inputPhotoEmpty::fetch(p);
    case inputPhoto::ID:
      return inputPhoto::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputPhotoEmpty::ID;

object_ptr<InputPhoto> inputPhotoEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputPhotoEmpty>();
}

void inputPhotoEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPhotoEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPhotoEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhotoEmpty");
    s.store_class_end();
  }
}

inputPhoto::inputPhoto(int64 id_, int64 access_hash_, bytes &&file_reference_)
  : id_(id_)
  , access_hash_(access_hash_)
  , file_reference_(std::move(file_reference_))
{}

const std::int32_t inputPhoto::ID;

object_ptr<InputPhoto> inputPhoto::fetch(TlBufferParser &p) {
  return make_tl_object<inputPhoto>(p);
}

inputPhoto::inputPhoto(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
  , file_reference_(TlFetchBytes<bytes>::parse(p))
{}

void inputPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
}

void inputPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreString::store(file_reference_, s);
}

void inputPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPhoto");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_bytes_field("file_reference", file_reference_);
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyStatusTimestamp::ID;

void inputPrivacyKeyStatusTimestamp::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyStatusTimestamp::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyStatusTimestamp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyStatusTimestamp");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyChatInvite::ID;

void inputPrivacyKeyChatInvite::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyChatInvite::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyChatInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyChatInvite");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyPhoneCall::ID;

void inputPrivacyKeyPhoneCall::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneCall::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyPhoneCall");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyPhoneP2P::ID;

void inputPrivacyKeyPhoneP2P::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneP2P::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneP2P::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyPhoneP2P");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyForwards::ID;

void inputPrivacyKeyForwards::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyForwards::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyForwards::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyForwards");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyProfilePhoto::ID;

void inputPrivacyKeyProfilePhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyProfilePhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyProfilePhoto");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyPhoneNumber::ID;

void inputPrivacyKeyPhoneNumber::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneNumber::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyPhoneNumber");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyAddedByPhone::ID;

void inputPrivacyKeyAddedByPhone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyAddedByPhone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyAddedByPhone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyAddedByPhone");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyVoiceMessages::ID;

void inputPrivacyKeyVoiceMessages::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyVoiceMessages::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyVoiceMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyVoiceMessages");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyAbout::ID;

void inputPrivacyKeyAbout::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyAbout::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyAbout::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyAbout");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyBirthday::ID;

void inputPrivacyKeyBirthday::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyBirthday::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyBirthday::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyBirthday");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyStarGiftsAutoSave::ID;

void inputPrivacyKeyStarGiftsAutoSave::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyStarGiftsAutoSave::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyStarGiftsAutoSave::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyStarGiftsAutoSave");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyKeyNoPaidMessages::ID;

void inputPrivacyKeyNoPaidMessages::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyNoPaidMessages::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyKeyNoPaidMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyKeyNoPaidMessages");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueAllowContacts::ID;

void inputPrivacyValueAllowContacts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowContacts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowContacts");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueAllowAll::ID;

void inputPrivacyValueAllowAll::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowAll::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowAll");
    s.store_class_end();
  }
}

inputPrivacyValueAllowUsers::inputPrivacyValueAllowUsers(array<object_ptr<InputUser>> &&users_)
  : users_(std::move(users_))
{}

const std::int32_t inputPrivacyValueAllowUsers::ID;

void inputPrivacyValueAllowUsers::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
}

void inputPrivacyValueAllowUsers::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
}

void inputPrivacyValueAllowUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowUsers");
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueDisallowContacts::ID;

void inputPrivacyValueDisallowContacts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowContacts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueDisallowContacts");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueDisallowAll::ID;

void inputPrivacyValueDisallowAll::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowAll::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueDisallowAll");
    s.store_class_end();
  }
}

inputPrivacyValueDisallowUsers::inputPrivacyValueDisallowUsers(array<object_ptr<InputUser>> &&users_)
  : users_(std::move(users_))
{}

const std::int32_t inputPrivacyValueDisallowUsers::ID;

void inputPrivacyValueDisallowUsers::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
}

void inputPrivacyValueDisallowUsers::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
}

void inputPrivacyValueDisallowUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueDisallowUsers");
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputPrivacyValueAllowChatParticipants::inputPrivacyValueAllowChatParticipants(array<int64> &&chats_)
  : chats_(std::move(chats_))
{}

const std::int32_t inputPrivacyValueAllowChatParticipants::ID;

void inputPrivacyValueAllowChatParticipants::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(chats_, s);
}

void inputPrivacyValueAllowChatParticipants::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(chats_, s);
}

void inputPrivacyValueAllowChatParticipants::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowChatParticipants");
    { s.store_vector_begin("chats", chats_.size()); for (const auto &_value : chats_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputPrivacyValueDisallowChatParticipants::inputPrivacyValueDisallowChatParticipants(array<int64> &&chats_)
  : chats_(std::move(chats_))
{}

const std::int32_t inputPrivacyValueDisallowChatParticipants::ID;

void inputPrivacyValueDisallowChatParticipants::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(chats_, s);
}

void inputPrivacyValueDisallowChatParticipants::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(chats_, s);
}

void inputPrivacyValueDisallowChatParticipants::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueDisallowChatParticipants");
    { s.store_vector_begin("chats", chats_.size()); for (const auto &_value : chats_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueAllowCloseFriends::ID;

void inputPrivacyValueAllowCloseFriends::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowCloseFriends::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowCloseFriends::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowCloseFriends");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueAllowPremium::ID;

void inputPrivacyValueAllowPremium::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowPremium::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowPremium");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueAllowBots::ID;

void inputPrivacyValueAllowBots::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowBots::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueAllowBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueAllowBots");
    s.store_class_end();
  }
}

const std::int32_t inputPrivacyValueDisallowBots::ID;

void inputPrivacyValueDisallowBots::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowBots::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputPrivacyValueDisallowBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPrivacyValueDisallowBots");
    s.store_class_end();
  }
}

inputQuickReplyShortcut::inputQuickReplyShortcut(string const &shortcut_)
  : shortcut_(shortcut_)
{}

const std::int32_t inputQuickReplyShortcut::ID;

void inputQuickReplyShortcut::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(shortcut_, s);
}

void inputQuickReplyShortcut::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(shortcut_, s);
}

void inputQuickReplyShortcut::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputQuickReplyShortcut");
    s.store_field("shortcut", shortcut_);
    s.store_class_end();
  }
}

inputQuickReplyShortcutId::inputQuickReplyShortcutId(int32 shortcut_id_)
  : shortcut_id_(shortcut_id_)
{}

const std::int32_t inputQuickReplyShortcutId::ID;

void inputQuickReplyShortcutId::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(shortcut_id_, s);
}

void inputQuickReplyShortcutId::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(shortcut_id_, s);
}

void inputQuickReplyShortcutId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputQuickReplyShortcutId");
    s.store_field("shortcut_id", shortcut_id_);
    s.store_class_end();
  }
}

object_ptr<InputReplyTo> InputReplyTo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputReplyToMessage::ID:
      return inputReplyToMessage::fetch(p);
    case inputReplyToStory::ID:
      return inputReplyToStory::fetch(p);
    case inputReplyToMonoForum::ID:
      return inputReplyToMonoForum::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

inputReplyToMessage::inputReplyToMessage()
  : flags_()
  , reply_to_msg_id_()
  , top_msg_id_()
  , reply_to_peer_id_()
  , quote_text_()
  , quote_entities_()
  , quote_offset_()
  , monoforum_peer_id_()
  , todo_item_id_()
{}

inputReplyToMessage::inputReplyToMessage(int32 flags_, int32 reply_to_msg_id_, int32 top_msg_id_, object_ptr<InputPeer> &&reply_to_peer_id_, string const &quote_text_, array<object_ptr<MessageEntity>> &&quote_entities_, int32 quote_offset_, object_ptr<InputPeer> &&monoforum_peer_id_, int32 todo_item_id_)
  : flags_(flags_)
  , reply_to_msg_id_(reply_to_msg_id_)
  , top_msg_id_(top_msg_id_)
  , reply_to_peer_id_(std::move(reply_to_peer_id_))
  , quote_text_(quote_text_)
  , quote_entities_(std::move(quote_entities_))
  , quote_offset_(quote_offset_)
  , monoforum_peer_id_(std::move(monoforum_peer_id_))
  , todo_item_id_(todo_item_id_)
{}

const std::int32_t inputReplyToMessage::ID;

object_ptr<InputReplyTo> inputReplyToMessage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputReplyToMessage> res = make_tl_object<inputReplyToMessage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->reply_to_msg_id_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->top_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->reply_to_peer_id_ = TlFetchObject<InputPeer>::parse(p); }
  if (var0 & 4) { res->quote_text_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->quote_entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 16) { res->quote_offset_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->monoforum_peer_id_ = TlFetchObject<InputPeer>::parse(p); }
  if (var0 & 64) { res->todo_item_id_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputReplyToMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(reply_to_msg_id_, s);
  if (var0 & 1) { TlStoreBinary::store(top_msg_id_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_to_peer_id_, s); }
  if (var0 & 4) { TlStoreString::store(quote_text_, s); }
  if (var0 & 8) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(quote_entities_, s); }
  if (var0 & 16) { TlStoreBinary::store(quote_offset_, s); }
  if (var0 & 32) { TlStoreBoxedUnknown<TlStoreObject>::store(monoforum_peer_id_, s); }
  if (var0 & 64) { TlStoreBinary::store(todo_item_id_, s); }
}

void inputReplyToMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(reply_to_msg_id_, s);
  if (var0 & 1) { TlStoreBinary::store(top_msg_id_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(reply_to_peer_id_, s); }
  if (var0 & 4) { TlStoreString::store(quote_text_, s); }
  if (var0 & 8) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(quote_entities_, s); }
  if (var0 & 16) { TlStoreBinary::store(quote_offset_, s); }
  if (var0 & 32) { TlStoreBoxedUnknown<TlStoreObject>::store(monoforum_peer_id_, s); }
  if (var0 & 64) { TlStoreBinary::store(todo_item_id_, s); }
}

void inputReplyToMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputReplyToMessage");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("reply_to_msg_id", reply_to_msg_id_);
    if (var0 & 1) { s.store_field("top_msg_id", top_msg_id_); }
    if (var0 & 2) { s.store_object_field("reply_to_peer_id", static_cast<const BaseObject *>(reply_to_peer_id_.get())); }
    if (var0 & 4) { s.store_field("quote_text", quote_text_); }
    if (var0 & 8) { { s.store_vector_begin("quote_entities", quote_entities_.size()); for (const auto &_value : quote_entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 16) { s.store_field("quote_offset", quote_offset_); }
    if (var0 & 32) { s.store_object_field("monoforum_peer_id", static_cast<const BaseObject *>(monoforum_peer_id_.get())); }
    if (var0 & 64) { s.store_field("todo_item_id", todo_item_id_); }
    s.store_class_end();
  }
}

inputReplyToStory::inputReplyToStory(object_ptr<InputPeer> &&peer_, int32 story_id_)
  : peer_(std::move(peer_))
  , story_id_(story_id_)
{}

const std::int32_t inputReplyToStory::ID;

object_ptr<InputReplyTo> inputReplyToStory::fetch(TlBufferParser &p) {
  return make_tl_object<inputReplyToStory>(p);
}

inputReplyToStory::inputReplyToStory(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , story_id_(TlFetchInt::parse(p))
{}

void inputReplyToStory::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(story_id_, s);
}

void inputReplyToStory::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(story_id_, s);
}

void inputReplyToStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputReplyToStory");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

inputReplyToMonoForum::inputReplyToMonoForum(object_ptr<InputPeer> &&monoforum_peer_id_)
  : monoforum_peer_id_(std::move(monoforum_peer_id_))
{}

const std::int32_t inputReplyToMonoForum::ID;

object_ptr<InputReplyTo> inputReplyToMonoForum::fetch(TlBufferParser &p) {
  return make_tl_object<inputReplyToMonoForum>(p);
}

inputReplyToMonoForum::inputReplyToMonoForum(TlBufferParser &p)
  : monoforum_peer_id_(TlFetchObject<InputPeer>::parse(p))
{}

void inputReplyToMonoForum::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(monoforum_peer_id_, s);
}

void inputReplyToMonoForum::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(monoforum_peer_id_, s);
}

void inputReplyToMonoForum::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputReplyToMonoForum");
    s.store_object_field("monoforum_peer_id", static_cast<const BaseObject *>(monoforum_peer_id_.get()));
    s.store_class_end();
  }
}

inputSavedStarGiftUser::inputSavedStarGiftUser(int32 msg_id_)
  : msg_id_(msg_id_)
{}

const std::int32_t inputSavedStarGiftUser::ID;

void inputSavedStarGiftUser::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(msg_id_, s);
}

void inputSavedStarGiftUser::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(msg_id_, s);
}

void inputSavedStarGiftUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSavedStarGiftUser");
    s.store_field("msg_id", msg_id_);
    s.store_class_end();
  }
}

inputSavedStarGiftChat::inputSavedStarGiftChat(object_ptr<InputPeer> &&peer_, int64 saved_id_)
  : peer_(std::move(peer_))
  , saved_id_(saved_id_)
{}

const std::int32_t inputSavedStarGiftChat::ID;

void inputSavedStarGiftChat::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(saved_id_, s);
}

void inputSavedStarGiftChat::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(saved_id_, s);
}

void inputSavedStarGiftChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSavedStarGiftChat");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("saved_id", saved_id_);
    s.store_class_end();
  }
}

inputSavedStarGiftSlug::inputSavedStarGiftSlug(string const &slug_)
  : slug_(slug_)
{}

const std::int32_t inputSavedStarGiftSlug::ID;

void inputSavedStarGiftSlug::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputSavedStarGiftSlug::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputSavedStarGiftSlug::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSavedStarGiftSlug");
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

inputSecureFileUploaded::inputSecureFileUploaded(int64 id_, int32 parts_, string const &md5_checksum_, bytes &&file_hash_, bytes &&secret_)
  : id_(id_)
  , parts_(parts_)
  , md5_checksum_(md5_checksum_)
  , file_hash_(std::move(file_hash_))
  , secret_(std::move(secret_))
{}

const std::int32_t inputSecureFileUploaded::ID;

void inputSecureFileUploaded::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(md5_checksum_, s);
  TlStoreString::store(file_hash_, s);
  TlStoreString::store(secret_, s);
}

void inputSecureFileUploaded::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(parts_, s);
  TlStoreString::store(md5_checksum_, s);
  TlStoreString::store(file_hash_, s);
  TlStoreString::store(secret_, s);
}

void inputSecureFileUploaded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSecureFileUploaded");
    s.store_field("id", id_);
    s.store_field("parts", parts_);
    s.store_field("md5_checksum", md5_checksum_);
    s.store_bytes_field("file_hash", file_hash_);
    s.store_bytes_field("secret", secret_);
    s.store_class_end();
  }
}

inputSecureFile::inputSecureFile(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputSecureFile::ID;

void inputSecureFile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputSecureFile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputSecureFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSecureFile");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputSecureValue::inputSecureValue(int32 flags_, object_ptr<SecureValueType> &&type_, object_ptr<secureData> &&data_, object_ptr<InputSecureFile> &&front_side_, object_ptr<InputSecureFile> &&reverse_side_, object_ptr<InputSecureFile> &&selfie_, array<object_ptr<InputSecureFile>> &&translation_, array<object_ptr<InputSecureFile>> &&files_, object_ptr<SecurePlainData> &&plain_data_)
  : flags_(flags_)
  , type_(std::move(type_))
  , data_(std::move(data_))
  , front_side_(std::move(front_side_))
  , reverse_side_(std::move(reverse_side_))
  , selfie_(std::move(selfie_))
  , translation_(std::move(translation_))
  , files_(std::move(files_))
  , plain_data_(std::move(plain_data_))
{}

const std::int32_t inputSecureValue::ID;

void inputSecureValue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(type_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1964327229>::store(data_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(front_side_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reverse_side_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(selfie_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(translation_, s); }
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(files_, s); }
  if (var0 & 32) { TlStoreBoxedUnknown<TlStoreObject>::store(plain_data_, s); }
}

void inputSecureValue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(type_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1964327229>::store(data_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(front_side_, s); }
  if (var0 & 4) { TlStoreBoxedUnknown<TlStoreObject>::store(reverse_side_, s); }
  if (var0 & 8) { TlStoreBoxedUnknown<TlStoreObject>::store(selfie_, s); }
  if (var0 & 64) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(translation_, s); }
  if (var0 & 16) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(files_, s); }
  if (var0 & 32) { TlStoreBoxedUnknown<TlStoreObject>::store(plain_data_, s); }
}

void inputSecureValue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSecureValue");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    if (var0 & 1) { s.store_object_field("data", static_cast<const BaseObject *>(data_.get())); }
    if (var0 & 2) { s.store_object_field("front_side", static_cast<const BaseObject *>(front_side_.get())); }
    if (var0 & 4) { s.store_object_field("reverse_side", static_cast<const BaseObject *>(reverse_side_.get())); }
    if (var0 & 8) { s.store_object_field("selfie", static_cast<const BaseObject *>(selfie_.get())); }
    if (var0 & 64) { { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 16) { { s.store_vector_begin("files", files_.size()); for (const auto &_value : files_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 32) { s.store_object_field("plain_data", static_cast<const BaseObject *>(plain_data_.get())); }
    s.store_class_end();
  }
}

inputSingleMedia::inputSingleMedia(int32 flags_, object_ptr<InputMedia> &&media_, int64 random_id_, string const &message_, array<object_ptr<MessageEntity>> &&entities_)
  : flags_(flags_)
  , media_(std::move(media_))
  , random_id_(random_id_)
  , message_(message_)
  , entities_(std::move(entities_))
{}

const std::int32_t inputSingleMedia::ID;

void inputSingleMedia::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(media_, s);
  TlStoreBinary::store(random_id_, s);
  TlStoreString::store(message_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
}

void inputSingleMedia::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(media_, s);
  TlStoreBinary::store(random_id_, s);
  TlStoreString::store(message_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(entities_, s); }
}

void inputSingleMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSingleMedia");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("media", static_cast<const BaseObject *>(media_.get()));
    s.store_field("random_id", random_id_);
    s.store_field("message", message_);
    if (var0 & 1) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

inputStarsTransaction::inputStarsTransaction(int32 flags_, bool refund_, string const &id_)
  : flags_(flags_)
  , refund_(refund_)
  , id_(id_)
{}

const std::int32_t inputStarsTransaction::ID;

void inputStarsTransaction::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (refund_ << 0)), s);
  TlStoreString::store(id_, s);
}

void inputStarsTransaction::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (refund_ << 0)), s);
  TlStoreString::store(id_, s);
}

void inputStarsTransaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStarsTransaction");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (refund_ << 0)));
    if (var0 & 1) { s.store_field("refund", true); }
    s.store_field("id", id_);
    s.store_class_end();
  }
}

object_ptr<InputStickerSet> InputStickerSet::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputStickerSetEmpty::ID:
      return inputStickerSetEmpty::fetch(p);
    case inputStickerSetID::ID:
      return inputStickerSetID::fetch(p);
    case inputStickerSetShortName::ID:
      return inputStickerSetShortName::fetch(p);
    case inputStickerSetAnimatedEmoji::ID:
      return inputStickerSetAnimatedEmoji::fetch(p);
    case inputStickerSetDice::ID:
      return inputStickerSetDice::fetch(p);
    case inputStickerSetAnimatedEmojiAnimations::ID:
      return inputStickerSetAnimatedEmojiAnimations::fetch(p);
    case inputStickerSetPremiumGifts::ID:
      return inputStickerSetPremiumGifts::fetch(p);
    case inputStickerSetEmojiGenericAnimations::ID:
      return inputStickerSetEmojiGenericAnimations::fetch(p);
    case inputStickerSetEmojiDefaultStatuses::ID:
      return inputStickerSetEmojiDefaultStatuses::fetch(p);
    case inputStickerSetEmojiDefaultTopicIcons::ID:
      return inputStickerSetEmojiDefaultTopicIcons::fetch(p);
    case inputStickerSetEmojiChannelDefaultStatuses::ID:
      return inputStickerSetEmojiChannelDefaultStatuses::fetch(p);
    case inputStickerSetTonGifts::ID:
      return inputStickerSetTonGifts::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputStickerSetEmpty::ID;

object_ptr<InputStickerSet> inputStickerSetEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetEmpty>();
}

void inputStickerSetEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetEmpty");
    s.store_class_end();
  }
}

inputStickerSetID::inputStickerSetID(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputStickerSetID::ID;

object_ptr<InputStickerSet> inputStickerSetID::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetID>(p);
}

inputStickerSetID::inputStickerSetID(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputStickerSetID::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputStickerSetID::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputStickerSetID::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetID");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputStickerSetShortName::inputStickerSetShortName(string const &short_name_)
  : short_name_(short_name_)
{}

const std::int32_t inputStickerSetShortName::ID;

object_ptr<InputStickerSet> inputStickerSetShortName::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetShortName>(p);
}

inputStickerSetShortName::inputStickerSetShortName(TlBufferParser &p)
  : short_name_(TlFetchString<string>::parse(p))
{}

void inputStickerSetShortName::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(short_name_, s);
}

void inputStickerSetShortName::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(short_name_, s);
}

void inputStickerSetShortName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetShortName");
    s.store_field("short_name", short_name_);
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetAnimatedEmoji::ID;

object_ptr<InputStickerSet> inputStickerSetAnimatedEmoji::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetAnimatedEmoji>();
}

void inputStickerSetAnimatedEmoji::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetAnimatedEmoji::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetAnimatedEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetAnimatedEmoji");
    s.store_class_end();
  }
}

inputStickerSetDice::inputStickerSetDice(string const &emoticon_)
  : emoticon_(emoticon_)
{}

const std::int32_t inputStickerSetDice::ID;

object_ptr<InputStickerSet> inputStickerSetDice::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetDice>(p);
}

inputStickerSetDice::inputStickerSetDice(TlBufferParser &p)
  : emoticon_(TlFetchString<string>::parse(p))
{}

void inputStickerSetDice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(emoticon_, s);
}

void inputStickerSetDice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(emoticon_, s);
}

void inputStickerSetDice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetDice");
    s.store_field("emoticon", emoticon_);
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetAnimatedEmojiAnimations::ID;

object_ptr<InputStickerSet> inputStickerSetAnimatedEmojiAnimations::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetAnimatedEmojiAnimations>();
}

void inputStickerSetAnimatedEmojiAnimations::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetAnimatedEmojiAnimations::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetAnimatedEmojiAnimations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetAnimatedEmojiAnimations");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetPremiumGifts::ID;

object_ptr<InputStickerSet> inputStickerSetPremiumGifts::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetPremiumGifts>();
}

void inputStickerSetPremiumGifts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetPremiumGifts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetPremiumGifts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetPremiumGifts");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetEmojiGenericAnimations::ID;

object_ptr<InputStickerSet> inputStickerSetEmojiGenericAnimations::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetEmojiGenericAnimations>();
}

void inputStickerSetEmojiGenericAnimations::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiGenericAnimations::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiGenericAnimations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetEmojiGenericAnimations");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetEmojiDefaultStatuses::ID;

object_ptr<InputStickerSet> inputStickerSetEmojiDefaultStatuses::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetEmojiDefaultStatuses>();
}

void inputStickerSetEmojiDefaultStatuses::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiDefaultStatuses::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiDefaultStatuses::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetEmojiDefaultStatuses");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetEmojiDefaultTopicIcons::ID;

object_ptr<InputStickerSet> inputStickerSetEmojiDefaultTopicIcons::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetEmojiDefaultTopicIcons>();
}

void inputStickerSetEmojiDefaultTopicIcons::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiDefaultTopicIcons::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiDefaultTopicIcons::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetEmojiDefaultTopicIcons");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetEmojiChannelDefaultStatuses::ID;

object_ptr<InputStickerSet> inputStickerSetEmojiChannelDefaultStatuses::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetEmojiChannelDefaultStatuses>();
}

void inputStickerSetEmojiChannelDefaultStatuses::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiChannelDefaultStatuses::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetEmojiChannelDefaultStatuses::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetEmojiChannelDefaultStatuses");
    s.store_class_end();
  }
}

const std::int32_t inputStickerSetTonGifts::ID;

object_ptr<InputStickerSet> inputStickerSetTonGifts::fetch(TlBufferParser &p) {
  return make_tl_object<inputStickerSetTonGifts>();
}

void inputStickerSetTonGifts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputStickerSetTonGifts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputStickerSetTonGifts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetTonGifts");
    s.store_class_end();
  }
}

inputStickerSetItem::inputStickerSetItem(int32 flags_, object_ptr<InputDocument> &&document_, string const &emoji_, object_ptr<maskCoords> &&mask_coords_, string const &keywords_)
  : flags_(flags_)
  , document_(std::move(document_))
  , emoji_(emoji_)
  , mask_coords_(std::move(mask_coords_))
  , keywords_(keywords_)
{}

const std::int32_t inputStickerSetItem::ID;

void inputStickerSetItem::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(document_, s);
  TlStoreString::store(emoji_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1361650766>::store(mask_coords_, s); }
  if (var0 & 2) { TlStoreString::store(keywords_, s); }
}

void inputStickerSetItem::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(document_, s);
  TlStoreString::store(emoji_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -1361650766>::store(mask_coords_, s); }
  if (var0 & 2) { TlStoreString::store(keywords_, s); }
}

void inputStickerSetItem::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickerSetItem");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_field("emoji", emoji_);
    if (var0 & 1) { s.store_object_field("mask_coords", static_cast<const BaseObject *>(mask_coords_.get())); }
    if (var0 & 2) { s.store_field("keywords", keywords_); }
    s.store_class_end();
  }
}

inputStickeredMediaPhoto::inputStickeredMediaPhoto(object_ptr<InputPhoto> &&id_)
  : id_(std::move(id_))
{}

const std::int32_t inputStickeredMediaPhoto::ID;

void inputStickeredMediaPhoto::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputStickeredMediaPhoto::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputStickeredMediaPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickeredMediaPhoto");
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    s.store_class_end();
  }
}

inputStickeredMediaDocument::inputStickeredMediaDocument(object_ptr<InputDocument> &&id_)
  : id_(std::move(id_))
{}

const std::int32_t inputStickeredMediaDocument::ID;

void inputStickeredMediaDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputStickeredMediaDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(id_, s);
}

void inputStickeredMediaDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStickeredMediaDocument");
    s.store_object_field("id", static_cast<const BaseObject *>(id_.get()));
    s.store_class_end();
  }
}

inputStorePaymentPremiumSubscription::inputStorePaymentPremiumSubscription(int32 flags_, bool restore_, bool upgrade_)
  : flags_(flags_)
  , restore_(restore_)
  , upgrade_(upgrade_)
{}

const std::int32_t inputStorePaymentPremiumSubscription::ID;

void inputStorePaymentPremiumSubscription::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (restore_ << 0) | (upgrade_ << 1)), s);
}

void inputStorePaymentPremiumSubscription::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (restore_ << 0) | (upgrade_ << 1)), s);
}

void inputStorePaymentPremiumSubscription::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentPremiumSubscription");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (restore_ << 0) | (upgrade_ << 1)));
    if (var0 & 1) { s.store_field("restore", true); }
    if (var0 & 2) { s.store_field("upgrade", true); }
    s.store_class_end();
  }
}

inputStorePaymentGiftPremium::inputStorePaymentGiftPremium(object_ptr<InputUser> &&user_id_, string const &currency_, int64 amount_)
  : user_id_(std::move(user_id_))
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t inputStorePaymentGiftPremium::ID;

void inputStorePaymentGiftPremium::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentGiftPremium::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentGiftPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentGiftPremium");
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

inputStorePaymentPremiumGiftCode::inputStorePaymentPremiumGiftCode(int32 flags_, array<object_ptr<InputUser>> &&users_, object_ptr<InputPeer> &&boost_peer_, string const &currency_, int64 amount_, object_ptr<textWithEntities> &&message_)
  : flags_(flags_)
  , users_(std::move(users_))
  , boost_peer_(std::move(boost_peer_))
  , currency_(currency_)
  , amount_(amount_)
  , message_(std::move(message_))
{}

const std::int32_t inputStorePaymentPremiumGiftCode::ID;

void inputStorePaymentPremiumGiftCode::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s); }
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputStorePaymentPremiumGiftCode::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(users_, s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s); }
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 1964978502>::store(message_, s); }
}

void inputStorePaymentPremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentPremiumGiftCode");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 1) { s.store_object_field("boost_peer", static_cast<const BaseObject *>(boost_peer_.get())); }
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    if (var0 & 2) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    s.store_class_end();
  }
}

inputStorePaymentPremiumGiveaway::inputStorePaymentPremiumGiveaway(int32 flags_, bool only_new_subscribers_, bool winners_are_visible_, object_ptr<InputPeer> &&boost_peer_, array<object_ptr<InputPeer>> &&additional_peers_, array<string> &&countries_iso2_, string const &prize_description_, int64 random_id_, int32 until_date_, string const &currency_, int64 amount_)
  : flags_(flags_)
  , only_new_subscribers_(only_new_subscribers_)
  , winners_are_visible_(winners_are_visible_)
  , boost_peer_(std::move(boost_peer_))
  , additional_peers_(std::move(additional_peers_))
  , countries_iso2_(std::move(countries_iso2_))
  , prize_description_(prize_description_)
  , random_id_(random_id_)
  , until_date_(until_date_)
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t inputStorePaymentPremiumGiveaway::ID;

void inputStorePaymentPremiumGiveaway::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(additional_peers_, s); }
  if (var0 & 4) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(countries_iso2_, s); }
  if (var0 & 16) { TlStoreString::store(prize_description_, s); }
  TlStoreBinary::store(random_id_, s);
  TlStoreBinary::store(until_date_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentPremiumGiveaway::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(additional_peers_, s); }
  if (var0 & 4) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(countries_iso2_, s); }
  if (var0 & 16) { TlStoreString::store(prize_description_, s); }
  TlStoreBinary::store(random_id_, s);
  TlStoreBinary::store(until_date_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentPremiumGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentPremiumGiveaway");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)));
    if (var0 & 1) { s.store_field("only_new_subscribers", true); }
    if (var0 & 8) { s.store_field("winners_are_visible", true); }
    s.store_object_field("boost_peer", static_cast<const BaseObject *>(boost_peer_.get()));
    if (var0 & 2) { { s.store_vector_begin("additional_peers", additional_peers_.size()); for (const auto &_value : additional_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { { s.store_vector_begin("countries_iso2", countries_iso2_.size()); for (const auto &_value : countries_iso2_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 16) { s.store_field("prize_description", prize_description_); }
    s.store_field("random_id", random_id_);
    s.store_field("until_date", until_date_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

inputStorePaymentStarsTopup::inputStorePaymentStarsTopup(int64 stars_, string const &currency_, int64 amount_)
  : stars_(stars_)
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t inputStorePaymentStarsTopup::ID;

void inputStorePaymentStarsTopup::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(stars_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentStarsTopup::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(stars_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentStarsTopup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentStarsTopup");
    s.store_field("stars", stars_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

inputStorePaymentStarsGift::inputStorePaymentStarsGift(object_ptr<InputUser> &&user_id_, int64 stars_, string const &currency_, int64 amount_)
  : user_id_(std::move(user_id_))
  , stars_(stars_)
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t inputStorePaymentStarsGift::ID;

void inputStorePaymentStarsGift::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreBinary::store(stars_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentStarsGift::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
  TlStoreBinary::store(stars_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentStarsGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentStarsGift");
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_field("stars", stars_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

inputStorePaymentStarsGiveaway::inputStorePaymentStarsGiveaway(int32 flags_, bool only_new_subscribers_, bool winners_are_visible_, int64 stars_, object_ptr<InputPeer> &&boost_peer_, array<object_ptr<InputPeer>> &&additional_peers_, array<string> &&countries_iso2_, string const &prize_description_, int64 random_id_, int32 until_date_, string const &currency_, int64 amount_, int32 users_)
  : flags_(flags_)
  , only_new_subscribers_(only_new_subscribers_)
  , winners_are_visible_(winners_are_visible_)
  , stars_(stars_)
  , boost_peer_(std::move(boost_peer_))
  , additional_peers_(std::move(additional_peers_))
  , countries_iso2_(std::move(countries_iso2_))
  , prize_description_(prize_description_)
  , random_id_(random_id_)
  , until_date_(until_date_)
  , currency_(currency_)
  , amount_(amount_)
  , users_(users_)
{}

const std::int32_t inputStorePaymentStarsGiveaway::ID;

void inputStorePaymentStarsGiveaway::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)), s);
  TlStoreBinary::store(stars_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(additional_peers_, s); }
  if (var0 & 4) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(countries_iso2_, s); }
  if (var0 & 16) { TlStoreString::store(prize_description_, s); }
  TlStoreBinary::store(random_id_, s);
  TlStoreBinary::store(until_date_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
  TlStoreBinary::store(users_, s);
}

void inputStorePaymentStarsGiveaway::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)), s);
  TlStoreBinary::store(stars_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(boost_peer_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(additional_peers_, s); }
  if (var0 & 4) { TlStoreBoxed<TlStoreVector<TlStoreString>, 481674261>::store(countries_iso2_, s); }
  if (var0 & 16) { TlStoreString::store(prize_description_, s); }
  TlStoreBinary::store(random_id_, s);
  TlStoreBinary::store(until_date_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
  TlStoreBinary::store(users_, s);
}

void inputStorePaymentStarsGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentStarsGiveaway");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 3)));
    if (var0 & 1) { s.store_field("only_new_subscribers", true); }
    if (var0 & 8) { s.store_field("winners_are_visible", true); }
    s.store_field("stars", stars_);
    s.store_object_field("boost_peer", static_cast<const BaseObject *>(boost_peer_.get()));
    if (var0 & 2) { { s.store_vector_begin("additional_peers", additional_peers_.size()); for (const auto &_value : additional_peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 4) { { s.store_vector_begin("countries_iso2", countries_iso2_.size()); for (const auto &_value : countries_iso2_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 16) { s.store_field("prize_description", prize_description_); }
    s.store_field("random_id", random_id_);
    s.store_field("until_date", until_date_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("users", users_);
    s.store_class_end();
  }
}

inputStorePaymentAuthCode::inputStorePaymentAuthCode(int32 flags_, bool restore_, string const &phone_number_, string const &phone_code_hash_, string const &currency_, int64 amount_)
  : flags_(flags_)
  , restore_(restore_)
  , phone_number_(phone_number_)
  , phone_code_hash_(phone_code_hash_)
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t inputStorePaymentAuthCode::ID;

void inputStorePaymentAuthCode::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (restore_ << 0)), s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(phone_code_hash_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentAuthCode::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (restore_ << 0)), s);
  TlStoreString::store(phone_number_, s);
  TlStoreString::store(phone_code_hash_, s);
  TlStoreString::store(currency_, s);
  TlStoreBinary::store(amount_, s);
}

void inputStorePaymentAuthCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStorePaymentAuthCode");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (restore_ << 0)));
    if (var0 & 1) { s.store_field("restore", true); }
    s.store_field("phone_number", phone_number_);
    s.store_field("phone_code_hash", phone_code_hash_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

inputTheme::inputTheme(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputTheme::ID;

void inputTheme::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputTheme::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputTheme");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputThemeSlug::inputThemeSlug(string const &slug_)
  : slug_(slug_)
{}

const std::int32_t inputThemeSlug::ID;

void inputThemeSlug::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputThemeSlug::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputThemeSlug::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputThemeSlug");
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

inputThemeSettings::inputThemeSettings(int32 flags_, bool message_colors_animated_, object_ptr<BaseTheme> &&base_theme_, int32 accent_color_, int32 outbox_accent_color_, array<int32> &&message_colors_, object_ptr<InputWallPaper> &&wallpaper_, object_ptr<wallPaperSettings> &&wallpaper_settings_)
  : flags_(flags_)
  , message_colors_animated_(message_colors_animated_)
  , base_theme_(std::move(base_theme_))
  , accent_color_(accent_color_)
  , outbox_accent_color_(outbox_accent_color_)
  , message_colors_(std::move(message_colors_))
  , wallpaper_(std::move(wallpaper_))
  , wallpaper_settings_(std::move(wallpaper_settings_))
{}

const std::int32_t inputThemeSettings::ID;

void inputThemeSettings::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (message_colors_animated_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(base_theme_, s);
  TlStoreBinary::store(accent_color_, s);
  if (var0 & 8) { TlStoreBinary::store(outbox_accent_color_, s); }
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(message_colors_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(wallpaper_, s); }
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 925826256>::store(wallpaper_settings_, s); }
}

void inputThemeSettings::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (message_colors_animated_ << 2)), s);
  TlStoreBoxedUnknown<TlStoreObject>::store(base_theme_, s);
  TlStoreBinary::store(accent_color_, s);
  if (var0 & 8) { TlStoreBinary::store(outbox_accent_color_, s); }
  if (var0 & 1) { TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(message_colors_, s); }
  if (var0 & 2) { TlStoreBoxedUnknown<TlStoreObject>::store(wallpaper_, s); }
  if (var0 & 2) { TlStoreBoxed<TlStoreObject, 925826256>::store(wallpaper_settings_, s); }
}

void inputThemeSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputThemeSettings");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (message_colors_animated_ << 2)));
    if (var0 & 4) { s.store_field("message_colors_animated", true); }
    s.store_object_field("base_theme", static_cast<const BaseObject *>(base_theme_.get()));
    s.store_field("accent_color", accent_color_);
    if (var0 & 8) { s.store_field("outbox_accent_color", outbox_accent_color_); }
    if (var0 & 1) { { s.store_vector_begin("message_colors", message_colors_.size()); for (const auto &_value : message_colors_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 2) { s.store_object_field("wallpaper", static_cast<const BaseObject *>(wallpaper_.get())); }
    if (var0 & 2) { s.store_object_field("wallpaper_settings", static_cast<const BaseObject *>(wallpaper_settings_.get())); }
    s.store_class_end();
  }
}

object_ptr<InputUser> InputUser::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputUserEmpty::ID:
      return inputUserEmpty::fetch(p);
    case inputUserSelf::ID:
      return inputUserSelf::fetch(p);
    case inputUser::ID:
      return inputUser::fetch(p);
    case inputUserFromMessage::ID:
      return inputUserFromMessage::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputUserEmpty::ID;

object_ptr<InputUser> inputUserEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputUserEmpty>();
}

void inputUserEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputUserEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputUserEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputUserEmpty");
    s.store_class_end();
  }
}

const std::int32_t inputUserSelf::ID;

object_ptr<InputUser> inputUserSelf::fetch(TlBufferParser &p) {
  return make_tl_object<inputUserSelf>();
}

void inputUserSelf::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputUserSelf::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputUserSelf::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputUserSelf");
    s.store_class_end();
  }
}

inputUser::inputUser(int64 user_id_, int64 access_hash_)
  : user_id_(user_id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputUser::ID;

object_ptr<InputUser> inputUser::fetch(TlBufferParser &p) {
  return make_tl_object<inputUser>(p);
}

inputUser::inputUser(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
  , access_hash_(TlFetchLong::parse(p))
{}

void inputUser::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(user_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputUser::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(user_id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputUser");
    s.store_field("user_id", user_id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputUserFromMessage::inputUserFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 user_id_)
  : peer_(std::move(peer_))
  , msg_id_(msg_id_)
  , user_id_(user_id_)
{}

const std::int32_t inputUserFromMessage::ID;

object_ptr<InputUser> inputUserFromMessage::fetch(TlBufferParser &p) {
  return make_tl_object<inputUserFromMessage>(p);
}

inputUserFromMessage::inputUserFromMessage(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
  , msg_id_(TlFetchInt::parse(p))
  , user_id_(TlFetchLong::parse(p))
{}

void inputUserFromMessage::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(user_id_, s);
}

void inputUserFromMessage::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
  TlStoreBinary::store(msg_id_, s);
  TlStoreBinary::store(user_id_, s);
}

void inputUserFromMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputUserFromMessage");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

inputWallPaper::inputWallPaper(int64 id_, int64 access_hash_)
  : id_(id_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputWallPaper::ID;

void inputWallPaper::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputWallPaper::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputWallPaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWallPaper");
    s.store_field("id", id_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputWallPaperSlug::inputWallPaperSlug(string const &slug_)
  : slug_(slug_)
{}

const std::int32_t inputWallPaperSlug::ID;

void inputWallPaperSlug::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputWallPaperSlug::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(slug_, s);
}

void inputWallPaperSlug::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWallPaperSlug");
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

inputWallPaperNoFile::inputWallPaperNoFile(int64 id_)
  : id_(id_)
{}

const std::int32_t inputWallPaperNoFile::ID;

void inputWallPaperNoFile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputWallPaperNoFile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void inputWallPaperNoFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWallPaperNoFile");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

inputWebDocument::inputWebDocument(string const &url_, int32 size_, string const &mime_type_, array<object_ptr<DocumentAttribute>> &&attributes_)
  : url_(url_)
  , size_(size_)
  , mime_type_(mime_type_)
  , attributes_(std::move(attributes_))
{}

const std::int32_t inputWebDocument::ID;

object_ptr<inputWebDocument> inputWebDocument::fetch(TlBufferParser &p) {
  return make_tl_object<inputWebDocument>(p);
}

inputWebDocument::inputWebDocument(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
  , size_(TlFetchInt::parse(p))
  , mime_type_(TlFetchString<string>::parse(p))
  , attributes_(TlFetchBoxed<TlFetchVector<TlFetchObject<DocumentAttribute>>, 481674261>::parse(p))
{}

void inputWebDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(url_, s);
  TlStoreBinary::store(size_, s);
  TlStoreString::store(mime_type_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(attributes_, s);
}

void inputWebDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(url_, s);
  TlStoreBinary::store(size_, s);
  TlStoreString::store(mime_type_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(attributes_, s);
}

void inputWebDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWebDocument");
    s.store_field("url", url_);
    s.store_field("size", size_);
    s.store_field("mime_type", mime_type_);
    { s.store_vector_begin("attributes", attributes_.size()); for (const auto &_value : attributes_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputWebFileLocation::inputWebFileLocation(string const &url_, int64 access_hash_)
  : url_(url_)
  , access_hash_(access_hash_)
{}

const std::int32_t inputWebFileLocation::ID;

void inputWebFileLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(url_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputWebFileLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(url_, s);
  TlStoreBinary::store(access_hash_, s);
}

void inputWebFileLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWebFileLocation");
    s.store_field("url", url_);
    s.store_field("access_hash", access_hash_);
    s.store_class_end();
  }
}

inputWebFileGeoPointLocation::inputWebFileGeoPointLocation(object_ptr<InputGeoPoint> &&geo_point_, int64 access_hash_, int32 w_, int32 h_, int32 zoom_, int32 scale_)
  : geo_point_(std::move(geo_point_))
  , access_hash_(access_hash_)
  , w_(w_)
  , h_(h_)
  , zoom_(zoom_)
  , scale_(scale_)
{}

const std::int32_t inputWebFileGeoPointLocation::ID;

void inputWebFileGeoPointLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  TlStoreBinary::store(zoom_, s);
  TlStoreBinary::store(scale_, s);
}

void inputWebFileGeoPointLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_point_, s);
  TlStoreBinary::store(access_hash_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  TlStoreBinary::store(zoom_, s);
  TlStoreBinary::store(scale_, s);
}

void inputWebFileGeoPointLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWebFileGeoPointLocation");
    s.store_object_field("geo_point", static_cast<const BaseObject *>(geo_point_.get()));
    s.store_field("access_hash", access_hash_);
    s.store_field("w", w_);
    s.store_field("h", h_);
    s.store_field("zoom", zoom_);
    s.store_field("scale", scale_);
    s.store_class_end();
  }
}

inputWebFileAudioAlbumThumbLocation::inputWebFileAudioAlbumThumbLocation(int32 flags_, bool small_, object_ptr<InputDocument> &&document_, string const &title_, string const &performer_)
  : flags_(flags_)
  , small_(small_)
  , document_(std::move(document_))
  , title_(title_)
  , performer_(performer_)
{}

const std::int32_t inputWebFileAudioAlbumThumbLocation::ID;

void inputWebFileAudioAlbumThumbLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (small_ << 2)), s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(document_, s); }
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 2) { TlStoreString::store(performer_, s); }
}

void inputWebFileAudioAlbumThumbLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (small_ << 2)), s);
  if (var0 & 1) { TlStoreBoxedUnknown<TlStoreObject>::store(document_, s); }
  if (var0 & 2) { TlStoreString::store(title_, s); }
  if (var0 & 2) { TlStoreString::store(performer_, s); }
}

void inputWebFileAudioAlbumThumbLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputWebFileAudioAlbumThumbLocation");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (small_ << 2)));
    if (var0 & 4) { s.store_field("small", true); }
    if (var0 & 1) { s.store_object_field("document", static_cast<const BaseObject *>(document_.get())); }
    if (var0 & 2) { s.store_field("title", title_); }
    if (var0 & 2) { s.store_field("performer", performer_); }
    s.store_class_end();
  }
}

invoice::invoice()
  : flags_()
  , test_()
  , name_requested_()
  , phone_requested_()
  , email_requested_()
  , shipping_address_requested_()
  , flexible_()
  , phone_to_provider_()
  , email_to_provider_()
  , recurring_()
  , currency_()
  , prices_()
  , max_tip_amount_()
  , suggested_tip_amounts_()
  , terms_url_()
  , subscription_period_()
{}

invoice::invoice(int32 flags_, bool test_, bool name_requested_, bool phone_requested_, bool email_requested_, bool shipping_address_requested_, bool flexible_, bool phone_to_provider_, bool email_to_provider_, bool recurring_, string const &currency_, array<object_ptr<labeledPrice>> &&prices_, int64 max_tip_amount_, array<int64> &&suggested_tip_amounts_, string const &terms_url_, int32 subscription_period_)
  : flags_(flags_)
  , test_(test_)
  , name_requested_(name_requested_)
  , phone_requested_(phone_requested_)
  , email_requested_(email_requested_)
  , shipping_address_requested_(shipping_address_requested_)
  , flexible_(flexible_)
  , phone_to_provider_(phone_to_provider_)
  , email_to_provider_(email_to_provider_)
  , recurring_(recurring_)
  , currency_(currency_)
  , prices_(std::move(prices_))
  , max_tip_amount_(max_tip_amount_)
  , suggested_tip_amounts_(std::move(suggested_tip_amounts_))
  , terms_url_(terms_url_)
  , subscription_period_(subscription_period_)
{}

const std::int32_t invoice::ID;

object_ptr<invoice> invoice::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<invoice> res = make_tl_object<invoice>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->test_ = (var0 & 1) != 0;
  res->name_requested_ = (var0 & 2) != 0;
  res->phone_requested_ = (var0 & 4) != 0;
  res->email_requested_ = (var0 & 8) != 0;
  res->shipping_address_requested_ = (var0 & 16) != 0;
  res->flexible_ = (var0 & 32) != 0;
  res->phone_to_provider_ = (var0 & 64) != 0;
  res->email_to_provider_ = (var0 & 128) != 0;
  res->recurring_ = (var0 & 512) != 0;
  res->currency_ = TlFetchString<string>::parse(p);
  res->prices_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<labeledPrice>, -886477832>>, 481674261>::parse(p);
  if (var0 & 256) { res->max_tip_amount_ = TlFetchLong::parse(p); }
  if (var0 & 256) { res->suggested_tip_amounts_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p); }
  if (var0 & 1024) { res->terms_url_ = TlFetchString<string>::parse(p); }
  if (var0 & 2048) { res->subscription_period_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void invoice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (test_ << 0) | (name_requested_ << 1) | (phone_requested_ << 2) | (email_requested_ << 3) | (shipping_address_requested_ << 4) | (flexible_ << 5) | (phone_to_provider_ << 6) | (email_to_provider_ << 7) | (recurring_ << 9)), s);
  TlStoreString::store(currency_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, -886477832>>, 481674261>::store(prices_, s);
  if (var0 & 256) { TlStoreBinary::store(max_tip_amount_, s); }
  if (var0 & 256) { TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(suggested_tip_amounts_, s); }
  if (var0 & 1024) { TlStoreString::store(terms_url_, s); }
  if (var0 & 2048) { TlStoreBinary::store(subscription_period_, s); }
}

void invoice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (test_ << 0) | (name_requested_ << 1) | (phone_requested_ << 2) | (email_requested_ << 3) | (shipping_address_requested_ << 4) | (flexible_ << 5) | (phone_to_provider_ << 6) | (email_to_provider_ << 7) | (recurring_ << 9)), s);
  TlStoreString::store(currency_, s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, -886477832>>, 481674261>::store(prices_, s);
  if (var0 & 256) { TlStoreBinary::store(max_tip_amount_, s); }
  if (var0 & 256) { TlStoreBoxed<TlStoreVector<TlStoreBinary>, 481674261>::store(suggested_tip_amounts_, s); }
  if (var0 & 1024) { TlStoreString::store(terms_url_, s); }
  if (var0 & 2048) { TlStoreBinary::store(subscription_period_, s); }
}

void invoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "invoice");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (test_ << 0) | (name_requested_ << 1) | (phone_requested_ << 2) | (email_requested_ << 3) | (shipping_address_requested_ << 4) | (flexible_ << 5) | (phone_to_provider_ << 6) | (email_to_provider_ << 7) | (recurring_ << 9)));
    if (var0 & 1) { s.store_field("test", true); }
    if (var0 & 2) { s.store_field("name_requested", true); }
    if (var0 & 4) { s.store_field("phone_requested", true); }
    if (var0 & 8) { s.store_field("email_requested", true); }
    if (var0 & 16) { s.store_field("shipping_address_requested", true); }
    if (var0 & 32) { s.store_field("flexible", true); }
    if (var0 & 64) { s.store_field("phone_to_provider", true); }
    if (var0 & 128) { s.store_field("email_to_provider", true); }
    if (var0 & 512) { s.store_field("recurring", true); }
    s.store_field("currency", currency_);
    { s.store_vector_begin("prices", prices_.size()); for (const auto &_value : prices_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 256) { s.store_field("max_tip_amount", max_tip_amount_); }
    if (var0 & 256) { { s.store_vector_begin("suggested_tip_amounts", suggested_tip_amounts_.size()); for (const auto &_value : suggested_tip_amounts_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 1024) { s.store_field("terms_url", terms_url_); }
    if (var0 & 2048) { s.store_field("subscription_period", subscription_period_); }
    s.store_class_end();
  }
}

object_ptr<IpPort> IpPort::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case ipPort::ID:
      return ipPort::fetch(p);
    case ipPortSecret::ID:
      return ipPortSecret::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t ipPort::ID;

object_ptr<IpPort> ipPort::fetch(TlBufferParser &p) {
  return make_tl_object<ipPort>(p);
}

ipPort::ipPort(TlBufferParser &p)
  : ipv4_(TlFetchInt::parse(p))
  , port_(TlFetchInt::parse(p))
{}

void ipPort::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ipPort");
    s.store_field("ipv4", ipv4_);
    s.store_field("port", port_);
    s.store_class_end();
  }
}

const std::int32_t ipPortSecret::ID;

object_ptr<IpPort> ipPortSecret::fetch(TlBufferParser &p) {
  return make_tl_object<ipPortSecret>(p);
}

ipPortSecret::ipPortSecret(TlBufferParser &p)
  : ipv4_(TlFetchInt::parse(p))
  , port_(TlFetchInt::parse(p))
  , secret_(TlFetchBytes<bytes>::parse(p))
{}

void ipPortSecret::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ipPortSecret");
    s.store_field("ipv4", ipv4_);
    s.store_field("port", port_);
    s.store_bytes_field("secret", secret_);
    s.store_class_end();
  }
}

jsonObjectValue::jsonObjectValue(string const &key_, object_ptr<JSONValue> &&value_)
  : key_(key_)
  , value_(std::move(value_))
{}

const std::int32_t jsonObjectValue::ID;

object_ptr<jsonObjectValue> jsonObjectValue::fetch(TlBufferParser &p) {
  return make_tl_object<jsonObjectValue>(p);
}

jsonObjectValue::jsonObjectValue(TlBufferParser &p)
  : key_(TlFetchString<string>::parse(p))
  , value_(TlFetchObject<JSONValue>::parse(p))
{}

void jsonObjectValue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(key_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(value_, s);
}

void jsonObjectValue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(key_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(value_, s);
}

void jsonObjectValue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonObjectValue");
    s.store_field("key", key_);
    s.store_object_field("value", static_cast<const BaseObject *>(value_.get()));
    s.store_class_end();
  }
}

object_ptr<JSONValue> JSONValue::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case jsonNull::ID:
      return jsonNull::fetch(p);
    case jsonBool::ID:
      return jsonBool::fetch(p);
    case jsonNumber::ID:
      return jsonNumber::fetch(p);
    case jsonString::ID:
      return jsonString::fetch(p);
    case jsonArray::ID:
      return jsonArray::fetch(p);
    case jsonObject::ID:
      return jsonObject::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t jsonNull::ID;

object_ptr<JSONValue> jsonNull::fetch(TlBufferParser &p) {
  return make_tl_object<jsonNull>();
}

void jsonNull::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void jsonNull::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void jsonNull::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonNull");
    s.store_class_end();
  }
}

jsonBool::jsonBool(bool value_)
  : value_(value_)
{}

const std::int32_t jsonBool::ID;

object_ptr<JSONValue> jsonBool::fetch(TlBufferParser &p) {
  return make_tl_object<jsonBool>(p);
}

jsonBool::jsonBool(TlBufferParser &p)
  : value_(TlFetchBool::parse(p))
{}

void jsonBool::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBool::store(value_, s);
}

void jsonBool::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBool::store(value_, s);
}

void jsonBool::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonBool");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonNumber::jsonNumber(double value_)
  : value_(value_)
{}

const std::int32_t jsonNumber::ID;

object_ptr<JSONValue> jsonNumber::fetch(TlBufferParser &p) {
  return make_tl_object<jsonNumber>(p);
}

jsonNumber::jsonNumber(TlBufferParser &p)
  : value_(TlFetchDouble::parse(p))
{}

void jsonNumber::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(value_, s);
}

void jsonNumber::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(value_, s);
}

void jsonNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonNumber");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonString::jsonString(string const &value_)
  : value_(value_)
{}

const std::int32_t jsonString::ID;

object_ptr<JSONValue> jsonString::fetch(TlBufferParser &p) {
  return make_tl_object<jsonString>(p);
}

jsonString::jsonString(TlBufferParser &p)
  : value_(TlFetchString<string>::parse(p))
{}

void jsonString::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(value_, s);
}

void jsonString::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(value_, s);
}

void jsonString::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonString");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonArray::jsonArray(array<object_ptr<JSONValue>> &&value_)
  : value_(std::move(value_))
{}

const std::int32_t jsonArray::ID;

object_ptr<JSONValue> jsonArray::fetch(TlBufferParser &p) {
  return make_tl_object<jsonArray>(p);
}

jsonArray::jsonArray(TlBufferParser &p)
  : value_(TlFetchBoxed<TlFetchVector<TlFetchObject<JSONValue>>, 481674261>::parse(p))
{}

void jsonArray::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(value_, s);
}

void jsonArray::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(value_, s);
}

void jsonArray::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonArray");
    { s.store_vector_begin("value", value_.size()); for (const auto &_value : value_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

jsonObject::jsonObject(array<object_ptr<jsonObjectValue>> &&value_)
  : value_(std::move(value_))
{}

const std::int32_t jsonObject::ID;

object_ptr<JSONValue> jsonObject::fetch(TlBufferParser &p) {
  return make_tl_object<jsonObject>(p);
}

jsonObject::jsonObject(TlBufferParser &p)
  : value_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<jsonObjectValue>, -1059185703>>, 481674261>::parse(p))
{}

void jsonObject::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, -1059185703>>, 481674261>::store(value_, s);
}

void jsonObject::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxed<TlStoreObject, -1059185703>>, 481674261>::store(value_, s);
}

void jsonObject::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonObject");
    { s.store_vector_begin("value", value_.size()); for (const auto &_value : value_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<KeyboardButton> KeyboardButton::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case keyboardButton::ID:
      return keyboardButton::fetch(p);
    case keyboardButtonUrl::ID:
      return keyboardButtonUrl::fetch(p);
    case keyboardButtonCallback::ID:
      return keyboardButtonCallback::fetch(p);
    case keyboardButtonRequestPhone::ID:
      return keyboardButtonRequestPhone::fetch(p);
    case keyboardButtonRequestGeoLocation::ID:
      return keyboardButtonRequestGeoLocation::fetch(p);
    case keyboardButtonSwitchInline::ID:
      return keyboardButtonSwitchInline::fetch(p);
    case keyboardButtonGame::ID:
      return keyboardButtonGame::fetch(p);
    case keyboardButtonBuy::ID:
      return keyboardButtonBuy::fetch(p);
    case keyboardButtonUrlAuth::ID:
      return keyboardButtonUrlAuth::fetch(p);
    case inputKeyboardButtonUrlAuth::ID:
      return inputKeyboardButtonUrlAuth::fetch(p);
    case keyboardButtonRequestPoll::ID:
      return keyboardButtonRequestPoll::fetch(p);
    case inputKeyboardButtonUserProfile::ID:
      return inputKeyboardButtonUserProfile::fetch(p);
    case keyboardButtonUserProfile::ID:
      return keyboardButtonUserProfile::fetch(p);
    case keyboardButtonWebView::ID:
      return keyboardButtonWebView::fetch(p);
    case keyboardButtonSimpleWebView::ID:
      return keyboardButtonSimpleWebView::fetch(p);
    case keyboardButtonRequestPeer::ID:
      return keyboardButtonRequestPeer::fetch(p);
    case inputKeyboardButtonRequestPeer::ID:
      return inputKeyboardButtonRequestPeer::fetch(p);
    case keyboardButtonCopy::ID:
      return keyboardButtonCopy::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

keyboardButton::keyboardButton(string const &text_)
  : text_(text_)
{}

const std::int32_t keyboardButton::ID;

object_ptr<KeyboardButton> keyboardButton::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButton>(p);
}

keyboardButton::keyboardButton(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void keyboardButton::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButton::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButton");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

keyboardButtonUrl::keyboardButtonUrl(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t keyboardButtonUrl::ID;

object_ptr<KeyboardButton> keyboardButtonUrl::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonUrl>(p);
}

keyboardButtonUrl::keyboardButtonUrl(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void keyboardButtonUrl::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonUrl::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonUrl");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

keyboardButtonCallback::keyboardButtonCallback()
  : flags_()
  , requires_password_()
  , text_()
  , data_()
{}

keyboardButtonCallback::keyboardButtonCallback(int32 flags_, bool requires_password_, string const &text_, bytes &&data_)
  : flags_(flags_)
  , requires_password_(requires_password_)
  , text_(text_)
  , data_(std::move(data_))
{}

const std::int32_t keyboardButtonCallback::ID;

object_ptr<KeyboardButton> keyboardButtonCallback::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<keyboardButtonCallback> res = make_tl_object<keyboardButtonCallback>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->requires_password_ = (var0 & 1) != 0;
  res->text_ = TlFetchString<string>::parse(p);
  res->data_ = TlFetchBytes<bytes>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void keyboardButtonCallback::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (requires_password_ << 0)), s);
  TlStoreString::store(text_, s);
  TlStoreString::store(data_, s);
}

void keyboardButtonCallback::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (requires_password_ << 0)), s);
  TlStoreString::store(text_, s);
  TlStoreString::store(data_, s);
}

void keyboardButtonCallback::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonCallback");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (requires_password_ << 0)));
    if (var0 & 1) { s.store_field("requires_password", true); }
    s.store_field("text", text_);
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

keyboardButtonRequestPhone::keyboardButtonRequestPhone(string const &text_)
  : text_(text_)
{}

const std::int32_t keyboardButtonRequestPhone::ID;

object_ptr<KeyboardButton> keyboardButtonRequestPhone::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonRequestPhone>(p);
}

keyboardButtonRequestPhone::keyboardButtonRequestPhone(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void keyboardButtonRequestPhone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestPhone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestPhone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonRequestPhone");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

keyboardButtonRequestGeoLocation::keyboardButtonRequestGeoLocation(string const &text_)
  : text_(text_)
{}

const std::int32_t keyboardButtonRequestGeoLocation::ID;

object_ptr<KeyboardButton> keyboardButtonRequestGeoLocation::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonRequestGeoLocation>(p);
}

keyboardButtonRequestGeoLocation::keyboardButtonRequestGeoLocation(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void keyboardButtonRequestGeoLocation::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestGeoLocation::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestGeoLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonRequestGeoLocation");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

keyboardButtonSwitchInline::keyboardButtonSwitchInline()
  : flags_()
  , same_peer_()
  , text_()
  , query_()
  , peer_types_()
{}

keyboardButtonSwitchInline::keyboardButtonSwitchInline(int32 flags_, bool same_peer_, string const &text_, string const &query_, array<object_ptr<InlineQueryPeerType>> &&peer_types_)
  : flags_(flags_)
  , same_peer_(same_peer_)
  , text_(text_)
  , query_(query_)
  , peer_types_(std::move(peer_types_))
{}

const std::int32_t keyboardButtonSwitchInline::ID;

object_ptr<KeyboardButton> keyboardButtonSwitchInline::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<keyboardButtonSwitchInline> res = make_tl_object<keyboardButtonSwitchInline>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->same_peer_ = (var0 & 1) != 0;
  res->text_ = TlFetchString<string>::parse(p);
  res->query_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->peer_types_ = TlFetchBoxed<TlFetchVector<TlFetchObject<InlineQueryPeerType>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void keyboardButtonSwitchInline::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (same_peer_ << 0)), s);
  TlStoreString::store(text_, s);
  TlStoreString::store(query_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(peer_types_, s); }
}

void keyboardButtonSwitchInline::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (same_peer_ << 0)), s);
  TlStoreString::store(text_, s);
  TlStoreString::store(query_, s);
  if (var0 & 2) { TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(peer_types_, s); }
}

void keyboardButtonSwitchInline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonSwitchInline");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (same_peer_ << 0)));
    if (var0 & 1) { s.store_field("same_peer", true); }
    s.store_field("text", text_);
    s.store_field("query", query_);
    if (var0 & 2) { { s.store_vector_begin("peer_types", peer_types_.size()); for (const auto &_value : peer_types_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

keyboardButtonGame::keyboardButtonGame(string const &text_)
  : text_(text_)
{}

const std::int32_t keyboardButtonGame::ID;

object_ptr<KeyboardButton> keyboardButtonGame::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonGame>(p);
}

keyboardButtonGame::keyboardButtonGame(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void keyboardButtonGame::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonGame::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonGame");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

keyboardButtonBuy::keyboardButtonBuy(string const &text_)
  : text_(text_)
{}

const std::int32_t keyboardButtonBuy::ID;

object_ptr<KeyboardButton> keyboardButtonBuy::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonBuy>(p);
}

keyboardButtonBuy::keyboardButtonBuy(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void keyboardButtonBuy::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonBuy::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
}

void keyboardButtonBuy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonBuy");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

keyboardButtonUrlAuth::keyboardButtonUrlAuth()
  : flags_()
  , text_()
  , fwd_text_()
  , url_()
  , button_id_()
{}

keyboardButtonUrlAuth::keyboardButtonUrlAuth(int32 flags_, string const &text_, string const &fwd_text_, string const &url_, int32 button_id_)
  : flags_(flags_)
  , text_(text_)
  , fwd_text_(fwd_text_)
  , url_(url_)
  , button_id_(button_id_)
{}

const std::int32_t keyboardButtonUrlAuth::ID;

object_ptr<KeyboardButton> keyboardButtonUrlAuth::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<keyboardButtonUrlAuth> res = make_tl_object<keyboardButtonUrlAuth>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->text_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->fwd_text_ = TlFetchString<string>::parse(p); }
  res->url_ = TlFetchString<string>::parse(p);
  res->button_id_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void keyboardButtonUrlAuth::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(text_, s);
  if (var0 & 1) { TlStoreString::store(fwd_text_, s); }
  TlStoreString::store(url_, s);
  TlStoreBinary::store(button_id_, s);
}

void keyboardButtonUrlAuth::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreString::store(text_, s);
  if (var0 & 1) { TlStoreString::store(fwd_text_, s); }
  TlStoreString::store(url_, s);
  TlStoreBinary::store(button_id_, s);
}

void keyboardButtonUrlAuth::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonUrlAuth");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("text", text_);
    if (var0 & 1) { s.store_field("fwd_text", fwd_text_); }
    s.store_field("url", url_);
    s.store_field("button_id", button_id_);
    s.store_class_end();
  }
}

inputKeyboardButtonUrlAuth::inputKeyboardButtonUrlAuth()
  : flags_()
  , request_write_access_()
  , text_()
  , fwd_text_()
  , url_()
  , bot_()
{}

inputKeyboardButtonUrlAuth::inputKeyboardButtonUrlAuth(int32 flags_, bool request_write_access_, string const &text_, string const &fwd_text_, string const &url_, object_ptr<InputUser> &&bot_)
  : flags_(flags_)
  , request_write_access_(request_write_access_)
  , text_(text_)
  , fwd_text_(fwd_text_)
  , url_(url_)
  , bot_(std::move(bot_))
{}

const std::int32_t inputKeyboardButtonUrlAuth::ID;

object_ptr<KeyboardButton> inputKeyboardButtonUrlAuth::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputKeyboardButtonUrlAuth> res = make_tl_object<inputKeyboardButtonUrlAuth>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->request_write_access_ = (var0 & 1) != 0;
  res->text_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->fwd_text_ = TlFetchString<string>::parse(p); }
  res->url_ = TlFetchString<string>::parse(p);
  res->bot_ = TlFetchObject<InputUser>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputKeyboardButtonUrlAuth::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (request_write_access_ << 0)), s);
  TlStoreString::store(text_, s);
  if (var0 & 2) { TlStoreString::store(fwd_text_, s); }
  TlStoreString::store(url_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_, s);
}

void inputKeyboardButtonUrlAuth::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (request_write_access_ << 0)), s);
  TlStoreString::store(text_, s);
  if (var0 & 2) { TlStoreString::store(fwd_text_, s); }
  TlStoreString::store(url_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(bot_, s);
}

void inputKeyboardButtonUrlAuth::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputKeyboardButtonUrlAuth");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (request_write_access_ << 0)));
    if (var0 & 1) { s.store_field("request_write_access", true); }
    s.store_field("text", text_);
    if (var0 & 2) { s.store_field("fwd_text", fwd_text_); }
    s.store_field("url", url_);
    s.store_object_field("bot", static_cast<const BaseObject *>(bot_.get()));
    s.store_class_end();
  }
}

keyboardButtonRequestPoll::keyboardButtonRequestPoll()
  : flags_()
  , quiz_()
  , text_()
{}

keyboardButtonRequestPoll::keyboardButtonRequestPoll(int32 flags_, bool quiz_, string const &text_)
  : flags_(flags_)
  , quiz_(quiz_)
  , text_(text_)
{}

const std::int32_t keyboardButtonRequestPoll::ID;

object_ptr<KeyboardButton> keyboardButtonRequestPoll::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<keyboardButtonRequestPoll> res = make_tl_object<keyboardButtonRequestPoll>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->quiz_ = TlFetchBool::parse(p); }
  res->text_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void keyboardButtonRequestPoll::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBool::store(quiz_, s); }
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestPoll::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreBool::store(quiz_, s); }
  TlStoreString::store(text_, s);
}

void keyboardButtonRequestPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonRequestPoll");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("quiz", quiz_); }
    s.store_field("text", text_);
    s.store_class_end();
  }
}

inputKeyboardButtonUserProfile::inputKeyboardButtonUserProfile(string const &text_, object_ptr<InputUser> &&user_id_)
  : text_(text_)
  , user_id_(std::move(user_id_))
{}

const std::int32_t inputKeyboardButtonUserProfile::ID;

object_ptr<KeyboardButton> inputKeyboardButtonUserProfile::fetch(TlBufferParser &p) {
  return make_tl_object<inputKeyboardButtonUserProfile>(p);
}

inputKeyboardButtonUserProfile::inputKeyboardButtonUserProfile(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , user_id_(TlFetchObject<InputUser>::parse(p))
{}

void inputKeyboardButtonUserProfile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void inputKeyboardButtonUserProfile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void inputKeyboardButtonUserProfile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputKeyboardButtonUserProfile");
    s.store_field("text", text_);
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_class_end();
  }
}

keyboardButtonUserProfile::keyboardButtonUserProfile(string const &text_, int64 user_id_)
  : text_(text_)
  , user_id_(user_id_)
{}

const std::int32_t keyboardButtonUserProfile::ID;

object_ptr<KeyboardButton> keyboardButtonUserProfile::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonUserProfile>(p);
}

keyboardButtonUserProfile::keyboardButtonUserProfile(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , user_id_(TlFetchLong::parse(p))
{}

void keyboardButtonUserProfile::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(user_id_, s);
}

void keyboardButtonUserProfile::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(user_id_, s);
}

void keyboardButtonUserProfile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonUserProfile");
    s.store_field("text", text_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

keyboardButtonWebView::keyboardButtonWebView(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t keyboardButtonWebView::ID;

object_ptr<KeyboardButton> keyboardButtonWebView::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonWebView>(p);
}

keyboardButtonWebView::keyboardButtonWebView(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void keyboardButtonWebView::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonWebView::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonWebView::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonWebView");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

keyboardButtonSimpleWebView::keyboardButtonSimpleWebView(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t keyboardButtonSimpleWebView::ID;

object_ptr<KeyboardButton> keyboardButtonSimpleWebView::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonSimpleWebView>(p);
}

keyboardButtonSimpleWebView::keyboardButtonSimpleWebView(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void keyboardButtonSimpleWebView::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonSimpleWebView::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(url_, s);
}

void keyboardButtonSimpleWebView::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonSimpleWebView");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

keyboardButtonRequestPeer::keyboardButtonRequestPeer(string const &text_, int32 button_id_, object_ptr<RequestPeerType> &&peer_type_, int32 max_quantity_)
  : text_(text_)
  , button_id_(button_id_)
  , peer_type_(std::move(peer_type_))
  , max_quantity_(max_quantity_)
{}

const std::int32_t keyboardButtonRequestPeer::ID;

object_ptr<KeyboardButton> keyboardButtonRequestPeer::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonRequestPeer>(p);
}

keyboardButtonRequestPeer::keyboardButtonRequestPeer(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , button_id_(TlFetchInt::parse(p))
  , peer_type_(TlFetchObject<RequestPeerType>::parse(p))
  , max_quantity_(TlFetchInt::parse(p))
{}

void keyboardButtonRequestPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(button_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_type_, s);
  TlStoreBinary::store(max_quantity_, s);
}

void keyboardButtonRequestPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(button_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_type_, s);
  TlStoreBinary::store(max_quantity_, s);
}

void keyboardButtonRequestPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonRequestPeer");
    s.store_field("text", text_);
    s.store_field("button_id", button_id_);
    s.store_object_field("peer_type", static_cast<const BaseObject *>(peer_type_.get()));
    s.store_field("max_quantity", max_quantity_);
    s.store_class_end();
  }
}

inputKeyboardButtonRequestPeer::inputKeyboardButtonRequestPeer()
  : flags_()
  , name_requested_()
  , username_requested_()
  , photo_requested_()
  , text_()
  , button_id_()
  , peer_type_()
  , max_quantity_()
{}

inputKeyboardButtonRequestPeer::inputKeyboardButtonRequestPeer(int32 flags_, bool name_requested_, bool username_requested_, bool photo_requested_, string const &text_, int32 button_id_, object_ptr<RequestPeerType> &&peer_type_, int32 max_quantity_)
  : flags_(flags_)
  , name_requested_(name_requested_)
  , username_requested_(username_requested_)
  , photo_requested_(photo_requested_)
  , text_(text_)
  , button_id_(button_id_)
  , peer_type_(std::move(peer_type_))
  , max_quantity_(max_quantity_)
{}

const std::int32_t inputKeyboardButtonRequestPeer::ID;

object_ptr<KeyboardButton> inputKeyboardButtonRequestPeer::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputKeyboardButtonRequestPeer> res = make_tl_object<inputKeyboardButtonRequestPeer>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->name_requested_ = (var0 & 1) != 0;
  res->username_requested_ = (var0 & 2) != 0;
  res->photo_requested_ = (var0 & 4) != 0;
  res->text_ = TlFetchString<string>::parse(p);
  res->button_id_ = TlFetchInt::parse(p);
  res->peer_type_ = TlFetchObject<RequestPeerType>::parse(p);
  res->max_quantity_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputKeyboardButtonRequestPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (name_requested_ << 0) | (username_requested_ << 1) | (photo_requested_ << 2)), s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(button_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_type_, s);
  TlStoreBinary::store(max_quantity_, s);
}

void inputKeyboardButtonRequestPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (name_requested_ << 0) | (username_requested_ << 1) | (photo_requested_ << 2)), s);
  TlStoreString::store(text_, s);
  TlStoreBinary::store(button_id_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_type_, s);
  TlStoreBinary::store(max_quantity_, s);
}

void inputKeyboardButtonRequestPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputKeyboardButtonRequestPeer");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (name_requested_ << 0) | (username_requested_ << 1) | (photo_requested_ << 2)));
    if (var0 & 1) { s.store_field("name_requested", true); }
    if (var0 & 2) { s.store_field("username_requested", true); }
    if (var0 & 4) { s.store_field("photo_requested", true); }
    s.store_field("text", text_);
    s.store_field("button_id", button_id_);
    s.store_object_field("peer_type", static_cast<const BaseObject *>(peer_type_.get()));
    s.store_field("max_quantity", max_quantity_);
    s.store_class_end();
  }
}

keyboardButtonCopy::keyboardButtonCopy(string const &text_, string const &copy_text_)
  : text_(text_)
  , copy_text_(copy_text_)
{}

const std::int32_t keyboardButtonCopy::ID;

object_ptr<KeyboardButton> keyboardButtonCopy::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonCopy>(p);
}

keyboardButtonCopy::keyboardButtonCopy(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , copy_text_(TlFetchString<string>::parse(p))
{}

void keyboardButtonCopy::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(copy_text_, s);
}

void keyboardButtonCopy::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(text_, s);
  TlStoreString::store(copy_text_, s);
}

void keyboardButtonCopy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonCopy");
    s.store_field("text", text_);
    s.store_field("copy_text", copy_text_);
    s.store_class_end();
  }
}

keyboardButtonRow::keyboardButtonRow(array<object_ptr<KeyboardButton>> &&buttons_)
  : buttons_(std::move(buttons_))
{}

const std::int32_t keyboardButtonRow::ID;

object_ptr<keyboardButtonRow> keyboardButtonRow::fetch(TlBufferParser &p) {
  return make_tl_object<keyboardButtonRow>(p);
}

keyboardButtonRow::keyboardButtonRow(TlBufferParser &p)
  : buttons_(TlFetchBoxed<TlFetchVector<TlFetchObject<KeyboardButton>>, 481674261>::parse(p))
{}

void keyboardButtonRow::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(buttons_, s);
}

void keyboardButtonRow::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreVector<TlStoreBoxedUnknown<TlStoreObject>>, 481674261>::store(buttons_, s);
}

void keyboardButtonRow::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonRow");
    { s.store_vector_begin("buttons", buttons_.size()); for (const auto &_value : buttons_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

labeledPrice::labeledPrice(string const &label_, int64 amount_)
  : label_(label_)
  , amount_(amount_)
{}

const std::int32_t labeledPrice::ID;

object_ptr<labeledPrice> labeledPrice::fetch(TlBufferParser &p) {
  return make_tl_object<labeledPrice>(p);
}

labeledPrice::labeledPrice(TlBufferParser &p)
  : label_(TlFetchString<string>::parse(p))
  , amount_(TlFetchLong::parse(p))
{}

void labeledPrice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(label_, s);
  TlStoreBinary::store(amount_, s);
}

void labeledPrice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(label_, s);
  TlStoreBinary::store(amount_, s);
}

void labeledPrice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "labeledPrice");
    s.store_field("label", label_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

const std::int32_t langPackDifference::ID;

object_ptr<langPackDifference> langPackDifference::fetch(TlBufferParser &p) {
  return make_tl_object<langPackDifference>(p);
}

langPackDifference::langPackDifference(TlBufferParser &p)
  : lang_code_(TlFetchString<string>::parse(p))
  , from_version_(TlFetchInt::parse(p))
  , version_(TlFetchInt::parse(p))
  , strings_(TlFetchBoxed<TlFetchVector<TlFetchObject<LangPackString>>, 481674261>::parse(p))
{}

void langPackDifference::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "langPackDifference");
    s.store_field("lang_code", lang_code_);
    s.store_field("from_version", from_version_);
    s.store_field("version", version_);
    { s.store_vector_begin("strings", strings_.size()); for (const auto &_value : strings_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

langPackLanguage::langPackLanguage()
  : flags_()
  , official_()
  , rtl_()
  , beta_()
  , name_()
  , native_name_()
  , lang_code_()
  , base_lang_code_()
  , plural_code_()
  , strings_count_()
  , translated_count_()
  , translations_url_()
{}

const std::int32_t langPackLanguage::ID;

object_ptr<langPackLanguage> langPackLanguage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<langPackLanguage> res = make_tl_object<langPackLanguage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->official_ = (var0 & 1) != 0;
  res->rtl_ = (var0 & 4) != 0;
  res->beta_ = (var0 & 8) != 0;
  res->name_ = TlFetchString<string>::parse(p);
  res->native_name_ = TlFetchString<string>::parse(p);
  res->lang_code_ = TlFetchString<string>::parse(p);
  if (var0 & 2) { res->base_lang_code_ = TlFetchString<string>::parse(p); }
  res->plural_code_ = TlFetchString<string>::parse(p);
  res->strings_count_ = TlFetchInt::parse(p);
  res->translated_count_ = TlFetchInt::parse(p);
  res->translations_url_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void langPackLanguage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "langPackLanguage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (official_ << 0) | (rtl_ << 2) | (beta_ << 3)));
    if (var0 & 1) { s.store_field("official", true); }
    if (var0 & 4) { s.store_field("rtl", true); }
    if (var0 & 8) { s.store_field("beta", true); }
    s.store_field("name", name_);
    s.store_field("native_name", native_name_);
    s.store_field("lang_code", lang_code_);
    if (var0 & 2) { s.store_field("base_lang_code", base_lang_code_); }
    s.store_field("plural_code", plural_code_);
    s.store_field("strings_count", strings_count_);
    s.store_field("translated_count", translated_count_);
    s.store_field("translations_url", translations_url_);
    s.store_class_end();
  }
}

object_ptr<LangPackString> LangPackString::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case langPackString::ID:
      return langPackString::fetch(p);
    case langPackStringPluralized::ID:
      return langPackStringPluralized::fetch(p);
    case langPackStringDeleted::ID:
      return langPackStringDeleted::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

langPackString::langPackString(string const &key_, string const &value_)
  : key_(key_)
  , value_(value_)
{}

const std::int32_t langPackString::ID;

object_ptr<LangPackString> langPackString::fetch(TlBufferParser &p) {
  return make_tl_object<langPackString>(p);
}

langPackString::langPackString(TlBufferParser &p)
  : key_(TlFetchString<string>::parse(p))
  , value_(TlFetchString<string>::parse(p))
{}

void langPackString::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "langPackString");
    s.store_field("key", key_);
    s.store_field("value", value_);
    s.store_class_end();
  }
}

langPackStringPluralized::langPackStringPluralized()
  : flags_()
  , key_()
  , zero_value_()
  , one_value_()
  , two_value_()
  , few_value_()
  , many_value_()
  , other_value_()
{}

langPackStringPluralized::langPackStringPluralized(int32 flags_, string const &key_, string const &zero_value_, string const &one_value_, string const &two_value_, string const &few_value_, string const &many_value_, string const &other_value_)
  : flags_(flags_)
  , key_(key_)
  , zero_value_(zero_value_)
  , one_value_(one_value_)
  , two_value_(two_value_)
  , few_value_(few_value_)
  , many_value_(many_value_)
  , other_value_(other_value_)
{}

const std::int32_t langPackStringPluralized::ID;

object_ptr<LangPackString> langPackStringPluralized::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<langPackStringPluralized> res = make_tl_object<langPackStringPluralized>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->key_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->zero_value_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->one_value_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->two_value_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->few_value_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->many_value_ = TlFetchString<string>::parse(p); }
  res->other_value_ = TlFetchString<string>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void langPackStringPluralized::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "langPackStringPluralized");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("key", key_);
    if (var0 & 1) { s.store_field("zero_value", zero_value_); }
    if (var0 & 2) { s.store_field("one_value", one_value_); }
    if (var0 & 4) { s.store_field("two_value", two_value_); }
    if (var0 & 8) { s.store_field("few_value", few_value_); }
    if (var0 & 16) { s.store_field("many_value", many_value_); }
    s.store_field("other_value", other_value_);
    s.store_class_end();
  }
}

langPackStringDeleted::langPackStringDeleted(string const &key_)
  : key_(key_)
{}

const std::int32_t langPackStringDeleted::ID;

object_ptr<LangPackString> langPackStringDeleted::fetch(TlBufferParser &p) {
  return make_tl_object<langPackStringDeleted>(p);
}

langPackStringDeleted::langPackStringDeleted(TlBufferParser &p)
  : key_(TlFetchString<string>::parse(p))
{}

void langPackStringDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "langPackStringDeleted");
    s.store_field("key", key_);
    s.store_class_end();
  }
}

maskCoords::maskCoords(int32 n_, double x_, double y_, double zoom_)
  : n_(n_)
  , x_(x_)
  , y_(y_)
  , zoom_(zoom_)
{}

const std::int32_t maskCoords::ID;

object_ptr<maskCoords> maskCoords::fetch(TlBufferParser &p) {
  return make_tl_object<maskCoords>(p);
}

maskCoords::maskCoords(TlBufferParser &p)
  : n_(TlFetchInt::parse(p))
  , x_(TlFetchDouble::parse(p))
  , y_(TlFetchDouble::parse(p))
  , zoom_(TlFetchDouble::parse(p))
{}

void maskCoords::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(n_, s);
  TlStoreBinary::store(x_, s);
  TlStoreBinary::store(y_, s);
  TlStoreBinary::store(zoom_, s);
}

void maskCoords::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(n_, s);
  TlStoreBinary::store(x_, s);
  TlStoreBinary::store(y_, s);
  TlStoreBinary::store(zoom_, s);
}

void maskCoords::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskCoords");
    s.store_field("n", n_);
    s.store_field("x", x_);
    s.store_field("y", y_);
    s.store_field("zoom", zoom_);
    s.store_class_end();
  }
}

object_ptr<MediaArea> MediaArea::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case mediaAreaVenue::ID:
      return mediaAreaVenue::fetch(p);
    case inputMediaAreaVenue::ID:
      return inputMediaAreaVenue::fetch(p);
    case mediaAreaGeoPoint::ID:
      return mediaAreaGeoPoint::fetch(p);
    case mediaAreaSuggestedReaction::ID:
      return mediaAreaSuggestedReaction::fetch(p);
    case mediaAreaChannelPost::ID:
      return mediaAreaChannelPost::fetch(p);
    case inputMediaAreaChannelPost::ID:
      return inputMediaAreaChannelPost::fetch(p);
    case mediaAreaUrl::ID:
      return mediaAreaUrl::fetch(p);
    case mediaAreaWeather::ID:
      return mediaAreaWeather::fetch(p);
    case mediaAreaStarGift::ID:
      return mediaAreaStarGift::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

mediaAreaVenue::mediaAreaVenue(object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<GeoPoint> &&geo_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_)
  : coordinates_(std::move(coordinates_))
  , geo_(std::move(geo_))
  , title_(title_)
  , address_(address_)
  , provider_(provider_)
  , venue_id_(venue_id_)
  , venue_type_(venue_type_)
{}

const std::int32_t mediaAreaVenue::ID;

object_ptr<MediaArea> mediaAreaVenue::fetch(TlBufferParser &p) {
  return make_tl_object<mediaAreaVenue>(p);
}

mediaAreaVenue::mediaAreaVenue(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , geo_(TlFetchObject<GeoPoint>::parse(p))
  , title_(TlFetchString<string>::parse(p))
  , address_(TlFetchString<string>::parse(p))
  , provider_(TlFetchString<string>::parse(p))
  , venue_id_(TlFetchString<string>::parse(p))
  , venue_type_(TlFetchString<string>::parse(p))
{}

void mediaAreaVenue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
}

void mediaAreaVenue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_, s);
  TlStoreString::store(title_, s);
  TlStoreString::store(address_, s);
  TlStoreString::store(provider_, s);
  TlStoreString::store(venue_id_, s);
  TlStoreString::store(venue_type_, s);
}

void mediaAreaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaVenue");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    s.store_field("title", title_);
    s.store_field("address", address_);
    s.store_field("provider", provider_);
    s.store_field("venue_id", venue_id_);
    s.store_field("venue_type", venue_type_);
    s.store_class_end();
  }
}

inputMediaAreaVenue::inputMediaAreaVenue(object_ptr<mediaAreaCoordinates> &&coordinates_, int64 query_id_, string const &result_id_)
  : coordinates_(std::move(coordinates_))
  , query_id_(query_id_)
  , result_id_(result_id_)
{}

const std::int32_t inputMediaAreaVenue::ID;

object_ptr<MediaArea> inputMediaAreaVenue::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaAreaVenue>(p);
}

inputMediaAreaVenue::inputMediaAreaVenue(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , query_id_(TlFetchLong::parse(p))
  , result_id_(TlFetchString<string>::parse(p))
{}

void inputMediaAreaVenue::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBinary::store(query_id_, s);
  TlStoreString::store(result_id_, s);
}

void inputMediaAreaVenue::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBinary::store(query_id_, s);
  TlStoreString::store(result_id_, s);
}

void inputMediaAreaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaAreaVenue");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_field("query_id", query_id_);
    s.store_field("result_id", result_id_);
    s.store_class_end();
  }
}

mediaAreaGeoPoint::mediaAreaGeoPoint()
  : flags_()
  , coordinates_()
  , geo_()
  , address_()
{}

mediaAreaGeoPoint::mediaAreaGeoPoint(int32 flags_, object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<GeoPoint> &&geo_, object_ptr<geoPointAddress> &&address_)
  : flags_(flags_)
  , coordinates_(std::move(coordinates_))
  , geo_(std::move(geo_))
  , address_(std::move(address_))
{}

const std::int32_t mediaAreaGeoPoint::ID;

object_ptr<MediaArea> mediaAreaGeoPoint::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<mediaAreaGeoPoint> res = make_tl_object<mediaAreaGeoPoint>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->coordinates_ = TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p);
  res->geo_ = TlFetchObject<GeoPoint>::parse(p);
  if (var0 & 1) { res->address_ = TlFetchBoxed<TlFetchObject<geoPointAddress>, -565420653>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void mediaAreaGeoPoint::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -565420653>::store(address_, s); }
}

void mediaAreaGeoPoint::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(geo_, s);
  if (var0 & 1) { TlStoreBoxed<TlStoreObject, -565420653>::store(address_, s); }
}

void mediaAreaGeoPoint::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaGeoPoint");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    if (var0 & 1) { s.store_object_field("address", static_cast<const BaseObject *>(address_.get())); }
    s.store_class_end();
  }
}

mediaAreaSuggestedReaction::mediaAreaSuggestedReaction()
  : flags_()
  , dark_()
  , flipped_()
  , coordinates_()
  , reaction_()
{}

mediaAreaSuggestedReaction::mediaAreaSuggestedReaction(int32 flags_, bool dark_, bool flipped_, object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<Reaction> &&reaction_)
  : flags_(flags_)
  , dark_(dark_)
  , flipped_(flipped_)
  , coordinates_(std::move(coordinates_))
  , reaction_(std::move(reaction_))
{}

const std::int32_t mediaAreaSuggestedReaction::ID;

object_ptr<MediaArea> mediaAreaSuggestedReaction::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<mediaAreaSuggestedReaction> res = make_tl_object<mediaAreaSuggestedReaction>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->dark_ = (var0 & 1) != 0;
  res->flipped_ = (var0 & 2) != 0;
  res->coordinates_ = TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p);
  res->reaction_ = TlFetchObject<Reaction>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void mediaAreaSuggestedReaction::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (dark_ << 0) | (flipped_ << 1)), s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(reaction_, s);
}

void mediaAreaSuggestedReaction::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (dark_ << 0) | (flipped_ << 1)), s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(reaction_, s);
}

void mediaAreaSuggestedReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaSuggestedReaction");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (dark_ << 0) | (flipped_ << 1)));
    if (var0 & 1) { s.store_field("dark", true); }
    if (var0 & 2) { s.store_field("flipped", true); }
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_object_field("reaction", static_cast<const BaseObject *>(reaction_.get()));
    s.store_class_end();
  }
}

mediaAreaChannelPost::mediaAreaChannelPost(object_ptr<mediaAreaCoordinates> &&coordinates_, int64 channel_id_, int32 msg_id_)
  : coordinates_(std::move(coordinates_))
  , channel_id_(channel_id_)
  , msg_id_(msg_id_)
{}

const std::int32_t mediaAreaChannelPost::ID;

object_ptr<MediaArea> mediaAreaChannelPost::fetch(TlBufferParser &p) {
  return make_tl_object<mediaAreaChannelPost>(p);
}

mediaAreaChannelPost::mediaAreaChannelPost(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , channel_id_(TlFetchLong::parse(p))
  , msg_id_(TlFetchInt::parse(p))
{}

void mediaAreaChannelPost::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(msg_id_, s);
}

void mediaAreaChannelPost::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBinary::store(channel_id_, s);
  TlStoreBinary::store(msg_id_, s);
}

void mediaAreaChannelPost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaChannelPost");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_field("channel_id", channel_id_);
    s.store_field("msg_id", msg_id_);
    s.store_class_end();
  }
}

inputMediaAreaChannelPost::inputMediaAreaChannelPost(object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<InputChannel> &&channel_, int32 msg_id_)
  : coordinates_(std::move(coordinates_))
  , channel_(std::move(channel_))
  , msg_id_(msg_id_)
{}

const std::int32_t inputMediaAreaChannelPost::ID;

object_ptr<MediaArea> inputMediaAreaChannelPost::fetch(TlBufferParser &p) {
  return make_tl_object<inputMediaAreaChannelPost>(p);
}

inputMediaAreaChannelPost::inputMediaAreaChannelPost(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , channel_(TlFetchObject<InputChannel>::parse(p))
  , msg_id_(TlFetchInt::parse(p))
{}

void inputMediaAreaChannelPost::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(channel_, s);
  TlStoreBinary::store(msg_id_, s);
}

void inputMediaAreaChannelPost::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(channel_, s);
  TlStoreBinary::store(msg_id_, s);
}

void inputMediaAreaChannelPost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMediaAreaChannelPost");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_object_field("channel", static_cast<const BaseObject *>(channel_.get()));
    s.store_field("msg_id", msg_id_);
    s.store_class_end();
  }
}

mediaAreaUrl::mediaAreaUrl(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &url_)
  : coordinates_(std::move(coordinates_))
  , url_(url_)
{}

const std::int32_t mediaAreaUrl::ID;

object_ptr<MediaArea> mediaAreaUrl::fetch(TlBufferParser &p) {
  return make_tl_object<mediaAreaUrl>(p);
}

mediaAreaUrl::mediaAreaUrl(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void mediaAreaUrl::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(url_, s);
}

void mediaAreaUrl::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(url_, s);
}

void mediaAreaUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaUrl");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_field("url", url_);
    s.store_class_end();
  }
}

mediaAreaWeather::mediaAreaWeather(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &emoji_, double temperature_c_, int32 color_)
  : coordinates_(std::move(coordinates_))
  , emoji_(emoji_)
  , temperature_c_(temperature_c_)
  , color_(color_)
{}

const std::int32_t mediaAreaWeather::ID;

object_ptr<MediaArea> mediaAreaWeather::fetch(TlBufferParser &p) {
  return make_tl_object<mediaAreaWeather>(p);
}

mediaAreaWeather::mediaAreaWeather(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , emoji_(TlFetchString<string>::parse(p))
  , temperature_c_(TlFetchDouble::parse(p))
  , color_(TlFetchInt::parse(p))
{}

void mediaAreaWeather::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(emoji_, s);
  TlStoreBinary::store(temperature_c_, s);
  TlStoreBinary::store(color_, s);
}

void mediaAreaWeather::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(emoji_, s);
  TlStoreBinary::store(temperature_c_, s);
  TlStoreBinary::store(color_, s);
}

void mediaAreaWeather::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaWeather");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_field("emoji", emoji_);
    s.store_field("temperature_c", temperature_c_);
    s.store_field("color", color_);
    s.store_class_end();
  }
}

mediaAreaStarGift::mediaAreaStarGift(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &slug_)
  : coordinates_(std::move(coordinates_))
  , slug_(slug_)
{}

const std::int32_t mediaAreaStarGift::ID;

object_ptr<MediaArea> mediaAreaStarGift::fetch(TlBufferParser &p) {
  return make_tl_object<mediaAreaStarGift>(p);
}

mediaAreaStarGift::mediaAreaStarGift(TlBufferParser &p)
  : coordinates_(TlFetchBoxed<TlFetchObject<mediaAreaCoordinates>, -808853502>::parse(p))
  , slug_(TlFetchString<string>::parse(p))
{}

void mediaAreaStarGift::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(slug_, s);
}

void mediaAreaStarGift::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxed<TlStoreObject, -808853502>::store(coordinates_, s);
  TlStoreString::store(slug_, s);
}

void mediaAreaStarGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaStarGift");
    s.store_object_field("coordinates", static_cast<const BaseObject *>(coordinates_.get()));
    s.store_field("slug", slug_);
    s.store_class_end();
  }
}

mediaAreaCoordinates::mediaAreaCoordinates()
  : flags_()
  , x_()
  , y_()
  , w_()
  , h_()
  , rotation_()
  , radius_()
{}

mediaAreaCoordinates::mediaAreaCoordinates(int32 flags_, double x_, double y_, double w_, double h_, double rotation_, double radius_)
  : flags_(flags_)
  , x_(x_)
  , y_(y_)
  , w_(w_)
  , h_(h_)
  , rotation_(rotation_)
  , radius_(radius_)
{}

const std::int32_t mediaAreaCoordinates::ID;

object_ptr<mediaAreaCoordinates> mediaAreaCoordinates::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<mediaAreaCoordinates> res = make_tl_object<mediaAreaCoordinates>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->x_ = TlFetchDouble::parse(p);
  res->y_ = TlFetchDouble::parse(p);
  res->w_ = TlFetchDouble::parse(p);
  res->h_ = TlFetchDouble::parse(p);
  res->rotation_ = TlFetchDouble::parse(p);
  if (var0 & 1) { res->radius_ = TlFetchDouble::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void mediaAreaCoordinates::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(x_, s);
  TlStoreBinary::store(y_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  TlStoreBinary::store(rotation_, s);
  if (var0 & 1) { TlStoreBinary::store(radius_, s); }
}

void mediaAreaCoordinates::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  TlStoreBinary::store(x_, s);
  TlStoreBinary::store(y_, s);
  TlStoreBinary::store(w_, s);
  TlStoreBinary::store(h_, s);
  TlStoreBinary::store(rotation_, s);
  if (var0 & 1) { TlStoreBinary::store(radius_, s); }
}

void mediaAreaCoordinates::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mediaAreaCoordinates");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("x", x_);
    s.store_field("y", y_);
    s.store_field("w", w_);
    s.store_field("h", h_);
    s.store_field("rotation", rotation_);
    if (var0 & 1) { s.store_field("radius", radius_); }
    s.store_class_end();
  }
}

object_ptr<Message> Message::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageEmpty::ID:
      return messageEmpty::fetch(p);
    case message::ID:
      return message::fetch(p);
    case messageService::ID:
      return messageService::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

messageEmpty::messageEmpty()
  : flags_()
  , id_()
  , peer_id_()
{}

const std::int32_t messageEmpty::ID;

object_ptr<Message> messageEmpty::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageEmpty> res = make_tl_object<messageEmpty>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->id_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->peer_id_ = TlFetchObject<Peer>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEmpty");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("id", id_);
    if (var0 & 1) { s.store_object_field("peer_id", static_cast<const BaseObject *>(peer_id_.get())); }
    s.store_class_end();
  }
}

message::message()
  : flags_()
  , out_()
  , mentioned_()
  , media_unread_()
  , silent_()
  , post_()
  , from_scheduled_()
  , legacy_()
  , edit_hide_()
  , pinned_()
  , noforwards_()
  , invert_media_()
  , flags2_()
  , offline_()
  , video_processing_pending_()
  , paid_suggested_post_stars_()
  , paid_suggested_post_ton_()
  , id_()
  , from_id_()
  , from_boosts_applied_()
  , peer_id_()
  , saved_peer_id_()
  , fwd_from_()
  , via_bot_id_()
  , via_business_bot_id_()
  , reply_to_()
  , date_()
  , message_()
  , media_()
  , reply_markup_()
  , entities_()
  , views_()
  , forwards_()
  , replies_()
  , edit_date_()
  , post_author_()
  , grouped_id_()
  , reactions_()
  , restriction_reason_()
  , ttl_period_()
  , quick_reply_shortcut_id_()
  , effect_()
  , factcheck_()
  , report_delivery_until_date_()
  , paid_message_stars_()
  , suggested_post_()
{}

message::message(int32 flags_, bool out_, bool mentioned_, bool media_unread_, bool silent_, bool post_, bool from_scheduled_, bool legacy_, bool edit_hide_, bool pinned_, bool noforwards_, bool invert_media_, int32 flags2_, bool offline_, bool video_processing_pending_, bool paid_suggested_post_stars_, bool paid_suggested_post_ton_, int32 id_, object_ptr<Peer> &&from_id_, int32 from_boosts_applied_, object_ptr<Peer> &&peer_id_, object_ptr<Peer> &&saved_peer_id_, object_ptr<messageFwdHeader> &&fwd_from_, int64 via_bot_id_, int64 via_business_bot_id_, object_ptr<MessageReplyHeader> &&reply_to_, int32 date_, string const &message_, object_ptr<MessageMedia> &&media_, object_ptr<ReplyMarkup> &&reply_markup_, array<object_ptr<MessageEntity>> &&entities_, int32 views_, int32 forwards_, object_ptr<messageReplies> &&replies_, int32 edit_date_, string const &post_author_, int64 grouped_id_, object_ptr<messageReactions> &&reactions_, array<object_ptr<restrictionReason>> &&restriction_reason_, int32 ttl_period_, int32 quick_reply_shortcut_id_, int64 effect_, object_ptr<factCheck> &&factcheck_, int32 report_delivery_until_date_, int64 paid_message_stars_, object_ptr<suggestedPost> &&suggested_post_)
  : flags_(flags_)
  , out_(out_)
  , mentioned_(mentioned_)
  , media_unread_(media_unread_)
  , silent_(silent_)
  , post_(post_)
  , from_scheduled_(from_scheduled_)
  , legacy_(legacy_)
  , edit_hide_(edit_hide_)
  , pinned_(pinned_)
  , noforwards_(noforwards_)
  , invert_media_(invert_media_)
  , flags2_(flags2_)
  , offline_(offline_)
  , video_processing_pending_(video_processing_pending_)
  , paid_suggested_post_stars_(paid_suggested_post_stars_)
  , paid_suggested_post_ton_(paid_suggested_post_ton_)
  , id_(id_)
  , from_id_(std::move(from_id_))
  , from_boosts_applied_(from_boosts_applied_)
  , peer_id_(std::move(peer_id_))
  , saved_peer_id_(std::move(saved_peer_id_))
  , fwd_from_(std::move(fwd_from_))
  , via_bot_id_(via_bot_id_)
  , via_business_bot_id_(via_business_bot_id_)
  , reply_to_(std::move(reply_to_))
  , date_(date_)
  , message_(message_)
  , media_(std::move(media_))
  , reply_markup_(std::move(reply_markup_))
  , entities_(std::move(entities_))
  , views_(views_)
  , forwards_(forwards_)
  , replies_(std::move(replies_))
  , edit_date_(edit_date_)
  , post_author_(post_author_)
  , grouped_id_(grouped_id_)
  , reactions_(std::move(reactions_))
  , restriction_reason_(std::move(restriction_reason_))
  , ttl_period_(ttl_period_)
  , quick_reply_shortcut_id_(quick_reply_shortcut_id_)
  , effect_(effect_)
  , factcheck_(std::move(factcheck_))
  , report_delivery_until_date_(report_delivery_until_date_)
  , paid_message_stars_(paid_message_stars_)
  , suggested_post_(std::move(suggested_post_))
{}

const std::int32_t message::ID;

object_ptr<Message> message::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<message> res = make_tl_object<message>();
  int32 var0;
  int32 var1;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->out_ = (var0 & 2) != 0;
  res->mentioned_ = (var0 & 16) != 0;
  res->media_unread_ = (var0 & 32) != 0;
  res->silent_ = (var0 & 8192) != 0;
  res->post_ = (var0 & 16384) != 0;
  res->from_scheduled_ = (var0 & 262144) != 0;
  res->legacy_ = (var0 & 524288) != 0;
  res->edit_hide_ = (var0 & 2097152) != 0;
  res->pinned_ = (var0 & 16777216) != 0;
  res->noforwards_ = (var0 & 67108864) != 0;
  res->invert_media_ = (var0 & 134217728) != 0;
  if ((var1 = res->flags2_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->offline_ = (var1 & 2) != 0;
  res->video_processing_pending_ = (var1 & 16) != 0;
  res->paid_suggested_post_stars_ = (var1 & 256) != 0;
  res->paid_suggested_post_ton_ = (var1 & 512) != 0;
  res->id_ = TlFetchInt::parse(p);
  if (var0 & 256) { res->from_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 536870912) { res->from_boosts_applied_ = TlFetchInt::parse(p); }
  res->peer_id_ = TlFetchObject<Peer>::parse(p);
  if (var0 & 268435456) { res->saved_peer_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 4) { res->fwd_from_ = TlFetchBoxed<TlFetchObject<messageFwdHeader>, 1313731771>::parse(p); }
  if (var0 & 2048) { res->via_bot_id_ = TlFetchLong::parse(p); }
  if (var1 & 1) { res->via_business_bot_id_ = TlFetchLong::parse(p); }
  if (var0 & 8) { res->reply_to_ = TlFetchObject<MessageReplyHeader>::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  res->message_ = TlFetchString<string>::parse(p);
  if (var0 & 512) { res->media_ = TlFetchObject<MessageMedia>::parse(p); }
  if (var0 & 64) { res->reply_markup_ = TlFetchObject<ReplyMarkup>::parse(p); }
  if (var0 & 128) { res->entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 1024) { res->views_ = TlFetchInt::parse(p); }
  if (var0 & 1024) { res->forwards_ = TlFetchInt::parse(p); }
  if (var0 & 8388608) { res->replies_ = TlFetchBoxed<TlFetchObject<messageReplies>, -2083123262>::parse(p); }
  if (var0 & 32768) { res->edit_date_ = TlFetchInt::parse(p); }
  if (var0 & 65536) { res->post_author_ = TlFetchString<string>::parse(p); }
  if (var0 & 131072) { res->grouped_id_ = TlFetchLong::parse(p); }
  if (var0 & 1048576) { res->reactions_ = TlFetchBoxed<TlFetchObject<messageReactions>, 171155211>::parse(p); }
  if (var0 & 4194304) { res->restriction_reason_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<restrictionReason>, -797791052>>, 481674261>::parse(p); }
  if (var0 & 33554432) { res->ttl_period_ = TlFetchInt::parse(p); }
  if (var0 & 1073741824) { res->quick_reply_shortcut_id_ = TlFetchInt::parse(p); }
  if (var1 & 4) { res->effect_ = TlFetchLong::parse(p); }
  if (var1 & 8) { res->factcheck_ = TlFetchBoxed<TlFetchObject<factCheck>, -1197736753>::parse(p); }
  if (var1 & 32) { res->report_delivery_until_date_ = TlFetchInt::parse(p); }
  if (var1 & 64) { res->paid_message_stars_ = TlFetchLong::parse(p); }
  if (var1 & 128) { res->suggested_post_ = TlFetchBoxed<TlFetchObject<suggestedPost>, 244201445>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void message::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "message");
  int32 var0;
  int32 var1;
    s.store_field("flags", (var0 = flags_ | (out_ << 1) | (mentioned_ << 4) | (media_unread_ << 5) | (silent_ << 13) | (post_ << 14) | (from_scheduled_ << 18) | (legacy_ << 19) | (edit_hide_ << 21) | (pinned_ << 24) | (noforwards_ << 26) | (invert_media_ << 27)));
    if (var0 & 2) { s.store_field("out", true); }
    if (var0 & 16) { s.store_field("mentioned", true); }
    if (var0 & 32) { s.store_field("media_unread", true); }
    if (var0 & 8192) { s.store_field("silent", true); }
    if (var0 & 16384) { s.store_field("post", true); }
    if (var0 & 262144) { s.store_field("from_scheduled", true); }
    if (var0 & 524288) { s.store_field("legacy", true); }
    if (var0 & 2097152) { s.store_field("edit_hide", true); }
    if (var0 & 16777216) { s.store_field("pinned", true); }
    if (var0 & 67108864) { s.store_field("noforwards", true); }
    if (var0 & 134217728) { s.store_field("invert_media", true); }
    s.store_field("flags2", (var1 = flags2_ | (offline_ << 1) | (video_processing_pending_ << 4) | (paid_suggested_post_stars_ << 8) | (paid_suggested_post_ton_ << 9)));
    if (var1 & 2) { s.store_field("offline", true); }
    if (var1 & 16) { s.store_field("video_processing_pending", true); }
    if (var1 & 256) { s.store_field("paid_suggested_post_stars", true); }
    if (var1 & 512) { s.store_field("paid_suggested_post_ton", true); }
    s.store_field("id", id_);
    if (var0 & 256) { s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get())); }
    if (var0 & 536870912) { s.store_field("from_boosts_applied", from_boosts_applied_); }
    s.store_object_field("peer_id", static_cast<const BaseObject *>(peer_id_.get()));
    if (var0 & 268435456) { s.store_object_field("saved_peer_id", static_cast<const BaseObject *>(saved_peer_id_.get())); }
    if (var0 & 4) { s.store_object_field("fwd_from", static_cast<const BaseObject *>(fwd_from_.get())); }
    if (var0 & 2048) { s.store_field("via_bot_id", via_bot_id_); }
    if (var1 & 1) { s.store_field("via_business_bot_id", via_business_bot_id_); }
    if (var0 & 8) { s.store_object_field("reply_to", static_cast<const BaseObject *>(reply_to_.get())); }
    s.store_field("date", date_);
    s.store_field("message", message_);
    if (var0 & 512) { s.store_object_field("media", static_cast<const BaseObject *>(media_.get())); }
    if (var0 & 64) { s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get())); }
    if (var0 & 128) { { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 1024) { s.store_field("views", views_); }
    if (var0 & 1024) { s.store_field("forwards", forwards_); }
    if (var0 & 8388608) { s.store_object_field("replies", static_cast<const BaseObject *>(replies_.get())); }
    if (var0 & 32768) { s.store_field("edit_date", edit_date_); }
    if (var0 & 65536) { s.store_field("post_author", post_author_); }
    if (var0 & 131072) { s.store_field("grouped_id", grouped_id_); }
    if (var0 & 1048576) { s.store_object_field("reactions", static_cast<const BaseObject *>(reactions_.get())); }
    if (var0 & 4194304) { { s.store_vector_begin("restriction_reason", restriction_reason_.size()); for (const auto &_value : restriction_reason_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 33554432) { s.store_field("ttl_period", ttl_period_); }
    if (var0 & 1073741824) { s.store_field("quick_reply_shortcut_id", quick_reply_shortcut_id_); }
    if (var1 & 4) { s.store_field("effect", effect_); }
    if (var1 & 8) { s.store_object_field("factcheck", static_cast<const BaseObject *>(factcheck_.get())); }
    if (var1 & 32) { s.store_field("report_delivery_until_date", report_delivery_until_date_); }
    if (var1 & 64) { s.store_field("paid_message_stars", paid_message_stars_); }
    if (var1 & 128) { s.store_object_field("suggested_post", static_cast<const BaseObject *>(suggested_post_.get())); }
    s.store_class_end();
  }
}

messageService::messageService()
  : flags_()
  , out_()
  , mentioned_()
  , media_unread_()
  , reactions_are_possible_()
  , silent_()
  , post_()
  , legacy_()
  , id_()
  , from_id_()
  , peer_id_()
  , saved_peer_id_()
  , reply_to_()
  , date_()
  , action_()
  , reactions_()
  , ttl_period_()
{}

const std::int32_t messageService::ID;

object_ptr<Message> messageService::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageService> res = make_tl_object<messageService>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->out_ = (var0 & 2) != 0;
  res->mentioned_ = (var0 & 16) != 0;
  res->media_unread_ = (var0 & 32) != 0;
  res->reactions_are_possible_ = (var0 & 512) != 0;
  res->silent_ = (var0 & 8192) != 0;
  res->post_ = (var0 & 16384) != 0;
  res->legacy_ = (var0 & 524288) != 0;
  res->id_ = TlFetchInt::parse(p);
  if (var0 & 256) { res->from_id_ = TlFetchObject<Peer>::parse(p); }
  res->peer_id_ = TlFetchObject<Peer>::parse(p);
  if (var0 & 268435456) { res->saved_peer_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 8) { res->reply_to_ = TlFetchObject<MessageReplyHeader>::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  res->action_ = TlFetchObject<MessageAction>::parse(p);
  if (var0 & 1048576) { res->reactions_ = TlFetchBoxed<TlFetchObject<messageReactions>, 171155211>::parse(p); }
  if (var0 & 33554432) { res->ttl_period_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageService::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageService");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (out_ << 1) | (mentioned_ << 4) | (media_unread_ << 5) | (reactions_are_possible_ << 9) | (silent_ << 13) | (post_ << 14) | (legacy_ << 19)));
    if (var0 & 2) { s.store_field("out", true); }
    if (var0 & 16) { s.store_field("mentioned", true); }
    if (var0 & 32) { s.store_field("media_unread", true); }
    if (var0 & 512) { s.store_field("reactions_are_possible", true); }
    if (var0 & 8192) { s.store_field("silent", true); }
    if (var0 & 16384) { s.store_field("post", true); }
    if (var0 & 524288) { s.store_field("legacy", true); }
    s.store_field("id", id_);
    if (var0 & 256) { s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get())); }
    s.store_object_field("peer_id", static_cast<const BaseObject *>(peer_id_.get()));
    if (var0 & 268435456) { s.store_object_field("saved_peer_id", static_cast<const BaseObject *>(saved_peer_id_.get())); }
    if (var0 & 8) { s.store_object_field("reply_to", static_cast<const BaseObject *>(reply_to_.get())); }
    s.store_field("date", date_);
    s.store_object_field("action", static_cast<const BaseObject *>(action_.get()));
    if (var0 & 1048576) { s.store_object_field("reactions", static_cast<const BaseObject *>(reactions_.get())); }
    if (var0 & 33554432) { s.store_field("ttl_period", ttl_period_); }
    s.store_class_end();
  }
}

object_ptr<MessageAction> MessageAction::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageActionEmpty::ID:
      return messageActionEmpty::fetch(p);
    case messageActionChatCreate::ID:
      return messageActionChatCreate::fetch(p);
    case messageActionChatEditTitle::ID:
      return messageActionChatEditTitle::fetch(p);
    case messageActionChatEditPhoto::ID:
      return messageActionChatEditPhoto::fetch(p);
    case messageActionChatDeletePhoto::ID:
      return messageActionChatDeletePhoto::fetch(p);
    case messageActionChatAddUser::ID:
      return messageActionChatAddUser::fetch(p);
    case messageActionChatDeleteUser::ID:
      return messageActionChatDeleteUser::fetch(p);
    case messageActionChatJoinedByLink::ID:
      return messageActionChatJoinedByLink::fetch(p);
    case messageActionChannelCreate::ID:
      return messageActionChannelCreate::fetch(p);
    case messageActionChatMigrateTo::ID:
      return messageActionChatMigrateTo::fetch(p);
    case messageActionChannelMigrateFrom::ID:
      return messageActionChannelMigrateFrom::fetch(p);
    case messageActionPinMessage::ID:
      return messageActionPinMessage::fetch(p);
    case messageActionHistoryClear::ID:
      return messageActionHistoryClear::fetch(p);
    case messageActionGameScore::ID:
      return messageActionGameScore::fetch(p);
    case messageActionPaymentSentMe::ID:
      return messageActionPaymentSentMe::fetch(p);
    case messageActionPaymentSent::ID:
      return messageActionPaymentSent::fetch(p);
    case messageActionPhoneCall::ID:
      return messageActionPhoneCall::fetch(p);
    case messageActionScreenshotTaken::ID:
      return messageActionScreenshotTaken::fetch(p);
    case messageActionCustomAction::ID:
      return messageActionCustomAction::fetch(p);
    case messageActionBotAllowed::ID:
      return messageActionBotAllowed::fetch(p);
    case messageActionSecureValuesSentMe::ID:
      return messageActionSecureValuesSentMe::fetch(p);
    case messageActionSecureValuesSent::ID:
      return messageActionSecureValuesSent::fetch(p);
    case messageActionContactSignUp::ID:
      return messageActionContactSignUp::fetch(p);
    case messageActionGeoProximityReached::ID:
      return messageActionGeoProximityReached::fetch(p);
    case messageActionGroupCall::ID:
      return messageActionGroupCall::fetch(p);
    case messageActionInviteToGroupCall::ID:
      return messageActionInviteToGroupCall::fetch(p);
    case messageActionSetMessagesTTL::ID:
      return messageActionSetMessagesTTL::fetch(p);
    case messageActionGroupCallScheduled::ID:
      return messageActionGroupCallScheduled::fetch(p);
    case messageActionSetChatTheme::ID:
      return messageActionSetChatTheme::fetch(p);
    case messageActionChatJoinedByRequest::ID:
      return messageActionChatJoinedByRequest::fetch(p);
    case messageActionWebViewDataSentMe::ID:
      return messageActionWebViewDataSentMe::fetch(p);
    case messageActionWebViewDataSent::ID:
      return messageActionWebViewDataSent::fetch(p);
    case messageActionGiftPremium::ID:
      return messageActionGiftPremium::fetch(p);
    case messageActionTopicCreate::ID:
      return messageActionTopicCreate::fetch(p);
    case messageActionTopicEdit::ID:
      return messageActionTopicEdit::fetch(p);
    case messageActionSuggestProfilePhoto::ID:
      return messageActionSuggestProfilePhoto::fetch(p);
    case messageActionRequestedPeer::ID:
      return messageActionRequestedPeer::fetch(p);
    case messageActionSetChatWallPaper::ID:
      return messageActionSetChatWallPaper::fetch(p);
    case messageActionGiftCode::ID:
      return messageActionGiftCode::fetch(p);
    case messageActionGiveawayLaunch::ID:
      return messageActionGiveawayLaunch::fetch(p);
    case messageActionGiveawayResults::ID:
      return messageActionGiveawayResults::fetch(p);
    case messageActionBoostApply::ID:
      return messageActionBoostApply::fetch(p);
    case messageActionRequestedPeerSentMe::ID:
      return messageActionRequestedPeerSentMe::fetch(p);
    case messageActionPaymentRefunded::ID:
      return messageActionPaymentRefunded::fetch(p);
    case messageActionGiftStars::ID:
      return messageActionGiftStars::fetch(p);
    case messageActionPrizeStars::ID:
      return messageActionPrizeStars::fetch(p);
    case messageActionStarGift::ID:
      return messageActionStarGift::fetch(p);
    case messageActionStarGiftUnique::ID:
      return messageActionStarGiftUnique::fetch(p);
    case messageActionPaidMessagesRefunded::ID:
      return messageActionPaidMessagesRefunded::fetch(p);
    case messageActionPaidMessagesPrice::ID:
      return messageActionPaidMessagesPrice::fetch(p);
    case messageActionConferenceCall::ID:
      return messageActionConferenceCall::fetch(p);
    case messageActionTodoCompletions::ID:
      return messageActionTodoCompletions::fetch(p);
    case messageActionTodoAppendTasks::ID:
      return messageActionTodoAppendTasks::fetch(p);
    case messageActionSuggestedPostApproval::ID:
      return messageActionSuggestedPostApproval::fetch(p);
    case messageActionSuggestedPostSuccess::ID:
      return messageActionSuggestedPostSuccess::fetch(p);
    case messageActionSuggestedPostRefund::ID:
      return messageActionSuggestedPostRefund::fetch(p);
    case messageActionGiftTon::ID:
      return messageActionGiftTon::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t messageActionEmpty::ID;

object_ptr<MessageAction> messageActionEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionEmpty>();
}

void messageActionEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionEmpty");
    s.store_class_end();
  }
}

const std::int32_t messageActionChatCreate::ID;

object_ptr<MessageAction> messageActionChatCreate::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatCreate>(p);
}

messageActionChatCreate::messageActionChatCreate(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , users_(TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p))
{}

void messageActionChatCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatCreate");
    s.store_field("title", title_);
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t messageActionChatEditTitle::ID;

object_ptr<MessageAction> messageActionChatEditTitle::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatEditTitle>(p);
}

messageActionChatEditTitle::messageActionChatEditTitle(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
{}

void messageActionChatEditTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatEditTitle");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChatEditPhoto::ID;

object_ptr<MessageAction> messageActionChatEditPhoto::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatEditPhoto>(p);
}

messageActionChatEditPhoto::messageActionChatEditPhoto(TlBufferParser &p)
  : photo_(TlFetchObject<Photo>::parse(p))
{}

void messageActionChatEditPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatEditPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageActionChatDeletePhoto::ID;

object_ptr<MessageAction> messageActionChatDeletePhoto::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatDeletePhoto>();
}

void messageActionChatDeletePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatDeletePhoto");
    s.store_class_end();
  }
}

const std::int32_t messageActionChatAddUser::ID;

object_ptr<MessageAction> messageActionChatAddUser::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatAddUser>(p);
}

messageActionChatAddUser::messageActionChatAddUser(TlBufferParser &p)
  : users_(TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p))
{}

void messageActionChatAddUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatAddUser");
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t messageActionChatDeleteUser::ID;

object_ptr<MessageAction> messageActionChatDeleteUser::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatDeleteUser>(p);
}

messageActionChatDeleteUser::messageActionChatDeleteUser(TlBufferParser &p)
  : user_id_(TlFetchLong::parse(p))
{}

void messageActionChatDeleteUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatDeleteUser");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChatJoinedByLink::ID;

object_ptr<MessageAction> messageActionChatJoinedByLink::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatJoinedByLink>(p);
}

messageActionChatJoinedByLink::messageActionChatJoinedByLink(TlBufferParser &p)
  : inviter_id_(TlFetchLong::parse(p))
{}

void messageActionChatJoinedByLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatJoinedByLink");
    s.store_field("inviter_id", inviter_id_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChannelCreate::ID;

object_ptr<MessageAction> messageActionChannelCreate::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChannelCreate>(p);
}

messageActionChannelCreate::messageActionChannelCreate(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
{}

void messageActionChannelCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChannelCreate");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChatMigrateTo::ID;

object_ptr<MessageAction> messageActionChatMigrateTo::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatMigrateTo>(p);
}

messageActionChatMigrateTo::messageActionChatMigrateTo(TlBufferParser &p)
  : channel_id_(TlFetchLong::parse(p))
{}

void messageActionChatMigrateTo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatMigrateTo");
    s.store_field("channel_id", channel_id_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChannelMigrateFrom::ID;

object_ptr<MessageAction> messageActionChannelMigrateFrom::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChannelMigrateFrom>(p);
}

messageActionChannelMigrateFrom::messageActionChannelMigrateFrom(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , chat_id_(TlFetchLong::parse(p))
{}

void messageActionChannelMigrateFrom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChannelMigrateFrom");
    s.store_field("title", title_);
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

const std::int32_t messageActionPinMessage::ID;

object_ptr<MessageAction> messageActionPinMessage::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionPinMessage>();
}

void messageActionPinMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPinMessage");
    s.store_class_end();
  }
}

const std::int32_t messageActionHistoryClear::ID;

object_ptr<MessageAction> messageActionHistoryClear::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionHistoryClear>();
}

void messageActionHistoryClear::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionHistoryClear");
    s.store_class_end();
  }
}

const std::int32_t messageActionGameScore::ID;

object_ptr<MessageAction> messageActionGameScore::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionGameScore>(p);
}

messageActionGameScore::messageActionGameScore(TlBufferParser &p)
  : game_id_(TlFetchLong::parse(p))
  , score_(TlFetchInt::parse(p))
{}

void messageActionGameScore::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGameScore");
    s.store_field("game_id", game_id_);
    s.store_field("score", score_);
    s.store_class_end();
  }
}

messageActionPaymentSentMe::messageActionPaymentSentMe()
  : flags_()
  , recurring_init_()
  , recurring_used_()
  , currency_()
  , total_amount_()
  , payload_()
  , info_()
  , shipping_option_id_()
  , charge_()
  , subscription_until_date_()
{}

const std::int32_t messageActionPaymentSentMe::ID;

object_ptr<MessageAction> messageActionPaymentSentMe::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPaymentSentMe> res = make_tl_object<messageActionPaymentSentMe>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->recurring_init_ = (var0 & 4) != 0;
  res->recurring_used_ = (var0 & 8) != 0;
  res->currency_ = TlFetchString<string>::parse(p);
  res->total_amount_ = TlFetchLong::parse(p);
  res->payload_ = TlFetchBytes<bytes>::parse(p);
  if (var0 & 1) { res->info_ = TlFetchBoxed<TlFetchObject<paymentRequestedInfo>, -1868808300>::parse(p); }
  if (var0 & 2) { res->shipping_option_id_ = TlFetchString<string>::parse(p); }
  res->charge_ = TlFetchBoxed<TlFetchObject<paymentCharge>, -368917890>::parse(p);
  if (var0 & 16) { res->subscription_until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPaymentSentMe::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPaymentSentMe");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (recurring_init_ << 2) | (recurring_used_ << 3)));
    if (var0 & 4) { s.store_field("recurring_init", true); }
    if (var0 & 8) { s.store_field("recurring_used", true); }
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_bytes_field("payload", payload_);
    if (var0 & 1) { s.store_object_field("info", static_cast<const BaseObject *>(info_.get())); }
    if (var0 & 2) { s.store_field("shipping_option_id", shipping_option_id_); }
    s.store_object_field("charge", static_cast<const BaseObject *>(charge_.get()));
    if (var0 & 16) { s.store_field("subscription_until_date", subscription_until_date_); }
    s.store_class_end();
  }
}

messageActionPaymentSent::messageActionPaymentSent()
  : flags_()
  , recurring_init_()
  , recurring_used_()
  , currency_()
  , total_amount_()
  , invoice_slug_()
  , subscription_until_date_()
{}

const std::int32_t messageActionPaymentSent::ID;

object_ptr<MessageAction> messageActionPaymentSent::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPaymentSent> res = make_tl_object<messageActionPaymentSent>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->recurring_init_ = (var0 & 4) != 0;
  res->recurring_used_ = (var0 & 8) != 0;
  res->currency_ = TlFetchString<string>::parse(p);
  res->total_amount_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->invoice_slug_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->subscription_until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPaymentSent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPaymentSent");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (recurring_init_ << 2) | (recurring_used_ << 3)));
    if (var0 & 4) { s.store_field("recurring_init", true); }
    if (var0 & 8) { s.store_field("recurring_used", true); }
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    if (var0 & 1) { s.store_field("invoice_slug", invoice_slug_); }
    if (var0 & 16) { s.store_field("subscription_until_date", subscription_until_date_); }
    s.store_class_end();
  }
}

messageActionPhoneCall::messageActionPhoneCall()
  : flags_()
  , video_()
  , call_id_()
  , reason_()
  , duration_()
{}

const std::int32_t messageActionPhoneCall::ID;

object_ptr<MessageAction> messageActionPhoneCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPhoneCall> res = make_tl_object<messageActionPhoneCall>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->video_ = (var0 & 4) != 0;
  res->call_id_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->reason_ = TlFetchObject<PhoneCallDiscardReason>::parse(p); }
  if (var0 & 2) { res->duration_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPhoneCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPhoneCall");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (video_ << 2)));
    if (var0 & 4) { s.store_field("video", true); }
    s.store_field("call_id", call_id_);
    if (var0 & 1) { s.store_object_field("reason", static_cast<const BaseObject *>(reason_.get())); }
    if (var0 & 2) { s.store_field("duration", duration_); }
    s.store_class_end();
  }
}

const std::int32_t messageActionScreenshotTaken::ID;

object_ptr<MessageAction> messageActionScreenshotTaken::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionScreenshotTaken>();
}

void messageActionScreenshotTaken::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionScreenshotTaken");
    s.store_class_end();
  }
}

const std::int32_t messageActionCustomAction::ID;

object_ptr<MessageAction> messageActionCustomAction::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionCustomAction>(p);
}

messageActionCustomAction::messageActionCustomAction(TlBufferParser &p)
  : message_(TlFetchString<string>::parse(p))
{}

void messageActionCustomAction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionCustomAction");
    s.store_field("message", message_);
    s.store_class_end();
  }
}

messageActionBotAllowed::messageActionBotAllowed()
  : flags_()
  , attach_menu_()
  , from_request_()
  , domain_()
  , app_()
{}

const std::int32_t messageActionBotAllowed::ID;

object_ptr<MessageAction> messageActionBotAllowed::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionBotAllowed> res = make_tl_object<messageActionBotAllowed>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->attach_menu_ = (var0 & 2) != 0;
  res->from_request_ = (var0 & 8) != 0;
  if (var0 & 1) { res->domain_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->app_ = TlFetchObject<BotApp>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionBotAllowed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionBotAllowed");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (attach_menu_ << 1) | (from_request_ << 3)));
    if (var0 & 2) { s.store_field("attach_menu", true); }
    if (var0 & 8) { s.store_field("from_request", true); }
    if (var0 & 1) { s.store_field("domain", domain_); }
    if (var0 & 4) { s.store_object_field("app", static_cast<const BaseObject *>(app_.get())); }
    s.store_class_end();
  }
}

const std::int32_t messageActionSecureValuesSentMe::ID;

object_ptr<MessageAction> messageActionSecureValuesSentMe::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionSecureValuesSentMe>(p);
}

messageActionSecureValuesSentMe::messageActionSecureValuesSentMe(TlBufferParser &p)
  : values_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<secureValue>, 411017418>>, 481674261>::parse(p))
  , credentials_(TlFetchBoxed<TlFetchObject<secureCredentialsEncrypted>, 871426631>::parse(p))
{}

void messageActionSecureValuesSentMe::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSecureValuesSentMe");
    { s.store_vector_begin("values", values_.size()); for (const auto &_value : values_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("credentials", static_cast<const BaseObject *>(credentials_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageActionSecureValuesSent::ID;

object_ptr<MessageAction> messageActionSecureValuesSent::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionSecureValuesSent>(p);
}

messageActionSecureValuesSent::messageActionSecureValuesSent(TlBufferParser &p)
  : types_(TlFetchBoxed<TlFetchVector<TlFetchObject<SecureValueType>>, 481674261>::parse(p))
{}

void messageActionSecureValuesSent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSecureValuesSent");
    { s.store_vector_begin("types", types_.size()); for (const auto &_value : types_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t messageActionContactSignUp::ID;

object_ptr<MessageAction> messageActionContactSignUp::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionContactSignUp>();
}

void messageActionContactSignUp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionContactSignUp");
    s.store_class_end();
  }
}

const std::int32_t messageActionGeoProximityReached::ID;

object_ptr<MessageAction> messageActionGeoProximityReached::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionGeoProximityReached>(p);
}

messageActionGeoProximityReached::messageActionGeoProximityReached(TlBufferParser &p)
  : from_id_(TlFetchObject<Peer>::parse(p))
  , to_id_(TlFetchObject<Peer>::parse(p))
  , distance_(TlFetchInt::parse(p))
{}

void messageActionGeoProximityReached::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGeoProximityReached");
    s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get()));
    s.store_object_field("to_id", static_cast<const BaseObject *>(to_id_.get()));
    s.store_field("distance", distance_);
    s.store_class_end();
  }
}

messageActionGroupCall::messageActionGroupCall()
  : flags_()
  , call_()
  , duration_()
{}

const std::int32_t messageActionGroupCall::ID;

object_ptr<MessageAction> messageActionGroupCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGroupCall> res = make_tl_object<messageActionGroupCall>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->call_ = TlFetchObject<InputGroupCall>::parse(p);
  if (var0 & 1) { res->duration_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGroupCall");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    if (var0 & 1) { s.store_field("duration", duration_); }
    s.store_class_end();
  }
}

const std::int32_t messageActionInviteToGroupCall::ID;

object_ptr<MessageAction> messageActionInviteToGroupCall::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionInviteToGroupCall>(p);
}

messageActionInviteToGroupCall::messageActionInviteToGroupCall(TlBufferParser &p)
  : call_(TlFetchObject<InputGroupCall>::parse(p))
  , users_(TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p))
{}

void messageActionInviteToGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionInviteToGroupCall");
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageActionSetMessagesTTL::messageActionSetMessagesTTL()
  : flags_()
  , period_()
  , auto_setting_from_()
{}

const std::int32_t messageActionSetMessagesTTL::ID;

object_ptr<MessageAction> messageActionSetMessagesTTL::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionSetMessagesTTL> res = make_tl_object<messageActionSetMessagesTTL>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->period_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->auto_setting_from_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionSetMessagesTTL::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSetMessagesTTL");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("period", period_);
    if (var0 & 1) { s.store_field("auto_setting_from", auto_setting_from_); }
    s.store_class_end();
  }
}

const std::int32_t messageActionGroupCallScheduled::ID;

object_ptr<MessageAction> messageActionGroupCallScheduled::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionGroupCallScheduled>(p);
}

messageActionGroupCallScheduled::messageActionGroupCallScheduled(TlBufferParser &p)
  : call_(TlFetchObject<InputGroupCall>::parse(p))
  , schedule_date_(TlFetchInt::parse(p))
{}

void messageActionGroupCallScheduled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGroupCallScheduled");
    s.store_object_field("call", static_cast<const BaseObject *>(call_.get()));
    s.store_field("schedule_date", schedule_date_);
    s.store_class_end();
  }
}

const std::int32_t messageActionSetChatTheme::ID;

object_ptr<MessageAction> messageActionSetChatTheme::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionSetChatTheme>(p);
}

messageActionSetChatTheme::messageActionSetChatTheme(TlBufferParser &p)
  : emoticon_(TlFetchString<string>::parse(p))
{}

void messageActionSetChatTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSetChatTheme");
    s.store_field("emoticon", emoticon_);
    s.store_class_end();
  }
}

const std::int32_t messageActionChatJoinedByRequest::ID;

object_ptr<MessageAction> messageActionChatJoinedByRequest::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionChatJoinedByRequest>();
}

void messageActionChatJoinedByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionChatJoinedByRequest");
    s.store_class_end();
  }
}

const std::int32_t messageActionWebViewDataSentMe::ID;

object_ptr<MessageAction> messageActionWebViewDataSentMe::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionWebViewDataSentMe>(p);
}

messageActionWebViewDataSentMe::messageActionWebViewDataSentMe(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , data_(TlFetchString<string>::parse(p))
{}

void messageActionWebViewDataSentMe::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionWebViewDataSentMe");
    s.store_field("text", text_);
    s.store_field("data", data_);
    s.store_class_end();
  }
}

const std::int32_t messageActionWebViewDataSent::ID;

object_ptr<MessageAction> messageActionWebViewDataSent::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionWebViewDataSent>(p);
}

messageActionWebViewDataSent::messageActionWebViewDataSent(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
{}

void messageActionWebViewDataSent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionWebViewDataSent");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

messageActionGiftPremium::messageActionGiftPremium()
  : flags_()
  , currency_()
  , amount_()
  , months_()
  , crypto_currency_()
  , crypto_amount_()
  , message_()
{}

const std::int32_t messageActionGiftPremium::ID;

object_ptr<MessageAction> messageActionGiftPremium::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiftPremium> res = make_tl_object<messageActionGiftPremium>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->currency_ = TlFetchString<string>::parse(p);
  res->amount_ = TlFetchLong::parse(p);
  res->months_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->crypto_currency_ = TlFetchString<string>::parse(p); }
  if (var0 & 1) { res->crypto_amount_ = TlFetchLong::parse(p); }
  if (var0 & 2) { res->message_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiftPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiftPremium");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("months", months_);
    if (var0 & 1) { s.store_field("crypto_currency", crypto_currency_); }
    if (var0 & 1) { s.store_field("crypto_amount", crypto_amount_); }
    if (var0 & 2) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    s.store_class_end();
  }
}

messageActionTopicCreate::messageActionTopicCreate()
  : flags_()
  , title_()
  , icon_color_()
  , icon_emoji_id_()
{}

const std::int32_t messageActionTopicCreate::ID;

object_ptr<MessageAction> messageActionTopicCreate::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionTopicCreate> res = make_tl_object<messageActionTopicCreate>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->title_ = TlFetchString<string>::parse(p);
  res->icon_color_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->icon_emoji_id_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionTopicCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionTopicCreate");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("title", title_);
    s.store_field("icon_color", icon_color_);
    if (var0 & 1) { s.store_field("icon_emoji_id", icon_emoji_id_); }
    s.store_class_end();
  }
}

messageActionTopicEdit::messageActionTopicEdit()
  : flags_()
  , title_()
  , icon_emoji_id_()
  , closed_()
  , hidden_()
{}

const std::int32_t messageActionTopicEdit::ID;

object_ptr<MessageAction> messageActionTopicEdit::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionTopicEdit> res = make_tl_object<messageActionTopicEdit>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->icon_emoji_id_ = TlFetchLong::parse(p); }
  if (var0 & 4) { res->closed_ = TlFetchBool::parse(p); }
  if (var0 & 8) { res->hidden_ = TlFetchBool::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionTopicEdit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionTopicEdit");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("title", title_); }
    if (var0 & 2) { s.store_field("icon_emoji_id", icon_emoji_id_); }
    if (var0 & 4) { s.store_field("closed", closed_); }
    if (var0 & 8) { s.store_field("hidden", hidden_); }
    s.store_class_end();
  }
}

const std::int32_t messageActionSuggestProfilePhoto::ID;

object_ptr<MessageAction> messageActionSuggestProfilePhoto::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionSuggestProfilePhoto>(p);
}

messageActionSuggestProfilePhoto::messageActionSuggestProfilePhoto(TlBufferParser &p)
  : photo_(TlFetchObject<Photo>::parse(p))
{}

void messageActionSuggestProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSuggestProfilePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageActionRequestedPeer::ID;

object_ptr<MessageAction> messageActionRequestedPeer::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionRequestedPeer>(p);
}

messageActionRequestedPeer::messageActionRequestedPeer(TlBufferParser &p)
  : button_id_(TlFetchInt::parse(p))
  , peers_(TlFetchBoxed<TlFetchVector<TlFetchObject<Peer>>, 481674261>::parse(p))
{}

void messageActionRequestedPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionRequestedPeer");
    s.store_field("button_id", button_id_);
    { s.store_vector_begin("peers", peers_.size()); for (const auto &_value : peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageActionSetChatWallPaper::messageActionSetChatWallPaper()
  : flags_()
  , same_()
  , for_both_()
  , wallpaper_()
{}

const std::int32_t messageActionSetChatWallPaper::ID;

object_ptr<MessageAction> messageActionSetChatWallPaper::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionSetChatWallPaper> res = make_tl_object<messageActionSetChatWallPaper>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->same_ = (var0 & 1) != 0;
  res->for_both_ = (var0 & 2) != 0;
  res->wallpaper_ = TlFetchObject<WallPaper>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionSetChatWallPaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSetChatWallPaper");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (same_ << 0) | (for_both_ << 1)));
    if (var0 & 1) { s.store_field("same", true); }
    if (var0 & 2) { s.store_field("for_both", true); }
    s.store_object_field("wallpaper", static_cast<const BaseObject *>(wallpaper_.get()));
    s.store_class_end();
  }
}

messageActionGiftCode::messageActionGiftCode()
  : flags_()
  , via_giveaway_()
  , unclaimed_()
  , boost_peer_()
  , months_()
  , slug_()
  , currency_()
  , amount_()
  , crypto_currency_()
  , crypto_amount_()
  , message_()
{}

const std::int32_t messageActionGiftCode::ID;

object_ptr<MessageAction> messageActionGiftCode::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiftCode> res = make_tl_object<messageActionGiftCode>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->via_giveaway_ = (var0 & 1) != 0;
  res->unclaimed_ = (var0 & 32) != 0;
  if (var0 & 2) { res->boost_peer_ = TlFetchObject<Peer>::parse(p); }
  res->months_ = TlFetchInt::parse(p);
  res->slug_ = TlFetchString<string>::parse(p);
  if (var0 & 4) { res->currency_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->amount_ = TlFetchLong::parse(p); }
  if (var0 & 8) { res->crypto_currency_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->crypto_amount_ = TlFetchLong::parse(p); }
  if (var0 & 16) { res->message_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiftCode");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (via_giveaway_ << 0) | (unclaimed_ << 5)));
    if (var0 & 1) { s.store_field("via_giveaway", true); }
    if (var0 & 32) { s.store_field("unclaimed", true); }
    if (var0 & 2) { s.store_object_field("boost_peer", static_cast<const BaseObject *>(boost_peer_.get())); }
    s.store_field("months", months_);
    s.store_field("slug", slug_);
    if (var0 & 4) { s.store_field("currency", currency_); }
    if (var0 & 4) { s.store_field("amount", amount_); }
    if (var0 & 8) { s.store_field("crypto_currency", crypto_currency_); }
    if (var0 & 8) { s.store_field("crypto_amount", crypto_amount_); }
    if (var0 & 16) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    s.store_class_end();
  }
}

messageActionGiveawayLaunch::messageActionGiveawayLaunch()
  : flags_()
  , stars_()
{}

const std::int32_t messageActionGiveawayLaunch::ID;

object_ptr<MessageAction> messageActionGiveawayLaunch::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiveawayLaunch> res = make_tl_object<messageActionGiveawayLaunch>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->stars_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiveawayLaunch::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiveawayLaunch");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("stars", stars_); }
    s.store_class_end();
  }
}

messageActionGiveawayResults::messageActionGiveawayResults()
  : flags_()
  , stars_()
  , winners_count_()
  , unclaimed_count_()
{}

const std::int32_t messageActionGiveawayResults::ID;

object_ptr<MessageAction> messageActionGiveawayResults::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiveawayResults> res = make_tl_object<messageActionGiveawayResults>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->stars_ = (var0 & 1) != 0;
  res->winners_count_ = TlFetchInt::parse(p);
  res->unclaimed_count_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiveawayResults::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiveawayResults");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (stars_ << 0)));
    if (var0 & 1) { s.store_field("stars", true); }
    s.store_field("winners_count", winners_count_);
    s.store_field("unclaimed_count", unclaimed_count_);
    s.store_class_end();
  }
}

const std::int32_t messageActionBoostApply::ID;

object_ptr<MessageAction> messageActionBoostApply::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionBoostApply>(p);
}

messageActionBoostApply::messageActionBoostApply(TlBufferParser &p)
  : boosts_(TlFetchInt::parse(p))
{}

void messageActionBoostApply::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionBoostApply");
    s.store_field("boosts", boosts_);
    s.store_class_end();
  }
}

const std::int32_t messageActionRequestedPeerSentMe::ID;

object_ptr<MessageAction> messageActionRequestedPeerSentMe::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionRequestedPeerSentMe>(p);
}

messageActionRequestedPeerSentMe::messageActionRequestedPeerSentMe(TlBufferParser &p)
  : button_id_(TlFetchInt::parse(p))
  , peers_(TlFetchBoxed<TlFetchVector<TlFetchObject<RequestedPeer>>, 481674261>::parse(p))
{}

void messageActionRequestedPeerSentMe::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionRequestedPeerSentMe");
    s.store_field("button_id", button_id_);
    { s.store_vector_begin("peers", peers_.size()); for (const auto &_value : peers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageActionPaymentRefunded::messageActionPaymentRefunded()
  : flags_()
  , peer_()
  , currency_()
  , total_amount_()
  , payload_()
  , charge_()
{}

const std::int32_t messageActionPaymentRefunded::ID;

object_ptr<MessageAction> messageActionPaymentRefunded::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPaymentRefunded> res = make_tl_object<messageActionPaymentRefunded>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->currency_ = TlFetchString<string>::parse(p);
  res->total_amount_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->payload_ = TlFetchBytes<bytes>::parse(p); }
  res->charge_ = TlFetchBoxed<TlFetchObject<paymentCharge>, -368917890>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPaymentRefunded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPaymentRefunded");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    if (var0 & 1) { s.store_bytes_field("payload", payload_); }
    s.store_object_field("charge", static_cast<const BaseObject *>(charge_.get()));
    s.store_class_end();
  }
}

messageActionGiftStars::messageActionGiftStars()
  : flags_()
  , currency_()
  , amount_()
  , stars_()
  , crypto_currency_()
  , crypto_amount_()
  , transaction_id_()
{}

const std::int32_t messageActionGiftStars::ID;

object_ptr<MessageAction> messageActionGiftStars::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiftStars> res = make_tl_object<messageActionGiftStars>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->currency_ = TlFetchString<string>::parse(p);
  res->amount_ = TlFetchLong::parse(p);
  res->stars_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->crypto_currency_ = TlFetchString<string>::parse(p); }
  if (var0 & 1) { res->crypto_amount_ = TlFetchLong::parse(p); }
  if (var0 & 2) { res->transaction_id_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiftStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiftStars");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("stars", stars_);
    if (var0 & 1) { s.store_field("crypto_currency", crypto_currency_); }
    if (var0 & 1) { s.store_field("crypto_amount", crypto_amount_); }
    if (var0 & 2) { s.store_field("transaction_id", transaction_id_); }
    s.store_class_end();
  }
}

messageActionPrizeStars::messageActionPrizeStars()
  : flags_()
  , unclaimed_()
  , stars_()
  , transaction_id_()
  , boost_peer_()
  , giveaway_msg_id_()
{}

const std::int32_t messageActionPrizeStars::ID;

object_ptr<MessageAction> messageActionPrizeStars::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPrizeStars> res = make_tl_object<messageActionPrizeStars>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->unclaimed_ = (var0 & 1) != 0;
  res->stars_ = TlFetchLong::parse(p);
  res->transaction_id_ = TlFetchString<string>::parse(p);
  res->boost_peer_ = TlFetchObject<Peer>::parse(p);
  res->giveaway_msg_id_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPrizeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPrizeStars");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (unclaimed_ << 0)));
    if (var0 & 1) { s.store_field("unclaimed", true); }
    s.store_field("stars", stars_);
    s.store_field("transaction_id", transaction_id_);
    s.store_object_field("boost_peer", static_cast<const BaseObject *>(boost_peer_.get()));
    s.store_field("giveaway_msg_id", giveaway_msg_id_);
    s.store_class_end();
  }
}

messageActionStarGift::messageActionStarGift()
  : flags_()
  , name_hidden_()
  , saved_()
  , converted_()
  , upgraded_()
  , refunded_()
  , can_upgrade_()
  , gift_()
  , message_()
  , convert_stars_()
  , upgrade_msg_id_()
  , upgrade_stars_()
  , from_id_()
  , peer_()
  , saved_id_()
{}

const std::int32_t messageActionStarGift::ID;

object_ptr<MessageAction> messageActionStarGift::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionStarGift> res = make_tl_object<messageActionStarGift>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->name_hidden_ = (var0 & 1) != 0;
  res->saved_ = (var0 & 4) != 0;
  res->converted_ = (var0 & 8) != 0;
  res->upgraded_ = (var0 & 32) != 0;
  res->refunded_ = (var0 & 512) != 0;
  res->can_upgrade_ = (var0 & 1024) != 0;
  res->gift_ = TlFetchObject<StarGift>::parse(p);
  if (var0 & 2) { res->message_ = TlFetchBoxed<TlFetchObject<textWithEntities>, 1964978502>::parse(p); }
  if (var0 & 16) { res->convert_stars_ = TlFetchLong::parse(p); }
  if (var0 & 32) { res->upgrade_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 256) { res->upgrade_stars_ = TlFetchLong::parse(p); }
  if (var0 & 2048) { res->from_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 4096) { res->peer_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 4096) { res->saved_id_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionStarGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionStarGift");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (name_hidden_ << 0) | (saved_ << 2) | (converted_ << 3) | (upgraded_ << 5) | (refunded_ << 9) | (can_upgrade_ << 10)));
    if (var0 & 1) { s.store_field("name_hidden", true); }
    if (var0 & 4) { s.store_field("saved", true); }
    if (var0 & 8) { s.store_field("converted", true); }
    if (var0 & 32) { s.store_field("upgraded", true); }
    if (var0 & 512) { s.store_field("refunded", true); }
    if (var0 & 1024) { s.store_field("can_upgrade", true); }
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    if (var0 & 2) { s.store_object_field("message", static_cast<const BaseObject *>(message_.get())); }
    if (var0 & 16) { s.store_field("convert_stars", convert_stars_); }
    if (var0 & 32) { s.store_field("upgrade_msg_id", upgrade_msg_id_); }
    if (var0 & 256) { s.store_field("upgrade_stars", upgrade_stars_); }
    if (var0 & 2048) { s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get())); }
    if (var0 & 4096) { s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get())); }
    if (var0 & 4096) { s.store_field("saved_id", saved_id_); }
    s.store_class_end();
  }
}

messageActionStarGiftUnique::messageActionStarGiftUnique()
  : flags_()
  , upgrade_()
  , transferred_()
  , saved_()
  , refunded_()
  , gift_()
  , can_export_at_()
  , transfer_stars_()
  , from_id_()
  , peer_()
  , saved_id_()
  , resale_stars_()
  , can_transfer_at_()
  , can_resell_at_()
{}

const std::int32_t messageActionStarGiftUnique::ID;

object_ptr<MessageAction> messageActionStarGiftUnique::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionStarGiftUnique> res = make_tl_object<messageActionStarGiftUnique>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->upgrade_ = (var0 & 1) != 0;
  res->transferred_ = (var0 & 2) != 0;
  res->saved_ = (var0 & 4) != 0;
  res->refunded_ = (var0 & 32) != 0;
  res->gift_ = TlFetchObject<StarGift>::parse(p);
  if (var0 & 8) { res->can_export_at_ = TlFetchInt::parse(p); }
  if (var0 & 16) { res->transfer_stars_ = TlFetchLong::parse(p); }
  if (var0 & 64) { res->from_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 128) { res->peer_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 128) { res->saved_id_ = TlFetchLong::parse(p); }
  if (var0 & 256) { res->resale_stars_ = TlFetchLong::parse(p); }
  if (var0 & 512) { res->can_transfer_at_ = TlFetchInt::parse(p); }
  if (var0 & 1024) { res->can_resell_at_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionStarGiftUnique::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionStarGiftUnique");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (upgrade_ << 0) | (transferred_ << 1) | (saved_ << 2) | (refunded_ << 5)));
    if (var0 & 1) { s.store_field("upgrade", true); }
    if (var0 & 2) { s.store_field("transferred", true); }
    if (var0 & 4) { s.store_field("saved", true); }
    if (var0 & 32) { s.store_field("refunded", true); }
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    if (var0 & 8) { s.store_field("can_export_at", can_export_at_); }
    if (var0 & 16) { s.store_field("transfer_stars", transfer_stars_); }
    if (var0 & 64) { s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get())); }
    if (var0 & 128) { s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get())); }
    if (var0 & 128) { s.store_field("saved_id", saved_id_); }
    if (var0 & 256) { s.store_field("resale_stars", resale_stars_); }
    if (var0 & 512) { s.store_field("can_transfer_at", can_transfer_at_); }
    if (var0 & 1024) { s.store_field("can_resell_at", can_resell_at_); }
    s.store_class_end();
  }
}

const std::int32_t messageActionPaidMessagesRefunded::ID;

object_ptr<MessageAction> messageActionPaidMessagesRefunded::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionPaidMessagesRefunded>(p);
}

messageActionPaidMessagesRefunded::messageActionPaidMessagesRefunded(TlBufferParser &p)
  : count_(TlFetchInt::parse(p))
  , stars_(TlFetchLong::parse(p))
{}

void messageActionPaidMessagesRefunded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPaidMessagesRefunded");
    s.store_field("count", count_);
    s.store_field("stars", stars_);
    s.store_class_end();
  }
}

messageActionPaidMessagesPrice::messageActionPaidMessagesPrice()
  : flags_()
  , broadcast_messages_allowed_()
  , stars_()
{}

const std::int32_t messageActionPaidMessagesPrice::ID;

object_ptr<MessageAction> messageActionPaidMessagesPrice::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionPaidMessagesPrice> res = make_tl_object<messageActionPaidMessagesPrice>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->broadcast_messages_allowed_ = (var0 & 1) != 0;
  res->stars_ = TlFetchLong::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionPaidMessagesPrice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionPaidMessagesPrice");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (broadcast_messages_allowed_ << 0)));
    if (var0 & 1) { s.store_field("broadcast_messages_allowed", true); }
    s.store_field("stars", stars_);
    s.store_class_end();
  }
}

messageActionConferenceCall::messageActionConferenceCall()
  : flags_()
  , missed_()
  , active_()
  , video_()
  , call_id_()
  , duration_()
  , other_participants_()
{}

const std::int32_t messageActionConferenceCall::ID;

object_ptr<MessageAction> messageActionConferenceCall::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionConferenceCall> res = make_tl_object<messageActionConferenceCall>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->missed_ = (var0 & 1) != 0;
  res->active_ = (var0 & 2) != 0;
  res->video_ = (var0 & 16) != 0;
  res->call_id_ = TlFetchLong::parse(p);
  if (var0 & 4) { res->duration_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->other_participants_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Peer>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionConferenceCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionConferenceCall");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (missed_ << 0) | (active_ << 1) | (video_ << 4)));
    if (var0 & 1) { s.store_field("missed", true); }
    if (var0 & 2) { s.store_field("active", true); }
    if (var0 & 16) { s.store_field("video", true); }
    s.store_field("call_id", call_id_);
    if (var0 & 4) { s.store_field("duration", duration_); }
    if (var0 & 8) { { s.store_vector_begin("other_participants", other_participants_.size()); for (const auto &_value : other_participants_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

const std::int32_t messageActionTodoCompletions::ID;

object_ptr<MessageAction> messageActionTodoCompletions::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionTodoCompletions>(p);
}

messageActionTodoCompletions::messageActionTodoCompletions(TlBufferParser &p)
  : completed_(TlFetchBoxed<TlFetchVector<TlFetchInt>, 481674261>::parse(p))
  , incompleted_(TlFetchBoxed<TlFetchVector<TlFetchInt>, 481674261>::parse(p))
{}

void messageActionTodoCompletions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionTodoCompletions");
    { s.store_vector_begin("completed", completed_.size()); for (const auto &_value : completed_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("incompleted", incompleted_.size()); for (const auto &_value : incompleted_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t messageActionTodoAppendTasks::ID;

object_ptr<MessageAction> messageActionTodoAppendTasks::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionTodoAppendTasks>(p);
}

messageActionTodoAppendTasks::messageActionTodoAppendTasks(TlBufferParser &p)
  : list_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<todoItem>, -878074577>>, 481674261>::parse(p))
{}

void messageActionTodoAppendTasks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionTodoAppendTasks");
    { s.store_vector_begin("list", list_.size()); for (const auto &_value : list_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageActionSuggestedPostApproval::messageActionSuggestedPostApproval()
  : flags_()
  , rejected_()
  , balance_too_low_()
  , reject_comment_()
  , schedule_date_()
  , price_()
{}

const std::int32_t messageActionSuggestedPostApproval::ID;

object_ptr<MessageAction> messageActionSuggestedPostApproval::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionSuggestedPostApproval> res = make_tl_object<messageActionSuggestedPostApproval>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->rejected_ = (var0 & 1) != 0;
  res->balance_too_low_ = (var0 & 2) != 0;
  if (var0 & 4) { res->reject_comment_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->schedule_date_ = TlFetchInt::parse(p); }
  if (var0 & 16) { res->price_ = TlFetchObject<StarsAmount>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionSuggestedPostApproval::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSuggestedPostApproval");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (rejected_ << 0) | (balance_too_low_ << 1)));
    if (var0 & 1) { s.store_field("rejected", true); }
    if (var0 & 2) { s.store_field("balance_too_low", true); }
    if (var0 & 4) { s.store_field("reject_comment", reject_comment_); }
    if (var0 & 8) { s.store_field("schedule_date", schedule_date_); }
    if (var0 & 16) { s.store_object_field("price", static_cast<const BaseObject *>(price_.get())); }
    s.store_class_end();
  }
}

const std::int32_t messageActionSuggestedPostSuccess::ID;

object_ptr<MessageAction> messageActionSuggestedPostSuccess::fetch(TlBufferParser &p) {
  return make_tl_object<messageActionSuggestedPostSuccess>(p);
}

messageActionSuggestedPostSuccess::messageActionSuggestedPostSuccess(TlBufferParser &p)
  : price_(TlFetchObject<StarsAmount>::parse(p))
{}

void messageActionSuggestedPostSuccess::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSuggestedPostSuccess");
    s.store_object_field("price", static_cast<const BaseObject *>(price_.get()));
    s.store_class_end();
  }
}

messageActionSuggestedPostRefund::messageActionSuggestedPostRefund()
  : flags_()
  , payer_initiated_()
{}

const std::int32_t messageActionSuggestedPostRefund::ID;

object_ptr<MessageAction> messageActionSuggestedPostRefund::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionSuggestedPostRefund> res = make_tl_object<messageActionSuggestedPostRefund>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->payer_initiated_ = (var0 & 1) != 0;
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionSuggestedPostRefund::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionSuggestedPostRefund");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (payer_initiated_ << 0)));
    if (var0 & 1) { s.store_field("payer_initiated", true); }
    s.store_class_end();
  }
}

messageActionGiftTon::messageActionGiftTon()
  : flags_()
  , currency_()
  , amount_()
  , crypto_currency_()
  , crypto_amount_()
  , transaction_id_()
{}

const std::int32_t messageActionGiftTon::ID;

object_ptr<MessageAction> messageActionGiftTon::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageActionGiftTon> res = make_tl_object<messageActionGiftTon>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->currency_ = TlFetchString<string>::parse(p);
  res->amount_ = TlFetchLong::parse(p);
  res->crypto_currency_ = TlFetchString<string>::parse(p);
  res->crypto_amount_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->transaction_id_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageActionGiftTon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageActionGiftTon");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("crypto_currency", crypto_currency_);
    s.store_field("crypto_amount", crypto_amount_);
    if (var0 & 1) { s.store_field("transaction_id", transaction_id_); }
    s.store_class_end();
  }
}

object_ptr<MessageEntity> MessageEntity::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageEntityUnknown::ID:
      return messageEntityUnknown::fetch(p);
    case messageEntityMention::ID:
      return messageEntityMention::fetch(p);
    case messageEntityHashtag::ID:
      return messageEntityHashtag::fetch(p);
    case messageEntityBotCommand::ID:
      return messageEntityBotCommand::fetch(p);
    case messageEntityUrl::ID:
      return messageEntityUrl::fetch(p);
    case messageEntityEmail::ID:
      return messageEntityEmail::fetch(p);
    case messageEntityBold::ID:
      return messageEntityBold::fetch(p);
    case messageEntityItalic::ID:
      return messageEntityItalic::fetch(p);
    case messageEntityCode::ID:
      return messageEntityCode::fetch(p);
    case messageEntityPre::ID:
      return messageEntityPre::fetch(p);
    case messageEntityTextUrl::ID:
      return messageEntityTextUrl::fetch(p);
    case messageEntityMentionName::ID:
      return messageEntityMentionName::fetch(p);
    case inputMessageEntityMentionName::ID:
      return inputMessageEntityMentionName::fetch(p);
    case messageEntityPhone::ID:
      return messageEntityPhone::fetch(p);
    case messageEntityCashtag::ID:
      return messageEntityCashtag::fetch(p);
    case messageEntityUnderline::ID:
      return messageEntityUnderline::fetch(p);
    case messageEntityStrike::ID:
      return messageEntityStrike::fetch(p);
    case messageEntityBankCard::ID:
      return messageEntityBankCard::fetch(p);
    case messageEntitySpoiler::ID:
      return messageEntitySpoiler::fetch(p);
    case messageEntityCustomEmoji::ID:
      return messageEntityCustomEmoji::fetch(p);
    case messageEntityBlockquote::ID:
      return messageEntityBlockquote::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

messageEntityUnknown::messageEntityUnknown(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityUnknown::ID;

object_ptr<MessageEntity> messageEntityUnknown::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityUnknown>(p);
}

messageEntityUnknown::messageEntityUnknown(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityUnknown::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUnknown::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUnknown::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityUnknown");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityMention::messageEntityMention(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityMention::ID;

object_ptr<MessageEntity> messageEntityMention::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityMention>(p);
}

messageEntityMention::messageEntityMention(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityMention::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityMention::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityMention");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityHashtag::messageEntityHashtag(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityHashtag::ID;

object_ptr<MessageEntity> messageEntityHashtag::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityHashtag>(p);
}

messageEntityHashtag::messageEntityHashtag(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityHashtag::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityHashtag::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityHashtag::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityHashtag");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityBotCommand::messageEntityBotCommand(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityBotCommand::ID;

object_ptr<MessageEntity> messageEntityBotCommand::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityBotCommand>(p);
}

messageEntityBotCommand::messageEntityBotCommand(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityBotCommand::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBotCommand::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBotCommand::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityBotCommand");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityUrl::messageEntityUrl(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityUrl::ID;

object_ptr<MessageEntity> messageEntityUrl::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityUrl>(p);
}

messageEntityUrl::messageEntityUrl(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityUrl::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUrl::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityUrl");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityEmail::messageEntityEmail(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityEmail::ID;

object_ptr<MessageEntity> messageEntityEmail::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityEmail>(p);
}

messageEntityEmail::messageEntityEmail(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityEmail::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityEmail::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityEmail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityEmail");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityBold::messageEntityBold(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityBold::ID;

object_ptr<MessageEntity> messageEntityBold::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityBold>(p);
}

messageEntityBold::messageEntityBold(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityBold::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBold::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBold::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityBold");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityItalic::messageEntityItalic(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityItalic::ID;

object_ptr<MessageEntity> messageEntityItalic::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityItalic>(p);
}

messageEntityItalic::messageEntityItalic(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityItalic::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityItalic::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityItalic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityItalic");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityCode::messageEntityCode(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityCode::ID;

object_ptr<MessageEntity> messageEntityCode::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityCode>(p);
}

messageEntityCode::messageEntityCode(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityCode::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityCode::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityCode");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityPre::messageEntityPre(int32 offset_, int32 length_, string const &language_)
  : offset_(offset_)
  , length_(length_)
  , language_(language_)
{}

const std::int32_t messageEntityPre::ID;

object_ptr<MessageEntity> messageEntityPre::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityPre>(p);
}

messageEntityPre::messageEntityPre(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
  , language_(TlFetchString<string>::parse(p))
{}

void messageEntityPre::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreString::store(language_, s);
}

void messageEntityPre::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreString::store(language_, s);
}

void messageEntityPre::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityPre");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_field("language", language_);
    s.store_class_end();
  }
}

messageEntityTextUrl::messageEntityTextUrl(int32 offset_, int32 length_, string const &url_)
  : offset_(offset_)
  , length_(length_)
  , url_(url_)
{}

const std::int32_t messageEntityTextUrl::ID;

object_ptr<MessageEntity> messageEntityTextUrl::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityTextUrl>(p);
}

messageEntityTextUrl::messageEntityTextUrl(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
  , url_(TlFetchString<string>::parse(p))
{}

void messageEntityTextUrl::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreString::store(url_, s);
}

void messageEntityTextUrl::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreString::store(url_, s);
}

void messageEntityTextUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityTextUrl");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

messageEntityMentionName::messageEntityMentionName(int32 offset_, int32 length_, int64 user_id_)
  : offset_(offset_)
  , length_(length_)
  , user_id_(user_id_)
{}

const std::int32_t messageEntityMentionName::ID;

object_ptr<MessageEntity> messageEntityMentionName::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityMentionName>(p);
}

messageEntityMentionName::messageEntityMentionName(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
  , user_id_(TlFetchLong::parse(p))
{}

void messageEntityMentionName::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBinary::store(user_id_, s);
}

void messageEntityMentionName::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBinary::store(user_id_, s);
}

void messageEntityMentionName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityMentionName");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

inputMessageEntityMentionName::inputMessageEntityMentionName(int32 offset_, int32 length_, object_ptr<InputUser> &&user_id_)
  : offset_(offset_)
  , length_(length_)
  , user_id_(std::move(user_id_))
{}

const std::int32_t inputMessageEntityMentionName::ID;

object_ptr<MessageEntity> inputMessageEntityMentionName::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessageEntityMentionName>(p);
}

inputMessageEntityMentionName::inputMessageEntityMentionName(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
  , user_id_(TlFetchObject<InputUser>::parse(p))
{}

void inputMessageEntityMentionName::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void inputMessageEntityMentionName::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBoxedUnknown<TlStoreObject>::store(user_id_, s);
}

void inputMessageEntityMentionName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageEntityMentionName");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_object_field("user_id", static_cast<const BaseObject *>(user_id_.get()));
    s.store_class_end();
  }
}

messageEntityPhone::messageEntityPhone(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityPhone::ID;

object_ptr<MessageEntity> messageEntityPhone::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityPhone>(p);
}

messageEntityPhone::messageEntityPhone(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityPhone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityPhone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityPhone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityPhone");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityCashtag::messageEntityCashtag(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityCashtag::ID;

object_ptr<MessageEntity> messageEntityCashtag::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityCashtag>(p);
}

messageEntityCashtag::messageEntityCashtag(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityCashtag::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityCashtag::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityCashtag::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityCashtag");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityUnderline::messageEntityUnderline(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityUnderline::ID;

object_ptr<MessageEntity> messageEntityUnderline::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityUnderline>(p);
}

messageEntityUnderline::messageEntityUnderline(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityUnderline::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUnderline::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityUnderline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityUnderline");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityStrike::messageEntityStrike(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityStrike::ID;

object_ptr<MessageEntity> messageEntityStrike::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityStrike>(p);
}

messageEntityStrike::messageEntityStrike(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityStrike::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityStrike::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityStrike::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityStrike");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityBankCard::messageEntityBankCard(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityBankCard::ID;

object_ptr<MessageEntity> messageEntityBankCard::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityBankCard>(p);
}

messageEntityBankCard::messageEntityBankCard(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntityBankCard::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBankCard::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBankCard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityBankCard");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntitySpoiler::messageEntitySpoiler(int32 offset_, int32 length_)
  : offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntitySpoiler::ID;

object_ptr<MessageEntity> messageEntitySpoiler::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntitySpoiler>(p);
}

messageEntitySpoiler::messageEntitySpoiler(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
{}

void messageEntitySpoiler::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntitySpoiler::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntitySpoiler::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntitySpoiler");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

messageEntityCustomEmoji::messageEntityCustomEmoji(int32 offset_, int32 length_, int64 document_id_)
  : offset_(offset_)
  , length_(length_)
  , document_id_(document_id_)
{}

const std::int32_t messageEntityCustomEmoji::ID;

object_ptr<MessageEntity> messageEntityCustomEmoji::fetch(TlBufferParser &p) {
  return make_tl_object<messageEntityCustomEmoji>(p);
}

messageEntityCustomEmoji::messageEntityCustomEmoji(TlBufferParser &p)
  : offset_(TlFetchInt::parse(p))
  , length_(TlFetchInt::parse(p))
  , document_id_(TlFetchLong::parse(p))
{}

void messageEntityCustomEmoji::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBinary::store(document_id_, s);
}

void messageEntityCustomEmoji::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
  TlStoreBinary::store(document_id_, s);
}

void messageEntityCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityCustomEmoji");
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_field("document_id", document_id_);
    s.store_class_end();
  }
}

messageEntityBlockquote::messageEntityBlockquote()
  : flags_()
  , collapsed_()
  , offset_()
  , length_()
{}

messageEntityBlockquote::messageEntityBlockquote(int32 flags_, bool collapsed_, int32 offset_, int32 length_)
  : flags_(flags_)
  , collapsed_(collapsed_)
  , offset_(offset_)
  , length_(length_)
{}

const std::int32_t messageEntityBlockquote::ID;

object_ptr<MessageEntity> messageEntityBlockquote::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageEntityBlockquote> res = make_tl_object<messageEntityBlockquote>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->collapsed_ = (var0 & 1) != 0;
  res->offset_ = TlFetchInt::parse(p);
  res->length_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageEntityBlockquote::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (collapsed_ << 0)), s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBlockquote::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (collapsed_ << 0)), s);
  TlStoreBinary::store(offset_, s);
  TlStoreBinary::store(length_, s);
}

void messageEntityBlockquote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEntityBlockquote");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (collapsed_ << 0)));
    if (var0 & 1) { s.store_field("collapsed", true); }
    s.store_field("offset", offset_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

object_ptr<MessageExtendedMedia> MessageExtendedMedia::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageExtendedMediaPreview::ID:
      return messageExtendedMediaPreview::fetch(p);
    case messageExtendedMedia::ID:
      return messageExtendedMedia::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

messageExtendedMediaPreview::messageExtendedMediaPreview()
  : flags_()
  , w_()
  , h_()
  , thumb_()
  , video_duration_()
{}

const std::int32_t messageExtendedMediaPreview::ID;

object_ptr<MessageExtendedMedia> messageExtendedMediaPreview::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageExtendedMediaPreview> res = make_tl_object<messageExtendedMediaPreview>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->w_ = TlFetchInt::parse(p); }
  if (var0 & 1) { res->h_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->thumb_ = TlFetchObject<PhotoSize>::parse(p); }
  if (var0 & 4) { res->video_duration_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageExtendedMediaPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExtendedMediaPreview");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("w", w_); }
    if (var0 & 1) { s.store_field("h", h_); }
    if (var0 & 2) { s.store_object_field("thumb", static_cast<const BaseObject *>(thumb_.get())); }
    if (var0 & 4) { s.store_field("video_duration", video_duration_); }
    s.store_class_end();
  }
}

const std::int32_t messageExtendedMedia::ID;

object_ptr<MessageExtendedMedia> messageExtendedMedia::fetch(TlBufferParser &p) {
  return make_tl_object<messageExtendedMedia>(p);
}

messageExtendedMedia::messageExtendedMedia(TlBufferParser &p)
  : media_(TlFetchObject<MessageMedia>::parse(p))
{}

void messageExtendedMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExtendedMedia");
    s.store_object_field("media", static_cast<const BaseObject *>(media_.get()));
    s.store_class_end();
  }
}

messageFwdHeader::messageFwdHeader()
  : flags_()
  , imported_()
  , saved_out_()
  , from_id_()
  , from_name_()
  , date_()
  , channel_post_()
  , post_author_()
  , saved_from_peer_()
  , saved_from_msg_id_()
  , saved_from_id_()
  , saved_from_name_()
  , saved_date_()
  , psa_type_()
{}

const std::int32_t messageFwdHeader::ID;

object_ptr<messageFwdHeader> messageFwdHeader::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageFwdHeader> res = make_tl_object<messageFwdHeader>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->imported_ = (var0 & 128) != 0;
  res->saved_out_ = (var0 & 2048) != 0;
  if (var0 & 1) { res->from_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 32) { res->from_name_ = TlFetchString<string>::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  if (var0 & 4) { res->channel_post_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->post_author_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->saved_from_peer_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 16) { res->saved_from_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 256) { res->saved_from_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 512) { res->saved_from_name_ = TlFetchString<string>::parse(p); }
  if (var0 & 1024) { res->saved_date_ = TlFetchInt::parse(p); }
  if (var0 & 64) { res->psa_type_ = TlFetchString<string>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messageFwdHeader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageFwdHeader");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (imported_ << 7) | (saved_out_ << 11)));
    if (var0 & 128) { s.store_field("imported", true); }
    if (var0 & 2048) { s.store_field("saved_out", true); }
    if (var0 & 1) { s.store_object_field("from_id", static_cast<const BaseObject *>(from_id_.get())); }
    if (var0 & 32) { s.store_field("from_name", from_name_); }
    s.store_field("date", date_);
    if (var0 & 4) { s.store_field("channel_post", channel_post_); }
    if (var0 & 8) { s.store_field("post_author", post_author_); }
    if (var0 & 16) { s.store_object_field("saved_from_peer", static_cast<const BaseObject *>(saved_from_peer_.get())); }
    if (var0 & 16) { s.store_field("saved_from_msg_id", saved_from_msg_id_); }
    if (var0 & 256) { s.store_object_field("saved_from_id", static_cast<const BaseObject *>(saved_from_id_.get())); }
    if (var0 & 512) { s.store_field("saved_from_name", saved_from_name_); }
    if (var0 & 1024) { s.store_field("saved_date", saved_date_); }
    if (var0 & 64) { s.store_field("psa_type", psa_type_); }
    s.store_class_end();
  }
}

object_ptr<MessageMedia> MessageMedia::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageMediaEmpty::ID:
      return messageMediaEmpty::fetch(p);
    case messageMediaPhoto::ID:
      return messageMediaPhoto::fetch(p);
    case messageMediaGeo::ID:
      return messageMediaGeo::fetch(p);
    case messageMediaContact::ID:
      return messageMediaContact::fetch(p);
    case messageMediaUnsupported::ID:
      return messageMediaUnsupported::fetch(p);
    case messageMediaDocument::ID:
      return messageMediaDocument::fetch(p);
    case messageMediaWebPage::ID:
      return messageMediaWebPage::fetch(p);
    case messageMediaVenue::ID:
      return messageMediaVenue::fetch(p);
    case messageMediaGame::ID:
      return messageMediaGame::fetch(p);
    case messageMediaInvoice::ID:
      return messageMediaInvoice::fetch(p);
    case messageMediaGeoLive::ID:
      return messageMediaGeoLive::fetch(p);
    case messageMediaPoll::ID:
      return messageMediaPoll::fetch(p);
    case messageMediaDice::ID:
      return messageMediaDice::fetch(p);
    case messageMediaStory::ID:
      return messageMediaStory::fetch(p);
    case messageMediaGiveaway::ID:
      return messageMediaGiveaway::fetch(p);
    case messageMediaGiveawayResults::ID:
      return messageMediaGiveawayResults::fetch(p);
    case messageMediaPaidMedia::ID:
      return messageMediaPaidMedia::fetch(p);
    case messageMediaToDo::ID:
      return messageMediaToDo::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t messageMediaEmpty::ID;

object_ptr<MessageMedia> messageMediaEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaEmpty>();
}

void messageMediaEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaEmpty");
    s.store_class_end();
  }
}

messageMediaPhoto::messageMediaPhoto()
  : flags_()
  , spoiler_()
  , photo_()
  , ttl_seconds_()
{}

const std::int32_t messageMediaPhoto::ID;

object_ptr<MessageMedia> messageMediaPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaPhoto> res = make_tl_object<messageMediaPhoto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->spoiler_ = (var0 & 8) != 0;
  if (var0 & 1) { res->photo_ = TlFetchObject<Photo>::parse(p); }
  if (var0 & 4) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (spoiler_ << 3)));
    if (var0 & 8) { s.store_field("spoiler", true); }
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    if (var0 & 4) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

const std::int32_t messageMediaGeo::ID;

object_ptr<MessageMedia> messageMediaGeo::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaGeo>(p);
}

messageMediaGeo::messageMediaGeo(TlBufferParser &p)
  : geo_(TlFetchObject<GeoPoint>::parse(p))
{}

void messageMediaGeo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaGeo");
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageMediaContact::ID;

object_ptr<MessageMedia> messageMediaContact::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaContact>(p);
}

messageMediaContact::messageMediaContact(TlBufferParser &p)
  : phone_number_(TlFetchString<string>::parse(p))
  , first_name_(TlFetchString<string>::parse(p))
  , last_name_(TlFetchString<string>::parse(p))
  , vcard_(TlFetchString<string>::parse(p))
  , user_id_(TlFetchLong::parse(p))
{}

void messageMediaContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaContact");
    s.store_field("phone_number", phone_number_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("vcard", vcard_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

const std::int32_t messageMediaUnsupported::ID;

object_ptr<MessageMedia> messageMediaUnsupported::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaUnsupported>();
}

void messageMediaUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaUnsupported");
    s.store_class_end();
  }
}

messageMediaDocument::messageMediaDocument()
  : flags_()
  , nopremium_()
  , spoiler_()
  , video_()
  , round_()
  , voice_()
  , document_()
  , alt_documents_()
  , video_cover_()
  , video_timestamp_()
  , ttl_seconds_()
{}

const std::int32_t messageMediaDocument::ID;

object_ptr<MessageMedia> messageMediaDocument::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaDocument> res = make_tl_object<messageMediaDocument>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->nopremium_ = (var0 & 8) != 0;
  res->spoiler_ = (var0 & 16) != 0;
  res->video_ = (var0 & 64) != 0;
  res->round_ = (var0 & 128) != 0;
  res->voice_ = (var0 & 256) != 0;
  if (var0 & 1) { res->document_ = TlFetchObject<Document>::parse(p); }
  if (var0 & 32) { res->alt_documents_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Document>>, 481674261>::parse(p); }
  if (var0 & 512) { res->video_cover_ = TlFetchObject<Photo>::parse(p); }
  if (var0 & 1024) { res->video_timestamp_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->ttl_seconds_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaDocument");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (nopremium_ << 3) | (spoiler_ << 4) | (video_ << 6) | (round_ << 7) | (voice_ << 8)));
    if (var0 & 8) { s.store_field("nopremium", true); }
    if (var0 & 16) { s.store_field("spoiler", true); }
    if (var0 & 64) { s.store_field("video", true); }
    if (var0 & 128) { s.store_field("round", true); }
    if (var0 & 256) { s.store_field("voice", true); }
    if (var0 & 1) { s.store_object_field("document", static_cast<const BaseObject *>(document_.get())); }
    if (var0 & 32) { { s.store_vector_begin("alt_documents", alt_documents_.size()); for (const auto &_value : alt_documents_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 512) { s.store_object_field("video_cover", static_cast<const BaseObject *>(video_cover_.get())); }
    if (var0 & 1024) { s.store_field("video_timestamp", video_timestamp_); }
    if (var0 & 4) { s.store_field("ttl_seconds", ttl_seconds_); }
    s.store_class_end();
  }
}

messageMediaWebPage::messageMediaWebPage()
  : flags_()
  , force_large_media_()
  , force_small_media_()
  , manual_()
  , safe_()
  , webpage_()
{}

const std::int32_t messageMediaWebPage::ID;

object_ptr<MessageMedia> messageMediaWebPage::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaWebPage> res = make_tl_object<messageMediaWebPage>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->force_large_media_ = (var0 & 1) != 0;
  res->force_small_media_ = (var0 & 2) != 0;
  res->manual_ = (var0 & 8) != 0;
  res->safe_ = (var0 & 16) != 0;
  res->webpage_ = TlFetchObject<WebPage>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaWebPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaWebPage");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (force_large_media_ << 0) | (force_small_media_ << 1) | (manual_ << 3) | (safe_ << 4)));
    if (var0 & 1) { s.store_field("force_large_media", true); }
    if (var0 & 2) { s.store_field("force_small_media", true); }
    if (var0 & 8) { s.store_field("manual", true); }
    if (var0 & 16) { s.store_field("safe", true); }
    s.store_object_field("webpage", static_cast<const BaseObject *>(webpage_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageMediaVenue::ID;

object_ptr<MessageMedia> messageMediaVenue::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaVenue>(p);
}

messageMediaVenue::messageMediaVenue(TlBufferParser &p)
  : geo_(TlFetchObject<GeoPoint>::parse(p))
  , title_(TlFetchString<string>::parse(p))
  , address_(TlFetchString<string>::parse(p))
  , provider_(TlFetchString<string>::parse(p))
  , venue_id_(TlFetchString<string>::parse(p))
  , venue_type_(TlFetchString<string>::parse(p))
{}

void messageMediaVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaVenue");
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    s.store_field("title", title_);
    s.store_field("address", address_);
    s.store_field("provider", provider_);
    s.store_field("venue_id", venue_id_);
    s.store_field("venue_type", venue_type_);
    s.store_class_end();
  }
}

const std::int32_t messageMediaGame::ID;

object_ptr<MessageMedia> messageMediaGame::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaGame>(p);
}

messageMediaGame::messageMediaGame(TlBufferParser &p)
  : game_(TlFetchBoxed<TlFetchObject<game>, -1107729093>::parse(p))
{}

void messageMediaGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaGame");
    s.store_object_field("game", static_cast<const BaseObject *>(game_.get()));
    s.store_class_end();
  }
}

messageMediaInvoice::messageMediaInvoice()
  : flags_()
  , shipping_address_requested_()
  , test_()
  , title_()
  , description_()
  , photo_()
  , receipt_msg_id_()
  , currency_()
  , total_amount_()
  , start_param_()
  , extended_media_()
{}

const std::int32_t messageMediaInvoice::ID;

object_ptr<MessageMedia> messageMediaInvoice::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaInvoice> res = make_tl_object<messageMediaInvoice>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->shipping_address_requested_ = (var0 & 2) != 0;
  res->test_ = (var0 & 8) != 0;
  res->title_ = TlFetchString<string>::parse(p);
  res->description_ = TlFetchString<string>::parse(p);
  if (var0 & 1) { res->photo_ = TlFetchObject<WebDocument>::parse(p); }
  if (var0 & 4) { res->receipt_msg_id_ = TlFetchInt::parse(p); }
  res->currency_ = TlFetchString<string>::parse(p);
  res->total_amount_ = TlFetchLong::parse(p);
  res->start_param_ = TlFetchString<string>::parse(p);
  if (var0 & 16) { res->extended_media_ = TlFetchObject<MessageExtendedMedia>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaInvoice");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (shipping_address_requested_ << 1) | (test_ << 3)));
    if (var0 & 2) { s.store_field("shipping_address_requested", true); }
    if (var0 & 8) { s.store_field("test", true); }
    s.store_field("title", title_);
    s.store_field("description", description_);
    if (var0 & 1) { s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get())); }
    if (var0 & 4) { s.store_field("receipt_msg_id", receipt_msg_id_); }
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_field("start_param", start_param_);
    if (var0 & 16) { s.store_object_field("extended_media", static_cast<const BaseObject *>(extended_media_.get())); }
    s.store_class_end();
  }
}

messageMediaGeoLive::messageMediaGeoLive()
  : flags_()
  , geo_()
  , heading_()
  , period_()
  , proximity_notification_radius_()
{}

const std::int32_t messageMediaGeoLive::ID;

object_ptr<MessageMedia> messageMediaGeoLive::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaGeoLive> res = make_tl_object<messageMediaGeoLive>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->geo_ = TlFetchObject<GeoPoint>::parse(p);
  if (var0 & 1) { res->heading_ = TlFetchInt::parse(p); }
  res->period_ = TlFetchInt::parse(p);
  if (var0 & 2) { res->proximity_notification_radius_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaGeoLive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaGeoLive");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    if (var0 & 1) { s.store_field("heading", heading_); }
    s.store_field("period", period_);
    if (var0 & 2) { s.store_field("proximity_notification_radius", proximity_notification_radius_); }
    s.store_class_end();
  }
}

const std::int32_t messageMediaPoll::ID;

object_ptr<MessageMedia> messageMediaPoll::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaPoll>(p);
}

messageMediaPoll::messageMediaPoll(TlBufferParser &p)
  : poll_(TlFetchBoxed<TlFetchObject<poll>, 1484026161>::parse(p))
  , results_(TlFetchBoxed<TlFetchObject<pollResults>, 2061444128>::parse(p))
{}

void messageMediaPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaPoll");
    s.store_object_field("poll", static_cast<const BaseObject *>(poll_.get()));
    s.store_object_field("results", static_cast<const BaseObject *>(results_.get()));
    s.store_class_end();
  }
}

const std::int32_t messageMediaDice::ID;

object_ptr<MessageMedia> messageMediaDice::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaDice>(p);
}

messageMediaDice::messageMediaDice(TlBufferParser &p)
  : value_(TlFetchInt::parse(p))
  , emoticon_(TlFetchString<string>::parse(p))
{}

void messageMediaDice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaDice");
    s.store_field("value", value_);
    s.store_field("emoticon", emoticon_);
    s.store_class_end();
  }
}

messageMediaStory::messageMediaStory()
  : flags_()
  , via_mention_()
  , peer_()
  , id_()
  , story_()
{}

const std::int32_t messageMediaStory::ID;

object_ptr<MessageMedia> messageMediaStory::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaStory> res = make_tl_object<messageMediaStory>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->via_mention_ = (var0 & 2) != 0;
  res->peer_ = TlFetchObject<Peer>::parse(p);
  res->id_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->story_ = TlFetchObject<StoryItem>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaStory");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (via_mention_ << 1)));
    if (var0 & 2) { s.store_field("via_mention", true); }
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("id", id_);
    if (var0 & 1) { s.store_object_field("story", static_cast<const BaseObject *>(story_.get())); }
    s.store_class_end();
  }
}

messageMediaGiveaway::messageMediaGiveaway()
  : flags_()
  , only_new_subscribers_()
  , winners_are_visible_()
  , channels_()
  , countries_iso2_()
  , prize_description_()
  , quantity_()
  , months_()
  , stars_()
  , until_date_()
{}

const std::int32_t messageMediaGiveaway::ID;

object_ptr<MessageMedia> messageMediaGiveaway::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaGiveaway> res = make_tl_object<messageMediaGiveaway>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->only_new_subscribers_ = (var0 & 1) != 0;
  res->winners_are_visible_ = (var0 & 4) != 0;
  res->channels_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p);
  if (var0 & 2) { res->countries_iso2_ = TlFetchBoxed<TlFetchVector<TlFetchString<string>>, 481674261>::parse(p); }
  if (var0 & 8) { res->prize_description_ = TlFetchString<string>::parse(p); }
  res->quantity_ = TlFetchInt::parse(p);
  if (var0 & 16) { res->months_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->stars_ = TlFetchLong::parse(p); }
  res->until_date_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaGiveaway");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (only_new_subscribers_ << 0) | (winners_are_visible_ << 2)));
    if (var0 & 1) { s.store_field("only_new_subscribers", true); }
    if (var0 & 4) { s.store_field("winners_are_visible", true); }
    { s.store_vector_begin("channels", channels_.size()); for (const auto &_value : channels_) { s.store_field("", _value); } s.store_class_end(); }
    if (var0 & 2) { { s.store_vector_begin("countries_iso2", countries_iso2_.size()); for (const auto &_value : countries_iso2_) { s.store_field("", _value); } s.store_class_end(); } }
    if (var0 & 8) { s.store_field("prize_description", prize_description_); }
    s.store_field("quantity", quantity_);
    if (var0 & 16) { s.store_field("months", months_); }
    if (var0 & 32) { s.store_field("stars", stars_); }
    s.store_field("until_date", until_date_);
    s.store_class_end();
  }
}

messageMediaGiveawayResults::messageMediaGiveawayResults()
  : flags_()
  , only_new_subscribers_()
  , refunded_()
  , channel_id_()
  , additional_peers_count_()
  , launch_msg_id_()
  , winners_count_()
  , unclaimed_count_()
  , winners_()
  , months_()
  , stars_()
  , prize_description_()
  , until_date_()
{}

const std::int32_t messageMediaGiveawayResults::ID;

object_ptr<MessageMedia> messageMediaGiveawayResults::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaGiveawayResults> res = make_tl_object<messageMediaGiveawayResults>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->only_new_subscribers_ = (var0 & 1) != 0;
  res->refunded_ = (var0 & 4) != 0;
  res->channel_id_ = TlFetchLong::parse(p);
  if (var0 & 8) { res->additional_peers_count_ = TlFetchInt::parse(p); }
  res->launch_msg_id_ = TlFetchInt::parse(p);
  res->winners_count_ = TlFetchInt::parse(p);
  res->unclaimed_count_ = TlFetchInt::parse(p);
  res->winners_ = TlFetchBoxed<TlFetchVector<TlFetchLong>, 481674261>::parse(p);
  if (var0 & 16) { res->months_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->stars_ = TlFetchLong::parse(p); }
  if (var0 & 2) { res->prize_description_ = TlFetchString<string>::parse(p); }
  res->until_date_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaGiveawayResults::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaGiveawayResults");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (only_new_subscribers_ << 0) | (refunded_ << 2)));
    if (var0 & 1) { s.store_field("only_new_subscribers", true); }
    if (var0 & 4) { s.store_field("refunded", true); }
    s.store_field("channel_id", channel_id_);
    if (var0 & 8) { s.store_field("additional_peers_count", additional_peers_count_); }
    s.store_field("launch_msg_id", launch_msg_id_);
    s.store_field("winners_count", winners_count_);
    s.store_field("unclaimed_count", unclaimed_count_);
    { s.store_vector_begin("winners", winners_.size()); for (const auto &_value : winners_) { s.store_field("", _value); } s.store_class_end(); }
    if (var0 & 16) { s.store_field("months", months_); }
    if (var0 & 32) { s.store_field("stars", stars_); }
    if (var0 & 2) { s.store_field("prize_description", prize_description_); }
    s.store_field("until_date", until_date_);
    s.store_class_end();
  }
}

const std::int32_t messageMediaPaidMedia::ID;

object_ptr<MessageMedia> messageMediaPaidMedia::fetch(TlBufferParser &p) {
  return make_tl_object<messageMediaPaidMedia>(p);
}

messageMediaPaidMedia::messageMediaPaidMedia(TlBufferParser &p)
  : stars_amount_(TlFetchLong::parse(p))
  , extended_media_(TlFetchBoxed<TlFetchVector<TlFetchObject<MessageExtendedMedia>>, 481674261>::parse(p))
{}

void messageMediaPaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaPaidMedia");
    s.store_field("stars_amount", stars_amount_);
    { s.store_vector_begin("extended_media", extended_media_.size()); for (const auto &_value : extended_media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageMediaToDo::messageMediaToDo()
  : flags_()
  , todo_()
  , completions_()
{}

const std::int32_t messageMediaToDo::ID;

object_ptr<MessageMedia> messageMediaToDo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageMediaToDo> res = make_tl_object<messageMediaToDo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->todo_ = TlFetchBoxed<TlFetchObject<todoList>, 1236871718>::parse(p);
  if (var0 & 1) { res->completions_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<todoCompletion>, 1287725239>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageMediaToDo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageMediaToDo");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_object_field("todo", static_cast<const BaseObject *>(todo_.get()));
    if (var0 & 1) { { s.store_vector_begin("completions", completions_.size()); for (const auto &_value : completions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

messagePeerReaction::messagePeerReaction()
  : flags_()
  , big_()
  , unread_()
  , my_()
  , peer_id_()
  , date_()
  , reaction_()
{}

const std::int32_t messagePeerReaction::ID;

object_ptr<messagePeerReaction> messagePeerReaction::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messagePeerReaction> res = make_tl_object<messagePeerReaction>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->big_ = (var0 & 1) != 0;
  res->unread_ = (var0 & 2) != 0;
  res->my_ = (var0 & 4) != 0;
  res->peer_id_ = TlFetchObject<Peer>::parse(p);
  res->date_ = TlFetchInt::parse(p);
  res->reaction_ = TlFetchObject<Reaction>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messagePeerReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePeerReaction");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (big_ << 0) | (unread_ << 1) | (my_ << 2)));
    if (var0 & 1) { s.store_field("big", true); }
    if (var0 & 2) { s.store_field("unread", true); }
    if (var0 & 4) { s.store_field("my", true); }
    s.store_object_field("peer_id", static_cast<const BaseObject *>(peer_id_.get()));
    s.store_field("date", date_);
    s.store_object_field("reaction", static_cast<const BaseObject *>(reaction_.get()));
    s.store_class_end();
  }
}

object_ptr<MessagePeerVote> MessagePeerVote::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messagePeerVote::ID:
      return messagePeerVote::fetch(p);
    case messagePeerVoteInputOption::ID:
      return messagePeerVoteInputOption::fetch(p);
    case messagePeerVoteMultiple::ID:
      return messagePeerVoteMultiple::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t messagePeerVote::ID;

object_ptr<MessagePeerVote> messagePeerVote::fetch(TlBufferParser &p) {
  return make_tl_object<messagePeerVote>(p);
}

messagePeerVote::messagePeerVote(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , option_(TlFetchBytes<bytes>::parse(p))
  , date_(TlFetchInt::parse(p))
{}

void messagePeerVote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePeerVote");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_bytes_field("option", option_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

const std::int32_t messagePeerVoteInputOption::ID;

object_ptr<MessagePeerVote> messagePeerVoteInputOption::fetch(TlBufferParser &p) {
  return make_tl_object<messagePeerVoteInputOption>(p);
}

messagePeerVoteInputOption::messagePeerVoteInputOption(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , date_(TlFetchInt::parse(p))
{}

void messagePeerVoteInputOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePeerVoteInputOption");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("date", date_);
    s.store_class_end();
  }
}

const std::int32_t messagePeerVoteMultiple::ID;

object_ptr<MessagePeerVote> messagePeerVoteMultiple::fetch(TlBufferParser &p) {
  return make_tl_object<messagePeerVoteMultiple>(p);
}

messagePeerVoteMultiple::messagePeerVoteMultiple(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , options_(TlFetchBoxed<TlFetchVector<TlFetchBytes<bytes>>, 481674261>::parse(p))
  , date_(TlFetchInt::parse(p))
{}

void messagePeerVoteMultiple::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePeerVoteMultiple");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_bytes_field("", _value); } s.store_class_end(); }
    s.store_field("date", date_);
    s.store_class_end();
  }
}

messageRange::messageRange(int32 min_id_, int32 max_id_)
  : min_id_(min_id_)
  , max_id_(max_id_)
{}

const std::int32_t messageRange::ID;

object_ptr<messageRange> messageRange::fetch(TlBufferParser &p) {
  return make_tl_object<messageRange>(p);
}

messageRange::messageRange(TlBufferParser &p)
  : min_id_(TlFetchInt::parse(p))
  , max_id_(TlFetchInt::parse(p))
{}

void messageRange::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(min_id_, s);
  TlStoreBinary::store(max_id_, s);
}

void messageRange::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(min_id_, s);
  TlStoreBinary::store(max_id_, s);
}

void messageRange::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageRange");
    s.store_field("min_id", min_id_);
    s.store_field("max_id", max_id_);
    s.store_class_end();
  }
}

messageReactions::messageReactions()
  : flags_()
  , min_()
  , can_see_list_()
  , reactions_as_tags_()
  , results_()
  , recent_reactions_()
  , top_reactors_()
{}

const std::int32_t messageReactions::ID;

object_ptr<messageReactions> messageReactions::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageReactions> res = make_tl_object<messageReactions>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->min_ = (var0 & 1) != 0;
  res->can_see_list_ = (var0 & 4) != 0;
  res->reactions_as_tags_ = (var0 & 8) != 0;
  res->results_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<reactionCount>, -1546531968>>, 481674261>::parse(p);
  if (var0 & 2) { res->recent_reactions_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<messagePeerReaction>, -1938180548>>, 481674261>::parse(p); }
  if (var0 & 16) { res->top_reactors_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<messageReactor>, 1269016922>>, 481674261>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messageReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReactions");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (min_ << 0) | (can_see_list_ << 2) | (reactions_as_tags_ << 3)));
    if (var0 & 1) { s.store_field("min", true); }
    if (var0 & 4) { s.store_field("can_see_list", true); }
    if (var0 & 8) { s.store_field("reactions_as_tags", true); }
    { s.store_vector_begin("results", results_.size()); for (const auto &_value : results_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 2) { { s.store_vector_begin("recent_reactions", recent_reactions_.size()); for (const auto &_value : recent_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 16) { { s.store_vector_begin("top_reactors", top_reactors_.size()); for (const auto &_value : top_reactors_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    s.store_class_end();
  }
}

messageReactor::messageReactor()
  : flags_()
  , top_()
  , my_()
  , anonymous_()
  , peer_id_()
  , count_()
{}

const std::int32_t messageReactor::ID;

object_ptr<messageReactor> messageReactor::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageReactor> res = make_tl_object<messageReactor>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->top_ = (var0 & 1) != 0;
  res->my_ = (var0 & 2) != 0;
  res->anonymous_ = (var0 & 4) != 0;
  if (var0 & 8) { res->peer_id_ = TlFetchObject<Peer>::parse(p); }
  res->count_ = TlFetchInt::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messageReactor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReactor");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (top_ << 0) | (my_ << 1) | (anonymous_ << 2)));
    if (var0 & 1) { s.store_field("top", true); }
    if (var0 & 2) { s.store_field("my", true); }
    if (var0 & 4) { s.store_field("anonymous", true); }
    if (var0 & 8) { s.store_object_field("peer_id", static_cast<const BaseObject *>(peer_id_.get())); }
    s.store_field("count", count_);
    s.store_class_end();
  }
}

messageReplies::messageReplies()
  : flags_()
  , comments_()
  , replies_()
  , replies_pts_()
  , recent_repliers_()
  , channel_id_()
  , max_id_()
  , read_max_id_()
{}

const std::int32_t messageReplies::ID;

object_ptr<messageReplies> messageReplies::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageReplies> res = make_tl_object<messageReplies>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->comments_ = (var0 & 1) != 0;
  res->replies_ = TlFetchInt::parse(p);
  res->replies_pts_ = TlFetchInt::parse(p);
  if (var0 & 2) { res->recent_repliers_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Peer>>, 481674261>::parse(p); }
  if (var0 & 1) { res->channel_id_ = TlFetchLong::parse(p); }
  if (var0 & 4) { res->max_id_ = TlFetchInt::parse(p); }
  if (var0 & 8) { res->read_max_id_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messageReplies::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplies");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (comments_ << 0)));
    if (var0 & 1) { s.store_field("comments", true); }
    s.store_field("replies", replies_);
    s.store_field("replies_pts", replies_pts_);
    if (var0 & 2) { { s.store_vector_begin("recent_repliers", recent_repliers_.size()); for (const auto &_value : recent_repliers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 1) { s.store_field("channel_id", channel_id_); }
    if (var0 & 4) { s.store_field("max_id", max_id_); }
    if (var0 & 8) { s.store_field("read_max_id", read_max_id_); }
    s.store_class_end();
  }
}

object_ptr<MessageReplyHeader> MessageReplyHeader::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case messageReplyHeader::ID:
      return messageReplyHeader::fetch(p);
    case messageReplyStoryHeader::ID:
      return messageReplyStoryHeader::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

messageReplyHeader::messageReplyHeader()
  : flags_()
  , reply_to_scheduled_()
  , forum_topic_()
  , quote_()
  , reply_to_msg_id_()
  , reply_to_peer_id_()
  , reply_from_()
  , reply_media_()
  , reply_to_top_id_()
  , quote_text_()
  , quote_entities_()
  , quote_offset_()
  , todo_item_id_()
{}

const std::int32_t messageReplyHeader::ID;

object_ptr<MessageReplyHeader> messageReplyHeader::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageReplyHeader> res = make_tl_object<messageReplyHeader>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->reply_to_scheduled_ = (var0 & 4) != 0;
  res->forum_topic_ = (var0 & 8) != 0;
  res->quote_ = (var0 & 512) != 0;
  if (var0 & 16) { res->reply_to_msg_id_ = TlFetchInt::parse(p); }
  if (var0 & 1) { res->reply_to_peer_id_ = TlFetchObject<Peer>::parse(p); }
  if (var0 & 32) { res->reply_from_ = TlFetchBoxed<TlFetchObject<messageFwdHeader>, 1313731771>::parse(p); }
  if (var0 & 256) { res->reply_media_ = TlFetchObject<MessageMedia>::parse(p); }
  if (var0 & 2) { res->reply_to_top_id_ = TlFetchInt::parse(p); }
  if (var0 & 64) { res->quote_text_ = TlFetchString<string>::parse(p); }
  if (var0 & 128) { res->quote_entities_ = TlFetchBoxed<TlFetchVector<TlFetchObject<MessageEntity>>, 481674261>::parse(p); }
  if (var0 & 1024) { res->quote_offset_ = TlFetchInt::parse(p); }
  if (var0 & 2048) { res->todo_item_id_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void messageReplyHeader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplyHeader");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (reply_to_scheduled_ << 2) | (forum_topic_ << 3) | (quote_ << 9)));
    if (var0 & 4) { s.store_field("reply_to_scheduled", true); }
    if (var0 & 8) { s.store_field("forum_topic", true); }
    if (var0 & 512) { s.store_field("quote", true); }
    if (var0 & 16) { s.store_field("reply_to_msg_id", reply_to_msg_id_); }
    if (var0 & 1) { s.store_object_field("reply_to_peer_id", static_cast<const BaseObject *>(reply_to_peer_id_.get())); }
    if (var0 & 32) { s.store_object_field("reply_from", static_cast<const BaseObject *>(reply_from_.get())); }
    if (var0 & 256) { s.store_object_field("reply_media", static_cast<const BaseObject *>(reply_media_.get())); }
    if (var0 & 2) { s.store_field("reply_to_top_id", reply_to_top_id_); }
    if (var0 & 64) { s.store_field("quote_text", quote_text_); }
    if (var0 & 128) { { s.store_vector_begin("quote_entities", quote_entities_.size()); for (const auto &_value : quote_entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); } }
    if (var0 & 1024) { s.store_field("quote_offset", quote_offset_); }
    if (var0 & 2048) { s.store_field("todo_item_id", todo_item_id_); }
    s.store_class_end();
  }
}

const std::int32_t messageReplyStoryHeader::ID;

object_ptr<MessageReplyHeader> messageReplyStoryHeader::fetch(TlBufferParser &p) {
  return make_tl_object<messageReplyStoryHeader>(p);
}

messageReplyStoryHeader::messageReplyStoryHeader(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , story_id_(TlFetchInt::parse(p))
{}

void messageReplyStoryHeader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplyStoryHeader");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

const std::int32_t messageReportOption::ID;

object_ptr<messageReportOption> messageReportOption::fetch(TlBufferParser &p) {
  return make_tl_object<messageReportOption>(p);
}

messageReportOption::messageReportOption(TlBufferParser &p)
  : text_(TlFetchString<string>::parse(p))
  , option_(TlFetchBytes<bytes>::parse(p))
{}

void messageReportOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReportOption");
    s.store_field("text", text_);
    s.store_bytes_field("option", option_);
    s.store_class_end();
  }
}

messageViews::messageViews()
  : flags_()
  , views_()
  , forwards_()
  , replies_()
{}

const std::int32_t messageViews::ID;

object_ptr<messageViews> messageViews::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<messageViews> res = make_tl_object<messageViews>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->views_ = TlFetchInt::parse(p); }
  if (var0 & 2) { res->forwards_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->replies_ = TlFetchBoxed<TlFetchObject<messageReplies>, -2083123262>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void messageViews::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageViews");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    if (var0 & 1) { s.store_field("views", views_); }
    if (var0 & 2) { s.store_field("forwards", forwards_); }
    if (var0 & 4) { s.store_object_field("replies", static_cast<const BaseObject *>(replies_.get())); }
    s.store_class_end();
  }
}

object_ptr<MessagesFilter> MessagesFilter::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case inputMessagesFilterEmpty::ID:
      return inputMessagesFilterEmpty::fetch(p);
    case inputMessagesFilterPhotos::ID:
      return inputMessagesFilterPhotos::fetch(p);
    case inputMessagesFilterVideo::ID:
      return inputMessagesFilterVideo::fetch(p);
    case inputMessagesFilterPhotoVideo::ID:
      return inputMessagesFilterPhotoVideo::fetch(p);
    case inputMessagesFilterDocument::ID:
      return inputMessagesFilterDocument::fetch(p);
    case inputMessagesFilterUrl::ID:
      return inputMessagesFilterUrl::fetch(p);
    case inputMessagesFilterGif::ID:
      return inputMessagesFilterGif::fetch(p);
    case inputMessagesFilterVoice::ID:
      return inputMessagesFilterVoice::fetch(p);
    case inputMessagesFilterMusic::ID:
      return inputMessagesFilterMusic::fetch(p);
    case inputMessagesFilterChatPhotos::ID:
      return inputMessagesFilterChatPhotos::fetch(p);
    case inputMessagesFilterPhoneCalls::ID:
      return inputMessagesFilterPhoneCalls::fetch(p);
    case inputMessagesFilterRoundVoice::ID:
      return inputMessagesFilterRoundVoice::fetch(p);
    case inputMessagesFilterRoundVideo::ID:
      return inputMessagesFilterRoundVideo::fetch(p);
    case inputMessagesFilterMyMentions::ID:
      return inputMessagesFilterMyMentions::fetch(p);
    case inputMessagesFilterGeo::ID:
      return inputMessagesFilterGeo::fetch(p);
    case inputMessagesFilterContacts::ID:
      return inputMessagesFilterContacts::fetch(p);
    case inputMessagesFilterPinned::ID:
      return inputMessagesFilterPinned::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t inputMessagesFilterEmpty::ID;

object_ptr<MessagesFilter> inputMessagesFilterEmpty::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterEmpty>();
}

void inputMessagesFilterEmpty::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterEmpty::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterEmpty");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterPhotos::ID;

object_ptr<MessagesFilter> inputMessagesFilterPhotos::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterPhotos>();
}

void inputMessagesFilterPhotos::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPhotos::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPhotos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterPhotos");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterVideo::ID;

object_ptr<MessagesFilter> inputMessagesFilterVideo::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterVideo>();
}

void inputMessagesFilterVideo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterVideo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterVideo");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterPhotoVideo::ID;

object_ptr<MessagesFilter> inputMessagesFilterPhotoVideo::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterPhotoVideo>();
}

void inputMessagesFilterPhotoVideo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPhotoVideo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPhotoVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterPhotoVideo");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterDocument::ID;

object_ptr<MessagesFilter> inputMessagesFilterDocument::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterDocument>();
}

void inputMessagesFilterDocument::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterDocument::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterDocument");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterUrl::ID;

object_ptr<MessagesFilter> inputMessagesFilterUrl::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterUrl>();
}

void inputMessagesFilterUrl::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterUrl::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterUrl");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterGif::ID;

object_ptr<MessagesFilter> inputMessagesFilterGif::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterGif>();
}

void inputMessagesFilterGif::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterGif::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterGif::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterGif");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterVoice::ID;

object_ptr<MessagesFilter> inputMessagesFilterVoice::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterVoice>();
}

void inputMessagesFilterVoice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterVoice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterVoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterVoice");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterMusic::ID;

object_ptr<MessagesFilter> inputMessagesFilterMusic::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterMusic>();
}

void inputMessagesFilterMusic::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterMusic::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterMusic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterMusic");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterChatPhotos::ID;

object_ptr<MessagesFilter> inputMessagesFilterChatPhotos::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterChatPhotos>();
}

void inputMessagesFilterChatPhotos::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterChatPhotos::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterChatPhotos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterChatPhotos");
    s.store_class_end();
  }
}

inputMessagesFilterPhoneCalls::inputMessagesFilterPhoneCalls()
  : flags_()
  , missed_()
{}

inputMessagesFilterPhoneCalls::inputMessagesFilterPhoneCalls(int32 flags_, bool missed_)
  : flags_(flags_)
  , missed_(missed_)
{}

const std::int32_t inputMessagesFilterPhoneCalls::ID;

object_ptr<MessagesFilter> inputMessagesFilterPhoneCalls::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<inputMessagesFilterPhoneCalls> res = make_tl_object<inputMessagesFilterPhoneCalls>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->missed_ = (var0 & 1) != 0;
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void inputMessagesFilterPhoneCalls::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (missed_ << 0)), s);
}

void inputMessagesFilterPhoneCalls::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_ | (missed_ << 0)), s);
}

void inputMessagesFilterPhoneCalls::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterPhoneCalls");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (missed_ << 0)));
    if (var0 & 1) { s.store_field("missed", true); }
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterRoundVoice::ID;

object_ptr<MessagesFilter> inputMessagesFilterRoundVoice::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterRoundVoice>();
}

void inputMessagesFilterRoundVoice::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterRoundVoice::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterRoundVoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterRoundVoice");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterRoundVideo::ID;

object_ptr<MessagesFilter> inputMessagesFilterRoundVideo::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterRoundVideo>();
}

void inputMessagesFilterRoundVideo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterRoundVideo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterRoundVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterRoundVideo");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterMyMentions::ID;

object_ptr<MessagesFilter> inputMessagesFilterMyMentions::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterMyMentions>();
}

void inputMessagesFilterMyMentions::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterMyMentions::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterMyMentions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterMyMentions");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterGeo::ID;

object_ptr<MessagesFilter> inputMessagesFilterGeo::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterGeo>();
}

void inputMessagesFilterGeo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterGeo::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterGeo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterGeo");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterContacts::ID;

object_ptr<MessagesFilter> inputMessagesFilterContacts::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterContacts>();
}

void inputMessagesFilterContacts::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterContacts::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterContacts");
    s.store_class_end();
  }
}

const std::int32_t inputMessagesFilterPinned::ID;

object_ptr<MessagesFilter> inputMessagesFilterPinned::fetch(TlBufferParser &p) {
  return make_tl_object<inputMessagesFilterPinned>();
}

void inputMessagesFilterPinned::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPinned::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void inputMessagesFilterPinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagesFilterPinned");
    s.store_class_end();
  }
}

missingInvitee::missingInvitee()
  : flags_()
  , premium_would_allow_invite_()
  , premium_required_for_pm_()
  , user_id_()
{}

const std::int32_t missingInvitee::ID;

object_ptr<missingInvitee> missingInvitee::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<missingInvitee> res = make_tl_object<missingInvitee>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->premium_would_allow_invite_ = (var0 & 1) != 0;
  res->premium_required_for_pm_ = (var0 & 2) != 0;
  res->user_id_ = TlFetchLong::parse(p);
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void missingInvitee::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "missingInvitee");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (premium_would_allow_invite_ << 0) | (premium_required_for_pm_ << 1)));
    if (var0 & 1) { s.store_field("premium_would_allow_invite", true); }
    if (var0 & 2) { s.store_field("premium_required_for_pm", true); }
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

myBoost::myBoost()
  : flags_()
  , slot_()
  , peer_()
  , date_()
  , expires_()
  , cooldown_until_date_()
{}

const std::int32_t myBoost::ID;

object_ptr<myBoost> myBoost::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<myBoost> res = make_tl_object<myBoost>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->slot_ = TlFetchInt::parse(p);
  if (var0 & 1) { res->peer_ = TlFetchObject<Peer>::parse(p); }
  res->date_ = TlFetchInt::parse(p);
  res->expires_ = TlFetchInt::parse(p);
  if (var0 & 2) { res->cooldown_until_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void myBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "myBoost");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("slot", slot_);
    if (var0 & 1) { s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get())); }
    s.store_field("date", date_);
    s.store_field("expires", expires_);
    if (var0 & 2) { s.store_field("cooldown_until_date", cooldown_until_date_); }
    s.store_class_end();
  }
}

const std::int32_t nearestDc::ID;

object_ptr<nearestDc> nearestDc::fetch(TlBufferParser &p) {
  return make_tl_object<nearestDc>(p);
}

nearestDc::nearestDc(TlBufferParser &p)
  : country_(TlFetchString<string>::parse(p))
  , this_dc_(TlFetchInt::parse(p))
  , nearest_dc_(TlFetchInt::parse(p))
{}

void nearestDc::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "nearestDc");
    s.store_field("country", country_);
    s.store_field("this_dc", this_dc_);
    s.store_field("nearest_dc", nearest_dc_);
    s.store_class_end();
  }
}

object_ptr<NotificationSound> NotificationSound::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case notificationSoundDefault::ID:
      return notificationSoundDefault::fetch(p);
    case notificationSoundNone::ID:
      return notificationSoundNone::fetch(p);
    case notificationSoundLocal::ID:
      return notificationSoundLocal::fetch(p);
    case notificationSoundRingtone::ID:
      return notificationSoundRingtone::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t notificationSoundDefault::ID;

object_ptr<NotificationSound> notificationSoundDefault::fetch(TlBufferParser &p) {
  return make_tl_object<notificationSoundDefault>();
}

void notificationSoundDefault::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void notificationSoundDefault::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void notificationSoundDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSoundDefault");
    s.store_class_end();
  }
}

const std::int32_t notificationSoundNone::ID;

object_ptr<NotificationSound> notificationSoundNone::fetch(TlBufferParser &p) {
  return make_tl_object<notificationSoundNone>();
}

void notificationSoundNone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void notificationSoundNone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void notificationSoundNone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSoundNone");
    s.store_class_end();
  }
}

notificationSoundLocal::notificationSoundLocal(string const &title_, string const &data_)
  : title_(title_)
  , data_(data_)
{}

const std::int32_t notificationSoundLocal::ID;

object_ptr<NotificationSound> notificationSoundLocal::fetch(TlBufferParser &p) {
  return make_tl_object<notificationSoundLocal>(p);
}

notificationSoundLocal::notificationSoundLocal(TlBufferParser &p)
  : title_(TlFetchString<string>::parse(p))
  , data_(TlFetchString<string>::parse(p))
{}

void notificationSoundLocal::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(title_, s);
  TlStoreString::store(data_, s);
}

void notificationSoundLocal::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(title_, s);
  TlStoreString::store(data_, s);
}

void notificationSoundLocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSoundLocal");
    s.store_field("title", title_);
    s.store_field("data", data_);
    s.store_class_end();
  }
}

notificationSoundRingtone::notificationSoundRingtone(int64 id_)
  : id_(id_)
{}

const std::int32_t notificationSoundRingtone::ID;

object_ptr<NotificationSound> notificationSoundRingtone::fetch(TlBufferParser &p) {
  return make_tl_object<notificationSoundRingtone>(p);
}

notificationSoundRingtone::notificationSoundRingtone(TlBufferParser &p)
  : id_(TlFetchLong::parse(p))
{}

void notificationSoundRingtone::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void notificationSoundRingtone::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBinary::store(id_, s);
}

void notificationSoundRingtone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSoundRingtone");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

object_ptr<NotifyPeer> NotifyPeer::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case notifyPeer::ID:
      return notifyPeer::fetch(p);
    case notifyUsers::ID:
      return notifyUsers::fetch(p);
    case notifyChats::ID:
      return notifyChats::fetch(p);
    case notifyBroadcasts::ID:
      return notifyBroadcasts::fetch(p);
    case notifyForumTopic::ID:
      return notifyForumTopic::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t notifyPeer::ID;

object_ptr<NotifyPeer> notifyPeer::fetch(TlBufferParser &p) {
  return make_tl_object<notifyPeer>(p);
}

notifyPeer::notifyPeer(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
{}

void notifyPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notifyPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

const std::int32_t notifyUsers::ID;

object_ptr<NotifyPeer> notifyUsers::fetch(TlBufferParser &p) {
  return make_tl_object<notifyUsers>();
}

void notifyUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notifyUsers");
    s.store_class_end();
  }
}

const std::int32_t notifyChats::ID;

object_ptr<NotifyPeer> notifyChats::fetch(TlBufferParser &p) {
  return make_tl_object<notifyChats>();
}

void notifyChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notifyChats");
    s.store_class_end();
  }
}

const std::int32_t notifyBroadcasts::ID;

object_ptr<NotifyPeer> notifyBroadcasts::fetch(TlBufferParser &p) {
  return make_tl_object<notifyBroadcasts>();
}

void notifyBroadcasts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notifyBroadcasts");
    s.store_class_end();
  }
}

const std::int32_t notifyForumTopic::ID;

object_ptr<NotifyPeer> notifyForumTopic::fetch(TlBufferParser &p) {
  return make_tl_object<notifyForumTopic>(p);
}

notifyForumTopic::notifyForumTopic(TlBufferParser &p)
  : peer_(TlFetchObject<Peer>::parse(p))
  , top_msg_id_(TlFetchInt::parse(p))
{}

void notifyForumTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notifyForumTopic");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_field("top_msg_id", top_msg_id_);
    s.store_class_end();
  }
}

const std::int32_t outboxReadDate::ID;

object_ptr<outboxReadDate> outboxReadDate::fetch(TlBufferParser &p) {
  return make_tl_object<outboxReadDate>(p);
}

outboxReadDate::outboxReadDate(TlBufferParser &p)
  : date_(TlFetchInt::parse(p))
{}

void outboxReadDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "outboxReadDate");
    s.store_field("date", date_);
    s.store_class_end();
  }
}

page::page()
  : flags_()
  , part_()
  , rtl_()
  , v2_()
  , url_()
  , blocks_()
  , photos_()
  , documents_()
  , views_()
{}

const std::int32_t page::ID;

object_ptr<page> page::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<page> res = make_tl_object<page>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->part_ = (var0 & 1) != 0;
  res->rtl_ = (var0 & 2) != 0;
  res->v2_ = (var0 & 4) != 0;
  res->url_ = TlFetchString<string>::parse(p);
  res->blocks_ = TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p);
  res->photos_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Photo>>, 481674261>::parse(p);
  res->documents_ = TlFetchBoxed<TlFetchVector<TlFetchObject<Document>>, 481674261>::parse(p);
  if (var0 & 8) { res->views_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void page::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "page");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (part_ << 0) | (rtl_ << 1) | (v2_ << 2)));
    if (var0 & 1) { s.store_field("part", true); }
    if (var0 & 2) { s.store_field("rtl", true); }
    if (var0 & 4) { s.store_field("v2", true); }
    s.store_field("url", url_);
    { s.store_vector_begin("blocks", blocks_.size()); for (const auto &_value : blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("photos", photos_.size()); for (const auto &_value : photos_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("documents", documents_.size()); for (const auto &_value : documents_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    if (var0 & 8) { s.store_field("views", views_); }
    s.store_class_end();
  }
}

object_ptr<PageBlock> PageBlock::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case pageBlockUnsupported::ID:
      return pageBlockUnsupported::fetch(p);
    case pageBlockTitle::ID:
      return pageBlockTitle::fetch(p);
    case pageBlockSubtitle::ID:
      return pageBlockSubtitle::fetch(p);
    case pageBlockAuthorDate::ID:
      return pageBlockAuthorDate::fetch(p);
    case pageBlockHeader::ID:
      return pageBlockHeader::fetch(p);
    case pageBlockSubheader::ID:
      return pageBlockSubheader::fetch(p);
    case pageBlockParagraph::ID:
      return pageBlockParagraph::fetch(p);
    case pageBlockPreformatted::ID:
      return pageBlockPreformatted::fetch(p);
    case pageBlockFooter::ID:
      return pageBlockFooter::fetch(p);
    case pageBlockDivider::ID:
      return pageBlockDivider::fetch(p);
    case pageBlockAnchor::ID:
      return pageBlockAnchor::fetch(p);
    case pageBlockList::ID:
      return pageBlockList::fetch(p);
    case pageBlockBlockquote::ID:
      return pageBlockBlockquote::fetch(p);
    case pageBlockPullquote::ID:
      return pageBlockPullquote::fetch(p);
    case pageBlockPhoto::ID:
      return pageBlockPhoto::fetch(p);
    case pageBlockVideo::ID:
      return pageBlockVideo::fetch(p);
    case pageBlockCover::ID:
      return pageBlockCover::fetch(p);
    case pageBlockEmbed::ID:
      return pageBlockEmbed::fetch(p);
    case pageBlockEmbedPost::ID:
      return pageBlockEmbedPost::fetch(p);
    case pageBlockCollage::ID:
      return pageBlockCollage::fetch(p);
    case pageBlockSlideshow::ID:
      return pageBlockSlideshow::fetch(p);
    case pageBlockChannel::ID:
      return pageBlockChannel::fetch(p);
    case pageBlockAudio::ID:
      return pageBlockAudio::fetch(p);
    case pageBlockKicker::ID:
      return pageBlockKicker::fetch(p);
    case pageBlockTable::ID:
      return pageBlockTable::fetch(p);
    case pageBlockOrderedList::ID:
      return pageBlockOrderedList::fetch(p);
    case pageBlockDetails::ID:
      return pageBlockDetails::fetch(p);
    case pageBlockRelatedArticles::ID:
      return pageBlockRelatedArticles::fetch(p);
    case pageBlockMap::ID:
      return pageBlockMap::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t pageBlockUnsupported::ID;

object_ptr<PageBlock> pageBlockUnsupported::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockUnsupported>();
}

void pageBlockUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockUnsupported");
    s.store_class_end();
  }
}

const std::int32_t pageBlockTitle::ID;

object_ptr<PageBlock> pageBlockTitle::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockTitle>(p);
}

pageBlockTitle::pageBlockTitle(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockTitle");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockSubtitle::ID;

object_ptr<PageBlock> pageBlockSubtitle::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockSubtitle>(p);
}

pageBlockSubtitle::pageBlockSubtitle(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockSubtitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSubtitle");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockAuthorDate::ID;

object_ptr<PageBlock> pageBlockAuthorDate::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockAuthorDate>(p);
}

pageBlockAuthorDate::pageBlockAuthorDate(TlBufferParser &p)
  : author_(TlFetchObject<RichText>::parse(p))
  , published_date_(TlFetchInt::parse(p))
{}

void pageBlockAuthorDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAuthorDate");
    s.store_object_field("author", static_cast<const BaseObject *>(author_.get()));
    s.store_field("published_date", published_date_);
    s.store_class_end();
  }
}

const std::int32_t pageBlockHeader::ID;

object_ptr<PageBlock> pageBlockHeader::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockHeader>(p);
}

pageBlockHeader::pageBlockHeader(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockHeader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockHeader");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockSubheader::ID;

object_ptr<PageBlock> pageBlockSubheader::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockSubheader>(p);
}

pageBlockSubheader::pageBlockSubheader(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockSubheader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSubheader");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockParagraph::ID;

object_ptr<PageBlock> pageBlockParagraph::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockParagraph>(p);
}

pageBlockParagraph::pageBlockParagraph(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockParagraph::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockParagraph");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockPreformatted::ID;

object_ptr<PageBlock> pageBlockPreformatted::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockPreformatted>(p);
}

pageBlockPreformatted::pageBlockPreformatted(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
  , language_(TlFetchString<string>::parse(p))
{}

void pageBlockPreformatted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPreformatted");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("language", language_);
    s.store_class_end();
  }
}

const std::int32_t pageBlockFooter::ID;

object_ptr<PageBlock> pageBlockFooter::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockFooter>(p);
}

pageBlockFooter::pageBlockFooter(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockFooter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockFooter");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockDivider::ID;

object_ptr<PageBlock> pageBlockDivider::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockDivider>();
}

void pageBlockDivider::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockDivider");
    s.store_class_end();
  }
}

const std::int32_t pageBlockAnchor::ID;

object_ptr<PageBlock> pageBlockAnchor::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockAnchor>(p);
}

pageBlockAnchor::pageBlockAnchor(TlBufferParser &p)
  : name_(TlFetchString<string>::parse(p))
{}

void pageBlockAnchor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAnchor");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

const std::int32_t pageBlockList::ID;

object_ptr<PageBlock> pageBlockList::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockList>(p);
}

pageBlockList::pageBlockList(TlBufferParser &p)
  : items_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageListItem>>, 481674261>::parse(p))
{}

void pageBlockList::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockList");
    { s.store_vector_begin("items", items_.size()); for (const auto &_value : items_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t pageBlockBlockquote::ID;

object_ptr<PageBlock> pageBlockBlockquote::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockBlockquote>(p);
}

pageBlockBlockquote::pageBlockBlockquote(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
  , caption_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockBlockquote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockBlockquote");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockPullquote::ID;

object_ptr<PageBlock> pageBlockPullquote::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockPullquote>(p);
}

pageBlockPullquote::pageBlockPullquote(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
  , caption_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockPullquote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPullquote");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockPhoto::pageBlockPhoto()
  : flags_()
  , photo_id_()
  , caption_()
  , url_()
  , webpage_id_()
{}

const std::int32_t pageBlockPhoto::ID;

object_ptr<PageBlock> pageBlockPhoto::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageBlockPhoto> res = make_tl_object<pageBlockPhoto>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->photo_id_ = TlFetchLong::parse(p);
  res->caption_ = TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p);
  if (var0 & 1) { res->url_ = TlFetchString<string>::parse(p); }
  if (var0 & 1) { res->webpage_id_ = TlFetchLong::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void pageBlockPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPhoto");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("photo_id", photo_id_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    if (var0 & 1) { s.store_field("url", url_); }
    if (var0 & 1) { s.store_field("webpage_id", webpage_id_); }
    s.store_class_end();
  }
}

pageBlockVideo::pageBlockVideo()
  : flags_()
  , autoplay_()
  , loop_()
  , video_id_()
  , caption_()
{}

const std::int32_t pageBlockVideo::ID;

object_ptr<PageBlock> pageBlockVideo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageBlockVideo> res = make_tl_object<pageBlockVideo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->autoplay_ = (var0 & 1) != 0;
  res->loop_ = (var0 & 2) != 0;
  res->video_id_ = TlFetchLong::parse(p);
  res->caption_ = TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void pageBlockVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVideo");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (autoplay_ << 0) | (loop_ << 1)));
    if (var0 & 1) { s.store_field("autoplay", true); }
    if (var0 & 2) { s.store_field("loop", true); }
    s.store_field("video_id", video_id_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockCover::ID;

object_ptr<PageBlock> pageBlockCover::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockCover>(p);
}

pageBlockCover::pageBlockCover(TlBufferParser &p)
  : cover_(TlFetchObject<PageBlock>::parse(p))
{}

void pageBlockCover::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockCover");
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_class_end();
  }
}

pageBlockEmbed::pageBlockEmbed()
  : flags_()
  , full_width_()
  , allow_scrolling_()
  , url_()
  , html_()
  , poster_photo_id_()
  , w_()
  , h_()
  , caption_()
{}

const std::int32_t pageBlockEmbed::ID;

object_ptr<PageBlock> pageBlockEmbed::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageBlockEmbed> res = make_tl_object<pageBlockEmbed>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->full_width_ = (var0 & 1) != 0;
  res->allow_scrolling_ = (var0 & 8) != 0;
  if (var0 & 2) { res->url_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->html_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->poster_photo_id_ = TlFetchLong::parse(p); }
  if (var0 & 32) { res->w_ = TlFetchInt::parse(p); }
  if (var0 & 32) { res->h_ = TlFetchInt::parse(p); }
  res->caption_ = TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void pageBlockEmbed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockEmbed");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (full_width_ << 0) | (allow_scrolling_ << 3)));
    if (var0 & 1) { s.store_field("full_width", true); }
    if (var0 & 8) { s.store_field("allow_scrolling", true); }
    if (var0 & 2) { s.store_field("url", url_); }
    if (var0 & 4) { s.store_field("html", html_); }
    if (var0 & 16) { s.store_field("poster_photo_id", poster_photo_id_); }
    if (var0 & 32) { s.store_field("w", w_); }
    if (var0 & 32) { s.store_field("h", h_); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockEmbedPost::ID;

object_ptr<PageBlock> pageBlockEmbedPost::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockEmbedPost>(p);
}

pageBlockEmbedPost::pageBlockEmbedPost(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
  , webpage_id_(TlFetchLong::parse(p))
  , author_photo_id_(TlFetchLong::parse(p))
  , author_(TlFetchString<string>::parse(p))
  , date_(TlFetchInt::parse(p))
  , blocks_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p))
  , caption_(TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p))
{}

void pageBlockEmbedPost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockEmbedPost");
    s.store_field("url", url_);
    s.store_field("webpage_id", webpage_id_);
    s.store_field("author_photo_id", author_photo_id_);
    s.store_field("author", author_);
    s.store_field("date", date_);
    { s.store_vector_begin("blocks", blocks_.size()); for (const auto &_value : blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockCollage::ID;

object_ptr<PageBlock> pageBlockCollage::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockCollage>(p);
}

pageBlockCollage::pageBlockCollage(TlBufferParser &p)
  : items_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p))
  , caption_(TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p))
{}

void pageBlockCollage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockCollage");
    { s.store_vector_begin("items", items_.size()); for (const auto &_value : items_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockSlideshow::ID;

object_ptr<PageBlock> pageBlockSlideshow::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockSlideshow>(p);
}

pageBlockSlideshow::pageBlockSlideshow(TlBufferParser &p)
  : items_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p))
  , caption_(TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p))
{}

void pageBlockSlideshow::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSlideshow");
    { s.store_vector_begin("items", items_.size()); for (const auto &_value : items_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockChannel::ID;

object_ptr<PageBlock> pageBlockChannel::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockChannel>(p);
}

pageBlockChannel::pageBlockChannel(TlBufferParser &p)
  : channel_(TlFetchObject<Chat>::parse(p))
{}

void pageBlockChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockChannel");
    s.store_object_field("channel", static_cast<const BaseObject *>(channel_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockAudio::ID;

object_ptr<PageBlock> pageBlockAudio::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockAudio>(p);
}

pageBlockAudio::pageBlockAudio(TlBufferParser &p)
  : audio_id_(TlFetchLong::parse(p))
  , caption_(TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p))
{}

void pageBlockAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAudio");
    s.store_field("audio_id", audio_id_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockKicker::ID;

object_ptr<PageBlock> pageBlockKicker::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockKicker>(p);
}

pageBlockKicker::pageBlockKicker(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageBlockKicker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockKicker");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

pageBlockTable::pageBlockTable()
  : flags_()
  , bordered_()
  , striped_()
  , title_()
  , rows_()
{}

const std::int32_t pageBlockTable::ID;

object_ptr<PageBlock> pageBlockTable::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageBlockTable> res = make_tl_object<pageBlockTable>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->bordered_ = (var0 & 1) != 0;
  res->striped_ = (var0 & 2) != 0;
  res->title_ = TlFetchObject<RichText>::parse(p);
  res->rows_ = TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<pageTableRow>, -524237339>>, 481674261>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void pageBlockTable::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockTable");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (bordered_ << 0) | (striped_ << 1)));
    if (var0 & 1) { s.store_field("bordered", true); }
    if (var0 & 2) { s.store_field("striped", true); }
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    { s.store_vector_begin("rows", rows_.size()); for (const auto &_value : rows_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t pageBlockOrderedList::ID;

object_ptr<PageBlock> pageBlockOrderedList::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockOrderedList>(p);
}

pageBlockOrderedList::pageBlockOrderedList(TlBufferParser &p)
  : items_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageListOrderedItem>>, 481674261>::parse(p))
{}

void pageBlockOrderedList::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockOrderedList");
    { s.store_vector_begin("items", items_.size()); for (const auto &_value : items_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageBlockDetails::pageBlockDetails()
  : flags_()
  , open_()
  , blocks_()
  , title_()
{}

const std::int32_t pageBlockDetails::ID;

object_ptr<PageBlock> pageBlockDetails::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageBlockDetails> res = make_tl_object<pageBlockDetails>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->open_ = (var0 & 1) != 0;
  res->blocks_ = TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p);
  res->title_ = TlFetchObject<RichText>::parse(p);
  if (p.get_error()) { FAIL(""); }
  return std::move(res);
#undef FAIL
}

void pageBlockDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockDetails");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (open_ << 0)));
    if (var0 & 1) { s.store_field("open", true); }
    { s.store_vector_begin("blocks", blocks_.size()); for (const auto &_value : blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageBlockRelatedArticles::ID;

object_ptr<PageBlock> pageBlockRelatedArticles::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockRelatedArticles>(p);
}

pageBlockRelatedArticles::pageBlockRelatedArticles(TlBufferParser &p)
  : title_(TlFetchObject<RichText>::parse(p))
  , articles_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<pageRelatedArticle>, -1282352120>>, 481674261>::parse(p))
{}

void pageBlockRelatedArticles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockRelatedArticles");
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    { s.store_vector_begin("articles", articles_.size()); for (const auto &_value : articles_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

const std::int32_t pageBlockMap::ID;

object_ptr<PageBlock> pageBlockMap::fetch(TlBufferParser &p) {
  return make_tl_object<pageBlockMap>(p);
}

pageBlockMap::pageBlockMap(TlBufferParser &p)
  : geo_(TlFetchObject<GeoPoint>::parse(p))
  , zoom_(TlFetchInt::parse(p))
  , w_(TlFetchInt::parse(p))
  , h_(TlFetchInt::parse(p))
  , caption_(TlFetchBoxed<TlFetchObject<pageCaption>, 1869903447>::parse(p))
{}

void pageBlockMap::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockMap");
    s.store_object_field("geo", static_cast<const BaseObject *>(geo_.get()));
    s.store_field("zoom", zoom_);
    s.store_field("w", w_);
    s.store_field("h", h_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageCaption::ID;

object_ptr<pageCaption> pageCaption::fetch(TlBufferParser &p) {
  return make_tl_object<pageCaption>(p);
}

pageCaption::pageCaption(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
  , credit_(TlFetchObject<RichText>::parse(p))
{}

void pageCaption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageCaption");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("credit", static_cast<const BaseObject *>(credit_.get()));
    s.store_class_end();
  }
}

object_ptr<PageListItem> PageListItem::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case pageListItemText::ID:
      return pageListItemText::fetch(p);
    case pageListItemBlocks::ID:
      return pageListItemBlocks::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t pageListItemText::ID;

object_ptr<PageListItem> pageListItemText::fetch(TlBufferParser &p) {
  return make_tl_object<pageListItemText>(p);
}

pageListItemText::pageListItemText(TlBufferParser &p)
  : text_(TlFetchObject<RichText>::parse(p))
{}

void pageListItemText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageListItemText");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageListItemBlocks::ID;

object_ptr<PageListItem> pageListItemBlocks::fetch(TlBufferParser &p) {
  return make_tl_object<pageListItemBlocks>(p);
}

pageListItemBlocks::pageListItemBlocks(TlBufferParser &p)
  : blocks_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p))
{}

void pageListItemBlocks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageListItemBlocks");
    { s.store_vector_begin("blocks", blocks_.size()); for (const auto &_value : blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<PageListOrderedItem> PageListOrderedItem::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case pageListOrderedItemText::ID:
      return pageListOrderedItemText::fetch(p);
    case pageListOrderedItemBlocks::ID:
      return pageListOrderedItemBlocks::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t pageListOrderedItemText::ID;

object_ptr<PageListOrderedItem> pageListOrderedItemText::fetch(TlBufferParser &p) {
  return make_tl_object<pageListOrderedItemText>(p);
}

pageListOrderedItemText::pageListOrderedItemText(TlBufferParser &p)
  : num_(TlFetchString<string>::parse(p))
  , text_(TlFetchObject<RichText>::parse(p))
{}

void pageListOrderedItemText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageListOrderedItemText");
    s.store_field("num", num_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

const std::int32_t pageListOrderedItemBlocks::ID;

object_ptr<PageListOrderedItem> pageListOrderedItemBlocks::fetch(TlBufferParser &p) {
  return make_tl_object<pageListOrderedItemBlocks>(p);
}

pageListOrderedItemBlocks::pageListOrderedItemBlocks(TlBufferParser &p)
  : num_(TlFetchString<string>::parse(p))
  , blocks_(TlFetchBoxed<TlFetchVector<TlFetchObject<PageBlock>>, 481674261>::parse(p))
{}

void pageListOrderedItemBlocks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageListOrderedItemBlocks");
    s.store_field("num", num_);
    { s.store_vector_begin("blocks", blocks_.size()); for (const auto &_value : blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageRelatedArticle::pageRelatedArticle()
  : flags_()
  , url_()
  , webpage_id_()
  , title_()
  , description_()
  , photo_id_()
  , author_()
  , published_date_()
{}

const std::int32_t pageRelatedArticle::ID;

object_ptr<pageRelatedArticle> pageRelatedArticle::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageRelatedArticle> res = make_tl_object<pageRelatedArticle>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->url_ = TlFetchString<string>::parse(p);
  res->webpage_id_ = TlFetchLong::parse(p);
  if (var0 & 1) { res->title_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->description_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->photo_id_ = TlFetchLong::parse(p); }
  if (var0 & 8) { res->author_ = TlFetchString<string>::parse(p); }
  if (var0 & 16) { res->published_date_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void pageRelatedArticle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageRelatedArticle");
  int32 var0;
    s.store_field("flags", (var0 = flags_));
    s.store_field("url", url_);
    s.store_field("webpage_id", webpage_id_);
    if (var0 & 1) { s.store_field("title", title_); }
    if (var0 & 2) { s.store_field("description", description_); }
    if (var0 & 4) { s.store_field("photo_id", photo_id_); }
    if (var0 & 8) { s.store_field("author", author_); }
    if (var0 & 16) { s.store_field("published_date", published_date_); }
    s.store_class_end();
  }
}

pageTableCell::pageTableCell()
  : flags_()
  , header_()
  , align_center_()
  , align_right_()
  , valign_middle_()
  , valign_bottom_()
  , text_()
  , colspan_()
  , rowspan_()
{}

const std::int32_t pageTableCell::ID;

object_ptr<pageTableCell> pageTableCell::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<pageTableCell> res = make_tl_object<pageTableCell>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  res->header_ = (var0 & 1) != 0;
  res->align_center_ = (var0 & 8) != 0;
  res->align_right_ = (var0 & 16) != 0;
  res->valign_middle_ = (var0 & 32) != 0;
  res->valign_bottom_ = (var0 & 64) != 0;
  if (var0 & 128) { res->text_ = TlFetchObject<RichText>::parse(p); }
  if (var0 & 2) { res->colspan_ = TlFetchInt::parse(p); }
  if (var0 & 4) { res->rowspan_ = TlFetchInt::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void pageTableCell::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageTableCell");
  int32 var0;
    s.store_field("flags", (var0 = flags_ | (header_ << 0) | (align_center_ << 3) | (align_right_ << 4) | (valign_middle_ << 5) | (valign_bottom_ << 6)));
    if (var0 & 1) { s.store_field("header", true); }
    if (var0 & 8) { s.store_field("align_center", true); }
    if (var0 & 16) { s.store_field("align_right", true); }
    if (var0 & 32) { s.store_field("valign_middle", true); }
    if (var0 & 64) { s.store_field("valign_bottom", true); }
    if (var0 & 128) { s.store_object_field("text", static_cast<const BaseObject *>(text_.get())); }
    if (var0 & 2) { s.store_field("colspan", colspan_); }
    if (var0 & 4) { s.store_field("rowspan", rowspan_); }
    s.store_class_end();
  }
}

const std::int32_t pageTableRow::ID;

object_ptr<pageTableRow> pageTableRow::fetch(TlBufferParser &p) {
  return make_tl_object<pageTableRow>(p);
}

pageTableRow::pageTableRow(TlBufferParser &p)
  : cells_(TlFetchBoxed<TlFetchVector<TlFetchBoxed<TlFetchObject<pageTableCell>, 878078826>>, 481674261>::parse(p))
{}

void pageTableRow::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageTableRow");
    { s.store_vector_begin("cells", cells_.size()); for (const auto &_value : cells_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

object_ptr<PaidReactionPrivacy> PaidReactionPrivacy::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case paidReactionPrivacyDefault::ID:
      return paidReactionPrivacyDefault::fetch(p);
    case paidReactionPrivacyAnonymous::ID:
      return paidReactionPrivacyAnonymous::fetch(p);
    case paidReactionPrivacyPeer::ID:
      return paidReactionPrivacyPeer::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t paidReactionPrivacyDefault::ID;

object_ptr<PaidReactionPrivacy> paidReactionPrivacyDefault::fetch(TlBufferParser &p) {
  return make_tl_object<paidReactionPrivacyDefault>();
}

void paidReactionPrivacyDefault::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void paidReactionPrivacyDefault::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void paidReactionPrivacyDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionPrivacyDefault");
    s.store_class_end();
  }
}

const std::int32_t paidReactionPrivacyAnonymous::ID;

object_ptr<PaidReactionPrivacy> paidReactionPrivacyAnonymous::fetch(TlBufferParser &p) {
  return make_tl_object<paidReactionPrivacyAnonymous>();
}

void paidReactionPrivacyAnonymous::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void paidReactionPrivacyAnonymous::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void paidReactionPrivacyAnonymous::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionPrivacyAnonymous");
    s.store_class_end();
  }
}

paidReactionPrivacyPeer::paidReactionPrivacyPeer(object_ptr<InputPeer> &&peer_)
  : peer_(std::move(peer_))
{}

const std::int32_t paidReactionPrivacyPeer::ID;

object_ptr<PaidReactionPrivacy> paidReactionPrivacyPeer::fetch(TlBufferParser &p) {
  return make_tl_object<paidReactionPrivacyPeer>(p);
}

paidReactionPrivacyPeer::paidReactionPrivacyPeer(TlBufferParser &p)
  : peer_(TlFetchObject<InputPeer>::parse(p))
{}

void paidReactionPrivacyPeer::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void paidReactionPrivacyPeer::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreBoxedUnknown<TlStoreObject>::store(peer_, s);
}

void paidReactionPrivacyPeer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionPrivacyPeer");
    s.store_object_field("peer", static_cast<const BaseObject *>(peer_.get()));
    s.store_class_end();
  }
}

object_ptr<PasswordKdfAlgo> PasswordKdfAlgo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  int constructor = p.fetch_int();
  switch (constructor) {
    case passwordKdfAlgoUnknown::ID:
      return passwordKdfAlgoUnknown::fetch(p);
    case passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::ID:
      return passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::fetch(p);
    default:
      FAIL(PSTRING() << "Unknown constructor found " << format::as_hex(constructor));
  }
#undef FAIL
}

const std::int32_t passwordKdfAlgoUnknown::ID;

object_ptr<PasswordKdfAlgo> passwordKdfAlgoUnknown::fetch(TlBufferParser &p) {
  return make_tl_object<passwordKdfAlgoUnknown>();
}

void passwordKdfAlgoUnknown::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
}

void passwordKdfAlgoUnknown::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
}

void passwordKdfAlgoUnknown::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passwordKdfAlgoUnknown");
    s.store_class_end();
  }
}

passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(bytes &&salt1_, bytes &&salt2_, int32 g_, bytes &&p_)
  : salt1_(std::move(salt1_))
  , salt2_(std::move(salt2_))
  , g_(g_)
  , p_(std::move(p_))
{}

const std::int32_t passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::ID;

object_ptr<PasswordKdfAlgo> passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::fetch(TlBufferParser &p) {
  return make_tl_object<passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow>(p);
}

passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TlBufferParser &p)
  : salt1_(TlFetchBytes<bytes>::parse(p))
  , salt2_(TlFetchBytes<bytes>::parse(p))
  , g_(TlFetchInt::parse(p))
  , p_(TlFetchBytes<bytes>::parse(p))
{}

void passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  TlStoreString::store(salt1_, s);
  TlStoreString::store(salt2_, s);
  TlStoreBinary::store(g_, s);
  TlStoreString::store(p_, s);
}

void passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::store(TlStorerUnsafe &s) const {
  (void)sizeof(s);
  TlStoreString::store(salt1_, s);
  TlStoreString::store(salt2_, s);
  TlStoreBinary::store(g_, s);
  TlStoreString::store(p_, s);
}

void passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow");
    s.store_bytes_field("salt1", salt1_);
    s.store_bytes_field("salt2", salt2_);
    s.store_field("g", g_);
    s.store_bytes_field("p", p_);
    s.store_class_end();
  }
}

const std::int32_t paymentCharge::ID;

object_ptr<paymentCharge> paymentCharge::fetch(TlBufferParser &p) {
  return make_tl_object<paymentCharge>(p);
}

paymentCharge::paymentCharge(TlBufferParser &p)
  : id_(TlFetchString<string>::parse(p))
  , provider_charge_id_(TlFetchString<string>::parse(p))
{}

void paymentCharge::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentCharge");
    s.store_field("id", id_);
    s.store_field("provider_charge_id", provider_charge_id_);
    s.store_class_end();
  }
}

const std::int32_t paymentFormMethod::ID;

object_ptr<paymentFormMethod> paymentFormMethod::fetch(TlBufferParser &p) {
  return make_tl_object<paymentFormMethod>(p);
}

paymentFormMethod::paymentFormMethod(TlBufferParser &p)
  : url_(TlFetchString<string>::parse(p))
  , title_(TlFetchString<string>::parse(p))
{}

void paymentFormMethod::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentFormMethod");
    s.store_field("url", url_);
    s.store_field("title", title_);
    s.store_class_end();
  }
}

paymentRequestedInfo::paymentRequestedInfo()
  : flags_()
  , name_()
  , phone_()
  , email_()
  , shipping_address_()
{}

paymentRequestedInfo::paymentRequestedInfo(int32 flags_, string const &name_, string const &phone_, string const &email_, object_ptr<postAddress> &&shipping_address_)
  : flags_(flags_)
  , name_(name_)
  , phone_(phone_)
  , email_(email_)
  , shipping_address_(std::move(shipping_address_))
{}

const std::int32_t paymentRequestedInfo::ID;

object_ptr<paymentRequestedInfo> paymentRequestedInfo::fetch(TlBufferParser &p) {
#define FAIL(error) p.set_error(error); return nullptr;
  object_ptr<paymentRequestedInfo> res = make_tl_object<paymentRequestedInfo>();
  int32 var0;
  if ((var0 = res->flags_ = TlFetchInt::parse(p)) < 0) { FAIL("Variable of type # can't be negative"); }
  if (var0 & 1) { res->name_ = TlFetchString<string>::parse(p); }
  if (var0 & 2) { res->phone_ = TlFetchString<string>::parse(p); }
  if (var0 & 4) { res->email_ = TlFetchString<string>::parse(p); }
  if (var0 & 8) { res->shipping_address_ = TlFetchBoxed<TlFetchObject<postAddress>, 512535275>::parse(p); }
  if (p.get_error()) { FAIL(""); }
  return res;
#undef FAIL
}

void paymentRequestedInfo::store(TlStorerCalcLength &s) const {
  (void)sizeof(s);
  int32 var0;
  TlStoreBinary::store((var0 = flags_), s);
  if (var0 & 1) { TlStoreString::store(name_, s); }
  if (var0 & 2) { TlStoreString::store(phone_, s); }
  if (var0 & 4) { TlStoreString::store(email_, s); }
  