#include "td_api.h"

#include "td/tl/tl_jni_object.h"

#include "td/utils/common.h"
#include "td/utils/format.h"
#include "td/utils/logging.h"
#include "td/utils/SliceBuilder.h"
#include "td/utils/tl_parsers.h"
#include "td/utils/tl_storers.h"
#include "td/utils/TlStorerToString.h"

namespace td {
namespace td_api {

std::string to_string(const BaseObject &value) {
  TlStorerToString storer;
  value.store(storer, "");
  return storer.move_as_string();
}

const char *&get_package_name_ref() {
  static const char *package_name = "Package name must be initialized first";
  return package_name;
}

const char *get_git_commit_hash() {
  return "a9863453385e09f09a6f746f78ad39ca6530b6a3";
}

jclass Object::Class;

object_ptr<Object> Object::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case accentColor::ID:
      return accentColor::fetch(env, p);
    case acceptedGiftTypes::ID:
      return acceptedGiftTypes::fetch(env, p);
    case accountInfo::ID:
      return accountInfo::fetch(env, p);
    case accountTtl::ID:
      return accountTtl::fetch(env, p);
    case addedReaction::ID:
      return addedReaction::fetch(env, p);
    case addedReactions::ID:
      return addedReactions::fetch(env, p);
    case address::ID:
      return address::fetch(env, p);
    case advertisementSponsor::ID:
      return advertisementSponsor::fetch(env, p);
    case affiliateInfo::ID:
      return affiliateInfo::fetch(env, p);
    case affiliateProgramInfo::ID:
      return affiliateProgramInfo::fetch(env, p);
    case affiliateProgramParameters::ID:
      return affiliateProgramParameters::fetch(env, p);
    case affiliateProgramSortOrderProfitability::ID:
      return affiliateProgramSortOrderProfitability::fetch(env, p);
    case affiliateProgramSortOrderCreationDate::ID:
      return affiliateProgramSortOrderCreationDate::fetch(env, p);
    case affiliateProgramSortOrderRevenue::ID:
      return affiliateProgramSortOrderRevenue::fetch(env, p);
    case affiliateTypeCurrentUser::ID:
      return affiliateTypeCurrentUser::fetch(env, p);
    case affiliateTypeBot::ID:
      return affiliateTypeBot::fetch(env, p);
    case affiliateTypeChannel::ID:
      return affiliateTypeChannel::fetch(env, p);
    case alternativeVideo::ID:
      return alternativeVideo::fetch(env, p);
    case animatedChatPhoto::ID:
      return animatedChatPhoto::fetch(env, p);
    case animatedEmoji::ID:
      return animatedEmoji::fetch(env, p);
    case animation::ID:
      return animation::fetch(env, p);
    case animations::ID:
      return animations::fetch(env, p);
    case archiveChatListSettings::ID:
      return archiveChatListSettings::fetch(env, p);
    case attachmentMenuBot::ID:
      return attachmentMenuBot::fetch(env, p);
    case attachmentMenuBotColor::ID:
      return attachmentMenuBotColor::fetch(env, p);
    case audio::ID:
      return audio::fetch(env, p);
    case authenticationCodeInfo::ID:
      return authenticationCodeInfo::fetch(env, p);
    case authenticationCodeTypeTelegramMessage::ID:
      return authenticationCodeTypeTelegramMessage::fetch(env, p);
    case authenticationCodeTypeSms::ID:
      return authenticationCodeTypeSms::fetch(env, p);
    case authenticationCodeTypeSmsWord::ID:
      return authenticationCodeTypeSmsWord::fetch(env, p);
    case authenticationCodeTypeSmsPhrase::ID:
      return authenticationCodeTypeSmsPhrase::fetch(env, p);
    case authenticationCodeTypeCall::ID:
      return authenticationCodeTypeCall::fetch(env, p);
    case authenticationCodeTypeFlashCall::ID:
      return authenticationCodeTypeFlashCall::fetch(env, p);
    case authenticationCodeTypeMissedCall::ID:
      return authenticationCodeTypeMissedCall::fetch(env, p);
    case authenticationCodeTypeFragment::ID:
      return authenticationCodeTypeFragment::fetch(env, p);
    case authenticationCodeTypeFirebaseAndroid::ID:
      return authenticationCodeTypeFirebaseAndroid::fetch(env, p);
    case authenticationCodeTypeFirebaseIos::ID:
      return authenticationCodeTypeFirebaseIos::fetch(env, p);
    case authorizationStateWaitTdlibParameters::ID:
      return authorizationStateWaitTdlibParameters::fetch(env, p);
    case authorizationStateWaitPhoneNumber::ID:
      return authorizationStateWaitPhoneNumber::fetch(env, p);
    case authorizationStateWaitPremiumPurchase::ID:
      return authorizationStateWaitPremiumPurchase::fetch(env, p);
    case authorizationStateWaitEmailAddress::ID:
      return authorizationStateWaitEmailAddress::fetch(env, p);
    case authorizationStateWaitEmailCode::ID:
      return authorizationStateWaitEmailCode::fetch(env, p);
    case authorizationStateWaitCode::ID:
      return authorizationStateWaitCode::fetch(env, p);
    case authorizationStateWaitOtherDeviceConfirmation::ID:
      return authorizationStateWaitOtherDeviceConfirmation::fetch(env, p);
    case authorizationStateWaitRegistration::ID:
      return authorizationStateWaitRegistration::fetch(env, p);
    case authorizationStateWaitPassword::ID:
      return authorizationStateWaitPassword::fetch(env, p);
    case authorizationStateReady::ID:
      return authorizationStateReady::fetch(env, p);
    case authorizationStateLoggingOut::ID:
      return authorizationStateLoggingOut::fetch(env, p);
    case authorizationStateClosing::ID:
      return authorizationStateClosing::fetch(env, p);
    case authorizationStateClosed::ID:
      return authorizationStateClosed::fetch(env, p);
    case autoDownloadSettings::ID:
      return autoDownloadSettings::fetch(env, p);
    case autoDownloadSettingsPresets::ID:
      return autoDownloadSettingsPresets::fetch(env, p);
    case autosaveSettings::ID:
      return autosaveSettings::fetch(env, p);
    case autosaveSettingsException::ID:
      return autosaveSettingsException::fetch(env, p);
    case autosaveSettingsScopePrivateChats::ID:
      return autosaveSettingsScopePrivateChats::fetch(env, p);
    case autosaveSettingsScopeGroupChats::ID:
      return autosaveSettingsScopeGroupChats::fetch(env, p);
    case autosaveSettingsScopeChannelChats::ID:
      return autosaveSettingsScopeChannelChats::fetch(env, p);
    case autosaveSettingsScopeChat::ID:
      return autosaveSettingsScopeChat::fetch(env, p);
    case availableGift::ID:
      return availableGift::fetch(env, p);
    case availableGifts::ID:
      return availableGifts::fetch(env, p);
    case availableReaction::ID:
      return availableReaction::fetch(env, p);
    case availableReactions::ID:
      return availableReactions::fetch(env, p);
    case background::ID:
      return background::fetch(env, p);
    case backgroundFillSolid::ID:
      return backgroundFillSolid::fetch(env, p);
    case backgroundFillGradient::ID:
      return backgroundFillGradient::fetch(env, p);
    case backgroundFillFreeformGradient::ID:
      return backgroundFillFreeformGradient::fetch(env, p);
    case backgroundTypeWallpaper::ID:
      return backgroundTypeWallpaper::fetch(env, p);
    case backgroundTypePattern::ID:
      return backgroundTypePattern::fetch(env, p);
    case backgroundTypeFill::ID:
      return backgroundTypeFill::fetch(env, p);
    case backgroundTypeChatTheme::ID:
      return backgroundTypeChatTheme::fetch(env, p);
    case backgrounds::ID:
      return backgrounds::fetch(env, p);
    case bankCardActionOpenUrl::ID:
      return bankCardActionOpenUrl::fetch(env, p);
    case bankCardInfo::ID:
      return bankCardInfo::fetch(env, p);
    case basicGroup::ID:
      return basicGroup::fetch(env, p);
    case basicGroupFullInfo::ID:
      return basicGroupFullInfo::fetch(env, p);
    case birthdate::ID:
      return birthdate::fetch(env, p);
    case blockListMain::ID:
      return blockListMain::fetch(env, p);
    case blockListStories::ID:
      return blockListStories::fetch(env, p);
    case botCommand::ID:
      return botCommand::fetch(env, p);
    case botCommandScopeDefault::ID:
      return botCommandScopeDefault::fetch(env, p);
    case botCommandScopeAllPrivateChats::ID:
      return botCommandScopeAllPrivateChats::fetch(env, p);
    case botCommandScopeAllGroupChats::ID:
      return botCommandScopeAllGroupChats::fetch(env, p);
    case botCommandScopeAllChatAdministrators::ID:
      return botCommandScopeAllChatAdministrators::fetch(env, p);
    case botCommandScopeChat::ID:
      return botCommandScopeChat::fetch(env, p);
    case botCommandScopeChatAdministrators::ID:
      return botCommandScopeChatAdministrators::fetch(env, p);
    case botCommandScopeChatMember::ID:
      return botCommandScopeChatMember::fetch(env, p);
    case botCommands::ID:
      return botCommands::fetch(env, p);
    case botInfo::ID:
      return botInfo::fetch(env, p);
    case botMediaPreview::ID:
      return botMediaPreview::fetch(env, p);
    case botMediaPreviewInfo::ID:
      return botMediaPreviewInfo::fetch(env, p);
    case botMediaPreviews::ID:
      return botMediaPreviews::fetch(env, p);
    case botMenuButton::ID:
      return botMenuButton::fetch(env, p);
    case botVerification::ID:
      return botVerification::fetch(env, p);
    case botVerificationParameters::ID:
      return botVerificationParameters::fetch(env, p);
    case botWriteAccessAllowReasonConnectedWebsite::ID:
      return botWriteAccessAllowReasonConnectedWebsite::fetch(env, p);
    case botWriteAccessAllowReasonAddedToAttachmentMenu::ID:
      return botWriteAccessAllowReasonAddedToAttachmentMenu::fetch(env, p);
    case botWriteAccessAllowReasonLaunchedWebApp::ID:
      return botWriteAccessAllowReasonLaunchedWebApp::fetch(env, p);
    case botWriteAccessAllowReasonAcceptedRequest::ID:
      return botWriteAccessAllowReasonAcceptedRequest::fetch(env, p);
    case businessAwayMessageScheduleAlways::ID:
      return businessAwayMessageScheduleAlways::fetch(env, p);
    case businessAwayMessageScheduleOutsideOfOpeningHours::ID:
      return businessAwayMessageScheduleOutsideOfOpeningHours::fetch(env, p);
    case businessAwayMessageScheduleCustom::ID:
      return businessAwayMessageScheduleCustom::fetch(env, p);
    case businessAwayMessageSettings::ID:
      return businessAwayMessageSettings::fetch(env, p);
    case businessBotManageBar::ID:
      return businessBotManageBar::fetch(env, p);
    case businessBotRights::ID:
      return businessBotRights::fetch(env, p);
    case businessChatLink::ID:
      return businessChatLink::fetch(env, p);
    case businessChatLinkInfo::ID:
      return businessChatLinkInfo::fetch(env, p);
    case businessChatLinks::ID:
      return businessChatLinks::fetch(env, p);
    case businessConnectedBot::ID:
      return businessConnectedBot::fetch(env, p);
    case businessConnection::ID:
      return businessConnection::fetch(env, p);
    case businessFeatureLocation::ID:
      return businessFeatureLocation::fetch(env, p);
    case businessFeatureOpeningHours::ID:
      return businessFeatureOpeningHours::fetch(env, p);
    case businessFeatureQuickReplies::ID:
      return businessFeatureQuickReplies::fetch(env, p);
    case businessFeatureGreetingMessage::ID:
      return businessFeatureGreetingMessage::fetch(env, p);
    case businessFeatureAwayMessage::ID:
      return businessFeatureAwayMessage::fetch(env, p);
    case businessFeatureAccountLinks::ID:
      return businessFeatureAccountLinks::fetch(env, p);
    case businessFeatureStartPage::ID:
      return businessFeatureStartPage::fetch(env, p);
    case businessFeatureBots::ID:
      return businessFeatureBots::fetch(env, p);
    case businessFeatureEmojiStatus::ID:
      return businessFeatureEmojiStatus::fetch(env, p);
    case businessFeatureChatFolderTags::ID:
      return businessFeatureChatFolderTags::fetch(env, p);
    case businessFeatureUpgradedStories::ID:
      return businessFeatureUpgradedStories::fetch(env, p);
    case businessFeaturePromotionAnimation::ID:
      return businessFeaturePromotionAnimation::fetch(env, p);
    case businessFeatures::ID:
      return businessFeatures::fetch(env, p);
    case businessGreetingMessageSettings::ID:
      return businessGreetingMessageSettings::fetch(env, p);
    case businessInfo::ID:
      return businessInfo::fetch(env, p);
    case businessLocation::ID:
      return businessLocation::fetch(env, p);
    case businessMessage::ID:
      return businessMessage::fetch(env, p);
    case businessMessages::ID:
      return businessMessages::fetch(env, p);
    case businessOpeningHours::ID:
      return businessOpeningHours::fetch(env, p);
    case businessOpeningHoursInterval::ID:
      return businessOpeningHoursInterval::fetch(env, p);
    case businessRecipients::ID:
      return businessRecipients::fetch(env, p);
    case businessStartPage::ID:
      return businessStartPage::fetch(env, p);
    case call::ID:
      return call::fetch(env, p);
    case callDiscardReasonEmpty::ID:
      return callDiscardReasonEmpty::fetch(env, p);
    case callDiscardReasonMissed::ID:
      return callDiscardReasonMissed::fetch(env, p);
    case callDiscardReasonDeclined::ID:
      return callDiscardReasonDeclined::fetch(env, p);
    case callDiscardReasonDisconnected::ID:
      return callDiscardReasonDisconnected::fetch(env, p);
    case callDiscardReasonHungUp::ID:
      return callDiscardReasonHungUp::fetch(env, p);
    case callDiscardReasonUpgradeToGroupCall::ID:
      return callDiscardReasonUpgradeToGroupCall::fetch(env, p);
    case callId::ID:
      return callId::fetch(env, p);
    case callProblemEcho::ID:
      return callProblemEcho::fetch(env, p);
    case callProblemNoise::ID:
      return callProblemNoise::fetch(env, p);
    case callProblemInterruptions::ID:
      return callProblemInterruptions::fetch(env, p);
    case callProblemDistortedSpeech::ID:
      return callProblemDistortedSpeech::fetch(env, p);
    case callProblemSilentLocal::ID:
      return callProblemSilentLocal::fetch(env, p);
    case callProblemSilentRemote::ID:
      return callProblemSilentRemote::fetch(env, p);
    case callProblemDropped::ID:
      return callProblemDropped::fetch(env, p);
    case callProblemDistortedVideo::ID:
      return callProblemDistortedVideo::fetch(env, p);
    case callProblemPixelatedVideo::ID:
      return callProblemPixelatedVideo::fetch(env, p);
    case callProtocol::ID:
      return callProtocol::fetch(env, p);
    case callServer::ID:
      return callServer::fetch(env, p);
    case callServerTypeTelegramReflector::ID:
      return callServerTypeTelegramReflector::fetch(env, p);
    case callServerTypeWebrtc::ID:
      return callServerTypeWebrtc::fetch(env, p);
    case callStatePending::ID:
      return callStatePending::fetch(env, p);
    case callStateExchangingKeys::ID:
      return callStateExchangingKeys::fetch(env, p);
    case callStateReady::ID:
      return callStateReady::fetch(env, p);
    case callStateHangingUp::ID:
      return callStateHangingUp::fetch(env, p);
    case callStateDiscarded::ID:
      return callStateDiscarded::fetch(env, p);
    case callStateError::ID:
      return callStateError::fetch(env, p);
    case callbackQueryAnswer::ID:
      return callbackQueryAnswer::fetch(env, p);
    case callbackQueryPayloadData::ID:
      return callbackQueryPayloadData::fetch(env, p);
    case callbackQueryPayloadDataWithPassword::ID:
      return callbackQueryPayloadDataWithPassword::fetch(env, p);
    case callbackQueryPayloadGame::ID:
      return callbackQueryPayloadGame::fetch(env, p);
    case canPostStoryResultOk::ID:
      return canPostStoryResultOk::fetch(env, p);
    case canPostStoryResultPremiumNeeded::ID:
      return canPostStoryResultPremiumNeeded::fetch(env, p);
    case canPostStoryResultBoostNeeded::ID:
      return canPostStoryResultBoostNeeded::fetch(env, p);
    case canPostStoryResultActiveStoryLimitExceeded::ID:
      return canPostStoryResultActiveStoryLimitExceeded::fetch(env, p);
    case canPostStoryResultWeeklyLimitExceeded::ID:
      return canPostStoryResultWeeklyLimitExceeded::fetch(env, p);
    case canPostStoryResultMonthlyLimitExceeded::ID:
      return canPostStoryResultMonthlyLimitExceeded::fetch(env, p);
    case canSendMessageToUserResultOk::ID:
      return canSendMessageToUserResultOk::fetch(env, p);
    case canSendMessageToUserResultUserHasPaidMessages::ID:
      return canSendMessageToUserResultUserHasPaidMessages::fetch(env, p);
    case canSendMessageToUserResultUserIsDeleted::ID:
      return canSendMessageToUserResultUserIsDeleted::fetch(env, p);
    case canSendMessageToUserResultUserRestrictsNewChats::ID:
      return canSendMessageToUserResultUserRestrictsNewChats::fetch(env, p);
    case canTransferOwnershipResultOk::ID:
      return canTransferOwnershipResultOk::fetch(env, p);
    case canTransferOwnershipResultPasswordNeeded::ID:
      return canTransferOwnershipResultPasswordNeeded::fetch(env, p);
    case canTransferOwnershipResultPasswordTooFresh::ID:
      return canTransferOwnershipResultPasswordTooFresh::fetch(env, p);
    case canTransferOwnershipResultSessionTooFresh::ID:
      return canTransferOwnershipResultSessionTooFresh::fetch(env, p);
    case chat::ID:
      return chat::fetch(env, p);
    case chatActionTyping::ID:
      return chatActionTyping::fetch(env, p);
    case chatActionRecordingVideo::ID:
      return chatActionRecordingVideo::fetch(env, p);
    case chatActionUploadingVideo::ID:
      return chatActionUploadingVideo::fetch(env, p);
    case chatActionRecordingVoiceNote::ID:
      return chatActionRecordingVoiceNote::fetch(env, p);
    case chatActionUploadingVoiceNote::ID:
      return chatActionUploadingVoiceNote::fetch(env, p);
    case chatActionUploadingPhoto::ID:
      return chatActionUploadingPhoto::fetch(env, p);
    case chatActionUploadingDocument::ID:
      return chatActionUploadingDocument::fetch(env, p);
    case chatActionChoosingSticker::ID:
      return chatActionChoosingSticker::fetch(env, p);
    case chatActionChoosingLocation::ID:
      return chatActionChoosingLocation::fetch(env, p);
    case chatActionChoosingContact::ID:
      return chatActionChoosingContact::fetch(env, p);
    case chatActionStartPlayingGame::ID:
      return chatActionStartPlayingGame::fetch(env, p);
    case chatActionRecordingVideoNote::ID:
      return chatActionRecordingVideoNote::fetch(env, p);
    case chatActionUploadingVideoNote::ID:
      return chatActionUploadingVideoNote::fetch(env, p);
    case chatActionWatchingAnimations::ID:
      return chatActionWatchingAnimations::fetch(env, p);
    case chatActionCancel::ID:
      return chatActionCancel::fetch(env, p);
    case chatActionBarReportSpam::ID:
      return chatActionBarReportSpam::fetch(env, p);
    case chatActionBarInviteMembers::ID:
      return chatActionBarInviteMembers::fetch(env, p);
    case chatActionBarReportAddBlock::ID:
      return chatActionBarReportAddBlock::fetch(env, p);
    case chatActionBarAddContact::ID:
      return chatActionBarAddContact::fetch(env, p);
    case chatActionBarSharePhoneNumber::ID:
      return chatActionBarSharePhoneNumber::fetch(env, p);
    case chatActionBarJoinRequest::ID:
      return chatActionBarJoinRequest::fetch(env, p);
    case chatActiveStories::ID:
      return chatActiveStories::fetch(env, p);
    case chatAdministrator::ID:
      return chatAdministrator::fetch(env, p);
    case chatAdministratorRights::ID:
      return chatAdministratorRights::fetch(env, p);
    case chatAdministrators::ID:
      return chatAdministrators::fetch(env, p);
    case chatAvailableReactionsAll::ID:
      return chatAvailableReactionsAll::fetch(env, p);
    case chatAvailableReactionsSome::ID:
      return chatAvailableReactionsSome::fetch(env, p);
    case chatBackground::ID:
      return chatBackground::fetch(env, p);
    case chatBoost::ID:
      return chatBoost::fetch(env, p);
    case chatBoostFeatures::ID:
      return chatBoostFeatures::fetch(env, p);
    case chatBoostLevelFeatures::ID:
      return chatBoostLevelFeatures::fetch(env, p);
    case chatBoostLink::ID:
      return chatBoostLink::fetch(env, p);
    case chatBoostLinkInfo::ID:
      return chatBoostLinkInfo::fetch(env, p);
    case chatBoostSlot::ID:
      return chatBoostSlot::fetch(env, p);
    case chatBoostSlots::ID:
      return chatBoostSlots::fetch(env, p);
    case chatBoostSourceGiftCode::ID:
      return chatBoostSourceGiftCode::fetch(env, p);
    case chatBoostSourceGiveaway::ID:
      return chatBoostSourceGiveaway::fetch(env, p);
    case chatBoostSourcePremium::ID:
      return chatBoostSourcePremium::fetch(env, p);
    case chatBoostStatus::ID:
      return chatBoostStatus::fetch(env, p);
    case chatEvent::ID:
      return chatEvent::fetch(env, p);
    case chatEventMessageEdited::ID:
      return chatEventMessageEdited::fetch(env, p);
    case chatEventMessageDeleted::ID:
      return chatEventMessageDeleted::fetch(env, p);
    case chatEventMessagePinned::ID:
      return chatEventMessagePinned::fetch(env, p);
    case chatEventMessageUnpinned::ID:
      return chatEventMessageUnpinned::fetch(env, p);
    case chatEventPollStopped::ID:
      return chatEventPollStopped::fetch(env, p);
    case chatEventMemberJoined::ID:
      return chatEventMemberJoined::fetch(env, p);
    case chatEventMemberJoinedByInviteLink::ID:
      return chatEventMemberJoinedByInviteLink::fetch(env, p);
    case chatEventMemberJoinedByRequest::ID:
      return chatEventMemberJoinedByRequest::fetch(env, p);
    case chatEventMemberInvited::ID:
      return chatEventMemberInvited::fetch(env, p);
    case chatEventMemberLeft::ID:
      return chatEventMemberLeft::fetch(env, p);
    case chatEventMemberPromoted::ID:
      return chatEventMemberPromoted::fetch(env, p);
    case chatEventMemberRestricted::ID:
      return chatEventMemberRestricted::fetch(env, p);
    case chatEventMemberSubscriptionExtended::ID:
      return chatEventMemberSubscriptionExtended::fetch(env, p);
    case chatEventAvailableReactionsChanged::ID:
      return chatEventAvailableReactionsChanged::fetch(env, p);
    case chatEventBackgroundChanged::ID:
      return chatEventBackgroundChanged::fetch(env, p);
    case chatEventDescriptionChanged::ID:
      return chatEventDescriptionChanged::fetch(env, p);
    case chatEventEmojiStatusChanged::ID:
      return chatEventEmojiStatusChanged::fetch(env, p);
    case chatEventLinkedChatChanged::ID:
      return chatEventLinkedChatChanged::fetch(env, p);
    case chatEventLocationChanged::ID:
      return chatEventLocationChanged::fetch(env, p);
    case chatEventMessageAutoDeleteTimeChanged::ID:
      return chatEventMessageAutoDeleteTimeChanged::fetch(env, p);
    case chatEventPermissionsChanged::ID:
      return chatEventPermissionsChanged::fetch(env, p);
    case chatEventPhotoChanged::ID:
      return chatEventPhotoChanged::fetch(env, p);
    case chatEventSlowModeDelayChanged::ID:
      return chatEventSlowModeDelayChanged::fetch(env, p);
    case chatEventStickerSetChanged::ID:
      return chatEventStickerSetChanged::fetch(env, p);
    case chatEventCustomEmojiStickerSetChanged::ID:
      return chatEventCustomEmojiStickerSetChanged::fetch(env, p);
    case chatEventTitleChanged::ID:
      return chatEventTitleChanged::fetch(env, p);
    case chatEventUsernameChanged::ID:
      return chatEventUsernameChanged::fetch(env, p);
    case chatEventActiveUsernamesChanged::ID:
      return chatEventActiveUsernamesChanged::fetch(env, p);
    case chatEventAccentColorChanged::ID:
      return chatEventAccentColorChanged::fetch(env, p);
    case chatEventProfileAccentColorChanged::ID:
      return chatEventProfileAccentColorChanged::fetch(env, p);
    case chatEventHasProtectedContentToggled::ID:
      return chatEventHasProtectedContentToggled::fetch(env, p);
    case chatEventInvitesToggled::ID:
      return chatEventInvitesToggled::fetch(env, p);
    case chatEventIsAllHistoryAvailableToggled::ID:
      return chatEventIsAllHistoryAvailableToggled::fetch(env, p);
    case chatEventHasAggressiveAntiSpamEnabledToggled::ID:
      return chatEventHasAggressiveAntiSpamEnabledToggled::fetch(env, p);
    case chatEventSignMessagesToggled::ID:
      return chatEventSignMessagesToggled::fetch(env, p);
    case chatEventShowMessageSenderToggled::ID:
      return chatEventShowMessageSenderToggled::fetch(env, p);
    case chatEventAutomaticTranslationToggled::ID:
      return chatEventAutomaticTranslationToggled::fetch(env, p);
    case chatEventInviteLinkEdited::ID:
      return chatEventInviteLinkEdited::fetch(env, p);
    case chatEventInviteLinkRevoked::ID:
      return chatEventInviteLinkRevoked::fetch(env, p);
    case chatEventInviteLinkDeleted::ID:
      return chatEventInviteLinkDeleted::fetch(env, p);
    case chatEventVideoChatCreated::ID:
      return chatEventVideoChatCreated::fetch(env, p);
    case chatEventVideoChatEnded::ID:
      return chatEventVideoChatEnded::fetch(env, p);
    case chatEventVideoChatMuteNewParticipantsToggled::ID:
      return chatEventVideoChatMuteNewParticipantsToggled::fetch(env, p);
    case chatEventVideoChatParticipantIsMutedToggled::ID:
      return chatEventVideoChatParticipantIsMutedToggled::fetch(env, p);
    case chatEventVideoChatParticipantVolumeLevelChanged::ID:
      return chatEventVideoChatParticipantVolumeLevelChanged::fetch(env, p);
    case chatEventIsForumToggled::ID:
      return chatEventIsForumToggled::fetch(env, p);
    case chatEventForumTopicCreated::ID:
      return chatEventForumTopicCreated::fetch(env, p);
    case chatEventForumTopicEdited::ID:
      return chatEventForumTopicEdited::fetch(env, p);
    case chatEventForumTopicToggleIsClosed::ID:
      return chatEventForumTopicToggleIsClosed::fetch(env, p);
    case chatEventForumTopicToggleIsHidden::ID:
      return chatEventForumTopicToggleIsHidden::fetch(env, p);
    case chatEventForumTopicDeleted::ID:
      return chatEventForumTopicDeleted::fetch(env, p);
    case chatEventForumTopicPinned::ID:
      return chatEventForumTopicPinned::fetch(env, p);
    case chatEventLogFilters::ID:
      return chatEventLogFilters::fetch(env, p);
    case chatEvents::ID:
      return chatEvents::fetch(env, p);
    case chatFolder::ID:
      return chatFolder::fetch(env, p);
    case chatFolderIcon::ID:
      return chatFolderIcon::fetch(env, p);
    case chatFolderInfo::ID:
      return chatFolderInfo::fetch(env, p);
    case chatFolderInviteLink::ID:
      return chatFolderInviteLink::fetch(env, p);
    case chatFolderInviteLinkInfo::ID:
      return chatFolderInviteLinkInfo::fetch(env, p);
    case chatFolderInviteLinks::ID:
      return chatFolderInviteLinks::fetch(env, p);
    case chatFolderName::ID:
      return chatFolderName::fetch(env, p);
    case chatInviteLink::ID:
      return chatInviteLink::fetch(env, p);
    case chatInviteLinkCount::ID:
      return chatInviteLinkCount::fetch(env, p);
    case chatInviteLinkCounts::ID:
      return chatInviteLinkCounts::fetch(env, p);
    case chatInviteLinkInfo::ID:
      return chatInviteLinkInfo::fetch(env, p);
    case chatInviteLinkMember::ID:
      return chatInviteLinkMember::fetch(env, p);
    case chatInviteLinkMembers::ID:
      return chatInviteLinkMembers::fetch(env, p);
    case chatInviteLinkSubscriptionInfo::ID:
      return chatInviteLinkSubscriptionInfo::fetch(env, p);
    case chatInviteLinks::ID:
      return chatInviteLinks::fetch(env, p);
    case chatJoinRequest::ID:
      return chatJoinRequest::fetch(env, p);
    case chatJoinRequests::ID:
      return chatJoinRequests::fetch(env, p);
    case chatJoinRequestsInfo::ID:
      return chatJoinRequestsInfo::fetch(env, p);
    case chatListMain::ID:
      return chatListMain::fetch(env, p);
    case chatListArchive::ID:
      return chatListArchive::fetch(env, p);
    case chatListFolder::ID:
      return chatListFolder::fetch(env, p);
    case chatLists::ID:
      return chatLists::fetch(env, p);
    case chatLocation::ID:
      return chatLocation::fetch(env, p);
    case chatMember::ID:
      return chatMember::fetch(env, p);
    case chatMemberStatusCreator::ID:
      return chatMemberStatusCreator::fetch(env, p);
    case chatMemberStatusAdministrator::ID:
      return chatMemberStatusAdministrator::fetch(env, p);
    case chatMemberStatusMember::ID:
      return chatMemberStatusMember::fetch(env, p);
    case chatMemberStatusRestricted::ID:
      return chatMemberStatusRestricted::fetch(env, p);
    case chatMemberStatusLeft::ID:
      return chatMemberStatusLeft::fetch(env, p);
    case chatMemberStatusBanned::ID:
      return chatMemberStatusBanned::fetch(env, p);
    case chatMembers::ID:
      return chatMembers::fetch(env, p);
    case chatMembersFilterContacts::ID:
      return chatMembersFilterContacts::fetch(env, p);
    case chatMembersFilterAdministrators::ID:
      return chatMembersFilterAdministrators::fetch(env, p);
    case chatMembersFilterMembers::ID:
      return chatMembersFilterMembers::fetch(env, p);
    case chatMembersFilterMention::ID:
      return chatMembersFilterMention::fetch(env, p);
    case chatMembersFilterRestricted::ID:
      return chatMembersFilterRestricted::fetch(env, p);
    case chatMembersFilterBanned::ID:
      return chatMembersFilterBanned::fetch(env, p);
    case chatMembersFilterBots::ID:
      return chatMembersFilterBots::fetch(env, p);
    case chatMessageSender::ID:
      return chatMessageSender::fetch(env, p);
    case chatMessageSenders::ID:
      return chatMessageSenders::fetch(env, p);
    case chatNotificationSettings::ID:
      return chatNotificationSettings::fetch(env, p);
    case chatPermissions::ID:
      return chatPermissions::fetch(env, p);
    case chatPhoto::ID:
      return chatPhoto::fetch(env, p);
    case chatPhotoInfo::ID:
      return chatPhotoInfo::fetch(env, p);
    case chatPhotoSticker::ID:
      return chatPhotoSticker::fetch(env, p);
    case chatPhotoStickerTypeRegularOrMask::ID:
      return chatPhotoStickerTypeRegularOrMask::fetch(env, p);
    case chatPhotoStickerTypeCustomEmoji::ID:
      return chatPhotoStickerTypeCustomEmoji::fetch(env, p);
    case chatPhotos::ID:
      return chatPhotos::fetch(env, p);
    case chatPosition::ID:
      return chatPosition::fetch(env, p);
    case chatRevenueAmount::ID:
      return chatRevenueAmount::fetch(env, p);
    case chatRevenueStatistics::ID:
      return chatRevenueStatistics::fetch(env, p);
    case chatRevenueTransaction::ID:
      return chatRevenueTransaction::fetch(env, p);
    case chatRevenueTransactionTypeUnsupported::ID:
      return chatRevenueTransactionTypeUnsupported::fetch(env, p);
    case chatRevenueTransactionTypeSponsoredMessageEarnings::ID:
      return chatRevenueTransactionTypeSponsoredMessageEarnings::fetch(env, p);
    case chatRevenueTransactionTypeSuggestedPostEarnings::ID:
      return chatRevenueTransactionTypeSuggestedPostEarnings::fetch(env, p);
    case chatRevenueTransactionTypeFragmentWithdrawal::ID:
      return chatRevenueTransactionTypeFragmentWithdrawal::fetch(env, p);
    case chatRevenueTransactionTypeFragmentRefund::ID:
      return chatRevenueTransactionTypeFragmentRefund::fetch(env, p);
    case chatRevenueTransactions::ID:
      return chatRevenueTransactions::fetch(env, p);
    case chatSourceMtprotoProxy::ID:
      return chatSourceMtprotoProxy::fetch(env, p);
    case chatSourcePublicServiceAnnouncement::ID:
      return chatSourcePublicServiceAnnouncement::fetch(env, p);
    case chatStatisticsSupergroup::ID:
      return chatStatisticsSupergroup::fetch(env, p);
    case chatStatisticsChannel::ID:
      return chatStatisticsChannel::fetch(env, p);
    case chatStatisticsAdministratorActionsInfo::ID:
      return chatStatisticsAdministratorActionsInfo::fetch(env, p);
    case chatStatisticsInteractionInfo::ID:
      return chatStatisticsInteractionInfo::fetch(env, p);
    case chatStatisticsInviterInfo::ID:
      return chatStatisticsInviterInfo::fetch(env, p);
    case chatStatisticsMessageSenderInfo::ID:
      return chatStatisticsMessageSenderInfo::fetch(env, p);
    case chatStatisticsObjectTypeMessage::ID:
      return chatStatisticsObjectTypeMessage::fetch(env, p);
    case chatStatisticsObjectTypeStory::ID:
      return chatStatisticsObjectTypeStory::fetch(env, p);
    case chatTheme::ID:
      return chatTheme::fetch(env, p);
    case chatTypePrivate::ID:
      return chatTypePrivate::fetch(env, p);
    case chatTypeBasicGroup::ID:
      return chatTypeBasicGroup::fetch(env, p);
    case chatTypeSupergroup::ID:
      return chatTypeSupergroup::fetch(env, p);
    case chatTypeSecret::ID:
      return chatTypeSecret::fetch(env, p);
    case chats::ID:
      return chats::fetch(env, p);
    case checkChatUsernameResultOk::ID:
      return checkChatUsernameResultOk::fetch(env, p);
    case checkChatUsernameResultUsernameInvalid::ID:
      return checkChatUsernameResultUsernameInvalid::fetch(env, p);
    case checkChatUsernameResultUsernameOccupied::ID:
      return checkChatUsernameResultUsernameOccupied::fetch(env, p);
    case checkChatUsernameResultUsernamePurchasable::ID:
      return checkChatUsernameResultUsernamePurchasable::fetch(env, p);
    case checkChatUsernameResultPublicChatsTooMany::ID:
      return checkChatUsernameResultPublicChatsTooMany::fetch(env, p);
    case checkChatUsernameResultPublicGroupsUnavailable::ID:
      return checkChatUsernameResultPublicGroupsUnavailable::fetch(env, p);
    case checkStickerSetNameResultOk::ID:
      return checkStickerSetNameResultOk::fetch(env, p);
    case checkStickerSetNameResultNameInvalid::ID:
      return checkStickerSetNameResultNameInvalid::fetch(env, p);
    case checkStickerSetNameResultNameOccupied::ID:
      return checkStickerSetNameResultNameOccupied::fetch(env, p);
    case checklist::ID:
      return checklist::fetch(env, p);
    case checklistTask::ID:
      return checklistTask::fetch(env, p);
    case closeBirthdayUser::ID:
      return closeBirthdayUser::fetch(env, p);
    case closedVectorPath::ID:
      return closedVectorPath::fetch(env, p);
    case collectibleItemInfo::ID:
      return collectibleItemInfo::fetch(env, p);
    case collectibleItemTypeUsername::ID:
      return collectibleItemTypeUsername::fetch(env, p);
    case collectibleItemTypePhoneNumber::ID:
      return collectibleItemTypePhoneNumber::fetch(env, p);
    case connectedAffiliateProgram::ID:
      return connectedAffiliateProgram::fetch(env, p);
    case connectedAffiliatePrograms::ID:
      return connectedAffiliatePrograms::fetch(env, p);
    case connectedWebsite::ID:
      return connectedWebsite::fetch(env, p);
    case connectedWebsites::ID:
      return connectedWebsites::fetch(env, p);
    case connectionStateWaitingForNetwork::ID:
      return connectionStateWaitingForNetwork::fetch(env, p);
    case connectionStateConnectingToProxy::ID:
      return connectionStateConnectingToProxy::fetch(env, p);
    case connectionStateConnecting::ID:
      return connectionStateConnecting::fetch(env, p);
    case connectionStateUpdating::ID:
      return connectionStateUpdating::fetch(env, p);
    case connectionStateReady::ID:
      return connectionStateReady::fetch(env, p);
    case contact::ID:
      return contact::fetch(env, p);
    case count::ID:
      return count::fetch(env, p);
    case countries::ID:
      return countries::fetch(env, p);
    case countryInfo::ID:
      return countryInfo::fetch(env, p);
    case createdBasicGroupChat::ID:
      return createdBasicGroupChat::fetch(env, p);
    case currentWeather::ID:
      return currentWeather::fetch(env, p);
    case customRequestResult::ID:
      return customRequestResult::fetch(env, p);
    case data::ID:
      return data::fetch(env, p);
    case databaseStatistics::ID:
      return databaseStatistics::fetch(env, p);
    case date::ID:
      return date::fetch(env, p);
    case dateRange::ID:
      return dateRange::fetch(env, p);
    case datedFile::ID:
      return datedFile::fetch(env, p);
    case deepLinkInfo::ID:
      return deepLinkInfo::fetch(env, p);
    case deviceTokenFirebaseCloudMessaging::ID:
      return deviceTokenFirebaseCloudMessaging::fetch(env, p);
    case deviceTokenApplePush::ID:
      return deviceTokenApplePush::fetch(env, p);
    case deviceTokenApplePushVoIP::ID:
      return deviceTokenApplePushVoIP::fetch(env, p);
    case deviceTokenWindowsPush::ID:
      return deviceTokenWindowsPush::fetch(env, p);
    case deviceTokenMicrosoftPush::ID:
      return deviceTokenMicrosoftPush::fetch(env, p);
    case deviceTokenMicrosoftPushVoIP::ID:
      return deviceTokenMicrosoftPushVoIP::fetch(env, p);
    case deviceTokenWebPush::ID:
      return deviceTokenWebPush::fetch(env, p);
    case deviceTokenSimplePush::ID:
      return deviceTokenSimplePush::fetch(env, p);
    case deviceTokenUbuntuPush::ID:
      return deviceTokenUbuntuPush::fetch(env, p);
    case deviceTokenBlackBerryPush::ID:
      return deviceTokenBlackBerryPush::fetch(env, p);
    case deviceTokenTizenPush::ID:
      return deviceTokenTizenPush::fetch(env, p);
    case deviceTokenHuaweiPush::ID:
      return deviceTokenHuaweiPush::fetch(env, p);
    case diceStickersRegular::ID:
      return diceStickersRegular::fetch(env, p);
    case diceStickersSlotMachine::ID:
      return diceStickersSlotMachine::fetch(env, p);
    case directMessagesChatTopic::ID:
      return directMessagesChatTopic::fetch(env, p);
    case document::ID:
      return document::fetch(env, p);
    case downloadedFileCounts::ID:
      return downloadedFileCounts::fetch(env, p);
    case draftMessage::ID:
      return draftMessage::fetch(env, p);
    case emailAddressAuthenticationCode::ID:
      return emailAddressAuthenticationCode::fetch(env, p);
    case emailAddressAuthenticationAppleId::ID:
      return emailAddressAuthenticationAppleId::fetch(env, p);
    case emailAddressAuthenticationGoogleId::ID:
      return emailAddressAuthenticationGoogleId::fetch(env, p);
    case emailAddressAuthenticationCodeInfo::ID:
      return emailAddressAuthenticationCodeInfo::fetch(env, p);
    case emailAddressResetStateAvailable::ID:
      return emailAddressResetStateAvailable::fetch(env, p);
    case emailAddressResetStatePending::ID:
      return emailAddressResetStatePending::fetch(env, p);
    case emojiCategories::ID:
      return emojiCategories::fetch(env, p);
    case emojiCategory::ID:
      return emojiCategory::fetch(env, p);
    case emojiCategorySourceSearch::ID:
      return emojiCategorySourceSearch::fetch(env, p);
    case emojiCategorySourcePremium::ID:
      return emojiCategorySourcePremium::fetch(env, p);
    case emojiCategoryTypeDefault::ID:
      return emojiCategoryTypeDefault::fetch(env, p);
    case emojiCategoryTypeRegularStickers::ID:
      return emojiCategoryTypeRegularStickers::fetch(env, p);
    case emojiCategoryTypeEmojiStatus::ID:
      return emojiCategoryTypeEmojiStatus::fetch(env, p);
    case emojiCategoryTypeChatPhoto::ID:
      return emojiCategoryTypeChatPhoto::fetch(env, p);
    case emojiKeyword::ID:
      return emojiKeyword::fetch(env, p);
    case emojiKeywords::ID:
      return emojiKeywords::fetch(env, p);
    case emojiReaction::ID:
      return emojiReaction::fetch(env, p);
    case emojiStatus::ID:
      return emojiStatus::fetch(env, p);
    case emojiStatusCustomEmojis::ID:
      return emojiStatusCustomEmojis::fetch(env, p);
    case emojiStatusTypeCustomEmoji::ID:
      return emojiStatusTypeCustomEmoji::fetch(env, p);
    case emojiStatusTypeUpgradedGift::ID:
      return emojiStatusTypeUpgradedGift::fetch(env, p);
    case emojiStatuses::ID:
      return emojiStatuses::fetch(env, p);
    case emojis::ID:
      return emojis::fetch(env, p);
    case encryptedCredentials::ID:
      return encryptedCredentials::fetch(env, p);
    case encryptedPassportElement::ID:
      return encryptedPassportElement::fetch(env, p);
    case error::ID:
      return error::fetch(env, p);
    case factCheck::ID:
      return factCheck::fetch(env, p);
    case failedToAddMember::ID:
      return failedToAddMember::fetch(env, p);
    case failedToAddMembers::ID:
      return failedToAddMembers::fetch(env, p);
    case file::ID:
      return file::fetch(env, p);
    case fileDownload::ID:
      return fileDownload::fetch(env, p);
    case fileDownloadedPrefixSize::ID:
      return fileDownloadedPrefixSize::fetch(env, p);
    case fileTypeNone::ID:
      return fileTypeNone::fetch(env, p);
    case fileTypeAnimation::ID:
      return fileTypeAnimation::fetch(env, p);
    case fileTypeAudio::ID:
      return fileTypeAudio::fetch(env, p);
    case fileTypeDocument::ID:
      return fileTypeDocument::fetch(env, p);
    case fileTypeNotificationSound::ID:
      return fileTypeNotificationSound::fetch(env, p);
    case fileTypePhoto::ID:
      return fileTypePhoto::fetch(env, p);
    case fileTypePhotoStory::ID:
      return fileTypePhotoStory::fetch(env, p);
    case fileTypeProfilePhoto::ID:
      return fileTypeProfilePhoto::fetch(env, p);
    case fileTypeSecret::ID:
      return fileTypeSecret::fetch(env, p);
    case fileTypeSecretThumbnail::ID:
      return fileTypeSecretThumbnail::fetch(env, p);
    case fileTypeSecure::ID:
      return fileTypeSecure::fetch(env, p);
    case fileTypeSelfDestructingPhoto::ID:
      return fileTypeSelfDestructingPhoto::fetch(env, p);
    case fileTypeSelfDestructingVideo::ID:
      return fileTypeSelfDestructingVideo::fetch(env, p);
    case fileTypeSelfDestructingVideoNote::ID:
      return fileTypeSelfDestructingVideoNote::fetch(env, p);
    case fileTypeSelfDestructingVoiceNote::ID:
      return fileTypeSelfDestructingVoiceNote::fetch(env, p);
    case fileTypeSticker::ID:
      return fileTypeSticker::fetch(env, p);
    case fileTypeThumbnail::ID:
      return fileTypeThumbnail::fetch(env, p);
    case fileTypeUnknown::ID:
      return fileTypeUnknown::fetch(env, p);
    case fileTypeVideo::ID:
      return fileTypeVideo::fetch(env, p);
    case fileTypeVideoNote::ID:
      return fileTypeVideoNote::fetch(env, p);
    case fileTypeVideoStory::ID:
      return fileTypeVideoStory::fetch(env, p);
    case fileTypeVoiceNote::ID:
      return fileTypeVoiceNote::fetch(env, p);
    case fileTypeWallpaper::ID:
      return fileTypeWallpaper::fetch(env, p);
    case firebaseAuthenticationSettingsAndroid::ID:
      return firebaseAuthenticationSettingsAndroid::fetch(env, p);
    case firebaseAuthenticationSettingsIos::ID:
      return firebaseAuthenticationSettingsIos::fetch(env, p);
    case firebaseDeviceVerificationParametersSafetyNet::ID:
      return firebaseDeviceVerificationParametersSafetyNet::fetch(env, p);
    case firebaseDeviceVerificationParametersPlayIntegrity::ID:
      return firebaseDeviceVerificationParametersPlayIntegrity::fetch(env, p);
    case formattedText::ID:
      return formattedText::fetch(env, p);
    case forumTopic::ID:
      return forumTopic::fetch(env, p);
    case forumTopicIcon::ID:
      return forumTopicIcon::fetch(env, p);
    case forumTopicInfo::ID:
      return forumTopicInfo::fetch(env, p);
    case forumTopics::ID:
      return forumTopics::fetch(env, p);
    case forwardSource::ID:
      return forwardSource::fetch(env, p);
    case foundAffiliateProgram::ID:
      return foundAffiliateProgram::fetch(env, p);
    case foundAffiliatePrograms::ID:
      return foundAffiliatePrograms::fetch(env, p);
    case foundChatBoosts::ID:
      return foundChatBoosts::fetch(env, p);
    case foundChatMessages::ID:
      return foundChatMessages::fetch(env, p);
    case foundFileDownloads::ID:
      return foundFileDownloads::fetch(env, p);
    case foundMessages::ID:
      return foundMessages::fetch(env, p);
    case foundPosition::ID:
      return foundPosition::fetch(env, p);
    case foundPositions::ID:
      return foundPositions::fetch(env, p);
    case foundStories::ID:
      return foundStories::fetch(env, p);
    case foundUsers::ID:
      return foundUsers::fetch(env, p);
    case foundWebApp::ID:
      return foundWebApp::fetch(env, p);
    case game::ID:
      return game::fetch(env, p);
    case gameHighScore::ID:
      return gameHighScore::fetch(env, p);
    case gameHighScores::ID:
      return gameHighScores::fetch(env, p);
    case gift::ID:
      return gift::fetch(env, p);
    case giftForResale::ID:
      return giftForResale::fetch(env, p);
    case giftForResaleOrderPrice::ID:
      return giftForResaleOrderPrice::fetch(env, p);
    case giftForResaleOrderPriceChangeDate::ID:
      return giftForResaleOrderPriceChangeDate::fetch(env, p);
    case giftForResaleOrderNumber::ID:
      return giftForResaleOrderNumber::fetch(env, p);
    case giftSettings::ID:
      return giftSettings::fetch(env, p);
    case giftUpgradePreview::ID:
      return giftUpgradePreview::fetch(env, p);
    case giftsForResale::ID:
      return giftsForResale::fetch(env, p);
    case giveawayInfoOngoing::ID:
      return giveawayInfoOngoing::fetch(env, p);
    case giveawayInfoCompleted::ID:
      return giveawayInfoCompleted::fetch(env, p);
    case giveawayParameters::ID:
      return giveawayParameters::fetch(env, p);
    case giveawayParticipantStatusEligible::ID:
      return giveawayParticipantStatusEligible::fetch(env, p);
    case giveawayParticipantStatusParticipating::ID:
      return giveawayParticipantStatusParticipating::fetch(env, p);
    case giveawayParticipantStatusAlreadyWasMember::ID:
      return giveawayParticipantStatusAlreadyWasMember::fetch(env, p);
    case giveawayParticipantStatusAdministrator::ID:
      return giveawayParticipantStatusAdministrator::fetch(env, p);
    case giveawayParticipantStatusDisallowedCountry::ID:
      return giveawayParticipantStatusDisallowedCountry::fetch(env, p);
    case giveawayPrizePremium::ID:
      return giveawayPrizePremium::fetch(env, p);
    case giveawayPrizeStars::ID:
      return giveawayPrizeStars::fetch(env, p);
    case groupCall::ID:
      return groupCall::fetch(env, p);
    case groupCallDataChannelMain::ID:
      return groupCallDataChannelMain::fetch(env, p);
    case groupCallDataChannelScreenSharing::ID:
      return groupCallDataChannelScreenSharing::fetch(env, p);
    case groupCallId::ID:
      return groupCallId::fetch(env, p);
    case groupCallInfo::ID:
      return groupCallInfo::fetch(env, p);
    case groupCallJoinParameters::ID:
      return groupCallJoinParameters::fetch(env, p);
    case groupCallParticipant::ID:
      return groupCallParticipant::fetch(env, p);
    case groupCallParticipantVideoInfo::ID:
      return groupCallParticipantVideoInfo::fetch(env, p);
    case groupCallParticipants::ID:
      return groupCallParticipants::fetch(env, p);
    case groupCallRecentSpeaker::ID:
      return groupCallRecentSpeaker::fetch(env, p);
    case groupCallVideoQualityThumbnail::ID:
      return groupCallVideoQualityThumbnail::fetch(env, p);
    case groupCallVideoQualityMedium::ID:
      return groupCallVideoQualityMedium::fetch(env, p);
    case groupCallVideoQualityFull::ID:
      return groupCallVideoQualityFull::fetch(env, p);
    case groupCallVideoSourceGroup::ID:
      return groupCallVideoSourceGroup::fetch(env, p);
    case hashtags::ID:
      return hashtags::fetch(env, p);
    case httpUrl::ID:
      return httpUrl::fetch(env, p);
    case identityDocument::ID:
      return identityDocument::fetch(env, p);
    case importedContacts::ID:
      return importedContacts::fetch(env, p);
    case inlineKeyboardButton::ID:
      return inlineKeyboardButton::fetch(env, p);
    case inlineKeyboardButtonTypeUrl::ID:
      return inlineKeyboardButtonTypeUrl::fetch(env, p);
    case inlineKeyboardButtonTypeLoginUrl::ID:
      return inlineKeyboardButtonTypeLoginUrl::fetch(env, p);
    case inlineKeyboardButtonTypeWebApp::ID:
      return inlineKeyboardButtonTypeWebApp::fetch(env, p);
    case inlineKeyboardButtonTypeCallback::ID:
      return inlineKeyboardButtonTypeCallback::fetch(env, p);
    case inlineKeyboardButtonTypeCallbackWithPassword::ID:
      return inlineKeyboardButtonTypeCallbackWithPassword::fetch(env, p);
    case inlineKeyboardButtonTypeCallbackGame::ID:
      return inlineKeyboardButtonTypeCallbackGame::fetch(env, p);
    case inlineKeyboardButtonTypeSwitchInline::ID:
      return inlineKeyboardButtonTypeSwitchInline::fetch(env, p);
    case inlineKeyboardButtonTypeBuy::ID:
      return inlineKeyboardButtonTypeBuy::fetch(env, p);
    case inlineKeyboardButtonTypeUser::ID:
      return inlineKeyboardButtonTypeUser::fetch(env, p);
    case inlineKeyboardButtonTypeCopyText::ID:
      return inlineKeyboardButtonTypeCopyText::fetch(env, p);
    case inlineQueryResultArticle::ID:
      return inlineQueryResultArticle::fetch(env, p);
    case inlineQueryResultContact::ID:
      return inlineQueryResultContact::fetch(env, p);
    case inlineQueryResultLocation::ID:
      return inlineQueryResultLocation::fetch(env, p);
    case inlineQueryResultVenue::ID:
      return inlineQueryResultVenue::fetch(env, p);
    case inlineQueryResultGame::ID:
      return inlineQueryResultGame::fetch(env, p);
    case inlineQueryResultAnimation::ID:
      return inlineQueryResultAnimation::fetch(env, p);
    case inlineQueryResultAudio::ID:
      return inlineQueryResultAudio::fetch(env, p);
    case inlineQueryResultDocument::ID:
      return inlineQueryResultDocument::fetch(env, p);
    case inlineQueryResultPhoto::ID:
      return inlineQueryResultPhoto::fetch(env, p);
    case inlineQueryResultSticker::ID:
      return inlineQueryResultSticker::fetch(env, p);
    case inlineQueryResultVideo::ID:
      return inlineQueryResultVideo::fetch(env, p);
    case inlineQueryResultVoiceNote::ID:
      return inlineQueryResultVoiceNote::fetch(env, p);
    case inlineQueryResults::ID:
      return inlineQueryResults::fetch(env, p);
    case inlineQueryResultsButton::ID:
      return inlineQueryResultsButton::fetch(env, p);
    case inlineQueryResultsButtonTypeStartBot::ID:
      return inlineQueryResultsButtonTypeStartBot::fetch(env, p);
    case inlineQueryResultsButtonTypeWebApp::ID:
      return inlineQueryResultsButtonTypeWebApp::fetch(env, p);
    case inputBackgroundLocal::ID:
      return inputBackgroundLocal::fetch(env, p);
    case inputBackgroundRemote::ID:
      return inputBackgroundRemote::fetch(env, p);
    case inputBackgroundPrevious::ID:
      return inputBackgroundPrevious::fetch(env, p);
    case inputBusinessChatLink::ID:
      return inputBusinessChatLink::fetch(env, p);
    case inputBusinessStartPage::ID:
      return inputBusinessStartPage::fetch(env, p);
    case inputChatPhotoPrevious::ID:
      return inputChatPhotoPrevious::fetch(env, p);
    case inputChatPhotoStatic::ID:
      return inputChatPhotoStatic::fetch(env, p);
    case inputChatPhotoAnimation::ID:
      return inputChatPhotoAnimation::fetch(env, p);
    case inputChatPhotoSticker::ID:
      return inputChatPhotoSticker::fetch(env, p);
    case inputChecklist::ID:
      return inputChecklist::fetch(env, p);
    case inputChecklistTask::ID:
      return inputChecklistTask::fetch(env, p);
    case inputCredentialsSaved::ID:
      return inputCredentialsSaved::fetch(env, p);
    case inputCredentialsNew::ID:
      return inputCredentialsNew::fetch(env, p);
    case inputCredentialsApplePay::ID:
      return inputCredentialsApplePay::fetch(env, p);
    case inputCredentialsGooglePay::ID:
      return inputCredentialsGooglePay::fetch(env, p);
    case inputFileId::ID:
      return inputFileId::fetch(env, p);
    case inputFileRemote::ID:
      return inputFileRemote::fetch(env, p);
    case inputFileLocal::ID:
      return inputFileLocal::fetch(env, p);
    case inputFileGenerated::ID:
      return inputFileGenerated::fetch(env, p);
    case inputGroupCallLink::ID:
      return inputGroupCallLink::fetch(env, p);
    case inputGroupCallMessage::ID:
      return inputGroupCallMessage::fetch(env, p);
    case inputIdentityDocument::ID:
      return inputIdentityDocument::fetch(env, p);
    case inputInlineQueryResultAnimation::ID:
      return inputInlineQueryResultAnimation::fetch(env, p);
    case inputInlineQueryResultArticle::ID:
      return inputInlineQueryResultArticle::fetch(env, p);
    case inputInlineQueryResultAudio::ID:
      return inputInlineQueryResultAudio::fetch(env, p);
    case inputInlineQueryResultContact::ID:
      return inputInlineQueryResultContact::fetch(env, p);
    case inputInlineQueryResultDocument::ID:
      return inputInlineQueryResultDocument::fetch(env, p);
    case inputInlineQueryResultGame::ID:
      return inputInlineQueryResultGame::fetch(env, p);
    case inputInlineQueryResultLocation::ID:
      return inputInlineQueryResultLocation::fetch(env, p);
    case inputInlineQueryResultPhoto::ID:
      return inputInlineQueryResultPhoto::fetch(env, p);
    case inputInlineQueryResultSticker::ID:
      return inputInlineQueryResultSticker::fetch(env, p);
    case inputInlineQueryResultVenue::ID:
      return inputInlineQueryResultVenue::fetch(env, p);
    case inputInlineQueryResultVideo::ID:
      return inputInlineQueryResultVideo::fetch(env, p);
    case inputInlineQueryResultVoiceNote::ID:
      return inputInlineQueryResultVoiceNote::fetch(env, p);
    case inputInvoiceMessage::ID:
      return inputInvoiceMessage::fetch(env, p);
    case inputInvoiceName::ID:
      return inputInvoiceName::fetch(env, p);
    case inputInvoiceTelegram::ID:
      return inputInvoiceTelegram::fetch(env, p);
    case inputMessageText::ID:
      return inputMessageText::fetch(env, p);
    case inputMessageAnimation::ID:
      return inputMessageAnimation::fetch(env, p);
    case inputMessageAudio::ID:
      return inputMessageAudio::fetch(env, p);
    case inputMessageDocument::ID:
      return inputMessageDocument::fetch(env, p);
    case inputMessagePaidMedia::ID:
      return inputMessagePaidMedia::fetch(env, p);
    case inputMessagePhoto::ID:
      return inputMessagePhoto::fetch(env, p);
    case inputMessageSticker::ID:
      return inputMessageSticker::fetch(env, p);
    case inputMessageVideo::ID:
      return inputMessageVideo::fetch(env, p);
    case inputMessageVideoNote::ID:
      return inputMessageVideoNote::fetch(env, p);
    case inputMessageVoiceNote::ID:
      return inputMessageVoiceNote::fetch(env, p);
    case inputMessageLocation::ID:
      return inputMessageLocation::fetch(env, p);
    case inputMessageVenue::ID:
      return inputMessageVenue::fetch(env, p);
    case inputMessageContact::ID:
      return inputMessageContact::fetch(env, p);
    case inputMessageDice::ID:
      return inputMessageDice::fetch(env, p);
    case inputMessageGame::ID:
      return inputMessageGame::fetch(env, p);
    case inputMessageInvoice::ID:
      return inputMessageInvoice::fetch(env, p);
    case inputMessagePoll::ID:
      return inputMessagePoll::fetch(env, p);
    case inputMessageStory::ID:
      return inputMessageStory::fetch(env, p);
    case inputMessageChecklist::ID:
      return inputMessageChecklist::fetch(env, p);
    case inputMessageForwarded::ID:
      return inputMessageForwarded::fetch(env, p);
    case inputMessageReplyToMessage::ID:
      return inputMessageReplyToMessage::fetch(env, p);
    case inputMessageReplyToExternalMessage::ID:
      return inputMessageReplyToExternalMessage::fetch(env, p);
    case inputMessageReplyToStory::ID:
      return inputMessageReplyToStory::fetch(env, p);
    case inputPaidMedia::ID:
      return inputPaidMedia::fetch(env, p);
    case inputPaidMediaTypePhoto::ID:
      return inputPaidMediaTypePhoto::fetch(env, p);
    case inputPaidMediaTypeVideo::ID:
      return inputPaidMediaTypeVideo::fetch(env, p);
    case inputPassportElementPersonalDetails::ID:
      return inputPassportElementPersonalDetails::fetch(env, p);
    case inputPassportElementPassport::ID:
      return inputPassportElementPassport::fetch(env, p);
    case inputPassportElementDriverLicense::ID:
      return inputPassportElementDriverLicense::fetch(env, p);
    case inputPassportElementIdentityCard::ID:
      return inputPassportElementIdentityCard::fetch(env, p);
    case inputPassportElementInternalPassport::ID:
      return inputPassportElementInternalPassport::fetch(env, p);
    case inputPassportElementAddress::ID:
      return inputPassportElementAddress::fetch(env, p);
    case inputPassportElementUtilityBill::ID:
      return inputPassportElementUtilityBill::fetch(env, p);
    case inputPassportElementBankStatement::ID:
      return inputPassportElementBankStatement::fetch(env, p);
    case inputPassportElementRentalAgreement::ID:
      return inputPassportElementRentalAgreement::fetch(env, p);
    case inputPassportElementPassportRegistration::ID:
      return inputPassportElementPassportRegistration::fetch(env, p);
    case inputPassportElementTemporaryRegistration::ID:
      return inputPassportElementTemporaryRegistration::fetch(env, p);
    case inputPassportElementPhoneNumber::ID:
      return inputPassportElementPhoneNumber::fetch(env, p);
    case inputPassportElementEmailAddress::ID:
      return inputPassportElementEmailAddress::fetch(env, p);
    case inputPassportElementError::ID:
      return inputPassportElementError::fetch(env, p);
    case inputPassportElementErrorSourceUnspecified::ID:
      return inputPassportElementErrorSourceUnspecified::fetch(env, p);
    case inputPassportElementErrorSourceDataField::ID:
      return inputPassportElementErrorSourceDataField::fetch(env, p);
    case inputPassportElementErrorSourceFrontSide::ID:
      return inputPassportElementErrorSourceFrontSide::fetch(env, p);
    case inputPassportElementErrorSourceReverseSide::ID:
      return inputPassportElementErrorSourceReverseSide::fetch(env, p);
    case inputPassportElementErrorSourceSelfie::ID:
      return inputPassportElementErrorSourceSelfie::fetch(env, p);
    case inputPassportElementErrorSourceTranslationFile::ID:
      return inputPassportElementErrorSourceTranslationFile::fetch(env, p);
    case inputPassportElementErrorSourceTranslationFiles::ID:
      return inputPassportElementErrorSourceTranslationFiles::fetch(env, p);
    case inputPassportElementErrorSourceFile::ID:
      return inputPassportElementErrorSourceFile::fetch(env, p);
    case inputPassportElementErrorSourceFiles::ID:
      return inputPassportElementErrorSourceFiles::fetch(env, p);
    case inputPersonalDocument::ID:
      return inputPersonalDocument::fetch(env, p);
    case inputSticker::ID:
      return inputSticker::fetch(env, p);
    case inputStoryArea::ID:
      return inputStoryArea::fetch(env, p);
    case inputStoryAreaTypeLocation::ID:
      return inputStoryAreaTypeLocation::fetch(env, p);
    case inputStoryAreaTypeFoundVenue::ID:
      return inputStoryAreaTypeFoundVenue::fetch(env, p);
    case inputStoryAreaTypePreviousVenue::ID:
      return inputStoryAreaTypePreviousVenue::fetch(env, p);
    case inputStoryAreaTypeSuggestedReaction::ID:
      return inputStoryAreaTypeSuggestedReaction::fetch(env, p);
    case inputStoryAreaTypeMessage::ID:
      return inputStoryAreaTypeMessage::fetch(env, p);
    case inputStoryAreaTypeLink::ID:
      return inputStoryAreaTypeLink::fetch(env, p);
    case inputStoryAreaTypeWeather::ID:
      return inputStoryAreaTypeWeather::fetch(env, p);
    case inputStoryAreaTypeUpgradedGift::ID:
      return inputStoryAreaTypeUpgradedGift::fetch(env, p);
    case inputStoryAreas::ID:
      return inputStoryAreas::fetch(env, p);
    case inputStoryContentPhoto::ID:
      return inputStoryContentPhoto::fetch(env, p);
    case inputStoryContentVideo::ID:
      return inputStoryContentVideo::fetch(env, p);
    case inputSuggestedPostInfo::ID:
      return inputSuggestedPostInfo::fetch(env, p);
    case inputTextQuote::ID:
      return inputTextQuote::fetch(env, p);
    case inputThumbnail::ID:
      return inputThumbnail::fetch(env, p);
    case internalLinkTypeActiveSessions::ID:
      return internalLinkTypeActiveSessions::fetch(env, p);
    case internalLinkTypeAttachmentMenuBot::ID:
      return internalLinkTypeAttachmentMenuBot::fetch(env, p);
    case internalLinkTypeAuthenticationCode::ID:
      return internalLinkTypeAuthenticationCode::fetch(env, p);
    case internalLinkTypeBackground::ID:
      return internalLinkTypeBackground::fetch(env, p);
    case internalLinkTypeBotAddToChannel::ID:
      return internalLinkTypeBotAddToChannel::fetch(env, p);
    case internalLinkTypeBotStart::ID:
      return internalLinkTypeBotStart::fetch(env, p);
    case internalLinkTypeBotStartInGroup::ID:
      return internalLinkTypeBotStartInGroup::fetch(env, p);
    case internalLinkTypeBusinessChat::ID:
      return internalLinkTypeBusinessChat::fetch(env, p);
    case internalLinkTypeBuyStars::ID:
      return internalLinkTypeBuyStars::fetch(env, p);
    case internalLinkTypeChangePhoneNumber::ID:
      return internalLinkTypeChangePhoneNumber::fetch(env, p);
    case internalLinkTypeChatAffiliateProgram::ID:
      return internalLinkTypeChatAffiliateProgram::fetch(env, p);
    case internalLinkTypeChatBoost::ID:
      return internalLinkTypeChatBoost::fetch(env, p);
    case internalLinkTypeChatFolderInvite::ID:
      return internalLinkTypeChatFolderInvite::fetch(env, p);
    case internalLinkTypeChatFolderSettings::ID:
      return internalLinkTypeChatFolderSettings::fetch(env, p);
    case internalLinkTypeChatInvite::ID:
      return internalLinkTypeChatInvite::fetch(env, p);
    case internalLinkTypeDefaultMessageAutoDeleteTimerSettings::ID:
      return internalLinkTypeDefaultMessageAutoDeleteTimerSettings::fetch(env, p);
    case internalLinkTypeEditProfileSettings::ID:
      return internalLinkTypeEditProfileSettings::fetch(env, p);
    case internalLinkTypeGame::ID:
      return internalLinkTypeGame::fetch(env, p);
    case internalLinkTypeGroupCall::ID:
      return internalLinkTypeGroupCall::fetch(env, p);
    case internalLinkTypeInstantView::ID:
      return internalLinkTypeInstantView::fetch(env, p);
    case internalLinkTypeInvoice::ID:
      return internalLinkTypeInvoice::fetch(env, p);
    case internalLinkTypeLanguagePack::ID:
      return internalLinkTypeLanguagePack::fetch(env, p);
    case internalLinkTypeLanguageSettings::ID:
      return internalLinkTypeLanguageSettings::fetch(env, p);
    case internalLinkTypeMainWebApp::ID:
      return internalLinkTypeMainWebApp::fetch(env, p);
    case internalLinkTypeMessage::ID:
      return internalLinkTypeMessage::fetch(env, p);
    case internalLinkTypeMessageDraft::ID:
      return internalLinkTypeMessageDraft::fetch(env, p);
    case internalLinkTypeMyStars::ID:
      return internalLinkTypeMyStars::fetch(env, p);
    case internalLinkTypeMyToncoins::ID:
      return internalLinkTypeMyToncoins::fetch(env, p);
    case internalLinkTypePassportDataRequest::ID:
      return internalLinkTypePassportDataRequest::fetch(env, p);
    case internalLinkTypePhoneNumberConfirmation::ID:
      return internalLinkTypePhoneNumberConfirmation::fetch(env, p);
    case internalLinkTypePremiumFeatures::ID:
      return internalLinkTypePremiumFeatures::fetch(env, p);
    case internalLinkTypePremiumGift::ID:
      return internalLinkTypePremiumGift::fetch(env, p);
    case internalLinkTypePremiumGiftCode::ID:
      return internalLinkTypePremiumGiftCode::fetch(env, p);
    case internalLinkTypePrivacyAndSecuritySettings::ID:
      return internalLinkTypePrivacyAndSecuritySettings::fetch(env, p);
    case internalLinkTypeProxy::ID:
      return internalLinkTypeProxy::fetch(env, p);
    case internalLinkTypePublicChat::ID:
      return internalLinkTypePublicChat::fetch(env, p);
    case internalLinkTypeQrCodeAuthentication::ID:
      return internalLinkTypeQrCodeAuthentication::fetch(env, p);
    case internalLinkTypeRestorePurchases::ID:
      return internalLinkTypeRestorePurchases::fetch(env, p);
    case internalLinkTypeSettings::ID:
      return internalLinkTypeSettings::fetch(env, p);
    case internalLinkTypeStickerSet::ID:
      return internalLinkTypeStickerSet::fetch(env, p);
    case internalLinkTypeStory::ID:
      return internalLinkTypeStory::fetch(env, p);
    case internalLinkTypeTheme::ID:
      return internalLinkTypeTheme::fetch(env, p);
    case internalLinkTypeThemeSettings::ID:
      return internalLinkTypeThemeSettings::fetch(env, p);
    case internalLinkTypeUnknownDeepLink::ID:
      return internalLinkTypeUnknownDeepLink::fetch(env, p);
    case internalLinkTypeUnsupportedProxy::ID:
      return internalLinkTypeUnsupportedProxy::fetch(env, p);
    case internalLinkTypeUpgradedGift::ID:
      return internalLinkTypeUpgradedGift::fetch(env, p);
    case internalLinkTypeUserPhoneNumber::ID:
      return internalLinkTypeUserPhoneNumber::fetch(env, p);
    case internalLinkTypeUserToken::ID:
      return internalLinkTypeUserToken::fetch(env, p);
    case internalLinkTypeVideoChat::ID:
      return internalLinkTypeVideoChat::fetch(env, p);
    case internalLinkTypeWebApp::ID:
      return internalLinkTypeWebApp::fetch(env, p);
    case inviteGroupCallParticipantResultUserPrivacyRestricted::ID:
      return inviteGroupCallParticipantResultUserPrivacyRestricted::fetch(env, p);
    case inviteGroupCallParticipantResultUserAlreadyParticipant::ID:
      return inviteGroupCallParticipantResultUserAlreadyParticipant::fetch(env, p);
    case inviteGroupCallParticipantResultUserWasBanned::ID:
      return inviteGroupCallParticipantResultUserWasBanned::fetch(env, p);
    case inviteGroupCallParticipantResultSuccess::ID:
      return inviteGroupCallParticipantResultSuccess::fetch(env, p);
    case inviteLinkChatTypeBasicGroup::ID:
      return inviteLinkChatTypeBasicGroup::fetch(env, p);
    case inviteLinkChatTypeSupergroup::ID:
      return inviteLinkChatTypeSupergroup::fetch(env, p);
    case inviteLinkChatTypeChannel::ID:
      return inviteLinkChatTypeChannel::fetch(env, p);
    case invoice::ID:
      return invoice::fetch(env, p);
    case jsonObjectMember::ID:
      return jsonObjectMember::fetch(env, p);
    case jsonValueNull::ID:
      return jsonValueNull::fetch(env, p);
    case jsonValueBoolean::ID:
      return jsonValueBoolean::fetch(env, p);
    case jsonValueNumber::ID:
      return jsonValueNumber::fetch(env, p);
    case jsonValueString::ID:
      return jsonValueString::fetch(env, p);
    case jsonValueArray::ID:
      return jsonValueArray::fetch(env, p);
    case jsonValueObject::ID:
      return jsonValueObject::fetch(env, p);
    case keyboardButton::ID:
      return keyboardButton::fetch(env, p);
    case keyboardButtonTypeText::ID:
      return keyboardButtonTypeText::fetch(env, p);
    case keyboardButtonTypeRequestPhoneNumber::ID:
      return keyboardButtonTypeRequestPhoneNumber::fetch(env, p);
    case keyboardButtonTypeRequestLocation::ID:
      return keyboardButtonTypeRequestLocation::fetch(env, p);
    case keyboardButtonTypeRequestPoll::ID:
      return keyboardButtonTypeRequestPoll::fetch(env, p);
    case keyboardButtonTypeRequestUsers::ID:
      return keyboardButtonTypeRequestUsers::fetch(env, p);
    case keyboardButtonTypeRequestChat::ID:
      return keyboardButtonTypeRequestChat::fetch(env, p);
    case keyboardButtonTypeWebApp::ID:
      return keyboardButtonTypeWebApp::fetch(env, p);
    case labeledPricePart::ID:
      return labeledPricePart::fetch(env, p);
    case languagePackInfo::ID:
      return languagePackInfo::fetch(env, p);
    case languagePackString::ID:
      return languagePackString::fetch(env, p);
    case languagePackStringValueOrdinary::ID:
      return languagePackStringValueOrdinary::fetch(env, p);
    case languagePackStringValuePluralized::ID:
      return languagePackStringValuePluralized::fetch(env, p);
    case languagePackStringValueDeleted::ID:
      return languagePackStringValueDeleted::fetch(env, p);
    case languagePackStrings::ID:
      return languagePackStrings::fetch(env, p);
    case linkPreview::ID:
      return linkPreview::fetch(env, p);
    case linkPreviewAlbumMediaPhoto::ID:
      return linkPreviewAlbumMediaPhoto::fetch(env, p);
    case linkPreviewAlbumMediaVideo::ID:
      return linkPreviewAlbumMediaVideo::fetch(env, p);
    case linkPreviewOptions::ID:
      return linkPreviewOptions::fetch(env, p);
    case linkPreviewTypeAlbum::ID:
      return linkPreviewTypeAlbum::fetch(env, p);
    case linkPreviewTypeAnimation::ID:
      return linkPreviewTypeAnimation::fetch(env, p);
    case linkPreviewTypeApp::ID:
      return linkPreviewTypeApp::fetch(env, p);
    case linkPreviewTypeArticle::ID:
      return linkPreviewTypeArticle::fetch(env, p);
    case linkPreviewTypeAudio::ID:
      return linkPreviewTypeAudio::fetch(env, p);
    case linkPreviewTypeBackground::ID:
      return linkPreviewTypeBackground::fetch(env, p);
    case linkPreviewTypeChannelBoost::ID:
      return linkPreviewTypeChannelBoost::fetch(env, p);
    case linkPreviewTypeChat::ID:
      return linkPreviewTypeChat::fetch(env, p);
    case linkPreviewTypeDocument::ID:
      return linkPreviewTypeDocument::fetch(env, p);
    case linkPreviewTypeEmbeddedAnimationPlayer::ID:
      return linkPreviewTypeEmbeddedAnimationPlayer::fetch(env, p);
    case linkPreviewTypeEmbeddedAudioPlayer::ID:
      return linkPreviewTypeEmbeddedAudioPlayer::fetch(env, p);
    case linkPreviewTypeEmbeddedVideoPlayer::ID:
      return linkPreviewTypeEmbeddedVideoPlayer::fetch(env, p);
    case linkPreviewTypeExternalAudio::ID:
      return linkPreviewTypeExternalAudio::fetch(env, p);
    case linkPreviewTypeExternalVideo::ID:
      return linkPreviewTypeExternalVideo::fetch(env, p);
    case linkPreviewTypeGroupCall::ID:
      return linkPreviewTypeGroupCall::fetch(env, p);
    case linkPreviewTypeInvoice::ID:
      return linkPreviewTypeInvoice::fetch(env, p);
    case linkPreviewTypeMessage::ID:
      return linkPreviewTypeMessage::fetch(env, p);
    case linkPreviewTypePhoto::ID:
      return linkPreviewTypePhoto::fetch(env, p);
    case linkPreviewTypePremiumGiftCode::ID:
      return linkPreviewTypePremiumGiftCode::fetch(env, p);
    case linkPreviewTypeShareableChatFolder::ID:
      return linkPreviewTypeShareableChatFolder::fetch(env, p);
    case linkPreviewTypeSticker::ID:
      return linkPreviewTypeSticker::fetch(env, p);
    case linkPreviewTypeStickerSet::ID:
      return linkPreviewTypeStickerSet::fetch(env, p);
    case linkPreviewTypeStory::ID:
      return linkPreviewTypeStory::fetch(env, p);
    case linkPreviewTypeSupergroupBoost::ID:
      return linkPreviewTypeSupergroupBoost::fetch(env, p);
    case linkPreviewTypeTheme::ID:
      return linkPreviewTypeTheme::fetch(env, p);
    case linkPreviewTypeUnsupported::ID:
      return linkPreviewTypeUnsupported::fetch(env, p);
    case linkPreviewTypeUpgradedGift::ID:
      return linkPreviewTypeUpgradedGift::fetch(env, p);
    case linkPreviewTypeUser::ID:
      return linkPreviewTypeUser::fetch(env, p);
    case linkPreviewTypeVideo::ID:
      return linkPreviewTypeVideo::fetch(env, p);
    case linkPreviewTypeVideoChat::ID:
      return linkPreviewTypeVideoChat::fetch(env, p);
    case linkPreviewTypeVideoNote::ID:
      return linkPreviewTypeVideoNote::fetch(env, p);
    case linkPreviewTypeVoiceNote::ID:
      return linkPreviewTypeVoiceNote::fetch(env, p);
    case linkPreviewTypeWebApp::ID:
      return linkPreviewTypeWebApp::fetch(env, p);
    case localFile::ID:
      return localFile::fetch(env, p);
    case localizationTargetInfo::ID:
      return localizationTargetInfo::fetch(env, p);
    case location::ID:
      return location::fetch(env, p);
    case locationAddress::ID:
      return locationAddress::fetch(env, p);
    case logStreamDefault::ID:
      return logStreamDefault::fetch(env, p);
    case logStreamFile::ID:
      return logStreamFile::fetch(env, p);
    case logStreamEmpty::ID:
      return logStreamEmpty::fetch(env, p);
    case logTags::ID:
      return logTags::fetch(env, p);
    case logVerbosityLevel::ID:
      return logVerbosityLevel::fetch(env, p);
    case loginUrlInfoOpen::ID:
      return loginUrlInfoOpen::fetch(env, p);
    case loginUrlInfoRequestConfirmation::ID:
      return loginUrlInfoRequestConfirmation::fetch(env, p);
    case mainWebApp::ID:
      return mainWebApp::fetch(env, p);
    case maskPointForehead::ID:
      return maskPointForehead::fetch(env, p);
    case maskPointEyes::ID:
      return maskPointEyes::fetch(env, p);
    case maskPointMouth::ID:
      return maskPointMouth::fetch(env, p);
    case maskPointChin::ID:
      return maskPointChin::fetch(env, p);
    case maskPosition::ID:
      return maskPosition::fetch(env, p);
    case message::ID:
      return message::fetch(env, p);
    case messageAutoDeleteTime::ID:
      return messageAutoDeleteTime::fetch(env, p);
    case messageCalendar::ID:
      return messageCalendar::fetch(env, p);
    case messageCalendarDay::ID:
      return messageCalendarDay::fetch(env, p);
    case messageText::ID:
      return messageText::fetch(env, p);
    case messageAnimation::ID:
      return messageAnimation::fetch(env, p);
    case messageAudio::ID:
      return messageAudio::fetch(env, p);
    case messageDocument::ID:
      return messageDocument::fetch(env, p);
    case messagePaidMedia::ID:
      return messagePaidMedia::fetch(env, p);
    case messagePhoto::ID:
      return messagePhoto::fetch(env, p);
    case messageSticker::ID:
      return messageSticker::fetch(env, p);
    case messageVideo::ID:
      return messageVideo::fetch(env, p);
    case messageVideoNote::ID:
      return messageVideoNote::fetch(env, p);
    case messageVoiceNote::ID:
      return messageVoiceNote::fetch(env, p);
    case messageExpiredPhoto::ID:
      return messageExpiredPhoto::fetch(env, p);
    case messageExpiredVideo::ID:
      return messageExpiredVideo::fetch(env, p);
    case messageExpiredVideoNote::ID:
      return messageExpiredVideoNote::fetch(env, p);
    case messageExpiredVoiceNote::ID:
      return messageExpiredVoiceNote::fetch(env, p);
    case messageLocation::ID:
      return messageLocation::fetch(env, p);
    case messageVenue::ID:
      return messageVenue::fetch(env, p);
    case messageContact::ID:
      return messageContact::fetch(env, p);
    case messageAnimatedEmoji::ID:
      return messageAnimatedEmoji::fetch(env, p);
    case messageDice::ID:
      return messageDice::fetch(env, p);
    case messageGame::ID:
      return messageGame::fetch(env, p);
    case messagePoll::ID:
      return messagePoll::fetch(env, p);
    case messageStory::ID:
      return messageStory::fetch(env, p);
    case messageChecklist::ID:
      return messageChecklist::fetch(env, p);
    case messageInvoice::ID:
      return messageInvoice::fetch(env, p);
    case messageCall::ID:
      return messageCall::fetch(env, p);
    case messageGroupCall::ID:
      return messageGroupCall::fetch(env, p);
    case messageVideoChatScheduled::ID:
      return messageVideoChatScheduled::fetch(env, p);
    case messageVideoChatStarted::ID:
      return messageVideoChatStarted::fetch(env, p);
    case messageVideoChatEnded::ID:
      return messageVideoChatEnded::fetch(env, p);
    case messageInviteVideoChatParticipants::ID:
      return messageInviteVideoChatParticipants::fetch(env, p);
    case messageBasicGroupChatCreate::ID:
      return messageBasicGroupChatCreate::fetch(env, p);
    case messageSupergroupChatCreate::ID:
      return messageSupergroupChatCreate::fetch(env, p);
    case messageChatChangeTitle::ID:
      return messageChatChangeTitle::fetch(env, p);
    case messageChatChangePhoto::ID:
      return messageChatChangePhoto::fetch(env, p);
    case messageChatDeletePhoto::ID:
      return messageChatDeletePhoto::fetch(env, p);
    case messageChatAddMembers::ID:
      return messageChatAddMembers::fetch(env, p);
    case messageChatJoinByLink::ID:
      return messageChatJoinByLink::fetch(env, p);
    case messageChatJoinByRequest::ID:
      return messageChatJoinByRequest::fetch(env, p);
    case messageChatDeleteMember::ID:
      return messageChatDeleteMember::fetch(env, p);
    case messageChatUpgradeTo::ID:
      return messageChatUpgradeTo::fetch(env, p);
    case messageChatUpgradeFrom::ID:
      return messageChatUpgradeFrom::fetch(env, p);
    case messagePinMessage::ID:
      return messagePinMessage::fetch(env, p);
    case messageScreenshotTaken::ID:
      return messageScreenshotTaken::fetch(env, p);
    case messageChatSetBackground::ID:
      return messageChatSetBackground::fetch(env, p);
    case messageChatSetTheme::ID:
      return messageChatSetTheme::fetch(env, p);
    case messageChatSetMessageAutoDeleteTime::ID:
      return messageChatSetMessageAutoDeleteTime::fetch(env, p);
    case messageChatBoost::ID:
      return messageChatBoost::fetch(env, p);
    case messageForumTopicCreated::ID:
      return messageForumTopicCreated::fetch(env, p);
    case messageForumTopicEdited::ID:
      return messageForumTopicEdited::fetch(env, p);
    case messageForumTopicIsClosedToggled::ID:
      return messageForumTopicIsClosedToggled::fetch(env, p);
    case messageForumTopicIsHiddenToggled::ID:
      return messageForumTopicIsHiddenToggled::fetch(env, p);
    case messageSuggestProfilePhoto::ID:
      return messageSuggestProfilePhoto::fetch(env, p);
    case messageCustomServiceAction::ID:
      return messageCustomServiceAction::fetch(env, p);
    case messageGameScore::ID:
      return messageGameScore::fetch(env, p);
    case messagePaymentSuccessful::ID:
      return messagePaymentSuccessful::fetch(env, p);
    case messagePaymentSuccessfulBot::ID:
      return messagePaymentSuccessfulBot::fetch(env, p);
    case messagePaymentRefunded::ID:
      return messagePaymentRefunded::fetch(env, p);
    case messageGiftedPremium::ID:
      return messageGiftedPremium::fetch(env, p);
    case messagePremiumGiftCode::ID:
      return messagePremiumGiftCode::fetch(env, p);
    case messageGiveawayCreated::ID:
      return messageGiveawayCreated::fetch(env, p);
    case messageGiveaway::ID:
      return messageGiveaway::fetch(env, p);
    case messageGiveawayCompleted::ID:
      return messageGiveawayCompleted::fetch(env, p);
    case messageGiveawayWinners::ID:
      return messageGiveawayWinners::fetch(env, p);
    case messageGiftedStars::ID:
      return messageGiftedStars::fetch(env, p);
    case messageGiftedTon::ID:
      return messageGiftedTon::fetch(env, p);
    case messageGiveawayPrizeStars::ID:
      return messageGiveawayPrizeStars::fetch(env, p);
    case messageGift::ID:
      return messageGift::fetch(env, p);
    case messageUpgradedGift::ID:
      return messageUpgradedGift::fetch(env, p);
    case messageRefundedUpgradedGift::ID:
      return messageRefundedUpgradedGift::fetch(env, p);
    case messagePaidMessagesRefunded::ID:
      return messagePaidMessagesRefunded::fetch(env, p);
    case messagePaidMessagePriceChanged::ID:
      return messagePaidMessagePriceChanged::fetch(env, p);
    case messageDirectMessagePriceChanged::ID:
      return messageDirectMessagePriceChanged::fetch(env, p);
    case messageChecklistTasksDone::ID:
      return messageChecklistTasksDone::fetch(env, p);
    case messageChecklistTasksAdded::ID:
      return messageChecklistTasksAdded::fetch(env, p);
    case messageSuggestedPostApprovalFailed::ID:
      return messageSuggestedPostApprovalFailed::fetch(env, p);
    case messageSuggestedPostApproved::ID:
      return messageSuggestedPostApproved::fetch(env, p);
    case messageSuggestedPostDeclined::ID:
      return messageSuggestedPostDeclined::fetch(env, p);
    case messageSuggestedPostPaid::ID:
      return messageSuggestedPostPaid::fetch(env, p);
    case messageSuggestedPostRefunded::ID:
      return messageSuggestedPostRefunded::fetch(env, p);
    case messageContactRegistered::ID:
      return messageContactRegistered::fetch(env, p);
    case messageUsersShared::ID:
      return messageUsersShared::fetch(env, p);
    case messageChatShared::ID:
      return messageChatShared::fetch(env, p);
    case messageBotWriteAccessAllowed::ID:
      return messageBotWriteAccessAllowed::fetch(env, p);
    case messageWebAppDataSent::ID:
      return messageWebAppDataSent::fetch(env, p);
    case messageWebAppDataReceived::ID:
      return messageWebAppDataReceived::fetch(env, p);
    case messagePassportDataSent::ID:
      return messagePassportDataSent::fetch(env, p);
    case messagePassportDataReceived::ID:
      return messagePassportDataReceived::fetch(env, p);
    case messageProximityAlertTriggered::ID:
      return messageProximityAlertTriggered::fetch(env, p);
    case messageUnsupported::ID:
      return messageUnsupported::fetch(env, p);
    case messageCopyOptions::ID:
      return messageCopyOptions::fetch(env, p);
    case messageEffect::ID:
      return messageEffect::fetch(env, p);
    case messageEffectTypeEmojiReaction::ID:
      return messageEffectTypeEmojiReaction::fetch(env, p);
    case messageEffectTypePremiumSticker::ID:
      return messageEffectTypePremiumSticker::fetch(env, p);
    case messageFileTypePrivate::ID:
      return messageFileTypePrivate::fetch(env, p);
    case messageFileTypeGroup::ID:
      return messageFileTypeGroup::fetch(env, p);
    case messageFileTypeUnknown::ID:
      return messageFileTypeUnknown::fetch(env, p);
    case messageForwardInfo::ID:
      return messageForwardInfo::fetch(env, p);
    case messageImportInfo::ID:
      return messageImportInfo::fetch(env, p);
    case messageInteractionInfo::ID:
      return messageInteractionInfo::fetch(env, p);
    case messageLink::ID:
      return messageLink::fetch(env, p);
    case messageLinkInfo::ID:
      return messageLinkInfo::fetch(env, p);
    case messageOriginUser::ID:
      return messageOriginUser::fetch(env, p);
    case messageOriginHiddenUser::ID:
      return messageOriginHiddenUser::fetch(env, p);
    case messageOriginChat::ID:
      return messageOriginChat::fetch(env, p);
    case messageOriginChannel::ID:
      return messageOriginChannel::fetch(env, p);
    case messagePosition::ID:
      return messagePosition::fetch(env, p);
    case messagePositions::ID:
      return messagePositions::fetch(env, p);
    case messageProperties::ID:
      return messageProperties::fetch(env, p);
    case messageReaction::ID:
      return messageReaction::fetch(env, p);
    case messageReactions::ID:
      return messageReactions::fetch(env, p);
    case messageReadDateRead::ID:
      return messageReadDateRead::fetch(env, p);
    case messageReadDateUnread::ID:
      return messageReadDateUnread::fetch(env, p);
    case messageReadDateTooOld::ID:
      return messageReadDateTooOld::fetch(env, p);
    case messageReadDateUserPrivacyRestricted::ID:
      return messageReadDateUserPrivacyRestricted::fetch(env, p);
    case messageReadDateMyPrivacyRestricted::ID:
      return messageReadDateMyPrivacyRestricted::fetch(env, p);
    case messageReplyInfo::ID:
      return messageReplyInfo::fetch(env, p);
    case messageReplyToMessage::ID:
      return messageReplyToMessage::fetch(env, p);
    case messageReplyToStory::ID:
      return messageReplyToStory::fetch(env, p);
    case messageSchedulingStateSendAtDate::ID:
      return messageSchedulingStateSendAtDate::fetch(env, p);
    case messageSchedulingStateSendWhenOnline::ID:
      return messageSchedulingStateSendWhenOnline::fetch(env, p);
    case messageSchedulingStateSendWhenVideoProcessed::ID:
      return messageSchedulingStateSendWhenVideoProcessed::fetch(env, p);
    case messageSelfDestructTypeTimer::ID:
      return messageSelfDestructTypeTimer::fetch(env, p);
    case messageSelfDestructTypeImmediately::ID:
      return messageSelfDestructTypeImmediately::fetch(env, p);
    case messageSendOptions::ID:
      return messageSendOptions::fetch(env, p);
    case messageSenderUser::ID:
      return messageSenderUser::fetch(env, p);
    case messageSenderChat::ID:
      return messageSenderChat::fetch(env, p);
    case messageSenders::ID:
      return messageSenders::fetch(env, p);
    case messageSendingStatePending::ID:
      return messageSendingStatePending::fetch(env, p);
    case messageSendingStateFailed::ID:
      return messageSendingStateFailed::fetch(env, p);
    case messageSourceChatHistory::ID:
      return messageSourceChatHistory::fetch(env, p);
    case messageSourceMessageThreadHistory::ID:
      return messageSourceMessageThreadHistory::fetch(env, p);
    case messageSourceForumTopicHistory::ID:
      return messageSourceForumTopicHistory::fetch(env, p);
    case messageSourceDirectMessagesChatTopicHistory::ID:
      return messageSourceDirectMessagesChatTopicHistory::fetch(env, p);
    case messageSourceHistoryPreview::ID:
      return messageSourceHistoryPreview::fetch(env, p);
    case messageSourceChatList::ID:
      return messageSourceChatList::fetch(env, p);
    case messageSourceSearch::ID:
      return messageSourceSearch::fetch(env, p);
    case messageSourceChatEventLog::ID:
      return messageSourceChatEventLog::fetch(env, p);
    case messageSourceNotification::ID:
      return messageSourceNotification::fetch(env, p);
    case messageSourceScreenshot::ID:
      return messageSourceScreenshot::fetch(env, p);
    case messageSourceOther::ID:
      return messageSourceOther::fetch(env, p);
    case messageStatistics::ID:
      return messageStatistics::fetch(env, p);
    case messageThreadInfo::ID:
      return messageThreadInfo::fetch(env, p);
    case messageTopicForum::ID:
      return messageTopicForum::fetch(env, p);
    case messageTopicDirectMessages::ID:
      return messageTopicDirectMessages::fetch(env, p);
    case messageTopicSavedMessages::ID:
      return messageTopicSavedMessages::fetch(env, p);
    case messageViewer::ID:
      return messageViewer::fetch(env, p);
    case messageViewers::ID:
      return messageViewers::fetch(env, p);
    case messages::ID:
      return messages::fetch(env, p);
    case minithumbnail::ID:
      return minithumbnail::fetch(env, p);
    case networkStatistics::ID:
      return networkStatistics::fetch(env, p);
    case networkStatisticsEntryFile::ID:
      return networkStatisticsEntryFile::fetch(env, p);
    case networkStatisticsEntryCall::ID:
      return networkStatisticsEntryCall::fetch(env, p);
    case networkTypeNone::ID:
      return networkTypeNone::fetch(env, p);
    case networkTypeMobile::ID:
      return networkTypeMobile::fetch(env, p);
    case networkTypeMobileRoaming::ID:
      return networkTypeMobileRoaming::fetch(env, p);
    case networkTypeWiFi::ID:
      return networkTypeWiFi::fetch(env, p);
    case networkTypeOther::ID:
      return networkTypeOther::fetch(env, p);
    case newChatPrivacySettings::ID:
      return newChatPrivacySettings::fetch(env, p);
    case notification::ID:
      return notification::fetch(env, p);
    case notificationGroup::ID:
      return notificationGroup::fetch(env, p);
    case notificationGroupTypeMessages::ID:
      return notificationGroupTypeMessages::fetch(env, p);
    case notificationGroupTypeMentions::ID:
      return notificationGroupTypeMentions::fetch(env, p);
    case notificationGroupTypeSecretChat::ID:
      return notificationGroupTypeSecretChat::fetch(env, p);
    case notificationGroupTypeCalls::ID:
      return notificationGroupTypeCalls::fetch(env, p);
    case notificationSettingsScopePrivateChats::ID:
      return notificationSettingsScopePrivateChats::fetch(env, p);
    case notificationSettingsScopeGroupChats::ID:
      return notificationSettingsScopeGroupChats::fetch(env, p);
    case notificationSettingsScopeChannelChats::ID:
      return notificationSettingsScopeChannelChats::fetch(env, p);
    case notificationSound::ID:
      return notificationSound::fetch(env, p);
    case notificationSounds::ID:
      return notificationSounds::fetch(env, p);
    case notificationTypeNewMessage::ID:
      return notificationTypeNewMessage::fetch(env, p);
    case notificationTypeNewSecretChat::ID:
      return notificationTypeNewSecretChat::fetch(env, p);
    case notificationTypeNewCall::ID:
      return notificationTypeNewCall::fetch(env, p);
    case notificationTypeNewPushMessage::ID:
      return notificationTypeNewPushMessage::fetch(env, p);
    case ok::ID:
      return ok::fetch(env, p);
    case optionValueBoolean::ID:
      return optionValueBoolean::fetch(env, p);
    case optionValueEmpty::ID:
      return optionValueEmpty::fetch(env, p);
    case optionValueInteger::ID:
      return optionValueInteger::fetch(env, p);
    case optionValueString::ID:
      return optionValueString::fetch(env, p);
    case orderInfo::ID:
      return orderInfo::fetch(env, p);
    case outline::ID:
      return outline::fetch(env, p);
    case pageBlockTitle::ID:
      return pageBlockTitle::fetch(env, p);
    case pageBlockSubtitle::ID:
      return pageBlockSubtitle::fetch(env, p);
    case pageBlockAuthorDate::ID:
      return pageBlockAuthorDate::fetch(env, p);
    case pageBlockHeader::ID:
      return pageBlockHeader::fetch(env, p);
    case pageBlockSubheader::ID:
      return pageBlockSubheader::fetch(env, p);
    case pageBlockKicker::ID:
      return pageBlockKicker::fetch(env, p);
    case pageBlockParagraph::ID:
      return pageBlockParagraph::fetch(env, p);
    case pageBlockPreformatted::ID:
      return pageBlockPreformatted::fetch(env, p);
    case pageBlockFooter::ID:
      return pageBlockFooter::fetch(env, p);
    case pageBlockDivider::ID:
      return pageBlockDivider::fetch(env, p);
    case pageBlockAnchor::ID:
      return pageBlockAnchor::fetch(env, p);
    case pageBlockList::ID:
      return pageBlockList::fetch(env, p);
    case pageBlockBlockQuote::ID:
      return pageBlockBlockQuote::fetch(env, p);
    case pageBlockPullQuote::ID:
      return pageBlockPullQuote::fetch(env, p);
    case pageBlockAnimation::ID:
      return pageBlockAnimation::fetch(env, p);
    case pageBlockAudio::ID:
      return pageBlockAudio::fetch(env, p);
    case pageBlockPhoto::ID:
      return pageBlockPhoto::fetch(env, p);
    case pageBlockVideo::ID:
      return pageBlockVideo::fetch(env, p);
    case pageBlockVoiceNote::ID:
      return pageBlockVoiceNote::fetch(env, p);
    case pageBlockCover::ID:
      return pageBlockCover::fetch(env, p);
    case pageBlockEmbedded::ID:
      return pageBlockEmbedded::fetch(env, p);
    case pageBlockEmbeddedPost::ID:
      return pageBlockEmbeddedPost::fetch(env, p);
    case pageBlockCollage::ID:
      return pageBlockCollage::fetch(env, p);
    case pageBlockSlideshow::ID:
      return pageBlockSlideshow::fetch(env, p);
    case pageBlockChatLink::ID:
      return pageBlockChatLink::fetch(env, p);
    case pageBlockTable::ID:
      return pageBlockTable::fetch(env, p);
    case pageBlockDetails::ID:
      return pageBlockDetails::fetch(env, p);
    case pageBlockRelatedArticles::ID:
      return pageBlockRelatedArticles::fetch(env, p);
    case pageBlockMap::ID:
      return pageBlockMap::fetch(env, p);
    case pageBlockCaption::ID:
      return pageBlockCaption::fetch(env, p);
    case pageBlockHorizontalAlignmentLeft::ID:
      return pageBlockHorizontalAlignmentLeft::fetch(env, p);
    case pageBlockHorizontalAlignmentCenter::ID:
      return pageBlockHorizontalAlignmentCenter::fetch(env, p);
    case pageBlockHorizontalAlignmentRight::ID:
      return pageBlockHorizontalAlignmentRight::fetch(env, p);
    case pageBlockListItem::ID:
      return pageBlockListItem::fetch(env, p);
    case pageBlockRelatedArticle::ID:
      return pageBlockRelatedArticle::fetch(env, p);
    case pageBlockTableCell::ID:
      return pageBlockTableCell::fetch(env, p);
    case pageBlockVerticalAlignmentTop::ID:
      return pageBlockVerticalAlignmentTop::fetch(env, p);
    case pageBlockVerticalAlignmentMiddle::ID:
      return pageBlockVerticalAlignmentMiddle::fetch(env, p);
    case pageBlockVerticalAlignmentBottom::ID:
      return pageBlockVerticalAlignmentBottom::fetch(env, p);
    case paidMediaPreview::ID:
      return paidMediaPreview::fetch(env, p);
    case paidMediaPhoto::ID:
      return paidMediaPhoto::fetch(env, p);
    case paidMediaVideo::ID:
      return paidMediaVideo::fetch(env, p);
    case paidMediaUnsupported::ID:
      return paidMediaUnsupported::fetch(env, p);
    case paidReactionTypeRegular::ID:
      return paidReactionTypeRegular::fetch(env, p);
    case paidReactionTypeAnonymous::ID:
      return paidReactionTypeAnonymous::fetch(env, p);
    case paidReactionTypeChat::ID:
      return paidReactionTypeChat::fetch(env, p);
    case paidReactor::ID:
      return paidReactor::fetch(env, p);
    case passportAuthorizationForm::ID:
      return passportAuthorizationForm::fetch(env, p);
    case passportElementPersonalDetails::ID:
      return passportElementPersonalDetails::fetch(env, p);
    case passportElementPassport::ID:
      return passportElementPassport::fetch(env, p);
    case passportElementDriverLicense::ID:
      return passportElementDriverLicense::fetch(env, p);
    case passportElementIdentityCard::ID:
      return passportElementIdentityCard::fetch(env, p);
    case passportElementInternalPassport::ID:
      return passportElementInternalPassport::fetch(env, p);
    case passportElementAddress::ID:
      return passportElementAddress::fetch(env, p);
    case passportElementUtilityBill::ID:
      return passportElementUtilityBill::fetch(env, p);
    case passportElementBankStatement::ID:
      return passportElementBankStatement::fetch(env, p);
    case passportElementRentalAgreement::ID:
      return passportElementRentalAgreement::fetch(env, p);
    case passportElementPassportRegistration::ID:
      return passportElementPassportRegistration::fetch(env, p);
    case passportElementTemporaryRegistration::ID:
      return passportElementTemporaryRegistration::fetch(env, p);
    case passportElementPhoneNumber::ID:
      return passportElementPhoneNumber::fetch(env, p);
    case passportElementEmailAddress::ID:
      return passportElementEmailAddress::fetch(env, p);
    case passportElementError::ID:
      return passportElementError::fetch(env, p);
    case passportElementErrorSourceUnspecified::ID:
      return passportElementErrorSourceUnspecified::fetch(env, p);
    case passportElementErrorSourceDataField::ID:
      return passportElementErrorSourceDataField::fetch(env, p);
    case passportElementErrorSourceFrontSide::ID:
      return passportElementErrorSourceFrontSide::fetch(env, p);
    case passportElementErrorSourceReverseSide::ID:
      return passportElementErrorSourceReverseSide::fetch(env, p);
    case passportElementErrorSourceSelfie::ID:
      return passportElementErrorSourceSelfie::fetch(env, p);
    case passportElementErrorSourceTranslationFile::ID:
      return passportElementErrorSourceTranslationFile::fetch(env, p);
    case passportElementErrorSourceTranslationFiles::ID:
      return passportElementErrorSourceTranslationFiles::fetch(env, p);
    case passportElementErrorSourceFile::ID:
      return passportElementErrorSourceFile::fetch(env, p);
    case passportElementErrorSourceFiles::ID:
      return passportElementErrorSourceFiles::fetch(env, p);
    case passportElementTypePersonalDetails::ID:
      return passportElementTypePersonalDetails::fetch(env, p);
    case passportElementTypePassport::ID:
      return passportElementTypePassport::fetch(env, p);
    case passportElementTypeDriverLicense::ID:
      return passportElementTypeDriverLicense::fetch(env, p);
    case passportElementTypeIdentityCard::ID:
      return passportElementTypeIdentityCard::fetch(env, p);
    case passportElementTypeInternalPassport::ID:
      return passportElementTypeInternalPassport::fetch(env, p);
    case passportElementTypeAddress::ID:
      return passportElementTypeAddress::fetch(env, p);
    case passportElementTypeUtilityBill::ID:
      return passportElementTypeUtilityBill::fetch(env, p);
    case passportElementTypeBankStatement::ID:
      return passportElementTypeBankStatement::fetch(env, p);
    case passportElementTypeRentalAgreement::ID:
      return passportElementTypeRentalAgreement::fetch(env, p);
    case passportElementTypePassportRegistration::ID:
      return passportElementTypePassportRegistration::fetch(env, p);
    case passportElementTypeTemporaryRegistration::ID:
      return passportElementTypeTemporaryRegistration::fetch(env, p);
    case passportElementTypePhoneNumber::ID:
      return passportElementTypePhoneNumber::fetch(env, p);
    case passportElementTypeEmailAddress::ID:
      return passportElementTypeEmailAddress::fetch(env, p);
    case passportElements::ID:
      return passportElements::fetch(env, p);
    case passportElementsWithErrors::ID:
      return passportElementsWithErrors::fetch(env, p);
    case passportRequiredElement::ID:
      return passportRequiredElement::fetch(env, p);
    case passportSuitableElement::ID:
      return passportSuitableElement::fetch(env, p);
    case passwordState::ID:
      return passwordState::fetch(env, p);
    case paymentForm::ID:
      return paymentForm::fetch(env, p);
    case paymentFormTypeRegular::ID:
      return paymentFormTypeRegular::fetch(env, p);
    case paymentFormTypeStars::ID:
      return paymentFormTypeStars::fetch(env, p);
    case paymentFormTypeStarSubscription::ID:
      return paymentFormTypeStarSubscription::fetch(env, p);
    case paymentOption::ID:
      return paymentOption::fetch(env, p);
    case paymentProviderSmartGlocal::ID:
      return paymentProviderSmartGlocal::fetch(env, p);
    case paymentProviderStripe::ID:
      return paymentProviderStripe::fetch(env, p);
    case paymentProviderOther::ID:
      return paymentProviderOther::fetch(env, p);
    case paymentReceipt::ID:
      return paymentReceipt::fetch(env, p);
    case paymentReceiptTypeRegular::ID:
      return paymentReceiptTypeRegular::fetch(env, p);
    case paymentReceiptTypeStars::ID:
      return paymentReceiptTypeStars::fetch(env, p);
    case paymentResult::ID:
      return paymentResult::fetch(env, p);
    case personalDetails::ID:
      return personalDetails::fetch(env, p);
    case personalDocument::ID:
      return personalDocument::fetch(env, p);
    case phoneNumberAuthenticationSettings::ID:
      return phoneNumberAuthenticationSettings::fetch(env, p);
    case phoneNumberCodeTypeChange::ID:
      return phoneNumberCodeTypeChange::fetch(env, p);
    case phoneNumberCodeTypeVerify::ID:
      return phoneNumberCodeTypeVerify::fetch(env, p);
    case phoneNumberCodeTypeConfirmOwnership::ID:
      return phoneNumberCodeTypeConfirmOwnership::fetch(env, p);
    case phoneNumberInfo::ID:
      return phoneNumberInfo::fetch(env, p);
    case photo::ID:
      return photo::fetch(env, p);
    case photoSize::ID:
      return photoSize::fetch(env, p);
    case point::ID:
      return point::fetch(env, p);
    case poll::ID:
      return poll::fetch(env, p);
    case pollOption::ID:
      return pollOption::fetch(env, p);
    case pollTypeRegular::ID:
      return pollTypeRegular::fetch(env, p);
    case pollTypeQuiz::ID:
      return pollTypeQuiz::fetch(env, p);
    case premiumFeatureIncreasedLimits::ID:
      return premiumFeatureIncreasedLimits::fetch(env, p);
    case premiumFeatureIncreasedUploadFileSize::ID:
      return premiumFeatureIncreasedUploadFileSize::fetch(env, p);
    case premiumFeatureImprovedDownloadSpeed::ID:
      return premiumFeatureImprovedDownloadSpeed::fetch(env, p);
    case premiumFeatureVoiceRecognition::ID:
      return premiumFeatureVoiceRecognition::fetch(env, p);
    case premiumFeatureDisabledAds::ID:
      return premiumFeatureDisabledAds::fetch(env, p);
    case premiumFeatureUniqueReactions::ID:
      return premiumFeatureUniqueReactions::fetch(env, p);
    case premiumFeatureUniqueStickers::ID:
      return premiumFeatureUniqueStickers::fetch(env, p);
    case premiumFeatureCustomEmoji::ID:
      return premiumFeatureCustomEmoji::fetch(env, p);
    case premiumFeatureAdvancedChatManagement::ID:
      return premiumFeatureAdvancedChatManagement::fetch(env, p);
    case premiumFeatureProfileBadge::ID:
      return premiumFeatureProfileBadge::fetch(env, p);
    case premiumFeatureEmojiStatus::ID:
      return premiumFeatureEmojiStatus::fetch(env, p);
    case premiumFeatureAnimatedProfilePhoto::ID:
      return premiumFeatureAnimatedProfilePhoto::fetch(env, p);
    case premiumFeatureForumTopicIcon::ID:
      return premiumFeatureForumTopicIcon::fetch(env, p);
    case premiumFeatureAppIcons::ID:
      return premiumFeatureAppIcons::fetch(env, p);
    case premiumFeatureRealTimeChatTranslation::ID:
      return premiumFeatureRealTimeChatTranslation::fetch(env, p);
    case premiumFeatureUpgradedStories::ID:
      return premiumFeatureUpgradedStories::fetch(env, p);
    case premiumFeatureChatBoost::ID:
      return premiumFeatureChatBoost::fetch(env, p);
    case premiumFeatureAccentColor::ID:
      return premiumFeatureAccentColor::fetch(env, p);
    case premiumFeatureBackgroundForBoth::ID:
      return premiumFeatureBackgroundForBoth::fetch(env, p);
    case premiumFeatureSavedMessagesTags::ID:
      return premiumFeatureSavedMessagesTags::fetch(env, p);
    case premiumFeatureMessagePrivacy::ID:
      return premiumFeatureMessagePrivacy::fetch(env, p);
    case premiumFeatureLastSeenTimes::ID:
      return premiumFeatureLastSeenTimes::fetch(env, p);
    case premiumFeatureBusiness::ID:
      return premiumFeatureBusiness::fetch(env, p);
    case premiumFeatureMessageEffects::ID:
      return premiumFeatureMessageEffects::fetch(env, p);
    case premiumFeatureChecklists::ID:
      return premiumFeatureChecklists::fetch(env, p);
    case premiumFeaturePromotionAnimation::ID:
      return premiumFeaturePromotionAnimation::fetch(env, p);
    case premiumFeatures::ID:
      return premiumFeatures::fetch(env, p);
    case premiumGiftCodeInfo::ID:
      return premiumGiftCodeInfo::fetch(env, p);
    case premiumGiftPaymentOption::ID:
      return premiumGiftPaymentOption::fetch(env, p);
    case premiumGiftPaymentOptions::ID:
      return premiumGiftPaymentOptions::fetch(env, p);
    case premiumGiveawayPaymentOption::ID:
      return premiumGiveawayPaymentOption::fetch(env, p);
    case premiumGiveawayPaymentOptions::ID:
      return premiumGiveawayPaymentOptions::fetch(env, p);
    case premiumLimit::ID:
      return premiumLimit::fetch(env, p);
    case premiumLimitTypeSupergroupCount::ID:
      return premiumLimitTypeSupergroupCount::fetch(env, p);
    case premiumLimitTypePinnedChatCount::ID:
      return premiumLimitTypePinnedChatCount::fetch(env, p);
    case premiumLimitTypeCreatedPublicChatCount::ID:
      return premiumLimitTypeCreatedPublicChatCount::fetch(env, p);
    case premiumLimitTypeSavedAnimationCount::ID:
      return premiumLimitTypeSavedAnimationCount::fetch(env, p);
    case premiumLimitTypeFavoriteStickerCount::ID:
      return premiumLimitTypeFavoriteStickerCount::fetch(env, p);
    case premiumLimitTypeChatFolderCount::ID:
      return premiumLimitTypeChatFolderCount::fetch(env, p);
    case premiumLimitTypeChatFolderChosenChatCount::ID:
      return premiumLimitTypeChatFolderChosenChatCount::fetch(env, p);
    case premiumLimitTypePinnedArchivedChatCount::ID:
      return premiumLimitTypePinnedArchivedChatCount::fetch(env, p);
    case premiumLimitTypePinnedSavedMessagesTopicCount::ID:
      return premiumLimitTypePinnedSavedMessagesTopicCount::fetch(env, p);
    case premiumLimitTypeCaptionLength::ID:
      return premiumLimitTypeCaptionLength::fetch(env, p);
    case premiumLimitTypeBioLength::ID:
      return premiumLimitTypeBioLength::fetch(env, p);
    case premiumLimitTypeChatFolderInviteLinkCount::ID:
      return premiumLimitTypeChatFolderInviteLinkCount::fetch(env, p);
    case premiumLimitTypeShareableChatFolderCount::ID:
      return premiumLimitTypeShareableChatFolderCount::fetch(env, p);
    case premiumLimitTypeActiveStoryCount::ID:
      return premiumLimitTypeActiveStoryCount::fetch(env, p);
    case premiumLimitTypeWeeklyPostedStoryCount::ID:
      return premiumLimitTypeWeeklyPostedStoryCount::fetch(env, p);
    case premiumLimitTypeMonthlyPostedStoryCount::ID:
      return premiumLimitTypeMonthlyPostedStoryCount::fetch(env, p);
    case premiumLimitTypeStoryCaptionLength::ID:
      return premiumLimitTypeStoryCaptionLength::fetch(env, p);
    case premiumLimitTypeStorySuggestedReactionAreaCount::ID:
      return premiumLimitTypeStorySuggestedReactionAreaCount::fetch(env, p);
    case premiumLimitTypeSimilarChatCount::ID:
      return premiumLimitTypeSimilarChatCount::fetch(env, p);
    case premiumPaymentOption::ID:
      return premiumPaymentOption::fetch(env, p);
    case premiumSourceLimitExceeded::ID:
      return premiumSourceLimitExceeded::fetch(env, p);
    case premiumSourceFeature::ID:
      return premiumSourceFeature::fetch(env, p);
    case premiumSourceBusinessFeature::ID:
      return premiumSourceBusinessFeature::fetch(env, p);
    case premiumSourceStoryFeature::ID:
      return premiumSourceStoryFeature::fetch(env, p);
    case premiumSourceLink::ID:
      return premiumSourceLink::fetch(env, p);
    case premiumSourceSettings::ID:
      return premiumSourceSettings::fetch(env, p);
    case premiumState::ID:
      return premiumState::fetch(env, p);
    case premiumStatePaymentOption::ID:
      return premiumStatePaymentOption::fetch(env, p);
    case premiumStoryFeaturePriorityOrder::ID:
      return premiumStoryFeaturePriorityOrder::fetch(env, p);
    case premiumStoryFeatureStealthMode::ID:
      return premiumStoryFeatureStealthMode::fetch(env, p);
    case premiumStoryFeaturePermanentViewsHistory::ID:
      return premiumStoryFeaturePermanentViewsHistory::fetch(env, p);
    case premiumStoryFeatureCustomExpirationDuration::ID:
      return premiumStoryFeatureCustomExpirationDuration::fetch(env, p);
    case premiumStoryFeatureSaveStories::ID:
      return premiumStoryFeatureSaveStories::fetch(env, p);
    case premiumStoryFeatureLinksAndFormatting::ID:
      return premiumStoryFeatureLinksAndFormatting::fetch(env, p);
    case premiumStoryFeatureVideoQuality::ID:
      return premiumStoryFeatureVideoQuality::fetch(env, p);
    case prepaidGiveaway::ID:
      return prepaidGiveaway::fetch(env, p);
    case preparedInlineMessage::ID:
      return preparedInlineMessage::fetch(env, p);
    case preparedInlineMessageId::ID:
      return preparedInlineMessageId::fetch(env, p);
    case productInfo::ID:
      return productInfo::fetch(env, p);
    case profileAccentColor::ID:
      return profileAccentColor::fetch(env, p);
    case profileAccentColors::ID:
      return profileAccentColors::fetch(env, p);
    case profilePhoto::ID:
      return profilePhoto::fetch(env, p);
    case proxies::ID:
      return proxies::fetch(env, p);
    case proxy::ID:
      return proxy::fetch(env, p);
    case proxyTypeSocks5::ID:
      return proxyTypeSocks5::fetch(env, p);
    case proxyTypeHttp::ID:
      return proxyTypeHttp::fetch(env, p);
    case proxyTypeMtproto::ID:
      return proxyTypeMtproto::fetch(env, p);
    case publicChatTypeHasUsername::ID:
      return publicChatTypeHasUsername::fetch(env, p);
    case publicChatTypeIsLocationBased::ID:
      return publicChatTypeIsLocationBased::fetch(env, p);
    case publicForwardMessage::ID:
      return publicForwardMessage::fetch(env, p);
    case publicForwardStory::ID:
      return publicForwardStory::fetch(env, p);
    case publicForwards::ID:
      return publicForwards::fetch(env, p);
    case pushMessageContentHidden::ID:
      return pushMessageContentHidden::fetch(env, p);
    case pushMessageContentAnimation::ID:
      return pushMessageContentAnimation::fetch(env, p);
    case pushMessageContentAudio::ID:
      return pushMessageContentAudio::fetch(env, p);
    case pushMessageContentContact::ID:
      return pushMessageContentContact::fetch(env, p);
    case pushMessageContentContactRegistered::ID:
      return pushMessageContentContactRegistered::fetch(env, p);
    case pushMessageContentDocument::ID:
      return pushMessageContentDocument::fetch(env, p);
    case pushMessageContentGame::ID:
      return pushMessageContentGame::fetch(env, p);
    case pushMessageContentGameScore::ID:
      return pushMessageContentGameScore::fetch(env, p);
    case pushMessageContentInvoice::ID:
      return pushMessageContentInvoice::fetch(env, p);
    case pushMessageContentLocation::ID:
      return pushMessageContentLocation::fetch(env, p);
    case pushMessageContentPaidMedia::ID:
      return pushMessageContentPaidMedia::fetch(env, p);
    case pushMessageContentPhoto::ID:
      return pushMessageContentPhoto::fetch(env, p);
    case pushMessageContentPoll::ID:
      return pushMessageContentPoll::fetch(env, p);
    case pushMessageContentPremiumGiftCode::ID:
      return pushMessageContentPremiumGiftCode::fetch(env, p);
    case pushMessageContentGiveaway::ID:
      return pushMessageContentGiveaway::fetch(env, p);
    case pushMessageContentGift::ID:
      return pushMessageContentGift::fetch(env, p);
    case pushMessageContentUpgradedGift::ID:
      return pushMessageContentUpgradedGift::fetch(env, p);
    case pushMessageContentScreenshotTaken::ID:
      return pushMessageContentScreenshotTaken::fetch(env, p);
    case pushMessageContentSticker::ID:
      return pushMessageContentSticker::fetch(env, p);
    case pushMessageContentStory::ID:
      return pushMessageContentStory::fetch(env, p);
    case pushMessageContentText::ID:
      return pushMessageContentText::fetch(env, p);
    case pushMessageContentChecklist::ID:
      return pushMessageContentChecklist::fetch(env, p);
    case pushMessageContentVideo::ID:
      return pushMessageContentVideo::fetch(env, p);
    case pushMessageContentVideoNote::ID:
      return pushMessageContentVideoNote::fetch(env, p);
    case pushMessageContentVoiceNote::ID:
      return pushMessageContentVoiceNote::fetch(env, p);
    case pushMessageContentBasicGroupChatCreate::ID:
      return pushMessageContentBasicGroupChatCreate::fetch(env, p);
    case pushMessageContentVideoChatStarted::ID:
      return pushMessageContentVideoChatStarted::fetch(env, p);
    case pushMessageContentVideoChatEnded::ID:
      return pushMessageContentVideoChatEnded::fetch(env, p);
    case pushMessageContentInviteVideoChatParticipants::ID:
      return pushMessageContentInviteVideoChatParticipants::fetch(env, p);
    case pushMessageContentChatAddMembers::ID:
      return pushMessageContentChatAddMembers::fetch(env, p);
    case pushMessageContentChatChangePhoto::ID:
      return pushMessageContentChatChangePhoto::fetch(env, p);
    case pushMessageContentChatChangeTitle::ID:
      return pushMessageContentChatChangeTitle::fetch(env, p);
    case pushMessageContentChatSetBackground::ID:
      return pushMessageContentChatSetBackground::fetch(env, p);
    case pushMessageContentChatSetTheme::ID:
      return pushMessageContentChatSetTheme::fetch(env, p);
    case pushMessageContentChatDeleteMember::ID:
      return pushMessageContentChatDeleteMember::fetch(env, p);
    case pushMessageContentChatJoinByLink::ID:
      return pushMessageContentChatJoinByLink::fetch(env, p);
    case pushMessageContentChatJoinByRequest::ID:
      return pushMessageContentChatJoinByRequest::fetch(env, p);
    case pushMessageContentRecurringPayment::ID:
      return pushMessageContentRecurringPayment::fetch(env, p);
    case pushMessageContentSuggestProfilePhoto::ID:
      return pushMessageContentSuggestProfilePhoto::fetch(env, p);
    case pushMessageContentProximityAlertTriggered::ID:
      return pushMessageContentProximityAlertTriggered::fetch(env, p);
    case pushMessageContentChecklistTasksAdded::ID:
      return pushMessageContentChecklistTasksAdded::fetch(env, p);
    case pushMessageContentChecklistTasksDone::ID:
      return pushMessageContentChecklistTasksDone::fetch(env, p);
    case pushMessageContentMessageForwards::ID:
      return pushMessageContentMessageForwards::fetch(env, p);
    case pushMessageContentMediaAlbum::ID:
      return pushMessageContentMediaAlbum::fetch(env, p);
    case pushReceiverId::ID:
      return pushReceiverId::fetch(env, p);
    case quickReplyMessage::ID:
      return quickReplyMessage::fetch(env, p);
    case quickReplyMessages::ID:
      return quickReplyMessages::fetch(env, p);
    case quickReplyShortcut::ID:
      return quickReplyShortcut::fetch(env, p);
    case reactionNotificationSettings::ID:
      return reactionNotificationSettings::fetch(env, p);
    case reactionNotificationSourceNone::ID:
      return reactionNotificationSourceNone::fetch(env, p);
    case reactionNotificationSourceContacts::ID:
      return reactionNotificationSourceContacts::fetch(env, p);
    case reactionNotificationSourceAll::ID:
      return reactionNotificationSourceAll::fetch(env, p);
    case reactionTypeEmoji::ID:
      return reactionTypeEmoji::fetch(env, p);
    case reactionTypeCustomEmoji::ID:
      return reactionTypeCustomEmoji::fetch(env, p);
    case reactionTypePaid::ID:
      return reactionTypePaid::fetch(env, p);
    case reactionUnavailabilityReasonAnonymousAdministrator::ID:
      return reactionUnavailabilityReasonAnonymousAdministrator::fetch(env, p);
    case reactionUnavailabilityReasonGuest::ID:
      return reactionUnavailabilityReasonGuest::fetch(env, p);
    case readDatePrivacySettings::ID:
      return readDatePrivacySettings::fetch(env, p);
    case receivedGift::ID:
      return receivedGift::fetch(env, p);
    case receivedGifts::ID:
      return receivedGifts::fetch(env, p);
    case recommendedChatFolder::ID:
      return recommendedChatFolder::fetch(env, p);
    case recommendedChatFolders::ID:
      return recommendedChatFolders::fetch(env, p);
    case recoveryEmailAddress::ID:
      return recoveryEmailAddress::fetch(env, p);
    case remoteFile::ID:
      return remoteFile::fetch(env, p);
    case replyMarkupRemoveKeyboard::ID:
      return replyMarkupRemoveKeyboard::fetch(env, p);
    case replyMarkupForceReply::ID:
      return replyMarkupForceReply::fetch(env, p);
    case replyMarkupShowKeyboard::ID:
      return replyMarkupShowKeyboard::fetch(env, p);
    case replyMarkupInlineKeyboard::ID:
      return replyMarkupInlineKeyboard::fetch(env, p);
    case reportChatResultOk::ID:
      return reportChatResultOk::fetch(env, p);
    case reportChatResultOptionRequired::ID:
      return reportChatResultOptionRequired::fetch(env, p);
    case reportChatResultTextRequired::ID:
      return reportChatResultTextRequired::fetch(env, p);
    case reportChatResultMessagesRequired::ID:
      return reportChatResultMessagesRequired::fetch(env, p);
    case reportOption::ID:
      return reportOption::fetch(env, p);
    case reportReasonSpam::ID:
      return reportReasonSpam::fetch(env, p);
    case reportReasonViolence::ID:
      return reportReasonViolence::fetch(env, p);
    case reportReasonPornography::ID:
      return reportReasonPornography::fetch(env, p);
    case reportReasonChildAbuse::ID:
      return reportReasonChildAbuse::fetch(env, p);
    case reportReasonCopyright::ID:
      return reportReasonCopyright::fetch(env, p);
    case reportReasonUnrelatedLocation::ID:
      return reportReasonUnrelatedLocation::fetch(env, p);
    case reportReasonFake::ID:
      return reportReasonFake::fetch(env, p);
    case reportReasonIllegalDrugs::ID:
      return reportReasonIllegalDrugs::fetch(env, p);
    case reportReasonPersonalDetails::ID:
      return reportReasonPersonalDetails::fetch(env, p);
    case reportReasonCustom::ID:
      return reportReasonCustom::fetch(env, p);
    case reportSponsoredResultOk::ID:
      return reportSponsoredResultOk::fetch(env, p);
    case reportSponsoredResultFailed::ID:
      return reportSponsoredResultFailed::fetch(env, p);
    case reportSponsoredResultOptionRequired::ID:
      return reportSponsoredResultOptionRequired::fetch(env, p);
    case reportSponsoredResultAdsHidden::ID:
      return reportSponsoredResultAdsHidden::fetch(env, p);
    case reportSponsoredResultPremiumRequired::ID:
      return reportSponsoredResultPremiumRequired::fetch(env, p);
    case reportStoryResultOk::ID:
      return reportStoryResultOk::fetch(env, p);
    case reportStoryResultOptionRequired::ID:
      return reportStoryResultOptionRequired::fetch(env, p);
    case reportStoryResultTextRequired::ID:
      return reportStoryResultTextRequired::fetch(env, p);
    case resendCodeReasonUserRequest::ID:
      return resendCodeReasonUserRequest::fetch(env, p);
    case resendCodeReasonVerificationFailed::ID:
      return resendCodeReasonVerificationFailed::fetch(env, p);
    case resetPasswordResultOk::ID:
      return resetPasswordResultOk::fetch(env, p);
    case resetPasswordResultPending::ID:
      return resetPasswordResultPending::fetch(env, p);
    case resetPasswordResultDeclined::ID:
      return resetPasswordResultDeclined::fetch(env, p);
    case revenueWithdrawalStatePending::ID:
      return revenueWithdrawalStatePending::fetch(env, p);
    case revenueWithdrawalStateSucceeded::ID:
      return revenueWithdrawalStateSucceeded::fetch(env, p);
    case revenueWithdrawalStateFailed::ID:
      return revenueWithdrawalStateFailed::fetch(env, p);
    case richTextPlain::ID:
      return richTextPlain::fetch(env, p);
    case richTextBold::ID:
      return richTextBold::fetch(env, p);
    case richTextItalic::ID:
      return richTextItalic::fetch(env, p);
    case richTextUnderline::ID:
      return richTextUnderline::fetch(env, p);
    case richTextStrikethrough::ID:
      return richTextStrikethrough::fetch(env, p);
    case richTextFixed::ID:
      return richTextFixed::fetch(env, p);
    case richTextUrl::ID:
      return richTextUrl::fetch(env, p);
    case richTextEmailAddress::ID:
      return richTextEmailAddress::fetch(env, p);
    case richTextSubscript::ID:
      return richTextSubscript::fetch(env, p);
    case richTextSuperscript::ID:
      return richTextSuperscript::fetch(env, p);
    case richTextMarked::ID:
      return richTextMarked::fetch(env, p);
    case richTextPhoneNumber::ID:
      return richTextPhoneNumber::fetch(env, p);
    case richTextIcon::ID:
      return richTextIcon::fetch(env, p);
    case richTextReference::ID:
      return richTextReference::fetch(env, p);
    case richTextAnchor::ID:
      return richTextAnchor::fetch(env, p);
    case richTextAnchorLink::ID:
      return richTextAnchorLink::fetch(env, p);
    case richTexts::ID:
      return richTexts::fetch(env, p);
    case rtmpUrl::ID:
      return rtmpUrl::fetch(env, p);
    case savedCredentials::ID:
      return savedCredentials::fetch(env, p);
    case savedMessagesTag::ID:
      return savedMessagesTag::fetch(env, p);
    case savedMessagesTags::ID:
      return savedMessagesTags::fetch(env, p);
    case savedMessagesTopic::ID:
      return savedMessagesTopic::fetch(env, p);
    case savedMessagesTopicTypeMyNotes::ID:
      return savedMessagesTopicTypeMyNotes::fetch(env, p);
    case savedMessagesTopicTypeAuthorHidden::ID:
      return savedMessagesTopicTypeAuthorHidden::fetch(env, p);
    case savedMessagesTopicTypeSavedFromChat::ID:
      return savedMessagesTopicTypeSavedFromChat::fetch(env, p);
    case scopeAutosaveSettings::ID:
      return scopeAutosaveSettings::fetch(env, p);
    case scopeNotificationSettings::ID:
      return scopeNotificationSettings::fetch(env, p);
    case searchMessagesChatTypeFilterPrivate::ID:
      return searchMessagesChatTypeFilterPrivate::fetch(env, p);
    case searchMessagesChatTypeFilterGroup::ID:
      return searchMessagesChatTypeFilterGroup::fetch(env, p);
    case searchMessagesChatTypeFilterChannel::ID:
      return searchMessagesChatTypeFilterChannel::fetch(env, p);
    case searchMessagesFilterEmpty::ID:
      return searchMessagesFilterEmpty::fetch(env, p);
    case searchMessagesFilterAnimation::ID:
      return searchMessagesFilterAnimation::fetch(env, p);
    case searchMessagesFilterAudio::ID:
      return searchMessagesFilterAudio::fetch(env, p);
    case searchMessagesFilterDocument::ID:
      return searchMessagesFilterDocument::fetch(env, p);
    case searchMessagesFilterPhoto::ID:
      return searchMessagesFilterPhoto::fetch(env, p);
    case searchMessagesFilterVideo::ID:
      return searchMessagesFilterVideo::fetch(env, p);
    case searchMessagesFilterVoiceNote::ID:
      return searchMessagesFilterVoiceNote::fetch(env, p);
    case searchMessagesFilterPhotoAndVideo::ID:
      return searchMessagesFilterPhotoAndVideo::fetch(env, p);
    case searchMessagesFilterUrl::ID:
      return searchMessagesFilterUrl::fetch(env, p);
    case searchMessagesFilterChatPhoto::ID:
      return searchMessagesFilterChatPhoto::fetch(env, p);
    case searchMessagesFilterVideoNote::ID:
      return searchMessagesFilterVideoNote::fetch(env, p);
    case searchMessagesFilterVoiceAndVideoNote::ID:
      return searchMessagesFilterVoiceAndVideoNote::fetch(env, p);
    case searchMessagesFilterMention::ID:
      return searchMessagesFilterMention::fetch(env, p);
    case searchMessagesFilterUnreadMention::ID:
      return searchMessagesFilterUnreadMention::fetch(env, p);
    case searchMessagesFilterUnreadReaction::ID:
      return searchMessagesFilterUnreadReaction::fetch(env, p);
    case searchMessagesFilterFailedToSend::ID:
      return searchMessagesFilterFailedToSend::fetch(env, p);
    case searchMessagesFilterPinned::ID:
      return searchMessagesFilterPinned::fetch(env, p);
    case seconds::ID:
      return seconds::fetch(env, p);
    case secretChat::ID:
      return secretChat::fetch(env, p);
    case secretChatStatePending::ID:
      return secretChatStatePending::fetch(env, p);
    case secretChatStateReady::ID:
      return secretChatStateReady::fetch(env, p);
    case secretChatStateClosed::ID:
      return secretChatStateClosed::fetch(env, p);
    case sentGiftRegular::ID:
      return sentGiftRegular::fetch(env, p);
    case sentGiftUpgraded::ID:
      return sentGiftUpgraded::fetch(env, p);
    case sentWebAppMessage::ID:
      return sentWebAppMessage::fetch(env, p);
    case session::ID:
      return session::fetch(env, p);
    case sessionTypeAndroid::ID:
      return sessionTypeAndroid::fetch(env, p);
    case sessionTypeApple::ID:
      return sessionTypeApple::fetch(env, p);
    case sessionTypeBrave::ID:
      return sessionTypeBrave::fetch(env, p);
    case sessionTypeChrome::ID:
      return sessionTypeChrome::fetch(env, p);
    case sessionTypeEdge::ID:
      return sessionTypeEdge::fetch(env, p);
    case sessionTypeFirefox::ID:
      return sessionTypeFirefox::fetch(env, p);
    case sessionTypeIpad::ID:
      return sessionTypeIpad::fetch(env, p);
    case sessionTypeIphone::ID:
      return sessionTypeIphone::fetch(env, p);
    case sessionTypeLinux::ID:
      return sessionTypeLinux::fetch(env, p);
    case sessionTypeMac::ID:
      return sessionTypeMac::fetch(env, p);
    case sessionTypeOpera::ID:
      return sessionTypeOpera::fetch(env, p);
    case sessionTypeSafari::ID:
      return sessionTypeSafari::fetch(env, p);
    case sessionTypeUbuntu::ID:
      return sessionTypeUbuntu::fetch(env, p);
    case sessionTypeUnknown::ID:
      return sessionTypeUnknown::fetch(env, p);
    case sessionTypeVivaldi::ID:
      return sessionTypeVivaldi::fetch(env, p);
    case sessionTypeWindows::ID:
      return sessionTypeWindows::fetch(env, p);
    case sessionTypeXbox::ID:
      return sessionTypeXbox::fetch(env, p);
    case sessions::ID:
      return sessions::fetch(env, p);
    case sharedChat::ID:
      return sharedChat::fetch(env, p);
    case sharedUser::ID:
      return sharedUser::fetch(env, p);
    case shippingOption::ID:
      return shippingOption::fetch(env, p);
    case speechRecognitionResultPending::ID:
      return speechRecognitionResultPending::fetch(env, p);
    case speechRecognitionResultText::ID:
      return speechRecognitionResultText::fetch(env, p);
    case speechRecognitionResultError::ID:
      return speechRecognitionResultError::fetch(env, p);
    case sponsoredChat::ID:
      return sponsoredChat::fetch(env, p);
    case sponsoredChats::ID:
      return sponsoredChats::fetch(env, p);
    case sponsoredMessage::ID:
      return sponsoredMessage::fetch(env, p);
    case sponsoredMessages::ID:
      return sponsoredMessages::fetch(env, p);
    case starAmount::ID:
      return starAmount::fetch(env, p);
    case starCount::ID:
      return starCount::fetch(env, p);
    case starGiveawayPaymentOption::ID:
      return starGiveawayPaymentOption::fetch(env, p);
    case starGiveawayPaymentOptions::ID:
      return starGiveawayPaymentOptions::fetch(env, p);
    case starGiveawayWinnerOption::ID:
      return starGiveawayWinnerOption::fetch(env, p);
    case starPaymentOption::ID:
      return starPaymentOption::fetch(env, p);
    case starPaymentOptions::ID:
      return starPaymentOptions::fetch(env, p);
    case starRevenueStatistics::ID:
      return starRevenueStatistics::fetch(env, p);
    case starRevenueStatus::ID:
      return starRevenueStatus::fetch(env, p);
    case starSubscription::ID:
      return starSubscription::fetch(env, p);
    case starSubscriptionPricing::ID:
      return starSubscriptionPricing::fetch(env, p);
    case starSubscriptionTypeChannel::ID:
      return starSubscriptionTypeChannel::fetch(env, p);
    case starSubscriptionTypeBot::ID:
      return starSubscriptionTypeBot::fetch(env, p);
    case starSubscriptions::ID:
      return starSubscriptions::fetch(env, p);
    case starTransaction::ID:
      return starTransaction::fetch(env, p);
    case starTransactionTypePremiumBotDeposit::ID:
      return starTransactionTypePremiumBotDeposit::fetch(env, p);
    case starTransactionTypeAppStoreDeposit::ID:
      return starTransactionTypeAppStoreDeposit::fetch(env, p);
    case starTransactionTypeGooglePlayDeposit::ID:
      return starTransactionTypeGooglePlayDeposit::fetch(env, p);
    case starTransactionTypeFragmentDeposit::ID:
      return starTransactionTypeFragmentDeposit::fetch(env, p);
    case starTransactionTypeUserDeposit::ID:
      return starTransactionTypeUserDeposit::fetch(env, p);
    case starTransactionTypeGiveawayDeposit::ID:
      return starTransactionTypeGiveawayDeposit::fetch(env, p);
    case starTransactionTypeFragmentWithdrawal::ID:
      return starTransactionTypeFragmentWithdrawal::fetch(env, p);
    case starTransactionTypeTelegramAdsWithdrawal::ID:
      return starTransactionTypeTelegramAdsWithdrawal::fetch(env, p);
    case starTransactionTypeTelegramApiUsage::ID:
      return starTransactionTypeTelegramApiUsage::fetch(env, p);
    case starTransactionTypeBotPaidMediaPurchase::ID:
      return starTransactionTypeBotPaidMediaPurchase::fetch(env, p);
    case starTransactionTypeBotPaidMediaSale::ID:
      return starTransactionTypeBotPaidMediaSale::fetch(env, p);
    case starTransactionTypeChannelPaidMediaPurchase::ID:
      return starTransactionTypeChannelPaidMediaPurchase::fetch(env, p);
    case starTransactionTypeChannelPaidMediaSale::ID:
      return starTransactionTypeChannelPaidMediaSale::fetch(env, p);
    case starTransactionTypeBotInvoicePurchase::ID:
      return starTransactionTypeBotInvoicePurchase::fetch(env, p);
    case starTransactionTypeBotInvoiceSale::ID:
      return starTransactionTypeBotInvoiceSale::fetch(env, p);
    case starTransactionTypeBotSubscriptionPurchase::ID:
      return starTransactionTypeBotSubscriptionPurchase::fetch(env, p);
    case starTransactionTypeBotSubscriptionSale::ID:
      return starTransactionTypeBotSubscriptionSale::fetch(env, p);
    case starTransactionTypeChannelSubscriptionPurchase::ID:
      return starTransactionTypeChannelSubscriptionPurchase::fetch(env, p);
    case starTransactionTypeChannelSubscriptionSale::ID:
      return starTransactionTypeChannelSubscriptionSale::fetch(env, p);
    case starTransactionTypeGiftPurchase::ID:
      return starTransactionTypeGiftPurchase::fetch(env, p);
    case starTransactionTypeGiftTransfer::ID:
      return starTransactionTypeGiftTransfer::fetch(env, p);
    case starTransactionTypeGiftSale::ID:
      return starTransactionTypeGiftSale::fetch(env, p);
    case starTransactionTypeGiftUpgrade::ID:
      return starTransactionTypeGiftUpgrade::fetch(env, p);
    case starTransactionTypeUpgradedGiftPurchase::ID:
      return starTransactionTypeUpgradedGiftPurchase::fetch(env, p);
    case starTransactionTypeUpgradedGiftSale::ID:
      return starTransactionTypeUpgradedGiftSale::fetch(env, p);
    case starTransactionTypeChannelPaidReactionSend::ID:
      return starTransactionTypeChannelPaidReactionSend::fetch(env, p);
    case starTransactionTypeChannelPaidReactionReceive::ID:
      return starTransactionTypeChannelPaidReactionReceive::fetch(env, p);
    case starTransactionTypeAffiliateProgramCommission::ID:
      return starTransactionTypeAffiliateProgramCommission::fetch(env, p);
    case starTransactionTypePaidMessageSend::ID:
      return starTransactionTypePaidMessageSend::fetch(env, p);
    case starTransactionTypePaidMessageReceive::ID:
      return starTransactionTypePaidMessageReceive::fetch(env, p);
    case starTransactionTypeSuggestedPostPaymentSend::ID:
      return starTransactionTypeSuggestedPostPaymentSend::fetch(env, p);
    case starTransactionTypeSuggestedPostPaymentReceive::ID:
      return starTransactionTypeSuggestedPostPaymentReceive::fetch(env, p);
    case starTransactionTypePremiumPurchase::ID:
      return starTransactionTypePremiumPurchase::fetch(env, p);
    case starTransactionTypeBusinessBotTransferSend::ID:
      return starTransactionTypeBusinessBotTransferSend::fetch(env, p);
    case starTransactionTypeBusinessBotTransferReceive::ID:
      return starTransactionTypeBusinessBotTransferReceive::fetch(env, p);
    case starTransactionTypeUnsupported::ID:
      return starTransactionTypeUnsupported::fetch(env, p);
    case starTransactions::ID:
      return starTransactions::fetch(env, p);
    case statisticalGraphData::ID:
      return statisticalGraphData::fetch(env, p);
    case statisticalGraphAsync::ID:
      return statisticalGraphAsync::fetch(env, p);
    case statisticalGraphError::ID:
      return statisticalGraphError::fetch(env, p);
    case statisticalValue::ID:
      return statisticalValue::fetch(env, p);
    case sticker::ID:
      return sticker::fetch(env, p);
    case stickerFormatWebp::ID:
      return stickerFormatWebp::fetch(env, p);
    case stickerFormatTgs::ID:
      return stickerFormatTgs::fetch(env, p);
    case stickerFormatWebm::ID:
      return stickerFormatWebm::fetch(env, p);
    case stickerFullTypeRegular::ID:
      return stickerFullTypeRegular::fetch(env, p);
    case stickerFullTypeMask::ID:
      return stickerFullTypeMask::fetch(env, p);
    case stickerFullTypeCustomEmoji::ID:
      return stickerFullTypeCustomEmoji::fetch(env, p);
    case stickerSet::ID:
      return stickerSet::fetch(env, p);
    case stickerSetInfo::ID:
      return stickerSetInfo::fetch(env, p);
    case stickerSets::ID:
      return stickerSets::fetch(env, p);
    case stickerTypeRegular::ID:
      return stickerTypeRegular::fetch(env, p);
    case stickerTypeMask::ID:
      return stickerTypeMask::fetch(env, p);
    case stickerTypeCustomEmoji::ID:
      return stickerTypeCustomEmoji::fetch(env, p);
    case stickers::ID:
      return stickers::fetch(env, p);
    case storageStatistics::ID:
      return storageStatistics::fetch(env, p);
    case storageStatisticsByChat::ID:
      return storageStatisticsByChat::fetch(env, p);
    case storageStatisticsByFileType::ID:
      return storageStatisticsByFileType::fetch(env, p);
    case storageStatisticsFast::ID:
      return storageStatisticsFast::fetch(env, p);
    case storePaymentPurposePremiumSubscription::ID:
      return storePaymentPurposePremiumSubscription::fetch(env, p);
    case storePaymentPurposePremiumGift::ID:
      return storePaymentPurposePremiumGift::fetch(env, p);
    case storePaymentPurposePremiumGiftCodes::ID:
      return storePaymentPurposePremiumGiftCodes::fetch(env, p);
    case storePaymentPurposePremiumGiveaway::ID:
      return storePaymentPurposePremiumGiveaway::fetch(env, p);
    case storePaymentPurposeStarGiveaway::ID:
      return storePaymentPurposeStarGiveaway::fetch(env, p);
    case storePaymentPurposeStars::ID:
      return storePaymentPurposeStars::fetch(env, p);
    case storePaymentPurposeGiftedStars::ID:
      return storePaymentPurposeGiftedStars::fetch(env, p);
    case storeTransactionAppStore::ID:
      return storeTransactionAppStore::fetch(env, p);
    case storeTransactionGooglePlay::ID:
      return storeTransactionGooglePlay::fetch(env, p);
    case stories::ID:
      return stories::fetch(env, p);
    case story::ID:
      return story::fetch(env, p);
    case storyArea::ID:
      return storyArea::fetch(env, p);
    case storyAreaPosition::ID:
      return storyAreaPosition::fetch(env, p);
    case storyAreaTypeLocation::ID:
      return storyAreaTypeLocation::fetch(env, p);
    case storyAreaTypeVenue::ID:
      return storyAreaTypeVenue::fetch(env, p);
    case storyAreaTypeSuggestedReaction::ID:
      return storyAreaTypeSuggestedReaction::fetch(env, p);
    case storyAreaTypeMessage::ID:
      return storyAreaTypeMessage::fetch(env, p);
    case storyAreaTypeLink::ID:
      return storyAreaTypeLink::fetch(env, p);
    case storyAreaTypeWeather::ID:
      return storyAreaTypeWeather::fetch(env, p);
    case storyAreaTypeUpgradedGift::ID:
      return storyAreaTypeUpgradedGift::fetch(env, p);
    case storyContentPhoto::ID:
      return storyContentPhoto::fetch(env, p);
    case storyContentVideo::ID:
      return storyContentVideo::fetch(env, p);
    case storyContentUnsupported::ID:
      return storyContentUnsupported::fetch(env, p);
    case storyFullId::ID:
      return storyFullId::fetch(env, p);
    case storyInfo::ID:
      return storyInfo::fetch(env, p);
    case storyInteraction::ID:
      return storyInteraction::fetch(env, p);
    case storyInteractionInfo::ID:
      return storyInteractionInfo::fetch(env, p);
    case storyInteractionTypeView::ID:
      return storyInteractionTypeView::fetch(env, p);
    case storyInteractionTypeForward::ID:
      return storyInteractionTypeForward::fetch(env, p);
    case storyInteractionTypeRepost::ID:
      return storyInteractionTypeRepost::fetch(env, p);
    case storyInteractions::ID:
      return storyInteractions::fetch(env, p);
    case storyListMain::ID:
      return storyListMain::fetch(env, p);
    case storyListArchive::ID:
      return storyListArchive::fetch(env, p);
    case storyOriginPublicStory::ID:
      return storyOriginPublicStory::fetch(env, p);
    case storyOriginHiddenUser::ID:
      return storyOriginHiddenUser::fetch(env, p);
    case storyPrivacySettingsEveryone::ID:
      return storyPrivacySettingsEveryone::fetch(env, p);
    case storyPrivacySettingsContacts::ID:
      return storyPrivacySettingsContacts::fetch(env, p);
    case storyPrivacySettingsCloseFriends::ID:
      return storyPrivacySettingsCloseFriends::fetch(env, p);
    case storyPrivacySettingsSelectedUsers::ID:
      return storyPrivacySettingsSelectedUsers::fetch(env, p);
    case storyRepostInfo::ID:
      return storyRepostInfo::fetch(env, p);
    case storyStatistics::ID:
      return storyStatistics::fetch(env, p);
    case storyVideo::ID:
      return storyVideo::fetch(env, p);
    case suggestedActionEnableArchiveAndMuteNewChats::ID:
      return suggestedActionEnableArchiveAndMuteNewChats::fetch(env, p);
    case suggestedActionCheckPassword::ID:
      return suggestedActionCheckPassword::fetch(env, p);
    case suggestedActionCheckPhoneNumber::ID:
      return suggestedActionCheckPhoneNumber::fetch(env, p);
    case suggestedActionViewChecksHint::ID:
      return suggestedActionViewChecksHint::fetch(env, p);
    case suggestedActionConvertToBroadcastGroup::ID:
      return suggestedActionConvertToBroadcastGroup::fetch(env, p);
    case suggestedActionSetPassword::ID:
      return suggestedActionSetPassword::fetch(env, p);
    case suggestedActionUpgradePremium::ID:
      return suggestedActionUpgradePremium::fetch(env, p);
    case suggestedActionRestorePremium::ID:
      return suggestedActionRestorePremium::fetch(env, p);
    case suggestedActionSubscribeToAnnualPremium::ID:
      return suggestedActionSubscribeToAnnualPremium::fetch(env, p);
    case suggestedActionGiftPremiumForChristmas::ID:
      return suggestedActionGiftPremiumForChristmas::fetch(env, p);
    case suggestedActionSetBirthdate::ID:
      return suggestedActionSetBirthdate::fetch(env, p);
    case suggestedActionSetProfilePhoto::ID:
      return suggestedActionSetProfilePhoto::fetch(env, p);
    case suggestedActionExtendPremium::ID:
      return suggestedActionExtendPremium::fetch(env, p);
    case suggestedActionExtendStarSubscriptions::ID:
      return suggestedActionExtendStarSubscriptions::fetch(env, p);
    case suggestedActionCustom::ID:
      return suggestedActionCustom::fetch(env, p);
    case suggestedPostInfo::ID:
      return suggestedPostInfo::fetch(env, p);
    case suggestedPostPriceStar::ID:
      return suggestedPostPriceStar::fetch(env, p);
    case suggestedPostPriceTon::ID:
      return suggestedPostPriceTon::fetch(env, p);
    case suggestedPostRefundReasonPostDeleted::ID:
      return suggestedPostRefundReasonPostDeleted::fetch(env, p);
    case suggestedPostRefundReasonPaymentRefunded::ID:
      return suggestedPostRefundReasonPaymentRefunded::fetch(env, p);
    case suggestedPostStatePending::ID:
      return suggestedPostStatePending::fetch(env, p);
    case suggestedPostStateApproved::ID:
      return suggestedPostStateApproved::fetch(env, p);
    case suggestedPostStateDeclined::ID:
      return suggestedPostStateDeclined::fetch(env, p);
    case supergroup::ID:
      return supergroup::fetch(env, p);
    case supergroupFullInfo::ID:
      return supergroupFullInfo::fetch(env, p);
    case supergroupMembersFilterRecent::ID:
      return supergroupMembersFilterRecent::fetch(env, p);
    case supergroupMembersFilterContacts::ID:
      return supergroupMembersFilterContacts::fetch(env, p);
    case supergroupMembersFilterAdministrators::ID:
      return supergroupMembersFilterAdministrators::fetch(env, p);
    case supergroupMembersFilterSearch::ID:
      return supergroupMembersFilterSearch::fetch(env, p);
    case supergroupMembersFilterRestricted::ID:
      return supergroupMembersFilterRestricted::fetch(env, p);
    case supergroupMembersFilterBanned::ID:
      return supergroupMembersFilterBanned::fetch(env, p);
    case supergroupMembersFilterMention::ID:
      return supergroupMembersFilterMention::fetch(env, p);
    case supergroupMembersFilterBots::ID:
      return supergroupMembersFilterBots::fetch(env, p);
    case tMeUrl::ID:
      return tMeUrl::fetch(env, p);
    case tMeUrlTypeUser::ID:
      return tMeUrlTypeUser::fetch(env, p);
    case tMeUrlTypeSupergroup::ID:
      return tMeUrlTypeSupergroup::fetch(env, p);
    case tMeUrlTypeChatInvite::ID:
      return tMeUrlTypeChatInvite::fetch(env, p);
    case tMeUrlTypeStickerSet::ID:
      return tMeUrlTypeStickerSet::fetch(env, p);
    case tMeUrls::ID:
      return tMeUrls::fetch(env, p);
    case targetChatCurrent::ID:
      return targetChatCurrent::fetch(env, p);
    case targetChatChosen::ID:
      return targetChatChosen::fetch(env, p);
    case targetChatInternalLink::ID:
      return targetChatInternalLink::fetch(env, p);
    case targetChatTypes::ID:
      return targetChatTypes::fetch(env, p);
    case telegramPaymentPurposePremiumGift::ID:
      return telegramPaymentPurposePremiumGift::fetch(env, p);
    case telegramPaymentPurposePremiumGiftCodes::ID:
      return telegramPaymentPurposePremiumGiftCodes::fetch(env, p);
    case telegramPaymentPurposePremiumGiveaway::ID:
      return telegramPaymentPurposePremiumGiveaway::fetch(env, p);
    case telegramPaymentPurposeStars::ID:
      return telegramPaymentPurposeStars::fetch(env, p);
    case telegramPaymentPurposeGiftedStars::ID:
      return telegramPaymentPurposeGiftedStars::fetch(env, p);
    case telegramPaymentPurposeStarGiveaway::ID:
      return telegramPaymentPurposeStarGiveaway::fetch(env, p);
    case telegramPaymentPurposeJoinChat::ID:
      return telegramPaymentPurposeJoinChat::fetch(env, p);
    case temporaryPasswordState::ID:
      return temporaryPasswordState::fetch(env, p);
    case termsOfService::ID:
      return termsOfService::fetch(env, p);
    case testBytes::ID:
      return testBytes::fetch(env, p);
    case testInt::ID:
      return testInt::fetch(env, p);
    case testString::ID:
      return testString::fetch(env, p);
    case testVectorInt::ID:
      return testVectorInt::fetch(env, p);
    case testVectorIntObject::ID:
      return testVectorIntObject::fetch(env, p);
    case testVectorString::ID:
      return testVectorString::fetch(env, p);
    case testVectorStringObject::ID:
      return testVectorStringObject::fetch(env, p);
    case text::ID:
      return text::fetch(env, p);
    case textEntities::ID:
      return textEntities::fetch(env, p);
    case textEntity::ID:
      return textEntity::fetch(env, p);
    case textEntityTypeMention::ID:
      return textEntityTypeMention::fetch(env, p);
    case textEntityTypeHashtag::ID:
      return textEntityTypeHashtag::fetch(env, p);
    case textEntityTypeCashtag::ID:
      return textEntityTypeCashtag::fetch(env, p);
    case textEntityTypeBotCommand::ID:
      return textEntityTypeBotCommand::fetch(env, p);
    case textEntityTypeUrl::ID:
      return textEntityTypeUrl::fetch(env, p);
    case textEntityTypeEmailAddress::ID:
      return textEntityTypeEmailAddress::fetch(env, p);
    case textEntityTypePhoneNumber::ID:
      return textEntityTypePhoneNumber::fetch(env, p);
    case textEntityTypeBankCardNumber::ID:
      return textEntityTypeBankCardNumber::fetch(env, p);
    case textEntityTypeBold::ID:
      return textEntityTypeBold::fetch(env, p);
    case textEntityTypeItalic::ID:
      return textEntityTypeItalic::fetch(env, p);
    case textEntityTypeUnderline::ID:
      return textEntityTypeUnderline::fetch(env, p);
    case textEntityTypeStrikethrough::ID:
      return textEntityTypeStrikethrough::fetch(env, p);
    case textEntityTypeSpoiler::ID:
      return textEntityTypeSpoiler::fetch(env, p);
    case textEntityTypeCode::ID:
      return textEntityTypeCode::fetch(env, p);
    case textEntityTypePre::ID:
      return textEntityTypePre::fetch(env, p);
    case textEntityTypePreCode::ID:
      return textEntityTypePreCode::fetch(env, p);
    case textEntityTypeBlockQuote::ID:
      return textEntityTypeBlockQuote::fetch(env, p);
    case textEntityTypeExpandableBlockQuote::ID:
      return textEntityTypeExpandableBlockQuote::fetch(env, p);
    case textEntityTypeTextUrl::ID:
      return textEntityTypeTextUrl::fetch(env, p);
    case textEntityTypeMentionName::ID:
      return textEntityTypeMentionName::fetch(env, p);
    case textEntityTypeCustomEmoji::ID:
      return textEntityTypeCustomEmoji::fetch(env, p);
    case textEntityTypeMediaTimestamp::ID:
      return textEntityTypeMediaTimestamp::fetch(env, p);
    case textParseModeMarkdown::ID:
      return textParseModeMarkdown::fetch(env, p);
    case textParseModeHTML::ID:
      return textParseModeHTML::fetch(env, p);
    case textQuote::ID:
      return textQuote::fetch(env, p);
    case themeParameters::ID:
      return themeParameters::fetch(env, p);
    case themeSettings::ID:
      return themeSettings::fetch(env, p);
    case thumbnail::ID:
      return thumbnail::fetch(env, p);
    case thumbnailFormatJpeg::ID:
      return thumbnailFormatJpeg::fetch(env, p);
    case thumbnailFormatGif::ID:
      return thumbnailFormatGif::fetch(env, p);
    case thumbnailFormatMpeg4::ID:
      return thumbnailFormatMpeg4::fetch(env, p);
    case thumbnailFormatPng::ID:
      return thumbnailFormatPng::fetch(env, p);
    case thumbnailFormatTgs::ID:
      return thumbnailFormatTgs::fetch(env, p);
    case thumbnailFormatWebm::ID:
      return thumbnailFormatWebm::fetch(env, p);
    case thumbnailFormatWebp::ID:
      return thumbnailFormatWebp::fetch(env, p);
    case timeZone::ID:
      return timeZone::fetch(env, p);
    case timeZones::ID:
      return timeZones::fetch(env, p);
    case tonTransaction::ID:
      return tonTransaction::fetch(env, p);
    case tonTransactionTypeFragmentDeposit::ID:
      return tonTransactionTypeFragmentDeposit::fetch(env, p);
    case tonTransactionTypeSuggestedPostPayment::ID:
      return tonTransactionTypeSuggestedPostPayment::fetch(env, p);
    case tonTransactionTypeUnsupported::ID:
      return tonTransactionTypeUnsupported::fetch(env, p);
    case tonTransactions::ID:
      return tonTransactions::fetch(env, p);
    case topChatCategoryUsers::ID:
      return topChatCategoryUsers::fetch(env, p);
    case topChatCategoryBots::ID:
      return topChatCategoryBots::fetch(env, p);
    case topChatCategoryGroups::ID:
      return topChatCategoryGroups::fetch(env, p);
    case topChatCategoryChannels::ID:
      return topChatCategoryChannels::fetch(env, p);
    case topChatCategoryInlineBots::ID:
      return topChatCategoryInlineBots::fetch(env, p);
    case topChatCategoryWebAppBots::ID:
      return topChatCategoryWebAppBots::fetch(env, p);
    case topChatCategoryCalls::ID:
      return topChatCategoryCalls::fetch(env, p);
    case topChatCategoryForwardChats::ID:
      return topChatCategoryForwardChats::fetch(env, p);
    case transactionDirectionIncoming::ID:
      return transactionDirectionIncoming::fetch(env, p);
    case transactionDirectionOutgoing::ID:
      return transactionDirectionOutgoing::fetch(env, p);
    case trendingStickerSets::ID:
      return trendingStickerSets::fetch(env, p);
    case unconfirmedSession::ID:
      return unconfirmedSession::fetch(env, p);
    case unreadReaction::ID:
      return unreadReaction::fetch(env, p);
    case updateAuthorizationState::ID:
      return updateAuthorizationState::fetch(env, p);
    case updateNewMessage::ID:
      return updateNewMessage::fetch(env, p);
    case updateMessageSendAcknowledged::ID:
      return updateMessageSendAcknowledged::fetch(env, p);
    case updateMessageSendSucceeded::ID:
      return updateMessageSendSucceeded::fetch(env, p);
    case updateMessageSendFailed::ID:
      return updateMessageSendFailed::fetch(env, p);
    case updateMessageContent::ID:
      return updateMessageContent::fetch(env, p);
    case updateMessageEdited::ID:
      return updateMessageEdited::fetch(env, p);
    case updateMessageIsPinned::ID:
      return updateMessageIsPinned::fetch(env, p);
    case updateMessageInteractionInfo::ID:
      return updateMessageInteractionInfo::fetch(env, p);
    case updateMessageContentOpened::ID:
      return updateMessageContentOpened::fetch(env, p);
    case updateMessageMentionRead::ID:
      return updateMessageMentionRead::fetch(env, p);
    case updateMessageUnreadReactions::ID:
      return updateMessageUnreadReactions::fetch(env, p);
    case updateMessageFactCheck::ID:
      return updateMessageFactCheck::fetch(env, p);
    case updateMessageSuggestedPostInfo::ID:
      return updateMessageSuggestedPostInfo::fetch(env, p);
    case updateMessageLiveLocationViewed::ID:
      return updateMessageLiveLocationViewed::fetch(env, p);
    case updateVideoPublished::ID:
      return updateVideoPublished::fetch(env, p);
    case updateNewChat::ID:
      return updateNewChat::fetch(env, p);
    case updateChatTitle::ID:
      return updateChatTitle::fetch(env, p);
    case updateChatPhoto::ID:
      return updateChatPhoto::fetch(env, p);
    case updateChatAccentColors::ID:
      return updateChatAccentColors::fetch(env, p);
    case updateChatPermissions::ID:
      return updateChatPermissions::fetch(env, p);
    case updateChatLastMessage::ID:
      return updateChatLastMessage::fetch(env, p);
    case updateChatPosition::ID:
      return updateChatPosition::fetch(env, p);
    case updateChatAddedToList::ID:
      return updateChatAddedToList::fetch(env, p);
    case updateChatRemovedFromList::ID:
      return updateChatRemovedFromList::fetch(env, p);
    case updateChatReadInbox::ID:
      return updateChatReadInbox::fetch(env, p);
    case updateChatReadOutbox::ID:
      return updateChatReadOutbox::fetch(env, p);
    case updateChatActionBar::ID:
      return updateChatActionBar::fetch(env, p);
    case updateChatBusinessBotManageBar::ID:
      return updateChatBusinessBotManageBar::fetch(env, p);
    case updateChatAvailableReactions::ID:
      return updateChatAvailableReactions::fetch(env, p);
    case updateChatDraftMessage::ID:
      return updateChatDraftMessage::fetch(env, p);
    case updateChatEmojiStatus::ID:
      return updateChatEmojiStatus::fetch(env, p);
    case updateChatMessageSender::ID:
      return updateChatMessageSender::fetch(env, p);
    case updateChatMessageAutoDeleteTime::ID:
      return updateChatMessageAutoDeleteTime::fetch(env, p);
    case updateChatNotificationSettings::ID:
      return updateChatNotificationSettings::fetch(env, p);
    case updateChatPendingJoinRequests::ID:
      return updateChatPendingJoinRequests::fetch(env, p);
    case updateChatReplyMarkup::ID:
      return updateChatReplyMarkup::fetch(env, p);
    case updateChatBackground::ID:
      return updateChatBackground::fetch(env, p);
    case updateChatTheme::ID:
      return updateChatTheme::fetch(env, p);
    case updateChatUnreadMentionCount::ID:
      return updateChatUnreadMentionCount::fetch(env, p);
    case updateChatUnreadReactionCount::ID:
      return updateChatUnreadReactionCount::fetch(env, p);
    case updateChatVideoChat::ID:
      return updateChatVideoChat::fetch(env, p);
    case updateChatDefaultDisableNotification::ID:
      return updateChatDefaultDisableNotification::fetch(env, p);
    case updateChatHasProtectedContent::ID:
      return updateChatHasProtectedContent::fetch(env, p);
    case updateChatIsTranslatable::ID:
      return updateChatIsTranslatable::fetch(env, p);
    case updateChatIsMarkedAsUnread::ID:
      return updateChatIsMarkedAsUnread::fetch(env, p);
    case updateChatViewAsTopics::ID:
      return updateChatViewAsTopics::fetch(env, p);
    case updateChatBlockList::ID:
      return updateChatBlockList::fetch(env, p);
    case updateChatHasScheduledMessages::ID:
      return updateChatHasScheduledMessages::fetch(env, p);
    case updateChatFolders::ID:
      return updateChatFolders::fetch(env, p);
    case updateChatOnlineMemberCount::ID:
      return updateChatOnlineMemberCount::fetch(env, p);
    case updateSavedMessagesTopic::ID:
      return updateSavedMessagesTopic::fetch(env, p);
    case updateSavedMessagesTopicCount::ID:
      return updateSavedMessagesTopicCount::fetch(env, p);
    case updateDirectMessagesChatTopic::ID:
      return updateDirectMessagesChatTopic::fetch(env, p);
    case updateTopicMessageCount::ID:
      return updateTopicMessageCount::fetch(env, p);
    case updateQuickReplyShortcut::ID:
      return updateQuickReplyShortcut::fetch(env, p);
    case updateQuickReplyShortcutDeleted::ID:
      return updateQuickReplyShortcutDeleted::fetch(env, p);
    case updateQuickReplyShortcuts::ID:
      return updateQuickReplyShortcuts::fetch(env, p);
    case updateQuickReplyShortcutMessages::ID:
      return updateQuickReplyShortcutMessages::fetch(env, p);
    case updateForumTopicInfo::ID:
      return updateForumTopicInfo::fetch(env, p);
    case updateForumTopic::ID:
      return updateForumTopic::fetch(env, p);
    case updateScopeNotificationSettings::ID:
      return updateScopeNotificationSettings::fetch(env, p);
    case updateReactionNotificationSettings::ID:
      return updateReactionNotificationSettings::fetch(env, p);
    case updateNotification::ID:
      return updateNotification::fetch(env, p);
    case updateNotificationGroup::ID:
      return updateNotificationGroup::fetch(env, p);
    case updateActiveNotifications::ID:
      return updateActiveNotifications::fetch(env, p);
    case updateHavePendingNotifications::ID:
      return updateHavePendingNotifications::fetch(env, p);
    case updateDeleteMessages::ID:
      return updateDeleteMessages::fetch(env, p);
    case updateChatAction::ID:
      return updateChatAction::fetch(env, p);
    case updateUserStatus::ID:
      return updateUserStatus::fetch(env, p);
    case updateUser::ID:
      return updateUser::fetch(env, p);
    case updateBasicGroup::ID:
      return updateBasicGroup::fetch(env, p);
    case updateSupergroup::ID:
      return updateSupergroup::fetch(env, p);
    case updateSecretChat::ID:
      return updateSecretChat::fetch(env, p);
    case updateUserFullInfo::ID:
      return updateUserFullInfo::fetch(env, p);
    case updateBasicGroupFullInfo::ID:
      return updateBasicGroupFullInfo::fetch(env, p);
    case updateSupergroupFullInfo::ID:
      return updateSupergroupFullInfo::fetch(env, p);
    case updateServiceNotification::ID:
      return updateServiceNotification::fetch(env, p);
    case updateFile::ID:
      return updateFile::fetch(env, p);
    case updateFileGenerationStart::ID:
      return updateFileGenerationStart::fetch(env, p);
    case updateFileGenerationStop::ID:
      return updateFileGenerationStop::fetch(env, p);
    case updateFileDownloads::ID:
      return updateFileDownloads::fetch(env, p);
    case updateFileAddedToDownloads::ID:
      return updateFileAddedToDownloads::fetch(env, p);
    case updateFileDownload::ID:
      return updateFileDownload::fetch(env, p);
    case updateFileRemovedFromDownloads::ID:
      return updateFileRemovedFromDownloads::fetch(env, p);
    case updateApplicationVerificationRequired::ID:
      return updateApplicationVerificationRequired::fetch(env, p);
    case updateApplicationRecaptchaVerificationRequired::ID:
      return updateApplicationRecaptchaVerificationRequired::fetch(env, p);
    case updateCall::ID:
      return updateCall::fetch(env, p);
    case updateGroupCall::ID:
      return updateGroupCall::fetch(env, p);
    case updateGroupCallParticipant::ID:
      return updateGroupCallParticipant::fetch(env, p);
    case updateGroupCallParticipants::ID:
      return updateGroupCallParticipants::fetch(env, p);
    case updateGroupCallVerificationState::ID:
      return updateGroupCallVerificationState::fetch(env, p);
    case updateNewCallSignalingData::ID:
      return updateNewCallSignalingData::fetch(env, p);
    case updateUserPrivacySettingRules::ID:
      return updateUserPrivacySettingRules::fetch(env, p);
    case updateUnreadMessageCount::ID:
      return updateUnreadMessageCount::fetch(env, p);
    case updateUnreadChatCount::ID:
      return updateUnreadChatCount::fetch(env, p);
    case updateStory::ID:
      return updateStory::fetch(env, p);
    case updateStoryDeleted::ID:
      return updateStoryDeleted::fetch(env, p);
    case updateStoryPostSucceeded::ID:
      return updateStoryPostSucceeded::fetch(env, p);
    case updateStoryPostFailed::ID:
      return updateStoryPostFailed::fetch(env, p);
    case updateChatActiveStories::ID:
      return updateChatActiveStories::fetch(env, p);
    case updateStoryListChatCount::ID:
      return updateStoryListChatCount::fetch(env, p);
    case updateStoryStealthMode::ID:
      return updateStoryStealthMode::fetch(env, p);
    case updateOption::ID:
      return updateOption::fetch(env, p);
    case updateStickerSet::ID:
      return updateStickerSet::fetch(env, p);
    case updateInstalledStickerSets::ID:
      return updateInstalledStickerSets::fetch(env, p);
    case updateTrendingStickerSets::ID:
      return updateTrendingStickerSets::fetch(env, p);
    case updateRecentStickers::ID:
      return updateRecentStickers::fetch(env, p);
    case updateFavoriteStickers::ID:
      return updateFavoriteStickers::fetch(env, p);
    case updateSavedAnimations::ID:
      return updateSavedAnimations::fetch(env, p);
    case updateSavedNotificationSounds::ID:
      return updateSavedNotificationSounds::fetch(env, p);
    case updateDefaultBackground::ID:
      return updateDefaultBackground::fetch(env, p);
    case updateChatThemes::ID:
      return updateChatThemes::fetch(env, p);
    case updateAccentColors::ID:
      return updateAccentColors::fetch(env, p);
    case updateProfileAccentColors::ID:
      return updateProfileAccentColors::fetch(env, p);
    case updateLanguagePackStrings::ID:
      return updateLanguagePackStrings::fetch(env, p);
    case updateConnectionState::ID:
      return updateConnectionState::fetch(env, p);
    case updateFreezeState::ID:
      return updateFreezeState::fetch(env, p);
    case updateTermsOfService::ID:
      return updateTermsOfService::fetch(env, p);
    case updateUnconfirmedSession::ID:
      return updateUnconfirmedSession::fetch(env, p);
    case updateAttachmentMenuBots::ID:
      return updateAttachmentMenuBots::fetch(env, p);
    case updateWebAppMessageSent::ID:
      return updateWebAppMessageSent::fetch(env, p);
    case updateActiveEmojiReactions::ID:
      return updateActiveEmojiReactions::fetch(env, p);
    case updateAvailableMessageEffects::ID:
      return updateAvailableMessageEffects::fetch(env, p);
    case updateDefaultReactionType::ID:
      return updateDefaultReactionType::fetch(env, p);
    case updateDefaultPaidReactionType::ID:
      return updateDefaultPaidReactionType::fetch(env, p);
    case updateSavedMessagesTags::ID:
      return updateSavedMessagesTags::fetch(env, p);
    case updateActiveLiveLocationMessages::ID:
      return updateActiveLiveLocationMessages::fetch(env, p);
    case updateOwnedStarCount::ID:
      return updateOwnedStarCount::fetch(env, p);
    case updateOwnedTonCount::ID:
      return updateOwnedTonCount::fetch(env, p);
    case updateChatRevenueAmount::ID:
      return updateChatRevenueAmount::fetch(env, p);
    case updateStarRevenueStatus::ID:
      return updateStarRevenueStatus::fetch(env, p);
    case updateSpeechRecognitionTrial::ID:
      return updateSpeechRecognitionTrial::fetch(env, p);
    case updateDiceEmojis::ID:
      return updateDiceEmojis::fetch(env, p);
    case updateAnimatedEmojiMessageClicked::ID:
      return updateAnimatedEmojiMessageClicked::fetch(env, p);
    case updateAnimationSearchParameters::ID:
      return updateAnimationSearchParameters::fetch(env, p);
    case updateSuggestedActions::ID:
      return updateSuggestedActions::fetch(env, p);
    case updateSpeedLimitNotification::ID:
      return updateSpeedLimitNotification::fetch(env, p);
    case updateContactCloseBirthdays::ID:
      return updateContactCloseBirthdays::fetch(env, p);
    case updateAutosaveSettings::ID:
      return updateAutosaveSettings::fetch(env, p);
    case updateBusinessConnection::ID:
      return updateBusinessConnection::fetch(env, p);
    case updateNewBusinessMessage::ID:
      return updateNewBusinessMessage::fetch(env, p);
    case updateBusinessMessageEdited::ID:
      return updateBusinessMessageEdited::fetch(env, p);
    case updateBusinessMessagesDeleted::ID:
      return updateBusinessMessagesDeleted::fetch(env, p);
    case updateNewInlineQuery::ID:
      return updateNewInlineQuery::fetch(env, p);
    case updateNewChosenInlineResult::ID:
      return updateNewChosenInlineResult::fetch(env, p);
    case updateNewCallbackQuery::ID:
      return updateNewCallbackQuery::fetch(env, p);
    case updateNewInlineCallbackQuery::ID:
      return updateNewInlineCallbackQuery::fetch(env, p);
    case updateNewBusinessCallbackQuery::ID:
      return updateNewBusinessCallbackQuery::fetch(env, p);
    case updateNewShippingQuery::ID:
      return updateNewShippingQuery::fetch(env, p);
    case updateNewPreCheckoutQuery::ID:
      return updateNewPreCheckoutQuery::fetch(env, p);
    case updateNewCustomEvent::ID:
      return updateNewCustomEvent::fetch(env, p);
    case updateNewCustomQuery::ID:
      return updateNewCustomQuery::fetch(env, p);
    case updatePoll::ID:
      return updatePoll::fetch(env, p);
    case updatePollAnswer::ID:
      return updatePollAnswer::fetch(env, p);
    case updateChatMember::ID:
      return updateChatMember::fetch(env, p);
    case updateNewChatJoinRequest::ID:
      return updateNewChatJoinRequest::fetch(env, p);
    case updateChatBoost::ID:
      return updateChatBoost::fetch(env, p);
    case updateMessageReaction::ID:
      return updateMessageReaction::fetch(env, p);
    case updateMessageReactions::ID:
      return updateMessageReactions::fetch(env, p);
    case updatePaidMediaPurchased::ID:
      return updatePaidMediaPurchased::fetch(env, p);
    case updates::ID:
      return updates::fetch(env, p);
    case upgradeGiftResult::ID:
      return upgradeGiftResult::fetch(env, p);
    case upgradedGift::ID:
      return upgradedGift::fetch(env, p);
    case upgradedGiftAttributeIdModel::ID:
      return upgradedGiftAttributeIdModel::fetch(env, p);
    case upgradedGiftAttributeIdSymbol::ID:
      return upgradedGiftAttributeIdSymbol::fetch(env, p);
    case upgradedGiftAttributeIdBackdrop::ID:
      return upgradedGiftAttributeIdBackdrop::fetch(env, p);
    case upgradedGiftBackdrop::ID:
      return upgradedGiftBackdrop::fetch(env, p);
    case upgradedGiftBackdropColors::ID:
      return upgradedGiftBackdropColors::fetch(env, p);
    case upgradedGiftBackdropCount::ID:
      return upgradedGiftBackdropCount::fetch(env, p);
    case upgradedGiftModel::ID:
      return upgradedGiftModel::fetch(env, p);
    case upgradedGiftModelCount::ID:
      return upgradedGiftModelCount::fetch(env, p);
    case upgradedGiftOriginUpgrade::ID:
      return upgradedGiftOriginUpgrade::fetch(env, p);
    case upgradedGiftOriginTransfer::ID:
      return upgradedGiftOriginTransfer::fetch(env, p);
    case upgradedGiftOriginResale::ID:
      return upgradedGiftOriginResale::fetch(env, p);
    case upgradedGiftOriginalDetails::ID:
      return upgradedGiftOriginalDetails::fetch(env, p);
    case upgradedGiftSymbol::ID:
      return upgradedGiftSymbol::fetch(env, p);
    case upgradedGiftSymbolCount::ID:
      return upgradedGiftSymbolCount::fetch(env, p);
    case user::ID:
      return user::fetch(env, p);
    case userFullInfo::ID:
      return userFullInfo::fetch(env, p);
    case userLink::ID:
      return userLink::fetch(env, p);
    case userPrivacySettingShowStatus::ID:
      return userPrivacySettingShowStatus::fetch(env, p);
    case userPrivacySettingShowProfilePhoto::ID:
      return userPrivacySettingShowProfilePhoto::fetch(env, p);
    case userPrivacySettingShowLinkInForwardedMessages::ID:
      return userPrivacySettingShowLinkInForwardedMessages::fetch(env, p);
    case userPrivacySettingShowPhoneNumber::ID:
      return userPrivacySettingShowPhoneNumber::fetch(env, p);
    case userPrivacySettingShowBio::ID:
      return userPrivacySettingShowBio::fetch(env, p);
    case userPrivacySettingShowBirthdate::ID:
      return userPrivacySettingShowBirthdate::fetch(env, p);
    case userPrivacySettingAllowChatInvites::ID:
      return userPrivacySettingAllowChatInvites::fetch(env, p);
    case userPrivacySettingAllowCalls::ID:
      return userPrivacySettingAllowCalls::fetch(env, p);
    case userPrivacySettingAllowPeerToPeerCalls::ID:
      return userPrivacySettingAllowPeerToPeerCalls::fetch(env, p);
    case userPrivacySettingAllowFindingByPhoneNumber::ID:
      return userPrivacySettingAllowFindingByPhoneNumber::fetch(env, p);
    case userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages::ID:
      return userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages::fetch(env, p);
    case userPrivacySettingAutosaveGifts::ID:
      return userPrivacySettingAutosaveGifts::fetch(env, p);
    case userPrivacySettingAllowUnpaidMessages::ID:
      return userPrivacySettingAllowUnpaidMessages::fetch(env, p);
    case userPrivacySettingRuleAllowAll::ID:
      return userPrivacySettingRuleAllowAll::fetch(env, p);
    case userPrivacySettingRuleAllowContacts::ID:
      return userPrivacySettingRuleAllowContacts::fetch(env, p);
    case userPrivacySettingRuleAllowBots::ID:
      return userPrivacySettingRuleAllowBots::fetch(env, p);
    case userPrivacySettingRuleAllowPremiumUsers::ID:
      return userPrivacySettingRuleAllowPremiumUsers::fetch(env, p);
    case userPrivacySettingRuleAllowUsers::ID:
      return userPrivacySettingRuleAllowUsers::fetch(env, p);
    case userPrivacySettingRuleAllowChatMembers::ID:
      return userPrivacySettingRuleAllowChatMembers::fetch(env, p);
    case userPrivacySettingRuleRestrictAll::ID:
      return userPrivacySettingRuleRestrictAll::fetch(env, p);
    case userPrivacySettingRuleRestrictContacts::ID:
      return userPrivacySettingRuleRestrictContacts::fetch(env, p);
    case userPrivacySettingRuleRestrictBots::ID:
      return userPrivacySettingRuleRestrictBots::fetch(env, p);
    case userPrivacySettingRuleRestrictUsers::ID:
      return userPrivacySettingRuleRestrictUsers::fetch(env, p);
    case userPrivacySettingRuleRestrictChatMembers::ID:
      return userPrivacySettingRuleRestrictChatMembers::fetch(env, p);
    case userPrivacySettingRules::ID:
      return userPrivacySettingRules::fetch(env, p);
    case userStatusEmpty::ID:
      return userStatusEmpty::fetch(env, p);
    case userStatusOnline::ID:
      return userStatusOnline::fetch(env, p);
    case userStatusOffline::ID:
      return userStatusOffline::fetch(env, p);
    case userStatusRecently::ID:
      return userStatusRecently::fetch(env, p);
    case userStatusLastWeek::ID:
      return userStatusLastWeek::fetch(env, p);
    case userStatusLastMonth::ID:
      return userStatusLastMonth::fetch(env, p);
    case userSupportInfo::ID:
      return userSupportInfo::fetch(env, p);
    case userTypeRegular::ID:
      return userTypeRegular::fetch(env, p);
    case userTypeDeleted::ID:
      return userTypeDeleted::fetch(env, p);
    case userTypeBot::ID:
      return userTypeBot::fetch(env, p);
    case userTypeUnknown::ID:
      return userTypeUnknown::fetch(env, p);
    case usernames::ID:
      return usernames::fetch(env, p);
    case users::ID:
      return users::fetch(env, p);
    case validatedOrderInfo::ID:
      return validatedOrderInfo::fetch(env, p);
    case vectorPathCommandLine::ID:
      return vectorPathCommandLine::fetch(env, p);
    case vectorPathCommandCubicBezierCurve::ID:
      return vectorPathCommandCubicBezierCurve::fetch(env, p);
    case venue::ID:
      return venue::fetch(env, p);
    case verificationStatus::ID:
      return verificationStatus::fetch(env, p);
    case video::ID:
      return video::fetch(env, p);
    case videoChat::ID:
      return videoChat::fetch(env, p);
    case videoChatStream::ID:
      return videoChatStream::fetch(env, p);
    case videoChatStreams::ID:
      return videoChatStreams::fetch(env, p);
    case videoMessageAdvertisement::ID:
      return videoMessageAdvertisement::fetch(env, p);
    case videoMessageAdvertisements::ID:
      return videoMessageAdvertisements::fetch(env, p);
    case videoNote::ID:
      return videoNote::fetch(env, p);
    case videoStoryboard::ID:
      return videoStoryboard::fetch(env, p);
    case voiceNote::ID:
      return voiceNote::fetch(env, p);
    case webApp::ID:
      return webApp::fetch(env, p);
    case webAppInfo::ID:
      return webAppInfo::fetch(env, p);
    case webAppOpenModeCompact::ID:
      return webAppOpenModeCompact::fetch(env, p);
    case webAppOpenModeFullSize::ID:
      return webAppOpenModeFullSize::fetch(env, p);
    case webAppOpenModeFullScreen::ID:
      return webAppOpenModeFullScreen::fetch(env, p);
    case webAppOpenParameters::ID:
      return webAppOpenParameters::fetch(env, p);
    case webPageInstantView::ID:
      return webPageInstantView::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void Object::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Object").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass Function::Class;

object_ptr<Function> Function::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case acceptCall::ID:
      return acceptCall::fetch(env, p);
    case acceptTermsOfService::ID:
      return acceptTermsOfService::fetch(env, p);
    case activateStoryStealthMode::ID:
      return activateStoryStealthMode::fetch(env, p);
    case addBotMediaPreview::ID:
      return addBotMediaPreview::fetch(env, p);
    case addChatFolderByInviteLink::ID:
      return addChatFolderByInviteLink::fetch(env, p);
    case addChatMember::ID:
      return addChatMember::fetch(env, p);
    case addChatMembers::ID:
      return addChatMembers::fetch(env, p);
    case addChatToList::ID:
      return addChatToList::fetch(env, p);
    case addChecklistTasks::ID:
      return addChecklistTasks::fetch(env, p);
    case addContact::ID:
      return addContact::fetch(env, p);
    case addCustomServerLanguagePack::ID:
      return addCustomServerLanguagePack::fetch(env, p);
    case addFavoriteSticker::ID:
      return addFavoriteSticker::fetch(env, p);
    case addFileToDownloads::ID:
      return addFileToDownloads::fetch(env, p);
    case addLocalMessage::ID:
      return addLocalMessage::fetch(env, p);
    case addLogMessage::ID:
      return addLogMessage::fetch(env, p);
    case addMessageReaction::ID:
      return addMessageReaction::fetch(env, p);
    case addNetworkStatistics::ID:
      return addNetworkStatistics::fetch(env, p);
    case addOffer::ID:
      return addOffer::fetch(env, p);
    case addPendingPaidMessageReaction::ID:
      return addPendingPaidMessageReaction::fetch(env, p);
    case addProxy::ID:
      return addProxy::fetch(env, p);
    case addQuickReplyShortcutInlineQueryResultMessage::ID:
      return addQuickReplyShortcutInlineQueryResultMessage::fetch(env, p);
    case addQuickReplyShortcutMessage::ID:
      return addQuickReplyShortcutMessage::fetch(env, p);
    case addQuickReplyShortcutMessageAlbum::ID:
      return addQuickReplyShortcutMessageAlbum::fetch(env, p);
    case addRecentSticker::ID:
      return addRecentSticker::fetch(env, p);
    case addRecentlyFoundChat::ID:
      return addRecentlyFoundChat::fetch(env, p);
    case addSavedAnimation::ID:
      return addSavedAnimation::fetch(env, p);
    case addSavedNotificationSound::ID:
      return addSavedNotificationSound::fetch(env, p);
    case addStickerToSet::ID:
      return addStickerToSet::fetch(env, p);
    case allowBotToSendMessages::ID:
      return allowBotToSendMessages::fetch(env, p);
    case allowUnpaidMessagesFromUser::ID:
      return allowUnpaidMessagesFromUser::fetch(env, p);
    case answerCallbackQuery::ID:
      return answerCallbackQuery::fetch(env, p);
    case answerCustomQuery::ID:
      return answerCustomQuery::fetch(env, p);
    case answerInlineQuery::ID:
      return answerInlineQuery::fetch(env, p);
    case answerPreCheckoutQuery::ID:
      return answerPreCheckoutQuery::fetch(env, p);
    case answerShippingQuery::ID:
      return answerShippingQuery::fetch(env, p);
    case answerWebAppQuery::ID:
      return answerWebAppQuery::fetch(env, p);
    case applyPremiumGiftCode::ID:
      return applyPremiumGiftCode::fetch(env, p);
    case approveSuggestedPost::ID:
      return approveSuggestedPost::fetch(env, p);
    case assignStoreTransaction::ID:
      return assignStoreTransaction::fetch(env, p);
    case banChatMember::ID:
      return banChatMember::fetch(env, p);
    case banGroupCallParticipants::ID:
      return banGroupCallParticipants::fetch(env, p);
    case blockMessageSenderFromReplies::ID:
      return blockMessageSenderFromReplies::fetch(env, p);
    case boostChat::ID:
      return boostChat::fetch(env, p);
    case canBotSendMessages::ID:
      return canBotSendMessages::fetch(env, p);
    case canPostStory::ID:
      return canPostStory::fetch(env, p);
    case canPurchaseFromStore::ID:
      return canPurchaseFromStore::fetch(env, p);
    case canSendMessageToUser::ID:
      return canSendMessageToUser::fetch(env, p);
    case canTransferOwnership::ID:
      return canTransferOwnership::fetch(env, p);
    case cancelDownloadFile::ID:
      return cancelDownloadFile::fetch(env, p);
    case cancelPasswordReset::ID:
      return cancelPasswordReset::fetch(env, p);
    case cancelPreliminaryUploadFile::ID:
      return cancelPreliminaryUploadFile::fetch(env, p);
    case cancelRecoveryEmailAddressVerification::ID:
      return cancelRecoveryEmailAddressVerification::fetch(env, p);
    case changeImportedContacts::ID:
      return changeImportedContacts::fetch(env, p);
    case changeStickerSet::ID:
      return changeStickerSet::fetch(env, p);
    case checkAuthenticationBotToken::ID:
      return checkAuthenticationBotToken::fetch(env, p);
    case checkAuthenticationCode::ID:
      return checkAuthenticationCode::fetch(env, p);
    case checkAuthenticationEmailCode::ID:
      return checkAuthenticationEmailCode::fetch(env, p);
    case checkAuthenticationPassword::ID:
      return checkAuthenticationPassword::fetch(env, p);
    case checkAuthenticationPasswordRecoveryCode::ID:
      return checkAuthenticationPasswordRecoveryCode::fetch(env, p);
    case checkAuthenticationPremiumPurchase::ID:
      return checkAuthenticationPremiumPurchase::fetch(env, p);
    case checkChatFolderInviteLink::ID:
      return checkChatFolderInviteLink::fetch(env, p);
    case checkChatInviteLink::ID:
      return checkChatInviteLink::fetch(env, p);
    case checkChatUsername::ID:
      return checkChatUsername::fetch(env, p);
    case checkCreatedPublicChatsLimit::ID:
      return checkCreatedPublicChatsLimit::fetch(env, p);
    case checkEmailAddressVerificationCode::ID:
      return checkEmailAddressVerificationCode::fetch(env, p);
    case checkLoginEmailAddressCode::ID:
      return checkLoginEmailAddressCode::fetch(env, p);
    case checkPasswordRecoveryCode::ID:
      return checkPasswordRecoveryCode::fetch(env, p);
    case checkPhoneNumberCode::ID:
      return checkPhoneNumberCode::fetch(env, p);
    case checkPremiumGiftCode::ID:
      return checkPremiumGiftCode::fetch(env, p);
    case checkQuickReplyShortcutName::ID:
      return checkQuickReplyShortcutName::fetch(env, p);
    case checkRecoveryEmailAddressCode::ID:
      return checkRecoveryEmailAddressCode::fetch(env, p);
    case checkStickerSetName::ID:
      return checkStickerSetName::fetch(env, p);
    case checkWebAppFileDownload::ID:
      return checkWebAppFileDownload::fetch(env, p);
    case cleanFileName::ID:
      return cleanFileName::fetch(env, p);
    case clearAllDraftMessages::ID:
      return clearAllDraftMessages::fetch(env, p);
    case clearAutosaveSettingsExceptions::ID:
      return clearAutosaveSettingsExceptions::fetch(env, p);
    case clearImportedContacts::ID:
      return clearImportedContacts::fetch(env, p);
    case clearRecentEmojiStatuses::ID:
      return clearRecentEmojiStatuses::fetch(env, p);
    case clearRecentReactions::ID:
      return clearRecentReactions::fetch(env, p);
    case clearRecentStickers::ID:
      return clearRecentStickers::fetch(env, p);
    case clearRecentlyFoundChats::ID:
      return clearRecentlyFoundChats::fetch(env, p);
    case clearSearchedForTags::ID:
      return clearSearchedForTags::fetch(env, p);
    case clickAnimatedEmojiMessage::ID:
      return clickAnimatedEmojiMessage::fetch(env, p);
    case clickChatSponsoredMessage::ID:
      return clickChatSponsoredMessage::fetch(env, p);
    case clickPremiumSubscriptionButton::ID:
      return clickPremiumSubscriptionButton::fetch(env, p);
    case clickVideoMessageAdvertisement::ID:
      return clickVideoMessageAdvertisement::fetch(env, p);
    case close::ID:
      return close::fetch(env, p);
    case closeChat::ID:
      return closeChat::fetch(env, p);
    case closeSecretChat::ID:
      return closeSecretChat::fetch(env, p);
    case closeStory::ID:
      return closeStory::fetch(env, p);
    case closeWebApp::ID:
      return closeWebApp::fetch(env, p);
    case commitPendingPaidMessageReactions::ID:
      return commitPendingPaidMessageReactions::fetch(env, p);
    case confirmQrCodeAuthentication::ID:
      return confirmQrCodeAuthentication::fetch(env, p);
    case confirmSession::ID:
      return confirmSession::fetch(env, p);
    case connectAffiliateProgram::ID:
      return connectAffiliateProgram::fetch(env, p);
    case createBasicGroupChat::ID:
      return createBasicGroupChat::fetch(env, p);
    case createBusinessChatLink::ID:
      return createBusinessChatLink::fetch(env, p);
    case createCall::ID:
      return createCall::fetch(env, p);
    case createChatFolder::ID:
      return createChatFolder::fetch(env, p);
    case createChatFolderInviteLink::ID:
      return createChatFolderInviteLink::fetch(env, p);
    case createChatInviteLink::ID:
      return createChatInviteLink::fetch(env, p);
    case createChatSubscriptionInviteLink::ID:
      return createChatSubscriptionInviteLink::fetch(env, p);
    case createForumTopic::ID:
      return createForumTopic::fetch(env, p);
    case createGroupCall::ID:
      return createGroupCall::fetch(env, p);
    case createInvoiceLink::ID:
      return createInvoiceLink::fetch(env, p);
    case createNewBasicGroupChat::ID:
      return createNewBasicGroupChat::fetch(env, p);
    case createNewSecretChat::ID:
      return createNewSecretChat::fetch(env, p);
    case createNewStickerSet::ID:
      return createNewStickerSet::fetch(env, p);
    case createNewSupergroupChat::ID:
      return createNewSupergroupChat::fetch(env, p);
    case createPrivateChat::ID:
      return createPrivateChat::fetch(env, p);
    case createSecretChat::ID:
      return createSecretChat::fetch(env, p);
    case createSupergroupChat::ID:
      return createSupergroupChat::fetch(env, p);
    case createTemporaryPassword::ID:
      return createTemporaryPassword::fetch(env, p);
    case createVideoChat::ID:
      return createVideoChat::fetch(env, p);
    case declineGroupCallInvitation::ID:
      return declineGroupCallInvitation::fetch(env, p);
    case declineSuggestedPost::ID:
      return declineSuggestedPost::fetch(env, p);
    case decryptGroupCallData::ID:
      return decryptGroupCallData::fetch(env, p);
    case deleteAccount::ID:
      return deleteAccount::fetch(env, p);
    case deleteAllCallMessages::ID:
      return deleteAllCallMessages::fetch(env, p);
    case deleteAllRevokedChatInviteLinks::ID:
      return deleteAllRevokedChatInviteLinks::fetch(env, p);
    case deleteBotMediaPreviews::ID:
      return deleteBotMediaPreviews::fetch(env, p);
    case deleteBusinessChatLink::ID:
      return deleteBusinessChatLink::fetch(env, p);
    case deleteBusinessConnectedBot::ID:
      return deleteBusinessConnectedBot::fetch(env, p);
    case deleteBusinessMessages::ID:
      return deleteBusinessMessages::fetch(env, p);
    case deleteBusinessStory::ID:
      return deleteBusinessStory::fetch(env, p);
    case deleteChat::ID:
      return deleteChat::fetch(env, p);
    case deleteChatBackground::ID:
      return deleteChatBackground::fetch(env, p);
    case deleteChatFolder::ID:
      return deleteChatFolder::fetch(env, p);
    case deleteChatFolderInviteLink::ID:
      return deleteChatFolderInviteLink::fetch(env, p);
    case deleteChatHistory::ID:
      return deleteChatHistory::fetch(env, p);
    case deleteChatMessagesByDate::ID:
      return deleteChatMessagesByDate::fetch(env, p);
    case deleteChatMessagesBySender::ID:
      return deleteChatMessagesBySender::fetch(env, p);
    case deleteChatReplyMarkup::ID:
      return deleteChatReplyMarkup::fetch(env, p);
    case deleteCommands::ID:
      return deleteCommands::fetch(env, p);
    case deleteDefaultBackground::ID:
      return deleteDefaultBackground::fetch(env, p);
    case deleteDirectMessagesChatTopicHistory::ID:
      return deleteDirectMessagesChatTopicHistory::fetch(env, p);
    case deleteDirectMessagesChatTopicMessagesByDate::ID:
      return deleteDirectMessagesChatTopicMessagesByDate::fetch(env, p);
    case deleteFile::ID:
      return deleteFile::fetch(env, p);
    case deleteForumTopic::ID:
      return deleteForumTopic::fetch(env, p);
    case deleteLanguagePack::ID:
      return deleteLanguagePack::fetch(env, p);
    case deleteMessages::ID:
      return deleteMessages::fetch(env, p);
    case deletePassportElement::ID:
      return deletePassportElement::fetch(env, p);
    case deleteProfilePhoto::ID:
      return deleteProfilePhoto::fetch(env, p);
    case deleteQuickReplyShortcut::ID:
      return deleteQuickReplyShortcut::fetch(env, p);
    case deleteQuickReplyShortcutMessages::ID:
      return deleteQuickReplyShortcutMessages::fetch(env, p);
    case deleteRevokedChatInviteLink::ID:
      return deleteRevokedChatInviteLink::fetch(env, p);
    case deleteSavedCredentials::ID:
      return deleteSavedCredentials::fetch(env, p);
    case deleteSavedMessagesTopicHistory::ID:
      return deleteSavedMessagesTopicHistory::fetch(env, p);
    case deleteSavedMessagesTopicMessagesByDate::ID:
      return deleteSavedMessagesTopicMessagesByDate::fetch(env, p);
    case deleteSavedOrderInfo::ID:
      return deleteSavedOrderInfo::fetch(env, p);
    case deleteStickerSet::ID:
      return deleteStickerSet::fetch(env, p);
    case deleteStory::ID:
      return deleteStory::fetch(env, p);
    case destroy::ID:
      return destroy::fetch(env, p);
    case disableAllSupergroupUsernames::ID:
      return disableAllSupergroupUsernames::fetch(env, p);
    case disableProxy::ID:
      return disableProxy::fetch(env, p);
    case discardCall::ID:
      return discardCall::fetch(env, p);
    case disconnectAffiliateProgram::ID:
      return disconnectAffiliateProgram::fetch(env, p);
    case disconnectAllWebsites::ID:
      return disconnectAllWebsites::fetch(env, p);
    case disconnectWebsite::ID:
      return disconnectWebsite::fetch(env, p);
    case downloadFile::ID:
      return downloadFile::fetch(env, p);
    case editBotMediaPreview::ID:
      return editBotMediaPreview::fetch(env, p);
    case editBusinessChatLink::ID:
      return editBusinessChatLink::fetch(env, p);
    case editBusinessMessageCaption::ID:
      return editBusinessMessageCaption::fetch(env, p);
    case editBusinessMessageChecklist::ID:
      return editBusinessMessageChecklist::fetch(env, p);
    case editBusinessMessageLiveLocation::ID:
      return editBusinessMessageLiveLocation::fetch(env, p);
    case editBusinessMessageMedia::ID:
      return editBusinessMessageMedia::fetch(env, p);
    case editBusinessMessageReplyMarkup::ID:
      return editBusinessMessageReplyMarkup::fetch(env, p);
    case editBusinessMessageText::ID:
      return editBusinessMessageText::fetch(env, p);
    case editBusinessStory::ID:
      return editBusinessStory::fetch(env, p);
    case editChatFolder::ID:
      return editChatFolder::fetch(env, p);
    case editChatFolderInviteLink::ID:
      return editChatFolderInviteLink::fetch(env, p);
    case editChatInviteLink::ID:
      return editChatInviteLink::fetch(env, p);
    case editChatSubscriptionInviteLink::ID:
      return editChatSubscriptionInviteLink::fetch(env, p);
    case editCustomLanguagePackInfo::ID:
      return editCustomLanguagePackInfo::fetch(env, p);
    case editForumTopic::ID:
      return editForumTopic::fetch(env, p);
    case editInlineMessageCaption::ID:
      return editInlineMessageCaption::fetch(env, p);
    case editInlineMessageLiveLocation::ID:
      return editInlineMessageLiveLocation::fetch(env, p);
    case editInlineMessageMedia::ID:
      return editInlineMessageMedia::fetch(env, p);
    case editInlineMessageReplyMarkup::ID:
      return editInlineMessageReplyMarkup::fetch(env, p);
    case editInlineMessageText::ID:
      return editInlineMessageText::fetch(env, p);
    case editMessageCaption::ID:
      return editMessageCaption::fetch(env, p);
    case editMessageChecklist::ID:
      return editMessageChecklist::fetch(env, p);
    case editMessageLiveLocation::ID:
      return editMessageLiveLocation::fetch(env, p);
    case editMessageMedia::ID:
      return editMessageMedia::fetch(env, p);
    case editMessageReplyMarkup::ID:
      return editMessageReplyMarkup::fetch(env, p);
    case editMessageSchedulingState::ID:
      return editMessageSchedulingState::fetch(env, p);
    case editMessageText::ID:
      return editMessageText::fetch(env, p);
    case editProxy::ID:
      return editProxy::fetch(env, p);
    case editQuickReplyMessage::ID:
      return editQuickReplyMessage::fetch(env, p);
    case editStarSubscription::ID:
      return editStarSubscription::fetch(env, p);
    case editStory::ID:
      return editStory::fetch(env, p);
    case editStoryCover::ID:
      return editStoryCover::fetch(env, p);
    case editUserStarSubscription::ID:
      return editUserStarSubscription::fetch(env, p);
    case enableProxy::ID:
      return enableProxy::fetch(env, p);
    case encryptGroupCallData::ID:
      return encryptGroupCallData::fetch(env, p);
    case endGroupCall::ID:
      return endGroupCall::fetch(env, p);
    case endGroupCallRecording::ID:
      return endGroupCallRecording::fetch(env, p);
    case endGroupCallScreenSharing::ID:
      return endGroupCallScreenSharing::fetch(env, p);
    case finishFileGeneration::ID:
      return finishFileGeneration::fetch(env, p);
    case forwardMessages::ID:
      return forwardMessages::fetch(env, p);
    case getAccountTtl::ID:
      return getAccountTtl::fetch(env, p);
    case getActiveSessions::ID:
      return getActiveSessions::fetch(env, p);
    case getAllPassportElements::ID:
      return getAllPassportElements::fetch(env, p);
    case getAllStickerEmojis::ID:
      return getAllStickerEmojis::fetch(env, p);
    case getAnimatedEmoji::ID:
      return getAnimatedEmoji::fetch(env, p);
    case getApplicationConfig::ID:
      return getApplicationConfig::fetch(env, p);
    case getApplicationDownloadLink::ID:
      return getApplicationDownloadLink::fetch(env, p);
    case getArchiveChatListSettings::ID:
      return getArchiveChatListSettings::fetch(env, p);
    case getArchivedStickerSets::ID:
      return getArchivedStickerSets::fetch(env, p);
    case getAttachedStickerSets::ID:
      return getAttachedStickerSets::fetch(env, p);
    case getAttachmentMenuBot::ID:
      return getAttachmentMenuBot::fetch(env, p);
    case getAuthorizationState::ID:
      return getAuthorizationState::fetch(env, p);
    case getAutoDownloadSettingsPresets::ID:
      return getAutoDownloadSettingsPresets::fetch(env, p);
    case getAutosaveSettings::ID:
      return getAutosaveSettings::fetch(env, p);
    case getAvailableChatBoostSlots::ID:
      return getAvailableChatBoostSlots::fetch(env, p);
    case getAvailableGifts::ID:
      return getAvailableGifts::fetch(env, p);
    case getBackgroundUrl::ID:
      return getBackgroundUrl::fetch(env, p);
    case getBankCardInfo::ID:
      return getBankCardInfo::fetch(env, p);
    case getBasicGroup::ID:
      return getBasicGroup::fetch(env, p);
    case getBasicGroupFullInfo::ID:
      return getBasicGroupFullInfo::fetch(env, p);
    case getBlockedMessageSenders::ID:
      return getBlockedMessageSenders::fetch(env, p);
    case getBotInfoDescription::ID:
      return getBotInfoDescription::fetch(env, p);
    case getBotInfoShortDescription::ID:
      return getBotInfoShortDescription::fetch(env, p);
    case getBotMediaPreviewInfo::ID:
      return getBotMediaPreviewInfo::fetch(env, p);
    case getBotMediaPreviews::ID:
      return getBotMediaPreviews::fetch(env, p);
    case getBotName::ID:
      return getBotName::fetch(env, p);
    case getBotSimilarBotCount::ID:
      return getBotSimilarBotCount::fetch(env, p);
    case getBotSimilarBots::ID:
      return getBotSimilarBots::fetch(env, p);
    case getBusinessAccountStarAmount::ID:
      return getBusinessAccountStarAmount::fetch(env, p);
    case getBusinessChatLinkInfo::ID:
      return getBusinessChatLinkInfo::fetch(env, p);
    case getBusinessChatLinks::ID:
      return getBusinessChatLinks::fetch(env, p);
    case getBusinessConnectedBot::ID:
      return getBusinessConnectedBot::fetch(env, p);
    case getBusinessConnection::ID:
      return getBusinessConnection::fetch(env, p);
    case getBusinessFeatures::ID:
      return getBusinessFeatures::fetch(env, p);
    case getCallbackQueryAnswer::ID:
      return getCallbackQueryAnswer::fetch(env, p);
    case getCallbackQueryMessage::ID:
      return getCallbackQueryMessage::fetch(env, p);
    case getChat::ID:
      return getChat::fetch(env, p);
    case getChatActiveStories::ID:
      return getChatActiveStories::fetch(env, p);
    case getChatAdministrators::ID:
      return getChatAdministrators::fetch(env, p);
    case getChatArchivedStories::ID:
      return getChatArchivedStories::fetch(env, p);
    case getChatAvailableMessageSenders::ID:
      return getChatAvailableMessageSenders::fetch(env, p);
    case getChatAvailablePaidMessageReactionSenders::ID:
      return getChatAvailablePaidMessageReactionSenders::fetch(env, p);
    case getChatBoostFeatures::ID:
      return getChatBoostFeatures::fetch(env, p);
    case getChatBoostLevelFeatures::ID:
      return getChatBoostLevelFeatures::fetch(env, p);
    case getChatBoostLink::ID:
      return getChatBoostLink::fetch(env, p);
    case getChatBoostLinkInfo::ID:
      return getChatBoostLinkInfo::fetch(env, p);
    case getChatBoostStatus::ID:
      return getChatBoostStatus::fetch(env, p);
    case getChatBoosts::ID:
      return getChatBoosts::fetch(env, p);
    case getChatEventLog::ID:
      return getChatEventLog::fetch(env, p);
    case getChatFolder::ID:
      return getChatFolder::fetch(env, p);
    case getChatFolderChatCount::ID:
      return getChatFolderChatCount::fetch(env, p);
    case getChatFolderChatsToLeave::ID:
      return getChatFolderChatsToLeave::fetch(env, p);
    case getChatFolderDefaultIconName::ID:
      return getChatFolderDefaultIconName::fetch(env, p);
    case getChatFolderInviteLinks::ID:
      return getChatFolderInviteLinks::fetch(env, p);
    case getChatFolderNewChats::ID:
      return getChatFolderNewChats::fetch(env, p);
    case getChatHistory::ID:
      return getChatHistory::fetch(env, p);
    case getChatInviteLink::ID:
      return getChatInviteLink::fetch(env, p);
    case getChatInviteLinkCounts::ID:
      return getChatInviteLinkCounts::fetch(env, p);
    case getChatInviteLinkMembers::ID:
      return getChatInviteLinkMembers::fetch(env, p);
    case getChatInviteLinks::ID:
      return getChatInviteLinks::fetch(env, p);
    case getChatJoinRequests::ID:
      return getChatJoinRequests::fetch(env, p);
    case getChatListsToAddChat::ID:
      return getChatListsToAddChat::fetch(env, p);
    case getChatMember::ID:
      return getChatMember::fetch(env, p);
    case getChatMessageByDate::ID:
      return getChatMessageByDate::fetch(env, p);
    case getChatMessageCalendar::ID:
      return getChatMessageCalendar::fetch(env, p);
    case getChatMessageCount::ID:
      return getChatMessageCount::fetch(env, p);
    case getChatMessagePosition::ID:
      return getChatMessagePosition::fetch(env, p);
    case getChatNotificationSettingsExceptions::ID:
      return getChatNotificationSettingsExceptions::fetch(env, p);
    case getChatPinnedMessage::ID:
      return getChatPinnedMessage::fetch(env, p);
    case getChatPostedToChatPageStories::ID:
      return getChatPostedToChatPageStories::fetch(env, p);
    case getChatRevenueStatistics::ID:
      return getChatRevenueStatistics::fetch(env, p);
    case getChatRevenueTransactions::ID:
      return getChatRevenueTransactions::fetch(env, p);
    case getChatRevenueWithdrawalUrl::ID:
      return getChatRevenueWithdrawalUrl::fetch(env, p);
    case getChatScheduledMessages::ID:
      return getChatScheduledMessages::fetch(env, p);
    case getChatSimilarChatCount::ID:
      return getChatSimilarChatCount::fetch(env, p);
    case getChatSimilarChats::ID:
      return getChatSimilarChats::fetch(env, p);
    case getChatSparseMessagePositions::ID:
      return getChatSparseMessagePositions::fetch(env, p);
    case getChatSponsoredMessages::ID:
      return getChatSponsoredMessages::fetch(env, p);
    case getChatStatistics::ID:
      return getChatStatistics::fetch(env, p);
    case getChatStoryInteractions::ID:
      return getChatStoryInteractions::fetch(env, p);
    case getChats::ID:
      return getChats::fetch(env, p);
    case getChatsForChatFolderInviteLink::ID:
      return getChatsForChatFolderInviteLink::fetch(env, p);
    case getChatsToPostStories::ID:
      return getChatsToPostStories::fetch(env, p);
    case getCloseFriends::ID:
      return getCloseFriends::fetch(env, p);
    case getCollectibleItemInfo::ID:
      return getCollectibleItemInfo::fetch(env, p);
    case getCommands::ID:
      return getCommands::fetch(env, p);
    case getConnectedAffiliateProgram::ID:
      return getConnectedAffiliateProgram::fetch(env, p);
    case getConnectedAffiliatePrograms::ID:
      return getConnectedAffiliatePrograms::fetch(env, p);
    case getConnectedWebsites::ID:
      return getConnectedWebsites::fetch(env, p);
    case getContacts::ID:
      return getContacts::fetch(env, p);
    case getCountries::ID:
      return getCountries::fetch(env, p);
    case getCountryCode::ID:
      return getCountryCode::fetch(env, p);
    case getCountryFlagEmoji::ID:
      return getCountryFlagEmoji::fetch(env, p);
    case getCreatedPublicChats::ID:
      return getCreatedPublicChats::fetch(env, p);
    case getCurrentState::ID:
      return getCurrentState::fetch(env, p);
    case getCurrentWeather::ID:
      return getCurrentWeather::fetch(env, p);
    case getCustomEmojiReactionAnimations::ID:
      return getCustomEmojiReactionAnimations::fetch(env, p);
    case getCustomEmojiStickers::ID:
      return getCustomEmojiStickers::fetch(env, p);
    case getDatabaseStatistics::ID:
      return getDatabaseStatistics::fetch(env, p);
    case getDeepLinkInfo::ID:
      return getDeepLinkInfo::fetch(env, p);
    case getDefaultBackgroundCustomEmojiStickers::ID:
      return getDefaultBackgroundCustomEmojiStickers::fetch(env, p);
    case getDefaultChatEmojiStatuses::ID:
      return getDefaultChatEmojiStatuses::fetch(env, p);
    case getDefaultChatPhotoCustomEmojiStickers::ID:
      return getDefaultChatPhotoCustomEmojiStickers::fetch(env, p);
    case getDefaultEmojiStatuses::ID:
      return getDefaultEmojiStatuses::fetch(env, p);
    case getDefaultMessageAutoDeleteTime::ID:
      return getDefaultMessageAutoDeleteTime::fetch(env, p);
    case getDefaultProfilePhotoCustomEmojiStickers::ID:
      return getDefaultProfilePhotoCustomEmojiStickers::fetch(env, p);
    case getDirectMessagesChatTopic::ID:
      return getDirectMessagesChatTopic::fetch(env, p);
    case getDirectMessagesChatTopicHistory::ID:
      return getDirectMessagesChatTopicHistory::fetch(env, p);
    case getDirectMessagesChatTopicMessageByDate::ID:
      return getDirectMessagesChatTopicMessageByDate::fetch(env, p);
    case getDirectMessagesChatTopicRevenue::ID:
      return getDirectMessagesChatTopicRevenue::fetch(env, p);
    case getDisallowedChatEmojiStatuses::ID:
      return getDisallowedChatEmojiStatuses::fetch(env, p);
    case getEmojiCategories::ID:
      return getEmojiCategories::fetch(env, p);
    case getEmojiReaction::ID:
      return getEmojiReaction::fetch(env, p);
    case getEmojiSuggestionsUrl::ID:
      return getEmojiSuggestionsUrl::fetch(env, p);
    case getExternalLink::ID:
      return getExternalLink::fetch(env, p);
    case getExternalLinkInfo::ID:
      return getExternalLinkInfo::fetch(env, p);
    case getFavoriteStickers::ID:
      return getFavoriteStickers::fetch(env, p);
    case getFile::ID:
      return getFile::fetch(env, p);
    case getFileDownloadedPrefixSize::ID:
      return getFileDownloadedPrefixSize::fetch(env, p);
    case getFileExtension::ID:
      return getFileExtension::fetch(env, p);
    case getFileMimeType::ID:
      return getFileMimeType::fetch(env, p);
    case getForumTopic::ID:
      return getForumTopic::fetch(env, p);
    case getForumTopicDefaultIcons::ID:
      return getForumTopicDefaultIcons::fetch(env, p);
    case getForumTopicLink::ID:
      return getForumTopicLink::fetch(env, p);
    case getForumTopics::ID:
      return getForumTopics::fetch(env, p);
    case getGameHighScores::ID:
      return getGameHighScores::fetch(env, p);
    case getGiftUpgradePreview::ID:
      return getGiftUpgradePreview::fetch(env, p);
    case getGiveawayInfo::ID:
      return getGiveawayInfo::fetch(env, p);
    case getGreetingStickers::ID:
      return getGreetingStickers::fetch(env, p);
    case getGrossingWebAppBots::ID:
      return getGrossingWebAppBots::fetch(env, p);
    case getGroupCall::ID:
      return getGroupCall::fetch(env, p);
    case getGroupCallParticipants::ID:
      return getGroupCallParticipants::fetch(env, p);
    case getGroupsInCommon::ID:
      return getGroupsInCommon::fetch(env, p);
    case getImportedContactCount::ID:
      return getImportedContactCount::fetch(env, p);
    case getInactiveSupergroupChats::ID:
      return getInactiveSupergroupChats::fetch(env, p);
    case getInlineGameHighScores::ID:
      return getInlineGameHighScores::fetch(env, p);
    case getInlineQueryResults::ID:
      return getInlineQueryResults::fetch(env, p);
    case getInstalledBackgrounds::ID:
      return getInstalledBackgrounds::fetch(env, p);
    case getInstalledStickerSets::ID:
      return getInstalledStickerSets::fetch(env, p);
    case getInternalLink::ID:
      return getInternalLink::fetch(env, p);
    case getInternalLinkType::ID:
      return getInternalLinkType::fetch(env, p);
    case getJsonString::ID:
      return getJsonString::fetch(env, p);
    case getJsonValue::ID:
      return getJsonValue::fetch(env, p);
    case getKeywordEmojis::ID:
      return getKeywordEmojis::fetch(env, p);
    case getLanguagePackInfo::ID:
      return getLanguagePackInfo::fetch(env, p);
    case getLanguagePackString::ID:
      return getLanguagePackString::fetch(env, p);
    case getLanguagePackStrings::ID:
      return getLanguagePackStrings::fetch(env, p);
    case getLinkPreview::ID:
      return getLinkPreview::fetch(env, p);
    case getLocalizationTargetInfo::ID:
      return getLocalizationTargetInfo::fetch(env, p);
    case getLogStream::ID:
      return getLogStream::fetch(env, p);
    case getLogTagVerbosityLevel::ID:
      return getLogTagVerbosityLevel::fetch(env, p);
    case getLogTags::ID:
      return getLogTags::fetch(env, p);
    case getLogVerbosityLevel::ID:
      return getLogVerbosityLevel::fetch(env, p);
    case getLoginUrl::ID:
      return getLoginUrl::fetch(env, p);
    case getLoginUrlInfo::ID:
      return getLoginUrlInfo::fetch(env, p);
    case getMainWebApp::ID:
      return getMainWebApp::fetch(env, p);
    case getMapThumbnailFile::ID:
      return getMapThumbnailFile::fetch(env, p);
    case getMarkdownText::ID:
      return getMarkdownText::fetch(env, p);
    case getMe::ID:
      return getMe::fetch(env, p);
    case getMenuButton::ID:
      return getMenuButton::fetch(env, p);
    case getMessage::ID:
      return getMessage::fetch(env, p);
    case getMessageAddedReactions::ID:
      return getMessageAddedReactions::fetch(env, p);
    case getMessageAuthor::ID:
      return getMessageAuthor::fetch(env, p);
    case getMessageAvailableReactions::ID:
      return getMessageAvailableReactions::fetch(env, p);
    case getMessageEffect::ID:
      return getMessageEffect::fetch(env, p);
    case getMessageEmbeddingCode::ID:
      return getMessageEmbeddingCode::fetch(env, p);
    case getMessageFileType::ID:
      return getMessageFileType::fetch(env, p);
    case getMessageImportConfirmationText::ID:
      return getMessageImportConfirmationText::fetch(env, p);
    case getMessageLink::ID:
      return getMessageLink::fetch(env, p);
    case getMessageLinkInfo::ID:
      return getMessageLinkInfo::fetch(env, p);
    case getMessageLocally::ID:
      return getMessageLocally::fetch(env, p);
    case getMessageProperties::ID:
      return getMessageProperties::fetch(env, p);
    case getMessagePublicForwards::ID:
      return getMessagePublicForwards::fetch(env, p);
    case getMessageReadDate::ID:
      return getMessageReadDate::fetch(env, p);
    case getMessageStatistics::ID:
      return getMessageStatistics::fetch(env, p);
    case getMessageThread::ID:
      return getMessageThread::fetch(env, p);
    case getMessageThreadHistory::ID:
      return getMessageThreadHistory::fetch(env, p);
    case getMessageViewers::ID:
      return getMessageViewers::fetch(env, p);
    case getMessages::ID:
      return getMessages::fetch(env, p);
    case getNetworkStatistics::ID:
      return getNetworkStatistics::fetch(env, p);
    case getNewChatPrivacySettings::ID:
      return getNewChatPrivacySettings::fetch(env, p);
    case getOption::ID:
      return getOption::fetch(env, p);
    case getOwnedBots::ID:
      return getOwnedBots::fetch(env, p);
    case getOwnedStickerSets::ID:
      return getOwnedStickerSets::fetch(env, p);
    case getPaidMessageRevenue::ID:
      return getPaidMessageRevenue::fetch(env, p);
    case getPassportAuthorizationForm::ID:
      return getPassportAuthorizationForm::fetch(env, p);
    case getPassportAuthorizationFormAvailableElements::ID:
      return getPassportAuthorizationFormAvailableElements::fetch(env, p);
    case getPassportElement::ID:
      return getPassportElement::fetch(env, p);
    case getPasswordState::ID:
      return getPasswordState::fetch(env, p);
    case getPaymentForm::ID:
      return getPaymentForm::fetch(env, p);
    case getPaymentReceipt::ID:
      return getPaymentReceipt::fetch(env, p);
    case getPhoneNumberInfo::ID:
      return getPhoneNumberInfo::fetch(env, p);
    case getPhoneNumberInfoSync::ID:
      return getPhoneNumberInfoSync::fetch(env, p);
    case getPollVoters::ID:
      return getPollVoters::fetch(env, p);
    case getPreferredCountryLanguage::ID:
      return getPreferredCountryLanguage::fetch(env, p);
    case getPremiumFeatures::ID:
      return getPremiumFeatures::fetch(env, p);
    case getPremiumGiftPaymentOptions::ID:
      return getPremiumGiftPaymentOptions::fetch(env, p);
    case getPremiumGiveawayPaymentOptions::ID:
      return getPremiumGiveawayPaymentOptions::fetch(env, p);
    case getPremiumInfoSticker::ID:
      return getPremiumInfoSticker::fetch(env, p);
    case getPremiumLimit::ID:
      return getPremiumLimit::fetch(env, p);
    case getPremiumState::ID:
      return getPremiumState::fetch(env, p);
    case getPremiumStickerExamples::ID:
      return getPremiumStickerExamples::fetch(env, p);
    case getPremiumStickers::ID:
      return getPremiumStickers::fetch(env, p);
    case getPreparedInlineMessage::ID:
      return getPreparedInlineMessage::fetch(env, p);
    case getProxies::ID:
      return getProxies::fetch(env, p);
    case getProxyLink::ID:
      return getProxyLink::fetch(env, p);
    case getPushReceiverId::ID:
      return getPushReceiverId::fetch(env, p);
    case getReadDatePrivacySettings::ID:
      return getReadDatePrivacySettings::fetch(env, p);
    case getReceivedGift::ID:
      return getReceivedGift::fetch(env, p);
    case getReceivedGifts::ID:
      return getReceivedGifts::fetch(env, p);
    case getRecentEmojiStatuses::ID:
      return getRecentEmojiStatuses::fetch(env, p);
    case getRecentInlineBots::ID:
      return getRecentInlineBots::fetch(env, p);
    case getRecentStickers::ID:
      return getRecentStickers::fetch(env, p);
    case getRecentlyOpenedChats::ID:
      return getRecentlyOpenedChats::fetch(env, p);
    case getRecentlyVisitedTMeUrls::ID:
      return getRecentlyVisitedTMeUrls::fetch(env, p);
    case getRecommendedChatFolders::ID:
      return getRecommendedChatFolders::fetch(env, p);
    case getRecommendedChats::ID:
      return getRecommendedChats::fetch(env, p);
    case getRecoveryEmailAddress::ID:
      return getRecoveryEmailAddress::fetch(env, p);
    case getRemoteFile::ID:
      return getRemoteFile::fetch(env, p);
    case getRepliedMessage::ID:
      return getRepliedMessage::fetch(env, p);
    case getSavedAnimations::ID:
      return getSavedAnimations::fetch(env, p);
    case getSavedMessagesTags::ID:
      return getSavedMessagesTags::fetch(env, p);
    case getSavedMessagesTopicHistory::ID:
      return getSavedMessagesTopicHistory::fetch(env, p);
    case getSavedMessagesTopicMessageByDate::ID:
      return getSavedMessagesTopicMessageByDate::fetch(env, p);
    case getSavedNotificationSound::ID:
      return getSavedNotificationSound::fetch(env, p);
    case getSavedNotificationSounds::ID:
      return getSavedNotificationSounds::fetch(env, p);
    case getSavedOrderInfo::ID:
      return getSavedOrderInfo::fetch(env, p);
    case getScopeNotificationSettings::ID:
      return getScopeNotificationSettings::fetch(env, p);
    case getSearchSponsoredChats::ID:
      return getSearchSponsoredChats::fetch(env, p);
    case getSearchedForTags::ID:
      return getSearchedForTags::fetch(env, p);
    case getSecretChat::ID:
      return getSecretChat::fetch(env, p);
    case getStarAdAccountUrl::ID:
      return getStarAdAccountUrl::fetch(env, p);
    case getStarGiftPaymentOptions::ID:
      return getStarGiftPaymentOptions::fetch(env, p);
    case getStarGiveawayPaymentOptions::ID:
      return getStarGiveawayPaymentOptions::fetch(env, p);
    case getStarPaymentOptions::ID:
      return getStarPaymentOptions::fetch(env, p);
    case getStarRevenueStatistics::ID:
      return getStarRevenueStatistics::fetch(env, p);
    case getStarSubscriptions::ID:
      return getStarSubscriptions::fetch(env, p);
    case getStarTransactions::ID:
      return getStarTransactions::fetch(env, p);
    case getStarWithdrawalUrl::ID:
      return getStarWithdrawalUrl::fetch(env, p);
    case getStatisticalGraph::ID:
      return getStatisticalGraph::fetch(env, p);
    case getStickerEmojis::ID:
      return getStickerEmojis::fetch(env, p);
    case getStickerOutline::ID:
      return getStickerOutline::fetch(env, p);
    case getStickerSet::ID:
      return getStickerSet::fetch(env, p);
    case getStickerSetName::ID:
      return getStickerSetName::fetch(env, p);
    case getStickers::ID:
      return getStickers::fetch(env, p);
    case getStorageStatistics::ID:
      return getStorageStatistics::fetch(env, p);
    case getStorageStatisticsFast::ID:
      return getStorageStatisticsFast::fetch(env, p);
    case getStory::ID:
      return getStory::fetch(env, p);
    case getStoryAvailableReactions::ID:
      return getStoryAvailableReactions::fetch(env, p);
    case getStoryInteractions::ID:
      return getStoryInteractions::fetch(env, p);
    case getStoryNotificationSettingsExceptions::ID:
      return getStoryNotificationSettingsExceptions::fetch(env, p);
    case getStoryPublicForwards::ID:
      return getStoryPublicForwards::fetch(env, p);
    case getStoryStatistics::ID:
      return getStoryStatistics::fetch(env, p);
    case getSuggestedFileName::ID:
      return getSuggestedFileName::fetch(env, p);
    case getSuggestedStickerSetName::ID:
      return getSuggestedStickerSetName::fetch(env, p);
    case getSuitableDiscussionChats::ID:
      return getSuitableDiscussionChats::fetch(env, p);
    case getSuitablePersonalChats::ID:
      return getSuitablePersonalChats::fetch(env, p);
    case getSupergroup::ID:
      return getSupergroup::fetch(env, p);
    case getSupergroupFullInfo::ID:
      return getSupergroupFullInfo::fetch(env, p);
    case getSupergroupMembers::ID:
      return getSupergroupMembers::fetch(env, p);
    case getSupportName::ID:
      return getSupportName::fetch(env, p);
    case getSupportUser::ID:
      return getSupportUser::fetch(env, p);
    case getTemporaryPasswordState::ID:
      return getTemporaryPasswordState::fetch(env, p);
    case getTextEntities::ID:
      return getTextEntities::fetch(env, p);
    case getThemeParametersJsonString::ID:
      return getThemeParametersJsonString::fetch(env, p);
    case getThemedChatEmojiStatuses::ID:
      return getThemedChatEmojiStatuses::fetch(env, p);
    case getThemedEmojiStatuses::ID:
      return getThemedEmojiStatuses::fetch(env, p);
    case getTimeZones::ID:
      return getTimeZones::fetch(env, p);
    case getTonTransactions::ID:
      return getTonTransactions::fetch(env, p);
    case getTopChats::ID:
      return getTopChats::fetch(env, p);
    case getTrendingStickerSets::ID:
      return getTrendingStickerSets::fetch(env, p);
    case getUpgradedGift::ID:
      return getUpgradedGift::fetch(env, p);
    case getUpgradedGiftEmojiStatuses::ID:
      return getUpgradedGiftEmojiStatuses::fetch(env, p);
    case getUpgradedGiftWithdrawalUrl::ID:
      return getUpgradedGiftWithdrawalUrl::fetch(env, p);
    case getUser::ID:
      return getUser::fetch(env, p);
    case getUserChatBoosts::ID:
      return getUserChatBoosts::fetch(env, p);
    case getUserFullInfo::ID:
      return getUserFullInfo::fetch(env, p);
    case getUserLink::ID:
      return getUserLink::fetch(env, p);
    case getUserPrivacySettingRules::ID:
      return getUserPrivacySettingRules::fetch(env, p);
    case getUserProfilePhotos::ID:
      return getUserProfilePhotos::fetch(env, p);
    case getUserSupportInfo::ID:
      return getUserSupportInfo::fetch(env, p);
    case getVideoChatAvailableParticipants::ID:
      return getVideoChatAvailableParticipants::fetch(env, p);
    case getVideoChatInviteLink::ID:
      return getVideoChatInviteLink::fetch(env, p);
    case getVideoChatRtmpUrl::ID:
      return getVideoChatRtmpUrl::fetch(env, p);
    case getVideoChatStreamSegment::ID:
      return getVideoChatStreamSegment::fetch(env, p);
    case getVideoChatStreams::ID:
      return getVideoChatStreams::fetch(env, p);
    case getVideoMessageAdvertisements::ID:
      return getVideoMessageAdvertisements::fetch(env, p);
    case getWebAppLinkUrl::ID:
      return getWebAppLinkUrl::fetch(env, p);
    case getWebAppPlaceholder::ID:
      return getWebAppPlaceholder::fetch(env, p);
    case getWebAppUrl::ID:
      return getWebAppUrl::fetch(env, p);
    case getWebPageInstantView::ID:
      return getWebPageInstantView::fetch(env, p);
    case giftPremiumWithStars::ID:
      return giftPremiumWithStars::fetch(env, p);
    case hideContactCloseBirthdays::ID:
      return hideContactCloseBirthdays::fetch(env, p);
    case hideSuggestedAction::ID:
      return hideSuggestedAction::fetch(env, p);
    case importContacts::ID:
      return importContacts::fetch(env, p);
    case importMessages::ID:
      return importMessages::fetch(env, p);
    case inviteGroupCallParticipant::ID:
      return inviteGroupCallParticipant::fetch(env, p);
    case inviteVideoChatParticipants::ID:
      return inviteVideoChatParticipants::fetch(env, p);
    case joinChat::ID:
      return joinChat::fetch(env, p);
    case joinChatByInviteLink::ID:
      return joinChatByInviteLink::fetch(env, p);
    case joinGroupCall::ID:
      return joinGroupCall::fetch(env, p);
    case joinVideoChat::ID:
      return joinVideoChat::fetch(env, p);
    case launchPrepaidGiveaway::ID:
      return launchPrepaidGiveaway::fetch(env, p);
    case leaveChat::ID:
      return leaveChat::fetch(env, p);
    case leaveGroupCall::ID:
      return leaveGroupCall::fetch(env, p);
    case loadActiveStories::ID:
      return loadActiveStories::fetch(env, p);
    case loadChats::ID:
      return loadChats::fetch(env, p);
    case loadDirectMessagesChatTopics::ID:
      return loadDirectMessagesChatTopics::fetch(env, p);
    case loadGroupCallParticipants::ID:
      return loadGroupCallParticipants::fetch(env, p);
    case loadQuickReplyShortcutMessages::ID:
      return loadQuickReplyShortcutMessages::fetch(env, p);
    case loadQuickReplyShortcuts::ID:
      return loadQuickReplyShortcuts::fetch(env, p);
    case loadSavedMessagesTopics::ID:
      return loadSavedMessagesTopics::fetch(env, p);
    case logOut::ID:
      return logOut::fetch(env, p);
    case markChecklistTasksAsDone::ID:
      return markChecklistTasksAsDone::fetch(env, p);
    case openBotSimilarBot::ID:
      return openBotSimilarBot::fetch(env, p);
    case openChat::ID:
      return openChat::fetch(env, p);
    case openChatSimilarChat::ID:
      return openChatSimilarChat::fetch(env, p);
    case openMessageContent::ID:
      return openMessageContent::fetch(env, p);
    case openSponsoredChat::ID:
      return openSponsoredChat::fetch(env, p);
    case openStory::ID:
      return openStory::fetch(env, p);
    case openWebApp::ID:
      return openWebApp::fetch(env, p);
    case optimizeStorage::ID:
      return optimizeStorage::fetch(env, p);
    case parseMarkdown::ID:
      return parseMarkdown::fetch(env, p);
    case parseTextEntities::ID:
      return parseTextEntities::fetch(env, p);
    case pinChatMessage::ID:
      return pinChatMessage::fetch(env, p);
    case pingProxy::ID:
      return pingProxy::fetch(env, p);
    case postStory::ID:
      return postStory::fetch(env, p);
    case preliminaryUploadFile::ID:
      return preliminaryUploadFile::fetch(env, p);
    case processChatFolderNewChats::ID:
      return processChatFolderNewChats::fetch(env, p);
    case processChatJoinRequest::ID:
      return processChatJoinRequest::fetch(env, p);
    case processChatJoinRequests::ID:
      return processChatJoinRequests::fetch(env, p);
    case processPushNotification::ID:
      return processPushNotification::fetch(env, p);
    case rateSpeechRecognition::ID:
      return rateSpeechRecognition::fetch(env, p);
    case readAllChatMentions::ID:
      return readAllChatMentions::fetch(env, p);
    case readAllChatReactions::ID:
      return readAllChatReactions::fetch(env, p);
    case readAllDirectMessagesChatTopicReactions::ID:
      return readAllDirectMessagesChatTopicReactions::fetch(env, p);
    case readAllMessageThreadMentions::ID:
      return readAllMessageThreadMentions::fetch(env, p);
    case readAllMessageThreadReactions::ID:
      return readAllMessageThreadReactions::fetch(env, p);
    case readBusinessMessage::ID:
      return readBusinessMessage::fetch(env, p);
    case readChatList::ID:
      return readChatList::fetch(env, p);
    case readFilePart::ID:
      return readFilePart::fetch(env, p);
    case readdQuickReplyShortcutMessages::ID:
      return readdQuickReplyShortcutMessages::fetch(env, p);
    case recognizeSpeech::ID:
      return recognizeSpeech::fetch(env, p);
    case recoverAuthenticationPassword::ID:
      return recoverAuthenticationPassword::fetch(env, p);
    case recoverPassword::ID:
      return recoverPassword::fetch(env, p);
    case refundStarPayment::ID:
      return refundStarPayment::fetch(env, p);
    case registerDevice::ID:
      return registerDevice::fetch(env, p);
    case registerUser::ID:
      return registerUser::fetch(env, p);
    case removeAllFilesFromDownloads::ID:
      return removeAllFilesFromDownloads::fetch(env, p);
    case removeBusinessConnectedBotFromChat::ID:
      return removeBusinessConnectedBotFromChat::fetch(env, p);
    case removeChatActionBar::ID:
      return removeChatActionBar::fetch(env, p);
    case removeContacts::ID:
      return removeContacts::fetch(env, p);
    case removeFavoriteSticker::ID:
      return removeFavoriteSticker::fetch(env, p);
    case removeFileFromDownloads::ID:
      return removeFileFromDownloads::fetch(env, p);
    case removeInstalledBackground::ID:
      return removeInstalledBackground::fetch(env, p);
    case removeMessageReaction::ID:
      return removeMessageReaction::fetch(env, p);
    case removeMessageSenderBotVerification::ID:
      return removeMessageSenderBotVerification::fetch(env, p);
    case removeNotification::ID:
      return removeNotification::fetch(env, p);
    case removeNotificationGroup::ID:
      return removeNotificationGroup::fetch(env, p);
    case removePendingPaidMessageReactions::ID:
      return removePendingPaidMessageReactions::fetch(env, p);
    case removeProxy::ID:
      return removeProxy::fetch(env, p);
    case removeRecentHashtag::ID:
      return removeRecentHashtag::fetch(env, p);
    case removeRecentSticker::ID:
      return removeRecentSticker::fetch(env, p);
    case removeRecentlyFoundChat::ID:
      return removeRecentlyFoundChat::fetch(env, p);
    case removeSavedAnimation::ID:
      return removeSavedAnimation::fetch(env, p);
    case removeSavedNotificationSound::ID:
      return removeSavedNotificationSound::fetch(env, p);
    case removeSearchedForTag::ID:
      return removeSearchedForTag::fetch(env, p);
    case removeStickerFromSet::ID:
      return removeStickerFromSet::fetch(env, p);
    case removeTopChat::ID:
      return removeTopChat::fetch(env, p);
    case reorderActiveUsernames::ID:
      return reorderActiveUsernames::fetch(env, p);
    case reorderBotActiveUsernames::ID:
      return reorderBotActiveUsernames::fetch(env, p);
    case reorderBotMediaPreviews::ID:
      return reorderBotMediaPreviews::fetch(env, p);
    case reorderChatFolders::ID:
      return reorderChatFolders::fetch(env, p);
    case reorderInstalledStickerSets::ID:
      return reorderInstalledStickerSets::fetch(env, p);
    case reorderQuickReplyShortcuts::ID:
      return reorderQuickReplyShortcuts::fetch(env, p);
    case reorderSupergroupActiveUsernames::ID:
      return reorderSupergroupActiveUsernames::fetch(env, p);
    case replacePrimaryChatInviteLink::ID:
      return replacePrimaryChatInviteLink::fetch(env, p);
    case replaceStickerInSet::ID:
      return replaceStickerInSet::fetch(env, p);
    case replaceVideoChatRtmpUrl::ID:
      return replaceVideoChatRtmpUrl::fetch(env, p);
    case reportAuthenticationCodeMissing::ID:
      return reportAuthenticationCodeMissing::fetch(env, p);
    case reportChat::ID:
      return reportChat::fetch(env, p);
    case reportChatPhoto::ID:
      return reportChatPhoto::fetch(env, p);
    case reportChatSponsoredMessage::ID:
      return reportChatSponsoredMessage::fetch(env, p);
    case reportMessageReactions::ID:
      return reportMessageReactions::fetch(env, p);
    case reportPhoneNumberCodeMissing::ID:
      return reportPhoneNumberCodeMissing::fetch(env, p);
    case reportSponsoredChat::ID:
      return reportSponsoredChat::fetch(env, p);
    case reportStory::ID:
      return reportStory::fetch(env, p);
    case reportSupergroupAntiSpamFalsePositive::ID:
      return reportSupergroupAntiSpamFalsePositive::fetch(env, p);
    case reportSupergroupSpam::ID:
      return reportSupergroupSpam::fetch(env, p);
    case reportVideoMessageAdvertisement::ID:
      return reportVideoMessageAdvertisement::fetch(env, p);
    case requestAuthenticationPasswordRecovery::ID:
      return requestAuthenticationPasswordRecovery::fetch(env, p);
    case requestPasswordRecovery::ID:
      return requestPasswordRecovery::fetch(env, p);
    case requestQrCodeAuthentication::ID:
      return requestQrCodeAuthentication::fetch(env, p);
    case resendAuthenticationCode::ID:
      return resendAuthenticationCode::fetch(env, p);
    case resendEmailAddressVerificationCode::ID:
      return resendEmailAddressVerificationCode::fetch(env, p);
    case resendLoginEmailAddressCode::ID:
      return resendLoginEmailAddressCode::fetch(env, p);
    case resendMessages::ID:
      return resendMessages::fetch(env, p);
    case resendPhoneNumberCode::ID:
      return resendPhoneNumberCode::fetch(env, p);
    case resendRecoveryEmailAddressCode::ID:
      return resendRecoveryEmailAddressCode::fetch(env, p);
    case resetAllNotificationSettings::ID:
      return resetAllNotificationSettings::fetch(env, p);
    case resetAuthenticationEmailAddress::ID:
      return resetAuthenticationEmailAddress::fetch(env, p);
    case resetInstalledBackgrounds::ID:
      return resetInstalledBackgrounds::fetch(env, p);
    case resetNetworkStatistics::ID:
      return resetNetworkStatistics::fetch(env, p);
    case resetPassword::ID:
      return resetPassword::fetch(env, p);
    case reuseStarSubscription::ID:
      return reuseStarSubscription::fetch(env, p);
    case revokeChatInviteLink::ID:
      return revokeChatInviteLink::fetch(env, p);
    case revokeGroupCallInviteLink::ID:
      return revokeGroupCallInviteLink::fetch(env, p);
    case saveApplicationLogEvent::ID:
      return saveApplicationLogEvent::fetch(env, p);
    case savePreparedInlineMessage::ID:
      return savePreparedInlineMessage::fetch(env, p);
    case searchAffiliatePrograms::ID:
      return searchAffiliatePrograms::fetch(env, p);
    case searchBackground::ID:
      return searchBackground::fetch(env, p);
    case searchCallMessages::ID:
      return searchCallMessages::fetch(env, p);
    case searchChatAffiliateProgram::ID:
      return searchChatAffiliateProgram::fetch(env, p);
    case searchChatMembers::ID:
      return searchChatMembers::fetch(env, p);
    case searchChatMessages::ID:
      return searchChatMessages::fetch(env, p);
    case searchChatRecentLocationMessages::ID:
      return searchChatRecentLocationMessages::fetch(env, p);
    case searchChats::ID:
      return searchChats::fetch(env, p);
    case searchChatsOnServer::ID:
      return searchChatsOnServer::fetch(env, p);
    case searchContacts::ID:
      return searchContacts::fetch(env, p);
    case searchEmojis::ID:
      return searchEmojis::fetch(env, p);
    case searchFileDownloads::ID:
      return searchFileDownloads::fetch(env, p);
    case searchGiftsForResale::ID:
      return searchGiftsForResale::fetch(env, p);
    case searchHashtags::ID:
      return searchHashtags::fetch(env, p);
    case searchInstalledStickerSets::ID:
      return searchInstalledStickerSets::fetch(env, p);
    case searchMessages::ID:
      return searchMessages::fetch(env, p);
    case searchOutgoingDocumentMessages::ID:
      return searchOutgoingDocumentMessages::fetch(env, p);
    case searchPublicChat::ID:
      return searchPublicChat::fetch(env, p);
    case searchPublicChats::ID:
      return searchPublicChats::fetch(env, p);
    case searchPublicMessagesByTag::ID:
      return searchPublicMessagesByTag::fetch(env, p);
    case searchPublicStoriesByLocation::ID:
      return searchPublicStoriesByLocation::fetch(env, p);
    case searchPublicStoriesByTag::ID:
      return searchPublicStoriesByTag::fetch(env, p);
    case searchPublicStoriesByVenue::ID:
      return searchPublicStoriesByVenue::fetch(env, p);
    case searchQuote::ID:
      return searchQuote::fetch(env, p);
    case searchRecentlyFoundChats::ID:
      return searchRecentlyFoundChats::fetch(env, p);
    case searchSavedMessages::ID:
      return searchSavedMessages::fetch(env, p);
    case searchSecretMessages::ID:
      return searchSecretMessages::fetch(env, p);
    case searchStickerSet::ID:
      return searchStickerSet::fetch(env, p);
    case searchStickerSets::ID:
      return searchStickerSets::fetch(env, p);
    case searchStickers::ID:
      return searchStickers::fetch(env, p);
    case searchStringsByPrefix::ID:
      return searchStringsByPrefix::fetch(env, p);
    case searchUserByPhoneNumber::ID:
      return searchUserByPhoneNumber::fetch(env, p);
    case searchUserByToken::ID:
      return searchUserByToken::fetch(env, p);
    case searchWebApp::ID:
      return searchWebApp::fetch(env, p);
    case sellGift::ID:
      return sellGift::fetch(env, p);
    case sendAuthenticationFirebaseSms::ID:
      return sendAuthenticationFirebaseSms::fetch(env, p);
    case sendBotStartMessage::ID:
      return sendBotStartMessage::fetch(env, p);
    case sendBusinessMessage::ID:
      return sendBusinessMessage::fetch(env, p);
    case sendBusinessMessageAlbum::ID:
      return sendBusinessMessageAlbum::fetch(env, p);
    case sendCallDebugInformation::ID:
      return sendCallDebugInformation::fetch(env, p);
    case sendCallLog::ID:
      return sendCallLog::fetch(env, p);
    case sendCallRating::ID:
      return sendCallRating::fetch(env, p);
    case sendCallSignalingData::ID:
      return sendCallSignalingData::fetch(env, p);
    case sendChatAction::ID:
      return sendChatAction::fetch(env, p);
    case sendCustomRequest::ID:
      return sendCustomRequest::fetch(env, p);
    case sendEmailAddressVerificationCode::ID:
      return sendEmailAddressVerificationCode::fetch(env, p);
    case sendGift::ID:
      return sendGift::fetch(env, p);
    case sendInlineQueryResultMessage::ID:
      return sendInlineQueryResultMessage::fetch(env, p);
    case sendMessage::ID:
      return sendMessage::fetch(env, p);
    case sendMessageAlbum::ID:
      return sendMessageAlbum::fetch(env, p);
    case sendPassportAuthorizationForm::ID:
      return sendPassportAuthorizationForm::fetch(env, p);
    case sendPaymentForm::ID:
      return sendPaymentForm::fetch(env, p);
    case sendPhoneNumberCode::ID:
      return sendPhoneNumberCode::fetch(env, p);
    case sendPhoneNumberFirebaseSms::ID:
      return sendPhoneNumberFirebaseSms::fetch(env, p);
    case sendQuickReplyShortcutMessages::ID:
      return sendQuickReplyShortcutMessages::fetch(env, p);
    case sendResoldGift::ID:
      return sendResoldGift::fetch(env, p);
    case sendWebAppCustomRequest::ID:
      return sendWebAppCustomRequest::fetch(env, p);
    case sendWebAppData::ID:
      return sendWebAppData::fetch(env, p);
    case setAccentColor::ID:
      return setAccentColor::fetch(env, p);
    case setAccountTtl::ID:
      return setAccountTtl::fetch(env, p);
    case setAlarm::ID:
      return setAlarm::fetch(env, p);
    case setApplicationVerificationToken::ID:
      return setApplicationVerificationToken::fetch(env, p);
    case setArchiveChatListSettings::ID:
      return setArchiveChatListSettings::fetch(env, p);
    case setAuthenticationEmailAddress::ID:
      return setAuthenticationEmailAddress::fetch(env, p);
    case setAuthenticationPhoneNumber::ID:
      return setAuthenticationPhoneNumber::fetch(env, p);
    case setAuthenticationPremiumPurchaseTransaction::ID:
      return setAuthenticationPremiumPurchaseTransaction::fetch(env, p);
    case setAutoDownloadSettings::ID:
      return setAutoDownloadSettings::fetch(env, p);
    case setAutosaveSettings::ID:
      return setAutosaveSettings::fetch(env, p);
    case setBio::ID:
      return setBio::fetch(env, p);
    case setBirthdate::ID:
      return setBirthdate::fetch(env, p);
    case setBotInfoDescription::ID:
      return setBotInfoDescription::fetch(env, p);
    case setBotInfoShortDescription::ID:
      return setBotInfoShortDescription::fetch(env, p);
    case setBotName::ID:
      return setBotName::fetch(env, p);
    case setBotProfilePhoto::ID:
      return setBotProfilePhoto::fetch(env, p);
    case setBotUpdatesStatus::ID:
      return setBotUpdatesStatus::fetch(env, p);
    case setBusinessAccountBio::ID:
      return setBusinessAccountBio::fetch(env, p);
    case setBusinessAccountGiftSettings::ID:
      return setBusinessAccountGiftSettings::fetch(env, p);
    case setBusinessAccountName::ID:
      return setBusinessAccountName::fetch(env, p);
    case setBusinessAccountProfilePhoto::ID:
      return setBusinessAccountProfilePhoto::fetch(env, p);
    case setBusinessAccountUsername::ID:
      return setBusinessAccountUsername::fetch(env, p);
    case setBusinessAwayMessageSettings::ID:
      return setBusinessAwayMessageSettings::fetch(env, p);
    case setBusinessConnectedBot::ID:
      return setBusinessConnectedBot::fetch(env, p);
    case setBusinessGreetingMessageSettings::ID:
      return setBusinessGreetingMessageSettings::fetch(env, p);
    case setBusinessLocation::ID:
      return setBusinessLocation::fetch(env, p);
    case setBusinessMessageIsPinned::ID:
      return setBusinessMessageIsPinned::fetch(env, p);
    case setBusinessOpeningHours::ID:
      return setBusinessOpeningHours::fetch(env, p);
    case setBusinessStartPage::ID:
      return setBusinessStartPage::fetch(env, p);
    case setChatAccentColor::ID:
      return setChatAccentColor::fetch(env, p);
    case setChatActiveStoriesList::ID:
      return setChatActiveStoriesList::fetch(env, p);
    case setChatAffiliateProgram::ID:
      return setChatAffiliateProgram::fetch(env, p);
    case setChatAvailableReactions::ID:
      return setChatAvailableReactions::fetch(env, p);
    case setChatBackground::ID:
      return setChatBackground::fetch(env, p);
    case setChatClientData::ID:
      return setChatClientData::fetch(env, p);
    case setChatDescription::ID:
      return setChatDescription::fetch(env, p);
    case setChatDirectMessagesGroup::ID:
      return setChatDirectMessagesGroup::fetch(env, p);
    case setChatDiscussionGroup::ID:
      return setChatDiscussionGroup::fetch(env, p);
    case setChatDraftMessage::ID:
      return setChatDraftMessage::fetch(env, p);
    case setChatEmojiStatus::ID:
      return setChatEmojiStatus::fetch(env, p);
    case setChatLocation::ID:
      return setChatLocation::fetch(env, p);
    case setChatMemberStatus::ID:
      return setChatMemberStatus::fetch(env, p);
    case setChatMessageAutoDeleteTime::ID:
      return setChatMessageAutoDeleteTime::fetch(env, p);
    case setChatMessageSender::ID:
      return setChatMessageSender::fetch(env, p);
    case setChatNotificationSettings::ID:
      return setChatNotificationSettings::fetch(env, p);
    case setChatPaidMessageStarCount::ID:
      return setChatPaidMessageStarCount::fetch(env, p);
    case setChatPermissions::ID:
      return setChatPermissions::fetch(env, p);
    case setChatPhoto::ID:
      return setChatPhoto::fetch(env, p);
    case setChatPinnedStories::ID:
      return setChatPinnedStories::fetch(env, p);
    case setChatProfileAccentColor::ID:
      return setChatProfileAccentColor::fetch(env, p);
    case setChatSlowModeDelay::ID:
      return setChatSlowModeDelay::fetch(env, p);
    case setChatTheme::ID:
      return setChatTheme::fetch(env, p);
    case setChatTitle::ID:
      return setChatTitle::fetch(env, p);
    case setCloseFriends::ID:
      return setCloseFriends::fetch(env, p);
    case setCommands::ID:
      return setCommands::fetch(env, p);
    case setCustomEmojiStickerSetThumbnail::ID:
      return setCustomEmojiStickerSetThumbnail::fetch(env, p);
    case setCustomLanguagePack::ID:
      return setCustomLanguagePack::fetch(env, p);
    case setCustomLanguagePackString::ID:
      return setCustomLanguagePackString::fetch(env, p);
    case setDatabaseEncryptionKey::ID:
      return setDatabaseEncryptionKey::fetch(env, p);
    case setDefaultBackground::ID:
      return setDefaultBackground::fetch(env, p);
    case setDefaultChannelAdministratorRights::ID:
      return setDefaultChannelAdministratorRights::fetch(env, p);
    case setDefaultGroupAdministratorRights::ID:
      return setDefaultGroupAdministratorRights::fetch(env, p);
    case setDefaultMessageAutoDeleteTime::ID:
      return setDefaultMessageAutoDeleteTime::fetch(env, p);
    case setDefaultReactionType::ID:
      return setDefaultReactionType::fetch(env, p);
    case setDirectMessagesChatTopicDraftMessage::ID:
      return setDirectMessagesChatTopicDraftMessage::fetch(env, p);
    case setDirectMessagesChatTopicIsMarkedAsUnread::ID:
      return setDirectMessagesChatTopicIsMarkedAsUnread::fetch(env, p);
    case setEmojiStatus::ID:
      return setEmojiStatus::fetch(env, p);
    case setFileGenerationProgress::ID:
      return setFileGenerationProgress::fetch(env, p);
    case setForumTopicNotificationSettings::ID:
      return setForumTopicNotificationSettings::fetch(env, p);
    case setGameScore::ID:
      return setGameScore::fetch(env, p);
    case setGiftResalePrice::ID:
      return setGiftResalePrice::fetch(env, p);
    case setGiftSettings::ID:
      return setGiftSettings::fetch(env, p);
    case setGroupCallParticipantIsSpeaking::ID:
      return setGroupCallParticipantIsSpeaking::fetch(env, p);
    case setGroupCallParticipantVolumeLevel::ID:
      return setGroupCallParticipantVolumeLevel::fetch(env, p);
    case setInactiveSessionTtl::ID:
      return setInactiveSessionTtl::fetch(env, p);
    case setInlineGameScore::ID:
      return setInlineGameScore::fetch(env, p);
    case setLogStream::ID:
      return setLogStream::fetch(env, p);
    case setLogTagVerbosityLevel::ID:
      return setLogTagVerbosityLevel::fetch(env, p);
    case setLogVerbosityLevel::ID:
      return setLogVerbosityLevel::fetch(env, p);
    case setLoginEmailAddress::ID:
      return setLoginEmailAddress::fetch(env, p);
    case setMenuButton::ID:
      return setMenuButton::fetch(env, p);
    case setMessageFactCheck::ID:
      return setMessageFactCheck::fetch(env, p);
    case setMessageReactions::ID:
      return setMessageReactions::fetch(env, p);
    case setMessageSenderBlockList::ID:
      return setMessageSenderBlockList::fetch(env, p);
    case setMessageSenderBotVerification::ID:
      return setMessageSenderBotVerification::fetch(env, p);
    case setName::ID:
      return setName::fetch(env, p);
    case setNetworkType::ID:
      return setNetworkType::fetch(env, p);
    case setNewChatPrivacySettings::ID:
      return setNewChatPrivacySettings::fetch(env, p);
    case setOption::ID:
      return setOption::fetch(env, p);
    case setPaidMessageReactionType::ID:
      return setPaidMessageReactionType::fetch(env, p);
    case setPassportElement::ID:
      return setPassportElement::fetch(env, p);
    case setPassportElementErrors::ID:
      return setPassportElementErrors::fetch(env, p);
    case setPassword::ID:
      return setPassword::fetch(env, p);
    case setPersonalChat::ID:
      return setPersonalChat::fetch(env, p);
    case setPinnedChats::ID:
      return setPinnedChats::fetch(env, p);
    case setPinnedForumTopics::ID:
      return setPinnedForumTopics::fetch(env, p);
    case setPinnedGifts::ID:
      return setPinnedGifts::fetch(env, p);
    case setPinnedSavedMessagesTopics::ID:
      return setPinnedSavedMessagesTopics::fetch(env, p);
    case setPollAnswer::ID:
      return setPollAnswer::fetch(env, p);
    case setProfileAccentColor::ID:
      return setProfileAccentColor::fetch(env, p);
    case setProfilePhoto::ID:
      return setProfilePhoto::fetch(env, p);
    case setQuickReplyShortcutName::ID:
      return setQuickReplyShortcutName::fetch(env, p);
    case setReactionNotificationSettings::ID:
      return setReactionNotificationSettings::fetch(env, p);
    case setReadDatePrivacySettings::ID:
      return setReadDatePrivacySettings::fetch(env, p);
    case setRecoveryEmailAddress::ID:
      return setRecoveryEmailAddress::fetch(env, p);
    case setSavedMessagesTagLabel::ID:
      return setSavedMessagesTagLabel::fetch(env, p);
    case setScopeNotificationSettings::ID:
      return setScopeNotificationSettings::fetch(env, p);
    case setStickerEmojis::ID:
      return setStickerEmojis::fetch(env, p);
    case setStickerKeywords::ID:
      return setStickerKeywords::fetch(env, p);
    case setStickerMaskPosition::ID:
      return setStickerMaskPosition::fetch(env, p);
    case setStickerPositionInSet::ID:
      return setStickerPositionInSet::fetch(env, p);
    case setStickerSetThumbnail::ID:
      return setStickerSetThumbnail::fetch(env, p);
    case setStickerSetTitle::ID:
      return setStickerSetTitle::fetch(env, p);
    case setStoryPrivacySettings::ID:
      return setStoryPrivacySettings::fetch(env, p);
    case setStoryReaction::ID:
      return setStoryReaction::fetch(env, p);
    case setSupergroupCustomEmojiStickerSet::ID:
      return setSupergroupCustomEmojiStickerSet::fetch(env, p);
    case setSupergroupStickerSet::ID:
      return setSupergroupStickerSet::fetch(env, p);
    case setSupergroupUnrestrictBoostCount::ID:
      return setSupergroupUnrestrictBoostCount::fetch(env, p);
    case setSupergroupUsername::ID:
      return setSupergroupUsername::fetch(env, p);
    case setTdlibParameters::ID:
      return setTdlibParameters::fetch(env, p);
    case setUserEmojiStatus::ID:
      return setUserEmojiStatus::fetch(env, p);
    case setUserPersonalProfilePhoto::ID:
      return setUserPersonalProfilePhoto::fetch(env, p);
    case setUserPrivacySettingRules::ID:
      return setUserPrivacySettingRules::fetch(env, p);
    case setUserSupportInfo::ID:
      return setUserSupportInfo::fetch(env, p);
    case setUsername::ID:
      return setUsername::fetch(env, p);
    case setVideoChatDefaultParticipant::ID:
      return setVideoChatDefaultParticipant::fetch(env, p);
    case setVideoChatTitle::ID:
      return setVideoChatTitle::fetch(env, p);
    case shareChatWithBot::ID:
      return shareChatWithBot::fetch(env, p);
    case sharePhoneNumber::ID:
      return sharePhoneNumber::fetch(env, p);
    case shareUsersWithBot::ID:
      return shareUsersWithBot::fetch(env, p);
    case startGroupCallRecording::ID:
      return startGroupCallRecording::fetch(env, p);
    case startGroupCallScreenSharing::ID:
      return startGroupCallScreenSharing::fetch(env, p);
    case startScheduledVideoChat::ID:
      return startScheduledVideoChat::fetch(env, p);
    case stopBusinessPoll::ID:
      return stopBusinessPoll::fetch(env, p);
    case stopPoll::ID:
      return stopPoll::fetch(env, p);
    case suggestUserProfilePhoto::ID:
      return suggestUserProfilePhoto::fetch(env, p);
    case synchronizeLanguagePack::ID:
      return synchronizeLanguagePack::fetch(env, p);
    case terminateAllOtherSessions::ID:
      return terminateAllOtherSessions::fetch(env, p);
    case terminateSession::ID:
      return terminateSession::fetch(env, p);
    case testCallBytes::ID:
      return testCallBytes::fetch(env, p);
    case testCallEmpty::ID:
      return testCallEmpty::fetch(env, p);
    case testCallString::ID:
      return testCallString::fetch(env, p);
    case testCallVectorInt::ID:
      return testCallVectorInt::fetch(env, p);
    case testCallVectorIntObject::ID:
      return testCallVectorIntObject::fetch(env, p);
    case testCallVectorString::ID:
      return testCallVectorString::fetch(env, p);
    case testCallVectorStringObject::ID:
      return testCallVectorStringObject::fetch(env, p);
    case testGetDifference::ID:
      return testGetDifference::fetch(env, p);
    case testNetwork::ID:
      return testNetwork::fetch(env, p);
    case testProxy::ID:
      return testProxy::fetch(env, p);
    case testReturnError::ID:
      return testReturnError::fetch(env, p);
    case testSquareInt::ID:
      return testSquareInt::fetch(env, p);
    case testUseUpdate::ID:
      return testUseUpdate::fetch(env, p);
    case toggleAllDownloadsArePaused::ID:
      return toggleAllDownloadsArePaused::fetch(env, p);
    case toggleBotCanManageEmojiStatus::ID:
      return toggleBotCanManageEmojiStatus::fetch(env, p);
    case toggleBotIsAddedToAttachmentMenu::ID:
      return toggleBotIsAddedToAttachmentMenu::fetch(env, p);
    case toggleBotUsernameIsActive::ID:
      return toggleBotUsernameIsActive::fetch(env, p);
    case toggleBusinessConnectedBotChatIsPaused::ID:
      return toggleBusinessConnectedBotChatIsPaused::fetch(env, p);
    case toggleChatDefaultDisableNotification::ID:
      return toggleChatDefaultDisableNotification::fetch(env, p);
    case toggleChatFolderTags::ID:
      return toggleChatFolderTags::fetch(env, p);
    case toggleChatGiftNotifications::ID:
      return toggleChatGiftNotifications::fetch(env, p);
    case toggleChatHasProtectedContent::ID:
      return toggleChatHasProtectedContent::fetch(env, p);
    case toggleChatIsMarkedAsUnread::ID:
      return toggleChatIsMarkedAsUnread::fetch(env, p);
    case toggleChatIsPinned::ID:
      return toggleChatIsPinned::fetch(env, p);
    case toggleChatIsTranslatable::ID:
      return toggleChatIsTranslatable::fetch(env, p);
    case toggleChatViewAsTopics::ID:
      return toggleChatViewAsTopics::fetch(env, p);
    case toggleDirectMessagesChatTopicCanSendUnpaidMessages::ID:
      return toggleDirectMessagesChatTopicCanSendUnpaidMessages::fetch(env, p);
    case toggleDownloadIsPaused::ID:
      return toggleDownloadIsPaused::fetch(env, p);
    case toggleForumTopicIsClosed::ID:
      return toggleForumTopicIsClosed::fetch(env, p);
    case toggleForumTopicIsPinned::ID:
      return toggleForumTopicIsPinned::fetch(env, p);
    case toggleGeneralForumTopicIsHidden::ID:
      return toggleGeneralForumTopicIsHidden::fetch(env, p);
    case toggleGiftIsSaved::ID:
      return toggleGiftIsSaved::fetch(env, p);
    case toggleGroupCallIsMyVideoEnabled::ID:
      return toggleGroupCallIsMyVideoEnabled::fetch(env, p);
    case toggleGroupCallIsMyVideoPaused::ID:
      return toggleGroupCallIsMyVideoPaused::fetch(env, p);
    case toggleGroupCallParticipantIsHandRaised::ID:
      return toggleGroupCallParticipantIsHandRaised::fetch(env, p);
    case toggleGroupCallParticipantIsMuted::ID:
      return toggleGroupCallParticipantIsMuted::fetch(env, p);
    case toggleGroupCallScreenSharingIsPaused::ID:
      return toggleGroupCallScreenSharingIsPaused::fetch(env, p);
    case toggleHasSponsoredMessagesEnabled::ID:
      return toggleHasSponsoredMessagesEnabled::fetch(env, p);
    case toggleSavedMessagesTopicIsPinned::ID:
      return toggleSavedMessagesTopicIsPinned::fetch(env, p);
    case toggleSessionCanAcceptCalls::ID:
      return toggleSessionCanAcceptCalls::fetch(env, p);
    case toggleSessionCanAcceptSecretChats::ID:
      return toggleSessionCanAcceptSecretChats::fetch(env, p);
    case toggleStoryIsPostedToChatPage::ID:
      return toggleStoryIsPostedToChatPage::fetch(env, p);
    case toggleSupergroupCanHaveSponsoredMessages::ID:
      return toggleSupergroupCanHaveSponsoredMessages::fetch(env, p);
    case toggleSupergroupHasAggressiveAntiSpamEnabled::ID:
      return toggleSupergroupHasAggressiveAntiSpamEnabled::fetch(env, p);
    case toggleSupergroupHasAutomaticTranslation::ID:
      return toggleSupergroupHasAutomaticTranslation::fetch(env, p);
    case toggleSupergroupHasHiddenMembers::ID:
      return toggleSupergroupHasHiddenMembers::fetch(env, p);
    case toggleSupergroupIsAllHistoryAvailable::ID:
      return toggleSupergroupIsAllHistoryAvailable::fetch(env, p);
    case toggleSupergroupIsBroadcastGroup::ID:
      return toggleSupergroupIsBroadcastGroup::fetch(env, p);
    case toggleSupergroupIsForum::ID:
      return toggleSupergroupIsForum::fetch(env, p);
    case toggleSupergroupJoinByRequest::ID:
      return toggleSupergroupJoinByRequest::fetch(env, p);
    case toggleSupergroupJoinToSendMessages::ID:
      return toggleSupergroupJoinToSendMessages::fetch(env, p);
    case toggleSupergroupSignMessages::ID:
      return toggleSupergroupSignMessages::fetch(env, p);
    case toggleSupergroupUsernameIsActive::ID:
      return toggleSupergroupUsernameIsActive::fetch(env, p);
    case toggleUsernameIsActive::ID:
      return toggleUsernameIsActive::fetch(env, p);
    case toggleVideoChatEnabledStartNotification::ID:
      return toggleVideoChatEnabledStartNotification::fetch(env, p);
    case toggleVideoChatMuteNewParticipants::ID:
      return toggleVideoChatMuteNewParticipants::fetch(env, p);
    case transferBusinessAccountStars::ID:
      return transferBusinessAccountStars::fetch(env, p);
    case transferChatOwnership::ID:
      return transferChatOwnership::fetch(env, p);
    case transferGift::ID:
      return transferGift::fetch(env, p);
    case translateMessageText::ID:
      return translateMessageText::fetch(env, p);
    case translateText::ID:
      return translateText::fetch(env, p);
    case unpinAllChatMessages::ID:
      return unpinAllChatMessages::fetch(env, p);
    case unpinAllDirectMessagesChatTopicMessages::ID:
      return unpinAllDirectMessagesChatTopicMessages::fetch(env, p);
    case unpinAllMessageThreadMessages::ID:
      return unpinAllMessageThreadMessages::fetch(env, p);
    case unpinChatMessage::ID:
      return unpinChatMessage::fetch(env, p);
    case upgradeBasicGroupChatToSupergroupChat::ID:
      return upgradeBasicGroupChatToSupergroupChat::fetch(env, p);
    case upgradeGift::ID:
      return upgradeGift::fetch(env, p);
    case uploadStickerFile::ID:
      return uploadStickerFile::fetch(env, p);
    case validateOrderInfo::ID:
      return validateOrderInfo::fetch(env, p);
    case viewMessages::ID:
      return viewMessages::fetch(env, p);
    case viewPremiumFeature::ID:
      return viewPremiumFeature::fetch(env, p);
    case viewSponsoredChat::ID:
      return viewSponsoredChat::fetch(env, p);
    case viewTrendingStickerSets::ID:
      return viewTrendingStickerSets::fetch(env, p);
    case viewVideoMessageAdvertisement::ID:
      return viewVideoMessageAdvertisement::fetch(env, p);
    case writeGeneratedFilePart::ID:
      return writeGeneratedFilePart::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void Function::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Function").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass accentColor::Class;
jfieldID accentColor::id_fieldID;
jfieldID accentColor::built_in_accent_color_id_fieldID;
jfieldID accentColor::light_theme_colors_fieldID;
jfieldID accentColor::dark_theme_colors_fieldID;
jfieldID accentColor::min_channel_chat_boost_level_fieldID;

accentColor::accentColor()
  : id_()
  , built_in_accent_color_id_()
  , light_theme_colors_()
  , dark_theme_colors_()
  , min_channel_chat_boost_level_()
{}

accentColor::accentColor(int32 id_, int32 built_in_accent_color_id_, array<int32> &&light_theme_colors_, array<int32> &&dark_theme_colors_, int32 min_channel_chat_boost_level_)
  : id_(id_)
  , built_in_accent_color_id_(built_in_accent_color_id_)
  , light_theme_colors_(std::move(light_theme_colors_))
  , dark_theme_colors_(std::move(dark_theme_colors_))
  , min_channel_chat_boost_level_(min_channel_chat_boost_level_)
{}

const std::int32_t accentColor::ID;

object_ptr<accentColor> accentColor::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<accentColor> res = make_object<accentColor>();
  res->id_ = env->GetIntField(p, res->id_fieldID);
  res->built_in_accent_color_id_ = env->GetIntField(p, res->built_in_accent_color_id_fieldID);
  res->light_theme_colors_ = jni::fetch_vector(env, (jintArray)jni::fetch_object(env, p, res->light_theme_colors_fieldID));
  res->dark_theme_colors_ = jni::fetch_vector(env, (jintArray)jni::fetch_object(env, p, res->dark_theme_colors_fieldID));
  res->min_channel_chat_boost_level_ = env->GetIntField(p, res->min_channel_chat_boost_level_fieldID);
  return res;
}

void accentColor::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, id_fieldID, id_);
  env->SetIntField(s, built_in_accent_color_id_fieldID, built_in_accent_color_id_);
  { auto arr_tmp_ = jni::store_vector(env, light_theme_colors_); if (arr_tmp_) { env->SetObjectField(s, light_theme_colors_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, dark_theme_colors_); if (arr_tmp_) { env->SetObjectField(s, dark_theme_colors_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetIntField(s, min_channel_chat_boost_level_fieldID, min_channel_chat_boost_level_);
}

void accentColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AccentColor");
    s.store_field("id", id_);
    s.store_field("builtInAccentColorId", built_in_accent_color_id_);
    { s.store_vector_begin("lightThemeColors", light_theme_colors_.size()); for (const auto &_value : light_theme_colors_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("darkThemeColors", dark_theme_colors_.size()); for (const auto &_value : dark_theme_colors_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("minChannelChatBoostLevel", min_channel_chat_boost_level_);
    s.store_class_end();
  }
}

void accentColor::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AccentColor").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "I");
    built_in_accent_color_id_fieldID = jni::get_field_id(env, Class, "builtInAccentColorId", "I");
    light_theme_colors_fieldID = jni::get_field_id(env, Class, "lightThemeColors", "[I");
    dark_theme_colors_fieldID = jni::get_field_id(env, Class, "darkThemeColors", "[I");
    min_channel_chat_boost_level_fieldID = jni::get_field_id(env, Class, "minChannelChatBoostLevel", "I");
    return true;
  }();
  (void)is_inited;
}

jclass acceptedGiftTypes::Class;
jfieldID acceptedGiftTypes::unlimited_gifts_fieldID;
jfieldID acceptedGiftTypes::limited_gifts_fieldID;
jfieldID acceptedGiftTypes::upgraded_gifts_fieldID;
jfieldID acceptedGiftTypes::premium_subscription_fieldID;

acceptedGiftTypes::acceptedGiftTypes()
  : unlimited_gifts_()
  , limited_gifts_()
  , upgraded_gifts_()
  , premium_subscription_()
{}

acceptedGiftTypes::acceptedGiftTypes(bool unlimited_gifts_, bool limited_gifts_, bool upgraded_gifts_, bool premium_subscription_)
  : unlimited_gifts_(unlimited_gifts_)
  , limited_gifts_(limited_gifts_)
  , upgraded_gifts_(upgraded_gifts_)
  , premium_subscription_(premium_subscription_)
{}

const std::int32_t acceptedGiftTypes::ID;

object_ptr<acceptedGiftTypes> acceptedGiftTypes::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<acceptedGiftTypes> res = make_object<acceptedGiftTypes>();
  res->unlimited_gifts_ = (env->GetBooleanField(p, res->unlimited_gifts_fieldID) != 0);
  res->limited_gifts_ = (env->GetBooleanField(p, res->limited_gifts_fieldID) != 0);
  res->upgraded_gifts_ = (env->GetBooleanField(p, res->upgraded_gifts_fieldID) != 0);
  res->premium_subscription_ = (env->GetBooleanField(p, res->premium_subscription_fieldID) != 0);
  return res;
}

void acceptedGiftTypes::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, unlimited_gifts_fieldID, unlimited_gifts_);
  env->SetBooleanField(s, limited_gifts_fieldID, limited_gifts_);
  env->SetBooleanField(s, upgraded_gifts_fieldID, upgraded_gifts_);
  env->SetBooleanField(s, premium_subscription_fieldID, premium_subscription_);
}

void acceptedGiftTypes::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AcceptedGiftTypes");
    s.store_field("unlimitedGifts", unlimited_gifts_);
    s.store_field("limitedGifts", limited_gifts_);
    s.store_field("upgradedGifts", upgraded_gifts_);
    s.store_field("premiumSubscription", premium_subscription_);
    s.store_class_end();
  }
}

void acceptedGiftTypes::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AcceptedGiftTypes").c_str());
    unlimited_gifts_fieldID = jni::get_field_id(env, Class, "unlimitedGifts", "Z");
    limited_gifts_fieldID = jni::get_field_id(env, Class, "limitedGifts", "Z");
    upgraded_gifts_fieldID = jni::get_field_id(env, Class, "upgradedGifts", "Z");
    premium_subscription_fieldID = jni::get_field_id(env, Class, "premiumSubscription", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass accountInfo::Class;
jfieldID accountInfo::registration_month_fieldID;
jfieldID accountInfo::registration_year_fieldID;
jfieldID accountInfo::phone_number_country_code_fieldID;
jfieldID accountInfo::last_name_change_date_fieldID;
jfieldID accountInfo::last_photo_change_date_fieldID;

accountInfo::accountInfo()
  : registration_month_()
  , registration_year_()
  , phone_number_country_code_()
  , last_name_change_date_()
  , last_photo_change_date_()
{}

accountInfo::accountInfo(int32 registration_month_, int32 registration_year_, string const &phone_number_country_code_, int32 last_name_change_date_, int32 last_photo_change_date_)
  : registration_month_(registration_month_)
  , registration_year_(registration_year_)
  , phone_number_country_code_(phone_number_country_code_)
  , last_name_change_date_(last_name_change_date_)
  , last_photo_change_date_(last_photo_change_date_)
{}

const std::int32_t accountInfo::ID;

object_ptr<accountInfo> accountInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<accountInfo> res = make_object<accountInfo>();
  res->registration_month_ = env->GetIntField(p, res->registration_month_fieldID);
  res->registration_year_ = env->GetIntField(p, res->registration_year_fieldID);
  res->phone_number_country_code_ = jni::fetch_string(env, p, res->phone_number_country_code_fieldID);
  res->last_name_change_date_ = env->GetIntField(p, res->last_name_change_date_fieldID);
  res->last_photo_change_date_ = env->GetIntField(p, res->last_photo_change_date_fieldID);
  return res;
}

void accountInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, registration_month_fieldID, registration_month_);
  env->SetIntField(s, registration_year_fieldID, registration_year_);
  { jstring nextString = jni::to_jstring(env, phone_number_country_code_); if (nextString) { env->SetObjectField(s, phone_number_country_code_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, last_name_change_date_fieldID, last_name_change_date_);
  env->SetIntField(s, last_photo_change_date_fieldID, last_photo_change_date_);
}

void accountInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AccountInfo");
    s.store_field("registrationMonth", registration_month_);
    s.store_field("registrationYear", registration_year_);
    s.store_field("phoneNumberCountryCode", phone_number_country_code_);
    s.store_field("lastNameChangeDate", last_name_change_date_);
    s.store_field("lastPhotoChangeDate", last_photo_change_date_);
    s.store_class_end();
  }
}

void accountInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AccountInfo").c_str());
    registration_month_fieldID = jni::get_field_id(env, Class, "registrationMonth", "I");
    registration_year_fieldID = jni::get_field_id(env, Class, "registrationYear", "I");
    phone_number_country_code_fieldID = jni::get_field_id(env, Class, "phoneNumberCountryCode", "Ljava/lang/String;");
    last_name_change_date_fieldID = jni::get_field_id(env, Class, "lastNameChangeDate", "I");
    last_photo_change_date_fieldID = jni::get_field_id(env, Class, "lastPhotoChangeDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass accountTtl::Class;
jfieldID accountTtl::days_fieldID;

accountTtl::accountTtl()
  : days_()
{}

accountTtl::accountTtl(int32 days_)
  : days_(days_)
{}

const std::int32_t accountTtl::ID;

object_ptr<accountTtl> accountTtl::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<accountTtl> res = make_object<accountTtl>();
  res->days_ = env->GetIntField(p, res->days_fieldID);
  return res;
}

void accountTtl::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, days_fieldID, days_);
}

void accountTtl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AccountTtl");
    s.store_field("days", days_);
    s.store_class_end();
  }
}

void accountTtl::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AccountTtl").c_str());
    days_fieldID = jni::get_field_id(env, Class, "days", "I");
    return true;
  }();
  (void)is_inited;
}

jclass addedReaction::Class;
jfieldID addedReaction::type_fieldID;
jfieldID addedReaction::sender_id_fieldID;
jfieldID addedReaction::is_outgoing_fieldID;
jfieldID addedReaction::date_fieldID;

addedReaction::addedReaction()
  : type_()
  , sender_id_()
  , is_outgoing_()
  , date_()
{}

addedReaction::addedReaction(object_ptr<ReactionType> &&type_, object_ptr<MessageSender> &&sender_id_, bool is_outgoing_, int32 date_)
  : type_(std::move(type_))
  , sender_id_(std::move(sender_id_))
  , is_outgoing_(is_outgoing_)
  , date_(date_)
{}

const std::int32_t addedReaction::ID;

object_ptr<addedReaction> addedReaction::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<addedReaction> res = make_object<addedReaction>();
  res->type_ = jni::fetch_tl_object<ReactionType>(env, jni::fetch_object(env, p, res->type_fieldID));
  res->sender_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->sender_id_fieldID));
  res->is_outgoing_ = (env->GetBooleanField(p, res->is_outgoing_fieldID) != 0);
  res->date_ = env->GetIntField(p, res->date_fieldID);
  return res;
}

void addedReaction::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
  if (sender_id_ != nullptr) { jobject next; sender_id_->store(env, next); if (next) { env->SetObjectField(s, sender_id_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, is_outgoing_fieldID, is_outgoing_);
  env->SetIntField(s, date_fieldID, date_);
}

void addedReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AddedReaction");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("senderId", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("isOutgoing", is_outgoing_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

void addedReaction::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AddedReaction").c_str());
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ReactionType;").c_str());
    sender_id_fieldID = jni::get_field_id(env, Class, "senderId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    is_outgoing_fieldID = jni::get_field_id(env, Class, "isOutgoing", "Z");
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    return true;
  }();
  (void)is_inited;
}

jclass addedReactions::Class;
jfieldID addedReactions::total_count_fieldID;
jfieldID addedReactions::reactions_fieldID;
jfieldID addedReactions::next_offset_fieldID;

addedReactions::addedReactions()
  : total_count_()
  , reactions_()
  , next_offset_()
{}

addedReactions::addedReactions(int32 total_count_, array<object_ptr<addedReaction>> &&reactions_, string const &next_offset_)
  : total_count_(total_count_)
  , reactions_(std::move(reactions_))
  , next_offset_(next_offset_)
{}

const std::int32_t addedReactions::ID;

object_ptr<addedReactions> addedReactions::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<addedReactions> res = make_object<addedReactions>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->reactions_ = jni::FetchVector<addedReaction>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->reactions_fieldID));
  res->next_offset_ = jni::fetch_string(env, p, res->next_offset_fieldID);
  return res;
}

void addedReactions::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, reactions_); if (arr_tmp_) { env->SetObjectField(s, reactions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { jstring nextString = jni::to_jstring(env, next_offset_); if (nextString) { env->SetObjectField(s, next_offset_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void addedReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AddedReactions");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("nextOffset", next_offset_);
    s.store_class_end();
  }
}

void addedReactions::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AddedReactions").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    reactions_fieldID = jni::get_field_id(env, Class, "reactions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AddedReaction;").c_str());
    next_offset_fieldID = jni::get_field_id(env, Class, "nextOffset", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass address::Class;
jfieldID address::country_code_fieldID;
jfieldID address::state_fieldID;
jfieldID address::city_fieldID;
jfieldID address::street_line1_fieldID;
jfieldID address::street_line2_fieldID;
jfieldID address::postal_code_fieldID;

address::address()
  : country_code_()
  , state_()
  , city_()
  , street_line1_()
  , street_line2_()
  , postal_code_()
{}

address::address(string const &country_code_, string const &state_, string const &city_, string const &street_line1_, string const &street_line2_, string const &postal_code_)
  : country_code_(country_code_)
  , state_(state_)
  , city_(city_)
  , street_line1_(street_line1_)
  , street_line2_(street_line2_)
  , postal_code_(postal_code_)
{}

const std::int32_t address::ID;

object_ptr<address> address::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<address> res = make_object<address>();
  res->country_code_ = jni::fetch_string(env, p, res->country_code_fieldID);
  res->state_ = jni::fetch_string(env, p, res->state_fieldID);
  res->city_ = jni::fetch_string(env, p, res->city_fieldID);
  res->street_line1_ = jni::fetch_string(env, p, res->street_line1_fieldID);
  res->street_line2_ = jni::fetch_string(env, p, res->street_line2_fieldID);
  res->postal_code_ = jni::fetch_string(env, p, res->postal_code_fieldID);
  return res;
}

void address::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, country_code_); if (nextString) { env->SetObjectField(s, country_code_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, state_); if (nextString) { env->SetObjectField(s, state_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, city_); if (nextString) { env->SetObjectField(s, city_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, street_line1_); if (nextString) { env->SetObjectField(s, street_line1_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, street_line2_); if (nextString) { env->SetObjectField(s, street_line2_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, postal_code_); if (nextString) { env->SetObjectField(s, postal_code_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void address::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Address");
    s.store_field("countryCode", country_code_);
    s.store_field("state", state_);
    s.store_field("city", city_);
    s.store_field("streetLine1", street_line1_);
    s.store_field("streetLine2", street_line2_);
    s.store_field("postalCode", postal_code_);
    s.store_class_end();
  }
}

void address::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Address").c_str());
    country_code_fieldID = jni::get_field_id(env, Class, "countryCode", "Ljava/lang/String;");
    state_fieldID = jni::get_field_id(env, Class, "state", "Ljava/lang/String;");
    city_fieldID = jni::get_field_id(env, Class, "city", "Ljava/lang/String;");
    street_line1_fieldID = jni::get_field_id(env, Class, "streetLine1", "Ljava/lang/String;");
    street_line2_fieldID = jni::get_field_id(env, Class, "streetLine2", "Ljava/lang/String;");
    postal_code_fieldID = jni::get_field_id(env, Class, "postalCode", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass advertisementSponsor::Class;
jfieldID advertisementSponsor::url_fieldID;
jfieldID advertisementSponsor::photo_fieldID;
jfieldID advertisementSponsor::info_fieldID;

advertisementSponsor::advertisementSponsor()
  : url_()
  , photo_()
  , info_()
{}

advertisementSponsor::advertisementSponsor(string const &url_, object_ptr<photo> &&photo_, string const &info_)
  : url_(url_)
  , photo_(std::move(photo_))
  , info_(info_)
{}

const std::int32_t advertisementSponsor::ID;

object_ptr<advertisementSponsor> advertisementSponsor::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<advertisementSponsor> res = make_object<advertisementSponsor>();
  res->url_ = jni::fetch_string(env, p, res->url_fieldID);
  res->photo_ = jni::fetch_tl_object<photo>(env, jni::fetch_object(env, p, res->photo_fieldID));
  res->info_ = jni::fetch_string(env, p, res->info_fieldID);
  return res;
}

void advertisementSponsor::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, url_); if (nextString) { env->SetObjectField(s, url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (photo_ != nullptr) { jobject next; photo_->store(env, next); if (next) { env->SetObjectField(s, photo_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, info_); if (nextString) { env->SetObjectField(s, info_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void advertisementSponsor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AdvertisementSponsor");
    s.store_field("url", url_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("info", info_);
    s.store_class_end();
  }
}

void advertisementSponsor::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AdvertisementSponsor").c_str());
    url_fieldID = jni::get_field_id(env, Class, "url", "Ljava/lang/String;");
    photo_fieldID = jni::get_field_id(env, Class, "photo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Photo;").c_str());
    info_fieldID = jni::get_field_id(env, Class, "info", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass affiliateInfo::Class;
jfieldID affiliateInfo::commission_per_mille_fieldID;
jfieldID affiliateInfo::affiliate_chat_id_fieldID;
jfieldID affiliateInfo::star_amount_fieldID;

affiliateInfo::affiliateInfo()
  : commission_per_mille_()
  , affiliate_chat_id_()
  , star_amount_()
{}

affiliateInfo::affiliateInfo(int32 commission_per_mille_, int53 affiliate_chat_id_, object_ptr<starAmount> &&star_amount_)
  : commission_per_mille_(commission_per_mille_)
  , affiliate_chat_id_(affiliate_chat_id_)
  , star_amount_(std::move(star_amount_))
{}

const std::int32_t affiliateInfo::ID;

object_ptr<affiliateInfo> affiliateInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<affiliateInfo> res = make_object<affiliateInfo>();
  res->commission_per_mille_ = env->GetIntField(p, res->commission_per_mille_fieldID);
  res->affiliate_chat_id_ = env->GetLongField(p, res->affiliate_chat_id_fieldID);
  res->star_amount_ = jni::fetch_tl_object<starAmount>(env, jni::fetch_object(env, p, res->star_amount_fieldID));
  return res;
}

void affiliateInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, commission_per_mille_fieldID, commission_per_mille_);
  env->SetLongField(s, affiliate_chat_id_fieldID, affiliate_chat_id_);
  if (star_amount_ != nullptr) { jobject next; star_amount_->store(env, next); if (next) { env->SetObjectField(s, star_amount_fieldID, next); env->DeleteLocalRef(next); } }
}

void affiliateInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateInfo");
    s.store_field("commissionPerMille", commission_per_mille_);
    s.store_field("affiliateChatId", affiliate_chat_id_);
    s.store_object_field("starAmount", static_cast<const BaseObject *>(star_amount_.get()));
    s.store_class_end();
  }
}

void affiliateInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateInfo").c_str());
    commission_per_mille_fieldID = jni::get_field_id(env, Class, "commissionPerMille", "I");
    affiliate_chat_id_fieldID = jni::get_field_id(env, Class, "affiliateChatId", "J");
    star_amount_fieldID = jni::get_field_id(env, Class, "starAmount", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StarAmount;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateProgramInfo::Class;
jfieldID affiliateProgramInfo::parameters_fieldID;
jfieldID affiliateProgramInfo::end_date_fieldID;
jfieldID affiliateProgramInfo::daily_revenue_per_user_amount_fieldID;

affiliateProgramInfo::affiliateProgramInfo()
  : parameters_()
  , end_date_()
  , daily_revenue_per_user_amount_()
{}

affiliateProgramInfo::affiliateProgramInfo(object_ptr<affiliateProgramParameters> &&parameters_, int32 end_date_, object_ptr<starAmount> &&daily_revenue_per_user_amount_)
  : parameters_(std::move(parameters_))
  , end_date_(end_date_)
  , daily_revenue_per_user_amount_(std::move(daily_revenue_per_user_amount_))
{}

const std::int32_t affiliateProgramInfo::ID;

object_ptr<affiliateProgramInfo> affiliateProgramInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<affiliateProgramInfo> res = make_object<affiliateProgramInfo>();
  res->parameters_ = jni::fetch_tl_object<affiliateProgramParameters>(env, jni::fetch_object(env, p, res->parameters_fieldID));
  res->end_date_ = env->GetIntField(p, res->end_date_fieldID);
  res->daily_revenue_per_user_amount_ = jni::fetch_tl_object<starAmount>(env, jni::fetch_object(env, p, res->daily_revenue_per_user_amount_fieldID));
  return res;
}

void affiliateProgramInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (parameters_ != nullptr) { jobject next; parameters_->store(env, next); if (next) { env->SetObjectField(s, parameters_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, end_date_fieldID, end_date_);
  if (daily_revenue_per_user_amount_ != nullptr) { jobject next; daily_revenue_per_user_amount_->store(env, next); if (next) { env->SetObjectField(s, daily_revenue_per_user_amount_fieldID, next); env->DeleteLocalRef(next); } }
}

void affiliateProgramInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateProgramInfo");
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("endDate", end_date_);
    s.store_object_field("dailyRevenuePerUserAmount", static_cast<const BaseObject *>(daily_revenue_per_user_amount_.get()));
    s.store_class_end();
  }
}

void affiliateProgramInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramInfo").c_str());
    parameters_fieldID = jni::get_field_id(env, Class, "parameters", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AffiliateProgramParameters;").c_str());
    end_date_fieldID = jni::get_field_id(env, Class, "endDate", "I");
    daily_revenue_per_user_amount_fieldID = jni::get_field_id(env, Class, "dailyRevenuePerUserAmount", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StarAmount;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateProgramParameters::Class;
jfieldID affiliateProgramParameters::commission_per_mille_fieldID;
jfieldID affiliateProgramParameters::month_count_fieldID;

affiliateProgramParameters::affiliateProgramParameters()
  : commission_per_mille_()
  , month_count_()
{}

affiliateProgramParameters::affiliateProgramParameters(int32 commission_per_mille_, int32 month_count_)
  : commission_per_mille_(commission_per_mille_)
  , month_count_(month_count_)
{}

const std::int32_t affiliateProgramParameters::ID;

object_ptr<affiliateProgramParameters> affiliateProgramParameters::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<affiliateProgramParameters> res = make_object<affiliateProgramParameters>();
  res->commission_per_mille_ = env->GetIntField(p, res->commission_per_mille_fieldID);
  res->month_count_ = env->GetIntField(p, res->month_count_fieldID);
  return res;
}

void affiliateProgramParameters::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, commission_per_mille_fieldID, commission_per_mille_);
  env->SetIntField(s, month_count_fieldID, month_count_);
}

void affiliateProgramParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateProgramParameters");
    s.store_field("commissionPerMille", commission_per_mille_);
    s.store_field("monthCount", month_count_);
    s.store_class_end();
  }
}

void affiliateProgramParameters::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramParameters").c_str());
    commission_per_mille_fieldID = jni::get_field_id(env, Class, "commissionPerMille", "I");
    month_count_fieldID = jni::get_field_id(env, Class, "monthCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass AffiliateProgramSortOrder::Class;

object_ptr<AffiliateProgramSortOrder> AffiliateProgramSortOrder::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case affiliateProgramSortOrderProfitability::ID:
      return affiliateProgramSortOrderProfitability::fetch(env, p);
    case affiliateProgramSortOrderCreationDate::ID:
      return affiliateProgramSortOrderCreationDate::fetch(env, p);
    case affiliateProgramSortOrderRevenue::ID:
      return affiliateProgramSortOrderRevenue::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void AffiliateProgramSortOrder::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramSortOrder").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateProgramSortOrderProfitability::Class;

affiliateProgramSortOrderProfitability::affiliateProgramSortOrderProfitability() {
}

const std::int32_t affiliateProgramSortOrderProfitability::ID;

object_ptr<AffiliateProgramSortOrder> affiliateProgramSortOrderProfitability::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<affiliateProgramSortOrderProfitability>();
}

void affiliateProgramSortOrderProfitability::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateProgramSortOrderProfitability");
    s.store_class_end();
  }
}

void affiliateProgramSortOrderProfitability::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramSortOrderProfitability").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateProgramSortOrderCreationDate::Class;

affiliateProgramSortOrderCreationDate::affiliateProgramSortOrderCreationDate() {
}

const std::int32_t affiliateProgramSortOrderCreationDate::ID;

object_ptr<AffiliateProgramSortOrder> affiliateProgramSortOrderCreationDate::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<affiliateProgramSortOrderCreationDate>();
}

void affiliateProgramSortOrderCreationDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateProgramSortOrderCreationDate");
    s.store_class_end();
  }
}

void affiliateProgramSortOrderCreationDate::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramSortOrderCreationDate").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateProgramSortOrderRevenue::Class;

affiliateProgramSortOrderRevenue::affiliateProgramSortOrderRevenue() {
}

const std::int32_t affiliateProgramSortOrderRevenue::ID;

object_ptr<AffiliateProgramSortOrder> affiliateProgramSortOrderRevenue::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<affiliateProgramSortOrderRevenue>();
}

void affiliateProgramSortOrderRevenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateProgramSortOrderRevenue");
    s.store_class_end();
  }
}

void affiliateProgramSortOrderRevenue::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateProgramSortOrderRevenue").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass AffiliateType::Class;

object_ptr<AffiliateType> AffiliateType::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case affiliateTypeCurrentUser::ID:
      return affiliateTypeCurrentUser::fetch(env, p);
    case affiliateTypeBot::ID:
      return affiliateTypeBot::fetch(env, p);
    case affiliateTypeChannel::ID:
      return affiliateTypeChannel::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void AffiliateType::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateType").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateTypeCurrentUser::Class;

affiliateTypeCurrentUser::affiliateTypeCurrentUser() {
}

const std::int32_t affiliateTypeCurrentUser::ID;

object_ptr<AffiliateType> affiliateTypeCurrentUser::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<affiliateTypeCurrentUser>();
}

void affiliateTypeCurrentUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateTypeCurrentUser");
    s.store_class_end();
  }
}

void affiliateTypeCurrentUser::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateTypeCurrentUser").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass affiliateTypeBot::Class;
jfieldID affiliateTypeBot::user_id_fieldID;

affiliateTypeBot::affiliateTypeBot()
  : user_id_()
{}

affiliateTypeBot::affiliateTypeBot(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t affiliateTypeBot::ID;

object_ptr<AffiliateType> affiliateTypeBot::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<affiliateTypeBot> res = make_object<affiliateTypeBot>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  return std::move(res);
}

void affiliateTypeBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateTypeBot");
    s.store_field("userId", user_id_);
    s.store_class_end();
  }
}

void affiliateTypeBot::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateTypeBot").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass affiliateTypeChannel::Class;
jfieldID affiliateTypeChannel::chat_id_fieldID;

affiliateTypeChannel::affiliateTypeChannel()
  : chat_id_()
{}

affiliateTypeChannel::affiliateTypeChannel(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t affiliateTypeChannel::ID;

object_ptr<AffiliateType> affiliateTypeChannel::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<affiliateTypeChannel> res = make_object<affiliateTypeChannel>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  return std::move(res);
}

void affiliateTypeChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AffiliateTypeChannel");
    s.store_field("chatId", chat_id_);
    s.store_class_end();
  }
}

void affiliateTypeChannel::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AffiliateTypeChannel").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass alternativeVideo::Class;
jfieldID alternativeVideo::id_fieldID;
jfieldID alternativeVideo::width_fieldID;
jfieldID alternativeVideo::height_fieldID;
jfieldID alternativeVideo::codec_fieldID;
jfieldID alternativeVideo::hls_file_fieldID;
jfieldID alternativeVideo::video_fieldID;

alternativeVideo::alternativeVideo()
  : id_()
  , width_()
  , height_()
  , codec_()
  , hls_file_()
  , video_()
{}

alternativeVideo::alternativeVideo(int64 id_, int32 width_, int32 height_, string const &codec_, object_ptr<file> &&hls_file_, object_ptr<file> &&video_)
  : id_(id_)
  , width_(width_)
  , height_(height_)
  , codec_(codec_)
  , hls_file_(std::move(hls_file_))
  , video_(std::move(video_))
{}

const std::int32_t alternativeVideo::ID;

object_ptr<alternativeVideo> alternativeVideo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<alternativeVideo> res = make_object<alternativeVideo>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->width_ = env->GetIntField(p, res->width_fieldID);
  res->height_ = env->GetIntField(p, res->height_fieldID);
  res->codec_ = jni::fetch_string(env, p, res->codec_fieldID);
  res->hls_file_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->hls_file_fieldID));
  res->video_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->video_fieldID));
  return res;
}

void alternativeVideo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  env->SetIntField(s, width_fieldID, width_);
  env->SetIntField(s, height_fieldID, height_);
  { jstring nextString = jni::to_jstring(env, codec_); if (nextString) { env->SetObjectField(s, codec_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (hls_file_ != nullptr) { jobject next; hls_file_->store(env, next); if (next) { env->SetObjectField(s, hls_file_fieldID, next); env->DeleteLocalRef(next); } }
  if (video_ != nullptr) { jobject next; video_->store(env, next); if (next) { env->SetObjectField(s, video_fieldID, next); env->DeleteLocalRef(next); } }
}

void alternativeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AlternativeVideo");
    s.store_field("id", id_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("codec", codec_);
    s.store_object_field("hlsFile", static_cast<const BaseObject *>(hls_file_.get()));
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_class_end();
  }
}

void alternativeVideo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AlternativeVideo").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    width_fieldID = jni::get_field_id(env, Class, "width", "I");
    height_fieldID = jni::get_field_id(env, Class, "height", "I");
    codec_fieldID = jni::get_field_id(env, Class, "codec", "Ljava/lang/String;");
    hls_file_fieldID = jni::get_field_id(env, Class, "hlsFile", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    video_fieldID = jni::get_field_id(env, Class, "video", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass animatedChatPhoto::Class;
jfieldID animatedChatPhoto::length_fieldID;
jfieldID animatedChatPhoto::file_fieldID;
jfieldID animatedChatPhoto::main_frame_timestamp_fieldID;

animatedChatPhoto::animatedChatPhoto()
  : length_()
  , file_()
  , main_frame_timestamp_()
{}

animatedChatPhoto::animatedChatPhoto(int32 length_, object_ptr<file> &&file_, double main_frame_timestamp_)
  : length_(length_)
  , file_(std::move(file_))
  , main_frame_timestamp_(main_frame_timestamp_)
{}

const std::int32_t animatedChatPhoto::ID;

object_ptr<animatedChatPhoto> animatedChatPhoto::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<animatedChatPhoto> res = make_object<animatedChatPhoto>();
  res->length_ = env->GetIntField(p, res->length_fieldID);
  res->file_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->file_fieldID));
  res->main_frame_timestamp_ = env->GetDoubleField(p, res->main_frame_timestamp_fieldID);
  return res;
}

void animatedChatPhoto::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, length_fieldID, length_);
  if (file_ != nullptr) { jobject next; file_->store(env, next); if (next) { env->SetObjectField(s, file_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetDoubleField(s, main_frame_timestamp_fieldID, main_frame_timestamp_);
}

void animatedChatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AnimatedChatPhoto");
    s.store_field("length", length_);
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    s.store_field("mainFrameTimestamp", main_frame_timestamp_);
    s.store_class_end();
  }
}

void animatedChatPhoto::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AnimatedChatPhoto").c_str());
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    file_fieldID = jni::get_field_id(env, Class, "file", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    main_frame_timestamp_fieldID = jni::get_field_id(env, Class, "mainFrameTimestamp", "D");
    return true;
  }();
  (void)is_inited;
}

jclass animatedEmoji::Class;
jfieldID animatedEmoji::sticker_fieldID;
jfieldID animatedEmoji::sticker_width_fieldID;
jfieldID animatedEmoji::sticker_height_fieldID;
jfieldID animatedEmoji::fitzpatrick_type_fieldID;
jfieldID animatedEmoji::sound_fieldID;

animatedEmoji::animatedEmoji()
  : sticker_()
  , sticker_width_()
  , sticker_height_()
  , fitzpatrick_type_()
  , sound_()
{}

animatedEmoji::animatedEmoji(object_ptr<sticker> &&sticker_, int32 sticker_width_, int32 sticker_height_, int32 fitzpatrick_type_, object_ptr<file> &&sound_)
  : sticker_(std::move(sticker_))
  , sticker_width_(sticker_width_)
  , sticker_height_(sticker_height_)
  , fitzpatrick_type_(fitzpatrick_type_)
  , sound_(std::move(sound_))
{}

const std::int32_t animatedEmoji::ID;

object_ptr<animatedEmoji> animatedEmoji::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<animatedEmoji> res = make_object<animatedEmoji>();
  res->sticker_ = jni::fetch_tl_object<sticker>(env, jni::fetch_object(env, p, res->sticker_fieldID));
  res->sticker_width_ = env->GetIntField(p, res->sticker_width_fieldID);
  res->sticker_height_ = env->GetIntField(p, res->sticker_height_fieldID);
  res->fitzpatrick_type_ = env->GetIntField(p, res->fitzpatrick_type_fieldID);
  res->sound_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->sound_fieldID));
  return res;
}

void animatedEmoji::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (sticker_ != nullptr) { jobject next; sticker_->store(env, next); if (next) { env->SetObjectField(s, sticker_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, sticker_width_fieldID, sticker_width_);
  env->SetIntField(s, sticker_height_fieldID, sticker_height_);
  env->SetIntField(s, fitzpatrick_type_fieldID, fitzpatrick_type_);
  if (sound_ != nullptr) { jobject next; sound_->store(env, next); if (next) { env->SetObjectField(s, sound_fieldID, next); env->DeleteLocalRef(next); } }
}

void animatedEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AnimatedEmoji");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("stickerWidth", sticker_width_);
    s.store_field("stickerHeight", sticker_height_);
    s.store_field("fitzpatrickType", fitzpatrick_type_);
    s.store_object_field("sound", static_cast<const BaseObject *>(sound_.get()));
    s.store_class_end();
  }
}

void animatedEmoji::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AnimatedEmoji").c_str());
    sticker_fieldID = jni::get_field_id(env, Class, "sticker", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Sticker;").c_str());
    sticker_width_fieldID = jni::get_field_id(env, Class, "stickerWidth", "I");
    sticker_height_fieldID = jni::get_field_id(env, Class, "stickerHeight", "I");
    fitzpatrick_type_fieldID = jni::get_field_id(env, Class, "fitzpatrickType", "I");
    sound_fieldID = jni::get_field_id(env, Class, "sound", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass animation::Class;
jfieldID animation::duration_fieldID;
jfieldID animation::width_fieldID;
jfieldID animation::height_fieldID;
jfieldID animation::file_name_fieldID;
jfieldID animation::mime_type_fieldID;
jfieldID animation::has_stickers_fieldID;
jfieldID animation::minithumbnail_fieldID;
jfieldID animation::thumbnail_fieldID;
jfieldID animation::animation_fieldID;

animation::animation()
  : duration_()
  , width_()
  , height_()
  , file_name_()
  , mime_type_()
  , has_stickers_()
  , minithumbnail_()
  , thumbnail_()
  , animation_()
{}

animation::animation(int32 duration_, int32 width_, int32 height_, string const &file_name_, string const &mime_type_, bool has_stickers_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&animation_)
  : duration_(duration_)
  , width_(width_)
  , height_(height_)
  , file_name_(file_name_)
  , mime_type_(mime_type_)
  , has_stickers_(has_stickers_)
  , minithumbnail_(std::move(minithumbnail_))
  , thumbnail_(std::move(thumbnail_))
  , animation_(std::move(animation_))
{}

const std::int32_t animation::ID;

object_ptr<animation> animation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<animation> res = make_object<animation>();
  res->duration_ = env->GetIntField(p, res->duration_fieldID);
  res->width_ = env->GetIntField(p, res->width_fieldID);
  res->height_ = env->GetIntField(p, res->height_fieldID);
  res->file_name_ = jni::fetch_string(env, p, res->file_name_fieldID);
  res->mime_type_ = jni::fetch_string(env, p, res->mime_type_fieldID);
  res->has_stickers_ = (env->GetBooleanField(p, res->has_stickers_fieldID) != 0);
  res->minithumbnail_ = jni::fetch_tl_object<minithumbnail>(env, jni::fetch_object(env, p, res->minithumbnail_fieldID));
  res->thumbnail_ = jni::fetch_tl_object<thumbnail>(env, jni::fetch_object(env, p, res->thumbnail_fieldID));
  res->animation_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->animation_fieldID));
  return res;
}

void animation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, duration_fieldID, duration_);
  env->SetIntField(s, width_fieldID, width_);
  env->SetIntField(s, height_fieldID, height_);
  { jstring nextString = jni::to_jstring(env, file_name_); if (nextString) { env->SetObjectField(s, file_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, mime_type_); if (nextString) { env->SetObjectField(s, mime_type_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, has_stickers_fieldID, has_stickers_);
  if (minithumbnail_ != nullptr) { jobject next; minithumbnail_->store(env, next); if (next) { env->SetObjectField(s, minithumbnail_fieldID, next); env->DeleteLocalRef(next); } }
  if (thumbnail_ != nullptr) { jobject next; thumbnail_->store(env, next); if (next) { env->SetObjectField(s, thumbnail_fieldID, next); env->DeleteLocalRef(next); } }
  if (animation_ != nullptr) { jobject next; animation_->store(env, next); if (next) { env->SetObjectField(s, animation_fieldID, next); env->DeleteLocalRef(next); } }
}

void animation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Animation");
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("fileName", file_name_);
    s.store_field("mimeType", mime_type_);
    s.store_field("hasStickers", has_stickers_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

void animation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Animation").c_str());
    duration_fieldID = jni::get_field_id(env, Class, "duration", "I");
    width_fieldID = jni::get_field_id(env, Class, "width", "I");
    height_fieldID = jni::get_field_id(env, Class, "height", "I");
    file_name_fieldID = jni::get_field_id(env, Class, "fileName", "Ljava/lang/String;");
    mime_type_fieldID = jni::get_field_id(env, Class, "mimeType", "Ljava/lang/String;");
    has_stickers_fieldID = jni::get_field_id(env, Class, "hasStickers", "Z");
    minithumbnail_fieldID = jni::get_field_id(env, Class, "minithumbnail", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Minithumbnail;").c_str());
    thumbnail_fieldID = jni::get_field_id(env, Class, "thumbnail", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Thumbnail;").c_str());
    animation_fieldID = jni::get_field_id(env, Class, "animation", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass animations::Class;
jfieldID animations::animations_fieldID;

animations::animations()
  : animations_()
{}

animations::animations(array<object_ptr<animation>> &&animations_)
  : animations_(std::move(animations_))
{}

const std::int32_t animations::ID;

object_ptr<animations> animations::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<animations> res = make_object<animations>();
  res->animations_ = jni::FetchVector<animation>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->animations_fieldID));
  return res;
}

void animations::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, animations_); if (arr_tmp_) { env->SetObjectField(s, animations_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void animations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Animations");
    { s.store_vector_begin("animations", animations_.size()); for (const auto &_value : animations_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void animations::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Animations").c_str());
    animations_fieldID = jni::get_field_id(env, Class, "animations", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$Animation;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass archiveChatListSettings::Class;
jfieldID archiveChatListSettings::archive_and_mute_new_chats_from_unknown_users_fieldID;
jfieldID archiveChatListSettings::keep_unmuted_chats_archived_fieldID;
jfieldID archiveChatListSettings::keep_chats_from_folders_archived_fieldID;

archiveChatListSettings::archiveChatListSettings()
  : archive_and_mute_new_chats_from_unknown_users_()
  , keep_unmuted_chats_archived_()
  , keep_chats_from_folders_archived_()
{}

archiveChatListSettings::archiveChatListSettings(bool archive_and_mute_new_chats_from_unknown_users_, bool keep_unmuted_chats_archived_, bool keep_chats_from_folders_archived_)
  : archive_and_mute_new_chats_from_unknown_users_(archive_and_mute_new_chats_from_unknown_users_)
  , keep_unmuted_chats_archived_(keep_unmuted_chats_archived_)
  , keep_chats_from_folders_archived_(keep_chats_from_folders_archived_)
{}

const std::int32_t archiveChatListSettings::ID;

object_ptr<archiveChatListSettings> archiveChatListSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<archiveChatListSettings> res = make_object<archiveChatListSettings>();
  res->archive_and_mute_new_chats_from_unknown_users_ = (env->GetBooleanField(p, res->archive_and_mute_new_chats_from_unknown_users_fieldID) != 0);
  res->keep_unmuted_chats_archived_ = (env->GetBooleanField(p, res->keep_unmuted_chats_archived_fieldID) != 0);
  res->keep_chats_from_folders_archived_ = (env->GetBooleanField(p, res->keep_chats_from_folders_archived_fieldID) != 0);
  return res;
}

void archiveChatListSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, archive_and_mute_new_chats_from_unknown_users_fieldID, archive_and_mute_new_chats_from_unknown_users_);
  env->SetBooleanField(s, keep_unmuted_chats_archived_fieldID, keep_unmuted_chats_archived_);
  env->SetBooleanField(s, keep_chats_from_folders_archived_fieldID, keep_chats_from_folders_archived_);
}

void archiveChatListSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ArchiveChatListSettings");
    s.store_field("archiveAndMuteNewChatsFromUnknownUsers", archive_and_mute_new_chats_from_unknown_users_);
    s.store_field("keepUnmutedChatsArchived", keep_unmuted_chats_archived_);
    s.store_field("keepChatsFromFoldersArchived", keep_chats_from_folders_archived_);
    s.store_class_end();
  }
}

void archiveChatListSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ArchiveChatListSettings").c_str());
    archive_and_mute_new_chats_from_unknown_users_fieldID = jni::get_field_id(env, Class, "archiveAndMuteNewChatsFromUnknownUsers", "Z");
    keep_unmuted_chats_archived_fieldID = jni::get_field_id(env, Class, "keepUnmutedChatsArchived", "Z");
    keep_chats_from_folders_archived_fieldID = jni::get_field_id(env, Class, "keepChatsFromFoldersArchived", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass attachmentMenuBot::Class;
jfieldID attachmentMenuBot::bot_user_id_fieldID;
jfieldID attachmentMenuBot::supports_self_chat_fieldID;
jfieldID attachmentMenuBot::supports_user_chats_fieldID;
jfieldID attachmentMenuBot::supports_bot_chats_fieldID;
jfieldID attachmentMenuBot::supports_group_chats_fieldID;
jfieldID attachmentMenuBot::supports_channel_chats_fieldID;
jfieldID attachmentMenuBot::request_write_access_fieldID;
jfieldID attachmentMenuBot::is_added_fieldID;
jfieldID attachmentMenuBot::show_in_attachment_menu_fieldID;
jfieldID attachmentMenuBot::show_in_side_menu_fieldID;
jfieldID attachmentMenuBot::show_disclaimer_in_side_menu_fieldID;
jfieldID attachmentMenuBot::name_fieldID;
jfieldID attachmentMenuBot::name_color_fieldID;
jfieldID attachmentMenuBot::default_icon_fieldID;
jfieldID attachmentMenuBot::ios_static_icon_fieldID;
jfieldID attachmentMenuBot::ios_animated_icon_fieldID;
jfieldID attachmentMenuBot::ios_side_menu_icon_fieldID;
jfieldID attachmentMenuBot::android_icon_fieldID;
jfieldID attachmentMenuBot::android_side_menu_icon_fieldID;
jfieldID attachmentMenuBot::macos_icon_fieldID;
jfieldID attachmentMenuBot::macos_side_menu_icon_fieldID;
jfieldID attachmentMenuBot::icon_color_fieldID;
jfieldID attachmentMenuBot::web_app_placeholder_fieldID;

attachmentMenuBot::attachmentMenuBot()
  : bot_user_id_()
  , supports_self_chat_()
  , supports_user_chats_()
  , supports_bot_chats_()
  , supports_group_chats_()
  , supports_channel_chats_()
  , request_write_access_()
  , is_added_()
  , show_in_attachment_menu_()
  , show_in_side_menu_()
  , show_disclaimer_in_side_menu_()
  , name_()
  , name_color_()
  , default_icon_()
  , ios_static_icon_()
  , ios_animated_icon_()
  , ios_side_menu_icon_()
  , android_icon_()
  , android_side_menu_icon_()
  , macos_icon_()
  , macos_side_menu_icon_()
  , icon_color_()
  , web_app_placeholder_()
{}

attachmentMenuBot::attachmentMenuBot(int53 bot_user_id_, bool supports_self_chat_, bool supports_user_chats_, bool supports_bot_chats_, bool supports_group_chats_, bool supports_channel_chats_, bool request_write_access_, bool is_added_, bool show_in_attachment_menu_, bool show_in_side_menu_, bool show_disclaimer_in_side_menu_, string const &name_, object_ptr<attachmentMenuBotColor> &&name_color_, object_ptr<file> &&default_icon_, object_ptr<file> &&ios_static_icon_, object_ptr<file> &&ios_animated_icon_, object_ptr<file> &&ios_side_menu_icon_, object_ptr<file> &&android_icon_, object_ptr<file> &&android_side_menu_icon_, object_ptr<file> &&macos_icon_, object_ptr<file> &&macos_side_menu_icon_, object_ptr<attachmentMenuBotColor> &&icon_color_, object_ptr<file> &&web_app_placeholder_)
  : bot_user_id_(bot_user_id_)
  , supports_self_chat_(supports_self_chat_)
  , supports_user_chats_(supports_user_chats_)
  , supports_bot_chats_(supports_bot_chats_)
  , supports_group_chats_(supports_group_chats_)
  , supports_channel_chats_(supports_channel_chats_)
  , request_write_access_(request_write_access_)
  , is_added_(is_added_)
  , show_in_attachment_menu_(show_in_attachment_menu_)
  , show_in_side_menu_(show_in_side_menu_)
  , show_disclaimer_in_side_menu_(show_disclaimer_in_side_menu_)
  , name_(name_)
  , name_color_(std::move(name_color_))
  , default_icon_(std::move(default_icon_))
  , ios_static_icon_(std::move(ios_static_icon_))
  , ios_animated_icon_(std::move(ios_animated_icon_))
  , ios_side_menu_icon_(std::move(ios_side_menu_icon_))
  , android_icon_(std::move(android_icon_))
  , android_side_menu_icon_(std::move(android_side_menu_icon_))
  , macos_icon_(std::move(macos_icon_))
  , macos_side_menu_icon_(std::move(macos_side_menu_icon_))
  , icon_color_(std::move(icon_color_))
  , web_app_placeholder_(std::move(web_app_placeholder_))
{}

const std::int32_t attachmentMenuBot::ID;

object_ptr<attachmentMenuBot> attachmentMenuBot::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<attachmentMenuBot> res = make_object<attachmentMenuBot>();
  res->bot_user_id_ = env->GetLongField(p, res->bot_user_id_fieldID);
  res->supports_self_chat_ = (env->GetBooleanField(p, res->supports_self_chat_fieldID) != 0);
  res->supports_user_chats_ = (env->GetBooleanField(p, res->supports_user_chats_fieldID) != 0);
  res->supports_bot_chats_ = (env->GetBooleanField(p, res->supports_bot_chats_fieldID) != 0);
  res->supports_group_chats_ = (env->GetBooleanField(p, res->supports_group_chats_fieldID) != 0);
  res->supports_channel_chats_ = (env->GetBooleanField(p, res->supports_channel_chats_fieldID) != 0);
  res->request_write_access_ = (env->GetBooleanField(p, res->request_write_access_fieldID) != 0);
  res->is_added_ = (env->GetBooleanField(p, res->is_added_fieldID) != 0);
  res->show_in_attachment_menu_ = (env->GetBooleanField(p, res->show_in_attachment_menu_fieldID) != 0);
  res->show_in_side_menu_ = (env->GetBooleanField(p, res->show_in_side_menu_fieldID) != 0);
  res->show_disclaimer_in_side_menu_ = (env->GetBooleanField(p, res->show_disclaimer_in_side_menu_fieldID) != 0);
  res->name_ = jni::fetch_string(env, p, res->name_fieldID);
  res->name_color_ = jni::fetch_tl_object<attachmentMenuBotColor>(env, jni::fetch_object(env, p, res->name_color_fieldID));
  res->default_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->default_icon_fieldID));
  res->ios_static_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->ios_static_icon_fieldID));
  res->ios_animated_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->ios_animated_icon_fieldID));
  res->ios_side_menu_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->ios_side_menu_icon_fieldID));
  res->android_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->android_icon_fieldID));
  res->android_side_menu_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->android_side_menu_icon_fieldID));
  res->macos_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->macos_icon_fieldID));
  res->macos_side_menu_icon_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->macos_side_menu_icon_fieldID));
  res->icon_color_ = jni::fetch_tl_object<attachmentMenuBotColor>(env, jni::fetch_object(env, p, res->icon_color_fieldID));
  res->web_app_placeholder_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->web_app_placeholder_fieldID));
  return res;
}

void attachmentMenuBot::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, bot_user_id_fieldID, bot_user_id_);
  env->SetBooleanField(s, supports_self_chat_fieldID, supports_self_chat_);
  env->SetBooleanField(s, supports_user_chats_fieldID, supports_user_chats_);
  env->SetBooleanField(s, supports_bot_chats_fieldID, supports_bot_chats_);
  env->SetBooleanField(s, supports_group_chats_fieldID, supports_group_chats_);
  env->SetBooleanField(s, supports_channel_chats_fieldID, supports_channel_chats_);
  env->SetBooleanField(s, request_write_access_fieldID, request_write_access_);
  env->SetBooleanField(s, is_added_fieldID, is_added_);
  env->SetBooleanField(s, show_in_attachment_menu_fieldID, show_in_attachment_menu_);
  env->SetBooleanField(s, show_in_side_menu_fieldID, show_in_side_menu_);
  env->SetBooleanField(s, show_disclaimer_in_side_menu_fieldID, show_disclaimer_in_side_menu_);
  { jstring nextString = jni::to_jstring(env, name_); if (nextString) { env->SetObjectField(s, name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (name_color_ != nullptr) { jobject next; name_color_->store(env, next); if (next) { env->SetObjectField(s, name_color_fieldID, next); env->DeleteLocalRef(next); } }
  if (default_icon_ != nullptr) { jobject next; default_icon_->store(env, next); if (next) { env->SetObjectField(s, default_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (ios_static_icon_ != nullptr) { jobject next; ios_static_icon_->store(env, next); if (next) { env->SetObjectField(s, ios_static_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (ios_animated_icon_ != nullptr) { jobject next; ios_animated_icon_->store(env, next); if (next) { env->SetObjectField(s, ios_animated_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (ios_side_menu_icon_ != nullptr) { jobject next; ios_side_menu_icon_->store(env, next); if (next) { env->SetObjectField(s, ios_side_menu_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (android_icon_ != nullptr) { jobject next; android_icon_->store(env, next); if (next) { env->SetObjectField(s, android_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (android_side_menu_icon_ != nullptr) { jobject next; android_side_menu_icon_->store(env, next); if (next) { env->SetObjectField(s, android_side_menu_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (macos_icon_ != nullptr) { jobject next; macos_icon_->store(env, next); if (next) { env->SetObjectField(s, macos_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (macos_side_menu_icon_ != nullptr) { jobject next; macos_side_menu_icon_->store(env, next); if (next) { env->SetObjectField(s, macos_side_menu_icon_fieldID, next); env->DeleteLocalRef(next); } }
  if (icon_color_ != nullptr) { jobject next; icon_color_->store(env, next); if (next) { env->SetObjectField(s, icon_color_fieldID, next); env->DeleteLocalRef(next); } }
  if (web_app_placeholder_ != nullptr) { jobject next; web_app_placeholder_->store(env, next); if (next) { env->SetObjectField(s, web_app_placeholder_fieldID, next); env->DeleteLocalRef(next); } }
}

void attachmentMenuBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AttachmentMenuBot");
    s.store_field("botUserId", bot_user_id_);
    s.store_field("supportsSelfChat", supports_self_chat_);
    s.store_field("supportsUserChats", supports_user_chats_);
    s.store_field("supportsBotChats", supports_bot_chats_);
    s.store_field("supportsGroupChats", supports_group_chats_);
    s.store_field("supportsChannelChats", supports_channel_chats_);
    s.store_field("requestWriteAccess", request_write_access_);
    s.store_field("isAdded", is_added_);
    s.store_field("showInAttachmentMenu", show_in_attachment_menu_);
    s.store_field("showInSideMenu", show_in_side_menu_);
    s.store_field("showDisclaimerInSideMenu", show_disclaimer_in_side_menu_);
    s.store_field("name", name_);
    s.store_object_field("nameColor", static_cast<const BaseObject *>(name_color_.get()));
    s.store_object_field("defaultIcon", static_cast<const BaseObject *>(default_icon_.get()));
    s.store_object_field("iosStaticIcon", static_cast<const BaseObject *>(ios_static_icon_.get()));
    s.store_object_field("iosAnimatedIcon", static_cast<const BaseObject *>(ios_animated_icon_.get()));
    s.store_object_field("iosSideMenuIcon", static_cast<const BaseObject *>(ios_side_menu_icon_.get()));
    s.store_object_field("androidIcon", static_cast<const BaseObject *>(android_icon_.get()));
    s.store_object_field("androidSideMenuIcon", static_cast<const BaseObject *>(android_side_menu_icon_.get()));
    s.store_object_field("macosIcon", static_cast<const BaseObject *>(macos_icon_.get()));
    s.store_object_field("macosSideMenuIcon", static_cast<const BaseObject *>(macos_side_menu_icon_.get()));
    s.store_object_field("iconColor", static_cast<const BaseObject *>(icon_color_.get()));
    s.store_object_field("webAppPlaceholder", static_cast<const BaseObject *>(web_app_placeholder_.get()));
    s.store_class_end();
  }
}

void attachmentMenuBot::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AttachmentMenuBot").c_str());
    bot_user_id_fieldID = jni::get_field_id(env, Class, "botUserId", "J");
    supports_self_chat_fieldID = jni::get_field_id(env, Class, "supportsSelfChat", "Z");
    supports_user_chats_fieldID = jni::get_field_id(env, Class, "supportsUserChats", "Z");
    supports_bot_chats_fieldID = jni::get_field_id(env, Class, "supportsBotChats", "Z");
    supports_group_chats_fieldID = jni::get_field_id(env, Class, "supportsGroupChats", "Z");
    supports_channel_chats_fieldID = jni::get_field_id(env, Class, "supportsChannelChats", "Z");
    request_write_access_fieldID = jni::get_field_id(env, Class, "requestWriteAccess", "Z");
    is_added_fieldID = jni::get_field_id(env, Class, "isAdded", "Z");
    show_in_attachment_menu_fieldID = jni::get_field_id(env, Class, "showInAttachmentMenu", "Z");
    show_in_side_menu_fieldID = jni::get_field_id(env, Class, "showInSideMenu", "Z");
    show_disclaimer_in_side_menu_fieldID = jni::get_field_id(env, Class, "showDisclaimerInSideMenu", "Z");
    name_fieldID = jni::get_field_id(env, Class, "name", "Ljava/lang/String;");
    name_color_fieldID = jni::get_field_id(env, Class, "nameColor", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AttachmentMenuBotColor;").c_str());
    default_icon_fieldID = jni::get_field_id(env, Class, "defaultIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    ios_static_icon_fieldID = jni::get_field_id(env, Class, "iosStaticIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    ios_animated_icon_fieldID = jni::get_field_id(env, Class, "iosAnimatedIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    ios_side_menu_icon_fieldID = jni::get_field_id(env, Class, "iosSideMenuIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    android_icon_fieldID = jni::get_field_id(env, Class, "androidIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    android_side_menu_icon_fieldID = jni::get_field_id(env, Class, "androidSideMenuIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    macos_icon_fieldID = jni::get_field_id(env, Class, "macosIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    macos_side_menu_icon_fieldID = jni::get_field_id(env, Class, "macosSideMenuIcon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    icon_color_fieldID = jni::get_field_id(env, Class, "iconColor", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AttachmentMenuBotColor;").c_str());
    web_app_placeholder_fieldID = jni::get_field_id(env, Class, "webAppPlaceholder", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass attachmentMenuBotColor::Class;
jfieldID attachmentMenuBotColor::light_color_fieldID;
jfieldID attachmentMenuBotColor::dark_color_fieldID;

attachmentMenuBotColor::attachmentMenuBotColor()
  : light_color_()
  , dark_color_()
{}

attachmentMenuBotColor::attachmentMenuBotColor(int32 light_color_, int32 dark_color_)
  : light_color_(light_color_)
  , dark_color_(dark_color_)
{}

const std::int32_t attachmentMenuBotColor::ID;

object_ptr<attachmentMenuBotColor> attachmentMenuBotColor::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<attachmentMenuBotColor> res = make_object<attachmentMenuBotColor>();
  res->light_color_ = env->GetIntField(p, res->light_color_fieldID);
  res->dark_color_ = env->GetIntField(p, res->dark_color_fieldID);
  return res;
}

void attachmentMenuBotColor::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, light_color_fieldID, light_color_);
  env->SetIntField(s, dark_color_fieldID, dark_color_);
}

void attachmentMenuBotColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AttachmentMenuBotColor");
    s.store_field("lightColor", light_color_);
    s.store_field("darkColor", dark_color_);
    s.store_class_end();
  }
}

void attachmentMenuBotColor::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AttachmentMenuBotColor").c_str());
    light_color_fieldID = jni::get_field_id(env, Class, "lightColor", "I");
    dark_color_fieldID = jni::get_field_id(env, Class, "darkColor", "I");
    return true;
  }();
  (void)is_inited;
}

jclass audio::Class;
jfieldID audio::duration_fieldID;
jfieldID audio::title_fieldID;
jfieldID audio::performer_fieldID;
jfieldID audio::file_name_fieldID;
jfieldID audio::mime_type_fieldID;
jfieldID audio::album_cover_minithumbnail_fieldID;
jfieldID audio::album_cover_thumbnail_fieldID;
jfieldID audio::external_album_covers_fieldID;
jfieldID audio::audio_fieldID;

audio::audio()
  : duration_()
  , title_()
  , performer_()
  , file_name_()
  , mime_type_()
  , album_cover_minithumbnail_()
  , album_cover_thumbnail_()
  , external_album_covers_()
  , audio_()
{}

audio::audio(int32 duration_, string const &title_, string const &performer_, string const &file_name_, string const &mime_type_, object_ptr<minithumbnail> &&album_cover_minithumbnail_, object_ptr<thumbnail> &&album_cover_thumbnail_, array<object_ptr<thumbnail>> &&external_album_covers_, object_ptr<file> &&audio_)
  : duration_(duration_)
  , title_(title_)
  , performer_(performer_)
  , file_name_(file_name_)
  , mime_type_(mime_type_)
  , album_cover_minithumbnail_(std::move(album_cover_minithumbnail_))
  , album_cover_thumbnail_(std::move(album_cover_thumbnail_))
  , external_album_covers_(std::move(external_album_covers_))
  , audio_(std::move(audio_))
{}

const std::int32_t audio::ID;

object_ptr<audio> audio::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<audio> res = make_object<audio>();
  res->duration_ = env->GetIntField(p, res->duration_fieldID);
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->performer_ = jni::fetch_string(env, p, res->performer_fieldID);
  res->file_name_ = jni::fetch_string(env, p, res->file_name_fieldID);
  res->mime_type_ = jni::fetch_string(env, p, res->mime_type_fieldID);
  res->album_cover_minithumbnail_ = jni::fetch_tl_object<minithumbnail>(env, jni::fetch_object(env, p, res->album_cover_minithumbnail_fieldID));
  res->album_cover_thumbnail_ = jni::fetch_tl_object<thumbnail>(env, jni::fetch_object(env, p, res->album_cover_thumbnail_fieldID));
  res->external_album_covers_ = jni::FetchVector<thumbnail>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->external_album_covers_fieldID));
  res->audio_ = jni::fetch_tl_object<file>(env, jni::fetch_object(env, p, res->audio_fieldID));
  return res;
}

void audio::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, duration_fieldID, duration_);
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, performer_); if (nextString) { env->SetObjectField(s, performer_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, file_name_); if (nextString) { env->SetObjectField(s, file_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, mime_type_); if (nextString) { env->SetObjectField(s, mime_type_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (album_cover_minithumbnail_ != nullptr) { jobject next; album_cover_minithumbnail_->store(env, next); if (next) { env->SetObjectField(s, album_cover_minithumbnail_fieldID, next); env->DeleteLocalRef(next); } }
  if (album_cover_thumbnail_ != nullptr) { jobject next; album_cover_thumbnail_->store(env, next); if (next) { env->SetObjectField(s, album_cover_thumbnail_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, external_album_covers_); if (arr_tmp_) { env->SetObjectField(s, external_album_covers_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  if (audio_ != nullptr) { jobject next; audio_->store(env, next); if (next) { env->SetObjectField(s, audio_fieldID, next); env->DeleteLocalRef(next); } }
}

void audio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Audio");
    s.store_field("duration", duration_);
    s.store_field("title", title_);
    s.store_field("performer", performer_);
    s.store_field("fileName", file_name_);
    s.store_field("mimeType", mime_type_);
    s.store_object_field("albumCoverMinithumbnail", static_cast<const BaseObject *>(album_cover_minithumbnail_.get()));
    s.store_object_field("albumCoverThumbnail", static_cast<const BaseObject *>(album_cover_thumbnail_.get()));
    { s.store_vector_begin("externalAlbumCovers", external_album_covers_.size()); for (const auto &_value : external_album_covers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_class_end();
  }
}

void audio::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Audio").c_str());
    duration_fieldID = jni::get_field_id(env, Class, "duration", "I");
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    performer_fieldID = jni::get_field_id(env, Class, "performer", "Ljava/lang/String;");
    file_name_fieldID = jni::get_field_id(env, Class, "fileName", "Ljava/lang/String;");
    mime_type_fieldID = jni::get_field_id(env, Class, "mimeType", "Ljava/lang/String;");
    album_cover_minithumbnail_fieldID = jni::get_field_id(env, Class, "albumCoverMinithumbnail", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Minithumbnail;").c_str());
    album_cover_thumbnail_fieldID = jni::get_field_id(env, Class, "albumCoverThumbnail", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Thumbnail;").c_str());
    external_album_covers_fieldID = jni::get_field_id(env, Class, "externalAlbumCovers", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$Thumbnail;").c_str());
    audio_fieldID = jni::get_field_id(env, Class, "audio", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$File;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeInfo::Class;
jfieldID authenticationCodeInfo::phone_number_fieldID;
jfieldID authenticationCodeInfo::type_fieldID;
jfieldID authenticationCodeInfo::next_type_fieldID;
jfieldID authenticationCodeInfo::timeout_fieldID;

authenticationCodeInfo::authenticationCodeInfo()
  : phone_number_()
  , type_()
  , next_type_()
  , timeout_()
{}

authenticationCodeInfo::authenticationCodeInfo(string const &phone_number_, object_ptr<AuthenticationCodeType> &&type_, object_ptr<AuthenticationCodeType> &&next_type_, int32 timeout_)
  : phone_number_(phone_number_)
  , type_(std::move(type_))
  , next_type_(std::move(next_type_))
  , timeout_(timeout_)
{}

const std::int32_t authenticationCodeInfo::ID;

object_ptr<authenticationCodeInfo> authenticationCodeInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeInfo> res = make_object<authenticationCodeInfo>();
  res->phone_number_ = jni::fetch_string(env, p, res->phone_number_fieldID);
  res->type_ = jni::fetch_tl_object<AuthenticationCodeType>(env, jni::fetch_object(env, p, res->type_fieldID));
  res->next_type_ = jni::fetch_tl_object<AuthenticationCodeType>(env, jni::fetch_object(env, p, res->next_type_fieldID));
  res->timeout_ = env->GetIntField(p, res->timeout_fieldID);
  return res;
}

void authenticationCodeInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, phone_number_); if (nextString) { env->SetObjectField(s, phone_number_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
  if (next_type_ != nullptr) { jobject next; next_type_->store(env, next); if (next) { env->SetObjectField(s, next_type_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, timeout_fieldID, timeout_);
}

void authenticationCodeInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeInfo");
    s.store_field("phoneNumber", phone_number_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("nextType", static_cast<const BaseObject *>(next_type_.get()));
    s.store_field("timeout", timeout_);
    s.store_class_end();
  }
}

void authenticationCodeInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeInfo").c_str());
    phone_number_fieldID = jni::get_field_id(env, Class, "phoneNumber", "Ljava/lang/String;");
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AuthenticationCodeType;").c_str());
    next_type_fieldID = jni::get_field_id(env, Class, "nextType", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AuthenticationCodeType;").c_str());
    timeout_fieldID = jni::get_field_id(env, Class, "timeout", "I");
    return true;
  }();
  (void)is_inited;
}

jclass AuthenticationCodeType::Class;

object_ptr<AuthenticationCodeType> AuthenticationCodeType::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case authenticationCodeTypeTelegramMessage::ID:
      return authenticationCodeTypeTelegramMessage::fetch(env, p);
    case authenticationCodeTypeSms::ID:
      return authenticationCodeTypeSms::fetch(env, p);
    case authenticationCodeTypeSmsWord::ID:
      return authenticationCodeTypeSmsWord::fetch(env, p);
    case authenticationCodeTypeSmsPhrase::ID:
      return authenticationCodeTypeSmsPhrase::fetch(env, p);
    case authenticationCodeTypeCall::ID:
      return authenticationCodeTypeCall::fetch(env, p);
    case authenticationCodeTypeFlashCall::ID:
      return authenticationCodeTypeFlashCall::fetch(env, p);
    case authenticationCodeTypeMissedCall::ID:
      return authenticationCodeTypeMissedCall::fetch(env, p);
    case authenticationCodeTypeFragment::ID:
      return authenticationCodeTypeFragment::fetch(env, p);
    case authenticationCodeTypeFirebaseAndroid::ID:
      return authenticationCodeTypeFirebaseAndroid::fetch(env, p);
    case authenticationCodeTypeFirebaseIos::ID:
      return authenticationCodeTypeFirebaseIos::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void AuthenticationCodeType::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeType").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeTelegramMessage::Class;
jfieldID authenticationCodeTypeTelegramMessage::length_fieldID;

authenticationCodeTypeTelegramMessage::authenticationCodeTypeTelegramMessage()
  : length_()
{}

authenticationCodeTypeTelegramMessage::authenticationCodeTypeTelegramMessage(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeTelegramMessage::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeTelegramMessage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeTelegramMessage> res = make_object<authenticationCodeTypeTelegramMessage>();
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeTelegramMessage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeTelegramMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeTelegramMessage");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeTelegramMessage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeTelegramMessage").c_str());
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeSms::Class;
jfieldID authenticationCodeTypeSms::length_fieldID;

authenticationCodeTypeSms::authenticationCodeTypeSms()
  : length_()
{}

authenticationCodeTypeSms::authenticationCodeTypeSms(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeSms::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeSms::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeSms> res = make_object<authenticationCodeTypeSms>();
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeSms::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeSms::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeSms");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeSms::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeSms").c_str());
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeSmsWord::Class;
jfieldID authenticationCodeTypeSmsWord::first_letter_fieldID;

authenticationCodeTypeSmsWord::authenticationCodeTypeSmsWord()
  : first_letter_()
{}

authenticationCodeTypeSmsWord::authenticationCodeTypeSmsWord(string const &first_letter_)
  : first_letter_(first_letter_)
{}

const std::int32_t authenticationCodeTypeSmsWord::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeSmsWord::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeSmsWord> res = make_object<authenticationCodeTypeSmsWord>();
  res->first_letter_ = jni::fetch_string(env, p, res->first_letter_fieldID);
  return std::move(res);
}

void authenticationCodeTypeSmsWord::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, first_letter_); if (nextString) { env->SetObjectField(s, first_letter_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authenticationCodeTypeSmsWord::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeSmsWord");
    s.store_field("firstLetter", first_letter_);
    s.store_class_end();
  }
}

void authenticationCodeTypeSmsWord::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeSmsWord").c_str());
    first_letter_fieldID = jni::get_field_id(env, Class, "firstLetter", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeSmsPhrase::Class;
jfieldID authenticationCodeTypeSmsPhrase::first_word_fieldID;

authenticationCodeTypeSmsPhrase::authenticationCodeTypeSmsPhrase()
  : first_word_()
{}

authenticationCodeTypeSmsPhrase::authenticationCodeTypeSmsPhrase(string const &first_word_)
  : first_word_(first_word_)
{}

const std::int32_t authenticationCodeTypeSmsPhrase::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeSmsPhrase::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeSmsPhrase> res = make_object<authenticationCodeTypeSmsPhrase>();
  res->first_word_ = jni::fetch_string(env, p, res->first_word_fieldID);
  return std::move(res);
}

void authenticationCodeTypeSmsPhrase::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, first_word_); if (nextString) { env->SetObjectField(s, first_word_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authenticationCodeTypeSmsPhrase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeSmsPhrase");
    s.store_field("firstWord", first_word_);
    s.store_class_end();
  }
}

void authenticationCodeTypeSmsPhrase::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeSmsPhrase").c_str());
    first_word_fieldID = jni::get_field_id(env, Class, "firstWord", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeCall::Class;
jfieldID authenticationCodeTypeCall::length_fieldID;

authenticationCodeTypeCall::authenticationCodeTypeCall()
  : length_()
{}

authenticationCodeTypeCall::authenticationCodeTypeCall(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeCall::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeCall::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeCall> res = make_object<authenticationCodeTypeCall>();
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeCall::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeCall");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeCall::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeCall").c_str());
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeFlashCall::Class;
jfieldID authenticationCodeTypeFlashCall::pattern_fieldID;

authenticationCodeTypeFlashCall::authenticationCodeTypeFlashCall()
  : pattern_()
{}

authenticationCodeTypeFlashCall::authenticationCodeTypeFlashCall(string const &pattern_)
  : pattern_(pattern_)
{}

const std::int32_t authenticationCodeTypeFlashCall::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeFlashCall::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeFlashCall> res = make_object<authenticationCodeTypeFlashCall>();
  res->pattern_ = jni::fetch_string(env, p, res->pattern_fieldID);
  return std::move(res);
}

void authenticationCodeTypeFlashCall::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, pattern_); if (nextString) { env->SetObjectField(s, pattern_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authenticationCodeTypeFlashCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeFlashCall");
    s.store_field("pattern", pattern_);
    s.store_class_end();
  }
}

void authenticationCodeTypeFlashCall::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeFlashCall").c_str());
    pattern_fieldID = jni::get_field_id(env, Class, "pattern", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeMissedCall::Class;
jfieldID authenticationCodeTypeMissedCall::phone_number_prefix_fieldID;
jfieldID authenticationCodeTypeMissedCall::length_fieldID;

authenticationCodeTypeMissedCall::authenticationCodeTypeMissedCall()
  : phone_number_prefix_()
  , length_()
{}

authenticationCodeTypeMissedCall::authenticationCodeTypeMissedCall(string const &phone_number_prefix_, int32 length_)
  : phone_number_prefix_(phone_number_prefix_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeMissedCall::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeMissedCall::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeMissedCall> res = make_object<authenticationCodeTypeMissedCall>();
  res->phone_number_prefix_ = jni::fetch_string(env, p, res->phone_number_prefix_fieldID);
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeMissedCall::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, phone_number_prefix_); if (nextString) { env->SetObjectField(s, phone_number_prefix_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeMissedCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeMissedCall");
    s.store_field("phoneNumberPrefix", phone_number_prefix_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeMissedCall::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeMissedCall").c_str());
    phone_number_prefix_fieldID = jni::get_field_id(env, Class, "phoneNumberPrefix", "Ljava/lang/String;");
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeFragment::Class;
jfieldID authenticationCodeTypeFragment::url_fieldID;
jfieldID authenticationCodeTypeFragment::length_fieldID;

authenticationCodeTypeFragment::authenticationCodeTypeFragment()
  : url_()
  , length_()
{}

authenticationCodeTypeFragment::authenticationCodeTypeFragment(string const &url_, int32 length_)
  : url_(url_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFragment::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeFragment::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeFragment> res = make_object<authenticationCodeTypeFragment>();
  res->url_ = jni::fetch_string(env, p, res->url_fieldID);
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeFragment::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, url_); if (nextString) { env->SetObjectField(s, url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeFragment::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeFragment");
    s.store_field("url", url_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeFragment::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeFragment").c_str());
    url_fieldID = jni::get_field_id(env, Class, "url", "Ljava/lang/String;");
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeFirebaseAndroid::Class;
jfieldID authenticationCodeTypeFirebaseAndroid::device_verification_parameters_fieldID;
jfieldID authenticationCodeTypeFirebaseAndroid::length_fieldID;

authenticationCodeTypeFirebaseAndroid::authenticationCodeTypeFirebaseAndroid()
  : device_verification_parameters_()
  , length_()
{}

authenticationCodeTypeFirebaseAndroid::authenticationCodeTypeFirebaseAndroid(object_ptr<FirebaseDeviceVerificationParameters> &&device_verification_parameters_, int32 length_)
  : device_verification_parameters_(std::move(device_verification_parameters_))
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFirebaseAndroid::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeFirebaseAndroid::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeFirebaseAndroid> res = make_object<authenticationCodeTypeFirebaseAndroid>();
  res->device_verification_parameters_ = jni::fetch_tl_object<FirebaseDeviceVerificationParameters>(env, jni::fetch_object(env, p, res->device_verification_parameters_fieldID));
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeFirebaseAndroid::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (device_verification_parameters_ != nullptr) { jobject next; device_verification_parameters_->store(env, next); if (next) { env->SetObjectField(s, device_verification_parameters_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeFirebaseAndroid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeFirebaseAndroid");
    s.store_object_field("deviceVerificationParameters", static_cast<const BaseObject *>(device_verification_parameters_.get()));
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeFirebaseAndroid::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeFirebaseAndroid").c_str());
    device_verification_parameters_fieldID = jni::get_field_id(env, Class, "deviceVerificationParameters", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FirebaseDeviceVerificationParameters;").c_str());
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass authenticationCodeTypeFirebaseIos::Class;
jfieldID authenticationCodeTypeFirebaseIos::receipt_fieldID;
jfieldID authenticationCodeTypeFirebaseIos::push_timeout_fieldID;
jfieldID authenticationCodeTypeFirebaseIos::length_fieldID;

authenticationCodeTypeFirebaseIos::authenticationCodeTypeFirebaseIos()
  : receipt_()
  , push_timeout_()
  , length_()
{}

authenticationCodeTypeFirebaseIos::authenticationCodeTypeFirebaseIos(string const &receipt_, int32 push_timeout_, int32 length_)
  : receipt_(receipt_)
  , push_timeout_(push_timeout_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFirebaseIos::ID;

object_ptr<AuthenticationCodeType> authenticationCodeTypeFirebaseIos::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authenticationCodeTypeFirebaseIos> res = make_object<authenticationCodeTypeFirebaseIos>();
  res->receipt_ = jni::fetch_string(env, p, res->receipt_fieldID);
  res->push_timeout_ = env->GetIntField(p, res->push_timeout_fieldID);
  res->length_ = env->GetIntField(p, res->length_fieldID);
  return std::move(res);
}

void authenticationCodeTypeFirebaseIos::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, receipt_); if (nextString) { env->SetObjectField(s, receipt_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, push_timeout_fieldID, push_timeout_);
  env->SetIntField(s, length_fieldID, length_);
}

void authenticationCodeTypeFirebaseIos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthenticationCodeTypeFirebaseIos");
    s.store_field("receipt", receipt_);
    s.store_field("pushTimeout", push_timeout_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

void authenticationCodeTypeFirebaseIos::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthenticationCodeTypeFirebaseIos").c_str());
    receipt_fieldID = jni::get_field_id(env, Class, "receipt", "Ljava/lang/String;");
    push_timeout_fieldID = jni::get_field_id(env, Class, "pushTimeout", "I");
    length_fieldID = jni::get_field_id(env, Class, "length", "I");
    return true;
  }();
  (void)is_inited;
}

jclass AuthorizationState::Class;

object_ptr<AuthorizationState> AuthorizationState::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case authorizationStateWaitTdlibParameters::ID:
      return authorizationStateWaitTdlibParameters::fetch(env, p);
    case authorizationStateWaitPhoneNumber::ID:
      return authorizationStateWaitPhoneNumber::fetch(env, p);
    case authorizationStateWaitPremiumPurchase::ID:
      return authorizationStateWaitPremiumPurchase::fetch(env, p);
    case authorizationStateWaitEmailAddress::ID:
      return authorizationStateWaitEmailAddress::fetch(env, p);
    case authorizationStateWaitEmailCode::ID:
      return authorizationStateWaitEmailCode::fetch(env, p);
    case authorizationStateWaitCode::ID:
      return authorizationStateWaitCode::fetch(env, p);
    case authorizationStateWaitOtherDeviceConfirmation::ID:
      return authorizationStateWaitOtherDeviceConfirmation::fetch(env, p);
    case authorizationStateWaitRegistration::ID:
      return authorizationStateWaitRegistration::fetch(env, p);
    case authorizationStateWaitPassword::ID:
      return authorizationStateWaitPassword::fetch(env, p);
    case authorizationStateReady::ID:
      return authorizationStateReady::fetch(env, p);
    case authorizationStateLoggingOut::ID:
      return authorizationStateLoggingOut::fetch(env, p);
    case authorizationStateClosing::ID:
      return authorizationStateClosing::fetch(env, p);
    case authorizationStateClosed::ID:
      return authorizationStateClosed::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void AuthorizationState::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationState").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitTdlibParameters::Class;

authorizationStateWaitTdlibParameters::authorizationStateWaitTdlibParameters() {
}

const std::int32_t authorizationStateWaitTdlibParameters::ID;

object_ptr<AuthorizationState> authorizationStateWaitTdlibParameters::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateWaitTdlibParameters>();
}

void authorizationStateWaitTdlibParameters::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateWaitTdlibParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitTdlibParameters");
    s.store_class_end();
  }
}

void authorizationStateWaitTdlibParameters::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitTdlibParameters").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitPhoneNumber::Class;

authorizationStateWaitPhoneNumber::authorizationStateWaitPhoneNumber() {
}

const std::int32_t authorizationStateWaitPhoneNumber::ID;

object_ptr<AuthorizationState> authorizationStateWaitPhoneNumber::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateWaitPhoneNumber>();
}

void authorizationStateWaitPhoneNumber::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateWaitPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitPhoneNumber");
    s.store_class_end();
  }
}

void authorizationStateWaitPhoneNumber::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitPhoneNumber").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitPremiumPurchase::Class;
jfieldID authorizationStateWaitPremiumPurchase::store_product_id_fieldID;

authorizationStateWaitPremiumPurchase::authorizationStateWaitPremiumPurchase()
  : store_product_id_()
{}

authorizationStateWaitPremiumPurchase::authorizationStateWaitPremiumPurchase(string const &store_product_id_)
  : store_product_id_(store_product_id_)
{}

const std::int32_t authorizationStateWaitPremiumPurchase::ID;

object_ptr<AuthorizationState> authorizationStateWaitPremiumPurchase::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitPremiumPurchase> res = make_object<authorizationStateWaitPremiumPurchase>();
  res->store_product_id_ = jni::fetch_string(env, p, res->store_product_id_fieldID);
  return std::move(res);
}

void authorizationStateWaitPremiumPurchase::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, store_product_id_); if (nextString) { env->SetObjectField(s, store_product_id_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authorizationStateWaitPremiumPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitPremiumPurchase");
    s.store_field("storeProductId", store_product_id_);
    s.store_class_end();
  }
}

void authorizationStateWaitPremiumPurchase::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitPremiumPurchase").c_str());
    store_product_id_fieldID = jni::get_field_id(env, Class, "storeProductId", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitEmailAddress::Class;
jfieldID authorizationStateWaitEmailAddress::allow_apple_id_fieldID;
jfieldID authorizationStateWaitEmailAddress::allow_google_id_fieldID;

authorizationStateWaitEmailAddress::authorizationStateWaitEmailAddress()
  : allow_apple_id_()
  , allow_google_id_()
{}

authorizationStateWaitEmailAddress::authorizationStateWaitEmailAddress(bool allow_apple_id_, bool allow_google_id_)
  : allow_apple_id_(allow_apple_id_)
  , allow_google_id_(allow_google_id_)
{}

const std::int32_t authorizationStateWaitEmailAddress::ID;

object_ptr<AuthorizationState> authorizationStateWaitEmailAddress::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitEmailAddress> res = make_object<authorizationStateWaitEmailAddress>();
  res->allow_apple_id_ = (env->GetBooleanField(p, res->allow_apple_id_fieldID) != 0);
  res->allow_google_id_ = (env->GetBooleanField(p, res->allow_google_id_fieldID) != 0);
  return std::move(res);
}

void authorizationStateWaitEmailAddress::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, allow_apple_id_fieldID, allow_apple_id_);
  env->SetBooleanField(s, allow_google_id_fieldID, allow_google_id_);
}

void authorizationStateWaitEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitEmailAddress");
    s.store_field("allowAppleId", allow_apple_id_);
    s.store_field("allowGoogleId", allow_google_id_);
    s.store_class_end();
  }
}

void authorizationStateWaitEmailAddress::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitEmailAddress").c_str());
    allow_apple_id_fieldID = jni::get_field_id(env, Class, "allowAppleId", "Z");
    allow_google_id_fieldID = jni::get_field_id(env, Class, "allowGoogleId", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitEmailCode::Class;
jfieldID authorizationStateWaitEmailCode::allow_apple_id_fieldID;
jfieldID authorizationStateWaitEmailCode::allow_google_id_fieldID;
jfieldID authorizationStateWaitEmailCode::code_info_fieldID;
jfieldID authorizationStateWaitEmailCode::email_address_reset_state_fieldID;

authorizationStateWaitEmailCode::authorizationStateWaitEmailCode()
  : allow_apple_id_()
  , allow_google_id_()
  , code_info_()
  , email_address_reset_state_()
{}

authorizationStateWaitEmailCode::authorizationStateWaitEmailCode(bool allow_apple_id_, bool allow_google_id_, object_ptr<emailAddressAuthenticationCodeInfo> &&code_info_, object_ptr<EmailAddressResetState> &&email_address_reset_state_)
  : allow_apple_id_(allow_apple_id_)
  , allow_google_id_(allow_google_id_)
  , code_info_(std::move(code_info_))
  , email_address_reset_state_(std::move(email_address_reset_state_))
{}

const std::int32_t authorizationStateWaitEmailCode::ID;

object_ptr<AuthorizationState> authorizationStateWaitEmailCode::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitEmailCode> res = make_object<authorizationStateWaitEmailCode>();
  res->allow_apple_id_ = (env->GetBooleanField(p, res->allow_apple_id_fieldID) != 0);
  res->allow_google_id_ = (env->GetBooleanField(p, res->allow_google_id_fieldID) != 0);
  res->code_info_ = jni::fetch_tl_object<emailAddressAuthenticationCodeInfo>(env, jni::fetch_object(env, p, res->code_info_fieldID));
  res->email_address_reset_state_ = jni::fetch_tl_object<EmailAddressResetState>(env, jni::fetch_object(env, p, res->email_address_reset_state_fieldID));
  return std::move(res);
}

void authorizationStateWaitEmailCode::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, allow_apple_id_fieldID, allow_apple_id_);
  env->SetBooleanField(s, allow_google_id_fieldID, allow_google_id_);
  if (code_info_ != nullptr) { jobject next; code_info_->store(env, next); if (next) { env->SetObjectField(s, code_info_fieldID, next); env->DeleteLocalRef(next); } }
  if (email_address_reset_state_ != nullptr) { jobject next; email_address_reset_state_->store(env, next); if (next) { env->SetObjectField(s, email_address_reset_state_fieldID, next); env->DeleteLocalRef(next); } }
}

void authorizationStateWaitEmailCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitEmailCode");
    s.store_field("allowAppleId", allow_apple_id_);
    s.store_field("allowGoogleId", allow_google_id_);
    s.store_object_field("codeInfo", static_cast<const BaseObject *>(code_info_.get()));
    s.store_object_field("emailAddressResetState", static_cast<const BaseObject *>(email_address_reset_state_.get()));
    s.store_class_end();
  }
}

void authorizationStateWaitEmailCode::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitEmailCode").c_str());
    allow_apple_id_fieldID = jni::get_field_id(env, Class, "allowAppleId", "Z");
    allow_google_id_fieldID = jni::get_field_id(env, Class, "allowGoogleId", "Z");
    code_info_fieldID = jni::get_field_id(env, Class, "codeInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$EmailAddressAuthenticationCodeInfo;").c_str());
    email_address_reset_state_fieldID = jni::get_field_id(env, Class, "emailAddressResetState", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$EmailAddressResetState;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitCode::Class;
jfieldID authorizationStateWaitCode::code_info_fieldID;

authorizationStateWaitCode::authorizationStateWaitCode()
  : code_info_()
{}

authorizationStateWaitCode::authorizationStateWaitCode(object_ptr<authenticationCodeInfo> &&code_info_)
  : code_info_(std::move(code_info_))
{}

const std::int32_t authorizationStateWaitCode::ID;

object_ptr<AuthorizationState> authorizationStateWaitCode::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitCode> res = make_object<authorizationStateWaitCode>();
  res->code_info_ = jni::fetch_tl_object<authenticationCodeInfo>(env, jni::fetch_object(env, p, res->code_info_fieldID));
  return std::move(res);
}

void authorizationStateWaitCode::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (code_info_ != nullptr) { jobject next; code_info_->store(env, next); if (next) { env->SetObjectField(s, code_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void authorizationStateWaitCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitCode");
    s.store_object_field("codeInfo", static_cast<const BaseObject *>(code_info_.get()));
    s.store_class_end();
  }
}

void authorizationStateWaitCode::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitCode").c_str());
    code_info_fieldID = jni::get_field_id(env, Class, "codeInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AuthenticationCodeInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitOtherDeviceConfirmation::Class;
jfieldID authorizationStateWaitOtherDeviceConfirmation::link_fieldID;

authorizationStateWaitOtherDeviceConfirmation::authorizationStateWaitOtherDeviceConfirmation()
  : link_()
{}

authorizationStateWaitOtherDeviceConfirmation::authorizationStateWaitOtherDeviceConfirmation(string const &link_)
  : link_(link_)
{}

const std::int32_t authorizationStateWaitOtherDeviceConfirmation::ID;

object_ptr<AuthorizationState> authorizationStateWaitOtherDeviceConfirmation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitOtherDeviceConfirmation> res = make_object<authorizationStateWaitOtherDeviceConfirmation>();
  res->link_ = jni::fetch_string(env, p, res->link_fieldID);
  return std::move(res);
}

void authorizationStateWaitOtherDeviceConfirmation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, link_); if (nextString) { env->SetObjectField(s, link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authorizationStateWaitOtherDeviceConfirmation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitOtherDeviceConfirmation");
    s.store_field("link", link_);
    s.store_class_end();
  }
}

void authorizationStateWaitOtherDeviceConfirmation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitOtherDeviceConfirmation").c_str());
    link_fieldID = jni::get_field_id(env, Class, "link", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitRegistration::Class;
jfieldID authorizationStateWaitRegistration::terms_of_service_fieldID;

authorizationStateWaitRegistration::authorizationStateWaitRegistration()
  : terms_of_service_()
{}

authorizationStateWaitRegistration::authorizationStateWaitRegistration(object_ptr<termsOfService> &&terms_of_service_)
  : terms_of_service_(std::move(terms_of_service_))
{}

const std::int32_t authorizationStateWaitRegistration::ID;

object_ptr<AuthorizationState> authorizationStateWaitRegistration::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitRegistration> res = make_object<authorizationStateWaitRegistration>();
  res->terms_of_service_ = jni::fetch_tl_object<termsOfService>(env, jni::fetch_object(env, p, res->terms_of_service_fieldID));
  return std::move(res);
}

void authorizationStateWaitRegistration::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (terms_of_service_ != nullptr) { jobject next; terms_of_service_->store(env, next); if (next) { env->SetObjectField(s, terms_of_service_fieldID, next); env->DeleteLocalRef(next); } }
}

void authorizationStateWaitRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitRegistration");
    s.store_object_field("termsOfService", static_cast<const BaseObject *>(terms_of_service_.get()));
    s.store_class_end();
  }
}

void authorizationStateWaitRegistration::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitRegistration").c_str());
    terms_of_service_fieldID = jni::get_field_id(env, Class, "termsOfService", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$TermsOfService;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateWaitPassword::Class;
jfieldID authorizationStateWaitPassword::password_hint_fieldID;
jfieldID authorizationStateWaitPassword::has_recovery_email_address_fieldID;
jfieldID authorizationStateWaitPassword::has_passport_data_fieldID;
jfieldID authorizationStateWaitPassword::recovery_email_address_pattern_fieldID;

authorizationStateWaitPassword::authorizationStateWaitPassword()
  : password_hint_()
  , has_recovery_email_address_()
  , has_passport_data_()
  , recovery_email_address_pattern_()
{}

authorizationStateWaitPassword::authorizationStateWaitPassword(string const &password_hint_, bool has_recovery_email_address_, bool has_passport_data_, string const &recovery_email_address_pattern_)
  : password_hint_(password_hint_)
  , has_recovery_email_address_(has_recovery_email_address_)
  , has_passport_data_(has_passport_data_)
  , recovery_email_address_pattern_(recovery_email_address_pattern_)
{}

const std::int32_t authorizationStateWaitPassword::ID;

object_ptr<AuthorizationState> authorizationStateWaitPassword::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<authorizationStateWaitPassword> res = make_object<authorizationStateWaitPassword>();
  res->password_hint_ = jni::fetch_string(env, p, res->password_hint_fieldID);
  res->has_recovery_email_address_ = (env->GetBooleanField(p, res->has_recovery_email_address_fieldID) != 0);
  res->has_passport_data_ = (env->GetBooleanField(p, res->has_passport_data_fieldID) != 0);
  res->recovery_email_address_pattern_ = jni::fetch_string(env, p, res->recovery_email_address_pattern_fieldID);
  return std::move(res);
}

void authorizationStateWaitPassword::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, password_hint_); if (nextString) { env->SetObjectField(s, password_hint_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, has_recovery_email_address_fieldID, has_recovery_email_address_);
  env->SetBooleanField(s, has_passport_data_fieldID, has_passport_data_);
  { jstring nextString = jni::to_jstring(env, recovery_email_address_pattern_); if (nextString) { env->SetObjectField(s, recovery_email_address_pattern_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void authorizationStateWaitPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateWaitPassword");
    s.store_field("passwordHint", password_hint_);
    s.store_field("hasRecoveryEmailAddress", has_recovery_email_address_);
    s.store_field("hasPassportData", has_passport_data_);
    s.store_field("recoveryEmailAddressPattern", recovery_email_address_pattern_);
    s.store_class_end();
  }
}

void authorizationStateWaitPassword::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateWaitPassword").c_str());
    password_hint_fieldID = jni::get_field_id(env, Class, "passwordHint", "Ljava/lang/String;");
    has_recovery_email_address_fieldID = jni::get_field_id(env, Class, "hasRecoveryEmailAddress", "Z");
    has_passport_data_fieldID = jni::get_field_id(env, Class, "hasPassportData", "Z");
    recovery_email_address_pattern_fieldID = jni::get_field_id(env, Class, "recoveryEmailAddressPattern", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateReady::Class;

authorizationStateReady::authorizationStateReady() {
}

const std::int32_t authorizationStateReady::ID;

object_ptr<AuthorizationState> authorizationStateReady::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateReady>();
}

void authorizationStateReady::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateReady");
    s.store_class_end();
  }
}

void authorizationStateReady::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateReady").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateLoggingOut::Class;

authorizationStateLoggingOut::authorizationStateLoggingOut() {
}

const std::int32_t authorizationStateLoggingOut::ID;

object_ptr<AuthorizationState> authorizationStateLoggingOut::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateLoggingOut>();
}

void authorizationStateLoggingOut::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateLoggingOut::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateLoggingOut");
    s.store_class_end();
  }
}

void authorizationStateLoggingOut::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateLoggingOut").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateClosing::Class;

authorizationStateClosing::authorizationStateClosing() {
}

const std::int32_t authorizationStateClosing::ID;

object_ptr<AuthorizationState> authorizationStateClosing::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateClosing>();
}

void authorizationStateClosing::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateClosing::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateClosing");
    s.store_class_end();
  }
}

void authorizationStateClosing::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateClosing").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass authorizationStateClosed::Class;

authorizationStateClosed::authorizationStateClosed() {
}

const std::int32_t authorizationStateClosed::ID;

object_ptr<AuthorizationState> authorizationStateClosed::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<authorizationStateClosed>();
}

void authorizationStateClosed::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void authorizationStateClosed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AuthorizationStateClosed");
    s.store_class_end();
  }
}

void authorizationStateClosed::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AuthorizationStateClosed").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autoDownloadSettings::Class;
jfieldID autoDownloadSettings::is_auto_download_enabled_fieldID;
jfieldID autoDownloadSettings::max_photo_file_size_fieldID;
jfieldID autoDownloadSettings::max_video_file_size_fieldID;
jfieldID autoDownloadSettings::max_other_file_size_fieldID;
jfieldID autoDownloadSettings::video_upload_bitrate_fieldID;
jfieldID autoDownloadSettings::preload_large_videos_fieldID;
jfieldID autoDownloadSettings::preload_next_audio_fieldID;
jfieldID autoDownloadSettings::preload_stories_fieldID;
jfieldID autoDownloadSettings::use_less_data_for_calls_fieldID;

autoDownloadSettings::autoDownloadSettings()
  : is_auto_download_enabled_()
  , max_photo_file_size_()
  , max_video_file_size_()
  , max_other_file_size_()
  , video_upload_bitrate_()
  , preload_large_videos_()
  , preload_next_audio_()
  , preload_stories_()
  , use_less_data_for_calls_()
{}

autoDownloadSettings::autoDownloadSettings(bool is_auto_download_enabled_, int32 max_photo_file_size_, int53 max_video_file_size_, int53 max_other_file_size_, int32 video_upload_bitrate_, bool preload_large_videos_, bool preload_next_audio_, bool preload_stories_, bool use_less_data_for_calls_)
  : is_auto_download_enabled_(is_auto_download_enabled_)
  , max_photo_file_size_(max_photo_file_size_)
  , max_video_file_size_(max_video_file_size_)
  , max_other_file_size_(max_other_file_size_)
  , video_upload_bitrate_(video_upload_bitrate_)
  , preload_large_videos_(preload_large_videos_)
  , preload_next_audio_(preload_next_audio_)
  , preload_stories_(preload_stories_)
  , use_less_data_for_calls_(use_less_data_for_calls_)
{}

const std::int32_t autoDownloadSettings::ID;

object_ptr<autoDownloadSettings> autoDownloadSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<autoDownloadSettings> res = make_object<autoDownloadSettings>();
  res->is_auto_download_enabled_ = (env->GetBooleanField(p, res->is_auto_download_enabled_fieldID) != 0);
  res->max_photo_file_size_ = env->GetIntField(p, res->max_photo_file_size_fieldID);
  res->max_video_file_size_ = env->GetLongField(p, res->max_video_file_size_fieldID);
  res->max_other_file_size_ = env->GetLongField(p, res->max_other_file_size_fieldID);
  res->video_upload_bitrate_ = env->GetIntField(p, res->video_upload_bitrate_fieldID);
  res->preload_large_videos_ = (env->GetBooleanField(p, res->preload_large_videos_fieldID) != 0);
  res->preload_next_audio_ = (env->GetBooleanField(p, res->preload_next_audio_fieldID) != 0);
  res->preload_stories_ = (env->GetBooleanField(p, res->preload_stories_fieldID) != 0);
  res->use_less_data_for_calls_ = (env->GetBooleanField(p, res->use_less_data_for_calls_fieldID) != 0);
  return res;
}

void autoDownloadSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_auto_download_enabled_fieldID, is_auto_download_enabled_);
  env->SetIntField(s, max_photo_file_size_fieldID, max_photo_file_size_);
  env->SetLongField(s, max_video_file_size_fieldID, max_video_file_size_);
  env->SetLongField(s, max_other_file_size_fieldID, max_other_file_size_);
  env->SetIntField(s, video_upload_bitrate_fieldID, video_upload_bitrate_);
  env->SetBooleanField(s, preload_large_videos_fieldID, preload_large_videos_);
  env->SetBooleanField(s, preload_next_audio_fieldID, preload_next_audio_);
  env->SetBooleanField(s, preload_stories_fieldID, preload_stories_);
  env->SetBooleanField(s, use_less_data_for_calls_fieldID, use_less_data_for_calls_);
}

void autoDownloadSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutoDownloadSettings");
    s.store_field("isAutoDownloadEnabled", is_auto_download_enabled_);
    s.store_field("maxPhotoFileSize", max_photo_file_size_);
    s.store_field("maxVideoFileSize", max_video_file_size_);
    s.store_field("maxOtherFileSize", max_other_file_size_);
    s.store_field("videoUploadBitrate", video_upload_bitrate_);
    s.store_field("preloadLargeVideos", preload_large_videos_);
    s.store_field("preloadNextAudio", preload_next_audio_);
    s.store_field("preloadStories", preload_stories_);
    s.store_field("useLessDataForCalls", use_less_data_for_calls_);
    s.store_class_end();
  }
}

void autoDownloadSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutoDownloadSettings").c_str());
    is_auto_download_enabled_fieldID = jni::get_field_id(env, Class, "isAutoDownloadEnabled", "Z");
    max_photo_file_size_fieldID = jni::get_field_id(env, Class, "maxPhotoFileSize", "I");
    max_video_file_size_fieldID = jni::get_field_id(env, Class, "maxVideoFileSize", "J");
    max_other_file_size_fieldID = jni::get_field_id(env, Class, "maxOtherFileSize", "J");
    video_upload_bitrate_fieldID = jni::get_field_id(env, Class, "videoUploadBitrate", "I");
    preload_large_videos_fieldID = jni::get_field_id(env, Class, "preloadLargeVideos", "Z");
    preload_next_audio_fieldID = jni::get_field_id(env, Class, "preloadNextAudio", "Z");
    preload_stories_fieldID = jni::get_field_id(env, Class, "preloadStories", "Z");
    use_less_data_for_calls_fieldID = jni::get_field_id(env, Class, "useLessDataForCalls", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass autoDownloadSettingsPresets::Class;
jfieldID autoDownloadSettingsPresets::low_fieldID;
jfieldID autoDownloadSettingsPresets::medium_fieldID;
jfieldID autoDownloadSettingsPresets::high_fieldID;

autoDownloadSettingsPresets::autoDownloadSettingsPresets()
  : low_()
  , medium_()
  , high_()
{}

autoDownloadSettingsPresets::autoDownloadSettingsPresets(object_ptr<autoDownloadSettings> &&low_, object_ptr<autoDownloadSettings> &&medium_, object_ptr<autoDownloadSettings> &&high_)
  : low_(std::move(low_))
  , medium_(std::move(medium_))
  , high_(std::move(high_))
{}

const std::int32_t autoDownloadSettingsPresets::ID;

object_ptr<autoDownloadSettingsPresets> autoDownloadSettingsPresets::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<autoDownloadSettingsPresets> res = make_object<autoDownloadSettingsPresets>();
  res->low_ = jni::fetch_tl_object<autoDownloadSettings>(env, jni::fetch_object(env, p, res->low_fieldID));
  res->medium_ = jni::fetch_tl_object<autoDownloadSettings>(env, jni::fetch_object(env, p, res->medium_fieldID));
  res->high_ = jni::fetch_tl_object<autoDownloadSettings>(env, jni::fetch_object(env, p, res->high_fieldID));
  return res;
}

void autoDownloadSettingsPresets::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (low_ != nullptr) { jobject next; low_->store(env, next); if (next) { env->SetObjectField(s, low_fieldID, next); env->DeleteLocalRef(next); } }
  if (medium_ != nullptr) { jobject next; medium_->store(env, next); if (next) { env->SetObjectField(s, medium_fieldID, next); env->DeleteLocalRef(next); } }
  if (high_ != nullptr) { jobject next; high_->store(env, next); if (next) { env->SetObjectField(s, high_fieldID, next); env->DeleteLocalRef(next); } }
}

void autoDownloadSettingsPresets::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutoDownloadSettingsPresets");
    s.store_object_field("low", static_cast<const BaseObject *>(low_.get()));
    s.store_object_field("medium", static_cast<const BaseObject *>(medium_.get()));
    s.store_object_field("high", static_cast<const BaseObject *>(high_.get()));
    s.store_class_end();
  }
}

void autoDownloadSettingsPresets::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutoDownloadSettingsPresets").c_str());
    low_fieldID = jni::get_field_id(env, Class, "low", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AutoDownloadSettings;").c_str());
    medium_fieldID = jni::get_field_id(env, Class, "medium", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AutoDownloadSettings;").c_str());
    high_fieldID = jni::get_field_id(env, Class, "high", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AutoDownloadSettings;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettings::Class;
jfieldID autosaveSettings::private_chat_settings_fieldID;
jfieldID autosaveSettings::group_settings_fieldID;
jfieldID autosaveSettings::channel_settings_fieldID;
jfieldID autosaveSettings::exceptions_fieldID;

autosaveSettings::autosaveSettings()
  : private_chat_settings_()
  , group_settings_()
  , channel_settings_()
  , exceptions_()
{}

autosaveSettings::autosaveSettings(object_ptr<scopeAutosaveSettings> &&private_chat_settings_, object_ptr<scopeAutosaveSettings> &&group_settings_, object_ptr<scopeAutosaveSettings> &&channel_settings_, array<object_ptr<autosaveSettingsException>> &&exceptions_)
  : private_chat_settings_(std::move(private_chat_settings_))
  , group_settings_(std::move(group_settings_))
  , channel_settings_(std::move(channel_settings_))
  , exceptions_(std::move(exceptions_))
{}

const std::int32_t autosaveSettings::ID;

object_ptr<autosaveSettings> autosaveSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<autosaveSettings> res = make_object<autosaveSettings>();
  res->private_chat_settings_ = jni::fetch_tl_object<scopeAutosaveSettings>(env, jni::fetch_object(env, p, res->private_chat_settings_fieldID));
  res->group_settings_ = jni::fetch_tl_object<scopeAutosaveSettings>(env, jni::fetch_object(env, p, res->group_settings_fieldID));
  res->channel_settings_ = jni::fetch_tl_object<scopeAutosaveSettings>(env, jni::fetch_object(env, p, res->channel_settings_fieldID));
  res->exceptions_ = jni::FetchVector<autosaveSettingsException>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->exceptions_fieldID));
  return res;
}

void autosaveSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (private_chat_settings_ != nullptr) { jobject next; private_chat_settings_->store(env, next); if (next) { env->SetObjectField(s, private_chat_settings_fieldID, next); env->DeleteLocalRef(next); } }
  if (group_settings_ != nullptr) { jobject next; group_settings_->store(env, next); if (next) { env->SetObjectField(s, group_settings_fieldID, next); env->DeleteLocalRef(next); } }
  if (channel_settings_ != nullptr) { jobject next; channel_settings_->store(env, next); if (next) { env->SetObjectField(s, channel_settings_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, exceptions_); if (arr_tmp_) { env->SetObjectField(s, exceptions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void autosaveSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettings");
    s.store_object_field("privateChatSettings", static_cast<const BaseObject *>(private_chat_settings_.get()));
    s.store_object_field("groupSettings", static_cast<const BaseObject *>(group_settings_.get()));
    s.store_object_field("channelSettings", static_cast<const BaseObject *>(channel_settings_.get()));
    { s.store_vector_begin("exceptions", exceptions_.size()); for (const auto &_value : exceptions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void autosaveSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettings").c_str());
    private_chat_settings_fieldID = jni::get_field_id(env, Class, "privateChatSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ScopeAutosaveSettings;").c_str());
    group_settings_fieldID = jni::get_field_id(env, Class, "groupSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ScopeAutosaveSettings;").c_str());
    channel_settings_fieldID = jni::get_field_id(env, Class, "channelSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ScopeAutosaveSettings;").c_str());
    exceptions_fieldID = jni::get_field_id(env, Class, "exceptions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AutosaveSettingsException;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettingsException::Class;
jfieldID autosaveSettingsException::chat_id_fieldID;
jfieldID autosaveSettingsException::settings_fieldID;

autosaveSettingsException::autosaveSettingsException()
  : chat_id_()
  , settings_()
{}

autosaveSettingsException::autosaveSettingsException(int53 chat_id_, object_ptr<scopeAutosaveSettings> &&settings_)
  : chat_id_(chat_id_)
  , settings_(std::move(settings_))
{}

const std::int32_t autosaveSettingsException::ID;

object_ptr<autosaveSettingsException> autosaveSettingsException::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<autosaveSettingsException> res = make_object<autosaveSettingsException>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  res->settings_ = jni::fetch_tl_object<scopeAutosaveSettings>(env, jni::fetch_object(env, p, res->settings_fieldID));
  return res;
}

void autosaveSettingsException::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, chat_id_fieldID, chat_id_);
  if (settings_ != nullptr) { jobject next; settings_->store(env, next); if (next) { env->SetObjectField(s, settings_fieldID, next); env->DeleteLocalRef(next); } }
}

void autosaveSettingsException::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettingsException");
    s.store_field("chatId", chat_id_);
    s.store_object_field("settings", static_cast<const BaseObject *>(settings_.get()));
    s.store_class_end();
  }
}

void autosaveSettingsException::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsException").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    settings_fieldID = jni::get_field_id(env, Class, "settings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ScopeAutosaveSettings;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass AutosaveSettingsScope::Class;

object_ptr<AutosaveSettingsScope> AutosaveSettingsScope::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case autosaveSettingsScopePrivateChats::ID:
      return autosaveSettingsScopePrivateChats::fetch(env, p);
    case autosaveSettingsScopeGroupChats::ID:
      return autosaveSettingsScopeGroupChats::fetch(env, p);
    case autosaveSettingsScopeChannelChats::ID:
      return autosaveSettingsScopeChannelChats::fetch(env, p);
    case autosaveSettingsScopeChat::ID:
      return autosaveSettingsScopeChat::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void AutosaveSettingsScope::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsScope").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettingsScopePrivateChats::Class;

autosaveSettingsScopePrivateChats::autosaveSettingsScopePrivateChats() {
}

const std::int32_t autosaveSettingsScopePrivateChats::ID;

object_ptr<AutosaveSettingsScope> autosaveSettingsScopePrivateChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<autosaveSettingsScopePrivateChats>();
}

void autosaveSettingsScopePrivateChats::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void autosaveSettingsScopePrivateChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettingsScopePrivateChats");
    s.store_class_end();
  }
}

void autosaveSettingsScopePrivateChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsScopePrivateChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettingsScopeGroupChats::Class;

autosaveSettingsScopeGroupChats::autosaveSettingsScopeGroupChats() {
}

const std::int32_t autosaveSettingsScopeGroupChats::ID;

object_ptr<AutosaveSettingsScope> autosaveSettingsScopeGroupChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<autosaveSettingsScopeGroupChats>();
}

void autosaveSettingsScopeGroupChats::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void autosaveSettingsScopeGroupChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettingsScopeGroupChats");
    s.store_class_end();
  }
}

void autosaveSettingsScopeGroupChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsScopeGroupChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettingsScopeChannelChats::Class;

autosaveSettingsScopeChannelChats::autosaveSettingsScopeChannelChats() {
}

const std::int32_t autosaveSettingsScopeChannelChats::ID;

object_ptr<AutosaveSettingsScope> autosaveSettingsScopeChannelChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<autosaveSettingsScopeChannelChats>();
}

void autosaveSettingsScopeChannelChats::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void autosaveSettingsScopeChannelChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettingsScopeChannelChats");
    s.store_class_end();
  }
}

void autosaveSettingsScopeChannelChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsScopeChannelChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass autosaveSettingsScopeChat::Class;
jfieldID autosaveSettingsScopeChat::chat_id_fieldID;

autosaveSettingsScopeChat::autosaveSettingsScopeChat()
  : chat_id_()
{}

autosaveSettingsScopeChat::autosaveSettingsScopeChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t autosaveSettingsScopeChat::ID;

object_ptr<AutosaveSettingsScope> autosaveSettingsScopeChat::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<autosaveSettingsScopeChat> res = make_object<autosaveSettingsScopeChat>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  return std::move(res);
}

void autosaveSettingsScopeChat::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, chat_id_fieldID, chat_id_);
}

void autosaveSettingsScopeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AutosaveSettingsScopeChat");
    s.store_field("chatId", chat_id_);
    s.store_class_end();
  }
}

void autosaveSettingsScopeChat::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AutosaveSettingsScopeChat").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass availableGift::Class;
jfieldID availableGift::gift_fieldID;
jfieldID availableGift::resale_count_fieldID;
jfieldID availableGift::min_resale_star_count_fieldID;
jfieldID availableGift::title_fieldID;

availableGift::availableGift()
  : gift_()
  , resale_count_()
  , min_resale_star_count_()
  , title_()
{}

availableGift::availableGift(object_ptr<gift> &&gift_, int32 resale_count_, int53 min_resale_star_count_, string const &title_)
  : gift_(std::move(gift_))
  , resale_count_(resale_count_)
  , min_resale_star_count_(min_resale_star_count_)
  , title_(title_)
{}

const std::int32_t availableGift::ID;

object_ptr<availableGift> availableGift::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<availableGift> res = make_object<availableGift>();
  res->gift_ = jni::fetch_tl_object<gift>(env, jni::fetch_object(env, p, res->gift_fieldID));
  res->resale_count_ = env->GetIntField(p, res->resale_count_fieldID);
  res->min_resale_star_count_ = env->GetLongField(p, res->min_resale_star_count_fieldID);
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  return res;
}

void availableGift::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (gift_ != nullptr) { jobject next; gift_->store(env, next); if (next) { env->SetObjectField(s, gift_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, resale_count_fieldID, resale_count_);
  env->SetLongField(s, min_resale_star_count_fieldID, min_resale_star_count_);
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void availableGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AvailableGift");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_field("resaleCount", resale_count_);
    s.store_field("minResaleStarCount", min_resale_star_count_);
    s.store_field("title", title_);
    s.store_class_end();
  }
}

void availableGift::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AvailableGift").c_str());
    gift_fieldID = jni::get_field_id(env, Class, "gift", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Gift;").c_str());
    resale_count_fieldID = jni::get_field_id(env, Class, "resaleCount", "I");
    min_resale_star_count_fieldID = jni::get_field_id(env, Class, "minResaleStarCount", "J");
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass availableGifts::Class;
jfieldID availableGifts::gifts_fieldID;

availableGifts::availableGifts()
  : gifts_()
{}

availableGifts::availableGifts(array<object_ptr<availableGift>> &&gifts_)
  : gifts_(std::move(gifts_))
{}

const std::int32_t availableGifts::ID;

object_ptr<availableGifts> availableGifts::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<availableGifts> res = make_object<availableGifts>();
  res->gifts_ = jni::FetchVector<availableGift>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->gifts_fieldID));
  return res;
}

void availableGifts::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, gifts_); if (arr_tmp_) { env->SetObjectField(s, gifts_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void availableGifts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AvailableGifts");
    { s.store_vector_begin("gifts", gifts_.size()); for (const auto &_value : gifts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void availableGifts::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AvailableGifts").c_str());
    gifts_fieldID = jni::get_field_id(env, Class, "gifts", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AvailableGift;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass availableReaction::Class;
jfieldID availableReaction::type_fieldID;
jfieldID availableReaction::needs_premium_fieldID;

availableReaction::availableReaction()
  : type_()
  , needs_premium_()
{}

availableReaction::availableReaction(object_ptr<ReactionType> &&type_, bool needs_premium_)
  : type_(std::move(type_))
  , needs_premium_(needs_premium_)
{}

const std::int32_t availableReaction::ID;

object_ptr<availableReaction> availableReaction::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<availableReaction> res = make_object<availableReaction>();
  res->type_ = jni::fetch_tl_object<ReactionType>(env, jni::fetch_object(env, p, res->type_fieldID));
  res->needs_premium_ = (env->GetBooleanField(p, res->needs_premium_fieldID) != 0);
  return res;
}

void availableReaction::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, needs_premium_fieldID, needs_premium_);
}

void availableReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AvailableReaction");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("needsPremium", needs_premium_);
    s.store_class_end();
  }
}

void availableReaction::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AvailableReaction").c_str());
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ReactionType;").c_str());
    needs_premium_fieldID = jni::get_field_id(env, Class, "needsPremium", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass availableReactions::Class;
jfieldID availableReactions::top_reactions_fieldID;
jfieldID availableReactions::recent_reactions_fieldID;
jfieldID availableReactions::popular_reactions_fieldID;
jfieldID availableReactions::allow_custom_emoji_fieldID;
jfieldID availableReactions::are_tags_fieldID;
jfieldID availableReactions::unavailability_reason_fieldID;

availableReactions::availableReactions()
  : top_reactions_()
  , recent_reactions_()
  , popular_reactions_()
  , allow_custom_emoji_()
  , are_tags_()
  , unavailability_reason_()
{}

availableReactions::availableReactions(array<object_ptr<availableReaction>> &&top_reactions_, array<object_ptr<availableReaction>> &&recent_reactions_, array<object_ptr<availableReaction>> &&popular_reactions_, bool allow_custom_emoji_, bool are_tags_, object_ptr<ReactionUnavailabilityReason> &&unavailability_reason_)
  : top_reactions_(std::move(top_reactions_))
  , recent_reactions_(std::move(recent_reactions_))
  , popular_reactions_(std::move(popular_reactions_))
  , allow_custom_emoji_(allow_custom_emoji_)
  , are_tags_(are_tags_)
  , unavailability_reason_(std::move(unavailability_reason_))
{}

const std::int32_t availableReactions::ID;

object_ptr<availableReactions> availableReactions::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<availableReactions> res = make_object<availableReactions>();
  res->top_reactions_ = jni::FetchVector<availableReaction>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->top_reactions_fieldID));
  res->recent_reactions_ = jni::FetchVector<availableReaction>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->recent_reactions_fieldID));
  res->popular_reactions_ = jni::FetchVector<availableReaction>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->popular_reactions_fieldID));
  res->allow_custom_emoji_ = (env->GetBooleanField(p, res->allow_custom_emoji_fieldID) != 0);
  res->are_tags_ = (env->GetBooleanField(p, res->are_tags_fieldID) != 0);
  res->unavailability_reason_ = jni::fetch_tl_object<ReactionUnavailabilityReason>(env, jni::fetch_object(env, p, res->unavailability_reason_fieldID));
  return res;
}

void availableReactions::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, top_reactions_); if (arr_tmp_) { env->SetObjectField(s, top_reactions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, recent_reactions_); if (arr_tmp_) { env->SetObjectField(s, recent_reactions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, popular_reactions_); if (arr_tmp_) { env->SetObjectField(s, popular_reactions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetBooleanField(s, allow_custom_emoji_fieldID, allow_custom_emoji_);
  env->SetBooleanField(s, are_tags_fieldID, are_tags_);
  if (unavailability_reason_ != nullptr) { jobject next; unavailability_reason_->store(env, next); if (next) { env->SetObjectField(s, unavailability_reason_fieldID, next); env->DeleteLocalRef(next); } }
}

void availableReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "AvailableReactions");
    { s.store_vector_begin("topReactions", top_reactions_.size()); for (const auto &_value : top_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("recentReactions", recent_reactions_.size()); for (const auto &_value : recent_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("popularReactions", popular_reactions_.size()); for (const auto &_value : popular_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("allowCustomEmoji", allow_custom_emoji_);
    s.store_field("areTags", are_tags_);
    s.store_object_field("unavailabilityReason", static_cast<const BaseObject *>(unavailability_reason_.get()));
    s.store_class_end();
  }
}

void availableReactions::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$AvailableReactions").c_str());
    top_reactions_fieldID = jni::get_field_id(env, Class, "topReactions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AvailableReaction;").c_str());
    recent_reactions_fieldID = jni::get_field_id(env, Class, "recentReactions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AvailableReaction;").c_str());
    popular_reactions_fieldID = jni::get_field_id(env, Class, "popularReactions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$AvailableReaction;").c_str());
    allow_custom_emoji_fieldID = jni::get_field_id(env, Class, "allowCustomEmoji", "Z");
    are_tags_fieldID = jni::get_field_id(env, Class, "areTags", "Z");
    unavailability_reason_fieldID = jni::get_field_id(env, Class, "unavailabilityReason", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ReactionUnavailabilityReason;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass background::Class;
jfieldID background::id_fieldID;
jfieldID background::is_default_fieldID;
jfieldID background::is_dark_fieldID;
jfieldID background::name_fieldID;
jfieldID background::document_fieldID;
jfieldID background::type_fieldID;

background::background()
  : id_()
  , is_default_()
  , is_dark_()
  , name_()
  , document_()
  , type_()
{}

background::background(int64 id_, bool is_default_, bool is_dark_, string const &name_, object_ptr<document> &&document_, object_ptr<BackgroundType> &&type_)
  : id_(id_)
  , is_default_(is_default_)
  , is_dark_(is_dark_)
  , name_(name_)
  , document_(std::move(document_))
  , type_(std::move(type_))
{}

const std::int32_t background::ID;

object_ptr<background> background::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<background> res = make_object<background>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->is_default_ = (env->GetBooleanField(p, res->is_default_fieldID) != 0);
  res->is_dark_ = (env->GetBooleanField(p, res->is_dark_fieldID) != 0);
  res->name_ = jni::fetch_string(env, p, res->name_fieldID);
  res->document_ = jni::fetch_tl_object<document>(env, jni::fetch_object(env, p, res->document_fieldID));
  res->type_ = jni::fetch_tl_object<BackgroundType>(env, jni::fetch_object(env, p, res->type_fieldID));
  return res;
}

void background::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  env->SetBooleanField(s, is_default_fieldID, is_default_);
  env->SetBooleanField(s, is_dark_fieldID, is_dark_);
  { jstring nextString = jni::to_jstring(env, name_); if (nextString) { env->SetObjectField(s, name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (document_ != nullptr) { jobject next; document_->store(env, next); if (next) { env->SetObjectField(s, document_fieldID, next); env->DeleteLocalRef(next); } }
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
}

void background::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Background");
    s.store_field("id", id_);
    s.store_field("isDefault", is_default_);
    s.store_field("isDark", is_dark_);
    s.store_field("name", name_);
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

void background::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Background").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    is_default_fieldID = jni::get_field_id(env, Class, "isDefault", "Z");
    is_dark_fieldID = jni::get_field_id(env, Class, "isDark", "Z");
    name_fieldID = jni::get_field_id(env, Class, "name", "Ljava/lang/String;");
    document_fieldID = jni::get_field_id(env, Class, "document", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Document;").c_str());
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BackgroundType;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass BackgroundFill::Class;

object_ptr<BackgroundFill> BackgroundFill::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case backgroundFillSolid::ID:
      return backgroundFillSolid::fetch(env, p);
    case backgroundFillGradient::ID:
      return backgroundFillGradient::fetch(env, p);
    case backgroundFillFreeformGradient::ID:
      return backgroundFillFreeformGradient::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BackgroundFill::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundFill").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass backgroundFillSolid::Class;
jfieldID backgroundFillSolid::color_fieldID;

backgroundFillSolid::backgroundFillSolid()
  : color_()
{}

backgroundFillSolid::backgroundFillSolid(int32 color_)
  : color_(color_)
{}

const std::int32_t backgroundFillSolid::ID;

object_ptr<BackgroundFill> backgroundFillSolid::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundFillSolid> res = make_object<backgroundFillSolid>();
  res->color_ = env->GetIntField(p, res->color_fieldID);
  return std::move(res);
}

void backgroundFillSolid::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, color_fieldID, color_);
}

void backgroundFillSolid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundFillSolid");
    s.store_field("color", color_);
    s.store_class_end();
  }
}

void backgroundFillSolid::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundFillSolid").c_str());
    color_fieldID = jni::get_field_id(env, Class, "color", "I");
    return true;
  }();
  (void)is_inited;
}

jclass backgroundFillGradient::Class;
jfieldID backgroundFillGradient::top_color_fieldID;
jfieldID backgroundFillGradient::bottom_color_fieldID;
jfieldID backgroundFillGradient::rotation_angle_fieldID;

backgroundFillGradient::backgroundFillGradient()
  : top_color_()
  , bottom_color_()
  , rotation_angle_()
{}

backgroundFillGradient::backgroundFillGradient(int32 top_color_, int32 bottom_color_, int32 rotation_angle_)
  : top_color_(top_color_)
  , bottom_color_(bottom_color_)
  , rotation_angle_(rotation_angle_)
{}

const std::int32_t backgroundFillGradient::ID;

object_ptr<BackgroundFill> backgroundFillGradient::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundFillGradient> res = make_object<backgroundFillGradient>();
  res->top_color_ = env->GetIntField(p, res->top_color_fieldID);
  res->bottom_color_ = env->GetIntField(p, res->bottom_color_fieldID);
  res->rotation_angle_ = env->GetIntField(p, res->rotation_angle_fieldID);
  return std::move(res);
}

void backgroundFillGradient::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, top_color_fieldID, top_color_);
  env->SetIntField(s, bottom_color_fieldID, bottom_color_);
  env->SetIntField(s, rotation_angle_fieldID, rotation_angle_);
}

void backgroundFillGradient::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundFillGradient");
    s.store_field("topColor", top_color_);
    s.store_field("bottomColor", bottom_color_);
    s.store_field("rotationAngle", rotation_angle_);
    s.store_class_end();
  }
}

void backgroundFillGradient::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundFillGradient").c_str());
    top_color_fieldID = jni::get_field_id(env, Class, "topColor", "I");
    bottom_color_fieldID = jni::get_field_id(env, Class, "bottomColor", "I");
    rotation_angle_fieldID = jni::get_field_id(env, Class, "rotationAngle", "I");
    return true;
  }();
  (void)is_inited;
}

jclass backgroundFillFreeformGradient::Class;
jfieldID backgroundFillFreeformGradient::colors_fieldID;

backgroundFillFreeformGradient::backgroundFillFreeformGradient()
  : colors_()
{}

backgroundFillFreeformGradient::backgroundFillFreeformGradient(array<int32> &&colors_)
  : colors_(std::move(colors_))
{}

const std::int32_t backgroundFillFreeformGradient::ID;

object_ptr<BackgroundFill> backgroundFillFreeformGradient::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundFillFreeformGradient> res = make_object<backgroundFillFreeformGradient>();
  res->colors_ = jni::fetch_vector(env, (jintArray)jni::fetch_object(env, p, res->colors_fieldID));
  return std::move(res);
}

void backgroundFillFreeformGradient::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, colors_); if (arr_tmp_) { env->SetObjectField(s, colors_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void backgroundFillFreeformGradient::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundFillFreeformGradient");
    { s.store_vector_begin("colors", colors_.size()); for (const auto &_value : colors_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void backgroundFillFreeformGradient::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundFillFreeformGradient").c_str());
    colors_fieldID = jni::get_field_id(env, Class, "colors", "[I");
    return true;
  }();
  (void)is_inited;
}

jclass BackgroundType::Class;

object_ptr<BackgroundType> BackgroundType::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case backgroundTypeWallpaper::ID:
      return backgroundTypeWallpaper::fetch(env, p);
    case backgroundTypePattern::ID:
      return backgroundTypePattern::fetch(env, p);
    case backgroundTypeFill::ID:
      return backgroundTypeFill::fetch(env, p);
    case backgroundTypeChatTheme::ID:
      return backgroundTypeChatTheme::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BackgroundType::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundType").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass backgroundTypeWallpaper::Class;
jfieldID backgroundTypeWallpaper::is_blurred_fieldID;
jfieldID backgroundTypeWallpaper::is_moving_fieldID;

backgroundTypeWallpaper::backgroundTypeWallpaper()
  : is_blurred_()
  , is_moving_()
{}

backgroundTypeWallpaper::backgroundTypeWallpaper(bool is_blurred_, bool is_moving_)
  : is_blurred_(is_blurred_)
  , is_moving_(is_moving_)
{}

const std::int32_t backgroundTypeWallpaper::ID;

object_ptr<BackgroundType> backgroundTypeWallpaper::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundTypeWallpaper> res = make_object<backgroundTypeWallpaper>();
  res->is_blurred_ = (env->GetBooleanField(p, res->is_blurred_fieldID) != 0);
  res->is_moving_ = (env->GetBooleanField(p, res->is_moving_fieldID) != 0);
  return std::move(res);
}

void backgroundTypeWallpaper::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_blurred_fieldID, is_blurred_);
  env->SetBooleanField(s, is_moving_fieldID, is_moving_);
}

void backgroundTypeWallpaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundTypeWallpaper");
    s.store_field("isBlurred", is_blurred_);
    s.store_field("isMoving", is_moving_);
    s.store_class_end();
  }
}

void backgroundTypeWallpaper::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundTypeWallpaper").c_str());
    is_blurred_fieldID = jni::get_field_id(env, Class, "isBlurred", "Z");
    is_moving_fieldID = jni::get_field_id(env, Class, "isMoving", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass backgroundTypePattern::Class;
jfieldID backgroundTypePattern::fill_fieldID;
jfieldID backgroundTypePattern::intensity_fieldID;
jfieldID backgroundTypePattern::is_inverted_fieldID;
jfieldID backgroundTypePattern::is_moving_fieldID;

backgroundTypePattern::backgroundTypePattern()
  : fill_()
  , intensity_()
  , is_inverted_()
  , is_moving_()
{}

backgroundTypePattern::backgroundTypePattern(object_ptr<BackgroundFill> &&fill_, int32 intensity_, bool is_inverted_, bool is_moving_)
  : fill_(std::move(fill_))
  , intensity_(intensity_)
  , is_inverted_(is_inverted_)
  , is_moving_(is_moving_)
{}

const std::int32_t backgroundTypePattern::ID;

object_ptr<BackgroundType> backgroundTypePattern::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundTypePattern> res = make_object<backgroundTypePattern>();
  res->fill_ = jni::fetch_tl_object<BackgroundFill>(env, jni::fetch_object(env, p, res->fill_fieldID));
  res->intensity_ = env->GetIntField(p, res->intensity_fieldID);
  res->is_inverted_ = (env->GetBooleanField(p, res->is_inverted_fieldID) != 0);
  res->is_moving_ = (env->GetBooleanField(p, res->is_moving_fieldID) != 0);
  return std::move(res);
}

void backgroundTypePattern::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (fill_ != nullptr) { jobject next; fill_->store(env, next); if (next) { env->SetObjectField(s, fill_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, intensity_fieldID, intensity_);
  env->SetBooleanField(s, is_inverted_fieldID, is_inverted_);
  env->SetBooleanField(s, is_moving_fieldID, is_moving_);
}

void backgroundTypePattern::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundTypePattern");
    s.store_object_field("fill", static_cast<const BaseObject *>(fill_.get()));
    s.store_field("intensity", intensity_);
    s.store_field("isInverted", is_inverted_);
    s.store_field("isMoving", is_moving_);
    s.store_class_end();
  }
}

void backgroundTypePattern::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundTypePattern").c_str());
    fill_fieldID = jni::get_field_id(env, Class, "fill", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BackgroundFill;").c_str());
    intensity_fieldID = jni::get_field_id(env, Class, "intensity", "I");
    is_inverted_fieldID = jni::get_field_id(env, Class, "isInverted", "Z");
    is_moving_fieldID = jni::get_field_id(env, Class, "isMoving", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass backgroundTypeFill::Class;
jfieldID backgroundTypeFill::fill_fieldID;

backgroundTypeFill::backgroundTypeFill()
  : fill_()
{}

backgroundTypeFill::backgroundTypeFill(object_ptr<BackgroundFill> &&fill_)
  : fill_(std::move(fill_))
{}

const std::int32_t backgroundTypeFill::ID;

object_ptr<BackgroundType> backgroundTypeFill::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundTypeFill> res = make_object<backgroundTypeFill>();
  res->fill_ = jni::fetch_tl_object<BackgroundFill>(env, jni::fetch_object(env, p, res->fill_fieldID));
  return std::move(res);
}

void backgroundTypeFill::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (fill_ != nullptr) { jobject next; fill_->store(env, next); if (next) { env->SetObjectField(s, fill_fieldID, next); env->DeleteLocalRef(next); } }
}

void backgroundTypeFill::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundTypeFill");
    s.store_object_field("fill", static_cast<const BaseObject *>(fill_.get()));
    s.store_class_end();
  }
}

void backgroundTypeFill::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundTypeFill").c_str());
    fill_fieldID = jni::get_field_id(env, Class, "fill", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BackgroundFill;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass backgroundTypeChatTheme::Class;
jfieldID backgroundTypeChatTheme::theme_name_fieldID;

backgroundTypeChatTheme::backgroundTypeChatTheme()
  : theme_name_()
{}

backgroundTypeChatTheme::backgroundTypeChatTheme(string const &theme_name_)
  : theme_name_(theme_name_)
{}

const std::int32_t backgroundTypeChatTheme::ID;

object_ptr<BackgroundType> backgroundTypeChatTheme::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgroundTypeChatTheme> res = make_object<backgroundTypeChatTheme>();
  res->theme_name_ = jni::fetch_string(env, p, res->theme_name_fieldID);
  return std::move(res);
}

void backgroundTypeChatTheme::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, theme_name_); if (nextString) { env->SetObjectField(s, theme_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void backgroundTypeChatTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BackgroundTypeChatTheme");
    s.store_field("themeName", theme_name_);
    s.store_class_end();
  }
}

void backgroundTypeChatTheme::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BackgroundTypeChatTheme").c_str());
    theme_name_fieldID = jni::get_field_id(env, Class, "themeName", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass backgrounds::Class;
jfieldID backgrounds::backgrounds_fieldID;

backgrounds::backgrounds()
  : backgrounds_()
{}

backgrounds::backgrounds(array<object_ptr<background>> &&backgrounds_)
  : backgrounds_(std::move(backgrounds_))
{}

const std::int32_t backgrounds::ID;

object_ptr<backgrounds> backgrounds::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<backgrounds> res = make_object<backgrounds>();
  res->backgrounds_ = jni::FetchVector<background>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->backgrounds_fieldID));
  return res;
}

void backgrounds::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, backgrounds_); if (arr_tmp_) { env->SetObjectField(s, backgrounds_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void backgrounds::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Backgrounds");
    { s.store_vector_begin("backgrounds", backgrounds_.size()); for (const auto &_value : backgrounds_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void backgrounds::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Backgrounds").c_str());
    backgrounds_fieldID = jni::get_field_id(env, Class, "backgrounds", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$Background;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass bankCardActionOpenUrl::Class;
jfieldID bankCardActionOpenUrl::text_fieldID;
jfieldID bankCardActionOpenUrl::url_fieldID;

bankCardActionOpenUrl::bankCardActionOpenUrl()
  : text_()
  , url_()
{}

bankCardActionOpenUrl::bankCardActionOpenUrl(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t bankCardActionOpenUrl::ID;

object_ptr<bankCardActionOpenUrl> bankCardActionOpenUrl::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<bankCardActionOpenUrl> res = make_object<bankCardActionOpenUrl>();
  res->text_ = jni::fetch_string(env, p, res->text_fieldID);
  res->url_ = jni::fetch_string(env, p, res->url_fieldID);
  return res;
}

void bankCardActionOpenUrl::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, text_); if (nextString) { env->SetObjectField(s, text_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, url_); if (nextString) { env->SetObjectField(s, url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void bankCardActionOpenUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BankCardActionOpenUrl");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

void bankCardActionOpenUrl::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BankCardActionOpenUrl").c_str());
    text_fieldID = jni::get_field_id(env, Class, "text", "Ljava/lang/String;");
    url_fieldID = jni::get_field_id(env, Class, "url", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass bankCardInfo::Class;
jfieldID bankCardInfo::title_fieldID;
jfieldID bankCardInfo::actions_fieldID;

bankCardInfo::bankCardInfo()
  : title_()
  , actions_()
{}

bankCardInfo::bankCardInfo(string const &title_, array<object_ptr<bankCardActionOpenUrl>> &&actions_)
  : title_(title_)
  , actions_(std::move(actions_))
{}

const std::int32_t bankCardInfo::ID;

object_ptr<bankCardInfo> bankCardInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<bankCardInfo> res = make_object<bankCardInfo>();
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->actions_ = jni::FetchVector<bankCardActionOpenUrl>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->actions_fieldID));
  return res;
}

void bankCardInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { auto arr_tmp_ = jni::store_vector(env, actions_); if (arr_tmp_) { env->SetObjectField(s, actions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void bankCardInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BankCardInfo");
    s.store_field("title", title_);
    { s.store_vector_begin("actions", actions_.size()); for (const auto &_value : actions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void bankCardInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BankCardInfo").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    actions_fieldID = jni::get_field_id(env, Class, "actions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BankCardActionOpenUrl;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass basicGroup::Class;
jfieldID basicGroup::id_fieldID;
jfieldID basicGroup::member_count_fieldID;
jfieldID basicGroup::status_fieldID;
jfieldID basicGroup::is_active_fieldID;
jfieldID basicGroup::upgraded_to_supergroup_id_fieldID;

basicGroup::basicGroup()
  : id_()
  , member_count_()
  , status_()
  , is_active_()
  , upgraded_to_supergroup_id_()
{}

basicGroup::basicGroup(int53 id_, int32 member_count_, object_ptr<ChatMemberStatus> &&status_, bool is_active_, int53 upgraded_to_supergroup_id_)
  : id_(id_)
  , member_count_(member_count_)
  , status_(std::move(status_))
  , is_active_(is_active_)
  , upgraded_to_supergroup_id_(upgraded_to_supergroup_id_)
{}

const std::int32_t basicGroup::ID;

object_ptr<basicGroup> basicGroup::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<basicGroup> res = make_object<basicGroup>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->member_count_ = env->GetIntField(p, res->member_count_fieldID);
  res->status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->status_fieldID));
  res->is_active_ = (env->GetBooleanField(p, res->is_active_fieldID) != 0);
  res->upgraded_to_supergroup_id_ = env->GetLongField(p, res->upgraded_to_supergroup_id_fieldID);
  return res;
}

void basicGroup::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  env->SetIntField(s, member_count_fieldID, member_count_);
  if (status_ != nullptr) { jobject next; status_->store(env, next); if (next) { env->SetObjectField(s, status_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, is_active_fieldID, is_active_);
  env->SetLongField(s, upgraded_to_supergroup_id_fieldID, upgraded_to_supergroup_id_);
}

void basicGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BasicGroup");
    s.store_field("id", id_);
    s.store_field("memberCount", member_count_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_field("isActive", is_active_);
    s.store_field("upgradedToSupergroupId", upgraded_to_supergroup_id_);
    s.store_class_end();
  }
}

void basicGroup::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BasicGroup").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    member_count_fieldID = jni::get_field_id(env, Class, "memberCount", "I");
    status_fieldID = jni::get_field_id(env, Class, "status", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    is_active_fieldID = jni::get_field_id(env, Class, "isActive", "Z");
    upgraded_to_supergroup_id_fieldID = jni::get_field_id(env, Class, "upgradedToSupergroupId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass basicGroupFullInfo::Class;
jfieldID basicGroupFullInfo::photo_fieldID;
jfieldID basicGroupFullInfo::description_fieldID;
jfieldID basicGroupFullInfo::creator_user_id_fieldID;
jfieldID basicGroupFullInfo::members_fieldID;
jfieldID basicGroupFullInfo::can_hide_members_fieldID;
jfieldID basicGroupFullInfo::can_toggle_aggressive_anti_spam_fieldID;
jfieldID basicGroupFullInfo::invite_link_fieldID;
jfieldID basicGroupFullInfo::bot_commands_fieldID;

basicGroupFullInfo::basicGroupFullInfo()
  : photo_()
  , description_()
  , creator_user_id_()
  , members_()
  , can_hide_members_()
  , can_toggle_aggressive_anti_spam_()
  , invite_link_()
  , bot_commands_()
{}

basicGroupFullInfo::basicGroupFullInfo(object_ptr<chatPhoto> &&photo_, string const &description_, int53 creator_user_id_, array<object_ptr<chatMember>> &&members_, bool can_hide_members_, bool can_toggle_aggressive_anti_spam_, object_ptr<chatInviteLink> &&invite_link_, array<object_ptr<botCommands>> &&bot_commands_)
  : photo_(std::move(photo_))
  , description_(description_)
  , creator_user_id_(creator_user_id_)
  , members_(std::move(members_))
  , can_hide_members_(can_hide_members_)
  , can_toggle_aggressive_anti_spam_(can_toggle_aggressive_anti_spam_)
  , invite_link_(std::move(invite_link_))
  , bot_commands_(std::move(bot_commands_))
{}

const std::int32_t basicGroupFullInfo::ID;

object_ptr<basicGroupFullInfo> basicGroupFullInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<basicGroupFullInfo> res = make_object<basicGroupFullInfo>();
  res->photo_ = jni::fetch_tl_object<chatPhoto>(env, jni::fetch_object(env, p, res->photo_fieldID));
  res->description_ = jni::fetch_string(env, p, res->description_fieldID);
  res->creator_user_id_ = env->GetLongField(p, res->creator_user_id_fieldID);
  res->members_ = jni::FetchVector<chatMember>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->members_fieldID));
  res->can_hide_members_ = (env->GetBooleanField(p, res->can_hide_members_fieldID) != 0);
  res->can_toggle_aggressive_anti_spam_ = (env->GetBooleanField(p, res->can_toggle_aggressive_anti_spam_fieldID) != 0);
  res->invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->invite_link_fieldID));
  res->bot_commands_ = jni::FetchVector<botCommands>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->bot_commands_fieldID));
  return res;
}

void basicGroupFullInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (photo_ != nullptr) { jobject next; photo_->store(env, next); if (next) { env->SetObjectField(s, photo_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, description_); if (nextString) { env->SetObjectField(s, description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetLongField(s, creator_user_id_fieldID, creator_user_id_);
  { auto arr_tmp_ = jni::store_vector(env, members_); if (arr_tmp_) { env->SetObjectField(s, members_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetBooleanField(s, can_hide_members_fieldID, can_hide_members_);
  env->SetBooleanField(s, can_toggle_aggressive_anti_spam_fieldID, can_toggle_aggressive_anti_spam_);
  if (invite_link_ != nullptr) { jobject next; invite_link_->store(env, next); if (next) { env->SetObjectField(s, invite_link_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, bot_commands_); if (arr_tmp_) { env->SetObjectField(s, bot_commands_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void basicGroupFullInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BasicGroupFullInfo");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("description", description_);
    s.store_field("creatorUserId", creator_user_id_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("canHideMembers", can_hide_members_);
    s.store_field("canToggleAggressiveAntiSpam", can_toggle_aggressive_anti_spam_);
    s.store_object_field("inviteLink", static_cast<const BaseObject *>(invite_link_.get()));
    { s.store_vector_begin("botCommands", bot_commands_.size()); for (const auto &_value : bot_commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void basicGroupFullInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BasicGroupFullInfo").c_str());
    photo_fieldID = jni::get_field_id(env, Class, "photo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPhoto;").c_str());
    description_fieldID = jni::get_field_id(env, Class, "description", "Ljava/lang/String;");
    creator_user_id_fieldID = jni::get_field_id(env, Class, "creatorUserId", "J");
    members_fieldID = jni::get_field_id(env, Class, "members", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatMember;").c_str());
    can_hide_members_fieldID = jni::get_field_id(env, Class, "canHideMembers", "Z");
    can_toggle_aggressive_anti_spam_fieldID = jni::get_field_id(env, Class, "canToggleAggressiveAntiSpam", "Z");
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    bot_commands_fieldID = jni::get_field_id(env, Class, "botCommands", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BotCommands;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass birthdate::Class;
jfieldID birthdate::day_fieldID;
jfieldID birthdate::month_fieldID;
jfieldID birthdate::year_fieldID;

birthdate::birthdate()
  : day_()
  , month_()
  , year_()
{}

birthdate::birthdate(int32 day_, int32 month_, int32 year_)
  : day_(day_)
  , month_(month_)
  , year_(year_)
{}

const std::int32_t birthdate::ID;

object_ptr<birthdate> birthdate::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<birthdate> res = make_object<birthdate>();
  res->day_ = env->GetIntField(p, res->day_fieldID);
  res->month_ = env->GetIntField(p, res->month_fieldID);
  res->year_ = env->GetIntField(p, res->year_fieldID);
  return res;
}

void birthdate::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, day_fieldID, day_);
  env->SetIntField(s, month_fieldID, month_);
  env->SetIntField(s, year_fieldID, year_);
}

void birthdate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Birthdate");
    s.store_field("day", day_);
    s.store_field("month", month_);
    s.store_field("year", year_);
    s.store_class_end();
  }
}

void birthdate::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Birthdate").c_str());
    day_fieldID = jni::get_field_id(env, Class, "day", "I");
    month_fieldID = jni::get_field_id(env, Class, "month", "I");
    year_fieldID = jni::get_field_id(env, Class, "year", "I");
    return true;
  }();
  (void)is_inited;
}

jclass BlockList::Class;

object_ptr<BlockList> BlockList::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case blockListMain::ID:
      return blockListMain::fetch(env, p);
    case blockListStories::ID:
      return blockListStories::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BlockList::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BlockList").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass blockListMain::Class;

blockListMain::blockListMain() {
}

const std::int32_t blockListMain::ID;

object_ptr<BlockList> blockListMain::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<blockListMain>();
}

void blockListMain::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void blockListMain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BlockListMain");
    s.store_class_end();
  }
}

void blockListMain::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BlockListMain").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass blockListStories::Class;

blockListStories::blockListStories() {
}

const std::int32_t blockListStories::ID;

object_ptr<BlockList> blockListStories::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<blockListStories>();
}

void blockListStories::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void blockListStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BlockListStories");
    s.store_class_end();
  }
}

void blockListStories::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BlockListStories").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommand::Class;
jfieldID botCommand::command_fieldID;
jfieldID botCommand::description_fieldID;

botCommand::botCommand()
  : command_()
  , description_()
{}

botCommand::botCommand(string const &command_, string const &description_)
  : command_(command_)
  , description_(description_)
{}

const std::int32_t botCommand::ID;

object_ptr<botCommand> botCommand::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botCommand> res = make_object<botCommand>();
  res->command_ = jni::fetch_string(env, p, res->command_fieldID);
  res->description_ = jni::fetch_string(env, p, res->description_fieldID);
  return res;
}

void botCommand::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, command_); if (nextString) { env->SetObjectField(s, command_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, description_); if (nextString) { env->SetObjectField(s, description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void botCommand::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommand");
    s.store_field("command", command_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

void botCommand::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommand").c_str());
    command_fieldID = jni::get_field_id(env, Class, "command", "Ljava/lang/String;");
    description_fieldID = jni::get_field_id(env, Class, "description", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass BotCommandScope::Class;

object_ptr<BotCommandScope> BotCommandScope::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case botCommandScopeDefault::ID:
      return botCommandScopeDefault::fetch(env, p);
    case botCommandScopeAllPrivateChats::ID:
      return botCommandScopeAllPrivateChats::fetch(env, p);
    case botCommandScopeAllGroupChats::ID:
      return botCommandScopeAllGroupChats::fetch(env, p);
    case botCommandScopeAllChatAdministrators::ID:
      return botCommandScopeAllChatAdministrators::fetch(env, p);
    case botCommandScopeChat::ID:
      return botCommandScopeChat::fetch(env, p);
    case botCommandScopeChatAdministrators::ID:
      return botCommandScopeChatAdministrators::fetch(env, p);
    case botCommandScopeChatMember::ID:
      return botCommandScopeChatMember::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BotCommandScope::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScope").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeDefault::Class;

botCommandScopeDefault::botCommandScopeDefault() {
}

const std::int32_t botCommandScopeDefault::ID;

object_ptr<BotCommandScope> botCommandScopeDefault::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botCommandScopeDefault>();
}

void botCommandScopeDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeDefault");
    s.store_class_end();
  }
}

void botCommandScopeDefault::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeDefault").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeAllPrivateChats::Class;

botCommandScopeAllPrivateChats::botCommandScopeAllPrivateChats() {
}

const std::int32_t botCommandScopeAllPrivateChats::ID;

object_ptr<BotCommandScope> botCommandScopeAllPrivateChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botCommandScopeAllPrivateChats>();
}

void botCommandScopeAllPrivateChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeAllPrivateChats");
    s.store_class_end();
  }
}

void botCommandScopeAllPrivateChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeAllPrivateChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeAllGroupChats::Class;

botCommandScopeAllGroupChats::botCommandScopeAllGroupChats() {
}

const std::int32_t botCommandScopeAllGroupChats::ID;

object_ptr<BotCommandScope> botCommandScopeAllGroupChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botCommandScopeAllGroupChats>();
}

void botCommandScopeAllGroupChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeAllGroupChats");
    s.store_class_end();
  }
}

void botCommandScopeAllGroupChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeAllGroupChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeAllChatAdministrators::Class;

botCommandScopeAllChatAdministrators::botCommandScopeAllChatAdministrators() {
}

const std::int32_t botCommandScopeAllChatAdministrators::ID;

object_ptr<BotCommandScope> botCommandScopeAllChatAdministrators::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botCommandScopeAllChatAdministrators>();
}

void botCommandScopeAllChatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeAllChatAdministrators");
    s.store_class_end();
  }
}

void botCommandScopeAllChatAdministrators::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeAllChatAdministrators").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeChat::Class;
jfieldID botCommandScopeChat::chat_id_fieldID;

botCommandScopeChat::botCommandScopeChat()
  : chat_id_()
{}

botCommandScopeChat::botCommandScopeChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t botCommandScopeChat::ID;

object_ptr<BotCommandScope> botCommandScopeChat::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botCommandScopeChat> res = make_object<botCommandScopeChat>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  return std::move(res);
}

void botCommandScopeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeChat");
    s.store_field("chatId", chat_id_);
    s.store_class_end();
  }
}

void botCommandScopeChat::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeChat").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeChatAdministrators::Class;
jfieldID botCommandScopeChatAdministrators::chat_id_fieldID;

botCommandScopeChatAdministrators::botCommandScopeChatAdministrators()
  : chat_id_()
{}

botCommandScopeChatAdministrators::botCommandScopeChatAdministrators(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t botCommandScopeChatAdministrators::ID;

object_ptr<BotCommandScope> botCommandScopeChatAdministrators::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botCommandScopeChatAdministrators> res = make_object<botCommandScopeChatAdministrators>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  return std::move(res);
}

void botCommandScopeChatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeChatAdministrators");
    s.store_field("chatId", chat_id_);
    s.store_class_end();
  }
}

void botCommandScopeChatAdministrators::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeChatAdministrators").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass botCommandScopeChatMember::Class;
jfieldID botCommandScopeChatMember::chat_id_fieldID;
jfieldID botCommandScopeChatMember::user_id_fieldID;

botCommandScopeChatMember::botCommandScopeChatMember()
  : chat_id_()
  , user_id_()
{}

botCommandScopeChatMember::botCommandScopeChatMember(int53 chat_id_, int53 user_id_)
  : chat_id_(chat_id_)
  , user_id_(user_id_)
{}

const std::int32_t botCommandScopeChatMember::ID;

object_ptr<BotCommandScope> botCommandScopeChatMember::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botCommandScopeChatMember> res = make_object<botCommandScopeChatMember>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  return std::move(res);
}

void botCommandScopeChatMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommandScopeChatMember");
    s.store_field("chatId", chat_id_);
    s.store_field("userId", user_id_);
    s.store_class_end();
  }
}

void botCommandScopeChatMember::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommandScopeChatMember").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass botCommands::Class;
jfieldID botCommands::bot_user_id_fieldID;
jfieldID botCommands::commands_fieldID;

botCommands::botCommands()
  : bot_user_id_()
  , commands_()
{}

botCommands::botCommands(int53 bot_user_id_, array<object_ptr<botCommand>> &&commands_)
  : bot_user_id_(bot_user_id_)
  , commands_(std::move(commands_))
{}

const std::int32_t botCommands::ID;

object_ptr<botCommands> botCommands::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botCommands> res = make_object<botCommands>();
  res->bot_user_id_ = env->GetLongField(p, res->bot_user_id_fieldID);
  res->commands_ = jni::FetchVector<botCommand>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->commands_fieldID));
  return res;
}

void botCommands::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, bot_user_id_fieldID, bot_user_id_);
  { auto arr_tmp_ = jni::store_vector(env, commands_); if (arr_tmp_) { env->SetObjectField(s, commands_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void botCommands::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotCommands");
    s.store_field("botUserId", bot_user_id_);
    { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void botCommands::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotCommands").c_str());
    bot_user_id_fieldID = jni::get_field_id(env, Class, "botUserId", "J");
    commands_fieldID = jni::get_field_id(env, Class, "commands", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BotCommand;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botInfo::Class;
jfieldID botInfo::short_description_fieldID;
jfieldID botInfo::description_fieldID;
jfieldID botInfo::photo_fieldID;
jfieldID botInfo::animation_fieldID;
jfieldID botInfo::menu_button_fieldID;
jfieldID botInfo::commands_fieldID;
jfieldID botInfo::privacy_policy_url_fieldID;
jfieldID botInfo::default_group_administrator_rights_fieldID;
jfieldID botInfo::default_channel_administrator_rights_fieldID;
jfieldID botInfo::affiliate_program_fieldID;
jfieldID botInfo::web_app_background_light_color_fieldID;
jfieldID botInfo::web_app_background_dark_color_fieldID;
jfieldID botInfo::web_app_header_light_color_fieldID;
jfieldID botInfo::web_app_header_dark_color_fieldID;
jfieldID botInfo::verification_parameters_fieldID;
jfieldID botInfo::can_get_revenue_statistics_fieldID;
jfieldID botInfo::can_manage_emoji_status_fieldID;
jfieldID botInfo::has_media_previews_fieldID;
jfieldID botInfo::edit_commands_link_fieldID;
jfieldID botInfo::edit_description_link_fieldID;
jfieldID botInfo::edit_description_media_link_fieldID;
jfieldID botInfo::edit_settings_link_fieldID;

botInfo::botInfo()
  : short_description_()
  , description_()
  , photo_()
  , animation_()
  , menu_button_()
  , commands_()
  , privacy_policy_url_()
  , default_group_administrator_rights_()
  , default_channel_administrator_rights_()
  , affiliate_program_()
  , web_app_background_light_color_()
  , web_app_background_dark_color_()
  , web_app_header_light_color_()
  , web_app_header_dark_color_()
  , verification_parameters_()
  , can_get_revenue_statistics_()
  , can_manage_emoji_status_()
  , has_media_previews_()
  , edit_commands_link_()
  , edit_description_link_()
  , edit_description_media_link_()
  , edit_settings_link_()
{}

botInfo::botInfo(string const &short_description_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_, object_ptr<botMenuButton> &&menu_button_, array<object_ptr<botCommand>> &&commands_, string const &privacy_policy_url_, object_ptr<chatAdministratorRights> &&default_group_administrator_rights_, object_ptr<chatAdministratorRights> &&default_channel_administrator_rights_, object_ptr<affiliateProgramInfo> &&affiliate_program_, int32 web_app_background_light_color_, int32 web_app_background_dark_color_, int32 web_app_header_light_color_, int32 web_app_header_dark_color_, object_ptr<botVerificationParameters> &&verification_parameters_, bool can_get_revenue_statistics_, bool can_manage_emoji_status_, bool has_media_previews_, object_ptr<InternalLinkType> &&edit_commands_link_, object_ptr<InternalLinkType> &&edit_description_link_, object_ptr<InternalLinkType> &&edit_description_media_link_, object_ptr<InternalLinkType> &&edit_settings_link_)
  : short_description_(short_description_)
  , description_(description_)
  , photo_(std::move(photo_))
  , animation_(std::move(animation_))
  , menu_button_(std::move(menu_button_))
  , commands_(std::move(commands_))
  , privacy_policy_url_(privacy_policy_url_)
  , default_group_administrator_rights_(std::move(default_group_administrator_rights_))
  , default_channel_administrator_rights_(std::move(default_channel_administrator_rights_))
  , affiliate_program_(std::move(affiliate_program_))
  , web_app_background_light_color_(web_app_background_light_color_)
  , web_app_background_dark_color_(web_app_background_dark_color_)
  , web_app_header_light_color_(web_app_header_light_color_)
  , web_app_header_dark_color_(web_app_header_dark_color_)
  , verification_parameters_(std::move(verification_parameters_))
  , can_get_revenue_statistics_(can_get_revenue_statistics_)
  , can_manage_emoji_status_(can_manage_emoji_status_)
  , has_media_previews_(has_media_previews_)
  , edit_commands_link_(std::move(edit_commands_link_))
  , edit_description_link_(std::move(edit_description_link_))
  , edit_description_media_link_(std::move(edit_description_media_link_))
  , edit_settings_link_(std::move(edit_settings_link_))
{}

const std::int32_t botInfo::ID;

object_ptr<botInfo> botInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botInfo> res = make_object<botInfo>();
  res->short_description_ = jni::fetch_string(env, p, res->short_description_fieldID);
  res->description_ = jni::fetch_string(env, p, res->description_fieldID);
  res->photo_ = jni::fetch_tl_object<photo>(env, jni::fetch_object(env, p, res->photo_fieldID));
  res->animation_ = jni::fetch_tl_object<animation>(env, jni::fetch_object(env, p, res->animation_fieldID));
  res->menu_button_ = jni::fetch_tl_object<botMenuButton>(env, jni::fetch_object(env, p, res->menu_button_fieldID));
  res->commands_ = jni::FetchVector<botCommand>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->commands_fieldID));
  res->privacy_policy_url_ = jni::fetch_string(env, p, res->privacy_policy_url_fieldID);
  res->default_group_administrator_rights_ = jni::fetch_tl_object<chatAdministratorRights>(env, jni::fetch_object(env, p, res->default_group_administrator_rights_fieldID));
  res->default_channel_administrator_rights_ = jni::fetch_tl_object<chatAdministratorRights>(env, jni::fetch_object(env, p, res->default_channel_administrator_rights_fieldID));
  res->affiliate_program_ = jni::fetch_tl_object<affiliateProgramInfo>(env, jni::fetch_object(env, p, res->affiliate_program_fieldID));
  res->web_app_background_light_color_ = env->GetIntField(p, res->web_app_background_light_color_fieldID);
  res->web_app_background_dark_color_ = env->GetIntField(p, res->web_app_background_dark_color_fieldID);
  res->web_app_header_light_color_ = env->GetIntField(p, res->web_app_header_light_color_fieldID);
  res->web_app_header_dark_color_ = env->GetIntField(p, res->web_app_header_dark_color_fieldID);
  res->verification_parameters_ = jni::fetch_tl_object<botVerificationParameters>(env, jni::fetch_object(env, p, res->verification_parameters_fieldID));
  res->can_get_revenue_statistics_ = (env->GetBooleanField(p, res->can_get_revenue_statistics_fieldID) != 0);
  res->can_manage_emoji_status_ = (env->GetBooleanField(p, res->can_manage_emoji_status_fieldID) != 0);
  res->has_media_previews_ = (env->GetBooleanField(p, res->has_media_previews_fieldID) != 0);
  res->edit_commands_link_ = jni::fetch_tl_object<InternalLinkType>(env, jni::fetch_object(env, p, res->edit_commands_link_fieldID));
  res->edit_description_link_ = jni::fetch_tl_object<InternalLinkType>(env, jni::fetch_object(env, p, res->edit_description_link_fieldID));
  res->edit_description_media_link_ = jni::fetch_tl_object<InternalLinkType>(env, jni::fetch_object(env, p, res->edit_description_media_link_fieldID));
  res->edit_settings_link_ = jni::fetch_tl_object<InternalLinkType>(env, jni::fetch_object(env, p, res->edit_settings_link_fieldID));
  return res;
}

void botInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, short_description_); if (nextString) { env->SetObjectField(s, short_description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, description_); if (nextString) { env->SetObjectField(s, description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (photo_ != nullptr) { jobject next; photo_->store(env, next); if (next) { env->SetObjectField(s, photo_fieldID, next); env->DeleteLocalRef(next); } }
  if (animation_ != nullptr) { jobject next; animation_->store(env, next); if (next) { env->SetObjectField(s, animation_fieldID, next); env->DeleteLocalRef(next); } }
  if (menu_button_ != nullptr) { jobject next; menu_button_->store(env, next); if (next) { env->SetObjectField(s, menu_button_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, commands_); if (arr_tmp_) { env->SetObjectField(s, commands_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { jstring nextString = jni::to_jstring(env, privacy_policy_url_); if (nextString) { env->SetObjectField(s, privacy_policy_url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (default_group_administrator_rights_ != nullptr) { jobject next; default_group_administrator_rights_->store(env, next); if (next) { env->SetObjectField(s, default_group_administrator_rights_fieldID, next); env->DeleteLocalRef(next); } }
  if (default_channel_administrator_rights_ != nullptr) { jobject next; default_channel_administrator_rights_->store(env, next); if (next) { env->SetObjectField(s, default_channel_administrator_rights_fieldID, next); env->DeleteLocalRef(next); } }
  if (affiliate_program_ != nullptr) { jobject next; affiliate_program_->store(env, next); if (next) { env->SetObjectField(s, affiliate_program_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, web_app_background_light_color_fieldID, web_app_background_light_color_);
  env->SetIntField(s, web_app_background_dark_color_fieldID, web_app_background_dark_color_);
  env->SetIntField(s, web_app_header_light_color_fieldID, web_app_header_light_color_);
  env->SetIntField(s, web_app_header_dark_color_fieldID, web_app_header_dark_color_);
  if (verification_parameters_ != nullptr) { jobject next; verification_parameters_->store(env, next); if (next) { env->SetObjectField(s, verification_parameters_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, can_get_revenue_statistics_fieldID, can_get_revenue_statistics_);
  env->SetBooleanField(s, can_manage_emoji_status_fieldID, can_manage_emoji_status_);
  env->SetBooleanField(s, has_media_previews_fieldID, has_media_previews_);
  if (edit_commands_link_ != nullptr) { jobject next; edit_commands_link_->store(env, next); if (next) { env->SetObjectField(s, edit_commands_link_fieldID, next); env->DeleteLocalRef(next); } }
  if (edit_description_link_ != nullptr) { jobject next; edit_description_link_->store(env, next); if (next) { env->SetObjectField(s, edit_description_link_fieldID, next); env->DeleteLocalRef(next); } }
  if (edit_description_media_link_ != nullptr) { jobject next; edit_description_media_link_->store(env, next); if (next) { env->SetObjectField(s, edit_description_media_link_fieldID, next); env->DeleteLocalRef(next); } }
  if (edit_settings_link_ != nullptr) { jobject next; edit_settings_link_->store(env, next); if (next) { env->SetObjectField(s, edit_settings_link_fieldID, next); env->DeleteLocalRef(next); } }
}

void botInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotInfo");
    s.store_field("shortDescription", short_description_);
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("menuButton", static_cast<const BaseObject *>(menu_button_.get()));
    { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("privacyPolicyUrl", privacy_policy_url_);
    s.store_object_field("defaultGroupAdministratorRights", static_cast<const BaseObject *>(default_group_administrator_rights_.get()));
    s.store_object_field("defaultChannelAdministratorRights", static_cast<const BaseObject *>(default_channel_administrator_rights_.get()));
    s.store_object_field("affiliateProgram", static_cast<const BaseObject *>(affiliate_program_.get()));
    s.store_field("webAppBackgroundLightColor", web_app_background_light_color_);
    s.store_field("webAppBackgroundDarkColor", web_app_background_dark_color_);
    s.store_field("webAppHeaderLightColor", web_app_header_light_color_);
    s.store_field("webAppHeaderDarkColor", web_app_header_dark_color_);
    s.store_object_field("verificationParameters", static_cast<const BaseObject *>(verification_parameters_.get()));
    s.store_field("canGetRevenueStatistics", can_get_revenue_statistics_);
    s.store_field("canManageEmojiStatus", can_manage_emoji_status_);
    s.store_field("hasMediaPreviews", has_media_previews_);
    s.store_object_field("editCommandsLink", static_cast<const BaseObject *>(edit_commands_link_.get()));
    s.store_object_field("editDescriptionLink", static_cast<const BaseObject *>(edit_description_link_.get()));
    s.store_object_field("editDescriptionMediaLink", static_cast<const BaseObject *>(edit_description_media_link_.get()));
    s.store_object_field("editSettingsLink", static_cast<const BaseObject *>(edit_settings_link_.get()));
    s.store_class_end();
  }
}

void botInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotInfo").c_str());
    short_description_fieldID = jni::get_field_id(env, Class, "shortDescription", "Ljava/lang/String;");
    description_fieldID = jni::get_field_id(env, Class, "description", "Ljava/lang/String;");
    photo_fieldID = jni::get_field_id(env, Class, "photo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Photo;").c_str());
    animation_fieldID = jni::get_field_id(env, Class, "animation", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Animation;").c_str());
    menu_button_fieldID = jni::get_field_id(env, Class, "menuButton", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BotMenuButton;").c_str());
    commands_fieldID = jni::get_field_id(env, Class, "commands", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BotCommand;").c_str());
    privacy_policy_url_fieldID = jni::get_field_id(env, Class, "privacyPolicyUrl", "Ljava/lang/String;");
    default_group_administrator_rights_fieldID = jni::get_field_id(env, Class, "defaultGroupAdministratorRights", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAdministratorRights;").c_str());
    default_channel_administrator_rights_fieldID = jni::get_field_id(env, Class, "defaultChannelAdministratorRights", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAdministratorRights;").c_str());
    affiliate_program_fieldID = jni::get_field_id(env, Class, "affiliateProgram", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AffiliateProgramInfo;").c_str());
    web_app_background_light_color_fieldID = jni::get_field_id(env, Class, "webAppBackgroundLightColor", "I");
    web_app_background_dark_color_fieldID = jni::get_field_id(env, Class, "webAppBackgroundDarkColor", "I");
    web_app_header_light_color_fieldID = jni::get_field_id(env, Class, "webAppHeaderLightColor", "I");
    web_app_header_dark_color_fieldID = jni::get_field_id(env, Class, "webAppHeaderDarkColor", "I");
    verification_parameters_fieldID = jni::get_field_id(env, Class, "verificationParameters", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BotVerificationParameters;").c_str());
    can_get_revenue_statistics_fieldID = jni::get_field_id(env, Class, "canGetRevenueStatistics", "Z");
    can_manage_emoji_status_fieldID = jni::get_field_id(env, Class, "canManageEmojiStatus", "Z");
    has_media_previews_fieldID = jni::get_field_id(env, Class, "hasMediaPreviews", "Z");
    edit_commands_link_fieldID = jni::get_field_id(env, Class, "editCommandsLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$InternalLinkType;").c_str());
    edit_description_link_fieldID = jni::get_field_id(env, Class, "editDescriptionLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$InternalLinkType;").c_str());
    edit_description_media_link_fieldID = jni::get_field_id(env, Class, "editDescriptionMediaLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$InternalLinkType;").c_str());
    edit_settings_link_fieldID = jni::get_field_id(env, Class, "editSettingsLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$InternalLinkType;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botMediaPreview::Class;
jfieldID botMediaPreview::date_fieldID;
jfieldID botMediaPreview::content_fieldID;

botMediaPreview::botMediaPreview()
  : date_()
  , content_()
{}

botMediaPreview::botMediaPreview(int32 date_, object_ptr<StoryContent> &&content_)
  : date_(date_)
  , content_(std::move(content_))
{}

const std::int32_t botMediaPreview::ID;

object_ptr<botMediaPreview> botMediaPreview::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botMediaPreview> res = make_object<botMediaPreview>();
  res->date_ = env->GetIntField(p, res->date_fieldID);
  res->content_ = jni::fetch_tl_object<StoryContent>(env, jni::fetch_object(env, p, res->content_fieldID));
  return res;
}

void botMediaPreview::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, date_fieldID, date_);
  if (content_ != nullptr) { jobject next; content_->store(env, next); if (next) { env->SetObjectField(s, content_fieldID, next); env->DeleteLocalRef(next); } }
}

void botMediaPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotMediaPreview");
    s.store_field("date", date_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_class_end();
  }
}

void botMediaPreview::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotMediaPreview").c_str());
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    content_fieldID = jni::get_field_id(env, Class, "content", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StoryContent;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botMediaPreviewInfo::Class;
jfieldID botMediaPreviewInfo::previews_fieldID;
jfieldID botMediaPreviewInfo::language_codes_fieldID;

botMediaPreviewInfo::botMediaPreviewInfo()
  : previews_()
  , language_codes_()
{}

botMediaPreviewInfo::botMediaPreviewInfo(array<object_ptr<botMediaPreview>> &&previews_, array<string> &&language_codes_)
  : previews_(std::move(previews_))
  , language_codes_(std::move(language_codes_))
{}

const std::int32_t botMediaPreviewInfo::ID;

object_ptr<botMediaPreviewInfo> botMediaPreviewInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botMediaPreviewInfo> res = make_object<botMediaPreviewInfo>();
  res->previews_ = jni::FetchVector<botMediaPreview>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->previews_fieldID));
  res->language_codes_ = jni::FetchVector<string>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->language_codes_fieldID));
  return res;
}

void botMediaPreviewInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, previews_); if (arr_tmp_) { env->SetObjectField(s, previews_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, language_codes_); if (arr_tmp_) { env->SetObjectField(s, language_codes_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void botMediaPreviewInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotMediaPreviewInfo");
    { s.store_vector_begin("previews", previews_.size()); for (const auto &_value : previews_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("languageCodes", language_codes_.size()); for (const auto &_value : language_codes_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void botMediaPreviewInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotMediaPreviewInfo").c_str());
    previews_fieldID = jni::get_field_id(env, Class, "previews", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BotMediaPreview;").c_str());
    language_codes_fieldID = jni::get_field_id(env, Class, "languageCodes", "[Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass botMediaPreviews::Class;
jfieldID botMediaPreviews::previews_fieldID;

botMediaPreviews::botMediaPreviews()
  : previews_()
{}

botMediaPreviews::botMediaPreviews(array<object_ptr<botMediaPreview>> &&previews_)
  : previews_(std::move(previews_))
{}

const std::int32_t botMediaPreviews::ID;

object_ptr<botMediaPreviews> botMediaPreviews::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botMediaPreviews> res = make_object<botMediaPreviews>();
  res->previews_ = jni::FetchVector<botMediaPreview>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->previews_fieldID));
  return res;
}

void botMediaPreviews::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, previews_); if (arr_tmp_) { env->SetObjectField(s, previews_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void botMediaPreviews::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotMediaPreviews");
    { s.store_vector_begin("previews", previews_.size()); for (const auto &_value : previews_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void botMediaPreviews::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotMediaPreviews").c_str());
    previews_fieldID = jni::get_field_id(env, Class, "previews", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BotMediaPreview;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botMenuButton::Class;
jfieldID botMenuButton::text_fieldID;
jfieldID botMenuButton::url_fieldID;

botMenuButton::botMenuButton()
  : text_()
  , url_()
{}

botMenuButton::botMenuButton(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t botMenuButton::ID;

object_ptr<botMenuButton> botMenuButton::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botMenuButton> res = make_object<botMenuButton>();
  res->text_ = jni::fetch_string(env, p, res->text_fieldID);
  res->url_ = jni::fetch_string(env, p, res->url_fieldID);
  return res;
}

void botMenuButton::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, text_); if (nextString) { env->SetObjectField(s, text_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, url_); if (nextString) { env->SetObjectField(s, url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void botMenuButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotMenuButton");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

void botMenuButton::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotMenuButton").c_str());
    text_fieldID = jni::get_field_id(env, Class, "text", "Ljava/lang/String;");
    url_fieldID = jni::get_field_id(env, Class, "url", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass botVerification::Class;
jfieldID botVerification::bot_user_id_fieldID;
jfieldID botVerification::icon_custom_emoji_id_fieldID;
jfieldID botVerification::custom_description_fieldID;

botVerification::botVerification()
  : bot_user_id_()
  , icon_custom_emoji_id_()
  , custom_description_()
{}

botVerification::botVerification(int53 bot_user_id_, int64 icon_custom_emoji_id_, object_ptr<formattedText> &&custom_description_)
  : bot_user_id_(bot_user_id_)
  , icon_custom_emoji_id_(icon_custom_emoji_id_)
  , custom_description_(std::move(custom_description_))
{}

const std::int32_t botVerification::ID;

object_ptr<botVerification> botVerification::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botVerification> res = make_object<botVerification>();
  res->bot_user_id_ = env->GetLongField(p, res->bot_user_id_fieldID);
  res->icon_custom_emoji_id_ = env->GetLongField(p, res->icon_custom_emoji_id_fieldID);
  res->custom_description_ = jni::fetch_tl_object<formattedText>(env, jni::fetch_object(env, p, res->custom_description_fieldID));
  return res;
}

void botVerification::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, bot_user_id_fieldID, bot_user_id_);
  env->SetLongField(s, icon_custom_emoji_id_fieldID, icon_custom_emoji_id_);
  if (custom_description_ != nullptr) { jobject next; custom_description_->store(env, next); if (next) { env->SetObjectField(s, custom_description_fieldID, next); env->DeleteLocalRef(next); } }
}

void botVerification::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotVerification");
    s.store_field("botUserId", bot_user_id_);
    s.store_field("iconCustomEmojiId", icon_custom_emoji_id_);
    s.store_object_field("customDescription", static_cast<const BaseObject *>(custom_description_.get()));
    s.store_class_end();
  }
}

void botVerification::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotVerification").c_str());
    bot_user_id_fieldID = jni::get_field_id(env, Class, "botUserId", "J");
    icon_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "iconCustomEmojiId", "J");
    custom_description_fieldID = jni::get_field_id(env, Class, "customDescription", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FormattedText;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botVerificationParameters::Class;
jfieldID botVerificationParameters::icon_custom_emoji_id_fieldID;
jfieldID botVerificationParameters::organization_name_fieldID;
jfieldID botVerificationParameters::default_custom_description_fieldID;
jfieldID botVerificationParameters::can_set_custom_description_fieldID;

botVerificationParameters::botVerificationParameters()
  : icon_custom_emoji_id_()
  , organization_name_()
  , default_custom_description_()
  , can_set_custom_description_()
{}

botVerificationParameters::botVerificationParameters(int64 icon_custom_emoji_id_, string const &organization_name_, object_ptr<formattedText> &&default_custom_description_, bool can_set_custom_description_)
  : icon_custom_emoji_id_(icon_custom_emoji_id_)
  , organization_name_(organization_name_)
  , default_custom_description_(std::move(default_custom_description_))
  , can_set_custom_description_(can_set_custom_description_)
{}

const std::int32_t botVerificationParameters::ID;

object_ptr<botVerificationParameters> botVerificationParameters::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botVerificationParameters> res = make_object<botVerificationParameters>();
  res->icon_custom_emoji_id_ = env->GetLongField(p, res->icon_custom_emoji_id_fieldID);
  res->organization_name_ = jni::fetch_string(env, p, res->organization_name_fieldID);
  res->default_custom_description_ = jni::fetch_tl_object<formattedText>(env, jni::fetch_object(env, p, res->default_custom_description_fieldID));
  res->can_set_custom_description_ = (env->GetBooleanField(p, res->can_set_custom_description_fieldID) != 0);
  return res;
}

void botVerificationParameters::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, icon_custom_emoji_id_fieldID, icon_custom_emoji_id_);
  { jstring nextString = jni::to_jstring(env, organization_name_); if (nextString) { env->SetObjectField(s, organization_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (default_custom_description_ != nullptr) { jobject next; default_custom_description_->store(env, next); if (next) { env->SetObjectField(s, default_custom_description_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, can_set_custom_description_fieldID, can_set_custom_description_);
}

void botVerificationParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotVerificationParameters");
    s.store_field("iconCustomEmojiId", icon_custom_emoji_id_);
    s.store_field("organizationName", organization_name_);
    s.store_object_field("defaultCustomDescription", static_cast<const BaseObject *>(default_custom_description_.get()));
    s.store_field("canSetCustomDescription", can_set_custom_description_);
    s.store_class_end();
  }
}

void botVerificationParameters::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotVerificationParameters").c_str());
    icon_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "iconCustomEmojiId", "J");
    organization_name_fieldID = jni::get_field_id(env, Class, "organizationName", "Ljava/lang/String;");
    default_custom_description_fieldID = jni::get_field_id(env, Class, "defaultCustomDescription", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FormattedText;").c_str());
    can_set_custom_description_fieldID = jni::get_field_id(env, Class, "canSetCustomDescription", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass BotWriteAccessAllowReason::Class;

object_ptr<BotWriteAccessAllowReason> BotWriteAccessAllowReason::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case botWriteAccessAllowReasonConnectedWebsite::ID:
      return botWriteAccessAllowReasonConnectedWebsite::fetch(env, p);
    case botWriteAccessAllowReasonAddedToAttachmentMenu::ID:
      return botWriteAccessAllowReasonAddedToAttachmentMenu::fetch(env, p);
    case botWriteAccessAllowReasonLaunchedWebApp::ID:
      return botWriteAccessAllowReasonLaunchedWebApp::fetch(env, p);
    case botWriteAccessAllowReasonAcceptedRequest::ID:
      return botWriteAccessAllowReasonAcceptedRequest::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BotWriteAccessAllowReason::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotWriteAccessAllowReason").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botWriteAccessAllowReasonConnectedWebsite::Class;
jfieldID botWriteAccessAllowReasonConnectedWebsite::domain_name_fieldID;

botWriteAccessAllowReasonConnectedWebsite::botWriteAccessAllowReasonConnectedWebsite()
  : domain_name_()
{}

botWriteAccessAllowReasonConnectedWebsite::botWriteAccessAllowReasonConnectedWebsite(string const &domain_name_)
  : domain_name_(domain_name_)
{}

const std::int32_t botWriteAccessAllowReasonConnectedWebsite::ID;

object_ptr<BotWriteAccessAllowReason> botWriteAccessAllowReasonConnectedWebsite::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botWriteAccessAllowReasonConnectedWebsite> res = make_object<botWriteAccessAllowReasonConnectedWebsite>();
  res->domain_name_ = jni::fetch_string(env, p, res->domain_name_fieldID);
  return std::move(res);
}

void botWriteAccessAllowReasonConnectedWebsite::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, domain_name_); if (nextString) { env->SetObjectField(s, domain_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void botWriteAccessAllowReasonConnectedWebsite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotWriteAccessAllowReasonConnectedWebsite");
    s.store_field("domainName", domain_name_);
    s.store_class_end();
  }
}

void botWriteAccessAllowReasonConnectedWebsite::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotWriteAccessAllowReasonConnectedWebsite").c_str());
    domain_name_fieldID = jni::get_field_id(env, Class, "domainName", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass botWriteAccessAllowReasonAddedToAttachmentMenu::Class;

botWriteAccessAllowReasonAddedToAttachmentMenu::botWriteAccessAllowReasonAddedToAttachmentMenu() {
}

const std::int32_t botWriteAccessAllowReasonAddedToAttachmentMenu::ID;

object_ptr<BotWriteAccessAllowReason> botWriteAccessAllowReasonAddedToAttachmentMenu::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botWriteAccessAllowReasonAddedToAttachmentMenu>();
}

void botWriteAccessAllowReasonAddedToAttachmentMenu::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void botWriteAccessAllowReasonAddedToAttachmentMenu::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotWriteAccessAllowReasonAddedToAttachmentMenu");
    s.store_class_end();
  }
}

void botWriteAccessAllowReasonAddedToAttachmentMenu::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotWriteAccessAllowReasonAddedToAttachmentMenu").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botWriteAccessAllowReasonLaunchedWebApp::Class;
jfieldID botWriteAccessAllowReasonLaunchedWebApp::web_app_fieldID;

botWriteAccessAllowReasonLaunchedWebApp::botWriteAccessAllowReasonLaunchedWebApp()
  : web_app_()
{}

botWriteAccessAllowReasonLaunchedWebApp::botWriteAccessAllowReasonLaunchedWebApp(object_ptr<webApp> &&web_app_)
  : web_app_(std::move(web_app_))
{}

const std::int32_t botWriteAccessAllowReasonLaunchedWebApp::ID;

object_ptr<BotWriteAccessAllowReason> botWriteAccessAllowReasonLaunchedWebApp::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<botWriteAccessAllowReasonLaunchedWebApp> res = make_object<botWriteAccessAllowReasonLaunchedWebApp>();
  res->web_app_ = jni::fetch_tl_object<webApp>(env, jni::fetch_object(env, p, res->web_app_fieldID));
  return std::move(res);
}

void botWriteAccessAllowReasonLaunchedWebApp::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (web_app_ != nullptr) { jobject next; web_app_->store(env, next); if (next) { env->SetObjectField(s, web_app_fieldID, next); env->DeleteLocalRef(next); } }
}

void botWriteAccessAllowReasonLaunchedWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotWriteAccessAllowReasonLaunchedWebApp");
    s.store_object_field("webApp", static_cast<const BaseObject *>(web_app_.get()));
    s.store_class_end();
  }
}

void botWriteAccessAllowReasonLaunchedWebApp::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotWriteAccessAllowReasonLaunchedWebApp").c_str());
    web_app_fieldID = jni::get_field_id(env, Class, "webApp", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$WebApp;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass botWriteAccessAllowReasonAcceptedRequest::Class;

botWriteAccessAllowReasonAcceptedRequest::botWriteAccessAllowReasonAcceptedRequest() {
}

const std::int32_t botWriteAccessAllowReasonAcceptedRequest::ID;

object_ptr<BotWriteAccessAllowReason> botWriteAccessAllowReasonAcceptedRequest::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<botWriteAccessAllowReasonAcceptedRequest>();
}

void botWriteAccessAllowReasonAcceptedRequest::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void botWriteAccessAllowReasonAcceptedRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BotWriteAccessAllowReasonAcceptedRequest");
    s.store_class_end();
  }
}

void botWriteAccessAllowReasonAcceptedRequest::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BotWriteAccessAllowReasonAcceptedRequest").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass BusinessAwayMessageSchedule::Class;

object_ptr<BusinessAwayMessageSchedule> BusinessAwayMessageSchedule::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case businessAwayMessageScheduleAlways::ID:
      return businessAwayMessageScheduleAlways::fetch(env, p);
    case businessAwayMessageScheduleOutsideOfOpeningHours::ID:
      return businessAwayMessageScheduleOutsideOfOpeningHours::fetch(env, p);
    case businessAwayMessageScheduleCustom::ID:
      return businessAwayMessageScheduleCustom::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BusinessAwayMessageSchedule::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessAwayMessageSchedule").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessAwayMessageScheduleAlways::Class;

businessAwayMessageScheduleAlways::businessAwayMessageScheduleAlways() {
}

const std::int32_t businessAwayMessageScheduleAlways::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleAlways::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessAwayMessageScheduleAlways>();
}

void businessAwayMessageScheduleAlways::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessAwayMessageScheduleAlways::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessAwayMessageScheduleAlways");
    s.store_class_end();
  }
}

void businessAwayMessageScheduleAlways::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessAwayMessageScheduleAlways").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessAwayMessageScheduleOutsideOfOpeningHours::Class;

businessAwayMessageScheduleOutsideOfOpeningHours::businessAwayMessageScheduleOutsideOfOpeningHours() {
}

const std::int32_t businessAwayMessageScheduleOutsideOfOpeningHours::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleOutsideOfOpeningHours::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessAwayMessageScheduleOutsideOfOpeningHours>();
}

void businessAwayMessageScheduleOutsideOfOpeningHours::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessAwayMessageScheduleOutsideOfOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessAwayMessageScheduleOutsideOfOpeningHours");
    s.store_class_end();
  }
}

void businessAwayMessageScheduleOutsideOfOpeningHours::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessAwayMessageScheduleOutsideOfOpeningHours").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessAwayMessageScheduleCustom::Class;
jfieldID businessAwayMessageScheduleCustom::start_date_fieldID;
jfieldID businessAwayMessageScheduleCustom::end_date_fieldID;

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom()
  : start_date_()
  , end_date_()
{}

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom(int32 start_date_, int32 end_date_)
  : start_date_(start_date_)
  , end_date_(end_date_)
{}

const std::int32_t businessAwayMessageScheduleCustom::ID;

object_ptr<BusinessAwayMessageSchedule> businessAwayMessageScheduleCustom::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessAwayMessageScheduleCustom> res = make_object<businessAwayMessageScheduleCustom>();
  res->start_date_ = env->GetIntField(p, res->start_date_fieldID);
  res->end_date_ = env->GetIntField(p, res->end_date_fieldID);
  return std::move(res);
}

void businessAwayMessageScheduleCustom::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, start_date_fieldID, start_date_);
  env->SetIntField(s, end_date_fieldID, end_date_);
}

void businessAwayMessageScheduleCustom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessAwayMessageScheduleCustom");
    s.store_field("startDate", start_date_);
    s.store_field("endDate", end_date_);
    s.store_class_end();
  }
}

void businessAwayMessageScheduleCustom::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessAwayMessageScheduleCustom").c_str());
    start_date_fieldID = jni::get_field_id(env, Class, "startDate", "I");
    end_date_fieldID = jni::get_field_id(env, Class, "endDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass businessAwayMessageSettings::Class;
jfieldID businessAwayMessageSettings::shortcut_id_fieldID;
jfieldID businessAwayMessageSettings::recipients_fieldID;
jfieldID businessAwayMessageSettings::schedule_fieldID;
jfieldID businessAwayMessageSettings::offline_only_fieldID;

businessAwayMessageSettings::businessAwayMessageSettings()
  : shortcut_id_()
  , recipients_()
  , schedule_()
  , offline_only_()
{}

businessAwayMessageSettings::businessAwayMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, object_ptr<BusinessAwayMessageSchedule> &&schedule_, bool offline_only_)
  : shortcut_id_(shortcut_id_)
  , recipients_(std::move(recipients_))
  , schedule_(std::move(schedule_))
  , offline_only_(offline_only_)
{}

const std::int32_t businessAwayMessageSettings::ID;

object_ptr<businessAwayMessageSettings> businessAwayMessageSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessAwayMessageSettings> res = make_object<businessAwayMessageSettings>();
  res->shortcut_id_ = env->GetIntField(p, res->shortcut_id_fieldID);
  res->recipients_ = jni::fetch_tl_object<businessRecipients>(env, jni::fetch_object(env, p, res->recipients_fieldID));
  res->schedule_ = jni::fetch_tl_object<BusinessAwayMessageSchedule>(env, jni::fetch_object(env, p, res->schedule_fieldID));
  res->offline_only_ = (env->GetBooleanField(p, res->offline_only_fieldID) != 0);
  return res;
}

void businessAwayMessageSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, shortcut_id_fieldID, shortcut_id_);
  if (recipients_ != nullptr) { jobject next; recipients_->store(env, next); if (next) { env->SetObjectField(s, recipients_fieldID, next); env->DeleteLocalRef(next); } }
  if (schedule_ != nullptr) { jobject next; schedule_->store(env, next); if (next) { env->SetObjectField(s, schedule_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, offline_only_fieldID, offline_only_);
}

void businessAwayMessageSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessAwayMessageSettings");
    s.store_field("shortcutId", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_object_field("schedule", static_cast<const BaseObject *>(schedule_.get()));
    s.store_field("offlineOnly", offline_only_);
    s.store_class_end();
  }
}

void businessAwayMessageSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessAwayMessageSettings").c_str());
    shortcut_id_fieldID = jni::get_field_id(env, Class, "shortcutId", "I");
    recipients_fieldID = jni::get_field_id(env, Class, "recipients", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessRecipients;").c_str());
    schedule_fieldID = jni::get_field_id(env, Class, "schedule", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessAwayMessageSchedule;").c_str());
    offline_only_fieldID = jni::get_field_id(env, Class, "offlineOnly", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass businessBotManageBar::Class;
jfieldID businessBotManageBar::bot_user_id_fieldID;
jfieldID businessBotManageBar::manage_url_fieldID;
jfieldID businessBotManageBar::is_bot_paused_fieldID;
jfieldID businessBotManageBar::can_bot_reply_fieldID;

businessBotManageBar::businessBotManageBar()
  : bot_user_id_()
  , manage_url_()
  , is_bot_paused_()
  , can_bot_reply_()
{}

businessBotManageBar::businessBotManageBar(int53 bot_user_id_, string const &manage_url_, bool is_bot_paused_, bool can_bot_reply_)
  : bot_user_id_(bot_user_id_)
  , manage_url_(manage_url_)
  , is_bot_paused_(is_bot_paused_)
  , can_bot_reply_(can_bot_reply_)
{}

const std::int32_t businessBotManageBar::ID;

object_ptr<businessBotManageBar> businessBotManageBar::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessBotManageBar> res = make_object<businessBotManageBar>();
  res->bot_user_id_ = env->GetLongField(p, res->bot_user_id_fieldID);
  res->manage_url_ = jni::fetch_string(env, p, res->manage_url_fieldID);
  res->is_bot_paused_ = (env->GetBooleanField(p, res->is_bot_paused_fieldID) != 0);
  res->can_bot_reply_ = (env->GetBooleanField(p, res->can_bot_reply_fieldID) != 0);
  return res;
}

void businessBotManageBar::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, bot_user_id_fieldID, bot_user_id_);
  { jstring nextString = jni::to_jstring(env, manage_url_); if (nextString) { env->SetObjectField(s, manage_url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, is_bot_paused_fieldID, is_bot_paused_);
  env->SetBooleanField(s, can_bot_reply_fieldID, can_bot_reply_);
}

void businessBotManageBar::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessBotManageBar");
    s.store_field("botUserId", bot_user_id_);
    s.store_field("manageUrl", manage_url_);
    s.store_field("isBotPaused", is_bot_paused_);
    s.store_field("canBotReply", can_bot_reply_);
    s.store_class_end();
  }
}

void businessBotManageBar::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessBotManageBar").c_str());
    bot_user_id_fieldID = jni::get_field_id(env, Class, "botUserId", "J");
    manage_url_fieldID = jni::get_field_id(env, Class, "manageUrl", "Ljava/lang/String;");
    is_bot_paused_fieldID = jni::get_field_id(env, Class, "isBotPaused", "Z");
    can_bot_reply_fieldID = jni::get_field_id(env, Class, "canBotReply", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass businessBotRights::Class;
jfieldID businessBotRights::can_reply_fieldID;
jfieldID businessBotRights::can_read_messages_fieldID;
jfieldID businessBotRights::can_delete_sent_messages_fieldID;
jfieldID businessBotRights::can_delete_all_messages_fieldID;
jfieldID businessBotRights::can_edit_name_fieldID;
jfieldID businessBotRights::can_edit_bio_fieldID;
jfieldID businessBotRights::can_edit_profile_photo_fieldID;
jfieldID businessBotRights::can_edit_username_fieldID;
jfieldID businessBotRights::can_view_gifts_and_stars_fieldID;
jfieldID businessBotRights::can_sell_gifts_fieldID;
jfieldID businessBotRights::can_change_gift_settings_fieldID;
jfieldID businessBotRights::can_transfer_and_upgrade_gifts_fieldID;
jfieldID businessBotRights::can_transfer_stars_fieldID;
jfieldID businessBotRights::can_manage_stories_fieldID;

businessBotRights::businessBotRights()
  : can_reply_()
  , can_read_messages_()
  , can_delete_sent_messages_()
  , can_delete_all_messages_()
  , can_edit_name_()
  , can_edit_bio_()
  , can_edit_profile_photo_()
  , can_edit_username_()
  , can_view_gifts_and_stars_()
  , can_sell_gifts_()
  , can_change_gift_settings_()
  , can_transfer_and_upgrade_gifts_()
  , can_transfer_stars_()
  , can_manage_stories_()
{}

businessBotRights::businessBotRights(bool can_reply_, bool can_read_messages_, bool can_delete_sent_messages_, bool can_delete_all_messages_, bool can_edit_name_, bool can_edit_bio_, bool can_edit_profile_photo_, bool can_edit_username_, bool can_view_gifts_and_stars_, bool can_sell_gifts_, bool can_change_gift_settings_, bool can_transfer_and_upgrade_gifts_, bool can_transfer_stars_, bool can_manage_stories_)
  : can_reply_(can_reply_)
  , can_read_messages_(can_read_messages_)
  , can_delete_sent_messages_(can_delete_sent_messages_)
  , can_delete_all_messages_(can_delete_all_messages_)
  , can_edit_name_(can_edit_name_)
  , can_edit_bio_(can_edit_bio_)
  , can_edit_profile_photo_(can_edit_profile_photo_)
  , can_edit_username_(can_edit_username_)
  , can_view_gifts_and_stars_(can_view_gifts_and_stars_)
  , can_sell_gifts_(can_sell_gifts_)
  , can_change_gift_settings_(can_change_gift_settings_)
  , can_transfer_and_upgrade_gifts_(can_transfer_and_upgrade_gifts_)
  , can_transfer_stars_(can_transfer_stars_)
  , can_manage_stories_(can_manage_stories_)
{}

const std::int32_t businessBotRights::ID;

object_ptr<businessBotRights> businessBotRights::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessBotRights> res = make_object<businessBotRights>();
  res->can_reply_ = (env->GetBooleanField(p, res->can_reply_fieldID) != 0);
  res->can_read_messages_ = (env->GetBooleanField(p, res->can_read_messages_fieldID) != 0);
  res->can_delete_sent_messages_ = (env->GetBooleanField(p, res->can_delete_sent_messages_fieldID) != 0);
  res->can_delete_all_messages_ = (env->GetBooleanField(p, res->can_delete_all_messages_fieldID) != 0);
  res->can_edit_name_ = (env->GetBooleanField(p, res->can_edit_name_fieldID) != 0);
  res->can_edit_bio_ = (env->GetBooleanField(p, res->can_edit_bio_fieldID) != 0);
  res->can_edit_profile_photo_ = (env->GetBooleanField(p, res->can_edit_profile_photo_fieldID) != 0);
  res->can_edit_username_ = (env->GetBooleanField(p, res->can_edit_username_fieldID) != 0);
  res->can_view_gifts_and_stars_ = (env->GetBooleanField(p, res->can_view_gifts_and_stars_fieldID) != 0);
  res->can_sell_gifts_ = (env->GetBooleanField(p, res->can_sell_gifts_fieldID) != 0);
  res->can_change_gift_settings_ = (env->GetBooleanField(p, res->can_change_gift_settings_fieldID) != 0);
  res->can_transfer_and_upgrade_gifts_ = (env->GetBooleanField(p, res->can_transfer_and_upgrade_gifts_fieldID) != 0);
  res->can_transfer_stars_ = (env->GetBooleanField(p, res->can_transfer_stars_fieldID) != 0);
  res->can_manage_stories_ = (env->GetBooleanField(p, res->can_manage_stories_fieldID) != 0);
  return res;
}

void businessBotRights::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, can_reply_fieldID, can_reply_);
  env->SetBooleanField(s, can_read_messages_fieldID, can_read_messages_);
  env->SetBooleanField(s, can_delete_sent_messages_fieldID, can_delete_sent_messages_);
  env->SetBooleanField(s, can_delete_all_messages_fieldID, can_delete_all_messages_);
  env->SetBooleanField(s, can_edit_name_fieldID, can_edit_name_);
  env->SetBooleanField(s, can_edit_bio_fieldID, can_edit_bio_);
  env->SetBooleanField(s, can_edit_profile_photo_fieldID, can_edit_profile_photo_);
  env->SetBooleanField(s, can_edit_username_fieldID, can_edit_username_);
  env->SetBooleanField(s, can_view_gifts_and_stars_fieldID, can_view_gifts_and_stars_);
  env->SetBooleanField(s, can_sell_gifts_fieldID, can_sell_gifts_);
  env->SetBooleanField(s, can_change_gift_settings_fieldID, can_change_gift_settings_);
  env->SetBooleanField(s, can_transfer_and_upgrade_gifts_fieldID, can_transfer_and_upgrade_gifts_);
  env->SetBooleanField(s, can_transfer_stars_fieldID, can_transfer_stars_);
  env->SetBooleanField(s, can_manage_stories_fieldID, can_manage_stories_);
}

void businessBotRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessBotRights");
    s.store_field("canReply", can_reply_);
    s.store_field("canReadMessages", can_read_messages_);
    s.store_field("canDeleteSentMessages", can_delete_sent_messages_);
    s.store_field("canDeleteAllMessages", can_delete_all_messages_);
    s.store_field("canEditName", can_edit_name_);
    s.store_field("canEditBio", can_edit_bio_);
    s.store_field("canEditProfilePhoto", can_edit_profile_photo_);
    s.store_field("canEditUsername", can_edit_username_);
    s.store_field("canViewGiftsAndStars", can_view_gifts_and_stars_);
    s.store_field("canSellGifts", can_sell_gifts_);
    s.store_field("canChangeGiftSettings", can_change_gift_settings_);
    s.store_field("canTransferAndUpgradeGifts", can_transfer_and_upgrade_gifts_);
    s.store_field("canTransferStars", can_transfer_stars_);
    s.store_field("canManageStories", can_manage_stories_);
    s.store_class_end();
  }
}

void businessBotRights::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessBotRights").c_str());
    can_reply_fieldID = jni::get_field_id(env, Class, "canReply", "Z");
    can_read_messages_fieldID = jni::get_field_id(env, Class, "canReadMessages", "Z");
    can_delete_sent_messages_fieldID = jni::get_field_id(env, Class, "canDeleteSentMessages", "Z");
    can_delete_all_messages_fieldID = jni::get_field_id(env, Class, "canDeleteAllMessages", "Z");
    can_edit_name_fieldID = jni::get_field_id(env, Class, "canEditName", "Z");
    can_edit_bio_fieldID = jni::get_field_id(env, Class, "canEditBio", "Z");
    can_edit_profile_photo_fieldID = jni::get_field_id(env, Class, "canEditProfilePhoto", "Z");
    can_edit_username_fieldID = jni::get_field_id(env, Class, "canEditUsername", "Z");
    can_view_gifts_and_stars_fieldID = jni::get_field_id(env, Class, "canViewGiftsAndStars", "Z");
    can_sell_gifts_fieldID = jni::get_field_id(env, Class, "canSellGifts", "Z");
    can_change_gift_settings_fieldID = jni::get_field_id(env, Class, "canChangeGiftSettings", "Z");
    can_transfer_and_upgrade_gifts_fieldID = jni::get_field_id(env, Class, "canTransferAndUpgradeGifts", "Z");
    can_transfer_stars_fieldID = jni::get_field_id(env, Class, "canTransferStars", "Z");
    can_manage_stories_fieldID = jni::get_field_id(env, Class, "canManageStories", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass businessChatLink::Class;
jfieldID businessChatLink::link_fieldID;
jfieldID businessChatLink::text_fieldID;
jfieldID businessChatLink::title_fieldID;
jfieldID businessChatLink::view_count_fieldID;

businessChatLink::businessChatLink()
  : link_()
  , text_()
  , title_()
  , view_count_()
{}

businessChatLink::businessChatLink(string const &link_, object_ptr<formattedText> &&text_, string const &title_, int32 view_count_)
  : link_(link_)
  , text_(std::move(text_))
  , title_(title_)
  , view_count_(view_count_)
{}

const std::int32_t businessChatLink::ID;

object_ptr<businessChatLink> businessChatLink::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessChatLink> res = make_object<businessChatLink>();
  res->link_ = jni::fetch_string(env, p, res->link_fieldID);
  res->text_ = jni::fetch_tl_object<formattedText>(env, jni::fetch_object(env, p, res->text_fieldID));
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->view_count_ = env->GetIntField(p, res->view_count_fieldID);
  return res;
}

void businessChatLink::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, link_); if (nextString) { env->SetObjectField(s, link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (text_ != nullptr) { jobject next; text_->store(env, next); if (next) { env->SetObjectField(s, text_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, view_count_fieldID, view_count_);
}

void businessChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessChatLink");
    s.store_field("link", link_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("title", title_);
    s.store_field("viewCount", view_count_);
    s.store_class_end();
  }
}

void businessChatLink::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessChatLink").c_str());
    link_fieldID = jni::get_field_id(env, Class, "link", "Ljava/lang/String;");
    text_fieldID = jni::get_field_id(env, Class, "text", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FormattedText;").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    view_count_fieldID = jni::get_field_id(env, Class, "viewCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass businessChatLinkInfo::Class;
jfieldID businessChatLinkInfo::chat_id_fieldID;
jfieldID businessChatLinkInfo::text_fieldID;

businessChatLinkInfo::businessChatLinkInfo()
  : chat_id_()
  , text_()
{}

businessChatLinkInfo::businessChatLinkInfo(int53 chat_id_, object_ptr<formattedText> &&text_)
  : chat_id_(chat_id_)
  , text_(std::move(text_))
{}

const std::int32_t businessChatLinkInfo::ID;

object_ptr<businessChatLinkInfo> businessChatLinkInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessChatLinkInfo> res = make_object<businessChatLinkInfo>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  res->text_ = jni::fetch_tl_object<formattedText>(env, jni::fetch_object(env, p, res->text_fieldID));
  return res;
}

void businessChatLinkInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, chat_id_fieldID, chat_id_);
  if (text_ != nullptr) { jobject next; text_->store(env, next); if (next) { env->SetObjectField(s, text_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessChatLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessChatLinkInfo");
    s.store_field("chatId", chat_id_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

void businessChatLinkInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessChatLinkInfo").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    text_fieldID = jni::get_field_id(env, Class, "text", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FormattedText;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessChatLinks::Class;
jfieldID businessChatLinks::links_fieldID;

businessChatLinks::businessChatLinks()
  : links_()
{}

businessChatLinks::businessChatLinks(array<object_ptr<businessChatLink>> &&links_)
  : links_(std::move(links_))
{}

const std::int32_t businessChatLinks::ID;

object_ptr<businessChatLinks> businessChatLinks::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessChatLinks> res = make_object<businessChatLinks>();
  res->links_ = jni::FetchVector<businessChatLink>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->links_fieldID));
  return res;
}

void businessChatLinks::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, links_); if (arr_tmp_) { env->SetObjectField(s, links_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void businessChatLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessChatLinks");
    { s.store_vector_begin("links", links_.size()); for (const auto &_value : links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void businessChatLinks::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessChatLinks").c_str());
    links_fieldID = jni::get_field_id(env, Class, "links", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BusinessChatLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessConnectedBot::Class;
jfieldID businessConnectedBot::bot_user_id_fieldID;
jfieldID businessConnectedBot::recipients_fieldID;
jfieldID businessConnectedBot::rights_fieldID;

businessConnectedBot::businessConnectedBot()
  : bot_user_id_()
  , recipients_()
  , rights_()
{}

businessConnectedBot::businessConnectedBot(int53 bot_user_id_, object_ptr<businessRecipients> &&recipients_, object_ptr<businessBotRights> &&rights_)
  : bot_user_id_(bot_user_id_)
  , recipients_(std::move(recipients_))
  , rights_(std::move(rights_))
{}

const std::int32_t businessConnectedBot::ID;

object_ptr<businessConnectedBot> businessConnectedBot::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessConnectedBot> res = make_object<businessConnectedBot>();
  res->bot_user_id_ = env->GetLongField(p, res->bot_user_id_fieldID);
  res->recipients_ = jni::fetch_tl_object<businessRecipients>(env, jni::fetch_object(env, p, res->recipients_fieldID));
  res->rights_ = jni::fetch_tl_object<businessBotRights>(env, jni::fetch_object(env, p, res->rights_fieldID));
  return res;
}

void businessConnectedBot::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, bot_user_id_fieldID, bot_user_id_);
  if (recipients_ != nullptr) { jobject next; recipients_->store(env, next); if (next) { env->SetObjectField(s, recipients_fieldID, next); env->DeleteLocalRef(next); } }
  if (rights_ != nullptr) { jobject next; rights_->store(env, next); if (next) { env->SetObjectField(s, rights_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessConnectedBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessConnectedBot");
    s.store_field("botUserId", bot_user_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get()));
    s.store_class_end();
  }
}

void businessConnectedBot::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessConnectedBot").c_str());
    bot_user_id_fieldID = jni::get_field_id(env, Class, "botUserId", "J");
    recipients_fieldID = jni::get_field_id(env, Class, "recipients", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessRecipients;").c_str());
    rights_fieldID = jni::get_field_id(env, Class, "rights", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessBotRights;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessConnection::Class;
jfieldID businessConnection::id_fieldID;
jfieldID businessConnection::user_id_fieldID;
jfieldID businessConnection::user_chat_id_fieldID;
jfieldID businessConnection::date_fieldID;
jfieldID businessConnection::rights_fieldID;
jfieldID businessConnection::is_enabled_fieldID;

businessConnection::businessConnection()
  : id_()
  , user_id_()
  , user_chat_id_()
  , date_()
  , rights_()
  , is_enabled_()
{}

businessConnection::businessConnection(string const &id_, int53 user_id_, int53 user_chat_id_, int32 date_, object_ptr<businessBotRights> &&rights_, bool is_enabled_)
  : id_(id_)
  , user_id_(user_id_)
  , user_chat_id_(user_chat_id_)
  , date_(date_)
  , rights_(std::move(rights_))
  , is_enabled_(is_enabled_)
{}

const std::int32_t businessConnection::ID;

object_ptr<businessConnection> businessConnection::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessConnection> res = make_object<businessConnection>();
  res->id_ = jni::fetch_string(env, p, res->id_fieldID);
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->user_chat_id_ = env->GetLongField(p, res->user_chat_id_fieldID);
  res->date_ = env->GetIntField(p, res->date_fieldID);
  res->rights_ = jni::fetch_tl_object<businessBotRights>(env, jni::fetch_object(env, p, res->rights_fieldID));
  res->is_enabled_ = (env->GetBooleanField(p, res->is_enabled_fieldID) != 0);
  return res;
}

void businessConnection::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, id_); if (nextString) { env->SetObjectField(s, id_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetLongField(s, user_id_fieldID, user_id_);
  env->SetLongField(s, user_chat_id_fieldID, user_chat_id_);
  env->SetIntField(s, date_fieldID, date_);
  if (rights_ != nullptr) { jobject next; rights_->store(env, next); if (next) { env->SetObjectField(s, rights_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, is_enabled_fieldID, is_enabled_);
}

void businessConnection::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessConnection");
    s.store_field("id", id_);
    s.store_field("userId", user_id_);
    s.store_field("userChatId", user_chat_id_);
    s.store_field("date", date_);
    s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get()));
    s.store_field("isEnabled", is_enabled_);
    s.store_class_end();
  }
}

void businessConnection::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessConnection").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "Ljava/lang/String;");
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    user_chat_id_fieldID = jni::get_field_id(env, Class, "userChatId", "J");
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    rights_fieldID = jni::get_field_id(env, Class, "rights", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessBotRights;").c_str());
    is_enabled_fieldID = jni::get_field_id(env, Class, "isEnabled", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass BusinessFeature::Class;

object_ptr<BusinessFeature> BusinessFeature::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case businessFeatureLocation::ID:
      return businessFeatureLocation::fetch(env, p);
    case businessFeatureOpeningHours::ID:
      return businessFeatureOpeningHours::fetch(env, p);
    case businessFeatureQuickReplies::ID:
      return businessFeatureQuickReplies::fetch(env, p);
    case businessFeatureGreetingMessage::ID:
      return businessFeatureGreetingMessage::fetch(env, p);
    case businessFeatureAwayMessage::ID:
      return businessFeatureAwayMessage::fetch(env, p);
    case businessFeatureAccountLinks::ID:
      return businessFeatureAccountLinks::fetch(env, p);
    case businessFeatureStartPage::ID:
      return businessFeatureStartPage::fetch(env, p);
    case businessFeatureBots::ID:
      return businessFeatureBots::fetch(env, p);
    case businessFeatureEmojiStatus::ID:
      return businessFeatureEmojiStatus::fetch(env, p);
    case businessFeatureChatFolderTags::ID:
      return businessFeatureChatFolderTags::fetch(env, p);
    case businessFeatureUpgradedStories::ID:
      return businessFeatureUpgradedStories::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void BusinessFeature::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeature").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureLocation::Class;

businessFeatureLocation::businessFeatureLocation() {
}

const std::int32_t businessFeatureLocation::ID;

object_ptr<BusinessFeature> businessFeatureLocation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureLocation>();
}

void businessFeatureLocation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureLocation");
    s.store_class_end();
  }
}

void businessFeatureLocation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureLocation").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureOpeningHours::Class;

businessFeatureOpeningHours::businessFeatureOpeningHours() {
}

const std::int32_t businessFeatureOpeningHours::ID;

object_ptr<BusinessFeature> businessFeatureOpeningHours::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureOpeningHours>();
}

void businessFeatureOpeningHours::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureOpeningHours");
    s.store_class_end();
  }
}

void businessFeatureOpeningHours::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureOpeningHours").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureQuickReplies::Class;

businessFeatureQuickReplies::businessFeatureQuickReplies() {
}

const std::int32_t businessFeatureQuickReplies::ID;

object_ptr<BusinessFeature> businessFeatureQuickReplies::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureQuickReplies>();
}

void businessFeatureQuickReplies::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureQuickReplies::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureQuickReplies");
    s.store_class_end();
  }
}

void businessFeatureQuickReplies::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureQuickReplies").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureGreetingMessage::Class;

businessFeatureGreetingMessage::businessFeatureGreetingMessage() {
}

const std::int32_t businessFeatureGreetingMessage::ID;

object_ptr<BusinessFeature> businessFeatureGreetingMessage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureGreetingMessage>();
}

void businessFeatureGreetingMessage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureGreetingMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureGreetingMessage");
    s.store_class_end();
  }
}

void businessFeatureGreetingMessage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureGreetingMessage").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureAwayMessage::Class;

businessFeatureAwayMessage::businessFeatureAwayMessage() {
}

const std::int32_t businessFeatureAwayMessage::ID;

object_ptr<BusinessFeature> businessFeatureAwayMessage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureAwayMessage>();
}

void businessFeatureAwayMessage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureAwayMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureAwayMessage");
    s.store_class_end();
  }
}

void businessFeatureAwayMessage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureAwayMessage").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureAccountLinks::Class;

businessFeatureAccountLinks::businessFeatureAccountLinks() {
}

const std::int32_t businessFeatureAccountLinks::ID;

object_ptr<BusinessFeature> businessFeatureAccountLinks::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureAccountLinks>();
}

void businessFeatureAccountLinks::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureAccountLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureAccountLinks");
    s.store_class_end();
  }
}

void businessFeatureAccountLinks::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureAccountLinks").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureStartPage::Class;

businessFeatureStartPage::businessFeatureStartPage() {
}

const std::int32_t businessFeatureStartPage::ID;

object_ptr<BusinessFeature> businessFeatureStartPage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureStartPage>();
}

void businessFeatureStartPage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureStartPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureStartPage");
    s.store_class_end();
  }
}

void businessFeatureStartPage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureStartPage").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureBots::Class;

businessFeatureBots::businessFeatureBots() {
}

const std::int32_t businessFeatureBots::ID;

object_ptr<BusinessFeature> businessFeatureBots::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureBots>();
}

void businessFeatureBots::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureBots");
    s.store_class_end();
  }
}

void businessFeatureBots::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureBots").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureEmojiStatus::Class;

businessFeatureEmojiStatus::businessFeatureEmojiStatus() {
}

const std::int32_t businessFeatureEmojiStatus::ID;

object_ptr<BusinessFeature> businessFeatureEmojiStatus::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureEmojiStatus>();
}

void businessFeatureEmojiStatus::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureEmojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureEmojiStatus");
    s.store_class_end();
  }
}

void businessFeatureEmojiStatus::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureEmojiStatus").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureChatFolderTags::Class;

businessFeatureChatFolderTags::businessFeatureChatFolderTags() {
}

const std::int32_t businessFeatureChatFolderTags::ID;

object_ptr<BusinessFeature> businessFeatureChatFolderTags::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureChatFolderTags>();
}

void businessFeatureChatFolderTags::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureChatFolderTags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureChatFolderTags");
    s.store_class_end();
  }
}

void businessFeatureChatFolderTags::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureChatFolderTags").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatureUpgradedStories::Class;

businessFeatureUpgradedStories::businessFeatureUpgradedStories() {
}

const std::int32_t businessFeatureUpgradedStories::ID;

object_ptr<BusinessFeature> businessFeatureUpgradedStories::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<businessFeatureUpgradedStories>();
}

void businessFeatureUpgradedStories::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void businessFeatureUpgradedStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatureUpgradedStories");
    s.store_class_end();
  }
}

void businessFeatureUpgradedStories::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatureUpgradedStories").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeaturePromotionAnimation::Class;
jfieldID businessFeaturePromotionAnimation::feature_fieldID;
jfieldID businessFeaturePromotionAnimation::animation_fieldID;

businessFeaturePromotionAnimation::businessFeaturePromotionAnimation()
  : feature_()
  , animation_()
{}

businessFeaturePromotionAnimation::businessFeaturePromotionAnimation(object_ptr<BusinessFeature> &&feature_, object_ptr<animation> &&animation_)
  : feature_(std::move(feature_))
  , animation_(std::move(animation_))
{}

const std::int32_t businessFeaturePromotionAnimation::ID;

object_ptr<businessFeaturePromotionAnimation> businessFeaturePromotionAnimation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessFeaturePromotionAnimation> res = make_object<businessFeaturePromotionAnimation>();
  res->feature_ = jni::fetch_tl_object<BusinessFeature>(env, jni::fetch_object(env, p, res->feature_fieldID));
  res->animation_ = jni::fetch_tl_object<animation>(env, jni::fetch_object(env, p, res->animation_fieldID));
  return res;
}

void businessFeaturePromotionAnimation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (feature_ != nullptr) { jobject next; feature_->store(env, next); if (next) { env->SetObjectField(s, feature_fieldID, next); env->DeleteLocalRef(next); } }
  if (animation_ != nullptr) { jobject next; animation_->store(env, next); if (next) { env->SetObjectField(s, animation_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessFeaturePromotionAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeaturePromotionAnimation");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

void businessFeaturePromotionAnimation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeaturePromotionAnimation").c_str());
    feature_fieldID = jni::get_field_id(env, Class, "feature", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessFeature;").c_str());
    animation_fieldID = jni::get_field_id(env, Class, "animation", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Animation;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessFeatures::Class;
jfieldID businessFeatures::features_fieldID;

businessFeatures::businessFeatures()
  : features_()
{}

businessFeatures::businessFeatures(array<object_ptr<BusinessFeature>> &&features_)
  : features_(std::move(features_))
{}

const std::int32_t businessFeatures::ID;

object_ptr<businessFeatures> businessFeatures::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessFeatures> res = make_object<businessFeatures>();
  res->features_ = jni::FetchVector<BusinessFeature>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->features_fieldID));
  return res;
}

void businessFeatures::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, features_); if (arr_tmp_) { env->SetObjectField(s, features_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void businessFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessFeatures");
    { s.store_vector_begin("features", features_.size()); for (const auto &_value : features_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void businessFeatures::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessFeatures").c_str());
    features_fieldID = jni::get_field_id(env, Class, "features", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BusinessFeature;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessGreetingMessageSettings::Class;
jfieldID businessGreetingMessageSettings::shortcut_id_fieldID;
jfieldID businessGreetingMessageSettings::recipients_fieldID;
jfieldID businessGreetingMessageSettings::inactivity_days_fieldID;

businessGreetingMessageSettings::businessGreetingMessageSettings()
  : shortcut_id_()
  , recipients_()
  , inactivity_days_()
{}

businessGreetingMessageSettings::businessGreetingMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, int32 inactivity_days_)
  : shortcut_id_(shortcut_id_)
  , recipients_(std::move(recipients_))
  , inactivity_days_(inactivity_days_)
{}

const std::int32_t businessGreetingMessageSettings::ID;

object_ptr<businessGreetingMessageSettings> businessGreetingMessageSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessGreetingMessageSettings> res = make_object<businessGreetingMessageSettings>();
  res->shortcut_id_ = env->GetIntField(p, res->shortcut_id_fieldID);
  res->recipients_ = jni::fetch_tl_object<businessRecipients>(env, jni::fetch_object(env, p, res->recipients_fieldID));
  res->inactivity_days_ = env->GetIntField(p, res->inactivity_days_fieldID);
  return res;
}

void businessGreetingMessageSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, shortcut_id_fieldID, shortcut_id_);
  if (recipients_ != nullptr) { jobject next; recipients_->store(env, next); if (next) { env->SetObjectField(s, recipients_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, inactivity_days_fieldID, inactivity_days_);
}

void businessGreetingMessageSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessGreetingMessageSettings");
    s.store_field("shortcutId", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_field("inactivityDays", inactivity_days_);
    s.store_class_end();
  }
}

void businessGreetingMessageSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessGreetingMessageSettings").c_str());
    shortcut_id_fieldID = jni::get_field_id(env, Class, "shortcutId", "I");
    recipients_fieldID = jni::get_field_id(env, Class, "recipients", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessRecipients;").c_str());
    inactivity_days_fieldID = jni::get_field_id(env, Class, "inactivityDays", "I");
    return true;
  }();
  (void)is_inited;
}

jclass businessInfo::Class;
jfieldID businessInfo::location_fieldID;
jfieldID businessInfo::opening_hours_fieldID;
jfieldID businessInfo::local_opening_hours_fieldID;
jfieldID businessInfo::next_open_in_fieldID;
jfieldID businessInfo::next_close_in_fieldID;
jfieldID businessInfo::greeting_message_settings_fieldID;
jfieldID businessInfo::away_message_settings_fieldID;
jfieldID businessInfo::start_page_fieldID;

businessInfo::businessInfo()
  : location_()
  , opening_hours_()
  , local_opening_hours_()
  , next_open_in_()
  , next_close_in_()
  , greeting_message_settings_()
  , away_message_settings_()
  , start_page_()
{}

businessInfo::businessInfo(object_ptr<businessLocation> &&location_, object_ptr<businessOpeningHours> &&opening_hours_, object_ptr<businessOpeningHours> &&local_opening_hours_, int32 next_open_in_, int32 next_close_in_, object_ptr<businessGreetingMessageSettings> &&greeting_message_settings_, object_ptr<businessAwayMessageSettings> &&away_message_settings_, object_ptr<businessStartPage> &&start_page_)
  : location_(std::move(location_))
  , opening_hours_(std::move(opening_hours_))
  , local_opening_hours_(std::move(local_opening_hours_))
  , next_open_in_(next_open_in_)
  , next_close_in_(next_close_in_)
  , greeting_message_settings_(std::move(greeting_message_settings_))
  , away_message_settings_(std::move(away_message_settings_))
  , start_page_(std::move(start_page_))
{}

const std::int32_t businessInfo::ID;

object_ptr<businessInfo> businessInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessInfo> res = make_object<businessInfo>();
  res->location_ = jni::fetch_tl_object<businessLocation>(env, jni::fetch_object(env, p, res->location_fieldID));
  res->opening_hours_ = jni::fetch_tl_object<businessOpeningHours>(env, jni::fetch_object(env, p, res->opening_hours_fieldID));
  res->local_opening_hours_ = jni::fetch_tl_object<businessOpeningHours>(env, jni::fetch_object(env, p, res->local_opening_hours_fieldID));
  res->next_open_in_ = env->GetIntField(p, res->next_open_in_fieldID);
  res->next_close_in_ = env->GetIntField(p, res->next_close_in_fieldID);
  res->greeting_message_settings_ = jni::fetch_tl_object<businessGreetingMessageSettings>(env, jni::fetch_object(env, p, res->greeting_message_settings_fieldID));
  res->away_message_settings_ = jni::fetch_tl_object<businessAwayMessageSettings>(env, jni::fetch_object(env, p, res->away_message_settings_fieldID));
  res->start_page_ = jni::fetch_tl_object<businessStartPage>(env, jni::fetch_object(env, p, res->start_page_fieldID));
  return res;
}

void businessInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (location_ != nullptr) { jobject next; location_->store(env, next); if (next) { env->SetObjectField(s, location_fieldID, next); env->DeleteLocalRef(next); } }
  if (opening_hours_ != nullptr) { jobject next; opening_hours_->store(env, next); if (next) { env->SetObjectField(s, opening_hours_fieldID, next); env->DeleteLocalRef(next); } }
  if (local_opening_hours_ != nullptr) { jobject next; local_opening_hours_->store(env, next); if (next) { env->SetObjectField(s, local_opening_hours_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, next_open_in_fieldID, next_open_in_);
  env->SetIntField(s, next_close_in_fieldID, next_close_in_);
  if (greeting_message_settings_ != nullptr) { jobject next; greeting_message_settings_->store(env, next); if (next) { env->SetObjectField(s, greeting_message_settings_fieldID, next); env->DeleteLocalRef(next); } }
  if (away_message_settings_ != nullptr) { jobject next; away_message_settings_->store(env, next); if (next) { env->SetObjectField(s, away_message_settings_fieldID, next); env->DeleteLocalRef(next); } }
  if (start_page_ != nullptr) { jobject next; start_page_->store(env, next); if (next) { env->SetObjectField(s, start_page_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessInfo");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_object_field("openingHours", static_cast<const BaseObject *>(opening_hours_.get()));
    s.store_object_field("localOpeningHours", static_cast<const BaseObject *>(local_opening_hours_.get()));
    s.store_field("nextOpenIn", next_open_in_);
    s.store_field("nextCloseIn", next_close_in_);
    s.store_object_field("greetingMessageSettings", static_cast<const BaseObject *>(greeting_message_settings_.get()));
    s.store_object_field("awayMessageSettings", static_cast<const BaseObject *>(away_message_settings_.get()));
    s.store_object_field("startPage", static_cast<const BaseObject *>(start_page_.get()));
    s.store_class_end();
  }
}

void businessInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessInfo").c_str());
    location_fieldID = jni::get_field_id(env, Class, "location", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessLocation;").c_str());
    opening_hours_fieldID = jni::get_field_id(env, Class, "openingHours", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessOpeningHours;").c_str());
    local_opening_hours_fieldID = jni::get_field_id(env, Class, "localOpeningHours", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessOpeningHours;").c_str());
    next_open_in_fieldID = jni::get_field_id(env, Class, "nextOpenIn", "I");
    next_close_in_fieldID = jni::get_field_id(env, Class, "nextCloseIn", "I");
    greeting_message_settings_fieldID = jni::get_field_id(env, Class, "greetingMessageSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessGreetingMessageSettings;").c_str());
    away_message_settings_fieldID = jni::get_field_id(env, Class, "awayMessageSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessAwayMessageSettings;").c_str());
    start_page_fieldID = jni::get_field_id(env, Class, "startPage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessStartPage;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessLocation::Class;
jfieldID businessLocation::location_fieldID;
jfieldID businessLocation::address_fieldID;

businessLocation::businessLocation()
  : location_()
  , address_()
{}

businessLocation::businessLocation(object_ptr<location> &&location_, string const &address_)
  : location_(std::move(location_))
  , address_(address_)
{}

const std::int32_t businessLocation::ID;

object_ptr<businessLocation> businessLocation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessLocation> res = make_object<businessLocation>();
  res->location_ = jni::fetch_tl_object<location>(env, jni::fetch_object(env, p, res->location_fieldID));
  res->address_ = jni::fetch_string(env, p, res->address_fieldID);
  return res;
}

void businessLocation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (location_ != nullptr) { jobject next; location_->store(env, next); if (next) { env->SetObjectField(s, location_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, address_); if (nextString) { env->SetObjectField(s, address_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void businessLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("address", address_);
    s.store_class_end();
  }
}

void businessLocation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessLocation").c_str());
    location_fieldID = jni::get_field_id(env, Class, "location", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Location;").c_str());
    address_fieldID = jni::get_field_id(env, Class, "address", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass businessMessage::Class;
jfieldID businessMessage::message_fieldID;
jfieldID businessMessage::reply_to_message_fieldID;

businessMessage::businessMessage()
  : message_()
  , reply_to_message_()
{}

businessMessage::businessMessage(object_ptr<message> &&message_, object_ptr<message> &&reply_to_message_)
  : message_(std::move(message_))
  , reply_to_message_(std::move(reply_to_message_))
{}

const std::int32_t businessMessage::ID;

object_ptr<businessMessage> businessMessage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessMessage> res = make_object<businessMessage>();
  res->message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->message_fieldID));
  res->reply_to_message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->reply_to_message_fieldID));
  return res;
}

void businessMessage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (message_ != nullptr) { jobject next; message_->store(env, next); if (next) { env->SetObjectField(s, message_fieldID, next); env->DeleteLocalRef(next); } }
  if (reply_to_message_ != nullptr) { jobject next; reply_to_message_->store(env, next); if (next) { env->SetObjectField(s, reply_to_message_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_object_field("replyToMessage", static_cast<const BaseObject *>(reply_to_message_.get()));
    s.store_class_end();
  }
}

void businessMessage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessMessage").c_str());
    message_fieldID = jni::get_field_id(env, Class, "message", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    reply_to_message_fieldID = jni::get_field_id(env, Class, "replyToMessage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessMessages::Class;
jfieldID businessMessages::messages_fieldID;

businessMessages::businessMessages()
  : messages_()
{}

businessMessages::businessMessages(array<object_ptr<businessMessage>> &&messages_)
  : messages_(std::move(messages_))
{}

const std::int32_t businessMessages::ID;

object_ptr<businessMessages> businessMessages::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessMessages> res = make_object<businessMessages>();
  res->messages_ = jni::FetchVector<businessMessage>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->messages_fieldID));
  return res;
}

void businessMessages::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, messages_); if (arr_tmp_) { env->SetObjectField(s, messages_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void businessMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessMessages");
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void businessMessages::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessMessages").c_str());
    messages_fieldID = jni::get_field_id(env, Class, "messages", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BusinessMessage;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessOpeningHours::Class;
jfieldID businessOpeningHours::time_zone_id_fieldID;
jfieldID businessOpeningHours::opening_hours_fieldID;

businessOpeningHours::businessOpeningHours()
  : time_zone_id_()
  , opening_hours_()
{}

businessOpeningHours::businessOpeningHours(string const &time_zone_id_, array<object_ptr<businessOpeningHoursInterval>> &&opening_hours_)
  : time_zone_id_(time_zone_id_)
  , opening_hours_(std::move(opening_hours_))
{}

const std::int32_t businessOpeningHours::ID;

object_ptr<businessOpeningHours> businessOpeningHours::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessOpeningHours> res = make_object<businessOpeningHours>();
  res->time_zone_id_ = jni::fetch_string(env, p, res->time_zone_id_fieldID);
  res->opening_hours_ = jni::FetchVector<businessOpeningHoursInterval>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->opening_hours_fieldID));
  return res;
}

void businessOpeningHours::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, time_zone_id_); if (nextString) { env->SetObjectField(s, time_zone_id_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { auto arr_tmp_ = jni::store_vector(env, opening_hours_); if (arr_tmp_) { env->SetObjectField(s, opening_hours_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void businessOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessOpeningHours");
    s.store_field("timeZoneId", time_zone_id_);
    { s.store_vector_begin("openingHours", opening_hours_.size()); for (const auto &_value : opening_hours_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void businessOpeningHours::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessOpeningHours").c_str());
    time_zone_id_fieldID = jni::get_field_id(env, Class, "timeZoneId", "Ljava/lang/String;");
    opening_hours_fieldID = jni::get_field_id(env, Class, "openingHours", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$BusinessOpeningHoursInterval;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass businessOpeningHoursInterval::Class;
jfieldID businessOpeningHoursInterval::start_minute_fieldID;
jfieldID businessOpeningHoursInterval::end_minute_fieldID;

businessOpeningHoursInterval::businessOpeningHoursInterval()
  : start_minute_()
  , end_minute_()
{}

businessOpeningHoursInterval::businessOpeningHoursInterval(int32 start_minute_, int32 end_minute_)
  : start_minute_(start_minute_)
  , end_minute_(end_minute_)
{}

const std::int32_t businessOpeningHoursInterval::ID;

object_ptr<businessOpeningHoursInterval> businessOpeningHoursInterval::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessOpeningHoursInterval> res = make_object<businessOpeningHoursInterval>();
  res->start_minute_ = env->GetIntField(p, res->start_minute_fieldID);
  res->end_minute_ = env->GetIntField(p, res->end_minute_fieldID);
  return res;
}

void businessOpeningHoursInterval::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, start_minute_fieldID, start_minute_);
  env->SetIntField(s, end_minute_fieldID, end_minute_);
}

void businessOpeningHoursInterval::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessOpeningHoursInterval");
    s.store_field("startMinute", start_minute_);
    s.store_field("endMinute", end_minute_);
    s.store_class_end();
  }
}

void businessOpeningHoursInterval::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessOpeningHoursInterval").c_str());
    start_minute_fieldID = jni::get_field_id(env, Class, "startMinute", "I");
    end_minute_fieldID = jni::get_field_id(env, Class, "endMinute", "I");
    return true;
  }();
  (void)is_inited;
}

jclass businessRecipients::Class;
jfieldID businessRecipients::chat_ids_fieldID;
jfieldID businessRecipients::excluded_chat_ids_fieldID;
jfieldID businessRecipients::select_existing_chats_fieldID;
jfieldID businessRecipients::select_new_chats_fieldID;
jfieldID businessRecipients::select_contacts_fieldID;
jfieldID businessRecipients::select_non_contacts_fieldID;
jfieldID businessRecipients::exclude_selected_fieldID;

businessRecipients::businessRecipients()
  : chat_ids_()
  , excluded_chat_ids_()
  , select_existing_chats_()
  , select_new_chats_()
  , select_contacts_()
  , select_non_contacts_()
  , exclude_selected_()
{}

businessRecipients::businessRecipients(array<int53> &&chat_ids_, array<int53> &&excluded_chat_ids_, bool select_existing_chats_, bool select_new_chats_, bool select_contacts_, bool select_non_contacts_, bool exclude_selected_)
  : chat_ids_(std::move(chat_ids_))
  , excluded_chat_ids_(std::move(excluded_chat_ids_))
  , select_existing_chats_(select_existing_chats_)
  , select_new_chats_(select_new_chats_)
  , select_contacts_(select_contacts_)
  , select_non_contacts_(select_non_contacts_)
  , exclude_selected_(exclude_selected_)
{}

const std::int32_t businessRecipients::ID;

object_ptr<businessRecipients> businessRecipients::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessRecipients> res = make_object<businessRecipients>();
  res->chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->chat_ids_fieldID));
  res->excluded_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->excluded_chat_ids_fieldID));
  res->select_existing_chats_ = (env->GetBooleanField(p, res->select_existing_chats_fieldID) != 0);
  res->select_new_chats_ = (env->GetBooleanField(p, res->select_new_chats_fieldID) != 0);
  res->select_contacts_ = (env->GetBooleanField(p, res->select_contacts_fieldID) != 0);
  res->select_non_contacts_ = (env->GetBooleanField(p, res->select_non_contacts_fieldID) != 0);
  res->exclude_selected_ = (env->GetBooleanField(p, res->exclude_selected_fieldID) != 0);
  return res;
}

void businessRecipients::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, chat_ids_); if (arr_tmp_) { env->SetObjectField(s, chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, excluded_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, excluded_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetBooleanField(s, select_existing_chats_fieldID, select_existing_chats_);
  env->SetBooleanField(s, select_new_chats_fieldID, select_new_chats_);
  env->SetBooleanField(s, select_contacts_fieldID, select_contacts_);
  env->SetBooleanField(s, select_non_contacts_fieldID, select_non_contacts_);
  env->SetBooleanField(s, exclude_selected_fieldID, exclude_selected_);
}

void businessRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessRecipients");
    { s.store_vector_begin("chatIds", chat_ids_.size()); for (const auto &_value : chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("excludedChatIds", excluded_chat_ids_.size()); for (const auto &_value : excluded_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("selectExistingChats", select_existing_chats_);
    s.store_field("selectNewChats", select_new_chats_);
    s.store_field("selectContacts", select_contacts_);
    s.store_field("selectNonContacts", select_non_contacts_);
    s.store_field("excludeSelected", exclude_selected_);
    s.store_class_end();
  }
}

void businessRecipients::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessRecipients").c_str());
    chat_ids_fieldID = jni::get_field_id(env, Class, "chatIds", "[J");
    excluded_chat_ids_fieldID = jni::get_field_id(env, Class, "excludedChatIds", "[J");
    select_existing_chats_fieldID = jni::get_field_id(env, Class, "selectExistingChats", "Z");
    select_new_chats_fieldID = jni::get_field_id(env, Class, "selectNewChats", "Z");
    select_contacts_fieldID = jni::get_field_id(env, Class, "selectContacts", "Z");
    select_non_contacts_fieldID = jni::get_field_id(env, Class, "selectNonContacts", "Z");
    exclude_selected_fieldID = jni::get_field_id(env, Class, "excludeSelected", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass businessStartPage::Class;
jfieldID businessStartPage::title_fieldID;
jfieldID businessStartPage::message_fieldID;
jfieldID businessStartPage::sticker_fieldID;

businessStartPage::businessStartPage()
  : title_()
  , message_()
  , sticker_()
{}

businessStartPage::businessStartPage(string const &title_, string const &message_, object_ptr<sticker> &&sticker_)
  : title_(title_)
  , message_(message_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t businessStartPage::ID;

object_ptr<businessStartPage> businessStartPage::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<businessStartPage> res = make_object<businessStartPage>();
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->message_ = jni::fetch_string(env, p, res->message_fieldID);
  res->sticker_ = jni::fetch_tl_object<sticker>(env, jni::fetch_object(env, p, res->sticker_fieldID));
  return res;
}

void businessStartPage::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, message_); if (nextString) { env->SetObjectField(s, message_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (sticker_ != nullptr) { jobject next; sticker_->store(env, next); if (next) { env->SetObjectField(s, sticker_fieldID, next); env->DeleteLocalRef(next); } }
}

void businessStartPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "BusinessStartPage");
    s.store_field("title", title_);
    s.store_field("message", message_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

void businessStartPage::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$BusinessStartPage").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    message_fieldID = jni::get_field_id(env, Class, "message", "Ljava/lang/String;");
    sticker_fieldID = jni::get_field_id(env, Class, "sticker", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Sticker;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass call::Class;
jfieldID call::id_fieldID;
jfieldID call::user_id_fieldID;
jfieldID call::is_outgoing_fieldID;
jfieldID call::is_video_fieldID;
jfieldID call::state_fieldID;

call::call()
  : id_()
  , user_id_()
  , is_outgoing_()
  , is_video_()
  , state_()
{}

call::call(int32 id_, int53 user_id_, bool is_outgoing_, bool is_video_, object_ptr<CallState> &&state_)
  : id_(id_)
  , user_id_(user_id_)
  , is_outgoing_(is_outgoing_)
  , is_video_(is_video_)
  , state_(std::move(state_))
{}

const std::int32_t call::ID;

object_ptr<call> call::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<call> res = make_object<call>();
  res->id_ = env->GetIntField(p, res->id_fieldID);
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->is_outgoing_ = (env->GetBooleanField(p, res->is_outgoing_fieldID) != 0);
  res->is_video_ = (env->GetBooleanField(p, res->is_video_fieldID) != 0);
  res->state_ = jni::fetch_tl_object<CallState>(env, jni::fetch_object(env, p, res->state_fieldID));
  return res;
}

void call::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, id_fieldID, id_);
  env->SetLongField(s, user_id_fieldID, user_id_);
  env->SetBooleanField(s, is_outgoing_fieldID, is_outgoing_);
  env->SetBooleanField(s, is_video_fieldID, is_video_);
  if (state_ != nullptr) { jobject next; state_->store(env, next); if (next) { env->SetObjectField(s, state_fieldID, next); env->DeleteLocalRef(next); } }
}

void call::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Call");
    s.store_field("id", id_);
    s.store_field("userId", user_id_);
    s.store_field("isOutgoing", is_outgoing_);
    s.store_field("isVideo", is_video_);
    s.store_object_field("state", static_cast<const BaseObject *>(state_.get()));
    s.store_class_end();
  }
}

void call::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Call").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "I");
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    is_outgoing_fieldID = jni::get_field_id(env, Class, "isOutgoing", "Z");
    is_video_fieldID = jni::get_field_id(env, Class, "isVideo", "Z");
    state_fieldID = jni::get_field_id(env, Class, "state", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$CallState;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass CallDiscardReason::Class;

object_ptr<CallDiscardReason> CallDiscardReason::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case callDiscardReasonEmpty::ID:
      return callDiscardReasonEmpty::fetch(env, p);
    case callDiscardReasonMissed::ID:
      return callDiscardReasonMissed::fetch(env, p);
    case callDiscardReasonDeclined::ID:
      return callDiscardReasonDeclined::fetch(env, p);
    case callDiscardReasonDisconnected::ID:
      return callDiscardReasonDisconnected::fetch(env, p);
    case callDiscardReasonHungUp::ID:
      return callDiscardReasonHungUp::fetch(env, p);
    case callDiscardReasonUpgradeToGroupCall::ID:
      return callDiscardReasonUpgradeToGroupCall::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CallDiscardReason::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReason").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonEmpty::Class;

callDiscardReasonEmpty::callDiscardReasonEmpty() {
}

const std::int32_t callDiscardReasonEmpty::ID;

object_ptr<CallDiscardReason> callDiscardReasonEmpty::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callDiscardReasonEmpty>();
}

void callDiscardReasonEmpty::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callDiscardReasonEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonEmpty");
    s.store_class_end();
  }
}

void callDiscardReasonEmpty::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonEmpty").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonMissed::Class;

callDiscardReasonMissed::callDiscardReasonMissed() {
}

const std::int32_t callDiscardReasonMissed::ID;

object_ptr<CallDiscardReason> callDiscardReasonMissed::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callDiscardReasonMissed>();
}

void callDiscardReasonMissed::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callDiscardReasonMissed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonMissed");
    s.store_class_end();
  }
}

void callDiscardReasonMissed::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonMissed").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonDeclined::Class;

callDiscardReasonDeclined::callDiscardReasonDeclined() {
}

const std::int32_t callDiscardReasonDeclined::ID;

object_ptr<CallDiscardReason> callDiscardReasonDeclined::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callDiscardReasonDeclined>();
}

void callDiscardReasonDeclined::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callDiscardReasonDeclined::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonDeclined");
    s.store_class_end();
  }
}

void callDiscardReasonDeclined::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonDeclined").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonDisconnected::Class;

callDiscardReasonDisconnected::callDiscardReasonDisconnected() {
}

const std::int32_t callDiscardReasonDisconnected::ID;

object_ptr<CallDiscardReason> callDiscardReasonDisconnected::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callDiscardReasonDisconnected>();
}

void callDiscardReasonDisconnected::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callDiscardReasonDisconnected::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonDisconnected");
    s.store_class_end();
  }
}

void callDiscardReasonDisconnected::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonDisconnected").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonHungUp::Class;

callDiscardReasonHungUp::callDiscardReasonHungUp() {
}

const std::int32_t callDiscardReasonHungUp::ID;

object_ptr<CallDiscardReason> callDiscardReasonHungUp::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callDiscardReasonHungUp>();
}

void callDiscardReasonHungUp::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callDiscardReasonHungUp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonHungUp");
    s.store_class_end();
  }
}

void callDiscardReasonHungUp::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonHungUp").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callDiscardReasonUpgradeToGroupCall::Class;
jfieldID callDiscardReasonUpgradeToGroupCall::invite_link_fieldID;

callDiscardReasonUpgradeToGroupCall::callDiscardReasonUpgradeToGroupCall()
  : invite_link_()
{}

callDiscardReasonUpgradeToGroupCall::callDiscardReasonUpgradeToGroupCall(string const &invite_link_)
  : invite_link_(invite_link_)
{}

const std::int32_t callDiscardReasonUpgradeToGroupCall::ID;

object_ptr<CallDiscardReason> callDiscardReasonUpgradeToGroupCall::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callDiscardReasonUpgradeToGroupCall> res = make_object<callDiscardReasonUpgradeToGroupCall>();
  res->invite_link_ = jni::fetch_string(env, p, res->invite_link_fieldID);
  return std::move(res);
}

void callDiscardReasonUpgradeToGroupCall::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, invite_link_); if (nextString) { env->SetObjectField(s, invite_link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void callDiscardReasonUpgradeToGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallDiscardReasonUpgradeToGroupCall");
    s.store_field("inviteLink", invite_link_);
    s.store_class_end();
  }
}

void callDiscardReasonUpgradeToGroupCall::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallDiscardReasonUpgradeToGroupCall").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass callId::Class;
jfieldID callId::id_fieldID;

callId::callId()
  : id_()
{}

callId::callId(int32 id_)
  : id_(id_)
{}

const std::int32_t callId::ID;

object_ptr<callId> callId::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callId> res = make_object<callId>();
  res->id_ = env->GetIntField(p, res->id_fieldID);
  return res;
}

void callId::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, id_fieldID, id_);
}

void callId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallId");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

void callId::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallId").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "I");
    return true;
  }();
  (void)is_inited;
}

jclass CallProblem::Class;

object_ptr<CallProblem> CallProblem::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case callProblemEcho::ID:
      return callProblemEcho::fetch(env, p);
    case callProblemNoise::ID:
      return callProblemNoise::fetch(env, p);
    case callProblemInterruptions::ID:
      return callProblemInterruptions::fetch(env, p);
    case callProblemDistortedSpeech::ID:
      return callProblemDistortedSpeech::fetch(env, p);
    case callProblemSilentLocal::ID:
      return callProblemSilentLocal::fetch(env, p);
    case callProblemSilentRemote::ID:
      return callProblemSilentRemote::fetch(env, p);
    case callProblemDropped::ID:
      return callProblemDropped::fetch(env, p);
    case callProblemDistortedVideo::ID:
      return callProblemDistortedVideo::fetch(env, p);
    case callProblemPixelatedVideo::ID:
      return callProblemPixelatedVideo::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CallProblem::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblem").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemEcho::Class;

callProblemEcho::callProblemEcho() {
}

const std::int32_t callProblemEcho::ID;

object_ptr<CallProblem> callProblemEcho::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemEcho>();
}

void callProblemEcho::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemEcho");
    s.store_class_end();
  }
}

void callProblemEcho::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemEcho").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemNoise::Class;

callProblemNoise::callProblemNoise() {
}

const std::int32_t callProblemNoise::ID;

object_ptr<CallProblem> callProblemNoise::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemNoise>();
}

void callProblemNoise::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemNoise");
    s.store_class_end();
  }
}

void callProblemNoise::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemNoise").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemInterruptions::Class;

callProblemInterruptions::callProblemInterruptions() {
}

const std::int32_t callProblemInterruptions::ID;

object_ptr<CallProblem> callProblemInterruptions::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemInterruptions>();
}

void callProblemInterruptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemInterruptions");
    s.store_class_end();
  }
}

void callProblemInterruptions::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemInterruptions").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemDistortedSpeech::Class;

callProblemDistortedSpeech::callProblemDistortedSpeech() {
}

const std::int32_t callProblemDistortedSpeech::ID;

object_ptr<CallProblem> callProblemDistortedSpeech::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemDistortedSpeech>();
}

void callProblemDistortedSpeech::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemDistortedSpeech");
    s.store_class_end();
  }
}

void callProblemDistortedSpeech::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemDistortedSpeech").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemSilentLocal::Class;

callProblemSilentLocal::callProblemSilentLocal() {
}

const std::int32_t callProblemSilentLocal::ID;

object_ptr<CallProblem> callProblemSilentLocal::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemSilentLocal>();
}

void callProblemSilentLocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemSilentLocal");
    s.store_class_end();
  }
}

void callProblemSilentLocal::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemSilentLocal").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemSilentRemote::Class;

callProblemSilentRemote::callProblemSilentRemote() {
}

const std::int32_t callProblemSilentRemote::ID;

object_ptr<CallProblem> callProblemSilentRemote::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemSilentRemote>();
}

void callProblemSilentRemote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemSilentRemote");
    s.store_class_end();
  }
}

void callProblemSilentRemote::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemSilentRemote").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemDropped::Class;

callProblemDropped::callProblemDropped() {
}

const std::int32_t callProblemDropped::ID;

object_ptr<CallProblem> callProblemDropped::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemDropped>();
}

void callProblemDropped::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemDropped");
    s.store_class_end();
  }
}

void callProblemDropped::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemDropped").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemDistortedVideo::Class;

callProblemDistortedVideo::callProblemDistortedVideo() {
}

const std::int32_t callProblemDistortedVideo::ID;

object_ptr<CallProblem> callProblemDistortedVideo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemDistortedVideo>();
}

void callProblemDistortedVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemDistortedVideo");
    s.store_class_end();
  }
}

void callProblemDistortedVideo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemDistortedVideo").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProblemPixelatedVideo::Class;

callProblemPixelatedVideo::callProblemPixelatedVideo() {
}

const std::int32_t callProblemPixelatedVideo::ID;

object_ptr<CallProblem> callProblemPixelatedVideo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callProblemPixelatedVideo>();
}

void callProblemPixelatedVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProblemPixelatedVideo");
    s.store_class_end();
  }
}

void callProblemPixelatedVideo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProblemPixelatedVideo").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callProtocol::Class;
jfieldID callProtocol::udp_p2p_fieldID;
jfieldID callProtocol::udp_reflector_fieldID;
jfieldID callProtocol::min_layer_fieldID;
jfieldID callProtocol::max_layer_fieldID;
jfieldID callProtocol::library_versions_fieldID;

callProtocol::callProtocol()
  : udp_p2p_()
  , udp_reflector_()
  , min_layer_()
  , max_layer_()
  , library_versions_()
{}

callProtocol::callProtocol(bool udp_p2p_, bool udp_reflector_, int32 min_layer_, int32 max_layer_, array<string> &&library_versions_)
  : udp_p2p_(udp_p2p_)
  , udp_reflector_(udp_reflector_)
  , min_layer_(min_layer_)
  , max_layer_(max_layer_)
  , library_versions_(std::move(library_versions_))
{}

const std::int32_t callProtocol::ID;

object_ptr<callProtocol> callProtocol::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callProtocol> res = make_object<callProtocol>();
  res->udp_p2p_ = (env->GetBooleanField(p, res->udp_p2p_fieldID) != 0);
  res->udp_reflector_ = (env->GetBooleanField(p, res->udp_reflector_fieldID) != 0);
  res->min_layer_ = env->GetIntField(p, res->min_layer_fieldID);
  res->max_layer_ = env->GetIntField(p, res->max_layer_fieldID);
  res->library_versions_ = jni::FetchVector<string>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->library_versions_fieldID));
  return res;
}

void callProtocol::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, udp_p2p_fieldID, udp_p2p_);
  env->SetBooleanField(s, udp_reflector_fieldID, udp_reflector_);
  env->SetIntField(s, min_layer_fieldID, min_layer_);
  env->SetIntField(s, max_layer_fieldID, max_layer_);
  { auto arr_tmp_ = jni::store_vector(env, library_versions_); if (arr_tmp_) { env->SetObjectField(s, library_versions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void callProtocol::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallProtocol");
    s.store_field("udpP2p", udp_p2p_);
    s.store_field("udpReflector", udp_reflector_);
    s.store_field("minLayer", min_layer_);
    s.store_field("maxLayer", max_layer_);
    { s.store_vector_begin("libraryVersions", library_versions_.size()); for (const auto &_value : library_versions_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void callProtocol::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallProtocol").c_str());
    udp_p2p_fieldID = jni::get_field_id(env, Class, "udpP2p", "Z");
    udp_reflector_fieldID = jni::get_field_id(env, Class, "udpReflector", "Z");
    min_layer_fieldID = jni::get_field_id(env, Class, "minLayer", "I");
    max_layer_fieldID = jni::get_field_id(env, Class, "maxLayer", "I");
    library_versions_fieldID = jni::get_field_id(env, Class, "libraryVersions", "[Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass callServer::Class;
jfieldID callServer::id_fieldID;
jfieldID callServer::ip_address_fieldID;
jfieldID callServer::ipv6_address_fieldID;
jfieldID callServer::port_fieldID;
jfieldID callServer::type_fieldID;

callServer::callServer()
  : id_()
  , ip_address_()
  , ipv6_address_()
  , port_()
  , type_()
{}

callServer::callServer(int64 id_, string const &ip_address_, string const &ipv6_address_, int32 port_, object_ptr<CallServerType> &&type_)
  : id_(id_)
  , ip_address_(ip_address_)
  , ipv6_address_(ipv6_address_)
  , port_(port_)
  , type_(std::move(type_))
{}

const std::int32_t callServer::ID;

object_ptr<callServer> callServer::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callServer> res = make_object<callServer>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->ip_address_ = jni::fetch_string(env, p, res->ip_address_fieldID);
  res->ipv6_address_ = jni::fetch_string(env, p, res->ipv6_address_fieldID);
  res->port_ = env->GetIntField(p, res->port_fieldID);
  res->type_ = jni::fetch_tl_object<CallServerType>(env, jni::fetch_object(env, p, res->type_fieldID));
  return res;
}

void callServer::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  { jstring nextString = jni::to_jstring(env, ip_address_); if (nextString) { env->SetObjectField(s, ip_address_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, ipv6_address_); if (nextString) { env->SetObjectField(s, ipv6_address_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, port_fieldID, port_);
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
}

void callServer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallServer");
    s.store_field("id", id_);
    s.store_field("ipAddress", ip_address_);
    s.store_field("ipv6Address", ipv6_address_);
    s.store_field("port", port_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

void callServer::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallServer").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    ip_address_fieldID = jni::get_field_id(env, Class, "ipAddress", "Ljava/lang/String;");
    ipv6_address_fieldID = jni::get_field_id(env, Class, "ipv6Address", "Ljava/lang/String;");
    port_fieldID = jni::get_field_id(env, Class, "port", "I");
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$CallServerType;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass CallServerType::Class;

object_ptr<CallServerType> CallServerType::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case callServerTypeTelegramReflector::ID:
      return callServerTypeTelegramReflector::fetch(env, p);
    case callServerTypeWebrtc::ID:
      return callServerTypeWebrtc::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CallServerType::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallServerType").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callServerTypeTelegramReflector::Class;
jfieldID callServerTypeTelegramReflector::peer_tag_fieldID;
jfieldID callServerTypeTelegramReflector::is_tcp_fieldID;

callServerTypeTelegramReflector::callServerTypeTelegramReflector()
  : peer_tag_()
  , is_tcp_()
{}

callServerTypeTelegramReflector::callServerTypeTelegramReflector(bytes const &peer_tag_, bool is_tcp_)
  : peer_tag_(std::move(peer_tag_))
  , is_tcp_(is_tcp_)
{}

const std::int32_t callServerTypeTelegramReflector::ID;

object_ptr<CallServerType> callServerTypeTelegramReflector::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callServerTypeTelegramReflector> res = make_object<callServerTypeTelegramReflector>();
  res->peer_tag_ = jni::from_bytes(env, (jbyteArray)jni::fetch_object(env, p, res->peer_tag_fieldID));
  res->is_tcp_ = (env->GetBooleanField(p, res->is_tcp_fieldID) != 0);
  return std::move(res);
}

void callServerTypeTelegramReflector::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jbyteArray nextBytes = jni::to_bytes(env, peer_tag_); if (nextBytes) { env->SetObjectField(s, peer_tag_fieldID, nextBytes); env->DeleteLocalRef(nextBytes); } }
  env->SetBooleanField(s, is_tcp_fieldID, is_tcp_);
}

void callServerTypeTelegramReflector::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallServerTypeTelegramReflector");
    s.store_bytes_field("peerTag", peer_tag_);
    s.store_field("isTcp", is_tcp_);
    s.store_class_end();
  }
}

void callServerTypeTelegramReflector::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallServerTypeTelegramReflector").c_str());
    peer_tag_fieldID = jni::get_field_id(env, Class, "peerTag", "[B");
    is_tcp_fieldID = jni::get_field_id(env, Class, "isTcp", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass callServerTypeWebrtc::Class;
jfieldID callServerTypeWebrtc::username_fieldID;
jfieldID callServerTypeWebrtc::password_fieldID;
jfieldID callServerTypeWebrtc::supports_turn_fieldID;
jfieldID callServerTypeWebrtc::supports_stun_fieldID;

callServerTypeWebrtc::callServerTypeWebrtc()
  : username_()
  , password_()
  , supports_turn_()
  , supports_stun_()
{}

callServerTypeWebrtc::callServerTypeWebrtc(string const &username_, string const &password_, bool supports_turn_, bool supports_stun_)
  : username_(username_)
  , password_(password_)
  , supports_turn_(supports_turn_)
  , supports_stun_(supports_stun_)
{}

const std::int32_t callServerTypeWebrtc::ID;

object_ptr<CallServerType> callServerTypeWebrtc::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callServerTypeWebrtc> res = make_object<callServerTypeWebrtc>();
  res->username_ = jni::fetch_string(env, p, res->username_fieldID);
  res->password_ = jni::fetch_string(env, p, res->password_fieldID);
  res->supports_turn_ = (env->GetBooleanField(p, res->supports_turn_fieldID) != 0);
  res->supports_stun_ = (env->GetBooleanField(p, res->supports_stun_fieldID) != 0);
  return std::move(res);
}

void callServerTypeWebrtc::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, username_); if (nextString) { env->SetObjectField(s, username_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, password_); if (nextString) { env->SetObjectField(s, password_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, supports_turn_fieldID, supports_turn_);
  env->SetBooleanField(s, supports_stun_fieldID, supports_stun_);
}

void callServerTypeWebrtc::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallServerTypeWebrtc");
    s.store_field("username", username_);
    s.store_field("password", password_);
    s.store_field("supportsTurn", supports_turn_);
    s.store_field("supportsStun", supports_stun_);
    s.store_class_end();
  }
}

void callServerTypeWebrtc::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallServerTypeWebrtc").c_str());
    username_fieldID = jni::get_field_id(env, Class, "username", "Ljava/lang/String;");
    password_fieldID = jni::get_field_id(env, Class, "password", "Ljava/lang/String;");
    supports_turn_fieldID = jni::get_field_id(env, Class, "supportsTurn", "Z");
    supports_stun_fieldID = jni::get_field_id(env, Class, "supportsStun", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass CallState::Class;

object_ptr<CallState> CallState::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case callStatePending::ID:
      return callStatePending::fetch(env, p);
    case callStateExchangingKeys::ID:
      return callStateExchangingKeys::fetch(env, p);
    case callStateReady::ID:
      return callStateReady::fetch(env, p);
    case callStateHangingUp::ID:
      return callStateHangingUp::fetch(env, p);
    case callStateDiscarded::ID:
      return callStateDiscarded::fetch(env, p);
    case callStateError::ID:
      return callStateError::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CallState::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallState").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callStatePending::Class;
jfieldID callStatePending::is_created_fieldID;
jfieldID callStatePending::is_received_fieldID;

callStatePending::callStatePending()
  : is_created_()
  , is_received_()
{}

callStatePending::callStatePending(bool is_created_, bool is_received_)
  : is_created_(is_created_)
  , is_received_(is_received_)
{}

const std::int32_t callStatePending::ID;

object_ptr<CallState> callStatePending::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callStatePending> res = make_object<callStatePending>();
  res->is_created_ = (env->GetBooleanField(p, res->is_created_fieldID) != 0);
  res->is_received_ = (env->GetBooleanField(p, res->is_received_fieldID) != 0);
  return std::move(res);
}

void callStatePending::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_created_fieldID, is_created_);
  env->SetBooleanField(s, is_received_fieldID, is_received_);
}

void callStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStatePending");
    s.store_field("isCreated", is_created_);
    s.store_field("isReceived", is_received_);
    s.store_class_end();
  }
}

void callStatePending::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStatePending").c_str());
    is_created_fieldID = jni::get_field_id(env, Class, "isCreated", "Z");
    is_received_fieldID = jni::get_field_id(env, Class, "isReceived", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass callStateExchangingKeys::Class;

callStateExchangingKeys::callStateExchangingKeys() {
}

const std::int32_t callStateExchangingKeys::ID;

object_ptr<CallState> callStateExchangingKeys::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callStateExchangingKeys>();
}

void callStateExchangingKeys::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callStateExchangingKeys::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStateExchangingKeys");
    s.store_class_end();
  }
}

void callStateExchangingKeys::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStateExchangingKeys").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callStateReady::Class;
jfieldID callStateReady::protocol_fieldID;
jfieldID callStateReady::servers_fieldID;
jfieldID callStateReady::config_fieldID;
jfieldID callStateReady::encryption_key_fieldID;
jfieldID callStateReady::emojis_fieldID;
jfieldID callStateReady::allow_p2p_fieldID;
jfieldID callStateReady::is_group_call_supported_fieldID;
jfieldID callStateReady::custom_parameters_fieldID;

callStateReady::callStateReady()
  : protocol_()
  , servers_()
  , config_()
  , encryption_key_()
  , emojis_()
  , allow_p2p_()
  , is_group_call_supported_()
  , custom_parameters_()
{}

callStateReady::callStateReady(object_ptr<callProtocol> &&protocol_, array<object_ptr<callServer>> &&servers_, string const &config_, bytes const &encryption_key_, array<string> &&emojis_, bool allow_p2p_, bool is_group_call_supported_, string const &custom_parameters_)
  : protocol_(std::move(protocol_))
  , servers_(std::move(servers_))
  , config_(config_)
  , encryption_key_(std::move(encryption_key_))
  , emojis_(std::move(emojis_))
  , allow_p2p_(allow_p2p_)
  , is_group_call_supported_(is_group_call_supported_)
  , custom_parameters_(custom_parameters_)
{}

const std::int32_t callStateReady::ID;

object_ptr<CallState> callStateReady::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callStateReady> res = make_object<callStateReady>();
  res->protocol_ = jni::fetch_tl_object<callProtocol>(env, jni::fetch_object(env, p, res->protocol_fieldID));
  res->servers_ = jni::FetchVector<callServer>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->servers_fieldID));
  res->config_ = jni::fetch_string(env, p, res->config_fieldID);
  res->encryption_key_ = jni::from_bytes(env, (jbyteArray)jni::fetch_object(env, p, res->encryption_key_fieldID));
  res->emojis_ = jni::FetchVector<string>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->emojis_fieldID));
  res->allow_p2p_ = (env->GetBooleanField(p, res->allow_p2p_fieldID) != 0);
  res->is_group_call_supported_ = (env->GetBooleanField(p, res->is_group_call_supported_fieldID) != 0);
  res->custom_parameters_ = jni::fetch_string(env, p, res->custom_parameters_fieldID);
  return std::move(res);
}

void callStateReady::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (protocol_ != nullptr) { jobject next; protocol_->store(env, next); if (next) { env->SetObjectField(s, protocol_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, servers_); if (arr_tmp_) { env->SetObjectField(s, servers_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { jstring nextString = jni::to_jstring(env, config_); if (nextString) { env->SetObjectField(s, config_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jbyteArray nextBytes = jni::to_bytes(env, encryption_key_); if (nextBytes) { env->SetObjectField(s, encryption_key_fieldID, nextBytes); env->DeleteLocalRef(nextBytes); } }
  { auto arr_tmp_ = jni::store_vector(env, emojis_); if (arr_tmp_) { env->SetObjectField(s, emojis_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetBooleanField(s, allow_p2p_fieldID, allow_p2p_);
  env->SetBooleanField(s, is_group_call_supported_fieldID, is_group_call_supported_);
  { jstring nextString = jni::to_jstring(env, custom_parameters_); if (nextString) { env->SetObjectField(s, custom_parameters_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void callStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStateReady");
    s.store_object_field("protocol", static_cast<const BaseObject *>(protocol_.get()));
    { s.store_vector_begin("servers", servers_.size()); for (const auto &_value : servers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("config", config_);
    s.store_bytes_field("encryptionKey", encryption_key_);
    { s.store_vector_begin("emojis", emojis_.size()); for (const auto &_value : emojis_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("allowP2p", allow_p2p_);
    s.store_field("isGroupCallSupported", is_group_call_supported_);
    s.store_field("customParameters", custom_parameters_);
    s.store_class_end();
  }
}

void callStateReady::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStateReady").c_str());
    protocol_fieldID = jni::get_field_id(env, Class, "protocol", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$CallProtocol;").c_str());
    servers_fieldID = jni::get_field_id(env, Class, "servers", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$CallServer;").c_str());
    config_fieldID = jni::get_field_id(env, Class, "config", "Ljava/lang/String;");
    encryption_key_fieldID = jni::get_field_id(env, Class, "encryptionKey", "[B");
    emojis_fieldID = jni::get_field_id(env, Class, "emojis", "[Ljava/lang/String;");
    allow_p2p_fieldID = jni::get_field_id(env, Class, "allowP2p", "Z");
    is_group_call_supported_fieldID = jni::get_field_id(env, Class, "isGroupCallSupported", "Z");
    custom_parameters_fieldID = jni::get_field_id(env, Class, "customParameters", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass callStateHangingUp::Class;

callStateHangingUp::callStateHangingUp() {
}

const std::int32_t callStateHangingUp::ID;

object_ptr<CallState> callStateHangingUp::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<callStateHangingUp>();
}

void callStateHangingUp::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void callStateHangingUp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStateHangingUp");
    s.store_class_end();
  }
}

void callStateHangingUp::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStateHangingUp").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callStateDiscarded::Class;
jfieldID callStateDiscarded::reason_fieldID;
jfieldID callStateDiscarded::need_rating_fieldID;
jfieldID callStateDiscarded::need_debug_information_fieldID;
jfieldID callStateDiscarded::need_log_fieldID;

callStateDiscarded::callStateDiscarded()
  : reason_()
  , need_rating_()
  , need_debug_information_()
  , need_log_()
{}

callStateDiscarded::callStateDiscarded(object_ptr<CallDiscardReason> &&reason_, bool need_rating_, bool need_debug_information_, bool need_log_)
  : reason_(std::move(reason_))
  , need_rating_(need_rating_)
  , need_debug_information_(need_debug_information_)
  , need_log_(need_log_)
{}

const std::int32_t callStateDiscarded::ID;

object_ptr<CallState> callStateDiscarded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callStateDiscarded> res = make_object<callStateDiscarded>();
  res->reason_ = jni::fetch_tl_object<CallDiscardReason>(env, jni::fetch_object(env, p, res->reason_fieldID));
  res->need_rating_ = (env->GetBooleanField(p, res->need_rating_fieldID) != 0);
  res->need_debug_information_ = (env->GetBooleanField(p, res->need_debug_information_fieldID) != 0);
  res->need_log_ = (env->GetBooleanField(p, res->need_log_fieldID) != 0);
  return std::move(res);
}

void callStateDiscarded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (reason_ != nullptr) { jobject next; reason_->store(env, next); if (next) { env->SetObjectField(s, reason_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, need_rating_fieldID, need_rating_);
  env->SetBooleanField(s, need_debug_information_fieldID, need_debug_information_);
  env->SetBooleanField(s, need_log_fieldID, need_log_);
}

void callStateDiscarded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStateDiscarded");
    s.store_object_field("reason", static_cast<const BaseObject *>(reason_.get()));
    s.store_field("needRating", need_rating_);
    s.store_field("needDebugInformation", need_debug_information_);
    s.store_field("needLog", need_log_);
    s.store_class_end();
  }
}

void callStateDiscarded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStateDiscarded").c_str());
    reason_fieldID = jni::get_field_id(env, Class, "reason", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$CallDiscardReason;").c_str());
    need_rating_fieldID = jni::get_field_id(env, Class, "needRating", "Z");
    need_debug_information_fieldID = jni::get_field_id(env, Class, "needDebugInformation", "Z");
    need_log_fieldID = jni::get_field_id(env, Class, "needLog", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass callStateError::Class;
jfieldID callStateError::error_fieldID;

callStateError::callStateError()
  : error_()
{}

callStateError::callStateError(object_ptr<error> &&error_)
  : error_(std::move(error_))
{}

const std::int32_t callStateError::ID;

object_ptr<CallState> callStateError::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callStateError> res = make_object<callStateError>();
  res->error_ = jni::fetch_tl_object<error>(env, jni::fetch_object(env, p, res->error_fieldID));
  return std::move(res);
}

void callStateError::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (error_ != nullptr) { jobject next; error_->store(env, next); if (next) { env->SetObjectField(s, error_fieldID, next); env->DeleteLocalRef(next); } }
}

void callStateError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallStateError");
    s.store_object_field("error", static_cast<const BaseObject *>(error_.get()));
    s.store_class_end();
  }
}

void callStateError::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallStateError").c_str());
    error_fieldID = jni::get_field_id(env, Class, "error", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Error;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callbackQueryAnswer::Class;
jfieldID callbackQueryAnswer::text_fieldID;
jfieldID callbackQueryAnswer::show_alert_fieldID;
jfieldID callbackQueryAnswer::url_fieldID;

callbackQueryAnswer::callbackQueryAnswer()
  : text_()
  , show_alert_()
  , url_()
{}

callbackQueryAnswer::callbackQueryAnswer(string const &text_, bool show_alert_, string const &url_)
  : text_(text_)
  , show_alert_(show_alert_)
  , url_(url_)
{}

const std::int32_t callbackQueryAnswer::ID;

object_ptr<callbackQueryAnswer> callbackQueryAnswer::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callbackQueryAnswer> res = make_object<callbackQueryAnswer>();
  res->text_ = jni::fetch_string(env, p, res->text_fieldID);
  res->show_alert_ = (env->GetBooleanField(p, res->show_alert_fieldID) != 0);
  res->url_ = jni::fetch_string(env, p, res->url_fieldID);
  return res;
}

void callbackQueryAnswer::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, text_); if (nextString) { env->SetObjectField(s, text_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, show_alert_fieldID, show_alert_);
  { jstring nextString = jni::to_jstring(env, url_); if (nextString) { env->SetObjectField(s, url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void callbackQueryAnswer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallbackQueryAnswer");
    s.store_field("text", text_);
    s.store_field("showAlert", show_alert_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

void callbackQueryAnswer::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallbackQueryAnswer").c_str());
    text_fieldID = jni::get_field_id(env, Class, "text", "Ljava/lang/String;");
    show_alert_fieldID = jni::get_field_id(env, Class, "showAlert", "Z");
    url_fieldID = jni::get_field_id(env, Class, "url", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass CallbackQueryPayload::Class;

object_ptr<CallbackQueryPayload> CallbackQueryPayload::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case callbackQueryPayloadData::ID:
      return callbackQueryPayloadData::fetch(env, p);
    case callbackQueryPayloadDataWithPassword::ID:
      return callbackQueryPayloadDataWithPassword::fetch(env, p);
    case callbackQueryPayloadGame::ID:
      return callbackQueryPayloadGame::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CallbackQueryPayload::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallbackQueryPayload").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass callbackQueryPayloadData::Class;
jfieldID callbackQueryPayloadData::data_fieldID;

callbackQueryPayloadData::callbackQueryPayloadData()
  : data_()
{}

callbackQueryPayloadData::callbackQueryPayloadData(bytes const &data_)
  : data_(std::move(data_))
{}

const std::int32_t callbackQueryPayloadData::ID;

object_ptr<CallbackQueryPayload> callbackQueryPayloadData::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callbackQueryPayloadData> res = make_object<callbackQueryPayloadData>();
  res->data_ = jni::from_bytes(env, (jbyteArray)jni::fetch_object(env, p, res->data_fieldID));
  return std::move(res);
}

void callbackQueryPayloadData::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jbyteArray nextBytes = jni::to_bytes(env, data_); if (nextBytes) { env->SetObjectField(s, data_fieldID, nextBytes); env->DeleteLocalRef(nextBytes); } }
}

void callbackQueryPayloadData::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallbackQueryPayloadData");
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

void callbackQueryPayloadData::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallbackQueryPayloadData").c_str());
    data_fieldID = jni::get_field_id(env, Class, "data", "[B");
    return true;
  }();
  (void)is_inited;
}

jclass callbackQueryPayloadDataWithPassword::Class;
jfieldID callbackQueryPayloadDataWithPassword::password_fieldID;
jfieldID callbackQueryPayloadDataWithPassword::data_fieldID;

callbackQueryPayloadDataWithPassword::callbackQueryPayloadDataWithPassword()
  : password_()
  , data_()
{}

callbackQueryPayloadDataWithPassword::callbackQueryPayloadDataWithPassword(string const &password_, bytes const &data_)
  : password_(password_)
  , data_(std::move(data_))
{}

const std::int32_t callbackQueryPayloadDataWithPassword::ID;

object_ptr<CallbackQueryPayload> callbackQueryPayloadDataWithPassword::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callbackQueryPayloadDataWithPassword> res = make_object<callbackQueryPayloadDataWithPassword>();
  res->password_ = jni::fetch_string(env, p, res->password_fieldID);
  res->data_ = jni::from_bytes(env, (jbyteArray)jni::fetch_object(env, p, res->data_fieldID));
  return std::move(res);
}

void callbackQueryPayloadDataWithPassword::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, password_); if (nextString) { env->SetObjectField(s, password_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jbyteArray nextBytes = jni::to_bytes(env, data_); if (nextBytes) { env->SetObjectField(s, data_fieldID, nextBytes); env->DeleteLocalRef(nextBytes); } }
}

void callbackQueryPayloadDataWithPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallbackQueryPayloadDataWithPassword");
    s.store_field("password", password_);
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

void callbackQueryPayloadDataWithPassword::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallbackQueryPayloadDataWithPassword").c_str());
    password_fieldID = jni::get_field_id(env, Class, "password", "Ljava/lang/String;");
    data_fieldID = jni::get_field_id(env, Class, "data", "[B");
    return true;
  }();
  (void)is_inited;
}

jclass callbackQueryPayloadGame::Class;
jfieldID callbackQueryPayloadGame::game_short_name_fieldID;

callbackQueryPayloadGame::callbackQueryPayloadGame()
  : game_short_name_()
{}

callbackQueryPayloadGame::callbackQueryPayloadGame(string const &game_short_name_)
  : game_short_name_(game_short_name_)
{}

const std::int32_t callbackQueryPayloadGame::ID;

object_ptr<CallbackQueryPayload> callbackQueryPayloadGame::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<callbackQueryPayloadGame> res = make_object<callbackQueryPayloadGame>();
  res->game_short_name_ = jni::fetch_string(env, p, res->game_short_name_fieldID);
  return std::move(res);
}

void callbackQueryPayloadGame::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, game_short_name_); if (nextString) { env->SetObjectField(s, game_short_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void callbackQueryPayloadGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CallbackQueryPayloadGame");
    s.store_field("gameShortName", game_short_name_);
    s.store_class_end();
  }
}

void callbackQueryPayloadGame::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CallbackQueryPayloadGame").c_str());
    game_short_name_fieldID = jni::get_field_id(env, Class, "gameShortName", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass CanPostStoryResult::Class;

object_ptr<CanPostStoryResult> CanPostStoryResult::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case canPostStoryResultOk::ID:
      return canPostStoryResultOk::fetch(env, p);
    case canPostStoryResultPremiumNeeded::ID:
      return canPostStoryResultPremiumNeeded::fetch(env, p);
    case canPostStoryResultBoostNeeded::ID:
      return canPostStoryResultBoostNeeded::fetch(env, p);
    case canPostStoryResultActiveStoryLimitExceeded::ID:
      return canPostStoryResultActiveStoryLimitExceeded::fetch(env, p);
    case canPostStoryResultWeeklyLimitExceeded::ID:
      return canPostStoryResultWeeklyLimitExceeded::fetch(env, p);
    case canPostStoryResultMonthlyLimitExceeded::ID:
      return canPostStoryResultMonthlyLimitExceeded::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CanPostStoryResult::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResult").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultOk::Class;
jfieldID canPostStoryResultOk::story_count_fieldID;

canPostStoryResultOk::canPostStoryResultOk()
  : story_count_()
{}

canPostStoryResultOk::canPostStoryResultOk(int32 story_count_)
  : story_count_(story_count_)
{}

const std::int32_t canPostStoryResultOk::ID;

object_ptr<CanPostStoryResult> canPostStoryResultOk::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canPostStoryResultOk> res = make_object<canPostStoryResultOk>();
  res->story_count_ = env->GetIntField(p, res->story_count_fieldID);
  return std::move(res);
}

void canPostStoryResultOk::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, story_count_fieldID, story_count_);
}

void canPostStoryResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultOk");
    s.store_field("storyCount", story_count_);
    s.store_class_end();
  }
}

void canPostStoryResultOk::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultOk").c_str());
    story_count_fieldID = jni::get_field_id(env, Class, "storyCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultPremiumNeeded::Class;

canPostStoryResultPremiumNeeded::canPostStoryResultPremiumNeeded() {
}

const std::int32_t canPostStoryResultPremiumNeeded::ID;

object_ptr<CanPostStoryResult> canPostStoryResultPremiumNeeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canPostStoryResultPremiumNeeded>();
}

void canPostStoryResultPremiumNeeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canPostStoryResultPremiumNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultPremiumNeeded");
    s.store_class_end();
  }
}

void canPostStoryResultPremiumNeeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultPremiumNeeded").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultBoostNeeded::Class;

canPostStoryResultBoostNeeded::canPostStoryResultBoostNeeded() {
}

const std::int32_t canPostStoryResultBoostNeeded::ID;

object_ptr<CanPostStoryResult> canPostStoryResultBoostNeeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canPostStoryResultBoostNeeded>();
}

void canPostStoryResultBoostNeeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canPostStoryResultBoostNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultBoostNeeded");
    s.store_class_end();
  }
}

void canPostStoryResultBoostNeeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultBoostNeeded").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultActiveStoryLimitExceeded::Class;

canPostStoryResultActiveStoryLimitExceeded::canPostStoryResultActiveStoryLimitExceeded() {
}

const std::int32_t canPostStoryResultActiveStoryLimitExceeded::ID;

object_ptr<CanPostStoryResult> canPostStoryResultActiveStoryLimitExceeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canPostStoryResultActiveStoryLimitExceeded>();
}

void canPostStoryResultActiveStoryLimitExceeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canPostStoryResultActiveStoryLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultActiveStoryLimitExceeded");
    s.store_class_end();
  }
}

void canPostStoryResultActiveStoryLimitExceeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultActiveStoryLimitExceeded").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultWeeklyLimitExceeded::Class;
jfieldID canPostStoryResultWeeklyLimitExceeded::retry_after_fieldID;

canPostStoryResultWeeklyLimitExceeded::canPostStoryResultWeeklyLimitExceeded()
  : retry_after_()
{}

canPostStoryResultWeeklyLimitExceeded::canPostStoryResultWeeklyLimitExceeded(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canPostStoryResultWeeklyLimitExceeded::ID;

object_ptr<CanPostStoryResult> canPostStoryResultWeeklyLimitExceeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canPostStoryResultWeeklyLimitExceeded> res = make_object<canPostStoryResultWeeklyLimitExceeded>();
  res->retry_after_ = env->GetIntField(p, res->retry_after_fieldID);
  return std::move(res);
}

void canPostStoryResultWeeklyLimitExceeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, retry_after_fieldID, retry_after_);
}

void canPostStoryResultWeeklyLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultWeeklyLimitExceeded");
    s.store_field("retryAfter", retry_after_);
    s.store_class_end();
  }
}

void canPostStoryResultWeeklyLimitExceeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultWeeklyLimitExceeded").c_str());
    retry_after_fieldID = jni::get_field_id(env, Class, "retryAfter", "I");
    return true;
  }();
  (void)is_inited;
}

jclass canPostStoryResultMonthlyLimitExceeded::Class;
jfieldID canPostStoryResultMonthlyLimitExceeded::retry_after_fieldID;

canPostStoryResultMonthlyLimitExceeded::canPostStoryResultMonthlyLimitExceeded()
  : retry_after_()
{}

canPostStoryResultMonthlyLimitExceeded::canPostStoryResultMonthlyLimitExceeded(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canPostStoryResultMonthlyLimitExceeded::ID;

object_ptr<CanPostStoryResult> canPostStoryResultMonthlyLimitExceeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canPostStoryResultMonthlyLimitExceeded> res = make_object<canPostStoryResultMonthlyLimitExceeded>();
  res->retry_after_ = env->GetIntField(p, res->retry_after_fieldID);
  return std::move(res);
}

void canPostStoryResultMonthlyLimitExceeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, retry_after_fieldID, retry_after_);
}

void canPostStoryResultMonthlyLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanPostStoryResultMonthlyLimitExceeded");
    s.store_field("retryAfter", retry_after_);
    s.store_class_end();
  }
}

void canPostStoryResultMonthlyLimitExceeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanPostStoryResultMonthlyLimitExceeded").c_str());
    retry_after_fieldID = jni::get_field_id(env, Class, "retryAfter", "I");
    return true;
  }();
  (void)is_inited;
}

jclass CanSendMessageToUserResult::Class;

object_ptr<CanSendMessageToUserResult> CanSendMessageToUserResult::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case canSendMessageToUserResultOk::ID:
      return canSendMessageToUserResultOk::fetch(env, p);
    case canSendMessageToUserResultUserHasPaidMessages::ID:
      return canSendMessageToUserResultUserHasPaidMessages::fetch(env, p);
    case canSendMessageToUserResultUserIsDeleted::ID:
      return canSendMessageToUserResultUserIsDeleted::fetch(env, p);
    case canSendMessageToUserResultUserRestrictsNewChats::ID:
      return canSendMessageToUserResultUserRestrictsNewChats::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CanSendMessageToUserResult::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanSendMessageToUserResult").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canSendMessageToUserResultOk::Class;

canSendMessageToUserResultOk::canSendMessageToUserResultOk() {
}

const std::int32_t canSendMessageToUserResultOk::ID;

object_ptr<CanSendMessageToUserResult> canSendMessageToUserResultOk::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canSendMessageToUserResultOk>();
}

void canSendMessageToUserResultOk::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canSendMessageToUserResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanSendMessageToUserResultOk");
    s.store_class_end();
  }
}

void canSendMessageToUserResultOk::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanSendMessageToUserResultOk").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canSendMessageToUserResultUserHasPaidMessages::Class;
jfieldID canSendMessageToUserResultUserHasPaidMessages::outgoing_paid_message_star_count_fieldID;

canSendMessageToUserResultUserHasPaidMessages::canSendMessageToUserResultUserHasPaidMessages()
  : outgoing_paid_message_star_count_()
{}

canSendMessageToUserResultUserHasPaidMessages::canSendMessageToUserResultUserHasPaidMessages(int53 outgoing_paid_message_star_count_)
  : outgoing_paid_message_star_count_(outgoing_paid_message_star_count_)
{}

const std::int32_t canSendMessageToUserResultUserHasPaidMessages::ID;

object_ptr<CanSendMessageToUserResult> canSendMessageToUserResultUserHasPaidMessages::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canSendMessageToUserResultUserHasPaidMessages> res = make_object<canSendMessageToUserResultUserHasPaidMessages>();
  res->outgoing_paid_message_star_count_ = env->GetLongField(p, res->outgoing_paid_message_star_count_fieldID);
  return std::move(res);
}

void canSendMessageToUserResultUserHasPaidMessages::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, outgoing_paid_message_star_count_fieldID, outgoing_paid_message_star_count_);
}

void canSendMessageToUserResultUserHasPaidMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanSendMessageToUserResultUserHasPaidMessages");
    s.store_field("outgoingPaidMessageStarCount", outgoing_paid_message_star_count_);
    s.store_class_end();
  }
}

void canSendMessageToUserResultUserHasPaidMessages::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanSendMessageToUserResultUserHasPaidMessages").c_str());
    outgoing_paid_message_star_count_fieldID = jni::get_field_id(env, Class, "outgoingPaidMessageStarCount", "J");
    return true;
  }();
  (void)is_inited;
}

jclass canSendMessageToUserResultUserIsDeleted::Class;

canSendMessageToUserResultUserIsDeleted::canSendMessageToUserResultUserIsDeleted() {
}

const std::int32_t canSendMessageToUserResultUserIsDeleted::ID;

object_ptr<CanSendMessageToUserResult> canSendMessageToUserResultUserIsDeleted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canSendMessageToUserResultUserIsDeleted>();
}

void canSendMessageToUserResultUserIsDeleted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canSendMessageToUserResultUserIsDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanSendMessageToUserResultUserIsDeleted");
    s.store_class_end();
  }
}

void canSendMessageToUserResultUserIsDeleted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanSendMessageToUserResultUserIsDeleted").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canSendMessageToUserResultUserRestrictsNewChats::Class;

canSendMessageToUserResultUserRestrictsNewChats::canSendMessageToUserResultUserRestrictsNewChats() {
}

const std::int32_t canSendMessageToUserResultUserRestrictsNewChats::ID;

object_ptr<CanSendMessageToUserResult> canSendMessageToUserResultUserRestrictsNewChats::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canSendMessageToUserResultUserRestrictsNewChats>();
}

void canSendMessageToUserResultUserRestrictsNewChats::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canSendMessageToUserResultUserRestrictsNewChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanSendMessageToUserResultUserRestrictsNewChats");
    s.store_class_end();
  }
}

void canSendMessageToUserResultUserRestrictsNewChats::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanSendMessageToUserResultUserRestrictsNewChats").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass CanTransferOwnershipResult::Class;

object_ptr<CanTransferOwnershipResult> CanTransferOwnershipResult::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case canTransferOwnershipResultOk::ID:
      return canTransferOwnershipResultOk::fetch(env, p);
    case canTransferOwnershipResultPasswordNeeded::ID:
      return canTransferOwnershipResultPasswordNeeded::fetch(env, p);
    case canTransferOwnershipResultPasswordTooFresh::ID:
      return canTransferOwnershipResultPasswordTooFresh::fetch(env, p);
    case canTransferOwnershipResultSessionTooFresh::ID:
      return canTransferOwnershipResultSessionTooFresh::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void CanTransferOwnershipResult::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanTransferOwnershipResult").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canTransferOwnershipResultOk::Class;

canTransferOwnershipResultOk::canTransferOwnershipResultOk() {
}

const std::int32_t canTransferOwnershipResultOk::ID;

object_ptr<CanTransferOwnershipResult> canTransferOwnershipResultOk::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canTransferOwnershipResultOk>();
}

void canTransferOwnershipResultOk::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canTransferOwnershipResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanTransferOwnershipResultOk");
    s.store_class_end();
  }
}

void canTransferOwnershipResultOk::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanTransferOwnershipResultOk").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canTransferOwnershipResultPasswordNeeded::Class;

canTransferOwnershipResultPasswordNeeded::canTransferOwnershipResultPasswordNeeded() {
}

const std::int32_t canTransferOwnershipResultPasswordNeeded::ID;

object_ptr<CanTransferOwnershipResult> canTransferOwnershipResultPasswordNeeded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<canTransferOwnershipResultPasswordNeeded>();
}

void canTransferOwnershipResultPasswordNeeded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void canTransferOwnershipResultPasswordNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanTransferOwnershipResultPasswordNeeded");
    s.store_class_end();
  }
}

void canTransferOwnershipResultPasswordNeeded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanTransferOwnershipResultPasswordNeeded").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass canTransferOwnershipResultPasswordTooFresh::Class;
jfieldID canTransferOwnershipResultPasswordTooFresh::retry_after_fieldID;

canTransferOwnershipResultPasswordTooFresh::canTransferOwnershipResultPasswordTooFresh()
  : retry_after_()
{}

canTransferOwnershipResultPasswordTooFresh::canTransferOwnershipResultPasswordTooFresh(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canTransferOwnershipResultPasswordTooFresh::ID;

object_ptr<CanTransferOwnershipResult> canTransferOwnershipResultPasswordTooFresh::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canTransferOwnershipResultPasswordTooFresh> res = make_object<canTransferOwnershipResultPasswordTooFresh>();
  res->retry_after_ = env->GetIntField(p, res->retry_after_fieldID);
  return std::move(res);
}

void canTransferOwnershipResultPasswordTooFresh::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, retry_after_fieldID, retry_after_);
}

void canTransferOwnershipResultPasswordTooFresh::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanTransferOwnershipResultPasswordTooFresh");
    s.store_field("retryAfter", retry_after_);
    s.store_class_end();
  }
}

void canTransferOwnershipResultPasswordTooFresh::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanTransferOwnershipResultPasswordTooFresh").c_str());
    retry_after_fieldID = jni::get_field_id(env, Class, "retryAfter", "I");
    return true;
  }();
  (void)is_inited;
}

jclass canTransferOwnershipResultSessionTooFresh::Class;
jfieldID canTransferOwnershipResultSessionTooFresh::retry_after_fieldID;

canTransferOwnershipResultSessionTooFresh::canTransferOwnershipResultSessionTooFresh()
  : retry_after_()
{}

canTransferOwnershipResultSessionTooFresh::canTransferOwnershipResultSessionTooFresh(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canTransferOwnershipResultSessionTooFresh::ID;

object_ptr<CanTransferOwnershipResult> canTransferOwnershipResultSessionTooFresh::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<canTransferOwnershipResultSessionTooFresh> res = make_object<canTransferOwnershipResultSessionTooFresh>();
  res->retry_after_ = env->GetIntField(p, res->retry_after_fieldID);
  return std::move(res);
}

void canTransferOwnershipResultSessionTooFresh::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, retry_after_fieldID, retry_after_);
}

void canTransferOwnershipResultSessionTooFresh::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "CanTransferOwnershipResultSessionTooFresh");
    s.store_field("retryAfter", retry_after_);
    s.store_class_end();
  }
}

void canTransferOwnershipResultSessionTooFresh::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$CanTransferOwnershipResultSessionTooFresh").c_str());
    retry_after_fieldID = jni::get_field_id(env, Class, "retryAfter", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chat::Class;
jfieldID chat::id_fieldID;
jfieldID chat::type_fieldID;
jfieldID chat::title_fieldID;
jfieldID chat::photo_fieldID;
jfieldID chat::accent_color_id_fieldID;
jfieldID chat::background_custom_emoji_id_fieldID;
jfieldID chat::profile_accent_color_id_fieldID;
jfieldID chat::profile_background_custom_emoji_id_fieldID;
jfieldID chat::permissions_fieldID;
jfieldID chat::last_message_fieldID;
jfieldID chat::positions_fieldID;
jfieldID chat::chat_lists_fieldID;
jfieldID chat::message_sender_id_fieldID;
jfieldID chat::block_list_fieldID;
jfieldID chat::has_protected_content_fieldID;
jfieldID chat::is_translatable_fieldID;
jfieldID chat::is_marked_as_unread_fieldID;
jfieldID chat::view_as_topics_fieldID;
jfieldID chat::has_scheduled_messages_fieldID;
jfieldID chat::can_be_deleted_only_for_self_fieldID;
jfieldID chat::can_be_deleted_for_all_users_fieldID;
jfieldID chat::can_be_reported_fieldID;
jfieldID chat::default_disable_notification_fieldID;
jfieldID chat::unread_count_fieldID;
jfieldID chat::last_read_inbox_message_id_fieldID;
jfieldID chat::last_read_outbox_message_id_fieldID;
jfieldID chat::unread_mention_count_fieldID;
jfieldID chat::unread_reaction_count_fieldID;
jfieldID chat::notification_settings_fieldID;
jfieldID chat::available_reactions_fieldID;
jfieldID chat::message_auto_delete_time_fieldID;
jfieldID chat::emoji_status_fieldID;
jfieldID chat::background_fieldID;
jfieldID chat::theme_name_fieldID;
jfieldID chat::action_bar_fieldID;
jfieldID chat::business_bot_manage_bar_fieldID;
jfieldID chat::video_chat_fieldID;
jfieldID chat::pending_join_requests_fieldID;
jfieldID chat::reply_markup_message_id_fieldID;
jfieldID chat::draft_message_fieldID;
jfieldID chat::client_data_fieldID;

chat::chat()
  : id_()
  , type_()
  , title_()
  , photo_()
  , accent_color_id_()
  , background_custom_emoji_id_()
  , profile_accent_color_id_()
  , profile_background_custom_emoji_id_()
  , permissions_()
  , last_message_()
  , positions_()
  , chat_lists_()
  , message_sender_id_()
  , block_list_()
  , has_protected_content_()
  , is_translatable_()
  , is_marked_as_unread_()
  , view_as_topics_()
  , has_scheduled_messages_()
  , can_be_deleted_only_for_self_()
  , can_be_deleted_for_all_users_()
  , can_be_reported_()
  , default_disable_notification_()
  , unread_count_()
  , last_read_inbox_message_id_()
  , last_read_outbox_message_id_()
  , unread_mention_count_()
  , unread_reaction_count_()
  , notification_settings_()
  , available_reactions_()
  , message_auto_delete_time_()
  , emoji_status_()
  , background_()
  , theme_name_()
  , action_bar_()
  , business_bot_manage_bar_()
  , video_chat_()
  , pending_join_requests_()
  , reply_markup_message_id_()
  , draft_message_()
  , client_data_()
{}

chat::chat(int53 id_, object_ptr<ChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, int64 background_custom_emoji_id_, int32 profile_accent_color_id_, int64 profile_background_custom_emoji_id_, object_ptr<chatPermissions> &&permissions_, object_ptr<message> &&last_message_, array<object_ptr<chatPosition>> &&positions_, array<object_ptr<ChatList>> &&chat_lists_, object_ptr<MessageSender> &&message_sender_id_, object_ptr<BlockList> &&block_list_, bool has_protected_content_, bool is_translatable_, bool is_marked_as_unread_, bool view_as_topics_, bool has_scheduled_messages_, bool can_be_deleted_only_for_self_, bool can_be_deleted_for_all_users_, bool can_be_reported_, bool default_disable_notification_, int32 unread_count_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int32 unread_mention_count_, int32 unread_reaction_count_, object_ptr<chatNotificationSettings> &&notification_settings_, object_ptr<ChatAvailableReactions> &&available_reactions_, int32 message_auto_delete_time_, object_ptr<emojiStatus> &&emoji_status_, object_ptr<chatBackground> &&background_, string const &theme_name_, object_ptr<ChatActionBar> &&action_bar_, object_ptr<businessBotManageBar> &&business_bot_manage_bar_, object_ptr<videoChat> &&video_chat_, object_ptr<chatJoinRequestsInfo> &&pending_join_requests_, int53 reply_markup_message_id_, object_ptr<draftMessage> &&draft_message_, string const &client_data_)
  : id_(id_)
  , type_(std::move(type_))
  , title_(title_)
  , photo_(std::move(photo_))
  , accent_color_id_(accent_color_id_)
  , background_custom_emoji_id_(background_custom_emoji_id_)
  , profile_accent_color_id_(profile_accent_color_id_)
  , profile_background_custom_emoji_id_(profile_background_custom_emoji_id_)
  , permissions_(std::move(permissions_))
  , last_message_(std::move(last_message_))
  , positions_(std::move(positions_))
  , chat_lists_(std::move(chat_lists_))
  , message_sender_id_(std::move(message_sender_id_))
  , block_list_(std::move(block_list_))
  , has_protected_content_(has_protected_content_)
  , is_translatable_(is_translatable_)
  , is_marked_as_unread_(is_marked_as_unread_)
  , view_as_topics_(view_as_topics_)
  , has_scheduled_messages_(has_scheduled_messages_)
  , can_be_deleted_only_for_self_(can_be_deleted_only_for_self_)
  , can_be_deleted_for_all_users_(can_be_deleted_for_all_users_)
  , can_be_reported_(can_be_reported_)
  , default_disable_notification_(default_disable_notification_)
  , unread_count_(unread_count_)
  , last_read_inbox_message_id_(last_read_inbox_message_id_)
  , last_read_outbox_message_id_(last_read_outbox_message_id_)
  , unread_mention_count_(unread_mention_count_)
  , unread_reaction_count_(unread_reaction_count_)
  , notification_settings_(std::move(notification_settings_))
  , available_reactions_(std::move(available_reactions_))
  , message_auto_delete_time_(message_auto_delete_time_)
  , emoji_status_(std::move(emoji_status_))
  , background_(std::move(background_))
  , theme_name_(theme_name_)
  , action_bar_(std::move(action_bar_))
  , business_bot_manage_bar_(std::move(business_bot_manage_bar_))
  , video_chat_(std::move(video_chat_))
  , pending_join_requests_(std::move(pending_join_requests_))
  , reply_markup_message_id_(reply_markup_message_id_)
  , draft_message_(std::move(draft_message_))
  , client_data_(client_data_)
{}

const std::int32_t chat::ID;

object_ptr<chat> chat::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chat> res = make_object<chat>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->type_ = jni::fetch_tl_object<ChatType>(env, jni::fetch_object(env, p, res->type_fieldID));
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->photo_ = jni::fetch_tl_object<chatPhotoInfo>(env, jni::fetch_object(env, p, res->photo_fieldID));
  res->accent_color_id_ = env->GetIntField(p, res->accent_color_id_fieldID);
  res->background_custom_emoji_id_ = env->GetLongField(p, res->background_custom_emoji_id_fieldID);
  res->profile_accent_color_id_ = env->GetIntField(p, res->profile_accent_color_id_fieldID);
  res->profile_background_custom_emoji_id_ = env->GetLongField(p, res->profile_background_custom_emoji_id_fieldID);
  res->permissions_ = jni::fetch_tl_object<chatPermissions>(env, jni::fetch_object(env, p, res->permissions_fieldID));
  res->last_message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->last_message_fieldID));
  res->positions_ = jni::FetchVector<chatPosition>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->positions_fieldID));
  res->chat_lists_ = jni::FetchVector<ChatList>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->chat_lists_fieldID));
  res->message_sender_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->message_sender_id_fieldID));
  res->block_list_ = jni::fetch_tl_object<BlockList>(env, jni::fetch_object(env, p, res->block_list_fieldID));
  res->has_protected_content_ = (env->GetBooleanField(p, res->has_protected_content_fieldID) != 0);
  res->is_translatable_ = (env->GetBooleanField(p, res->is_translatable_fieldID) != 0);
  res->is_marked_as_unread_ = (env->GetBooleanField(p, res->is_marked_as_unread_fieldID) != 0);
  res->view_as_topics_ = (env->GetBooleanField(p, res->view_as_topics_fieldID) != 0);
  res->has_scheduled_messages_ = (env->GetBooleanField(p, res->has_scheduled_messages_fieldID) != 0);
  res->can_be_deleted_only_for_self_ = (env->GetBooleanField(p, res->can_be_deleted_only_for_self_fieldID) != 0);
  res->can_be_deleted_for_all_users_ = (env->GetBooleanField(p, res->can_be_deleted_for_all_users_fieldID) != 0);
  res->can_be_reported_ = (env->GetBooleanField(p, res->can_be_reported_fieldID) != 0);
  res->default_disable_notification_ = (env->GetBooleanField(p, res->default_disable_notification_fieldID) != 0);
  res->unread_count_ = env->GetIntField(p, res->unread_count_fieldID);
  res->last_read_inbox_message_id_ = env->GetLongField(p, res->last_read_inbox_message_id_fieldID);
  res->last_read_outbox_message_id_ = env->GetLongField(p, res->last_read_outbox_message_id_fieldID);
  res->unread_mention_count_ = env->GetIntField(p, res->unread_mention_count_fieldID);
  res->unread_reaction_count_ = env->GetIntField(p, res->unread_reaction_count_fieldID);
  res->notification_settings_ = jni::fetch_tl_object<chatNotificationSettings>(env, jni::fetch_object(env, p, res->notification_settings_fieldID));
  res->available_reactions_ = jni::fetch_tl_object<ChatAvailableReactions>(env, jni::fetch_object(env, p, res->available_reactions_fieldID));
  res->message_auto_delete_time_ = env->GetIntField(p, res->message_auto_delete_time_fieldID);
  res->emoji_status_ = jni::fetch_tl_object<emojiStatus>(env, jni::fetch_object(env, p, res->emoji_status_fieldID));
  res->background_ = jni::fetch_tl_object<chatBackground>(env, jni::fetch_object(env, p, res->background_fieldID));
  res->theme_name_ = jni::fetch_string(env, p, res->theme_name_fieldID);
  res->action_bar_ = jni::fetch_tl_object<ChatActionBar>(env, jni::fetch_object(env, p, res->action_bar_fieldID));
  res->business_bot_manage_bar_ = jni::fetch_tl_object<businessBotManageBar>(env, jni::fetch_object(env, p, res->business_bot_manage_bar_fieldID));
  res->video_chat_ = jni::fetch_tl_object<videoChat>(env, jni::fetch_object(env, p, res->video_chat_fieldID));
  res->pending_join_requests_ = jni::fetch_tl_object<chatJoinRequestsInfo>(env, jni::fetch_object(env, p, res->pending_join_requests_fieldID));
  res->reply_markup_message_id_ = env->GetLongField(p, res->reply_markup_message_id_fieldID);
  res->draft_message_ = jni::fetch_tl_object<draftMessage>(env, jni::fetch_object(env, p, res->draft_message_fieldID));
  res->client_data_ = jni::fetch_string(env, p, res->client_data_fieldID);
  return res;
}

void chat::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (photo_ != nullptr) { jobject next; photo_->store(env, next); if (next) { env->SetObjectField(s, photo_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, accent_color_id_fieldID, accent_color_id_);
  env->SetLongField(s, background_custom_emoji_id_fieldID, background_custom_emoji_id_);
  env->SetIntField(s, profile_accent_color_id_fieldID, profile_accent_color_id_);
  env->SetLongField(s, profile_background_custom_emoji_id_fieldID, profile_background_custom_emoji_id_);
  if (permissions_ != nullptr) { jobject next; permissions_->store(env, next); if (next) { env->SetObjectField(s, permissions_fieldID, next); env->DeleteLocalRef(next); } }
  if (last_message_ != nullptr) { jobject next; last_message_->store(env, next); if (next) { env->SetObjectField(s, last_message_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, positions_); if (arr_tmp_) { env->SetObjectField(s, positions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, chat_lists_); if (arr_tmp_) { env->SetObjectField(s, chat_lists_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  if (message_sender_id_ != nullptr) { jobject next; message_sender_id_->store(env, next); if (next) { env->SetObjectField(s, message_sender_id_fieldID, next); env->DeleteLocalRef(next); } }
  if (block_list_ != nullptr) { jobject next; block_list_->store(env, next); if (next) { env->SetObjectField(s, block_list_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, has_protected_content_fieldID, has_protected_content_);
  env->SetBooleanField(s, is_translatable_fieldID, is_translatable_);
  env->SetBooleanField(s, is_marked_as_unread_fieldID, is_marked_as_unread_);
  env->SetBooleanField(s, view_as_topics_fieldID, view_as_topics_);
  env->SetBooleanField(s, has_scheduled_messages_fieldID, has_scheduled_messages_);
  env->SetBooleanField(s, can_be_deleted_only_for_self_fieldID, can_be_deleted_only_for_self_);
  env->SetBooleanField(s, can_be_deleted_for_all_users_fieldID, can_be_deleted_for_all_users_);
  env->SetBooleanField(s, can_be_reported_fieldID, can_be_reported_);
  env->SetBooleanField(s, default_disable_notification_fieldID, default_disable_notification_);
  env->SetIntField(s, unread_count_fieldID, unread_count_);
  env->SetLongField(s, last_read_inbox_message_id_fieldID, last_read_inbox_message_id_);
  env->SetLongField(s, last_read_outbox_message_id_fieldID, last_read_outbox_message_id_);
  env->SetIntField(s, unread_mention_count_fieldID, unread_mention_count_);
  env->SetIntField(s, unread_reaction_count_fieldID, unread_reaction_count_);
  if (notification_settings_ != nullptr) { jobject next; notification_settings_->store(env, next); if (next) { env->SetObjectField(s, notification_settings_fieldID, next); env->DeleteLocalRef(next); } }
  if (available_reactions_ != nullptr) { jobject next; available_reactions_->store(env, next); if (next) { env->SetObjectField(s, available_reactions_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, message_auto_delete_time_fieldID, message_auto_delete_time_);
  if (emoji_status_ != nullptr) { jobject next; emoji_status_->store(env, next); if (next) { env->SetObjectField(s, emoji_status_fieldID, next); env->DeleteLocalRef(next); } }
  if (background_ != nullptr) { jobject next; background_->store(env, next); if (next) { env->SetObjectField(s, background_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, theme_name_); if (nextString) { env->SetObjectField(s, theme_name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (action_bar_ != nullptr) { jobject next; action_bar_->store(env, next); if (next) { env->SetObjectField(s, action_bar_fieldID, next); env->DeleteLocalRef(next); } }
  if (business_bot_manage_bar_ != nullptr) { jobject next; business_bot_manage_bar_->store(env, next); if (next) { env->SetObjectField(s, business_bot_manage_bar_fieldID, next); env->DeleteLocalRef(next); } }
  if (video_chat_ != nullptr) { jobject next; video_chat_->store(env, next); if (next) { env->SetObjectField(s, video_chat_fieldID, next); env->DeleteLocalRef(next); } }
  if (pending_join_requests_ != nullptr) { jobject next; pending_join_requests_->store(env, next); if (next) { env->SetObjectField(s, pending_join_requests_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetLongField(s, reply_markup_message_id_fieldID, reply_markup_message_id_);
  if (draft_message_ != nullptr) { jobject next; draft_message_->store(env, next); if (next) { env->SetObjectField(s, draft_message_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, client_data_); if (nextString) { env->SetObjectField(s, client_data_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "Chat");
    s.store_field("id", id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("accentColorId", accent_color_id_);
    s.store_field("backgroundCustomEmojiId", background_custom_emoji_id_);
    s.store_field("profileAccentColorId", profile_accent_color_id_);
    s.store_field("profileBackgroundCustomEmojiId", profile_background_custom_emoji_id_);
    s.store_object_field("permissions", static_cast<const BaseObject *>(permissions_.get()));
    s.store_object_field("lastMessage", static_cast<const BaseObject *>(last_message_.get()));
    { s.store_vector_begin("positions", positions_.size()); for (const auto &_value : positions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("chatLists", chat_lists_.size()); for (const auto &_value : chat_lists_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("messageSenderId", static_cast<const BaseObject *>(message_sender_id_.get()));
    s.store_object_field("blockList", static_cast<const BaseObject *>(block_list_.get()));
    s.store_field("hasProtectedContent", has_protected_content_);
    s.store_field("isTranslatable", is_translatable_);
    s.store_field("isMarkedAsUnread", is_marked_as_unread_);
    s.store_field("viewAsTopics", view_as_topics_);
    s.store_field("hasScheduledMessages", has_scheduled_messages_);
    s.store_field("canBeDeletedOnlyForSelf", can_be_deleted_only_for_self_);
    s.store_field("canBeDeletedForAllUsers", can_be_deleted_for_all_users_);
    s.store_field("canBeReported", can_be_reported_);
    s.store_field("defaultDisableNotification", default_disable_notification_);
    s.store_field("unreadCount", unread_count_);
    s.store_field("lastReadInboxMessageId", last_read_inbox_message_id_);
    s.store_field("lastReadOutboxMessageId", last_read_outbox_message_id_);
    s.store_field("unreadMentionCount", unread_mention_count_);
    s.store_field("unreadReactionCount", unread_reaction_count_);
    s.store_object_field("notificationSettings", static_cast<const BaseObject *>(notification_settings_.get()));
    s.store_object_field("availableReactions", static_cast<const BaseObject *>(available_reactions_.get()));
    s.store_field("messageAutoDeleteTime", message_auto_delete_time_);
    s.store_object_field("emojiStatus", static_cast<const BaseObject *>(emoji_status_.get()));
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_field("themeName", theme_name_);
    s.store_object_field("actionBar", static_cast<const BaseObject *>(action_bar_.get()));
    s.store_object_field("businessBotManageBar", static_cast<const BaseObject *>(business_bot_manage_bar_.get()));
    s.store_object_field("videoChat", static_cast<const BaseObject *>(video_chat_.get()));
    s.store_object_field("pendingJoinRequests", static_cast<const BaseObject *>(pending_join_requests_.get()));
    s.store_field("replyMarkupMessageId", reply_markup_message_id_);
    s.store_object_field("draftMessage", static_cast<const BaseObject *>(draft_message_.get()));
    s.store_field("clientData", client_data_);
    s.store_class_end();
  }
}

void chat::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$Chat").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatType;").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    photo_fieldID = jni::get_field_id(env, Class, "photo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPhotoInfo;").c_str());
    accent_color_id_fieldID = jni::get_field_id(env, Class, "accentColorId", "I");
    background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "backgroundCustomEmojiId", "J");
    profile_accent_color_id_fieldID = jni::get_field_id(env, Class, "profileAccentColorId", "I");
    profile_background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "profileBackgroundCustomEmojiId", "J");
    permissions_fieldID = jni::get_field_id(env, Class, "permissions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPermissions;").c_str());
    last_message_fieldID = jni::get_field_id(env, Class, "lastMessage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    positions_fieldID = jni::get_field_id(env, Class, "positions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatPosition;").c_str());
    chat_lists_fieldID = jni::get_field_id(env, Class, "chatLists", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatList;").c_str());
    message_sender_id_fieldID = jni::get_field_id(env, Class, "messageSenderId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    block_list_fieldID = jni::get_field_id(env, Class, "blockList", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BlockList;").c_str());
    has_protected_content_fieldID = jni::get_field_id(env, Class, "hasProtectedContent", "Z");
    is_translatable_fieldID = jni::get_field_id(env, Class, "isTranslatable", "Z");
    is_marked_as_unread_fieldID = jni::get_field_id(env, Class, "isMarkedAsUnread", "Z");
    view_as_topics_fieldID = jni::get_field_id(env, Class, "viewAsTopics", "Z");
    has_scheduled_messages_fieldID = jni::get_field_id(env, Class, "hasScheduledMessages", "Z");
    can_be_deleted_only_for_self_fieldID = jni::get_field_id(env, Class, "canBeDeletedOnlyForSelf", "Z");
    can_be_deleted_for_all_users_fieldID = jni::get_field_id(env, Class, "canBeDeletedForAllUsers", "Z");
    can_be_reported_fieldID = jni::get_field_id(env, Class, "canBeReported", "Z");
    default_disable_notification_fieldID = jni::get_field_id(env, Class, "defaultDisableNotification", "Z");
    unread_count_fieldID = jni::get_field_id(env, Class, "unreadCount", "I");
    last_read_inbox_message_id_fieldID = jni::get_field_id(env, Class, "lastReadInboxMessageId", "J");
    last_read_outbox_message_id_fieldID = jni::get_field_id(env, Class, "lastReadOutboxMessageId", "J");
    unread_mention_count_fieldID = jni::get_field_id(env, Class, "unreadMentionCount", "I");
    unread_reaction_count_fieldID = jni::get_field_id(env, Class, "unreadReactionCount", "I");
    notification_settings_fieldID = jni::get_field_id(env, Class, "notificationSettings", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatNotificationSettings;").c_str());
    available_reactions_fieldID = jni::get_field_id(env, Class, "availableReactions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAvailableReactions;").c_str());
    message_auto_delete_time_fieldID = jni::get_field_id(env, Class, "messageAutoDeleteTime", "I");
    emoji_status_fieldID = jni::get_field_id(env, Class, "emojiStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$EmojiStatus;").c_str());
    background_fieldID = jni::get_field_id(env, Class, "background", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatBackground;").c_str());
    theme_name_fieldID = jni::get_field_id(env, Class, "themeName", "Ljava/lang/String;");
    action_bar_fieldID = jni::get_field_id(env, Class, "actionBar", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatActionBar;").c_str());
    business_bot_manage_bar_fieldID = jni::get_field_id(env, Class, "businessBotManageBar", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$BusinessBotManageBar;").c_str());
    video_chat_fieldID = jni::get_field_id(env, Class, "videoChat", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$VideoChat;").c_str());
    pending_join_requests_fieldID = jni::get_field_id(env, Class, "pendingJoinRequests", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatJoinRequestsInfo;").c_str());
    reply_markup_message_id_fieldID = jni::get_field_id(env, Class, "replyMarkupMessageId", "J");
    draft_message_fieldID = jni::get_field_id(env, Class, "draftMessage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$DraftMessage;").c_str());
    client_data_fieldID = jni::get_field_id(env, Class, "clientData", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass ChatAction::Class;

object_ptr<ChatAction> ChatAction::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatActionTyping::ID:
      return chatActionTyping::fetch(env, p);
    case chatActionRecordingVideo::ID:
      return chatActionRecordingVideo::fetch(env, p);
    case chatActionUploadingVideo::ID:
      return chatActionUploadingVideo::fetch(env, p);
    case chatActionRecordingVoiceNote::ID:
      return chatActionRecordingVoiceNote::fetch(env, p);
    case chatActionUploadingVoiceNote::ID:
      return chatActionUploadingVoiceNote::fetch(env, p);
    case chatActionUploadingPhoto::ID:
      return chatActionUploadingPhoto::fetch(env, p);
    case chatActionUploadingDocument::ID:
      return chatActionUploadingDocument::fetch(env, p);
    case chatActionChoosingSticker::ID:
      return chatActionChoosingSticker::fetch(env, p);
    case chatActionChoosingLocation::ID:
      return chatActionChoosingLocation::fetch(env, p);
    case chatActionChoosingContact::ID:
      return chatActionChoosingContact::fetch(env, p);
    case chatActionStartPlayingGame::ID:
      return chatActionStartPlayingGame::fetch(env, p);
    case chatActionRecordingVideoNote::ID:
      return chatActionRecordingVideoNote::fetch(env, p);
    case chatActionUploadingVideoNote::ID:
      return chatActionUploadingVideoNote::fetch(env, p);
    case chatActionWatchingAnimations::ID:
      return chatActionWatchingAnimations::fetch(env, p);
    case chatActionCancel::ID:
      return chatActionCancel::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatAction::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAction").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionTyping::Class;

chatActionTyping::chatActionTyping() {
}

const std::int32_t chatActionTyping::ID;

object_ptr<ChatAction> chatActionTyping::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionTyping>();
}

void chatActionTyping::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionTyping::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionTyping");
    s.store_class_end();
  }
}

void chatActionTyping::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionTyping").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionRecordingVideo::Class;

chatActionRecordingVideo::chatActionRecordingVideo() {
}

const std::int32_t chatActionRecordingVideo::ID;

object_ptr<ChatAction> chatActionRecordingVideo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionRecordingVideo>();
}

void chatActionRecordingVideo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionRecordingVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionRecordingVideo");
    s.store_class_end();
  }
}

void chatActionRecordingVideo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionRecordingVideo").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionUploadingVideo::Class;
jfieldID chatActionUploadingVideo::progress_fieldID;

chatActionUploadingVideo::chatActionUploadingVideo()
  : progress_()
{}

chatActionUploadingVideo::chatActionUploadingVideo(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVideo::ID;

object_ptr<ChatAction> chatActionUploadingVideo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionUploadingVideo> res = make_object<chatActionUploadingVideo>();
  res->progress_ = env->GetIntField(p, res->progress_fieldID);
  return std::move(res);
}

void chatActionUploadingVideo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, progress_fieldID, progress_);
}

void chatActionUploadingVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionUploadingVideo");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

void chatActionUploadingVideo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionUploadingVideo").c_str());
    progress_fieldID = jni::get_field_id(env, Class, "progress", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionRecordingVoiceNote::Class;

chatActionRecordingVoiceNote::chatActionRecordingVoiceNote() {
}

const std::int32_t chatActionRecordingVoiceNote::ID;

object_ptr<ChatAction> chatActionRecordingVoiceNote::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionRecordingVoiceNote>();
}

void chatActionRecordingVoiceNote::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionRecordingVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionRecordingVoiceNote");
    s.store_class_end();
  }
}

void chatActionRecordingVoiceNote::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionRecordingVoiceNote").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionUploadingVoiceNote::Class;
jfieldID chatActionUploadingVoiceNote::progress_fieldID;

chatActionUploadingVoiceNote::chatActionUploadingVoiceNote()
  : progress_()
{}

chatActionUploadingVoiceNote::chatActionUploadingVoiceNote(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVoiceNote::ID;

object_ptr<ChatAction> chatActionUploadingVoiceNote::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionUploadingVoiceNote> res = make_object<chatActionUploadingVoiceNote>();
  res->progress_ = env->GetIntField(p, res->progress_fieldID);
  return std::move(res);
}

void chatActionUploadingVoiceNote::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, progress_fieldID, progress_);
}

void chatActionUploadingVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionUploadingVoiceNote");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

void chatActionUploadingVoiceNote::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionUploadingVoiceNote").c_str());
    progress_fieldID = jni::get_field_id(env, Class, "progress", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionUploadingPhoto::Class;
jfieldID chatActionUploadingPhoto::progress_fieldID;

chatActionUploadingPhoto::chatActionUploadingPhoto()
  : progress_()
{}

chatActionUploadingPhoto::chatActionUploadingPhoto(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingPhoto::ID;

object_ptr<ChatAction> chatActionUploadingPhoto::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionUploadingPhoto> res = make_object<chatActionUploadingPhoto>();
  res->progress_ = env->GetIntField(p, res->progress_fieldID);
  return std::move(res);
}

void chatActionUploadingPhoto::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, progress_fieldID, progress_);
}

void chatActionUploadingPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionUploadingPhoto");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

void chatActionUploadingPhoto::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionUploadingPhoto").c_str());
    progress_fieldID = jni::get_field_id(env, Class, "progress", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionUploadingDocument::Class;
jfieldID chatActionUploadingDocument::progress_fieldID;

chatActionUploadingDocument::chatActionUploadingDocument()
  : progress_()
{}

chatActionUploadingDocument::chatActionUploadingDocument(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingDocument::ID;

object_ptr<ChatAction> chatActionUploadingDocument::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionUploadingDocument> res = make_object<chatActionUploadingDocument>();
  res->progress_ = env->GetIntField(p, res->progress_fieldID);
  return std::move(res);
}

void chatActionUploadingDocument::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, progress_fieldID, progress_);
}

void chatActionUploadingDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionUploadingDocument");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

void chatActionUploadingDocument::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionUploadingDocument").c_str());
    progress_fieldID = jni::get_field_id(env, Class, "progress", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionChoosingSticker::Class;

chatActionChoosingSticker::chatActionChoosingSticker() {
}

const std::int32_t chatActionChoosingSticker::ID;

object_ptr<ChatAction> chatActionChoosingSticker::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionChoosingSticker>();
}

void chatActionChoosingSticker::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionChoosingSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionChoosingSticker");
    s.store_class_end();
  }
}

void chatActionChoosingSticker::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionChoosingSticker").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionChoosingLocation::Class;

chatActionChoosingLocation::chatActionChoosingLocation() {
}

const std::int32_t chatActionChoosingLocation::ID;

object_ptr<ChatAction> chatActionChoosingLocation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionChoosingLocation>();
}

void chatActionChoosingLocation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionChoosingLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionChoosingLocation");
    s.store_class_end();
  }
}

void chatActionChoosingLocation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionChoosingLocation").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionChoosingContact::Class;

chatActionChoosingContact::chatActionChoosingContact() {
}

const std::int32_t chatActionChoosingContact::ID;

object_ptr<ChatAction> chatActionChoosingContact::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionChoosingContact>();
}

void chatActionChoosingContact::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionChoosingContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionChoosingContact");
    s.store_class_end();
  }
}

void chatActionChoosingContact::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionChoosingContact").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionStartPlayingGame::Class;

chatActionStartPlayingGame::chatActionStartPlayingGame() {
}

const std::int32_t chatActionStartPlayingGame::ID;

object_ptr<ChatAction> chatActionStartPlayingGame::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionStartPlayingGame>();
}

void chatActionStartPlayingGame::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionStartPlayingGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionStartPlayingGame");
    s.store_class_end();
  }
}

void chatActionStartPlayingGame::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionStartPlayingGame").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionRecordingVideoNote::Class;

chatActionRecordingVideoNote::chatActionRecordingVideoNote() {
}

const std::int32_t chatActionRecordingVideoNote::ID;

object_ptr<ChatAction> chatActionRecordingVideoNote::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionRecordingVideoNote>();
}

void chatActionRecordingVideoNote::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionRecordingVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionRecordingVideoNote");
    s.store_class_end();
  }
}

void chatActionRecordingVideoNote::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionRecordingVideoNote").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionUploadingVideoNote::Class;
jfieldID chatActionUploadingVideoNote::progress_fieldID;

chatActionUploadingVideoNote::chatActionUploadingVideoNote()
  : progress_()
{}

chatActionUploadingVideoNote::chatActionUploadingVideoNote(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVideoNote::ID;

object_ptr<ChatAction> chatActionUploadingVideoNote::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionUploadingVideoNote> res = make_object<chatActionUploadingVideoNote>();
  res->progress_ = env->GetIntField(p, res->progress_fieldID);
  return std::move(res);
}

void chatActionUploadingVideoNote::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, progress_fieldID, progress_);
}

void chatActionUploadingVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionUploadingVideoNote");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

void chatActionUploadingVideoNote::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionUploadingVideoNote").c_str());
    progress_fieldID = jni::get_field_id(env, Class, "progress", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionWatchingAnimations::Class;
jfieldID chatActionWatchingAnimations::emoji_fieldID;

chatActionWatchingAnimations::chatActionWatchingAnimations()
  : emoji_()
{}

chatActionWatchingAnimations::chatActionWatchingAnimations(string const &emoji_)
  : emoji_(emoji_)
{}

const std::int32_t chatActionWatchingAnimations::ID;

object_ptr<ChatAction> chatActionWatchingAnimations::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionWatchingAnimations> res = make_object<chatActionWatchingAnimations>();
  res->emoji_ = jni::fetch_string(env, p, res->emoji_fieldID);
  return std::move(res);
}

void chatActionWatchingAnimations::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, emoji_); if (nextString) { env->SetObjectField(s, emoji_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatActionWatchingAnimations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionWatchingAnimations");
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

void chatActionWatchingAnimations::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionWatchingAnimations").c_str());
    emoji_fieldID = jni::get_field_id(env, Class, "emoji", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionCancel::Class;

chatActionCancel::chatActionCancel() {
}

const std::int32_t chatActionCancel::ID;

object_ptr<ChatAction> chatActionCancel::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionCancel>();
}

void chatActionCancel::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionCancel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionCancel");
    s.store_class_end();
  }
}

void chatActionCancel::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionCancel").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatActionBar::Class;

object_ptr<ChatActionBar> ChatActionBar::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatActionBarReportSpam::ID:
      return chatActionBarReportSpam::fetch(env, p);
    case chatActionBarInviteMembers::ID:
      return chatActionBarInviteMembers::fetch(env, p);
    case chatActionBarReportAddBlock::ID:
      return chatActionBarReportAddBlock::fetch(env, p);
    case chatActionBarAddContact::ID:
      return chatActionBarAddContact::fetch(env, p);
    case chatActionBarSharePhoneNumber::ID:
      return chatActionBarSharePhoneNumber::fetch(env, p);
    case chatActionBarJoinRequest::ID:
      return chatActionBarJoinRequest::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatActionBar::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBar").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarReportSpam::Class;
jfieldID chatActionBarReportSpam::can_unarchive_fieldID;

chatActionBarReportSpam::chatActionBarReportSpam()
  : can_unarchive_()
{}

chatActionBarReportSpam::chatActionBarReportSpam(bool can_unarchive_)
  : can_unarchive_(can_unarchive_)
{}

const std::int32_t chatActionBarReportSpam::ID;

object_ptr<ChatActionBar> chatActionBarReportSpam::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionBarReportSpam> res = make_object<chatActionBarReportSpam>();
  res->can_unarchive_ = (env->GetBooleanField(p, res->can_unarchive_fieldID) != 0);
  return std::move(res);
}

void chatActionBarReportSpam::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, can_unarchive_fieldID, can_unarchive_);
}

void chatActionBarReportSpam::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarReportSpam");
    s.store_field("canUnarchive", can_unarchive_);
    s.store_class_end();
  }
}

void chatActionBarReportSpam::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarReportSpam").c_str());
    can_unarchive_fieldID = jni::get_field_id(env, Class, "canUnarchive", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarInviteMembers::Class;

chatActionBarInviteMembers::chatActionBarInviteMembers() {
}

const std::int32_t chatActionBarInviteMembers::ID;

object_ptr<ChatActionBar> chatActionBarInviteMembers::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionBarInviteMembers>();
}

void chatActionBarInviteMembers::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionBarInviteMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarInviteMembers");
    s.store_class_end();
  }
}

void chatActionBarInviteMembers::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarInviteMembers").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarReportAddBlock::Class;
jfieldID chatActionBarReportAddBlock::can_unarchive_fieldID;
jfieldID chatActionBarReportAddBlock::account_info_fieldID;

chatActionBarReportAddBlock::chatActionBarReportAddBlock()
  : can_unarchive_()
  , account_info_()
{}

chatActionBarReportAddBlock::chatActionBarReportAddBlock(bool can_unarchive_, object_ptr<accountInfo> &&account_info_)
  : can_unarchive_(can_unarchive_)
  , account_info_(std::move(account_info_))
{}

const std::int32_t chatActionBarReportAddBlock::ID;

object_ptr<ChatActionBar> chatActionBarReportAddBlock::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionBarReportAddBlock> res = make_object<chatActionBarReportAddBlock>();
  res->can_unarchive_ = (env->GetBooleanField(p, res->can_unarchive_fieldID) != 0);
  res->account_info_ = jni::fetch_tl_object<accountInfo>(env, jni::fetch_object(env, p, res->account_info_fieldID));
  return std::move(res);
}

void chatActionBarReportAddBlock::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, can_unarchive_fieldID, can_unarchive_);
  if (account_info_ != nullptr) { jobject next; account_info_->store(env, next); if (next) { env->SetObjectField(s, account_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatActionBarReportAddBlock::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarReportAddBlock");
    s.store_field("canUnarchive", can_unarchive_);
    s.store_object_field("accountInfo", static_cast<const BaseObject *>(account_info_.get()));
    s.store_class_end();
  }
}

void chatActionBarReportAddBlock::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarReportAddBlock").c_str());
    can_unarchive_fieldID = jni::get_field_id(env, Class, "canUnarchive", "Z");
    account_info_fieldID = jni::get_field_id(env, Class, "accountInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$AccountInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarAddContact::Class;

chatActionBarAddContact::chatActionBarAddContact() {
}

const std::int32_t chatActionBarAddContact::ID;

object_ptr<ChatActionBar> chatActionBarAddContact::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionBarAddContact>();
}

void chatActionBarAddContact::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionBarAddContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarAddContact");
    s.store_class_end();
  }
}

void chatActionBarAddContact::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarAddContact").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarSharePhoneNumber::Class;

chatActionBarSharePhoneNumber::chatActionBarSharePhoneNumber() {
}

const std::int32_t chatActionBarSharePhoneNumber::ID;

object_ptr<ChatActionBar> chatActionBarSharePhoneNumber::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatActionBarSharePhoneNumber>();
}

void chatActionBarSharePhoneNumber::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatActionBarSharePhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarSharePhoneNumber");
    s.store_class_end();
  }
}

void chatActionBarSharePhoneNumber::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarSharePhoneNumber").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatActionBarJoinRequest::Class;
jfieldID chatActionBarJoinRequest::title_fieldID;
jfieldID chatActionBarJoinRequest::is_channel_fieldID;
jfieldID chatActionBarJoinRequest::request_date_fieldID;

chatActionBarJoinRequest::chatActionBarJoinRequest()
  : title_()
  , is_channel_()
  , request_date_()
{}

chatActionBarJoinRequest::chatActionBarJoinRequest(string const &title_, bool is_channel_, int32 request_date_)
  : title_(title_)
  , is_channel_(is_channel_)
  , request_date_(request_date_)
{}

const std::int32_t chatActionBarJoinRequest::ID;

object_ptr<ChatActionBar> chatActionBarJoinRequest::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActionBarJoinRequest> res = make_object<chatActionBarJoinRequest>();
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->is_channel_ = (env->GetBooleanField(p, res->is_channel_fieldID) != 0);
  res->request_date_ = env->GetIntField(p, res->request_date_fieldID);
  return std::move(res);
}

void chatActionBarJoinRequest::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, is_channel_fieldID, is_channel_);
  env->SetIntField(s, request_date_fieldID, request_date_);
}

void chatActionBarJoinRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActionBarJoinRequest");
    s.store_field("title", title_);
    s.store_field("isChannel", is_channel_);
    s.store_field("requestDate", request_date_);
    s.store_class_end();
  }
}

void chatActionBarJoinRequest::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActionBarJoinRequest").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    is_channel_fieldID = jni::get_field_id(env, Class, "isChannel", "Z");
    request_date_fieldID = jni::get_field_id(env, Class, "requestDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatActiveStories::Class;
jfieldID chatActiveStories::chat_id_fieldID;
jfieldID chatActiveStories::list_fieldID;
jfieldID chatActiveStories::order_fieldID;
jfieldID chatActiveStories::max_read_story_id_fieldID;
jfieldID chatActiveStories::stories_fieldID;

chatActiveStories::chatActiveStories()
  : chat_id_()
  , list_()
  , order_()
  , max_read_story_id_()
  , stories_()
{}

chatActiveStories::chatActiveStories(int53 chat_id_, object_ptr<StoryList> &&list_, int53 order_, int32 max_read_story_id_, array<object_ptr<storyInfo>> &&stories_)
  : chat_id_(chat_id_)
  , list_(std::move(list_))
  , order_(order_)
  , max_read_story_id_(max_read_story_id_)
  , stories_(std::move(stories_))
{}

const std::int32_t chatActiveStories::ID;

object_ptr<chatActiveStories> chatActiveStories::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatActiveStories> res = make_object<chatActiveStories>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  res->list_ = jni::fetch_tl_object<StoryList>(env, jni::fetch_object(env, p, res->list_fieldID));
  res->order_ = env->GetLongField(p, res->order_fieldID);
  res->max_read_story_id_ = env->GetIntField(p, res->max_read_story_id_fieldID);
  res->stories_ = jni::FetchVector<storyInfo>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->stories_fieldID));
  return res;
}

void chatActiveStories::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, chat_id_fieldID, chat_id_);
  if (list_ != nullptr) { jobject next; list_->store(env, next); if (next) { env->SetObjectField(s, list_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetLongField(s, order_fieldID, order_);
  env->SetIntField(s, max_read_story_id_fieldID, max_read_story_id_);
  { auto arr_tmp_ = jni::store_vector(env, stories_); if (arr_tmp_) { env->SetObjectField(s, stories_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatActiveStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatActiveStories");
    s.store_field("chatId", chat_id_);
    s.store_object_field("list", static_cast<const BaseObject *>(list_.get()));
    s.store_field("order", order_);
    s.store_field("maxReadStoryId", max_read_story_id_);
    { s.store_vector_begin("stories", stories_.size()); for (const auto &_value : stories_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatActiveStories::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatActiveStories").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    list_fieldID = jni::get_field_id(env, Class, "list", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StoryList;").c_str());
    order_fieldID = jni::get_field_id(env, Class, "order", "J");
    max_read_story_id_fieldID = jni::get_field_id(env, Class, "maxReadStoryId", "I");
    stories_fieldID = jni::get_field_id(env, Class, "stories", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$StoryInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatAdministrator::Class;
jfieldID chatAdministrator::user_id_fieldID;
jfieldID chatAdministrator::custom_title_fieldID;
jfieldID chatAdministrator::is_owner_fieldID;

chatAdministrator::chatAdministrator()
  : user_id_()
  , custom_title_()
  , is_owner_()
{}

chatAdministrator::chatAdministrator(int53 user_id_, string const &custom_title_, bool is_owner_)
  : user_id_(user_id_)
  , custom_title_(custom_title_)
  , is_owner_(is_owner_)
{}

const std::int32_t chatAdministrator::ID;

object_ptr<chatAdministrator> chatAdministrator::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatAdministrator> res = make_object<chatAdministrator>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->custom_title_ = jni::fetch_string(env, p, res->custom_title_fieldID);
  res->is_owner_ = (env->GetBooleanField(p, res->is_owner_fieldID) != 0);
  return res;
}

void chatAdministrator::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  { jstring nextString = jni::to_jstring(env, custom_title_); if (nextString) { env->SetObjectField(s, custom_title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, is_owner_fieldID, is_owner_);
}

void chatAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatAdministrator");
    s.store_field("userId", user_id_);
    s.store_field("customTitle", custom_title_);
    s.store_field("isOwner", is_owner_);
    s.store_class_end();
  }
}

void chatAdministrator::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAdministrator").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    custom_title_fieldID = jni::get_field_id(env, Class, "customTitle", "Ljava/lang/String;");
    is_owner_fieldID = jni::get_field_id(env, Class, "isOwner", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatAdministratorRights::Class;
jfieldID chatAdministratorRights::can_manage_chat_fieldID;
jfieldID chatAdministratorRights::can_change_info_fieldID;
jfieldID chatAdministratorRights::can_post_messages_fieldID;
jfieldID chatAdministratorRights::can_edit_messages_fieldID;
jfieldID chatAdministratorRights::can_delete_messages_fieldID;
jfieldID chatAdministratorRights::can_invite_users_fieldID;
jfieldID chatAdministratorRights::can_restrict_members_fieldID;
jfieldID chatAdministratorRights::can_pin_messages_fieldID;
jfieldID chatAdministratorRights::can_manage_topics_fieldID;
jfieldID chatAdministratorRights::can_promote_members_fieldID;
jfieldID chatAdministratorRights::can_manage_video_chats_fieldID;
jfieldID chatAdministratorRights::can_post_stories_fieldID;
jfieldID chatAdministratorRights::can_edit_stories_fieldID;
jfieldID chatAdministratorRights::can_delete_stories_fieldID;
jfieldID chatAdministratorRights::can_manage_direct_messages_fieldID;
jfieldID chatAdministratorRights::is_anonymous_fieldID;

chatAdministratorRights::chatAdministratorRights()
  : can_manage_chat_()
  , can_change_info_()
  , can_post_messages_()
  , can_edit_messages_()
  , can_delete_messages_()
  , can_invite_users_()
  , can_restrict_members_()
  , can_pin_messages_()
  , can_manage_topics_()
  , can_promote_members_()
  , can_manage_video_chats_()
  , can_post_stories_()
  , can_edit_stories_()
  , can_delete_stories_()
  , can_manage_direct_messages_()
  , is_anonymous_()
{}

chatAdministratorRights::chatAdministratorRights(bool can_manage_chat_, bool can_change_info_, bool can_post_messages_, bool can_edit_messages_, bool can_delete_messages_, bool can_invite_users_, bool can_restrict_members_, bool can_pin_messages_, bool can_manage_topics_, bool can_promote_members_, bool can_manage_video_chats_, bool can_post_stories_, bool can_edit_stories_, bool can_delete_stories_, bool can_manage_direct_messages_, bool is_anonymous_)
  : can_manage_chat_(can_manage_chat_)
  , can_change_info_(can_change_info_)
  , can_post_messages_(can_post_messages_)
  , can_edit_messages_(can_edit_messages_)
  , can_delete_messages_(can_delete_messages_)
  , can_invite_users_(can_invite_users_)
  , can_restrict_members_(can_restrict_members_)
  , can_pin_messages_(can_pin_messages_)
  , can_manage_topics_(can_manage_topics_)
  , can_promote_members_(can_promote_members_)
  , can_manage_video_chats_(can_manage_video_chats_)
  , can_post_stories_(can_post_stories_)
  , can_edit_stories_(can_edit_stories_)
  , can_delete_stories_(can_delete_stories_)
  , can_manage_direct_messages_(can_manage_direct_messages_)
  , is_anonymous_(is_anonymous_)
{}

const std::int32_t chatAdministratorRights::ID;

object_ptr<chatAdministratorRights> chatAdministratorRights::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatAdministratorRights> res = make_object<chatAdministratorRights>();
  res->can_manage_chat_ = (env->GetBooleanField(p, res->can_manage_chat_fieldID) != 0);
  res->can_change_info_ = (env->GetBooleanField(p, res->can_change_info_fieldID) != 0);
  res->can_post_messages_ = (env->GetBooleanField(p, res->can_post_messages_fieldID) != 0);
  res->can_edit_messages_ = (env->GetBooleanField(p, res->can_edit_messages_fieldID) != 0);
  res->can_delete_messages_ = (env->GetBooleanField(p, res->can_delete_messages_fieldID) != 0);
  res->can_invite_users_ = (env->GetBooleanField(p, res->can_invite_users_fieldID) != 0);
  res->can_restrict_members_ = (env->GetBooleanField(p, res->can_restrict_members_fieldID) != 0);
  res->can_pin_messages_ = (env->GetBooleanField(p, res->can_pin_messages_fieldID) != 0);
  res->can_manage_topics_ = (env->GetBooleanField(p, res->can_manage_topics_fieldID) != 0);
  res->can_promote_members_ = (env->GetBooleanField(p, res->can_promote_members_fieldID) != 0);
  res->can_manage_video_chats_ = (env->GetBooleanField(p, res->can_manage_video_chats_fieldID) != 0);
  res->can_post_stories_ = (env->GetBooleanField(p, res->can_post_stories_fieldID) != 0);
  res->can_edit_stories_ = (env->GetBooleanField(p, res->can_edit_stories_fieldID) != 0);
  res->can_delete_stories_ = (env->GetBooleanField(p, res->can_delete_stories_fieldID) != 0);
  res->can_manage_direct_messages_ = (env->GetBooleanField(p, res->can_manage_direct_messages_fieldID) != 0);
  res->is_anonymous_ = (env->GetBooleanField(p, res->is_anonymous_fieldID) != 0);
  return res;
}

void chatAdministratorRights::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, can_manage_chat_fieldID, can_manage_chat_);
  env->SetBooleanField(s, can_change_info_fieldID, can_change_info_);
  env->SetBooleanField(s, can_post_messages_fieldID, can_post_messages_);
  env->SetBooleanField(s, can_edit_messages_fieldID, can_edit_messages_);
  env->SetBooleanField(s, can_delete_messages_fieldID, can_delete_messages_);
  env->SetBooleanField(s, can_invite_users_fieldID, can_invite_users_);
  env->SetBooleanField(s, can_restrict_members_fieldID, can_restrict_members_);
  env->SetBooleanField(s, can_pin_messages_fieldID, can_pin_messages_);
  env->SetBooleanField(s, can_manage_topics_fieldID, can_manage_topics_);
  env->SetBooleanField(s, can_promote_members_fieldID, can_promote_members_);
  env->SetBooleanField(s, can_manage_video_chats_fieldID, can_manage_video_chats_);
  env->SetBooleanField(s, can_post_stories_fieldID, can_post_stories_);
  env->SetBooleanField(s, can_edit_stories_fieldID, can_edit_stories_);
  env->SetBooleanField(s, can_delete_stories_fieldID, can_delete_stories_);
  env->SetBooleanField(s, can_manage_direct_messages_fieldID, can_manage_direct_messages_);
  env->SetBooleanField(s, is_anonymous_fieldID, is_anonymous_);
}

void chatAdministratorRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatAdministratorRights");
    s.store_field("canManageChat", can_manage_chat_);
    s.store_field("canChangeInfo", can_change_info_);
    s.store_field("canPostMessages", can_post_messages_);
    s.store_field("canEditMessages", can_edit_messages_);
    s.store_field("canDeleteMessages", can_delete_messages_);
    s.store_field("canInviteUsers", can_invite_users_);
    s.store_field("canRestrictMembers", can_restrict_members_);
    s.store_field("canPinMessages", can_pin_messages_);
    s.store_field("canManageTopics", can_manage_topics_);
    s.store_field("canPromoteMembers", can_promote_members_);
    s.store_field("canManageVideoChats", can_manage_video_chats_);
    s.store_field("canPostStories", can_post_stories_);
    s.store_field("canEditStories", can_edit_stories_);
    s.store_field("canDeleteStories", can_delete_stories_);
    s.store_field("canManageDirectMessages", can_manage_direct_messages_);
    s.store_field("isAnonymous", is_anonymous_);
    s.store_class_end();
  }
}

void chatAdministratorRights::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAdministratorRights").c_str());
    can_manage_chat_fieldID = jni::get_field_id(env, Class, "canManageChat", "Z");
    can_change_info_fieldID = jni::get_field_id(env, Class, "canChangeInfo", "Z");
    can_post_messages_fieldID = jni::get_field_id(env, Class, "canPostMessages", "Z");
    can_edit_messages_fieldID = jni::get_field_id(env, Class, "canEditMessages", "Z");
    can_delete_messages_fieldID = jni::get_field_id(env, Class, "canDeleteMessages", "Z");
    can_invite_users_fieldID = jni::get_field_id(env, Class, "canInviteUsers", "Z");
    can_restrict_members_fieldID = jni::get_field_id(env, Class, "canRestrictMembers", "Z");
    can_pin_messages_fieldID = jni::get_field_id(env, Class, "canPinMessages", "Z");
    can_manage_topics_fieldID = jni::get_field_id(env, Class, "canManageTopics", "Z");
    can_promote_members_fieldID = jni::get_field_id(env, Class, "canPromoteMembers", "Z");
    can_manage_video_chats_fieldID = jni::get_field_id(env, Class, "canManageVideoChats", "Z");
    can_post_stories_fieldID = jni::get_field_id(env, Class, "canPostStories", "Z");
    can_edit_stories_fieldID = jni::get_field_id(env, Class, "canEditStories", "Z");
    can_delete_stories_fieldID = jni::get_field_id(env, Class, "canDeleteStories", "Z");
    can_manage_direct_messages_fieldID = jni::get_field_id(env, Class, "canManageDirectMessages", "Z");
    is_anonymous_fieldID = jni::get_field_id(env, Class, "isAnonymous", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatAdministrators::Class;
jfieldID chatAdministrators::administrators_fieldID;

chatAdministrators::chatAdministrators()
  : administrators_()
{}

chatAdministrators::chatAdministrators(array<object_ptr<chatAdministrator>> &&administrators_)
  : administrators_(std::move(administrators_))
{}

const std::int32_t chatAdministrators::ID;

object_ptr<chatAdministrators> chatAdministrators::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatAdministrators> res = make_object<chatAdministrators>();
  res->administrators_ = jni::FetchVector<chatAdministrator>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->administrators_fieldID));
  return res;
}

void chatAdministrators::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, administrators_); if (arr_tmp_) { env->SetObjectField(s, administrators_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatAdministrators");
    { s.store_vector_begin("administrators", administrators_.size()); for (const auto &_value : administrators_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatAdministrators::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAdministrators").c_str());
    administrators_fieldID = jni::get_field_id(env, Class, "administrators", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatAdministrator;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatAvailableReactions::Class;

object_ptr<ChatAvailableReactions> ChatAvailableReactions::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatAvailableReactionsAll::ID:
      return chatAvailableReactionsAll::fetch(env, p);
    case chatAvailableReactionsSome::ID:
      return chatAvailableReactionsSome::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatAvailableReactions::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAvailableReactions").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatAvailableReactionsAll::Class;
jfieldID chatAvailableReactionsAll::max_reaction_count_fieldID;

chatAvailableReactionsAll::chatAvailableReactionsAll()
  : max_reaction_count_()
{}

chatAvailableReactionsAll::chatAvailableReactionsAll(int32 max_reaction_count_)
  : max_reaction_count_(max_reaction_count_)
{}

const std::int32_t chatAvailableReactionsAll::ID;

object_ptr<ChatAvailableReactions> chatAvailableReactionsAll::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatAvailableReactionsAll> res = make_object<chatAvailableReactionsAll>();
  res->max_reaction_count_ = env->GetIntField(p, res->max_reaction_count_fieldID);
  return std::move(res);
}

void chatAvailableReactionsAll::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, max_reaction_count_fieldID, max_reaction_count_);
}

void chatAvailableReactionsAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatAvailableReactionsAll");
    s.store_field("maxReactionCount", max_reaction_count_);
    s.store_class_end();
  }
}

void chatAvailableReactionsAll::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAvailableReactionsAll").c_str());
    max_reaction_count_fieldID = jni::get_field_id(env, Class, "maxReactionCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatAvailableReactionsSome::Class;
jfieldID chatAvailableReactionsSome::reactions_fieldID;
jfieldID chatAvailableReactionsSome::max_reaction_count_fieldID;

chatAvailableReactionsSome::chatAvailableReactionsSome()
  : reactions_()
  , max_reaction_count_()
{}

chatAvailableReactionsSome::chatAvailableReactionsSome(array<object_ptr<ReactionType>> &&reactions_, int32 max_reaction_count_)
  : reactions_(std::move(reactions_))
  , max_reaction_count_(max_reaction_count_)
{}

const std::int32_t chatAvailableReactionsSome::ID;

object_ptr<ChatAvailableReactions> chatAvailableReactionsSome::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatAvailableReactionsSome> res = make_object<chatAvailableReactionsSome>();
  res->reactions_ = jni::FetchVector<ReactionType>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->reactions_fieldID));
  res->max_reaction_count_ = env->GetIntField(p, res->max_reaction_count_fieldID);
  return std::move(res);
}

void chatAvailableReactionsSome::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, reactions_); if (arr_tmp_) { env->SetObjectField(s, reactions_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetIntField(s, max_reaction_count_fieldID, max_reaction_count_);
}

void chatAvailableReactionsSome::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatAvailableReactionsSome");
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("maxReactionCount", max_reaction_count_);
    s.store_class_end();
  }
}

void chatAvailableReactionsSome::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatAvailableReactionsSome").c_str());
    reactions_fieldID = jni::get_field_id(env, Class, "reactions", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ReactionType;").c_str());
    max_reaction_count_fieldID = jni::get_field_id(env, Class, "maxReactionCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatBackground::Class;
jfieldID chatBackground::background_fieldID;
jfieldID chatBackground::dark_theme_dimming_fieldID;

chatBackground::chatBackground()
  : background_()
  , dark_theme_dimming_()
{}

chatBackground::chatBackground(object_ptr<background> &&background_, int32 dark_theme_dimming_)
  : background_(std::move(background_))
  , dark_theme_dimming_(dark_theme_dimming_)
{}

const std::int32_t chatBackground::ID;

object_ptr<chatBackground> chatBackground::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBackground> res = make_object<chatBackground>();
  res->background_ = jni::fetch_tl_object<background>(env, jni::fetch_object(env, p, res->background_fieldID));
  res->dark_theme_dimming_ = env->GetIntField(p, res->dark_theme_dimming_fieldID);
  return res;
}

void chatBackground::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (background_ != nullptr) { jobject next; background_->store(env, next); if (next) { env->SetObjectField(s, background_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, dark_theme_dimming_fieldID, dark_theme_dimming_);
}

void chatBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBackground");
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_field("darkThemeDimming", dark_theme_dimming_);
    s.store_class_end();
  }
}

void chatBackground::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBackground").c_str());
    background_fieldID = jni::get_field_id(env, Class, "background", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Background;").c_str());
    dark_theme_dimming_fieldID = jni::get_field_id(env, Class, "darkThemeDimming", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoost::Class;
jfieldID chatBoost::id_fieldID;
jfieldID chatBoost::count_fieldID;
jfieldID chatBoost::source_fieldID;
jfieldID chatBoost::start_date_fieldID;
jfieldID chatBoost::expiration_date_fieldID;

chatBoost::chatBoost()
  : id_()
  , count_()
  , source_()
  , start_date_()
  , expiration_date_()
{}

chatBoost::chatBoost(string const &id_, int32 count_, object_ptr<ChatBoostSource> &&source_, int32 start_date_, int32 expiration_date_)
  : id_(id_)
  , count_(count_)
  , source_(std::move(source_))
  , start_date_(start_date_)
  , expiration_date_(expiration_date_)
{}

const std::int32_t chatBoost::ID;

object_ptr<chatBoost> chatBoost::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoost> res = make_object<chatBoost>();
  res->id_ = jni::fetch_string(env, p, res->id_fieldID);
  res->count_ = env->GetIntField(p, res->count_fieldID);
  res->source_ = jni::fetch_tl_object<ChatBoostSource>(env, jni::fetch_object(env, p, res->source_fieldID));
  res->start_date_ = env->GetIntField(p, res->start_date_fieldID);
  res->expiration_date_ = env->GetIntField(p, res->expiration_date_fieldID);
  return res;
}

void chatBoost::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, id_); if (nextString) { env->SetObjectField(s, id_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, count_fieldID, count_);
  if (source_ != nullptr) { jobject next; source_->store(env, next); if (next) { env->SetObjectField(s, source_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, start_date_fieldID, start_date_);
  env->SetIntField(s, expiration_date_fieldID, expiration_date_);
}

void chatBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoost");
    s.store_field("id", id_);
    s.store_field("count", count_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_field("startDate", start_date_);
    s.store_field("expirationDate", expiration_date_);
    s.store_class_end();
  }
}

void chatBoost::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoost").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "Ljava/lang/String;");
    count_fieldID = jni::get_field_id(env, Class, "count", "I");
    source_fieldID = jni::get_field_id(env, Class, "source", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatBoostSource;").c_str());
    start_date_fieldID = jni::get_field_id(env, Class, "startDate", "I");
    expiration_date_fieldID = jni::get_field_id(env, Class, "expirationDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostFeatures::Class;
jfieldID chatBoostFeatures::features_fieldID;
jfieldID chatBoostFeatures::min_profile_background_custom_emoji_boost_level_fieldID;
jfieldID chatBoostFeatures::min_background_custom_emoji_boost_level_fieldID;
jfieldID chatBoostFeatures::min_emoji_status_boost_level_fieldID;
jfieldID chatBoostFeatures::min_chat_theme_background_boost_level_fieldID;
jfieldID chatBoostFeatures::min_custom_background_boost_level_fieldID;
jfieldID chatBoostFeatures::min_custom_emoji_sticker_set_boost_level_fieldID;
jfieldID chatBoostFeatures::min_automatic_translation_boost_level_fieldID;
jfieldID chatBoostFeatures::min_speech_recognition_boost_level_fieldID;
jfieldID chatBoostFeatures::min_sponsored_message_disable_boost_level_fieldID;

chatBoostFeatures::chatBoostFeatures()
  : features_()
  , min_profile_background_custom_emoji_boost_level_()
  , min_background_custom_emoji_boost_level_()
  , min_emoji_status_boost_level_()
  , min_chat_theme_background_boost_level_()
  , min_custom_background_boost_level_()
  , min_custom_emoji_sticker_set_boost_level_()
  , min_automatic_translation_boost_level_()
  , min_speech_recognition_boost_level_()
  , min_sponsored_message_disable_boost_level_()
{}

chatBoostFeatures::chatBoostFeatures(array<object_ptr<chatBoostLevelFeatures>> &&features_, int32 min_profile_background_custom_emoji_boost_level_, int32 min_background_custom_emoji_boost_level_, int32 min_emoji_status_boost_level_, int32 min_chat_theme_background_boost_level_, int32 min_custom_background_boost_level_, int32 min_custom_emoji_sticker_set_boost_level_, int32 min_automatic_translation_boost_level_, int32 min_speech_recognition_boost_level_, int32 min_sponsored_message_disable_boost_level_)
  : features_(std::move(features_))
  , min_profile_background_custom_emoji_boost_level_(min_profile_background_custom_emoji_boost_level_)
  , min_background_custom_emoji_boost_level_(min_background_custom_emoji_boost_level_)
  , min_emoji_status_boost_level_(min_emoji_status_boost_level_)
  , min_chat_theme_background_boost_level_(min_chat_theme_background_boost_level_)
  , min_custom_background_boost_level_(min_custom_background_boost_level_)
  , min_custom_emoji_sticker_set_boost_level_(min_custom_emoji_sticker_set_boost_level_)
  , min_automatic_translation_boost_level_(min_automatic_translation_boost_level_)
  , min_speech_recognition_boost_level_(min_speech_recognition_boost_level_)
  , min_sponsored_message_disable_boost_level_(min_sponsored_message_disable_boost_level_)
{}

const std::int32_t chatBoostFeatures::ID;

object_ptr<chatBoostFeatures> chatBoostFeatures::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostFeatures> res = make_object<chatBoostFeatures>();
  res->features_ = jni::FetchVector<chatBoostLevelFeatures>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->features_fieldID));
  res->min_profile_background_custom_emoji_boost_level_ = env->GetIntField(p, res->min_profile_background_custom_emoji_boost_level_fieldID);
  res->min_background_custom_emoji_boost_level_ = env->GetIntField(p, res->min_background_custom_emoji_boost_level_fieldID);
  res->min_emoji_status_boost_level_ = env->GetIntField(p, res->min_emoji_status_boost_level_fieldID);
  res->min_chat_theme_background_boost_level_ = env->GetIntField(p, res->min_chat_theme_background_boost_level_fieldID);
  res->min_custom_background_boost_level_ = env->GetIntField(p, res->min_custom_background_boost_level_fieldID);
  res->min_custom_emoji_sticker_set_boost_level_ = env->GetIntField(p, res->min_custom_emoji_sticker_set_boost_level_fieldID);
  res->min_automatic_translation_boost_level_ = env->GetIntField(p, res->min_automatic_translation_boost_level_fieldID);
  res->min_speech_recognition_boost_level_ = env->GetIntField(p, res->min_speech_recognition_boost_level_fieldID);
  res->min_sponsored_message_disable_boost_level_ = env->GetIntField(p, res->min_sponsored_message_disable_boost_level_fieldID);
  return res;
}

void chatBoostFeatures::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, features_); if (arr_tmp_) { env->SetObjectField(s, features_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetIntField(s, min_profile_background_custom_emoji_boost_level_fieldID, min_profile_background_custom_emoji_boost_level_);
  env->SetIntField(s, min_background_custom_emoji_boost_level_fieldID, min_background_custom_emoji_boost_level_);
  env->SetIntField(s, min_emoji_status_boost_level_fieldID, min_emoji_status_boost_level_);
  env->SetIntField(s, min_chat_theme_background_boost_level_fieldID, min_chat_theme_background_boost_level_);
  env->SetIntField(s, min_custom_background_boost_level_fieldID, min_custom_background_boost_level_);
  env->SetIntField(s, min_custom_emoji_sticker_set_boost_level_fieldID, min_custom_emoji_sticker_set_boost_level_);
  env->SetIntField(s, min_automatic_translation_boost_level_fieldID, min_automatic_translation_boost_level_);
  env->SetIntField(s, min_speech_recognition_boost_level_fieldID, min_speech_recognition_boost_level_);
  env->SetIntField(s, min_sponsored_message_disable_boost_level_fieldID, min_sponsored_message_disable_boost_level_);
}

void chatBoostFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostFeatures");
    { s.store_vector_begin("features", features_.size()); for (const auto &_value : features_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("minProfileBackgroundCustomEmojiBoostLevel", min_profile_background_custom_emoji_boost_level_);
    s.store_field("minBackgroundCustomEmojiBoostLevel", min_background_custom_emoji_boost_level_);
    s.store_field("minEmojiStatusBoostLevel", min_emoji_status_boost_level_);
    s.store_field("minChatThemeBackgroundBoostLevel", min_chat_theme_background_boost_level_);
    s.store_field("minCustomBackgroundBoostLevel", min_custom_background_boost_level_);
    s.store_field("minCustomEmojiStickerSetBoostLevel", min_custom_emoji_sticker_set_boost_level_);
    s.store_field("minAutomaticTranslationBoostLevel", min_automatic_translation_boost_level_);
    s.store_field("minSpeechRecognitionBoostLevel", min_speech_recognition_boost_level_);
    s.store_field("minSponsoredMessageDisableBoostLevel", min_sponsored_message_disable_boost_level_);
    s.store_class_end();
  }
}

void chatBoostFeatures::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostFeatures").c_str());
    features_fieldID = jni::get_field_id(env, Class, "features", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatBoostLevelFeatures;").c_str());
    min_profile_background_custom_emoji_boost_level_fieldID = jni::get_field_id(env, Class, "minProfileBackgroundCustomEmojiBoostLevel", "I");
    min_background_custom_emoji_boost_level_fieldID = jni::get_field_id(env, Class, "minBackgroundCustomEmojiBoostLevel", "I");
    min_emoji_status_boost_level_fieldID = jni::get_field_id(env, Class, "minEmojiStatusBoostLevel", "I");
    min_chat_theme_background_boost_level_fieldID = jni::get_field_id(env, Class, "minChatThemeBackgroundBoostLevel", "I");
    min_custom_background_boost_level_fieldID = jni::get_field_id(env, Class, "minCustomBackgroundBoostLevel", "I");
    min_custom_emoji_sticker_set_boost_level_fieldID = jni::get_field_id(env, Class, "minCustomEmojiStickerSetBoostLevel", "I");
    min_automatic_translation_boost_level_fieldID = jni::get_field_id(env, Class, "minAutomaticTranslationBoostLevel", "I");
    min_speech_recognition_boost_level_fieldID = jni::get_field_id(env, Class, "minSpeechRecognitionBoostLevel", "I");
    min_sponsored_message_disable_boost_level_fieldID = jni::get_field_id(env, Class, "minSponsoredMessageDisableBoostLevel", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostLevelFeatures::Class;
jfieldID chatBoostLevelFeatures::level_fieldID;
jfieldID chatBoostLevelFeatures::story_per_day_count_fieldID;
jfieldID chatBoostLevelFeatures::custom_emoji_reaction_count_fieldID;
jfieldID chatBoostLevelFeatures::title_color_count_fieldID;
jfieldID chatBoostLevelFeatures::profile_accent_color_count_fieldID;
jfieldID chatBoostLevelFeatures::can_set_profile_background_custom_emoji_fieldID;
jfieldID chatBoostLevelFeatures::accent_color_count_fieldID;
jfieldID chatBoostLevelFeatures::can_set_background_custom_emoji_fieldID;
jfieldID chatBoostLevelFeatures::can_set_emoji_status_fieldID;
jfieldID chatBoostLevelFeatures::chat_theme_background_count_fieldID;
jfieldID chatBoostLevelFeatures::can_set_custom_background_fieldID;
jfieldID chatBoostLevelFeatures::can_set_custom_emoji_sticker_set_fieldID;
jfieldID chatBoostLevelFeatures::can_enable_automatic_translation_fieldID;
jfieldID chatBoostLevelFeatures::can_recognize_speech_fieldID;
jfieldID chatBoostLevelFeatures::can_disable_sponsored_messages_fieldID;

chatBoostLevelFeatures::chatBoostLevelFeatures()
  : level_()
  , story_per_day_count_()
  , custom_emoji_reaction_count_()
  , title_color_count_()
  , profile_accent_color_count_()
  , can_set_profile_background_custom_emoji_()
  , accent_color_count_()
  , can_set_background_custom_emoji_()
  , can_set_emoji_status_()
  , chat_theme_background_count_()
  , can_set_custom_background_()
  , can_set_custom_emoji_sticker_set_()
  , can_enable_automatic_translation_()
  , can_recognize_speech_()
  , can_disable_sponsored_messages_()
{}

chatBoostLevelFeatures::chatBoostLevelFeatures(int32 level_, int32 story_per_day_count_, int32 custom_emoji_reaction_count_, int32 title_color_count_, int32 profile_accent_color_count_, bool can_set_profile_background_custom_emoji_, int32 accent_color_count_, bool can_set_background_custom_emoji_, bool can_set_emoji_status_, int32 chat_theme_background_count_, bool can_set_custom_background_, bool can_set_custom_emoji_sticker_set_, bool can_enable_automatic_translation_, bool can_recognize_speech_, bool can_disable_sponsored_messages_)
  : level_(level_)
  , story_per_day_count_(story_per_day_count_)
  , custom_emoji_reaction_count_(custom_emoji_reaction_count_)
  , title_color_count_(title_color_count_)
  , profile_accent_color_count_(profile_accent_color_count_)
  , can_set_profile_background_custom_emoji_(can_set_profile_background_custom_emoji_)
  , accent_color_count_(accent_color_count_)
  , can_set_background_custom_emoji_(can_set_background_custom_emoji_)
  , can_set_emoji_status_(can_set_emoji_status_)
  , chat_theme_background_count_(chat_theme_background_count_)
  , can_set_custom_background_(can_set_custom_background_)
  , can_set_custom_emoji_sticker_set_(can_set_custom_emoji_sticker_set_)
  , can_enable_automatic_translation_(can_enable_automatic_translation_)
  , can_recognize_speech_(can_recognize_speech_)
  , can_disable_sponsored_messages_(can_disable_sponsored_messages_)
{}

const std::int32_t chatBoostLevelFeatures::ID;

object_ptr<chatBoostLevelFeatures> chatBoostLevelFeatures::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostLevelFeatures> res = make_object<chatBoostLevelFeatures>();
  res->level_ = env->GetIntField(p, res->level_fieldID);
  res->story_per_day_count_ = env->GetIntField(p, res->story_per_day_count_fieldID);
  res->custom_emoji_reaction_count_ = env->GetIntField(p, res->custom_emoji_reaction_count_fieldID);
  res->title_color_count_ = env->GetIntField(p, res->title_color_count_fieldID);
  res->profile_accent_color_count_ = env->GetIntField(p, res->profile_accent_color_count_fieldID);
  res->can_set_profile_background_custom_emoji_ = (env->GetBooleanField(p, res->can_set_profile_background_custom_emoji_fieldID) != 0);
  res->accent_color_count_ = env->GetIntField(p, res->accent_color_count_fieldID);
  res->can_set_background_custom_emoji_ = (env->GetBooleanField(p, res->can_set_background_custom_emoji_fieldID) != 0);
  res->can_set_emoji_status_ = (env->GetBooleanField(p, res->can_set_emoji_status_fieldID) != 0);
  res->chat_theme_background_count_ = env->GetIntField(p, res->chat_theme_background_count_fieldID);
  res->can_set_custom_background_ = (env->GetBooleanField(p, res->can_set_custom_background_fieldID) != 0);
  res->can_set_custom_emoji_sticker_set_ = (env->GetBooleanField(p, res->can_set_custom_emoji_sticker_set_fieldID) != 0);
  res->can_enable_automatic_translation_ = (env->GetBooleanField(p, res->can_enable_automatic_translation_fieldID) != 0);
  res->can_recognize_speech_ = (env->GetBooleanField(p, res->can_recognize_speech_fieldID) != 0);
  res->can_disable_sponsored_messages_ = (env->GetBooleanField(p, res->can_disable_sponsored_messages_fieldID) != 0);
  return res;
}

void chatBoostLevelFeatures::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, level_fieldID, level_);
  env->SetIntField(s, story_per_day_count_fieldID, story_per_day_count_);
  env->SetIntField(s, custom_emoji_reaction_count_fieldID, custom_emoji_reaction_count_);
  env->SetIntField(s, title_color_count_fieldID, title_color_count_);
  env->SetIntField(s, profile_accent_color_count_fieldID, profile_accent_color_count_);
  env->SetBooleanField(s, can_set_profile_background_custom_emoji_fieldID, can_set_profile_background_custom_emoji_);
  env->SetIntField(s, accent_color_count_fieldID, accent_color_count_);
  env->SetBooleanField(s, can_set_background_custom_emoji_fieldID, can_set_background_custom_emoji_);
  env->SetBooleanField(s, can_set_emoji_status_fieldID, can_set_emoji_status_);
  env->SetIntField(s, chat_theme_background_count_fieldID, chat_theme_background_count_);
  env->SetBooleanField(s, can_set_custom_background_fieldID, can_set_custom_background_);
  env->SetBooleanField(s, can_set_custom_emoji_sticker_set_fieldID, can_set_custom_emoji_sticker_set_);
  env->SetBooleanField(s, can_enable_automatic_translation_fieldID, can_enable_automatic_translation_);
  env->SetBooleanField(s, can_recognize_speech_fieldID, can_recognize_speech_);
  env->SetBooleanField(s, can_disable_sponsored_messages_fieldID, can_disable_sponsored_messages_);
}

void chatBoostLevelFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostLevelFeatures");
    s.store_field("level", level_);
    s.store_field("storyPerDayCount", story_per_day_count_);
    s.store_field("customEmojiReactionCount", custom_emoji_reaction_count_);
    s.store_field("titleColorCount", title_color_count_);
    s.store_field("profileAccentColorCount", profile_accent_color_count_);
    s.store_field("canSetProfileBackgroundCustomEmoji", can_set_profile_background_custom_emoji_);
    s.store_field("accentColorCount", accent_color_count_);
    s.store_field("canSetBackgroundCustomEmoji", can_set_background_custom_emoji_);
    s.store_field("canSetEmojiStatus", can_set_emoji_status_);
    s.store_field("chatThemeBackgroundCount", chat_theme_background_count_);
    s.store_field("canSetCustomBackground", can_set_custom_background_);
    s.store_field("canSetCustomEmojiStickerSet", can_set_custom_emoji_sticker_set_);
    s.store_field("canEnableAutomaticTranslation", can_enable_automatic_translation_);
    s.store_field("canRecognizeSpeech", can_recognize_speech_);
    s.store_field("canDisableSponsoredMessages", can_disable_sponsored_messages_);
    s.store_class_end();
  }
}

void chatBoostLevelFeatures::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostLevelFeatures").c_str());
    level_fieldID = jni::get_field_id(env, Class, "level", "I");
    story_per_day_count_fieldID = jni::get_field_id(env, Class, "storyPerDayCount", "I");
    custom_emoji_reaction_count_fieldID = jni::get_field_id(env, Class, "customEmojiReactionCount", "I");
    title_color_count_fieldID = jni::get_field_id(env, Class, "titleColorCount", "I");
    profile_accent_color_count_fieldID = jni::get_field_id(env, Class, "profileAccentColorCount", "I");
    can_set_profile_background_custom_emoji_fieldID = jni::get_field_id(env, Class, "canSetProfileBackgroundCustomEmoji", "Z");
    accent_color_count_fieldID = jni::get_field_id(env, Class, "accentColorCount", "I");
    can_set_background_custom_emoji_fieldID = jni::get_field_id(env, Class, "canSetBackgroundCustomEmoji", "Z");
    can_set_emoji_status_fieldID = jni::get_field_id(env, Class, "canSetEmojiStatus", "Z");
    chat_theme_background_count_fieldID = jni::get_field_id(env, Class, "chatThemeBackgroundCount", "I");
    can_set_custom_background_fieldID = jni::get_field_id(env, Class, "canSetCustomBackground", "Z");
    can_set_custom_emoji_sticker_set_fieldID = jni::get_field_id(env, Class, "canSetCustomEmojiStickerSet", "Z");
    can_enable_automatic_translation_fieldID = jni::get_field_id(env, Class, "canEnableAutomaticTranslation", "Z");
    can_recognize_speech_fieldID = jni::get_field_id(env, Class, "canRecognizeSpeech", "Z");
    can_disable_sponsored_messages_fieldID = jni::get_field_id(env, Class, "canDisableSponsoredMessages", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostLink::Class;
jfieldID chatBoostLink::link_fieldID;
jfieldID chatBoostLink::is_public_fieldID;

chatBoostLink::chatBoostLink()
  : link_()
  , is_public_()
{}

chatBoostLink::chatBoostLink(string const &link_, bool is_public_)
  : link_(link_)
  , is_public_(is_public_)
{}

const std::int32_t chatBoostLink::ID;

object_ptr<chatBoostLink> chatBoostLink::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostLink> res = make_object<chatBoostLink>();
  res->link_ = jni::fetch_string(env, p, res->link_fieldID);
  res->is_public_ = (env->GetBooleanField(p, res->is_public_fieldID) != 0);
  return res;
}

void chatBoostLink::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, link_); if (nextString) { env->SetObjectField(s, link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, is_public_fieldID, is_public_);
}

void chatBoostLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostLink");
    s.store_field("link", link_);
    s.store_field("isPublic", is_public_);
    s.store_class_end();
  }
}

void chatBoostLink::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostLink").c_str());
    link_fieldID = jni::get_field_id(env, Class, "link", "Ljava/lang/String;");
    is_public_fieldID = jni::get_field_id(env, Class, "isPublic", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostLinkInfo::Class;
jfieldID chatBoostLinkInfo::is_public_fieldID;
jfieldID chatBoostLinkInfo::chat_id_fieldID;

chatBoostLinkInfo::chatBoostLinkInfo()
  : is_public_()
  , chat_id_()
{}

chatBoostLinkInfo::chatBoostLinkInfo(bool is_public_, int53 chat_id_)
  : is_public_(is_public_)
  , chat_id_(chat_id_)
{}

const std::int32_t chatBoostLinkInfo::ID;

object_ptr<chatBoostLinkInfo> chatBoostLinkInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostLinkInfo> res = make_object<chatBoostLinkInfo>();
  res->is_public_ = (env->GetBooleanField(p, res->is_public_fieldID) != 0);
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  return res;
}

void chatBoostLinkInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_public_fieldID, is_public_);
  env->SetLongField(s, chat_id_fieldID, chat_id_);
}

void chatBoostLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostLinkInfo");
    s.store_field("isPublic", is_public_);
    s.store_field("chatId", chat_id_);
    s.store_class_end();
  }
}

void chatBoostLinkInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostLinkInfo").c_str());
    is_public_fieldID = jni::get_field_id(env, Class, "isPublic", "Z");
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostSlot::Class;
jfieldID chatBoostSlot::slot_id_fieldID;
jfieldID chatBoostSlot::currently_boosted_chat_id_fieldID;
jfieldID chatBoostSlot::start_date_fieldID;
jfieldID chatBoostSlot::expiration_date_fieldID;
jfieldID chatBoostSlot::cooldown_until_date_fieldID;

chatBoostSlot::chatBoostSlot()
  : slot_id_()
  , currently_boosted_chat_id_()
  , start_date_()
  , expiration_date_()
  , cooldown_until_date_()
{}

chatBoostSlot::chatBoostSlot(int32 slot_id_, int53 currently_boosted_chat_id_, int32 start_date_, int32 expiration_date_, int32 cooldown_until_date_)
  : slot_id_(slot_id_)
  , currently_boosted_chat_id_(currently_boosted_chat_id_)
  , start_date_(start_date_)
  , expiration_date_(expiration_date_)
  , cooldown_until_date_(cooldown_until_date_)
{}

const std::int32_t chatBoostSlot::ID;

object_ptr<chatBoostSlot> chatBoostSlot::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostSlot> res = make_object<chatBoostSlot>();
  res->slot_id_ = env->GetIntField(p, res->slot_id_fieldID);
  res->currently_boosted_chat_id_ = env->GetLongField(p, res->currently_boosted_chat_id_fieldID);
  res->start_date_ = env->GetIntField(p, res->start_date_fieldID);
  res->expiration_date_ = env->GetIntField(p, res->expiration_date_fieldID);
  res->cooldown_until_date_ = env->GetIntField(p, res->cooldown_until_date_fieldID);
  return res;
}

void chatBoostSlot::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, slot_id_fieldID, slot_id_);
  env->SetLongField(s, currently_boosted_chat_id_fieldID, currently_boosted_chat_id_);
  env->SetIntField(s, start_date_fieldID, start_date_);
  env->SetIntField(s, expiration_date_fieldID, expiration_date_);
  env->SetIntField(s, cooldown_until_date_fieldID, cooldown_until_date_);
}

void chatBoostSlot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostSlot");
    s.store_field("slotId", slot_id_);
    s.store_field("currentlyBoostedChatId", currently_boosted_chat_id_);
    s.store_field("startDate", start_date_);
    s.store_field("expirationDate", expiration_date_);
    s.store_field("cooldownUntilDate", cooldown_until_date_);
    s.store_class_end();
  }
}

void chatBoostSlot::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSlot").c_str());
    slot_id_fieldID = jni::get_field_id(env, Class, "slotId", "I");
    currently_boosted_chat_id_fieldID = jni::get_field_id(env, Class, "currentlyBoostedChatId", "J");
    start_date_fieldID = jni::get_field_id(env, Class, "startDate", "I");
    expiration_date_fieldID = jni::get_field_id(env, Class, "expirationDate", "I");
    cooldown_until_date_fieldID = jni::get_field_id(env, Class, "cooldownUntilDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostSlots::Class;
jfieldID chatBoostSlots::slots_fieldID;

chatBoostSlots::chatBoostSlots()
  : slots_()
{}

chatBoostSlots::chatBoostSlots(array<object_ptr<chatBoostSlot>> &&slots_)
  : slots_(std::move(slots_))
{}

const std::int32_t chatBoostSlots::ID;

object_ptr<chatBoostSlots> chatBoostSlots::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostSlots> res = make_object<chatBoostSlots>();
  res->slots_ = jni::FetchVector<chatBoostSlot>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->slots_fieldID));
  return res;
}

void chatBoostSlots::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, slots_); if (arr_tmp_) { env->SetObjectField(s, slots_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatBoostSlots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostSlots");
    { s.store_vector_begin("slots", slots_.size()); for (const auto &_value : slots_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatBoostSlots::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSlots").c_str());
    slots_fieldID = jni::get_field_id(env, Class, "slots", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatBoostSlot;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatBoostSource::Class;

object_ptr<ChatBoostSource> ChatBoostSource::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatBoostSourceGiftCode::ID:
      return chatBoostSourceGiftCode::fetch(env, p);
    case chatBoostSourceGiveaway::ID:
      return chatBoostSourceGiveaway::fetch(env, p);
    case chatBoostSourcePremium::ID:
      return chatBoostSourcePremium::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatBoostSource::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSource").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostSourceGiftCode::Class;
jfieldID chatBoostSourceGiftCode::user_id_fieldID;
jfieldID chatBoostSourceGiftCode::gift_code_fieldID;

chatBoostSourceGiftCode::chatBoostSourceGiftCode()
  : user_id_()
  , gift_code_()
{}

chatBoostSourceGiftCode::chatBoostSourceGiftCode(int53 user_id_, string const &gift_code_)
  : user_id_(user_id_)
  , gift_code_(gift_code_)
{}

const std::int32_t chatBoostSourceGiftCode::ID;

object_ptr<ChatBoostSource> chatBoostSourceGiftCode::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostSourceGiftCode> res = make_object<chatBoostSourceGiftCode>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->gift_code_ = jni::fetch_string(env, p, res->gift_code_fieldID);
  return std::move(res);
}

void chatBoostSourceGiftCode::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  { jstring nextString = jni::to_jstring(env, gift_code_); if (nextString) { env->SetObjectField(s, gift_code_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatBoostSourceGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostSourceGiftCode");
    s.store_field("userId", user_id_);
    s.store_field("giftCode", gift_code_);
    s.store_class_end();
  }
}

void chatBoostSourceGiftCode::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSourceGiftCode").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    gift_code_fieldID = jni::get_field_id(env, Class, "giftCode", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostSourceGiveaway::Class;
jfieldID chatBoostSourceGiveaway::user_id_fieldID;
jfieldID chatBoostSourceGiveaway::gift_code_fieldID;
jfieldID chatBoostSourceGiveaway::star_count_fieldID;
jfieldID chatBoostSourceGiveaway::giveaway_message_id_fieldID;
jfieldID chatBoostSourceGiveaway::is_unclaimed_fieldID;

chatBoostSourceGiveaway::chatBoostSourceGiveaway()
  : user_id_()
  , gift_code_()
  , star_count_()
  , giveaway_message_id_()
  , is_unclaimed_()
{}

chatBoostSourceGiveaway::chatBoostSourceGiveaway(int53 user_id_, string const &gift_code_, int53 star_count_, int53 giveaway_message_id_, bool is_unclaimed_)
  : user_id_(user_id_)
  , gift_code_(gift_code_)
  , star_count_(star_count_)
  , giveaway_message_id_(giveaway_message_id_)
  , is_unclaimed_(is_unclaimed_)
{}

const std::int32_t chatBoostSourceGiveaway::ID;

object_ptr<ChatBoostSource> chatBoostSourceGiveaway::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostSourceGiveaway> res = make_object<chatBoostSourceGiveaway>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->gift_code_ = jni::fetch_string(env, p, res->gift_code_fieldID);
  res->star_count_ = env->GetLongField(p, res->star_count_fieldID);
  res->giveaway_message_id_ = env->GetLongField(p, res->giveaway_message_id_fieldID);
  res->is_unclaimed_ = (env->GetBooleanField(p, res->is_unclaimed_fieldID) != 0);
  return std::move(res);
}

void chatBoostSourceGiveaway::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  { jstring nextString = jni::to_jstring(env, gift_code_); if (nextString) { env->SetObjectField(s, gift_code_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetLongField(s, star_count_fieldID, star_count_);
  env->SetLongField(s, giveaway_message_id_fieldID, giveaway_message_id_);
  env->SetBooleanField(s, is_unclaimed_fieldID, is_unclaimed_);
}

void chatBoostSourceGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostSourceGiveaway");
    s.store_field("userId", user_id_);
    s.store_field("giftCode", gift_code_);
    s.store_field("starCount", star_count_);
    s.store_field("giveawayMessageId", giveaway_message_id_);
    s.store_field("isUnclaimed", is_unclaimed_);
    s.store_class_end();
  }
}

void chatBoostSourceGiveaway::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSourceGiveaway").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    gift_code_fieldID = jni::get_field_id(env, Class, "giftCode", "Ljava/lang/String;");
    star_count_fieldID = jni::get_field_id(env, Class, "starCount", "J");
    giveaway_message_id_fieldID = jni::get_field_id(env, Class, "giveawayMessageId", "J");
    is_unclaimed_fieldID = jni::get_field_id(env, Class, "isUnclaimed", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostSourcePremium::Class;
jfieldID chatBoostSourcePremium::user_id_fieldID;

chatBoostSourcePremium::chatBoostSourcePremium()
  : user_id_()
{}

chatBoostSourcePremium::chatBoostSourcePremium(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t chatBoostSourcePremium::ID;

object_ptr<ChatBoostSource> chatBoostSourcePremium::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostSourcePremium> res = make_object<chatBoostSourcePremium>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  return std::move(res);
}

void chatBoostSourcePremium::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
}

void chatBoostSourcePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostSourcePremium");
    s.store_field("userId", user_id_);
    s.store_class_end();
  }
}

void chatBoostSourcePremium::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostSourcePremium").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatBoostStatus::Class;
jfieldID chatBoostStatus::boost_url_fieldID;
jfieldID chatBoostStatus::applied_slot_ids_fieldID;
jfieldID chatBoostStatus::level_fieldID;
jfieldID chatBoostStatus::gift_code_boost_count_fieldID;
jfieldID chatBoostStatus::boost_count_fieldID;
jfieldID chatBoostStatus::current_level_boost_count_fieldID;
jfieldID chatBoostStatus::next_level_boost_count_fieldID;
jfieldID chatBoostStatus::premium_member_count_fieldID;
jfieldID chatBoostStatus::premium_member_percentage_fieldID;
jfieldID chatBoostStatus::prepaid_giveaways_fieldID;

chatBoostStatus::chatBoostStatus()
  : boost_url_()
  , applied_slot_ids_()
  , level_()
  , gift_code_boost_count_()
  , boost_count_()
  , current_level_boost_count_()
  , next_level_boost_count_()
  , premium_member_count_()
  , premium_member_percentage_()
  , prepaid_giveaways_()
{}

chatBoostStatus::chatBoostStatus(string const &boost_url_, array<int32> &&applied_slot_ids_, int32 level_, int32 gift_code_boost_count_, int32 boost_count_, int32 current_level_boost_count_, int32 next_level_boost_count_, int32 premium_member_count_, double premium_member_percentage_, array<object_ptr<prepaidGiveaway>> &&prepaid_giveaways_)
  : boost_url_(boost_url_)
  , applied_slot_ids_(std::move(applied_slot_ids_))
  , level_(level_)
  , gift_code_boost_count_(gift_code_boost_count_)
  , boost_count_(boost_count_)
  , current_level_boost_count_(current_level_boost_count_)
  , next_level_boost_count_(next_level_boost_count_)
  , premium_member_count_(premium_member_count_)
  , premium_member_percentage_(premium_member_percentage_)
  , prepaid_giveaways_(std::move(prepaid_giveaways_))
{}

const std::int32_t chatBoostStatus::ID;

object_ptr<chatBoostStatus> chatBoostStatus::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatBoostStatus> res = make_object<chatBoostStatus>();
  res->boost_url_ = jni::fetch_string(env, p, res->boost_url_fieldID);
  res->applied_slot_ids_ = jni::fetch_vector(env, (jintArray)jni::fetch_object(env, p, res->applied_slot_ids_fieldID));
  res->level_ = env->GetIntField(p, res->level_fieldID);
  res->gift_code_boost_count_ = env->GetIntField(p, res->gift_code_boost_count_fieldID);
  res->boost_count_ = env->GetIntField(p, res->boost_count_fieldID);
  res->current_level_boost_count_ = env->GetIntField(p, res->current_level_boost_count_fieldID);
  res->next_level_boost_count_ = env->GetIntField(p, res->next_level_boost_count_fieldID);
  res->premium_member_count_ = env->GetIntField(p, res->premium_member_count_fieldID);
  res->premium_member_percentage_ = env->GetDoubleField(p, res->premium_member_percentage_fieldID);
  res->prepaid_giveaways_ = jni::FetchVector<prepaidGiveaway>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->prepaid_giveaways_fieldID));
  return res;
}

void chatBoostStatus::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, boost_url_); if (nextString) { env->SetObjectField(s, boost_url_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { auto arr_tmp_ = jni::store_vector(env, applied_slot_ids_); if (arr_tmp_) { env->SetObjectField(s, applied_slot_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetIntField(s, level_fieldID, level_);
  env->SetIntField(s, gift_code_boost_count_fieldID, gift_code_boost_count_);
  env->SetIntField(s, boost_count_fieldID, boost_count_);
  env->SetIntField(s, current_level_boost_count_fieldID, current_level_boost_count_);
  env->SetIntField(s, next_level_boost_count_fieldID, next_level_boost_count_);
  env->SetIntField(s, premium_member_count_fieldID, premium_member_count_);
  env->SetDoubleField(s, premium_member_percentage_fieldID, premium_member_percentage_);
  { auto arr_tmp_ = jni::store_vector(env, prepaid_giveaways_); if (arr_tmp_) { env->SetObjectField(s, prepaid_giveaways_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatBoostStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatBoostStatus");
    s.store_field("boostUrl", boost_url_);
    { s.store_vector_begin("appliedSlotIds", applied_slot_ids_.size()); for (const auto &_value : applied_slot_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("level", level_);
    s.store_field("giftCodeBoostCount", gift_code_boost_count_);
    s.store_field("boostCount", boost_count_);
    s.store_field("currentLevelBoostCount", current_level_boost_count_);
    s.store_field("nextLevelBoostCount", next_level_boost_count_);
    s.store_field("premiumMemberCount", premium_member_count_);
    s.store_field("premiumMemberPercentage", premium_member_percentage_);
    { s.store_vector_begin("prepaidGiveaways", prepaid_giveaways_.size()); for (const auto &_value : prepaid_giveaways_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatBoostStatus::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatBoostStatus").c_str());
    boost_url_fieldID = jni::get_field_id(env, Class, "boostUrl", "Ljava/lang/String;");
    applied_slot_ids_fieldID = jni::get_field_id(env, Class, "appliedSlotIds", "[I");
    level_fieldID = jni::get_field_id(env, Class, "level", "I");
    gift_code_boost_count_fieldID = jni::get_field_id(env, Class, "giftCodeBoostCount", "I");
    boost_count_fieldID = jni::get_field_id(env, Class, "boostCount", "I");
    current_level_boost_count_fieldID = jni::get_field_id(env, Class, "currentLevelBoostCount", "I");
    next_level_boost_count_fieldID = jni::get_field_id(env, Class, "nextLevelBoostCount", "I");
    premium_member_count_fieldID = jni::get_field_id(env, Class, "premiumMemberCount", "I");
    premium_member_percentage_fieldID = jni::get_field_id(env, Class, "premiumMemberPercentage", "D");
    prepaid_giveaways_fieldID = jni::get_field_id(env, Class, "prepaidGiveaways", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$PrepaidGiveaway;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEvent::Class;
jfieldID chatEvent::id_fieldID;
jfieldID chatEvent::date_fieldID;
jfieldID chatEvent::member_id_fieldID;
jfieldID chatEvent::action_fieldID;

chatEvent::chatEvent()
  : id_()
  , date_()
  , member_id_()
  , action_()
{}

chatEvent::chatEvent(int64 id_, int32 date_, object_ptr<MessageSender> &&member_id_, object_ptr<ChatEventAction> &&action_)
  : id_(id_)
  , date_(date_)
  , member_id_(std::move(member_id_))
  , action_(std::move(action_))
{}

const std::int32_t chatEvent::ID;

object_ptr<chatEvent> chatEvent::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEvent> res = make_object<chatEvent>();
  res->id_ = env->GetLongField(p, res->id_fieldID);
  res->date_ = env->GetIntField(p, res->date_fieldID);
  res->member_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->member_id_fieldID));
  res->action_ = jni::fetch_tl_object<ChatEventAction>(env, jni::fetch_object(env, p, res->action_fieldID));
  return res;
}

void chatEvent::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, id_fieldID, id_);
  env->SetIntField(s, date_fieldID, date_);
  if (member_id_ != nullptr) { jobject next; member_id_->store(env, next); if (next) { env->SetObjectField(s, member_id_fieldID, next); env->DeleteLocalRef(next); } }
  if (action_ != nullptr) { jobject next; action_->store(env, next); if (next) { env->SetObjectField(s, action_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEvent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEvent");
    s.store_field("id", id_);
    s.store_field("date", date_);
    s.store_object_field("memberId", static_cast<const BaseObject *>(member_id_.get()));
    s.store_object_field("action", static_cast<const BaseObject *>(action_.get()));
    s.store_class_end();
  }
}

void chatEvent::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEvent").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "J");
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    member_id_fieldID = jni::get_field_id(env, Class, "memberId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    action_fieldID = jni::get_field_id(env, Class, "action", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatEventAction;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatEventAction::Class;

object_ptr<ChatEventAction> ChatEventAction::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatEventMessageEdited::ID:
      return chatEventMessageEdited::fetch(env, p);
    case chatEventMessageDeleted::ID:
      return chatEventMessageDeleted::fetch(env, p);
    case chatEventMessagePinned::ID:
      return chatEventMessagePinned::fetch(env, p);
    case chatEventMessageUnpinned::ID:
      return chatEventMessageUnpinned::fetch(env, p);
    case chatEventPollStopped::ID:
      return chatEventPollStopped::fetch(env, p);
    case chatEventMemberJoined::ID:
      return chatEventMemberJoined::fetch(env, p);
    case chatEventMemberJoinedByInviteLink::ID:
      return chatEventMemberJoinedByInviteLink::fetch(env, p);
    case chatEventMemberJoinedByRequest::ID:
      return chatEventMemberJoinedByRequest::fetch(env, p);
    case chatEventMemberInvited::ID:
      return chatEventMemberInvited::fetch(env, p);
    case chatEventMemberLeft::ID:
      return chatEventMemberLeft::fetch(env, p);
    case chatEventMemberPromoted::ID:
      return chatEventMemberPromoted::fetch(env, p);
    case chatEventMemberRestricted::ID:
      return chatEventMemberRestricted::fetch(env, p);
    case chatEventMemberSubscriptionExtended::ID:
      return chatEventMemberSubscriptionExtended::fetch(env, p);
    case chatEventAvailableReactionsChanged::ID:
      return chatEventAvailableReactionsChanged::fetch(env, p);
    case chatEventBackgroundChanged::ID:
      return chatEventBackgroundChanged::fetch(env, p);
    case chatEventDescriptionChanged::ID:
      return chatEventDescriptionChanged::fetch(env, p);
    case chatEventEmojiStatusChanged::ID:
      return chatEventEmojiStatusChanged::fetch(env, p);
    case chatEventLinkedChatChanged::ID:
      return chatEventLinkedChatChanged::fetch(env, p);
    case chatEventLocationChanged::ID:
      return chatEventLocationChanged::fetch(env, p);
    case chatEventMessageAutoDeleteTimeChanged::ID:
      return chatEventMessageAutoDeleteTimeChanged::fetch(env, p);
    case chatEventPermissionsChanged::ID:
      return chatEventPermissionsChanged::fetch(env, p);
    case chatEventPhotoChanged::ID:
      return chatEventPhotoChanged::fetch(env, p);
    case chatEventSlowModeDelayChanged::ID:
      return chatEventSlowModeDelayChanged::fetch(env, p);
    case chatEventStickerSetChanged::ID:
      return chatEventStickerSetChanged::fetch(env, p);
    case chatEventCustomEmojiStickerSetChanged::ID:
      return chatEventCustomEmojiStickerSetChanged::fetch(env, p);
    case chatEventTitleChanged::ID:
      return chatEventTitleChanged::fetch(env, p);
    case chatEventUsernameChanged::ID:
      return chatEventUsernameChanged::fetch(env, p);
    case chatEventActiveUsernamesChanged::ID:
      return chatEventActiveUsernamesChanged::fetch(env, p);
    case chatEventAccentColorChanged::ID:
      return chatEventAccentColorChanged::fetch(env, p);
    case chatEventProfileAccentColorChanged::ID:
      return chatEventProfileAccentColorChanged::fetch(env, p);
    case chatEventHasProtectedContentToggled::ID:
      return chatEventHasProtectedContentToggled::fetch(env, p);
    case chatEventInvitesToggled::ID:
      return chatEventInvitesToggled::fetch(env, p);
    case chatEventIsAllHistoryAvailableToggled::ID:
      return chatEventIsAllHistoryAvailableToggled::fetch(env, p);
    case chatEventHasAggressiveAntiSpamEnabledToggled::ID:
      return chatEventHasAggressiveAntiSpamEnabledToggled::fetch(env, p);
    case chatEventSignMessagesToggled::ID:
      return chatEventSignMessagesToggled::fetch(env, p);
    case chatEventShowMessageSenderToggled::ID:
      return chatEventShowMessageSenderToggled::fetch(env, p);
    case chatEventAutomaticTranslationToggled::ID:
      return chatEventAutomaticTranslationToggled::fetch(env, p);
    case chatEventInviteLinkEdited::ID:
      return chatEventInviteLinkEdited::fetch(env, p);
    case chatEventInviteLinkRevoked::ID:
      return chatEventInviteLinkRevoked::fetch(env, p);
    case chatEventInviteLinkDeleted::ID:
      return chatEventInviteLinkDeleted::fetch(env, p);
    case chatEventVideoChatCreated::ID:
      return chatEventVideoChatCreated::fetch(env, p);
    case chatEventVideoChatEnded::ID:
      return chatEventVideoChatEnded::fetch(env, p);
    case chatEventVideoChatMuteNewParticipantsToggled::ID:
      return chatEventVideoChatMuteNewParticipantsToggled::fetch(env, p);
    case chatEventVideoChatParticipantIsMutedToggled::ID:
      return chatEventVideoChatParticipantIsMutedToggled::fetch(env, p);
    case chatEventVideoChatParticipantVolumeLevelChanged::ID:
      return chatEventVideoChatParticipantVolumeLevelChanged::fetch(env, p);
    case chatEventIsForumToggled::ID:
      return chatEventIsForumToggled::fetch(env, p);
    case chatEventForumTopicCreated::ID:
      return chatEventForumTopicCreated::fetch(env, p);
    case chatEventForumTopicEdited::ID:
      return chatEventForumTopicEdited::fetch(env, p);
    case chatEventForumTopicToggleIsClosed::ID:
      return chatEventForumTopicToggleIsClosed::fetch(env, p);
    case chatEventForumTopicToggleIsHidden::ID:
      return chatEventForumTopicToggleIsHidden::fetch(env, p);
    case chatEventForumTopicDeleted::ID:
      return chatEventForumTopicDeleted::fetch(env, p);
    case chatEventForumTopicPinned::ID:
      return chatEventForumTopicPinned::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatEventAction::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventAction").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMessageEdited::Class;
jfieldID chatEventMessageEdited::old_message_fieldID;
jfieldID chatEventMessageEdited::new_message_fieldID;

chatEventMessageEdited::chatEventMessageEdited()
  : old_message_()
  , new_message_()
{}

chatEventMessageEdited::chatEventMessageEdited(object_ptr<message> &&old_message_, object_ptr<message> &&new_message_)
  : old_message_(std::move(old_message_))
  , new_message_(std::move(new_message_))
{}

const std::int32_t chatEventMessageEdited::ID;

object_ptr<ChatEventAction> chatEventMessageEdited::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMessageEdited> res = make_object<chatEventMessageEdited>();
  res->old_message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->old_message_fieldID));
  res->new_message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->new_message_fieldID));
  return std::move(res);
}

void chatEventMessageEdited::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_message_ != nullptr) { jobject next; old_message_->store(env, next); if (next) { env->SetObjectField(s, old_message_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_message_ != nullptr) { jobject next; new_message_->store(env, next); if (next) { env->SetObjectField(s, new_message_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMessageEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMessageEdited");
    s.store_object_field("oldMessage", static_cast<const BaseObject *>(old_message_.get()));
    s.store_object_field("newMessage", static_cast<const BaseObject *>(new_message_.get()));
    s.store_class_end();
  }
}

void chatEventMessageEdited::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMessageEdited").c_str());
    old_message_fieldID = jni::get_field_id(env, Class, "oldMessage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    new_message_fieldID = jni::get_field_id(env, Class, "newMessage", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMessageDeleted::Class;
jfieldID chatEventMessageDeleted::message_fieldID;
jfieldID chatEventMessageDeleted::can_report_anti_spam_false_positive_fieldID;

chatEventMessageDeleted::chatEventMessageDeleted()
  : message_()
  , can_report_anti_spam_false_positive_()
{}

chatEventMessageDeleted::chatEventMessageDeleted(object_ptr<message> &&message_, bool can_report_anti_spam_false_positive_)
  : message_(std::move(message_))
  , can_report_anti_spam_false_positive_(can_report_anti_spam_false_positive_)
{}

const std::int32_t chatEventMessageDeleted::ID;

object_ptr<ChatEventAction> chatEventMessageDeleted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMessageDeleted> res = make_object<chatEventMessageDeleted>();
  res->message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->message_fieldID));
  res->can_report_anti_spam_false_positive_ = (env->GetBooleanField(p, res->can_report_anti_spam_false_positive_fieldID) != 0);
  return std::move(res);
}

void chatEventMessageDeleted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (message_ != nullptr) { jobject next; message_->store(env, next); if (next) { env->SetObjectField(s, message_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, can_report_anti_spam_false_positive_fieldID, can_report_anti_spam_false_positive_);
}

void chatEventMessageDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMessageDeleted");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_field("canReportAntiSpamFalsePositive", can_report_anti_spam_false_positive_);
    s.store_class_end();
  }
}

void chatEventMessageDeleted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMessageDeleted").c_str());
    message_fieldID = jni::get_field_id(env, Class, "message", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    can_report_anti_spam_false_positive_fieldID = jni::get_field_id(env, Class, "canReportAntiSpamFalsePositive", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMessagePinned::Class;
jfieldID chatEventMessagePinned::message_fieldID;

chatEventMessagePinned::chatEventMessagePinned()
  : message_()
{}

chatEventMessagePinned::chatEventMessagePinned(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventMessagePinned::ID;

object_ptr<ChatEventAction> chatEventMessagePinned::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMessagePinned> res = make_object<chatEventMessagePinned>();
  res->message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->message_fieldID));
  return std::move(res);
}

void chatEventMessagePinned::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (message_ != nullptr) { jobject next; message_->store(env, next); if (next) { env->SetObjectField(s, message_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMessagePinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMessagePinned");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

void chatEventMessagePinned::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMessagePinned").c_str());
    message_fieldID = jni::get_field_id(env, Class, "message", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMessageUnpinned::Class;
jfieldID chatEventMessageUnpinned::message_fieldID;

chatEventMessageUnpinned::chatEventMessageUnpinned()
  : message_()
{}

chatEventMessageUnpinned::chatEventMessageUnpinned(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventMessageUnpinned::ID;

object_ptr<ChatEventAction> chatEventMessageUnpinned::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMessageUnpinned> res = make_object<chatEventMessageUnpinned>();
  res->message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->message_fieldID));
  return std::move(res);
}

void chatEventMessageUnpinned::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (message_ != nullptr) { jobject next; message_->store(env, next); if (next) { env->SetObjectField(s, message_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMessageUnpinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMessageUnpinned");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

void chatEventMessageUnpinned::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMessageUnpinned").c_str());
    message_fieldID = jni::get_field_id(env, Class, "message", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventPollStopped::Class;
jfieldID chatEventPollStopped::message_fieldID;

chatEventPollStopped::chatEventPollStopped()
  : message_()
{}

chatEventPollStopped::chatEventPollStopped(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventPollStopped::ID;

object_ptr<ChatEventAction> chatEventPollStopped::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventPollStopped> res = make_object<chatEventPollStopped>();
  res->message_ = jni::fetch_tl_object<message>(env, jni::fetch_object(env, p, res->message_fieldID));
  return std::move(res);
}

void chatEventPollStopped::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (message_ != nullptr) { jobject next; message_->store(env, next); if (next) { env->SetObjectField(s, message_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventPollStopped::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventPollStopped");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

void chatEventPollStopped::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventPollStopped").c_str());
    message_fieldID = jni::get_field_id(env, Class, "message", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Message;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberJoined::Class;

chatEventMemberJoined::chatEventMemberJoined() {
}

const std::int32_t chatEventMemberJoined::ID;

object_ptr<ChatEventAction> chatEventMemberJoined::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatEventMemberJoined>();
}

void chatEventMemberJoined::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatEventMemberJoined::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberJoined");
    s.store_class_end();
  }
}

void chatEventMemberJoined::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberJoined").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberJoinedByInviteLink::Class;
jfieldID chatEventMemberJoinedByInviteLink::invite_link_fieldID;
jfieldID chatEventMemberJoinedByInviteLink::via_chat_folder_invite_link_fieldID;

chatEventMemberJoinedByInviteLink::chatEventMemberJoinedByInviteLink()
  : invite_link_()
  , via_chat_folder_invite_link_()
{}

chatEventMemberJoinedByInviteLink::chatEventMemberJoinedByInviteLink(object_ptr<chatInviteLink> &&invite_link_, bool via_chat_folder_invite_link_)
  : invite_link_(std::move(invite_link_))
  , via_chat_folder_invite_link_(via_chat_folder_invite_link_)
{}

const std::int32_t chatEventMemberJoinedByInviteLink::ID;

object_ptr<ChatEventAction> chatEventMemberJoinedByInviteLink::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberJoinedByInviteLink> res = make_object<chatEventMemberJoinedByInviteLink>();
  res->invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->invite_link_fieldID));
  res->via_chat_folder_invite_link_ = (env->GetBooleanField(p, res->via_chat_folder_invite_link_fieldID) != 0);
  return std::move(res);
}

void chatEventMemberJoinedByInviteLink::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (invite_link_ != nullptr) { jobject next; invite_link_->store(env, next); if (next) { env->SetObjectField(s, invite_link_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, via_chat_folder_invite_link_fieldID, via_chat_folder_invite_link_);
}

void chatEventMemberJoinedByInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberJoinedByInviteLink");
    s.store_object_field("inviteLink", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_field("viaChatFolderInviteLink", via_chat_folder_invite_link_);
    s.store_class_end();
  }
}

void chatEventMemberJoinedByInviteLink::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberJoinedByInviteLink").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    via_chat_folder_invite_link_fieldID = jni::get_field_id(env, Class, "viaChatFolderInviteLink", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberJoinedByRequest::Class;
jfieldID chatEventMemberJoinedByRequest::approver_user_id_fieldID;
jfieldID chatEventMemberJoinedByRequest::invite_link_fieldID;

chatEventMemberJoinedByRequest::chatEventMemberJoinedByRequest()
  : approver_user_id_()
  , invite_link_()
{}

chatEventMemberJoinedByRequest::chatEventMemberJoinedByRequest(int53 approver_user_id_, object_ptr<chatInviteLink> &&invite_link_)
  : approver_user_id_(approver_user_id_)
  , invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventMemberJoinedByRequest::ID;

object_ptr<ChatEventAction> chatEventMemberJoinedByRequest::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberJoinedByRequest> res = make_object<chatEventMemberJoinedByRequest>();
  res->approver_user_id_ = env->GetLongField(p, res->approver_user_id_fieldID);
  res->invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->invite_link_fieldID));
  return std::move(res);
}

void chatEventMemberJoinedByRequest::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, approver_user_id_fieldID, approver_user_id_);
  if (invite_link_ != nullptr) { jobject next; invite_link_->store(env, next); if (next) { env->SetObjectField(s, invite_link_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMemberJoinedByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberJoinedByRequest");
    s.store_field("approverUserId", approver_user_id_);
    s.store_object_field("inviteLink", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

void chatEventMemberJoinedByRequest::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberJoinedByRequest").c_str());
    approver_user_id_fieldID = jni::get_field_id(env, Class, "approverUserId", "J");
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberInvited::Class;
jfieldID chatEventMemberInvited::user_id_fieldID;
jfieldID chatEventMemberInvited::status_fieldID;

chatEventMemberInvited::chatEventMemberInvited()
  : user_id_()
  , status_()
{}

chatEventMemberInvited::chatEventMemberInvited(int53 user_id_, object_ptr<ChatMemberStatus> &&status_)
  : user_id_(user_id_)
  , status_(std::move(status_))
{}

const std::int32_t chatEventMemberInvited::ID;

object_ptr<ChatEventAction> chatEventMemberInvited::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberInvited> res = make_object<chatEventMemberInvited>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->status_fieldID));
  return std::move(res);
}

void chatEventMemberInvited::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  if (status_ != nullptr) { jobject next; status_->store(env, next); if (next) { env->SetObjectField(s, status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMemberInvited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberInvited");
    s.store_field("userId", user_id_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_class_end();
  }
}

void chatEventMemberInvited::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberInvited").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    status_fieldID = jni::get_field_id(env, Class, "status", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberLeft::Class;

chatEventMemberLeft::chatEventMemberLeft() {
}

const std::int32_t chatEventMemberLeft::ID;

object_ptr<ChatEventAction> chatEventMemberLeft::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatEventMemberLeft>();
}

void chatEventMemberLeft::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatEventMemberLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberLeft");
    s.store_class_end();
  }
}

void chatEventMemberLeft::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberLeft").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberPromoted::Class;
jfieldID chatEventMemberPromoted::user_id_fieldID;
jfieldID chatEventMemberPromoted::old_status_fieldID;
jfieldID chatEventMemberPromoted::new_status_fieldID;

chatEventMemberPromoted::chatEventMemberPromoted()
  : user_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberPromoted::chatEventMemberPromoted(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : user_id_(user_id_)
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberPromoted::ID;

object_ptr<ChatEventAction> chatEventMemberPromoted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberPromoted> res = make_object<chatEventMemberPromoted>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->old_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->old_status_fieldID));
  res->new_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->new_status_fieldID));
  return std::move(res);
}

void chatEventMemberPromoted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  if (old_status_ != nullptr) { jobject next; old_status_->store(env, next); if (next) { env->SetObjectField(s, old_status_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_status_ != nullptr) { jobject next; new_status_->store(env, next); if (next) { env->SetObjectField(s, new_status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMemberPromoted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberPromoted");
    s.store_field("userId", user_id_);
    s.store_object_field("oldStatus", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("newStatus", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

void chatEventMemberPromoted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberPromoted").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    old_status_fieldID = jni::get_field_id(env, Class, "oldStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    new_status_fieldID = jni::get_field_id(env, Class, "newStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberRestricted::Class;
jfieldID chatEventMemberRestricted::member_id_fieldID;
jfieldID chatEventMemberRestricted::old_status_fieldID;
jfieldID chatEventMemberRestricted::new_status_fieldID;

chatEventMemberRestricted::chatEventMemberRestricted()
  : member_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberRestricted::chatEventMemberRestricted(object_ptr<MessageSender> &&member_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : member_id_(std::move(member_id_))
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberRestricted::ID;

object_ptr<ChatEventAction> chatEventMemberRestricted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberRestricted> res = make_object<chatEventMemberRestricted>();
  res->member_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->member_id_fieldID));
  res->old_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->old_status_fieldID));
  res->new_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->new_status_fieldID));
  return std::move(res);
}

void chatEventMemberRestricted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (member_id_ != nullptr) { jobject next; member_id_->store(env, next); if (next) { env->SetObjectField(s, member_id_fieldID, next); env->DeleteLocalRef(next); } }
  if (old_status_ != nullptr) { jobject next; old_status_->store(env, next); if (next) { env->SetObjectField(s, old_status_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_status_ != nullptr) { jobject next; new_status_->store(env, next); if (next) { env->SetObjectField(s, new_status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMemberRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberRestricted");
    s.store_object_field("memberId", static_cast<const BaseObject *>(member_id_.get()));
    s.store_object_field("oldStatus", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("newStatus", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

void chatEventMemberRestricted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberRestricted").c_str());
    member_id_fieldID = jni::get_field_id(env, Class, "memberId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    old_status_fieldID = jni::get_field_id(env, Class, "oldStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    new_status_fieldID = jni::get_field_id(env, Class, "newStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMemberSubscriptionExtended::Class;
jfieldID chatEventMemberSubscriptionExtended::user_id_fieldID;
jfieldID chatEventMemberSubscriptionExtended::old_status_fieldID;
jfieldID chatEventMemberSubscriptionExtended::new_status_fieldID;

chatEventMemberSubscriptionExtended::chatEventMemberSubscriptionExtended()
  : user_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberSubscriptionExtended::chatEventMemberSubscriptionExtended(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : user_id_(user_id_)
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberSubscriptionExtended::ID;

object_ptr<ChatEventAction> chatEventMemberSubscriptionExtended::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMemberSubscriptionExtended> res = make_object<chatEventMemberSubscriptionExtended>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->old_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->old_status_fieldID));
  res->new_status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->new_status_fieldID));
  return std::move(res);
}

void chatEventMemberSubscriptionExtended::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  if (old_status_ != nullptr) { jobject next; old_status_->store(env, next); if (next) { env->SetObjectField(s, old_status_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_status_ != nullptr) { jobject next; new_status_->store(env, next); if (next) { env->SetObjectField(s, new_status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventMemberSubscriptionExtended::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMemberSubscriptionExtended");
    s.store_field("userId", user_id_);
    s.store_object_field("oldStatus", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("newStatus", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

void chatEventMemberSubscriptionExtended::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMemberSubscriptionExtended").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    old_status_fieldID = jni::get_field_id(env, Class, "oldStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    new_status_fieldID = jni::get_field_id(env, Class, "newStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventAvailableReactionsChanged::Class;
jfieldID chatEventAvailableReactionsChanged::old_available_reactions_fieldID;
jfieldID chatEventAvailableReactionsChanged::new_available_reactions_fieldID;

chatEventAvailableReactionsChanged::chatEventAvailableReactionsChanged()
  : old_available_reactions_()
  , new_available_reactions_()
{}

chatEventAvailableReactionsChanged::chatEventAvailableReactionsChanged(object_ptr<ChatAvailableReactions> &&old_available_reactions_, object_ptr<ChatAvailableReactions> &&new_available_reactions_)
  : old_available_reactions_(std::move(old_available_reactions_))
  , new_available_reactions_(std::move(new_available_reactions_))
{}

const std::int32_t chatEventAvailableReactionsChanged::ID;

object_ptr<ChatEventAction> chatEventAvailableReactionsChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventAvailableReactionsChanged> res = make_object<chatEventAvailableReactionsChanged>();
  res->old_available_reactions_ = jni::fetch_tl_object<ChatAvailableReactions>(env, jni::fetch_object(env, p, res->old_available_reactions_fieldID));
  res->new_available_reactions_ = jni::fetch_tl_object<ChatAvailableReactions>(env, jni::fetch_object(env, p, res->new_available_reactions_fieldID));
  return std::move(res);
}

void chatEventAvailableReactionsChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_available_reactions_ != nullptr) { jobject next; old_available_reactions_->store(env, next); if (next) { env->SetObjectField(s, old_available_reactions_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_available_reactions_ != nullptr) { jobject next; new_available_reactions_->store(env, next); if (next) { env->SetObjectField(s, new_available_reactions_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventAvailableReactionsChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventAvailableReactionsChanged");
    s.store_object_field("oldAvailableReactions", static_cast<const BaseObject *>(old_available_reactions_.get()));
    s.store_object_field("newAvailableReactions", static_cast<const BaseObject *>(new_available_reactions_.get()));
    s.store_class_end();
  }
}

void chatEventAvailableReactionsChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventAvailableReactionsChanged").c_str());
    old_available_reactions_fieldID = jni::get_field_id(env, Class, "oldAvailableReactions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAvailableReactions;").c_str());
    new_available_reactions_fieldID = jni::get_field_id(env, Class, "newAvailableReactions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAvailableReactions;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventBackgroundChanged::Class;
jfieldID chatEventBackgroundChanged::old_background_fieldID;
jfieldID chatEventBackgroundChanged::new_background_fieldID;

chatEventBackgroundChanged::chatEventBackgroundChanged()
  : old_background_()
  , new_background_()
{}

chatEventBackgroundChanged::chatEventBackgroundChanged(object_ptr<chatBackground> &&old_background_, object_ptr<chatBackground> &&new_background_)
  : old_background_(std::move(old_background_))
  , new_background_(std::move(new_background_))
{}

const std::int32_t chatEventBackgroundChanged::ID;

object_ptr<ChatEventAction> chatEventBackgroundChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventBackgroundChanged> res = make_object<chatEventBackgroundChanged>();
  res->old_background_ = jni::fetch_tl_object<chatBackground>(env, jni::fetch_object(env, p, res->old_background_fieldID));
  res->new_background_ = jni::fetch_tl_object<chatBackground>(env, jni::fetch_object(env, p, res->new_background_fieldID));
  return std::move(res);
}

void chatEventBackgroundChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_background_ != nullptr) { jobject next; old_background_->store(env, next); if (next) { env->SetObjectField(s, old_background_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_background_ != nullptr) { jobject next; new_background_->store(env, next); if (next) { env->SetObjectField(s, new_background_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventBackgroundChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventBackgroundChanged");
    s.store_object_field("oldBackground", static_cast<const BaseObject *>(old_background_.get()));
    s.store_object_field("newBackground", static_cast<const BaseObject *>(new_background_.get()));
    s.store_class_end();
  }
}

void chatEventBackgroundChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventBackgroundChanged").c_str());
    old_background_fieldID = jni::get_field_id(env, Class, "oldBackground", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatBackground;").c_str());
    new_background_fieldID = jni::get_field_id(env, Class, "newBackground", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatBackground;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventDescriptionChanged::Class;
jfieldID chatEventDescriptionChanged::old_description_fieldID;
jfieldID chatEventDescriptionChanged::new_description_fieldID;

chatEventDescriptionChanged::chatEventDescriptionChanged()
  : old_description_()
  , new_description_()
{}

chatEventDescriptionChanged::chatEventDescriptionChanged(string const &old_description_, string const &new_description_)
  : old_description_(old_description_)
  , new_description_(new_description_)
{}

const std::int32_t chatEventDescriptionChanged::ID;

object_ptr<ChatEventAction> chatEventDescriptionChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventDescriptionChanged> res = make_object<chatEventDescriptionChanged>();
  res->old_description_ = jni::fetch_string(env, p, res->old_description_fieldID);
  res->new_description_ = jni::fetch_string(env, p, res->new_description_fieldID);
  return std::move(res);
}

void chatEventDescriptionChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, old_description_); if (nextString) { env->SetObjectField(s, old_description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, new_description_); if (nextString) { env->SetObjectField(s, new_description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatEventDescriptionChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventDescriptionChanged");
    s.store_field("oldDescription", old_description_);
    s.store_field("newDescription", new_description_);
    s.store_class_end();
  }
}

void chatEventDescriptionChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventDescriptionChanged").c_str());
    old_description_fieldID = jni::get_field_id(env, Class, "oldDescription", "Ljava/lang/String;");
    new_description_fieldID = jni::get_field_id(env, Class, "newDescription", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventEmojiStatusChanged::Class;
jfieldID chatEventEmojiStatusChanged::old_emoji_status_fieldID;
jfieldID chatEventEmojiStatusChanged::new_emoji_status_fieldID;

chatEventEmojiStatusChanged::chatEventEmojiStatusChanged()
  : old_emoji_status_()
  , new_emoji_status_()
{}

chatEventEmojiStatusChanged::chatEventEmojiStatusChanged(object_ptr<emojiStatus> &&old_emoji_status_, object_ptr<emojiStatus> &&new_emoji_status_)
  : old_emoji_status_(std::move(old_emoji_status_))
  , new_emoji_status_(std::move(new_emoji_status_))
{}

const std::int32_t chatEventEmojiStatusChanged::ID;

object_ptr<ChatEventAction> chatEventEmojiStatusChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventEmojiStatusChanged> res = make_object<chatEventEmojiStatusChanged>();
  res->old_emoji_status_ = jni::fetch_tl_object<emojiStatus>(env, jni::fetch_object(env, p, res->old_emoji_status_fieldID));
  res->new_emoji_status_ = jni::fetch_tl_object<emojiStatus>(env, jni::fetch_object(env, p, res->new_emoji_status_fieldID));
  return std::move(res);
}

void chatEventEmojiStatusChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_emoji_status_ != nullptr) { jobject next; old_emoji_status_->store(env, next); if (next) { env->SetObjectField(s, old_emoji_status_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_emoji_status_ != nullptr) { jobject next; new_emoji_status_->store(env, next); if (next) { env->SetObjectField(s, new_emoji_status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventEmojiStatusChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventEmojiStatusChanged");
    s.store_object_field("oldEmojiStatus", static_cast<const BaseObject *>(old_emoji_status_.get()));
    s.store_object_field("newEmojiStatus", static_cast<const BaseObject *>(new_emoji_status_.get()));
    s.store_class_end();
  }
}

void chatEventEmojiStatusChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventEmojiStatusChanged").c_str());
    old_emoji_status_fieldID = jni::get_field_id(env, Class, "oldEmojiStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$EmojiStatus;").c_str());
    new_emoji_status_fieldID = jni::get_field_id(env, Class, "newEmojiStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$EmojiStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventLinkedChatChanged::Class;
jfieldID chatEventLinkedChatChanged::old_linked_chat_id_fieldID;
jfieldID chatEventLinkedChatChanged::new_linked_chat_id_fieldID;

chatEventLinkedChatChanged::chatEventLinkedChatChanged()
  : old_linked_chat_id_()
  , new_linked_chat_id_()
{}

chatEventLinkedChatChanged::chatEventLinkedChatChanged(int53 old_linked_chat_id_, int53 new_linked_chat_id_)
  : old_linked_chat_id_(old_linked_chat_id_)
  , new_linked_chat_id_(new_linked_chat_id_)
{}

const std::int32_t chatEventLinkedChatChanged::ID;

object_ptr<ChatEventAction> chatEventLinkedChatChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventLinkedChatChanged> res = make_object<chatEventLinkedChatChanged>();
  res->old_linked_chat_id_ = env->GetLongField(p, res->old_linked_chat_id_fieldID);
  res->new_linked_chat_id_ = env->GetLongField(p, res->new_linked_chat_id_fieldID);
  return std::move(res);
}

void chatEventLinkedChatChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, old_linked_chat_id_fieldID, old_linked_chat_id_);
  env->SetLongField(s, new_linked_chat_id_fieldID, new_linked_chat_id_);
}

void chatEventLinkedChatChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventLinkedChatChanged");
    s.store_field("oldLinkedChatId", old_linked_chat_id_);
    s.store_field("newLinkedChatId", new_linked_chat_id_);
    s.store_class_end();
  }
}

void chatEventLinkedChatChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventLinkedChatChanged").c_str());
    old_linked_chat_id_fieldID = jni::get_field_id(env, Class, "oldLinkedChatId", "J");
    new_linked_chat_id_fieldID = jni::get_field_id(env, Class, "newLinkedChatId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventLocationChanged::Class;
jfieldID chatEventLocationChanged::old_location_fieldID;
jfieldID chatEventLocationChanged::new_location_fieldID;

chatEventLocationChanged::chatEventLocationChanged()
  : old_location_()
  , new_location_()
{}

chatEventLocationChanged::chatEventLocationChanged(object_ptr<chatLocation> &&old_location_, object_ptr<chatLocation> &&new_location_)
  : old_location_(std::move(old_location_))
  , new_location_(std::move(new_location_))
{}

const std::int32_t chatEventLocationChanged::ID;

object_ptr<ChatEventAction> chatEventLocationChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventLocationChanged> res = make_object<chatEventLocationChanged>();
  res->old_location_ = jni::fetch_tl_object<chatLocation>(env, jni::fetch_object(env, p, res->old_location_fieldID));
  res->new_location_ = jni::fetch_tl_object<chatLocation>(env, jni::fetch_object(env, p, res->new_location_fieldID));
  return std::move(res);
}

void chatEventLocationChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_location_ != nullptr) { jobject next; old_location_->store(env, next); if (next) { env->SetObjectField(s, old_location_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_location_ != nullptr) { jobject next; new_location_->store(env, next); if (next) { env->SetObjectField(s, new_location_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventLocationChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventLocationChanged");
    s.store_object_field("oldLocation", static_cast<const BaseObject *>(old_location_.get()));
    s.store_object_field("newLocation", static_cast<const BaseObject *>(new_location_.get()));
    s.store_class_end();
  }
}

void chatEventLocationChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventLocationChanged").c_str());
    old_location_fieldID = jni::get_field_id(env, Class, "oldLocation", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatLocation;").c_str());
    new_location_fieldID = jni::get_field_id(env, Class, "newLocation", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatLocation;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventMessageAutoDeleteTimeChanged::Class;
jfieldID chatEventMessageAutoDeleteTimeChanged::old_message_auto_delete_time_fieldID;
jfieldID chatEventMessageAutoDeleteTimeChanged::new_message_auto_delete_time_fieldID;

chatEventMessageAutoDeleteTimeChanged::chatEventMessageAutoDeleteTimeChanged()
  : old_message_auto_delete_time_()
  , new_message_auto_delete_time_()
{}

chatEventMessageAutoDeleteTimeChanged::chatEventMessageAutoDeleteTimeChanged(int32 old_message_auto_delete_time_, int32 new_message_auto_delete_time_)
  : old_message_auto_delete_time_(old_message_auto_delete_time_)
  , new_message_auto_delete_time_(new_message_auto_delete_time_)
{}

const std::int32_t chatEventMessageAutoDeleteTimeChanged::ID;

object_ptr<ChatEventAction> chatEventMessageAutoDeleteTimeChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventMessageAutoDeleteTimeChanged> res = make_object<chatEventMessageAutoDeleteTimeChanged>();
  res->old_message_auto_delete_time_ = env->GetIntField(p, res->old_message_auto_delete_time_fieldID);
  res->new_message_auto_delete_time_ = env->GetIntField(p, res->new_message_auto_delete_time_fieldID);
  return std::move(res);
}

void chatEventMessageAutoDeleteTimeChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, old_message_auto_delete_time_fieldID, old_message_auto_delete_time_);
  env->SetIntField(s, new_message_auto_delete_time_fieldID, new_message_auto_delete_time_);
}

void chatEventMessageAutoDeleteTimeChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventMessageAutoDeleteTimeChanged");
    s.store_field("oldMessageAutoDeleteTime", old_message_auto_delete_time_);
    s.store_field("newMessageAutoDeleteTime", new_message_auto_delete_time_);
    s.store_class_end();
  }
}

void chatEventMessageAutoDeleteTimeChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventMessageAutoDeleteTimeChanged").c_str());
    old_message_auto_delete_time_fieldID = jni::get_field_id(env, Class, "oldMessageAutoDeleteTime", "I");
    new_message_auto_delete_time_fieldID = jni::get_field_id(env, Class, "newMessageAutoDeleteTime", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventPermissionsChanged::Class;
jfieldID chatEventPermissionsChanged::old_permissions_fieldID;
jfieldID chatEventPermissionsChanged::new_permissions_fieldID;

chatEventPermissionsChanged::chatEventPermissionsChanged()
  : old_permissions_()
  , new_permissions_()
{}

chatEventPermissionsChanged::chatEventPermissionsChanged(object_ptr<chatPermissions> &&old_permissions_, object_ptr<chatPermissions> &&new_permissions_)
  : old_permissions_(std::move(old_permissions_))
  , new_permissions_(std::move(new_permissions_))
{}

const std::int32_t chatEventPermissionsChanged::ID;

object_ptr<ChatEventAction> chatEventPermissionsChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventPermissionsChanged> res = make_object<chatEventPermissionsChanged>();
  res->old_permissions_ = jni::fetch_tl_object<chatPermissions>(env, jni::fetch_object(env, p, res->old_permissions_fieldID));
  res->new_permissions_ = jni::fetch_tl_object<chatPermissions>(env, jni::fetch_object(env, p, res->new_permissions_fieldID));
  return std::move(res);
}

void chatEventPermissionsChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_permissions_ != nullptr) { jobject next; old_permissions_->store(env, next); if (next) { env->SetObjectField(s, old_permissions_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_permissions_ != nullptr) { jobject next; new_permissions_->store(env, next); if (next) { env->SetObjectField(s, new_permissions_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventPermissionsChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventPermissionsChanged");
    s.store_object_field("oldPermissions", static_cast<const BaseObject *>(old_permissions_.get()));
    s.store_object_field("newPermissions", static_cast<const BaseObject *>(new_permissions_.get()));
    s.store_class_end();
  }
}

void chatEventPermissionsChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventPermissionsChanged").c_str());
    old_permissions_fieldID = jni::get_field_id(env, Class, "oldPermissions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPermissions;").c_str());
    new_permissions_fieldID = jni::get_field_id(env, Class, "newPermissions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPermissions;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventPhotoChanged::Class;
jfieldID chatEventPhotoChanged::old_photo_fieldID;
jfieldID chatEventPhotoChanged::new_photo_fieldID;

chatEventPhotoChanged::chatEventPhotoChanged()
  : old_photo_()
  , new_photo_()
{}

chatEventPhotoChanged::chatEventPhotoChanged(object_ptr<chatPhoto> &&old_photo_, object_ptr<chatPhoto> &&new_photo_)
  : old_photo_(std::move(old_photo_))
  , new_photo_(std::move(new_photo_))
{}

const std::int32_t chatEventPhotoChanged::ID;

object_ptr<ChatEventAction> chatEventPhotoChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventPhotoChanged> res = make_object<chatEventPhotoChanged>();
  res->old_photo_ = jni::fetch_tl_object<chatPhoto>(env, jni::fetch_object(env, p, res->old_photo_fieldID));
  res->new_photo_ = jni::fetch_tl_object<chatPhoto>(env, jni::fetch_object(env, p, res->new_photo_fieldID));
  return std::move(res);
}

void chatEventPhotoChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_photo_ != nullptr) { jobject next; old_photo_->store(env, next); if (next) { env->SetObjectField(s, old_photo_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_photo_ != nullptr) { jobject next; new_photo_->store(env, next); if (next) { env->SetObjectField(s, new_photo_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventPhotoChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventPhotoChanged");
    s.store_object_field("oldPhoto", static_cast<const BaseObject *>(old_photo_.get()));
    s.store_object_field("newPhoto", static_cast<const BaseObject *>(new_photo_.get()));
    s.store_class_end();
  }
}

void chatEventPhotoChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventPhotoChanged").c_str());
    old_photo_fieldID = jni::get_field_id(env, Class, "oldPhoto", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPhoto;").c_str());
    new_photo_fieldID = jni::get_field_id(env, Class, "newPhoto", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPhoto;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventSlowModeDelayChanged::Class;
jfieldID chatEventSlowModeDelayChanged::old_slow_mode_delay_fieldID;
jfieldID chatEventSlowModeDelayChanged::new_slow_mode_delay_fieldID;

chatEventSlowModeDelayChanged::chatEventSlowModeDelayChanged()
  : old_slow_mode_delay_()
  , new_slow_mode_delay_()
{}

chatEventSlowModeDelayChanged::chatEventSlowModeDelayChanged(int32 old_slow_mode_delay_, int32 new_slow_mode_delay_)
  : old_slow_mode_delay_(old_slow_mode_delay_)
  , new_slow_mode_delay_(new_slow_mode_delay_)
{}

const std::int32_t chatEventSlowModeDelayChanged::ID;

object_ptr<ChatEventAction> chatEventSlowModeDelayChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventSlowModeDelayChanged> res = make_object<chatEventSlowModeDelayChanged>();
  res->old_slow_mode_delay_ = env->GetIntField(p, res->old_slow_mode_delay_fieldID);
  res->new_slow_mode_delay_ = env->GetIntField(p, res->new_slow_mode_delay_fieldID);
  return std::move(res);
}

void chatEventSlowModeDelayChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, old_slow_mode_delay_fieldID, old_slow_mode_delay_);
  env->SetIntField(s, new_slow_mode_delay_fieldID, new_slow_mode_delay_);
}

void chatEventSlowModeDelayChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventSlowModeDelayChanged");
    s.store_field("oldSlowModeDelay", old_slow_mode_delay_);
    s.store_field("newSlowModeDelay", new_slow_mode_delay_);
    s.store_class_end();
  }
}

void chatEventSlowModeDelayChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventSlowModeDelayChanged").c_str());
    old_slow_mode_delay_fieldID = jni::get_field_id(env, Class, "oldSlowModeDelay", "I");
    new_slow_mode_delay_fieldID = jni::get_field_id(env, Class, "newSlowModeDelay", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventStickerSetChanged::Class;
jfieldID chatEventStickerSetChanged::old_sticker_set_id_fieldID;
jfieldID chatEventStickerSetChanged::new_sticker_set_id_fieldID;

chatEventStickerSetChanged::chatEventStickerSetChanged()
  : old_sticker_set_id_()
  , new_sticker_set_id_()
{}

chatEventStickerSetChanged::chatEventStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_)
  : old_sticker_set_id_(old_sticker_set_id_)
  , new_sticker_set_id_(new_sticker_set_id_)
{}

const std::int32_t chatEventStickerSetChanged::ID;

object_ptr<ChatEventAction> chatEventStickerSetChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventStickerSetChanged> res = make_object<chatEventStickerSetChanged>();
  res->old_sticker_set_id_ = env->GetLongField(p, res->old_sticker_set_id_fieldID);
  res->new_sticker_set_id_ = env->GetLongField(p, res->new_sticker_set_id_fieldID);
  return std::move(res);
}

void chatEventStickerSetChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, old_sticker_set_id_fieldID, old_sticker_set_id_);
  env->SetLongField(s, new_sticker_set_id_fieldID, new_sticker_set_id_);
}

void chatEventStickerSetChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventStickerSetChanged");
    s.store_field("oldStickerSetId", old_sticker_set_id_);
    s.store_field("newStickerSetId", new_sticker_set_id_);
    s.store_class_end();
  }
}

void chatEventStickerSetChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventStickerSetChanged").c_str());
    old_sticker_set_id_fieldID = jni::get_field_id(env, Class, "oldStickerSetId", "J");
    new_sticker_set_id_fieldID = jni::get_field_id(env, Class, "newStickerSetId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventCustomEmojiStickerSetChanged::Class;
jfieldID chatEventCustomEmojiStickerSetChanged::old_sticker_set_id_fieldID;
jfieldID chatEventCustomEmojiStickerSetChanged::new_sticker_set_id_fieldID;

chatEventCustomEmojiStickerSetChanged::chatEventCustomEmojiStickerSetChanged()
  : old_sticker_set_id_()
  , new_sticker_set_id_()
{}

chatEventCustomEmojiStickerSetChanged::chatEventCustomEmojiStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_)
  : old_sticker_set_id_(old_sticker_set_id_)
  , new_sticker_set_id_(new_sticker_set_id_)
{}

const std::int32_t chatEventCustomEmojiStickerSetChanged::ID;

object_ptr<ChatEventAction> chatEventCustomEmojiStickerSetChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventCustomEmojiStickerSetChanged> res = make_object<chatEventCustomEmojiStickerSetChanged>();
  res->old_sticker_set_id_ = env->GetLongField(p, res->old_sticker_set_id_fieldID);
  res->new_sticker_set_id_ = env->GetLongField(p, res->new_sticker_set_id_fieldID);
  return std::move(res);
}

void chatEventCustomEmojiStickerSetChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, old_sticker_set_id_fieldID, old_sticker_set_id_);
  env->SetLongField(s, new_sticker_set_id_fieldID, new_sticker_set_id_);
}

void chatEventCustomEmojiStickerSetChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventCustomEmojiStickerSetChanged");
    s.store_field("oldStickerSetId", old_sticker_set_id_);
    s.store_field("newStickerSetId", new_sticker_set_id_);
    s.store_class_end();
  }
}

void chatEventCustomEmojiStickerSetChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventCustomEmojiStickerSetChanged").c_str());
    old_sticker_set_id_fieldID = jni::get_field_id(env, Class, "oldStickerSetId", "J");
    new_sticker_set_id_fieldID = jni::get_field_id(env, Class, "newStickerSetId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventTitleChanged::Class;
jfieldID chatEventTitleChanged::old_title_fieldID;
jfieldID chatEventTitleChanged::new_title_fieldID;

chatEventTitleChanged::chatEventTitleChanged()
  : old_title_()
  , new_title_()
{}

chatEventTitleChanged::chatEventTitleChanged(string const &old_title_, string const &new_title_)
  : old_title_(old_title_)
  , new_title_(new_title_)
{}

const std::int32_t chatEventTitleChanged::ID;

object_ptr<ChatEventAction> chatEventTitleChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventTitleChanged> res = make_object<chatEventTitleChanged>();
  res->old_title_ = jni::fetch_string(env, p, res->old_title_fieldID);
  res->new_title_ = jni::fetch_string(env, p, res->new_title_fieldID);
  return std::move(res);
}

void chatEventTitleChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, old_title_); if (nextString) { env->SetObjectField(s, old_title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, new_title_); if (nextString) { env->SetObjectField(s, new_title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatEventTitleChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventTitleChanged");
    s.store_field("oldTitle", old_title_);
    s.store_field("newTitle", new_title_);
    s.store_class_end();
  }
}

void chatEventTitleChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventTitleChanged").c_str());
    old_title_fieldID = jni::get_field_id(env, Class, "oldTitle", "Ljava/lang/String;");
    new_title_fieldID = jni::get_field_id(env, Class, "newTitle", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventUsernameChanged::Class;
jfieldID chatEventUsernameChanged::old_username_fieldID;
jfieldID chatEventUsernameChanged::new_username_fieldID;

chatEventUsernameChanged::chatEventUsernameChanged()
  : old_username_()
  , new_username_()
{}

chatEventUsernameChanged::chatEventUsernameChanged(string const &old_username_, string const &new_username_)
  : old_username_(old_username_)
  , new_username_(new_username_)
{}

const std::int32_t chatEventUsernameChanged::ID;

object_ptr<ChatEventAction> chatEventUsernameChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventUsernameChanged> res = make_object<chatEventUsernameChanged>();
  res->old_username_ = jni::fetch_string(env, p, res->old_username_fieldID);
  res->new_username_ = jni::fetch_string(env, p, res->new_username_fieldID);
  return std::move(res);
}

void chatEventUsernameChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, old_username_); if (nextString) { env->SetObjectField(s, old_username_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, new_username_); if (nextString) { env->SetObjectField(s, new_username_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatEventUsernameChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventUsernameChanged");
    s.store_field("oldUsername", old_username_);
    s.store_field("newUsername", new_username_);
    s.store_class_end();
  }
}

void chatEventUsernameChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventUsernameChanged").c_str());
    old_username_fieldID = jni::get_field_id(env, Class, "oldUsername", "Ljava/lang/String;");
    new_username_fieldID = jni::get_field_id(env, Class, "newUsername", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventActiveUsernamesChanged::Class;
jfieldID chatEventActiveUsernamesChanged::old_usernames_fieldID;
jfieldID chatEventActiveUsernamesChanged::new_usernames_fieldID;

chatEventActiveUsernamesChanged::chatEventActiveUsernamesChanged()
  : old_usernames_()
  , new_usernames_()
{}

chatEventActiveUsernamesChanged::chatEventActiveUsernamesChanged(array<string> &&old_usernames_, array<string> &&new_usernames_)
  : old_usernames_(std::move(old_usernames_))
  , new_usernames_(std::move(new_usernames_))
{}

const std::int32_t chatEventActiveUsernamesChanged::ID;

object_ptr<ChatEventAction> chatEventActiveUsernamesChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventActiveUsernamesChanged> res = make_object<chatEventActiveUsernamesChanged>();
  res->old_usernames_ = jni::FetchVector<string>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->old_usernames_fieldID));
  res->new_usernames_ = jni::FetchVector<string>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->new_usernames_fieldID));
  return std::move(res);
}

void chatEventActiveUsernamesChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, old_usernames_); if (arr_tmp_) { env->SetObjectField(s, old_usernames_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, new_usernames_); if (arr_tmp_) { env->SetObjectField(s, new_usernames_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatEventActiveUsernamesChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventActiveUsernamesChanged");
    { s.store_vector_begin("oldUsernames", old_usernames_.size()); for (const auto &_value : old_usernames_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("newUsernames", new_usernames_.size()); for (const auto &_value : new_usernames_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatEventActiveUsernamesChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventActiveUsernamesChanged").c_str());
    old_usernames_fieldID = jni::get_field_id(env, Class, "oldUsernames", "[Ljava/lang/String;");
    new_usernames_fieldID = jni::get_field_id(env, Class, "newUsernames", "[Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventAccentColorChanged::Class;
jfieldID chatEventAccentColorChanged::old_accent_color_id_fieldID;
jfieldID chatEventAccentColorChanged::old_background_custom_emoji_id_fieldID;
jfieldID chatEventAccentColorChanged::new_accent_color_id_fieldID;
jfieldID chatEventAccentColorChanged::new_background_custom_emoji_id_fieldID;

chatEventAccentColorChanged::chatEventAccentColorChanged()
  : old_accent_color_id_()
  , old_background_custom_emoji_id_()
  , new_accent_color_id_()
  , new_background_custom_emoji_id_()
{}

chatEventAccentColorChanged::chatEventAccentColorChanged(int32 old_accent_color_id_, int64 old_background_custom_emoji_id_, int32 new_accent_color_id_, int64 new_background_custom_emoji_id_)
  : old_accent_color_id_(old_accent_color_id_)
  , old_background_custom_emoji_id_(old_background_custom_emoji_id_)
  , new_accent_color_id_(new_accent_color_id_)
  , new_background_custom_emoji_id_(new_background_custom_emoji_id_)
{}

const std::int32_t chatEventAccentColorChanged::ID;

object_ptr<ChatEventAction> chatEventAccentColorChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventAccentColorChanged> res = make_object<chatEventAccentColorChanged>();
  res->old_accent_color_id_ = env->GetIntField(p, res->old_accent_color_id_fieldID);
  res->old_background_custom_emoji_id_ = env->GetLongField(p, res->old_background_custom_emoji_id_fieldID);
  res->new_accent_color_id_ = env->GetIntField(p, res->new_accent_color_id_fieldID);
  res->new_background_custom_emoji_id_ = env->GetLongField(p, res->new_background_custom_emoji_id_fieldID);
  return std::move(res);
}

void chatEventAccentColorChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, old_accent_color_id_fieldID, old_accent_color_id_);
  env->SetLongField(s, old_background_custom_emoji_id_fieldID, old_background_custom_emoji_id_);
  env->SetIntField(s, new_accent_color_id_fieldID, new_accent_color_id_);
  env->SetLongField(s, new_background_custom_emoji_id_fieldID, new_background_custom_emoji_id_);
}

void chatEventAccentColorChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventAccentColorChanged");
    s.store_field("oldAccentColorId", old_accent_color_id_);
    s.store_field("oldBackgroundCustomEmojiId", old_background_custom_emoji_id_);
    s.store_field("newAccentColorId", new_accent_color_id_);
    s.store_field("newBackgroundCustomEmojiId", new_background_custom_emoji_id_);
    s.store_class_end();
  }
}

void chatEventAccentColorChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventAccentColorChanged").c_str());
    old_accent_color_id_fieldID = jni::get_field_id(env, Class, "oldAccentColorId", "I");
    old_background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "oldBackgroundCustomEmojiId", "J");
    new_accent_color_id_fieldID = jni::get_field_id(env, Class, "newAccentColorId", "I");
    new_background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "newBackgroundCustomEmojiId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventProfileAccentColorChanged::Class;
jfieldID chatEventProfileAccentColorChanged::old_profile_accent_color_id_fieldID;
jfieldID chatEventProfileAccentColorChanged::old_profile_background_custom_emoji_id_fieldID;
jfieldID chatEventProfileAccentColorChanged::new_profile_accent_color_id_fieldID;
jfieldID chatEventProfileAccentColorChanged::new_profile_background_custom_emoji_id_fieldID;

chatEventProfileAccentColorChanged::chatEventProfileAccentColorChanged()
  : old_profile_accent_color_id_()
  , old_profile_background_custom_emoji_id_()
  , new_profile_accent_color_id_()
  , new_profile_background_custom_emoji_id_()
{}

chatEventProfileAccentColorChanged::chatEventProfileAccentColorChanged(int32 old_profile_accent_color_id_, int64 old_profile_background_custom_emoji_id_, int32 new_profile_accent_color_id_, int64 new_profile_background_custom_emoji_id_)
  : old_profile_accent_color_id_(old_profile_accent_color_id_)
  , old_profile_background_custom_emoji_id_(old_profile_background_custom_emoji_id_)
  , new_profile_accent_color_id_(new_profile_accent_color_id_)
  , new_profile_background_custom_emoji_id_(new_profile_background_custom_emoji_id_)
{}

const std::int32_t chatEventProfileAccentColorChanged::ID;

object_ptr<ChatEventAction> chatEventProfileAccentColorChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventProfileAccentColorChanged> res = make_object<chatEventProfileAccentColorChanged>();
  res->old_profile_accent_color_id_ = env->GetIntField(p, res->old_profile_accent_color_id_fieldID);
  res->old_profile_background_custom_emoji_id_ = env->GetLongField(p, res->old_profile_background_custom_emoji_id_fieldID);
  res->new_profile_accent_color_id_ = env->GetIntField(p, res->new_profile_accent_color_id_fieldID);
  res->new_profile_background_custom_emoji_id_ = env->GetLongField(p, res->new_profile_background_custom_emoji_id_fieldID);
  return std::move(res);
}

void chatEventProfileAccentColorChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, old_profile_accent_color_id_fieldID, old_profile_accent_color_id_);
  env->SetLongField(s, old_profile_background_custom_emoji_id_fieldID, old_profile_background_custom_emoji_id_);
  env->SetIntField(s, new_profile_accent_color_id_fieldID, new_profile_accent_color_id_);
  env->SetLongField(s, new_profile_background_custom_emoji_id_fieldID, new_profile_background_custom_emoji_id_);
}

void chatEventProfileAccentColorChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventProfileAccentColorChanged");
    s.store_field("oldProfileAccentColorId", old_profile_accent_color_id_);
    s.store_field("oldProfileBackgroundCustomEmojiId", old_profile_background_custom_emoji_id_);
    s.store_field("newProfileAccentColorId", new_profile_accent_color_id_);
    s.store_field("newProfileBackgroundCustomEmojiId", new_profile_background_custom_emoji_id_);
    s.store_class_end();
  }
}

void chatEventProfileAccentColorChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventProfileAccentColorChanged").c_str());
    old_profile_accent_color_id_fieldID = jni::get_field_id(env, Class, "oldProfileAccentColorId", "I");
    old_profile_background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "oldProfileBackgroundCustomEmojiId", "J");
    new_profile_accent_color_id_fieldID = jni::get_field_id(env, Class, "newProfileAccentColorId", "I");
    new_profile_background_custom_emoji_id_fieldID = jni::get_field_id(env, Class, "newProfileBackgroundCustomEmojiId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventHasProtectedContentToggled::Class;
jfieldID chatEventHasProtectedContentToggled::has_protected_content_fieldID;

chatEventHasProtectedContentToggled::chatEventHasProtectedContentToggled()
  : has_protected_content_()
{}

chatEventHasProtectedContentToggled::chatEventHasProtectedContentToggled(bool has_protected_content_)
  : has_protected_content_(has_protected_content_)
{}

const std::int32_t chatEventHasProtectedContentToggled::ID;

object_ptr<ChatEventAction> chatEventHasProtectedContentToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventHasProtectedContentToggled> res = make_object<chatEventHasProtectedContentToggled>();
  res->has_protected_content_ = (env->GetBooleanField(p, res->has_protected_content_fieldID) != 0);
  return std::move(res);
}

void chatEventHasProtectedContentToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, has_protected_content_fieldID, has_protected_content_);
}

void chatEventHasProtectedContentToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventHasProtectedContentToggled");
    s.store_field("hasProtectedContent", has_protected_content_);
    s.store_class_end();
  }
}

void chatEventHasProtectedContentToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventHasProtectedContentToggled").c_str());
    has_protected_content_fieldID = jni::get_field_id(env, Class, "hasProtectedContent", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventInvitesToggled::Class;
jfieldID chatEventInvitesToggled::can_invite_users_fieldID;

chatEventInvitesToggled::chatEventInvitesToggled()
  : can_invite_users_()
{}

chatEventInvitesToggled::chatEventInvitesToggled(bool can_invite_users_)
  : can_invite_users_(can_invite_users_)
{}

const std::int32_t chatEventInvitesToggled::ID;

object_ptr<ChatEventAction> chatEventInvitesToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventInvitesToggled> res = make_object<chatEventInvitesToggled>();
  res->can_invite_users_ = (env->GetBooleanField(p, res->can_invite_users_fieldID) != 0);
  return std::move(res);
}

void chatEventInvitesToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, can_invite_users_fieldID, can_invite_users_);
}

void chatEventInvitesToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventInvitesToggled");
    s.store_field("canInviteUsers", can_invite_users_);
    s.store_class_end();
  }
}

void chatEventInvitesToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventInvitesToggled").c_str());
    can_invite_users_fieldID = jni::get_field_id(env, Class, "canInviteUsers", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventIsAllHistoryAvailableToggled::Class;
jfieldID chatEventIsAllHistoryAvailableToggled::is_all_history_available_fieldID;

chatEventIsAllHistoryAvailableToggled::chatEventIsAllHistoryAvailableToggled()
  : is_all_history_available_()
{}

chatEventIsAllHistoryAvailableToggled::chatEventIsAllHistoryAvailableToggled(bool is_all_history_available_)
  : is_all_history_available_(is_all_history_available_)
{}

const std::int32_t chatEventIsAllHistoryAvailableToggled::ID;

object_ptr<ChatEventAction> chatEventIsAllHistoryAvailableToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventIsAllHistoryAvailableToggled> res = make_object<chatEventIsAllHistoryAvailableToggled>();
  res->is_all_history_available_ = (env->GetBooleanField(p, res->is_all_history_available_fieldID) != 0);
  return std::move(res);
}

void chatEventIsAllHistoryAvailableToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_all_history_available_fieldID, is_all_history_available_);
}

void chatEventIsAllHistoryAvailableToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventIsAllHistoryAvailableToggled");
    s.store_field("isAllHistoryAvailable", is_all_history_available_);
    s.store_class_end();
  }
}

void chatEventIsAllHistoryAvailableToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventIsAllHistoryAvailableToggled").c_str());
    is_all_history_available_fieldID = jni::get_field_id(env, Class, "isAllHistoryAvailable", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventHasAggressiveAntiSpamEnabledToggled::Class;
jfieldID chatEventHasAggressiveAntiSpamEnabledToggled::has_aggressive_anti_spam_enabled_fieldID;

chatEventHasAggressiveAntiSpamEnabledToggled::chatEventHasAggressiveAntiSpamEnabledToggled()
  : has_aggressive_anti_spam_enabled_()
{}

chatEventHasAggressiveAntiSpamEnabledToggled::chatEventHasAggressiveAntiSpamEnabledToggled(bool has_aggressive_anti_spam_enabled_)
  : has_aggressive_anti_spam_enabled_(has_aggressive_anti_spam_enabled_)
{}

const std::int32_t chatEventHasAggressiveAntiSpamEnabledToggled::ID;

object_ptr<ChatEventAction> chatEventHasAggressiveAntiSpamEnabledToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventHasAggressiveAntiSpamEnabledToggled> res = make_object<chatEventHasAggressiveAntiSpamEnabledToggled>();
  res->has_aggressive_anti_spam_enabled_ = (env->GetBooleanField(p, res->has_aggressive_anti_spam_enabled_fieldID) != 0);
  return std::move(res);
}

void chatEventHasAggressiveAntiSpamEnabledToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, has_aggressive_anti_spam_enabled_fieldID, has_aggressive_anti_spam_enabled_);
}

void chatEventHasAggressiveAntiSpamEnabledToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventHasAggressiveAntiSpamEnabledToggled");
    s.store_field("hasAggressiveAntiSpamEnabled", has_aggressive_anti_spam_enabled_);
    s.store_class_end();
  }
}

void chatEventHasAggressiveAntiSpamEnabledToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventHasAggressiveAntiSpamEnabledToggled").c_str());
    has_aggressive_anti_spam_enabled_fieldID = jni::get_field_id(env, Class, "hasAggressiveAntiSpamEnabled", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventSignMessagesToggled::Class;
jfieldID chatEventSignMessagesToggled::sign_messages_fieldID;

chatEventSignMessagesToggled::chatEventSignMessagesToggled()
  : sign_messages_()
{}

chatEventSignMessagesToggled::chatEventSignMessagesToggled(bool sign_messages_)
  : sign_messages_(sign_messages_)
{}

const std::int32_t chatEventSignMessagesToggled::ID;

object_ptr<ChatEventAction> chatEventSignMessagesToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventSignMessagesToggled> res = make_object<chatEventSignMessagesToggled>();
  res->sign_messages_ = (env->GetBooleanField(p, res->sign_messages_fieldID) != 0);
  return std::move(res);
}

void chatEventSignMessagesToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, sign_messages_fieldID, sign_messages_);
}

void chatEventSignMessagesToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventSignMessagesToggled");
    s.store_field("signMessages", sign_messages_);
    s.store_class_end();
  }
}

void chatEventSignMessagesToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventSignMessagesToggled").c_str());
    sign_messages_fieldID = jni::get_field_id(env, Class, "signMessages", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventShowMessageSenderToggled::Class;
jfieldID chatEventShowMessageSenderToggled::show_message_sender_fieldID;

chatEventShowMessageSenderToggled::chatEventShowMessageSenderToggled()
  : show_message_sender_()
{}

chatEventShowMessageSenderToggled::chatEventShowMessageSenderToggled(bool show_message_sender_)
  : show_message_sender_(show_message_sender_)
{}

const std::int32_t chatEventShowMessageSenderToggled::ID;

object_ptr<ChatEventAction> chatEventShowMessageSenderToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventShowMessageSenderToggled> res = make_object<chatEventShowMessageSenderToggled>();
  res->show_message_sender_ = (env->GetBooleanField(p, res->show_message_sender_fieldID) != 0);
  return std::move(res);
}

void chatEventShowMessageSenderToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, show_message_sender_fieldID, show_message_sender_);
}

void chatEventShowMessageSenderToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventShowMessageSenderToggled");
    s.store_field("showMessageSender", show_message_sender_);
    s.store_class_end();
  }
}

void chatEventShowMessageSenderToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventShowMessageSenderToggled").c_str());
    show_message_sender_fieldID = jni::get_field_id(env, Class, "showMessageSender", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventAutomaticTranslationToggled::Class;
jfieldID chatEventAutomaticTranslationToggled::has_automatic_translation_fieldID;

chatEventAutomaticTranslationToggled::chatEventAutomaticTranslationToggled()
  : has_automatic_translation_()
{}

chatEventAutomaticTranslationToggled::chatEventAutomaticTranslationToggled(bool has_automatic_translation_)
  : has_automatic_translation_(has_automatic_translation_)
{}

const std::int32_t chatEventAutomaticTranslationToggled::ID;

object_ptr<ChatEventAction> chatEventAutomaticTranslationToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventAutomaticTranslationToggled> res = make_object<chatEventAutomaticTranslationToggled>();
  res->has_automatic_translation_ = (env->GetBooleanField(p, res->has_automatic_translation_fieldID) != 0);
  return std::move(res);
}

void chatEventAutomaticTranslationToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, has_automatic_translation_fieldID, has_automatic_translation_);
}

void chatEventAutomaticTranslationToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventAutomaticTranslationToggled");
    s.store_field("hasAutomaticTranslation", has_automatic_translation_);
    s.store_class_end();
  }
}

void chatEventAutomaticTranslationToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventAutomaticTranslationToggled").c_str());
    has_automatic_translation_fieldID = jni::get_field_id(env, Class, "hasAutomaticTranslation", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventInviteLinkEdited::Class;
jfieldID chatEventInviteLinkEdited::old_invite_link_fieldID;
jfieldID chatEventInviteLinkEdited::new_invite_link_fieldID;

chatEventInviteLinkEdited::chatEventInviteLinkEdited()
  : old_invite_link_()
  , new_invite_link_()
{}

chatEventInviteLinkEdited::chatEventInviteLinkEdited(object_ptr<chatInviteLink> &&old_invite_link_, object_ptr<chatInviteLink> &&new_invite_link_)
  : old_invite_link_(std::move(old_invite_link_))
  , new_invite_link_(std::move(new_invite_link_))
{}

const std::int32_t chatEventInviteLinkEdited::ID;

object_ptr<ChatEventAction> chatEventInviteLinkEdited::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventInviteLinkEdited> res = make_object<chatEventInviteLinkEdited>();
  res->old_invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->old_invite_link_fieldID));
  res->new_invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->new_invite_link_fieldID));
  return std::move(res);
}

void chatEventInviteLinkEdited::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_invite_link_ != nullptr) { jobject next; old_invite_link_->store(env, next); if (next) { env->SetObjectField(s, old_invite_link_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_invite_link_ != nullptr) { jobject next; new_invite_link_->store(env, next); if (next) { env->SetObjectField(s, new_invite_link_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventInviteLinkEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventInviteLinkEdited");
    s.store_object_field("oldInviteLink", static_cast<const BaseObject *>(old_invite_link_.get()));
    s.store_object_field("newInviteLink", static_cast<const BaseObject *>(new_invite_link_.get()));
    s.store_class_end();
  }
}

void chatEventInviteLinkEdited::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventInviteLinkEdited").c_str());
    old_invite_link_fieldID = jni::get_field_id(env, Class, "oldInviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    new_invite_link_fieldID = jni::get_field_id(env, Class, "newInviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventInviteLinkRevoked::Class;
jfieldID chatEventInviteLinkRevoked::invite_link_fieldID;

chatEventInviteLinkRevoked::chatEventInviteLinkRevoked()
  : invite_link_()
{}

chatEventInviteLinkRevoked::chatEventInviteLinkRevoked(object_ptr<chatInviteLink> &&invite_link_)
  : invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventInviteLinkRevoked::ID;

object_ptr<ChatEventAction> chatEventInviteLinkRevoked::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventInviteLinkRevoked> res = make_object<chatEventInviteLinkRevoked>();
  res->invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->invite_link_fieldID));
  return std::move(res);
}

void chatEventInviteLinkRevoked::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (invite_link_ != nullptr) { jobject next; invite_link_->store(env, next); if (next) { env->SetObjectField(s, invite_link_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventInviteLinkRevoked::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventInviteLinkRevoked");
    s.store_object_field("inviteLink", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

void chatEventInviteLinkRevoked::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventInviteLinkRevoked").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventInviteLinkDeleted::Class;
jfieldID chatEventInviteLinkDeleted::invite_link_fieldID;

chatEventInviteLinkDeleted::chatEventInviteLinkDeleted()
  : invite_link_()
{}

chatEventInviteLinkDeleted::chatEventInviteLinkDeleted(object_ptr<chatInviteLink> &&invite_link_)
  : invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventInviteLinkDeleted::ID;

object_ptr<ChatEventAction> chatEventInviteLinkDeleted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventInviteLinkDeleted> res = make_object<chatEventInviteLinkDeleted>();
  res->invite_link_ = jni::fetch_tl_object<chatInviteLink>(env, jni::fetch_object(env, p, res->invite_link_fieldID));
  return std::move(res);
}

void chatEventInviteLinkDeleted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (invite_link_ != nullptr) { jobject next; invite_link_->store(env, next); if (next) { env->SetObjectField(s, invite_link_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventInviteLinkDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventInviteLinkDeleted");
    s.store_object_field("inviteLink", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

void chatEventInviteLinkDeleted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventInviteLinkDeleted").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventVideoChatCreated::Class;
jfieldID chatEventVideoChatCreated::group_call_id_fieldID;

chatEventVideoChatCreated::chatEventVideoChatCreated()
  : group_call_id_()
{}

chatEventVideoChatCreated::chatEventVideoChatCreated(int32 group_call_id_)
  : group_call_id_(group_call_id_)
{}

const std::int32_t chatEventVideoChatCreated::ID;

object_ptr<ChatEventAction> chatEventVideoChatCreated::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventVideoChatCreated> res = make_object<chatEventVideoChatCreated>();
  res->group_call_id_ = env->GetIntField(p, res->group_call_id_fieldID);
  return std::move(res);
}

void chatEventVideoChatCreated::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, group_call_id_fieldID, group_call_id_);
}

void chatEventVideoChatCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventVideoChatCreated");
    s.store_field("groupCallId", group_call_id_);
    s.store_class_end();
  }
}

void chatEventVideoChatCreated::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventVideoChatCreated").c_str());
    group_call_id_fieldID = jni::get_field_id(env, Class, "groupCallId", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventVideoChatEnded::Class;
jfieldID chatEventVideoChatEnded::group_call_id_fieldID;

chatEventVideoChatEnded::chatEventVideoChatEnded()
  : group_call_id_()
{}

chatEventVideoChatEnded::chatEventVideoChatEnded(int32 group_call_id_)
  : group_call_id_(group_call_id_)
{}

const std::int32_t chatEventVideoChatEnded::ID;

object_ptr<ChatEventAction> chatEventVideoChatEnded::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventVideoChatEnded> res = make_object<chatEventVideoChatEnded>();
  res->group_call_id_ = env->GetIntField(p, res->group_call_id_fieldID);
  return std::move(res);
}

void chatEventVideoChatEnded::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, group_call_id_fieldID, group_call_id_);
}

void chatEventVideoChatEnded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventVideoChatEnded");
    s.store_field("groupCallId", group_call_id_);
    s.store_class_end();
  }
}

void chatEventVideoChatEnded::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventVideoChatEnded").c_str());
    group_call_id_fieldID = jni::get_field_id(env, Class, "groupCallId", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventVideoChatMuteNewParticipantsToggled::Class;
jfieldID chatEventVideoChatMuteNewParticipantsToggled::mute_new_participants_fieldID;

chatEventVideoChatMuteNewParticipantsToggled::chatEventVideoChatMuteNewParticipantsToggled()
  : mute_new_participants_()
{}

chatEventVideoChatMuteNewParticipantsToggled::chatEventVideoChatMuteNewParticipantsToggled(bool mute_new_participants_)
  : mute_new_participants_(mute_new_participants_)
{}

const std::int32_t chatEventVideoChatMuteNewParticipantsToggled::ID;

object_ptr<ChatEventAction> chatEventVideoChatMuteNewParticipantsToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventVideoChatMuteNewParticipantsToggled> res = make_object<chatEventVideoChatMuteNewParticipantsToggled>();
  res->mute_new_participants_ = (env->GetBooleanField(p, res->mute_new_participants_fieldID) != 0);
  return std::move(res);
}

void chatEventVideoChatMuteNewParticipantsToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, mute_new_participants_fieldID, mute_new_participants_);
}

void chatEventVideoChatMuteNewParticipantsToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventVideoChatMuteNewParticipantsToggled");
    s.store_field("muteNewParticipants", mute_new_participants_);
    s.store_class_end();
  }
}

void chatEventVideoChatMuteNewParticipantsToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventVideoChatMuteNewParticipantsToggled").c_str());
    mute_new_participants_fieldID = jni::get_field_id(env, Class, "muteNewParticipants", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventVideoChatParticipantIsMutedToggled::Class;
jfieldID chatEventVideoChatParticipantIsMutedToggled::participant_id_fieldID;
jfieldID chatEventVideoChatParticipantIsMutedToggled::is_muted_fieldID;

chatEventVideoChatParticipantIsMutedToggled::chatEventVideoChatParticipantIsMutedToggled()
  : participant_id_()
  , is_muted_()
{}

chatEventVideoChatParticipantIsMutedToggled::chatEventVideoChatParticipantIsMutedToggled(object_ptr<MessageSender> &&participant_id_, bool is_muted_)
  : participant_id_(std::move(participant_id_))
  , is_muted_(is_muted_)
{}

const std::int32_t chatEventVideoChatParticipantIsMutedToggled::ID;

object_ptr<ChatEventAction> chatEventVideoChatParticipantIsMutedToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventVideoChatParticipantIsMutedToggled> res = make_object<chatEventVideoChatParticipantIsMutedToggled>();
  res->participant_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->participant_id_fieldID));
  res->is_muted_ = (env->GetBooleanField(p, res->is_muted_fieldID) != 0);
  return std::move(res);
}

void chatEventVideoChatParticipantIsMutedToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (participant_id_ != nullptr) { jobject next; participant_id_->store(env, next); if (next) { env->SetObjectField(s, participant_id_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, is_muted_fieldID, is_muted_);
}

void chatEventVideoChatParticipantIsMutedToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventVideoChatParticipantIsMutedToggled");
    s.store_object_field("participantId", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("isMuted", is_muted_);
    s.store_class_end();
  }
}

void chatEventVideoChatParticipantIsMutedToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventVideoChatParticipantIsMutedToggled").c_str());
    participant_id_fieldID = jni::get_field_id(env, Class, "participantId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    is_muted_fieldID = jni::get_field_id(env, Class, "isMuted", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventVideoChatParticipantVolumeLevelChanged::Class;
jfieldID chatEventVideoChatParticipantVolumeLevelChanged::participant_id_fieldID;
jfieldID chatEventVideoChatParticipantVolumeLevelChanged::volume_level_fieldID;

chatEventVideoChatParticipantVolumeLevelChanged::chatEventVideoChatParticipantVolumeLevelChanged()
  : participant_id_()
  , volume_level_()
{}

chatEventVideoChatParticipantVolumeLevelChanged::chatEventVideoChatParticipantVolumeLevelChanged(object_ptr<MessageSender> &&participant_id_, int32 volume_level_)
  : participant_id_(std::move(participant_id_))
  , volume_level_(volume_level_)
{}

const std::int32_t chatEventVideoChatParticipantVolumeLevelChanged::ID;

object_ptr<ChatEventAction> chatEventVideoChatParticipantVolumeLevelChanged::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventVideoChatParticipantVolumeLevelChanged> res = make_object<chatEventVideoChatParticipantVolumeLevelChanged>();
  res->participant_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->participant_id_fieldID));
  res->volume_level_ = env->GetIntField(p, res->volume_level_fieldID);
  return std::move(res);
}

void chatEventVideoChatParticipantVolumeLevelChanged::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (participant_id_ != nullptr) { jobject next; participant_id_->store(env, next); if (next) { env->SetObjectField(s, participant_id_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, volume_level_fieldID, volume_level_);
}

void chatEventVideoChatParticipantVolumeLevelChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventVideoChatParticipantVolumeLevelChanged");
    s.store_object_field("participantId", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("volumeLevel", volume_level_);
    s.store_class_end();
  }
}

void chatEventVideoChatParticipantVolumeLevelChanged::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventVideoChatParticipantVolumeLevelChanged").c_str());
    participant_id_fieldID = jni::get_field_id(env, Class, "participantId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    volume_level_fieldID = jni::get_field_id(env, Class, "volumeLevel", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventIsForumToggled::Class;
jfieldID chatEventIsForumToggled::is_forum_fieldID;

chatEventIsForumToggled::chatEventIsForumToggled()
  : is_forum_()
{}

chatEventIsForumToggled::chatEventIsForumToggled(bool is_forum_)
  : is_forum_(is_forum_)
{}

const std::int32_t chatEventIsForumToggled::ID;

object_ptr<ChatEventAction> chatEventIsForumToggled::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventIsForumToggled> res = make_object<chatEventIsForumToggled>();
  res->is_forum_ = (env->GetBooleanField(p, res->is_forum_fieldID) != 0);
  return std::move(res);
}

void chatEventIsForumToggled::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_forum_fieldID, is_forum_);
}

void chatEventIsForumToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventIsForumToggled");
    s.store_field("isForum", is_forum_);
    s.store_class_end();
  }
}

void chatEventIsForumToggled::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventIsForumToggled").c_str());
    is_forum_fieldID = jni::get_field_id(env, Class, "isForum", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicCreated::Class;
jfieldID chatEventForumTopicCreated::topic_info_fieldID;

chatEventForumTopicCreated::chatEventForumTopicCreated()
  : topic_info_()
{}

chatEventForumTopicCreated::chatEventForumTopicCreated(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicCreated::ID;

object_ptr<ChatEventAction> chatEventForumTopicCreated::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicCreated> res = make_object<chatEventForumTopicCreated>();
  res->topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicCreated::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (topic_info_ != nullptr) { jobject next; topic_info_->store(env, next); if (next) { env->SetObjectField(s, topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicCreated");
    s.store_object_field("topicInfo", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicCreated::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicCreated").c_str());
    topic_info_fieldID = jni::get_field_id(env, Class, "topicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicEdited::Class;
jfieldID chatEventForumTopicEdited::old_topic_info_fieldID;
jfieldID chatEventForumTopicEdited::new_topic_info_fieldID;

chatEventForumTopicEdited::chatEventForumTopicEdited()
  : old_topic_info_()
  , new_topic_info_()
{}

chatEventForumTopicEdited::chatEventForumTopicEdited(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_)
  : old_topic_info_(std::move(old_topic_info_))
  , new_topic_info_(std::move(new_topic_info_))
{}

const std::int32_t chatEventForumTopicEdited::ID;

object_ptr<ChatEventAction> chatEventForumTopicEdited::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicEdited> res = make_object<chatEventForumTopicEdited>();
  res->old_topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->old_topic_info_fieldID));
  res->new_topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->new_topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicEdited::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_topic_info_ != nullptr) { jobject next; old_topic_info_->store(env, next); if (next) { env->SetObjectField(s, old_topic_info_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_topic_info_ != nullptr) { jobject next; new_topic_info_->store(env, next); if (next) { env->SetObjectField(s, new_topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicEdited");
    s.store_object_field("oldTopicInfo", static_cast<const BaseObject *>(old_topic_info_.get()));
    s.store_object_field("newTopicInfo", static_cast<const BaseObject *>(new_topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicEdited::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicEdited").c_str());
    old_topic_info_fieldID = jni::get_field_id(env, Class, "oldTopicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    new_topic_info_fieldID = jni::get_field_id(env, Class, "newTopicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicToggleIsClosed::Class;
jfieldID chatEventForumTopicToggleIsClosed::topic_info_fieldID;

chatEventForumTopicToggleIsClosed::chatEventForumTopicToggleIsClosed()
  : topic_info_()
{}

chatEventForumTopicToggleIsClosed::chatEventForumTopicToggleIsClosed(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicToggleIsClosed::ID;

object_ptr<ChatEventAction> chatEventForumTopicToggleIsClosed::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicToggleIsClosed> res = make_object<chatEventForumTopicToggleIsClosed>();
  res->topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicToggleIsClosed::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (topic_info_ != nullptr) { jobject next; topic_info_->store(env, next); if (next) { env->SetObjectField(s, topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicToggleIsClosed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicToggleIsClosed");
    s.store_object_field("topicInfo", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicToggleIsClosed::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicToggleIsClosed").c_str());
    topic_info_fieldID = jni::get_field_id(env, Class, "topicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicToggleIsHidden::Class;
jfieldID chatEventForumTopicToggleIsHidden::topic_info_fieldID;

chatEventForumTopicToggleIsHidden::chatEventForumTopicToggleIsHidden()
  : topic_info_()
{}

chatEventForumTopicToggleIsHidden::chatEventForumTopicToggleIsHidden(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicToggleIsHidden::ID;

object_ptr<ChatEventAction> chatEventForumTopicToggleIsHidden::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicToggleIsHidden> res = make_object<chatEventForumTopicToggleIsHidden>();
  res->topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicToggleIsHidden::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (topic_info_ != nullptr) { jobject next; topic_info_->store(env, next); if (next) { env->SetObjectField(s, topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicToggleIsHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicToggleIsHidden");
    s.store_object_field("topicInfo", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicToggleIsHidden::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicToggleIsHidden").c_str());
    topic_info_fieldID = jni::get_field_id(env, Class, "topicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicDeleted::Class;
jfieldID chatEventForumTopicDeleted::topic_info_fieldID;

chatEventForumTopicDeleted::chatEventForumTopicDeleted()
  : topic_info_()
{}

chatEventForumTopicDeleted::chatEventForumTopicDeleted(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicDeleted::ID;

object_ptr<ChatEventAction> chatEventForumTopicDeleted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicDeleted> res = make_object<chatEventForumTopicDeleted>();
  res->topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicDeleted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (topic_info_ != nullptr) { jobject next; topic_info_->store(env, next); if (next) { env->SetObjectField(s, topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicDeleted");
    s.store_object_field("topicInfo", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicDeleted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicDeleted").c_str());
    topic_info_fieldID = jni::get_field_id(env, Class, "topicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventForumTopicPinned::Class;
jfieldID chatEventForumTopicPinned::old_topic_info_fieldID;
jfieldID chatEventForumTopicPinned::new_topic_info_fieldID;

chatEventForumTopicPinned::chatEventForumTopicPinned()
  : old_topic_info_()
  , new_topic_info_()
{}

chatEventForumTopicPinned::chatEventForumTopicPinned(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_)
  : old_topic_info_(std::move(old_topic_info_))
  , new_topic_info_(std::move(new_topic_info_))
{}

const std::int32_t chatEventForumTopicPinned::ID;

object_ptr<ChatEventAction> chatEventForumTopicPinned::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventForumTopicPinned> res = make_object<chatEventForumTopicPinned>();
  res->old_topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->old_topic_info_fieldID));
  res->new_topic_info_ = jni::fetch_tl_object<forumTopicInfo>(env, jni::fetch_object(env, p, res->new_topic_info_fieldID));
  return std::move(res);
}

void chatEventForumTopicPinned::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (old_topic_info_ != nullptr) { jobject next; old_topic_info_->store(env, next); if (next) { env->SetObjectField(s, old_topic_info_fieldID, next); env->DeleteLocalRef(next); } }
  if (new_topic_info_ != nullptr) { jobject next; new_topic_info_->store(env, next); if (next) { env->SetObjectField(s, new_topic_info_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatEventForumTopicPinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventForumTopicPinned");
    s.store_object_field("oldTopicInfo", static_cast<const BaseObject *>(old_topic_info_.get()));
    s.store_object_field("newTopicInfo", static_cast<const BaseObject *>(new_topic_info_.get()));
    s.store_class_end();
  }
}

void chatEventForumTopicPinned::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventForumTopicPinned").c_str());
    old_topic_info_fieldID = jni::get_field_id(env, Class, "oldTopicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    new_topic_info_fieldID = jni::get_field_id(env, Class, "newTopicInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ForumTopicInfo;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatEventLogFilters::Class;
jfieldID chatEventLogFilters::message_edits_fieldID;
jfieldID chatEventLogFilters::message_deletions_fieldID;
jfieldID chatEventLogFilters::message_pins_fieldID;
jfieldID chatEventLogFilters::member_joins_fieldID;
jfieldID chatEventLogFilters::member_leaves_fieldID;
jfieldID chatEventLogFilters::member_invites_fieldID;
jfieldID chatEventLogFilters::member_promotions_fieldID;
jfieldID chatEventLogFilters::member_restrictions_fieldID;
jfieldID chatEventLogFilters::info_changes_fieldID;
jfieldID chatEventLogFilters::setting_changes_fieldID;
jfieldID chatEventLogFilters::invite_link_changes_fieldID;
jfieldID chatEventLogFilters::video_chat_changes_fieldID;
jfieldID chatEventLogFilters::forum_changes_fieldID;
jfieldID chatEventLogFilters::subscription_extensions_fieldID;

chatEventLogFilters::chatEventLogFilters()
  : message_edits_()
  , message_deletions_()
  , message_pins_()
  , member_joins_()
  , member_leaves_()
  , member_invites_()
  , member_promotions_()
  , member_restrictions_()
  , info_changes_()
  , setting_changes_()
  , invite_link_changes_()
  , video_chat_changes_()
  , forum_changes_()
  , subscription_extensions_()
{}

chatEventLogFilters::chatEventLogFilters(bool message_edits_, bool message_deletions_, bool message_pins_, bool member_joins_, bool member_leaves_, bool member_invites_, bool member_promotions_, bool member_restrictions_, bool info_changes_, bool setting_changes_, bool invite_link_changes_, bool video_chat_changes_, bool forum_changes_, bool subscription_extensions_)
  : message_edits_(message_edits_)
  , message_deletions_(message_deletions_)
  , message_pins_(message_pins_)
  , member_joins_(member_joins_)
  , member_leaves_(member_leaves_)
  , member_invites_(member_invites_)
  , member_promotions_(member_promotions_)
  , member_restrictions_(member_restrictions_)
  , info_changes_(info_changes_)
  , setting_changes_(setting_changes_)
  , invite_link_changes_(invite_link_changes_)
  , video_chat_changes_(video_chat_changes_)
  , forum_changes_(forum_changes_)
  , subscription_extensions_(subscription_extensions_)
{}

const std::int32_t chatEventLogFilters::ID;

object_ptr<chatEventLogFilters> chatEventLogFilters::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEventLogFilters> res = make_object<chatEventLogFilters>();
  res->message_edits_ = (env->GetBooleanField(p, res->message_edits_fieldID) != 0);
  res->message_deletions_ = (env->GetBooleanField(p, res->message_deletions_fieldID) != 0);
  res->message_pins_ = (env->GetBooleanField(p, res->message_pins_fieldID) != 0);
  res->member_joins_ = (env->GetBooleanField(p, res->member_joins_fieldID) != 0);
  res->member_leaves_ = (env->GetBooleanField(p, res->member_leaves_fieldID) != 0);
  res->member_invites_ = (env->GetBooleanField(p, res->member_invites_fieldID) != 0);
  res->member_promotions_ = (env->GetBooleanField(p, res->member_promotions_fieldID) != 0);
  res->member_restrictions_ = (env->GetBooleanField(p, res->member_restrictions_fieldID) != 0);
  res->info_changes_ = (env->GetBooleanField(p, res->info_changes_fieldID) != 0);
  res->setting_changes_ = (env->GetBooleanField(p, res->setting_changes_fieldID) != 0);
  res->invite_link_changes_ = (env->GetBooleanField(p, res->invite_link_changes_fieldID) != 0);
  res->video_chat_changes_ = (env->GetBooleanField(p, res->video_chat_changes_fieldID) != 0);
  res->forum_changes_ = (env->GetBooleanField(p, res->forum_changes_fieldID) != 0);
  res->subscription_extensions_ = (env->GetBooleanField(p, res->subscription_extensions_fieldID) != 0);
  return res;
}

void chatEventLogFilters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEventLogFilters");
    s.store_field("messageEdits", message_edits_);
    s.store_field("messageDeletions", message_deletions_);
    s.store_field("messagePins", message_pins_);
    s.store_field("memberJoins", member_joins_);
    s.store_field("memberLeaves", member_leaves_);
    s.store_field("memberInvites", member_invites_);
    s.store_field("memberPromotions", member_promotions_);
    s.store_field("memberRestrictions", member_restrictions_);
    s.store_field("infoChanges", info_changes_);
    s.store_field("settingChanges", setting_changes_);
    s.store_field("inviteLinkChanges", invite_link_changes_);
    s.store_field("videoChatChanges", video_chat_changes_);
    s.store_field("forumChanges", forum_changes_);
    s.store_field("subscriptionExtensions", subscription_extensions_);
    s.store_class_end();
  }
}

void chatEventLogFilters::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEventLogFilters").c_str());
    message_edits_fieldID = jni::get_field_id(env, Class, "messageEdits", "Z");
    message_deletions_fieldID = jni::get_field_id(env, Class, "messageDeletions", "Z");
    message_pins_fieldID = jni::get_field_id(env, Class, "messagePins", "Z");
    member_joins_fieldID = jni::get_field_id(env, Class, "memberJoins", "Z");
    member_leaves_fieldID = jni::get_field_id(env, Class, "memberLeaves", "Z");
    member_invites_fieldID = jni::get_field_id(env, Class, "memberInvites", "Z");
    member_promotions_fieldID = jni::get_field_id(env, Class, "memberPromotions", "Z");
    member_restrictions_fieldID = jni::get_field_id(env, Class, "memberRestrictions", "Z");
    info_changes_fieldID = jni::get_field_id(env, Class, "infoChanges", "Z");
    setting_changes_fieldID = jni::get_field_id(env, Class, "settingChanges", "Z");
    invite_link_changes_fieldID = jni::get_field_id(env, Class, "inviteLinkChanges", "Z");
    video_chat_changes_fieldID = jni::get_field_id(env, Class, "videoChatChanges", "Z");
    forum_changes_fieldID = jni::get_field_id(env, Class, "forumChanges", "Z");
    subscription_extensions_fieldID = jni::get_field_id(env, Class, "subscriptionExtensions", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatEvents::Class;
jfieldID chatEvents::events_fieldID;

chatEvents::chatEvents()
  : events_()
{}

chatEvents::chatEvents(array<object_ptr<chatEvent>> &&events_)
  : events_(std::move(events_))
{}

const std::int32_t chatEvents::ID;

object_ptr<chatEvents> chatEvents::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatEvents> res = make_object<chatEvents>();
  res->events_ = jni::FetchVector<chatEvent>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->events_fieldID));
  return res;
}

void chatEvents::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, events_); if (arr_tmp_) { env->SetObjectField(s, events_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatEvents::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatEvents");
    { s.store_vector_begin("events", events_.size()); for (const auto &_value : events_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatEvents::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatEvents").c_str());
    events_fieldID = jni::get_field_id(env, Class, "events", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatEvent;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatFolder::Class;
jfieldID chatFolder::name_fieldID;
jfieldID chatFolder::icon_fieldID;
jfieldID chatFolder::color_id_fieldID;
jfieldID chatFolder::is_shareable_fieldID;
jfieldID chatFolder::pinned_chat_ids_fieldID;
jfieldID chatFolder::included_chat_ids_fieldID;
jfieldID chatFolder::excluded_chat_ids_fieldID;
jfieldID chatFolder::exclude_muted_fieldID;
jfieldID chatFolder::exclude_read_fieldID;
jfieldID chatFolder::exclude_archived_fieldID;
jfieldID chatFolder::include_contacts_fieldID;
jfieldID chatFolder::include_non_contacts_fieldID;
jfieldID chatFolder::include_bots_fieldID;
jfieldID chatFolder::include_groups_fieldID;
jfieldID chatFolder::include_channels_fieldID;

chatFolder::chatFolder()
  : name_()
  , icon_()
  , color_id_()
  , is_shareable_()
  , pinned_chat_ids_()
  , included_chat_ids_()
  , excluded_chat_ids_()
  , exclude_muted_()
  , exclude_read_()
  , exclude_archived_()
  , include_contacts_()
  , include_non_contacts_()
  , include_bots_()
  , include_groups_()
  , include_channels_()
{}

chatFolder::chatFolder(object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, array<int53> &&pinned_chat_ids_, array<int53> &&included_chat_ids_, array<int53> &&excluded_chat_ids_, bool exclude_muted_, bool exclude_read_, bool exclude_archived_, bool include_contacts_, bool include_non_contacts_, bool include_bots_, bool include_groups_, bool include_channels_)
  : name_(std::move(name_))
  , icon_(std::move(icon_))
  , color_id_(color_id_)
  , is_shareable_(is_shareable_)
  , pinned_chat_ids_(std::move(pinned_chat_ids_))
  , included_chat_ids_(std::move(included_chat_ids_))
  , excluded_chat_ids_(std::move(excluded_chat_ids_))
  , exclude_muted_(exclude_muted_)
  , exclude_read_(exclude_read_)
  , exclude_archived_(exclude_archived_)
  , include_contacts_(include_contacts_)
  , include_non_contacts_(include_non_contacts_)
  , include_bots_(include_bots_)
  , include_groups_(include_groups_)
  , include_channels_(include_channels_)
{}

const std::int32_t chatFolder::ID;

object_ptr<chatFolder> chatFolder::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolder> res = make_object<chatFolder>();
  res->name_ = jni::fetch_tl_object<chatFolderName>(env, jni::fetch_object(env, p, res->name_fieldID));
  res->icon_ = jni::fetch_tl_object<chatFolderIcon>(env, jni::fetch_object(env, p, res->icon_fieldID));
  res->color_id_ = env->GetIntField(p, res->color_id_fieldID);
  res->is_shareable_ = (env->GetBooleanField(p, res->is_shareable_fieldID) != 0);
  res->pinned_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->pinned_chat_ids_fieldID));
  res->included_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->included_chat_ids_fieldID));
  res->excluded_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->excluded_chat_ids_fieldID));
  res->exclude_muted_ = (env->GetBooleanField(p, res->exclude_muted_fieldID) != 0);
  res->exclude_read_ = (env->GetBooleanField(p, res->exclude_read_fieldID) != 0);
  res->exclude_archived_ = (env->GetBooleanField(p, res->exclude_archived_fieldID) != 0);
  res->include_contacts_ = (env->GetBooleanField(p, res->include_contacts_fieldID) != 0);
  res->include_non_contacts_ = (env->GetBooleanField(p, res->include_non_contacts_fieldID) != 0);
  res->include_bots_ = (env->GetBooleanField(p, res->include_bots_fieldID) != 0);
  res->include_groups_ = (env->GetBooleanField(p, res->include_groups_fieldID) != 0);
  res->include_channels_ = (env->GetBooleanField(p, res->include_channels_fieldID) != 0);
  return res;
}

void chatFolder::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (name_ != nullptr) { jobject next; name_->store(env, next); if (next) { env->SetObjectField(s, name_fieldID, next); env->DeleteLocalRef(next); } }
  if (icon_ != nullptr) { jobject next; icon_->store(env, next); if (next) { env->SetObjectField(s, icon_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, color_id_fieldID, color_id_);
  env->SetBooleanField(s, is_shareable_fieldID, is_shareable_);
  { auto arr_tmp_ = jni::store_vector(env, pinned_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, pinned_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, included_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, included_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, excluded_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, excluded_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  env->SetBooleanField(s, exclude_muted_fieldID, exclude_muted_);
  env->SetBooleanField(s, exclude_read_fieldID, exclude_read_);
  env->SetBooleanField(s, exclude_archived_fieldID, exclude_archived_);
  env->SetBooleanField(s, include_contacts_fieldID, include_contacts_);
  env->SetBooleanField(s, include_non_contacts_fieldID, include_non_contacts_);
  env->SetBooleanField(s, include_bots_fieldID, include_bots_);
  env->SetBooleanField(s, include_groups_fieldID, include_groups_);
  env->SetBooleanField(s, include_channels_fieldID, include_channels_);
}

void chatFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolder");
    s.store_object_field("name", static_cast<const BaseObject *>(name_.get()));
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_field("colorId", color_id_);
    s.store_field("isShareable", is_shareable_);
    { s.store_vector_begin("pinnedChatIds", pinned_chat_ids_.size()); for (const auto &_value : pinned_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("includedChatIds", included_chat_ids_.size()); for (const auto &_value : included_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("excludedChatIds", excluded_chat_ids_.size()); for (const auto &_value : excluded_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("excludeMuted", exclude_muted_);
    s.store_field("excludeRead", exclude_read_);
    s.store_field("excludeArchived", exclude_archived_);
    s.store_field("includeContacts", include_contacts_);
    s.store_field("includeNonContacts", include_non_contacts_);
    s.store_field("includeBots", include_bots_);
    s.store_field("includeGroups", include_groups_);
    s.store_field("includeChannels", include_channels_);
    s.store_class_end();
  }
}

void chatFolder::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolder").c_str());
    name_fieldID = jni::get_field_id(env, Class, "name", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatFolderName;").c_str());
    icon_fieldID = jni::get_field_id(env, Class, "icon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatFolderIcon;").c_str());
    color_id_fieldID = jni::get_field_id(env, Class, "colorId", "I");
    is_shareable_fieldID = jni::get_field_id(env, Class, "isShareable", "Z");
    pinned_chat_ids_fieldID = jni::get_field_id(env, Class, "pinnedChatIds", "[J");
    included_chat_ids_fieldID = jni::get_field_id(env, Class, "includedChatIds", "[J");
    excluded_chat_ids_fieldID = jni::get_field_id(env, Class, "excludedChatIds", "[J");
    exclude_muted_fieldID = jni::get_field_id(env, Class, "excludeMuted", "Z");
    exclude_read_fieldID = jni::get_field_id(env, Class, "excludeRead", "Z");
    exclude_archived_fieldID = jni::get_field_id(env, Class, "excludeArchived", "Z");
    include_contacts_fieldID = jni::get_field_id(env, Class, "includeContacts", "Z");
    include_non_contacts_fieldID = jni::get_field_id(env, Class, "includeNonContacts", "Z");
    include_bots_fieldID = jni::get_field_id(env, Class, "includeBots", "Z");
    include_groups_fieldID = jni::get_field_id(env, Class, "includeGroups", "Z");
    include_channels_fieldID = jni::get_field_id(env, Class, "includeChannels", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderIcon::Class;
jfieldID chatFolderIcon::name_fieldID;

chatFolderIcon::chatFolderIcon()
  : name_()
{}

chatFolderIcon::chatFolderIcon(string const &name_)
  : name_(name_)
{}

const std::int32_t chatFolderIcon::ID;

object_ptr<chatFolderIcon> chatFolderIcon::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderIcon> res = make_object<chatFolderIcon>();
  res->name_ = jni::fetch_string(env, p, res->name_fieldID);
  return res;
}

void chatFolderIcon::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, name_); if (nextString) { env->SetObjectField(s, name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatFolderIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderIcon");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

void chatFolderIcon::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderIcon").c_str());
    name_fieldID = jni::get_field_id(env, Class, "name", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderInfo::Class;
jfieldID chatFolderInfo::id_fieldID;
jfieldID chatFolderInfo::name_fieldID;
jfieldID chatFolderInfo::icon_fieldID;
jfieldID chatFolderInfo::color_id_fieldID;
jfieldID chatFolderInfo::is_shareable_fieldID;
jfieldID chatFolderInfo::has_my_invite_links_fieldID;

chatFolderInfo::chatFolderInfo()
  : id_()
  , name_()
  , icon_()
  , color_id_()
  , is_shareable_()
  , has_my_invite_links_()
{}

chatFolderInfo::chatFolderInfo(int32 id_, object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, bool has_my_invite_links_)
  : id_(id_)
  , name_(std::move(name_))
  , icon_(std::move(icon_))
  , color_id_(color_id_)
  , is_shareable_(is_shareable_)
  , has_my_invite_links_(has_my_invite_links_)
{}

const std::int32_t chatFolderInfo::ID;

object_ptr<chatFolderInfo> chatFolderInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderInfo> res = make_object<chatFolderInfo>();
  res->id_ = env->GetIntField(p, res->id_fieldID);
  res->name_ = jni::fetch_tl_object<chatFolderName>(env, jni::fetch_object(env, p, res->name_fieldID));
  res->icon_ = jni::fetch_tl_object<chatFolderIcon>(env, jni::fetch_object(env, p, res->icon_fieldID));
  res->color_id_ = env->GetIntField(p, res->color_id_fieldID);
  res->is_shareable_ = (env->GetBooleanField(p, res->is_shareable_fieldID) != 0);
  res->has_my_invite_links_ = (env->GetBooleanField(p, res->has_my_invite_links_fieldID) != 0);
  return res;
}

void chatFolderInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, id_fieldID, id_);
  if (name_ != nullptr) { jobject next; name_->store(env, next); if (next) { env->SetObjectField(s, name_fieldID, next); env->DeleteLocalRef(next); } }
  if (icon_ != nullptr) { jobject next; icon_->store(env, next); if (next) { env->SetObjectField(s, icon_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, color_id_fieldID, color_id_);
  env->SetBooleanField(s, is_shareable_fieldID, is_shareable_);
  env->SetBooleanField(s, has_my_invite_links_fieldID, has_my_invite_links_);
}

void chatFolderInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderInfo");
    s.store_field("id", id_);
    s.store_object_field("name", static_cast<const BaseObject *>(name_.get()));
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_field("colorId", color_id_);
    s.store_field("isShareable", is_shareable_);
    s.store_field("hasMyInviteLinks", has_my_invite_links_);
    s.store_class_end();
  }
}

void chatFolderInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderInfo").c_str());
    id_fieldID = jni::get_field_id(env, Class, "id", "I");
    name_fieldID = jni::get_field_id(env, Class, "name", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatFolderName;").c_str());
    icon_fieldID = jni::get_field_id(env, Class, "icon", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatFolderIcon;").c_str());
    color_id_fieldID = jni::get_field_id(env, Class, "colorId", "I");
    is_shareable_fieldID = jni::get_field_id(env, Class, "isShareable", "Z");
    has_my_invite_links_fieldID = jni::get_field_id(env, Class, "hasMyInviteLinks", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderInviteLink::Class;
jfieldID chatFolderInviteLink::invite_link_fieldID;
jfieldID chatFolderInviteLink::name_fieldID;
jfieldID chatFolderInviteLink::chat_ids_fieldID;

chatFolderInviteLink::chatFolderInviteLink()
  : invite_link_()
  , name_()
  , chat_ids_()
{}

chatFolderInviteLink::chatFolderInviteLink(string const &invite_link_, string const &name_, array<int53> &&chat_ids_)
  : invite_link_(invite_link_)
  , name_(name_)
  , chat_ids_(std::move(chat_ids_))
{}

const std::int32_t chatFolderInviteLink::ID;

object_ptr<chatFolderInviteLink> chatFolderInviteLink::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderInviteLink> res = make_object<chatFolderInviteLink>();
  res->invite_link_ = jni::fetch_string(env, p, res->invite_link_fieldID);
  res->name_ = jni::fetch_string(env, p, res->name_fieldID);
  res->chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->chat_ids_fieldID));
  return res;
}

void chatFolderInviteLink::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, invite_link_); if (nextString) { env->SetObjectField(s, invite_link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, name_); if (nextString) { env->SetObjectField(s, name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { auto arr_tmp_ = jni::store_vector(env, chat_ids_); if (arr_tmp_) { env->SetObjectField(s, chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatFolderInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderInviteLink");
    s.store_field("inviteLink", invite_link_);
    s.store_field("name", name_);
    { s.store_vector_begin("chatIds", chat_ids_.size()); for (const auto &_value : chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatFolderInviteLink::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderInviteLink").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", "Ljava/lang/String;");
    name_fieldID = jni::get_field_id(env, Class, "name", "Ljava/lang/String;");
    chat_ids_fieldID = jni::get_field_id(env, Class, "chatIds", "[J");
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderInviteLinkInfo::Class;
jfieldID chatFolderInviteLinkInfo::chat_folder_info_fieldID;
jfieldID chatFolderInviteLinkInfo::missing_chat_ids_fieldID;
jfieldID chatFolderInviteLinkInfo::added_chat_ids_fieldID;

chatFolderInviteLinkInfo::chatFolderInviteLinkInfo()
  : chat_folder_info_()
  , missing_chat_ids_()
  , added_chat_ids_()
{}

chatFolderInviteLinkInfo::chatFolderInviteLinkInfo(object_ptr<chatFolderInfo> &&chat_folder_info_, array<int53> &&missing_chat_ids_, array<int53> &&added_chat_ids_)
  : chat_folder_info_(std::move(chat_folder_info_))
  , missing_chat_ids_(std::move(missing_chat_ids_))
  , added_chat_ids_(std::move(added_chat_ids_))
{}

const std::int32_t chatFolderInviteLinkInfo::ID;

object_ptr<chatFolderInviteLinkInfo> chatFolderInviteLinkInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderInviteLinkInfo> res = make_object<chatFolderInviteLinkInfo>();
  res->chat_folder_info_ = jni::fetch_tl_object<chatFolderInfo>(env, jni::fetch_object(env, p, res->chat_folder_info_fieldID));
  res->missing_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->missing_chat_ids_fieldID));
  res->added_chat_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->added_chat_ids_fieldID));
  return res;
}

void chatFolderInviteLinkInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (chat_folder_info_ != nullptr) { jobject next; chat_folder_info_->store(env, next); if (next) { env->SetObjectField(s, chat_folder_info_fieldID, next); env->DeleteLocalRef(next); } }
  { auto arr_tmp_ = jni::store_vector(env, missing_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, missing_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  { auto arr_tmp_ = jni::store_vector(env, added_chat_ids_); if (arr_tmp_) { env->SetObjectField(s, added_chat_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatFolderInviteLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderInviteLinkInfo");
    s.store_object_field("chatFolderInfo", static_cast<const BaseObject *>(chat_folder_info_.get()));
    { s.store_vector_begin("missingChatIds", missing_chat_ids_.size()); for (const auto &_value : missing_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("addedChatIds", added_chat_ids_.size()); for (const auto &_value : added_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatFolderInviteLinkInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderInviteLinkInfo").c_str());
    chat_folder_info_fieldID = jni::get_field_id(env, Class, "chatFolderInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatFolderInfo;").c_str());
    missing_chat_ids_fieldID = jni::get_field_id(env, Class, "missingChatIds", "[J");
    added_chat_ids_fieldID = jni::get_field_id(env, Class, "addedChatIds", "[J");
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderInviteLinks::Class;
jfieldID chatFolderInviteLinks::invite_links_fieldID;

chatFolderInviteLinks::chatFolderInviteLinks()
  : invite_links_()
{}

chatFolderInviteLinks::chatFolderInviteLinks(array<object_ptr<chatFolderInviteLink>> &&invite_links_)
  : invite_links_(std::move(invite_links_))
{}

const std::int32_t chatFolderInviteLinks::ID;

object_ptr<chatFolderInviteLinks> chatFolderInviteLinks::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderInviteLinks> res = make_object<chatFolderInviteLinks>();
  res->invite_links_ = jni::FetchVector<chatFolderInviteLink>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->invite_links_fieldID));
  return res;
}

void chatFolderInviteLinks::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, invite_links_); if (arr_tmp_) { env->SetObjectField(s, invite_links_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatFolderInviteLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderInviteLinks");
    { s.store_vector_begin("inviteLinks", invite_links_.size()); for (const auto &_value : invite_links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatFolderInviteLinks::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderInviteLinks").c_str());
    invite_links_fieldID = jni::get_field_id(env, Class, "inviteLinks", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatFolderInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatFolderName::Class;
jfieldID chatFolderName::text_fieldID;
jfieldID chatFolderName::animate_custom_emoji_fieldID;

chatFolderName::chatFolderName()
  : text_()
  , animate_custom_emoji_()
{}

chatFolderName::chatFolderName(object_ptr<formattedText> &&text_, bool animate_custom_emoji_)
  : text_(std::move(text_))
  , animate_custom_emoji_(animate_custom_emoji_)
{}

const std::int32_t chatFolderName::ID;

object_ptr<chatFolderName> chatFolderName::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatFolderName> res = make_object<chatFolderName>();
  res->text_ = jni::fetch_tl_object<formattedText>(env, jni::fetch_object(env, p, res->text_fieldID));
  res->animate_custom_emoji_ = (env->GetBooleanField(p, res->animate_custom_emoji_fieldID) != 0);
  return res;
}

void chatFolderName::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (text_ != nullptr) { jobject next; text_->store(env, next); if (next) { env->SetObjectField(s, text_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, animate_custom_emoji_fieldID, animate_custom_emoji_);
}

void chatFolderName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatFolderName");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("animateCustomEmoji", animate_custom_emoji_);
    s.store_class_end();
  }
}

void chatFolderName::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatFolderName").c_str());
    text_fieldID = jni::get_field_id(env, Class, "text", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$FormattedText;").c_str());
    animate_custom_emoji_fieldID = jni::get_field_id(env, Class, "animateCustomEmoji", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLink::Class;
jfieldID chatInviteLink::invite_link_fieldID;
jfieldID chatInviteLink::name_fieldID;
jfieldID chatInviteLink::creator_user_id_fieldID;
jfieldID chatInviteLink::date_fieldID;
jfieldID chatInviteLink::edit_date_fieldID;
jfieldID chatInviteLink::expiration_date_fieldID;
jfieldID chatInviteLink::subscription_pricing_fieldID;
jfieldID chatInviteLink::member_limit_fieldID;
jfieldID chatInviteLink::member_count_fieldID;
jfieldID chatInviteLink::expired_member_count_fieldID;
jfieldID chatInviteLink::pending_join_request_count_fieldID;
jfieldID chatInviteLink::creates_join_request_fieldID;
jfieldID chatInviteLink::is_primary_fieldID;
jfieldID chatInviteLink::is_revoked_fieldID;

chatInviteLink::chatInviteLink()
  : invite_link_()
  , name_()
  , creator_user_id_()
  , date_()
  , edit_date_()
  , expiration_date_()
  , subscription_pricing_()
  , member_limit_()
  , member_count_()
  , expired_member_count_()
  , pending_join_request_count_()
  , creates_join_request_()
  , is_primary_()
  , is_revoked_()
{}

chatInviteLink::chatInviteLink(string const &invite_link_, string const &name_, int53 creator_user_id_, int32 date_, int32 edit_date_, int32 expiration_date_, object_ptr<starSubscriptionPricing> &&subscription_pricing_, int32 member_limit_, int32 member_count_, int32 expired_member_count_, int32 pending_join_request_count_, bool creates_join_request_, bool is_primary_, bool is_revoked_)
  : invite_link_(invite_link_)
  , name_(name_)
  , creator_user_id_(creator_user_id_)
  , date_(date_)
  , edit_date_(edit_date_)
  , expiration_date_(expiration_date_)
  , subscription_pricing_(std::move(subscription_pricing_))
  , member_limit_(member_limit_)
  , member_count_(member_count_)
  , expired_member_count_(expired_member_count_)
  , pending_join_request_count_(pending_join_request_count_)
  , creates_join_request_(creates_join_request_)
  , is_primary_(is_primary_)
  , is_revoked_(is_revoked_)
{}

const std::int32_t chatInviteLink::ID;

object_ptr<chatInviteLink> chatInviteLink::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLink> res = make_object<chatInviteLink>();
  res->invite_link_ = jni::fetch_string(env, p, res->invite_link_fieldID);
  res->name_ = jni::fetch_string(env, p, res->name_fieldID);
  res->creator_user_id_ = env->GetLongField(p, res->creator_user_id_fieldID);
  res->date_ = env->GetIntField(p, res->date_fieldID);
  res->edit_date_ = env->GetIntField(p, res->edit_date_fieldID);
  res->expiration_date_ = env->GetIntField(p, res->expiration_date_fieldID);
  res->subscription_pricing_ = jni::fetch_tl_object<starSubscriptionPricing>(env, jni::fetch_object(env, p, res->subscription_pricing_fieldID));
  res->member_limit_ = env->GetIntField(p, res->member_limit_fieldID);
  res->member_count_ = env->GetIntField(p, res->member_count_fieldID);
  res->expired_member_count_ = env->GetIntField(p, res->expired_member_count_fieldID);
  res->pending_join_request_count_ = env->GetIntField(p, res->pending_join_request_count_fieldID);
  res->creates_join_request_ = (env->GetBooleanField(p, res->creates_join_request_fieldID) != 0);
  res->is_primary_ = (env->GetBooleanField(p, res->is_primary_fieldID) != 0);
  res->is_revoked_ = (env->GetBooleanField(p, res->is_revoked_fieldID) != 0);
  return res;
}

void chatInviteLink::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, invite_link_); if (nextString) { env->SetObjectField(s, invite_link_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  { jstring nextString = jni::to_jstring(env, name_); if (nextString) { env->SetObjectField(s, name_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetLongField(s, creator_user_id_fieldID, creator_user_id_);
  env->SetIntField(s, date_fieldID, date_);
  env->SetIntField(s, edit_date_fieldID, edit_date_);
  env->SetIntField(s, expiration_date_fieldID, expiration_date_);
  if (subscription_pricing_ != nullptr) { jobject next; subscription_pricing_->store(env, next); if (next) { env->SetObjectField(s, subscription_pricing_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, member_limit_fieldID, member_limit_);
  env->SetIntField(s, member_count_fieldID, member_count_);
  env->SetIntField(s, expired_member_count_fieldID, expired_member_count_);
  env->SetIntField(s, pending_join_request_count_fieldID, pending_join_request_count_);
  env->SetBooleanField(s, creates_join_request_fieldID, creates_join_request_);
  env->SetBooleanField(s, is_primary_fieldID, is_primary_);
  env->SetBooleanField(s, is_revoked_fieldID, is_revoked_);
}

void chatInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLink");
    s.store_field("inviteLink", invite_link_);
    s.store_field("name", name_);
    s.store_field("creatorUserId", creator_user_id_);
    s.store_field("date", date_);
    s.store_field("editDate", edit_date_);
    s.store_field("expirationDate", expiration_date_);
    s.store_object_field("subscriptionPricing", static_cast<const BaseObject *>(subscription_pricing_.get()));
    s.store_field("memberLimit", member_limit_);
    s.store_field("memberCount", member_count_);
    s.store_field("expiredMemberCount", expired_member_count_);
    s.store_field("pendingJoinRequestCount", pending_join_request_count_);
    s.store_field("createsJoinRequest", creates_join_request_);
    s.store_field("isPrimary", is_primary_);
    s.store_field("isRevoked", is_revoked_);
    s.store_class_end();
  }
}

void chatInviteLink::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLink").c_str());
    invite_link_fieldID = jni::get_field_id(env, Class, "inviteLink", "Ljava/lang/String;");
    name_fieldID = jni::get_field_id(env, Class, "name", "Ljava/lang/String;");
    creator_user_id_fieldID = jni::get_field_id(env, Class, "creatorUserId", "J");
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    edit_date_fieldID = jni::get_field_id(env, Class, "editDate", "I");
    expiration_date_fieldID = jni::get_field_id(env, Class, "expirationDate", "I");
    subscription_pricing_fieldID = jni::get_field_id(env, Class, "subscriptionPricing", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StarSubscriptionPricing;").c_str());
    member_limit_fieldID = jni::get_field_id(env, Class, "memberLimit", "I");
    member_count_fieldID = jni::get_field_id(env, Class, "memberCount", "I");
    expired_member_count_fieldID = jni::get_field_id(env, Class, "expiredMemberCount", "I");
    pending_join_request_count_fieldID = jni::get_field_id(env, Class, "pendingJoinRequestCount", "I");
    creates_join_request_fieldID = jni::get_field_id(env, Class, "createsJoinRequest", "Z");
    is_primary_fieldID = jni::get_field_id(env, Class, "isPrimary", "Z");
    is_revoked_fieldID = jni::get_field_id(env, Class, "isRevoked", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkCount::Class;
jfieldID chatInviteLinkCount::user_id_fieldID;
jfieldID chatInviteLinkCount::invite_link_count_fieldID;
jfieldID chatInviteLinkCount::revoked_invite_link_count_fieldID;

chatInviteLinkCount::chatInviteLinkCount()
  : user_id_()
  , invite_link_count_()
  , revoked_invite_link_count_()
{}

chatInviteLinkCount::chatInviteLinkCount(int53 user_id_, int32 invite_link_count_, int32 revoked_invite_link_count_)
  : user_id_(user_id_)
  , invite_link_count_(invite_link_count_)
  , revoked_invite_link_count_(revoked_invite_link_count_)
{}

const std::int32_t chatInviteLinkCount::ID;

object_ptr<chatInviteLinkCount> chatInviteLinkCount::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkCount> res = make_object<chatInviteLinkCount>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->invite_link_count_ = env->GetIntField(p, res->invite_link_count_fieldID);
  res->revoked_invite_link_count_ = env->GetIntField(p, res->revoked_invite_link_count_fieldID);
  return res;
}

void chatInviteLinkCount::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  env->SetIntField(s, invite_link_count_fieldID, invite_link_count_);
  env->SetIntField(s, revoked_invite_link_count_fieldID, revoked_invite_link_count_);
}

void chatInviteLinkCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkCount");
    s.store_field("userId", user_id_);
    s.store_field("inviteLinkCount", invite_link_count_);
    s.store_field("revokedInviteLinkCount", revoked_invite_link_count_);
    s.store_class_end();
  }
}

void chatInviteLinkCount::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkCount").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    invite_link_count_fieldID = jni::get_field_id(env, Class, "inviteLinkCount", "I");
    revoked_invite_link_count_fieldID = jni::get_field_id(env, Class, "revokedInviteLinkCount", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkCounts::Class;
jfieldID chatInviteLinkCounts::invite_link_counts_fieldID;

chatInviteLinkCounts::chatInviteLinkCounts()
  : invite_link_counts_()
{}

chatInviteLinkCounts::chatInviteLinkCounts(array<object_ptr<chatInviteLinkCount>> &&invite_link_counts_)
  : invite_link_counts_(std::move(invite_link_counts_))
{}

const std::int32_t chatInviteLinkCounts::ID;

object_ptr<chatInviteLinkCounts> chatInviteLinkCounts::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkCounts> res = make_object<chatInviteLinkCounts>();
  res->invite_link_counts_ = jni::FetchVector<chatInviteLinkCount>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->invite_link_counts_fieldID));
  return res;
}

void chatInviteLinkCounts::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, invite_link_counts_); if (arr_tmp_) { env->SetObjectField(s, invite_link_counts_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatInviteLinkCounts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkCounts");
    { s.store_vector_begin("inviteLinkCounts", invite_link_counts_.size()); for (const auto &_value : invite_link_counts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatInviteLinkCounts::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkCounts").c_str());
    invite_link_counts_fieldID = jni::get_field_id(env, Class, "inviteLinkCounts", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatInviteLinkCount;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkInfo::Class;
jfieldID chatInviteLinkInfo::chat_id_fieldID;
jfieldID chatInviteLinkInfo::accessible_for_fieldID;
jfieldID chatInviteLinkInfo::type_fieldID;
jfieldID chatInviteLinkInfo::title_fieldID;
jfieldID chatInviteLinkInfo::photo_fieldID;
jfieldID chatInviteLinkInfo::accent_color_id_fieldID;
jfieldID chatInviteLinkInfo::description_fieldID;
jfieldID chatInviteLinkInfo::member_count_fieldID;
jfieldID chatInviteLinkInfo::member_user_ids_fieldID;
jfieldID chatInviteLinkInfo::subscription_info_fieldID;
jfieldID chatInviteLinkInfo::creates_join_request_fieldID;
jfieldID chatInviteLinkInfo::is_public_fieldID;
jfieldID chatInviteLinkInfo::verification_status_fieldID;

chatInviteLinkInfo::chatInviteLinkInfo()
  : chat_id_()
  , accessible_for_()
  , type_()
  , title_()
  , photo_()
  , accent_color_id_()
  , description_()
  , member_count_()
  , member_user_ids_()
  , subscription_info_()
  , creates_join_request_()
  , is_public_()
  , verification_status_()
{}

chatInviteLinkInfo::chatInviteLinkInfo(int53 chat_id_, int32 accessible_for_, object_ptr<InviteLinkChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, string const &description_, int32 member_count_, array<int53> &&member_user_ids_, object_ptr<chatInviteLinkSubscriptionInfo> &&subscription_info_, bool creates_join_request_, bool is_public_, object_ptr<verificationStatus> &&verification_status_)
  : chat_id_(chat_id_)
  , accessible_for_(accessible_for_)
  , type_(std::move(type_))
  , title_(title_)
  , photo_(std::move(photo_))
  , accent_color_id_(accent_color_id_)
  , description_(description_)
  , member_count_(member_count_)
  , member_user_ids_(std::move(member_user_ids_))
  , subscription_info_(std::move(subscription_info_))
  , creates_join_request_(creates_join_request_)
  , is_public_(is_public_)
  , verification_status_(std::move(verification_status_))
{}

const std::int32_t chatInviteLinkInfo::ID;

object_ptr<chatInviteLinkInfo> chatInviteLinkInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkInfo> res = make_object<chatInviteLinkInfo>();
  res->chat_id_ = env->GetLongField(p, res->chat_id_fieldID);
  res->accessible_for_ = env->GetIntField(p, res->accessible_for_fieldID);
  res->type_ = jni::fetch_tl_object<InviteLinkChatType>(env, jni::fetch_object(env, p, res->type_fieldID));
  res->title_ = jni::fetch_string(env, p, res->title_fieldID);
  res->photo_ = jni::fetch_tl_object<chatPhotoInfo>(env, jni::fetch_object(env, p, res->photo_fieldID));
  res->accent_color_id_ = env->GetIntField(p, res->accent_color_id_fieldID);
  res->description_ = jni::fetch_string(env, p, res->description_fieldID);
  res->member_count_ = env->GetIntField(p, res->member_count_fieldID);
  res->member_user_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->member_user_ids_fieldID));
  res->subscription_info_ = jni::fetch_tl_object<chatInviteLinkSubscriptionInfo>(env, jni::fetch_object(env, p, res->subscription_info_fieldID));
  res->creates_join_request_ = (env->GetBooleanField(p, res->creates_join_request_fieldID) != 0);
  res->is_public_ = (env->GetBooleanField(p, res->is_public_fieldID) != 0);
  res->verification_status_ = jni::fetch_tl_object<verificationStatus>(env, jni::fetch_object(env, p, res->verification_status_fieldID));
  return res;
}

void chatInviteLinkInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, chat_id_fieldID, chat_id_);
  env->SetIntField(s, accessible_for_fieldID, accessible_for_);
  if (type_ != nullptr) { jobject next; type_->store(env, next); if (next) { env->SetObjectField(s, type_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, title_); if (nextString) { env->SetObjectField(s, title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  if (photo_ != nullptr) { jobject next; photo_->store(env, next); if (next) { env->SetObjectField(s, photo_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetIntField(s, accent_color_id_fieldID, accent_color_id_);
  { jstring nextString = jni::to_jstring(env, description_); if (nextString) { env->SetObjectField(s, description_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetIntField(s, member_count_fieldID, member_count_);
  { auto arr_tmp_ = jni::store_vector(env, member_user_ids_); if (arr_tmp_) { env->SetObjectField(s, member_user_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
  if (subscription_info_ != nullptr) { jobject next; subscription_info_->store(env, next); if (next) { env->SetObjectField(s, subscription_info_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, creates_join_request_fieldID, creates_join_request_);
  env->SetBooleanField(s, is_public_fieldID, is_public_);
  if (verification_status_ != nullptr) { jobject next; verification_status_->store(env, next); if (next) { env->SetObjectField(s, verification_status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatInviteLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkInfo");
    s.store_field("chatId", chat_id_);
    s.store_field("accessibleFor", accessible_for_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("accentColorId", accent_color_id_);
    s.store_field("description", description_);
    s.store_field("memberCount", member_count_);
    { s.store_vector_begin("memberUserIds", member_user_ids_.size()); for (const auto &_value : member_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_object_field("subscriptionInfo", static_cast<const BaseObject *>(subscription_info_.get()));
    s.store_field("createsJoinRequest", creates_join_request_);
    s.store_field("isPublic", is_public_);
    s.store_object_field("verificationStatus", static_cast<const BaseObject *>(verification_status_.get()));
    s.store_class_end();
  }
}

void chatInviteLinkInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkInfo").c_str());
    chat_id_fieldID = jni::get_field_id(env, Class, "chatId", "J");
    accessible_for_fieldID = jni::get_field_id(env, Class, "accessibleFor", "I");
    type_fieldID = jni::get_field_id(env, Class, "type", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$InviteLinkChatType;").c_str());
    title_fieldID = jni::get_field_id(env, Class, "title", "Ljava/lang/String;");
    photo_fieldID = jni::get_field_id(env, Class, "photo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPhotoInfo;").c_str());
    accent_color_id_fieldID = jni::get_field_id(env, Class, "accentColorId", "I");
    description_fieldID = jni::get_field_id(env, Class, "description", "Ljava/lang/String;");
    member_count_fieldID = jni::get_field_id(env, Class, "memberCount", "I");
    member_user_ids_fieldID = jni::get_field_id(env, Class, "memberUserIds", "[J");
    subscription_info_fieldID = jni::get_field_id(env, Class, "subscriptionInfo", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatInviteLinkSubscriptionInfo;").c_str());
    creates_join_request_fieldID = jni::get_field_id(env, Class, "createsJoinRequest", "Z");
    is_public_fieldID = jni::get_field_id(env, Class, "isPublic", "Z");
    verification_status_fieldID = jni::get_field_id(env, Class, "verificationStatus", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$VerificationStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkMember::Class;
jfieldID chatInviteLinkMember::user_id_fieldID;
jfieldID chatInviteLinkMember::joined_chat_date_fieldID;
jfieldID chatInviteLinkMember::via_chat_folder_invite_link_fieldID;
jfieldID chatInviteLinkMember::approver_user_id_fieldID;

chatInviteLinkMember::chatInviteLinkMember()
  : user_id_()
  , joined_chat_date_()
  , via_chat_folder_invite_link_()
  , approver_user_id_()
{}

chatInviteLinkMember::chatInviteLinkMember(int53 user_id_, int32 joined_chat_date_, bool via_chat_folder_invite_link_, int53 approver_user_id_)
  : user_id_(user_id_)
  , joined_chat_date_(joined_chat_date_)
  , via_chat_folder_invite_link_(via_chat_folder_invite_link_)
  , approver_user_id_(approver_user_id_)
{}

const std::int32_t chatInviteLinkMember::ID;

object_ptr<chatInviteLinkMember> chatInviteLinkMember::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkMember> res = make_object<chatInviteLinkMember>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->joined_chat_date_ = env->GetIntField(p, res->joined_chat_date_fieldID);
  res->via_chat_folder_invite_link_ = (env->GetBooleanField(p, res->via_chat_folder_invite_link_fieldID) != 0);
  res->approver_user_id_ = env->GetLongField(p, res->approver_user_id_fieldID);
  return res;
}

void chatInviteLinkMember::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  env->SetIntField(s, joined_chat_date_fieldID, joined_chat_date_);
  env->SetBooleanField(s, via_chat_folder_invite_link_fieldID, via_chat_folder_invite_link_);
  env->SetLongField(s, approver_user_id_fieldID, approver_user_id_);
}

void chatInviteLinkMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkMember");
    s.store_field("userId", user_id_);
    s.store_field("joinedChatDate", joined_chat_date_);
    s.store_field("viaChatFolderInviteLink", via_chat_folder_invite_link_);
    s.store_field("approverUserId", approver_user_id_);
    s.store_class_end();
  }
}

void chatInviteLinkMember::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkMember").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    joined_chat_date_fieldID = jni::get_field_id(env, Class, "joinedChatDate", "I");
    via_chat_folder_invite_link_fieldID = jni::get_field_id(env, Class, "viaChatFolderInviteLink", "Z");
    approver_user_id_fieldID = jni::get_field_id(env, Class, "approverUserId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkMembers::Class;
jfieldID chatInviteLinkMembers::total_count_fieldID;
jfieldID chatInviteLinkMembers::members_fieldID;

chatInviteLinkMembers::chatInviteLinkMembers()
  : total_count_()
  , members_()
{}

chatInviteLinkMembers::chatInviteLinkMembers(int32 total_count_, array<object_ptr<chatInviteLinkMember>> &&members_)
  : total_count_(total_count_)
  , members_(std::move(members_))
{}

const std::int32_t chatInviteLinkMembers::ID;

object_ptr<chatInviteLinkMembers> chatInviteLinkMembers::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkMembers> res = make_object<chatInviteLinkMembers>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->members_ = jni::FetchVector<chatInviteLinkMember>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->members_fieldID));
  return res;
}

void chatInviteLinkMembers::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, members_); if (arr_tmp_) { env->SetObjectField(s, members_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatInviteLinkMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkMembers");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatInviteLinkMembers::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkMembers").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    members_fieldID = jni::get_field_id(env, Class, "members", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatInviteLinkMember;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinkSubscriptionInfo::Class;
jfieldID chatInviteLinkSubscriptionInfo::pricing_fieldID;
jfieldID chatInviteLinkSubscriptionInfo::can_reuse_fieldID;
jfieldID chatInviteLinkSubscriptionInfo::form_id_fieldID;

chatInviteLinkSubscriptionInfo::chatInviteLinkSubscriptionInfo()
  : pricing_()
  , can_reuse_()
  , form_id_()
{}

chatInviteLinkSubscriptionInfo::chatInviteLinkSubscriptionInfo(object_ptr<starSubscriptionPricing> &&pricing_, bool can_reuse_, int64 form_id_)
  : pricing_(std::move(pricing_))
  , can_reuse_(can_reuse_)
  , form_id_(form_id_)
{}

const std::int32_t chatInviteLinkSubscriptionInfo::ID;

object_ptr<chatInviteLinkSubscriptionInfo> chatInviteLinkSubscriptionInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinkSubscriptionInfo> res = make_object<chatInviteLinkSubscriptionInfo>();
  res->pricing_ = jni::fetch_tl_object<starSubscriptionPricing>(env, jni::fetch_object(env, p, res->pricing_fieldID));
  res->can_reuse_ = (env->GetBooleanField(p, res->can_reuse_fieldID) != 0);
  res->form_id_ = env->GetLongField(p, res->form_id_fieldID);
  return res;
}

void chatInviteLinkSubscriptionInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (pricing_ != nullptr) { jobject next; pricing_->store(env, next); if (next) { env->SetObjectField(s, pricing_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, can_reuse_fieldID, can_reuse_);
  env->SetLongField(s, form_id_fieldID, form_id_);
}

void chatInviteLinkSubscriptionInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinkSubscriptionInfo");
    s.store_object_field("pricing", static_cast<const BaseObject *>(pricing_.get()));
    s.store_field("canReuse", can_reuse_);
    s.store_field("formId", form_id_);
    s.store_class_end();
  }
}

void chatInviteLinkSubscriptionInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinkSubscriptionInfo").c_str());
    pricing_fieldID = jni::get_field_id(env, Class, "pricing", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$StarSubscriptionPricing;").c_str());
    can_reuse_fieldID = jni::get_field_id(env, Class, "canReuse", "Z");
    form_id_fieldID = jni::get_field_id(env, Class, "formId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatInviteLinks::Class;
jfieldID chatInviteLinks::total_count_fieldID;
jfieldID chatInviteLinks::invite_links_fieldID;

chatInviteLinks::chatInviteLinks()
  : total_count_()
  , invite_links_()
{}

chatInviteLinks::chatInviteLinks(int32 total_count_, array<object_ptr<chatInviteLink>> &&invite_links_)
  : total_count_(total_count_)
  , invite_links_(std::move(invite_links_))
{}

const std::int32_t chatInviteLinks::ID;

object_ptr<chatInviteLinks> chatInviteLinks::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatInviteLinks> res = make_object<chatInviteLinks>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->invite_links_ = jni::FetchVector<chatInviteLink>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->invite_links_fieldID));
  return res;
}

void chatInviteLinks::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, invite_links_); if (arr_tmp_) { env->SetObjectField(s, invite_links_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatInviteLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatInviteLinks");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("inviteLinks", invite_links_.size()); for (const auto &_value : invite_links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatInviteLinks::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatInviteLinks").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    invite_links_fieldID = jni::get_field_id(env, Class, "inviteLinks", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatInviteLink;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatJoinRequest::Class;
jfieldID chatJoinRequest::user_id_fieldID;
jfieldID chatJoinRequest::date_fieldID;
jfieldID chatJoinRequest::bio_fieldID;

chatJoinRequest::chatJoinRequest()
  : user_id_()
  , date_()
  , bio_()
{}

chatJoinRequest::chatJoinRequest(int53 user_id_, int32 date_, string const &bio_)
  : user_id_(user_id_)
  , date_(date_)
  , bio_(bio_)
{}

const std::int32_t chatJoinRequest::ID;

object_ptr<chatJoinRequest> chatJoinRequest::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatJoinRequest> res = make_object<chatJoinRequest>();
  res->user_id_ = env->GetLongField(p, res->user_id_fieldID);
  res->date_ = env->GetIntField(p, res->date_fieldID);
  res->bio_ = jni::fetch_string(env, p, res->bio_fieldID);
  return res;
}

void chatJoinRequest::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetLongField(s, user_id_fieldID, user_id_);
  env->SetIntField(s, date_fieldID, date_);
  { jstring nextString = jni::to_jstring(env, bio_); if (nextString) { env->SetObjectField(s, bio_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatJoinRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatJoinRequest");
    s.store_field("userId", user_id_);
    s.store_field("date", date_);
    s.store_field("bio", bio_);
    s.store_class_end();
  }
}

void chatJoinRequest::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatJoinRequest").c_str());
    user_id_fieldID = jni::get_field_id(env, Class, "userId", "J");
    date_fieldID = jni::get_field_id(env, Class, "date", "I");
    bio_fieldID = jni::get_field_id(env, Class, "bio", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatJoinRequests::Class;
jfieldID chatJoinRequests::total_count_fieldID;
jfieldID chatJoinRequests::requests_fieldID;

chatJoinRequests::chatJoinRequests()
  : total_count_()
  , requests_()
{}

chatJoinRequests::chatJoinRequests(int32 total_count_, array<object_ptr<chatJoinRequest>> &&requests_)
  : total_count_(total_count_)
  , requests_(std::move(requests_))
{}

const std::int32_t chatJoinRequests::ID;

object_ptr<chatJoinRequests> chatJoinRequests::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatJoinRequests> res = make_object<chatJoinRequests>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->requests_ = jni::FetchVector<chatJoinRequest>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->requests_fieldID));
  return res;
}

void chatJoinRequests::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, requests_); if (arr_tmp_) { env->SetObjectField(s, requests_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatJoinRequests::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatJoinRequests");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("requests", requests_.size()); for (const auto &_value : requests_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatJoinRequests::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatJoinRequests").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    requests_fieldID = jni::get_field_id(env, Class, "requests", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatJoinRequest;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatJoinRequestsInfo::Class;
jfieldID chatJoinRequestsInfo::total_count_fieldID;
jfieldID chatJoinRequestsInfo::user_ids_fieldID;

chatJoinRequestsInfo::chatJoinRequestsInfo()
  : total_count_()
  , user_ids_()
{}

chatJoinRequestsInfo::chatJoinRequestsInfo(int32 total_count_, array<int53> &&user_ids_)
  : total_count_(total_count_)
  , user_ids_(std::move(user_ids_))
{}

const std::int32_t chatJoinRequestsInfo::ID;

object_ptr<chatJoinRequestsInfo> chatJoinRequestsInfo::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatJoinRequestsInfo> res = make_object<chatJoinRequestsInfo>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->user_ids_ = jni::fetch_vector(env, (jlongArray)jni::fetch_object(env, p, res->user_ids_fieldID));
  return res;
}

void chatJoinRequestsInfo::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, user_ids_); if (arr_tmp_) { env->SetObjectField(s, user_ids_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatJoinRequestsInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatJoinRequestsInfo");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("userIds", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatJoinRequestsInfo::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatJoinRequestsInfo").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    user_ids_fieldID = jni::get_field_id(env, Class, "userIds", "[J");
    return true;
  }();
  (void)is_inited;
}

jclass ChatList::Class;

object_ptr<ChatList> ChatList::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatListMain::ID:
      return chatListMain::fetch(env, p);
    case chatListArchive::ID:
      return chatListArchive::fetch(env, p);
    case chatListFolder::ID:
      return chatListFolder::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatList::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatList").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatListMain::Class;

chatListMain::chatListMain() {
}

const std::int32_t chatListMain::ID;

object_ptr<ChatList> chatListMain::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatListMain>();
}

void chatListMain::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatListMain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatListMain");
    s.store_class_end();
  }
}

void chatListMain::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatListMain").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatListArchive::Class;

chatListArchive::chatListArchive() {
}

const std::int32_t chatListArchive::ID;

object_ptr<ChatList> chatListArchive::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatListArchive>();
}

void chatListArchive::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatListArchive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatListArchive");
    s.store_class_end();
  }
}

void chatListArchive::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatListArchive").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatListFolder::Class;
jfieldID chatListFolder::chat_folder_id_fieldID;

chatListFolder::chatListFolder()
  : chat_folder_id_()
{}

chatListFolder::chatListFolder(int32 chat_folder_id_)
  : chat_folder_id_(chat_folder_id_)
{}

const std::int32_t chatListFolder::ID;

object_ptr<ChatList> chatListFolder::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatListFolder> res = make_object<chatListFolder>();
  res->chat_folder_id_ = env->GetIntField(p, res->chat_folder_id_fieldID);
  return std::move(res);
}

void chatListFolder::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, chat_folder_id_fieldID, chat_folder_id_);
}

void chatListFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatListFolder");
    s.store_field("chatFolderId", chat_folder_id_);
    s.store_class_end();
  }
}

void chatListFolder::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatListFolder").c_str());
    chat_folder_id_fieldID = jni::get_field_id(env, Class, "chatFolderId", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatLists::Class;
jfieldID chatLists::chat_lists_fieldID;

chatLists::chatLists()
  : chat_lists_()
{}

chatLists::chatLists(array<object_ptr<ChatList>> &&chat_lists_)
  : chat_lists_(std::move(chat_lists_))
{}

const std::int32_t chatLists::ID;

object_ptr<chatLists> chatLists::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatLists> res = make_object<chatLists>();
  res->chat_lists_ = jni::FetchVector<ChatList>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->chat_lists_fieldID));
  return res;
}

void chatLists::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, chat_lists_); if (arr_tmp_) { env->SetObjectField(s, chat_lists_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatLists::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatLists");
    { s.store_vector_begin("chatLists", chat_lists_.size()); for (const auto &_value : chat_lists_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatLists::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatLists").c_str());
    chat_lists_fieldID = jni::get_field_id(env, Class, "chatLists", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatList;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatLocation::Class;
jfieldID chatLocation::location_fieldID;
jfieldID chatLocation::address_fieldID;

chatLocation::chatLocation()
  : location_()
  , address_()
{}

chatLocation::chatLocation(object_ptr<location> &&location_, string const &address_)
  : location_(std::move(location_))
  , address_(address_)
{}

const std::int32_t chatLocation::ID;

object_ptr<chatLocation> chatLocation::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatLocation> res = make_object<chatLocation>();
  res->location_ = jni::fetch_tl_object<location>(env, jni::fetch_object(env, p, res->location_fieldID));
  res->address_ = jni::fetch_string(env, p, res->address_fieldID);
  return res;
}

void chatLocation::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (location_ != nullptr) { jobject next; location_->store(env, next); if (next) { env->SetObjectField(s, location_fieldID, next); env->DeleteLocalRef(next); } }
  { jstring nextString = jni::to_jstring(env, address_); if (nextString) { env->SetObjectField(s, address_fieldID, nextString); env->DeleteLocalRef(nextString); } }
}

void chatLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("address", address_);
    s.store_class_end();
  }
}

void chatLocation::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatLocation").c_str());
    location_fieldID = jni::get_field_id(env, Class, "location", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$Location;").c_str());
    address_fieldID = jni::get_field_id(env, Class, "address", "Ljava/lang/String;");
    return true;
  }();
  (void)is_inited;
}

jclass chatMember::Class;
jfieldID chatMember::member_id_fieldID;
jfieldID chatMember::inviter_user_id_fieldID;
jfieldID chatMember::joined_chat_date_fieldID;
jfieldID chatMember::status_fieldID;

chatMember::chatMember()
  : member_id_()
  , inviter_user_id_()
  , joined_chat_date_()
  , status_()
{}

chatMember::chatMember(object_ptr<MessageSender> &&member_id_, int53 inviter_user_id_, int32 joined_chat_date_, object_ptr<ChatMemberStatus> &&status_)
  : member_id_(std::move(member_id_))
  , inviter_user_id_(inviter_user_id_)
  , joined_chat_date_(joined_chat_date_)
  , status_(std::move(status_))
{}

const std::int32_t chatMember::ID;

object_ptr<chatMember> chatMember::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMember> res = make_object<chatMember>();
  res->member_id_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->member_id_fieldID));
  res->inviter_user_id_ = env->GetLongField(p, res->inviter_user_id_fieldID);
  res->joined_chat_date_ = env->GetIntField(p, res->joined_chat_date_fieldID);
  res->status_ = jni::fetch_tl_object<ChatMemberStatus>(env, jni::fetch_object(env, p, res->status_fieldID));
  return res;
}

void chatMember::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (member_id_ != nullptr) { jobject next; member_id_->store(env, next); if (next) { env->SetObjectField(s, member_id_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetLongField(s, inviter_user_id_fieldID, inviter_user_id_);
  env->SetIntField(s, joined_chat_date_fieldID, joined_chat_date_);
  if (status_ != nullptr) { jobject next; status_->store(env, next); if (next) { env->SetObjectField(s, status_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMember");
    s.store_object_field("memberId", static_cast<const BaseObject *>(member_id_.get()));
    s.store_field("inviterUserId", inviter_user_id_);
    s.store_field("joinedChatDate", joined_chat_date_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_class_end();
  }
}

void chatMember::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMember").c_str());
    member_id_fieldID = jni::get_field_id(env, Class, "memberId", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    inviter_user_id_fieldID = jni::get_field_id(env, Class, "inviterUserId", "J");
    joined_chat_date_fieldID = jni::get_field_id(env, Class, "joinedChatDate", "I");
    status_fieldID = jni::get_field_id(env, Class, "status", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatMemberStatus;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatMemberStatus::Class;

object_ptr<ChatMemberStatus> ChatMemberStatus::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatMemberStatusCreator::ID:
      return chatMemberStatusCreator::fetch(env, p);
    case chatMemberStatusAdministrator::ID:
      return chatMemberStatusAdministrator::fetch(env, p);
    case chatMemberStatusMember::ID:
      return chatMemberStatusMember::fetch(env, p);
    case chatMemberStatusRestricted::ID:
      return chatMemberStatusRestricted::fetch(env, p);
    case chatMemberStatusLeft::ID:
      return chatMemberStatusLeft::fetch(env, p);
    case chatMemberStatusBanned::ID:
      return chatMemberStatusBanned::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatMemberStatus::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatus").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusCreator::Class;
jfieldID chatMemberStatusCreator::custom_title_fieldID;
jfieldID chatMemberStatusCreator::is_anonymous_fieldID;
jfieldID chatMemberStatusCreator::is_member_fieldID;

chatMemberStatusCreator::chatMemberStatusCreator()
  : custom_title_()
  , is_anonymous_()
  , is_member_()
{}

chatMemberStatusCreator::chatMemberStatusCreator(string const &custom_title_, bool is_anonymous_, bool is_member_)
  : custom_title_(custom_title_)
  , is_anonymous_(is_anonymous_)
  , is_member_(is_member_)
{}

const std::int32_t chatMemberStatusCreator::ID;

object_ptr<ChatMemberStatus> chatMemberStatusCreator::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMemberStatusCreator> res = make_object<chatMemberStatusCreator>();
  res->custom_title_ = jni::fetch_string(env, p, res->custom_title_fieldID);
  res->is_anonymous_ = (env->GetBooleanField(p, res->is_anonymous_fieldID) != 0);
  res->is_member_ = (env->GetBooleanField(p, res->is_member_fieldID) != 0);
  return std::move(res);
}

void chatMemberStatusCreator::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, custom_title_); if (nextString) { env->SetObjectField(s, custom_title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, is_anonymous_fieldID, is_anonymous_);
  env->SetBooleanField(s, is_member_fieldID, is_member_);
}

void chatMemberStatusCreator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusCreator");
    s.store_field("customTitle", custom_title_);
    s.store_field("isAnonymous", is_anonymous_);
    s.store_field("isMember", is_member_);
    s.store_class_end();
  }
}

void chatMemberStatusCreator::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusCreator").c_str());
    custom_title_fieldID = jni::get_field_id(env, Class, "customTitle", "Ljava/lang/String;");
    is_anonymous_fieldID = jni::get_field_id(env, Class, "isAnonymous", "Z");
    is_member_fieldID = jni::get_field_id(env, Class, "isMember", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusAdministrator::Class;
jfieldID chatMemberStatusAdministrator::custom_title_fieldID;
jfieldID chatMemberStatusAdministrator::can_be_edited_fieldID;
jfieldID chatMemberStatusAdministrator::rights_fieldID;

chatMemberStatusAdministrator::chatMemberStatusAdministrator()
  : custom_title_()
  , can_be_edited_()
  , rights_()
{}

chatMemberStatusAdministrator::chatMemberStatusAdministrator(string const &custom_title_, bool can_be_edited_, object_ptr<chatAdministratorRights> &&rights_)
  : custom_title_(custom_title_)
  , can_be_edited_(can_be_edited_)
  , rights_(std::move(rights_))
{}

const std::int32_t chatMemberStatusAdministrator::ID;

object_ptr<ChatMemberStatus> chatMemberStatusAdministrator::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMemberStatusAdministrator> res = make_object<chatMemberStatusAdministrator>();
  res->custom_title_ = jni::fetch_string(env, p, res->custom_title_fieldID);
  res->can_be_edited_ = (env->GetBooleanField(p, res->can_be_edited_fieldID) != 0);
  res->rights_ = jni::fetch_tl_object<chatAdministratorRights>(env, jni::fetch_object(env, p, res->rights_fieldID));
  return std::move(res);
}

void chatMemberStatusAdministrator::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { jstring nextString = jni::to_jstring(env, custom_title_); if (nextString) { env->SetObjectField(s, custom_title_fieldID, nextString); env->DeleteLocalRef(nextString); } }
  env->SetBooleanField(s, can_be_edited_fieldID, can_be_edited_);
  if (rights_ != nullptr) { jobject next; rights_->store(env, next); if (next) { env->SetObjectField(s, rights_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatMemberStatusAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusAdministrator");
    s.store_field("customTitle", custom_title_);
    s.store_field("canBeEdited", can_be_edited_);
    s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get()));
    s.store_class_end();
  }
}

void chatMemberStatusAdministrator::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusAdministrator").c_str());
    custom_title_fieldID = jni::get_field_id(env, Class, "customTitle", "Ljava/lang/String;");
    can_be_edited_fieldID = jni::get_field_id(env, Class, "canBeEdited", "Z");
    rights_fieldID = jni::get_field_id(env, Class, "rights", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatAdministratorRights;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusMember::Class;
jfieldID chatMemberStatusMember::member_until_date_fieldID;

chatMemberStatusMember::chatMemberStatusMember()
  : member_until_date_()
{}

chatMemberStatusMember::chatMemberStatusMember(int32 member_until_date_)
  : member_until_date_(member_until_date_)
{}

const std::int32_t chatMemberStatusMember::ID;

object_ptr<ChatMemberStatus> chatMemberStatusMember::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMemberStatusMember> res = make_object<chatMemberStatusMember>();
  res->member_until_date_ = env->GetIntField(p, res->member_until_date_fieldID);
  return std::move(res);
}

void chatMemberStatusMember::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, member_until_date_fieldID, member_until_date_);
}

void chatMemberStatusMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusMember");
    s.store_field("memberUntilDate", member_until_date_);
    s.store_class_end();
  }
}

void chatMemberStatusMember::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusMember").c_str());
    member_until_date_fieldID = jni::get_field_id(env, Class, "memberUntilDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusRestricted::Class;
jfieldID chatMemberStatusRestricted::is_member_fieldID;
jfieldID chatMemberStatusRestricted::restricted_until_date_fieldID;
jfieldID chatMemberStatusRestricted::permissions_fieldID;

chatMemberStatusRestricted::chatMemberStatusRestricted()
  : is_member_()
  , restricted_until_date_()
  , permissions_()
{}

chatMemberStatusRestricted::chatMemberStatusRestricted(bool is_member_, int32 restricted_until_date_, object_ptr<chatPermissions> &&permissions_)
  : is_member_(is_member_)
  , restricted_until_date_(restricted_until_date_)
  , permissions_(std::move(permissions_))
{}

const std::int32_t chatMemberStatusRestricted::ID;

object_ptr<ChatMemberStatus> chatMemberStatusRestricted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMemberStatusRestricted> res = make_object<chatMemberStatusRestricted>();
  res->is_member_ = (env->GetBooleanField(p, res->is_member_fieldID) != 0);
  res->restricted_until_date_ = env->GetIntField(p, res->restricted_until_date_fieldID);
  res->permissions_ = jni::fetch_tl_object<chatPermissions>(env, jni::fetch_object(env, p, res->permissions_fieldID));
  return std::move(res);
}

void chatMemberStatusRestricted::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, is_member_fieldID, is_member_);
  env->SetIntField(s, restricted_until_date_fieldID, restricted_until_date_);
  if (permissions_ != nullptr) { jobject next; permissions_->store(env, next); if (next) { env->SetObjectField(s, permissions_fieldID, next); env->DeleteLocalRef(next); } }
}

void chatMemberStatusRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusRestricted");
    s.store_field("isMember", is_member_);
    s.store_field("restrictedUntilDate", restricted_until_date_);
    s.store_object_field("permissions", static_cast<const BaseObject *>(permissions_.get()));
    s.store_class_end();
  }
}

void chatMemberStatusRestricted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusRestricted").c_str());
    is_member_fieldID = jni::get_field_id(env, Class, "isMember", "Z");
    restricted_until_date_fieldID = jni::get_field_id(env, Class, "restrictedUntilDate", "I");
    permissions_fieldID = jni::get_field_id(env, Class, "permissions", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$ChatPermissions;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusLeft::Class;

chatMemberStatusLeft::chatMemberStatusLeft() {
}

const std::int32_t chatMemberStatusLeft::ID;

object_ptr<ChatMemberStatus> chatMemberStatusLeft::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMemberStatusLeft>();
}

void chatMemberStatusLeft::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
}

void chatMemberStatusLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusLeft");
    s.store_class_end();
  }
}

void chatMemberStatusLeft::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusLeft").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMemberStatusBanned::Class;
jfieldID chatMemberStatusBanned::banned_until_date_fieldID;

chatMemberStatusBanned::chatMemberStatusBanned()
  : banned_until_date_()
{}

chatMemberStatusBanned::chatMemberStatusBanned(int32 banned_until_date_)
  : banned_until_date_(banned_until_date_)
{}

const std::int32_t chatMemberStatusBanned::ID;

object_ptr<ChatMemberStatus> chatMemberStatusBanned::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMemberStatusBanned> res = make_object<chatMemberStatusBanned>();
  res->banned_until_date_ = env->GetIntField(p, res->banned_until_date_fieldID);
  return std::move(res);
}

void chatMemberStatusBanned::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, banned_until_date_fieldID, banned_until_date_);
}

void chatMemberStatusBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMemberStatusBanned");
    s.store_field("bannedUntilDate", banned_until_date_);
    s.store_class_end();
  }
}

void chatMemberStatusBanned::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMemberStatusBanned").c_str());
    banned_until_date_fieldID = jni::get_field_id(env, Class, "bannedUntilDate", "I");
    return true;
  }();
  (void)is_inited;
}

jclass chatMembers::Class;
jfieldID chatMembers::total_count_fieldID;
jfieldID chatMembers::members_fieldID;

chatMembers::chatMembers()
  : total_count_()
  , members_()
{}

chatMembers::chatMembers(int32 total_count_, array<object_ptr<chatMember>> &&members_)
  : total_count_(total_count_)
  , members_(std::move(members_))
{}

const std::int32_t chatMembers::ID;

object_ptr<chatMembers> chatMembers::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMembers> res = make_object<chatMembers>();
  res->total_count_ = env->GetIntField(p, res->total_count_fieldID);
  res->members_ = jni::FetchVector<chatMember>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->members_fieldID));
  return res;
}

void chatMembers::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetIntField(s, total_count_fieldID, total_count_);
  { auto arr_tmp_ = jni::store_vector(env, members_); if (arr_tmp_) { env->SetObjectField(s, members_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembers");
    s.store_field("totalCount", total_count_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatMembers::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembers").c_str());
    total_count_fieldID = jni::get_field_id(env, Class, "totalCount", "I");
    members_fieldID = jni::get_field_id(env, Class, "members", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatMember;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass ChatMembersFilter::Class;

object_ptr<ChatMembersFilter> ChatMembersFilter::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) { return nullptr; }
  jint constructor = env->CallIntMethod(p, jni::GetConstructorID);  switch (constructor) {
    case chatMembersFilterContacts::ID:
      return chatMembersFilterContacts::fetch(env, p);
    case chatMembersFilterAdministrators::ID:
      return chatMembersFilterAdministrators::fetch(env, p);
    case chatMembersFilterMembers::ID:
      return chatMembersFilterMembers::fetch(env, p);
    case chatMembersFilterMention::ID:
      return chatMembersFilterMention::fetch(env, p);
    case chatMembersFilterRestricted::ID:
      return chatMembersFilterRestricted::fetch(env, p);
    case chatMembersFilterBanned::ID:
      return chatMembersFilterBanned::fetch(env, p);
    case chatMembersFilterBots::ID:
      return chatMembersFilterBots::fetch(env, p);
    default:
      LOG(WARNING) << "Unknown Java API constructor found " << format::as_hex(constructor);
      return nullptr;
  }
}

void ChatMembersFilter::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilter").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterContacts::Class;

chatMembersFilterContacts::chatMembersFilterContacts() {
}

const std::int32_t chatMembersFilterContacts::ID;

object_ptr<ChatMembersFilter> chatMembersFilterContacts::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterContacts>();
}

void chatMembersFilterContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterContacts");
    s.store_class_end();
  }
}

void chatMembersFilterContacts::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterContacts").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterAdministrators::Class;

chatMembersFilterAdministrators::chatMembersFilterAdministrators() {
}

const std::int32_t chatMembersFilterAdministrators::ID;

object_ptr<ChatMembersFilter> chatMembersFilterAdministrators::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterAdministrators>();
}

void chatMembersFilterAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterAdministrators");
    s.store_class_end();
  }
}

void chatMembersFilterAdministrators::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterAdministrators").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterMembers::Class;

chatMembersFilterMembers::chatMembersFilterMembers() {
}

const std::int32_t chatMembersFilterMembers::ID;

object_ptr<ChatMembersFilter> chatMembersFilterMembers::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterMembers>();
}

void chatMembersFilterMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterMembers");
    s.store_class_end();
  }
}

void chatMembersFilterMembers::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterMembers").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterMention::Class;
jfieldID chatMembersFilterMention::message_thread_id_fieldID;

chatMembersFilterMention::chatMembersFilterMention()
  : message_thread_id_()
{}

chatMembersFilterMention::chatMembersFilterMention(int53 message_thread_id_)
  : message_thread_id_(message_thread_id_)
{}

const std::int32_t chatMembersFilterMention::ID;

object_ptr<ChatMembersFilter> chatMembersFilterMention::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMembersFilterMention> res = make_object<chatMembersFilterMention>();
  res->message_thread_id_ = env->GetLongField(p, res->message_thread_id_fieldID);
  return std::move(res);
}

void chatMembersFilterMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterMention");
    s.store_field("messageThreadId", message_thread_id_);
    s.store_class_end();
  }
}

void chatMembersFilterMention::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterMention").c_str());
    message_thread_id_fieldID = jni::get_field_id(env, Class, "messageThreadId", "J");
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterRestricted::Class;

chatMembersFilterRestricted::chatMembersFilterRestricted() {
}

const std::int32_t chatMembersFilterRestricted::ID;

object_ptr<ChatMembersFilter> chatMembersFilterRestricted::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterRestricted>();
}

void chatMembersFilterRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterRestricted");
    s.store_class_end();
  }
}

void chatMembersFilterRestricted::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterRestricted").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterBanned::Class;

chatMembersFilterBanned::chatMembersFilterBanned() {
}

const std::int32_t chatMembersFilterBanned::ID;

object_ptr<ChatMembersFilter> chatMembersFilterBanned::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterBanned>();
}

void chatMembersFilterBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterBanned");
    s.store_class_end();
  }
}

void chatMembersFilterBanned::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterBanned").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMembersFilterBots::Class;

chatMembersFilterBots::chatMembersFilterBots() {
}

const std::int32_t chatMembersFilterBots::ID;

object_ptr<ChatMembersFilter> chatMembersFilterBots::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  return make_object<chatMembersFilterBots>();
}

void chatMembersFilterBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMembersFilterBots");
    s.store_class_end();
  }
}

void chatMembersFilterBots::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMembersFilterBots").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatMessageSender::Class;
jfieldID chatMessageSender::sender_fieldID;
jfieldID chatMessageSender::needs_premium_fieldID;

chatMessageSender::chatMessageSender()
  : sender_()
  , needs_premium_()
{}

chatMessageSender::chatMessageSender(object_ptr<MessageSender> &&sender_, bool needs_premium_)
  : sender_(std::move(sender_))
  , needs_premium_(needs_premium_)
{}

const std::int32_t chatMessageSender::ID;

object_ptr<chatMessageSender> chatMessageSender::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMessageSender> res = make_object<chatMessageSender>();
  res->sender_ = jni::fetch_tl_object<MessageSender>(env, jni::fetch_object(env, p, res->sender_fieldID));
  res->needs_premium_ = (env->GetBooleanField(p, res->needs_premium_fieldID) != 0);
  return res;
}

void chatMessageSender::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  if (sender_ != nullptr) { jobject next; sender_->store(env, next); if (next) { env->SetObjectField(s, sender_fieldID, next); env->DeleteLocalRef(next); } }
  env->SetBooleanField(s, needs_premium_fieldID, needs_premium_);
}

void chatMessageSender::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMessageSender");
    s.store_object_field("sender", static_cast<const BaseObject *>(sender_.get()));
    s.store_field("needsPremium", needs_premium_);
    s.store_class_end();
  }
}

void chatMessageSender::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMessageSender").c_str());
    sender_fieldID = jni::get_field_id(env, Class, "sender", (PSLICE() << "L" << get_package_name_ref() << "/TdApi$MessageSender;").c_str());
    needs_premium_fieldID = jni::get_field_id(env, Class, "needsPremium", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatMessageSenders::Class;
jfieldID chatMessageSenders::senders_fieldID;

chatMessageSenders::chatMessageSenders()
  : senders_()
{}

chatMessageSenders::chatMessageSenders(array<object_ptr<chatMessageSender>> &&senders_)
  : senders_(std::move(senders_))
{}

const std::int32_t chatMessageSenders::ID;

object_ptr<chatMessageSenders> chatMessageSenders::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatMessageSenders> res = make_object<chatMessageSenders>();
  res->senders_ = jni::FetchVector<chatMessageSender>::fetch(env, (jobjectArray)jni::fetch_object(env, p, res->senders_fieldID));
  return res;
}

void chatMessageSenders::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  { auto arr_tmp_ = jni::store_vector(env, senders_); if (arr_tmp_) { env->SetObjectField(s, senders_fieldID, arr_tmp_); env->DeleteLocalRef(arr_tmp_); } }
}

void chatMessageSenders::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatMessageSenders");
    { s.store_vector_begin("senders", senders_.size()); for (const auto &_value : senders_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

void chatMessageSenders::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatMessageSenders").c_str());
    senders_fieldID = jni::get_field_id(env, Class, "senders", (PSLICE() << "[L" << get_package_name_ref() << "/TdApi$ChatMessageSender;").c_str());
    return true;
  }();
  (void)is_inited;
}

jclass chatNotificationSettings::Class;
jfieldID chatNotificationSettings::use_default_mute_for_fieldID;
jfieldID chatNotificationSettings::mute_for_fieldID;
jfieldID chatNotificationSettings::use_default_sound_fieldID;
jfieldID chatNotificationSettings::sound_id_fieldID;
jfieldID chatNotificationSettings::use_default_show_preview_fieldID;
jfieldID chatNotificationSettings::show_preview_fieldID;
jfieldID chatNotificationSettings::use_default_mute_stories_fieldID;
jfieldID chatNotificationSettings::mute_stories_fieldID;
jfieldID chatNotificationSettings::use_default_story_sound_fieldID;
jfieldID chatNotificationSettings::story_sound_id_fieldID;
jfieldID chatNotificationSettings::use_default_show_story_poster_fieldID;
jfieldID chatNotificationSettings::show_story_poster_fieldID;
jfieldID chatNotificationSettings::use_default_disable_pinned_message_notifications_fieldID;
jfieldID chatNotificationSettings::disable_pinned_message_notifications_fieldID;
jfieldID chatNotificationSettings::use_default_disable_mention_notifications_fieldID;
jfieldID chatNotificationSettings::disable_mention_notifications_fieldID;

chatNotificationSettings::chatNotificationSettings()
  : use_default_mute_for_()
  , mute_for_()
  , use_default_sound_()
  , sound_id_()
  , use_default_show_preview_()
  , show_preview_()
  , use_default_mute_stories_()
  , mute_stories_()
  , use_default_story_sound_()
  , story_sound_id_()
  , use_default_show_story_poster_()
  , show_story_poster_()
  , use_default_disable_pinned_message_notifications_()
  , disable_pinned_message_notifications_()
  , use_default_disable_mention_notifications_()
  , disable_mention_notifications_()
{}

chatNotificationSettings::chatNotificationSettings(bool use_default_mute_for_, int32 mute_for_, bool use_default_sound_, int64 sound_id_, bool use_default_show_preview_, bool show_preview_, bool use_default_mute_stories_, bool mute_stories_, bool use_default_story_sound_, int64 story_sound_id_, bool use_default_show_story_poster_, bool show_story_poster_, bool use_default_disable_pinned_message_notifications_, bool disable_pinned_message_notifications_, bool use_default_disable_mention_notifications_, bool disable_mention_notifications_)
  : use_default_mute_for_(use_default_mute_for_)
  , mute_for_(mute_for_)
  , use_default_sound_(use_default_sound_)
  , sound_id_(sound_id_)
  , use_default_show_preview_(use_default_show_preview_)
  , show_preview_(show_preview_)
  , use_default_mute_stories_(use_default_mute_stories_)
  , mute_stories_(mute_stories_)
  , use_default_story_sound_(use_default_story_sound_)
  , story_sound_id_(story_sound_id_)
  , use_default_show_story_poster_(use_default_show_story_poster_)
  , show_story_poster_(show_story_poster_)
  , use_default_disable_pinned_message_notifications_(use_default_disable_pinned_message_notifications_)
  , disable_pinned_message_notifications_(disable_pinned_message_notifications_)
  , use_default_disable_mention_notifications_(use_default_disable_mention_notifications_)
  , disable_mention_notifications_(disable_mention_notifications_)
{}

const std::int32_t chatNotificationSettings::ID;

object_ptr<chatNotificationSettings> chatNotificationSettings::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatNotificationSettings> res = make_object<chatNotificationSettings>();
  res->use_default_mute_for_ = (env->GetBooleanField(p, res->use_default_mute_for_fieldID) != 0);
  res->mute_for_ = env->GetIntField(p, res->mute_for_fieldID);
  res->use_default_sound_ = (env->GetBooleanField(p, res->use_default_sound_fieldID) != 0);
  res->sound_id_ = env->GetLongField(p, res->sound_id_fieldID);
  res->use_default_show_preview_ = (env->GetBooleanField(p, res->use_default_show_preview_fieldID) != 0);
  res->show_preview_ = (env->GetBooleanField(p, res->show_preview_fieldID) != 0);
  res->use_default_mute_stories_ = (env->GetBooleanField(p, res->use_default_mute_stories_fieldID) != 0);
  res->mute_stories_ = (env->GetBooleanField(p, res->mute_stories_fieldID) != 0);
  res->use_default_story_sound_ = (env->GetBooleanField(p, res->use_default_story_sound_fieldID) != 0);
  res->story_sound_id_ = env->GetLongField(p, res->story_sound_id_fieldID);
  res->use_default_show_story_poster_ = (env->GetBooleanField(p, res->use_default_show_story_poster_fieldID) != 0);
  res->show_story_poster_ = (env->GetBooleanField(p, res->show_story_poster_fieldID) != 0);
  res->use_default_disable_pinned_message_notifications_ = (env->GetBooleanField(p, res->use_default_disable_pinned_message_notifications_fieldID) != 0);
  res->disable_pinned_message_notifications_ = (env->GetBooleanField(p, res->disable_pinned_message_notifications_fieldID) != 0);
  res->use_default_disable_mention_notifications_ = (env->GetBooleanField(p, res->use_default_disable_mention_notifications_fieldID) != 0);
  res->disable_mention_notifications_ = (env->GetBooleanField(p, res->disable_mention_notifications_fieldID) != 0);
  return res;
}

void chatNotificationSettings::store(JNIEnv *env, jobject &s) const {
  init_jni_vars(env);
  s = env->AllocObject(Class);
  if (!s) { return; }
  env->SetBooleanField(s, use_default_mute_for_fieldID, use_default_mute_for_);
  env->SetIntField(s, mute_for_fieldID, mute_for_);
  env->SetBooleanField(s, use_default_sound_fieldID, use_default_sound_);
  env->SetLongField(s, sound_id_fieldID, sound_id_);
  env->SetBooleanField(s, use_default_show_preview_fieldID, use_default_show_preview_);
  env->SetBooleanField(s, show_preview_fieldID, show_preview_);
  env->SetBooleanField(s, use_default_mute_stories_fieldID, use_default_mute_stories_);
  env->SetBooleanField(s, mute_stories_fieldID, mute_stories_);
  env->SetBooleanField(s, use_default_story_sound_fieldID, use_default_story_sound_);
  env->SetLongField(s, story_sound_id_fieldID, story_sound_id_);
  env->SetBooleanField(s, use_default_show_story_poster_fieldID, use_default_show_story_poster_);
  env->SetBooleanField(s, show_story_poster_fieldID, show_story_poster_);
  env->SetBooleanField(s, use_default_disable_pinned_message_notifications_fieldID, use_default_disable_pinned_message_notifications_);
  env->SetBooleanField(s, disable_pinned_message_notifications_fieldID, disable_pinned_message_notifications_);
  env->SetBooleanField(s, use_default_disable_mention_notifications_fieldID, use_default_disable_mention_notifications_);
  env->SetBooleanField(s, disable_mention_notifications_fieldID, disable_mention_notifications_);
}

void chatNotificationSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ChatNotificationSettings");
    s.store_field("useDefaultMuteFor", use_default_mute_for_);
    s.store_field("muteFor", mute_for_);
    s.store_field("useDefaultSound", use_default_sound_);
    s.store_field("soundId", sound_id_);
    s.store_field("useDefaultShowPreview", use_default_show_preview_);
    s.store_field("showPreview", show_preview_);
    s.store_field("useDefaultMuteStories", use_default_mute_stories_);
    s.store_field("muteStories", mute_stories_);
    s.store_field("useDefaultStorySound", use_default_story_sound_);
    s.store_field("storySoundId", story_sound_id_);
    s.store_field("useDefaultShowStoryPoster", use_default_show_story_poster_);
    s.store_field("showStoryPoster", show_story_poster_);
    s.store_field("useDefaultDisablePinnedMessageNotifications", use_default_disable_pinned_message_notifications_);
    s.store_field("disablePinnedMessageNotifications", disable_pinned_message_notifications_);
    s.store_field("useDefaultDisableMentionNotifications", use_default_disable_mention_notifications_);
    s.store_field("disableMentionNotifications", disable_mention_notifications_);
    s.store_class_end();
  }
}

void chatNotificationSettings::init_jni_vars(JNIEnv *env) {
  static bool is_inited = [&] {
    Class = jni::get_jclass(env, (PSLICE() << get_package_name_ref() << "/TdApi$ChatNotificationSettings").c_str());
    use_default_mute_for_fieldID = jni::get_field_id(env, Class, "useDefaultMuteFor", "Z");
    mute_for_fieldID = jni::get_field_id(env, Class, "muteFor", "I");
    use_default_sound_fieldID = jni::get_field_id(env, Class, "useDefaultSound", "Z");
    sound_id_fieldID = jni::get_field_id(env, Class, "soundId", "J");
    use_default_show_preview_fieldID = jni::get_field_id(env, Class, "useDefaultShowPreview", "Z");
    show_preview_fieldID = jni::get_field_id(env, Class, "showPreview", "Z");
    use_default_mute_stories_fieldID = jni::get_field_id(env, Class, "useDefaultMuteStories", "Z");
    mute_stories_fieldID = jni::get_field_id(env, Class, "muteStories", "Z");
    use_default_story_sound_fieldID = jni::get_field_id(env, Class, "useDefaultStorySound", "Z");
    story_sound_id_fieldID = jni::get_field_id(env, Class, "storySoundId", "J");
    use_default_show_story_poster_fieldID = jni::get_field_id(env, Class, "useDefaultShowStoryPoster", "Z");
    show_story_poster_fieldID = jni::get_field_id(env, Class, "showStoryPoster", "Z");
    use_default_disable_pinned_message_notifications_fieldID = jni::get_field_id(env, Class, "useDefaultDisablePinnedMessageNotifications", "Z");
    disable_pinned_message_notifications_fieldID = jni::get_field_id(env, Class, "disablePinnedMessageNotifications", "Z");
    use_default_disable_mention_notifications_fieldID = jni::get_field_id(env, Class, "useDefaultDisableMentionNotifications", "Z");
    disable_mention_notifications_fieldID = jni::get_field_id(env, Class, "disableMentionNotifications", "Z");
    return true;
  }();
  (void)is_inited;
}

jclass chatPermissions::Class;
jfieldID chatPermissions::can_send_basic_messages_fieldID;
jfieldID chatPermissions::can_send_audios_fieldID;
jfieldID chatPermissions::can_send_documents_fieldID;
jfieldID chatPermissions::can_send_photos_fieldID;
jfieldID chatPermissions::can_send_videos_fieldID;
jfieldID chatPermissions::can_send_video_notes_fieldID;
jfieldID chatPermissions::can_send_voice_notes_fieldID;
jfieldID chatPermissions::can_send_polls_fieldID;
jfieldID chatPermissions::can_send_other_messages_fieldID;
jfieldID chatPermissions::can_add_link_previews_fieldID;
jfieldID chatPermissions::can_change_info_fieldID;
jfieldID chatPermissions::can_invite_users_fieldID;
jfieldID chatPermissions::can_pin_messages_fieldID;
jfieldID chatPermissions::can_create_topics_fieldID;

chatPermissions::chatPermissions()
  : can_send_basic_messages_()
  , can_send_audios_()
  , can_send_documents_()
  , can_send_photos_()
  , can_send_videos_()
  , can_send_video_notes_()
  , can_send_voice_notes_()
  , can_send_polls_()
  , can_send_other_messages_()
  , can_add_link_previews_()
  , can_change_info_()
  , can_invite_users_()
  , can_pin_messages_()
  , can_create_topics_()
{}

chatPermissions::chatPermissions(bool can_send_basic_messages_, bool can_send_audios_, bool can_send_documents_, bool can_send_photos_, bool can_send_videos_, bool can_send_video_notes_, bool can_send_voice_notes_, bool can_send_polls_, bool can_send_other_messages_, bool can_add_link_previews_, bool can_change_info_, bool can_invite_users_, bool can_pin_messages_, bool can_create_topics_)
  : can_send_basic_messages_(can_send_basic_messages_)
  , can_send_audios_(can_send_audios_)
  , can_send_documents_(can_send_documents_)
  , can_send_photos_(can_send_photos_)
  , can_send_videos_(can_send_videos_)
  , can_send_video_notes_(can_send_video_notes_)
  , can_send_voice_notes_(can_send_voice_notes_)
  , can_send_polls_(can_send_polls_)
  , can_send_other_messages_(can_send_other_messages_)
  , can_add_link_previews_(can_add_link_previews_)
  , can_change_info_(can_change_info_)
  , can_invite_users_(can_invite_users_)
  , can_pin_messages_(can_pin_messages_)
  , can_create_topics_(can_create_topics_)
{}

const std::int32_t chatPermissions::ID;

object_ptr<chatPermissions> chatPermissions::fetch(JNIEnv *env, jobject &p) {
  if (p == nullptr) return nullptr;
  init_jni_vars(env);
  object_ptr<chatPermissions> res = make_object<chatPermissions>();
  res->can_send_basic_messages_ = (env->GetBooleanField(p, res->can_send_basic_messages_fieldID) != 0);
  res->can_send_audios_ = (env->GetBooleanField(p, res->can_send_audios_fieldID) != 0);
  res->can_send_documents_ = (env->GetBooleanField(p, res->can_send_documents_fieldID) != 0);
  res->can_send_photos_ = (env->GetBooleanField(p, res->can_send_photos_fieldID) != 0);
  res->can_send_videos_ = (env->GetBooleanField(p, res->can_send_videos_fieldID) != 0);
  res->can_send_video_notes_ = (env->GetBooleanField(p, res->can_send_video_notes_fieldID) != 0);
  res->can_send_voice_notes_ = (env->GetBooleanField(p, res->can_send_voice_notes_fieldID) != 0);
  res->can_send_polls_ = (env->GetBooleanField(p, res->can_send_polls_fieldID) != 0);
  res->can_send_other_messages_ = (env->GetBooleanField(p, res->can_send_other_messages_fieldID) != 0);
  res->can_add_link_previews_ = (env->GetBooleanField(p, res->can_add_link_previews_fieldID) != 0);
  res->can_change_info_ = (env->GetBooleanField(p,