//
// Copyright Aliaksei Levin (levlam@telegram.org), Arseny Smirnov (arseny30@gmail.com) 2014-2021
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
#include "td/utils/emoji.h"

#include "td/utils/misc.h"

#include <unordered_set>

namespace td {

bool is_emoji(Slice str) {
  static const std::unordered_set<Slice, SliceHash> emojis = {
      "⌚", "⌛", "⏩", "⏪", "⏫", "⏬", "⏰", "⏳", "◽", "◾", "☔", "☕", "♈", "♉", "♊", "♋", "♌", "♍", "♎", "♏", "♐", "♑", "♒",
      "♓", "♿", "⚓", "⚡", "⚪", "⚫", "⚽", "⚾", "⛄", "⛅", "⛎", "⛔", "⛪", "⛲", "⛳", "⛵", "⛺", "⛽", "✅", "✊", "✋", "✨", "❌",
      "❎", "❓", "❔", "❕", "❗", "➕", "➖", "➗", "➰", "➿", "⬛", "⬜", "⭐", "⭕", "🀄", "🃏", "🆎", "🆑", "🆒", "🆓", "🆔", "🆕", "🆖",
      "🆗", "🆘", "🆙", "🆚", "🈁", "🈚", "🈯", "🈲", "🈳", "🈴", "🈵", "🈶", "🈸", "🈹", "🈺", "🉐", "🉑", "🌀", "🌁", "🌂", "🌃", "🌄", "🌅",
      "🌆", "🌇", "🌈", "🌉", "🌊", "🌋", "🌌", "🌍", "🌎", "🌏", "🌐", "🌑", "🌒", "🌓", "🌔", "🌕", "🌖", "🌗", "🌘", "🌙", "🌚", "🌛", "🌜",
      "🌝", "🌞", "🌟", "🌠", "🌭", "🌮", "🌯", "🌰", "🌱", "🌲", "🌳", "🌴", "🌵", "🌷", "🌸", "🌹", "🌺", "🌻", "🌼", "🌽", "🌾",
      "🌿", "🍀", "🍁", "🍂", "🍃", "🍄", "🍅", "🍆", "🍇", "🍈", "🍉", "🍊", "🍋", "🍌", "🍍", "🍎", "🍏", "🍐", "🍑", "🍒", "🍓", "🍔", "🍕",
      "🍖", "🍗", "🍘", "🍙", "🍚", "🍛", "🍜", "🍝", "🍞", "🍟", "🍠", "🍡", "🍢", "🍣", "🍤", "🍥", "🍦", "🍧", "🍨", "🍩", "🍪", "🍫", "🍬",
      "🍭", "🍮", "🍯", "🍰", "🍱", "🍲", "🍳", "🍴", "🍵", "🍶", "🍷", "🍸", "🍹", "🍺", "🍻", "🍼", "🍾", "🍿", "🎀", "🎁", "🎂",
      "🎃", "🎄", "🎅", "🎆", "🎇", "🎈", "🎉", "🎊", "🎋", "🎌", "🎍", "🎎", "🎏", "🎐", "🎑", "🎒", "🎓", "🎠", "🎡", "🎢", "🎣", "🎤", "🎥",
      "🎦", "🎧", "🎨", "🎩", "🎪", "🎫", "🎬", "🎭", "🎮", "🎯", "🎰", "🎱", "🎲", "🎳", "🎴", "🎵", "🎶", "🎷", "🎸", "🎹", "🎺", "🎻", "🎼",
      "🎽", "🎾", "🎿", "🏀", "🏁", "🏂", "🏃", "🏄", "🏅", "🏆", "🏇", "🏈", "🏉", "🏊", "🏏", "🏐", "🏑", "🏒", "🏓",
      "🏠", "🏡", "🏢", "🏣", "🏤", "🏥", "🏦", "🏧", "🏨", "🏩", "🏪", "🏫", "🏬", "🏭", "🏮", "🏯", "🏰", "🏴", "🏸", "🏹",
      "🏺", "🏻", "🏼", "🏽", "🏾", "🏿", "🐀", "🐁", "🐂", "🐃", "🐄", "🐅", "🐆", "🐇", "🐈", "🐉", "🐊", "🐋", "🐌",
      "🐍", "🐎", "🐏", "🐐", "🐑", "🐒", "🐓", "🐔", "🐕", "🐖", "🐗", "🐘", "🐙", "🐚", "🐛", "🐜", "🐝", "🐞", "🐟", "🐠", "🐡", "🐢", "🐣",
      "🐤", "🐥", "🐦", "🐧", "🐨", "🐩", "🐪", "🐫", "🐬", "🐭", "🐮", "🐯", "🐰", "🐱", "🐲", "🐳", "🐴", "🐵", "🐶", "🐷", "🐸", "🐹", "🐺",
      "🐻", "🐼", "🐽", "🐾", "👀", "👂", "👃", "👄", "👅", "👆", "👇", "👈", "👉", "👊", "👋", "👌", "👍", "👎", "👏", "👐", "👑", "👒", "👓",
      "👔", "👕", "👖", "👗", "👘", "👙", "👚", "👛", "👜", "👝", "👞", "👟", "👠", "👡", "👢", "👣", "👤", "👥", "👦", "👧", "👨", "👩", "👪",
      "👫", "👬", "👭", "👮", "👯", "👰", "👱", "👲", "👳", "👴", "👵", "👶", "👷", "👸", "👹", "👺", "👻", "👼", "👽", "👾", "👿", "💀", "💁",
      "💂", "💃", "💄", "💅", "💆", "💇", "💈", "💉", "💊", "💋", "💌", "💍", "💎", "💏", "💐", "💑", "💒", "💓", "💔", "💕", "💖", "💗", "💘",
      "💙", "💚", "💛", "💜", "💝", "💞", "💟", "💠", "💡", "💢", "💣", "💤", "💥", "💦", "💧", "💨", "💩", "💪", "💫", "💬", "💭", "💮", "💯",
      "💰", "💱", "💲", "💳", "💴", "💵", "💶", "💷", "💸", "💹", "💺", "💻", "💼", "💽", "💾", "💿", "📀", "📁", "📂", "📃", "📄", "📅", "📆",
      "📇", "📈", "📉", "📊", "📋", "📌", "📍", "📎", "📏", "📐", "📑", "📒", "📓", "📔", "📕", "📖", "📗", "📘", "📙", "📚", "📛", "📜", "📝",
      "📞", "📟", "📠", "📡", "📢", "📣", "📤", "📥", "📦", "📧", "📨", "📩", "📪", "📫", "📬", "📭", "📮", "📯", "📰", "📱", "📲", "📳", "📴",
      "📵", "📶", "📷", "📸", "📹", "📺", "📻", "📼", "📿", "🔀", "🔁", "🔂", "🔃", "🔄", "🔅", "🔆", "🔇", "🔈", "🔉", "🔊", "🔋",
      "🔌", "🔍", "🔎", "🔏", "🔐", "🔑", "🔒", "🔓", "🔔", "🔕", "🔖", "🔗", "🔘", "🔙", "🔚", "🔛", "🔜", "🔝", "🔞", "🔟", "🔠", "🔡", "🔢",
      "🔣", "🔤", "🔥", "🔦", "🔧", "🔨", "🔩", "🔪", "🔫", "🔬", "🔭", "🔮", "🔯", "🔰", "🔱", "🔲", "🔳", "🔴", "🔵", "🔶", "🔷", "🔸", "🔹",
      "🔺", "🔻", "🔼", "🔽", "🕋", "🕌", "🕍", "🕎", "🕐", "🕑", "🕒", "🕓", "🕔", "🕕", "🕖", "🕗", "🕘", "🕙", "🕚", "🕛",
      "🕜", "🕝", "🕞", "🕟", "🕠", "🕡", "🕢", "🕣", "🕤", "🕥", "🕦", "🕧", "🕺", "🖕", "🖖", "🖤", "🗻", "🗼", "🗽", "🗾",
      "🗿", "😀", "😁", "😂", "😃", "😄", "😅", "😆", "😇", "😈", "😉", "😊", "😋", "😌", "😍", "😎", "😏", "😐", "😑", "😒", "😓", "😔", "😕",
      "😖", "😗", "😘", "😙", "😚", "😛", "😜", "😝", "😞", "😟", "😠", "😡", "😢", "😣", "😤", "😥", "😦", "😧", "😨", "😩", "😪", "😫", "😬",
      "😭", "😮", "😯", "😰", "😱", "😲", "😳", "😴", "😵", "😶", "😷", "😸", "😹", "😺", "😻", "😼", "😽", "😾", "😿", "🙀", "🙁",
      "🙂", "🙃", "🙄", "🙅", "🙆", "🙇", "🙈", "🙉", "🙊", "🙋", "🙌", "🙍", "🙎", "🙏", "🚀", "🚁", "🚂", "🚃", "🚄", "🚅", "🚆",
      "🚇", "🚈", "🚉", "🚊", "🚋", "🚌", "🚍", "🚎", "🚏", "🚐", "🚑", "🚒", "🚓", "🚔", "🚕", "🚖", "🚗", "🚘", "🚙", "🚚", "🚛", "🚜", "🚝",
      "🚞", "🚟", "🚠", "🚡", "🚢", "🚣", "🚤", "🚥", "🚦", "🚧", "🚨", "🚩", "🚪", "🚫", "🚬", "🚭", "🚮", "🚯", "🚰", "🚱", "🚲", "🚳", "🚴",
      "🚵", "🚶", "🚷", "🚸", "🚹", "🚺", "🚻", "🚼", "🚽", "🚾", "🚿", "🛀", "🛁", "🛂", "🛃", "🛄", "🛅", "🛌", "🛐", "🛑",
      "🛒", "🛕", "🛖", "🛗", "🛝", "🛞", "🛟", "🛫", "🛬", "🛴", "🛵", "🛶", "🛷", "🛸",
      "🛹", "🛺", "🛻", "🛼", "🟠", "🟡", "🟢", "🟣", "🟤", "🟥", "🟦", "🟧", "🟨", "🟩",
      "🟪", "🟫", "🟰", "🤌", "🤍", "🤎", "🤏", "🤐", "🤑", "🤒", "🤓", "🤔", "🤕", "🤖",
      "🤗", "🤘", "🤙", "🤚", "🤛", "🤜", "🤝", "🤞", "🤟", "🤠", "🤡", "🤢", "🤣", "🤤",
      "🤥", "🤦", "🤧", "🤨", "🤩", "🤪", "🤫", "🤬", "🤭", "🤮", "🤯", "🤰", "🤱", "🤲",
      "🤳", "🤴", "🤵", "🤶", "🤷", "🤸", "🤹", "🤺", "🤼", "🤽", "🤾", "🤿", "🥀", "🥁",
      "🥂", "🥃", "🥄", "🥅", "🥇", "🥈", "🥉", "🥊", "🥋", "🥌", "🥍", "🥎", "🥏", "🥐",
      "🥑", "🥒", "🥓", "🥔", "🥕", "🥖", "🥗", "🥘", "🥙", "🥚", "🥛", "🥜", "🥝", "🥞",
      "🥟", "🥠", "🥡", "🥢", "🥣", "🥤", "🥥", "🥦", "🥧", "🥨", "🥩", "🥪", "🥫", "🥬",
      "🥭", "🥮", "🥯", "🥰", "🥱", "🥲", "🥳", "🥴", "🥵", "🥶", "🥷", "🥸", "🥹", "🥺",
      "🥻", "🥼", "🥽", "🥾", "🥿", "🦀", "🦁", "🦂", "🦃", "🦄", "🦅", "🦆", "🦇", "🦈",
      "🦉", "🦊", "🦋", "🦌", "🦍", "🦎", "🦏", "🦐", "🦑", "🦒", "🦓", "🦔", "🦕", "🦖",
      "🦗", "🦘", "🦙", "🦚", "🦛", "🦜", "🦝", "🦞", "🦟", "🦠", "🦡", "🦢", "🦣", "🦤",
      "🦥", "🦦", "🦧", "🦨", "🦩", "🦪", "🦫", "🦬", "🦭", "🦮", "🦯", "🦰", "🦱", "🦲",
      "🦳", "🦴", "🦵", "🦶", "🦷", "🦸", "🦹", "🦺", "🦻", "🦼", "🦽", "🦾", "🦿", "🧀",
      "🧁", "🧂", "🧃", "🧄", "🧅", "🧆", "🧇", "🧈", "🧉", "🧊", "🧋", "🧌", "🧍", "🧎",
      "🧏", "🧐", "🧑", "🧒", "🧓", "🧔", "🧕", "🧖", "🧗", "🧘", "🧙", "🧚", "🧛", "🧜",
      "🧝", "🧞", "🧟", "🧠", "🧡", "🧢", "🧣", "🧤", "🧥", "🧦", "🧧", "🧨", "🧩", "🧪",
      "🧫", "🧬", "🧭", "🧮", "🧯", "🧰", "🧱", "🧲", "🧳", "🧴", "🧵", "🧶", "🧷", "🧸",
      "🧹", "🧺", "🧻", "🧼", "🧽", "🧾", "🧿", "🩰", "🩱", "🩲", "🩳", "🩴", "🩸", "🩹",
      "🩺", "🩻", "🩼", "🪀", "🪁", "🪂", "🪃", "🪄", "🪅", "🪆", "🪐", "🪑", "🪒", "🪓",
      "🪔", "🪕", "🪖", "🪗", "🪘", "🪙", "🪚", "🪛", "🪜", "🪝", "🪞", "🪟", "🪠", "🪡",
      "🪢", "🪣", "🪤", "🪥", "🪦", "🪧", "🪨", "🪩", "🪪", "🪫", "🪬", "🪰", "🪱", "🪲",
      "🪳", "🪴", "🪵", "🪶", "🪷", "🪸", "🪹", "🪺", "🫀", "🫁", "🫂", "🫃", "🫄", "🫅",
      "🫐", "🫑", "🫒", "🫓", "🫔", "🫕", "🫖", "🫗", "🫘", "🫙", "🫠", "🫡", "🫢", "🫣",
      "🫤", "🫥", "🫦", "🫧", "🫰", "🫱", "🫲", "🫳", "🫴", "🫵", "🫶", "©", "®", "‼", "⁉", "™",
      "ℹ", "↔", "↕", "↖", "↗", "↘", "↙", "↩", "↪", "⌨", "⏏", "⏭", "⏮", "⏯", "⏱", "⏲", "⏸", "⏹", "⏺", "Ⓜ", "▪",
      "▫", "▶", "◀", "◻", "◼", "☀", "☁", "☂", "☃", "☄", "☎", "☑", "☘", "☝", "☠", "☢", "☣", "☦", "☪", "☮", "☯", "☸", "☹",
      "☺", "♀", "♂", "♟", "♠", "♣", "♥", "♦", "♨", "♻", "♾", "⚒", "⚔", "⚕", "⚖", "⚗", "⚙", "⚛", "⚜", "⚠", "⚧", "⚰", "⚱",
      "⛈", "⛏", "⛑", "⛓", "⛩", "⛰", "⛱", "⛴", "⛷", "⛸", "⛹", "✂", "✈", "✉", "✌", "✍", "✏", "✒", "✔", "✖", "✝", "✡", "✳",
      "✴", "❄", "❇", "❣", "❤", "➡", "⤴", "⤵", "⬅", "⬆", "⬇", "〰", "〽", "㊗", "㊙", "🅰", "🅱", "🅾", "🅿", "🈂", "🈷",
      "🌡", "🌤", "🌥", "🌦", "🌧", "🌨", "🌩", "🌪", "🌫", "🌬", "🌶", "🍽", "🎖", "🎗",
      "🎙", "🎚", "🎛", "🎞", "🎟", "🏋", "🏌", "🏍", "🏎", "🏔", "🏕", "🏖", "🏗", "🏘",
      "🏙", "🏚", "🏛", "🏜", "🏝", "🏞", "🏟", "🏳", "🏵", "🏷", "🐿", "👁", "📽", "🕉",
      "🕊", "🕯", "🕰", "🕳", "🕴", "🕵", "🕶", "🕷", "🕸", "🕹", "🖇", "🖊", "🖋", "🖌",
      "🖍", "🖐", "🖥", "🖨", "🖱", "🖲", "🖼", "🗂", "🗃", "🗄", "🗑", "🗒", "🗓", "🗜",
      "🗝", "🗞", "🗡", "🗣", "🗨", "🗯", "🗳", "🗺", "🛋", "🛍", "🛎", "🛏", "🛠", "🛡",
      "🛢", "🛣", "🛤", "🛥", "🛩", "🛰", "🛳", "#⃣", "#️⃣", "*⃣", "*️⃣", "0⃣", "0️⃣", "1⃣",
      "1️⃣", "2⃣", "2️⃣", "3⃣", "3️⃣", "4⃣", "4️⃣", "5⃣", "5️⃣", "6⃣", "6️⃣", "7⃣", "7️⃣", "8⃣",
      "8️⃣", "9⃣", "9️⃣", "🇦🇨", "🇦🇨", "🇦🇩", "🇦🇩", "🇦🇪", "🇦🇪", "🇦🇫", "🇦🇫", "🇦🇬", "🇦🇬", "🇦🇮", "🇦🇮", "🇦🇱", "🇦🇱",
      "🇦🇲", "🇦🇲", "🇦🇴", "🇦🇴", "🇦🇶", "🇦🇶", "🇦🇷", "🇦🇷", "🇦🇸", "🇦🇸", "🇦🇹", "🇦🇹", "🇦🇺", "🇦🇺", "🇦🇼", "🇦🇼", "🇦🇽", "🇦🇽", "🇦🇿",
      "🇦🇿", "🇧🇦", "🇧🇦", "🇧🇧", "🇧🇧", "🇧🇩", "🇧🇩", "🇧🇪", "🇧🇪", "🇧🇫", "🇧🇫", "🇧🇬", "🇧🇬", "🇧🇭", "🇧🇭", "🇧🇮", "🇧🇮", "🇧🇯", "🇧🇯",
      "🇧🇱", "🇧🇱", "🇧🇲", "🇧🇲", "🇧🇳", "🇧🇳", "🇧🇴", "🇧🇴", "🇧🇶", "🇧🇶", "🇧🇷", "🇧🇷", "🇧🇸", "🇧🇸", "🇧🇹", "🇧🇹", "🇧🇻", "🇧🇻", "🇧🇼",
      "🇧🇼", "🇧🇾", "🇧🇾", "🇧🇿", "🇧🇿", "🇨🇦", "🇨🇦", "🇨🇨", "🇨🇨", "🇨🇩", "🇨🇩", "🇨🇫", "🇨🇫", "🇨🇬", "🇨🇬", "🇨🇭", "🇨🇭", "🇨🇮", "🇨🇮",
      "🇨🇰", "🇨🇰", "🇨🇱", "🇨🇱", "🇨🇲", "🇨🇲", "🇨🇳", "🇨🇳", "🇨🇴", "🇨🇴", "🇨🇵", "🇨🇵", "🇨🇷", "🇨🇷", "🇨🇺", "🇨🇺", "🇨🇻", "🇨🇻", "🇨🇼",
      "🇨🇼", "🇨🇽", "🇨🇽", "🇨🇾", "🇨🇾", "🇨🇿", "🇨🇿", "🇩🇪", "🇩🇪", "🇩🇬", "🇩🇬", "🇩🇯", "🇩🇯", "🇩🇰", "🇩🇰", "🇩🇲", "🇩🇲", "🇩🇴", "🇩🇴",
      "🇩🇿", "🇩🇿", "🇪🇦", "🇪🇦", "🇪🇨", "🇪🇨", "🇪🇪", "🇪🇪", "🇪🇬", "🇪🇬", "🇪🇭", "🇪🇭", "🇪🇷", "🇪🇷", "🇪🇸", "🇪🇸", "🇪🇹", "🇪🇹", "🇪🇺",
      "🇪🇺", "🇫🇮", "🇫🇮", "🇫🇯", "🇫🇯", "🇫🇰", "🇫🇰", "🇫🇲", "🇫🇲", "🇫🇴", "🇫🇴", "🇫🇷", "🇫🇷", "🇬🇦", "🇬🇦", "🇬🇧", "🇬🇧", "🇬🇩", "🇬🇩",
      "🇬🇪", "🇬🇪", "🇬🇫", "🇬🇫", "🇬🇬", "🇬🇬", "🇬🇭", "🇬🇭", "🇬🇮", "🇬🇮", "🇬🇱", "🇬🇱", "🇬🇲", "🇬🇲", "🇬🇳", "🇬🇳", "🇬🇵", "🇬🇵", "🇬🇶",
      "🇬🇶", "🇬🇷", "🇬🇷", "🇬🇸", "🇬🇸", "🇬🇹", "🇬🇹", "🇬🇺", "🇬🇺", "🇬🇼", "🇬🇼", "🇬🇾", "🇬🇾", "🇭🇰", "🇭🇰", "🇭🇲", "🇭🇲", "🇭🇳", "🇭🇳",
      "🇭🇷", "🇭🇷", "🇭🇹", "🇭🇹", "🇭🇺", "🇭🇺", "🇮🇨", "🇮🇨", "🇮🇩", "🇮🇩", "🇮🇪", "🇮🇪", "🇮🇱", "🇮🇱", "🇮🇲", "🇮🇲", "🇮🇳", "🇮🇳", "🇮🇴",
      "🇮🇴", "🇮🇶", "🇮🇶", "🇮🇷", "🇮🇷", "🇮🇸", "🇮🇸", "🇮🇹", "🇮🇹", "🇯🇪", "🇯🇪", "🇯🇲", "🇯🇲", "🇯🇴", "🇯🇴", "🇯🇵", "🇯🇵", "🇰🇪", "🇰🇪",
      "🇰🇬", "🇰🇬", "🇰🇭", "🇰🇭", "🇰🇮", "🇰🇮", "🇰🇲", "🇰🇲", "🇰🇳", "🇰🇳", "🇰🇵", "🇰🇵", "🇰🇷", "🇰🇷", "🇰🇼", "🇰🇼", "🇰🇾", "🇰🇾", "🇰🇿",
      "🇰🇿", "🇱🇦", "🇱🇦", "🇱🇧", "🇱🇧", "🇱🇨", "🇱🇨", "🇱🇮", "🇱🇮", "🇱🇰", "🇱🇰", "🇱🇷", "🇱🇷", "🇱🇸", "🇱🇸", "🇱🇹", "🇱🇹", "🇱🇺", "🇱🇺",
      "🇱🇻", "🇱🇻", "🇱🇾", "🇱🇾", "🇲🇦", "🇲🇦", "🇲🇨", "🇲🇨", "🇲🇩", "🇲🇩", "🇲🇪", "🇲🇪", "🇲🇫", "🇲🇫", "🇲🇬", "🇲🇬", "🇲🇭", "🇲🇭", "🇲🇰",
      "🇲🇰", "🇲🇱", "🇲🇱", "🇲🇲", "🇲🇲", "🇲🇳", "🇲🇳", "🇲🇴", "🇲🇴", "🇲🇵", "🇲🇵", "🇲🇶", "🇲🇶", "🇲🇷", "🇲🇷", "🇲🇸", "🇲🇸", "🇲🇹", "🇲🇹",
      "🇲🇺", "🇲🇺", "🇲🇻", "🇲🇻", "🇲🇼", "🇲🇼", "🇲🇽", "🇲🇽", "🇲🇾", "🇲🇾", "🇲🇿", "🇲🇿", "🇳🇦", "🇳🇦", "🇳🇨", "🇳🇨", "🇳🇪", "🇳🇪", "🇳🇫",
      "🇳🇫", "🇳🇬", "🇳🇬", "🇳🇮", "🇳🇮", "🇳🇱", "🇳🇱", "🇳🇴", "🇳🇴", "🇳🇵", "🇳🇵", "🇳🇷", "🇳🇷", "🇳🇺", "🇳🇺", "🇳🇿", "🇳🇿", "🇴🇲", "🇴🇲",
      "🇵🇦", "🇵🇦", "🇵🇪", "🇵🇪", "🇵🇫", "🇵🇫", "🇵🇬", "🇵🇬", "🇵🇭", "🇵🇭", "🇵🇰", "🇵🇰", "🇵🇱", "🇵🇱", "🇵🇲", "🇵🇲", "🇵🇳", "🇵🇳", "🇵🇷",
      "🇵🇷", "🇵🇸", "🇵🇸", "🇵🇹", "🇵🇹", "🇵🇼", "🇵🇼", "🇵🇾", "🇵🇾", "🇶🇦", "🇶🇦", "🇷🇪", "🇷🇪", "🇷🇴", "🇷🇴", "🇷🇸", "🇷🇸", "🇷🇺", "🇷🇺",
      "🇷🇼", "🇷🇼", "🇸🇦", "🇸🇦", "🇸🇧", "🇸🇧", "🇸🇨", "🇸🇨", "🇸🇩", "🇸🇩", "🇸🇪", "🇸🇪", "🇸🇬", "🇸🇬", "🇸🇭", "🇸🇭", "🇸🇮", "🇸🇮", "🇸🇯",
      "🇸🇯", "🇸🇰", "🇸🇰", "🇸🇱", "🇸🇱", "🇸🇲", "🇸🇲", "🇸🇳", "🇸🇳", "🇸🇴", "🇸🇴", "🇸🇷", "🇸🇷", "🇸🇸", "🇸🇸", "🇸🇹", "🇸🇹", "🇸🇻", "🇸🇻",
      "🇸🇽", "🇸🇽", "🇸🇾", "🇸🇾", "🇸🇿", "🇸🇿", "🇹🇦", "🇹🇦", "🇹🇨", "🇹🇨", "🇹🇩", "🇹🇩", "🇹🇫", "🇹🇫", "🇹🇬", "🇹🇬", "🇹🇭", "🇹🇭", "🇹🇯",
      "🇹🇯", "🇹🇰", "🇹🇰", "🇹🇱", "🇹🇱", "🇹🇲", "🇹🇲", "🇹🇳", "🇹🇳", "🇹🇴", "🇹🇴", "🇹🇷", "🇹🇷", "🇹🇹", "🇹🇹", "🇹🇻", "🇹🇻", "🇹🇼", "🇹🇼",
      "🇹🇿", "🇹🇿", "🇺🇦", "🇺🇦", "🇺🇬", "🇺🇬", "🇺🇲", "🇺🇲", "🇺🇳", "🇺🇳", "🇺🇸", "🇺🇸", "🇺🇾", "🇺🇾", "🇺🇿", "🇺🇿", "🇻🇦", "🇻🇦", "🇻🇨",
      "🇻🇨", "🇻🇪", "🇻🇪", "🇻🇬", "🇻🇬", "🇻🇮", "🇻🇮", "🇻🇳", "🇻🇳", "🇻🇺", "🇻🇺", "🇼🇫", "🇼🇫", "🇼🇸", "🇼🇸", "🇽🇰", "🇽🇰", "🇾🇪", "🇾🇪",
      "🇾🇹", "🇾🇹", "🇿🇦", "🇿🇦", "🇿🇲", "🇿🇲", "🇿🇼", "🇿🇼", "🏴󠁧󠁢󠁥󠁮󠁧󠁿", "🏴󠁧󠁢󠁥󠁮󠁧󠁿",
      "🏴󠁧󠁢󠁳󠁣󠁴󠁿", "🏴󠁧󠁢󠁳󠁣󠁴󠁿", "🏴󠁧󠁢󠁷󠁬󠁳󠁿",
      "🏴󠁧󠁢󠁷󠁬󠁳󠁿", "☝🏻", "☝🏻", "☝🏼", "☝🏼", "☝🏽", "☝🏽", "☝🏾",
      "☝🏾", "☝🏿", "☝🏿", "⛹🏻", "⛹🏻", "⛹🏼", "⛹🏼", "⛹🏽", "⛹🏽", "⛹🏾",
      "⛹🏾", "⛹🏿", "⛹🏿", "✊🏻", "✊🏻", "✊🏼", "✊🏼", "✊🏽", "✊🏽", "✊🏾",
      "✊🏾", "✊🏿", "✊🏿", "✋🏻", "✋🏻", "✋🏼", "✋🏼", "✋🏽", "✋🏽", "✋🏾",
      "✋🏾", "✋🏿", "✋🏿", "✌🏻", "✌🏻", "✌🏼", "✌🏼", "✌🏽", "✌🏽", "✌🏾",
      "✌🏾", "✌🏿", "✌🏿", "✍🏻", "✍🏻", "✍🏼", "✍🏼", "✍🏽", "✍🏽", "✍🏾",
      "✍🏾", "✍🏿", "✍🏿", "🎅🏻", "🎅🏻", "🎅🏼", "🎅🏼", "🎅🏽", "🎅🏽",
      "🎅🏾", "🎅🏾", "🎅🏿", "🎅🏿", "🏂🏻", "🏂🏻", "🏂🏼", "🏂🏼", "🏂🏽",
      "🏂🏽", "🏂🏾", "🏂🏾", "🏂🏿", "🏂🏿", "🏃🏻", "🏃🏻", "🏃🏼", "🏃🏼",
      "🏃🏽", "🏃🏽", "🏃🏾", "🏃🏾", "🏃🏿", "🏃🏿", "🏄🏻", "🏄🏻", "🏄🏼",
      "🏄🏼", "🏄🏽", "🏄🏽", "🏄🏾", "🏄🏾", "🏄🏿", "🏄🏿", "🏇🏻", "🏇🏻",
      "🏇🏼", "🏇🏼", "🏇🏽", "🏇🏽", "🏇🏾", "🏇🏾", "🏇🏿", "🏇🏿", "🏊🏻",
      "🏊🏻", "🏊🏼", "🏊🏼", "🏊🏽", "🏊🏽", "🏊🏾", "🏊🏾", "🏊🏿", "🏊🏿",
      "🏋🏻", "🏋🏻", "🏋🏼", "🏋🏼", "🏋🏽", "🏋🏽", "🏋🏾", "🏋🏾", "🏋🏿",
      "🏋🏿", "🏌🏻", "🏌🏻", "🏌🏼", "🏌🏼", "🏌🏽", "🏌🏽", "🏌🏾", "🏌🏾",
      "🏌🏿", "🏌🏿", "👂🏻", "👂🏻", "👂🏼", "👂🏼", "👂🏽", "👂🏽", "👂🏾",
      "👂🏾", "👂🏿", "👂🏿", "👃🏻", "👃🏻", "👃🏼", "👃🏼", "👃🏽", "👃🏽",
      "👃🏾", "👃🏾", "👃🏿", "👃🏿", "👆🏻", "👆🏻", "👆🏼", "👆🏼", "👆🏽",
      "👆🏽", "👆🏾", "👆🏾", "👆🏿", "👆🏿", "👇🏻", "👇🏻", "👇🏼", "👇🏼",
      "👇🏽", "👇🏽", "👇🏾", "👇🏾", "👇🏿", "👇🏿", "👈🏻", "👈🏻", "👈🏼",
      "👈🏼", "👈🏽", "👈🏽", "👈🏾", "👈🏾", "👈🏿", "👈🏿", "👉🏻", "👉🏻",
      "👉🏼", "👉🏼", "👉🏽", "👉🏽", "👉🏾", "👉🏾", "👉🏿", "👉🏿", "👊🏻",
      "👊🏻", "👊🏼", "👊🏼", "👊🏽", "👊🏽", "👊🏾", "👊🏾", "👊🏿", "👊🏿",
      "👋🏻", "👋🏻", "👋🏼", "👋🏼", "👋🏽", "👋🏽", "👋🏾", "👋🏾", "👋🏿",
      "👋🏿", "👌🏻", "👌🏻", "👌🏼", "👌🏼", "👌🏽", "👌🏽", "👌🏾", "👌🏾",
      "👌🏿", "👌🏿", "👍🏻", "👍🏻", "👍🏼", "👍🏼", "👍🏽", "👍🏽", "👍🏾",
      "👍🏾", "👍🏿", "👍🏿", "👎🏻", "👎🏻", "👎🏼", "👎🏼", "👎🏽", "👎🏽",
      "👎🏾", "👎🏾", "👎🏿", "👎🏿", "👏🏻", "👏🏻", "👏🏼", "👏🏼", "👏🏽",
      "👏🏽", "👏🏾", "👏🏾", "👏🏿", "👏🏿", "👐🏻", "👐🏻", "👐🏼", "👐🏼",
      "👐🏽", "👐🏽", "👐🏾", "👐🏾", "👐🏿", "👐🏿", "👦🏻", "👦🏻", "👦🏼",
      "👦🏼", "👦🏽", "👦🏽", "👦🏾", "👦🏾", "👦🏿", "👦🏿", "👧🏻", "👧🏻",
      "👧🏼", "👧🏼", "👧🏽", "👧🏽", "👧🏾", "👧🏾", "👧🏿", "👧🏿", "👨🏻",
      "👨🏻", "👨🏼", "👨🏼", "👨🏽", "👨🏽", "👨🏾", "👨🏾", "👨🏿", "👨🏿",
      "👩🏻", "👩🏻", "👩🏼", "👩🏼", "👩🏽", "👩🏽", "👩🏾", "👩🏾", "👩🏿",
      "👩🏿", "👫🏻", "👫🏻", "👫🏼", "👫🏼", "👫🏽", "👫🏽", "👫🏾", "👫🏾",
      "👫🏿", "👫🏿", "👬🏻", "👬🏻", "👬🏼", "👬🏼", "👬🏽", "👬🏽", "👬🏾",
      "👬🏾", "👬🏿", "👬🏿", "👭🏻", "👭🏻", "👭🏼", "👭🏼", "👭🏽", "👭🏽",
      "👭🏾", "👭🏾", "👭🏿", "👭🏿", "👮🏻", "👮🏻", "👮🏼", "👮🏼", "👮🏽",
      "👮🏽", "👮🏾", "👮🏾", "👮🏿", "👮🏿", "👰🏻", "👰🏻", "👰🏼", "👰🏼",
      "👰🏽", "👰🏽", "👰🏾", "👰🏾", "👰🏿", "👰🏿", "👱🏻", "👱🏻", "👱🏼",
      "👱🏼", "👱🏽", "👱🏽", "👱🏾", "👱🏾", "👱🏿", "👱🏿", "👲🏻", "👲🏻",
      "👲🏼", "👲🏼", "👲🏽", "👲🏽", "👲🏾", "👲🏾", "👲🏿", "👲🏿", "👳🏻",
      "👳🏻", "👳🏼", "👳🏼", "👳🏽", "👳🏽", "👳🏾", "👳🏾", "👳🏿", "👳🏿",
      "👴🏻", "👴🏻", "👴🏼", "👴🏼", "👴🏽", "👴🏽", "👴🏾", "👴🏾", "👴🏿",
      "👴🏿", "👵🏻", "👵🏻", "👵🏼", "👵🏼", "👵🏽", "👵🏽", "👵🏾", "👵🏾",
      "👵🏿", "👵🏿", "👶🏻", "👶🏻", "👶🏼", "👶🏼", "👶🏽", "👶🏽", "👶🏾",
      "👶🏾", "👶🏿", "👶🏿", "👷🏻", "👷🏻", "👷🏼", "👷🏼", "👷🏽", "👷🏽",
      "👷🏾", "👷🏾", "👷🏿", "👷🏿", "👸🏻", "👸🏻", "👸🏼", "👸🏼", "👸🏽",
      "👸🏽", "👸🏾", "👸🏾", "👸🏿", "👸🏿", "👼🏻", "👼🏻", "👼🏼", "👼🏼",
      "👼🏽", "👼🏽", "👼🏾", "👼🏾", "👼🏿", "👼🏿", "💁🏻", "💁🏻", "💁🏼",
      "💁🏼", "💁🏽", "💁🏽", "💁🏾", "💁🏾", "💁🏿", "💁🏿", "💂🏻", "💂🏻",
      "💂🏼", "💂🏼", "💂🏽", "💂🏽", "💂🏾", "💂🏾", "💂🏿", "💂🏿", "💃🏻",
      "💃🏻", "💃🏼", "💃🏼", "💃🏽", "💃🏽", "💃🏾", "💃🏾", "💃🏿", "💃🏿",
      "💅🏻", "💅🏻", "💅🏼", "💅🏼", "💅🏽", "💅🏽", "💅🏾", "💅🏾", "💅🏿",
      "💅🏿", "💆🏻", "💆🏻", "💆🏼", "💆🏼", "💆🏽", "💆🏽", "💆🏾", "💆🏾",
      "💆🏿", "💆🏿", "💇🏻", "💇🏻", "💇🏼", "💇🏼", "💇🏽", "💇🏽", "💇🏾",
      "💇🏾", "💇🏿", "💇🏿", "💏🏻", "💏🏻", "💏🏼", "💏🏼", "💏🏽", "💏🏽",
      "💏🏾", "💏🏾", "💏🏿", "💏🏿", "💑🏻", "💑🏻", "💑🏼", "💑🏼", "💑🏽",
      "💑🏽", "💑🏾", "💑🏾", "💑🏿", "💑🏿", "💪🏻", "💪🏻", "💪🏼", "💪🏼",
      "💪🏽", "💪🏽", "💪🏾", "💪🏾", "💪🏿", "💪🏿", "🕴🏻", "🕴🏻", "🕴🏼",
      "🕴🏼", "🕴🏽", "🕴🏽", "🕴🏾", "🕴🏾", "🕴🏿", "🕴🏿", "🕵🏻", "🕵🏻",
      "🕵🏼", "🕵🏼", "🕵🏽", "🕵🏽", "🕵🏾", "🕵🏾", "🕵🏿", "🕵🏿", "🕺🏻",
      "🕺🏻", "🕺🏼", "🕺🏼", "🕺🏽", "🕺🏽", "🕺🏾", "🕺🏾", "🕺🏿", "🕺🏿",
      "🖐🏻", "🖐🏻", "🖐🏼", "🖐🏼", "🖐🏽", "🖐🏽", "🖐🏾", "🖐🏾", "🖐🏿",
      "🖐🏿", "🖕🏻", "🖕🏻", "🖕🏼", "🖕🏼", "🖕🏽", "🖕🏽", "🖕🏾", "🖕🏾",
      "🖕🏿", "🖕🏿", "🖖🏻", "🖖🏻", "🖖🏼", "🖖🏼", "🖖🏽", "🖖🏽", "🖖🏾",
      "🖖🏾", "🖖🏿", "🖖🏿", "🙅🏻", "🙅🏻", "🙅🏼", "🙅🏼", "🙅🏽", "🙅🏽",
      "🙅🏾", "🙅🏾", "🙅🏿", "🙅🏿", "🙆🏻", "🙆🏻", "🙆🏼", "🙆🏼", "🙆🏽",
      "🙆🏽", "🙆🏾", "🙆🏾", "🙆🏿", "🙆🏿", "🙇🏻", "🙇🏻", "🙇🏼", "🙇🏼",
      "🙇🏽", "🙇🏽", "🙇🏾", "🙇🏾", "🙇🏿", "🙇🏿", "🙋🏻", "🙋🏻", "🙋🏼",
      "🙋🏼", "🙋🏽", "🙋🏽", "🙋🏾", "🙋🏾", "🙋🏿", "🙋🏿", "🙌🏻", "🙌🏻",
      "🙌🏼", "🙌🏼", "🙌🏽", "🙌🏽", "🙌🏾", "🙌🏾", "🙌🏿", "🙌🏿", "🙍🏻",
      "🙍🏻", "🙍🏼", "🙍🏼", "🙍🏽", "🙍🏽", "🙍🏾", "🙍🏾", "🙍🏿", "🙍🏿",
      "🙎🏻", "🙎🏻", "🙎🏼", "🙎🏼", "🙎🏽", "🙎🏽", "🙎🏾", "🙎🏾", "🙎🏿",
      "🙎🏿", "🙏🏻", "🙏🏻", "🙏🏼", "🙏🏼", "🙏🏽", "🙏🏽", "🙏🏾", "🙏🏾",
      "🙏🏿", "🙏🏿", "🚣🏻", "🚣🏻", "🚣🏼", "🚣🏼", "🚣🏽", "🚣🏽", "🚣🏾",
      "🚣🏾", "🚣🏿", "🚣🏿", "🚴🏻", "🚴🏻", "🚴🏼", "🚴🏼", "🚴🏽", "🚴🏽",
      "🚴🏾", "🚴🏾", "🚴🏿", "🚴🏿", "🚵🏻", "🚵🏻", "🚵🏼", "🚵🏼", "🚵🏽",
      "🚵🏽", "🚵🏾", "🚵🏾", "🚵🏿", "🚵🏿", "🚶🏻", "🚶🏻", "🚶🏼", "🚶🏼",
      "🚶🏽", "🚶🏽", "🚶🏾", "🚶🏾", "🚶🏿", "🚶🏿", "🛀🏻", "🛀🏻", "🛀🏼",
      "🛀🏼", "🛀🏽", "🛀🏽", "🛀🏾", "🛀🏾", "🛀🏿", "🛀🏿", "🛌🏻", "🛌🏻",
      "🛌🏼", "🛌🏼", "🛌🏽", "🛌🏽", "🛌🏾", "🛌🏾", "🛌🏿", "🛌🏿", "🤌🏻",
      "🤌🏻", "🤌🏼", "🤌🏼", "🤌🏽", "🤌🏽", "🤌🏾", "🤌🏾", "🤌🏿", "🤌🏿",
      "🤏🏻", "🤏🏻", "🤏🏼", "🤏🏼", "🤏🏽", "🤏🏽", "🤏🏾", "🤏🏾", "🤏🏿",
      "🤏🏿", "🤘🏻", "🤘🏻", "🤘🏼", "🤘🏼", "🤘🏽", "🤘🏽", "🤘🏾", "🤘🏾",
      "🤘🏿", "🤘🏿", "🤙🏻", "🤙🏻", "🤙🏼", "🤙🏼", "🤙🏽", "🤙🏽", "🤙🏾",
      "🤙🏾", "🤙🏿", "🤙🏿", "🤚🏻", "🤚🏻", "🤚🏼", "🤚🏼", "🤚🏽", "🤚🏽",
      "🤚🏾", "🤚🏾", "🤚🏿", "🤚🏿", "🤛🏻", "🤛🏻", "🤛🏼", "🤛🏼", "🤛🏽",
      "🤛🏽", "🤛🏾", "🤛🏾", "🤛🏿", "🤛🏿", "🤜🏻", "🤜🏻", "🤜🏼", "🤜🏼",
      "🤜🏽", "🤜🏽", "🤜🏾", "🤜🏾", "🤜🏿", "🤜🏿", "🤝🏻", "🤝🏻", "🤝🏼",
      "🤝🏼", "🤝🏽", "🤝🏽", "🤝🏾", "🤝🏾", "🤝🏿", "🤝🏿", "🤞🏻", "🤞🏻",
      "🤞🏼", "🤞🏼", "🤞🏽", "🤞🏽", "🤞🏾", "🤞🏾", "🤞🏿", "🤞🏿", "🤟🏻",
      "🤟🏻", "🤟🏼", "🤟🏼", "🤟🏽", "🤟🏽", "🤟🏾", "🤟🏾", "🤟🏿", "🤟🏿",
      "🤦🏻", "🤦🏻", "🤦🏼", "🤦🏼", "🤦🏽", "🤦🏽", "🤦🏾", "🤦🏾", "🤦🏿",
      "🤦🏿", "🤰🏻", "🤰🏻", "🤰🏼", "🤰🏼", "🤰🏽", "🤰🏽", "🤰🏾", "🤰🏾",
      "🤰🏿", "🤰🏿", "🤱🏻", "🤱🏻", "🤱🏼", "🤱🏼", "🤱🏽", "🤱🏽", "🤱🏾",
      "🤱🏾", "🤱🏿", "🤱🏿", "🤲🏻", "🤲🏻", "🤲🏼", "🤲🏼", "🤲🏽", "🤲🏽",
      "🤲🏾", "🤲🏾", "🤲🏿", "🤲🏿", "🤳🏻", "🤳🏻", "🤳🏼", "🤳🏼", "🤳🏽",
      "🤳🏽", "🤳🏾", "🤳🏾", "🤳🏿", "🤳🏿", "🤴🏻", "🤴🏻", "🤴🏼", "🤴🏼",
      "🤴🏽", "🤴🏽", "🤴🏾", "🤴🏾", "🤴🏿", "🤴🏿", "🤵🏻", "🤵🏻", "🤵🏼",
      "🤵🏼", "🤵🏽", "🤵🏽", "🤵🏾", "🤵🏾", "🤵🏿", "🤵🏿", "🤶🏻", "🤶🏻",
      "🤶🏼", "🤶🏼", "🤶🏽", "🤶🏽", "🤶🏾", "🤶🏾", "🤶🏿", "🤶🏿", "🤷🏻",
      "🤷🏻", "🤷🏼", "🤷🏼", "🤷🏽", "🤷🏽", "🤷🏾", "🤷🏾", "🤷🏿", "🤷🏿",
      "🤸🏻", "🤸🏻", "🤸🏼", "🤸🏼", "🤸🏽", "🤸🏽", "🤸🏾", "🤸🏾", "🤸🏿",
      "🤸🏿", "🤹🏻", "🤹🏻", "🤹🏼", "🤹🏼", "🤹🏽", "🤹🏽", "🤹🏾", "🤹🏾",
      "🤹🏿", "🤹🏿", "🤽🏻", "🤽🏻", "🤽🏼", "🤽🏼", "🤽🏽", "🤽🏽", "🤽🏾",
      "🤽🏾", "🤽🏿", "🤽🏿", "🤾🏻", "🤾🏻", "🤾🏼", "🤾🏼", "🤾🏽", "🤾🏽",
      "🤾🏾", "🤾🏾", "🤾🏿", "🤾🏿", "🥷🏻", "🥷🏻", "🥷🏼", "🥷🏼", "🥷🏽",
      "🥷🏽", "🥷🏾", "🥷🏾", "🥷🏿", "🥷🏿", "🦵🏻", "🦵🏻", "🦵🏼", "🦵🏼",
      "🦵🏽", "🦵🏽", "🦵🏾", "🦵🏾", "🦵🏿", "🦵🏿", "🦶🏻", "🦶🏻", "🦶🏼",
      "🦶🏼", "🦶🏽", "🦶🏽", "🦶🏾", "🦶🏾", "🦶🏿", "🦶🏿", "🦸🏻", "🦸🏻",
      "🦸🏼", "🦸🏼", "🦸🏽", "🦸🏽", "🦸🏾", "🦸🏾", "🦸🏿", "🦸🏿", "🦹🏻",
      "🦹🏻", "🦹🏼", "🦹🏼", "🦹🏽", "🦹🏽", "🦹🏾", "🦹🏾", "🦹🏿", "🦹🏿",
      "🦻🏻", "🦻🏻", "🦻🏼", "🦻🏼", "🦻🏽", "🦻🏽", "🦻🏾", "🦻🏾", "🦻🏿",
      "🦻🏿", "🧍🏻", "🧍🏻", "🧍🏼", "🧍🏼", "🧍🏽", "🧍🏽", "🧍🏾", "🧍🏾",
      "🧍🏿", "🧍🏿", "🧎🏻", "🧎🏻", "🧎🏼", "🧎🏼", "🧎🏽", "🧎🏽", "🧎🏾",
      "🧎🏾", "🧎🏿", "🧎🏿", "🧏🏻", "🧏🏻", "🧏🏼", "🧏🏼", "🧏🏽", "🧏🏽",
      "🧏🏾", "🧏🏾", "🧏🏿", "🧏🏿", "🧑🏻", "🧑🏻", "🧑🏼", "🧑🏼", "🧑🏽",
      "🧑🏽", "🧑🏾", "🧑🏾", "🧑🏿", "🧑🏿", "🧒🏻", "🧒🏻", "🧒🏼", "🧒🏼",
      "🧒🏽", "🧒🏽", "🧒🏾", "🧒🏾", "🧒🏿", "🧒🏿", "🧓🏻", "🧓🏻", "🧓🏼",
      "🧓🏼", "🧓🏽", "🧓🏽", "🧓🏾", "🧓🏾", "🧓🏿", "🧓🏿", "🧔🏻", "🧔🏻",
      "🧔🏼", "🧔🏼", "🧔🏽", "🧔🏽", "🧔🏾", "🧔🏾", "🧔🏿", "🧔🏿", "🧕🏻",
      "🧕🏻", "🧕🏼", "🧕🏼", "🧕🏽", "🧕🏽", "🧕🏾", "🧕🏾", "🧕🏿", "🧕🏿",
      "🧖🏻", "🧖🏻", "🧖🏼", "🧖🏼", "🧖🏽", "🧖🏽", "🧖🏾", "🧖🏾", "🧖🏿",
      "🧖🏿", "🧗🏻", "🧗🏻", "🧗🏼", "🧗🏼", "🧗🏽", "🧗🏽", "🧗🏾", "🧗🏾",
      "🧗🏿", "🧗🏿", "🧘🏻", "🧘🏻", "🧘🏼", "🧘🏼", "🧘🏽", "🧘🏽", "🧘🏾",
      "🧘🏾", "🧘🏿", "🧘🏿", "🧙🏻", "🧙🏻", "🧙🏼", "🧙🏼", "🧙🏽", "🧙🏽",
      "🧙🏾", "🧙🏾", "🧙🏿", "🧙🏿", "🧚🏻", "🧚🏻", "🧚🏼", "🧚🏼", "🧚🏽",
      "🧚🏽", "🧚🏾", "🧚🏾", "🧚🏿", "🧚🏿", "🧛🏻", "🧛🏻", "🧛🏼", "🧛🏼",
      "🧛🏽", "🧛🏽", "🧛🏾", "🧛🏾", "🧛🏿", "🧛🏿", "🧜🏻", "🧜🏻", "🧜🏼",
      "🧜🏼", "🧜🏽", "🧜🏽", "🧜🏾", "🧜🏾", "🧜🏿", "🧜🏿", "🧝🏻", "🧝🏻",
      "🧝🏼", "🧝🏼", "🧝🏽", "🧝🏽", "🧝🏾", "🧝🏾", "🧝🏿", "🧝🏿", "🫃🏻",
      "🫃🏻", "🫃🏼", "🫃🏼", "🫃🏽", "🫃🏽", "🫃🏾", "🫃🏾", "🫃🏿", "🫃🏿",
      "🫄🏻", "🫄🏻", "🫄🏼", "🫄🏼", "🫄🏽", "🫄🏽", "🫄🏾", "🫄🏾", "🫄🏿",
      "🫄🏿", "🫅🏻", "🫅🏻", "🫅🏼", "🫅🏼", "🫅🏽", "🫅🏽", "🫅🏾", "🫅🏾",
      "🫅🏿", "🫅🏿", "🫰🏻", "🫰🏻", "🫰🏼", "🫰🏼", "🫰🏽", "🫰🏽", "🫰🏾",
      "🫰🏾", "🫰🏿", "🫰🏿", "🫱🏻", "🫱🏻", "🫱🏼", "🫱🏼", "🫱🏽", "🫱🏽",
      "🫱🏾", "🫱🏾", "🫱🏿", "🫱🏿", "🫲🏻", "🫲🏻", "🫲🏼", "🫲🏼", "🫲🏽",
      "🫲🏽", "🫲🏾", "🫲🏾", "🫲🏿", "🫲🏿", "🫳🏻", "🫳🏻", "🫳🏼", "🫳🏼",
      "🫳🏽", "🫳🏽", "🫳🏾", "🫳🏾", "🫳🏿", "🫳🏿", "🫴🏻", "🫴🏻", "🫴🏼",
      "🫴🏼", "🫴🏽", "🫴🏽", "🫴🏾", "🫴🏾", "🫴🏿", "🫴🏿", "🫵🏻", "🫵🏻",
      "🫵🏼", "🫵🏼", "🫵🏽", "🫵🏽", "🫵🏾", "🫵🏾", "🫵🏿", "🫵🏿", "🫶🏻",
      "🫶🏻", "🫶🏼", "🫶🏼", "🫶🏽", "🫶🏽", "🫶🏾", "🫶🏾", "🫶🏿", "🫶🏿",
      "👨‍❤‍👨", "👨‍❤️‍👨", "👨‍❤‍💋‍👨", "👨‍❤️‍💋‍👨",
      "👨‍👦", "👨‍👦", "👨‍👦‍👦", "👨‍👦‍👦", "👨‍👧", "👨‍👧",
      "👨‍👧‍👦", "👨‍👧‍👦", "👨‍👧‍👧", "👨‍👧‍👧", "👨‍👨‍👦",
      "👨‍👨‍👦", "👨‍👨‍👦‍👦", "👨‍👨‍👦‍👦", "👨‍👨‍👧",
      "👨‍👨‍👧", "👨‍👨‍👧‍👦", "👨‍👨‍👧‍👦", "👨‍👨‍👧‍👧",
      "👨‍👨‍👧‍👧", "👨‍👩‍👦", "👨‍👩‍👦", "👨‍👩‍👦‍👦",
      "👨‍👩‍👦‍👦", "👨‍👩‍👧", "👨‍👩‍👧", "👨‍👩‍👧‍👦",
      "👨‍👩‍👧‍👦", "👨‍👩‍👧‍👧", "👨‍👩‍👧‍👧",
      "👨🏻‍❤‍👨🏻", "👨🏻‍❤️‍👨🏻", "👨🏻‍❤‍👨🏼",
      "👨🏻‍❤️‍👨🏼", "👨🏻‍❤‍👨🏽", "👨🏻‍❤️‍👨🏽",
      "👨🏻‍❤‍👨🏾", "👨🏻‍❤️‍👨🏾", "👨🏻‍❤‍👨🏿",
      "👨🏻‍❤️‍👨🏿", "👨🏻‍❤‍💋‍👨🏻", "👨🏻‍❤️‍💋‍👨🏻",
      "👨🏻‍❤‍💋‍👨🏼", "👨🏻‍❤️‍💋‍👨🏼", "👨🏻‍❤‍💋‍👨🏽",
      "👨🏻‍❤️‍💋‍👨🏽", "👨🏻‍❤‍💋‍👨🏾", "👨🏻‍❤️‍💋‍👨🏾",
      "👨🏻‍❤‍💋‍👨🏿", "👨🏻‍❤️‍💋‍👨🏿", "👨🏻‍🤝‍👨🏼",
      "👨🏻‍🤝‍👨🏼", "👨🏻‍🤝‍👨🏽", "👨🏻‍🤝‍👨🏽",
      "👨🏻‍🤝‍👨🏾", "👨🏻‍🤝‍👨🏾", "👨🏻‍🤝‍👨🏿",
      "👨🏻‍🤝‍👨🏿", "👨🏼‍❤‍👨🏻", "👨🏼‍❤️‍👨🏻",
      "👨🏼‍❤‍👨🏼", "👨🏼‍❤️‍👨🏼", "👨🏼‍❤‍👨🏽",
      "👨🏼‍❤️‍👨🏽", "👨🏼‍❤‍👨🏾", "👨🏼‍❤️‍👨🏾",
      "👨🏼‍❤‍👨🏿", "👨🏼‍❤️‍👨🏿", "👨🏼‍❤‍💋‍👨🏻",
      "👨🏼‍❤️‍💋‍👨🏻", "👨🏼‍❤‍💋‍👨🏼", "👨🏼‍❤️‍💋‍👨🏼",
      "👨🏼‍❤‍💋‍👨🏽", "👨🏼‍❤️‍💋‍👨🏽", "👨🏼‍❤‍💋‍👨🏾",
      "👨🏼‍❤️‍💋‍👨🏾", "👨🏼‍❤‍💋‍👨🏿", "👨🏼‍❤️‍💋‍👨🏿",
      "👨🏼‍🤝‍👨🏻", "👨🏼‍🤝‍👨🏻", "👨🏼‍🤝‍👨🏽",
      "👨🏼‍🤝‍👨🏽", "👨🏼‍🤝‍👨🏾", "👨🏼‍🤝‍👨🏾",
      "👨🏼‍🤝‍👨🏿", "👨🏼‍🤝‍👨🏿", "👨🏽‍❤‍👨🏻",
      "👨🏽‍❤️‍👨🏻", "👨🏽‍❤‍👨🏼", "👨🏽‍❤️‍👨🏼",
      "👨🏽‍❤‍👨🏽", "👨🏽‍❤️‍👨🏽", "👨🏽‍❤‍👨🏾",
      "👨🏽‍❤️‍👨🏾", "👨🏽‍❤‍👨🏿", "👨🏽‍❤️‍👨🏿",
      "👨🏽‍❤‍💋‍👨🏻", "👨🏽‍❤️‍💋‍👨🏻", "👨🏽‍❤‍💋‍👨🏼",
      "👨🏽‍❤️‍💋‍👨🏼", "👨🏽‍❤‍💋‍👨🏽", "👨🏽‍❤️‍💋‍👨🏽",
      "👨🏽‍❤‍💋‍👨🏾", "👨🏽‍❤️‍💋‍👨🏾", "👨🏽‍❤‍💋‍👨🏿",
      "👨🏽‍❤️‍💋‍👨🏿", "👨🏽‍🤝‍👨🏻", "👨🏽‍🤝‍👨🏻",
      "👨🏽‍🤝‍👨🏼", "👨🏽‍🤝‍👨🏼", "👨🏽‍🤝‍👨🏾",
      "👨🏽‍🤝‍👨🏾", "👨🏽‍🤝‍👨🏿", "👨🏽‍🤝‍👨🏿",
      "👨🏾‍❤‍👨🏻", "👨🏾‍❤️‍👨🏻", "👨🏾‍❤‍👨🏼",
      "👨🏾‍❤️‍👨🏼", "👨🏾‍❤‍👨🏽", "👨🏾‍❤️‍👨🏽",
      "👨🏾‍❤‍👨🏾", "👨🏾‍❤️‍👨🏾", "👨🏾‍❤‍👨🏿",
      "👨🏾‍❤️‍👨🏿", "👨🏾‍❤‍💋‍👨🏻", "👨🏾‍❤️‍💋‍👨🏻",
      "👨🏾‍❤‍💋‍👨🏼", "👨🏾‍❤️‍💋‍👨🏼", "👨🏾‍❤‍💋‍👨🏽",
      "👨🏾‍❤️‍💋‍👨🏽", "👨🏾‍❤‍💋‍👨🏾", "👨🏾‍❤️‍💋‍👨🏾",
      "👨🏾‍❤‍💋‍👨🏿", "👨🏾‍❤️‍💋‍👨🏿", "👨🏾‍🤝‍👨🏻",
      "👨🏾‍🤝‍👨🏻", "👨🏾‍🤝‍👨🏼", "👨🏾‍🤝‍👨🏼",
      "👨🏾‍🤝‍👨🏽", "👨🏾‍🤝‍👨🏽", "👨🏾‍🤝‍👨🏿",
      "👨🏾‍🤝‍👨🏿", "👨🏿‍❤‍👨🏻", "👨🏿‍❤️‍👨🏻",
      "👨🏿‍❤‍👨🏼", "👨🏿‍❤️‍👨🏼", "👨🏿‍❤‍👨🏽",
      "👨🏿‍❤️‍👨🏽", "👨🏿‍❤‍👨🏾", "👨🏿‍❤️‍👨🏾",
      "👨🏿‍❤‍👨🏿", "👨🏿‍❤️‍👨🏿", "👨🏿‍❤‍💋‍👨🏻",
      "👨🏿‍❤️‍💋‍👨🏻", "👨🏿‍❤‍💋‍👨🏼", "👨🏿‍❤️‍💋‍👨🏼",
      "👨🏿‍❤‍💋‍👨🏽", "👨🏿‍❤️‍💋‍👨🏽", "👨🏿‍❤‍💋‍👨🏾",
      "👨🏿‍❤️‍💋‍👨🏾", "👨🏿‍❤‍💋‍👨🏿", "👨🏿‍❤️‍💋‍👨🏿",
      "👨🏿‍🤝‍👨🏻", "👨🏿‍🤝‍👨🏻", "👨🏿‍🤝‍👨🏼",
      "👨🏿‍🤝‍👨🏼", "👨🏿‍🤝‍👨🏽", "👨🏿‍🤝‍👨🏽",
      "👨🏿‍🤝‍👨🏾", "👨🏿‍🤝‍👨🏾", "👩‍❤‍👨", "👩‍❤️‍👨",
      "👩‍❤‍👩", "👩‍❤️‍👩", "👩‍❤‍💋‍👨", "👩‍❤️‍💋‍👨",
      "👩‍❤‍💋‍👩", "👩‍❤️‍💋‍👩", "👩‍👦", "👩‍👦", "👩‍👦‍👦",
      "👩‍👦‍👦", "👩‍👧", "👩‍👧", "👩‍👧‍👦", "👩‍👧‍👦",
      "👩‍👧‍👧", "👩‍👧‍👧", "👩‍👩‍👦", "👩‍👩‍👦",
      "👩‍👩‍👦‍👦", "👩‍👩‍👦‍👦", "👩‍👩‍👧", "👩‍👩‍👧",
      "👩‍👩‍👧‍👦", "👩‍👩‍👧‍👦", "👩‍👩‍👧‍👧",
      "👩‍👩‍👧‍👧", "👩🏻‍❤‍👨🏻", "👩🏻‍❤️‍👨🏻",
      "👩🏻‍❤‍👨🏼", "👩🏻‍❤️‍👨🏼", "👩🏻‍❤‍👨🏽",
      "👩🏻‍❤️‍👨🏽", "👩🏻‍❤‍👨🏾", "👩🏻‍❤️‍👨🏾",
      "👩🏻‍❤‍👨🏿", "👩🏻‍❤️‍👨🏿", "👩🏻‍❤‍👩🏻",
      "👩🏻‍❤️‍👩🏻", "👩🏻‍❤‍👩🏼", "👩🏻‍❤️‍👩🏼",
      "👩🏻‍❤‍👩🏽", "👩🏻‍❤️‍👩🏽", "👩🏻‍❤‍👩🏾",
      "👩🏻‍❤️‍👩🏾", "👩🏻‍❤‍👩🏿", "👩🏻‍❤️‍👩🏿",
      "👩🏻‍❤‍💋‍👨🏻", "👩🏻‍❤️‍💋‍👨🏻", "👩🏻‍❤‍💋‍👨🏼",
      "👩🏻‍❤️‍💋‍👨🏼", "👩🏻‍❤‍💋‍👨🏽", "👩🏻‍❤️‍💋‍👨🏽",
      "👩🏻‍❤‍💋‍👨🏾", "👩🏻‍❤️‍💋‍👨🏾", "👩🏻‍❤‍💋‍👨🏿",
      "👩🏻‍❤️‍💋‍👨🏿", "👩🏻‍❤‍💋‍👩🏻", "👩🏻‍❤️‍💋‍👩🏻",
      "👩🏻‍❤‍💋‍👩🏼", "👩🏻‍❤️‍💋‍👩🏼", "👩🏻‍❤‍💋‍👩🏽",
      "👩🏻‍❤️‍💋‍👩🏽", "👩🏻‍❤‍💋‍👩🏾", "👩🏻‍❤️‍💋‍👩🏾",
      "👩🏻‍❤‍💋‍👩🏿", "👩🏻‍❤️‍💋‍👩🏿", "👩🏻‍🤝‍👨🏼",
      "👩🏻‍🤝‍👨🏼", "👩🏻‍🤝‍👨🏽", "👩🏻‍🤝‍👨🏽",
      "👩🏻‍🤝‍👨🏾", "👩🏻‍🤝‍👨🏾", "👩🏻‍🤝‍👨🏿",
      "👩🏻‍🤝‍👨🏿", "👩🏻‍🤝‍👩🏼", "👩🏻‍🤝‍👩🏼",
      "👩🏻‍🤝‍👩🏽", "👩🏻‍🤝‍👩🏽", "👩🏻‍🤝‍👩🏾",
      "👩🏻‍🤝‍👩🏾", "👩🏻‍🤝‍👩🏿", "👩🏻‍🤝‍👩🏿",
      "👩🏼‍❤‍👨🏻", "👩🏼‍❤️‍👨🏻", "👩🏼‍❤‍👨🏼",
      "👩🏼‍❤️‍👨🏼", "👩🏼‍❤‍👨🏽", "👩🏼‍❤️‍👨🏽",
      "👩🏼‍❤‍👨🏾", "👩🏼‍❤️‍👨🏾", "👩🏼‍❤‍👨🏿",
      "👩🏼‍❤️‍👨🏿", "👩🏼‍❤‍👩🏻", "👩🏼‍❤️‍👩🏻",
      "👩🏼‍❤‍👩🏼", "👩🏼‍❤️‍👩🏼", "👩🏼‍❤‍👩🏽",
      "👩🏼‍❤️‍👩🏽", "👩🏼‍❤‍👩🏾", "👩🏼‍❤️‍👩🏾",
      "👩🏼‍❤‍👩🏿", "👩🏼‍❤️‍👩🏿", "👩🏼‍❤‍💋‍👨🏻",
      "👩🏼‍❤️‍💋‍👨🏻", "👩🏼‍❤‍💋‍👨🏼", "👩🏼‍❤️‍💋‍👨🏼",
      "👩🏼‍❤‍💋‍👨🏽", "👩🏼‍❤️‍💋‍👨🏽", "👩🏼‍❤‍💋‍👨🏾",
      "👩🏼‍❤️‍💋‍👨🏾", "👩🏼‍❤‍💋‍👨🏿", "👩🏼‍❤️‍💋‍👨🏿",
      "👩🏼‍❤‍💋‍👩🏻", "👩🏼‍❤️‍💋‍👩🏻", "👩🏼‍❤‍💋‍👩🏼",
      "👩🏼‍❤️‍💋‍👩🏼", "👩🏼‍❤‍💋‍👩🏽", "👩🏼‍❤️‍💋‍👩🏽",
      "👩🏼‍❤‍💋‍👩🏾", "👩🏼‍❤️‍💋‍👩🏾", "👩🏼‍❤‍💋‍👩🏿",
      "👩🏼‍❤️‍💋‍👩🏿", "👩🏼‍🤝‍👨🏻", "👩🏼‍🤝‍👨🏻",
      "👩🏼‍🤝‍👨🏽", "👩🏼‍🤝‍👨🏽", "👩🏼‍🤝‍👨🏾",
      "👩🏼‍🤝‍👨🏾", "👩🏼‍🤝‍👨🏿", "👩🏼‍🤝‍👨🏿",
      "👩🏼‍🤝‍👩🏻", "👩🏼‍🤝‍👩🏻", "👩🏼‍🤝‍👩🏽",
      "👩🏼‍🤝‍👩🏽", "👩🏼‍🤝‍👩🏾", "👩🏼‍🤝‍👩🏾",
      "👩🏼‍🤝‍👩🏿", "👩🏼‍🤝‍👩🏿", "👩🏽‍❤‍👨🏻",
      "👩🏽‍❤️‍👨🏻", "👩🏽‍❤‍👨🏼", "👩🏽‍❤️‍👨🏼",
      "👩🏽‍❤‍👨🏽", "👩🏽‍❤️‍👨🏽", "👩🏽‍❤‍👨🏾",
      "👩🏽‍❤️‍👨🏾", "👩🏽‍❤‍👨🏿", "👩🏽‍❤️‍👨🏿",
      "👩🏽‍❤‍👩🏻", "👩🏽‍❤️‍👩🏻", "👩🏽‍❤‍👩🏼",
      "👩🏽‍❤️‍👩🏼", "👩🏽‍❤‍👩🏽", "👩🏽‍❤️‍👩🏽",
      "👩🏽‍❤‍👩🏾", "👩🏽‍❤️‍👩🏾", "👩🏽‍❤‍👩🏿",
      "👩🏽‍❤️‍👩🏿", "👩🏽‍❤‍💋‍👨🏻", "👩🏽‍❤️‍💋‍👨🏻",
      "👩🏽‍❤‍💋‍👨🏼", "👩🏽‍❤️‍💋‍👨🏼", "👩🏽‍❤‍💋‍👨🏽",
      "👩🏽‍❤️‍💋‍👨🏽", "👩🏽‍❤‍💋‍👨🏾", "👩🏽‍❤️‍💋‍👨🏾",
      "👩🏽‍❤‍💋‍👨🏿", "👩🏽‍❤️‍💋‍👨🏿", "👩🏽‍❤‍💋‍👩🏻",
      "👩🏽‍❤️‍💋‍👩🏻", "👩🏽‍❤‍💋‍👩🏼", "👩🏽‍❤️‍💋‍👩🏼",
      "👩🏽‍❤‍💋‍👩🏽", "👩🏽‍❤️‍💋‍👩🏽", "👩🏽‍❤‍💋‍👩🏾",
      "👩🏽‍❤️‍💋‍👩🏾", "👩🏽‍❤‍💋‍👩🏿", "👩🏽‍❤️‍💋‍👩🏿",
      "👩🏽‍🤝‍👨🏻", "👩🏽‍🤝‍👨🏻", "👩🏽‍🤝‍👨🏼",
      "👩🏽‍🤝‍👨🏼", "👩🏽‍🤝‍👨🏾", "👩🏽‍🤝‍👨🏾",
      "👩🏽‍🤝‍👨🏿", "👩🏽‍🤝‍👨🏿", "👩🏽‍🤝‍👩🏻",
      "👩🏽‍🤝‍👩🏻", "👩🏽‍🤝‍👩🏼", "👩🏽‍🤝‍👩🏼",
      "👩🏽‍🤝‍👩🏾", "👩🏽‍🤝‍👩🏾", "👩🏽‍🤝‍👩🏿",
      "👩🏽‍🤝‍👩🏿", "👩🏾‍❤‍👨🏻", "👩🏾‍❤️‍👨🏻",
      "👩🏾‍❤‍👨🏼", "👩🏾‍❤️‍👨🏼", "👩🏾‍❤‍👨🏽",
      "👩🏾‍❤️‍👨🏽", "👩🏾‍❤‍👨🏾", "👩🏾‍❤️‍👨🏾",
      "👩🏾‍❤‍👨🏿", "👩🏾‍❤️‍👨🏿", "👩🏾‍❤‍👩🏻",
      "👩🏾‍❤️‍👩🏻", "👩🏾‍❤‍👩🏼", "👩🏾‍❤️‍👩🏼",
      "👩🏾‍❤‍👩🏽", "👩🏾‍❤️‍👩🏽", "👩🏾‍❤‍👩🏾",
      "👩🏾‍❤️‍👩🏾", "👩🏾‍❤‍👩🏿", "👩🏾‍❤️‍👩🏿",
      "👩🏾‍❤‍💋‍👨🏻", "👩🏾‍❤️‍💋‍👨🏻", "👩🏾‍❤‍💋‍👨🏼",
      "👩🏾‍❤️‍💋‍👨🏼", "👩🏾‍❤‍💋‍👨🏽", "👩🏾‍❤️‍💋‍👨🏽",
      "👩🏾‍❤‍💋‍👨🏾", "👩🏾‍❤️‍💋‍👨🏾", "👩🏾‍❤‍💋‍👨🏿",
      "👩🏾‍❤️‍💋‍👨🏿", "👩🏾‍❤‍💋‍👩🏻", "👩🏾‍❤️‍💋‍👩🏻",
      "👩🏾‍❤‍💋‍👩🏼", "👩🏾‍❤️‍💋‍👩🏼", "👩🏾‍❤‍💋‍👩🏽",
      "👩🏾‍❤️‍💋‍👩🏽", "👩🏾‍❤‍💋‍👩🏾", "👩🏾‍❤️‍💋‍👩🏾",
      "👩🏾‍❤‍💋‍👩🏿", "👩🏾‍❤️‍💋‍👩🏿", "👩🏾‍🤝‍👨🏻",
      "👩🏾‍🤝‍👨🏻", "👩🏾‍🤝‍👨🏼", "👩🏾‍🤝‍👨🏼",
      "👩🏾‍🤝‍👨🏽", "👩🏾‍🤝‍👨🏽", "👩🏾‍🤝‍👨🏿",
      "👩🏾‍🤝‍👨🏿", "👩🏾‍🤝‍👩🏻", "👩🏾‍🤝‍👩🏻",
      "👩🏾‍🤝‍👩🏼", "👩🏾‍🤝‍👩🏼", "👩🏾‍🤝‍👩🏽",
      "👩🏾‍🤝‍👩🏽", "👩🏾‍🤝‍👩🏿", "👩🏾‍🤝‍👩🏿",
      "👩🏿‍❤‍👨🏻", "👩🏿‍❤️‍👨🏻", "👩🏿‍❤‍👨🏼",
      "👩🏿‍❤️‍👨🏼", "👩🏿‍❤‍👨🏽", "👩🏿‍❤️‍👨🏽",
      "👩🏿‍❤‍👨🏾", "👩🏿‍❤️‍👨🏾", "👩🏿‍❤‍👨🏿",
      "👩🏿‍❤️‍👨🏿", "👩🏿‍❤‍👩🏻", "👩🏿‍❤️‍👩🏻",
      "👩🏿‍❤‍👩🏼", "👩🏿‍❤️‍👩🏼", "👩🏿‍❤‍👩🏽",
      "👩🏿‍❤️‍👩🏽", "👩🏿‍❤‍👩🏾", "👩🏿‍❤️‍👩🏾",
      "👩🏿‍❤‍👩🏿", "👩🏿‍❤️‍👩🏿", "👩🏿‍❤‍💋‍👨🏻",
      "👩🏿‍❤️‍💋‍👨🏻", "👩🏿‍❤‍💋‍👨🏼", "👩🏿‍❤️‍💋‍👨🏼",
      "👩🏿‍❤‍💋‍👨🏽", "👩🏿‍❤️‍💋‍👨🏽", "👩🏿‍❤‍💋‍👨🏾",
      "👩🏿‍❤️‍💋‍👨🏾", "👩🏿‍❤‍💋‍👨🏿", "👩🏿‍❤️‍💋‍👨🏿",
      "👩🏿‍❤‍💋‍👩🏻", "👩🏿‍❤️‍💋‍👩🏻", "👩🏿‍❤‍💋‍👩🏼",
      "👩🏿‍❤️‍💋‍👩🏼", "👩🏿‍❤‍💋‍👩🏽", "👩🏿‍❤️‍💋‍👩🏽",
      "👩🏿‍❤‍💋‍👩🏾", "👩🏿‍❤️‍💋‍👩🏾", "👩🏿‍❤‍💋‍👩🏿",
      "👩🏿‍❤️‍💋‍👩🏿", "👩🏿‍🤝‍👨🏻", "👩🏿‍🤝‍👨🏻",
      "👩🏿‍🤝‍👨🏼", "👩🏿‍🤝‍👨🏼", "👩🏿‍🤝‍👨🏽",
      "👩🏿‍🤝‍👨🏽", "👩🏿‍🤝‍👨🏾", "👩🏿‍🤝‍👨🏾",
      "👩🏿‍🤝‍👩🏻", "👩🏿‍🤝‍👩🏻", "👩🏿‍🤝‍👩🏼",
      "👩🏿‍🤝‍👩🏼", "👩🏿‍🤝‍👩🏽", "👩🏿‍🤝‍👩🏽",
      "👩🏿‍🤝‍👩🏾", "👩🏿‍🤝‍👩🏾", "🧑‍🤝‍🧑", "🧑‍🤝‍🧑",
      "🧑🏻‍❤‍💋‍🧑🏼", "🧑🏻‍❤️‍💋‍🧑🏼", "🧑🏻‍❤‍💋‍🧑🏽",
      "🧑🏻‍❤️‍💋‍🧑🏽", "🧑🏻‍❤‍💋‍🧑🏾", "🧑🏻‍❤️‍💋‍🧑🏾",
      "🧑🏻‍❤‍💋‍🧑🏿", "🧑🏻‍❤️‍💋‍🧑🏿", "🧑🏻‍❤‍🧑🏼",
      "🧑🏻‍❤️‍🧑🏼", "🧑🏻‍❤‍🧑🏽", "🧑🏻‍❤️‍🧑🏽",
      "🧑🏻‍❤‍🧑🏾", "🧑🏻‍❤️‍🧑🏾", "🧑🏻‍❤‍🧑🏿",
      "🧑🏻‍❤️‍🧑🏿", "🧑🏻‍🎄", "🧑🏻‍🎄", "🧑🏻‍🤝‍🧑🏻",
      "🧑🏻‍🤝‍🧑🏻", "🧑🏻‍🤝‍🧑🏼", "🧑🏻‍🤝‍🧑🏼",
      "🧑🏻‍🤝‍🧑🏽", "🧑🏻‍🤝‍🧑🏽", "🧑🏻‍🤝‍🧑🏾",
      "🧑🏻‍🤝‍🧑🏾", "🧑🏻‍🤝‍🧑🏿", "🧑🏻‍🤝‍🧑🏿",
      "🧑🏼‍❤‍💋‍🧑🏻", "🧑🏼‍❤️‍💋‍🧑🏻", "🧑🏼‍❤‍💋‍🧑🏽",
      "🧑🏼‍❤️‍💋‍🧑🏽", "🧑🏼‍❤‍💋‍🧑🏾", "🧑🏼‍❤️‍💋‍🧑🏾",
      "🧑🏼‍❤‍💋‍🧑🏿", "🧑🏼‍❤️‍💋‍🧑🏿", "🧑🏼‍❤‍🧑🏻",
      "🧑🏼‍❤️‍🧑🏻", "🧑🏼‍❤‍🧑🏽", "🧑🏼‍❤️‍🧑🏽",
      "🧑🏼‍❤‍🧑🏾", "🧑🏼‍❤️‍🧑🏾", "🧑🏼‍❤‍🧑🏿",
      "🧑🏼‍❤️‍🧑🏿", "🧑🏼‍🎄", "🧑🏼‍🎄", "🧑🏼‍🤝‍🧑🏻",
      "🧑🏼‍🤝‍🧑🏻", "🧑🏼‍🤝‍🧑🏼", "🧑🏼‍🤝‍🧑🏼",
      "🧑🏼‍🤝‍🧑🏽", "🧑🏼‍🤝‍🧑🏽", "🧑🏼‍🤝‍🧑🏾",
      "🧑🏼‍🤝‍🧑🏾", "🧑🏼‍🤝‍🧑🏿", "🧑🏼‍🤝‍🧑🏿",
      "🧑🏽‍❤‍💋‍🧑🏻", "🧑🏽‍❤️‍💋‍🧑🏻", "🧑🏽‍❤‍💋‍🧑🏼",
      "🧑🏽‍❤️‍💋‍🧑🏼", "🧑🏽‍❤‍💋‍🧑🏾", "🧑🏽‍❤️‍💋‍🧑🏾",
      "🧑🏽‍❤‍💋‍🧑🏿", "🧑🏽‍❤️‍💋‍🧑🏿", "🧑🏽‍❤‍🧑🏻",
      "🧑🏽‍❤️‍🧑🏻", "🧑🏽‍❤‍🧑🏼", "🧑🏽‍❤️‍🧑🏼",
      "🧑🏽‍❤‍🧑🏾", "🧑🏽‍❤️‍🧑🏾", "🧑🏽‍❤‍🧑🏿",
      "🧑🏽‍❤️‍🧑🏿", "🧑🏽‍🎄", "🧑🏽‍🎄", "🧑🏽‍🤝‍🧑🏻",
      "🧑🏽‍🤝‍🧑🏻", "🧑🏽‍🤝‍🧑🏼", "🧑🏽‍🤝‍🧑🏼",
      "🧑🏽‍🤝‍🧑🏽", "🧑🏽‍🤝‍🧑🏽", "🧑🏽‍🤝‍🧑🏾",
      "🧑🏽‍🤝‍🧑🏾", "🧑🏽‍🤝‍🧑🏿", "🧑🏽‍🤝‍🧑🏿",
      "🧑🏾‍❤‍💋‍🧑🏻", "🧑🏾‍❤️‍💋‍🧑🏻", "🧑🏾‍❤‍💋‍🧑🏼",
      "🧑🏾‍❤️‍💋‍🧑🏼", "🧑🏾‍❤‍💋‍🧑🏽", "🧑🏾‍❤️‍💋‍🧑🏽",
      "🧑🏾‍❤‍💋‍🧑🏿", "🧑🏾‍❤️‍💋‍🧑🏿", "🧑🏾‍❤‍🧑🏻",
      "🧑🏾‍❤️‍🧑🏻", "🧑🏾‍❤‍🧑🏼", "🧑🏾‍❤️‍🧑🏼",
      "🧑🏾‍❤‍🧑🏽", "🧑🏾‍❤️‍🧑🏽", "🧑🏾‍❤‍🧑🏿",
      "🧑🏾‍❤️‍🧑🏿", "🧑🏾‍🎄", "🧑🏾‍🎄", "🧑🏾‍🤝‍🧑🏻",
      "🧑🏾‍🤝‍🧑🏻", "🧑🏾‍🤝‍🧑🏼", "🧑🏾‍🤝‍🧑🏼",
      "🧑🏾‍🤝‍🧑🏽", "🧑🏾‍🤝‍🧑🏽", "🧑🏾‍🤝‍🧑🏾",
      "🧑🏾‍🤝‍🧑🏾", "🧑🏾‍🤝‍🧑🏿", "🧑🏾‍🤝‍🧑🏿",
      "🧑🏿‍❤‍💋‍🧑🏻", "🧑🏿‍❤️‍💋‍🧑🏻", "🧑🏿‍❤‍💋‍🧑🏼",
      "🧑🏿‍❤️‍💋‍🧑🏼", "🧑🏿‍❤‍💋‍🧑🏽", "🧑🏿‍❤️‍💋‍🧑🏽",
      "🧑🏿‍❤‍💋‍🧑🏾", "🧑🏿‍❤️‍💋‍🧑🏾", "🧑🏿‍❤‍🧑🏻",
      "🧑🏿‍❤️‍🧑🏻", "🧑🏿‍❤‍🧑🏼", "🧑🏿‍❤️‍🧑🏼",
      "🧑🏿‍❤‍🧑🏽", "🧑🏿‍❤️‍🧑🏽", "🧑🏿‍❤‍🧑🏾",
      "🧑🏿‍❤️‍🧑🏾", "🧑🏿‍🎄", "🧑🏿‍🎄", "🧑🏿‍🤝‍🧑🏻",
      "🧑🏿‍🤝‍🧑🏻", "🧑🏿‍🤝‍🧑🏼", "🧑🏿‍🤝‍🧑🏼",
      "🧑🏿‍🤝‍🧑🏽", "🧑🏿‍🤝‍🧑🏽", "🧑🏿‍🤝‍🧑🏾",
      "🧑🏿‍🤝‍🧑🏾", "🧑🏿‍🤝‍🧑🏿", "🧑🏿‍🤝‍🧑🏿", "🫱🏻‍🫲🏼",
      "🫱🏻‍🫲🏼", "🫱🏻‍🫲🏽", "🫱🏻‍🫲🏽", "🫱🏻‍🫲🏾", "🫱🏻‍🫲🏾",
      "🫱🏻‍🫲🏿", "🫱🏻‍🫲🏿", "🫱🏼‍🫲🏻", "🫱🏼‍🫲🏻", "🫱🏼‍🫲🏽",
      "🫱🏼‍🫲🏽", "🫱🏼‍🫲🏾", "🫱🏼‍🫲🏾", "🫱🏼‍🫲🏿", "🫱🏼‍🫲🏿",
      "🫱🏽‍🫲🏻", "🫱🏽‍🫲🏻", "🫱🏽‍🫲🏼", "🫱🏽‍🫲🏼", "🫱🏽‍🫲🏾",
      "🫱🏽‍🫲🏾", "🫱🏽‍🫲🏿", "🫱🏽‍🫲🏿", "🫱🏾‍🫲🏻", "🫱🏾‍🫲🏻",
      "🫱🏾‍🫲🏼", "🫱🏾‍🫲🏼", "🫱🏾‍🫲🏽", "🫱🏾‍🫲🏽", "🫱🏾‍🫲🏿",
      "🫱🏾‍🫲🏿", "🫱🏿‍🫲🏻", "🫱🏿‍🫲🏻", "🫱🏿‍🫲🏼", "🫱🏿‍🫲🏼",
      "🫱🏿‍🫲🏽", "🫱🏿‍🫲🏽", "🫱🏿‍🫲🏾", "🫱🏿‍🫲🏾", "👨‍⚕",
      "👨‍⚕️", "👨‍⚖", "👨‍⚖️", "👨‍✈", "👨‍✈️", "👨‍🌾", "👨‍🌾",
      "👨‍🍳", "👨‍🍳", "👨‍🍼", "👨‍🍼", "👨‍🎓", "👨‍🎓", "👨‍🎤",
      "👨‍🎤", "👨‍🎨", "👨‍🎨", "👨‍🏫", "👨‍🏫", "👨‍🏭", "👨‍🏭",
      "👨‍💻", "👨‍💻", "👨‍💼", "👨‍💼", "👨‍🔧", "👨‍🔧", "👨‍🔬",
      "👨‍🔬", "👨‍🚀", "👨‍🚀", "👨‍🚒", "👨‍🚒", "👨‍🦯", "👨‍🦯",
      "👨‍🦼", "👨‍🦼", "👨‍🦽", "👨‍🦽", "👨🏻‍⚕", "👨🏻‍⚕️",
      "👨🏻‍⚖", "👨🏻‍⚖️", "👨🏻‍✈", "👨🏻‍✈️", "👨🏻‍🌾",
      "👨🏻‍🌾", "👨🏻‍🍳", "👨🏻‍🍳", "👨🏻‍🍼", "👨🏻‍🍼", "👨🏻‍🎓",
      "👨🏻‍🎓", "👨🏻‍🎤", "👨🏻‍🎤", "👨🏻‍🎨", "👨🏻‍🎨", "👨🏻‍🏫",
      "👨🏻‍🏫", "👨🏻‍🏭", "👨🏻‍🏭", "👨🏻‍💻", "👨🏻‍💻", "👨🏻‍💼",
      "👨🏻‍💼", "👨🏻‍🔧", "👨🏻‍🔧", "👨🏻‍🔬", "👨🏻‍🔬", "👨🏻‍🚀",
      "👨🏻‍🚀", "👨🏻‍🚒", "👨🏻‍🚒", "👨🏻‍🦯", "👨🏻‍🦯", "👨🏻‍🦼",
      "👨🏻‍🦼", "👨🏻‍🦽", "👨🏻‍🦽", "👨🏼‍⚕", "👨🏼‍⚕️", "👨🏼‍⚖",
      "👨🏼‍⚖️", "👨🏼‍✈", "👨🏼‍✈️", "👨🏼‍🌾", "👨🏼‍🌾",
      "👨🏼‍🍳", "👨🏼‍🍳", "👨🏼‍🍼", "👨🏼‍🍼", "👨🏼‍🎓", "👨🏼‍🎓",
      "👨🏼‍🎤", "👨🏼‍🎤", "👨🏼‍🎨", "👨🏼‍🎨", "👨🏼‍🏫", "👨🏼‍🏫",
      "👨🏼‍🏭", "👨🏼‍🏭", "👨🏼‍💻", "👨🏼‍💻", "👨🏼‍💼", "👨🏼‍💼",
      "👨🏼‍🔧", "👨🏼‍🔧", "👨🏼‍🔬", "👨🏼‍🔬", "👨🏼‍🚀", "👨🏼‍🚀",
      "👨🏼‍🚒", "👨🏼‍🚒", "👨🏼‍🦯", "👨🏼‍🦯", "👨🏼‍🦼", "👨🏼‍🦼",
      "👨🏼‍🦽", "👨🏼‍🦽", "👨🏽‍⚕", "👨🏽‍⚕️", "👨🏽‍⚖",
      "👨🏽‍⚖️", "👨🏽‍✈", "👨🏽‍✈️", "👨🏽‍🌾", "👨🏽‍🌾",
      "👨🏽‍🍳", "👨🏽‍🍳", "👨🏽‍🍼", "👨🏽‍🍼", "👨🏽‍🎓", "👨🏽‍🎓",
      "👨🏽‍🎤", "👨🏽‍🎤", "👨🏽‍🎨", "👨🏽‍🎨", "👨🏽‍🏫", "👨🏽‍🏫",
      "👨🏽‍🏭", "👨🏽‍🏭", "👨🏽‍💻", "👨🏽‍💻", "👨🏽‍💼", "👨🏽‍💼",
      "👨🏽‍🔧", "👨🏽‍🔧", "👨🏽‍🔬", "👨🏽‍🔬", "👨🏽‍🚀", "👨🏽‍🚀",
      "👨🏽‍🚒", "👨🏽‍🚒", "👨🏽‍🦯", "👨🏽‍🦯", "👨🏽‍🦼", "👨🏽‍🦼",
      "👨🏽‍🦽", "👨🏽‍🦽", "👨🏾‍⚕", "👨🏾‍⚕️", "👨🏾‍⚖",
      "👨🏾‍⚖️", "👨🏾‍✈", "👨🏾‍✈️", "👨🏾‍🌾", "👨🏾‍🌾",
      "👨🏾‍🍳", "👨🏾‍🍳", "👨🏾‍🍼", "👨🏾‍🍼", "👨🏾‍🎓", "👨🏾‍🎓",
      "👨🏾‍🎤", "👨🏾‍🎤", "👨🏾‍🎨", "👨🏾‍🎨", "👨🏾‍🏫", "👨🏾‍🏫",
      "👨🏾‍🏭", "👨🏾‍🏭", "👨🏾‍💻", "👨🏾‍💻", "👨🏾‍💼", "👨🏾‍💼",
      "👨🏾‍🔧", "👨🏾‍🔧", "👨🏾‍🔬", "👨🏾‍🔬", "👨🏾‍🚀", "👨🏾‍🚀",
      "👨🏾‍🚒", "👨🏾‍🚒", "👨🏾‍🦯", "👨🏾‍🦯", "👨🏾‍🦼", "👨🏾‍🦼",
      "👨🏾‍🦽", "👨🏾‍🦽", "👨🏿‍⚕", "👨🏿‍⚕️", "👨🏿‍⚖",
      "👨🏿‍⚖️", "👨🏿‍✈", "👨🏿‍✈️", "👨🏿‍🌾", "👨🏿‍🌾",
      "👨🏿‍🍳", "👨🏿‍🍳", "👨🏿‍🍼", "👨🏿‍🍼", "👨🏿‍🎓", "👨🏿‍🎓",
      "👨🏿‍🎤", "👨🏿‍🎤", "👨🏿‍🎨", "👨🏿‍🎨", "👨🏿‍🏫", "👨🏿‍🏫",
      "👨🏿‍🏭", "👨🏿‍🏭", "👨🏿‍💻", "👨🏿‍💻", "👨🏿‍💼", "👨🏿‍💼",
      "👨🏿‍🔧", "👨🏿‍🔧", "👨🏿‍🔬", "👨🏿‍🔬", "👨🏿‍🚀", "👨🏿‍🚀",
      "👨🏿‍🚒", "👨🏿‍🚒", "👨🏿‍🦯", "👨🏿‍🦯", "👨🏿‍🦼", "👨🏿‍🦼",
      "👨🏿‍🦽", "👨🏿‍🦽", "👩‍⚕", "👩‍⚕️", "👩‍⚖", "👩‍⚖️", "👩‍✈",
      "👩‍✈️", "👩‍🌾", "👩‍🌾", "👩‍🍳", "👩‍🍳", "👩‍🍼", "👩‍🍼",
      "👩‍🎓", "👩‍🎓", "👩‍🎤", "👩‍🎤", "👩‍🎨", "👩‍🎨", "👩‍🏫",
      "👩‍🏫", "👩‍🏭", "👩‍🏭", "👩‍💻", "👩‍💻", "👩‍💼", "👩‍💼",
      "👩‍🔧", "👩‍🔧", "👩‍🔬", "👩‍🔬", "👩‍🚀", "👩‍🚀", "👩‍🚒",
      "👩‍🚒", "👩‍🦯", "👩‍🦯", "👩‍🦼", "👩‍🦼", "👩‍🦽", "👩‍🦽",
      "👩🏻‍⚕", "👩🏻‍⚕️", "👩🏻‍⚖", "👩🏻‍⚖️", "👩🏻‍✈",
      "👩🏻‍✈️", "👩🏻‍🌾", "👩🏻‍🌾", "👩🏻‍🍳", "👩🏻‍🍳",
      "👩🏻‍🍼", "👩🏻‍🍼", "👩🏻‍🎓", "👩🏻‍🎓", "👩🏻‍🎤", "👩🏻‍🎤",
      "👩🏻‍🎨", "👩🏻‍🎨", "👩🏻‍🏫", "👩🏻‍🏫", "👩🏻‍🏭", "👩🏻‍🏭",
      "👩🏻‍💻", "👩🏻‍💻", "👩🏻‍💼", "👩🏻‍💼", "👩🏻‍🔧", "👩🏻‍🔧",
      "👩🏻‍🔬", "👩🏻‍🔬", "👩🏻‍🚀", "👩🏻‍🚀", "👩🏻‍🚒", "👩🏻‍🚒",
      "👩🏻‍🦯", "👩🏻‍🦯", "👩🏻‍🦼", "👩🏻‍🦼", "👩🏻‍🦽", "👩🏻‍🦽",
      "👩🏼‍⚕", "👩🏼‍⚕️", "👩🏼‍⚖", "👩🏼‍⚖️", "👩🏼‍✈",
      "👩🏼‍✈️", "👩🏼‍🌾", "👩🏼‍🌾", "👩🏼‍🍳", "👩🏼‍🍳",
      "👩🏼‍🍼", "👩🏼‍🍼", "👩🏼‍🎓", "👩🏼‍🎓", "👩🏼‍🎤", "👩🏼‍🎤",
      "👩🏼‍🎨", "👩🏼‍🎨", "👩🏼‍🏫", "👩🏼‍🏫", "👩🏼‍🏭", "👩🏼‍🏭",
      "👩🏼‍💻", "👩🏼‍💻", "👩🏼‍💼", "👩🏼‍💼", "👩🏼‍🔧", "👩🏼‍🔧",
      "👩🏼‍🔬", "👩🏼‍🔬", "👩🏼‍🚀", "👩🏼‍🚀", "👩🏼‍🚒", "👩🏼‍🚒",
      "👩🏼‍🦯", "👩🏼‍🦯", "👩🏼‍🦼", "👩🏼‍🦼", "👩🏼‍🦽", "👩🏼‍🦽",
      "👩🏽‍⚕", "👩🏽‍⚕️", "👩🏽‍⚖", "👩🏽‍⚖️", "👩🏽‍✈",
      "👩🏽‍✈️", "👩🏽‍🌾", "👩🏽‍🌾", "👩🏽‍🍳", "👩🏽‍🍳",
      "👩🏽‍🍼", "👩🏽‍🍼", "👩🏽‍🎓", "👩🏽‍🎓", "👩🏽‍🎤", "👩🏽‍🎤",
      "👩🏽‍🎨", "👩🏽‍🎨", "👩🏽‍🏫", "👩🏽‍🏫", "👩🏽‍🏭", "👩🏽‍🏭",
      "👩🏽‍💻", "👩🏽‍💻", "👩🏽‍💼", "👩🏽‍💼", "👩🏽‍🔧", "👩🏽‍🔧",
      "👩🏽‍🔬", "👩🏽‍🔬", "👩🏽‍🚀", "👩🏽‍🚀", "👩🏽‍🚒", "👩🏽‍🚒",
      "👩🏽‍🦯", "👩🏽‍🦯", "👩🏽‍🦼", "👩🏽‍🦼", "👩🏽‍🦽", "👩🏽‍🦽",
      "👩🏾‍⚕", "👩🏾‍⚕️", "👩🏾‍⚖", "👩🏾‍⚖️", "👩🏾‍✈",
      "👩🏾‍✈️", "👩🏾‍🌾", "👩🏾‍🌾", "👩🏾‍🍳", "👩🏾‍🍳",
      "👩🏾‍🍼", "👩🏾‍🍼", "👩🏾‍🎓", "👩🏾‍🎓", "👩🏾‍🎤", "👩🏾‍🎤",
      "👩🏾‍🎨", "👩🏾‍🎨", "👩🏾‍🏫", "👩🏾‍🏫", "👩🏾‍🏭", "👩🏾‍🏭",
      "👩🏾‍💻", "👩🏾‍💻", "👩🏾‍💼", "👩🏾‍💼", "👩🏾‍🔧", "👩🏾‍🔧",
      "👩🏾‍🔬", "👩🏾‍🔬", "👩🏾‍🚀", "👩🏾‍🚀", "👩🏾‍🚒", "👩🏾‍🚒",
      "👩🏾‍🦯", "👩🏾‍🦯", "👩🏾‍🦼", "👩🏾‍🦼", "👩🏾‍🦽", "👩🏾‍🦽",
      "👩🏿‍⚕", "👩🏿‍⚕️", "👩🏿‍⚖", "👩🏿‍⚖️", "👩🏿‍✈",
      "👩🏿‍✈️", "👩🏿‍🌾", "👩🏿‍🌾", "👩🏿‍🍳", "👩🏿‍🍳",
      "👩🏿‍🍼", "👩🏿‍🍼", "👩🏿‍🎓", "👩🏿‍🎓", "👩🏿‍🎤", "👩🏿‍🎤",
      "👩🏿‍🎨", "👩🏿‍🎨", "👩🏿‍🏫", "👩🏿‍🏫", "👩🏿‍🏭", "👩🏿‍🏭",
      "👩🏿‍💻", "👩🏿‍💻", "👩🏿‍💼", "👩🏿‍💼", "👩🏿‍🔧", "👩🏿‍🔧",
      "👩🏿‍🔬", "👩🏿‍🔬", "👩🏿‍🚀", "👩🏿‍🚀", "👩🏿‍🚒", "👩🏿‍🚒",
      "👩🏿‍🦯", "👩🏿‍🦯", "👩🏿‍🦼", "👩🏿‍🦼", "👩🏿‍🦽", "👩🏿‍🦽",
      "🧑‍⚕", "🧑‍⚕️", "🧑‍⚖", "🧑‍⚖️", "🧑‍✈", "🧑‍✈️", "🧑‍🌾",
      "🧑‍🌾", "🧑‍🍳", "🧑‍🍳", "🧑‍🍼", "🧑‍🍼", "🧑‍🎓", "🧑‍🎓",
      "🧑‍🎤", "🧑‍🎤", "🧑‍🎨", "🧑‍🎨", "🧑‍🏫", "🧑‍🏫", "🧑‍🏭",
      "🧑‍🏭", "🧑‍💻", "🧑‍💻", "🧑‍💼", "🧑‍💼", "🧑‍🔧", "🧑‍🔧",
      "🧑‍🔬", "🧑‍🔬", "🧑‍🚀", "🧑‍🚀", "🧑‍🚒", "🧑‍🚒", "🧑‍🦯",
      "🧑‍🦯", "🧑‍🦼", "🧑‍🦼", "🧑‍🦽", "🧑‍🦽", "🧑🏻‍⚕", "🧑🏻‍⚕️",
      "🧑🏻‍⚖", "🧑🏻‍⚖️", "🧑🏻‍✈", "🧑🏻‍✈️", "🧑🏻‍🌾",
      "🧑🏻‍🌾", "🧑🏻‍🍳", "🧑🏻‍🍳", "🧑🏻‍🍼", "🧑🏻‍🍼", "🧑🏻‍🎓",
      "🧑🏻‍🎓", "🧑🏻‍🎤", "🧑🏻‍🎤", "🧑🏻‍🎨", "🧑🏻‍🎨", "🧑🏻‍🏫",
      "🧑🏻‍🏫", "🧑🏻‍🏭", "🧑🏻‍🏭", "🧑🏻‍💻", "🧑🏻‍💻", "🧑🏻‍💼",
      "🧑🏻‍💼", "🧑🏻‍🔧", "🧑🏻‍🔧", "🧑🏻‍🔬", "🧑🏻‍🔬", "🧑🏻‍🚀",
      "🧑🏻‍🚀", "🧑🏻‍🚒", "🧑🏻‍🚒", "🧑🏻‍🦯", "🧑🏻‍🦯", "🧑🏻‍🦼",
      "🧑🏻‍🦼", "🧑🏻‍🦽", "🧑🏻‍🦽", "🧑🏼‍⚕", "🧑🏼‍⚕️", "🧑🏼‍⚖",
      "🧑🏼‍⚖️", "🧑🏼‍✈", "🧑🏼‍✈️", "🧑🏼‍🌾", "🧑🏼‍🌾",
      "🧑🏼‍🍳", "🧑🏼‍🍳", "🧑🏼‍🍼", "🧑🏼‍🍼", "🧑🏼‍🎓", "🧑🏼‍🎓",
      "🧑🏼‍🎤", "🧑🏼‍🎤", "🧑🏼‍🎨", "🧑🏼‍🎨", "🧑🏼‍🏫", "🧑🏼‍🏫",
      "🧑🏼‍🏭", "🧑🏼‍🏭", "🧑🏼‍💻", "🧑🏼‍💻", "🧑🏼‍💼", "🧑🏼‍💼",
      "🧑🏼‍🔧", "🧑🏼‍🔧", "🧑🏼‍🔬", "🧑🏼‍🔬", "🧑🏼‍🚀", "🧑🏼‍🚀",
      "🧑🏼‍🚒", "🧑🏼‍🚒", "🧑🏼‍🦯", "🧑🏼‍🦯", "🧑🏼‍🦼", "🧑🏼‍🦼",
      "🧑🏼‍🦽", "🧑🏼‍🦽", "🧑🏽‍⚕", "🧑🏽‍⚕️", "🧑🏽‍⚖",
      "🧑🏽‍⚖️", "🧑🏽‍✈", "🧑🏽‍✈️", "🧑🏽‍🌾", "🧑🏽‍🌾",
      "🧑🏽‍🍳", "🧑🏽‍🍳", "🧑🏽‍🍼", "🧑🏽‍🍼", "🧑🏽‍🎓", "🧑🏽‍🎓",
      "🧑🏽‍🎤", "🧑🏽‍🎤", "🧑🏽‍🎨", "🧑🏽‍🎨", "🧑🏽‍🏫", "🧑🏽‍🏫",
      "🧑🏽‍🏭", "🧑🏽‍🏭", "🧑🏽‍💻", "🧑🏽‍💻", "🧑🏽‍💼", "🧑🏽‍💼",
      "🧑🏽‍🔧", "🧑🏽‍🔧", "🧑🏽‍🔬", "🧑🏽‍🔬", "🧑🏽‍🚀", "🧑🏽‍🚀",
      "🧑🏽‍🚒", "🧑🏽‍🚒", "🧑🏽‍🦯", "🧑🏽‍🦯", "🧑🏽‍🦼", "🧑🏽‍🦼",
      "🧑🏽‍🦽", "🧑🏽‍🦽", "🧑🏾‍⚕", "🧑🏾‍⚕️", "🧑🏾‍⚖",
      "🧑🏾‍⚖️", "🧑🏾‍✈", "🧑🏾‍✈️", "🧑🏾‍🌾", "🧑🏾‍🌾",
      "🧑🏾‍🍳", "🧑🏾‍🍳", "🧑🏾‍🍼", "🧑🏾‍🍼", "🧑🏾‍🎓", "🧑🏾‍🎓",
      "🧑🏾‍🎤", "🧑🏾‍🎤", "🧑🏾‍🎨", "🧑🏾‍🎨", "🧑🏾‍🏫", "🧑🏾‍🏫",
      "🧑🏾‍🏭", "🧑🏾‍🏭", "🧑🏾‍💻", "🧑🏾‍💻", "🧑🏾‍💼", "🧑🏾‍💼",
      "🧑🏾‍🔧", "🧑🏾‍🔧", "🧑🏾‍🔬", "🧑🏾‍🔬", "🧑🏾‍🚀", "🧑🏾‍🚀",
      "🧑🏾‍🚒", "🧑🏾‍🚒", "🧑🏾‍🦯", "🧑🏾‍🦯", "🧑🏾‍🦼", "🧑🏾‍🦼",
      "🧑🏾‍🦽", "🧑🏾‍🦽", "🧑🏿‍⚕", "🧑🏿‍⚕️", "🧑🏿‍⚖",
      "🧑🏿‍⚖️", "🧑🏿‍✈", "🧑🏿‍✈️", "🧑🏿‍🌾", "🧑🏿‍🌾",
      "🧑🏿‍🍳", "🧑🏿‍🍳", "🧑🏿‍🍼", "🧑🏿‍🍼", "🧑🏿‍🎓", "🧑🏿‍🎓",
      "🧑🏿‍🎤", "🧑🏿‍🎤", "🧑🏿‍🎨", "🧑🏿‍🎨", "🧑🏿‍🏫", "🧑🏿‍🏫",
      "🧑🏿‍🏭", "🧑🏿‍🏭", "🧑🏿‍💻", "🧑🏿‍💻", "🧑🏿‍💼", "🧑🏿‍💼",
      "🧑🏿‍🔧", "🧑🏿‍🔧", "🧑🏿‍🔬", "🧑🏿‍🔬", "🧑🏿‍🚀", "🧑🏿‍🚀",
      "🧑🏿‍🚒", "🧑🏿‍🚒", "🧑🏿‍🦯", "🧑🏿‍🦯", "🧑🏿‍🦼", "🧑🏿‍🦼",
      "🧑🏿‍🦽", "🧑🏿‍🦽", "⛹🏻‍♀", "⛹🏻‍♀️", "⛹🏻‍♂", "⛹🏻‍♂️",
      "⛹🏼‍♀", "⛹🏼‍♀️", "⛹🏼‍♂", "⛹🏼‍♂️", "⛹🏽‍♀", "⛹🏽‍♀️",
      "⛹🏽‍♂", "⛹🏽‍♂️", "⛹🏾‍♀", "⛹🏾‍♀️", "⛹🏾‍♂", "⛹🏾‍♂️",
      "⛹🏿‍♀", "⛹🏿‍♀️", "⛹🏿‍♂", "⛹🏿‍♂️", "⛹‍♀", "⛹️‍♀️",
      "⛹‍♂", "⛹️‍♂️", "🏃‍♀", "🏃‍♀️", "🏃‍♂", "🏃‍♂️", "🏃🏻‍♀",
      "🏃🏻‍♀️", "🏃🏻‍♂", "🏃🏻‍♂️", "🏃🏼‍♀", "🏃🏼‍♀️",
      "🏃🏼‍♂", "🏃🏼‍♂️", "🏃🏽‍♀", "🏃🏽‍♀️", "🏃🏽‍♂",
      "🏃🏽‍♂️", "🏃🏾‍♀", "🏃🏾‍♀️", "🏃🏾‍♂", "🏃🏾‍♂️",
      "🏃🏿‍♀", "🏃🏿‍♀️", "🏃🏿‍♂", "🏃🏿‍♂️", "🏄‍♀", "🏄‍♀️",
      "🏄‍♂", "🏄‍♂️", "🏄🏻‍♀", "🏄🏻‍♀️", "🏄🏻‍♂", "🏄🏻‍♂️",
      "🏄🏼‍♀", "🏄🏼‍♀️", "🏄🏼‍♂", "🏄🏼‍♂️", "🏄🏽‍♀",
      "🏄🏽‍♀️", "🏄🏽‍♂", "🏄🏽‍♂️", "🏄🏾‍♀", "🏄🏾‍♀️",
      "🏄🏾‍♂", "🏄🏾‍♂️", "🏄🏿‍♀", "🏄🏿‍♀️", "🏄🏿‍♂",
      "🏄🏿‍♂️", "🏊‍♀", "🏊‍♀️", "🏊‍♂", "🏊‍♂️", "🏊🏻‍♀",
      "🏊🏻‍♀️", "🏊🏻‍♂", "🏊🏻‍♂️", "🏊🏼‍♀", "🏊🏼‍♀️",
      "🏊🏼‍♂", "🏊🏼‍♂️", "🏊🏽‍♀", "🏊🏽‍♀️", "🏊🏽‍♂",
      "🏊🏽‍♂️", "🏊🏾‍♀", "🏊🏾‍♀️", "🏊🏾‍♂", "🏊🏾‍♂️",
      "🏊🏿‍♀", "🏊🏿‍♀️", "🏊🏿‍♂", "🏊🏿‍♂️", "🏋🏻‍♀",
      "🏋🏻‍♀️", "🏋🏻‍♂", "🏋🏻‍♂️", "🏋🏼‍♀", "🏋🏼‍♀️",
      "🏋🏼‍♂", "🏋🏼‍♂️", "🏋🏽‍♀", "🏋🏽‍♀️", "🏋🏽‍♂",
      "🏋🏽‍♂️", "🏋🏾‍♀", "🏋🏾‍♀️", "🏋🏾‍♂", "🏋🏾‍♂️",
      "🏋🏿‍♀", "🏋🏿‍♀️", "🏋🏿‍♂", "🏋🏿‍♂️", "🏋‍♀", "🏋️‍♀️",
      "🏋‍♂", "🏋️‍♂️", "🏌🏻‍♀", "🏌🏻‍♀️", "🏌🏻‍♂", "🏌🏻‍♂️",
      "🏌🏼‍♀", "🏌🏼‍♀️", "🏌🏼‍♂", "🏌🏼‍♂️", "🏌🏽‍♀",
      "🏌🏽‍♀️", "🏌🏽‍♂", "🏌🏽‍♂️", "🏌🏾‍♀", "🏌🏾‍♀️",
      "🏌🏾‍♂", "🏌🏾‍♂️", "🏌🏿‍♀", "🏌🏿‍♀️", "🏌🏿‍♂",
      "🏌🏿‍♂️", "🏌‍♀", "🏌️‍♀️", "🏌‍♂", "🏌️‍♂️", "👮‍♀",
      "👮‍♀️", "👮‍♂", "👮‍♂️", "👮🏻‍♀", "👮🏻‍♀️", "👮🏻‍♂",
      "👮🏻‍♂️", "👮🏼‍♀", "👮🏼‍♀️", "👮🏼‍♂", "👮🏼‍♂️",
      "👮🏽‍♀", "👮🏽‍♀️", "👮🏽‍♂", "👮🏽‍♂️", "👮🏾‍♀",
      "👮🏾‍♀️", "👮🏾‍♂", "👮🏾‍♂️", "👮🏿‍♀", "👮🏿‍♀️",
      "👮🏿‍♂", "👮🏿‍♂️", "👯‍♀", "👯‍♀️", "👯‍♂", "👯‍♂️", "👰‍♀",
      "👰‍♀️", "👰‍♂", "👰‍♂️", "👰🏻‍♀", "👰🏻‍♀️", "👰🏻‍♂",
      "👰🏻‍♂️", "👰🏼‍♀", "👰🏼‍♀️", "👰🏼‍♂", "👰🏼‍♂️",
      "👰🏽‍♀", "👰🏽‍♀️", "👰🏽‍♂", "👰🏽‍♂️", "👰🏾‍♀",
      "👰🏾‍♀️", "👰🏾‍♂", "👰🏾‍♂️", "👰🏿‍♀", "👰🏿‍♀️",
      "👰🏿‍♂", "👰🏿‍♂️", "👱‍♀", "👱‍♀️", "👱‍♂", "👱‍♂️",
      "👱🏻‍♀", "👱🏻‍♀️", "👱🏻‍♂", "👱🏻‍♂️", "👱🏼‍♀",
      "👱🏼‍♀️", "👱🏼‍♂", "👱🏼‍♂️", "👱🏽‍♀", "👱🏽‍♀️",
      "👱🏽‍♂", "👱🏽‍♂️", "👱🏾‍♀", "👱🏾‍♀️", "👱🏾‍♂",
      "👱🏾‍♂️", "👱🏿‍♀", "👱🏿‍♀️", "👱🏿‍♂", "👱🏿‍♂️", "👳‍♀",
      "👳‍♀️", "👳‍♂", "👳‍♂️", "👳🏻‍♀", "👳🏻‍♀️", "👳🏻‍♂",
      "👳🏻‍♂️", "👳🏼‍♀", "👳🏼‍♀️", "👳🏼‍♂", "👳🏼‍♂️",
      "👳🏽‍♀", "👳🏽‍♀️", "👳🏽‍♂", "👳🏽‍♂️", "👳🏾‍♀",
      "👳🏾‍♀️", "👳🏾‍♂", "👳🏾‍♂️", "👳🏿‍♀", "👳🏿‍♀️",
      "👳🏿‍♂", "👳🏿‍♂️", "👷‍♀", "👷‍♀️", "👷‍♂", "👷‍♂️",
      "👷🏻‍♀", "👷🏻‍♀️", "👷🏻‍♂", "👷🏻‍♂️", "👷🏼‍♀",
      "👷🏼‍♀️", "👷🏼‍♂", "👷🏼‍♂️", "👷🏽‍♀", "👷🏽‍♀️",
      "👷🏽‍♂", "👷🏽‍♂️", "👷🏾‍♀", "👷🏾‍♀️", "👷🏾‍♂",
      "👷🏾‍♂️", "👷🏿‍♀", "👷🏿‍♀️", "👷🏿‍♂", "👷🏿‍♂️", "💁‍♀",
      "💁‍♀️", "💁‍♂", "💁‍♂️", "💁🏻‍♀", "💁🏻‍♀️", "💁🏻‍♂",
      "💁🏻‍♂️", "💁🏼‍♀", "💁🏼‍♀️", "💁🏼‍♂", "💁🏼‍♂️",
      "💁🏽‍♀", "💁🏽‍♀️", "💁🏽‍♂", "💁🏽‍♂️", "💁🏾‍♀",
      "💁🏾‍♀️", "💁🏾‍♂", "💁🏾‍♂️", "💁🏿‍♀", "💁🏿‍♀️",
      "💁🏿‍♂", "💁🏿‍♂️", "💂‍♀", "💂‍♀️", "💂‍♂", "💂‍♂️",
      "💂🏻‍♀", "💂🏻‍♀️", "💂🏻‍♂", "💂🏻‍♂️", "💂🏼‍♀",
      "💂🏼‍♀️", "💂🏼‍♂", "💂🏼‍♂️", "💂🏽‍♀", "💂🏽‍♀️",
      "💂🏽‍♂", "💂🏽‍♂️", "💂🏾‍♀", "💂🏾‍♀️", "💂🏾‍♂",
      "💂🏾‍♂️", "💂🏿‍♀", "💂🏿‍♀️", "💂🏿‍♂", "💂🏿‍♂️", "💆‍♀",
      "💆‍♀️", "💆‍♂", "💆‍♂️", "💆🏻‍♀", "💆🏻‍♀️", "💆🏻‍♂",
      "💆🏻‍♂️", "💆🏼‍♀", "💆🏼‍♀️", "💆🏼‍♂", "💆🏼‍♂️",
      "💆🏽‍♀", "💆🏽‍♀️", "💆🏽‍♂", "💆🏽‍♂️", "💆🏾‍♀",
      "💆🏾‍♀️", "💆🏾‍♂", "💆🏾‍♂️", "💆🏿‍♀", "💆🏿‍♀️",
      "💆🏿‍♂", "💆🏿‍♂️", "💇‍♀", "💇‍♀️", "💇‍♂", "💇‍♂️",
      "💇🏻‍♀", "💇🏻‍♀️", "💇🏻‍♂", "💇🏻‍♂️", "💇🏼‍♀",
      "💇🏼‍♀️", "💇🏼‍♂", "💇🏼‍♂️", "💇🏽‍♀", "💇🏽‍♀️",
      "💇🏽‍♂", "💇🏽‍♂️", "💇🏾‍♀", "💇🏾‍♀️", "💇🏾‍♂",
      "💇🏾‍♂️", "💇🏿‍♀", "💇🏿‍♀️", "💇🏿‍♂", "💇🏿‍♂️",
      "🕵🏻‍♀", "🕵🏻‍♀️", "🕵🏻‍♂", "🕵🏻‍♂️", "🕵🏼‍♀",
      "🕵🏼‍♀️", "🕵🏼‍♂", "🕵🏼‍♂️", "🕵🏽‍♀", "🕵🏽‍♀️",
      "🕵🏽‍♂", "🕵🏽‍♂️", "🕵🏾‍♀", "🕵🏾‍♀️", "🕵🏾‍♂",
      "🕵🏾‍♂️", "🕵🏿‍♀", "🕵🏿‍♀️", "🕵🏿‍♂", "🕵🏿‍♂️", "🕵‍♀",
      "🕵️‍♀️", "🕵‍♂", "🕵️‍♂️", "🙅‍♀", "🙅‍♀️", "🙅‍♂",
      "🙅‍♂️", "🙅🏻‍♀", "🙅🏻‍♀️", "🙅🏻‍♂", "🙅🏻‍♂️", "🙅🏼‍♀",
      "🙅🏼‍♀️", "🙅🏼‍♂", "🙅🏼‍♂️", "🙅🏽‍♀", "🙅🏽‍♀️",
      "🙅🏽‍♂", "🙅🏽‍♂️", "🙅🏾‍♀", "🙅🏾‍♀️", "🙅🏾‍♂",
      "🙅🏾‍♂️", "🙅🏿‍♀", "🙅🏿‍♀️", "🙅🏿‍♂", "🙅🏿‍♂️", "🙆‍♀",
      "🙆‍♀️", "🙆‍♂", "🙆‍♂️", "🙆🏻‍♀", "🙆🏻‍♀️", "🙆🏻‍♂",
      "🙆🏻‍♂️", "🙆🏼‍♀", "🙆🏼‍♀️", "🙆🏼‍♂", "🙆🏼‍♂️",
      "🙆🏽‍♀", "🙆🏽‍♀️", "🙆🏽‍♂", "🙆🏽‍♂️", "🙆🏾‍♀",
      "🙆🏾‍♀️", "🙆🏾‍♂", "🙆🏾‍♂️", "🙆🏿‍♀", "🙆🏿‍♀️",
      "🙆🏿‍♂", "🙆🏿‍♂️", "🙇‍♀", "🙇‍♀️", "🙇‍♂", "🙇‍♂️",
      "🙇🏻‍♀", "🙇🏻‍♀️", "🙇🏻‍♂", "🙇🏻‍♂️", "🙇🏼‍♀",
      "🙇🏼‍♀️", "🙇🏼‍♂", "🙇🏼‍♂️", "🙇🏽‍♀", "🙇🏽‍♀️",
      "🙇🏽‍♂", "🙇🏽‍♂️", "🙇🏾‍♀", "🙇🏾‍♀️", "🙇🏾‍♂",
      "🙇🏾‍♂️", "🙇🏿‍♀", "🙇🏿‍♀️", "🙇🏿‍♂", "🙇🏿‍♂️", "🙋‍♀",
      "🙋‍♀️", "🙋‍♂", "🙋‍♂️", "🙋🏻‍♀", "🙋🏻‍♀️", "🙋🏻‍♂",
      "🙋🏻‍♂️", "🙋🏼‍♀", "🙋🏼‍♀️", "🙋🏼‍♂", "🙋🏼‍♂️",
      "🙋🏽‍♀", "🙋🏽‍♀️", "🙋🏽‍♂", "🙋🏽‍♂️", "🙋🏾‍♀",
      "🙋🏾‍♀️", "🙋🏾‍♂", "🙋🏾‍♂️", "🙋🏿‍♀", "🙋🏿‍♀️",
      "🙋🏿‍♂", "🙋🏿‍♂️", "🙍‍♀", "🙍‍♀️", "🙍‍♂", "🙍‍♂️",
      "🙍🏻‍♀", "🙍🏻‍♀️", "🙍🏻‍♂", "🙍🏻‍♂️", "🙍🏼‍♀",
      "🙍🏼‍♀️", "🙍🏼‍♂", "🙍🏼‍♂️", "🙍🏽‍♀", "🙍🏽‍♀️",
      "🙍🏽‍♂", "🙍🏽‍♂️", "🙍🏾‍♀", "🙍🏾‍♀️", "🙍🏾‍♂",
      "🙍🏾‍♂️", "🙍🏿‍♀", "🙍🏿‍♀️", "🙍🏿‍♂", "🙍🏿‍♂️", "🙎‍♀",
      "🙎‍♀️", "🙎‍♂", "🙎‍♂️", "🙎🏻‍♀", "🙎🏻‍♀️", "🙎🏻‍♂",
      "🙎🏻‍♂️", "🙎🏼‍♀", "🙎🏼‍♀️", "🙎🏼‍♂", "🙎🏼‍♂️",
      "🙎🏽‍♀", "🙎🏽‍♀️", "🙎🏽‍♂", "🙎🏽‍♂️", "🙎🏾‍♀",
      "🙎🏾‍♀️", "🙎🏾‍♂", "🙎🏾‍♂️", "🙎🏿‍♀", "🙎🏿‍♀️",
      "🙎🏿‍♂", "🙎🏿‍♂️", "🚣‍♀", "🚣‍♀️", "🚣‍♂", "🚣‍♂️",
      "🚣🏻‍♀", "🚣🏻‍♀️", "🚣🏻‍♂", "🚣🏻‍♂️", "🚣🏼‍♀",
      "🚣🏼‍♀️", "🚣🏼‍♂", "🚣🏼‍♂️", "🚣🏽‍♀", "🚣🏽‍♀️",
      "🚣🏽‍♂", "🚣🏽‍♂️", "🚣🏾‍♀", "🚣🏾‍♀️", "🚣🏾‍♂",
      "🚣🏾‍♂️", "🚣🏿‍♀", "🚣🏿‍♀️", "🚣🏿‍♂", "🚣🏿‍♂️", "🚴‍♀",
      "🚴‍♀️", "🚴‍♂", "🚴‍♂️", "🚴🏻‍♀", "🚴🏻‍♀️", "🚴🏻‍♂",
      "🚴🏻‍♂️", "🚴🏼‍♀", "🚴🏼‍♀️", "🚴🏼‍♂", "🚴🏼‍♂️",
      "🚴🏽‍♀", "🚴🏽‍♀️", "🚴🏽‍♂", "🚴🏽‍♂️", "🚴🏾‍♀",
      "🚴🏾‍♀️", "🚴🏾‍♂", "🚴🏾‍♂️", "🚴🏿‍♀", "🚴🏿‍♀️",
      "🚴🏿‍♂", "🚴🏿‍♂️", "🚵‍♀", "🚵‍♀️", "🚵‍♂", "🚵‍♂️",
      "🚵🏻‍♀", "🚵🏻‍♀️", "🚵🏻‍♂", "🚵🏻‍♂️", "🚵🏼‍♀",
      "🚵🏼‍♀️", "🚵🏼‍♂", "🚵🏼‍♂️", "🚵🏽‍♀", "🚵🏽‍♀️",
      "🚵🏽‍♂", "🚵🏽‍♂️", "🚵🏾‍♀", "🚵🏾‍♀️", "🚵🏾‍♂",
      "🚵🏾‍♂️", "🚵🏿‍♀", "🚵🏿‍♀️", "🚵🏿‍♂", "🚵🏿‍♂️", "🚶‍♀",
      "🚶‍♀️", "🚶‍♂", "🚶‍♂️", "🚶🏻‍♀", "🚶🏻‍♀️", "🚶🏻‍♂",
      "🚶🏻‍♂️", "🚶🏼‍♀", "🚶🏼‍♀️", "🚶🏼‍♂", "🚶🏼‍♂️",
      "🚶🏽‍♀", "🚶🏽‍♀️", "🚶🏽‍♂", "🚶🏽‍♂️", "🚶🏾‍♀",
      "🚶🏾‍♀️", "🚶🏾‍♂", "🚶🏾‍♂️", "🚶🏿‍♀", "🚶🏿‍♀️",
      "🚶🏿‍♂", "🚶🏿‍♂️", "🤦‍♀", "🤦‍♀️", "🤦‍♂", "🤦‍♂️",
      "🤦🏻‍♀", "🤦🏻‍♀️", "🤦🏻‍♂", "🤦🏻‍♂️", "🤦🏼‍♀",
      "🤦🏼‍♀️", "🤦🏼‍♂", "🤦🏼‍♂️", "🤦🏽‍♀", "🤦🏽‍♀️",
      "🤦🏽‍♂", "🤦🏽‍♂️", "🤦🏾‍♀", "🤦🏾‍♀️", "🤦🏾‍♂",
      "🤦🏾‍♂️", "🤦🏿‍♀", "🤦🏿‍♀️", "🤦🏿‍♂", "🤦🏿‍♂️", "🤵‍♀",
      "🤵‍♀️", "🤵‍♂", "🤵‍♂️", "🤵🏻‍♀", "🤵🏻‍♀️", "🤵🏻‍♂",
      "🤵🏻‍♂️", "🤵🏼‍♀", "🤵🏼‍♀️", "🤵🏼‍♂", "🤵🏼‍♂️",
      "🤵🏽‍♀", "🤵🏽‍♀️", "🤵🏽‍♂", "🤵🏽‍♂️", "🤵🏾‍♀",
      "🤵🏾‍♀️", "🤵🏾‍♂", "🤵🏾‍♂️", "🤵🏿‍♀", "🤵🏿‍♀️",
      "🤵🏿‍♂", "🤵🏿‍♂️", "🤷‍♀", "🤷‍♀️", "🤷‍♂", "🤷‍♂️",
      "🤷🏻‍♀", "🤷🏻‍♀️", "🤷🏻‍♂", "🤷🏻‍♂️", "🤷🏼‍♀",
      "🤷🏼‍♀️", "🤷🏼‍♂", "🤷🏼‍♂️", "🤷🏽‍♀", "🤷🏽‍♀️",
      "🤷🏽‍♂", "🤷🏽‍♂️", "🤷🏾‍♀", "🤷🏾‍♀️", "🤷🏾‍♂",
      "🤷🏾‍♂️", "🤷🏿‍♀", "🤷🏿‍♀️", "🤷🏿‍♂", "🤷🏿‍♂️", "🤸‍♀",
      "🤸‍♀️", "🤸‍♂", "🤸‍♂️", "🤸🏻‍♀", "🤸🏻‍♀️", "🤸🏻‍♂",
      "🤸🏻‍♂️", "🤸🏼‍♀", "🤸🏼‍♀️", "🤸🏼‍♂", "🤸🏼‍♂️",
      "🤸🏽‍♀", "🤸🏽‍♀️", "🤸🏽‍♂", "🤸🏽‍♂️", "🤸🏾‍♀",
      "🤸🏾‍♀️", "🤸🏾‍♂", "🤸🏾‍♂️", "🤸🏿‍♀", "🤸🏿‍♀️",
      "🤸🏿‍♂", "🤸🏿‍♂️", "🤹‍♀", "🤹‍♀️", "🤹‍♂", "🤹‍♂️",
      "🤹🏻‍♀", "🤹🏻‍♀️", "🤹🏻‍♂", "🤹🏻‍♂️", "🤹🏼‍♀",
      "🤹🏼‍♀️", "🤹🏼‍♂", "🤹🏼‍♂️", "🤹🏽‍♀", "🤹🏽‍♀️",
      "🤹🏽‍♂", "🤹🏽‍♂️", "🤹🏾‍♀", "🤹🏾‍♀️", "🤹🏾‍♂",
      "🤹🏾‍♂️", "🤹🏿‍♀", "🤹🏿‍♀️", "🤹🏿‍♂", "🤹🏿‍♂️", "🤼‍♀",
      "🤼‍♀️", "🤼‍♂", "🤼‍♂️", "🤽‍♀", "🤽‍♀️", "🤽‍♂", "🤽‍♂️",
      "🤽🏻‍♀", "🤽🏻‍♀️", "🤽🏻‍♂", "🤽🏻‍♂️", "🤽🏼‍♀",
      "🤽🏼‍♀️", "🤽🏼‍♂", "🤽🏼‍♂️", "🤽🏽‍♀", "🤽🏽‍♀️",
      "🤽🏽‍♂", "🤽🏽‍♂️", "🤽🏾‍♀", "🤽🏾‍♀️", "🤽🏾‍♂",
      "🤽🏾‍♂️", "🤽🏿‍♀", "🤽🏿‍♀️", "🤽🏿‍♂", "🤽🏿‍♂️", "🤾‍♀",
      "🤾‍♀️", "🤾‍♂", "🤾‍♂️", "🤾🏻‍♀", "🤾🏻‍♀️", "🤾🏻‍♂",
      "🤾🏻‍♂️", "🤾🏼‍♀", "🤾🏼‍♀️", "🤾🏼‍♂", "🤾🏼‍♂️",
      "🤾🏽‍♀", "🤾🏽‍♀️", "🤾🏽‍♂", "🤾🏽‍♂️", "🤾🏾‍♀",
      "🤾🏾‍♀️", "🤾🏾‍♂", "🤾🏾‍♂️", "🤾🏿‍♀", "🤾🏿‍♀️",
      "🤾🏿‍♂", "🤾🏿‍♂️", "🦸‍♀", "🦸‍♀️", "🦸‍♂", "🦸‍♂️",
      "🦸🏻‍♀", "🦸🏻‍♀️", "🦸🏻‍♂", "🦸🏻‍♂️", "🦸🏼‍♀",
      "🦸🏼‍♀️", "🦸🏼‍♂", "🦸🏼‍♂️", "🦸🏽‍♀", "🦸🏽‍♀️",
      "🦸🏽‍♂", "🦸🏽‍♂️", "🦸🏾‍♀", "🦸🏾‍♀️", "🦸🏾‍♂",
      "🦸🏾‍♂️", "🦸🏿‍♀", "🦸🏿‍♀️", "🦸🏿‍♂", "🦸🏿‍♂️", "🦹‍♀",
      "🦹‍♀️", "🦹‍♂", "🦹‍♂️", "🦹🏻‍♀", "🦹🏻‍♀️", "🦹🏻‍♂",
      "🦹🏻‍♂️", "🦹🏼‍♀", "🦹🏼‍♀️", "🦹🏼‍♂", "🦹🏼‍♂️",
      "🦹🏽‍♀", "🦹🏽‍♀️", "🦹🏽‍♂", "🦹🏽‍♂️", "🦹🏾‍♀",
      "🦹🏾‍♀️", "🦹🏾‍♂", "🦹🏾‍♂️", "🦹🏿‍♀", "🦹🏿‍♀️",
      "🦹🏿‍♂", "🦹🏿‍♂️", "🧍‍♀", "🧍‍♀️", "🧍‍♂", "🧍‍♂️",
      "🧍🏻‍♀", "🧍🏻‍♀️", "🧍🏻‍♂", "🧍🏻‍♂️", "🧍🏼‍♀",
      "🧍🏼‍♀️", "🧍🏼‍♂", "🧍🏼‍♂️", "🧍🏽‍♀", "🧍🏽‍♀️",
      "🧍🏽‍♂", "🧍🏽‍♂️", "🧍🏾‍♀", "🧍🏾‍♀️", "🧍🏾‍♂",
      "🧍🏾‍♂️", "🧍🏿‍♀", "🧍🏿‍♀️", "🧍🏿‍♂", "🧍🏿‍♂️", "🧎‍♀",
      "🧎‍♀️", "🧎‍♂", "🧎‍♂️", "🧎🏻‍♀", "🧎🏻‍♀️", "🧎🏻‍♂",
      "🧎🏻‍♂️", "🧎🏼‍♀", "🧎🏼‍♀️", "🧎🏼‍♂", "🧎🏼‍♂️",
      "🧎🏽‍♀", "🧎🏽‍♀️", "🧎🏽‍♂", "🧎🏽‍♂️", "🧎🏾‍♀",
      "🧎🏾‍♀️", "🧎🏾‍♂", "🧎🏾‍♂️", "🧎🏿‍♀", "🧎🏿‍♀️",
      "🧎🏿‍♂", "🧎🏿‍♂️", "🧏‍♀", "🧏‍♀️", "🧏‍♂", "🧏‍♂️",
      "🧏🏻‍♀", "🧏🏻‍♀️", "🧏🏻‍♂", "🧏🏻‍♂️", "🧏🏼‍♀",
      "🧏🏼‍♀️", "🧏🏼‍♂", "🧏🏼‍♂️", "🧏🏽‍♀", "🧏🏽‍♀️",
      "🧏🏽‍♂", "🧏🏽‍♂️", "🧏🏾‍♀", "🧏🏾‍♀️", "🧏🏾‍♂",
      "🧏🏾‍♂️", "🧏🏿‍♀", "🧏🏿‍♀️", "🧏🏿‍♂", "🧏🏿‍♂️", "🧔‍♀",
      "🧔‍♀️", "🧔‍♂", "🧔‍♂️", "🧔🏻‍♀", "🧔🏻‍♀️", "🧔🏻‍♂",
      "🧔🏻‍♂️", "🧔🏼‍♀", "🧔🏼‍♀️", "🧔🏼‍♂", "🧔🏼‍♂️",
      "🧔🏽‍♀", "🧔🏽‍♀️", "🧔🏽‍♂", "🧔🏽‍♂️", "🧔🏾‍♀",
      "🧔🏾‍♀️", "🧔🏾‍♂", "🧔🏾‍♂️", "🧔🏿‍♀", "🧔🏿‍♀️",
      "🧔🏿‍♂", "🧔🏿‍♂️", "🧖‍♀", "🧖‍♀️", "🧖‍♂", "🧖‍♂️",
      "🧖🏻‍♀", "🧖🏻‍♀️", "🧖🏻‍♂", "🧖🏻‍♂️", "🧖🏼‍♀",
      "🧖🏼‍♀️", "🧖🏼‍♂", "🧖🏼‍♂️", "🧖🏽‍♀", "🧖🏽‍♀️",
      "🧖🏽‍♂", "🧖🏽‍♂️", "🧖🏾‍♀", "🧖🏾‍♀️", "🧖🏾‍♂",
      "🧖🏾‍♂️", "🧖🏿‍♀", "🧖🏿‍♀️", "🧖🏿‍♂", "🧖🏿‍♂️", "🧗‍♀",
      "🧗‍♀️", "🧗‍♂", "🧗‍♂️", "🧗🏻‍♀", "🧗🏻‍♀️", "🧗🏻‍♂",
      "🧗🏻‍♂️", "🧗🏼‍♀", "🧗🏼‍♀️", "🧗🏼‍♂", "🧗🏼‍♂️",
      "🧗🏽‍♀", "🧗🏽‍♀️", "🧗🏽‍♂", "🧗🏽‍♂️", "🧗🏾‍♀",
      "🧗🏾‍♀️", "🧗🏾‍♂", "🧗🏾‍♂️", "🧗🏿‍♀", "🧗🏿‍♀️",
      "🧗🏿‍♂", "🧗🏿‍♂️", "🧘‍♀", "🧘‍♀️", "🧘‍♂", "🧘‍♂️",
      "🧘🏻‍♀", "🧘🏻‍♀️", "🧘🏻‍♂", "🧘🏻‍♂️", "🧘🏼‍♀",
      "🧘🏼‍♀️", "🧘🏼‍♂", "🧘🏼‍♂️", "🧘🏽‍♀", "🧘🏽‍♀️",
      "🧘🏽‍♂", "🧘🏽‍♂️", "🧘🏾‍♀", "🧘🏾‍♀️", "🧘🏾‍♂",
      "🧘🏾‍♂️", "🧘🏿‍♀", "🧘🏿‍♀️", "🧘🏿‍♂", "🧘🏿‍♂️", "🧙‍♀",
      "🧙‍♀️", "🧙‍♂", "🧙‍♂️", "🧙🏻‍♀", "🧙🏻‍♀️", "🧙🏻‍♂",
      "🧙🏻‍♂️", "🧙🏼‍♀", "🧙🏼‍♀️", "🧙🏼‍♂", "🧙🏼‍♂️",
      "🧙🏽‍♀", "🧙🏽‍♀️", "🧙🏽‍♂", "🧙🏽‍♂️", "🧙🏾‍♀",
      "🧙🏾‍♀️", "🧙🏾‍♂", "🧙🏾‍♂️", "🧙🏿‍♀", "🧙🏿‍♀️",
      "🧙🏿‍♂", "🧙🏿‍♂️", "🧚‍♀", "🧚‍♀️", "🧚‍♂", "🧚‍♂️",
      "🧚🏻‍♀", "🧚🏻‍♀️", "🧚🏻‍♂", "🧚🏻‍♂️", "🧚🏼‍♀",
      "🧚🏼‍♀️", "🧚🏼‍♂", "🧚🏼‍♂️", "🧚🏽‍♀", "🧚🏽‍♀️",
      "🧚🏽‍♂", "🧚🏽‍♂️", "🧚🏾‍♀", "🧚🏾‍♀️", "🧚🏾‍♂",
      "🧚🏾‍♂️", "🧚🏿‍♀", "🧚🏿‍♀️", "🧚🏿‍♂", "🧚🏿‍♂️", "🧛‍♀",
      "🧛‍♀️", "🧛‍♂", "🧛‍♂️", "🧛🏻‍♀", "🧛🏻‍♀️", "🧛🏻‍♂",
      "🧛🏻‍♂️", "🧛🏼‍♀", "🧛🏼‍♀️", "🧛🏼‍♂", "🧛🏼‍♂️",
      "🧛🏽‍♀", "🧛🏽‍♀️", "🧛🏽‍♂", "🧛🏽‍♂️", "🧛🏾‍♀",
      "🧛🏾‍♀️", "🧛🏾‍♂", "🧛🏾‍♂️", "🧛🏿‍♀", "🧛🏿‍♀️",
      "🧛🏿‍♂", "🧛🏿‍♂️", "🧜‍♀", "🧜‍♀️", "🧜‍♂", "🧜‍♂️",
      "🧜🏻‍♀", "🧜🏻‍♀️", "🧜🏻‍♂", "🧜🏻‍♂️", "🧜🏼‍♀",
      "🧜🏼‍♀️", "🧜🏼‍♂", "🧜🏼‍♂️", "🧜🏽‍♀", "🧜🏽‍♀️",
      "🧜🏽‍♂", "🧜🏽‍♂️", "🧜🏾‍♀", "🧜🏾‍♀️", "🧜🏾‍♂",
      "🧜🏾‍♂️", "🧜🏿‍♀", "🧜🏿‍♀️", "🧜🏿‍♂", "🧜🏿‍♂️", "🧝‍♀",
      "🧝‍♀️", "🧝‍♂", "🧝‍♂️", "🧝🏻‍♀", "🧝🏻‍♀️", "🧝🏻‍♂",
      "🧝🏻‍♂️", "🧝🏼‍♀", "🧝🏼‍♀️", "🧝🏼‍♂", "🧝🏼‍♂️",
      "🧝🏽‍♀", "🧝🏽‍♀️", "🧝🏽‍♂", "🧝🏽‍♂️", "🧝🏾‍♀",
      "🧝🏾‍♀️", "🧝🏾‍♂", "🧝🏾‍♂️", "🧝🏿‍♀", "🧝🏿‍♀️",
      "🧝🏿‍♂", "🧝🏿‍♂️", "🧞‍♀", "🧞‍♀️", "🧞‍♂", "🧞‍♂️", "🧟‍♀",
      "🧟‍♀️", "🧟‍♂", "🧟‍♂️", "👨‍🦰", "👨‍🦰", "👨‍🦱", "👨‍🦱",
      "👨‍🦲", "👨‍🦲", "👨‍🦳", "👨‍🦳", "👨🏻‍🦰", "👨🏻‍🦰",
      "👨🏻‍🦱", "👨🏻‍🦱", "👨🏻‍🦲", "👨🏻‍🦲", "👨🏻‍🦳", "👨🏻‍🦳",
      "👨🏼‍🦰", "👨🏼‍🦰", "👨🏼‍🦱", "👨🏼‍🦱", "👨🏼‍🦲", "👨🏼‍🦲",
      "👨🏼‍🦳", "👨🏼‍🦳", "👨🏽‍🦰", "👨🏽‍🦰", "👨🏽‍🦱", "👨🏽‍🦱",
      "👨🏽‍🦲", "👨🏽‍🦲", "👨🏽‍🦳", "👨🏽‍🦳", "👨🏾‍🦰", "👨🏾‍🦰",
      "👨🏾‍🦱", "👨🏾‍🦱", "👨🏾‍🦲", "👨🏾‍🦲", "👨🏾‍🦳", "👨🏾‍🦳",
      "👨🏿‍🦰", "👨🏿‍🦰", "👨🏿‍🦱", "👨🏿‍🦱", "👨🏿‍🦲", "👨🏿‍🦲",
      "👨🏿‍🦳", "👨🏿‍🦳", "👩‍🦰", "👩‍🦰", "👩‍🦱", "👩‍🦱", "👩‍🦲",
      "👩‍🦲", "👩‍🦳", "👩‍🦳", "👩🏻‍🦰", "👩🏻‍🦰", "👩🏻‍🦱",
      "👩🏻‍🦱", "👩🏻‍🦲", "👩🏻‍🦲", "👩🏻‍🦳", "👩🏻‍🦳", "👩🏼‍🦰",
      "👩🏼‍🦰", "👩🏼‍🦱", "👩🏼‍🦱", "👩🏼‍🦲", "👩🏼‍🦲", "👩🏼‍🦳",
      "👩🏼‍🦳", "👩🏽‍🦰", "👩🏽‍🦰", "👩🏽‍🦱", "👩🏽‍🦱", "👩🏽‍🦲",
      "👩🏽‍🦲", "👩🏽‍🦳", "👩🏽‍🦳", "👩🏾‍🦰", "👩🏾‍🦰", "👩🏾‍🦱",
      "👩🏾‍🦱", "👩🏾‍🦲", "👩🏾‍🦲", "👩🏾‍🦳", "👩🏾‍🦳", "👩🏿‍🦰",
      "👩🏿‍🦰", "👩🏿‍🦱", "👩🏿‍🦱", "👩🏿‍🦲", "👩🏿‍🦲", "👩🏿‍🦳",
      "👩🏿‍🦳", "🧑‍🦰", "🧑‍🦰", "🧑‍🦱", "🧑‍🦱", "🧑‍🦲", "🧑‍🦲",
      "🧑‍🦳", "🧑‍🦳", "🧑🏻‍🦰", "🧑🏻‍🦰", "🧑🏻‍🦱", "🧑🏻‍🦱",
      "🧑🏻‍🦲", "🧑🏻‍🦲", "🧑🏻‍🦳", "🧑🏻‍🦳", "🧑🏼‍🦰", "🧑🏼‍🦰",
      "🧑🏼‍🦱", "🧑🏼‍🦱", "🧑🏼‍🦲", "🧑🏼‍🦲", "🧑🏼‍🦳", "🧑🏼‍🦳",
      "🧑🏽‍🦰", "🧑🏽‍🦰", "🧑🏽‍🦱", "🧑🏽‍🦱", "🧑🏽‍🦲", "🧑🏽‍🦲",
      "🧑🏽‍🦳", "🧑🏽‍🦳", "🧑🏾‍🦰", "🧑🏾‍🦰", "🧑🏾‍🦱", "🧑🏾‍🦱",
      "🧑🏾‍🦲", "🧑🏾‍🦲", "🧑🏾‍🦳", "🧑🏾‍🦳", "🧑🏿‍🦰", "🧑🏿‍🦰",
      "🧑🏿‍🦱", "🧑🏿‍🦱", "🧑🏿‍🦲", "🧑🏿‍🦲", "🧑🏿‍🦳", "🧑🏿‍🦳",
      "❤‍🔥", "❤️‍🔥", "❤‍🩹", "❤️‍🩹", "🏳‍⚧", "🏳️‍⚧️", "🏳‍🌈",
      "🏳️‍🌈", "🏴‍☠", "🏴‍☠️", "🐈‍⬛", "🐈‍⬛", "🐕‍🦺", "🐕‍🦺",
      "🐻‍❄", "🐻‍❄️", "👁‍🗨", "👁️‍🗨️", "😮‍💨", "😮‍💨", "😵‍💫",
      "😵‍💫", "😶‍🌫", "😶‍🌫️", "🧑‍🎄",
      // comment for clang-format
      "🧑‍🎄"};
  if (str.size() >= 40) {
    return false;
  }
  return emojis.count(str) != 0;
}

int get_fitzpatrick_modifier(Slice emoji) {
  if (emoji.size() < 4 || emoji[emoji.size() - 4] != '\xF0' || emoji[emoji.size() - 3] != '\x9F' ||
      emoji[emoji.size() - 2] != '\x8F') {
    return 0;
  }
  auto c = static_cast<unsigned char>(emoji.back());
  if (c < 0xBB || c > 0xBF) {
    return 0;
  }
  return (c - 0xBB) + 2;
}

Slice remove_fitzpatrick_modifier(Slice emoji) {
  while (get_fitzpatrick_modifier(emoji) != 0) {
    emoji.remove_suffix(4);
  }
  return emoji;
}

Slice remove_emoji_modifiers(Slice emoji) {
  static const Slice modifiers[] = {u8"\uFE0E" /* variation selector-15 */,
                                    u8"\uFE0F" /* variation selector-16 */,
                                    u8"\u200D\u2640" /* zero width joiner + female sign */,
                                    u8"\u200D\u2642" /* zero width joiner + male sign */,
                                    u8"\U0001F3FB" /* emoji modifier fitzpatrick type-1-2 */,
                                    u8"\U0001F3FC" /* emoji modifier fitzpatrick type-3 */,
                                    u8"\U0001F3FD" /* emoji modifier fitzpatrick type-4 */,
                                    u8"\U0001F3FE" /* emoji modifier fitzpatrick type-5 */,
                                    u8"\U0001F3FF" /* emoji modifier fitzpatrick type-6 */};
  bool found = true;
  while (found) {
    found = false;
    for (auto &modifier : modifiers) {
      if (ends_with(emoji, modifier) && emoji.size() > modifier.size()) {
        emoji.remove_suffix(modifier.size());
        found = true;
      }
    }
  }
  return emoji;
}

void remove_emoji_modifiers_in_place(string &emoji) {
  emoji.resize(remove_emoji_modifiers(emoji).size());
}

}  // namespace td
