#!/bin/bash
# Use this script to import a new version of wxLua
#
# Provide the path to the root of the wxLua source tree
# (i.e. there should be a "wxLua" directory under it).

set -e

if [ $# -ne 1 ]
then
	echo "Usage: $0 <path-to-wxlua-sources>" 1>&2
	exit 1
fi

SRC="$(pwd)"

git rm -rfq --ignore-unmatch wxLua
rm -rf wxLua

# Copy the bits of wxLua's source tree we need (the full distribution is *huge*).
(cd "$1" && cp -a --parents wxLua/bindings/ wxLua/modules/wxlua/ wxLua/modules/wxbind/ "$SRC")
cp "$1"/wxLua/docs/licence.txt wxLua/

# Pare down the tree a bit - all of this will be regenerated when we run genwxbind.lua anyway.
grep -r "generated by genwxbind.lua" wxLua/ --exclude=genwxbind.lua | cut -d: -f1 | sort | uniq | xargs -r rm

git add wxLua/
