/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfl.h
    Title:      SFL Global Include File
    Package:    Standard Function Library (SFL)

    Synopsis:   This header file is GENERATED by the buildh script.  DO NOT
                MODIFY THIS FILE.  If you change prelude.h, or any of the
                other sfl header files, re-run buildh to recreate this file.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/
/*  ----------------------------------------------------------------<Prolog>-
    Name:       prelude.h
    Title:      Universal Header File for C programming
    Package:    Standard Function Library (SFL)

    Written:    1993/03/29  iMatix SFL project team <sfl@imatix.com>
    Revised:    2000/02/11

    Version:    2.04
    <TABLE>
    2.04_PH     Added BeOS support
    2.02_PH     Released with SFL 2.02
    </TABLE>

    Synopsis:   This header file encapsulates many generally-useful include
                files and defines lots of good stuff.  The intention of this
                header file is to hide the messy #ifdef's that you typically
                need to make real programs compile & run.  To use, specify
                as the first include file in your program.

                The main contributors to this file were:
                <Table>
                PH   Pieter Hintjens    <ph@imatix.com>
                EDM  Ewen McNeill       <ewen@imatix.com>
                PA   Pascal Antonnaux   <pascal@imatix.com>
                BW   Bruce Walter       <walter@fortean.com>
                RJ   Rob Judd           <judd@alphalink.com.au>
                </Table>

    Copyright:  Copyright (c) 1991-99 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef PRELUDE_INCLUDED               /*  Allow multiple inclusions        */
#define PRELUDE_INCLUDED


/*- Establish the compiler and computer system ------------------------------*/
/*
 *  Defines zero or more of these symbols, for use in any non-portable
 *  code:
 *
 *  __WINDOWS__         Microsoft C/C++ with Windows calls
 *  __MSDOS__           System is MS-DOS (set if __WINDOWS__ set)
 *  __VMS__             System is VAX/VMS or Alpha/OpenVMS
 *  __UNIX__            System is UNIX
 *  __OS2__             System is OS/2
 *
 *  __IS_32BIT__        OS/compiler is 32 bits
 *  __IS_64BIT__        OS/compiler is 64 bits
 *
 *  When __UNIX__ is defined, we also define exactly one of these:
 *
 *  __UTYPE_AUX         Apple AUX
 *  __UTYPE_BEOS        BeOS
 *  __UTYPE_BSDOS       BSD/OS
 *  __UTYPE_DECALPHA    Digital UNIX (Alpha)
 *  __UTYPE_IBMAIX      IBM RS/6000 AIX
 *  __UTYPE_FREEBSD     FreeBSD
 *  __UTYPE_HPUX        HP/UX
 *  __UTYPE_LINUX       Linux
 *  __UTYPE_MIPS        MIPS (BSD 4.3/System V mixture)
 *  __UTYPE_NETBSD      NetBSD
 *  __UTYPE_NEXT        NeXT
 *  __UTYPE_QNX         QNX
 *  __UTYPE_SCO         SCO Unix
 *  __UTYPE_IRIX        Silicon Graphics IRIX
 *  __UTYPE_SINIX       SINIX-N (Siemens-Nixdorf Unix)
 *  __UTYPE_SUNOS       SunOS
 *  __UTYPE_SUNSOLARIS  Sun Solaris
 *  __UTYPE_UNIXWARE    SCO UnixWare
 *                      ... these are the ones I know about so far.
 *  __UTYPE_GENERIC     Any other UNIX
 *
 *  When __VMS__ is defined, we may define one or more of these:
 *
 *  __VMS_XOPEN         Supports XOPEN functions
 */

#if (defined (__64BIT__) || defined(__LP64__))               /*  EDM 96/05/30                     */
#    define __IS_64BIT__                /*  May have 64-bit OS/compiler      */
#else
#    define __IS_32BIT__                /*  Else assume 32-bit OS/compiler   */
#endif

#if (defined WIN32 || defined (_WIN32))
#   undef __WINDOWS__
#   define __WINDOWS__
#   undef __MSDOS__
#   define __MSDOS__
#   undef UNIX                          /*  Some Win32 compilers like RSXNT  */
#   undef unix                          /*    define UNIX as well as Win32   */
#   undef __unix__                      /*    which causes problems...       */
#endif

#if (defined WINDOWS || defined (_WINDOWS) || defined (__WINDOWS__))
#   undef __WINDOWS__
#   define __WINDOWS__
#   undef __MSDOS__
#   define __MSDOS__
#endif

/*  MSDOS               Microsoft C                                          */
/*  _MSC_VER            Microsoft C                                          */
/*  __TURBOC__          Borland Turbo C                                      */
/*  __DJGPP__           D.J. Delorie's GNU C for DOS                         */
#if (defined (MSDOS) || defined (_MSC_VER) || defined (__TURBOC__) \
 || defined (__DJGPP__))
#   undef __MSDOS__
#   define __MSDOS__
#   if (defined (_DEBUG))
#       define DEBUG
#   endif
#endif

/*  EDM 96/05/28                                                             */
/*  __OS2__    Triggered by __EMX__ define and __i386__ define to avoid      */
/*             manual definition (eg, makefile) even though __EMX__ and      */
/*             __i386__ can be used on a MSDOS machine as well.  Here        */
/*             the same work is required at present.                         */
#if (defined (__EMX__) && defined (__i386__))
#   undef __OS2__
#   define __OS2__
#endif

/*  VMS                 VAX C (VAX/VMS)                                      */
/*  __VMS               Dec C (Alpha/OpenVMS)                                */
/*  __vax__             gcc                                                  */
#if (defined (VMS) || defined (__VMS) || defined (__vax__))
#   undef __VMS__
#   define __VMS__
#   if (__VMS_VER >= 70000000)
#       define __VMS_XOPEN
#   endif
#endif

/*  Try to define a __UTYPE_xxx symbol...                                    */
/*  unix                SunOS at least                                       */
/*  __unix__            gcc                                                  */
/*  _POSIX_SOURCE is various UNIX systems, maybe also VAX/VMS                */
#if (defined (unix) || defined (__unix__) || defined (_POSIX_SOURCE) || !defined(WINDOWS))
#   if (!defined (__VMS__))
#       undef __UNIX__
#       define __UNIX__
#       if (defined (__alpha))          /*  Digital UNIX is 64-bit           */
#           undef  __IS_32BIT__
#           define __IS_64BIT__
#           define __UTYPE_DECALPHA
#       endif
#   endif
#endif

#if (defined (_AUX))
#   define __UTYPE_AUX
#   define __UNIX__
#elif (defined (__BEOS__))
#   define __UTYPE_BEOS
#   define __UNIX__
#elif (defined (__hpux))
#   define __UTYPE_HPUX
#   define __UNIX__
#   define _INCLUDE_HPUX_SOURCE
#   define _INCLUDE_XOPEN_SOURCE
#   define _INCLUDE_POSIX_SOURCE
#elif (defined (_AIX) || defined (AIX))
#   define __UTYPE_IBMAIX
#   define __UNIX__
#elif (defined (BSD) || defined (bsd))
#   define __UTYPE_BSDOS
#   define __UNIX__
#elif (defined (linux))
#   define __UTYPE_LINUX
#   define __UNIX__
/* #   define __NO_CTYPE */                  /*  Suppress warnings on tolower()   */
#elif (defined (Mips))
#   define __UTYPE_MIPS
#   define __UNIX__
#elif (defined (FreeBSD) || defined (__FreeBSD__))
#   define __UTYPE_FREEBSD
#   define __UNIX__
#elif (defined (NetBSD) || defined (__NetBSD__))
#   define __UTYPE_NETBSD
#   define __UNIX__
#elif (defined (NeXT))
#   define __UTYPE_NEXT
#   define __UNIX__
#elif (defined (__QNX__))
#   define __UTYPE_QNX
#   define __UNIX__
#elif (defined (sco))
#   define __UTYPE_SCO
#   define __UNIX__
#elif (defined (sgi))
#   define __UTYPE_IRIX
#   define __UNIX__
#elif (defined (sinix))
#   define __UTYPE_SINIX
#   define __UNIX__
#elif (defined (SOLARIS) || defined (__SRV4))
#   define __UTYPE_SUNSOLARIS
#   define __UNIX__
#elif (defined (SUNOS) || defined (SUN) || defined (sun))
#   define __UTYPE_SUNOS
#   define __UNIX__
#elif (defined (__USLC__) || defined (UnixWare))
#   define __UTYPE_UNIXWARE
#   define __UNIX__
#elif (defined (__DJGPP__))       /* DJGPP thinks it's running in Unix. heh. */
#   undef __UNIX__
#elif (defined __UNIX__)
#   define __UTYPE_GENERIC
#endif


/*- Standard ANSI include files ---------------------------------------------*/

#ifdef __cplusplus
#include <iostream>                   /*  A bit of support for C++         */
#endif

#include <ctype.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <setjmp.h>


/*- System-specific include files -------------------------------------------*/

#if (defined (__MSDOS__))
#   if (defined (__WINDOWS__))          /*  When __WINDOWS__ is defined,     */
#       define FD_SETSIZE     1024      /*  Max. filehandles/sockets         */
#       include <windows.h>  
#       include <winsock.h>             /*  May cause trouble on VC 1.x      */
#       include <direct.h>   
#       include <process.h>   
#   endif
#   if (defined (__TURBOC__))
#       include <dir.h>
#       include <alloc.h>               /*  Okay for Turbo C                 */
#   else
#       include <malloc.h>              /*  But will it work for others?     */
#   endif
#   include <dos.h>
#   include <io.h>
#   include <fcntl.h>
#   include <sys/types.h>
#   include <sys/stat.h>
#endif

/*  These include files are for non-PC systems                               */

#if (defined (__UNIX__)) && !defined(WII) && !defined(MINPSPW) && !defined(PS3) && !defined(NDS) && !defined(NACL) && !defined(XENON)
#   if defined (__GNUC__) && (__GNUC__ >= 2)
#       define __STRICT_ANSI__
#   endif
#   include <fcntl.h>
#   include <netdb.h>
#   include <unistd.h>
#   include <dirent.h>
#   include <pwd.h>
#   include <grp.h>
#   include <sys/types.h>
#   include <sys/param.h>
#   include <sys/socket.h>
#   include <sys/time.h>
#   include <sys/stat.h>
#   include <sys/ioctl.h>
#   include <sys/file.h>
#   include <sys/wait.h>
#   include <netinet/in.h>              /*  Must come before arpa/inet.h     */
#   if (!defined (__UTYPE_BEOS))
#       include <arpa/inet.h>
#       if (!defined (TCP_NODELAY))
#           include <netinet/tcp.h>
#       endif
#   endif
/*  Specific #include's for UNIX varieties                                   */
#   if (defined (__UTYPE_IBMAIX) || defined(__UTYPE_QNX))
#       include <sys/select.h>
#   endif
#endif

#if defined(WII) || defined(MINPSPW) || defined(PS3) || defined(NDS) || defined(NACL) || defined(XENON)
#define AF_INET 1
#include <dirent.h>
#endif

#if (defined (__VMS__))
#   if (!defined (vaxc))
#       include <fcntl.h>               /*  Not provided by Vax C            */
#   endif
#   include <netdb.h>
#   include <unistd.h>
#   include <unixio.h>
#   include <unixlib.h>
#   include <types.h>
#   include <file.h>
#   include <socket.h>
#   include <dirent.h>
#   include <time.h>
#   include <pwd.h>
#   include <stat.h>
#   include <in.h>
#   include <inet.h>
#endif

#if (defined (__OS2__))
/*  Include list for OS/2 updated by EDM 96/12/31
 *  NOTE: sys/types.h must go near the top of the list because some of the
 *        definitions in other include files rely on types defined there.
 */
#   include <sys/types.h>
#   include <fcntl.h>
#   include <malloc.h>
#   include <netdb.h>
#   include <unistd.h>
#   include <dirent.h>
#   include <pwd.h>
#   include <grp.h>
#   include <io.h>
#   include <process.h>
#   include <sys/param.h>
#   include <sys/socket.h>
#   include <sys/select.h>
#   include <sys/time.h>
#   include <sys/stat.h>
#   include <sys/ioctl.h>
#   include <sys/file.h>
#   include <sys/wait.h>
#   include <netinet/in.h>              /*  Must come before arpa/inet.h     */
#   include <arpa/inet.h>
#   if (!defined (TCP_NODELAY))
#       include <netinet/tcp.h>
#   endif
#endif

#if (defined (__DJGPP__))
#   include <unistd.h>
#   include <dirent.h>
#   include <pwd.h>
#   include <grp.h>
#   include <dir.h>
#   include <sys/types.h>
#   include <sys/param.h>
#   include <sys/time.h>
#   include <sys/stat.h>
#   include <sys/ioctl.h>
#   include <sys/file.h>
#   include <sys/wait.h>
#endif


/*- Data types --------------------------------------------------------------*/

typedef unsigned short  Bool;           /*  Boolean TRUE/FALSE value         */
typedef unsigned char   byte;           /*  Single unsigned byte = 8 bits    */
typedef unsigned short  dbyte;          /*  Double byte = 16 bits            */
typedef unsigned short  word;           /*  Alternative for double-byte      */
typedef unsigned long   dword;          /*  Double word >= 32 bits           */
#if (defined (__IS_32BIT__))
typedef unsigned long   qbyte;          /*  Quad byte = 32 bits              */
#else
typedef unsigned int    qbyte;          /*  Quad byte = 32 bits              */
#endif
typedef void (*function) (void);        /*  Address of simple function       */
#define local static void               /*  Shorthand for local functions    */

typedef struct {                        /*  Memory descriptor                */
    size_t size;                        /*    Size of data part              */
    byte  *data;                        /*    Data part follows here         */
} DESCR;

typedef struct {                        /*  Variable-size descriptor         */
    size_t max_size;                    /*    Maximum size of data part      */
    size_t cur_size;                    /*    Current size of data part      */
    byte  *data;                        /*    Data part follows here         */
} VDESCR;

typedef struct {                        /*  Database timestamp               */
    long date;
    long time;
} TIMESTAMP;

/*- Check compiler data type sizes ------------------------------------------*/

#if (UCHAR_MAX != 0xFF)
#   error "Cannot compile: must change definition of 'byte'."
#endif
#if (USHRT_MAX != 0xFFFFU)
#   error "Cannot compile: must change definition of 'dbyte'."
#endif
#if (defined (__IS_32BIT__))
#   if (ULONG_MAX != 0xFFFFFFFFUL)
#       error "Cannot compile: must change definition of 'qbyte'."
#   endif
#else
#   if (UINT_MAX != 0xFFFFFFFFU)
#       error "Cannot compile: must change definition of 'qbyte'."
#   endif
#endif


/*- Pseudo-functions --------------------------------------------------------*/

#define FOREVER         for (;;)            /*  FOREVER { ... }              */
#define until(expr)     while (!(expr))     /*  do { ... } until (expr)      */
#define streq(s1,s2)    (!strcmp ((s1), (s2)))
#define strneq(s1,s2)   (strcmp ((s1), (s2)))
#define strused(s)      (*(s) != 0)
#define strnull(s)      (*(s) == 0)
#define strclr(s)       (*(s) = 0)
#define strlast(s)      ((s) [strlen (s) - 1])
#define strterm(s)      ((s) [strlen (s)])

#define bit_msk(bit)    (1 << (bit))
#define bit_set(x,bit)  ((x) |=  bit_msk (bit))
#define bit_clr(x,bit)  ((x) &= ~bit_msk (bit))
#define bit_tst(x,bit)  ((x) &   bit_msk (bit))

#define tblsize(x)      (sizeof (x) / sizeof ((x) [0]))
#define tbllast(x)      (x [tblsize (x) - 1])

#if (defined (random))
#   undef random
#   undef randomize
#endif
#if (defined (min))
#   undef min
#   undef max
#endif

#if (defined (__IS_32BIT__))
#define random(num)     (int) ((long) rand () % (num))
#else
#define random(num)     (int) ((int)  rand () % (num))
#endif
#define randomize()     srand ((unsigned) time (NULL))
#define min(a,b)        (((a) < (b))? (a): (b))
#define max(a,b)        (((a) > (b))? (a): (b))


/*- ASSERT ------------------------------------------------------------------*/
/*  If DEBUG is defined, the ASSERT macro aborts if the specified condition
 *  is false.  Note that you must include sflsyst.c in your application, for
 *  the sys_assert() function.
 */
#if (defined (DEBUG))
#   ifdef __cplusplus
extern "C" {
#   endif
void  sys_assert  (const char *filename, unsigned line_number);
#   undef  ASSERT
#   define ASSERT(f)    \
        if (f)          \
            ;           \
        else            \
            sys_assert (__FILE__, __LINE__)
#   ifdef __cplusplus
};
#   endif
#else
#   define ASSERT(f)
#endif


/*- Boolean operators and constants -----------------------------------------*/

#if (!defined (TRUE))
#    define TRUE        1               /*  ANSI standard                    */
#    define FALSE       0
#endif


/*- Symbolic constants ------------------------------------------------------*/

#define FORK_ERROR      -1              /*  Return codes from fork()         */
#define FORK_CHILD      0

#undef  LINE_MAX                      
#define LINE_MAX        1024            /*  Length of line from text file    */

#if (!defined (PATH_MAX))               /*  Length of path variable          */
#   define PATH_MAX     2048            /*    if not previously #define'd    */
#endif                                  /*  EDM 96/05/28                     */

#if (!defined (EXIT_SUCCESS))           /*  ANSI, and should be in stdlib.h  */
#   define EXIT_SUCCESS 0               /*    but not defined on SunOs with  */
#   define EXIT_FAILURE 1               /*    GCC, sometimes.                */
#endif


/*- System-specific definitions ---------------------------------------------*/

/*  On most systems, 'timezone' is an external long variable.  On a few, it
 *  is a function that returns a string.  We define TIMEZONE to be the long
 *  value.                                                                   */

#undef  TIMEZONE
#define TIMEZONE    timezone            /*  Unless redefined later           */

/*  UNIX defines sleep() in terms of second; Win32 defines Sleep() in
 *  terms of milliseconds.  We want to be able to use sleep() anywhere.      */

#if (defined (__WINDOWS__))
#   if (defined (WIN32))
#       undef  sleep
#       define sleep(a) Sleep(a*1000)   /*  UNIX sleep() is seconds          */
#   else
#       define sleep(a)                 /*  Do nothing?                      */
#   endif
    /*  MSVC 1.x does not define standard signals if in Windows              */
#   if (!defined (SIGINT))
#   define SIGINT       2               /*  Ctrl-C sequence                  */
#   define SIGILL       4               /*  Illegal instruction              */
#   define SIGSEGV      11              /*  Segment violation                */
#   define SIGTERM      15              /*  Kill signal                      */
#   define SIGABRT      22              /*  Termination by abort()           */
#   endif
    /*  MSVC 4.x does not define SIGALRM, so we pinch SIGFPE                 */
#   if (!defined (SIGALRM))
#   define SIGALRM      SIGFPE          /*  Must be a known signal           */
#   endif
    /*  Define STDxx_FILENO macros                                           */
#   if (!defined (STDIN_FILENO))
#   define STDIN_FILENO   _fileno (stdin)
#   define STDOUT_FILENO  _fileno (stdout)
#   define STDERR_FILENO  _fileno (stderr)
#   endif
    /*  Support for LCC-WIN32 compiler                                       */
#   if (defined (__LCC__))
#       include <mmsystem.h>
#       undef  TIMEZONE
#       define TIMEZONE 0
#       define environ _environ
        extern char   **environ;        /*  Not defined in include files     */
#   endif

/*  On SunOs, the ANSI C compiler costs extra, so many people install gcc
 *  but using the standard non-ANSI C library.  We have to make a few extra
 *  definitions for this case.  (Here we defined just what we needed for
 *  Libero and SMT -- we'll add more code as required.)                      */

#elif (defined (__UTYPE_SUNOS) || defined (__UTYPE_SUNSOLARIS))
#   if (!defined (_SIZE_T))             /*  Non-ANSI headers/libraries       */
#       define strerror(n)      sys_errlist [n]
#       define memmove(d,s,l)   bcopy (s,d,l)
        extern char *sys_errlist [];
#   endif

#elif (defined (__UTYPE_BSDOS))
#   undef  TIMEZONE
#   define TIMEZONE 0                   /*  timezone is not available        */

#elif (defined (__UTYPE_FREEBSD))
#   undef  TIMEZONE
#   define TIMEZONE 0                   /*  timezone is not available        */

#elif (defined (__UTYPE_NETBSD))
#   undef  TIMEZONE
#   define TIMEZONE 0                   /*  timezone is not available        */

#elif (defined (__VMS__))
    /*  This data structure is often used in OpenVMS library functions       */
    typedef struct {                    /*  Fixed-string descriptor:         */
        word  length;                   /*    Length of string in bytes      */
        byte  dtype;                    /*    Must be DSC$K_DTYPE_T = 14     */
        byte  class;                    /*    Must be DSC$K_CLASS_S = 1      */
        char *value;                    /*    Address of start of string     */
    } STRING_DESC;
    #define VMS_STRING(name,value) STRING_DESC name = \
                                        { sizeof (value) - 1, 14, 1, value }
#endif

#if (defined (__UNIX__) || defined (__VMS__) || defined (__DJGPP__)) && !defined(WII) && !defined(MINPSPW) && !defined(PS3) && !defined(NDS) && !defined(XENON)
    extern char **environ;              /*  Not defined in include files     */
#endif

/*  On some systems (older Vaxen and Unixes) O_BINARY is not defined.        */

#if (!defined (O_BINARY))
#   define O_BINARY     0
#endif

/*  On some systems SIGALRM is not defined; we allow it in code anyhow       */

#if (!defined (SIGALRM))
#   define SIGALRM      1
#endif

/*  On some systems O_NDELAY is used instead of O_NONBLOCK                   */

#if (!defined (O_NONBLOCK))
#   if (!defined (O_NDELAY))
#       define O_NDELAY 0
#   endif
#   if (defined (__VMS__))
#       define O_NONBLOCK 0             /*  Can't use O_NONBLOCK on files    */
#   else
#       define O_NONBLOCK O_NDELAY
#   endif
#endif

/*  We define constants for the way the current system formats filenames;
 *  we assume that the system has some type of path concept.                 */

#if (defined (WIN32))                   /*  Windows 95/NT                    */
#   define PATHSEP      ";"             /*  Separates path components        */
#   define PATHEND      '\\'            /*  Delimits directory and filename  */
#   define PATHFOLD     FALSE           /*  Convert pathvalue to uppercase?  */
#   define NAMEFOLD     FALSE           /*  Convert filenames to uppercase?  */
#   define MSDOS_FILESYSTEM             /*  MS-DOS derivative                */
#elif (defined (__MSDOS__))             /*  16-bit Windows, MS-DOS           */
#   define PATHSEP      ";"
#   define PATHEND      '\\'
#   if defined LFN                      /*  Support DRDOS long file names    */
#       define PATHFOLD FALSE
#       define NAMEFOLD FALSE
#   else
#       define PATHFOLD TRUE
#       define NAMEFOLD TRUE
#   endif
#   define MSDOS_FILESYSTEM             /*  MS-DOS derivative                */
#elif (defined (__VMS__))               /*  Digital OpenVMS                  */
#   define PATHSEP      ","             /*    We work with POSIX filenames   */
#   define PATHEND      '/'
#   define PATHFOLD     TRUE
#   define NAMEFOLD     TRUE
#elif (defined (__UNIX__))              /*  All UNIXes                       */
#   define PATHSEP      ":"
#   define PATHEND      '/'
#   define PATHFOLD     FALSE
#   define NAMEFOLD     FALSE
#elif (defined (__OS2__))               /*  OS/2 using EMX/GCC               */
#   define PATHSEP      ";"             /*  EDM 96/05/28                     */
#   define PATHEND      '\\'
#   define PATHFOLD     TRUE
#   define NAMEFOLD     FALSE
#   define MSDOS_FILESYSTEM             /*  MS-DOS derivative                */
#else
#   error "No definitions for PATH constants"
#endif


/*- Capability definitions --------------------------------------------------*/
/*
 *  Defines zero or more of these symbols, for use in any non-portable
 *  code:
 *
 *  DOES_SOCKETS        We can use (at least some) BSD socket functions
 *  DOES_UID            We can use (at least some) uid access functions
 *  DOES_SNPRINTF       Supports snprintf and vsnprintf functions
 *  DOES_BSDSIGNALS     Supports BSD signal model (e.g. siginterrupt)
 */

#if (defined (AF_INET))
#   define DOES_SOCKETS                 /*  System supports BSD sockets      */
#else
#   undef  DOES_SOCKETS
#endif

#if (defined (__UNIX__) || defined (__VMS__) || defined (__OS2__))
#   define DOES_UID                     /*  System supports uid functions    */
#else
#   undef  DOES_UID
#   if (!defined (__DJGPP__))           /*  gid_t and uid_t already defined  */
        typedef int gid_t;              /*  Group id type                    */
        typedef int uid_t;              /*  User id type                     */
#   endif
#endif

#if (defined (__WINDOWS__) && (!defined (__LCC__)))
#   define DOES_SNPRINTF
#   define snprintf  _snprintf
#   define vsnprintf _vsnprintf
#elif (defined (__OS2__))
#   define DOES_SNPRINTF
#elif (defined (__UTYPE_SCO))
#   define DOES_SNPRINTF
#elif (defined (__UTYPE_LINUX))
#   define DOES_SNPRINTF
#else
#   undef DOES_SNPRINTF
#endif

/*  SunOS 5 (Solaris) does not support BSD-style signal handling             */
#if (!defined (__UTYPE_SUNSOLARIS))
#   define DOES_BSDSIGNALS
#else
#   undef  DOES_BSDSIGNALS
#endif


#endif                                  /*  Include PRELUDE.H                */
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflvers.h
    Title:      Define SFL version
    Package:    Standard Function Library (SFL)

    Written:    1996/11/21  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/10/02

    Synopsis:   Defines the SFL_VERSION constant.
    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLVERS_INCLUDED               /*  Allow multiple inclusions        */
#define SFLVERS_INCLUDED

#define SFL_VERSION     "2.01"          /*  Main SFL version                 */

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflbits.h
    Title:      Large bitstring manipulation functions
    Package:    Standard Function Library (SFL)

    Written:    1996/05/14  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides operations to manipulate large bitstrings.  The
                bitstrings are compressed.  Intended for bit-based index
                techniques, where bitstrings can be millions of bits long.
                These functions are still in development; this is an early
                version that provides basic functionality.  Simple tests
                on large bitmaps with random filling show a cost of about
                3 bytes per bit, after compression.  This includes all the
                indexing information.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLBITS_INCLUDED               /*  Allow multiple inclusions        */
#define SFLBITS_INCLUDED

/*  Definitions                                                              */

#define BIT_DATASIZE    500             /*  Size of block data part          */
#define BIT_INDEXSIZE   BIT_DATASIZE/2  /*  Size of block index part         */
#define BIT_SECTSIZE    8192            /*  Size of one bitstring section    */
#define BIT_MAXBLOCKS   1024            /*  Max. size of bitstring           */
#define BIT_MAXBITS     16384000L       /*  Max. possible bit number         */

typedef struct {                        /*  Bitstring block                  */
    union {
        byte  data  [BIT_DATASIZE];     /*    Data record part               */
        dbyte index [BIT_INDEXSIZE];    /*    Index record part              */
    } block;
    dbyte left,                         /*    Pointer to left (index only)   */
          right;                        /*    Pointer to right (data too)    */
    int   size;                         /*    Size of data part              */
} BITBLOCK;

typedef struct {                        /*  Bitstring object                 */
    BITBLOCK
       *block [BIT_MAXBLOCKS];          /*  Table of allocated blocks        */
    int
        block_count;                    /*  How many allocated blocks        */
    dbyte
        free_list;                      /*  Block free list                  */
} BITS;

extern long bits_free_count;            /*  We count free() and malloc()     */
extern long bits_alloc_count;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

int   bits_init    (void);
int   bits_term    (void);
BITS *bits_create  (void);
void  bits_destroy (BITS *bits);
int   bits_set     (BITS *bits, long bit);
int   bits_clear   (BITS *bits, long bit);
int   bits_test    (const BITS *bits, long bit);
int   bits_fput    (FILE *file, const BITS *bits);
BITS *bits_fget    (FILE *file);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflcomp.h
    Title:      Compression functions
    Package:    Standard Function Library (SFL)

    Written:    1991/05/20  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Various compression/decompression functions.  The LZ-type
                algorith (LZRW1/KH) was originally written by Kurt Haenen
                <ghgaea8@blekul11> and made portable by P. Hintjens. This
                is a reasonable LZ/RLE algorithm, very fast, but about 30%
                less efficient than a ZIP-type algorithm in terms of space.
                The RLE algorithms are better suited to compressing sparse
                data.  The nulls variant is specifically tuned to data that
                consists mostly of binary zeroes.  The bits variant is
                tuned for compressing sparse bitmaps.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLCOMP_INCLUDED               /*  Allow multiple inclusions        */
#define SFLCOMP_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

word compress_block (const byte *source, byte *dest, word source_size);
word expand_block   (const byte *source, byte *dest, word source_size);
word compress_rle   (      byte *source, byte *dest, word source_size);
word expand_rle     (const byte *source, byte *dest, word source_size);
word compress_nulls (      byte *source, byte *dest, word source_size);
word expand_nulls   (const byte *source, byte *dest, word source_size);
word compress_bits  (      byte *source, byte *dest, word source_size);
word expand_bits    (const byte *source, byte *dest, word source_size);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflcons.h
    Title:      Console output functions
    Package:    Standard Function Library (SFL)

    Written:    1997/05/22  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/02/08

    Synopsis:   Provides redirectable console output: use the coprintf() and
                coputs() calls instead of printf() and puts() in a real-time
                application.  Then, you can call console_send() to send all
                console output to a specified function.  This is a useful
                way to get output into -- for example -- a GUI window.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLCONS_INCLUDED               /*  Allow multiple inclusions        */
#define SFLCONS_INCLUDED


/*  Type definition for operator redirection function                        */

typedef void (CONSOLE_FCT) (const char *);


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

void  console_send        (CONSOLE_FCT *console_fct, Bool echo);
void  console_enable      (void);
void  console_disable     (void);
void  console_set_mode    (int CONSOLE_MODE);
int   console_capture     (const char *filename, char mode);
int   coputs              (const char *string);
int   coprintf            (const char *format, ...);
int   coputc              (int character);

#ifdef __cplusplus
}
#endif


/*  Constant definitions                                                     */

enum {
    CONSOLE_PLAIN,                      /*  Print as requested               */
    CONSOLE_DATETIME,                   /*  Prefix with date and time        */
    CONSOLE_TIME                        /*  Prefix with time only            */
};

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflconv.h
    Title:      Conversion functions
    Package:    Standard Function Library (SFL)

    Written:    1995/12/17  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/10/19

    Synopsis:   These functions provide conversion between a set of datatypes
                (dates, times, numbers, Booleans) and external strings that
                represent the values.  The objective is to format datatypes
                for display or printing, and to validate and convert strings
                supplied by the user.  Conversion is controlled by a set of
                options specific to each datatype.  Additionally, dates and
                times may be formatted using picture strings.  The functions
                were written for use in an interactive 'forms' environment.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLCONV_INCLUDED               /*  Allow multiple inclusions        */
#define SFLCONV_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

char  *conv_number_str  (const char *number, int flags, char point,
                         int decimals, int decimal_format, int width,
                         int sign_format);
char  *conv_str_number  (const char *string, int flags, char point,
                         int decimals, int decimal_format, int width);
char  *conv_date_str    (long date, int flags, int format, int order,
                         char datesep, int width);
long   conv_str_date    (const char *string, int flags, int format, int order);
int    conv_str_day     (const char *day_name);

char  *conv_time_str    (long time, int flags, char timesep, int width);
long   conv_str_time    (const char *string);

char  *conv_bool_str    (Bool boolean, int format);
int    conv_str_bool    (const char *string);

char  *conv_time_pict   (long time, const char *picture);
char  *conv_date_pict   (long date, const char *picture);

/** Not Yet Implemented **/
char  *conv_float_str   (double number, int flags, int sign_format, char
                         point, int decimals, int decimal_format, int width
                        /*  Srcdoc: IGNORE                                   */
                        );
/** Not Yet Implemented **/
double conv_str_float   (char *string, int flags, int sign_format,
                         char point, int decimals, int decimal_format
                        /*  Srcdoc: IGNORE                                   */
                        );

#ifdef __cplusplus
}
#endif

#define FORMAT_MAX              80      /*  Max. size of formatted field     */
#define CONV_MAX_DECS           100     /*  Up to 100 decimal positions      */


/*  Global variables for error reporting                                     */

extern int   conv_reason;               /*  Reason for last conversion error */
                                        /*  0 = okay; >0 = error             */
extern char *conv_reason_text [];       /*  Array of error messages 1..n     */
                                        /*  Index using conv_reason          */

/*  Possible values for conv_reason                                          */

#define CONV_NO_ERRORS             0    /*  No errors                        */

#define CONV_ERR_INVALID_INPUT     1    /*  Unrecognised char in input       */
#define CONV_ERR_OUT_OF_RANGE      2    /*  Value out of valid range         */

/*  conv_str_bool ()                                                         */

#define CONV_ERR_NOT_BOOLEAN       3    /*  Not a yes/no or true/false value */

/*  conv_str_time ()                                                         */

#define CONV_ERR_MULTIPLE_AM       4    /*  More than one 'am' or 'pm'       */

/*  conv_date_str ()                                                         */

#define CONV_ERR_DATE_OVERFLOW     5    /*  Result too large for output      */

/*  conv_str_date ()                                                         */

#define CONV_ERR_DATE_SIZE         6    /*  Too few or too many digits       */
#define CONV_ERR_MULTIPLE_DELIM    7    /*  Too many delimiters              */
#define CONV_ERR_BAD_MONTH         8    /*  Unknown month name               */
#define CONV_ERR_REJECT_3_5        9    /*  3/5 digits in a row not allowed  */
#define CONV_ERR_MULTIPLE_MONTH   10    /*  More than one month name         */

/*  conv_number_str ()                                                       */

#define CONV_ERR_DECS_MISSING     11    /*  Not enough decimals supplied     */
#define CONV_ERR_NUM_OVERFLOW     12    /*  Result too large for output      */

/*  conv_str_number ()                                                       */

#define CONV_ERR_MULTIPLE_SIGN    13    /*  More than one sign character     */
#define CONV_ERR_SIGN_REJECTED    14    /*  Sign not allowed if unsigned     */
#define CONV_ERR_SIGN_BAD_FIN     15    /*  Malformed financial negative     */
#define CONV_ERR_MULTIPLE_POINT   16    /*  More than one decimal point      */
#define CONV_ERR_DECS_REJECTED    17    /*  Decimals not allowed if integer  */
#define CONV_ERR_DECS_HIDDEN      18    /*  Decimals not allowed if hidden   */
#define CONV_ERR_DECS_OVERFLOW    19    /*  Too many decimal positions       */
#define CONV_ERR_TOO_MANY_DIGITS  20    /*  Too many digits for number       */


/*  Constants used for dedicated formatting functions                        */

#define DATE_ORDER_FIRST       1       /*  Values for date_order            */
#define DATE_ORDER_YMD         1
#define DATE_ORDER_DMY         2
#define DATE_ORDER_MDY         3
#define DATE_ORDER_LAST        3

#define FLAG_N_SIGNED           1       /*  Number field flags               */
#define FLAG_N_DECIMALS         2
#define FLAG_N_LEFT             4
#define FLAG_N_ZERO_FILL        8
#define FLAG_N_ZERO_BLANK      16
#define FLAG_N_THOUSANDS       32

#define SIGN_NEG_TRAIL          1       /*  Number field formatting          */
#define SIGN_ALL_TRAIL          2
#define SIGN_NEG_LEAD           3
#define SIGN_ALL_LEAD           4
#define SIGN_FINANCIAL          5

#define DECS_SHOW_ALL           1
#define DECS_DROP_ZEROS         2
#define DECS_HIDE_ALL           3
#define DECS_SCIENTIFIC         4

#define DATE_FORMAT_FIRST      0       /*  Date field formatting            */
#define DATE_YMD_COMPACT        0
#define DATE_YMD_DELIM          1
#define DATE_YMD_SPACE          2
#define DATE_YMD_COMMA          3
#define DATE_YMD_LAST          3
#define DATE_YM_COMPACT         4
#define DATE_YM_DELIM           5
#define DATE_YM_SPACE           6
#define DATE_YM_LAST           6
#define DATE_MD_COMPACT         7
#define DATE_MD_DELIM           8
#define DATE_MD_SPACE           9
#define DATE_MD_LAST           9
#define DATE_FORMAT_LAST       9

#define FLAG_D_DD_AS_D          1       /*  Date field flags                 */
#define FLAG_D_MM_AS_M          2
#define FLAG_D_MONTH_ABC        4
#define FLAG_D_CENTURY          8
#define FLAG_D_UPPER           16
#define FLAG_D_ORDER_YMD       32
#define FLAG_D_ORDER_DMY       64
#define FLAG_D_ORDER_MDY      128

#define FLAG_T_HH_AS_H          1       /*  Time field flags                 */
#define FLAG_T_MM_AS_M          2
#define FLAG_T_SS_AS_S          4
#define FLAG_T_CC_AS_C          8
#define FLAG_T_COMPACT         16
#define FLAG_T_12_HOUR         32

#define BOOL_YES_NO             0       /*  Boolean field formatting         */
#define BOOL_Y_N                1
#define BOOL_TRUE_FALSE         2
#define BOOL_T_F                3
#define BOOL_1_0                4

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflcryp.h
    Title:      Encryption and decryption functions
    Package:    Standard Function Library (SFL)

    Written:    1996/01/23  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation

    Synopsis:   The encryption/decryption functions were based on the
                cryptosystem library by Andrew Brown <asb@cs.nott.ac.uk>,
                cleaned-up for portability.  Thanks for a great package.

                IDEA is registered as the international patent WO 91/18459
                "Device for Converting a Digital Block and the Use thereof".
                For commercial use of IDEA, you should contact:
                  ASCOM TECH AG
                  Freiburgstrasse 370
                  CH-3018 Bern, Switzerland

    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.

    Notes:
    Description of IDEA cipher
    --------------------------
    The IDEA cipher operates on 64 bit (8 byte) blocks, using a 128 bit (16
    byte) key. IDEA has found itself famous through its inclusion in the
    well-known PGP package. The following is from the introduction to chapter
    3 of the thesis that presented the cipher.

    The block cipher IDEA (International Data Encryption Algorithm) is based
    on the new design concept of "mixing operations from different algebraic
    groups". The required "confusion" was achieved by successively using three
    "incompatible" group operations on pairs of 16-bit subblocks and the cipher
    structure was chosen to provide the necessary "diffusion". The cipher
    structure was further chosen to facilitate both hardware and software
    implementations. The IDEA cipher is an improved version of PES and was
    developed to increase security against differential cryptanalysis.

    Description of MDC cipher
    -------------------------
    This is a method for turning a hash function, here MD5, into a fast
    secret-key encryption. Based on a suggestion by Phil Karn in sci.crypt, 13
    Feb 1992. See also his comments from sci.crypt, 23 Mar 1992. The method is
    a variant of that described in Zheng, Matsumoto and Imai, Crypto 89. See
    also, "A New Class of Cryptosystems Based on Interconnection Networks" by
    michaelp@terpsichore.informatic.rwth-aachen.de

    Description of DES cipher
    -------------------------
    DES is the well known U.S. Data Encryption Standard cipher.
    DES encrypts data in 64 bit blocks, using a 64 bit key -- of which
    56 bits are used in the encipherment process.
------------------------------------------------------------------</Prolog>-*/

#ifndef SFLCRYP_INCLUDED               /*  Allow multiple inclusions        */
#define SFLCRYP_INCLUDED


/*  Definitions of the encryption algorithms we support                      */

#define CRYPT_IDEA      0               /*  IDEA algorithm                   */
#define CRYPT_MDC       1               /*  MDC algorithm                    */
#define CRYPT_DES       2               /*  DES algorithm                    */
#define CRYPT_XOR       3               /*  A basic XOR algorithm            */
#define CRYPT_TOP       4               /*  We support 4 algorithms          */

/*  We define some tables that key off the encryption algorithm              */

#if (defined (DEFINE_CRYPT_TABLES))
static int
    crypt_block_size [] = {             /*  Block size for each algorithm    */
       8, 32, 8, 16
    };
#define CRYPT_MAX_BLOCK_SIZE  32        /*  Largest block size, in bytes     */
#endif

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

Bool  crypt_encode  (byte *buffer, word buffer_size, int algorithm, 
                     const byte *key);
Bool  crypt_decode  (byte *buffer, word buffer_size, int algorithm, 
                     const byte *key);
qbyte calculate_crc (byte *block, size_t length);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfldate.h
    Title:      Date and time functions
    Package:    Standard Function Library (SFL)

    Written:    1996/01/05  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/08/05

    Synopsis:   Includes functions to get the current date/time, calculate
                the day or week, week of year and leap year.  Dates and times
                are each stored in a 32-bit long value of 8 digits: dates are
                CCYYMMDD; times are HHMMSSCC.  You can compare dates and times
                directly - e.g. if (date_wanted >= date_now).

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLDATE_INCLUDED               /*  Allow multiple inclusions        */
#define SFLDATE_INCLUDED

/*  Macros                                                                   */

#define GET_CENTURY(d)      (int) ( (d) / 1000000L)
#define GET_CCYEAR(d)       (int) ( (d) / 10000L)
#define GET_YEAR(d)         (int) (((d) % 1000000L) / 10000L)
#define GET_MONTH(d)        (int) (((d) % 10000L) / 100)
#define GET_DAY(d)          (int) ( (d) % 100)

#define GET_HOUR(t)         (int) ( (t) / 1000000L)
#define GET_MINUTE(t)       (int) (((t) % 1000000L) / 10000L)
#define GET_SECOND(t)       (int) (((t) % 10000L) / 100)
#define GET_CENTI(t)        (int) ( (t) % 100)

#define MAKE_DATE(c,y,m,d)  (long) (c) * 1000000L +                          \
                            (long) (y) * 10000L +                            \
                            (long) (m) * 100 + (d)
#define MAKE_TIME(h,m,s,c)  (long) (h) * 1000000L +                          \
                            (long) (m) * 10000L +                            \
                            (long) (s) * 100 + (c)

#define timeeq(d1,t1,d2,t2)  ((d1) == (d2) && (t1) == (t2))
#define timeneq(d1,t1,d2,t2) ((d1) != (d2) || (t1) != (t2))
#define timelt(d1,t1,d2,t2)  ((d1) < (d2) || ((d1) == (d2) && (t1) <  (t2)))
#define timele(d1,t1,d2,t2)  ((d1) < (d2) || ((d1) == (d2) && (t1) <= (t2)))
#define timegt(d1,t1,d2,t2)  ((d1) > (d2) || ((d1) == (d2) && (t1) >  (t2)))
#define timege(d1,t1,d2,t2)  ((d1) > (d2) || ((d1) == (d2) && (t1) >= (t2)))

/*  Days are numbered from 0=Sunday to 6=Saturday                            */

#define DAY_SUNDAY      0
#define DAY_MONDAY      1
#define DAY_TUESDAY     2
#define DAY_WEDNESDAY   3
#define DAY_THURSDAY    4
#define DAY_FRIDAY      5
#define DAY_SATURDAY    6


/*  Interval values, specified in centiseconds                               */

#define INTERVAL_CENTI      1
#define INTERVAL_SEC        100
#define INTERVAL_MIN        6000
#define INTERVAL_HOUR       360000L
#define INTERVAL_DAY        8640000L


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

long   date_now           (void);
long   time_now           (void);
Bool   leap_year          (int year);
int    julian_date        (long date);
int    day_of_week        (long date);
int    week_of_year       (long date);
int    year_quarter       (long date);
long   next_weekday       (long date);
long   prev_weekday       (long date);
word   pack_date          (long date);
word   pack_time          (long time);
long   unpack_date        (word packdate);
long   unpack_time        (word packtime);
long   default_century    (long *date);
long   date_to_days       (long date);
long   days_to_date       (long days);
time_t date_to_timer      (long date, long time);
long   timer_to_date      (time_t time_secs);
long   timer_to_time      (time_t time_secs);
long   timer_to_gmdate    (time_t time_secs);
long   timer_to_gmtime    (time_t time_secs);
long   time_to_csecs      (long time);
long   csecs_to_time      (long csecs);
void   future_date        (long *date, long *time, long days, long csecs);
void   past_date          (long *date, long *time, long days, long csecs);
void   date_diff          (long date1, long time1, long date2, long time2,
                           long *days, long *csecs);
Bool   valid_date         (long date);
Bool   valid_time         (long time);
Bool   date_is_future     (long date, long time);
Bool   date_is_past       (long date, long time);
char  *timezone_string    (void);
void   local_to_gmt       (long date, long time, long *gmdate, long *gmtime);
void   gmt_to_local       (long gmdate, long gmtime, long *date, long *time);
struct tm *safe_localtime (const time_t *time_secs);
struct tm *safe_gmtime    (const time_t *time_secs);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfldbio.h
    Title:      Database interface - header file
    Package:    SFL

    Written:    1999/03/31  Pascal Antonnaux <pascal@imatix.com>
    Revised:    2000/02/13  Jonathan Schultz

    Synopsis:   Defines structures and constants for the db interface.

    Copyright:  Copyright (c) 1991-99 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SFLDBIO_INCLUDED
#define _SFLDBIO_INCLUDED

/*- Definitions  ------------------------------------------------------------*/

/* Database type should be defined in CCDEFINES environment variable         */

#if (defined (DBIO_ODBC))
    /*  Okay, use ODBC                                                       */
#elif (defined (DBIO_MYSQL))
    /*  Okay, use MySQL                                                      */
#elif (defined (DBIO_ORACLE))
    /*  Okay, use Oracle                                                     */
#elif (defined (DBIO_DB2))
    /*  Okay, use IBM/DB2                                                    */
#elif (defined (DBIO_XML))
    /*  Okay, use XML simulated database                                     */
#else
#   define DBIO_NONE
#endif

/* Type of Database server                                                   */

#define DB_TYPE_NONE           0
#define DB_TYPE_ODBC           1
#define DB_TYPE_ORACLE         2
#define DB_TYPE_DB2            3
#define DB_TYPE_INFORMIX       4
#define DB_TYPE_SYBASE         5
#define DB_TYPE_SQLSERV        6
#define DB_TYPE_MYSQL          7
#define DB_TYPE_POSTGRES       8
#define DB_TYPE_XML            9

#define DB_TYPE_MAX            10

#define GOTO_NEXT_RECORD       99999
#define ERR_MSG_SIZE           300
#define ERR_CODE_SIZE          20

#define COMMON_DBIO_CTX                                                      \
    long               connect_id;      /* Connection ID                   */\
    free_table_handle *free_handle;     /* Handle to free table resource   */   


typedef void (free_table_handle) (void *);

/* Error structure                                                           */

typedef struct
{
    int  code;                          /* Error code ( 0 = NO ERROR)        */
    char code_msg [ERR_CODE_SIZE];      /* Message code                      */
    char message  [ERR_MSG_SIZE];       /* Error message                     */
    int  parse_offset;                  /* Parse error offset                */
    int  nb_rows;                       /* number of rows processed          */
} DBIO_ERR;


/* All feedback type                                                         */

enum {
    OK                    = 0,
    HARD_ERROR            = 1,
    ILLEGAL_OPERATION     = 2,
    ILLEGAL_MODE          = 3,
    RECORD_NOT_PRESENT    = 4,
    DUPLICATE_RECORD      = 5,
    ILLEGAL_FILE_USAGE    = 6,
    RECORD_LOCKED         = 7,
    RECORD_CHANGED        = 8,
    RECORD_INTEGRITY      = 9,
    INVALID_SEARCH_KEY    = 10,
    NOT_CONNECTED         = 11
};

/* Position mode                                                             */

enum {
    THIS_RECORD           = 0,
    EQUAL_TO              = 1,
    GREATER_OR_EQUAL      = 2,
    GREATER_THAN          = 3,
    LESS_THAN             = 4,
    LESS_THAN_OR_EQUAL    = 5,
    NEXT_RECORD           = 6,
    PRIOR_RECORD          = 7,
    LAST_RECORD           = 8,
    FIRST_RECORD          = 9
};

/* KEY selector                                                              */

enum {
    PRIMARY               = 0,
    ALTERNATE_A           = 1,
    ALTERNATE_B           = 2,
    ALTERNATE_C           = 3,
    ALTERNATE_D           = 4,
    ALTERNATE_E           = 5,
    ALTERNATE_F           = 6,
    ALTERNATE_G           = 7,
    ALTERNATE_H           = 8,
    ALTERNATE_I           = 9,
    ALTERNATE_J           = 10,
    ALTERNATE_K           = 11,
    ALTERNATE_L           = 12,
    ALTERNATE_M           = 13,
    ALTERNATE_N           = 14,
    ALTERNATE_O           = 15,
    ALTERNATE_P           = 16,
    ALTERNATE_Q           = 17,
    ALTERNATE_R           = 18,
    ALTERNATE_S           = 19,
    ALTERNATE_T           = 20,
    ALTERNATE_U           = 21,
    ALTERNATE_V           = 22,
    ALTERNATE_W           = 23,
    ALTERNATE_X           = 24,
    ALTERNATE_Y           = 25,
    ALTERNATE_Z           = 26,
    ALTERNATE_ERROR       = 27
};

#ifdef __cplusplus
extern "C" {
#endif

extern long
    current_connect_id [DB_TYPE_MAX];

Bool      dbio_connect       (char *db_name, char *user, char *pwd, char *extra,
                              Bool set_default, dbyte db_type);
void     *dbio_get_handle    (dbyte db_type, char *table, char *connect_name, 
                              long connect_id);
void      dbio_disconnect    (void);
int       dbio_commit        (void);
int       dbio_rollback      (void);
DBIO_ERR *dbio_get_error     (void);
int       dbio_error_code    (void);
char     *dbio_error_message (void);
dbyte     get_db_type        (char *db_type_name);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflexdr.h
    Title:      External data representation functions
    Package:    Standard Function Library (SFL)

    Written:    1996/06/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides functions to read and write data in a portable
                format that is suitable for transmission to other systems.
                The principle is similar to the ONC XDR standard used in
                RPC, but somewhat simpler.  The streams produced by these
                functions are not compatible with ONC XDR.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLEXDR_INCLUDED               /*  Allow multiple inclusions        */
#define SFLEXDR_INCLUDED


/*---------------------------------------------------------------------------
 *  Function prototypes
 */

#ifdef __cplusplus
extern "C" {
#endif

int    exdr_write   (byte  *buffer, const char *format, ...);
int    exdr_writed  (DESCR *buffer, const char *format, ...);
int    exdr_read    (const byte *buffer, const char *format, ...);

#ifdef __cplusplus
}
#endif


#endif                                  /*  Include sflexdr.h                */
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflfind.h
    Title:      Fast string searching functions
    Package:    Standard Function Library (SFL)

    Written:    1996/04/24  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/05/03

    Synopsis:   Searches for a pattern within a string or block of memory
                using a variant of the Boyer-Moore algorithm (improved by
                Horspool and Sunday). As fast or faster than the normal
                Boyer-Moore algorithm for most search strings, and much
                simpler.  Includes a basic function for searching blocks of
                memory with known sizes, plus an envelope that searches
                null-delimited strings.  Provides the option of repeatedly
                searching for the same pattern without re-parsing the pattern
                each time.  Original algorithm published by BOYER, R., and S.
                MOORE 1977, "A Fast String Searching Algorithm." CACM, 20,
                762-72.  Simplifications by HORSPOOL, R. N. 1980, "Practical
                Fast Searching in Strings." Software - Practice and Experience,
                10, 501-06.  More improvements by HUME, A., and D. M. SUNDAY
                1991, "Fast String Searching." AT&T Bell Labs Computing Science
                Technical Report No. 156.  Implemented in C by P. Hintjens.

                strfind_r() and memfind_r(), are reentrant versions of
                strfind() and memfind() for single searches, and
                strfind_rb() and memfind_rb() are reentrant versions of
                strfind() and memfind() supporting repeat searches against
                the same pattern.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLFIND_INCLUDED               /*  Allow multiple inclusions        */
#define SFLFIND_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char *strfind    (const char *string, const char *pattern, Bool repeat_find);
char *strfind_r  (const char *string, const char *pattern);
char *strfind_rb (const char *string, const char *pattern,
                  size_t *shift, Bool *repeat_find);

void *memfind    (const void *block,   size_t block_size,
                  const void *pattern, size_t pattern_size, Bool repeat_find);
void *memfind_r  (const void *block,   size_t block_size,
                  const void *pattern, size_t pattern_size);
void *memfind_rb (const void *block,   size_t block_size,
                  const void *pattern, size_t pattern_size,
                  size_t *shift, Bool *repeat_find);

char *txtfind    (const char *string, const char *pattern);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflfile.h
    Title:      File-access functions
    Package:    Standard Function Library (SFL)

    Written:    1992/10/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/11/08

    Synopsis:   Provides functions to read and write files with explicit
                new-line/carriage-return control; to find files on a path;
                to copy files, check files' protection, etc.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLFILE_INCLUDED               /*  Allow multiple inclusions        */
#define SFLFILE_INCLUDED


/*  System-specific definitions                                              */

#if (defined (__MSDOS__))
#   define FOPEN_READ_TEXT      "rt"    /*  Under DOS we can be explict      */
#   define FOPEN_READ_BINARY    "rb"    /*    and use 't' or 'b' in fopen    */
#   define FOPEN_WRITE_TEXT     "wt"
#   define FOPEN_WRITE_BINARY   "wb"
#   define FOPEN_APPEND_TEXT    "at"
#   define FOPEN_APPEND_BINARY  "ab"
#elif (defined (__VMS__))
#   define FOPEN_READ_TEXT      "r"     /*  Dec C does not like 't' or 'b'   */
#   define FOPEN_READ_BINARY    "r"
#   define FOPEN_WRITE_TEXT     "w"
#   define FOPEN_WRITE_BINARY   "w"
#   define FOPEN_APPEND_TEXT    "a"
#   define FOPEN_APPEND_BINARY  "a"
#elif (defined (__UNIX__))
#   define FOPEN_READ_TEXT      "rt"    /*  Under UNIX we can be explict     */
#   define FOPEN_READ_BINARY    "rb"    /*    and use 't' or 'b' in fopen    */
#   define FOPEN_WRITE_TEXT     "wt"
#   define FOPEN_WRITE_BINARY   "wb"
#   define FOPEN_APPEND_TEXT    "at"
#   define FOPEN_APPEND_BINARY  "ab"
#elif (defined (__OS2__))
#   define FOPEN_READ_TEXT      "rt"    /*  Under OS/2 we can be explict     */
#   define FOPEN_READ_BINARY    "rb"    /*    and use 't' or 'b' in fopen    */
#   define FOPEN_WRITE_TEXT     "wt"
#   define FOPEN_WRITE_BINARY   "wb"
#   define FOPEN_APPEND_TEXT    "at"
#   define FOPEN_APPEND_BINARY  "ab"
#else
#   error "No definitions for FOPEN constants"
#endif


/*  Constants                                                                */

enum {
    CYCLE_ALWAYS  = 0,                  /*  Cycle file unconditionally       */
    CYCLE_HOURLY  = 1,                  /*  Cycle file if hour has changed   */
    CYCLE_DAILY   = 2,                  /*  Cycle file if day has changed    */
    CYCLE_WEEKLY  = 3,                  /*  Cycle file if week has changed   */
    CYCLE_MONTHLY = 4,                  /*  Cycle file if month has changed  */
    CYCLE_NEVER   = 5                   /*  Don't cycle the file             */
};

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

FILE  *file_open           (const char *filename, char mode);
FILE  *file_locate         (const char *path, const char *name,
                            const char *ext);
int    file_close          (FILE *stream);
Bool   file_read           (FILE *stream, char *string);
Bool   file_readn          (FILE *stream, char *string, int line_max);
char  *file_write          (FILE *stream, const char *string);
int    file_copy           (const char *dest, const char *src, char mode);
int    file_concat         (const char *dest, const char *src);
int    file_rename         (const char *oldname, const char *newname);
int    file_delete         (const char *filename);
char  *file_where          (char mode, const char *path, const char *name,
                            const char *ext);
char  *file_where_ext      (char mode, const char *path, const char *name,
                            const char **ext);
Bool   file_exists         (const char *filename);
Bool   file_cycle          (const char *filename, int how);
Bool   file_cycle_needed   (const char *filename, int how);
Bool   file_has_changed    (const char *filename, long old_date, long old_time);
Bool   safe_to_extend      (const char *filename);
char  *default_extension   (char *dest, const char *src, const char *ext);
char  *fixed_extension     (char *dest, const char *src, const char *ext);
char  *strip_extension     (char *filename);
char  *add_extension       (char *dest, const char *src, const char *ext);
char  *strip_file_path     (char *filename);
char  *strip_file_name     (char *filename);
char  *get_new_filename    (const char *filename);
Bool   file_is_readable    (const char *filename);
Bool   file_is_writeable   (const char *filename);
Bool   file_is_executable  (const char *filename);
Bool   file_is_directory   (const char *filename);
Bool   file_is_program     (const char *filename);
Bool   file_is_legal       (const char *filename);
char  *file_exec_name      (const char *filename);
long   get_file_size       (const char *filename);
time_t get_file_time       (const char *filename);
long   get_file_lines      (const char *filename);
DESCR *file_slurp          (const char *filename);
DESCR *file_slurpl         (const char *filename);
dbyte  file_set_eoln       (char *dest, const char *src, dbyte src_size,
                            Bool add_cr);
char  *get_tmp_file_name   (const char *path, qbyte *index, const char *ext);
int    file_fhredirect     (int source, int dest);
void   file_fhrestore      (int source, int dest);
FILE  *ftmp_open           (char **pathname);
void   ftmp_close          (FILE *tempstream);

#ifdef __cplusplus
}
#endif


/*  Symbols, macros                                                          */

#define FILE_NAME_MAX   160             /*  Max size of filename             */
#define FILE_DIR_MAX    64              /*  Max size of directory name       */
#define file_lines(f)   get_file_lines(f)   /*  Changed 98/07/23             */

/*  External variables                                                       */

extern Bool  file_crlf;                 /*  TRUE or FALSE                    */

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflfort.h
    Title:      Fortune-cookie functions
    Package:    Standard Function Library (SFL)

    Written:    1999/08/16  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/08/27

    Synopsis:   Provides functions to create compressed or simple fortune
                cookie files, and functions to read from such files.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLFORT_INCLUDED               /*  Allow multiple inclusions        */
#define SFLFORT_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

int   fortune_build (const char *in, const char *out, Bool compress);
char *fortune_read  (const char *fortune_file);

#ifdef __cplusplus
}
#endif


#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfllang.h
    Title:      Multilanguage support
    Package:    Standard Function Library (SFL)

    Written:    1997/06/04  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/05/31

    Synopsis:   Provides hard-coded multilanguage dictionaries for dates and
                numbers,  The hard-coded dictionaries work with most European
                languages.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLLANG_INCLUDED               /*  Allow multiple inclusions        */
#define SFLLANG_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

int   set_userlang        (int language);
int   set_userlang_str    (const char *language);
int   get_userlang        (void);
char *get_userlang_str    (void);
int   set_accents         (Bool accents);
Bool  get_accents         (void);
char *get_units_name      (int units);
char *get_tens_name       (int tens);
char *get_day_name        (int day);
char *get_day_abbrev      (int day, Bool upper);
char *get_month_name      (int month);
char *get_month_abbrev    (int month, Bool upper);
char *timestamp_string    (char *buffer, const char *pattern);

#ifdef __cplusplus
}
#endif


/*  Constant definitions                                                     */

enum {
    USERLANG_DEFAULT = 0,               /*  Default language                 */
    USERLANG_DA,                        /*  Danish                           */
    USERLANG_DE,                        /*  German                           */
    USERLANG_EN,                        /*  English                          */
    USERLANG_ES,                        /*  Castillian Spanish               */
    USERLANG_FB,                        /*  Belgian or Swiss French          */
    USERLANG_FR,                        /*  French                           */
    USERLANG_IS,                        /*  Icelandic                        */
    USERLANG_IT,                        /*  Italian                          */
    USERLANG_NL,                        /*  Dutch                            */
    USERLANG_NO,                        /*  Norwegian                        */
    USERLANG_PO,                        /*  Portuguese                       */
    USERLANG_SV                         /*  Swedish                          */
};

#define USERLANG_TOP     USERLANG_SV + 1

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfllbuf.h
    Title:      Line buffering functions
    Package:    Standard Function Library (SFL)

    Written:    1997/09/07  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides circular line buffering functions.  A line buffer
                is a data structure that holds a fixed amount of data in a
                serial fashion; the oldest data gets discarded as new data
                is added.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLLBUF_INCLUDED               /*  Allow multiple inclusions        */
#define SFLLBUF_INCLUDED


/*- Type definitions --------------------------------------------------------*/

typedef struct {
    char  *data;                        /*  Buffer contents                  */
    char  *head;                        /*  Where we add new data            */
    char  *tail;                        /*  Oldest data is here              */
    size_t size;                        /*  Actual size of buffer            */
    char  *top;                         /*  Address of top of buffer         */
} LINEBUF;                              /*  Empty when tail == head          */


/*- Function Prototypes -----------------------------------------------------*/

LINEBUF *linebuf_create  (size_t maxsize);
void     linebuf_destroy (LINEBUF *buffer);
void     linebuf_reset   (LINEBUF *buffer);
void     linebuf_append  (LINEBUF *buffer, const char *line);
char    *linebuf_first   (LINEBUF *buffer, DESCR *line);
char    *linebuf_next    (LINEBUF *buffer, DESCR *line, const char *cur);
char    *linebuf_last    (LINEBUF *buffer, DESCR *line);
char    *linebuf_prev    (LINEBUF *buffer, DESCR *line, const char *cur);

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfllist.h
    Title:      Linked-list functions
    Package:    Standard Function Library (SFL)

    Written:    1997/07/28  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/07/26

    Synopsis:   Provides functions to maintain doubly-linked lists.  You can
                use these functions to work with lists of any structure.  To
                make this work, all structures must start with two pointers,
                "void *next, *prev;".  When you want to attach a linked-list
                to another structure, declare the list head as a list.  You
                can then refer to this variable when you attach items to the
                list head.  The code sets the global list_unsafe to TRUE
                whenever it is changing a list.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLLIST_INCLUDED               /*  Allow multiple inclusions        */
#define SFLLIST_INCLUDED

/*- Types -------------------------------------------------------------------*/

/*  The list descriptor simply contains two pointers.  All blocks that are   */
/*  descriptors that are held in lists.  We can (a) allocate a dummy list    */
/*  instead of a complete block for a list head, and (b) use the same list   */
/*  handling functions for all descriptors.                                  */

typedef struct {                        /*  list descriptor                  */
    void *next, *prev;                  /*    for a doubly-linked list       */
} LIST;

/*  Function type for comparing nodes.  A function of this type is passed    */
/*  to the list sorting functions which use it to compare nodes.  A function */
/*  of this type should return TRUE iff the two nodes need swapping.         */

typedef Bool (*NODE_COMPARE) (LIST *t1, LIST *t2);

/*  Global variables                                                         */

extern Bool
    list_unsafe;                        /*  TRUE if we're changing a list    */

/*- Function prototypes -----------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

void *list_relink (void *left, void *list, void *right);
void *list_unlink (            void *list             );
void *list_add    (LIST *list, void *data, size_t size);
void list_remove  (LIST *list, void *data, size_t size);
void list_sort    (void *list, NODE_COMPARE comp);

#ifdef __cplusplus
}
#endif


/*  -------------------------------------------------------------------------
    Macro: list_relink_after

    Synopsis: Links a list into a doubly-linked list after a point in the
    list.  Generally a linked list is attached to a 'head': an empty list
    consists of just the head list.  To attach a list to the start of the
    list, link after the head.  To attach a list to the end of the list,
    link before the head using list_relink_before().  In this way you can
    build doubly-ended queues, fifo queue, lists, etc.  Returns the address
    of the list.
    -------------------------------------------------------------------------*/

#define list_relink_after(l,a) (list_relink (a, l, ((LIST *) a)-> next))


/*  -------------------------------------------------------------------------
    Macro: list_relink_before

    Synopsis: Links a list into a doubly-linked list before a point in the
    list.  To link a list to the end of a doubly-linked list, link it before
    the list header list.
    -------------------------------------------------------------------------*/

#define list_relink_before(l,b) (list_relink (((LIST *) b)-> prev, l, b))


/*  Other macros                                                             */

#define list_reset(list)        (list)-> prev = (list)-> next = (list)
#define list_empty(list)        ((list)-> prev == (list))
#define list_create(node,size)  if (((node) = mem_alloc (size)) != NULL) \
                                    list_reset (node)

/*  Macro to do all nodes on a linked list                                   */

#define FORLIST(node,root)      for ((node) = (root).next;       \
                                     (void *) (node) != &(root); \
                                     (node) = (node)-> next)

/*  Macros to use lists as stacks and queues                                 */

#define list_push(list,item)    list_add (list,                               \
                                          &item,                              \
                                          sizeof (item))

#define list_queue(list,item)   list_add (((LIST *)list)-> prev,              \
                                          &item,                              \
                                          sizeof (item))

#define list_pop(list,item)     list_remove (list,                            \
                                             &item,                           \
                                             sizeof (item))

#define list_destroy(list)      while (!list_empty(list))                     \
                                  {                                           \
                                    LIST *item = ((LIST *)list)-> next;       \
                                    list_unlink (item);                       \
                                    mem_free (item);                          \
                                  }
#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflmath.h
    Title:      Mathematic functions
    Package:    Standard Function Library (SFL)

    Written:    1996/05/12  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides miscellaneous mathematical functions, including
                calculation of points within areas.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLMATH_INCLUDED               /*  Allow multiple inclusions        */
#define SFLMATH_INCLUDED

/*  Structure declaration                                                    */

typedef struct
  {
    double x;
    double y;
  } FPOINT;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

int  point_in_rect   (const FPOINT *point, const FPOINT *coords);
int  point_in_circle (const FPOINT *point, const FPOINT *coords);
int  point_in_poly   (const FPOINT *point, const FPOINT *coords, int nb_point);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflmail.h
    Title:      SMTP mailer function
    Package:    standard function library (sfl)

    Written:    06/18/97 Scott Beasley (jscottb@infoave.com)
    Revised:    1999/07/06

    Synopsis:   Functions to format and send SMTP messages.  Messages
                can contain attachments, and be sent with "cc"'s "bcc"'s as
                well as the normal "to" receivers.
            
    Copyright:  Copyright (C) 1991-2000 Scott Beasley and iMatix Corporation
    License:    this is free software; you can redistribute it and/or modify
                it under the terms of the sfl license agreement as provided
                in the file license.txt.  this software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _sflmail_included               /*  allow multiple inclusions        */
#define _sflmail_included

typedef struct SMTP {
   char *strSmtpServer;
   char *strMessageBody;
   char *strSubject;
   char *strSenderUserId;
   char *strFullSenderUserId;          /* to be filled with: "realname" <e-mail> */
   char *strDestUserIds;
   char *strFullDestUserIds;           /* to be filled with: "realname" <e-mail> */   
   char *strCcUserIds;
   char *strFullCcUserIds;             /* to be filled with: "realname" <e-mail> */
   char *strBccUserIds;
   char *strFullBccUserIds;
   char *strRetPathUserId;
   char *strRrcpUserId;
   char *strMsgComment;
   char *strMailerName;
   char *strBinFiles;
   char *strTxtFiles;
   char strlast_smtp_message[513];
   int  debug;
   char *strDebugFile;
   int  mime;
   int  encode_type;
   int  connect_retry_cnt;
   int  retry_wait_time;
} SMTP;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif
int smtp_send_mail_ex (SMTP *smtp);
int smtp_send_mail    (char *strSmtpServer,       char *strMessageBody,
                       char *strSubject,          char *strSenderUserId,
                       char *strFullSenderUserId, char *strDestUserIds,
                       char *strFullDestUserIds,  char *strCcUserIds,
                       char *strFullCcUserIds,    char *strBccUserIds,
                       char *strFullBccUserIds,   char *strRetPathUserId,
                       char *strRrcpUserId,       char *strMsgComment,
                       char *strMailerName,       char *strBinFiles,
                       char *strTxtFiles,         char *strDebugFile );
#ifdef __cplusplus
}
#endif

#endif

/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflmesg.h
    Title:      Message-file access functions
    Package:    Standard Function Library (SFL)

    Written:    1992/10/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides functions to read and format messages from a message
                file.  The intention of such a file is to provide a single
                location for all error messages: you can easier translate
                these into foreign languages, and you can control the
                consistency of an application's error messages.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLMESG_INCLUDED               /*  Allow multiple inclusions        */
#define SFLMESG_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

int    open_message_file   (const char *filename);
void   close_message_file  (void);
void   print_message       (int msgid, ...);
char  *message_text        (int msgid);

#ifdef __cplusplus
}
#endif

/*  Symbols, macros                                                          */

#define ERROR_ANY       0000            /*  Generic error message            */

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflmem.h
    Title:      Memory allocation functions
    Package:    Standard Function Library (SFL)

    Written:    1996/06/08  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/12/28

    Synopsis:   Encapsulated memory allocation functions.  Based on an
                article by Jim Schimandle in DDJ August 1990.  Provides
                'safe' versions of malloc(), realloc(), free(), and strdup().
                These functions protect the programmer from errors in calling
                memory allocation/free routines.   When these calls are used,
                the allocation routines in this module add a data structure
                to the top of allocated memory blocks which tags them as legal
                memory blocks.  When the free routine is called, the memory
                block to be freed is checked for legality.  If the block
                is not legal, the memory list is dumped to stderr and the
                program is terminated.  Some of these functions are called
                through macros that add the filename and line number of the
                call, for tracing.  Do not call these functions directly.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLMEM_INCLUDED                /*  Allow multiple inclusions        */
#define SFLMEM_INCLUDED


/*- Type definitions --------------------------------------------------------*/

typedef Bool (*scavenger) (void *);     /*  Memory scavenger function        */

typedef struct _MEMHDR MEMHDR;          /*  Memory block header              */
typedef struct _MEMTRN MEMTRN;          /*  Transaction block identifier     */

/*- Function prototypes -----------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*  General memory allocation functions                                      */

void  *mem_alloc_      (MEMTRN *trn, size_t size,
                        const char *source_file, size_t source_line);
void  *mem_realloc_    (void *block, size_t size,
                        const char *source_file, size_t source_line);
void   mem_free_       (void *block,
                        const char *source_file, size_t source_line);
char  *mem_strdup_     (MEMTRN *trn, const char *string,
                        const char *source_file, size_t source_line);
void   mem_strfree_    (char **string,
                        const char *source_file, size_t source_line);
DESCR *mem_descr_      (MEMTRN *trn, const void *block, size_t size,
                        const char *source_file, size_t source_line);

/*  Functions on transactions                                                */

MEMTRN *mem_new_trans_ (const char *source_file, size_t source_line);
void    mem_commit_    (MEMTRN *trn,
                        const char *source_file, size_t source_line);
void    mem_rollback_  (MEMTRN *trn,
                        const char *source_file, size_t source_line);

/*  Hidden control functions                                                 */

void   mem_checkall_   (const char *source_file, size_t source_line);
void   mem_check_      (const void *block,
                        const char *source_file, size_t source_line);
void   mem_assert_     (const char *source_file, size_t source_line);

/*  Visible control functions                                                */

size_t mem_size_       (const void *block,
                        const char *source_file, size_t source_line);
long   mem_used        (void);
long   mem_allocs      (void);
long   mem_frees       (void);
void   mem_freeall     (void);
void   mem_display     (FILE *save_to);
int    mem_scavenger   (scavenger scav_fct, void *scav_arg);

#ifdef __cplusplus
}
#endif

/*- Define macros to encapsulate calls to the hidden functions --------------*/

#if (defined (DEBUG))

/*  Transaction-based allocation macros                                      */

# define memt_alloc(t,n)    mem_alloc_     ((t),  (n),      __FILE__, __LINE__)
# define memt_strdup(t,s)   mem_strdup_    ((t),  (s),      __FILE__, __LINE__)
# define memt_descr(t,p,n)  mem_descr_     ((t),  (p), (n), __FILE__, __LINE__)

/*  Basic allocation macros                                                  */

# define mem_alloc(n)       mem_alloc_     (NULL, (n),      __FILE__, __LINE__)
# define mem_strdup(s)      mem_strdup_    (NULL, (s),      __FILE__, __LINE__)
# define mem_descr(p,n)     mem_descr_     (NULL, (p), (n), __FILE__, __LINE__)

/*  Other functions requiring __FILE__ & __LINE__ substitution               */

# define mem_new_trans()    mem_new_trans_ (                __FILE__, __LINE__)
# define mem_commit(t)      mem_commit_    ((t),            __FILE__, __LINE__)
# define mem_rollback(t)    mem_rollback_  ((t),            __FILE__, __LINE__)
# define mem_realloc(p,n)   mem_realloc_   ((p), (n),       __FILE__, __LINE__)
# define mem_free(p)        { if ((p)) mem_free_ ((p), __FILE__, __LINE__); }
# define mem_strfree(ps)    mem_strfree_   ((ps),           __FILE__, __LINE__)
# define mem_assert()       mem_assert_    (                __FILE__, __LINE__)
# define mem_checkall()     mem_checkall_  (                __FILE__, __LINE__)
# define mem_check(p)       mem_check_     ((p),            __FILE__, __LINE__)
# define mem_size(p)        mem_size_      ((p),            __FILE__, __LINE__)
#else

/*  Transaction-based allocation macros                                      */

# define memt_alloc(t,n)    mem_alloc_     ((t),  (n),      NULL, 0)
# define memt_strdup(t,s)   mem_strdup_    ((t),  (s),      NULL, 0)
# define memt_descr(t,p,n)  mem_descr_     ((t),  (p), (n), NULL, 0)

/*  Basic allocation macros                                                  */

# define mem_alloc(n)       mem_alloc_     (NULL, (n),      NULL, 0)
# define mem_strdup(s)      mem_strdup_    (NULL, (s),      NULL, 0)
# define mem_descr(p,n)     mem_descr_     (NULL, (p), (n), NULL, 0)

/*  Other functions requiring __FILE__ & __LINE__ substitution               */

# define mem_new_trans()    mem_new_trans_ (                NULL, 0)
# define mem_commit(t)      mem_commit_    ((t),            NULL, 0)
# define mem_rollback(t)    mem_rollback_  ((t),            NULL, 0)
# define mem_realloc(p,n)   mem_realloc_   ((p), (n),       NULL, 0)
# define mem_free(p)        mem_free_      ((p),            NULL, 0)
# define mem_strfree(ps)    mem_strfree_   ((ps),           NULL, 0)
# define mem_assert()       mem_assert_    (                NULL, 0)
# define mem_checkall()     mem_checkall_  (                NULL, 0)
# define mem_check(p)       mem_check_     ((p),            NULL, 0)
# define mem_size(p)        mem_size_      ((p),            NULL, 0)
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflmime.h
    Title:      MIME support functions
    Package:    Standard Function Library (SFL)

    Written:    1996/03/28  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/11/18

    Synopsis:   Provides various functions that support MIME encoding and
                decoding.  See RFC 1521 for details.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.

    Notes:
    Extract from RFC1521 for Base64 Content-Transfer-Encoding
    ---------------------------------------------------------

    The Base64 Content-Transfer-Encoding is designed to represent
    arbitrary sequences of octets in a form that need not be humanly
    readable.  The encoding and decoding algorithms are simple, but the
    encoded data are consistently only about 33 percent larger than the
    unencoded data.  This encoding is virtually identical to the one used
    in Privacy Enhanced Mail (PEM) applications, as defined in RFC 1421.
    The base64 encoding is adapted from RFC 1421, with one change: base64
    eliminates the "*" mechanism for embedded clear text.

    A 65-character subset of US-ASCII is used, enabling 6 bits to be
    represented per printable character. (The extra 65th character, "=",
    is used to signify a special processing function.)

    \NOTE: This subset has the important property that it is
    represented identically in all versions of ISO 646, including US
    ASCII, and all characters in the subset are also represented
    identically in all versions of EBCDIC.  Other popular encodings,
    such as the encoding used by the uuencode utility and the base85
    encoding specified as part of Level 2 PostScript, do not share
    these properties, and thus do not fulfill the portability
    requirements a binary transport encoding for mail must meet.

    The encoding process represents 24-bit groups of input bits as output
    strings of 4 encoded characters. Proceeding from left to right, a
    24-bit input group is formed by concatenating 3 8-bit input groups.
    These 24 bits are then treated as 4 concatenated 6-bit groups, each
    of which is translated into a single digit in the base64 alphabet.
    When encoding a bit stream via the base64 encoding, the bit stream
    must be presumed to be ordered with the most-significant-bit first.

    That is, the first bit in the stream will be the high-order bit in
    the first byte, and the eighth bit will be the low-order bit in the
    first byte, and so on.

    Each 6-bit group is used as an index into an array of 64 printable
    characters. The character referenced by the index is placed in the
    output string. These characters, identified in Table 1, below, are
    selected so as to be universally representable, and the set excludes
    characters with particular significance to SMTP (e.g., ".", CR, LF)
    and to the encapsulation boundaries defined in this document (e.g.,
    "-").

                      Table 1: The Base64 Alphabet

      Value Encoding  Value Encoding  Value Encoding  Value Encoding
           0 A            17 R            34 i            51 z
           1 B            18 S            35 j            52 0
           2 C            19 T            36 k            53 1
           3 D            20 U            37 l            54 2
           4 E            21 V            38 m            55 3
           5 F            22 W            39 n            56 4
           6 G            23 X            40 o            57 5
           7 H            24 Y            41 p            58 6
           8 I            25 Z            42 q            59 7
           9 J            26 a            43 r            60 8
          10 K            27 b            44 s            61 9
          11 L            28 c            45 t            62 +
          12 M            29 d            46 u            63 /
          13 N            30 e            47 v
          14 O            31 f            48 w         (pad) =
          15 P            32 g            49 x
          16 Q            33 h            50 y

    The output stream (encoded bytes) must be represented in lines of no
    more than 76 characters each.  All line breaks or other characters
    not found in Table 1 must be ignored by decoding software.  In base64
    data, characters other than those in Table 1, line breaks, and other
    white space probably indicate a transmission error, about which a
    warning message or even a message rejection might be appropriate
    under some circumstances.

    Special processing is performed if fewer than 24 bits are available
    at the end of the data being encoded.  A full encoding quantum is
    always completed at the end of a body.  When fewer than 24 input bits
    are available in an input group, zero bits are added (on the right)
    to form an integral number of 6-bit groups.  Padding at the end of
    the data is performed using the '=' character.  Since all base64
    input is an integral number of octets, only the following cases can
    \arise: (1) the final quantum of encoding input is an integral
    multiple of 24 bits; here, the final unit of encoded output will be
    an integral multiple of 4 characters with no "=" padding, (2) the
    final quantum of encoding input is exactly 8 bits; here, the final
    unit of encoded output will be two characters followed by two "="
    padding characters, or (3) the final quantum of encoding input is
    exactly 16 bits; here, the final unit of encoded output will be three
    characters followed by one "=" padding character.

    Because it is used only for padding at the end of the data, the
    occurrence of any '=' characters may be taken as evidence that the
    end of the data has been reached (without truncation in transit).  No
    such assurance is possible, however, when the number of octets
    transmitted was a multiple of three.

    Any characters outside of the base64 alphabet are to be ignored in
    base64-encoded data.  The same applies to any illegal sequence of
    characters in the base64 encoding, such as "====="

    Care must be taken to use the proper octets for line breaks if base64
    encoding is applied directly to text material that has not been
    converted to canonical form.  In particular, text line breaks must be
    converted into CRLF sequences prior to base64 encoding. The important
    thing to note is that this may be done directly by the encoder rather
    than in a prior canonicalization step in some implementations.

    \NOTE: There is no need to worry about quoting apparent
    encapsulation boundaries within base64-encoded parts of multipart
    entities because no hyphen characters are used in the base64
    encoding.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLMIME_INCLUDED                /*  Allow multiple inclusions       */
#define SFLMIME_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

size_t  encode_base64    (const byte *source, byte *target, size_t source_size);
size_t  decode_base64    (const byte *source, byte *target, size_t source_size);
Bool    decode_mime_time (const char *mime_date, long *date, long *time);
char   *encode_mime_time (long date, long time);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflnode.h
    Title:      Linked-list functions
    Package:    Standard Function Library (SFL)

    Written:    1996/06/03  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides functions to maintain doubly-linked lists.  You can
                use these functions to work with lists of any structure.  To
                make this work, all structures must start with two pointers,
                "void *next, *prev;".  When you want to attach a linked-list
                to another structure, declare the list head as a NODE.  You
                can then refer to this variable when you attach items to the
                list head.  The code sets the global node_unsafe to TRUE
                whenever it is changing a list.  NOTE: DEPRECATED IN FAVOUR
                OF SFLLIST.C.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLNODE_INCLUDED               /*  Allow multiple inclusions        */
#define SFLNODE_INCLUDED


/*  The node descriptor simply contains two pointers.  All blocks that are   */
/*  descriptors that are held in lists.  We can (a) allocate a dummy node    */
/*  instead of a complete block for a list head, and (b) use the same list   */
/*  handling functions for all descriptors.                                  */

typedef struct {                        /*  Node descriptor                  */
    void *next, *prev;                  /*    for a doubly-linked list       */
} NODE;

/*  Global variables                                                         */

extern Bool
    node_unsafe;                        /*  TRUE if we're changing a list    */

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

void *node_create        (void *after, size_t size);
void  node_destroy       (void *node);
void *node_unlink        (void *node);
void *node_relink        (void *left, void *node, void *right);
void *node_relink_after  (void *node, void *after);
void *node_relink_before (void *node, void *before);

#ifdef __cplusplus
}
#endif

/*  Macros                                                                   */

#define node_reset(node)          (node)-> prev = (node)-> next = (node)

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfldir.h
    Title:      Directory access functions
    Package:    Standard Function Library (SFL)

    Written:    1996/04/02  iMatix SFL project team <sfl@imatix.com>
    Revised:    2000/01/18

    Synopsis:   The directory access functions provide a portable interface
                to the system's file directory structure.   In general these
                functions are modelled around the UNIX opendir and readdir
                functions, but they are also similar to the DOS interface.
                These functions can fail on SVr4 if the <dirent.h> file
                does not match the C library.  Recompile with the switch
                -D _USE_BSD_DIRENT and they should work a bit better.
                Tested on: MS-DOS (Turbo-C), Windows (MSVC 4.0), UNIX
                (Linux, IBM AIX, SunOS).  OS/2 port was done by Ewen McNeill
                <ewen@naos.co.nz>.  DJGPP and DRDOS LFN by Rob Judd
                <judd@alphalink.com.au>.  Changes for Win32 by Will Menninger
                <willus@netcom.com>.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLDIR_INCLUDED                /*  Allow multiple inclusions        */
#define SFLDIR_INCLUDED

#if !(defined (NAME_MAX))               /*  Posix uses NAME_MAX              */
#   if !(defined (MAXNAMLEN))           /*  BSD uses MAXNAMLEN               */
#       if (defined (__WINDOWS__))
#           define MAXNAMLEN 259        /*  MSVC uses 259                    */
#       elif (defined (__MS_DOS__) && !defined LFN) /* Support for DRDOS LFN */
#           define MAXNAMLEN 12         /*  DOS uses 8.3                     */
#       else
#           define MAXNAMLEN 255        /*  And for everyone else, 255       */
#       endif
#   endif
#   define NAME_MAX         MAXNAMLEN
#endif

#define UID_CACHE_MAX       10          /*  Max. different uid's we cache    */
#define GID_CACHE_MAX       10          /*  Max. different gid's we cache    */

/*  DOS-ish file attributes, provided as an alternative to the UNIX-ish      */
/*  file mode bits.  Both fields are always filled-out as far as possible.   */
/*  These bits correspond to the normal DOS values.                          */

#define ATTR_RDONLY         0x01        /*  Read only file                   */
#define ATTR_HIDDEN         0x02        /*  Hidden file                      */
#define ATTR_SYSTEM         0x04        /*  System file                      */
#define ATTR_SUBDIR         0x10        /*  Subdirectory                     */
#define ATTR_MASK           0x17        /*  All bits together                */

/*  For portability we need to define types for the various fields that      */
/*  stat() returns.  If the compiler complains about these definitions,      */
/*  you need to add conditional definitions accordingly.  SMOP.              */
/*  For now, I assume that DOES_UID defines the stat types correctly.        */
/*  Note that prelude.h already defines uid_t and gid_t.                     */

#if (!defined (DOES_UID) && !defined (__DJGPP__))
typedef unsigned short      mode_t;
typedef unsigned short      nlink_t;
typedef long                off_t;
#endif

/*  Microsoft tends to use _stat instead of stat.                            */

#if (defined (_MSC_VER))
#   define stat _stat
#endif

/*  BeOS does not define S_IXUSR so we build this mask ourselves             */

#if (!defined (S_IXUSR))
#    define S_IXUSR  00100  /*  Owner may execute                            */
#endif

/*  We define DEFAULT_DIR as the default current directory, so that we       */
/*  can call open_dir() with a null or empty directory argument.  On most    */
/*  systems this is ".".                                                     */

#if (defined (__VMS__))
#   define DEFAULT_DIR      " "
#else
#   define DEFAULT_DIR      "."
#endif

/*  Under SVr4 it can happen that the <dirent.h> file does not match the     */
/*  C library.  Typically the library readdir() function returns the BSD     */
/*  structure while the <dirent.h> file defines dirent using the System V    */
/*  standards.  This is weird but apparently quite common.  Solution: at     */
/*  compile-time, force the switch -D _USE_BSD_DIRENT, and we define our     */
/*  own BSD-like structure.  Hey, I hate second-guessing the include files   */
/*  but if it's broke, you gotta fix it.  This problem appears at least on   */
/*  SunOS, to our knowledge.                                                 */

#if (defined (_USE_BSD_DIRENT))
struct Dirent
  {
    unsigned long   d_fileno;           /*  File number of entry             */
    unsigned short  d_reclen;           /*  Length of this record            */
    unsigned short  d_namlen;           /*  Length of string in d_name       */
    char            d_name [255 + 1];   /*  Maximum name length              */
  };
#else
#   define Dirent   dirent              /*  We'll always refer to Dirent     */
#endif

/*  Directory stream structure - this contains private fields starting       */
/*  with '_' and public fields.  If you use the private fields, be warned    */
/*  that these may change as we see fit.  If you add strings to this block,  */
/*  be sure to check fix_dir() and free_dir().                               */

typedef struct
{
    Bool    _fixed;                     /*  TRUE if processed by fix_dir()   */

#if (defined (__UNIX__) || defined (__VMS_XOPEN) || defined (__OS2__))
    DIR    *_dir_handle;                /*    a directory handle             */
    struct Dirent                       /*    and a file desc. structure,    */
           *_dir_entry;                 /*    both transient blocks          */

#elif (defined (WIN32))                 /*  Win32:                           */
    HANDLE  _dir_handle;                /*    a directory handle             */
    WIN32_FIND_DATA _dir_entry;         /*    and a file descriptor          */

#elif (defined (_MSC_VER))              /*  MSC Win16                        */
    long    _dir_handle;                /*    a directory handle             */
    struct  _find_t _dir_entry;         /*    and a file desc. structure     */

#elif (defined (__TURBOC__) || defined (__DJGPP__))
    struct ffblk                        /*    a file desc. structure         */
            _dir_entry;

#elif (defined (__VMS__))               /*  OpenVMS V5.x and lower           */
    long   _dir_handle;                 /*    lib$find_file context          */
#endif

    /*  Public fields                                                        */
    char   *dir_name;                   /*  Directory name + sep             */
    char   *owner;                      /*  File owner name                  */
    char   *group;                      /*  File owner group name            */
    char   *file_name;                  /*  Name of the file                 */
    time_t  file_time;                  /*  Time of modification for file    */
    off_t   file_size;                  /*  Size of the file                 */
    mode_t  file_mode;                  /*  UNIX-ish permission bits         */
    byte    file_attrs;                 /*  MS-DOS-ish permission bits       */
    nlink_t file_nlink;                 /*  Number of links to file          */
} DIRST;


typedef struct _FILEINFO
{
    struct _FILEINFO                    /*  Pointer for the linked list      */
        *next,
        *prev;
    DIRST
        dir;                            /*  File information                 */
    Bool
        directory;                      /*  TRUE if file is directory        */
} FILEINFO;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

Bool      open_dir      (DIRST *dir, const char *dir_name);
Bool      read_dir      (DIRST *dir);
Bool      close_dir     (DIRST *dir);
char     *format_dir    (DIRST *dir, Bool full);
int       fix_dir       (DIRST *dir);
int       free_dir      (DIRST *dir);
char     *resolve_path  (const char *path);
char     *locate_path   (const char *root, const char *path);
char     *clean_path    (const char *path);
NODE     *load_dir_list (const char *dir_name, const char *sort);
void      sort_dir_list (NODE *filelist, const char *sort);
FILEINFO *add_dir_list  (NODE *filelist, const DIRST *dir);
void      free_dir_list (NODE *filelist);
char     *get_curdir    (void);
int       set_curdir    (const char *path);
Bool      file_matches  (const char *filename, const char *pattern);
int       make_dir      (const char *path);
int       remove_dir    (const char *path);
qbyte     dir_usage     (const char *path, Bool recurse);
qbyte     dir_files     (const char *path, Bool recurse);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflslot.h
    Title:      Time-slot functions
    Package:    Standard Function Library (SFL)

    Written:    1996/01/01  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   The time-slot functions provide long-running programs with
                a means to 'switch-on' and 'switch-off' depending on the time
                of day, and day of year.  The intention is that the user can
                configure such programs to be active only between certain
                hours, on certain days, etc.  The time-slot functions work
                with 'range' bitmaps for a day (in seconds) and a year (in
                days), and provide functions to set, clear, and test these
                ranges.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLSLOT_INCLUDED               /*  Allow multiple inclusions        */
#define SFLSLOT_INCLUDED

#define MAX_DAY          366            /*  Max. days in a normal year       */
#define MAX_MIN         1440            /*  Max. minutes in a normal day     */
typedef byte year_range [46];           /*  366 bits (1 per day)             */
typedef byte day_range  [180];          /*  1440 bits (1 per minute)         */

#ifdef __cplusplus
extern "C" {
#endif

void  year_range_empty      (byte *range);
void  year_range_fill       (byte *range);
int   year_slot_set         (byte *range, int day_from, int day_to);
int   year_slot_clear       (byte *range, int day_from, int day_to);
Bool  year_slot_filled      (const byte *range, int day);

void  day_range_empty       (byte *range);
void  day_range_fill        (byte *range);
int   day_slot_set          (byte *range, int min_from, int min_to);
int   day_slot_clear        (byte *range, int min_from, int min_to);
Bool  day_slot_filled       (const byte *range, int minute);

int   date_to_day           (long date);
int   time_to_min           (long time);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflstr.h
    Title:      String-handling functions
    Package:    Standard Function Library (SFL)

    Written:    1992/10/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/06/22

    Synopsis:   Provides various string-handling functions.  Some of these
                functions are available on some but not all platforms; others
                are useful tools for string handling.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLSTR_INCLUDED                /*  Allow multiple inclusions        */
#define SFLSTR_INCLUDED

/*  Macro to prepare call to xstrcpy                                         */
#if (defined (DEBUG))
#  define xstrcpy_debug() { xstrcpy_file = __FILE__; xstrcpy_line = __LINE__;}
#else
#  define xstrcpy_debug()
#endif

extern char *xstrcpy_file;
extern word  xstrcpy_line;

/*  Structure defines simple unsorted lookup table                           */
typedef struct {
    char *key;
    int   value;
} LOOKUP;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char   *strdupl            (const char *string);
char  **strfree            (char **string);
char   *strskp             (const char *string);
char   *strcset            (char *string, char ch);
char   *strpad             (char *string, char ch, int length);
char   *strlwc             (char *string);
char   *strupc             (char *string);
char   *strcrop            (char *string);
char   *stropen            (char *string, Bool align);
char   *strclose           (char *string, Bool align);
char   *strunique          (char *string, char unique);
int     strmatch           (const char *string1, const char *string2);
qbyte   strhash            (const char *string);
Bool    strprefixed        (const char *string, const char *prefix);
char   *strprefix          (const char *string, const char *delims);
char   *strdefix           (const char *string, const char *prefix);
char   *strconvch          (char *string, char from, char to);
char   *xstrcat            (char *dest, const char *src, ...);
char   *xstrcpy            (char *dest, const char *src, ...);
int     lexcmp             (const char *string1, const char *string2);
int     lexncmp            (const char *string1, const char *string2,
                            const int count);
int     lexwcmp            (const char *string1, const char *string2);
char   *soundex            (const char *string);
char   *soundexn           (const char *string, int size, Bool fold);
DESCR  *strt2descr         (char **strings);
char  **descr2strt         (const DESCR *descr);
void    strtfree           (char **strings);
int     strcntch           (const char *string, char value);
int     strlookup          (const LOOKUP *lookup, const char *key);
char   *strreformat        (const char *source, size_t width, const char *prefix);

char   *removechars        (char *str, char *chrs);
char   *replacechrswith    (char *str, char *chrs, char ctorlcwth);
char   *insertstring       (char *str, char *chrstoins, int pos);
char   *insertchar         (char *str, char chrtoins, int pos);
char   *leftfill           (char *str, char chrtofill, unsigned len);
char   *rightfill          (char *str, char chrtofill, unsigned len);
char   *trim               (char *strin);
char   *ltrim              (char *string);
char   *searchreplace      (char *str, char *strtofnd, char *strtoins);
char   *deletestring       (char *str, char *strtodel, int ignorecase);
char   *getstrfld          (char *str, int fln, int ofset,
                            char *sep, char *ret);
char   *setstrfld          (char *str, int fln, int ofset,
                            char *sep, char *ins);
int     getstrfldlen       (char *str, int fln, int ofset, char *sep);
char   *findstrinfile      (FILE *fp, char *find, char *retstr, int *iLnNo);
char   *getequval          (char *strline, char *strretstr);
int     matchtable         (char *str, char *strmatch,
                            char *strsept, int ncse);
char   *stringreplace      (char *strbuf, char *strpattern);
char   *wordwrapstr        (char *strbuff, int iwid);
char   *stricstr           (const char *str1, const char *str2);
int     strtempcmp         (const char *str1, const char *strPat);
int     istoken            (char **strLine, const char *strtoken,
                            int *iWasToken);
int     isoneoftokens      (char **str, char *strmat,
                            char *strsep, int *iWasTk);
char   *eatstr             (char **strBuff, char *strToEat);
char   *eatstrpast         (char **strBuff, char *strCharsToEatPast);
char   *movestrpast        (char **strBuff, char cCharToEatPast);
char   *eatchar            (char **strBuff, char cChar);

#ifdef __cplusplus
}
#endif

/*  Macros & defines                                                         */
#define IGNORECASE 0
#define SENSECASE  1

#define mstrncpy(dest,src,len) {strncpy(dest,src,len);*(dest+len)='\0';}
#define cstrcpy(dest,src) {*dest=src;*(dest+1)='\0';}
#define deletechar(strbuf,pos) strcpy((strbuf+pos),(strbuf+pos+1))
#define deletechars(strbuf,pos,cnt) strcpy((strbuf+pos),(strbuf+pos+cnt))
#define getcommandlinearg(argnum) ((argnum)<=(argc-1))?argv[argnum]:""
#define numofcmdargs() ((argc-1)>0?argc-1:0)
#define checkargcnt(reqnum) ((argc-1)>=(reqnum)?1:0)

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflsock.h
    Title:      TCP/IP, UDP/IP socket functions
    Package:    Standard Function Library (SFL)

    Written:    1996/02/03  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/09/20

    Synopsis:   Provides functions to create, read, and write TCP and UDP
                sockets.  Encapsulates system dependencies.  Tested under
                MS Winsock, UNIX (Linux, AIX, SunOs), OpenVMS.  Some of the
                code in this module was based on the book "Internetworking
                With TCP/IP Volume III: Client-Server Programming And
                Applications BSD Socket Version" by Douglas E. Comer and
                David L. Stevens, published 1993 by Prentice-Hall Inc.
                ISBN 0-13-020272-X.  Defines sock_t which you should use
                for all sockets.  If you need to call a native socket
                function, use a (SOCKET) cast on the sock_t handle.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLSOCK_INCLUDED               /*  Allow multiple inclusions        */
#define SFLSOCK_INCLUDED


/*---------------------------------------------------------------------------
 *  Non-portable definitions - currently for Winsocks
 *  winsock.h is included in the prelude.h file.
 */

#if (defined (__WINDOWS__))
#   define sockerrno     winsock_last_error ()
#   undef INVALID_SOCKET                /*  MSVC defines it in winsock.h     */
#   if (defined (WIN32) && defined (_MSC_VER))
#       pragma comment (lib, "wsock32")
#   endif
#else
#   define sockerrno     errno          /*  Use sockerrno for error number   */
#   define SOCKET_ERROR  -1             /*  Error on socket function         */
    typedef int SOCKET;                 /*  Use (SOCKET) for system calls    */
#endif


/*---------------------------------------------------------------------------
 *  Standard TCP/IP constants
 */

#define DNS_PORT         53             /*  Domain Name server port          */


/*---------------------------------------------------------------------------
 *  Define the socket type 'sock_t' and various types and constants.
 */

typedef qbyte sock_t;                   /*  Use sock_t for all sockets       */

/*  Argument sizes are "int", on most systems, even though negative values
 *  do not make sense.  GNU libc 2 (aka Linux libc6) changed argument sizes
 *  to be "socklen_t", ie unsigned int, at least as of GNU libc 2.0.7.
 *  OpenVMS Dec C defines these as "unsigned int".
 */

#if (defined (__GLIBC__) && (__GLIBC__ > 1))
typedef socklen_t  argsize_t;           /*  GNU libc: size arg for sock func */

#elif (defined (__VMS__) && !defined (vaxc))
typedef unsigned int argsize_t;         /*  OpenVMS: size arg for sock func  */

#else
typedef int argsize_t;                  /*  Traditional: size for sock func  */
#endif

#define INVALID_SOCKET   (sock_t) -1    /*  Invalid socket handle            */
#define SOCKET_LOOPBACK  0x7f000001L    /*  Loopback address 127.0.0.1       */


/*---------------------------------------------------------------------------
 *  Fake socket definitions
 *
 *  If the system does not support sockets, we'll fake it so that the code
 *  still works.  Under crippleware OS's this will work so that all devices
 *  are always ready for I/O.  Most of this code is adapted from the Linux
 *  time.h file.  We also define some useful structures.
 */

#if (!defined (DOES_SOCKETS) && !defined(XENON))
#   define INADDR_ANY       0

    /*  If FAKE_SOCKETS is set, sflsock will fake basic socket i/o           */
#   define FAKE_SOCKETS     1

    /*  Number of descriptors that can fit in an `fd_set'.                   */
#   define FD_SETSIZE       256

    /*  It's easier to assume 8-bit bytes than to get CHAR_BIT.              */
#   define NFDBITS          (sizeof (unsigned long int) * 8)
#   define __FDELT(d)       ((d) / NFDBITS)
#   define __FDMASK(d)      (1 << ((d) % NFDBITS))
#   if (!defined (__DJGPP__))
#   define FD_ZERO(set)     ((void) memset((void *) (set), 0, sizeof(fd_set)))
#   define FD_SET(d,set)    ((set)->__bits[__FDELT(d)] |=  __FDMASK(d))
#   define FD_CLR(d,set)    ((set)->__bits[__FDELT(d)] &= ~__FDMASK(d))
#   define FD_ISSET(d,set)  ((set)->__bits[__FDELT(d)] &   __FDMASK(d))
#   endif

    /*  Fake a select() function that just returns 1                         */
#   define select(n,rf,wf,xf,t)         1

    /*  Fake the inet conversion functions                                   */
#   define inet_addr(x)     1
#   define inet_ntoa(x)     "127.0.0.1"

#if (!defined (__DJGPP__))
    /*  Define the fd_set structure for select()                             */
    typedef struct {
        qbyte __bits [(FD_SETSIZE + (NFDBITS - 1)) / NFDBITS];
    } fd_set;

    /*  Define the timeval structure for select()                            */
    struct timeval {
        long  tv_sec;                   /*  Seconds                          */
        long  tv_usec;                  /*  Microseconds                     */
    };
#endif

    /*  Define the generic socket address structure                          */
    struct sockaddr {
        dbyte sa_family;                /*  Type of address                  */
        char  sa_data [14];             /*  Value of address (filename)      */
    };

    /*  Define the internet socket address structure                         */
    struct in_addr {
        qbyte s_addr;
    };
    struct sockaddr_in {
        dbyte          sin_family;      /*  Type of address                  */
        dbyte          sin_port;        /*  Protocol port number             */
        struct in_addr sin_addr;        /*  IP address                       */
        char           sin_zero [8];    /*  Unused - should be zero          */
    };
#   define AF_INET          0

    /*  Define net-to-host conversion macros                                 */
#   if (defined (__MSDOS__) && !defined (__DJGPP__))
#       define ntohs(x) (((x) & 0xff00U) >> 8) +                             \
                        (((x) & 0x00ffU) << 8)
#       define ntohl(x) (((x) & 0xff000000UL) >> 24) +                       \
                        (((x) & 0x00ff0000UL) >> 8 ) +                       \
                        (((x) & 0x0000ff00UL) << 8 ) +                       \
                        (((x) & 0x000000ffUL) << 24)
#       define htons(x) ntohs(x)
#       define htonl(x) ntohl(x)
#   else
#       define ntohs(x) (x)
#       define ntohl(x) (x)
#       define htons(x) (x)
#       define htonl(x) (x)
#   endif                               /*  msdos                            */
#endif                                  /*  Define fake sockets              */


/*---------------------------------------------------------------------------
 *  Definitions for DJGPP and other compilers which don't have net support
 *  in their header libraries. Expand as required.
 */

#if (defined (__DJGPP__) || defined (__VMS__) || defined (__UTYPE_BEOS))
struct protoent {                       /*  Protocol entry                   */
    char  *p_name;
    char **p_aliases;
    int    p_proto;
};
struct protoent *getprotobynumber (int);
struct protoent *getprotobyname   (const char *);
struct servent  *getservbyport    (int, const char *);
#endif
#if (defined (__DJGPP__))
struct servent {                        /*  Server entry                     */
    char  *s_name;
    char **s_aliases;
    int    s_port;
    char  *s_proto;
};
#endif

/*---------------------------------------------------------------------------
 *  Required definitions
 *
 *  These are symbols used by calling programs: if the compiler does not
 *  define them, we do it.
 */

#if (!defined (EWOULDBLOCK))            /*  BSD tends to use EWOULDBLOCK     */
#   if (defined (__WINDOWS__))
#       define EWOULDBLOCK  WSAEWOULDBLOCK
#   else
#       define EWOULDBLOCK  -1
#   endif
#endif

#if (!defined (EINPROGRESS))            /*  Return code for asynch I/O       */
#   if (defined (__WINDOWS__))
#       define EINPROGRESS  WSAEINPROGRESS
#   else
#       define EINPROGRESS  EWOULDBLOCK
#   endif
#endif

#if (!defined (EAGAIN))                 /*  Return code for asynch I/O       */
#   define EAGAIN           EWOULDBLOCK
#endif

#if (!defined (EPIPE))                  /*  Return code for closed socket    */
#   define EPIPE            -1
#endif

#if (!defined (ECONNRESET))             /*  Return code for closed socket    */
#   if (defined (__WINDOWS__))
#       define ECONNRESET   WSAECONNRESET
#   else
#       define ECONNRESET   EPIPE
#   endif
#endif

#if (defined (__UTYPE_HPUX))
#   define FD_SETTYPE (int *)           /*  Some systems use the older       */
#else                                   /*    select() format                */
#   define FD_SETTYPE                   /*  Most use fd_set's                */
#endif

#if (!defined (MAXHOSTNAMELEN))         /*  Some guys don't define this      */
#   define MAXHOSTNAMELEN   256         /*    constant                       */
#endif
#if (!defined (INADDR_NONE))            /*  Some guys don't define this      */
#   define INADDR_NONE      -1          /*    constant                       */
#endif


/*---------------------------------------------------------------------------
 *  Error values returned by connect_error(). These reflect the last problem
 *  detected by one of the passive/connect connection functions.
 */

#define IP_NOERROR          0           /*  No errors                        */
#define IP_NOSOCKETS        1           /*  Sockets not supported            */
#define IP_BADHOST          2           /*  Host not known                   */
#define IP_BADSERVICE       3           /*  Service or port not known        */
#define IP_BADPROTOCOL      4           /*  Invalid protocol specified       */
#define IP_SOCKETERROR      5           /*  Error creating socket            */
#define IP_CONNECTERROR     6           /*  Error making connection          */
#define IP_BINDERROR        7           /*  Error binding socket             */
#define IP_LISTENERROR      8           /*  Error preparing to listen        */


/*---------------------------------------------------------------------------
 *  The ip_portbase is added to the port number when creating a service;
 *  you can set this variable before calling passive_TCP or passive_UDP.
 */

extern int
    ip_portbase;

/*---------------------------------------------------------------------------
 *  The ip_nonblock flag determines whether sockets are blocking or not.
 *  Under Windows sockets are never blocking.  Under UNIX they may be, or
 *  not.  For portability to Windows, this flag is set to TRUE by default.
 *  The main consequence of this is that after a connect_xxx() call you may
 *  need to perform a select() on the socket for writing to determine when
 *  the connection has suceeded.
 */

extern Bool
    ip_nonblock;

/*---------------------------------------------------------------------------
 *  The connect_errlist table provides messages for the connect_error()
 *  values.
 */

extern char
    *connect_errlist [];

/*---------------------------------------------------------------------------
 *  The ip_passive address is used for passive socket connections.  Initially
 *  this is set to INADDR_ANY.  It is used for one passive socket creation
 *  and reset to INADDR_ANY thereafter.
 */

extern qbyte
    ip_passive;

extern int
    ip_sockets;                         /*  Number of open sockets           */


/*---------------------------------------------------------------------------
 *  Function prototypes
 */

#ifdef __cplusplus
extern "C" {
#endif

int    sock_init            (void);
int    sock_term            (void);
sock_t passive_TCP          (const char *service, int queue);
sock_t passive_UDP          (const char *service);
sock_t passive_socket       (const char *service, const char *protocol,
                             int queue);
sock_t connect_TCP          (const char *host, const char *service);
sock_t connect_UDP          (const char *host, const char *service);
sock_t connect_TCP_fast     (const struct sockaddr_in *sin);
sock_t connect_UDP_fast     (const struct sockaddr_in *sin);
sock_t connect_socket       (const char *host, const char *service, const char
                             *protocol, const struct sockaddr_in *sin,
                             int retry_max, int retry_delay);
int    connect_to_peer      (sock_t handle,
                             const struct sockaddr_in *sin);
int    connect_error        (void);
sock_t accept_socket        (sock_t master);
sock_t create_socket        (const char *protocol);
int    address_end_point    (const char *host, const char *service, const
                             char *protocol, struct sockaddr_in *sin);
int    get_sock_addr        (sock_t handle, struct sockaddr_in *sin,
                             char *name, int namesize);
int    get_peer_addr        (sock_t handle, struct sockaddr_in *sin,
                             char *name, int namesize);
void   build_sockaddr       (struct sockaddr_in *sin, qbyte host, dbyte port);
char  *socket_localaddr     (sock_t handle);
char  *socket_peeraddr      (sock_t handle);
Bool   socket_is_alive      (sock_t handle);
int    socket_error         (sock_t handle);
int    socket_nodelay       (sock_t handle);
int    read_TCP             (sock_t handle, void *buffer, size_t length);
int    write_TCP            (sock_t handle, const void *buffer, size_t length);
int    read_UDP             (sock_t handle, void *buffer, size_t length,
                             const struct sockaddr_in *sin);
int    write_UDP            (sock_t handle, const void *buffer, size_t length,
                             const struct sockaddr_in *sin);
int    close_socket         (sock_t handle);
#if !defined(MINPSPW) && !defined(PS3)
int    sock_select          (int nfds, fd_set *readfds, fd_set *writefds,
                             fd_set *errorfds, struct timeval *timeout);
#endif
char  *get_hostname         (void);
qbyte  get_hostaddr         (void);
qbyte *get_hostaddrs        (void);
const  char *sockmsg        (void);
Bool   socket_is_permitted  (const char *address, const char *mask);
char  *sock_ntoa            (qbyte address);
char  *get_host_file        (void);
int    get_name_server      (struct sockaddr_in *ns_address, int ns_max);

#if (defined (__WINDOWS__))
int    winsock_last_error   (void);
#endif

#ifdef __cplusplus
}
#endif

/*  Macros for compatibility with previous versions                          */
#define socket_hostaddr(handle) socket_peeraddr (handle)


#endif                                  /*  Include sflsock.h                */
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflsymb.h
    Title:      Symbol-table functions
    Package:    Standard Function Library (SFL)

    Written:    1993/12/27  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/08/07

    Synopsis:   Symbol lookup is by name.  Symbols contain a string value
                and a pointer to an caller-defined memory block.

                The symbol-table functions let you create and manage symbol
                tables.  The functions are designed to be as general as
                possible (to support a wide variety of applications), but at
                the same time fast.  The symbol table data structure is based
                on a combined linked list & hash table representation.  The
                file sflsymb.h contains definitions for the various structures
                and external functions used in the sflsymb.c.  Both the
                linked-list and hash-table representations have a guaranteed
                order.  In the linked-list, new symbols are pushed on to the
                head of the list.  In the hash table each bucket just contains
                a pointer to a linked-list of symbols.  When a new symbol is
                created, it is pushed onto the front of this list.  The reason
                that both data structures are used is to make the algorithm
                faster.  Each representation has its stengths and weaknesses.
                For instance, if you wanted to lookup a symbol table entry
                for a given name using the hash table you could find it
                immediately, whereas with the linked-list, you would need to
                traverse most of the table to find the symbol.  Some of these
                functions are called through macros that add the filename and
                line number of the call, for tracing.  Do NOT call these
                functions directly.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLSYMB_INCLUDED                /*  Allow multiple inclusions        */
#define SFLSYMB_INCLUDED


/*  Structure of a symbol                                                    */

typedef struct _SYMBOL {
    struct _SYMBOL
         *next,                         /*  Next symbol in table             */
         *prev,                         /*  Previous symbol in table         */
         *h_next,                       /*  Next symbol in bucket            */
         *h_prev;                       /*  Previous symbol in bucket        */
    char *name;                         /*  Copy of name                     */
    char *value;                        /*  String value, or null            */
    void *data;                         /*  Caller data, or null             */
    byte  hash;                         /*  Hash bucket #                    */
} SYMBOL;

#define SYM_HASH_SIZE   256             /*  Assumed by sym_hash ()           */


/*  Structure of a symbol table                                              */

typedef struct {
    SYMBOL *symbols;                    /*  Pointer to list of symbols       */
    SYMBOL *hash [SYM_HASH_SIZE];       /*  Table of hash buckets            */
    int     size;                       /*  Number of symbols defined        */
} SYMTAB;


/*  Function that handles a symbol                                           */

typedef Bool (*symfunc) (SYMBOL *, ...);


/*  Function to compare two symbols, for sorting                             */

typedef int (*symsort) (const void *symb1, const void *symb2);


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

SYMTAB *sym_create_table_  (const char *source_file, size_t source_line);
void    sym_delete_table   (SYMTAB *symtab);
void    sym_empty_table    (SYMTAB *symtab);
int     sym_merge_tables   (SYMTAB *symtab, const SYMTAB *import);
SYMBOL *sym_lookup_symbol  (const SYMTAB *symtab, const char *name);
SYMBOL *sym_create_symbol_ (SYMTAB *symtab, const char *name, const char *val,
                            const char *source_file, size_t source_line);
SYMBOL *sym_assume_symbol_ (SYMTAB *symtab, const char *name, const char *val,
                            const char *source_file, size_t source_line);
SYMBOL *sym_delete_symbol  (SYMTAB *symtab, SYMBOL *symbol);
const char *sym_get_name   (const SYMBOL *sym);
char   *sym_get_value      (const SYMTAB *symtab, const char *name,
                            const char *default_value);
long    sym_get_number     (const SYMTAB *symtab, const char *key,
                            const long default_value);
Bool    sym_get_boolean    (const SYMTAB *symtab, const char *key,
                            const Bool default_value);
void    sym_set_value      (SYMBOL *symbol, const char *value);
int     sym_exec_all       (const SYMTAB *symtab, symfunc handler, ...);
int     sym_hash           (const char *name);
void    sym_sort_table     (SYMTAB *symtab, symsort sort_function);
char  **symb2strt_         (const SYMTAB *symtab,
                            const char *source_file, size_t source_line);
SYMTAB *strt2symb_         (char **strings,
                            const char *source_file, size_t source_line);
DESCR  *symb2descr_        (const SYMTAB *symtab,
                            const char *source_file, size_t source_line);
SYMTAB *descr2symb_        (const DESCR *descr,
                            const char *source_file, size_t source_line);


#ifdef __cplusplus
}
#endif


/*- Define macros to encapsulate calls to the hidden functions --------------*/

#if (defined (DEBUG))
# define sym_create_table()       sym_create_table_  (__FILE__, __LINE__)
# define sym_create_symbol(t,n,v) sym_create_symbol_ ((t), (n), (v), \
                                                      __FILE__, __LINE__)
# define sym_assume_symbol(t,n,v) sym_assume_symbol_ ((t), (n), (v), \
                                                      __FILE__, __LINE__)
# define symb2strt(t)  symb2strt_  ((t), __FILE__, __LINE__)
# define strt2symb(s)  strt2symb_  ((s), __FILE__, __LINE__)
# define symb2descr(t) symb2descr_ ((t), __FILE__, __LINE__)
# define descr2symb(d) descr2symb_ ((d), __FILE__, __LINE__)

#else
# define sym_create_table()       sym_create_table_  (NULL, 0)
# define sym_create_symbol(t,n,v) sym_create_symbol_ ((t), (n), (v), NULL, 0)
# define sym_assume_symbol(t,n,v) sym_assume_symbol_ ((t), (n), (v), NULL, 0)
# define symb2strt(t)  symb2strt_  ((t), NULL, 0)
# define strt2symb(s)  strt2symb_  ((s), NULL, 0)
# define symb2descr(t) symb2descr_ ((t), NULL, 0)
# define descr2symb(d) descr2symb_ ((d), NULL, 0)
#endif

#endif                                  /*  Include SFLSYMB.H                */
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflproc.h
    Title:      Process control functions
    Package:    Standard Function Library (SFL)

    Written:    1996/09/09  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/10/17

    Synopsis:   Provides functions to create and manage processes.  The main
                set of functions lets you create, monitor, and end processes.
                A secondary function lets you run the current process as a
                background process.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLPROC_INCLUDED                /*  Allow multiple inclusions        */
#define SFLPROC_INCLUDED

/*  Type definitions                                                         */

#if (defined (WIN32))
typedef struct {
    HANDLE process;
    DESCR *envd;                        /*  Environment data                 */
} PROC_HANDLE;
typedef PROC_HANDLE *PROCESS;           /*  Process ID type                  */
#define NULL_PROCESS NULL               /*    and null process               */

#elif (defined (__VMS__))
typedef struct {
    long id;
    long status;
} PROC_HANDLE;
typedef PROC_HANDLE *PROCESS;           /*  Process ID type                  */
#define NULL_PROCESS NULL               /*    and null process               */

#else
typedef pid_t        PROCESS;           /*  Process ID type                  */
#   define NULL_PROCESS 0               /*    and null process               */
#endif

#define NULL_HANDLE  -2                 /*  File handle set to nothing       */

/*  Process creation data structure -- contains all the information needed   */
/*  to create a new process, including I/O redirection, changing directories */
/*  changing UID/GID.  The uid/gid values are applicable only to unix.       */
/*  The rootdir option does a chroot() under unix, and a _chdir() under DOS, */
/*  Windows, and OS/2 (which will also change drive).                        */
/*                                                                           */
/*  The macro PROCESS_DATA_INIT can be used to initialised this struct       */
/*  at variable declaration time.                                            */

typedef struct {
    /*  Program name and arguments ----------------------------------------- */
    /*  The filename string can contain arguments (which will be parsed)     */
    /*  if argv == NULL.  If argv != NULL filename will not be parsed for    */
    /*  arguments.                                                           */
    /*  The searchext field is relevant only to DOS-like systems, and lists  */
    /*  extensions to try adding to the file to find it.  The default is     */
    /*  operating system specific, covering standard executable extensions.  */
    const char *filename;
          char **argv;
    const char *path;                   /*  Override PATH, if not null       */
    const char *shell;                  /*  Override default shell, if ! null*/
    const char **searchext;             /*  Extensions to try, to find file  */
    Bool       searchpath;              /*  Look in path for filename        */
    Bool       useshell;                /*  Invoked via shell                */
    Bool       createdaemon;            /*  Create daemon process (detached) */
    Bool       wait;                    /*  Wait for process to finish       */
    int        delay;                   /*  ms to wait to see if exec worked */

    /*  Directories to change to ------------------------------------------- */
    const char *rootdir;                /*  Dir to chroot() to, if not NULL  */
    const char *workdir;                /*  Work dir; done after any chroot()*/

    /*  I/O Redirection ---------------------------------------------------- */
    /*  A handle of NULL_HANDLE means "no change".                           */
    /*  no_hanldes specifies the number of handles that should be inherited  */
    /*  by the child process, where this can be controlled (eg under unix,   */
    /*  where handles above that number will be marked to close on exec())   */
    int in;
    int out;
    int err;
    int no_handles;                     /*  File handles inherited; default 3*/


    /*  Environment -------------------------------------------------------- */
    /*  Default is to inherit the current environment, without change.  This */
    /*  can either be replaced entirely by supplying envv != NULL, or things */
    /*  can be added/removed from the current environment to get a new one.  */
    char   **envv;                      /*  Whole replacement environment    */
    SYMTAB *envadd;                     /*  Entries to add to environment    */
    SYMTAB *envrm;                      /*  Keys to remove from environment  */

    /*  Security ----------------------------------------------------------- */
    /*  If user name and group are not null, tries to run the process under  */
    /*  the specified user name.  Under Windows, the group name is the name  */
    /*  of the domain.  The password field is needed if the calling process  */
    /*  does not run as a priviliged process.                                */
    char  *username;
    char  *groupname;
    char  *password;
    Bool   preserveroot;                /*  Retain root privileges?          */

    /*  Output ------------------------------------------------------------- */
    /*  This section contains elements set by process_create_full().         */
    PROCESS  pid;
    int   returncode;                   /*  Return code from process         */
    int   error;                        /*  Error code from functionc call   */
} PROCESS_DATA;

/*  Macros:
 *  FILEHANDLE_MAX      Maximum possible number of open files
 *  PROCESS_DATA_INIT   Process data structure (empty) initialisation
 */

/*  getdtablesize () is not available on all systems                         */
#if (defined (__UNIX__))
#   if (defined (__UTYPE_UNIXWARE))
#       define FILEHANDLE_MAX   sysconf (_SC_OPEN_MAX)
#   elif (defined (__UTYPE_HPUX))
#       define FILEHANDLE_MAX   FD_SETSIZE
#   elif (defined (__UTYPE_SINIX))
#       define FILEHANDLE_MAX   FD_SETSIZE
#   else
#       define FILEHANDLE_MAX   getdtablesize ()
#   endif
#elif (defined (FD_SETSIZE))
#   define FILEHANDLE_MAX       FD_SETSIZE
#else
#   define FILEHANDLE_MAX       32      /*  Arbitrary                        */
#endif

/*  Usage: PROCESS_DATA myproc = PROCESS_DATA_INIT;                          */
#define PROCESS_DATA_INIT  {\
      /*  Filename, args,   */  NULL, NULL, NULL, NULL, NULL,            \
      /*    flags           */  FALSE, FALSE, FALSE, FALSE, 1000,        \
      /*  Directories       */  NULL, NULL,                              \
      /*  I/O redirection   */  NULL_HANDLE, NULL_HANDLE, NULL_HANDLE, 3,\
      /*  Environment       */  NULL, NULL, NULL,                        \
      /*  Security          */  NULL, NULL, NULL, FALSE,                 \
      /*  Output            */  NULL_PROCESS, 0, 0                       \
    }


/*  Global variables                                                         */

extern int  process_errno;              /*  Last process exit code           */
extern Bool process_compatible;         /*  Try to be compatible             */
extern const char **sfl_default_ext;    /*  Default extensions               */

#ifdef __cplusplus
extern "C" {
#endif

PROCESS process_create_full (PROCESS_DATA *procinfo);
PROCESS process_create      (const char *file, char *argv [], const char *dir,
                             const char *in, const char *out, const char *err,
                             char *envv [], Bool wait);
int     process_setinfo     (PROCESS_DATA *procinfo, const char *in,
                             const char *out, Bool scratch_out,
                             const char *err, Bool scratch_err);
int     process_open_io     (const char *filename, char access_type);
void    process_close_io    (PROCESS_DATA *procinfo);
int     process_status      (PROCESS process_id);
int     process_kill        (PROCESS process_id);
void    process_close       (PROCESS process_id);
int     process_server      (const char *workdir, const char *lockfile,
                             int argc, char *argv [], const char *sswitch []);
Bool    process_alarm       (long delay);
char   *process_esc         (char *dest, const char *src);
char   *process_unesc       (char *dest, const char *src);
int     process_priority    (int priority);

#ifdef __cplusplus
}
#endif

/*  Return values from process_status()                                      */

#define PROCESS_RUNNING         0
#define PROCESS_ENDED_OK        1
#define PROCESS_ENDED_ERROR     2
#define PROCESS_INTERRUPTED     3

/*  Values for process_priority()                                            */

#define PRIORITY_LOW            0
#define PRIORITY_NORMAL         1
#define PRIORITY_HIGH           2

/*  Is process_create_full() implemented?                                    */
#if (defined (__UNIX__) || defined (__OS2__) || defined (WIN32))
#   define DOES_FULL_PROCESS
#else
#   undef  DOES_FULL_PROCESS
#endif


#endif


/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflprint.h
    Title:      Printing Functions
    Package:    Standard Function Library (SFL)

    Written:    1999/09/10  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/09/10

    Synopsis:   Provides printing functions which may be absent on some
                systems.   In particular ensures that the system has 
		snprintf()/vsnprintf() functions which can be called.  The
                functions supplied here are not as good as the vender 
		supplied ones, but are better than having none at all.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLPRINT_INCLUDED               /*  Allow multiple inclusions        */
#define SFLPRINT_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

#if (! defined (DOES_SNPRINTF))
int snprintf  (char *str, size_t n, const char *format, ...);
int vsnprintf (char *str, size_t n, const char *format, va_list ap);
#endif

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflsyst.h
    Title:      System-level functions (assertions,...)
    Package:    Standard Function Library (SFL)

    Written:    1997/04/13  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/10/05

    Synopsis:   Provides miscellaneous system-level functions.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLSYST_INCLUDED               /*  Allow multiple inclusions        */
#define SFLSYST_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char *sys_name (Bool full);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflhttp.h
    Title:      HTTP and CGI Support functions
    Package:    Standard Function Library (SFL)

    Written:    1996/05/31  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/06/16

    Synopsis:   Provides various functions that support HTTP and CGI
                programming, including escaping/unescaping, and CGI data
                manipulation.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLHTTP_INCLUDED               /*  Allow multiple inclusions        */
#define SFLHTTP_INCLUDED

/*  Macro's and defines                                                      */

/* Macro to free up the input line that GetCgiInput created. */
#define cgi_free_input(strBuf) free((strBuf))

/* Defines for input methods. */
#define CGIGET   0
#define CGIPOST  1
#define CGIETHER 2

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char   *http_escape           (const char *string, char *result, size_t outmax);
char   *http_escape_hex       (const char *string, char *result, size_t outmax);
size_t  http_escape_size      (const char *string);
char   *http_unescape         (char *string, char *result);
char   *http_unescape_hex     (char *string, char *result);
char  **http_query2strt       (const char *query);
SYMTAB *http_query2symb       (const char *query);
DESCR  *http_query2descr      (const char *query);
size_t  http_encode_meta      (char  *output, char **input,
                               size_t outmax, Bool html);
size_t  encode_meta_char      (char  *output, char meta_char,
                               size_t outmax, Bool html);
size_t  http_decode_meta      (char  *output, char **input, size_t outmax);
char    decode_meta_charn     (const char *meta_char, size_t length);
int     cgi_parse_query_vars  (SYMTAB *symtab, const char *query,
                               const char *prefix);
int     cgi_parse_file_vars   (SYMTAB *symtab, FILE *file, const char *prefix,
                               size_t size);
DESCR  *http_multipart_decode (const char *mime_file, const char *store_path,
                               const char *local_format);
Bool    is_full_url           (const char *string);
char   *build_full_url        (const char *uri, const char *base_uri);
char   *http_time_str         (void);
char   *cgi_get_input         (int iMethod);
char   *cgi_fld_by_name       (char *strFld, char *strIn, char *strRetBuf);
char   *cgi_fld_by_index      (int iPos, char *strIn, char *strRetBuf,
                               char *strFldName);
int     cgi_fld_len_by_index  (int iPos, char *strIn, int *iDataLen,
                               int *iNameLen);
int     displayform           (char *strformfile, char *strvalues);

#ifdef __cplusplus
}
#endif

#define decode_meta_char(string) decode_meta_charn (string, sizeof (string))

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflini.h
    Title:      Initialisation file access functions
    Package:    Standard Function Library (SFL)

    Written:    1994/01/08  iMatix SFL project team <sfl@imatix.com>
    Revised:    1999/10/26

    Synopsis:   Provides functions to read an initialisation file that follows
                the MS-Windows style, i.e. consists of [Sections] followed by
                keyword = value lines.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SLFINI_INCLUDED                /*  Allow multiple inclusions        */
#define SLFINI_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

Bool    ini_find_section  (FILE *inifile, char *section, Bool top);
Bool    ini_scan_section  (FILE *inifile, char **keyword, char **value);
SYMTAB *ini_dyn_load      (SYMTAB *symtab, const char *filename);
SYMTAB *ini_dyn_loade     (SYMTAB *symtab, const char *filename);
int     ini_dyn_save      (SYMTAB *symtab, const char *filename);
Bool    ini_dyn_changed   (SYMTAB *symtab);
Bool    ini_dyn_refresh   (SYMTAB *symtab);
char   *ini_dyn_value     (SYMTAB *symtab, const char *section,
                           const char *keyword, const char *default_value);
char  **ini_dyn_values    (SYMTAB *symtab, const char *section,
                           const char *keyword, const char *default_value);
char   *ini_dyn_assume    (SYMTAB *symtab, const char *section,
                           const char *keyword, const char *default_value);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflenv.h
    Title:      Environment variable functions
    Package:    Standard Function Library (SFL)

    Written:    1996/05/14  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/10/22

    Synopsis:   Provides functions to read environment variables (also called
                shell variables or logical variables.)  Provides translation
                into numeric and Boolean values.  Provides functions to work
                with the environment block.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef _SFLENV_INCLUDED                /*  Allow multiple inclusions        */
#define _SFLENV_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char    *env_get_string   (const char *name, const char *default_value);
long     env_get_number   (const char *name, long default_value);
Bool     env_get_boolean  (const char *name, Bool default_value);
DESCR   *env2descr        (void);
char   **descr2env        (const DESCR *descr);
SYMTAB  *env2symb         (void);
char   **symb2env         (const SYMTAB *symtab);
char   **env_copy         (char **environment);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfltok.h
    Title:      String token manipulation functions.
    Package:    Standard Function Library (SFL)

    Written:    1996/09/10  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/03/31

    Synopsis:   Provides functions to break strings into tokens and handle
                symbol substitution in strings.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLTOK_INCLUDED                /*  Allow multiple inclusions        */
#define SFLTOK_INCLUDED


/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char **tok_split      (const char *string);
char **tok_split_rich (const char *string, const char *delims);
void   tok_free       (char **token_list);
char **tok_push       (char **token_list, const char *string);
int    tok_size       (char **token_list);
size_t tok_text_size  (char **token_list);
char  *tok_subst      (const char *string, SYMTAB *symbols);

#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfltree.h
    Title:      Linked-list functions
    Package:    Standard Function Library (SFL)

    Written:    1997/11/18  Jonathan Schultz <jonathan@imatix.com>
    Revised:    1998/01/03  Jonathan Schultz <jonathan@imatix.com>

    Synopsis:   Provides functions to maintain 'Red-Black' balanced binary
                trees.  You can use these functions to work with trees of any
                structure.  To make this work, all structures must start with
                the following: "void *left, *right, *parent; TREE_COLOUR
                colour;".  All trees need a pointer to the root of type TREE
                which should be initialised with tree_init - you can test
                whether a tree is empty by comparing its root with TREE_NULL.
                The order of nodes in the tree is determined by calling a
                node comparison function provided by the caller - this
                accepts two node pointers  and returns zero if the two nodes
                are equal, -1 if the first is smaller and 1 if the first is
                larger.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLTREE_INCLUDED               /*  Allow multiple inclusions        */
#define SFLTREE_INCLUDED


/* Red-Black tree description */

typedef enum {BLACK, RED} TREE_COLOUR;

/*  Node descriptor                                                          */

typedef struct _TREE {
    struct _TREE
        *left, *right, *parent;
    TREE_COLOUR
         colour;
} TREE;

/*  The tree algorithm needs to know how to sort the data.  It does this     */
/*  using a functions provided by the calling program.                       */

typedef int (TREE_COMPARE) (void *t1, void *t2);

/*  Define a function type for use with the tree traversal function          */

typedef void (TREE_PROCESS) (void *t);

/*  Global variables                                                         */

extern TREE
    TREE_EMPTY;

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

void  tree_init     (TREE **root);
int   tree_insert   (TREE **root, void *tree, TREE_COMPARE *comp,
                     Bool allow_duplicates);
void  tree_delete   (TREE **root, void *tree);
void *tree_find_eq  (TREE **root, void *tree, TREE_COMPARE *comp);
void *tree_find_lt  (TREE **root, void *tree, TREE_COMPARE *comp);
void *tree_find_le  (TREE **root, void *tree, TREE_COMPARE *comp);
void *tree_find_gt  (TREE **root, void *tree, TREE_COMPARE *comp);
void *tree_find_ge  (TREE **root, void *tree, TREE_COMPARE *comp);
void  tree_traverse (void *tree, TREE_PROCESS *process, int method);
void *tree_next     (void *tree);
void *tree_prev     (void *tree);
void *tree_first    (void *tree);
void *tree_last     (void *tree);

#ifdef __cplusplus
}
#endif

/*  Return codes                                                             */

#define TREE_DUPLICATE -1
#define TREE_OK         0

/*  Macros                                                                   */

#define TREE_NULL &TREE_EMPTY

#endif

/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfltron.h
    Title:      Tracing functions
    Package:    Standard Function Library (SFL)

    Written:    1992/10/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    1997/09/08

    Synopsis:   Provides functions for a programmer who needs to insert
                long-term tracing code in software.  The tracing code is
                activated and disactivated at run-time, for instance when
                problems are suspected.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLTRON_INCLUDED               /*  Allow multiple inclusions        */
#define SFLTRON_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

void  enable_trace        (void);
void  disable_trace       (void);
void  push_trace          (Bool new_state);
void  pop_trace           (void);
void  set_trace_file      (const char *filename, char mode);
void  trace               (const char *format, ...);

#ifdef __cplusplus
}
#endif


/*  External variables                                                       */

extern Bool  TraceState;                /*  TRUE or FALSE                    */
extern FILE *TraceFile;                 /*  Current trace output file        */

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sfluid.h
    Title:      Process user id (uid) and group id (gid) functions
    Package:    Standard Function Library (SFL)

    Written:    1996/05/03  iMatix SFL project team <sfl@imatix.com>
    Revised:    1998/09/04

    Synopsis:   Provides functions to access user and group id names and
                manage the current real/effective uid's and gid's for a
                process.  These functions are only meaningful on UNIX
                systems, and partially on VMS systems, but may be used by
                portable programs that must operate under UNIX as well as
                other environments.  Some uid functions are non-portable
                between UNIX systems; this package provides a single API.
                Changes for OS/2 were done by Ewen McNeill <ewen@naos.co.nz>.

    Copyright:  Copyright (c) 1996-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SFLUID_INCLUDED                /*  Allow multiple inclusions        */
#define SFLUID_INCLUDED

/*  Function prototypes                                                      */

#ifdef __cplusplus
extern "C" {
#endif

char *get_uid_name  (uid_t uid);
char *get_gid_name  (gid_t gid);
int   set_uid_user  (void);
int   set_uid_root  (void);
int   set_gid_user  (void);
int   set_gid_root  (void);
int   set_uid_gid   (char *new_uid, char *new_gid);
char *get_login     (void);


#ifdef __cplusplus
}
#endif

#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflxml.h
    Title:      XML (Extensible Markup Language) access functions
    Package:    Standard Function Library (SFL)

    Written:    1998/02/25  iMatix SFL project team <sfl@imatix.com>
    Revised:    2000/01/16

    Synopsis:   Provides functions to read and write XML files, and manipulate
                XML data in memory as list structures.  XML is the Extensible
                Markup Language.  Accepts this XML syntax:
                <item [attr=["]value["]]...>value [child]</item>

    Copyright:  Copyright (c) 1991-99 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SLFXML_INCLUDED                /*  Allow multiple inclusions        */
#define SLFXML_INCLUDED

/* -------------------------------------------------------------------------
    An XML tree is built as the following recursive structure:

                   .---------.    .----------.
                 .-:  Attr   :<-->:   0..n   :  Attributes are not sorted.
    .----------. : :  Head   :    :   attrs  :
    :   Item   :-' `---------'    `----------'
    :   node   :-. .---------.    .----------.
    `----------' : :  Child/ :<-->:   0..n   :  Each child node is the root
                 `-:  Value  :    : children :  of its own tree of nodes.
                   `---------'    `----------'
   ------------------------------------------------------------------------- */


/*- Structure definitions -------------------------------------------------- */

typedef struct _XML_ITEM XML_ITEM;
typedef struct _XML_ATTR XML_ATTR;


/*- Function prototypes ---------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/*  XML item functions */
XML_ITEM *xml_new          (XML_ITEM *parent,
                            const char *name,
                            const char *value);

XML_ITEM *xml_create       (const char *name,
                            const char *value);
void      xml_modify_value (XML_ITEM *item,
                            const char *value);
void      xml_rename       (XML_ITEM *item,
                            const char *name);
char     *xml_item_name    (XML_ITEM *item);
char     *xml_item_value   (XML_ITEM *item);
void      xml_free         (XML_ITEM *item);

/*  XML tree manipulation  */
void      xml_attach_child   (XML_ITEM *parent,  XML_ITEM *item);
void      xml_attach_sibling (XML_ITEM *sibling, XML_ITEM *item);
void      xml_detach         (XML_ITEM *item);

/*  XML family navigation  */
XML_ITEM *xml_first_child  (XML_ITEM *item);
XML_ITEM *xml_last_child   (XML_ITEM *item);
XML_ITEM *xml_next_sibling (XML_ITEM *item);
XML_ITEM *xml_prev_sibling (XML_ITEM *item);
XML_ITEM *xml_parent       (XML_ITEM *item);

/*  XML attribute functions  */
int       xml_put_attr_ic  (XML_ITEM   *item,
                            const char *name,
                            const char *value,
                            Bool        ignore_case);
XML_ATTR *xml_attr_ic      (XML_ITEM   *item, 
                            const char *name,
                            Bool        ignore_case);
char     *xml_attr_name    (XML_ATTR   *item);
char     *xml_attr_value   (XML_ATTR   *item);
char     *xml_get_attr_ic  (XML_ITEM   *item,
                            const char *name,
                            const char *deflt,
                            Bool        ignore_case);
void      xml_free_attr    (XML_ATTR   *attr);

#define  xml_put_attr(item, name, value)                                      \
         xml_put_attr_ic (item, name, value, FALSE)
#define  xml_attr(item, name)                                                 \
         xml_attr_ic (item, name, FALSE)
#define  xml_get_attr(item, name, dflt)                                       \
         xml_get_attr_ic (item, name, dflt, FALSE)

/*  XML attribute navigation  */
XML_ATTR *xml_first_attr   (XML_ITEM *item);
XML_ATTR *xml_last_attr    (XML_ITEM *item);
XML_ATTR *xml_next_attr    (XML_ATTR *attr);
XML_ATTR *xml_prev_attr    (XML_ATTR *attr);

/*  XML housekeeping functions  */
Bool     xml_changed       (XML_ITEM *item);
Bool     xml_refresh       (XML_ITEM **item);


/*  Macros to treat all children and all attributes                          */

#define FORCHILDREN(child,item)    for (child  = xml_first_child (item);      \
                                        child != NULL;                        \
                                        child  = xml_next_sibling (child))    \
                                       if (xml_item_name (child))

#define FORVALUES(child,item)      for (child  = xml_first_child (item);      \
                                        child != NULL;                        \
                                        child  = xml_next_sibling (child))    \
                                       if (!xml_item_name (child))

#define FORATTRIBUTES(attr,item)   for (attr  = xml_first_attr (item);        \
                                        attr != NULL;                         \
                                        attr  = xml_next_attr (attr))


#ifdef __cplusplus
}
#endif


#endif
/*  ----------------------------------------------------------------<Prolog>-
    Name:       sflxmll.h
    Title:      XML serialisation functions
    Package:    Standard Function Library (SFL)

    Written:    1996/06/08  iMatix SFL project team <sfl@imatix.com>
    Revised:    2000/01/21

    Synopsis:   Provides functions to load and save XML files.  An XML file
                is held in memory as a tree of nodes, of type XML_ITEM.  The
                XML functions do not currently accept DTDs in the XML data.

    Copyright:  Copyright (c) 1991-2000 iMatix Corporation
    License:    This is free software; you can redistribute it and/or modify
                it under the terms of the SFL License Agreement as provided
                in the file LICENSE.TXT.  This software is distributed in
                the hope that it will be useful, but without any warranty.
 ------------------------------------------------------------------</Prolog>-*/

#ifndef SLFXMLL_INCLUDED               /*  Allow multiple inclusions        */
#define SLFXMLL_INCLUDED

/*- Function prototypes ---------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/*  Error values  */

#define XML_NOERROR         0           /*  No errors                        */
#define XML_FILEERROR       1           /*  Error in file i/o                */
#define XML_LOADERROR       2           /*  Error loading XML                */

/*  Function prototypes  */

int       xml_save_file      (XML_ITEM   *item, const char *filename);
char     *xml_save_string    (XML_ITEM   *item);
char     *xml_error          (void);
int       xml_seems_to_be    (const char *path,
                              const char *filename);
int       xml_load_file      (XML_ITEM   **item,
                              const char *path,
                              const char *filename,
                              Bool  allow_extended);
int       xml_load_string    (XML_ITEM   **item,
                              const char *xmlstring,
                              Bool  allow_extended);

/*  Macros  */

#define xml_load_extended(item, path, filename)                               \
    xml_load_file (item, path, filename, TRUE)
#define xml_load(item, path, filename)                                        \
    xml_load_file (item, path, filename, FALSE)


#ifdef __cplusplus
}
#endif

#endif                                  /*  Included                         */
