/*
 *	gettimeofday.cpp
 */

#ifdef WIN32

#include "gettimeofday.h"
#include <cstddef>
#include <windows.h>

#if defined(_MSC_VER) || defined(_MSC_EXTENSIONS)
	#define DELTA_EPOCH_IN_MICROSECS 11644473600000000Ui64
#else
	#define DELTA_EPOCH_IN_MICROSECS 11644473600000000ULL
#endif

int gettimeofday( struct timeval *tv, struct timezone *tz )
{
	FILETIME ft;
	unsigned __int64 tmpres = 0;
	static int tzflag = 0;
	
	if( NULL != tv )
	{
		GetSystemTimeAsFileTime(&ft);
		
		tmpres |= ft.dwHighDateTime;
		tmpres <<= 32;
		tmpres |= ft.dwLowDateTime;
		
		tmpres /= 10;  // convert into microseconds
		
		// converting file time to unix epoch
		tmpres -= DELTA_EPOCH_IN_MICROSECS; 
		tv->tv_sec = (long)(tmpres / 1000000UL);
		tv->tv_usec = (long)(tmpres % 1000000UL);
	}
	
	if (NULL != tz)
	{
		if (!tzflag)
		{
			_tzset();
			tzflag++;
		}
		tz->tz_minuteswest = _timezone / 60;
		tz->tz_dsttime = _daylight;
	}
	
	return 0;
}

#endif
