# Changelog
All notable changes to this project will be documented in this file.

This project adheres to [Semantic Versioning](http://semver.org/).

## [Unreleased]
### Added
### Changed
### Deprecated
### Removed
### Fixed
### Security

## [0.9.11] - 2021-06-07
### Changed
- app.config fixes.

## [0.9.10] - 2021-05-31
### Changed
- Added an audit rule to log login attempts.

## [0.9.9] - 2020-12-14
### Changed
- Set LimitNOFILE=1048576 in the guam.service file
- Log readable messages and avoid crashes on known reasons for client connections to break.
### Fixed
- Fixed a StartTLS regression

## [0.9.8] - 2020-10-26
### Fixed
- Fixed performance regression with literals containing CRLFs.
- Avoid buffering entire literal continuations

## [0.9.7] - 2020-04-15
### Fixed
- Fixed processing of multiple commands arriving in the same packet.
- Enable keepalive on incoming socket
- Enabled full IMAP traffic logging on debug log level

## [0.9.6] - 2020-03-31
### Fixed
- use iolist_to_binary to fix attachment downloading with K9-Mail

## [0.9.5] - 2019-11-18
### Added
- Support for LIST-STATUS and LIST-EXTENDED LIST responses
### Fixed
- Client buffer handling via guam-0.9.2-stalling-client-buffer-and-split-command-handling patch

## [0.9.4] - 2018-02-19
### Fixed
- Support empty lines from the client

## [0.9.3] - 2017-05-03
### Fixed
- With a properly crafted folder list, clients could receive empty lines
  in filtered folder listings

## [0.9.2] - 2017-03-21
### Fixed
- Fix client message processing when there are no active rules

## [0.9.1] - 2016-02-20
### Fixed
- Improve SSL connection accepts (prevent timing errors on the socket)
- Support fragmentary messages from clients (e.g. tag in one packet, cmd in another)

## [0.9.0] - 2016-07-29
### Added
- bind to a network interface (rather than an IP/host) with net_iface

### Changed
- handle the implicit ssl upgrade a bit more manually, allowing faster
  replenish of the listener pool and simplifying socket setup code
- upgraded build to rebar3
- Upgraded eimap to 0.3.0

### Fixed
- fix CAPABILITY response (was CAPABILITIES)

## [0.8.3] - 2016-08-08
### Fixed
- always close ssl sockets as an ssl socket
- keep listen_socket separate from socket
- not required to make the socket active to accept connections
- ensure eimap processes are always terminated in all cases

## [0.8.2] - 2016-07-08
### Added
- listener_pool_size configuration option for listeners
### Changed
- Default size of listener pool drops to 10 from 20
- Rate limit (by introducing a short wait) connection accept()s
### Fixed
- Prevent starvation of the session pool due to clients dropping connections
  pre-accept()

## [0.8.1] - 2016-07-06
### Added
- ipv6 connections
### Changed
- update to eimap 0.2.5
### Fixed
- Ignore non-listing LIST commands (e.g. requests for the root/separator)
- Tidy up the server greetings

## [0.8.0] - 2016-06-08
### Added
- systemd service module
- sysv init script
### Changed
- Upgraded eimap to 0.2.4
### Fixed
- Support more variations of the LIST command args in the filter_groupware rule

