#-------------------------------------------------
#
# Project created by QtCreator 2017-02-16T22:41:52
#
#-------------------------------------------------

QT       += core gui

# this kind of conflicts with a later option
greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

TARGET = barcoder
TEMPLATE = app

VERSION_MAJOR = 1
VERSION_MINOR = 1
VERSION_BUILD = 1

DEFINES += "VERSION_MAJOR=$$VERSION_MAJOR"\
       "VERSION_MINOR=$$VERSION_MINOR"\
       "VERSION_BUILD=$$VERSION_BUILD"

#Target version
VERSION = "$${VERSION_MAJOR}.$${VERSION_MINOR}.$${VERSION_BUILD}"

DEFINES +=  VERSION_S='\\"$${VERSION}\\"'

DEFINES += QT_DEPRECATED_WARNINGS
DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x050000

INCLUDEPATH += 3rdparty/qqrencode
LIBS += -lqrencode -ldmtx


SOURCES += main.cpp\
        mainwindow.cpp\
        3rdparty/qqrencode/qqrencode.cpp

HEADERS  += mainwindow.h

FORMS    += mainwindow.ui

unix {
    #VARIABLES
    isEmpty(PREFIX) {
        PREFIX = /usr #QT_INSTALL_PREFIX
    }
    BINDIR = $$PREFIX/bin
    DATADIR =$$PREFIX/share

    DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

    # MAKE tarball
    tarball.commands = git archive --prefix $${TARGET}_$${VERSION}/ -o $${TARGET}_$${VERSION}.orig.tar.gz HEAD . \":(exclude)debian\" \":(exclude)data\"
    tarball.path = .


    # MAKE zip
    zip.commands = git archive --prefix $${TARGET}_$${VERSION}/ -o $${TARGET}_$${VERSION}.orig.zip HEAD . \":(exclude)debian\" \":(exclude)data\"
    zip.path = .


    mangz.commands = gzip -c -9 docs/$${TARGET}.1 > docs/$${TARGET}.1.gz
    mangz.files = docs/*.1
    mangz.path = $$DATADIR/man/man1

    man.depends = mangz
    man.path = $$DATADIR/man/man1
    man.files = docs/*.?.gz

    # i don't provide command for icon but something like convert barcoder.xcf barcoder-256.png
    icon.path = $$DATADIR/icons/hicolor/128x128/apps/
    icon.files = $$PWD/$${TARGET}.png

    desktop.depends = icon
    desktop.path = $$DATADIR/applications/
    desktop.files = $$PWD/$${TARGET}.desktop


    QMAKE_CLEAN += $$PWD/*zip $$PWD/*.tar.gz $$PWD/*.deb


    QMAKE_EXTRA_TARGETS += tarball zip deb man mangz desktop icon


    #MAKE INSTALL

    INSTALLS += target mangz man desktop icon

    target.path = $$BINDIR


    deb.target = deb
    deb.path = .
    deb.depends = debian/control
    deb.commands = dpkg-buildpackage -uc -us


}

DISTFILES += docs/*gz \
    $${TARGET}.desktop \
    $${TARGET}.png






