#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QProcess>
#include <QClipboard>
#include "qqrencode.h"
#include <dmtx.h>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    // tricky: don't need to use settings  object because no actual settings exist
    this->setWindowTitle(this->windowTitle()+" "+VERSION_S);
    this->setWindowFlags(Qt::WindowStaysOnTopHint);

    // the text that I want encoded
    const QString inp = QApplication::arguments().value(-1, QGuiApplication::clipboard()->text());

    // DATAMATRIX STUFF START
    int err = 0;
    int len = inp.length();

    // segfault for text longer than this. so dont bother
    if (len > 1595) {
        //    err = 1596;
    } else {
        DmtxEncode *im = dmtxEncodeCreate();
        /* Read input data into buffer */
        err = dmtxEncodeDataMatrix(im, len, (unsigned char*)inp.toLocal8Bit().data());
        QImage dmatrix(im->image->pxl, im->image->width, im->image->height, QImage::Format_RGB888);
        ui->label->setPixmap(QPixmap::fromImage(dmatrix).scaled(240,240));
        dmtxEncodeDestroy(&im);
    }
    // DATAMATRIX STUFF END


    // QRCODE STUFF START
    QQREncode encoder;
    encoder.encode(inp, true);
    QImage qrcode = encoder.toQImage().scaled(240,240);
    ui->label_2->setPixmap(QPixmap::fromImage(qrcode));
    // QRCODE STUFF END

    // COMPENSATE FOR DMATRIX FAILURE USING INVERTED QRCODE START
    if (err == 0) {
        qrcode.invertPixels();
        ui->label->setPixmap(QPixmap::fromImage(qrcode));
    }
    // COMPENSATE FOR DMATRIX FAILURE USING INVERTED QRCODE END


    this->updateGeometry();
}

void MainWindow::mousePressEvent ( QMouseEvent * event )
{
    Q_UNUSED(event);
    QApplication::quit();
}

MainWindow::~MainWindow()
{
    delete ui;
}
